# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'AliasContextResponse',
    'ArtifactHashesResponse',
    'ArtifactResponse',
    'ArtifactRuleResponse',
    'AttestationResponse',
    'AuthorityResponse',
    'BasisResponse',
    'BindingResponse',
    'BuildProvenanceResponse',
    'BuildResponse',
    'BuildSignatureResponse',
    'ByProductsResponse',
    'CVSSv3Response',
    'CloudRepoSourceContextResponse',
    'CommandResponse',
    'DeployableResponse',
    'DeploymentResponse',
    'DerivedResponse',
    'DetailResponse',
    'DetailsResponse',
    'DiscoveredResponse',
    'DiscoveryResponse',
    'DistributionResponse',
    'DocumentNoteResponse',
    'DocumentOccurrenceResponse',
    'EnvironmentResponse',
    'ExprResponse',
    'ExternalRefResponse',
    'FileNoteResponse',
    'FileOccurrenceResponse',
    'FingerprintResponse',
    'GenericSignedAttestationResponse',
    'GerritSourceContextResponse',
    'GitSourceContextResponse',
    'GrafeasV1beta1BuildDetailsResponse',
    'GrafeasV1beta1DeploymentDetailsResponse',
    'GrafeasV1beta1DiscoveryDetailsResponse',
    'GrafeasV1beta1ImageDetailsResponse',
    'GrafeasV1beta1IntotoArtifactResponse',
    'GrafeasV1beta1IntotoDetailsResponse',
    'GrafeasV1beta1IntotoSignatureResponse',
    'GrafeasV1beta1PackageDetailsResponse',
    'GrafeasV1beta1VulnerabilityDetailsResponse',
    'HintResponse',
    'InTotoResponse',
    'InstallationResponse',
    'KnowledgeBaseResponse',
    'LayerResponse',
    'LicenseResponse',
    'LinkResponse',
    'LocationResponse',
    'PackageInfoNoteResponse',
    'PackageInfoOccurrenceResponse',
    'PackageIssueResponse',
    'PackageResponse',
    'PgpSignedAttestationResponse',
    'ProjectRepoIdResponse',
    'RelatedUrlResponse',
    'RelationshipNoteResponse',
    'RelationshipOccurrenceResponse',
    'RepoIdResponse',
    'ResourceResponse',
    'SignatureResponse',
    'SigningKeyResponse',
    'SourceContextResponse',
    'SourceResponse',
    'StatusResponse',
    'VersionResponse',
    'VulnerabilityLocationResponse',
    'VulnerabilityResponse',
    'WindowsDetailResponse',
]

@pulumi.output_type
class AliasContextResponse(dict):
    """
    An alias to a repo revision.
    """
    def __init__(__self__, *,
                 kind: str,
                 name: str):
        """
        An alias to a repo revision.
        :param str kind: The alias kind.
        :param str name: The alias name.
        """
        pulumi.set(__self__, "kind", kind)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def kind(self) -> str:
        """
        The alias kind.
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The alias name.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class ArtifactHashesResponse(dict):
    """
    Defines a hash object for use in Materials and Products.
    """
    def __init__(__self__, *,
                 sha256: str):
        """
        Defines a hash object for use in Materials and Products.
        """
        pulumi.set(__self__, "sha256", sha256)

    @property
    @pulumi.getter
    def sha256(self) -> str:
        return pulumi.get(self, "sha256")


@pulumi.output_type
class ArtifactResponse(dict):
    """
    Artifact describes a build product.
    """
    def __init__(__self__, *,
                 checksum: str,
                 names: Sequence[str]):
        """
        Artifact describes a build product.
        :param str checksum: Hash or checksum value of a binary, or Docker Registry 2.0 digest of a container.
        :param Sequence[str] names: Related artifact names. This may be the path to a binary or jar file, or in the case of a container build, the name used to push the container image to Google Container Registry, as presented to `docker push`. Note that a single Artifact ID can have multiple names, for example if two tags are applied to one image.
        """
        pulumi.set(__self__, "checksum", checksum)
        pulumi.set(__self__, "names", names)

    @property
    @pulumi.getter
    def checksum(self) -> str:
        """
        Hash or checksum value of a binary, or Docker Registry 2.0 digest of a container.
        """
        return pulumi.get(self, "checksum")

    @property
    @pulumi.getter
    def names(self) -> Sequence[str]:
        """
        Related artifact names. This may be the path to a binary or jar file, or in the case of a container build, the name used to push the container image to Google Container Registry, as presented to `docker push`. Note that a single Artifact ID can have multiple names, for example if two tags are applied to one image.
        """
        return pulumi.get(self, "names")


@pulumi.output_type
class ArtifactRuleResponse(dict):
    """
    Defines an object to declare an in-toto artifact rule
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "artifactRule":
            suggest = "artifact_rule"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ArtifactRuleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ArtifactRuleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ArtifactRuleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 artifact_rule: Sequence[str]):
        """
        Defines an object to declare an in-toto artifact rule
        """
        pulumi.set(__self__, "artifact_rule", artifact_rule)

    @property
    @pulumi.getter(name="artifactRule")
    def artifact_rule(self) -> Sequence[str]:
        return pulumi.get(self, "artifact_rule")


@pulumi.output_type
class AttestationResponse(dict):
    """
    Occurrence that represents a single "attestation". The authenticity of an attestation can be verified using the attached signature. If the verifier trusts the public key of the signer, then verifying the signature is sufficient to establish trust. In this circumstance, the authority to which this attestation is attached is primarily useful for look-up (how to find this attestation if you already know the authority and artifact to be verified) and intent (which authority was this attestation intended to sign for).
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "genericSignedAttestation":
            suggest = "generic_signed_attestation"
        elif key == "pgpSignedAttestation":
            suggest = "pgp_signed_attestation"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AttestationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AttestationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AttestationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 generic_signed_attestation: 'outputs.GenericSignedAttestationResponse',
                 pgp_signed_attestation: 'outputs.PgpSignedAttestationResponse'):
        """
        Occurrence that represents a single "attestation". The authenticity of an attestation can be verified using the attached signature. If the verifier trusts the public key of the signer, then verifying the signature is sufficient to establish trust. In this circumstance, the authority to which this attestation is attached is primarily useful for look-up (how to find this attestation if you already know the authority and artifact to be verified) and intent (which authority was this attestation intended to sign for).
        :param 'PgpSignedAttestationResponse' pgp_signed_attestation: A PGP signed attestation.
        """
        pulumi.set(__self__, "generic_signed_attestation", generic_signed_attestation)
        pulumi.set(__self__, "pgp_signed_attestation", pgp_signed_attestation)

    @property
    @pulumi.getter(name="genericSignedAttestation")
    def generic_signed_attestation(self) -> 'outputs.GenericSignedAttestationResponse':
        return pulumi.get(self, "generic_signed_attestation")

    @property
    @pulumi.getter(name="pgpSignedAttestation")
    def pgp_signed_attestation(self) -> 'outputs.PgpSignedAttestationResponse':
        """
        A PGP signed attestation.
        """
        return pulumi.get(self, "pgp_signed_attestation")


@pulumi.output_type
class AuthorityResponse(dict):
    """
    Note kind that represents a logical attestation "role" or "authority". For example, an organization might have one `Authority` for "QA" and one for "build". This note is intended to act strictly as a grouping mechanism for the attached occurrences (Attestations). This grouping mechanism also provides a security boundary, since IAM ACLs gate the ability for a principle to attach an occurrence to a given note. It also provides a single point of lookup to find all attached attestation occurrences, even if they don't all live in the same project.
    """
    def __init__(__self__, *,
                 hint: 'outputs.HintResponse'):
        """
        Note kind that represents a logical attestation "role" or "authority". For example, an organization might have one `Authority` for "QA" and one for "build". This note is intended to act strictly as a grouping mechanism for the attached occurrences (Attestations). This grouping mechanism also provides a security boundary, since IAM ACLs gate the ability for a principle to attach an occurrence to a given note. It also provides a single point of lookup to find all attached attestation occurrences, even if they don't all live in the same project.
        :param 'HintResponse' hint: Hint hints at the purpose of the attestation authority.
        """
        pulumi.set(__self__, "hint", hint)

    @property
    @pulumi.getter
    def hint(self) -> 'outputs.HintResponse':
        """
        Hint hints at the purpose of the attestation authority.
        """
        return pulumi.get(self, "hint")


@pulumi.output_type
class BasisResponse(dict):
    """
    Basis describes the base image portion (Note) of the DockerImage relationship. Linked occurrences are derived from this or an equivalent image via: FROM Or an equivalent reference, e.g. a tag of the resource_url.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourceUrl":
            suggest = "resource_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BasisResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BasisResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BasisResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 fingerprint: 'outputs.FingerprintResponse',
                 resource_url: str):
        """
        Basis describes the base image portion (Note) of the DockerImage relationship. Linked occurrences are derived from this or an equivalent image via: FROM Or an equivalent reference, e.g. a tag of the resource_url.
        :param 'FingerprintResponse' fingerprint: Immutable. The fingerprint of the base image.
        :param str resource_url: Immutable. The resource_url for the resource representing the basis of associated occurrence images.
        """
        pulumi.set(__self__, "fingerprint", fingerprint)
        pulumi.set(__self__, "resource_url", resource_url)

    @property
    @pulumi.getter
    def fingerprint(self) -> 'outputs.FingerprintResponse':
        """
        Immutable. The fingerprint of the base image.
        """
        return pulumi.get(self, "fingerprint")

    @property
    @pulumi.getter(name="resourceUrl")
    def resource_url(self) -> str:
        """
        Immutable. The resource_url for the resource representing the basis of associated occurrence images.
        """
        return pulumi.get(self, "resource_url")


@pulumi.output_type
class BindingResponse(dict):
    """
    Associates `members`, or principals, with a `role`.
    """
    def __init__(__self__, *,
                 condition: 'outputs.ExprResponse',
                 members: Sequence[str],
                 role: str):
        """
        Associates `members`, or principals, with a `role`.
        :param 'ExprResponse' condition: The condition that is associated with this binding. If the condition evaluates to `true`, then this binding applies to the current request. If the condition evaluates to `false`, then this binding does not apply to the current request. However, a different role binding might grant the same role to one or more of the principals in this binding. To learn which resources support conditions in their IAM policies, see the [IAM documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
        :param Sequence[str] members: Specifies the principals requesting access for a Cloud Platform resource. `members` can have the following values: * `allUsers`: A special identifier that represents anyone who is on the internet; with or without a Google account. * `allAuthenticatedUsers`: A special identifier that represents anyone who is authenticated with a Google account or a service account. * `user:{emailid}`: An email address that represents a specific Google account. For example, `alice@example.com` . * `serviceAccount:{emailid}`: An email address that represents a service account. For example, `my-other-app@appspot.gserviceaccount.com`. * `group:{emailid}`: An email address that represents a Google group. For example, `admins@example.com`. * `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a user that has been recently deleted. For example, `alice@example.com?uid=123456789012345678901`. If the user is recovered, this value reverts to `user:{emailid}` and the recovered user retains the role in the binding. * `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a service account that has been recently deleted. For example, `my-other-app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the service account is undeleted, this value reverts to `serviceAccount:{emailid}` and the undeleted service account retains the role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a Google group that has been recently deleted. For example, `admins@example.com?uid=123456789012345678901`. If the group is recovered, this value reverts to `group:{emailid}` and the recovered group retains the role in the binding. * `domain:{domain}`: The G Suite domain (primary) that represents all the users of that domain. For example, `google.com` or `example.com`. 
        :param str role: Role that is assigned to the list of `members`, or principals. For example, `roles/viewer`, `roles/editor`, or `roles/owner`.
        """
        pulumi.set(__self__, "condition", condition)
        pulumi.set(__self__, "members", members)
        pulumi.set(__self__, "role", role)

    @property
    @pulumi.getter
    def condition(self) -> 'outputs.ExprResponse':
        """
        The condition that is associated with this binding. If the condition evaluates to `true`, then this binding applies to the current request. If the condition evaluates to `false`, then this binding does not apply to the current request. However, a different role binding might grant the same role to one or more of the principals in this binding. To learn which resources support conditions in their IAM policies, see the [IAM documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
        """
        return pulumi.get(self, "condition")

    @property
    @pulumi.getter
    def members(self) -> Sequence[str]:
        """
        Specifies the principals requesting access for a Cloud Platform resource. `members` can have the following values: * `allUsers`: A special identifier that represents anyone who is on the internet; with or without a Google account. * `allAuthenticatedUsers`: A special identifier that represents anyone who is authenticated with a Google account or a service account. * `user:{emailid}`: An email address that represents a specific Google account. For example, `alice@example.com` . * `serviceAccount:{emailid}`: An email address that represents a service account. For example, `my-other-app@appspot.gserviceaccount.com`. * `group:{emailid}`: An email address that represents a Google group. For example, `admins@example.com`. * `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a user that has been recently deleted. For example, `alice@example.com?uid=123456789012345678901`. If the user is recovered, this value reverts to `user:{emailid}` and the recovered user retains the role in the binding. * `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a service account that has been recently deleted. For example, `my-other-app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the service account is undeleted, this value reverts to `serviceAccount:{emailid}` and the undeleted service account retains the role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a Google group that has been recently deleted. For example, `admins@example.com?uid=123456789012345678901`. If the group is recovered, this value reverts to `group:{emailid}` and the recovered group retains the role in the binding. * `domain:{domain}`: The G Suite domain (primary) that represents all the users of that domain. For example, `google.com` or `example.com`. 
        """
        return pulumi.get(self, "members")

    @property
    @pulumi.getter
    def role(self) -> str:
        """
        Role that is assigned to the list of `members`, or principals. For example, `roles/viewer`, `roles/editor`, or `roles/owner`.
        """
        return pulumi.get(self, "role")


@pulumi.output_type
class BuildProvenanceResponse(dict):
    """
    Provenance of a build. Contains all information needed to verify the full details about the build from source to completion.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "buildOptions":
            suggest = "build_options"
        elif key == "builderVersion":
            suggest = "builder_version"
        elif key == "builtArtifacts":
            suggest = "built_artifacts"
        elif key == "createTime":
            suggest = "create_time"
        elif key == "endTime":
            suggest = "end_time"
        elif key == "logsUri":
            suggest = "logs_uri"
        elif key == "sourceProvenance":
            suggest = "source_provenance"
        elif key == "startTime":
            suggest = "start_time"
        elif key == "triggerId":
            suggest = "trigger_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BuildProvenanceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BuildProvenanceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BuildProvenanceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 build_options: Mapping[str, str],
                 builder_version: str,
                 built_artifacts: Sequence['outputs.ArtifactResponse'],
                 commands: Sequence['outputs.CommandResponse'],
                 create_time: str,
                 creator: str,
                 end_time: str,
                 logs_uri: str,
                 project: str,
                 source_provenance: 'outputs.SourceResponse',
                 start_time: str,
                 trigger_id: str):
        """
        Provenance of a build. Contains all information needed to verify the full details about the build from source to completion.
        :param Mapping[str, str] build_options: Special options applied to this build. This is a catch-all field where build providers can enter any desired additional details.
        :param str builder_version: Version string of the builder at the time this build was executed.
        :param Sequence['ArtifactResponse'] built_artifacts: Output of the build.
        :param Sequence['CommandResponse'] commands: Commands requested by the build.
        :param str create_time: Time at which the build was created.
        :param str creator: E-mail address of the user who initiated this build. Note that this was the user's e-mail address at the time the build was initiated; this address may not represent the same end-user for all time.
        :param str end_time: Time at which execution of the build was finished.
        :param str logs_uri: URI where any logs for this provenance were written.
        :param str project: ID of the project.
        :param 'SourceResponse' source_provenance: Details of the Source input to the build.
        :param str start_time: Time at which execution of the build was started.
        :param str trigger_id: Trigger identifier if the build was triggered automatically; empty if not.
        """
        pulumi.set(__self__, "build_options", build_options)
        pulumi.set(__self__, "builder_version", builder_version)
        pulumi.set(__self__, "built_artifacts", built_artifacts)
        pulumi.set(__self__, "commands", commands)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "creator", creator)
        pulumi.set(__self__, "end_time", end_time)
        pulumi.set(__self__, "logs_uri", logs_uri)
        pulumi.set(__self__, "project", project)
        pulumi.set(__self__, "source_provenance", source_provenance)
        pulumi.set(__self__, "start_time", start_time)
        pulumi.set(__self__, "trigger_id", trigger_id)

    @property
    @pulumi.getter(name="buildOptions")
    def build_options(self) -> Mapping[str, str]:
        """
        Special options applied to this build. This is a catch-all field where build providers can enter any desired additional details.
        """
        return pulumi.get(self, "build_options")

    @property
    @pulumi.getter(name="builderVersion")
    def builder_version(self) -> str:
        """
        Version string of the builder at the time this build was executed.
        """
        return pulumi.get(self, "builder_version")

    @property
    @pulumi.getter(name="builtArtifacts")
    def built_artifacts(self) -> Sequence['outputs.ArtifactResponse']:
        """
        Output of the build.
        """
        return pulumi.get(self, "built_artifacts")

    @property
    @pulumi.getter
    def commands(self) -> Sequence['outputs.CommandResponse']:
        """
        Commands requested by the build.
        """
        return pulumi.get(self, "commands")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        Time at which the build was created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def creator(self) -> str:
        """
        E-mail address of the user who initiated this build. Note that this was the user's e-mail address at the time the build was initiated; this address may not represent the same end-user for all time.
        """
        return pulumi.get(self, "creator")

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> str:
        """
        Time at which execution of the build was finished.
        """
        return pulumi.get(self, "end_time")

    @property
    @pulumi.getter(name="logsUri")
    def logs_uri(self) -> str:
        """
        URI where any logs for this provenance were written.
        """
        return pulumi.get(self, "logs_uri")

    @property
    @pulumi.getter
    def project(self) -> str:
        """
        ID of the project.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="sourceProvenance")
    def source_provenance(self) -> 'outputs.SourceResponse':
        """
        Details of the Source input to the build.
        """
        return pulumi.get(self, "source_provenance")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> str:
        """
        Time at which execution of the build was started.
        """
        return pulumi.get(self, "start_time")

    @property
    @pulumi.getter(name="triggerId")
    def trigger_id(self) -> str:
        """
        Trigger identifier if the build was triggered automatically; empty if not.
        """
        return pulumi.get(self, "trigger_id")


@pulumi.output_type
class BuildResponse(dict):
    """
    Note holding the version of the provider's builder and the signature of the provenance message in the build details occurrence.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "builderVersion":
            suggest = "builder_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BuildResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BuildResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BuildResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 builder_version: str,
                 signature: 'outputs.BuildSignatureResponse'):
        """
        Note holding the version of the provider's builder and the signature of the provenance message in the build details occurrence.
        :param str builder_version: Immutable. Version of the builder which produced this build.
        :param 'BuildSignatureResponse' signature: Signature of the build in occurrences pointing to this build note containing build details.
        """
        pulumi.set(__self__, "builder_version", builder_version)
        pulumi.set(__self__, "signature", signature)

    @property
    @pulumi.getter(name="builderVersion")
    def builder_version(self) -> str:
        """
        Immutable. Version of the builder which produced this build.
        """
        return pulumi.get(self, "builder_version")

    @property
    @pulumi.getter
    def signature(self) -> 'outputs.BuildSignatureResponse':
        """
        Signature of the build in occurrences pointing to this build note containing build details.
        """
        return pulumi.get(self, "signature")


@pulumi.output_type
class BuildSignatureResponse(dict):
    """
    Message encapsulating the signature of the verified build.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "keyId":
            suggest = "key_id"
        elif key == "keyType":
            suggest = "key_type"
        elif key == "publicKey":
            suggest = "public_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BuildSignatureResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BuildSignatureResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BuildSignatureResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key_id: str,
                 key_type: str,
                 public_key: str,
                 signature: str):
        """
        Message encapsulating the signature of the verified build.
        :param str key_id: An ID for the key used to sign. This could be either an ID for the key stored in `public_key` (such as the ID or fingerprint for a PGP key, or the CN for a cert), or a reference to an external key (such as a reference to a key in Cloud Key Management Service).
        :param str key_type: The type of the key, either stored in `public_key` or referenced in `key_id`.
        :param str public_key: Public key of the builder which can be used to verify that the related findings are valid and unchanged. If `key_type` is empty, this defaults to PEM encoded public keys. This field may be empty if `key_id` references an external key. For Cloud Build based signatures, this is a PEM encoded public key. To verify the Cloud Build signature, place the contents of this field into a file (public.pem). The signature field is base64-decoded into its binary representation in signature.bin, and the provenance bytes from `BuildDetails` are base64-decoded into a binary representation in signed.bin. OpenSSL can then verify the signature: `openssl sha256 -verify public.pem -signature signature.bin signed.bin`
        :param str signature: Signature of the related `BuildProvenance`. In JSON, this is base-64 encoded.
        """
        pulumi.set(__self__, "key_id", key_id)
        pulumi.set(__self__, "key_type", key_type)
        pulumi.set(__self__, "public_key", public_key)
        pulumi.set(__self__, "signature", signature)

    @property
    @pulumi.getter(name="keyId")
    def key_id(self) -> str:
        """
        An ID for the key used to sign. This could be either an ID for the key stored in `public_key` (such as the ID or fingerprint for a PGP key, or the CN for a cert), or a reference to an external key (such as a reference to a key in Cloud Key Management Service).
        """
        return pulumi.get(self, "key_id")

    @property
    @pulumi.getter(name="keyType")
    def key_type(self) -> str:
        """
        The type of the key, either stored in `public_key` or referenced in `key_id`.
        """
        return pulumi.get(self, "key_type")

    @property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> str:
        """
        Public key of the builder which can be used to verify that the related findings are valid and unchanged. If `key_type` is empty, this defaults to PEM encoded public keys. This field may be empty if `key_id` references an external key. For Cloud Build based signatures, this is a PEM encoded public key. To verify the Cloud Build signature, place the contents of this field into a file (public.pem). The signature field is base64-decoded into its binary representation in signature.bin, and the provenance bytes from `BuildDetails` are base64-decoded into a binary representation in signed.bin. OpenSSL can then verify the signature: `openssl sha256 -verify public.pem -signature signature.bin signed.bin`
        """
        return pulumi.get(self, "public_key")

    @property
    @pulumi.getter
    def signature(self) -> str:
        """
        Signature of the related `BuildProvenance`. In JSON, this is base-64 encoded.
        """
        return pulumi.get(self, "signature")


@pulumi.output_type
class ByProductsResponse(dict):
    """
    Defines an object for the byproducts field in in-toto links. The suggested fields are "stderr", "stdout", and "return-value".
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "customValues":
            suggest = "custom_values"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ByProductsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ByProductsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ByProductsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 custom_values: Mapping[str, str]):
        """
        Defines an object for the byproducts field in in-toto links. The suggested fields are "stderr", "stdout", and "return-value".
        """
        pulumi.set(__self__, "custom_values", custom_values)

    @property
    @pulumi.getter(name="customValues")
    def custom_values(self) -> Mapping[str, str]:
        return pulumi.get(self, "custom_values")


@pulumi.output_type
class CVSSv3Response(dict):
    """
    Common Vulnerability Scoring System version 3. For details, see https://www.first.org/cvss/specification-document
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "attackComplexity":
            suggest = "attack_complexity"
        elif key == "attackVector":
            suggest = "attack_vector"
        elif key == "availabilityImpact":
            suggest = "availability_impact"
        elif key == "baseScore":
            suggest = "base_score"
        elif key == "confidentialityImpact":
            suggest = "confidentiality_impact"
        elif key == "exploitabilityScore":
            suggest = "exploitability_score"
        elif key == "impactScore":
            suggest = "impact_score"
        elif key == "integrityImpact":
            suggest = "integrity_impact"
        elif key == "privilegesRequired":
            suggest = "privileges_required"
        elif key == "userInteraction":
            suggest = "user_interaction"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CVSSv3Response. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CVSSv3Response.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CVSSv3Response.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 attack_complexity: str,
                 attack_vector: str,
                 availability_impact: str,
                 base_score: float,
                 confidentiality_impact: str,
                 exploitability_score: float,
                 impact_score: float,
                 integrity_impact: str,
                 privileges_required: str,
                 scope: str,
                 user_interaction: str):
        """
        Common Vulnerability Scoring System version 3. For details, see https://www.first.org/cvss/specification-document
        :param str attack_vector: Base Metrics Represents the intrinsic characteristics of a vulnerability that are constant over time and across user environments.
        :param float base_score: The base score is a function of the base metric scores.
        """
        pulumi.set(__self__, "attack_complexity", attack_complexity)
        pulumi.set(__self__, "attack_vector", attack_vector)
        pulumi.set(__self__, "availability_impact", availability_impact)
        pulumi.set(__self__, "base_score", base_score)
        pulumi.set(__self__, "confidentiality_impact", confidentiality_impact)
        pulumi.set(__self__, "exploitability_score", exploitability_score)
        pulumi.set(__self__, "impact_score", impact_score)
        pulumi.set(__self__, "integrity_impact", integrity_impact)
        pulumi.set(__self__, "privileges_required", privileges_required)
        pulumi.set(__self__, "scope", scope)
        pulumi.set(__self__, "user_interaction", user_interaction)

    @property
    @pulumi.getter(name="attackComplexity")
    def attack_complexity(self) -> str:
        return pulumi.get(self, "attack_complexity")

    @property
    @pulumi.getter(name="attackVector")
    def attack_vector(self) -> str:
        """
        Base Metrics Represents the intrinsic characteristics of a vulnerability that are constant over time and across user environments.
        """
        return pulumi.get(self, "attack_vector")

    @property
    @pulumi.getter(name="availabilityImpact")
    def availability_impact(self) -> str:
        return pulumi.get(self, "availability_impact")

    @property
    @pulumi.getter(name="baseScore")
    def base_score(self) -> float:
        """
        The base score is a function of the base metric scores.
        """
        return pulumi.get(self, "base_score")

    @property
    @pulumi.getter(name="confidentialityImpact")
    def confidentiality_impact(self) -> str:
        return pulumi.get(self, "confidentiality_impact")

    @property
    @pulumi.getter(name="exploitabilityScore")
    def exploitability_score(self) -> float:
        return pulumi.get(self, "exploitability_score")

    @property
    @pulumi.getter(name="impactScore")
    def impact_score(self) -> float:
        return pulumi.get(self, "impact_score")

    @property
    @pulumi.getter(name="integrityImpact")
    def integrity_impact(self) -> str:
        return pulumi.get(self, "integrity_impact")

    @property
    @pulumi.getter(name="privilegesRequired")
    def privileges_required(self) -> str:
        return pulumi.get(self, "privileges_required")

    @property
    @pulumi.getter
    def scope(self) -> str:
        return pulumi.get(self, "scope")

    @property
    @pulumi.getter(name="userInteraction")
    def user_interaction(self) -> str:
        return pulumi.get(self, "user_interaction")


@pulumi.output_type
class CloudRepoSourceContextResponse(dict):
    """
    A CloudRepoSourceContext denotes a particular revision in a Google Cloud Source Repo.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "aliasContext":
            suggest = "alias_context"
        elif key == "repoId":
            suggest = "repo_id"
        elif key == "revisionId":
            suggest = "revision_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CloudRepoSourceContextResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CloudRepoSourceContextResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CloudRepoSourceContextResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 alias_context: 'outputs.AliasContextResponse',
                 repo_id: 'outputs.RepoIdResponse',
                 revision_id: str):
        """
        A CloudRepoSourceContext denotes a particular revision in a Google Cloud Source Repo.
        :param 'AliasContextResponse' alias_context: An alias, which may be a branch or tag.
        :param 'RepoIdResponse' repo_id: The ID of the repo.
        :param str revision_id: A revision ID.
        """
        pulumi.set(__self__, "alias_context", alias_context)
        pulumi.set(__self__, "repo_id", repo_id)
        pulumi.set(__self__, "revision_id", revision_id)

    @property
    @pulumi.getter(name="aliasContext")
    def alias_context(self) -> 'outputs.AliasContextResponse':
        """
        An alias, which may be a branch or tag.
        """
        return pulumi.get(self, "alias_context")

    @property
    @pulumi.getter(name="repoId")
    def repo_id(self) -> 'outputs.RepoIdResponse':
        """
        The ID of the repo.
        """
        return pulumi.get(self, "repo_id")

    @property
    @pulumi.getter(name="revisionId")
    def revision_id(self) -> str:
        """
        A revision ID.
        """
        return pulumi.get(self, "revision_id")


@pulumi.output_type
class CommandResponse(dict):
    """
    Command describes a step performed as part of the build pipeline.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "waitFor":
            suggest = "wait_for"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CommandResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CommandResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CommandResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 args: Sequence[str],
                 dir: str,
                 env: Sequence[str],
                 name: str,
                 wait_for: Sequence[str]):
        """
        Command describes a step performed as part of the build pipeline.
        :param Sequence[str] args: Command-line arguments used when executing this command.
        :param str dir: Working directory (relative to project source root) used when running this command.
        :param Sequence[str] env: Environment variables set before running this command.
        :param str name: Name of the command, as presented on the command line, or if the command is packaged as a Docker container, as presented to `docker pull`.
        :param Sequence[str] wait_for: The ID(s) of the command(s) that this command depends on.
        """
        pulumi.set(__self__, "args", args)
        pulumi.set(__self__, "dir", dir)
        pulumi.set(__self__, "env", env)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "wait_for", wait_for)

    @property
    @pulumi.getter
    def args(self) -> Sequence[str]:
        """
        Command-line arguments used when executing this command.
        """
        return pulumi.get(self, "args")

    @property
    @pulumi.getter
    def dir(self) -> str:
        """
        Working directory (relative to project source root) used when running this command.
        """
        return pulumi.get(self, "dir")

    @property
    @pulumi.getter
    def env(self) -> Sequence[str]:
        """
        Environment variables set before running this command.
        """
        return pulumi.get(self, "env")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the command, as presented on the command line, or if the command is packaged as a Docker container, as presented to `docker pull`.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="waitFor")
    def wait_for(self) -> Sequence[str]:
        """
        The ID(s) of the command(s) that this command depends on.
        """
        return pulumi.get(self, "wait_for")


@pulumi.output_type
class DeployableResponse(dict):
    """
    An artifact that can be deployed in some runtime.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourceUri":
            suggest = "resource_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeployableResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeployableResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeployableResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 resource_uri: Sequence[str]):
        """
        An artifact that can be deployed in some runtime.
        :param Sequence[str] resource_uri: Resource URI for the artifact being deployed.
        """
        pulumi.set(__self__, "resource_uri", resource_uri)

    @property
    @pulumi.getter(name="resourceUri")
    def resource_uri(self) -> Sequence[str]:
        """
        Resource URI for the artifact being deployed.
        """
        return pulumi.get(self, "resource_uri")


@pulumi.output_type
class DeploymentResponse(dict):
    """
    The period during which some deployable was active in a runtime.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deployTime":
            suggest = "deploy_time"
        elif key == "resourceUri":
            suggest = "resource_uri"
        elif key == "undeployTime":
            suggest = "undeploy_time"
        elif key == "userEmail":
            suggest = "user_email"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeploymentResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeploymentResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeploymentResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 address: str,
                 config: str,
                 deploy_time: str,
                 platform: str,
                 resource_uri: Sequence[str],
                 undeploy_time: str,
                 user_email: str):
        """
        The period during which some deployable was active in a runtime.
        :param str address: Address of the runtime element hosting this deployment.
        :param str config: Configuration used to create this deployment.
        :param str deploy_time: Beginning of the lifetime of this deployment.
        :param str platform: Platform hosting this deployment.
        :param Sequence[str] resource_uri: Resource URI for the artifact being deployed taken from the deployable field with the same name.
        :param str undeploy_time: End of the lifetime of this deployment.
        :param str user_email: Identity of the user that triggered this deployment.
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "config", config)
        pulumi.set(__self__, "deploy_time", deploy_time)
        pulumi.set(__self__, "platform", platform)
        pulumi.set(__self__, "resource_uri", resource_uri)
        pulumi.set(__self__, "undeploy_time", undeploy_time)
        pulumi.set(__self__, "user_email", user_email)

    @property
    @pulumi.getter
    def address(self) -> str:
        """
        Address of the runtime element hosting this deployment.
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter
    def config(self) -> str:
        """
        Configuration used to create this deployment.
        """
        return pulumi.get(self, "config")

    @property
    @pulumi.getter(name="deployTime")
    def deploy_time(self) -> str:
        """
        Beginning of the lifetime of this deployment.
        """
        return pulumi.get(self, "deploy_time")

    @property
    @pulumi.getter
    def platform(self) -> str:
        """
        Platform hosting this deployment.
        """
        return pulumi.get(self, "platform")

    @property
    @pulumi.getter(name="resourceUri")
    def resource_uri(self) -> Sequence[str]:
        """
        Resource URI for the artifact being deployed taken from the deployable field with the same name.
        """
        return pulumi.get(self, "resource_uri")

    @property
    @pulumi.getter(name="undeployTime")
    def undeploy_time(self) -> str:
        """
        End of the lifetime of this deployment.
        """
        return pulumi.get(self, "undeploy_time")

    @property
    @pulumi.getter(name="userEmail")
    def user_email(self) -> str:
        """
        Identity of the user that triggered this deployment.
        """
        return pulumi.get(self, "user_email")


@pulumi.output_type
class DerivedResponse(dict):
    """
    Derived describes the derived image portion (Occurrence) of the DockerImage relationship. This image would be produced from a Dockerfile with FROM .
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "baseResourceUrl":
            suggest = "base_resource_url"
        elif key == "layerInfo":
            suggest = "layer_info"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DerivedResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DerivedResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DerivedResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 base_resource_url: str,
                 distance: int,
                 fingerprint: 'outputs.FingerprintResponse',
                 layer_info: Sequence['outputs.LayerResponse']):
        """
        Derived describes the derived image portion (Occurrence) of the DockerImage relationship. This image would be produced from a Dockerfile with FROM .
        :param str base_resource_url: This contains the base image URL for the derived image occurrence.
        :param int distance: The number of layers by which this image differs from the associated image basis.
        :param 'FingerprintResponse' fingerprint: The fingerprint of the derived image.
        :param Sequence['LayerResponse'] layer_info: This contains layer-specific metadata, if populated it has length "distance" and is ordered with [distance] being the layer immediately following the base image and [1] being the final layer.
        """
        pulumi.set(__self__, "base_resource_url", base_resource_url)
        pulumi.set(__self__, "distance", distance)
        pulumi.set(__self__, "fingerprint", fingerprint)
        pulumi.set(__self__, "layer_info", layer_info)

    @property
    @pulumi.getter(name="baseResourceUrl")
    def base_resource_url(self) -> str:
        """
        This contains the base image URL for the derived image occurrence.
        """
        return pulumi.get(self, "base_resource_url")

    @property
    @pulumi.getter
    def distance(self) -> int:
        """
        The number of layers by which this image differs from the associated image basis.
        """
        return pulumi.get(self, "distance")

    @property
    @pulumi.getter
    def fingerprint(self) -> 'outputs.FingerprintResponse':
        """
        The fingerprint of the derived image.
        """
        return pulumi.get(self, "fingerprint")

    @property
    @pulumi.getter(name="layerInfo")
    def layer_info(self) -> Sequence['outputs.LayerResponse']:
        """
        This contains layer-specific metadata, if populated it has length "distance" and is ordered with [distance] being the layer immediately following the base image and [1] being the final layer.
        """
        return pulumi.get(self, "layer_info")


@pulumi.output_type
class DetailResponse(dict):
    """
    Identifies all appearances of this vulnerability in the package for a specific distro/location. For example: glibc in cpe:/o:debian:debian_linux:8 for versions 2.1 - 2.2
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cpeUri":
            suggest = "cpe_uri"
        elif key == "fixedLocation":
            suggest = "fixed_location"
        elif key == "isObsolete":
            suggest = "is_obsolete"
        elif key == "maxAffectedVersion":
            suggest = "max_affected_version"
        elif key == "minAffectedVersion":
            suggest = "min_affected_version"
        elif key == "packageType":
            suggest = "package_type"
        elif key == "severityName":
            suggest = "severity_name"
        elif key == "sourceUpdateTime":
            suggest = "source_update_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DetailResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DetailResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DetailResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cpe_uri: str,
                 description: str,
                 fixed_location: 'outputs.VulnerabilityLocationResponse',
                 is_obsolete: bool,
                 max_affected_version: 'outputs.VersionResponse',
                 min_affected_version: 'outputs.VersionResponse',
                 package: str,
                 package_type: str,
                 severity_name: str,
                 source: str,
                 source_update_time: str,
                 vendor: str):
        """
        Identifies all appearances of this vulnerability in the package for a specific distro/location. For example: glibc in cpe:/o:debian:debian_linux:8 for versions 2.1 - 2.2
        :param str cpe_uri: The CPE URI in [cpe format](https://cpe.mitre.org/specification/) in which the vulnerability manifests. Examples include distro or storage location for vulnerable jar.
        :param str description: A vendor-specific description of this note.
        :param 'VulnerabilityLocationResponse' fixed_location: The fix for this specific package version.
        :param bool is_obsolete: Whether this detail is obsolete. Occurrences are expected not to point to obsolete details.
        :param 'VersionResponse' max_affected_version: The max version of the package in which the vulnerability exists.
        :param 'VersionResponse' min_affected_version: The min version of the package in which the vulnerability exists.
        :param str package: The name of the package where the vulnerability was found.
        :param str package_type: The type of package; whether native or non native(ruby gems, node.js packages etc).
        :param str severity_name: The severity (eg: distro assigned severity) for this vulnerability.
        :param str source: The source from which the information in this Detail was obtained.
        :param str source_update_time: The time this information was last changed at the source. This is an upstream timestamp from the underlying information source - e.g. Ubuntu security tracker.
        :param str vendor: The name of the vendor of the product.
        """
        pulumi.set(__self__, "cpe_uri", cpe_uri)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "fixed_location", fixed_location)
        pulumi.set(__self__, "is_obsolete", is_obsolete)
        pulumi.set(__self__, "max_affected_version", max_affected_version)
        pulumi.set(__self__, "min_affected_version", min_affected_version)
        pulumi.set(__self__, "package", package)
        pulumi.set(__self__, "package_type", package_type)
        pulumi.set(__self__, "severity_name", severity_name)
        pulumi.set(__self__, "source", source)
        pulumi.set(__self__, "source_update_time", source_update_time)
        pulumi.set(__self__, "vendor", vendor)

    @property
    @pulumi.getter(name="cpeUri")
    def cpe_uri(self) -> str:
        """
        The CPE URI in [cpe format](https://cpe.mitre.org/specification/) in which the vulnerability manifests. Examples include distro or storage location for vulnerable jar.
        """
        return pulumi.get(self, "cpe_uri")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        A vendor-specific description of this note.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="fixedLocation")
    def fixed_location(self) -> 'outputs.VulnerabilityLocationResponse':
        """
        The fix for this specific package version.
        """
        return pulumi.get(self, "fixed_location")

    @property
    @pulumi.getter(name="isObsolete")
    def is_obsolete(self) -> bool:
        """
        Whether this detail is obsolete. Occurrences are expected not to point to obsolete details.
        """
        return pulumi.get(self, "is_obsolete")

    @property
    @pulumi.getter(name="maxAffectedVersion")
    def max_affected_version(self) -> 'outputs.VersionResponse':
        """
        The max version of the package in which the vulnerability exists.
        """
        return pulumi.get(self, "max_affected_version")

    @property
    @pulumi.getter(name="minAffectedVersion")
    def min_affected_version(self) -> 'outputs.VersionResponse':
        """
        The min version of the package in which the vulnerability exists.
        """
        return pulumi.get(self, "min_affected_version")

    @property
    @pulumi.getter
    def package(self) -> str:
        """
        The name of the package where the vulnerability was found.
        """
        return pulumi.get(self, "package")

    @property
    @pulumi.getter(name="packageType")
    def package_type(self) -> str:
        """
        The type of package; whether native or non native(ruby gems, node.js packages etc).
        """
        return pulumi.get(self, "package_type")

    @property
    @pulumi.getter(name="severityName")
    def severity_name(self) -> str:
        """
        The severity (eg: distro assigned severity) for this vulnerability.
        """
        return pulumi.get(self, "severity_name")

    @property
    @pulumi.getter
    def source(self) -> str:
        """
        The source from which the information in this Detail was obtained.
        """
        return pulumi.get(self, "source")

    @property
    @pulumi.getter(name="sourceUpdateTime")
    def source_update_time(self) -> str:
        """
        The time this information was last changed at the source. This is an upstream timestamp from the underlying information source - e.g. Ubuntu security tracker.
        """
        return pulumi.get(self, "source_update_time")

    @property
    @pulumi.getter
    def vendor(self) -> str:
        """
        The name of the vendor of the product.
        """
        return pulumi.get(self, "vendor")


@pulumi.output_type
class DetailsResponse(dict):
    """
    Details of an attestation occurrence.
    """
    def __init__(__self__, *,
                 attestation: 'outputs.AttestationResponse'):
        """
        Details of an attestation occurrence.
        :param 'AttestationResponse' attestation: Attestation for the resource.
        """
        pulumi.set(__self__, "attestation", attestation)

    @property
    @pulumi.getter
    def attestation(self) -> 'outputs.AttestationResponse':
        """
        Attestation for the resource.
        """
        return pulumi.get(self, "attestation")


@pulumi.output_type
class DiscoveredResponse(dict):
    """
    Provides information about the analysis status of a discovered resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "analysisStatus":
            suggest = "analysis_status"
        elif key == "analysisStatusError":
            suggest = "analysis_status_error"
        elif key == "continuousAnalysis":
            suggest = "continuous_analysis"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DiscoveredResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DiscoveredResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DiscoveredResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 analysis_status: str,
                 analysis_status_error: 'outputs.StatusResponse',
                 continuous_analysis: str):
        """
        Provides information about the analysis status of a discovered resource.
        :param str analysis_status: The status of discovery for the resource.
        :param 'StatusResponse' analysis_status_error: When an error is encountered this will contain a LocalizedMessage under details to show to the user. The LocalizedMessage is output only and populated by the API.
        :param str continuous_analysis: Whether the resource is continuously analyzed.
        """
        pulumi.set(__self__, "analysis_status", analysis_status)
        pulumi.set(__self__, "analysis_status_error", analysis_status_error)
        pulumi.set(__self__, "continuous_analysis", continuous_analysis)

    @property
    @pulumi.getter(name="analysisStatus")
    def analysis_status(self) -> str:
        """
        The status of discovery for the resource.
        """
        return pulumi.get(self, "analysis_status")

    @property
    @pulumi.getter(name="analysisStatusError")
    def analysis_status_error(self) -> 'outputs.StatusResponse':
        """
        When an error is encountered this will contain a LocalizedMessage under details to show to the user. The LocalizedMessage is output only and populated by the API.
        """
        return pulumi.get(self, "analysis_status_error")

    @property
    @pulumi.getter(name="continuousAnalysis")
    def continuous_analysis(self) -> str:
        """
        Whether the resource is continuously analyzed.
        """
        return pulumi.get(self, "continuous_analysis")


@pulumi.output_type
class DiscoveryResponse(dict):
    """
    A note that indicates a type of analysis a provider would perform. This note exists in a provider's project. A `Discovery` occurrence is created in a consumer's project at the start of analysis.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "analysisKind":
            suggest = "analysis_kind"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DiscoveryResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DiscoveryResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DiscoveryResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 analysis_kind: str):
        """
        A note that indicates a type of analysis a provider would perform. This note exists in a provider's project. A `Discovery` occurrence is created in a consumer's project at the start of analysis.
        :param str analysis_kind: Immutable. The kind of analysis that is handled by this discovery.
        """
        pulumi.set(__self__, "analysis_kind", analysis_kind)

    @property
    @pulumi.getter(name="analysisKind")
    def analysis_kind(self) -> str:
        """
        Immutable. The kind of analysis that is handled by this discovery.
        """
        return pulumi.get(self, "analysis_kind")


@pulumi.output_type
class DistributionResponse(dict):
    """
    This represents a particular channel of distribution for a given package. E.g., Debian's jessie-backports dpkg mirror.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cpeUri":
            suggest = "cpe_uri"
        elif key == "latestVersion":
            suggest = "latest_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DistributionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DistributionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DistributionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 architecture: str,
                 cpe_uri: str,
                 description: str,
                 latest_version: 'outputs.VersionResponse',
                 maintainer: str,
                 url: str):
        """
        This represents a particular channel of distribution for a given package. E.g., Debian's jessie-backports dpkg mirror.
        :param str architecture: The CPU architecture for which packages in this distribution channel were built.
        :param str cpe_uri: The cpe_uri in [CPE format](https://cpe.mitre.org/specification/) denoting the package manager version distributing a package.
        :param str description: The distribution channel-specific description of this package.
        :param 'VersionResponse' latest_version: The latest available version of this package in this distribution channel.
        :param str maintainer: A freeform string denoting the maintainer of this package.
        :param str url: The distribution channel-specific homepage for this package.
        """
        pulumi.set(__self__, "architecture", architecture)
        pulumi.set(__self__, "cpe_uri", cpe_uri)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "latest_version", latest_version)
        pulumi.set(__self__, "maintainer", maintainer)
        pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter
    def architecture(self) -> str:
        """
        The CPU architecture for which packages in this distribution channel were built.
        """
        return pulumi.get(self, "architecture")

    @property
    @pulumi.getter(name="cpeUri")
    def cpe_uri(self) -> str:
        """
        The cpe_uri in [CPE format](https://cpe.mitre.org/specification/) denoting the package manager version distributing a package.
        """
        return pulumi.get(self, "cpe_uri")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The distribution channel-specific description of this package.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="latestVersion")
    def latest_version(self) -> 'outputs.VersionResponse':
        """
        The latest available version of this package in this distribution channel.
        """
        return pulumi.get(self, "latest_version")

    @property
    @pulumi.getter
    def maintainer(self) -> str:
        """
        A freeform string denoting the maintainer of this package.
        """
        return pulumi.get(self, "maintainer")

    @property
    @pulumi.getter
    def url(self) -> str:
        """
        The distribution channel-specific homepage for this package.
        """
        return pulumi.get(self, "url")


@pulumi.output_type
class DocumentNoteResponse(dict):
    """
    DocumentNote represents an SPDX Document Creation Infromation section: https://spdx.github.io/spdx-spec/2-document-creation-information/
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataLicence":
            suggest = "data_licence"
        elif key == "spdxVersion":
            suggest = "spdx_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DocumentNoteResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DocumentNoteResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DocumentNoteResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 data_licence: str,
                 spdx_version: str):
        """
        DocumentNote represents an SPDX Document Creation Infromation section: https://spdx.github.io/spdx-spec/2-document-creation-information/
        :param str data_licence: Compliance with the SPDX specification includes populating the SPDX fields therein with data related to such fields ("SPDX-Metadata")
        :param str spdx_version: Provide a reference number that can be used to understand how to parse and interpret the rest of the file
        """
        pulumi.set(__self__, "data_licence", data_licence)
        pulumi.set(__self__, "spdx_version", spdx_version)

    @property
    @pulumi.getter(name="dataLicence")
    def data_licence(self) -> str:
        """
        Compliance with the SPDX specification includes populating the SPDX fields therein with data related to such fields ("SPDX-Metadata")
        """
        return pulumi.get(self, "data_licence")

    @property
    @pulumi.getter(name="spdxVersion")
    def spdx_version(self) -> str:
        """
        Provide a reference number that can be used to understand how to parse and interpret the rest of the file
        """
        return pulumi.get(self, "spdx_version")


@pulumi.output_type
class DocumentOccurrenceResponse(dict):
    """
    DocumentOccurrence represents an SPDX Document Creation Information section: https://spdx.github.io/spdx-spec/2-document-creation-information/
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createTime":
            suggest = "create_time"
        elif key == "creatorComment":
            suggest = "creator_comment"
        elif key == "documentComment":
            suggest = "document_comment"
        elif key == "externalDocumentRefs":
            suggest = "external_document_refs"
        elif key == "licenseListVersion":
            suggest = "license_list_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DocumentOccurrenceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DocumentOccurrenceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DocumentOccurrenceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 create_time: str,
                 creator_comment: str,
                 creators: Sequence[str],
                 document_comment: str,
                 external_document_refs: Sequence[str],
                 license_list_version: str,
                 namespace: str,
                 title: str):
        """
        DocumentOccurrence represents an SPDX Document Creation Information section: https://spdx.github.io/spdx-spec/2-document-creation-information/
        :param str create_time: Identify when the SPDX file was originally created. The date is to be specified according to combined date and time in UTC format as specified in ISO 8601 standard
        :param str creator_comment: A field for creators of the SPDX file to provide general comments about the creation of the SPDX file or any other relevant comment not included in the other fields
        :param Sequence[str] creators: Identify who (or what, in the case of a tool) created the SPDX file. If the SPDX file was created by an individual, indicate the person's name
        :param str document_comment: A field for creators of the SPDX file content to provide comments to the consumers of the SPDX document
        :param Sequence[str] external_document_refs: Identify any external SPDX documents referenced within this SPDX document
        :param str license_list_version: A field for creators of the SPDX file to provide the version of the SPDX License List used when the SPDX file was created
        :param str namespace: Provide an SPDX document specific namespace as a unique absolute Uniform Resource Identifier (URI) as specified in RFC-3986, with the exception of the ‘#’ delimiter
        :param str title: Identify name of this document as designated by creator
        """
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "creator_comment", creator_comment)
        pulumi.set(__self__, "creators", creators)
        pulumi.set(__self__, "document_comment", document_comment)
        pulumi.set(__self__, "external_document_refs", external_document_refs)
        pulumi.set(__self__, "license_list_version", license_list_version)
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        Identify when the SPDX file was originally created. The date is to be specified according to combined date and time in UTC format as specified in ISO 8601 standard
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="creatorComment")
    def creator_comment(self) -> str:
        """
        A field for creators of the SPDX file to provide general comments about the creation of the SPDX file or any other relevant comment not included in the other fields
        """
        return pulumi.get(self, "creator_comment")

    @property
    @pulumi.getter
    def creators(self) -> Sequence[str]:
        """
        Identify who (or what, in the case of a tool) created the SPDX file. If the SPDX file was created by an individual, indicate the person's name
        """
        return pulumi.get(self, "creators")

    @property
    @pulumi.getter(name="documentComment")
    def document_comment(self) -> str:
        """
        A field for creators of the SPDX file content to provide comments to the consumers of the SPDX document
        """
        return pulumi.get(self, "document_comment")

    @property
    @pulumi.getter(name="externalDocumentRefs")
    def external_document_refs(self) -> Sequence[str]:
        """
        Identify any external SPDX documents referenced within this SPDX document
        """
        return pulumi.get(self, "external_document_refs")

    @property
    @pulumi.getter(name="licenseListVersion")
    def license_list_version(self) -> str:
        """
        A field for creators of the SPDX file to provide the version of the SPDX License List used when the SPDX file was created
        """
        return pulumi.get(self, "license_list_version")

    @property
    @pulumi.getter
    def namespace(self) -> str:
        """
        Provide an SPDX document specific namespace as a unique absolute Uniform Resource Identifier (URI) as specified in RFC-3986, with the exception of the ‘#’ delimiter
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter
    def title(self) -> str:
        """
        Identify name of this document as designated by creator
        """
        return pulumi.get(self, "title")


@pulumi.output_type
class EnvironmentResponse(dict):
    """
    Defines an object for the environment field in in-toto links. The suggested fields are "variables", "filesystem", and "workdir".
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "customValues":
            suggest = "custom_values"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EnvironmentResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EnvironmentResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EnvironmentResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 custom_values: Mapping[str, str]):
        """
        Defines an object for the environment field in in-toto links. The suggested fields are "variables", "filesystem", and "workdir".
        """
        pulumi.set(__self__, "custom_values", custom_values)

    @property
    @pulumi.getter(name="customValues")
    def custom_values(self) -> Mapping[str, str]:
        return pulumi.get(self, "custom_values")


@pulumi.output_type
class ExprResponse(dict):
    """
    Represents a textual expression in the Common Expression Language (CEL) syntax. CEL is a C-like expression language. The syntax and semantics of CEL are documented at https://github.com/google/cel-spec. Example (Comparison): title: "Summary size limit" description: "Determines if a summary is less than 100 chars" expression: "document.summary.size() < 100" Example (Equality): title: "Requestor is owner" description: "Determines if requestor is the document owner" expression: "document.owner == request.auth.claims.email" Example (Logic): title: "Public documents" description: "Determine whether the document should be publicly visible" expression: "document.type != 'private' && document.type != 'internal'" Example (Data Manipulation): title: "Notification string" description: "Create a notification string with a timestamp." expression: "'New message received at ' + string(document.create_time)" The exact variables and functions that may be referenced within an expression are determined by the service that evaluates it. See the service documentation for additional information.
    """
    def __init__(__self__, *,
                 description: str,
                 expression: str,
                 location: str,
                 title: str):
        """
        Represents a textual expression in the Common Expression Language (CEL) syntax. CEL is a C-like expression language. The syntax and semantics of CEL are documented at https://github.com/google/cel-spec. Example (Comparison): title: "Summary size limit" description: "Determines if a summary is less than 100 chars" expression: "document.summary.size() < 100" Example (Equality): title: "Requestor is owner" description: "Determines if requestor is the document owner" expression: "document.owner == request.auth.claims.email" Example (Logic): title: "Public documents" description: "Determine whether the document should be publicly visible" expression: "document.type != 'private' && document.type != 'internal'" Example (Data Manipulation): title: "Notification string" description: "Create a notification string with a timestamp." expression: "'New message received at ' + string(document.create_time)" The exact variables and functions that may be referenced within an expression are determined by the service that evaluates it. See the service documentation for additional information.
        :param str description: Optional. Description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
        :param str expression: Textual representation of an expression in Common Expression Language syntax.
        :param str location: Optional. String indicating the location of the expression for error reporting, e.g. a file name and a position in the file.
        :param str title: Optional. Title for the expression, i.e. a short string describing its purpose. This can be used e.g. in UIs which allow to enter the expression.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Optional. Description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def expression(self) -> str:
        """
        Textual representation of an expression in Common Expression Language syntax.
        """
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def location(self) -> str:
        """
        Optional. String indicating the location of the expression for error reporting, e.g. a file name and a position in the file.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def title(self) -> str:
        """
        Optional. Title for the expression, i.e. a short string describing its purpose. This can be used e.g. in UIs which allow to enter the expression.
        """
        return pulumi.get(self, "title")


@pulumi.output_type
class ExternalRefResponse(dict):
    """
    An External Reference allows a Package to reference an external source of additional information, metadata, enumerations, asset identifiers, or downloadable content believed to be relevant to the Package
    """
    def __init__(__self__, *,
                 category: str,
                 comment: str,
                 locator: str,
                 type: str):
        """
        An External Reference allows a Package to reference an external source of additional information, metadata, enumerations, asset identifiers, or downloadable content believed to be relevant to the Package
        :param str category: An External Reference allows a Package to reference an external source of additional information, metadata, enumerations, asset identifiers, or downloadable content believed to be relevant to the Package
        :param str comment: Human-readable information about the purpose and target of the reference
        :param str locator: The unique string with no spaces necessary to access the package-specific information, metadata, or content within the target location
        :param str type: Type of category (e.g. 'npm' for the PACKAGE_MANAGER category)
        """
        pulumi.set(__self__, "category", category)
        pulumi.set(__self__, "comment", comment)
        pulumi.set(__self__, "locator", locator)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def category(self) -> str:
        """
        An External Reference allows a Package to reference an external source of additional information, metadata, enumerations, asset identifiers, or downloadable content believed to be relevant to the Package
        """
        return pulumi.get(self, "category")

    @property
    @pulumi.getter
    def comment(self) -> str:
        """
        Human-readable information about the purpose and target of the reference
        """
        return pulumi.get(self, "comment")

    @property
    @pulumi.getter
    def locator(self) -> str:
        """
        The unique string with no spaces necessary to access the package-specific information, metadata, or content within the target location
        """
        return pulumi.get(self, "locator")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of category (e.g. 'npm' for the PACKAGE_MANAGER category)
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class FileNoteResponse(dict):
    """
    FileNote represents an SPDX File Information section: https://spdx.github.io/spdx-spec/4-file-information/
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fileType":
            suggest = "file_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FileNoteResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FileNoteResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FileNoteResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 checksum: Sequence[str],
                 file_type: str,
                 title: str):
        """
        FileNote represents an SPDX File Information section: https://spdx.github.io/spdx-spec/4-file-information/
        :param Sequence[str] checksum: Provide a unique identifier to match analysis information on each specific file in a package
        :param str file_type: This field provides information about the type of file identified
        :param str title: Identify the full path and filename that corresponds to the file information in this section
        """
        pulumi.set(__self__, "checksum", checksum)
        pulumi.set(__self__, "file_type", file_type)
        pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter
    def checksum(self) -> Sequence[str]:
        """
        Provide a unique identifier to match analysis information on each specific file in a package
        """
        return pulumi.get(self, "checksum")

    @property
    @pulumi.getter(name="fileType")
    def file_type(self) -> str:
        """
        This field provides information about the type of file identified
        """
        return pulumi.get(self, "file_type")

    @property
    @pulumi.getter
    def title(self) -> str:
        """
        Identify the full path and filename that corresponds to the file information in this section
        """
        return pulumi.get(self, "title")


@pulumi.output_type
class FileOccurrenceResponse(dict):
    """
    FileOccurrence represents an SPDX File Information section: https://spdx.github.io/spdx-spec/4-file-information/
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "filesLicenseInfo":
            suggest = "files_license_info"
        elif key == "licenseConcluded":
            suggest = "license_concluded"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FileOccurrenceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FileOccurrenceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FileOccurrenceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 attributions: Sequence[str],
                 comment: str,
                 contributors: Sequence[str],
                 copyright: str,
                 files_license_info: Sequence[str],
                 license_concluded: 'outputs.LicenseResponse',
                 notice: str):
        """
        FileOccurrence represents an SPDX File Information section: https://spdx.github.io/spdx-spec/4-file-information/
        :param Sequence[str] attributions: This field provides a place for the SPDX data creator to record, at the file level, acknowledgements that may be needed to be communicated in some contexts
        :param str comment: This field provides a place for the SPDX file creator to record any general comments about the file
        :param Sequence[str] contributors: This field provides a place for the SPDX file creator to record file contributors
        :param str copyright: Identify the copyright holder of the file, as well as any dates present
        :param Sequence[str] files_license_info: This field contains the license information actually found in the file, if any
        :param 'LicenseResponse' license_concluded: This field contains the license the SPDX file creator has concluded as governing the file or alternative values if the governing license cannot be determined
        :param str notice: This field provides a place for the SPDX file creator to record license notices or other such related notices found in the file
        """
        pulumi.set(__self__, "attributions", attributions)
        pulumi.set(__self__, "comment", comment)
        pulumi.set(__self__, "contributors", contributors)
        pulumi.set(__self__, "copyright", copyright)
        pulumi.set(__self__, "files_license_info", files_license_info)
        pulumi.set(__self__, "license_concluded", license_concluded)
        pulumi.set(__self__, "notice", notice)

    @property
    @pulumi.getter
    def attributions(self) -> Sequence[str]:
        """
        This field provides a place for the SPDX data creator to record, at the file level, acknowledgements that may be needed to be communicated in some contexts
        """
        return pulumi.get(self, "attributions")

    @property
    @pulumi.getter
    def comment(self) -> str:
        """
        This field provides a place for the SPDX file creator to record any general comments about the file
        """
        return pulumi.get(self, "comment")

    @property
    @pulumi.getter
    def contributors(self) -> Sequence[str]:
        """
        This field provides a place for the SPDX file creator to record file contributors
        """
        return pulumi.get(self, "contributors")

    @property
    @pulumi.getter
    def copyright(self) -> str:
        """
        Identify the copyright holder of the file, as well as any dates present
        """
        return pulumi.get(self, "copyright")

    @property
    @pulumi.getter(name="filesLicenseInfo")
    def files_license_info(self) -> Sequence[str]:
        """
        This field contains the license information actually found in the file, if any
        """
        return pulumi.get(self, "files_license_info")

    @property
    @pulumi.getter(name="licenseConcluded")
    def license_concluded(self) -> 'outputs.LicenseResponse':
        """
        This field contains the license the SPDX file creator has concluded as governing the file or alternative values if the governing license cannot be determined
        """
        return pulumi.get(self, "license_concluded")

    @property
    @pulumi.getter
    def notice(self) -> str:
        """
        This field provides a place for the SPDX file creator to record license notices or other such related notices found in the file
        """
        return pulumi.get(self, "notice")


@pulumi.output_type
class FingerprintResponse(dict):
    """
    A set of properties that uniquely identify a given Docker image.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "v1Name":
            suggest = "v1_name"
        elif key == "v2Blob":
            suggest = "v2_blob"
        elif key == "v2Name":
            suggest = "v2_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FingerprintResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FingerprintResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FingerprintResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 v1_name: str,
                 v2_blob: Sequence[str],
                 v2_name: str):
        """
        A set of properties that uniquely identify a given Docker image.
        :param str v1_name: The layer ID of the final layer in the Docker image's v1 representation.
        :param Sequence[str] v2_blob: The ordered list of v2 blobs that represent a given image.
        :param str v2_name: The name of the image's v2 blobs computed via: [bottom] := v2_blobbottom := sha256(v2_blob[N] + " " + v2_name[N+1]) Only the name of the final blob is kept.
        """
        pulumi.set(__self__, "v1_name", v1_name)
        pulumi.set(__self__, "v2_blob", v2_blob)
        pulumi.set(__self__, "v2_name", v2_name)

    @property
    @pulumi.getter(name="v1Name")
    def v1_name(self) -> str:
        """
        The layer ID of the final layer in the Docker image's v1 representation.
        """
        return pulumi.get(self, "v1_name")

    @property
    @pulumi.getter(name="v2Blob")
    def v2_blob(self) -> Sequence[str]:
        """
        The ordered list of v2 blobs that represent a given image.
        """
        return pulumi.get(self, "v2_blob")

    @property
    @pulumi.getter(name="v2Name")
    def v2_name(self) -> str:
        """
        The name of the image's v2 blobs computed via: [bottom] := v2_blobbottom := sha256(v2_blob[N] + " " + v2_name[N+1]) Only the name of the final blob is kept.
        """
        return pulumi.get(self, "v2_name")


@pulumi.output_type
class GenericSignedAttestationResponse(dict):
    """
    An attestation wrapper that uses the Grafeas `Signature` message. This attestation must define the `serialized_payload` that the `signatures` verify and any metadata necessary to interpret that plaintext. The signatures should always be over the `serialized_payload` bytestring.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "contentType":
            suggest = "content_type"
        elif key == "serializedPayload":
            suggest = "serialized_payload"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GenericSignedAttestationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GenericSignedAttestationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GenericSignedAttestationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 content_type: str,
                 serialized_payload: str,
                 signatures: Sequence['outputs.SignatureResponse']):
        """
        An attestation wrapper that uses the Grafeas `Signature` message. This attestation must define the `serialized_payload` that the `signatures` verify and any metadata necessary to interpret that plaintext. The signatures should always be over the `serialized_payload` bytestring.
        :param str content_type: Type (for example schema) of the attestation payload that was signed. The verifier must ensure that the provided type is one that the verifier supports, and that the attestation payload is a valid instantiation of that type (for example by validating a JSON schema).
        :param str serialized_payload: The serialized payload that is verified by one or more `signatures`. The encoding and semantic meaning of this payload must match what is set in `content_type`.
        :param Sequence['SignatureResponse'] signatures: One or more signatures over `serialized_payload`. Verifier implementations should consider this attestation message verified if at least one `signature` verifies `serialized_payload`. See `Signature` in common.proto for more details on signature structure and verification.
        """
        pulumi.set(__self__, "content_type", content_type)
        pulumi.set(__self__, "serialized_payload", serialized_payload)
        pulumi.set(__self__, "signatures", signatures)

    @property
    @pulumi.getter(name="contentType")
    def content_type(self) -> str:
        """
        Type (for example schema) of the attestation payload that was signed. The verifier must ensure that the provided type is one that the verifier supports, and that the attestation payload is a valid instantiation of that type (for example by validating a JSON schema).
        """
        return pulumi.get(self, "content_type")

    @property
    @pulumi.getter(name="serializedPayload")
    def serialized_payload(self) -> str:
        """
        The serialized payload that is verified by one or more `signatures`. The encoding and semantic meaning of this payload must match what is set in `content_type`.
        """
        return pulumi.get(self, "serialized_payload")

    @property
    @pulumi.getter
    def signatures(self) -> Sequence['outputs.SignatureResponse']:
        """
        One or more signatures over `serialized_payload`. Verifier implementations should consider this attestation message verified if at least one `signature` verifies `serialized_payload`. See `Signature` in common.proto for more details on signature structure and verification.
        """
        return pulumi.get(self, "signatures")


@pulumi.output_type
class GerritSourceContextResponse(dict):
    """
    A SourceContext referring to a Gerrit project.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "aliasContext":
            suggest = "alias_context"
        elif key == "gerritProject":
            suggest = "gerrit_project"
        elif key == "hostUri":
            suggest = "host_uri"
        elif key == "revisionId":
            suggest = "revision_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GerritSourceContextResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GerritSourceContextResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GerritSourceContextResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 alias_context: 'outputs.AliasContextResponse',
                 gerrit_project: str,
                 host_uri: str,
                 revision_id: str):
        """
        A SourceContext referring to a Gerrit project.
        :param 'AliasContextResponse' alias_context: An alias, which may be a branch or tag.
        :param str gerrit_project: The full project name within the host. Projects may be nested, so "project/subproject" is a valid project name. The "repo name" is the hostURI/project.
        :param str host_uri: The URI of a running Gerrit instance.
        :param str revision_id: A revision (commit) ID.
        """
        pulumi.set(__self__, "alias_context", alias_context)
        pulumi.set(__self__, "gerrit_project", gerrit_project)
        pulumi.set(__self__, "host_uri", host_uri)
        pulumi.set(__self__, "revision_id", revision_id)

    @property
    @pulumi.getter(name="aliasContext")
    def alias_context(self) -> 'outputs.AliasContextResponse':
        """
        An alias, which may be a branch or tag.
        """
        return pulumi.get(self, "alias_context")

    @property
    @pulumi.getter(name="gerritProject")
    def gerrit_project(self) -> str:
        """
        The full project name within the host. Projects may be nested, so "project/subproject" is a valid project name. The "repo name" is the hostURI/project.
        """
        return pulumi.get(self, "gerrit_project")

    @property
    @pulumi.getter(name="hostUri")
    def host_uri(self) -> str:
        """
        The URI of a running Gerrit instance.
        """
        return pulumi.get(self, "host_uri")

    @property
    @pulumi.getter(name="revisionId")
    def revision_id(self) -> str:
        """
        A revision (commit) ID.
        """
        return pulumi.get(self, "revision_id")


@pulumi.output_type
class GitSourceContextResponse(dict):
    """
    A GitSourceContext denotes a particular revision in a third party Git repository (e.g., GitHub).
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "revisionId":
            suggest = "revision_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GitSourceContextResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GitSourceContextResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GitSourceContextResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 revision_id: str,
                 url: str):
        """
        A GitSourceContext denotes a particular revision in a third party Git repository (e.g., GitHub).
        :param str revision_id: Git commit hash.
        :param str url: Git repository URL.
        """
        pulumi.set(__self__, "revision_id", revision_id)
        pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter(name="revisionId")
    def revision_id(self) -> str:
        """
        Git commit hash.
        """
        return pulumi.get(self, "revision_id")

    @property
    @pulumi.getter
    def url(self) -> str:
        """
        Git repository URL.
        """
        return pulumi.get(self, "url")


@pulumi.output_type
class GrafeasV1beta1BuildDetailsResponse(dict):
    """
    Details of a build occurrence.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "provenanceBytes":
            suggest = "provenance_bytes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GrafeasV1beta1BuildDetailsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GrafeasV1beta1BuildDetailsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GrafeasV1beta1BuildDetailsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 provenance: 'outputs.BuildProvenanceResponse',
                 provenance_bytes: str):
        """
        Details of a build occurrence.
        :param 'BuildProvenanceResponse' provenance: The actual provenance for the build.
        :param str provenance_bytes: Serialized JSON representation of the provenance, used in generating the build signature in the corresponding build note. After verifying the signature, `provenance_bytes` can be unmarshalled and compared to the provenance to confirm that it is unchanged. A base64-encoded string representation of the provenance bytes is used for the signature in order to interoperate with openssl which expects this format for signature verification. The serialized form is captured both to avoid ambiguity in how the provenance is marshalled to json as well to prevent incompatibilities with future changes.
        """
        pulumi.set(__self__, "provenance", provenance)
        pulumi.set(__self__, "provenance_bytes", provenance_bytes)

    @property
    @pulumi.getter
    def provenance(self) -> 'outputs.BuildProvenanceResponse':
        """
        The actual provenance for the build.
        """
        return pulumi.get(self, "provenance")

    @property
    @pulumi.getter(name="provenanceBytes")
    def provenance_bytes(self) -> str:
        """
        Serialized JSON representation of the provenance, used in generating the build signature in the corresponding build note. After verifying the signature, `provenance_bytes` can be unmarshalled and compared to the provenance to confirm that it is unchanged. A base64-encoded string representation of the provenance bytes is used for the signature in order to interoperate with openssl which expects this format for signature verification. The serialized form is captured both to avoid ambiguity in how the provenance is marshalled to json as well to prevent incompatibilities with future changes.
        """
        return pulumi.get(self, "provenance_bytes")


@pulumi.output_type
class GrafeasV1beta1DeploymentDetailsResponse(dict):
    """
    Details of a deployment occurrence.
    """
    def __init__(__self__, *,
                 deployment: 'outputs.DeploymentResponse'):
        """
        Details of a deployment occurrence.
        :param 'DeploymentResponse' deployment: Deployment history for the resource.
        """
        pulumi.set(__self__, "deployment", deployment)

    @property
    @pulumi.getter
    def deployment(self) -> 'outputs.DeploymentResponse':
        """
        Deployment history for the resource.
        """
        return pulumi.get(self, "deployment")


@pulumi.output_type
class GrafeasV1beta1DiscoveryDetailsResponse(dict):
    """
    Details of a discovery occurrence.
    """
    def __init__(__self__, *,
                 discovered: 'outputs.DiscoveredResponse'):
        """
        Details of a discovery occurrence.
        :param 'DiscoveredResponse' discovered: Analysis status for the discovered resource.
        """
        pulumi.set(__self__, "discovered", discovered)

    @property
    @pulumi.getter
    def discovered(self) -> 'outputs.DiscoveredResponse':
        """
        Analysis status for the discovered resource.
        """
        return pulumi.get(self, "discovered")


@pulumi.output_type
class GrafeasV1beta1ImageDetailsResponse(dict):
    """
    Details of an image occurrence.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "derivedImage":
            suggest = "derived_image"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GrafeasV1beta1ImageDetailsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GrafeasV1beta1ImageDetailsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GrafeasV1beta1ImageDetailsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 derived_image: 'outputs.DerivedResponse'):
        """
        Details of an image occurrence.
        :param 'DerivedResponse' derived_image: Immutable. The child image derived from the base image.
        """
        pulumi.set(__self__, "derived_image", derived_image)

    @property
    @pulumi.getter(name="derivedImage")
    def derived_image(self) -> 'outputs.DerivedResponse':
        """
        Immutable. The child image derived from the base image.
        """
        return pulumi.get(self, "derived_image")


@pulumi.output_type
class GrafeasV1beta1IntotoArtifactResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourceUri":
            suggest = "resource_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GrafeasV1beta1IntotoArtifactResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GrafeasV1beta1IntotoArtifactResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GrafeasV1beta1IntotoArtifactResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 hashes: 'outputs.ArtifactHashesResponse',
                 resource_uri: str):
        pulumi.set(__self__, "hashes", hashes)
        pulumi.set(__self__, "resource_uri", resource_uri)

    @property
    @pulumi.getter
    def hashes(self) -> 'outputs.ArtifactHashesResponse':
        return pulumi.get(self, "hashes")

    @property
    @pulumi.getter(name="resourceUri")
    def resource_uri(self) -> str:
        return pulumi.get(self, "resource_uri")


@pulumi.output_type
class GrafeasV1beta1IntotoDetailsResponse(dict):
    """
    This corresponds to a signed in-toto link - it is made up of one or more signatures and the in-toto link itself. This is used for occurrences of a Grafeas in-toto note.
    """
    def __init__(__self__, *,
                 signatures: Sequence['outputs.GrafeasV1beta1IntotoSignatureResponse'],
                 signed: 'outputs.LinkResponse'):
        """
        This corresponds to a signed in-toto link - it is made up of one or more signatures and the in-toto link itself. This is used for occurrences of a Grafeas in-toto note.
        """
        pulumi.set(__self__, "signatures", signatures)
        pulumi.set(__self__, "signed", signed)

    @property
    @pulumi.getter
    def signatures(self) -> Sequence['outputs.GrafeasV1beta1IntotoSignatureResponse']:
        return pulumi.get(self, "signatures")

    @property
    @pulumi.getter
    def signed(self) -> 'outputs.LinkResponse':
        return pulumi.get(self, "signed")


@pulumi.output_type
class GrafeasV1beta1IntotoSignatureResponse(dict):
    """
    A signature object consists of the KeyID used and the signature itself.
    """
    def __init__(__self__, *,
                 keyid: str,
                 sig: str):
        """
        A signature object consists of the KeyID used and the signature itself.
        """
        pulumi.set(__self__, "keyid", keyid)
        pulumi.set(__self__, "sig", sig)

    @property
    @pulumi.getter
    def keyid(self) -> str:
        return pulumi.get(self, "keyid")

    @property
    @pulumi.getter
    def sig(self) -> str:
        return pulumi.get(self, "sig")


@pulumi.output_type
class GrafeasV1beta1PackageDetailsResponse(dict):
    """
    Details of a package occurrence.
    """
    def __init__(__self__, *,
                 installation: 'outputs.InstallationResponse'):
        """
        Details of a package occurrence.
        :param 'InstallationResponse' installation: Where the package was installed.
        """
        pulumi.set(__self__, "installation", installation)

    @property
    @pulumi.getter
    def installation(self) -> 'outputs.InstallationResponse':
        """
        Where the package was installed.
        """
        return pulumi.get(self, "installation")


@pulumi.output_type
class GrafeasV1beta1VulnerabilityDetailsResponse(dict):
    """
    Details of a vulnerability Occurrence.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cvssScore":
            suggest = "cvss_score"
        elif key == "effectiveSeverity":
            suggest = "effective_severity"
        elif key == "longDescription":
            suggest = "long_description"
        elif key == "packageIssue":
            suggest = "package_issue"
        elif key == "relatedUrls":
            suggest = "related_urls"
        elif key == "shortDescription":
            suggest = "short_description"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GrafeasV1beta1VulnerabilityDetailsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GrafeasV1beta1VulnerabilityDetailsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GrafeasV1beta1VulnerabilityDetailsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cvss_score: float,
                 effective_severity: str,
                 long_description: str,
                 package_issue: Sequence['outputs.PackageIssueResponse'],
                 related_urls: Sequence['outputs.RelatedUrlResponse'],
                 severity: str,
                 short_description: str,
                 type: str):
        """
        Details of a vulnerability Occurrence.
        :param float cvss_score: The CVSS score of this vulnerability. CVSS score is on a scale of 0-10 where 0 indicates low severity and 10 indicates high severity.
        :param str effective_severity: The distro assigned severity for this vulnerability when it is available, and note provider assigned severity when distro has not yet assigned a severity for this vulnerability. When there are multiple PackageIssues for this vulnerability, they can have different effective severities because some might be provided by the distro while others are provided by the language ecosystem for a language pack. For this reason, it is advised to use the effective severity on the PackageIssue level. In the case where multiple PackageIssues have differing effective severities, this field should be the highest severity for any of the PackageIssues.
        :param str long_description: A detailed description of this vulnerability.
        :param Sequence['PackageIssueResponse'] package_issue: The set of affected locations and their fixes (if available) within the associated resource.
        :param Sequence['RelatedUrlResponse'] related_urls: URLs related to this vulnerability.
        :param str severity: The note provider assigned Severity of the vulnerability.
        :param str short_description: A one sentence description of this vulnerability.
        :param str type: The type of package; whether native or non native(ruby gems, node.js packages etc)
        """
        pulumi.set(__self__, "cvss_score", cvss_score)
        pulumi.set(__self__, "effective_severity", effective_severity)
        pulumi.set(__self__, "long_description", long_description)
        pulumi.set(__self__, "package_issue", package_issue)
        pulumi.set(__self__, "related_urls", related_urls)
        pulumi.set(__self__, "severity", severity)
        pulumi.set(__self__, "short_description", short_description)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="cvssScore")
    def cvss_score(self) -> float:
        """
        The CVSS score of this vulnerability. CVSS score is on a scale of 0-10 where 0 indicates low severity and 10 indicates high severity.
        """
        return pulumi.get(self, "cvss_score")

    @property
    @pulumi.getter(name="effectiveSeverity")
    def effective_severity(self) -> str:
        """
        The distro assigned severity for this vulnerability when it is available, and note provider assigned severity when distro has not yet assigned a severity for this vulnerability. When there are multiple PackageIssues for this vulnerability, they can have different effective severities because some might be provided by the distro while others are provided by the language ecosystem for a language pack. For this reason, it is advised to use the effective severity on the PackageIssue level. In the case where multiple PackageIssues have differing effective severities, this field should be the highest severity for any of the PackageIssues.
        """
        return pulumi.get(self, "effective_severity")

    @property
    @pulumi.getter(name="longDescription")
    def long_description(self) -> str:
        """
        A detailed description of this vulnerability.
        """
        return pulumi.get(self, "long_description")

    @property
    @pulumi.getter(name="packageIssue")
    def package_issue(self) -> Sequence['outputs.PackageIssueResponse']:
        """
        The set of affected locations and their fixes (if available) within the associated resource.
        """
        return pulumi.get(self, "package_issue")

    @property
    @pulumi.getter(name="relatedUrls")
    def related_urls(self) -> Sequence['outputs.RelatedUrlResponse']:
        """
        URLs related to this vulnerability.
        """
        return pulumi.get(self, "related_urls")

    @property
    @pulumi.getter
    def severity(self) -> str:
        """
        The note provider assigned Severity of the vulnerability.
        """
        return pulumi.get(self, "severity")

    @property
    @pulumi.getter(name="shortDescription")
    def short_description(self) -> str:
        """
        A one sentence description of this vulnerability.
        """
        return pulumi.get(self, "short_description")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of package; whether native or non native(ruby gems, node.js packages etc)
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class HintResponse(dict):
    """
    This submessage provides human-readable hints about the purpose of the authority. Because the name of a note acts as its resource reference, it is important to disambiguate the canonical name of the Note (which might be a UUID for security purposes) from "readable" names more suitable for debug output. Note that these hints should not be used to look up authorities in security sensitive contexts, such as when looking up attestations to verify.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "humanReadableName":
            suggest = "human_readable_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HintResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HintResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HintResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 human_readable_name: str):
        """
        This submessage provides human-readable hints about the purpose of the authority. Because the name of a note acts as its resource reference, it is important to disambiguate the canonical name of the Note (which might be a UUID for security purposes) from "readable" names more suitable for debug output. Note that these hints should not be used to look up authorities in security sensitive contexts, such as when looking up attestations to verify.
        :param str human_readable_name: The human readable name of this attestation authority, for example "qa".
        """
        pulumi.set(__self__, "human_readable_name", human_readable_name)

    @property
    @pulumi.getter(name="humanReadableName")
    def human_readable_name(self) -> str:
        """
        The human readable name of this attestation authority, for example "qa".
        """
        return pulumi.get(self, "human_readable_name")


@pulumi.output_type
class InTotoResponse(dict):
    """
    This contains the fields corresponding to the definition of a software supply chain step in an in-toto layout. This information goes into a Grafeas note.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "expectedCommand":
            suggest = "expected_command"
        elif key == "expectedMaterials":
            suggest = "expected_materials"
        elif key == "expectedProducts":
            suggest = "expected_products"
        elif key == "signingKeys":
            suggest = "signing_keys"
        elif key == "stepName":
            suggest = "step_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InTotoResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InTotoResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InTotoResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 expected_command: Sequence[str],
                 expected_materials: Sequence['outputs.ArtifactRuleResponse'],
                 expected_products: Sequence['outputs.ArtifactRuleResponse'],
                 signing_keys: Sequence['outputs.SigningKeyResponse'],
                 step_name: str,
                 threshold: str):
        """
        This contains the fields corresponding to the definition of a software supply chain step in an in-toto layout. This information goes into a Grafeas note.
        :param Sequence[str] expected_command: This field contains the expected command used to perform the step.
        :param Sequence['ArtifactRuleResponse'] expected_materials: The following fields contain in-toto artifact rules identifying the artifacts that enter this supply chain step, and exit the supply chain step, i.e. materials and products of the step.
        :param Sequence['SigningKeyResponse'] signing_keys: This field contains the public keys that can be used to verify the signatures on the step metadata.
        :param str step_name: This field identifies the name of the step in the supply chain.
        :param str threshold: This field contains a value that indicates the minimum number of keys that need to be used to sign the step's in-toto link.
        """
        pulumi.set(__self__, "expected_command", expected_command)
        pulumi.set(__self__, "expected_materials", expected_materials)
        pulumi.set(__self__, "expected_products", expected_products)
        pulumi.set(__self__, "signing_keys", signing_keys)
        pulumi.set(__self__, "step_name", step_name)
        pulumi.set(__self__, "threshold", threshold)

    @property
    @pulumi.getter(name="expectedCommand")
    def expected_command(self) -> Sequence[str]:
        """
        This field contains the expected command used to perform the step.
        """
        return pulumi.get(self, "expected_command")

    @property
    @pulumi.getter(name="expectedMaterials")
    def expected_materials(self) -> Sequence['outputs.ArtifactRuleResponse']:
        """
        The following fields contain in-toto artifact rules identifying the artifacts that enter this supply chain step, and exit the supply chain step, i.e. materials and products of the step.
        """
        return pulumi.get(self, "expected_materials")

    @property
    @pulumi.getter(name="expectedProducts")
    def expected_products(self) -> Sequence['outputs.ArtifactRuleResponse']:
        return pulumi.get(self, "expected_products")

    @property
    @pulumi.getter(name="signingKeys")
    def signing_keys(self) -> Sequence['outputs.SigningKeyResponse']:
        """
        This field contains the public keys that can be used to verify the signatures on the step metadata.
        """
        return pulumi.get(self, "signing_keys")

    @property
    @pulumi.getter(name="stepName")
    def step_name(self) -> str:
        """
        This field identifies the name of the step in the supply chain.
        """
        return pulumi.get(self, "step_name")

    @property
    @pulumi.getter
    def threshold(self) -> str:
        """
        This field contains a value that indicates the minimum number of keys that need to be used to sign the step's in-toto link.
        """
        return pulumi.get(self, "threshold")


@pulumi.output_type
class InstallationResponse(dict):
    """
    This represents how a particular software package may be installed on a system.
    """
    def __init__(__self__, *,
                 location: Sequence['outputs.LocationResponse'],
                 name: str):
        """
        This represents how a particular software package may be installed on a system.
        :param Sequence['LocationResponse'] location: All of the places within the filesystem versions of this package have been found.
        :param str name: The name of the installed package.
        """
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def location(self) -> Sequence['outputs.LocationResponse']:
        """
        All of the places within the filesystem versions of this package have been found.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the installed package.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class KnowledgeBaseResponse(dict):
    def __init__(__self__, *,
                 name: str,
                 url: str):
        """
        :param str name: The KB name (generally of the form KB[0-9]+ i.e. KB123456).
        :param str url: A link to the KB in the Windows update catalog - https://www.catalog.update.microsoft.com/
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The KB name (generally of the form KB[0-9]+ i.e. KB123456).
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def url(self) -> str:
        """
        A link to the KB in the Windows update catalog - https://www.catalog.update.microsoft.com/
        """
        return pulumi.get(self, "url")


@pulumi.output_type
class LayerResponse(dict):
    """
    Layer holds metadata specific to a layer of a Docker image.
    """
    def __init__(__self__, *,
                 arguments: str,
                 directive: str):
        """
        Layer holds metadata specific to a layer of a Docker image.
        :param str arguments: The recovered arguments to the Dockerfile directive.
        :param str directive: The recovered Dockerfile directive used to construct this layer.
        """
        pulumi.set(__self__, "arguments", arguments)
        pulumi.set(__self__, "directive", directive)

    @property
    @pulumi.getter
    def arguments(self) -> str:
        """
        The recovered arguments to the Dockerfile directive.
        """
        return pulumi.get(self, "arguments")

    @property
    @pulumi.getter
    def directive(self) -> str:
        """
        The recovered Dockerfile directive used to construct this layer.
        """
        return pulumi.get(self, "directive")


@pulumi.output_type
class LicenseResponse(dict):
    """
    License information: https://spdx.github.io/spdx-spec/3-package-information/#315-declared-license
    """
    def __init__(__self__, *,
                 comments: str,
                 expression: str):
        """
        License information: https://spdx.github.io/spdx-spec/3-package-information/#315-declared-license
        :param str comments: Comments
        :param str expression: Expression: https://spdx.github.io/spdx-spec/appendix-IV-SPDX-license-expressions/
        """
        pulumi.set(__self__, "comments", comments)
        pulumi.set(__self__, "expression", expression)

    @property
    @pulumi.getter
    def comments(self) -> str:
        """
        Comments
        """
        return pulumi.get(self, "comments")

    @property
    @pulumi.getter
    def expression(self) -> str:
        """
        Expression: https://spdx.github.io/spdx-spec/appendix-IV-SPDX-license-expressions/
        """
        return pulumi.get(self, "expression")


@pulumi.output_type
class LinkResponse(dict):
    """
    This corresponds to an in-toto link.
    """
    def __init__(__self__, *,
                 byproducts: 'outputs.ByProductsResponse',
                 command: Sequence[str],
                 environment: 'outputs.EnvironmentResponse',
                 materials: Sequence['outputs.GrafeasV1beta1IntotoArtifactResponse'],
                 products: Sequence['outputs.GrafeasV1beta1IntotoArtifactResponse']):
        """
        This corresponds to an in-toto link.
        :param 'ByProductsResponse' byproducts: ByProducts are data generated as part of a software supply chain step, but are not the actual result of the step.
        :param Sequence[str] command: This field contains the full command executed for the step. This can also be empty if links are generated for operations that aren't directly mapped to a specific command. Each term in the command is an independent string in the list. An example of a command in the in-toto metadata field is: "command": ["git", "clone", "https://github.com/in-toto/demo-project.git"]
        :param 'EnvironmentResponse' environment: This is a field that can be used to capture information about the environment. It is suggested for this field to contain information that details environment variables, filesystem information, and the present working directory. The recommended structure of this field is: "environment": { "custom_values": { "variables": "", "filesystem": "", "workdir": "", "": "..." } }
        :param Sequence['GrafeasV1beta1IntotoArtifactResponse'] materials: Materials are the supply chain artifacts that go into the step and are used for the operation performed. The key of the map is the path of the artifact and the structure contains the recorded hash information. An example is: "materials": [ { "resource_uri": "foo/bar", "hashes": { "sha256": "ebebf...", : } } ]
        :param Sequence['GrafeasV1beta1IntotoArtifactResponse'] products: Products are the supply chain artifacts generated as a result of the step. The structure is identical to that of materials.
        """
        pulumi.set(__self__, "byproducts", byproducts)
        pulumi.set(__self__, "command", command)
        pulumi.set(__self__, "environment", environment)
        pulumi.set(__self__, "materials", materials)
        pulumi.set(__self__, "products", products)

    @property
    @pulumi.getter
    def byproducts(self) -> 'outputs.ByProductsResponse':
        """
        ByProducts are data generated as part of a software supply chain step, but are not the actual result of the step.
        """
        return pulumi.get(self, "byproducts")

    @property
    @pulumi.getter
    def command(self) -> Sequence[str]:
        """
        This field contains the full command executed for the step. This can also be empty if links are generated for operations that aren't directly mapped to a specific command. Each term in the command is an independent string in the list. An example of a command in the in-toto metadata field is: "command": ["git", "clone", "https://github.com/in-toto/demo-project.git"]
        """
        return pulumi.get(self, "command")

    @property
    @pulumi.getter
    def environment(self) -> 'outputs.EnvironmentResponse':
        """
        This is a field that can be used to capture information about the environment. It is suggested for this field to contain information that details environment variables, filesystem information, and the present working directory. The recommended structure of this field is: "environment": { "custom_values": { "variables": "", "filesystem": "", "workdir": "", "": "..." } }
        """
        return pulumi.get(self, "environment")

    @property
    @pulumi.getter
    def materials(self) -> Sequence['outputs.GrafeasV1beta1IntotoArtifactResponse']:
        """
        Materials are the supply chain artifacts that go into the step and are used for the operation performed. The key of the map is the path of the artifact and the structure contains the recorded hash information. An example is: "materials": [ { "resource_uri": "foo/bar", "hashes": { "sha256": "ebebf...", : } } ]
        """
        return pulumi.get(self, "materials")

    @property
    @pulumi.getter
    def products(self) -> Sequence['outputs.GrafeasV1beta1IntotoArtifactResponse']:
        """
        Products are the supply chain artifacts generated as a result of the step. The structure is identical to that of materials.
        """
        return pulumi.get(self, "products")


@pulumi.output_type
class LocationResponse(dict):
    """
    An occurrence of a particular package installation found within a system's filesystem. E.g., glibc was found in `/var/lib/dpkg/status`.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cpeUri":
            suggest = "cpe_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LocationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LocationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LocationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cpe_uri: str,
                 path: str,
                 version: 'outputs.VersionResponse'):
        """
        An occurrence of a particular package installation found within a system's filesystem. E.g., glibc was found in `/var/lib/dpkg/status`.
        :param str cpe_uri: The CPE URI in [CPE format](https://cpe.mitre.org/specification/) denoting the package manager version distributing a package.
        :param str path: The path from which we gathered that this package/version is installed.
        :param 'VersionResponse' version: The version installed at this location.
        """
        pulumi.set(__self__, "cpe_uri", cpe_uri)
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="cpeUri")
    def cpe_uri(self) -> str:
        """
        The CPE URI in [CPE format](https://cpe.mitre.org/specification/) denoting the package manager version distributing a package.
        """
        return pulumi.get(self, "cpe_uri")

    @property
    @pulumi.getter
    def path(self) -> str:
        """
        The path from which we gathered that this package/version is installed.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def version(self) -> 'outputs.VersionResponse':
        """
        The version installed at this location.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class PackageInfoNoteResponse(dict):
    """
    PackageInfoNote represents an SPDX Package Information section: https://spdx.github.io/spdx-spec/3-package-information/
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "detailedDescription":
            suggest = "detailed_description"
        elif key == "downloadLocation":
            suggest = "download_location"
        elif key == "externalRefs":
            suggest = "external_refs"
        elif key == "filesLicenseInfo":
            suggest = "files_license_info"
        elif key == "homePage":
            suggest = "home_page"
        elif key == "licenseDeclared":
            suggest = "license_declared"
        elif key == "packageType":
            suggest = "package_type"
        elif key == "summaryDescription":
            suggest = "summary_description"
        elif key == "verificationCode":
            suggest = "verification_code"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PackageInfoNoteResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PackageInfoNoteResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PackageInfoNoteResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 analyzed: bool,
                 attribution: str,
                 checksum: str,
                 copyright: str,
                 detailed_description: str,
                 download_location: str,
                 external_refs: Sequence['outputs.ExternalRefResponse'],
                 files_license_info: Sequence[str],
                 home_page: str,
                 license_declared: 'outputs.LicenseResponse',
                 originator: str,
                 package_type: str,
                 summary_description: str,
                 supplier: str,
                 title: str,
                 verification_code: str,
                 version: str):
        """
        PackageInfoNote represents an SPDX Package Information section: https://spdx.github.io/spdx-spec/3-package-information/
        :param bool analyzed: Indicates whether the file content of this package has been available for or subjected to analysis when creating the SPDX document
        :param str attribution: A place for the SPDX data creator to record, at the package level, acknowledgements that may be needed to be communicated in some contexts
        :param str checksum: Provide an independently reproducible mechanism that permits unique identification of a specific package that correlates to the data in this SPDX file
        :param str copyright: Identify the copyright holders of the package, as well as any dates present
        :param str detailed_description: A more detailed description of the package
        :param str download_location: This section identifies the download Universal Resource Locator (URL), or a specific location within a version control system (VCS) for the package at the time that the SPDX file was created
        :param Sequence['ExternalRefResponse'] external_refs: ExternalRef
        :param Sequence[str] files_license_info: Contain the license the SPDX file creator has concluded as governing the This field is to contain a list of all licenses found in the package. The relationship between licenses (i.e., conjunctive, disjunctive) is not specified in this field – it is simply a listing of all licenses found
        :param str home_page: Provide a place for the SPDX file creator to record a web site that serves as the package's home page
        :param 'LicenseResponse' license_declared: List the licenses that have been declared by the authors of the package
        :param str originator: If the package identified in the SPDX file originated from a different person or organization than identified as Package Supplier, this field identifies from where or whom the package originally came
        :param str package_type: The type of package: OS, MAVEN, GO, GO_STDLIB, etc.
        :param str summary_description: A short description of the package
        :param str supplier: Identify the actual distribution source for the package/directory identified in the SPDX file
        :param str title: Identify the full name of the package as given by the Package Originator
        :param str verification_code: This field provides an independently reproducible mechanism identifying specific contents of a package based on the actual files (except the SPDX file itself, if it is included in the package) that make up each package and that correlates to the data in this SPDX file
        :param str version: Identify the version of the package
        """
        pulumi.set(__self__, "analyzed", analyzed)
        pulumi.set(__self__, "attribution", attribution)
        pulumi.set(__self__, "checksum", checksum)
        pulumi.set(__self__, "copyright", copyright)
        pulumi.set(__self__, "detailed_description", detailed_description)
        pulumi.set(__self__, "download_location", download_location)
        pulumi.set(__self__, "external_refs", external_refs)
        pulumi.set(__self__, "files_license_info", files_license_info)
        pulumi.set(__self__, "home_page", home_page)
        pulumi.set(__self__, "license_declared", license_declared)
        pulumi.set(__self__, "originator", originator)
        pulumi.set(__self__, "package_type", package_type)
        pulumi.set(__self__, "summary_description", summary_description)
        pulumi.set(__self__, "supplier", supplier)
        pulumi.set(__self__, "title", title)
        pulumi.set(__self__, "verification_code", verification_code)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def analyzed(self) -> bool:
        """
        Indicates whether the file content of this package has been available for or subjected to analysis when creating the SPDX document
        """
        return pulumi.get(self, "analyzed")

    @property
    @pulumi.getter
    def attribution(self) -> str:
        """
        A place for the SPDX data creator to record, at the package level, acknowledgements that may be needed to be communicated in some contexts
        """
        return pulumi.get(self, "attribution")

    @property
    @pulumi.getter
    def checksum(self) -> str:
        """
        Provide an independently reproducible mechanism that permits unique identification of a specific package that correlates to the data in this SPDX file
        """
        return pulumi.get(self, "checksum")

    @property
    @pulumi.getter
    def copyright(self) -> str:
        """
        Identify the copyright holders of the package, as well as any dates present
        """
        return pulumi.get(self, "copyright")

    @property
    @pulumi.getter(name="detailedDescription")
    def detailed_description(self) -> str:
        """
        A more detailed description of the package
        """
        return pulumi.get(self, "detailed_description")

    @property
    @pulumi.getter(name="downloadLocation")
    def download_location(self) -> str:
        """
        This section identifies the download Universal Resource Locator (URL), or a specific location within a version control system (VCS) for the package at the time that the SPDX file was created
        """
        return pulumi.get(self, "download_location")

    @property
    @pulumi.getter(name="externalRefs")
    def external_refs(self) -> Sequence['outputs.ExternalRefResponse']:
        """
        ExternalRef
        """
        return pulumi.get(self, "external_refs")

    @property
    @pulumi.getter(name="filesLicenseInfo")
    def files_license_info(self) -> Sequence[str]:
        """
        Contain the license the SPDX file creator has concluded as governing the This field is to contain a list of all licenses found in the package. The relationship between licenses (i.e., conjunctive, disjunctive) is not specified in this field – it is simply a listing of all licenses found
        """
        return pulumi.get(self, "files_license_info")

    @property
    @pulumi.getter(name="homePage")
    def home_page(self) -> str:
        """
        Provide a place for the SPDX file creator to record a web site that serves as the package's home page
        """
        return pulumi.get(self, "home_page")

    @property
    @pulumi.getter(name="licenseDeclared")
    def license_declared(self) -> 'outputs.LicenseResponse':
        """
        List the licenses that have been declared by the authors of the package
        """
        return pulumi.get(self, "license_declared")

    @property
    @pulumi.getter
    def originator(self) -> str:
        """
        If the package identified in the SPDX file originated from a different person or organization than identified as Package Supplier, this field identifies from where or whom the package originally came
        """
        return pulumi.get(self, "originator")

    @property
    @pulumi.getter(name="packageType")
    def package_type(self) -> str:
        """
        The type of package: OS, MAVEN, GO, GO_STDLIB, etc.
        """
        return pulumi.get(self, "package_type")

    @property
    @pulumi.getter(name="summaryDescription")
    def summary_description(self) -> str:
        """
        A short description of the package
        """
        return pulumi.get(self, "summary_description")

    @property
    @pulumi.getter
    def supplier(self) -> str:
        """
        Identify the actual distribution source for the package/directory identified in the SPDX file
        """
        return pulumi.get(self, "supplier")

    @property
    @pulumi.getter
    def title(self) -> str:
        """
        Identify the full name of the package as given by the Package Originator
        """
        return pulumi.get(self, "title")

    @property
    @pulumi.getter(name="verificationCode")
    def verification_code(self) -> str:
        """
        This field provides an independently reproducible mechanism identifying specific contents of a package based on the actual files (except the SPDX file itself, if it is included in the package) that make up each package and that correlates to the data in this SPDX file
        """
        return pulumi.get(self, "verification_code")

    @property
    @pulumi.getter
    def version(self) -> str:
        """
        Identify the version of the package
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class PackageInfoOccurrenceResponse(dict):
    """
    PackageInfoOccurrence represents an SPDX Package Information section: https://spdx.github.io/spdx-spec/3-package-information/
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "homePage":
            suggest = "home_page"
        elif key == "licenseConcluded":
            suggest = "license_concluded"
        elif key == "packageType":
            suggest = "package_type"
        elif key == "sourceInfo":
            suggest = "source_info"
        elif key == "summaryDescription":
            suggest = "summary_description"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PackageInfoOccurrenceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PackageInfoOccurrenceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PackageInfoOccurrenceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 comment: str,
                 filename: str,
                 home_page: str,
                 license_concluded: 'outputs.LicenseResponse',
                 package_type: str,
                 source_info: str,
                 summary_description: str,
                 title: str,
                 version: str):
        """
        PackageInfoOccurrence represents an SPDX Package Information section: https://spdx.github.io/spdx-spec/3-package-information/
        :param str comment: A place for the SPDX file creator to record any general comments about the package being described
        :param str filename: Provide the actual file name of the package, or path of the directory being treated as a package
        :param str home_page: Provide a place for the SPDX file creator to record a web site that serves as the package's home page
        :param 'LicenseResponse' license_concluded: package or alternative values, if the governing license cannot be determined
        :param str package_type: The type of package: OS, MAVEN, GO, GO_STDLIB, etc.
        :param str source_info: Provide a place for the SPDX file creator to record any relevant background information or additional comments about the origin of the package
        :param str summary_description: A short description of the package
        :param str title: Identify the full name of the package as given by the Package Originator
        :param str version: Identify the version of the package
        """
        pulumi.set(__self__, "comment", comment)
        pulumi.set(__self__, "filename", filename)
        pulumi.set(__self__, "home_page", home_page)
        pulumi.set(__self__, "license_concluded", license_concluded)
        pulumi.set(__self__, "package_type", package_type)
        pulumi.set(__self__, "source_info", source_info)
        pulumi.set(__self__, "summary_description", summary_description)
        pulumi.set(__self__, "title", title)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def comment(self) -> str:
        """
        A place for the SPDX file creator to record any general comments about the package being described
        """
        return pulumi.get(self, "comment")

    @property
    @pulumi.getter
    def filename(self) -> str:
        """
        Provide the actual file name of the package, or path of the directory being treated as a package
        """
        return pulumi.get(self, "filename")

    @property
    @pulumi.getter(name="homePage")
    def home_page(self) -> str:
        """
        Provide a place for the SPDX file creator to record a web site that serves as the package's home page
        """
        return pulumi.get(self, "home_page")

    @property
    @pulumi.getter(name="licenseConcluded")
    def license_concluded(self) -> 'outputs.LicenseResponse':
        """
        package or alternative values, if the governing license cannot be determined
        """
        return pulumi.get(self, "license_concluded")

    @property
    @pulumi.getter(name="packageType")
    def package_type(self) -> str:
        """
        The type of package: OS, MAVEN, GO, GO_STDLIB, etc.
        """
        return pulumi.get(self, "package_type")

    @property
    @pulumi.getter(name="sourceInfo")
    def source_info(self) -> str:
        """
        Provide a place for the SPDX file creator to record any relevant background information or additional comments about the origin of the package
        """
        return pulumi.get(self, "source_info")

    @property
    @pulumi.getter(name="summaryDescription")
    def summary_description(self) -> str:
        """
        A short description of the package
        """
        return pulumi.get(self, "summary_description")

    @property
    @pulumi.getter
    def title(self) -> str:
        """
        Identify the full name of the package as given by the Package Originator
        """
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def version(self) -> str:
        """
        Identify the version of the package
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class PackageIssueResponse(dict):
    """
    This message wraps a location affected by a vulnerability and its associated fix (if one is available).
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "affectedLocation":
            suggest = "affected_location"
        elif key == "effectiveSeverity":
            suggest = "effective_severity"
        elif key == "fixedLocation":
            suggest = "fixed_location"
        elif key == "packageType":
            suggest = "package_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PackageIssueResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PackageIssueResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PackageIssueResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 affected_location: 'outputs.VulnerabilityLocationResponse',
                 effective_severity: str,
                 fixed_location: 'outputs.VulnerabilityLocationResponse',
                 package_type: str):
        """
        This message wraps a location affected by a vulnerability and its associated fix (if one is available).
        :param 'VulnerabilityLocationResponse' affected_location: The location of the vulnerability.
        :param str effective_severity: The distro or language system assigned severity for this vulnerability when that is available and note provider assigned severity when it is not available.
        :param 'VulnerabilityLocationResponse' fixed_location: The location of the available fix for vulnerability.
        :param str package_type: The type of package (e.g. OS, MAVEN, GO).
        """
        pulumi.set(__self__, "affected_location", affected_location)
        pulumi.set(__self__, "effective_severity", effective_severity)
        pulumi.set(__self__, "fixed_location", fixed_location)
        pulumi.set(__self__, "package_type", package_type)

    @property
    @pulumi.getter(name="affectedLocation")
    def affected_location(self) -> 'outputs.VulnerabilityLocationResponse':
        """
        The location of the vulnerability.
        """
        return pulumi.get(self, "affected_location")

    @property
    @pulumi.getter(name="effectiveSeverity")
    def effective_severity(self) -> str:
        """
        The distro or language system assigned severity for this vulnerability when that is available and note provider assigned severity when it is not available.
        """
        return pulumi.get(self, "effective_severity")

    @property
    @pulumi.getter(name="fixedLocation")
    def fixed_location(self) -> 'outputs.VulnerabilityLocationResponse':
        """
        The location of the available fix for vulnerability.
        """
        return pulumi.get(self, "fixed_location")

    @property
    @pulumi.getter(name="packageType")
    def package_type(self) -> str:
        """
        The type of package (e.g. OS, MAVEN, GO).
        """
        return pulumi.get(self, "package_type")


@pulumi.output_type
class PackageResponse(dict):
    """
    This represents a particular package that is distributed over various channels. E.g., glibc (aka libc6) is distributed by many, at various versions.
    """
    def __init__(__self__, *,
                 distribution: Sequence['outputs.DistributionResponse'],
                 name: str):
        """
        This represents a particular package that is distributed over various channels. E.g., glibc (aka libc6) is distributed by many, at various versions.
        :param Sequence['DistributionResponse'] distribution: The various channels by which a package is distributed.
        :param str name: Immutable. The name of the package.
        """
        pulumi.set(__self__, "distribution", distribution)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def distribution(self) -> Sequence['outputs.DistributionResponse']:
        """
        The various channels by which a package is distributed.
        """
        return pulumi.get(self, "distribution")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Immutable. The name of the package.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class PgpSignedAttestationResponse(dict):
    """
    An attestation wrapper with a PGP-compatible signature. This message only supports `ATTACHED` signatures, where the payload that is signed is included alongside the signature itself in the same file.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "contentType":
            suggest = "content_type"
        elif key == "pgpKeyId":
            suggest = "pgp_key_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PgpSignedAttestationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PgpSignedAttestationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PgpSignedAttestationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 content_type: str,
                 pgp_key_id: str,
                 signature: str):
        """
        An attestation wrapper with a PGP-compatible signature. This message only supports `ATTACHED` signatures, where the payload that is signed is included alongside the signature itself in the same file.
        :param str content_type: Type (for example schema) of the attestation payload that was signed. The verifier must ensure that the provided type is one that the verifier supports, and that the attestation payload is a valid instantiation of that type (for example by validating a JSON schema).
        :param str pgp_key_id: The cryptographic fingerprint of the key used to generate the signature, as output by, e.g. `gpg --list-keys`. This should be the version 4, full 160-bit fingerprint, expressed as a 40 character hexidecimal string. See https://tools.ietf.org/html/rfc4880#section-12.2 for details. Implementations may choose to acknowledge "LONG", "SHORT", or other abbreviated key IDs, but only the full fingerprint is guaranteed to work. In gpg, the full fingerprint can be retrieved from the `fpr` field returned when calling --list-keys with --with-colons. For example: ``` gpg --with-colons --with-fingerprint --force-v4-certs \ --list-keys attester@example.com tru::1:1513631572:0:3:1:5 pub:...... fpr:::::::::24FF6481B76AC91E66A00AC657A93A81EF3AE6FB: ``` Above, the fingerprint is `24FF6481B76AC91E66A00AC657A93A81EF3AE6FB`.
        :param str signature: The raw content of the signature, as output by GNU Privacy Guard (GPG) or equivalent. Since this message only supports attached signatures, the payload that was signed must be attached. While the signature format supported is dependent on the verification implementation, currently only ASCII-armored (`--armor` to gpg), non-clearsigned (`--sign` rather than `--clearsign` to gpg) are supported. Concretely, `gpg --sign --armor --output=signature.gpg payload.json` will create the signature content expected in this field in `signature.gpg` for the `payload.json` attestation payload.
        """
        pulumi.set(__self__, "content_type", content_type)
        pulumi.set(__self__, "pgp_key_id", pgp_key_id)
        pulumi.set(__self__, "signature", signature)

    @property
    @pulumi.getter(name="contentType")
    def content_type(self) -> str:
        """
        Type (for example schema) of the attestation payload that was signed. The verifier must ensure that the provided type is one that the verifier supports, and that the attestation payload is a valid instantiation of that type (for example by validating a JSON schema).
        """
        return pulumi.get(self, "content_type")

    @property
    @pulumi.getter(name="pgpKeyId")
    def pgp_key_id(self) -> str:
        """
        The cryptographic fingerprint of the key used to generate the signature, as output by, e.g. `gpg --list-keys`. This should be the version 4, full 160-bit fingerprint, expressed as a 40 character hexidecimal string. See https://tools.ietf.org/html/rfc4880#section-12.2 for details. Implementations may choose to acknowledge "LONG", "SHORT", or other abbreviated key IDs, but only the full fingerprint is guaranteed to work. In gpg, the full fingerprint can be retrieved from the `fpr` field returned when calling --list-keys with --with-colons. For example: ``` gpg --with-colons --with-fingerprint --force-v4-certs \ --list-keys attester@example.com tru::1:1513631572:0:3:1:5 pub:...... fpr:::::::::24FF6481B76AC91E66A00AC657A93A81EF3AE6FB: ``` Above, the fingerprint is `24FF6481B76AC91E66A00AC657A93A81EF3AE6FB`.
        """
        return pulumi.get(self, "pgp_key_id")

    @property
    @pulumi.getter
    def signature(self) -> str:
        """
        The raw content of the signature, as output by GNU Privacy Guard (GPG) or equivalent. Since this message only supports attached signatures, the payload that was signed must be attached. While the signature format supported is dependent on the verification implementation, currently only ASCII-armored (`--armor` to gpg), non-clearsigned (`--sign` rather than `--clearsign` to gpg) are supported. Concretely, `gpg --sign --armor --output=signature.gpg payload.json` will create the signature content expected in this field in `signature.gpg` for the `payload.json` attestation payload.
        """
        return pulumi.get(self, "signature")


@pulumi.output_type
class ProjectRepoIdResponse(dict):
    """
    Selects a repo using a Google Cloud Platform project ID (e.g., winged-cargo-31) and a repo name within that project.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "repoName":
            suggest = "repo_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProjectRepoIdResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProjectRepoIdResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProjectRepoIdResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 project: str,
                 repo_name: str):
        """
        Selects a repo using a Google Cloud Platform project ID (e.g., winged-cargo-31) and a repo name within that project.
        :param str project: The ID of the project.
        :param str repo_name: The name of the repo. Leave empty for the default repo.
        """
        pulumi.set(__self__, "project", project)
        pulumi.set(__self__, "repo_name", repo_name)

    @property
    @pulumi.getter
    def project(self) -> str:
        """
        The ID of the project.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="repoName")
    def repo_name(self) -> str:
        """
        The name of the repo. Leave empty for the default repo.
        """
        return pulumi.get(self, "repo_name")


@pulumi.output_type
class RelatedUrlResponse(dict):
    """
    Metadata for any related URL information.
    """
    def __init__(__self__, *,
                 label: str,
                 url: str):
        """
        Metadata for any related URL information.
        :param str label: Label to describe usage of the URL.
        :param str url: Specific URL associated with the resource.
        """
        pulumi.set(__self__, "label", label)
        pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter
    def label(self) -> str:
        """
        Label to describe usage of the URL.
        """
        return pulumi.get(self, "label")

    @property
    @pulumi.getter
    def url(self) -> str:
        """
        Specific URL associated with the resource.
        """
        return pulumi.get(self, "url")


@pulumi.output_type
class RelationshipNoteResponse(dict):
    """
    RelationshipNote represents an SPDX Relationship section: https://spdx.github.io/spdx-spec/7-relationships-between-SPDX-elements/
    """
    def __init__(__self__, *,
                 type: str):
        """
        RelationshipNote represents an SPDX Relationship section: https://spdx.github.io/spdx-spec/7-relationships-between-SPDX-elements/
        :param str type: The type of relationship between the source and target SPDX elements
        """
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of relationship between the source and target SPDX elements
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class RelationshipOccurrenceResponse(dict):
    """
    RelationshipOccurrence represents an SPDX Relationship section: https://spdx.github.io/spdx-spec/7-relationships-between-SPDX-elements/
    """
    def __init__(__self__, *,
                 comment: str,
                 source: str,
                 target: str,
                 type: str):
        """
        RelationshipOccurrence represents an SPDX Relationship section: https://spdx.github.io/spdx-spec/7-relationships-between-SPDX-elements/
        :param str comment: A place for the SPDX file creator to record any general comments about the relationship
        :param str source: Also referred to as SPDXRef-A The source SPDX element (file, package, etc)
        :param str target: Also referred to as SPDXRef-B The target SPDC element (file, package, etc) In cases where there are "known unknowns", the use of the keyword NOASSERTION can be used The keywords NONE can be used to indicate that an SPDX element (package/file/snippet) has no other elements connected by some relationship to it
        :param str type: The type of relationship between the source and target SPDX elements
        """
        pulumi.set(__self__, "comment", comment)
        pulumi.set(__self__, "source", source)
        pulumi.set(__self__, "target", target)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def comment(self) -> str:
        """
        A place for the SPDX file creator to record any general comments about the relationship
        """
        return pulumi.get(self, "comment")

    @property
    @pulumi.getter
    def source(self) -> str:
        """
        Also referred to as SPDXRef-A The source SPDX element (file, package, etc)
        """
        return pulumi.get(self, "source")

    @property
    @pulumi.getter
    def target(self) -> str:
        """
        Also referred to as SPDXRef-B The target SPDC element (file, package, etc) In cases where there are "known unknowns", the use of the keyword NOASSERTION can be used The keywords NONE can be used to indicate that an SPDX element (package/file/snippet) has no other elements connected by some relationship to it
        """
        return pulumi.get(self, "target")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of relationship between the source and target SPDX elements
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class RepoIdResponse(dict):
    """
    A unique identifier for a Cloud Repo.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "projectRepoId":
            suggest = "project_repo_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RepoIdResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RepoIdResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RepoIdResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 project_repo_id: 'outputs.ProjectRepoIdResponse',
                 uid: str):
        """
        A unique identifier for a Cloud Repo.
        :param 'ProjectRepoIdResponse' project_repo_id: A combination of a project ID and a repo name.
        :param str uid: A server-assigned, globally unique identifier.
        """
        pulumi.set(__self__, "project_repo_id", project_repo_id)
        pulumi.set(__self__, "uid", uid)

    @property
    @pulumi.getter(name="projectRepoId")
    def project_repo_id(self) -> 'outputs.ProjectRepoIdResponse':
        """
        A combination of a project ID and a repo name.
        """
        return pulumi.get(self, "project_repo_id")

    @property
    @pulumi.getter
    def uid(self) -> str:
        """
        A server-assigned, globally unique identifier.
        """
        return pulumi.get(self, "uid")


@pulumi.output_type
class ResourceResponse(dict):
    """
    An entity that can have metadata. For example, a Docker image.
    """
    def __init__(__self__, *,
                 uri: str):
        """
        An entity that can have metadata. For example, a Docker image.
        :param str uri: The unique URI of the resource. For example, `https://gcr.io/project/image@sha256:foo` for a Docker image.
        """
        pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter
    def uri(self) -> str:
        """
        The unique URI of the resource. For example, `https://gcr.io/project/image@sha256:foo` for a Docker image.
        """
        return pulumi.get(self, "uri")


@pulumi.output_type
class SignatureResponse(dict):
    """
    Verifiers (e.g. Kritis implementations) MUST verify signatures with respect to the trust anchors defined in policy (e.g. a Kritis policy). Typically this means that the verifier has been configured with a map from `public_key_id` to public key material (and any required parameters, e.g. signing algorithm). In particular, verification implementations MUST NOT treat the signature `public_key_id` as anything more than a key lookup hint. The `public_key_id` DOES NOT validate or authenticate a public key; it only provides a mechanism for quickly selecting a public key ALREADY CONFIGURED on the verifier through a trusted channel. Verification implementations MUST reject signatures in any of the following circumstances: * The `public_key_id` is not recognized by the verifier. * The public key that `public_key_id` refers to does not verify the signature with respect to the payload. The `signature` contents SHOULD NOT be "attached" (where the payload is included with the serialized `signature` bytes). Verifiers MUST ignore any "attached" payload and only verify signatures with respect to explicitly provided payload (e.g. a `payload` field on the proto message that holds this Signature, or the canonical serialization of the proto message that holds this signature).
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "publicKeyId":
            suggest = "public_key_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SignatureResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SignatureResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SignatureResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 public_key_id: str,
                 signature: str):
        """
        Verifiers (e.g. Kritis implementations) MUST verify signatures with respect to the trust anchors defined in policy (e.g. a Kritis policy). Typically this means that the verifier has been configured with a map from `public_key_id` to public key material (and any required parameters, e.g. signing algorithm). In particular, verification implementations MUST NOT treat the signature `public_key_id` as anything more than a key lookup hint. The `public_key_id` DOES NOT validate or authenticate a public key; it only provides a mechanism for quickly selecting a public key ALREADY CONFIGURED on the verifier through a trusted channel. Verification implementations MUST reject signatures in any of the following circumstances: * The `public_key_id` is not recognized by the verifier. * The public key that `public_key_id` refers to does not verify the signature with respect to the payload. The `signature` contents SHOULD NOT be "attached" (where the payload is included with the serialized `signature` bytes). Verifiers MUST ignore any "attached" payload and only verify signatures with respect to explicitly provided payload (e.g. a `payload` field on the proto message that holds this Signature, or the canonical serialization of the proto message that holds this signature).
        :param str public_key_id: The identifier for the public key that verifies this signature. * The `public_key_id` is required. * The `public_key_id` SHOULD be an RFC3986 conformant URI. * When possible, the `public_key_id` SHOULD be an immutable reference, such as a cryptographic digest. Examples of valid `public_key_id`s: OpenPGP V4 public key fingerprint: * "openpgp4fpr:74FAF3B861BDA0870C7B6DEF607E48D2A663AEEA" See https://www.iana.org/assignments/uri-schemes/prov/openpgp4fpr for more details on this scheme. RFC6920 digest-named SubjectPublicKeyInfo (digest of the DER serialization): * "ni:///sha-256;cD9o9Cq6LG3jD0iKXqEi_vdjJGecm_iXkbqVoScViaU" * "nih:///sha-256;703f68f42aba2c6de30f488a5ea122fef76324679c9bf89791ba95a1271589a5"
        :param str signature: The content of the signature, an opaque bytestring. The payload that this signature verifies MUST be unambiguously provided with the Signature during verification. A wrapper message might provide the payload explicitly. Alternatively, a message might have a canonical serialization that can always be unambiguously computed to derive the payload.
        """
        pulumi.set(__self__, "public_key_id", public_key_id)
        pulumi.set(__self__, "signature", signature)

    @property
    @pulumi.getter(name="publicKeyId")
    def public_key_id(self) -> str:
        """
        The identifier for the public key that verifies this signature. * The `public_key_id` is required. * The `public_key_id` SHOULD be an RFC3986 conformant URI. * When possible, the `public_key_id` SHOULD be an immutable reference, such as a cryptographic digest. Examples of valid `public_key_id`s: OpenPGP V4 public key fingerprint: * "openpgp4fpr:74FAF3B861BDA0870C7B6DEF607E48D2A663AEEA" See https://www.iana.org/assignments/uri-schemes/prov/openpgp4fpr for more details on this scheme. RFC6920 digest-named SubjectPublicKeyInfo (digest of the DER serialization): * "ni:///sha-256;cD9o9Cq6LG3jD0iKXqEi_vdjJGecm_iXkbqVoScViaU" * "nih:///sha-256;703f68f42aba2c6de30f488a5ea122fef76324679c9bf89791ba95a1271589a5"
        """
        return pulumi.get(self, "public_key_id")

    @property
    @pulumi.getter
    def signature(self) -> str:
        """
        The content of the signature, an opaque bytestring. The payload that this signature verifies MUST be unambiguously provided with the Signature during verification. A wrapper message might provide the payload explicitly. Alternatively, a message might have a canonical serialization that can always be unambiguously computed to derive the payload.
        """
        return pulumi.get(self, "signature")


@pulumi.output_type
class SigningKeyResponse(dict):
    """
    This defines the format used to record keys used in the software supply chain. An in-toto link is attested using one or more keys defined in the in-toto layout. An example of this is: { "key_id": "776a00e29f3559e0141b3b096f696abc6cfb0c657ab40f441132b345b0...", "key_type": "rsa", "public_key_value": "-----BEGIN PUBLIC KEY-----\nMIIBojANBgkqhkiG9w0B...", "key_scheme": "rsassa-pss-sha256" } The format for in-toto's key definition can be found in section 4.2 of the in-toto specification.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "keyId":
            suggest = "key_id"
        elif key == "keyScheme":
            suggest = "key_scheme"
        elif key == "keyType":
            suggest = "key_type"
        elif key == "publicKeyValue":
            suggest = "public_key_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SigningKeyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SigningKeyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SigningKeyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key_id: str,
                 key_scheme: str,
                 key_type: str,
                 public_key_value: str):
        """
        This defines the format used to record keys used in the software supply chain. An in-toto link is attested using one or more keys defined in the in-toto layout. An example of this is: { "key_id": "776a00e29f3559e0141b3b096f696abc6cfb0c657ab40f441132b345b0...", "key_type": "rsa", "public_key_value": "-----BEGIN PUBLIC KEY-----\nMIIBojANBgkqhkiG9w0B...", "key_scheme": "rsassa-pss-sha256" } The format for in-toto's key definition can be found in section 4.2 of the in-toto specification.
        :param str key_id: key_id is an identifier for the signing key.
        :param str key_scheme: This field contains the corresponding signature scheme. Eg: "rsassa-pss-sha256".
        :param str key_type: This field identifies the specific signing method. Eg: "rsa", "ed25519", and "ecdsa".
        :param str public_key_value: This field contains the actual public key.
        """
        pulumi.set(__self__, "key_id", key_id)
        pulumi.set(__self__, "key_scheme", key_scheme)
        pulumi.set(__self__, "key_type", key_type)
        pulumi.set(__self__, "public_key_value", public_key_value)

    @property
    @pulumi.getter(name="keyId")
    def key_id(self) -> str:
        """
        key_id is an identifier for the signing key.
        """
        return pulumi.get(self, "key_id")

    @property
    @pulumi.getter(name="keyScheme")
    def key_scheme(self) -> str:
        """
        This field contains the corresponding signature scheme. Eg: "rsassa-pss-sha256".
        """
        return pulumi.get(self, "key_scheme")

    @property
    @pulumi.getter(name="keyType")
    def key_type(self) -> str:
        """
        This field identifies the specific signing method. Eg: "rsa", "ed25519", and "ecdsa".
        """
        return pulumi.get(self, "key_type")

    @property
    @pulumi.getter(name="publicKeyValue")
    def public_key_value(self) -> str:
        """
        This field contains the actual public key.
        """
        return pulumi.get(self, "public_key_value")


@pulumi.output_type
class SourceContextResponse(dict):
    """
    A SourceContext is a reference to a tree of files. A SourceContext together with a path point to a unique revision of a single file or directory.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cloudRepo":
            suggest = "cloud_repo"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SourceContextResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SourceContextResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SourceContextResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cloud_repo: 'outputs.CloudRepoSourceContextResponse',
                 gerrit: 'outputs.GerritSourceContextResponse',
                 git: 'outputs.GitSourceContextResponse',
                 labels: Mapping[str, str]):
        """
        A SourceContext is a reference to a tree of files. A SourceContext together with a path point to a unique revision of a single file or directory.
        :param 'CloudRepoSourceContextResponse' cloud_repo: A SourceContext referring to a revision in a Google Cloud Source Repo.
        :param 'GerritSourceContextResponse' gerrit: A SourceContext referring to a Gerrit project.
        :param 'GitSourceContextResponse' git: A SourceContext referring to any third party Git repo (e.g., GitHub).
        :param Mapping[str, str] labels: Labels with user defined metadata.
        """
        pulumi.set(__self__, "cloud_repo", cloud_repo)
        pulumi.set(__self__, "gerrit", gerrit)
        pulumi.set(__self__, "git", git)
        pulumi.set(__self__, "labels", labels)

    @property
    @pulumi.getter(name="cloudRepo")
    def cloud_repo(self) -> 'outputs.CloudRepoSourceContextResponse':
        """
        A SourceContext referring to a revision in a Google Cloud Source Repo.
        """
        return pulumi.get(self, "cloud_repo")

    @property
    @pulumi.getter
    def gerrit(self) -> 'outputs.GerritSourceContextResponse':
        """
        A SourceContext referring to a Gerrit project.
        """
        return pulumi.get(self, "gerrit")

    @property
    @pulumi.getter
    def git(self) -> 'outputs.GitSourceContextResponse':
        """
        A SourceContext referring to any third party Git repo (e.g., GitHub).
        """
        return pulumi.get(self, "git")

    @property
    @pulumi.getter
    def labels(self) -> Mapping[str, str]:
        """
        Labels with user defined metadata.
        """
        return pulumi.get(self, "labels")


@pulumi.output_type
class SourceResponse(dict):
    """
    Source describes the location of the source used for the build.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "additionalContexts":
            suggest = "additional_contexts"
        elif key == "artifactStorageSourceUri":
            suggest = "artifact_storage_source_uri"
        elif key == "fileHashes":
            suggest = "file_hashes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SourceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SourceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SourceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 additional_contexts: Sequence['outputs.SourceContextResponse'],
                 artifact_storage_source_uri: str,
                 context: 'outputs.SourceContextResponse',
                 file_hashes: Mapping[str, str]):
        """
        Source describes the location of the source used for the build.
        :param Sequence['SourceContextResponse'] additional_contexts: If provided, some of the source code used for the build may be found in these locations, in the case where the source repository had multiple remotes or submodules. This list will not include the context specified in the context field.
        :param str artifact_storage_source_uri: If provided, the input binary artifacts for the build came from this location.
        :param 'SourceContextResponse' context: If provided, the source code used for the build came from this location.
        :param Mapping[str, str] file_hashes: Hash(es) of the build source, which can be used to verify that the original source integrity was maintained in the build. The keys to this map are file paths used as build source and the values contain the hash values for those files. If the build source came in a single package such as a gzipped tarfile (.tar.gz), the FileHash will be for the single path to that file.
        """
        pulumi.set(__self__, "additional_contexts", additional_contexts)
        pulumi.set(__self__, "artifact_storage_source_uri", artifact_storage_source_uri)
        pulumi.set(__self__, "context", context)
        pulumi.set(__self__, "file_hashes", file_hashes)

    @property
    @pulumi.getter(name="additionalContexts")
    def additional_contexts(self) -> Sequence['outputs.SourceContextResponse']:
        """
        If provided, some of the source code used for the build may be found in these locations, in the case where the source repository had multiple remotes or submodules. This list will not include the context specified in the context field.
        """
        return pulumi.get(self, "additional_contexts")

    @property
    @pulumi.getter(name="artifactStorageSourceUri")
    def artifact_storage_source_uri(self) -> str:
        """
        If provided, the input binary artifacts for the build came from this location.
        """
        return pulumi.get(self, "artifact_storage_source_uri")

    @property
    @pulumi.getter
    def context(self) -> 'outputs.SourceContextResponse':
        """
        If provided, the source code used for the build came from this location.
        """
        return pulumi.get(self, "context")

    @property
    @pulumi.getter(name="fileHashes")
    def file_hashes(self) -> Mapping[str, str]:
        """
        Hash(es) of the build source, which can be used to verify that the original source integrity was maintained in the build. The keys to this map are file paths used as build source and the values contain the hash values for those files. If the build source came in a single package such as a gzipped tarfile (.tar.gz), the FileHash will be for the single path to that file.
        """
        return pulumi.get(self, "file_hashes")


@pulumi.output_type
class StatusResponse(dict):
    """
    The `Status` type defines a logical error model that is suitable for different programming environments, including REST APIs and RPC APIs. It is used by [gRPC](https://github.com/grpc). Each `Status` message contains three pieces of data: error code, error message, and error details. You can find out more about this error model and how to work with it in the [API Design Guide](https://cloud.google.com/apis/design/errors).
    """
    def __init__(__self__, *,
                 code: int,
                 details: Sequence[Mapping[str, str]],
                 message: str):
        """
        The `Status` type defines a logical error model that is suitable for different programming environments, including REST APIs and RPC APIs. It is used by [gRPC](https://github.com/grpc). Each `Status` message contains three pieces of data: error code, error message, and error details. You can find out more about this error model and how to work with it in the [API Design Guide](https://cloud.google.com/apis/design/errors).
        :param int code: The status code, which should be an enum value of google.rpc.Code.
        :param Sequence[Mapping[str, str]] details: A list of messages that carry the error details. There is a common set of message types for APIs to use.
        :param str message: A developer-facing error message, which should be in English. Any user-facing error message should be localized and sent in the google.rpc.Status.details field, or localized by the client.
        """
        pulumi.set(__self__, "code", code)
        pulumi.set(__self__, "details", details)
        pulumi.set(__self__, "message", message)

    @property
    @pulumi.getter
    def code(self) -> int:
        """
        The status code, which should be an enum value of google.rpc.Code.
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter
    def details(self) -> Sequence[Mapping[str, str]]:
        """
        A list of messages that carry the error details. There is a common set of message types for APIs to use.
        """
        return pulumi.get(self, "details")

    @property
    @pulumi.getter
    def message(self) -> str:
        """
        A developer-facing error message, which should be in English. Any user-facing error message should be localized and sent in the google.rpc.Status.details field, or localized by the client.
        """
        return pulumi.get(self, "message")


@pulumi.output_type
class VersionResponse(dict):
    """
    Version contains structured information about the version of a package.
    """
    def __init__(__self__, *,
                 epoch: int,
                 inclusive: bool,
                 kind: str,
                 name: str,
                 revision: str):
        """
        Version contains structured information about the version of a package.
        :param int epoch: Used to correct mistakes in the version numbering scheme.
        :param bool inclusive: Whether this version is specifying part of an inclusive range. Grafeas does not have the capability to specify version ranges; instead we have fields that specify start version and end versions. At times this is insufficient - we also need to specify whether the version is included in the range or is excluded from the range. This boolean is expected to be set to true when the version is included in a range.
        :param str kind: Distinguishes between sentinel MIN/MAX versions and normal versions.
        :param str name: Required only when version kind is NORMAL. The main part of the version name.
        :param str revision: The iteration of the package build from the above version.
        """
        pulumi.set(__self__, "epoch", epoch)
        pulumi.set(__self__, "inclusive", inclusive)
        pulumi.set(__self__, "kind", kind)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "revision", revision)

    @property
    @pulumi.getter
    def epoch(self) -> int:
        """
        Used to correct mistakes in the version numbering scheme.
        """
        return pulumi.get(self, "epoch")

    @property
    @pulumi.getter
    def inclusive(self) -> bool:
        """
        Whether this version is specifying part of an inclusive range. Grafeas does not have the capability to specify version ranges; instead we have fields that specify start version and end versions. At times this is insufficient - we also need to specify whether the version is included in the range or is excluded from the range. This boolean is expected to be set to true when the version is included in a range.
        """
        return pulumi.get(self, "inclusive")

    @property
    @pulumi.getter
    def kind(self) -> str:
        """
        Distinguishes between sentinel MIN/MAX versions and normal versions.
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Required only when version kind is NORMAL. The main part of the version name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def revision(self) -> str:
        """
        The iteration of the package build from the above version.
        """
        return pulumi.get(self, "revision")


@pulumi.output_type
class VulnerabilityLocationResponse(dict):
    """
    The location of the vulnerability.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cpeUri":
            suggest = "cpe_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VulnerabilityLocationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VulnerabilityLocationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VulnerabilityLocationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cpe_uri: str,
                 package: str,
                 version: 'outputs.VersionResponse'):
        """
        The location of the vulnerability.
        :param str cpe_uri: The CPE URI in [cpe format](https://cpe.mitre.org/specification/) format. Examples include distro or storage location for vulnerable jar.
        :param str package: The package being described.
        :param 'VersionResponse' version: The version of the package being described.
        """
        pulumi.set(__self__, "cpe_uri", cpe_uri)
        pulumi.set(__self__, "package", package)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="cpeUri")
    def cpe_uri(self) -> str:
        """
        The CPE URI in [cpe format](https://cpe.mitre.org/specification/) format. Examples include distro or storage location for vulnerable jar.
        """
        return pulumi.get(self, "cpe_uri")

    @property
    @pulumi.getter
    def package(self) -> str:
        """
        The package being described.
        """
        return pulumi.get(self, "package")

    @property
    @pulumi.getter
    def version(self) -> 'outputs.VersionResponse':
        """
        The version of the package being described.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class VulnerabilityResponse(dict):
    """
    Vulnerability provides metadata about a security vulnerability in a Note.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cvssScore":
            suggest = "cvss_score"
        elif key == "cvssV3":
            suggest = "cvss_v3"
        elif key == "sourceUpdateTime":
            suggest = "source_update_time"
        elif key == "windowsDetails":
            suggest = "windows_details"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VulnerabilityResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VulnerabilityResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VulnerabilityResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cvss_score: float,
                 cvss_v3: 'outputs.CVSSv3Response',
                 details: Sequence['outputs.DetailResponse'],
                 severity: str,
                 source_update_time: str,
                 windows_details: Sequence['outputs.WindowsDetailResponse']):
        """
        Vulnerability provides metadata about a security vulnerability in a Note.
        :param float cvss_score: The CVSS score for this vulnerability.
        :param 'CVSSv3Response' cvss_v3: The full description of the CVSSv3.
        :param Sequence['DetailResponse'] details: All information about the package to specifically identify this vulnerability. One entry per (version range and cpe_uri) the package vulnerability has manifested in.
        :param str severity: Note provider assigned impact of the vulnerability.
        :param str source_update_time: The time this information was last changed at the source. This is an upstream timestamp from the underlying information source - e.g. Ubuntu security tracker.
        :param Sequence['WindowsDetailResponse'] windows_details: Windows details get their own format because the information format and model don't match a normal detail. Specifically Windows updates are done as patches, thus Windows vulnerabilities really are a missing package, rather than a package being at an incorrect version.
        """
        pulumi.set(__self__, "cvss_score", cvss_score)
        pulumi.set(__self__, "cvss_v3", cvss_v3)
        pulumi.set(__self__, "details", details)
        pulumi.set(__self__, "severity", severity)
        pulumi.set(__self__, "source_update_time", source_update_time)
        pulumi.set(__self__, "windows_details", windows_details)

    @property
    @pulumi.getter(name="cvssScore")
    def cvss_score(self) -> float:
        """
        The CVSS score for this vulnerability.
        """
        return pulumi.get(self, "cvss_score")

    @property
    @pulumi.getter(name="cvssV3")
    def cvss_v3(self) -> 'outputs.CVSSv3Response':
        """
        The full description of the CVSSv3.
        """
        return pulumi.get(self, "cvss_v3")

    @property
    @pulumi.getter
    def details(self) -> Sequence['outputs.DetailResponse']:
        """
        All information about the package to specifically identify this vulnerability. One entry per (version range and cpe_uri) the package vulnerability has manifested in.
        """
        return pulumi.get(self, "details")

    @property
    @pulumi.getter
    def severity(self) -> str:
        """
        Note provider assigned impact of the vulnerability.
        """
        return pulumi.get(self, "severity")

    @property
    @pulumi.getter(name="sourceUpdateTime")
    def source_update_time(self) -> str:
        """
        The time this information was last changed at the source. This is an upstream timestamp from the underlying information source - e.g. Ubuntu security tracker.
        """
        return pulumi.get(self, "source_update_time")

    @property
    @pulumi.getter(name="windowsDetails")
    def windows_details(self) -> Sequence['outputs.WindowsDetailResponse']:
        """
        Windows details get their own format because the information format and model don't match a normal detail. Specifically Windows updates are done as patches, thus Windows vulnerabilities really are a missing package, rather than a package being at an incorrect version.
        """
        return pulumi.get(self, "windows_details")


@pulumi.output_type
class WindowsDetailResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cpeUri":
            suggest = "cpe_uri"
        elif key == "fixingKbs":
            suggest = "fixing_kbs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WindowsDetailResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WindowsDetailResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WindowsDetailResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cpe_uri: str,
                 description: str,
                 fixing_kbs: Sequence['outputs.KnowledgeBaseResponse'],
                 name: str):
        """
        :param str cpe_uri: The CPE URI in [cpe format](https://cpe.mitre.org/specification/) in which the vulnerability manifests. Examples include distro or storage location for vulnerable jar.
        :param str description: The description of the vulnerability.
        :param Sequence['KnowledgeBaseResponse'] fixing_kbs: The names of the KBs which have hotfixes to mitigate this vulnerability. Note that there may be multiple hotfixes (and thus multiple KBs) that mitigate a given vulnerability. Currently any listed kb's presence is considered a fix.
        :param str name: The name of the vulnerability.
        """
        pulumi.set(__self__, "cpe_uri", cpe_uri)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "fixing_kbs", fixing_kbs)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="cpeUri")
    def cpe_uri(self) -> str:
        """
        The CPE URI in [cpe format](https://cpe.mitre.org/specification/) in which the vulnerability manifests. Examples include distro or storage location for vulnerable jar.
        """
        return pulumi.get(self, "cpe_uri")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description of the vulnerability.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="fixingKbs")
    def fixing_kbs(self) -> Sequence['outputs.KnowledgeBaseResponse']:
        """
        The names of the KBs which have hotfixes to mitigate this vulnerability. Note that there may be multiple hotfixes (and thus multiple KBs) that mitigate a given vulnerability. Currently any listed kb's presence is considered a fix.
        """
        return pulumi.get(self, "fixing_kbs")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the vulnerability.
        """
        return pulumi.get(self, "name")


