# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = [
    'AcceleratorConfigArgs',
    'AccessConfigArgs',
    'AdvancedMachineFeaturesArgs',
    'AliasIpRangeArgs',
    'AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDiskArgs',
    'AllocationSpecificSKUAllocationReservedInstancePropertiesArgs',
    'AllocationSpecificSKUReservationArgs',
    'AttachedDiskInitializeParamsArgs',
    'AttachedDiskArgs',
    'AuditConfigArgs',
    'AuditLogConfigArgs',
    'AuthorizationLoggingOptionsArgs',
    'AutoscalingPolicyCpuUtilizationArgs',
    'AutoscalingPolicyCustomMetricUtilizationArgs',
    'AutoscalingPolicyLoadBalancingUtilizationArgs',
    'AutoscalingPolicyScaleDownControlArgs',
    'AutoscalingPolicyScaleInControlArgs',
    'AutoscalingPolicyArgs',
    'BackendBucketCdnPolicyBypassCacheOnRequestHeaderArgs',
    'BackendBucketCdnPolicyCacheKeyPolicyArgs',
    'BackendBucketCdnPolicyNegativeCachingPolicyArgs',
    'BackendBucketCdnPolicyArgs',
    'BackendServiceCdnPolicyBypassCacheOnRequestHeaderArgs',
    'BackendServiceCdnPolicyNegativeCachingPolicyArgs',
    'BackendServiceCdnPolicyArgs',
    'BackendServiceConnectionTrackingPolicyArgs',
    'BackendServiceFailoverPolicyArgs',
    'BackendServiceIAPArgs',
    'BackendServiceLogConfigArgs',
    'BackendArgs',
    'BindingArgs',
    'CacheKeyPolicyArgs',
    'CircuitBreakersArgs',
    'ConditionArgs',
    'ConfidentialInstanceConfigArgs',
    'ConnectionDrainingArgs',
    'ConsistentHashLoadBalancerSettingsHttpCookieArgs',
    'ConsistentHashLoadBalancerSettingsArgs',
    'CorsPolicyArgs',
    'CustomerEncryptionKeyArgs',
    'DeprecationStatusArgs',
    'DiskInstantiationConfigArgs',
    'DisplayDeviceArgs',
    'DistributionPolicyZoneConfigurationArgs',
    'DistributionPolicyArgs',
    'DurationArgs',
    'ExprArgs',
    'ExternalVpnGatewayInterfaceArgs',
    'FileContentBufferArgs',
    'FirewallAllowedItemArgs',
    'FirewallDeniedItemArgs',
    'FirewallLogConfigArgs',
    'FirewallPolicyAssociationArgs',
    'FirewallPolicyRuleMatcherLayer4ConfigArgs',
    'FirewallPolicyRuleMatcherArgs',
    'FirewallPolicyRuleArgs',
    'FixedOrPercentArgs',
    'ForwardingRuleServiceDirectoryRegistrationArgs',
    'GRPCHealthCheckArgs',
    'GuestOsFeatureArgs',
    'HTTP2HealthCheckArgs',
    'HTTPHealthCheckArgs',
    'HTTPSHealthCheckArgs',
    'HealthCheckLogConfigArgs',
    'HostRuleArgs',
    'HttpFaultAbortArgs',
    'HttpFaultDelayArgs',
    'HttpFaultInjectionArgs',
    'HttpFilterConfigArgs',
    'HttpHeaderActionArgs',
    'HttpHeaderMatchArgs',
    'HttpHeaderOptionArgs',
    'HttpQueryParameterMatchArgs',
    'HttpRedirectActionArgs',
    'HttpRetryPolicyArgs',
    'HttpRouteActionArgs',
    'HttpRouteRuleMatchArgs',
    'HttpRouteRuleArgs',
    'ImageRawDiskArgs',
    'InitialStateConfigArgs',
    'InstanceGroupManagerAutoHealingPolicyArgs',
    'InstanceGroupManagerUpdatePolicyArgs',
    'InstanceGroupManagerVersionArgs',
    'InstanceParamsArgs',
    'InstancePropertiesArgs',
    'Int64RangeMatchArgs',
    'InterconnectAttachmentPartnerMetadataArgs',
    'LicenseResourceCommitmentArgs',
    'LicenseResourceRequirementsArgs',
    'LocalDiskArgs',
    'LogConfigCloudAuditOptionsArgs',
    'LogConfigCounterOptionsCustomFieldArgs',
    'LogConfigCounterOptionsArgs',
    'LogConfigDataAccessOptionsArgs',
    'LogConfigArgs',
    'MetadataFilterLabelMatchArgs',
    'MetadataFilterArgs',
    'MetadataItemsItemArgs',
    'MetadataArgs',
    'NamedPortArgs',
    'NetworkEndpointGroupAppEngineArgs',
    'NetworkEndpointGroupCloudFunctionArgs',
    'NetworkEndpointGroupCloudRunArgs',
    'NetworkEndpointGroupServerlessDeploymentArgs',
    'NetworkInterfaceArgs',
    'NetworkPerformanceConfigArgs',
    'NetworkRoutingConfigArgs',
    'NodeGroupAutoscalingPolicyArgs',
    'NodeGroupMaintenanceWindowArgs',
    'NodeTemplateNodeTypeFlexibilityArgs',
    'NotificationEndpointGrpcSettingsArgs',
    'OutlierDetectionArgs',
    'PacketMirroringFilterArgs',
    'PacketMirroringForwardingRuleInfoArgs',
    'PacketMirroringMirroredResourceInfoInstanceInfoArgs',
    'PacketMirroringMirroredResourceInfoSubnetInfoArgs',
    'PacketMirroringMirroredResourceInfoArgs',
    'PacketMirroringNetworkInfoArgs',
    'PathMatcherArgs',
    'PathRuleArgs',
    'PublicDelegatedPrefixPublicDelegatedSubPrefixArgs',
    'RequestMirrorPolicyArgs',
    'ReservationAffinityArgs',
    'ReservationArgs',
    'ResourceCommitmentArgs',
    'ResourcePolicyDailyCycleArgs',
    'ResourcePolicyGroupPlacementPolicyArgs',
    'ResourcePolicyHourlyCycleArgs',
    'ResourcePolicyInstanceSchedulePolicyScheduleArgs',
    'ResourcePolicyInstanceSchedulePolicyArgs',
    'ResourcePolicySnapshotSchedulePolicyRetentionPolicyArgs',
    'ResourcePolicySnapshotSchedulePolicyScheduleArgs',
    'ResourcePolicySnapshotSchedulePolicySnapshotPropertiesArgs',
    'ResourcePolicySnapshotSchedulePolicyArgs',
    'ResourcePolicyWeeklyCycleDayOfWeekArgs',
    'ResourcePolicyWeeklyCycleArgs',
    'RolloutPolicyArgs',
    'RouterAdvertisedIpRangeArgs',
    'RouterBgpPeerBfdArgs',
    'RouterBgpPeerArgs',
    'RouterBgpArgs',
    'RouterInterfaceArgs',
    'RouterNatLogConfigArgs',
    'RouterNatRuleActionArgs',
    'RouterNatRuleArgs',
    'RouterNatSubnetworkToNatArgs',
    'RouterNatArgs',
    'RuleArgs',
    'SSLHealthCheckArgs',
    'SavedDiskArgs',
    'SchedulingNodeAffinityArgs',
    'SchedulingArgs',
    'SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfigArgs',
    'SecurityPolicyAdaptiveProtectionConfigArgs',
    'SecurityPolicyAdvancedOptionsConfigArgs',
    'SecurityPolicyAssociationArgs',
    'SecurityPolicyRecaptchaOptionsConfigArgs',
    'SecurityPolicyRuleHttpHeaderActionHttpHeaderOptionArgs',
    'SecurityPolicyRuleHttpHeaderActionArgs',
    'SecurityPolicyRuleMatcherConfigLayer4ConfigArgs',
    'SecurityPolicyRuleMatcherConfigArgs',
    'SecurityPolicyRuleMatcherArgs',
    'SecurityPolicyRuleRateLimitOptionsThresholdArgs',
    'SecurityPolicyRuleRateLimitOptionsArgs',
    'SecurityPolicyRuleRedirectOptionsArgs',
    'SecurityPolicyRuleArgs',
    'SecuritySettingsArgs',
    'ServerBindingArgs',
    'ServiceAccountArgs',
    'ServiceAttachmentConsumerProjectLimitArgs',
    'ShareSettingsArgs',
    'ShieldedInstanceConfigArgs',
    'ShieldedInstanceIntegrityPolicyArgs',
    'ShieldedVmConfigArgs',
    'ShieldedVmIntegrityPolicyArgs',
    'SourceDiskEncryptionKeyArgs',
    'SourceInstanceParamsArgs',
    'SslCertificateManagedSslCertificateArgs',
    'SslCertificateSelfManagedSslCertificateArgs',
    'StatefulPolicyPreservedStateArgs',
    'StatefulPolicyArgs',
    'SubnetworkLogConfigArgs',
    'SubnetworkSecondaryRangeArgs',
    'SubsettingArgs',
    'TCPHealthCheckArgs',
    'TagsArgs',
    'UrlMapTestHeaderArgs',
    'UrlMapTestArgs',
    'UrlRewriteArgs',
    'VpnGatewayVpnGatewayInterfaceArgs',
    'WeightedBackendServiceArgs',
]

@pulumi.input_type
class AcceleratorConfigArgs:
    def __init__(__self__, *,
                 accelerator_count: Optional[pulumi.Input[int]] = None,
                 accelerator_type: Optional[pulumi.Input[str]] = None):
        """
        A specification of the type and number of accelerator cards attached to the instance.
        :param pulumi.Input[int] accelerator_count: The number of the guest accelerator cards exposed to this instance.
        :param pulumi.Input[str] accelerator_type: Full or partial URL of the accelerator type resource to attach to this instance. For example: projects/my-project/zones/us-central1-c/acceleratorTypes/nvidia-tesla-p100 If you are creating an instance template, specify only the accelerator name. See GPUs on Compute Engine for a full list of accelerator types.
        """
        if accelerator_count is not None:
            pulumi.set(__self__, "accelerator_count", accelerator_count)
        if accelerator_type is not None:
            pulumi.set(__self__, "accelerator_type", accelerator_type)

    @property
    @pulumi.getter(name="acceleratorCount")
    def accelerator_count(self) -> Optional[pulumi.Input[int]]:
        """
        The number of the guest accelerator cards exposed to this instance.
        """
        return pulumi.get(self, "accelerator_count")

    @accelerator_count.setter
    def accelerator_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "accelerator_count", value)

    @property
    @pulumi.getter(name="acceleratorType")
    def accelerator_type(self) -> Optional[pulumi.Input[str]]:
        """
        Full or partial URL of the accelerator type resource to attach to this instance. For example: projects/my-project/zones/us-central1-c/acceleratorTypes/nvidia-tesla-p100 If you are creating an instance template, specify only the accelerator name. See GPUs on Compute Engine for a full list of accelerator types.
        """
        return pulumi.get(self, "accelerator_type")

    @accelerator_type.setter
    def accelerator_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "accelerator_type", value)


@pulumi.input_type
class AccessConfigArgs:
    def __init__(__self__, *,
                 external_ipv6: Optional[pulumi.Input[str]] = None,
                 external_ipv6_prefix_length: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 nat_ip: Optional[pulumi.Input[str]] = None,
                 network_tier: Optional[pulumi.Input['AccessConfigNetworkTier']] = None,
                 public_ptr_domain_name: Optional[pulumi.Input[str]] = None,
                 set_public_ptr: Optional[pulumi.Input[bool]] = None,
                 type: Optional[pulumi.Input['AccessConfigType']] = None):
        """
        An access configuration attached to an instance's network interface. Only one access config per instance is supported.
        :param pulumi.Input[str] external_ipv6: The first IPv6 address of the external IPv6 range associated with this instance, prefix length is stored in externalIpv6PrefixLength in ipv6AccessConfig. The field is output only, an IPv6 address from a subnetwork associated with the instance will be allocated dynamically.
        :param pulumi.Input[int] external_ipv6_prefix_length: The prefix length of the external IPv6 range.
        :param pulumi.Input[str] name: The name of this access configuration. The default and recommended name is External NAT, but you can use any arbitrary string, such as My external IP or Network Access.
        :param pulumi.Input[str] nat_ip: An external IP address associated with this instance. Specify an unused static external IP address available to the project or leave this field undefined to use an IP from a shared ephemeral IP address pool. If you specify a static external IP address, it must live in the same region as the zone of the instance.
        :param pulumi.Input['AccessConfigNetworkTier'] network_tier: This signifies the networking tier used for configuring this access configuration and can only take the following values: PREMIUM, STANDARD. If an AccessConfig is specified without a valid external IP address, an ephemeral IP will be created with this networkTier. If an AccessConfig with a valid external IP address is specified, it must match that of the networkTier associated with the Address resource owning that IP.
        :param pulumi.Input[str] public_ptr_domain_name: The DNS domain name for the public PTR record. You can set this field only if the `setPublicPtr` field is enabled in accessConfig. If this field is unspecified in ipv6AccessConfig, a default PTR record will be createc for first IP in associated external IPv6 range.
        :param pulumi.Input[bool] set_public_ptr: Specifies whether a public DNS 'PTR' record should be created to map the external IP address of the instance to a DNS domain name. This field is not used in ipv6AccessConfig. A default PTR record will be created if the VM has external IPv6 range associated.
        :param pulumi.Input['AccessConfigType'] type: The type of configuration. The default and only option is ONE_TO_ONE_NAT.
        """
        if external_ipv6 is not None:
            pulumi.set(__self__, "external_ipv6", external_ipv6)
        if external_ipv6_prefix_length is not None:
            pulumi.set(__self__, "external_ipv6_prefix_length", external_ipv6_prefix_length)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if nat_ip is not None:
            pulumi.set(__self__, "nat_ip", nat_ip)
        if network_tier is not None:
            pulumi.set(__self__, "network_tier", network_tier)
        if public_ptr_domain_name is not None:
            pulumi.set(__self__, "public_ptr_domain_name", public_ptr_domain_name)
        if set_public_ptr is not None:
            pulumi.set(__self__, "set_public_ptr", set_public_ptr)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="externalIpv6")
    def external_ipv6(self) -> Optional[pulumi.Input[str]]:
        """
        The first IPv6 address of the external IPv6 range associated with this instance, prefix length is stored in externalIpv6PrefixLength in ipv6AccessConfig. The field is output only, an IPv6 address from a subnetwork associated with the instance will be allocated dynamically.
        """
        return pulumi.get(self, "external_ipv6")

    @external_ipv6.setter
    def external_ipv6(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "external_ipv6", value)

    @property
    @pulumi.getter(name="externalIpv6PrefixLength")
    def external_ipv6_prefix_length(self) -> Optional[pulumi.Input[int]]:
        """
        The prefix length of the external IPv6 range.
        """
        return pulumi.get(self, "external_ipv6_prefix_length")

    @external_ipv6_prefix_length.setter
    def external_ipv6_prefix_length(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "external_ipv6_prefix_length", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of this access configuration. The default and recommended name is External NAT, but you can use any arbitrary string, such as My external IP or Network Access.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="natIP")
    def nat_ip(self) -> Optional[pulumi.Input[str]]:
        """
        An external IP address associated with this instance. Specify an unused static external IP address available to the project or leave this field undefined to use an IP from a shared ephemeral IP address pool. If you specify a static external IP address, it must live in the same region as the zone of the instance.
        """
        return pulumi.get(self, "nat_ip")

    @nat_ip.setter
    def nat_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "nat_ip", value)

    @property
    @pulumi.getter(name="networkTier")
    def network_tier(self) -> Optional[pulumi.Input['AccessConfigNetworkTier']]:
        """
        This signifies the networking tier used for configuring this access configuration and can only take the following values: PREMIUM, STANDARD. If an AccessConfig is specified without a valid external IP address, an ephemeral IP will be created with this networkTier. If an AccessConfig with a valid external IP address is specified, it must match that of the networkTier associated with the Address resource owning that IP.
        """
        return pulumi.get(self, "network_tier")

    @network_tier.setter
    def network_tier(self, value: Optional[pulumi.Input['AccessConfigNetworkTier']]):
        pulumi.set(self, "network_tier", value)

    @property
    @pulumi.getter(name="publicPtrDomainName")
    def public_ptr_domain_name(self) -> Optional[pulumi.Input[str]]:
        """
        The DNS domain name for the public PTR record. You can set this field only if the `setPublicPtr` field is enabled in accessConfig. If this field is unspecified in ipv6AccessConfig, a default PTR record will be createc for first IP in associated external IPv6 range.
        """
        return pulumi.get(self, "public_ptr_domain_name")

    @public_ptr_domain_name.setter
    def public_ptr_domain_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "public_ptr_domain_name", value)

    @property
    @pulumi.getter(name="setPublicPtr")
    def set_public_ptr(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether a public DNS 'PTR' record should be created to map the external IP address of the instance to a DNS domain name. This field is not used in ipv6AccessConfig. A default PTR record will be created if the VM has external IPv6 range associated.
        """
        return pulumi.get(self, "set_public_ptr")

    @set_public_ptr.setter
    def set_public_ptr(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "set_public_ptr", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input['AccessConfigType']]:
        """
        The type of configuration. The default and only option is ONE_TO_ONE_NAT.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input['AccessConfigType']]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class AdvancedMachineFeaturesArgs:
    def __init__(__self__, *,
                 enable_nested_virtualization: Optional[pulumi.Input[bool]] = None,
                 threads_per_core: Optional[pulumi.Input[int]] = None):
        """
        Specifies options for controlling advanced machine features. Options that would traditionally be configured in a BIOS belong here. Features that require operating system support may have corresponding entries in the GuestOsFeatures of an Image (e.g., whether or not the OS in the Image supports nested virtualization being enabled or disabled).
        :param pulumi.Input[bool] enable_nested_virtualization: Whether to enable nested virtualization or not (default is false).
        :param pulumi.Input[int] threads_per_core: The number of threads per physical core. To disable simultaneous multithreading (SMT) set this to 1. If unset, the maximum number of threads supported per core by the underlying processor is assumed.
        """
        if enable_nested_virtualization is not None:
            pulumi.set(__self__, "enable_nested_virtualization", enable_nested_virtualization)
        if threads_per_core is not None:
            pulumi.set(__self__, "threads_per_core", threads_per_core)

    @property
    @pulumi.getter(name="enableNestedVirtualization")
    def enable_nested_virtualization(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to enable nested virtualization or not (default is false).
        """
        return pulumi.get(self, "enable_nested_virtualization")

    @enable_nested_virtualization.setter
    def enable_nested_virtualization(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_nested_virtualization", value)

    @property
    @pulumi.getter(name="threadsPerCore")
    def threads_per_core(self) -> Optional[pulumi.Input[int]]:
        """
        The number of threads per physical core. To disable simultaneous multithreading (SMT) set this to 1. If unset, the maximum number of threads supported per core by the underlying processor is assumed.
        """
        return pulumi.get(self, "threads_per_core")

    @threads_per_core.setter
    def threads_per_core(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "threads_per_core", value)


@pulumi.input_type
class AliasIpRangeArgs:
    def __init__(__self__, *,
                 ip_cidr_range: Optional[pulumi.Input[str]] = None,
                 subnetwork_range_name: Optional[pulumi.Input[str]] = None):
        """
        An alias IP range attached to an instance's network interface.
        :param pulumi.Input[str] ip_cidr_range: The IP alias ranges to allocate for this interface. This IP CIDR range must belong to the specified subnetwork and cannot contain IP addresses reserved by system or used by other network interfaces. This range may be a single IP address (such as 10.2.3.4), a netmask (such as /24) or a CIDR-formatted string (such as 10.1.2.0/24).
        :param pulumi.Input[str] subnetwork_range_name: The name of a subnetwork secondary IP range from which to allocate an IP alias range. If not specified, the primary range of the subnetwork is used.
        """
        if ip_cidr_range is not None:
            pulumi.set(__self__, "ip_cidr_range", ip_cidr_range)
        if subnetwork_range_name is not None:
            pulumi.set(__self__, "subnetwork_range_name", subnetwork_range_name)

    @property
    @pulumi.getter(name="ipCidrRange")
    def ip_cidr_range(self) -> Optional[pulumi.Input[str]]:
        """
        The IP alias ranges to allocate for this interface. This IP CIDR range must belong to the specified subnetwork and cannot contain IP addresses reserved by system or used by other network interfaces. This range may be a single IP address (such as 10.2.3.4), a netmask (such as /24) or a CIDR-formatted string (such as 10.1.2.0/24).
        """
        return pulumi.get(self, "ip_cidr_range")

    @ip_cidr_range.setter
    def ip_cidr_range(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip_cidr_range", value)

    @property
    @pulumi.getter(name="subnetworkRangeName")
    def subnetwork_range_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of a subnetwork secondary IP range from which to allocate an IP alias range. If not specified, the primary range of the subnetwork is used.
        """
        return pulumi.get(self, "subnetwork_range_name")

    @subnetwork_range_name.setter
    def subnetwork_range_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnetwork_range_name", value)


@pulumi.input_type
class AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDiskArgs:
    def __init__(__self__, *,
                 disk_size_gb: Optional[pulumi.Input[str]] = None,
                 interface: Optional[pulumi.Input['AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDiskInterface']] = None):
        """
        :param pulumi.Input[str] disk_size_gb: Specifies the size of the disk in base-2 GB.
        :param pulumi.Input['AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDiskInterface'] interface: Specifies the disk interface to use for attaching this disk, which is either SCSI or NVME. The default is SCSI. For performance characteristics of SCSI over NVMe, see Local SSD performance.
        """
        if disk_size_gb is not None:
            pulumi.set(__self__, "disk_size_gb", disk_size_gb)
        if interface is not None:
            pulumi.set(__self__, "interface", interface)

    @property
    @pulumi.getter(name="diskSizeGb")
    def disk_size_gb(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the size of the disk in base-2 GB.
        """
        return pulumi.get(self, "disk_size_gb")

    @disk_size_gb.setter
    def disk_size_gb(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "disk_size_gb", value)

    @property
    @pulumi.getter
    def interface(self) -> Optional[pulumi.Input['AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDiskInterface']]:
        """
        Specifies the disk interface to use for attaching this disk, which is either SCSI or NVME. The default is SCSI. For performance characteristics of SCSI over NVMe, see Local SSD performance.
        """
        return pulumi.get(self, "interface")

    @interface.setter
    def interface(self, value: Optional[pulumi.Input['AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDiskInterface']]):
        pulumi.set(self, "interface", value)


@pulumi.input_type
class AllocationSpecificSKUAllocationReservedInstancePropertiesArgs:
    def __init__(__self__, *,
                 guest_accelerators: Optional[pulumi.Input[Sequence[pulumi.Input['AcceleratorConfigArgs']]]] = None,
                 local_ssds: Optional[pulumi.Input[Sequence[pulumi.Input['AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDiskArgs']]]] = None,
                 location_hint: Optional[pulumi.Input[str]] = None,
                 machine_type: Optional[pulumi.Input[str]] = None,
                 maintenance_freeze_duration_hours: Optional[pulumi.Input[int]] = None,
                 maintenance_interval: Optional[pulumi.Input['AllocationSpecificSKUAllocationReservedInstancePropertiesMaintenanceInterval']] = None,
                 min_cpu_platform: Optional[pulumi.Input[str]] = None):
        """
        Properties of the SKU instances being reserved. Next ID: 9
        :param pulumi.Input[Sequence[pulumi.Input['AcceleratorConfigArgs']]] guest_accelerators: Specifies accelerator type and count.
        :param pulumi.Input[Sequence[pulumi.Input['AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDiskArgs']]] local_ssds: Specifies amount of local ssd to reserve with each instance. The type of disk is local-ssd.
        :param pulumi.Input[str] location_hint: An opaque location hint used to place the allocation close to other resources. This field is for use by internal tools that use the public API.
        :param pulumi.Input[str] machine_type: Specifies type of machine (name only) which has fixed number of vCPUs and fixed amount of memory. This also includes specifying custom machine type following custom-NUMBER_OF_CPUS-AMOUNT_OF_MEMORY pattern.
        :param pulumi.Input[int] maintenance_freeze_duration_hours: Specifies the number of hours after reservation creation where instances using the reservation won't be scheduled for maintenance.
        :param pulumi.Input['AllocationSpecificSKUAllocationReservedInstancePropertiesMaintenanceInterval'] maintenance_interval: For more information about maintenance intervals, see Setting maintenance intervals.
        :param pulumi.Input[str] min_cpu_platform: Minimum cpu platform the reservation.
        """
        if guest_accelerators is not None:
            pulumi.set(__self__, "guest_accelerators", guest_accelerators)
        if local_ssds is not None:
            pulumi.set(__self__, "local_ssds", local_ssds)
        if location_hint is not None:
            pulumi.set(__self__, "location_hint", location_hint)
        if machine_type is not None:
            pulumi.set(__self__, "machine_type", machine_type)
        if maintenance_freeze_duration_hours is not None:
            pulumi.set(__self__, "maintenance_freeze_duration_hours", maintenance_freeze_duration_hours)
        if maintenance_interval is not None:
            pulumi.set(__self__, "maintenance_interval", maintenance_interval)
        if min_cpu_platform is not None:
            pulumi.set(__self__, "min_cpu_platform", min_cpu_platform)

    @property
    @pulumi.getter(name="guestAccelerators")
    def guest_accelerators(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AcceleratorConfigArgs']]]]:
        """
        Specifies accelerator type and count.
        """
        return pulumi.get(self, "guest_accelerators")

    @guest_accelerators.setter
    def guest_accelerators(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AcceleratorConfigArgs']]]]):
        pulumi.set(self, "guest_accelerators", value)

    @property
    @pulumi.getter(name="localSsds")
    def local_ssds(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDiskArgs']]]]:
        """
        Specifies amount of local ssd to reserve with each instance. The type of disk is local-ssd.
        """
        return pulumi.get(self, "local_ssds")

    @local_ssds.setter
    def local_ssds(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDiskArgs']]]]):
        pulumi.set(self, "local_ssds", value)

    @property
    @pulumi.getter(name="locationHint")
    def location_hint(self) -> Optional[pulumi.Input[str]]:
        """
        An opaque location hint used to place the allocation close to other resources. This field is for use by internal tools that use the public API.
        """
        return pulumi.get(self, "location_hint")

    @location_hint.setter
    def location_hint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location_hint", value)

    @property
    @pulumi.getter(name="machineType")
    def machine_type(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies type of machine (name only) which has fixed number of vCPUs and fixed amount of memory. This also includes specifying custom machine type following custom-NUMBER_OF_CPUS-AMOUNT_OF_MEMORY pattern.
        """
        return pulumi.get(self, "machine_type")

    @machine_type.setter
    def machine_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "machine_type", value)

    @property
    @pulumi.getter(name="maintenanceFreezeDurationHours")
    def maintenance_freeze_duration_hours(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the number of hours after reservation creation where instances using the reservation won't be scheduled for maintenance.
        """
        return pulumi.get(self, "maintenance_freeze_duration_hours")

    @maintenance_freeze_duration_hours.setter
    def maintenance_freeze_duration_hours(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "maintenance_freeze_duration_hours", value)

    @property
    @pulumi.getter(name="maintenanceInterval")
    def maintenance_interval(self) -> Optional[pulumi.Input['AllocationSpecificSKUAllocationReservedInstancePropertiesMaintenanceInterval']]:
        """
        For more information about maintenance intervals, see Setting maintenance intervals.
        """
        return pulumi.get(self, "maintenance_interval")

    @maintenance_interval.setter
    def maintenance_interval(self, value: Optional[pulumi.Input['AllocationSpecificSKUAllocationReservedInstancePropertiesMaintenanceInterval']]):
        pulumi.set(self, "maintenance_interval", value)

    @property
    @pulumi.getter(name="minCpuPlatform")
    def min_cpu_platform(self) -> Optional[pulumi.Input[str]]:
        """
        Minimum cpu platform the reservation.
        """
        return pulumi.get(self, "min_cpu_platform")

    @min_cpu_platform.setter
    def min_cpu_platform(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "min_cpu_platform", value)


@pulumi.input_type
class AllocationSpecificSKUReservationArgs:
    def __init__(__self__, *,
                 count: Optional[pulumi.Input[str]] = None,
                 instance_properties: Optional[pulumi.Input['AllocationSpecificSKUAllocationReservedInstancePropertiesArgs']] = None):
        """
        This reservation type allows to pre allocate specific instance configuration. Next ID: 5
        :param pulumi.Input[str] count: Specifies the number of resources that are allocated.
        :param pulumi.Input['AllocationSpecificSKUAllocationReservedInstancePropertiesArgs'] instance_properties: The instance properties for the reservation.
        """
        if count is not None:
            pulumi.set(__self__, "count", count)
        if instance_properties is not None:
            pulumi.set(__self__, "instance_properties", instance_properties)

    @property
    @pulumi.getter
    def count(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the number of resources that are allocated.
        """
        return pulumi.get(self, "count")

    @count.setter
    def count(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "count", value)

    @property
    @pulumi.getter(name="instanceProperties")
    def instance_properties(self) -> Optional[pulumi.Input['AllocationSpecificSKUAllocationReservedInstancePropertiesArgs']]:
        """
        The instance properties for the reservation.
        """
        return pulumi.get(self, "instance_properties")

    @instance_properties.setter
    def instance_properties(self, value: Optional[pulumi.Input['AllocationSpecificSKUAllocationReservedInstancePropertiesArgs']]):
        pulumi.set(self, "instance_properties", value)


@pulumi.input_type
class AttachedDiskInitializeParamsArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 disk_name: Optional[pulumi.Input[str]] = None,
                 disk_size_gb: Optional[pulumi.Input[str]] = None,
                 disk_type: Optional[pulumi.Input[str]] = None,
                 guest_os_features: Optional[pulumi.Input[Sequence[pulumi.Input['GuestOsFeatureArgs']]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 licenses: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 multi_writer: Optional[pulumi.Input[bool]] = None,
                 on_update_action: Optional[pulumi.Input['AttachedDiskInitializeParamsOnUpdateAction']] = None,
                 provisioned_iops: Optional[pulumi.Input[str]] = None,
                 resource_policies: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 source_image: Optional[pulumi.Input[str]] = None,
                 source_image_encryption_key: Optional[pulumi.Input['CustomerEncryptionKeyArgs']] = None,
                 source_snapshot: Optional[pulumi.Input[str]] = None,
                 source_snapshot_encryption_key: Optional[pulumi.Input['CustomerEncryptionKeyArgs']] = None):
        """
        [Input Only] Specifies the parameters for a new disk that will be created alongside the new instance. Use initialization parameters to create boot disks or local SSDs attached to the new instance. This property is mutually exclusive with the source property; you can only define one or the other, but not both.
        :param pulumi.Input[str] description: An optional description. Provide this property when creating the disk.
        :param pulumi.Input[str] disk_name: Specifies the disk name. If not specified, the default is to use the name of the instance. If a disk with the same name already exists in the given region, the existing disk is attached to the new instance and the new disk is not created.
        :param pulumi.Input[str] disk_size_gb: Specifies the size of the disk in base-2 GB. The size must be at least 10 GB. If you specify a sourceImage, which is required for boot disks, the default size is the size of the sourceImage. If you do not specify a sourceImage, the default disk size is 500 GB.
        :param pulumi.Input[str] disk_type: Specifies the disk type to use to create the instance. If not specified, the default is pd-standard, specified using the full URL. For example: https://www.googleapis.com/compute/v1/projects/project/zones/zone /diskTypes/pd-standard For a full list of acceptable values, see Persistent disk types. If you define this field, you can provide either the full or partial URL. For example, the following are valid values: - https://www.googleapis.com/compute/v1/projects/project/zones/zone /diskTypes/diskType - projects/project/zones/zone/diskTypes/diskType - zones/zone/diskTypes/diskType Note that for InstanceTemplate, this is the name of the disk type, not URL.
        :param pulumi.Input[Sequence[pulumi.Input['GuestOsFeatureArgs']]] guest_os_features: A list of features to enable on the guest operating system. Applicable only for bootable images. Read Enabling guest operating system features to see a list of available options. Guest OS features are applied by merging initializeParams.guestOsFeatures and disks.guestOsFeatures
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Labels to apply to this disk. These can be later modified by the disks.setLabels method. This field is only applicable for persistent disks.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] licenses: A list of publicly visible licenses. Reserved for Google's use.
        :param pulumi.Input[bool] multi_writer: Indicates whether or not the disk can be read/write attached to more than one instance.
        :param pulumi.Input['AttachedDiskInitializeParamsOnUpdateAction'] on_update_action: Specifies which action to take on instance update with this disk. Default is to use the existing disk.
        :param pulumi.Input[str] provisioned_iops: Indicates how many IOPS to provision for the disk. This sets the number of I/O operations per second that the disk can handle. Values must be between 10,000 and 120,000. For more details, see the Extreme persistent disk documentation.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] resource_policies: Resource policies applied to this disk for automatic snapshot creations. Specified using the full or partial URL. For instance template, specify only the resource policy name.
        :param pulumi.Input[str] source_image: The source image to create this disk. When creating a new instance, one of initializeParams.sourceImage or initializeParams.sourceSnapshot or disks.source is required except for local SSD. To create a disk with one of the public operating system images, specify the image by its family name. For example, specify family/debian-9 to use the latest Debian 9 image: projects/debian-cloud/global/images/family/debian-9 Alternatively, use a specific version of a public operating system image: projects/debian-cloud/global/images/debian-9-stretch-vYYYYMMDD To create a disk with a custom image that you created, specify the image name in the following format: global/images/my-custom-image You can also specify a custom image by its image family, which returns the latest version of the image in that family. Replace the image name with family/family-name: global/images/family/my-image-family If the source image is deleted later, this field will not be set.
        :param pulumi.Input['CustomerEncryptionKeyArgs'] source_image_encryption_key: The customer-supplied encryption key of the source image. Required if the source image is protected by a customer-supplied encryption key. Instance templates do not store customer-supplied encryption keys, so you cannot create disks for instances in a managed instance group if the source images are encrypted with your own keys.
        :param pulumi.Input[str] source_snapshot: The source snapshot to create this disk. When creating a new instance, one of initializeParams.sourceSnapshot or initializeParams.sourceImage or disks.source is required except for local SSD. To create a disk with a snapshot that you created, specify the snapshot name in the following format: global/snapshots/my-backup If the source snapshot is deleted later, this field will not be set.
        :param pulumi.Input['CustomerEncryptionKeyArgs'] source_snapshot_encryption_key: The customer-supplied encryption key of the source snapshot.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disk_name is not None:
            pulumi.set(__self__, "disk_name", disk_name)
        if disk_size_gb is not None:
            pulumi.set(__self__, "disk_size_gb", disk_size_gb)
        if disk_type is not None:
            pulumi.set(__self__, "disk_type", disk_type)
        if guest_os_features is not None:
            pulumi.set(__self__, "guest_os_features", guest_os_features)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if licenses is not None:
            pulumi.set(__self__, "licenses", licenses)
        if multi_writer is not None:
            pulumi.set(__self__, "multi_writer", multi_writer)
        if on_update_action is not None:
            pulumi.set(__self__, "on_update_action", on_update_action)
        if provisioned_iops is not None:
            pulumi.set(__self__, "provisioned_iops", provisioned_iops)
        if resource_policies is not None:
            pulumi.set(__self__, "resource_policies", resource_policies)
        if source_image is not None:
            pulumi.set(__self__, "source_image", source_image)
        if source_image_encryption_key is not None:
            pulumi.set(__self__, "source_image_encryption_key", source_image_encryption_key)
        if source_snapshot is not None:
            pulumi.set(__self__, "source_snapshot", source_snapshot)
        if source_snapshot_encryption_key is not None:
            pulumi.set(__self__, "source_snapshot_encryption_key", source_snapshot_encryption_key)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        An optional description. Provide this property when creating the disk.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="diskName")
    def disk_name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the disk name. If not specified, the default is to use the name of the instance. If a disk with the same name already exists in the given region, the existing disk is attached to the new instance and the new disk is not created.
        """
        return pulumi.get(self, "disk_name")

    @disk_name.setter
    def disk_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "disk_name", value)

    @property
    @pulumi.getter(name="diskSizeGb")
    def disk_size_gb(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the size of the disk in base-2 GB. The size must be at least 10 GB. If you specify a sourceImage, which is required for boot disks, the default size is the size of the sourceImage. If you do not specify a sourceImage, the default disk size is 500 GB.
        """
        return pulumi.get(self, "disk_size_gb")

    @disk_size_gb.setter
    def disk_size_gb(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "disk_size_gb", value)

    @property
    @pulumi.getter(name="diskType")
    def disk_type(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the disk type to use to create the instance. If not specified, the default is pd-standard, specified using the full URL. For example: https://www.googleapis.com/compute/v1/projects/project/zones/zone /diskTypes/pd-standard For a full list of acceptable values, see Persistent disk types. If you define this field, you can provide either the full or partial URL. For example, the following are valid values: - https://www.googleapis.com/compute/v1/projects/project/zones/zone /diskTypes/diskType - projects/project/zones/zone/diskTypes/diskType - zones/zone/diskTypes/diskType Note that for InstanceTemplate, this is the name of the disk type, not URL.
        """
        return pulumi.get(self, "disk_type")

    @disk_type.setter
    def disk_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "disk_type", value)

    @property
    @pulumi.getter(name="guestOsFeatures")
    def guest_os_features(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GuestOsFeatureArgs']]]]:
        """
        A list of features to enable on the guest operating system. Applicable only for bootable images. Read Enabling guest operating system features to see a list of available options. Guest OS features are applied by merging initializeParams.guestOsFeatures and disks.guestOsFeatures
        """
        return pulumi.get(self, "guest_os_features")

    @guest_os_features.setter
    def guest_os_features(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GuestOsFeatureArgs']]]]):
        pulumi.set(self, "guest_os_features", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Labels to apply to this disk. These can be later modified by the disks.setLabels method. This field is only applicable for persistent disks.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def licenses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of publicly visible licenses. Reserved for Google's use.
        """
        return pulumi.get(self, "licenses")

    @licenses.setter
    def licenses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "licenses", value)

    @property
    @pulumi.getter(name="multiWriter")
    def multi_writer(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether or not the disk can be read/write attached to more than one instance.
        """
        return pulumi.get(self, "multi_writer")

    @multi_writer.setter
    def multi_writer(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "multi_writer", value)

    @property
    @pulumi.getter(name="onUpdateAction")
    def on_update_action(self) -> Optional[pulumi.Input['AttachedDiskInitializeParamsOnUpdateAction']]:
        """
        Specifies which action to take on instance update with this disk. Default is to use the existing disk.
        """
        return pulumi.get(self, "on_update_action")

    @on_update_action.setter
    def on_update_action(self, value: Optional[pulumi.Input['AttachedDiskInitializeParamsOnUpdateAction']]):
        pulumi.set(self, "on_update_action", value)

    @property
    @pulumi.getter(name="provisionedIops")
    def provisioned_iops(self) -> Optional[pulumi.Input[str]]:
        """
        Indicates how many IOPS to provision for the disk. This sets the number of I/O operations per second that the disk can handle. Values must be between 10,000 and 120,000. For more details, see the Extreme persistent disk documentation.
        """
        return pulumi.get(self, "provisioned_iops")

    @provisioned_iops.setter
    def provisioned_iops(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "provisioned_iops", value)

    @property
    @pulumi.getter(name="resourcePolicies")
    def resource_policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Resource policies applied to this disk for automatic snapshot creations. Specified using the full or partial URL. For instance template, specify only the resource policy name.
        """
        return pulumi.get(self, "resource_policies")

    @resource_policies.setter
    def resource_policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "resource_policies", value)

    @property
    @pulumi.getter(name="sourceImage")
    def source_image(self) -> Optional[pulumi.Input[str]]:
        """
        The source image to create this disk. When creating a new instance, one of initializeParams.sourceImage or initializeParams.sourceSnapshot or disks.source is required except for local SSD. To create a disk with one of the public operating system images, specify the image by its family name. For example, specify family/debian-9 to use the latest Debian 9 image: projects/debian-cloud/global/images/family/debian-9 Alternatively, use a specific version of a public operating system image: projects/debian-cloud/global/images/debian-9-stretch-vYYYYMMDD To create a disk with a custom image that you created, specify the image name in the following format: global/images/my-custom-image You can also specify a custom image by its image family, which returns the latest version of the image in that family. Replace the image name with family/family-name: global/images/family/my-image-family If the source image is deleted later, this field will not be set.
        """
        return pulumi.get(self, "source_image")

    @source_image.setter
    def source_image(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_image", value)

    @property
    @pulumi.getter(name="sourceImageEncryptionKey")
    def source_image_encryption_key(self) -> Optional[pulumi.Input['CustomerEncryptionKeyArgs']]:
        """
        The customer-supplied encryption key of the source image. Required if the source image is protected by a customer-supplied encryption key. Instance templates do not store customer-supplied encryption keys, so you cannot create disks for instances in a managed instance group if the source images are encrypted with your own keys.
        """
        return pulumi.get(self, "source_image_encryption_key")

    @source_image_encryption_key.setter
    def source_image_encryption_key(self, value: Optional[pulumi.Input['CustomerEncryptionKeyArgs']]):
        pulumi.set(self, "source_image_encryption_key", value)

    @property
    @pulumi.getter(name="sourceSnapshot")
    def source_snapshot(self) -> Optional[pulumi.Input[str]]:
        """
        The source snapshot to create this disk. When creating a new instance, one of initializeParams.sourceSnapshot or initializeParams.sourceImage or disks.source is required except for local SSD. To create a disk with a snapshot that you created, specify the snapshot name in the following format: global/snapshots/my-backup If the source snapshot is deleted later, this field will not be set.
        """
        return pulumi.get(self, "source_snapshot")

    @source_snapshot.setter
    def source_snapshot(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_snapshot", value)

    @property
    @pulumi.getter(name="sourceSnapshotEncryptionKey")
    def source_snapshot_encryption_key(self) -> Optional[pulumi.Input['CustomerEncryptionKeyArgs']]:
        """
        The customer-supplied encryption key of the source snapshot.
        """
        return pulumi.get(self, "source_snapshot_encryption_key")

    @source_snapshot_encryption_key.setter
    def source_snapshot_encryption_key(self, value: Optional[pulumi.Input['CustomerEncryptionKeyArgs']]):
        pulumi.set(self, "source_snapshot_encryption_key", value)


@pulumi.input_type
class AttachedDiskArgs:
    def __init__(__self__, *,
                 auto_delete: Optional[pulumi.Input[bool]] = None,
                 boot: Optional[pulumi.Input[bool]] = None,
                 device_name: Optional[pulumi.Input[str]] = None,
                 disk_encryption_key: Optional[pulumi.Input['CustomerEncryptionKeyArgs']] = None,
                 disk_size_gb: Optional[pulumi.Input[str]] = None,
                 guest_os_features: Optional[pulumi.Input[Sequence[pulumi.Input['GuestOsFeatureArgs']]]] = None,
                 initialize_params: Optional[pulumi.Input['AttachedDiskInitializeParamsArgs']] = None,
                 interface: Optional[pulumi.Input['AttachedDiskInterface']] = None,
                 mode: Optional[pulumi.Input['AttachedDiskMode']] = None,
                 source: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input['AttachedDiskType']] = None):
        """
        An instance-attached disk resource.
        :param pulumi.Input[bool] auto_delete: Specifies whether the disk will be auto-deleted when the instance is deleted (but not when the disk is detached from the instance).
        :param pulumi.Input[bool] boot: Indicates that this is a boot disk. The virtual machine will use the first partition of the disk for its root filesystem.
        :param pulumi.Input[str] device_name: Specifies a unique device name of your choice that is reflected into the /dev/disk/by-id/google-* tree of a Linux operating system running within the instance. This name can be used to reference the device for mounting, resizing, and so on, from within the instance. If not specified, the server chooses a default device name to apply to this disk, in the form persistent-disk-x, where x is a number assigned by Google Compute Engine. This field is only applicable for persistent disks.
        :param pulumi.Input['CustomerEncryptionKeyArgs'] disk_encryption_key: Encrypts or decrypts a disk using a customer-supplied encryption key. If you are creating a new disk, this field encrypts the new disk using an encryption key that you provide. If you are attaching an existing disk that is already encrypted, this field decrypts the disk using the customer-supplied encryption key. If you encrypt a disk using a customer-supplied key, you must provide the same key again when you attempt to use this resource at a later time. For example, you must provide the key when you create a snapshot or an image from the disk or when you attach the disk to a virtual machine instance. If you do not provide an encryption key, then the disk will be encrypted using an automatically generated key and you do not need to provide a key to use the disk later. Instance templates do not store customer-supplied encryption keys, so you cannot use your own keys to encrypt disks in a managed instance group.
        :param pulumi.Input[str] disk_size_gb: The size of the disk in GB.
        :param pulumi.Input[Sequence[pulumi.Input['GuestOsFeatureArgs']]] guest_os_features: A list of features to enable on the guest operating system. Applicable only for bootable images. Read Enabling guest operating system features to see a list of available options.
        :param pulumi.Input['AttachedDiskInitializeParamsArgs'] initialize_params: [Input Only] Specifies the parameters for a new disk that will be created alongside the new instance. Use initialization parameters to create boot disks or local SSDs attached to the new instance. This property is mutually exclusive with the source property; you can only define one or the other, but not both.
        :param pulumi.Input['AttachedDiskInterface'] interface: Specifies the disk interface to use for attaching this disk, which is either SCSI or NVME. The default is SCSI. Persistent disks must always use SCSI and the request will fail if you attempt to attach a persistent disk in any other format than SCSI. Local SSDs can use either NVME or SCSI. For performance characteristics of SCSI over NVMe, see Local SSD performance.
        :param pulumi.Input['AttachedDiskMode'] mode: The mode in which to attach this disk, either READ_WRITE or READ_ONLY. If not specified, the default is to attach the disk in READ_WRITE mode.
        :param pulumi.Input[str] source: Specifies a valid partial or full URL to an existing Persistent Disk resource. When creating a new instance, one of initializeParams.sourceImage or initializeParams.sourceSnapshot or disks.source is required except for local SSD. If desired, you can also attach existing non-root persistent disks using this property. This field is only applicable for persistent disks. Note that for InstanceTemplate, specify the disk name for zonal disk, and the URL for regional disk.
        :param pulumi.Input['AttachedDiskType'] type: Specifies the type of the disk, either SCRATCH or PERSISTENT. If not specified, the default is PERSISTENT.
        """
        if auto_delete is not None:
            pulumi.set(__self__, "auto_delete", auto_delete)
        if boot is not None:
            pulumi.set(__self__, "boot", boot)
        if device_name is not None:
            pulumi.set(__self__, "device_name", device_name)
        if disk_encryption_key is not None:
            pulumi.set(__self__, "disk_encryption_key", disk_encryption_key)
        if disk_size_gb is not None:
            pulumi.set(__self__, "disk_size_gb", disk_size_gb)
        if guest_os_features is not None:
            pulumi.set(__self__, "guest_os_features", guest_os_features)
        if initialize_params is not None:
            pulumi.set(__self__, "initialize_params", initialize_params)
        if interface is not None:
            pulumi.set(__self__, "interface", interface)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if source is not None:
            pulumi.set(__self__, "source", source)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="autoDelete")
    def auto_delete(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether the disk will be auto-deleted when the instance is deleted (but not when the disk is detached from the instance).
        """
        return pulumi.get(self, "auto_delete")

    @auto_delete.setter
    def auto_delete(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_delete", value)

    @property
    @pulumi.getter
    def boot(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates that this is a boot disk. The virtual machine will use the first partition of the disk for its root filesystem.
        """
        return pulumi.get(self, "boot")

    @boot.setter
    def boot(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "boot", value)

    @property
    @pulumi.getter(name="deviceName")
    def device_name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies a unique device name of your choice that is reflected into the /dev/disk/by-id/google-* tree of a Linux operating system running within the instance. This name can be used to reference the device for mounting, resizing, and so on, from within the instance. If not specified, the server chooses a default device name to apply to this disk, in the form persistent-disk-x, where x is a number assigned by Google Compute Engine. This field is only applicable for persistent disks.
        """
        return pulumi.get(self, "device_name")

    @device_name.setter
    def device_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "device_name", value)

    @property
    @pulumi.getter(name="diskEncryptionKey")
    def disk_encryption_key(self) -> Optional[pulumi.Input['CustomerEncryptionKeyArgs']]:
        """
        Encrypts or decrypts a disk using a customer-supplied encryption key. If you are creating a new disk, this field encrypts the new disk using an encryption key that you provide. If you are attaching an existing disk that is already encrypted, this field decrypts the disk using the customer-supplied encryption key. If you encrypt a disk using a customer-supplied key, you must provide the same key again when you attempt to use this resource at a later time. For example, you must provide the key when you create a snapshot or an image from the disk or when you attach the disk to a virtual machine instance. If you do not provide an encryption key, then the disk will be encrypted using an automatically generated key and you do not need to provide a key to use the disk later. Instance templates do not store customer-supplied encryption keys, so you cannot use your own keys to encrypt disks in a managed instance group.
        """
        return pulumi.get(self, "disk_encryption_key")

    @disk_encryption_key.setter
    def disk_encryption_key(self, value: Optional[pulumi.Input['CustomerEncryptionKeyArgs']]):
        pulumi.set(self, "disk_encryption_key", value)

    @property
    @pulumi.getter(name="diskSizeGb")
    def disk_size_gb(self) -> Optional[pulumi.Input[str]]:
        """
        The size of the disk in GB.
        """
        return pulumi.get(self, "disk_size_gb")

    @disk_size_gb.setter
    def disk_size_gb(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "disk_size_gb", value)

    @property
    @pulumi.getter(name="guestOsFeatures")
    def guest_os_features(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GuestOsFeatureArgs']]]]:
        """
        A list of features to enable on the guest operating system. Applicable only for bootable images. Read Enabling guest operating system features to see a list of available options.
        """
        return pulumi.get(self, "guest_os_features")

    @guest_os_features.setter
    def guest_os_features(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GuestOsFeatureArgs']]]]):
        pulumi.set(self, "guest_os_features", value)

    @property
    @pulumi.getter(name="initializeParams")
    def initialize_params(self) -> Optional[pulumi.Input['AttachedDiskInitializeParamsArgs']]:
        """
        [Input Only] Specifies the parameters for a new disk that will be created alongside the new instance. Use initialization parameters to create boot disks or local SSDs attached to the new instance. This property is mutually exclusive with the source property; you can only define one or the other, but not both.
        """
        return pulumi.get(self, "initialize_params")

    @initialize_params.setter
    def initialize_params(self, value: Optional[pulumi.Input['AttachedDiskInitializeParamsArgs']]):
        pulumi.set(self, "initialize_params", value)

    @property
    @pulumi.getter
    def interface(self) -> Optional[pulumi.Input['AttachedDiskInterface']]:
        """
        Specifies the disk interface to use for attaching this disk, which is either SCSI or NVME. The default is SCSI. Persistent disks must always use SCSI and the request will fail if you attempt to attach a persistent disk in any other format than SCSI. Local SSDs can use either NVME or SCSI. For performance characteristics of SCSI over NVMe, see Local SSD performance.
        """
        return pulumi.get(self, "interface")

    @interface.setter
    def interface(self, value: Optional[pulumi.Input['AttachedDiskInterface']]):
        pulumi.set(self, "interface", value)

    @property
    @pulumi.getter
    def mode(self) -> Optional[pulumi.Input['AttachedDiskMode']]:
        """
        The mode in which to attach this disk, either READ_WRITE or READ_ONLY. If not specified, the default is to attach the disk in READ_WRITE mode.
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: Optional[pulumi.Input['AttachedDiskMode']]):
        pulumi.set(self, "mode", value)

    @property
    @pulumi.getter
    def source(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies a valid partial or full URL to an existing Persistent Disk resource. When creating a new instance, one of initializeParams.sourceImage or initializeParams.sourceSnapshot or disks.source is required except for local SSD. If desired, you can also attach existing non-root persistent disks using this property. This field is only applicable for persistent disks. Note that for InstanceTemplate, specify the disk name for zonal disk, and the URL for regional disk.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input['AttachedDiskType']]:
        """
        Specifies the type of the disk, either SCRATCH or PERSISTENT. If not specified, the default is PERSISTENT.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input['AttachedDiskType']]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class AuditConfigArgs:
    def __init__(__self__, *,
                 audit_log_configs: Optional[pulumi.Input[Sequence[pulumi.Input['AuditLogConfigArgs']]]] = None,
                 exempted_members: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 service: Optional[pulumi.Input[str]] = None):
        """
        Specifies the audit configuration for a service. The configuration determines which permission types are logged, and what identities, if any, are exempted from logging. An AuditConfig must have one or more AuditLogConfigs. If there are AuditConfigs for both `allServices` and a specific service, the union of the two AuditConfigs is used for that service: the log_types specified in each AuditConfig are enabled, and the exempted_members in each AuditLogConfig are exempted. Example Policy with multiple AuditConfigs: { "audit_configs": [ { "service": "allServices", "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [ "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" }, { "log_type": "ADMIN_READ" } ] }, { "service": "sampleservice.googleapis.com", "audit_log_configs": [ { "log_type": "DATA_READ" }, { "log_type": "DATA_WRITE", "exempted_members": [ "user:aliya@example.com" ] } ] } ] } For sampleservice, this policy enables DATA_READ, DATA_WRITE and ADMIN_READ logging. It also exempts jose@example.com from DATA_READ logging, and aliya@example.com from DATA_WRITE logging.
        :param pulumi.Input[Sequence[pulumi.Input['AuditLogConfigArgs']]] audit_log_configs: The configuration for logging of each type of permission.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] exempted_members: This is deprecated and has no effect. Do not use.
        :param pulumi.Input[str] service: Specifies a service that will be enabled for audit logging. For example, `storage.googleapis.com`, `cloudsql.googleapis.com`. `allServices` is a special value that covers all services.
        """
        if audit_log_configs is not None:
            pulumi.set(__self__, "audit_log_configs", audit_log_configs)
        if exempted_members is not None:
            pulumi.set(__self__, "exempted_members", exempted_members)
        if service is not None:
            pulumi.set(__self__, "service", service)

    @property
    @pulumi.getter(name="auditLogConfigs")
    def audit_log_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AuditLogConfigArgs']]]]:
        """
        The configuration for logging of each type of permission.
        """
        return pulumi.get(self, "audit_log_configs")

    @audit_log_configs.setter
    def audit_log_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AuditLogConfigArgs']]]]):
        pulumi.set(self, "audit_log_configs", value)

    @property
    @pulumi.getter(name="exemptedMembers")
    def exempted_members(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        This is deprecated and has no effect. Do not use.
        """
        return pulumi.get(self, "exempted_members")

    @exempted_members.setter
    def exempted_members(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "exempted_members", value)

    @property
    @pulumi.getter
    def service(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies a service that will be enabled for audit logging. For example, `storage.googleapis.com`, `cloudsql.googleapis.com`. `allServices` is a special value that covers all services.
        """
        return pulumi.get(self, "service")

    @service.setter
    def service(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service", value)


@pulumi.input_type
class AuditLogConfigArgs:
    def __init__(__self__, *,
                 exempted_members: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 ignore_child_exemptions: Optional[pulumi.Input[bool]] = None,
                 log_type: Optional[pulumi.Input['AuditLogConfigLogType']] = None):
        """
        Provides the configuration for logging a type of permissions. Example: { "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [ "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" } ] } This enables 'DATA_READ' and 'DATA_WRITE' logging, while exempting jose@example.com from DATA_READ logging.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] exempted_members: Specifies the identities that do not cause logging for this type of permission. Follows the same format of Binding.members.
        :param pulumi.Input[bool] ignore_child_exemptions: This is deprecated and has no effect. Do not use.
        :param pulumi.Input['AuditLogConfigLogType'] log_type: The log type that this config enables.
        """
        if exempted_members is not None:
            pulumi.set(__self__, "exempted_members", exempted_members)
        if ignore_child_exemptions is not None:
            pulumi.set(__self__, "ignore_child_exemptions", ignore_child_exemptions)
        if log_type is not None:
            pulumi.set(__self__, "log_type", log_type)

    @property
    @pulumi.getter(name="exemptedMembers")
    def exempted_members(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies the identities that do not cause logging for this type of permission. Follows the same format of Binding.members.
        """
        return pulumi.get(self, "exempted_members")

    @exempted_members.setter
    def exempted_members(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "exempted_members", value)

    @property
    @pulumi.getter(name="ignoreChildExemptions")
    def ignore_child_exemptions(self) -> Optional[pulumi.Input[bool]]:
        """
        This is deprecated and has no effect. Do not use.
        """
        return pulumi.get(self, "ignore_child_exemptions")

    @ignore_child_exemptions.setter
    def ignore_child_exemptions(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "ignore_child_exemptions", value)

    @property
    @pulumi.getter(name="logType")
    def log_type(self) -> Optional[pulumi.Input['AuditLogConfigLogType']]:
        """
        The log type that this config enables.
        """
        return pulumi.get(self, "log_type")

    @log_type.setter
    def log_type(self, value: Optional[pulumi.Input['AuditLogConfigLogType']]):
        pulumi.set(self, "log_type", value)


@pulumi.input_type
class AuthorizationLoggingOptionsArgs:
    def __init__(__self__, *,
                 permission_type: Optional[pulumi.Input['AuthorizationLoggingOptionsPermissionType']] = None):
        """
        This is deprecated and has no effect. Do not use.
        :param pulumi.Input['AuthorizationLoggingOptionsPermissionType'] permission_type: This is deprecated and has no effect. Do not use.
        """
        if permission_type is not None:
            pulumi.set(__self__, "permission_type", permission_type)

    @property
    @pulumi.getter(name="permissionType")
    def permission_type(self) -> Optional[pulumi.Input['AuthorizationLoggingOptionsPermissionType']]:
        """
        This is deprecated and has no effect. Do not use.
        """
        return pulumi.get(self, "permission_type")

    @permission_type.setter
    def permission_type(self, value: Optional[pulumi.Input['AuthorizationLoggingOptionsPermissionType']]):
        pulumi.set(self, "permission_type", value)


@pulumi.input_type
class AutoscalingPolicyCpuUtilizationArgs:
    def __init__(__self__, *,
                 predictive_method: Optional[pulumi.Input['AutoscalingPolicyCpuUtilizationPredictiveMethod']] = None,
                 utilization_target: Optional[pulumi.Input[float]] = None):
        """
        CPU utilization policy.
        :param pulumi.Input['AutoscalingPolicyCpuUtilizationPredictiveMethod'] predictive_method: Indicates whether predictive autoscaling based on CPU metric is enabled. Valid values are: * NONE (default). No predictive method is used. The autoscaler scales the group to meet current demand based on real-time metrics. * OPTIMIZE_AVAILABILITY. Predictive autoscaling improves availability by monitoring daily and weekly load patterns and scaling out ahead of anticipated demand.
        :param pulumi.Input[float] utilization_target: The target CPU utilization that the autoscaler maintains. Must be a float value in the range (0, 1]. If not specified, the default is 0.6. If the CPU level is below the target utilization, the autoscaler scales in the number of instances until it reaches the minimum number of instances you specified or until the average CPU of your instances reaches the target utilization. If the average CPU is above the target utilization, the autoscaler scales out until it reaches the maximum number of instances you specified or until the average utilization reaches the target utilization.
        """
        if predictive_method is not None:
            pulumi.set(__self__, "predictive_method", predictive_method)
        if utilization_target is not None:
            pulumi.set(__self__, "utilization_target", utilization_target)

    @property
    @pulumi.getter(name="predictiveMethod")
    def predictive_method(self) -> Optional[pulumi.Input['AutoscalingPolicyCpuUtilizationPredictiveMethod']]:
        """
        Indicates whether predictive autoscaling based on CPU metric is enabled. Valid values are: * NONE (default). No predictive method is used. The autoscaler scales the group to meet current demand based on real-time metrics. * OPTIMIZE_AVAILABILITY. Predictive autoscaling improves availability by monitoring daily and weekly load patterns and scaling out ahead of anticipated demand.
        """
        return pulumi.get(self, "predictive_method")

    @predictive_method.setter
    def predictive_method(self, value: Optional[pulumi.Input['AutoscalingPolicyCpuUtilizationPredictiveMethod']]):
        pulumi.set(self, "predictive_method", value)

    @property
    @pulumi.getter(name="utilizationTarget")
    def utilization_target(self) -> Optional[pulumi.Input[float]]:
        """
        The target CPU utilization that the autoscaler maintains. Must be a float value in the range (0, 1]. If not specified, the default is 0.6. If the CPU level is below the target utilization, the autoscaler scales in the number of instances until it reaches the minimum number of instances you specified or until the average CPU of your instances reaches the target utilization. If the average CPU is above the target utilization, the autoscaler scales out until it reaches the maximum number of instances you specified or until the average utilization reaches the target utilization.
        """
        return pulumi.get(self, "utilization_target")

    @utilization_target.setter
    def utilization_target(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "utilization_target", value)


@pulumi.input_type
class AutoscalingPolicyCustomMetricUtilizationArgs:
    def __init__(__self__, *,
                 filter: Optional[pulumi.Input[str]] = None,
                 metric: Optional[pulumi.Input[str]] = None,
                 single_instance_assignment: Optional[pulumi.Input[float]] = None,
                 utilization_target: Optional[pulumi.Input[float]] = None,
                 utilization_target_type: Optional[pulumi.Input['AutoscalingPolicyCustomMetricUtilizationUtilizationTargetType']] = None):
        """
        Custom utilization metric policy.
        :param pulumi.Input[str] filter: A filter string, compatible with a Stackdriver Monitoring filter string for TimeSeries.list API call. This filter is used to select a specific TimeSeries for the purpose of autoscaling and to determine whether the metric is exporting per-instance or per-group data. For the filter to be valid for autoscaling purposes, the following rules apply: - You can only use the AND operator for joining selectors. - You can only use direct equality comparison operator (=) without any functions for each selector. - You can specify the metric in both the filter string and in the metric field. However, if specified in both places, the metric must be identical. - The monitored resource type determines what kind of values are expected for the metric. If it is a gce_instance, the autoscaler expects the metric to include a separate TimeSeries for each instance in a group. In such a case, you cannot filter on resource labels. If the resource type is any other value, the autoscaler expects this metric to contain values that apply to the entire autoscaled instance group and resource label filtering can be performed to point autoscaler at the correct TimeSeries to scale upon. This is called a *per-group metric* for the purpose of autoscaling. If not specified, the type defaults to gce_instance. Try to provide a filter that is selective enough to pick just one TimeSeries for the autoscaled group or for each of the instances (if you are using gce_instance resource type). If multiple TimeSeries are returned upon the query execution, the autoscaler will sum their respective values to obtain its scaling value.
        :param pulumi.Input[str] metric: The identifier (type) of the Stackdriver Monitoring metric. The metric cannot have negative values. The metric must have a value type of INT64 or DOUBLE.
        :param pulumi.Input[float] single_instance_assignment: If scaling is based on a per-group metric value that represents the total amount of work to be done or resource usage, set this value to an amount assigned for a single instance of the scaled group. Autoscaler keeps the number of instances proportional to the value of this metric. The metric itself does not change value due to group resizing. A good metric to use with the target is for example pubsub.googleapis.com/subscription/num_undelivered_messages or a custom metric exporting the total number of requests coming to your instances. A bad example would be a metric exporting an average or median latency, since this value can't include a chunk assignable to a single instance, it could be better used with utilization_target instead.
        :param pulumi.Input[float] utilization_target: The target value of the metric that autoscaler maintains. This must be a positive value. A utilization metric scales number of virtual machines handling requests to increase or decrease proportionally to the metric. For example, a good metric to use as a utilization_target is https://www.googleapis.com/compute/v1/instance/network/received_bytes_count. The autoscaler works to keep this value constant for each of the instances.
        :param pulumi.Input['AutoscalingPolicyCustomMetricUtilizationUtilizationTargetType'] utilization_target_type: Defines how target utilization value is expressed for a Stackdriver Monitoring metric. Either GAUGE, DELTA_PER_SECOND, or DELTA_PER_MINUTE.
        """
        if filter is not None:
            pulumi.set(__self__, "filter", filter)
        if metric is not None:
            pulumi.set(__self__, "metric", metric)
        if single_instance_assignment is not None:
            pulumi.set(__self__, "single_instance_assignment", single_instance_assignment)
        if utilization_target is not None:
            pulumi.set(__self__, "utilization_target", utilization_target)
        if utilization_target_type is not None:
            pulumi.set(__self__, "utilization_target_type", utilization_target_type)

    @property
    @pulumi.getter
    def filter(self) -> Optional[pulumi.Input[str]]:
        """
        A filter string, compatible with a Stackdriver Monitoring filter string for TimeSeries.list API call. This filter is used to select a specific TimeSeries for the purpose of autoscaling and to determine whether the metric is exporting per-instance or per-group data. For the filter to be valid for autoscaling purposes, the following rules apply: - You can only use the AND operator for joining selectors. - You can only use direct equality comparison operator (=) without any functions for each selector. - You can specify the metric in both the filter string and in the metric field. However, if specified in both places, the metric must be identical. - The monitored resource type determines what kind of values are expected for the metric. If it is a gce_instance, the autoscaler expects the metric to include a separate TimeSeries for each instance in a group. In such a case, you cannot filter on resource labels. If the resource type is any other value, the autoscaler expects this metric to contain values that apply to the entire autoscaled instance group and resource label filtering can be performed to point autoscaler at the correct TimeSeries to scale upon. This is called a *per-group metric* for the purpose of autoscaling. If not specified, the type defaults to gce_instance. Try to provide a filter that is selective enough to pick just one TimeSeries for the autoscaled group or for each of the instances (if you are using gce_instance resource type). If multiple TimeSeries are returned upon the query execution, the autoscaler will sum their respective values to obtain its scaling value.
        """
        return pulumi.get(self, "filter")

    @filter.setter
    def filter(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "filter", value)

    @property
    @pulumi.getter
    def metric(self) -> Optional[pulumi.Input[str]]:
        """
        The identifier (type) of the Stackdriver Monitoring metric. The metric cannot have negative values. The metric must have a value type of INT64 or DOUBLE.
        """
        return pulumi.get(self, "metric")

    @metric.setter
    def metric(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "metric", value)

    @property
    @pulumi.getter(name="singleInstanceAssignment")
    def single_instance_assignment(self) -> Optional[pulumi.Input[float]]:
        """
        If scaling is based on a per-group metric value that represents the total amount of work to be done or resource usage, set this value to an amount assigned for a single instance of the scaled group. Autoscaler keeps the number of instances proportional to the value of this metric. The metric itself does not change value due to group resizing. A good metric to use with the target is for example pubsub.googleapis.com/subscription/num_undelivered_messages or a custom metric exporting the total number of requests coming to your instances. A bad example would be a metric exporting an average or median latency, since this value can't include a chunk assignable to a single instance, it could be better used with utilization_target instead.
        """
        return pulumi.get(self, "single_instance_assignment")

    @single_instance_assignment.setter
    def single_instance_assignment(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "single_instance_assignment", value)

    @property
    @pulumi.getter(name="utilizationTarget")
    def utilization_target(self) -> Optional[pulumi.Input[float]]:
        """
        The target value of the metric that autoscaler maintains. This must be a positive value. A utilization metric scales number of virtual machines handling requests to increase or decrease proportionally to the metric. For example, a good metric to use as a utilization_target is https://www.googleapis.com/compute/v1/instance/network/received_bytes_count. The autoscaler works to keep this value constant for each of the instances.
        """
        return pulumi.get(self, "utilization_target")

    @utilization_target.setter
    def utilization_target(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "utilization_target", value)

    @property
    @pulumi.getter(name="utilizationTargetType")
    def utilization_target_type(self) -> Optional[pulumi.Input['AutoscalingPolicyCustomMetricUtilizationUtilizationTargetType']]:
        """
        Defines how target utilization value is expressed for a Stackdriver Monitoring metric. Either GAUGE, DELTA_PER_SECOND, or DELTA_PER_MINUTE.
        """
        return pulumi.get(self, "utilization_target_type")

    @utilization_target_type.setter
    def utilization_target_type(self, value: Optional[pulumi.Input['AutoscalingPolicyCustomMetricUtilizationUtilizationTargetType']]):
        pulumi.set(self, "utilization_target_type", value)


@pulumi.input_type
class AutoscalingPolicyLoadBalancingUtilizationArgs:
    def __init__(__self__, *,
                 utilization_target: Optional[pulumi.Input[float]] = None):
        """
        Configuration parameters of autoscaling based on load balancing.
        :param pulumi.Input[float] utilization_target: Fraction of backend capacity utilization (set in HTTP(S) load balancing configuration) that the autoscaler maintains. Must be a positive float value. If not defined, the default is 0.8.
        """
        if utilization_target is not None:
            pulumi.set(__self__, "utilization_target", utilization_target)

    @property
    @pulumi.getter(name="utilizationTarget")
    def utilization_target(self) -> Optional[pulumi.Input[float]]:
        """
        Fraction of backend capacity utilization (set in HTTP(S) load balancing configuration) that the autoscaler maintains. Must be a positive float value. If not defined, the default is 0.8.
        """
        return pulumi.get(self, "utilization_target")

    @utilization_target.setter
    def utilization_target(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "utilization_target", value)


@pulumi.input_type
class AutoscalingPolicyScaleDownControlArgs:
    def __init__(__self__, *,
                 max_scaled_down_replicas: Optional[pulumi.Input['FixedOrPercentArgs']] = None,
                 time_window_sec: Optional[pulumi.Input[int]] = None):
        """
        Configuration that allows for slower scale in so that even if Autoscaler recommends an abrupt scale in of a MIG, it will be throttled as specified by the parameters below.
        :param pulumi.Input['FixedOrPercentArgs'] max_scaled_down_replicas: Maximum allowed number (or %) of VMs that can be deducted from the peak recommendation during the window autoscaler looks at when computing recommendations. Possibly all these VMs can be deleted at once so user service needs to be prepared to lose that many VMs in one step.
        :param pulumi.Input[int] time_window_sec: How far back autoscaling looks when computing recommendations to include directives regarding slower scale in, as described above.
        """
        if max_scaled_down_replicas is not None:
            pulumi.set(__self__, "max_scaled_down_replicas", max_scaled_down_replicas)
        if time_window_sec is not None:
            pulumi.set(__self__, "time_window_sec", time_window_sec)

    @property
    @pulumi.getter(name="maxScaledDownReplicas")
    def max_scaled_down_replicas(self) -> Optional[pulumi.Input['FixedOrPercentArgs']]:
        """
        Maximum allowed number (or %) of VMs that can be deducted from the peak recommendation during the window autoscaler looks at when computing recommendations. Possibly all these VMs can be deleted at once so user service needs to be prepared to lose that many VMs in one step.
        """
        return pulumi.get(self, "max_scaled_down_replicas")

    @max_scaled_down_replicas.setter
    def max_scaled_down_replicas(self, value: Optional[pulumi.Input['FixedOrPercentArgs']]):
        pulumi.set(self, "max_scaled_down_replicas", value)

    @property
    @pulumi.getter(name="timeWindowSec")
    def time_window_sec(self) -> Optional[pulumi.Input[int]]:
        """
        How far back autoscaling looks when computing recommendations to include directives regarding slower scale in, as described above.
        """
        return pulumi.get(self, "time_window_sec")

    @time_window_sec.setter
    def time_window_sec(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "time_window_sec", value)


@pulumi.input_type
class AutoscalingPolicyScaleInControlArgs:
    def __init__(__self__, *,
                 max_scaled_in_replicas: Optional[pulumi.Input['FixedOrPercentArgs']] = None,
                 time_window_sec: Optional[pulumi.Input[int]] = None):
        """
        Configuration that allows for slower scale in so that even if Autoscaler recommends an abrupt scale in of a MIG, it will be throttled as specified by the parameters below.
        :param pulumi.Input['FixedOrPercentArgs'] max_scaled_in_replicas: Maximum allowed number (or %) of VMs that can be deducted from the peak recommendation during the window autoscaler looks at when computing recommendations. Possibly all these VMs can be deleted at once so user service needs to be prepared to lose that many VMs in one step.
        :param pulumi.Input[int] time_window_sec: How far back autoscaling looks when computing recommendations to include directives regarding slower scale in, as described above.
        """
        if max_scaled_in_replicas is not None:
            pulumi.set(__self__, "max_scaled_in_replicas", max_scaled_in_replicas)
        if time_window_sec is not None:
            pulumi.set(__self__, "time_window_sec", time_window_sec)

    @property
    @pulumi.getter(name="maxScaledInReplicas")
    def max_scaled_in_replicas(self) -> Optional[pulumi.Input['FixedOrPercentArgs']]:
        """
        Maximum allowed number (or %) of VMs that can be deducted from the peak recommendation during the window autoscaler looks at when computing recommendations. Possibly all these VMs can be deleted at once so user service needs to be prepared to lose that many VMs in one step.
        """
        return pulumi.get(self, "max_scaled_in_replicas")

    @max_scaled_in_replicas.setter
    def max_scaled_in_replicas(self, value: Optional[pulumi.Input['FixedOrPercentArgs']]):
        pulumi.set(self, "max_scaled_in_replicas", value)

    @property
    @pulumi.getter(name="timeWindowSec")
    def time_window_sec(self) -> Optional[pulumi.Input[int]]:
        """
        How far back autoscaling looks when computing recommendations to include directives regarding slower scale in, as described above.
        """
        return pulumi.get(self, "time_window_sec")

    @time_window_sec.setter
    def time_window_sec(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "time_window_sec", value)


@pulumi.input_type
class AutoscalingPolicyArgs:
    def __init__(__self__, *,
                 cool_down_period_sec: Optional[pulumi.Input[int]] = None,
                 cpu_utilization: Optional[pulumi.Input['AutoscalingPolicyCpuUtilizationArgs']] = None,
                 custom_metric_utilizations: Optional[pulumi.Input[Sequence[pulumi.Input['AutoscalingPolicyCustomMetricUtilizationArgs']]]] = None,
                 load_balancing_utilization: Optional[pulumi.Input['AutoscalingPolicyLoadBalancingUtilizationArgs']] = None,
                 max_num_replicas: Optional[pulumi.Input[int]] = None,
                 min_num_replicas: Optional[pulumi.Input[int]] = None,
                 mode: Optional[pulumi.Input['AutoscalingPolicyMode']] = None,
                 scale_down_control: Optional[pulumi.Input['AutoscalingPolicyScaleDownControlArgs']] = None,
                 scale_in_control: Optional[pulumi.Input['AutoscalingPolicyScaleInControlArgs']] = None,
                 scaling_schedules: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        Cloud Autoscaler policy.
        :param pulumi.Input[int] cool_down_period_sec: The number of seconds that the autoscaler waits before it starts collecting information from a new instance. This prevents the autoscaler from collecting information when the instance is initializing, during which the collected usage would not be reliable. The default time autoscaler waits is 60 seconds. Virtual machine initialization times might vary because of numerous factors. We recommend that you test how long an instance may take to initialize. To do this, create an instance and time the startup process.
        :param pulumi.Input['AutoscalingPolicyCpuUtilizationArgs'] cpu_utilization: Defines the CPU utilization policy that allows the autoscaler to scale based on the average CPU utilization of a managed instance group.
        :param pulumi.Input[Sequence[pulumi.Input['AutoscalingPolicyCustomMetricUtilizationArgs']]] custom_metric_utilizations: Configuration parameters of autoscaling based on a custom metric.
        :param pulumi.Input['AutoscalingPolicyLoadBalancingUtilizationArgs'] load_balancing_utilization: Configuration parameters of autoscaling based on load balancer.
        :param pulumi.Input[int] max_num_replicas: The maximum number of instances that the autoscaler can scale out to. This is required when creating or updating an autoscaler. The maximum number of replicas must not be lower than minimal number of replicas.
        :param pulumi.Input[int] min_num_replicas: The minimum number of replicas that the autoscaler can scale in to. This cannot be less than 0. If not provided, autoscaler chooses a default value depending on maximum number of instances allowed.
        :param pulumi.Input['AutoscalingPolicyMode'] mode: Defines operating mode for this policy.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] scaling_schedules: Scaling schedules defined for an autoscaler. Multiple schedules can be set on an autoscaler, and they can overlap. During overlapping periods the greatest min_required_replicas of all scaling schedules is applied. Up to 128 scaling schedules are allowed.
        """
        if cool_down_period_sec is not None:
            pulumi.set(__self__, "cool_down_period_sec", cool_down_period_sec)
        if cpu_utilization is not None:
            pulumi.set(__self__, "cpu_utilization", cpu_utilization)
        if custom_metric_utilizations is not None:
            pulumi.set(__self__, "custom_metric_utilizations", custom_metric_utilizations)
        if load_balancing_utilization is not None:
            pulumi.set(__self__, "load_balancing_utilization", load_balancing_utilization)
        if max_num_replicas is not None:
            pulumi.set(__self__, "max_num_replicas", max_num_replicas)
        if min_num_replicas is not None:
            pulumi.set(__self__, "min_num_replicas", min_num_replicas)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if scale_down_control is not None:
            pulumi.set(__self__, "scale_down_control", scale_down_control)
        if scale_in_control is not None:
            pulumi.set(__self__, "scale_in_control", scale_in_control)
        if scaling_schedules is not None:
            pulumi.set(__self__, "scaling_schedules", scaling_schedules)

    @property
    @pulumi.getter(name="coolDownPeriodSec")
    def cool_down_period_sec(self) -> Optional[pulumi.Input[int]]:
        """
        The number of seconds that the autoscaler waits before it starts collecting information from a new instance. This prevents the autoscaler from collecting information when the instance is initializing, during which the collected usage would not be reliable. The default time autoscaler waits is 60 seconds. Virtual machine initialization times might vary because of numerous factors. We recommend that you test how long an instance may take to initialize. To do this, create an instance and time the startup process.
        """
        return pulumi.get(self, "cool_down_period_sec")

    @cool_down_period_sec.setter
    def cool_down_period_sec(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "cool_down_period_sec", value)

    @property
    @pulumi.getter(name="cpuUtilization")
    def cpu_utilization(self) -> Optional[pulumi.Input['AutoscalingPolicyCpuUtilizationArgs']]:
        """
        Defines the CPU utilization policy that allows the autoscaler to scale based on the average CPU utilization of a managed instance group.
        """
        return pulumi.get(self, "cpu_utilization")

    @cpu_utilization.setter
    def cpu_utilization(self, value: Optional[pulumi.Input['AutoscalingPolicyCpuUtilizationArgs']]):
        pulumi.set(self, "cpu_utilization", value)

    @property
    @pulumi.getter(name="customMetricUtilizations")
    def custom_metric_utilizations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AutoscalingPolicyCustomMetricUtilizationArgs']]]]:
        """
        Configuration parameters of autoscaling based on a custom metric.
        """
        return pulumi.get(self, "custom_metric_utilizations")

    @custom_metric_utilizations.setter
    def custom_metric_utilizations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AutoscalingPolicyCustomMetricUtilizationArgs']]]]):
        pulumi.set(self, "custom_metric_utilizations", value)

    @property
    @pulumi.getter(name="loadBalancingUtilization")
    def load_balancing_utilization(self) -> Optional[pulumi.Input['AutoscalingPolicyLoadBalancingUtilizationArgs']]:
        """
        Configuration parameters of autoscaling based on load balancer.
        """
        return pulumi.get(self, "load_balancing_utilization")

    @load_balancing_utilization.setter
    def load_balancing_utilization(self, value: Optional[pulumi.Input['AutoscalingPolicyLoadBalancingUtilizationArgs']]):
        pulumi.set(self, "load_balancing_utilization", value)

    @property
    @pulumi.getter(name="maxNumReplicas")
    def max_num_replicas(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum number of instances that the autoscaler can scale out to. This is required when creating or updating an autoscaler. The maximum number of replicas must not be lower than minimal number of replicas.
        """
        return pulumi.get(self, "max_num_replicas")

    @max_num_replicas.setter
    def max_num_replicas(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_num_replicas", value)

    @property
    @pulumi.getter(name="minNumReplicas")
    def min_num_replicas(self) -> Optional[pulumi.Input[int]]:
        """
        The minimum number of replicas that the autoscaler can scale in to. This cannot be less than 0. If not provided, autoscaler chooses a default value depending on maximum number of instances allowed.
        """
        return pulumi.get(self, "min_num_replicas")

    @min_num_replicas.setter
    def min_num_replicas(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_num_replicas", value)

    @property
    @pulumi.getter
    def mode(self) -> Optional[pulumi.Input['AutoscalingPolicyMode']]:
        """
        Defines operating mode for this policy.
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: Optional[pulumi.Input['AutoscalingPolicyMode']]):
        pulumi.set(self, "mode", value)

    @property
    @pulumi.getter(name="scaleDownControl")
    def scale_down_control(self) -> Optional[pulumi.Input['AutoscalingPolicyScaleDownControlArgs']]:
        return pulumi.get(self, "scale_down_control")

    @scale_down_control.setter
    def scale_down_control(self, value: Optional[pulumi.Input['AutoscalingPolicyScaleDownControlArgs']]):
        pulumi.set(self, "scale_down_control", value)

    @property
    @pulumi.getter(name="scaleInControl")
    def scale_in_control(self) -> Optional[pulumi.Input['AutoscalingPolicyScaleInControlArgs']]:
        return pulumi.get(self, "scale_in_control")

    @scale_in_control.setter
    def scale_in_control(self, value: Optional[pulumi.Input['AutoscalingPolicyScaleInControlArgs']]):
        pulumi.set(self, "scale_in_control", value)

    @property
    @pulumi.getter(name="scalingSchedules")
    def scaling_schedules(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Scaling schedules defined for an autoscaler. Multiple schedules can be set on an autoscaler, and they can overlap. During overlapping periods the greatest min_required_replicas of all scaling schedules is applied. Up to 128 scaling schedules are allowed.
        """
        return pulumi.get(self, "scaling_schedules")

    @scaling_schedules.setter
    def scaling_schedules(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "scaling_schedules", value)


@pulumi.input_type
class BackendBucketCdnPolicyBypassCacheOnRequestHeaderArgs:
    def __init__(__self__, *,
                 header_name: Optional[pulumi.Input[str]] = None):
        """
        Bypass the cache when the specified request headers are present, e.g. Pragma or Authorization headers. Values are case insensitive. The presence of such a header overrides the cache_mode setting.
        :param pulumi.Input[str] header_name: The header field name to match on when bypassing cache. Values are case-insensitive.
        """
        if header_name is not None:
            pulumi.set(__self__, "header_name", header_name)

    @property
    @pulumi.getter(name="headerName")
    def header_name(self) -> Optional[pulumi.Input[str]]:
        """
        The header field name to match on when bypassing cache. Values are case-insensitive.
        """
        return pulumi.get(self, "header_name")

    @header_name.setter
    def header_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "header_name", value)


@pulumi.input_type
class BackendBucketCdnPolicyCacheKeyPolicyArgs:
    def __init__(__self__, *,
                 include_http_headers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 query_string_whitelist: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Message containing what to include in the cache key for a request for Cloud CDN.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] include_http_headers: Allows HTTP request headers (by name) to be used in the cache key.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] query_string_whitelist: Names of query string parameters to include in cache keys. All other parameters will be excluded. '&' and '=' will be percent encoded and not treated as delimiters.
        """
        if include_http_headers is not None:
            pulumi.set(__self__, "include_http_headers", include_http_headers)
        if query_string_whitelist is not None:
            pulumi.set(__self__, "query_string_whitelist", query_string_whitelist)

    @property
    @pulumi.getter(name="includeHttpHeaders")
    def include_http_headers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Allows HTTP request headers (by name) to be used in the cache key.
        """
        return pulumi.get(self, "include_http_headers")

    @include_http_headers.setter
    def include_http_headers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "include_http_headers", value)

    @property
    @pulumi.getter(name="queryStringWhitelist")
    def query_string_whitelist(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Names of query string parameters to include in cache keys. All other parameters will be excluded. '&' and '=' will be percent encoded and not treated as delimiters.
        """
        return pulumi.get(self, "query_string_whitelist")

    @query_string_whitelist.setter
    def query_string_whitelist(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "query_string_whitelist", value)


@pulumi.input_type
class BackendBucketCdnPolicyNegativeCachingPolicyArgs:
    def __init__(__self__, *,
                 code: Optional[pulumi.Input[int]] = None,
                 ttl: Optional[pulumi.Input[int]] = None):
        """
        Specify CDN TTLs for response error codes.
        :param pulumi.Input[int] code: The HTTP status code to define a TTL against. Only HTTP status codes 300, 301, 302, 307, 308, 404, 405, 410, 421, 451 and 501 are can be specified as values, and you cannot specify a status code more than once.
        :param pulumi.Input[int] ttl: The TTL (in seconds) for which to cache responses with the corresponding status code. The maximum allowed value is 1800s (30 minutes), noting that infrequently accessed objects may be evicted from the cache before the defined TTL.
        """
        if code is not None:
            pulumi.set(__self__, "code", code)
        if ttl is not None:
            pulumi.set(__self__, "ttl", ttl)

    @property
    @pulumi.getter
    def code(self) -> Optional[pulumi.Input[int]]:
        """
        The HTTP status code to define a TTL against. Only HTTP status codes 300, 301, 302, 307, 308, 404, 405, 410, 421, 451 and 501 are can be specified as values, and you cannot specify a status code more than once.
        """
        return pulumi.get(self, "code")

    @code.setter
    def code(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "code", value)

    @property
    @pulumi.getter
    def ttl(self) -> Optional[pulumi.Input[int]]:
        """
        The TTL (in seconds) for which to cache responses with the corresponding status code. The maximum allowed value is 1800s (30 minutes), noting that infrequently accessed objects may be evicted from the cache before the defined TTL.
        """
        return pulumi.get(self, "ttl")

    @ttl.setter
    def ttl(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ttl", value)


@pulumi.input_type
class BackendBucketCdnPolicyArgs:
    def __init__(__self__, *,
                 bypass_cache_on_request_headers: Optional[pulumi.Input[Sequence[pulumi.Input['BackendBucketCdnPolicyBypassCacheOnRequestHeaderArgs']]]] = None,
                 cache_key_policy: Optional[pulumi.Input['BackendBucketCdnPolicyCacheKeyPolicyArgs']] = None,
                 cache_mode: Optional[pulumi.Input['BackendBucketCdnPolicyCacheMode']] = None,
                 client_ttl: Optional[pulumi.Input[int]] = None,
                 default_ttl: Optional[pulumi.Input[int]] = None,
                 max_ttl: Optional[pulumi.Input[int]] = None,
                 negative_caching: Optional[pulumi.Input[bool]] = None,
                 negative_caching_policy: Optional[pulumi.Input[Sequence[pulumi.Input['BackendBucketCdnPolicyNegativeCachingPolicyArgs']]]] = None,
                 request_coalescing: Optional[pulumi.Input[bool]] = None,
                 serve_while_stale: Optional[pulumi.Input[int]] = None,
                 signed_url_cache_max_age_sec: Optional[pulumi.Input[str]] = None):
        """
        Message containing Cloud CDN configuration for a backend bucket.
        :param pulumi.Input[Sequence[pulumi.Input['BackendBucketCdnPolicyBypassCacheOnRequestHeaderArgs']]] bypass_cache_on_request_headers: Bypass the cache when the specified request headers are matched - e.g. Pragma or Authorization headers. Up to 5 headers can be specified. The cache is bypassed for all cdnPolicy.cacheMode settings.
        :param pulumi.Input['BackendBucketCdnPolicyCacheKeyPolicyArgs'] cache_key_policy: The CacheKeyPolicy for this CdnPolicy.
        :param pulumi.Input['BackendBucketCdnPolicyCacheMode'] cache_mode: Specifies the cache setting for all responses from this backend. The possible values are: USE_ORIGIN_HEADERS Requires the origin to set valid caching headers to cache content. Responses without these headers will not be cached at Google's edge, and will require a full trip to the origin on every request, potentially impacting performance and increasing load on the origin server. FORCE_CACHE_ALL Cache all content, ignoring any "private", "no-store" or "no-cache" directives in Cache-Control response headers. Warning: this may result in Cloud CDN caching private, per-user (user identifiable) content. CACHE_ALL_STATIC Automatically cache static content, including common image formats, media (video and audio), and web assets (JavaScript and CSS). Requests and responses that are marked as uncacheable, as well as dynamic content (including HTML), will not be cached.
        :param pulumi.Input[int] client_ttl: Specifies a separate client (e.g. browser client) maximum TTL. This is used to clamp the max-age (or Expires) value sent to the client. With FORCE_CACHE_ALL, the lesser of client_ttl and default_ttl is used for the response max-age directive, along with a "public" directive. For cacheable content in CACHE_ALL_STATIC mode, client_ttl clamps the max-age from the origin (if specified), or else sets the response max-age directive to the lesser of the client_ttl and default_ttl, and also ensures a "public" cache-control directive is present. If a client TTL is not specified, a default value (1 hour) will be used. The maximum allowed value is 31,622,400s (1 year).
        :param pulumi.Input[int] default_ttl: Specifies the default TTL for cached content served by this origin for responses that do not have an existing valid TTL (max-age or s-max-age). Setting a TTL of "0" means "always revalidate". The value of defaultTTL cannot be set to a value greater than that of maxTTL, but can be equal. When the cacheMode is set to FORCE_CACHE_ALL, the defaultTTL will overwrite the TTL set in all responses. The maximum allowed value is 31,622,400s (1 year), noting that infrequently accessed objects may be evicted from the cache before the defined TTL.
        :param pulumi.Input[int] max_ttl: Specifies the maximum allowed TTL for cached content served by this origin. Cache directives that attempt to set a max-age or s-maxage higher than this, or an Expires header more than maxTTL seconds in the future will be capped at the value of maxTTL, as if it were the value of an s-maxage Cache-Control directive. Headers sent to the client will not be modified. Setting a TTL of "0" means "always revalidate". The maximum allowed value is 31,622,400s (1 year), noting that infrequently accessed objects may be evicted from the cache before the defined TTL.
        :param pulumi.Input[bool] negative_caching: Negative caching allows per-status code TTLs to be set, in order to apply fine-grained caching for common errors or redirects. This can reduce the load on your origin and improve end-user experience by reducing response latency. When the cache mode is set to CACHE_ALL_STATIC or USE_ORIGIN_HEADERS, negative caching applies to responses with the specified response code that lack any Cache-Control, Expires, or Pragma: no-cache directives. When the cache mode is set to FORCE_CACHE_ALL, negative caching applies to all responses with the specified response code, and override any caching headers. By default, Cloud CDN will apply the following default TTLs to these status codes: HTTP 300 (Multiple Choice), 301, 308 (Permanent Redirects): 10m HTTP 404 (Not Found), 410 (Gone), 451 (Unavailable For Legal Reasons): 120s HTTP 405 (Method Not Found), 421 (Misdirected Request), 501 (Not Implemented): 60s. These defaults can be overridden in negative_caching_policy.
        :param pulumi.Input[Sequence[pulumi.Input['BackendBucketCdnPolicyNegativeCachingPolicyArgs']]] negative_caching_policy: Sets a cache TTL for the specified HTTP status code. negative_caching must be enabled to configure negative_caching_policy. Omitting the policy and leaving negative_caching enabled will use Cloud CDN's default cache TTLs. Note that when specifying an explicit negative_caching_policy, you should take care to specify a cache TTL for all response codes that you wish to cache. Cloud CDN will not apply any default negative caching when a policy exists.
        :param pulumi.Input[bool] request_coalescing: If true then Cloud CDN will combine multiple concurrent cache fill requests into a small number of requests to the origin.
        :param pulumi.Input[int] serve_while_stale: Serve existing content from the cache (if available) when revalidating content with the origin, or when an error is encountered when refreshing the cache. This setting defines the default "max-stale" duration for any cached responses that do not specify a max-stale directive. Stale responses that exceed the TTL configured here will not be served. The default limit (max-stale) is 86400s (1 day), which will allow stale content to be served up to this limit beyond the max-age (or s-max-age) of a cached response. The maximum allowed value is 604800 (1 week). Set this to zero (0) to disable serve-while-stale.
        :param pulumi.Input[str] signed_url_cache_max_age_sec: Maximum number of seconds the response to a signed URL request will be considered fresh. After this time period, the response will be revalidated before being served. Defaults to 1hr (3600s). When serving responses to signed URL requests, Cloud CDN will internally behave as though all responses from this backend had a "Cache-Control: public, max-age=[TTL]" header, regardless of any existing Cache-Control header. The actual headers served in responses will not be altered.
        """
        if bypass_cache_on_request_headers is not None:
            pulumi.set(__self__, "bypass_cache_on_request_headers", bypass_cache_on_request_headers)
        if cache_key_policy is not None:
            pulumi.set(__self__, "cache_key_policy", cache_key_policy)
        if cache_mode is not None:
            pulumi.set(__self__, "cache_mode", cache_mode)
        if client_ttl is not None:
            pulumi.set(__self__, "client_ttl", client_ttl)
        if default_ttl is not None:
            pulumi.set(__self__, "default_ttl", default_ttl)
        if max_ttl is not None:
            pulumi.set(__self__, "max_ttl", max_ttl)
        if negative_caching is not None:
            pulumi.set(__self__, "negative_caching", negative_caching)
        if negative_caching_policy is not None:
            pulumi.set(__self__, "negative_caching_policy", negative_caching_policy)
        if request_coalescing is not None:
            pulumi.set(__self__, "request_coalescing", request_coalescing)
        if serve_while_stale is not None:
            pulumi.set(__self__, "serve_while_stale", serve_while_stale)
        if signed_url_cache_max_age_sec is not None:
            pulumi.set(__self__, "signed_url_cache_max_age_sec", signed_url_cache_max_age_sec)

    @property
    @pulumi.getter(name="bypassCacheOnRequestHeaders")
    def bypass_cache_on_request_headers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BackendBucketCdnPolicyBypassCacheOnRequestHeaderArgs']]]]:
        """
        Bypass the cache when the specified request headers are matched - e.g. Pragma or Authorization headers. Up to 5 headers can be specified. The cache is bypassed for all cdnPolicy.cacheMode settings.
        """
        return pulumi.get(self, "bypass_cache_on_request_headers")

    @bypass_cache_on_request_headers.setter
    def bypass_cache_on_request_headers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BackendBucketCdnPolicyBypassCacheOnRequestHeaderArgs']]]]):
        pulumi.set(self, "bypass_cache_on_request_headers", value)

    @property
    @pulumi.getter(name="cacheKeyPolicy")
    def cache_key_policy(self) -> Optional[pulumi.Input['BackendBucketCdnPolicyCacheKeyPolicyArgs']]:
        """
        The CacheKeyPolicy for this CdnPolicy.
        """
        return pulumi.get(self, "cache_key_policy")

    @cache_key_policy.setter
    def cache_key_policy(self, value: Optional[pulumi.Input['BackendBucketCdnPolicyCacheKeyPolicyArgs']]):
        pulumi.set(self, "cache_key_policy", value)

    @property
    @pulumi.getter(name="cacheMode")
    def cache_mode(self) -> Optional[pulumi.Input['BackendBucketCdnPolicyCacheMode']]:
        """
        Specifies the cache setting for all responses from this backend. The possible values are: USE_ORIGIN_HEADERS Requires the origin to set valid caching headers to cache content. Responses without these headers will not be cached at Google's edge, and will require a full trip to the origin on every request, potentially impacting performance and increasing load on the origin server. FORCE_CACHE_ALL Cache all content, ignoring any "private", "no-store" or "no-cache" directives in Cache-Control response headers. Warning: this may result in Cloud CDN caching private, per-user (user identifiable) content. CACHE_ALL_STATIC Automatically cache static content, including common image formats, media (video and audio), and web assets (JavaScript and CSS). Requests and responses that are marked as uncacheable, as well as dynamic content (including HTML), will not be cached.
        """
        return pulumi.get(self, "cache_mode")

    @cache_mode.setter
    def cache_mode(self, value: Optional[pulumi.Input['BackendBucketCdnPolicyCacheMode']]):
        pulumi.set(self, "cache_mode", value)

    @property
    @pulumi.getter(name="clientTtl")
    def client_ttl(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies a separate client (e.g. browser client) maximum TTL. This is used to clamp the max-age (or Expires) value sent to the client. With FORCE_CACHE_ALL, the lesser of client_ttl and default_ttl is used for the response max-age directive, along with a "public" directive. For cacheable content in CACHE_ALL_STATIC mode, client_ttl clamps the max-age from the origin (if specified), or else sets the response max-age directive to the lesser of the client_ttl and default_ttl, and also ensures a "public" cache-control directive is present. If a client TTL is not specified, a default value (1 hour) will be used. The maximum allowed value is 31,622,400s (1 year).
        """
        return pulumi.get(self, "client_ttl")

    @client_ttl.setter
    def client_ttl(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "client_ttl", value)

    @property
    @pulumi.getter(name="defaultTtl")
    def default_ttl(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the default TTL for cached content served by this origin for responses that do not have an existing valid TTL (max-age or s-max-age). Setting a TTL of "0" means "always revalidate". The value of defaultTTL cannot be set to a value greater than that of maxTTL, but can be equal. When the cacheMode is set to FORCE_CACHE_ALL, the defaultTTL will overwrite the TTL set in all responses. The maximum allowed value is 31,622,400s (1 year), noting that infrequently accessed objects may be evicted from the cache before the defined TTL.
        """
        return pulumi.get(self, "default_ttl")

    @default_ttl.setter
    def default_ttl(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "default_ttl", value)

    @property
    @pulumi.getter(name="maxTtl")
    def max_ttl(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the maximum allowed TTL for cached content served by this origin. Cache directives that attempt to set a max-age or s-maxage higher than this, or an Expires header more than maxTTL seconds in the future will be capped at the value of maxTTL, as if it were the value of an s-maxage Cache-Control directive. Headers sent to the client will not be modified. Setting a TTL of "0" means "always revalidate". The maximum allowed value is 31,622,400s (1 year), noting that infrequently accessed objects may be evicted from the cache before the defined TTL.
        """
        return pulumi.get(self, "max_ttl")

    @max_ttl.setter
    def max_ttl(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_ttl", value)

    @property
    @pulumi.getter(name="negativeCaching")
    def negative_caching(self) -> Optional[pulumi.Input[bool]]:
        """
        Negative caching allows per-status code TTLs to be set, in order to apply fine-grained caching for common errors or redirects. This can reduce the load on your origin and improve end-user experience by reducing response latency. When the cache mode is set to CACHE_ALL_STATIC or USE_ORIGIN_HEADERS, negative caching applies to responses with the specified response code that lack any Cache-Control, Expires, or Pragma: no-cache directives. When the cache mode is set to FORCE_CACHE_ALL, negative caching applies to all responses with the specified response code, and override any caching headers. By default, Cloud CDN will apply the following default TTLs to these status codes: HTTP 300 (Multiple Choice), 301, 308 (Permanent Redirects): 10m HTTP 404 (Not Found), 410 (Gone), 451 (Unavailable For Legal Reasons): 120s HTTP 405 (Method Not Found), 421 (Misdirected Request), 501 (Not Implemented): 60s. These defaults can be overridden in negative_caching_policy.
        """
        return pulumi.get(self, "negative_caching")

    @negative_caching.setter
    def negative_caching(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "negative_caching", value)

    @property
    @pulumi.getter(name="negativeCachingPolicy")
    def negative_caching_policy(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BackendBucketCdnPolicyNegativeCachingPolicyArgs']]]]:
        """
        Sets a cache TTL for the specified HTTP status code. negative_caching must be enabled to configure negative_caching_policy. Omitting the policy and leaving negative_caching enabled will use Cloud CDN's default cache TTLs. Note that when specifying an explicit negative_caching_policy, you should take care to specify a cache TTL for all response codes that you wish to cache. Cloud CDN will not apply any default negative caching when a policy exists.
        """
        return pulumi.get(self, "negative_caching_policy")

    @negative_caching_policy.setter
    def negative_caching_policy(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BackendBucketCdnPolicyNegativeCachingPolicyArgs']]]]):
        pulumi.set(self, "negative_caching_policy", value)

    @property
    @pulumi.getter(name="requestCoalescing")
    def request_coalescing(self) -> Optional[pulumi.Input[bool]]:
        """
        If true then Cloud CDN will combine multiple concurrent cache fill requests into a small number of requests to the origin.
        """
        return pulumi.get(self, "request_coalescing")

    @request_coalescing.setter
    def request_coalescing(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "request_coalescing", value)

    @property
    @pulumi.getter(name="serveWhileStale")
    def serve_while_stale(self) -> Optional[pulumi.Input[int]]:
        """
        Serve existing content from the cache (if available) when revalidating content with the origin, or when an error is encountered when refreshing the cache. This setting defines the default "max-stale" duration for any cached responses that do not specify a max-stale directive. Stale responses that exceed the TTL configured here will not be served. The default limit (max-stale) is 86400s (1 day), which will allow stale content to be served up to this limit beyond the max-age (or s-max-age) of a cached response. The maximum allowed value is 604800 (1 week). Set this to zero (0) to disable serve-while-stale.
        """
        return pulumi.get(self, "serve_while_stale")

    @serve_while_stale.setter
    def serve_while_stale(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "serve_while_stale", value)

    @property
    @pulumi.getter(name="signedUrlCacheMaxAgeSec")
    def signed_url_cache_max_age_sec(self) -> Optional[pulumi.Input[str]]:
        """
        Maximum number of seconds the response to a signed URL request will be considered fresh. After this time period, the response will be revalidated before being served. Defaults to 1hr (3600s). When serving responses to signed URL requests, Cloud CDN will internally behave as though all responses from this backend had a "Cache-Control: public, max-age=[TTL]" header, regardless of any existing Cache-Control header. The actual headers served in responses will not be altered.
        """
        return pulumi.get(self, "signed_url_cache_max_age_sec")

    @signed_url_cache_max_age_sec.setter
    def signed_url_cache_max_age_sec(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "signed_url_cache_max_age_sec", value)


@pulumi.input_type
class BackendServiceCdnPolicyBypassCacheOnRequestHeaderArgs:
    def __init__(__self__, *,
                 header_name: Optional[pulumi.Input[str]] = None):
        """
        Bypass the cache when the specified request headers are present, e.g. Pragma or Authorization headers. Values are case insensitive. The presence of such a header overrides the cache_mode setting.
        :param pulumi.Input[str] header_name: The header field name to match on when bypassing cache. Values are case-insensitive.
        """
        if header_name is not None:
            pulumi.set(__self__, "header_name", header_name)

    @property
    @pulumi.getter(name="headerName")
    def header_name(self) -> Optional[pulumi.Input[str]]:
        """
        The header field name to match on when bypassing cache. Values are case-insensitive.
        """
        return pulumi.get(self, "header_name")

    @header_name.setter
    def header_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "header_name", value)


@pulumi.input_type
class BackendServiceCdnPolicyNegativeCachingPolicyArgs:
    def __init__(__self__, *,
                 code: Optional[pulumi.Input[int]] = None,
                 ttl: Optional[pulumi.Input[int]] = None):
        """
        Specify CDN TTLs for response error codes.
        :param pulumi.Input[int] code: The HTTP status code to define a TTL against. Only HTTP status codes 300, 301, 302, 307, 308, 404, 405, 410, 421, 451 and 501 are can be specified as values, and you cannot specify a status code more than once.
        :param pulumi.Input[int] ttl: The TTL (in seconds) for which to cache responses with the corresponding status code. The maximum allowed value is 1800s (30 minutes), noting that infrequently accessed objects may be evicted from the cache before the defined TTL.
        """
        if code is not None:
            pulumi.set(__self__, "code", code)
        if ttl is not None:
            pulumi.set(__self__, "ttl", ttl)

    @property
    @pulumi.getter
    def code(self) -> Optional[pulumi.Input[int]]:
        """
        The HTTP status code to define a TTL against. Only HTTP status codes 300, 301, 302, 307, 308, 404, 405, 410, 421, 451 and 501 are can be specified as values, and you cannot specify a status code more than once.
        """
        return pulumi.get(self, "code")

    @code.setter
    def code(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "code", value)

    @property
    @pulumi.getter
    def ttl(self) -> Optional[pulumi.Input[int]]:
        """
        The TTL (in seconds) for which to cache responses with the corresponding status code. The maximum allowed value is 1800s (30 minutes), noting that infrequently accessed objects may be evicted from the cache before the defined TTL.
        """
        return pulumi.get(self, "ttl")

    @ttl.setter
    def ttl(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ttl", value)


@pulumi.input_type
class BackendServiceCdnPolicyArgs:
    def __init__(__self__, *,
                 bypass_cache_on_request_headers: Optional[pulumi.Input[Sequence[pulumi.Input['BackendServiceCdnPolicyBypassCacheOnRequestHeaderArgs']]]] = None,
                 cache_key_policy: Optional[pulumi.Input['CacheKeyPolicyArgs']] = None,
                 cache_mode: Optional[pulumi.Input['BackendServiceCdnPolicyCacheMode']] = None,
                 client_ttl: Optional[pulumi.Input[int]] = None,
                 default_ttl: Optional[pulumi.Input[int]] = None,
                 max_ttl: Optional[pulumi.Input[int]] = None,
                 negative_caching: Optional[pulumi.Input[bool]] = None,
                 negative_caching_policy: Optional[pulumi.Input[Sequence[pulumi.Input['BackendServiceCdnPolicyNegativeCachingPolicyArgs']]]] = None,
                 request_coalescing: Optional[pulumi.Input[bool]] = None,
                 serve_while_stale: Optional[pulumi.Input[int]] = None,
                 signed_url_cache_max_age_sec: Optional[pulumi.Input[str]] = None):
        """
        Message containing Cloud CDN configuration for a backend service.
        :param pulumi.Input[Sequence[pulumi.Input['BackendServiceCdnPolicyBypassCacheOnRequestHeaderArgs']]] bypass_cache_on_request_headers: Bypass the cache when the specified request headers are matched - e.g. Pragma or Authorization headers. Up to 5 headers can be specified. The cache is bypassed for all cdnPolicy.cacheMode settings.
        :param pulumi.Input['CacheKeyPolicyArgs'] cache_key_policy: The CacheKeyPolicy for this CdnPolicy.
        :param pulumi.Input['BackendServiceCdnPolicyCacheMode'] cache_mode: Specifies the cache setting for all responses from this backend. The possible values are: USE_ORIGIN_HEADERS Requires the origin to set valid caching headers to cache content. Responses without these headers will not be cached at Google's edge, and will require a full trip to the origin on every request, potentially impacting performance and increasing load on the origin server. FORCE_CACHE_ALL Cache all content, ignoring any "private", "no-store" or "no-cache" directives in Cache-Control response headers. Warning: this may result in Cloud CDN caching private, per-user (user identifiable) content. CACHE_ALL_STATIC Automatically cache static content, including common image formats, media (video and audio), and web assets (JavaScript and CSS). Requests and responses that are marked as uncacheable, as well as dynamic content (including HTML), will not be cached.
        :param pulumi.Input[int] client_ttl: Specifies a separate client (e.g. browser client) maximum TTL. This is used to clamp the max-age (or Expires) value sent to the client. With FORCE_CACHE_ALL, the lesser of client_ttl and default_ttl is used for the response max-age directive, along with a "public" directive. For cacheable content in CACHE_ALL_STATIC mode, client_ttl clamps the max-age from the origin (if specified), or else sets the response max-age directive to the lesser of the client_ttl and default_ttl, and also ensures a "public" cache-control directive is present. If a client TTL is not specified, a default value (1 hour) will be used. The maximum allowed value is 31,622,400s (1 year).
        :param pulumi.Input[int] default_ttl: Specifies the default TTL for cached content served by this origin for responses that do not have an existing valid TTL (max-age or s-max-age). Setting a TTL of "0" means "always revalidate". The value of defaultTTL cannot be set to a value greater than that of maxTTL, but can be equal. When the cacheMode is set to FORCE_CACHE_ALL, the defaultTTL will overwrite the TTL set in all responses. The maximum allowed value is 31,622,400s (1 year), noting that infrequently accessed objects may be evicted from the cache before the defined TTL.
        :param pulumi.Input[int] max_ttl: Specifies the maximum allowed TTL for cached content served by this origin. Cache directives that attempt to set a max-age or s-maxage higher than this, or an Expires header more than maxTTL seconds in the future will be capped at the value of maxTTL, as if it were the value of an s-maxage Cache-Control directive. Headers sent to the client will not be modified. Setting a TTL of "0" means "always revalidate". The maximum allowed value is 31,622,400s (1 year), noting that infrequently accessed objects may be evicted from the cache before the defined TTL.
        :param pulumi.Input[bool] negative_caching: Negative caching allows per-status code TTLs to be set, in order to apply fine-grained caching for common errors or redirects. This can reduce the load on your origin and improve end-user experience by reducing response latency. When the cache mode is set to CACHE_ALL_STATIC or USE_ORIGIN_HEADERS, negative caching applies to responses with the specified response code that lack any Cache-Control, Expires, or Pragma: no-cache directives. When the cache mode is set to FORCE_CACHE_ALL, negative caching applies to all responses with the specified response code, and override any caching headers. By default, Cloud CDN will apply the following default TTLs to these status codes: HTTP 300 (Multiple Choice), 301, 308 (Permanent Redirects): 10m HTTP 404 (Not Found), 410 (Gone), 451 (Unavailable For Legal Reasons): 120s HTTP 405 (Method Not Found), 421 (Misdirected Request), 501 (Not Implemented): 60s. These defaults can be overridden in negative_caching_policy.
        :param pulumi.Input[Sequence[pulumi.Input['BackendServiceCdnPolicyNegativeCachingPolicyArgs']]] negative_caching_policy: Sets a cache TTL for the specified HTTP status code. negative_caching must be enabled to configure negative_caching_policy. Omitting the policy and leaving negative_caching enabled will use Cloud CDN's default cache TTLs. Note that when specifying an explicit negative_caching_policy, you should take care to specify a cache TTL for all response codes that you wish to cache. Cloud CDN will not apply any default negative caching when a policy exists.
        :param pulumi.Input[bool] request_coalescing: If true then Cloud CDN will combine multiple concurrent cache fill requests into a small number of requests to the origin.
        :param pulumi.Input[int] serve_while_stale: Serve existing content from the cache (if available) when revalidating content with the origin, or when an error is encountered when refreshing the cache. This setting defines the default "max-stale" duration for any cached responses that do not specify a max-stale directive. Stale responses that exceed the TTL configured here will not be served. The default limit (max-stale) is 86400s (1 day), which will allow stale content to be served up to this limit beyond the max-age (or s-max-age) of a cached response. The maximum allowed value is 604800 (1 week). Set this to zero (0) to disable serve-while-stale.
        :param pulumi.Input[str] signed_url_cache_max_age_sec: Maximum number of seconds the response to a signed URL request will be considered fresh. After this time period, the response will be revalidated before being served. Defaults to 1hr (3600s). When serving responses to signed URL requests, Cloud CDN will internally behave as though all responses from this backend had a "Cache-Control: public, max-age=[TTL]" header, regardless of any existing Cache-Control header. The actual headers served in responses will not be altered.
        """
        if bypass_cache_on_request_headers is not None:
            pulumi.set(__self__, "bypass_cache_on_request_headers", bypass_cache_on_request_headers)
        if cache_key_policy is not None:
            pulumi.set(__self__, "cache_key_policy", cache_key_policy)
        if cache_mode is not None:
            pulumi.set(__self__, "cache_mode", cache_mode)
        if client_ttl is not None:
            pulumi.set(__self__, "client_ttl", client_ttl)
        if default_ttl is not None:
            pulumi.set(__self__, "default_ttl", default_ttl)
        if max_ttl is not None:
            pulumi.set(__self__, "max_ttl", max_ttl)
        if negative_caching is not None:
            pulumi.set(__self__, "negative_caching", negative_caching)
        if negative_caching_policy is not None:
            pulumi.set(__self__, "negative_caching_policy", negative_caching_policy)
        if request_coalescing is not None:
            pulumi.set(__self__, "request_coalescing", request_coalescing)
        if serve_while_stale is not None:
            pulumi.set(__self__, "serve_while_stale", serve_while_stale)
        if signed_url_cache_max_age_sec is not None:
            pulumi.set(__self__, "signed_url_cache_max_age_sec", signed_url_cache_max_age_sec)

    @property
    @pulumi.getter(name="bypassCacheOnRequestHeaders")
    def bypass_cache_on_request_headers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BackendServiceCdnPolicyBypassCacheOnRequestHeaderArgs']]]]:
        """
        Bypass the cache when the specified request headers are matched - e.g. Pragma or Authorization headers. Up to 5 headers can be specified. The cache is bypassed for all cdnPolicy.cacheMode settings.
        """
        return pulumi.get(self, "bypass_cache_on_request_headers")

    @bypass_cache_on_request_headers.setter
    def bypass_cache_on_request_headers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BackendServiceCdnPolicyBypassCacheOnRequestHeaderArgs']]]]):
        pulumi.set(self, "bypass_cache_on_request_headers", value)

    @property
    @pulumi.getter(name="cacheKeyPolicy")
    def cache_key_policy(self) -> Optional[pulumi.Input['CacheKeyPolicyArgs']]:
        """
        The CacheKeyPolicy for this CdnPolicy.
        """
        return pulumi.get(self, "cache_key_policy")

    @cache_key_policy.setter
    def cache_key_policy(self, value: Optional[pulumi.Input['CacheKeyPolicyArgs']]):
        pulumi.set(self, "cache_key_policy", value)

    @property
    @pulumi.getter(name="cacheMode")
    def cache_mode(self) -> Optional[pulumi.Input['BackendServiceCdnPolicyCacheMode']]:
        """
        Specifies the cache setting for all responses from this backend. The possible values are: USE_ORIGIN_HEADERS Requires the origin to set valid caching headers to cache content. Responses without these headers will not be cached at Google's edge, and will require a full trip to the origin on every request, potentially impacting performance and increasing load on the origin server. FORCE_CACHE_ALL Cache all content, ignoring any "private", "no-store" or "no-cache" directives in Cache-Control response headers. Warning: this may result in Cloud CDN caching private, per-user (user identifiable) content. CACHE_ALL_STATIC Automatically cache static content, including common image formats, media (video and audio), and web assets (JavaScript and CSS). Requests and responses that are marked as uncacheable, as well as dynamic content (including HTML), will not be cached.
        """
        return pulumi.get(self, "cache_mode")

    @cache_mode.setter
    def cache_mode(self, value: Optional[pulumi.Input['BackendServiceCdnPolicyCacheMode']]):
        pulumi.set(self, "cache_mode", value)

    @property
    @pulumi.getter(name="clientTtl")
    def client_ttl(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies a separate client (e.g. browser client) maximum TTL. This is used to clamp the max-age (or Expires) value sent to the client. With FORCE_CACHE_ALL, the lesser of client_ttl and default_ttl is used for the response max-age directive, along with a "public" directive. For cacheable content in CACHE_ALL_STATIC mode, client_ttl clamps the max-age from the origin (if specified), or else sets the response max-age directive to the lesser of the client_ttl and default_ttl, and also ensures a "public" cache-control directive is present. If a client TTL is not specified, a default value (1 hour) will be used. The maximum allowed value is 31,622,400s (1 year).
        """
        return pulumi.get(self, "client_ttl")

    @client_ttl.setter
    def client_ttl(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "client_ttl", value)

    @property
    @pulumi.getter(name="defaultTtl")
    def default_ttl(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the default TTL for cached content served by this origin for responses that do not have an existing valid TTL (max-age or s-max-age). Setting a TTL of "0" means "always revalidate". The value of defaultTTL cannot be set to a value greater than that of maxTTL, but can be equal. When the cacheMode is set to FORCE_CACHE_ALL, the defaultTTL will overwrite the TTL set in all responses. The maximum allowed value is 31,622,400s (1 year), noting that infrequently accessed objects may be evicted from the cache before the defined TTL.
        """
        return pulumi.get(self, "default_ttl")

    @default_ttl.setter
    def default_ttl(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "default_ttl", value)

    @property
    @pulumi.getter(name="maxTtl")
    def max_ttl(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the maximum allowed TTL for cached content served by this origin. Cache directives that attempt to set a max-age or s-maxage higher than this, or an Expires header more than maxTTL seconds in the future will be capped at the value of maxTTL, as if it were the value of an s-maxage Cache-Control directive. Headers sent to the client will not be modified. Setting a TTL of "0" means "always revalidate". The maximum allowed value is 31,622,400s (1 year), noting that infrequently accessed objects may be evicted from the cache before the defined TTL.
        """
        return pulumi.get(self, "max_ttl")

    @max_ttl.setter
    def max_ttl(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_ttl", value)

    @property
    @pulumi.getter(name="negativeCaching")
    def negative_caching(self) -> Optional[pulumi.Input[bool]]:
        """
        Negative caching allows per-status code TTLs to be set, in order to apply fine-grained caching for common errors or redirects. This can reduce the load on your origin and improve end-user experience by reducing response latency. When the cache mode is set to CACHE_ALL_STATIC or USE_ORIGIN_HEADERS, negative caching applies to responses with the specified response code that lack any Cache-Control, Expires, or Pragma: no-cache directives. When the cache mode is set to FORCE_CACHE_ALL, negative caching applies to all responses with the specified response code, and override any caching headers. By default, Cloud CDN will apply the following default TTLs to these status codes: HTTP 300 (Multiple Choice), 301, 308 (Permanent Redirects): 10m HTTP 404 (Not Found), 410 (Gone), 451 (Unavailable For Legal Reasons): 120s HTTP 405 (Method Not Found), 421 (Misdirected Request), 501 (Not Implemented): 60s. These defaults can be overridden in negative_caching_policy.
        """
        return pulumi.get(self, "negative_caching")

    @negative_caching.setter
    def negative_caching(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "negative_caching", value)

    @property
    @pulumi.getter(name="negativeCachingPolicy")
    def negative_caching_policy(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BackendServiceCdnPolicyNegativeCachingPolicyArgs']]]]:
        """
        Sets a cache TTL for the specified HTTP status code. negative_caching must be enabled to configure negative_caching_policy. Omitting the policy and leaving negative_caching enabled will use Cloud CDN's default cache TTLs. Note that when specifying an explicit negative_caching_policy, you should take care to specify a cache TTL for all response codes that you wish to cache. Cloud CDN will not apply any default negative caching when a policy exists.
        """
        return pulumi.get(self, "negative_caching_policy")

    @negative_caching_policy.setter
    def negative_caching_policy(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BackendServiceCdnPolicyNegativeCachingPolicyArgs']]]]):
        pulumi.set(self, "negative_caching_policy", value)

    @property
    @pulumi.getter(name="requestCoalescing")
    def request_coalescing(self) -> Optional[pulumi.Input[bool]]:
        """
        If true then Cloud CDN will combine multiple concurrent cache fill requests into a small number of requests to the origin.
        """
        return pulumi.get(self, "request_coalescing")

    @request_coalescing.setter
    def request_coalescing(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "request_coalescing", value)

    @property
    @pulumi.getter(name="serveWhileStale")
    def serve_while_stale(self) -> Optional[pulumi.Input[int]]:
        """
        Serve existing content from the cache (if available) when revalidating content with the origin, or when an error is encountered when refreshing the cache. This setting defines the default "max-stale" duration for any cached responses that do not specify a max-stale directive. Stale responses that exceed the TTL configured here will not be served. The default limit (max-stale) is 86400s (1 day), which will allow stale content to be served up to this limit beyond the max-age (or s-max-age) of a cached response. The maximum allowed value is 604800 (1 week). Set this to zero (0) to disable serve-while-stale.
        """
        return pulumi.get(self, "serve_while_stale")

    @serve_while_stale.setter
    def serve_while_stale(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "serve_while_stale", value)

    @property
    @pulumi.getter(name="signedUrlCacheMaxAgeSec")
    def signed_url_cache_max_age_sec(self) -> Optional[pulumi.Input[str]]:
        """
        Maximum number of seconds the response to a signed URL request will be considered fresh. After this time period, the response will be revalidated before being served. Defaults to 1hr (3600s). When serving responses to signed URL requests, Cloud CDN will internally behave as though all responses from this backend had a "Cache-Control: public, max-age=[TTL]" header, regardless of any existing Cache-Control header. The actual headers served in responses will not be altered.
        """
        return pulumi.get(self, "signed_url_cache_max_age_sec")

    @signed_url_cache_max_age_sec.setter
    def signed_url_cache_max_age_sec(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "signed_url_cache_max_age_sec", value)


@pulumi.input_type
class BackendServiceConnectionTrackingPolicyArgs:
    def __init__(__self__, *,
                 connection_persistence_on_unhealthy_backends: Optional[pulumi.Input['BackendServiceConnectionTrackingPolicyConnectionPersistenceOnUnhealthyBackends']] = None,
                 enable_strong_affinity: Optional[pulumi.Input[bool]] = None,
                 idle_timeout_sec: Optional[pulumi.Input[int]] = None,
                 tracking_mode: Optional[pulumi.Input['BackendServiceConnectionTrackingPolicyTrackingMode']] = None):
        """
        Connection Tracking configuration for this BackendService.
        :param pulumi.Input['BackendServiceConnectionTrackingPolicyConnectionPersistenceOnUnhealthyBackends'] connection_persistence_on_unhealthy_backends: Specifies connection persistence when backends are unhealthy. The default value is DEFAULT_FOR_PROTOCOL. If set to DEFAULT_FOR_PROTOCOL, the existing connections persist on unhealthy backends only for connection-oriented protocols (TCP and SCTP) and only if the Tracking Mode is PER_CONNECTION (default tracking mode) or the Session Affinity is configured for 5-tuple. They do not persist for UDP. If set to NEVER_PERSIST, after a backend becomes unhealthy, the existing connections on the unhealthy backend are never persisted on the unhealthy backend. They are always diverted to newly selected healthy backends (unless all backends are unhealthy). If set to ALWAYS_PERSIST, existing connections always persist on unhealthy backends regardless of protocol and session affinity. It is generally not recommended to use this mode overriding the default. For more details, see [Connection Persistence for Network Load Balancing](https://cloud.google.com/load-balancing/docs/network/networklb-backend-service#connection-persistence) and [Connection Persistence for Internal TCP/UDP Load Balancing](https://cloud.google.com/load-balancing/docs/internal#connection-persistence).
        :param pulumi.Input[bool] enable_strong_affinity: Enable Strong Session Affinity for Network Load Balancing. This option is not available publicly.
        :param pulumi.Input[int] idle_timeout_sec: Specifies how long to keep a Connection Tracking entry while there is no matching traffic (in seconds). For Internal TCP/UDP Load Balancing: - The minimum (default) is 10 minutes and the maximum is 16 hours. - It can be set only if Connection Tracking is less than 5-tuple (i.e. Session Affinity is CLIENT_IP_NO_DESTINATION, CLIENT_IP or CLIENT_IP_PROTO, and Tracking Mode is PER_SESSION). For Network Load Balancer the default is 60 seconds. This option is not available publicly.
        :param pulumi.Input['BackendServiceConnectionTrackingPolicyTrackingMode'] tracking_mode: Specifies the key used for connection tracking. There are two options: - PER_CONNECTION: This is the default mode. The Connection Tracking is performed as per the Connection Key (default Hash Method) for the specific protocol. - PER_SESSION: The Connection Tracking is performed as per the configured Session Affinity. It matches the configured Session Affinity. For more details, see [Tracking Mode for Network Load Balancing](https://cloud.google.com/load-balancing/docs/network/networklb-backend-service#tracking-mode) and [Tracking Mode for Internal TCP/UDP Load Balancing](https://cloud.google.com/load-balancing/docs/internal#tracking-mode).
        """
        if connection_persistence_on_unhealthy_backends is not None:
            pulumi.set(__self__, "connection_persistence_on_unhealthy_backends", connection_persistence_on_unhealthy_backends)
        if enable_strong_affinity is not None:
            pulumi.set(__self__, "enable_strong_affinity", enable_strong_affinity)
        if idle_timeout_sec is not None:
            pulumi.set(__self__, "idle_timeout_sec", idle_timeout_sec)
        if tracking_mode is not None:
            pulumi.set(__self__, "tracking_mode", tracking_mode)

    @property
    @pulumi.getter(name="connectionPersistenceOnUnhealthyBackends")
    def connection_persistence_on_unhealthy_backends(self) -> Optional[pulumi.Input['BackendServiceConnectionTrackingPolicyConnectionPersistenceOnUnhealthyBackends']]:
        """
        Specifies connection persistence when backends are unhealthy. The default value is DEFAULT_FOR_PROTOCOL. If set to DEFAULT_FOR_PROTOCOL, the existing connections persist on unhealthy backends only for connection-oriented protocols (TCP and SCTP) and only if the Tracking Mode is PER_CONNECTION (default tracking mode) or the Session Affinity is configured for 5-tuple. They do not persist for UDP. If set to NEVER_PERSIST, after a backend becomes unhealthy, the existing connections on the unhealthy backend are never persisted on the unhealthy backend. They are always diverted to newly selected healthy backends (unless all backends are unhealthy). If set to ALWAYS_PERSIST, existing connections always persist on unhealthy backends regardless of protocol and session affinity. It is generally not recommended to use this mode overriding the default. For more details, see [Connection Persistence for Network Load Balancing](https://cloud.google.com/load-balancing/docs/network/networklb-backend-service#connection-persistence) and [Connection Persistence for Internal TCP/UDP Load Balancing](https://cloud.google.com/load-balancing/docs/internal#connection-persistence).
        """
        return pulumi.get(self, "connection_persistence_on_unhealthy_backends")

    @connection_persistence_on_unhealthy_backends.setter
    def connection_persistence_on_unhealthy_backends(self, value: Optional[pulumi.Input['BackendServiceConnectionTrackingPolicyConnectionPersistenceOnUnhealthyBackends']]):
        pulumi.set(self, "connection_persistence_on_unhealthy_backends", value)

    @property
    @pulumi.getter(name="enableStrongAffinity")
    def enable_strong_affinity(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable Strong Session Affinity for Network Load Balancing. This option is not available publicly.
        """
        return pulumi.get(self, "enable_strong_affinity")

    @enable_strong_affinity.setter
    def enable_strong_affinity(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_strong_affinity", value)

    @property
    @pulumi.getter(name="idleTimeoutSec")
    def idle_timeout_sec(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies how long to keep a Connection Tracking entry while there is no matching traffic (in seconds). For Internal TCP/UDP Load Balancing: - The minimum (default) is 10 minutes and the maximum is 16 hours. - It can be set only if Connection Tracking is less than 5-tuple (i.e. Session Affinity is CLIENT_IP_NO_DESTINATION, CLIENT_IP or CLIENT_IP_PROTO, and Tracking Mode is PER_SESSION). For Network Load Balancer the default is 60 seconds. This option is not available publicly.
        """
        return pulumi.get(self, "idle_timeout_sec")

    @idle_timeout_sec.setter
    def idle_timeout_sec(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "idle_timeout_sec", value)

    @property
    @pulumi.getter(name="trackingMode")
    def tracking_mode(self) -> Optional[pulumi.Input['BackendServiceConnectionTrackingPolicyTrackingMode']]:
        """
        Specifies the key used for connection tracking. There are two options: - PER_CONNECTION: This is the default mode. The Connection Tracking is performed as per the Connection Key (default Hash Method) for the specific protocol. - PER_SESSION: The Connection Tracking is performed as per the configured Session Affinity. It matches the configured Session Affinity. For more details, see [Tracking Mode for Network Load Balancing](https://cloud.google.com/load-balancing/docs/network/networklb-backend-service#tracking-mode) and [Tracking Mode for Internal TCP/UDP Load Balancing](https://cloud.google.com/load-balancing/docs/internal#tracking-mode).
        """
        return pulumi.get(self, "tracking_mode")

    @tracking_mode.setter
    def tracking_mode(self, value: Optional[pulumi.Input['BackendServiceConnectionTrackingPolicyTrackingMode']]):
        pulumi.set(self, "tracking_mode", value)


@pulumi.input_type
class BackendServiceFailoverPolicyArgs:
    def __init__(__self__, *,
                 disable_connection_drain_on_failover: Optional[pulumi.Input[bool]] = None,
                 drop_traffic_if_unhealthy: Optional[pulumi.Input[bool]] = None,
                 failover_ratio: Optional[pulumi.Input[float]] = None):
        """
        For load balancers that have configurable failover: [Internal TCP/UDP Load Balancing](https://cloud.google.com/load-balancing/docs/internal/failover-overview) and [external TCP/UDP Load Balancing](https://cloud.google.com/load-balancing/docs/network/networklb-failover-overview). On failover or failback, this field indicates whether connection draining will be honored. Google Cloud has a fixed connection draining timeout of 10 minutes. A setting of true terminates existing TCP connections to the active pool during failover and failback, immediately draining traffic. A setting of false allows existing TCP connections to persist, even on VMs no longer in the active pool, for up to the duration of the connection draining timeout (10 minutes).
        :param pulumi.Input[bool] disable_connection_drain_on_failover: This can be set to true only if the protocol is TCP. The default is false.
        :param pulumi.Input[bool] drop_traffic_if_unhealthy: If set to true, connections to the load balancer are dropped when all primary and all backup backend VMs are unhealthy.If set to false, connections are distributed among all primary VMs when all primary and all backup backend VMs are unhealthy. For load balancers that have configurable failover: [Internal TCP/UDP Load Balancing](https://cloud.google.com/load-balancing/docs/internal/failover-overview) and [external TCP/UDP Load Balancing](https://cloud.google.com/load-balancing/docs/network/networklb-failover-overview). The default is false.
        :param pulumi.Input[float] failover_ratio: The value of the field must be in the range [0, 1]. If the value is 0, the load balancer performs a failover when the number of healthy primary VMs equals zero. For all other values, the load balancer performs a failover when the total number of healthy primary VMs is less than this ratio. For load balancers that have configurable failover: [Internal TCP/UDP Load Balancing](https://cloud.google.com/load-balancing/docs/internal/failover-overview) and [external TCP/UDP Load Balancing](https://cloud.google.com/load-balancing/docs/network/networklb-failover-overview).
        """
        if disable_connection_drain_on_failover is not None:
            pulumi.set(__self__, "disable_connection_drain_on_failover", disable_connection_drain_on_failover)
        if drop_traffic_if_unhealthy is not None:
            pulumi.set(__self__, "drop_traffic_if_unhealthy", drop_traffic_if_unhealthy)
        if failover_ratio is not None:
            pulumi.set(__self__, "failover_ratio", failover_ratio)

    @property
    @pulumi.getter(name="disableConnectionDrainOnFailover")
    def disable_connection_drain_on_failover(self) -> Optional[pulumi.Input[bool]]:
        """
        This can be set to true only if the protocol is TCP. The default is false.
        """
        return pulumi.get(self, "disable_connection_drain_on_failover")

    @disable_connection_drain_on_failover.setter
    def disable_connection_drain_on_failover(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disable_connection_drain_on_failover", value)

    @property
    @pulumi.getter(name="dropTrafficIfUnhealthy")
    def drop_traffic_if_unhealthy(self) -> Optional[pulumi.Input[bool]]:
        """
        If set to true, connections to the load balancer are dropped when all primary and all backup backend VMs are unhealthy.If set to false, connections are distributed among all primary VMs when all primary and all backup backend VMs are unhealthy. For load balancers that have configurable failover: [Internal TCP/UDP Load Balancing](https://cloud.google.com/load-balancing/docs/internal/failover-overview) and [external TCP/UDP Load Balancing](https://cloud.google.com/load-balancing/docs/network/networklb-failover-overview). The default is false.
        """
        return pulumi.get(self, "drop_traffic_if_unhealthy")

    @drop_traffic_if_unhealthy.setter
    def drop_traffic_if_unhealthy(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "drop_traffic_if_unhealthy", value)

    @property
    @pulumi.getter(name="failoverRatio")
    def failover_ratio(self) -> Optional[pulumi.Input[float]]:
        """
        The value of the field must be in the range [0, 1]. If the value is 0, the load balancer performs a failover when the number of healthy primary VMs equals zero. For all other values, the load balancer performs a failover when the total number of healthy primary VMs is less than this ratio. For load balancers that have configurable failover: [Internal TCP/UDP Load Balancing](https://cloud.google.com/load-balancing/docs/internal/failover-overview) and [external TCP/UDP Load Balancing](https://cloud.google.com/load-balancing/docs/network/networklb-failover-overview).
        """
        return pulumi.get(self, "failover_ratio")

    @failover_ratio.setter
    def failover_ratio(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "failover_ratio", value)


@pulumi.input_type
class BackendServiceIAPArgs:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 oauth2_client_id: Optional[pulumi.Input[str]] = None,
                 oauth2_client_secret: Optional[pulumi.Input[str]] = None):
        """
        Identity-Aware Proxy
        :param pulumi.Input[bool] enabled: Whether the serving infrastructure will authenticate and authorize all incoming requests. If true, the oauth2ClientId and oauth2ClientSecret fields must be non-empty.
        :param pulumi.Input[str] oauth2_client_id: OAuth2 client ID to use for the authentication flow.
        :param pulumi.Input[str] oauth2_client_secret: OAuth2 client secret to use for the authentication flow. For security reasons, this value cannot be retrieved via the API. Instead, the SHA-256 hash of the value is returned in the oauth2ClientSecretSha256 field. @InputOnly
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if oauth2_client_id is not None:
            pulumi.set(__self__, "oauth2_client_id", oauth2_client_id)
        if oauth2_client_secret is not None:
            pulumi.set(__self__, "oauth2_client_secret", oauth2_client_secret)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the serving infrastructure will authenticate and authorize all incoming requests. If true, the oauth2ClientId and oauth2ClientSecret fields must be non-empty.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="oauth2ClientId")
    def oauth2_client_id(self) -> Optional[pulumi.Input[str]]:
        """
        OAuth2 client ID to use for the authentication flow.
        """
        return pulumi.get(self, "oauth2_client_id")

    @oauth2_client_id.setter
    def oauth2_client_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "oauth2_client_id", value)

    @property
    @pulumi.getter(name="oauth2ClientSecret")
    def oauth2_client_secret(self) -> Optional[pulumi.Input[str]]:
        """
        OAuth2 client secret to use for the authentication flow. For security reasons, this value cannot be retrieved via the API. Instead, the SHA-256 hash of the value is returned in the oauth2ClientSecretSha256 field. @InputOnly
        """
        return pulumi.get(self, "oauth2_client_secret")

    @oauth2_client_secret.setter
    def oauth2_client_secret(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "oauth2_client_secret", value)


@pulumi.input_type
class BackendServiceLogConfigArgs:
    def __init__(__self__, *,
                 enable: Optional[pulumi.Input[bool]] = None,
                 sample_rate: Optional[pulumi.Input[float]] = None):
        """
        The available logging options for the load balancer traffic served by this backend service.
        :param pulumi.Input[bool] enable: This field denotes whether to enable logging for the load balancer traffic served by this backend service.
        :param pulumi.Input[float] sample_rate: This field can only be specified if logging is enabled for this backend service. The value of the field must be in [0, 1]. This configures the sampling rate of requests to the load balancer where 1.0 means all logged requests are reported and 0.0 means no logged requests are reported. The default value is 1.0.
        """
        if enable is not None:
            pulumi.set(__self__, "enable", enable)
        if sample_rate is not None:
            pulumi.set(__self__, "sample_rate", sample_rate)

    @property
    @pulumi.getter
    def enable(self) -> Optional[pulumi.Input[bool]]:
        """
        This field denotes whether to enable logging for the load balancer traffic served by this backend service.
        """
        return pulumi.get(self, "enable")

    @enable.setter
    def enable(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable", value)

    @property
    @pulumi.getter(name="sampleRate")
    def sample_rate(self) -> Optional[pulumi.Input[float]]:
        """
        This field can only be specified if logging is enabled for this backend service. The value of the field must be in [0, 1]. This configures the sampling rate of requests to the load balancer where 1.0 means all logged requests are reported and 0.0 means no logged requests are reported. The default value is 1.0.
        """
        return pulumi.get(self, "sample_rate")

    @sample_rate.setter
    def sample_rate(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "sample_rate", value)


@pulumi.input_type
class BackendArgs:
    def __init__(__self__, *,
                 balancing_mode: Optional[pulumi.Input['BackendBalancingMode']] = None,
                 capacity_scaler: Optional[pulumi.Input[float]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 failover: Optional[pulumi.Input[bool]] = None,
                 group: Optional[pulumi.Input[str]] = None,
                 max_connections: Optional[pulumi.Input[int]] = None,
                 max_connections_per_endpoint: Optional[pulumi.Input[int]] = None,
                 max_connections_per_instance: Optional[pulumi.Input[int]] = None,
                 max_rate: Optional[pulumi.Input[int]] = None,
                 max_rate_per_endpoint: Optional[pulumi.Input[float]] = None,
                 max_rate_per_instance: Optional[pulumi.Input[float]] = None,
                 max_utilization: Optional[pulumi.Input[float]] = None):
        """
        Message containing information of one individual backend.
        :param pulumi.Input['BackendBalancingMode'] balancing_mode: Specifies how to determine whether the backend of a load balancer can handle additional traffic or is fully loaded. For usage guidelines, see Connection balancing mode. Backends must use compatible balancing modes. For more information, see Supported balancing modes and target capacity settings and Restrictions and guidance for instance groups. Note: Currently, if you use the API to configure incompatible balancing modes, the configuration might be accepted even though it has no impact and is ignored. Specifically, Backend.maxUtilization is ignored when Backend.balancingMode is RATE. In the future, this incompatible combination will be rejected.
        :param pulumi.Input[float] capacity_scaler: A multiplier applied to the backend's target capacity of its balancing mode. The default value is 1, which means the group serves up to 100% of its configured capacity (depending on balancingMode). A setting of 0 means the group is completely drained, offering 0% of its available capacity. The valid ranges are 0.0 and [0.1,1.0]. You cannot configure a setting larger than 0 and smaller than 0.1. You cannot configure a setting of 0 when there is only one backend attached to the backend service.
        :param pulumi.Input[str] description: An optional description of this resource. Provide this property when you create the resource.
        :param pulumi.Input[bool] failover: This field designates whether this is a failover backend. More than one failover backend can be configured for a given BackendService.
        :param pulumi.Input[str] group: The fully-qualified URL of an instance group or network endpoint group (NEG) resource. To determine what types of backends a load balancer supports, see the [Backend services overview](https://cloud.google.com/load-balancing/docs/backend-service#backends). You must use the *fully-qualified* URL (starting with https://www.googleapis.com/) to specify the instance group or NEG. Partial URLs are not supported.
        :param pulumi.Input[int] max_connections: Defines a target maximum number of simultaneous connections. For usage guidelines, see Connection balancing mode and Utilization balancing mode. Not available if the backend's balancingMode is RATE.
        :param pulumi.Input[int] max_connections_per_endpoint: Defines a target maximum number of simultaneous connections. For usage guidelines, see Connection balancing mode and Utilization balancing mode. Not available if the backend's balancingMode is RATE.
        :param pulumi.Input[int] max_connections_per_instance: Defines a target maximum number of simultaneous connections. For usage guidelines, see Connection balancing mode and Utilization balancing mode. Not available if the backend's balancingMode is RATE.
        :param pulumi.Input[int] max_rate: Defines a maximum number of HTTP requests per second (RPS). For usage guidelines, see Rate balancing mode and Utilization balancing mode. Not available if the backend's balancingMode is CONNECTION.
        :param pulumi.Input[float] max_rate_per_endpoint: Defines a maximum target for requests per second (RPS). For usage guidelines, see Rate balancing mode and Utilization balancing mode. Not available if the backend's balancingMode is CONNECTION.
        :param pulumi.Input[float] max_rate_per_instance: Defines a maximum target for requests per second (RPS). For usage guidelines, see Rate balancing mode and Utilization balancing mode. Not available if the backend's balancingMode is CONNECTION.
        :param pulumi.Input[float] max_utilization: Optional parameter to define a target capacity for the UTILIZATIONbalancing mode. The valid range is [0.0, 1.0]. For usage guidelines, see Utilization balancing mode.
        """
        if balancing_mode is not None:
            pulumi.set(__self__, "balancing_mode", balancing_mode)
        if capacity_scaler is not None:
            pulumi.set(__self__, "capacity_scaler", capacity_scaler)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if failover is not None:
            pulumi.set(__self__, "failover", failover)
        if group is not None:
            pulumi.set(__self__, "group", group)
        if max_connections is not None:
            pulumi.set(__self__, "max_connections", max_connections)
        if max_connections_per_endpoint is not None:
            pulumi.set(__self__, "max_connections_per_endpoint", max_connections_per_endpoint)
        if max_connections_per_instance is not None:
            pulumi.set(__self__, "max_connections_per_instance", max_connections_per_instance)
        if max_rate is not None:
            pulumi.set(__self__, "max_rate", max_rate)
        if max_rate_per_endpoint is not None:
            pulumi.set(__self__, "max_rate_per_endpoint", max_rate_per_endpoint)
        if max_rate_per_instance is not None:
            pulumi.set(__self__, "max_rate_per_instance", max_rate_per_instance)
        if max_utilization is not None:
            pulumi.set(__self__, "max_utilization", max_utilization)

    @property
    @pulumi.getter(name="balancingMode")
    def balancing_mode(self) -> Optional[pulumi.Input['BackendBalancingMode']]:
        """
        Specifies how to determine whether the backend of a load balancer can handle additional traffic or is fully loaded. For usage guidelines, see Connection balancing mode. Backends must use compatible balancing modes. For more information, see Supported balancing modes and target capacity settings and Restrictions and guidance for instance groups. Note: Currently, if you use the API to configure incompatible balancing modes, the configuration might be accepted even though it has no impact and is ignored. Specifically, Backend.maxUtilization is ignored when Backend.balancingMode is RATE. In the future, this incompatible combination will be rejected.
        """
        return pulumi.get(self, "balancing_mode")

    @balancing_mode.setter
    def balancing_mode(self, value: Optional[pulumi.Input['BackendBalancingMode']]):
        pulumi.set(self, "balancing_mode", value)

    @property
    @pulumi.getter(name="capacityScaler")
    def capacity_scaler(self) -> Optional[pulumi.Input[float]]:
        """
        A multiplier applied to the backend's target capacity of its balancing mode. The default value is 1, which means the group serves up to 100% of its configured capacity (depending on balancingMode). A setting of 0 means the group is completely drained, offering 0% of its available capacity. The valid ranges are 0.0 and [0.1,1.0]. You cannot configure a setting larger than 0 and smaller than 0.1. You cannot configure a setting of 0 when there is only one backend attached to the backend service.
        """
        return pulumi.get(self, "capacity_scaler")

    @capacity_scaler.setter
    def capacity_scaler(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "capacity_scaler", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        An optional description of this resource. Provide this property when you create the resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def failover(self) -> Optional[pulumi.Input[bool]]:
        """
        This field designates whether this is a failover backend. More than one failover backend can be configured for a given BackendService.
        """
        return pulumi.get(self, "failover")

    @failover.setter
    def failover(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "failover", value)

    @property
    @pulumi.getter
    def group(self) -> Optional[pulumi.Input[str]]:
        """
        The fully-qualified URL of an instance group or network endpoint group (NEG) resource. To determine what types of backends a load balancer supports, see the [Backend services overview](https://cloud.google.com/load-balancing/docs/backend-service#backends). You must use the *fully-qualified* URL (starting with https://www.googleapis.com/) to specify the instance group or NEG. Partial URLs are not supported.
        """
        return pulumi.get(self, "group")

    @group.setter
    def group(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "group", value)

    @property
    @pulumi.getter(name="maxConnections")
    def max_connections(self) -> Optional[pulumi.Input[int]]:
        """
        Defines a target maximum number of simultaneous connections. For usage guidelines, see Connection balancing mode and Utilization balancing mode. Not available if the backend's balancingMode is RATE.
        """
        return pulumi.get(self, "max_connections")

    @max_connections.setter
    def max_connections(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_connections", value)

    @property
    @pulumi.getter(name="maxConnectionsPerEndpoint")
    def max_connections_per_endpoint(self) -> Optional[pulumi.Input[int]]:
        """
        Defines a target maximum number of simultaneous connections. For usage guidelines, see Connection balancing mode and Utilization balancing mode. Not available if the backend's balancingMode is RATE.
        """
        return pulumi.get(self, "max_connections_per_endpoint")

    @max_connections_per_endpoint.setter
    def max_connections_per_endpoint(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_connections_per_endpoint", value)

    @property
    @pulumi.getter(name="maxConnectionsPerInstance")
    def max_connections_per_instance(self) -> Optional[pulumi.Input[int]]:
        """
        Defines a target maximum number of simultaneous connections. For usage guidelines, see Connection balancing mode and Utilization balancing mode. Not available if the backend's balancingMode is RATE.
        """
        return pulumi.get(self, "max_connections_per_instance")

    @max_connections_per_instance.setter
    def max_connections_per_instance(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_connections_per_instance", value)

    @property
    @pulumi.getter(name="maxRate")
    def max_rate(self) -> Optional[pulumi.Input[int]]:
        """
        Defines a maximum number of HTTP requests per second (RPS). For usage guidelines, see Rate balancing mode and Utilization balancing mode. Not available if the backend's balancingMode is CONNECTION.
        """
        return pulumi.get(self, "max_rate")

    @max_rate.setter
    def max_rate(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_rate", value)

    @property
    @pulumi.getter(name="maxRatePerEndpoint")
    def max_rate_per_endpoint(self) -> Optional[pulumi.Input[float]]:
        """
        Defines a maximum target for requests per second (RPS). For usage guidelines, see Rate balancing mode and Utilization balancing mode. Not available if the backend's balancingMode is CONNECTION.
        """
        return pulumi.get(self, "max_rate_per_endpoint")

    @max_rate_per_endpoint.setter
    def max_rate_per_endpoint(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "max_rate_per_endpoint", value)

    @property
    @pulumi.getter(name="maxRatePerInstance")
    def max_rate_per_instance(self) -> Optional[pulumi.Input[float]]:
        """
        Defines a maximum target for requests per second (RPS). For usage guidelines, see Rate balancing mode and Utilization balancing mode. Not available if the backend's balancingMode is CONNECTION.
        """
        return pulumi.get(self, "max_rate_per_instance")

    @max_rate_per_instance.setter
    def max_rate_per_instance(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "max_rate_per_instance", value)

    @property
    @pulumi.getter(name="maxUtilization")
    def max_utilization(self) -> Optional[pulumi.Input[float]]:
        """
        Optional parameter to define a target capacity for the UTILIZATIONbalancing mode. The valid range is [0.0, 1.0]. For usage guidelines, see Utilization balancing mode.
        """
        return pulumi.get(self, "max_utilization")

    @max_utilization.setter
    def max_utilization(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "max_utilization", value)


@pulumi.input_type
class BindingArgs:
    def __init__(__self__, *,
                 binding_id: Optional[pulumi.Input[str]] = None,
                 condition: Optional[pulumi.Input['ExprArgs']] = None,
                 members: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 role: Optional[pulumi.Input[str]] = None):
        """
        Associates `members`, or principals, with a `role`.
        :param pulumi.Input[str] binding_id: This is deprecated and has no effect. Do not use.
        :param pulumi.Input['ExprArgs'] condition: The condition that is associated with this binding. If the condition evaluates to `true`, then this binding applies to the current request. If the condition evaluates to `false`, then this binding does not apply to the current request. However, a different role binding might grant the same role to one or more of the principals in this binding. To learn which resources support conditions in their IAM policies, see the [IAM documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] members: Specifies the principals requesting access for a Cloud Platform resource. `members` can have the following values: * `allUsers`: A special identifier that represents anyone who is on the internet; with or without a Google account. * `allAuthenticatedUsers`: A special identifier that represents anyone who is authenticated with a Google account or a service account. * `user:{emailid}`: An email address that represents a specific Google account. For example, `alice@example.com` . * `serviceAccount:{emailid}`: An email address that represents a service account. For example, `my-other-app@appspot.gserviceaccount.com`. * `group:{emailid}`: An email address that represents a Google group. For example, `admins@example.com`. * `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a user that has been recently deleted. For example, `alice@example.com?uid=123456789012345678901`. If the user is recovered, this value reverts to `user:{emailid}` and the recovered user retains the role in the binding. * `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a service account that has been recently deleted. For example, `my-other-app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the service account is undeleted, this value reverts to `serviceAccount:{emailid}` and the undeleted service account retains the role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a Google group that has been recently deleted. For example, `admins@example.com?uid=123456789012345678901`. If the group is recovered, this value reverts to `group:{emailid}` and the recovered group retains the role in the binding. * `domain:{domain}`: The G Suite domain (primary) that represents all the users of that domain. For example, `google.com` or `example.com`. 
        :param pulumi.Input[str] role: Role that is assigned to the list of `members`, or principals. For example, `roles/viewer`, `roles/editor`, or `roles/owner`.
        """
        if binding_id is not None:
            pulumi.set(__self__, "binding_id", binding_id)
        if condition is not None:
            pulumi.set(__self__, "condition", condition)
        if members is not None:
            pulumi.set(__self__, "members", members)
        if role is not None:
            pulumi.set(__self__, "role", role)

    @property
    @pulumi.getter(name="bindingId")
    def binding_id(self) -> Optional[pulumi.Input[str]]:
        """
        This is deprecated and has no effect. Do not use.
        """
        return pulumi.get(self, "binding_id")

    @binding_id.setter
    def binding_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "binding_id", value)

    @property
    @pulumi.getter
    def condition(self) -> Optional[pulumi.Input['ExprArgs']]:
        """
        The condition that is associated with this binding. If the condition evaluates to `true`, then this binding applies to the current request. If the condition evaluates to `false`, then this binding does not apply to the current request. However, a different role binding might grant the same role to one or more of the principals in this binding. To learn which resources support conditions in their IAM policies, see the [IAM documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
        """
        return pulumi.get(self, "condition")

    @condition.setter
    def condition(self, value: Optional[pulumi.Input['ExprArgs']]):
        pulumi.set(self, "condition", value)

    @property
    @pulumi.getter
    def members(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies the principals requesting access for a Cloud Platform resource. `members` can have the following values: * `allUsers`: A special identifier that represents anyone who is on the internet; with or without a Google account. * `allAuthenticatedUsers`: A special identifier that represents anyone who is authenticated with a Google account or a service account. * `user:{emailid}`: An email address that represents a specific Google account. For example, `alice@example.com` . * `serviceAccount:{emailid}`: An email address that represents a service account. For example, `my-other-app@appspot.gserviceaccount.com`. * `group:{emailid}`: An email address that represents a Google group. For example, `admins@example.com`. * `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a user that has been recently deleted. For example, `alice@example.com?uid=123456789012345678901`. If the user is recovered, this value reverts to `user:{emailid}` and the recovered user retains the role in the binding. * `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a service account that has been recently deleted. For example, `my-other-app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the service account is undeleted, this value reverts to `serviceAccount:{emailid}` and the undeleted service account retains the role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a Google group that has been recently deleted. For example, `admins@example.com?uid=123456789012345678901`. If the group is recovered, this value reverts to `group:{emailid}` and the recovered group retains the role in the binding. * `domain:{domain}`: The G Suite domain (primary) that represents all the users of that domain. For example, `google.com` or `example.com`. 
        """
        return pulumi.get(self, "members")

    @members.setter
    def members(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "members", value)

    @property
    @pulumi.getter
    def role(self) -> Optional[pulumi.Input[str]]:
        """
        Role that is assigned to the list of `members`, or principals. For example, `roles/viewer`, `roles/editor`, or `roles/owner`.
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "role", value)


@pulumi.input_type
class CacheKeyPolicyArgs:
    def __init__(__self__, *,
                 include_host: Optional[pulumi.Input[bool]] = None,
                 include_http_headers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 include_named_cookies: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 include_protocol: Optional[pulumi.Input[bool]] = None,
                 include_query_string: Optional[pulumi.Input[bool]] = None,
                 query_string_blacklist: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 query_string_whitelist: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Message containing what to include in the cache key for a request for Cloud CDN.
        :param pulumi.Input[bool] include_host: If true, requests to different hosts will be cached separately.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] include_http_headers: Allows HTTP request headers (by name) to be used in the cache key.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] include_named_cookies: Allows HTTP cookies (by name) to be used in the cache key. The name=value pair will be used in the cache key Cloud CDN generates.
        :param pulumi.Input[bool] include_protocol: If true, http and https requests will be cached separately.
        :param pulumi.Input[bool] include_query_string: If true, include query string parameters in the cache key according to query_string_whitelist and query_string_blacklist. If neither is set, the entire query string will be included. If false, the query string will be excluded from the cache key entirely.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] query_string_blacklist: Names of query string parameters to exclude in cache keys. All other parameters will be included. Either specify query_string_whitelist or query_string_blacklist, not both. '&' and '=' will be percent encoded and not treated as delimiters.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] query_string_whitelist: Names of query string parameters to include in cache keys. All other parameters will be excluded. Either specify query_string_whitelist or query_string_blacklist, not both. '&' and '=' will be percent encoded and not treated as delimiters.
        """
        if include_host is not None:
            pulumi.set(__self__, "include_host", include_host)
        if include_http_headers is not None:
            pulumi.set(__self__, "include_http_headers", include_http_headers)
        if include_named_cookies is not None:
            pulumi.set(__self__, "include_named_cookies", include_named_cookies)
        if include_protocol is not None:
            pulumi.set(__self__, "include_protocol", include_protocol)
        if include_query_string is not None:
            pulumi.set(__self__, "include_query_string", include_query_string)
        if query_string_blacklist is not None:
            pulumi.set(__self__, "query_string_blacklist", query_string_blacklist)
        if query_string_whitelist is not None:
            pulumi.set(__self__, "query_string_whitelist", query_string_whitelist)

    @property
    @pulumi.getter(name="includeHost")
    def include_host(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, requests to different hosts will be cached separately.
        """
        return pulumi.get(self, "include_host")

    @include_host.setter
    def include_host(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "include_host", value)

    @property
    @pulumi.getter(name="includeHttpHeaders")
    def include_http_headers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Allows HTTP request headers (by name) to be used in the cache key.
        """
        return pulumi.get(self, "include_http_headers")

    @include_http_headers.setter
    def include_http_headers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "include_http_headers", value)

    @property
    @pulumi.getter(name="includeNamedCookies")
    def include_named_cookies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Allows HTTP cookies (by name) to be used in the cache key. The name=value pair will be used in the cache key Cloud CDN generates.
        """
        return pulumi.get(self, "include_named_cookies")

    @include_named_cookies.setter
    def include_named_cookies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "include_named_cookies", value)

    @property
    @pulumi.getter(name="includeProtocol")
    def include_protocol(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, http and https requests will be cached separately.
        """
        return pulumi.get(self, "include_protocol")

    @include_protocol.setter
    def include_protocol(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "include_protocol", value)

    @property
    @pulumi.getter(name="includeQueryString")
    def include_query_string(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, include query string parameters in the cache key according to query_string_whitelist and query_string_blacklist. If neither is set, the entire query string will be included. If false, the query string will be excluded from the cache key entirely.
        """
        return pulumi.get(self, "include_query_string")

    @include_query_string.setter
    def include_query_string(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "include_query_string", value)

    @property
    @pulumi.getter(name="queryStringBlacklist")
    def query_string_blacklist(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Names of query string parameters to exclude in cache keys. All other parameters will be included. Either specify query_string_whitelist or query_string_blacklist, not both. '&' and '=' will be percent encoded and not treated as delimiters.
        """
        return pulumi.get(self, "query_string_blacklist")

    @query_string_blacklist.setter
    def query_string_blacklist(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "query_string_blacklist", value)

    @property
    @pulumi.getter(name="queryStringWhitelist")
    def query_string_whitelist(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Names of query string parameters to include in cache keys. All other parameters will be excluded. Either specify query_string_whitelist or query_string_blacklist, not both. '&' and '=' will be percent encoded and not treated as delimiters.
        """
        return pulumi.get(self, "query_string_whitelist")

    @query_string_whitelist.setter
    def query_string_whitelist(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "query_string_whitelist", value)


@pulumi.input_type
class CircuitBreakersArgs:
    def __init__(__self__, *,
                 connect_timeout: Optional[pulumi.Input['DurationArgs']] = None,
                 max_connections: Optional[pulumi.Input[int]] = None,
                 max_pending_requests: Optional[pulumi.Input[int]] = None,
                 max_requests: Optional[pulumi.Input[int]] = None,
                 max_requests_per_connection: Optional[pulumi.Input[int]] = None,
                 max_retries: Optional[pulumi.Input[int]] = None):
        """
        Settings controlling the volume of requests, connections and retries to this backend service.
        :param pulumi.Input['DurationArgs'] connect_timeout: The timeout for new network connections to hosts.
        :param pulumi.Input[int] max_connections: Not supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true.
        :param pulumi.Input[int] max_pending_requests: Not supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true.
        :param pulumi.Input[int] max_requests: The maximum number of parallel requests that allowed to the backend service. If not specified, there is no limit.
        :param pulumi.Input[int] max_requests_per_connection: Not supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true.
        :param pulumi.Input[int] max_retries: Not supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true.
        """
        if connect_timeout is not None:
            pulumi.set(__self__, "connect_timeout", connect_timeout)
        if max_connections is not None:
            pulumi.set(__self__, "max_connections", max_connections)
        if max_pending_requests is not None:
            pulumi.set(__self__, "max_pending_requests", max_pending_requests)
        if max_requests is not None:
            pulumi.set(__self__, "max_requests", max_requests)
        if max_requests_per_connection is not None:
            pulumi.set(__self__, "max_requests_per_connection", max_requests_per_connection)
        if max_retries is not None:
            pulumi.set(__self__, "max_retries", max_retries)

    @property
    @pulumi.getter(name="connectTimeout")
    def connect_timeout(self) -> Optional[pulumi.Input['DurationArgs']]:
        """
        The timeout for new network connections to hosts.
        """
        return pulumi.get(self, "connect_timeout")

    @connect_timeout.setter
    def connect_timeout(self, value: Optional[pulumi.Input['DurationArgs']]):
        pulumi.set(self, "connect_timeout", value)

    @property
    @pulumi.getter(name="maxConnections")
    def max_connections(self) -> Optional[pulumi.Input[int]]:
        """
        Not supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true.
        """
        return pulumi.get(self, "max_connections")

    @max_connections.setter
    def max_connections(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_connections", value)

    @property
    @pulumi.getter(name="maxPendingRequests")
    def max_pending_requests(self) -> Optional[pulumi.Input[int]]:
        """
        Not supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true.
        """
        return pulumi.get(self, "max_pending_requests")

    @max_pending_requests.setter
    def max_pending_requests(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_pending_requests", value)

    @property
    @pulumi.getter(name="maxRequests")
    def max_requests(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum number of parallel requests that allowed to the backend service. If not specified, there is no limit.
        """
        return pulumi.get(self, "max_requests")

    @max_requests.setter
    def max_requests(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_requests", value)

    @property
    @pulumi.getter(name="maxRequestsPerConnection")
    def max_requests_per_connection(self) -> Optional[pulumi.Input[int]]:
        """
        Not supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true.
        """
        return pulumi.get(self, "max_requests_per_connection")

    @max_requests_per_connection.setter
    def max_requests_per_connection(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_requests_per_connection", value)

    @property
    @pulumi.getter(name="maxRetries")
    def max_retries(self) -> Optional[pulumi.Input[int]]:
        """
        Not supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true.
        """
        return pulumi.get(self, "max_retries")

    @max_retries.setter
    def max_retries(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_retries", value)


@pulumi.input_type
class ConditionArgs:
    def __init__(__self__, *,
                 iam: Optional[pulumi.Input['ConditionIam']] = None,
                 op: Optional[pulumi.Input['ConditionOp']] = None,
                 svc: Optional[pulumi.Input[str]] = None,
                 sys: Optional[pulumi.Input['ConditionSys']] = None,
                 values: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        This is deprecated and has no effect. Do not use.
        :param pulumi.Input['ConditionIam'] iam: This is deprecated and has no effect. Do not use.
        :param pulumi.Input['ConditionOp'] op: This is deprecated and has no effect. Do not use.
        :param pulumi.Input[str] svc: This is deprecated and has no effect. Do not use.
        :param pulumi.Input['ConditionSys'] sys: This is deprecated and has no effect. Do not use.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] values: This is deprecated and has no effect. Do not use.
        """
        if iam is not None:
            pulumi.set(__self__, "iam", iam)
        if op is not None:
            pulumi.set(__self__, "op", op)
        if svc is not None:
            pulumi.set(__self__, "svc", svc)
        if sys is not None:
            pulumi.set(__self__, "sys", sys)
        if values is not None:
            pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def iam(self) -> Optional[pulumi.Input['ConditionIam']]:
        """
        This is deprecated and has no effect. Do not use.
        """
        return pulumi.get(self, "iam")

    @iam.setter
    def iam(self, value: Optional[pulumi.Input['ConditionIam']]):
        pulumi.set(self, "iam", value)

    @property
    @pulumi.getter
    def op(self) -> Optional[pulumi.Input['ConditionOp']]:
        """
        This is deprecated and has no effect. Do not use.
        """
        return pulumi.get(self, "op")

    @op.setter
    def op(self, value: Optional[pulumi.Input['ConditionOp']]):
        pulumi.set(self, "op", value)

    @property
    @pulumi.getter
    def svc(self) -> Optional[pulumi.Input[str]]:
        """
        This is deprecated and has no effect. Do not use.
        """
        return pulumi.get(self, "svc")

    @svc.setter
    def svc(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "svc", value)

    @property
    @pulumi.getter
    def sys(self) -> Optional[pulumi.Input['ConditionSys']]:
        """
        This is deprecated and has no effect. Do not use.
        """
        return pulumi.get(self, "sys")

    @sys.setter
    def sys(self, value: Optional[pulumi.Input['ConditionSys']]):
        pulumi.set(self, "sys", value)

    @property
    @pulumi.getter
    def values(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        This is deprecated and has no effect. Do not use.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "values", value)


@pulumi.input_type
class ConfidentialInstanceConfigArgs:
    def __init__(__self__, *,
                 enable_confidential_compute: Optional[pulumi.Input[bool]] = None):
        """
        A set of Confidential Instance options.
        :param pulumi.Input[bool] enable_confidential_compute: Defines whether the instance should have confidential compute enabled.
        """
        if enable_confidential_compute is not None:
            pulumi.set(__self__, "enable_confidential_compute", enable_confidential_compute)

    @property
    @pulumi.getter(name="enableConfidentialCompute")
    def enable_confidential_compute(self) -> Optional[pulumi.Input[bool]]:
        """
        Defines whether the instance should have confidential compute enabled.
        """
        return pulumi.get(self, "enable_confidential_compute")

    @enable_confidential_compute.setter
    def enable_confidential_compute(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_confidential_compute", value)


@pulumi.input_type
class ConnectionDrainingArgs:
    def __init__(__self__, *,
                 draining_timeout_sec: Optional[pulumi.Input[int]] = None):
        """
        Message containing connection draining configuration.
        :param pulumi.Input[int] draining_timeout_sec: Configures a duration timeout for existing requests on a removed backend instance. For supported load balancers and protocols, as described in Enabling connection draining.
        """
        if draining_timeout_sec is not None:
            pulumi.set(__self__, "draining_timeout_sec", draining_timeout_sec)

    @property
    @pulumi.getter(name="drainingTimeoutSec")
    def draining_timeout_sec(self) -> Optional[pulumi.Input[int]]:
        """
        Configures a duration timeout for existing requests on a removed backend instance. For supported load balancers and protocols, as described in Enabling connection draining.
        """
        return pulumi.get(self, "draining_timeout_sec")

    @draining_timeout_sec.setter
    def draining_timeout_sec(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "draining_timeout_sec", value)


@pulumi.input_type
class ConsistentHashLoadBalancerSettingsHttpCookieArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 path: Optional[pulumi.Input[str]] = None,
                 ttl: Optional[pulumi.Input['DurationArgs']] = None):
        """
        The information about the HTTP Cookie on which the hash function is based for load balancing policies that use a consistent hash.
        :param pulumi.Input[str] name: Name of the cookie.
        :param pulumi.Input[str] path: Path to set for the cookie.
        :param pulumi.Input['DurationArgs'] ttl: Lifetime of the cookie.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if ttl is not None:
            pulumi.set(__self__, "ttl", ttl)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the cookie.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        """
        Path to set for the cookie.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter
    def ttl(self) -> Optional[pulumi.Input['DurationArgs']]:
        """
        Lifetime of the cookie.
        """
        return pulumi.get(self, "ttl")

    @ttl.setter
    def ttl(self, value: Optional[pulumi.Input['DurationArgs']]):
        pulumi.set(self, "ttl", value)


@pulumi.input_type
class ConsistentHashLoadBalancerSettingsArgs:
    def __init__(__self__, *,
                 http_cookie: Optional[pulumi.Input['ConsistentHashLoadBalancerSettingsHttpCookieArgs']] = None,
                 http_header_name: Optional[pulumi.Input[str]] = None,
                 minimum_ring_size: Optional[pulumi.Input[str]] = None):
        """
        This message defines settings for a consistent hash style load balancer.
        :param pulumi.Input['ConsistentHashLoadBalancerSettingsHttpCookieArgs'] http_cookie: Hash is based on HTTP Cookie. This field describes a HTTP cookie that will be used as the hash key for the consistent hash load balancer. If the cookie is not present, it will be generated. This field is applicable if the sessionAffinity is set to HTTP_COOKIE. Not supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true.
        :param pulumi.Input[str] http_header_name: The hash based on the value of the specified header field. This field is applicable if the sessionAffinity is set to HEADER_FIELD.
        :param pulumi.Input[str] minimum_ring_size: The minimum number of virtual nodes to use for the hash ring. Defaults to 1024. Larger ring sizes result in more granular load distributions. If the number of hosts in the load balancing pool is larger than the ring size, each host will be assigned a single virtual node.
        """
        if http_cookie is not None:
            pulumi.set(__self__, "http_cookie", http_cookie)
        if http_header_name is not None:
            pulumi.set(__self__, "http_header_name", http_header_name)
        if minimum_ring_size is not None:
            pulumi.set(__self__, "minimum_ring_size", minimum_ring_size)

    @property
    @pulumi.getter(name="httpCookie")
    def http_cookie(self) -> Optional[pulumi.Input['ConsistentHashLoadBalancerSettingsHttpCookieArgs']]:
        """
        Hash is based on HTTP Cookie. This field describes a HTTP cookie that will be used as the hash key for the consistent hash load balancer. If the cookie is not present, it will be generated. This field is applicable if the sessionAffinity is set to HTTP_COOKIE. Not supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true.
        """
        return pulumi.get(self, "http_cookie")

    @http_cookie.setter
    def http_cookie(self, value: Optional[pulumi.Input['ConsistentHashLoadBalancerSettingsHttpCookieArgs']]):
        pulumi.set(self, "http_cookie", value)

    @property
    @pulumi.getter(name="httpHeaderName")
    def http_header_name(self) -> Optional[pulumi.Input[str]]:
        """
        The hash based on the value of the specified header field. This field is applicable if the sessionAffinity is set to HEADER_FIELD.
        """
        return pulumi.get(self, "http_header_name")

    @http_header_name.setter
    def http_header_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "http_header_name", value)

    @property
    @pulumi.getter(name="minimumRingSize")
    def minimum_ring_size(self) -> Optional[pulumi.Input[str]]:
        """
        The minimum number of virtual nodes to use for the hash ring. Defaults to 1024. Larger ring sizes result in more granular load distributions. If the number of hosts in the load balancing pool is larger than the ring size, each host will be assigned a single virtual node.
        """
        return pulumi.get(self, "minimum_ring_size")

    @minimum_ring_size.setter
    def minimum_ring_size(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "minimum_ring_size", value)


@pulumi.input_type
class CorsPolicyArgs:
    def __init__(__self__, *,
                 allow_credentials: Optional[pulumi.Input[bool]] = None,
                 allow_headers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 allow_methods: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 allow_origin_regexes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 allow_origins: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 disabled: Optional[pulumi.Input[bool]] = None,
                 expose_headers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 max_age: Optional[pulumi.Input[int]] = None):
        """
        The specification for allowing client-side cross-origin requests. For more information about the W3C recommendation for cross-origin resource sharing (CORS), see Fetch API Living Standard.
        :param pulumi.Input[bool] allow_credentials: In response to a preflight request, setting this to true indicates that the actual request can include user credentials. This field translates to the Access-Control-Allow-Credentials header. Default is false.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allow_headers: Specifies the content for the Access-Control-Allow-Headers header.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allow_methods: Specifies the content for the Access-Control-Allow-Methods header.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allow_origin_regexes: Specifies a regular expression that matches allowed origins. For more information about the regular expression syntax, see Syntax. An origin is allowed if it matches either an item in allowOrigins or an item in allowOriginRegexes.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allow_origins: Specifies the list of origins that is allowed to do CORS requests. An origin is allowed if it matches either an item in allowOrigins or an item in allowOriginRegexes.
        :param pulumi.Input[bool] disabled: If true, the setting specifies the CORS policy is disabled. The default value of false, which indicates that the CORS policy is in effect.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] expose_headers: Specifies the content for the Access-Control-Expose-Headers header.
        :param pulumi.Input[int] max_age: Specifies how long results of a preflight request can be cached in seconds. This field translates to the Access-Control-Max-Age header.
        """
        if allow_credentials is not None:
            pulumi.set(__self__, "allow_credentials", allow_credentials)
        if allow_headers is not None:
            pulumi.set(__self__, "allow_headers", allow_headers)
        if allow_methods is not None:
            pulumi.set(__self__, "allow_methods", allow_methods)
        if allow_origin_regexes is not None:
            pulumi.set(__self__, "allow_origin_regexes", allow_origin_regexes)
        if allow_origins is not None:
            pulumi.set(__self__, "allow_origins", allow_origins)
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)
        if expose_headers is not None:
            pulumi.set(__self__, "expose_headers", expose_headers)
        if max_age is not None:
            pulumi.set(__self__, "max_age", max_age)

    @property
    @pulumi.getter(name="allowCredentials")
    def allow_credentials(self) -> Optional[pulumi.Input[bool]]:
        """
        In response to a preflight request, setting this to true indicates that the actual request can include user credentials. This field translates to the Access-Control-Allow-Credentials header. Default is false.
        """
        return pulumi.get(self, "allow_credentials")

    @allow_credentials.setter
    def allow_credentials(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_credentials", value)

    @property
    @pulumi.getter(name="allowHeaders")
    def allow_headers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies the content for the Access-Control-Allow-Headers header.
        """
        return pulumi.get(self, "allow_headers")

    @allow_headers.setter
    def allow_headers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "allow_headers", value)

    @property
    @pulumi.getter(name="allowMethods")
    def allow_methods(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies the content for the Access-Control-Allow-Methods header.
        """
        return pulumi.get(self, "allow_methods")

    @allow_methods.setter
    def allow_methods(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "allow_methods", value)

    @property
    @pulumi.getter(name="allowOriginRegexes")
    def allow_origin_regexes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies a regular expression that matches allowed origins. For more information about the regular expression syntax, see Syntax. An origin is allowed if it matches either an item in allowOrigins or an item in allowOriginRegexes.
        """
        return pulumi.get(self, "allow_origin_regexes")

    @allow_origin_regexes.setter
    def allow_origin_regexes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "allow_origin_regexes", value)

    @property
    @pulumi.getter(name="allowOrigins")
    def allow_origins(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies the list of origins that is allowed to do CORS requests. An origin is allowed if it matches either an item in allowOrigins or an item in allowOriginRegexes.
        """
        return pulumi.get(self, "allow_origins")

    @allow_origins.setter
    def allow_origins(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "allow_origins", value)

    @property
    @pulumi.getter
    def disabled(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, the setting specifies the CORS policy is disabled. The default value of false, which indicates that the CORS policy is in effect.
        """
        return pulumi.get(self, "disabled")

    @disabled.setter
    def disabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disabled", value)

    @property
    @pulumi.getter(name="exposeHeaders")
    def expose_headers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies the content for the Access-Control-Expose-Headers header.
        """
        return pulumi.get(self, "expose_headers")

    @expose_headers.setter
    def expose_headers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "expose_headers", value)

    @property
    @pulumi.getter(name="maxAge")
    def max_age(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies how long results of a preflight request can be cached in seconds. This field translates to the Access-Control-Max-Age header.
        """
        return pulumi.get(self, "max_age")

    @max_age.setter
    def max_age(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_age", value)


@pulumi.input_type
class CustomerEncryptionKeyArgs:
    def __init__(__self__, *,
                 kms_key_name: Optional[pulumi.Input[str]] = None,
                 kms_key_service_account: Optional[pulumi.Input[str]] = None,
                 raw_key: Optional[pulumi.Input[str]] = None,
                 rsa_encrypted_key: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] kms_key_name: The name of the encryption key that is stored in Google Cloud KMS. For example: "kmsKeyName": "projects/kms_project_id/locations/region/keyRings/ key_region/cryptoKeys/key 
        :param pulumi.Input[str] kms_key_service_account: The service account being used for the encryption request for the given KMS key. If absent, the Compute Engine default service account is used. For example: "kmsKeyServiceAccount": "name@project_id.iam.gserviceaccount.com/ 
        :param pulumi.Input[str] raw_key: Specifies a 256-bit customer-supplied encryption key, encoded in RFC 4648 base64 to either encrypt or decrypt this resource. You can provide either the rawKey or the rsaEncryptedKey. For example: "rawKey": "SGVsbG8gZnJvbSBHb29nbGUgQ2xvdWQgUGxhdGZvcm0=" 
        :param pulumi.Input[str] rsa_encrypted_key: Specifies an RFC 4648 base64 encoded, RSA-wrapped 2048-bit customer-supplied encryption key to either encrypt or decrypt this resource. You can provide either the rawKey or the rsaEncryptedKey. For example: "rsaEncryptedKey": "ieCx/NcW06PcT7Ep1X6LUTc/hLvUDYyzSZPPVCVPTVEohpeHASqC8uw5TzyO9U+Fka9JFH z0mBibXUInrC/jEk014kCK/NPjYgEMOyssZ4ZINPKxlUh2zn1bV+MCaTICrdmuSBTWlUUiFoD D6PYznLwh8ZNdaheCeZ8ewEXgFQ8V+sDroLaN3Xs3MDTXQEMMoNUXMCZEIpg9Vtp9x2oe==" The key must meet the following requirements before you can provide it to Compute Engine: 1. The key is wrapped using a RSA public key certificate provided by Google. 2. After being wrapped, the key must be encoded in RFC 4648 base64 encoding. Gets the RSA public key certificate provided by Google at: https://cloud-certs.storage.googleapis.com/google-cloud-csek-ingress.pem 
        """
        if kms_key_name is not None:
            pulumi.set(__self__, "kms_key_name", kms_key_name)
        if kms_key_service_account is not None:
            pulumi.set(__self__, "kms_key_service_account", kms_key_service_account)
        if raw_key is not None:
            pulumi.set(__self__, "raw_key", raw_key)
        if rsa_encrypted_key is not None:
            pulumi.set(__self__, "rsa_encrypted_key", rsa_encrypted_key)

    @property
    @pulumi.getter(name="kmsKeyName")
    def kms_key_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the encryption key that is stored in Google Cloud KMS. For example: "kmsKeyName": "projects/kms_project_id/locations/region/keyRings/ key_region/cryptoKeys/key 
        """
        return pulumi.get(self, "kms_key_name")

    @kms_key_name.setter
    def kms_key_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_key_name", value)

    @property
    @pulumi.getter(name="kmsKeyServiceAccount")
    def kms_key_service_account(self) -> Optional[pulumi.Input[str]]:
        """
        The service account being used for the encryption request for the given KMS key. If absent, the Compute Engine default service account is used. For example: "kmsKeyServiceAccount": "name@project_id.iam.gserviceaccount.com/ 
        """
        return pulumi.get(self, "kms_key_service_account")

    @kms_key_service_account.setter
    def kms_key_service_account(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_key_service_account", value)

    @property
    @pulumi.getter(name="rawKey")
    def raw_key(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies a 256-bit customer-supplied encryption key, encoded in RFC 4648 base64 to either encrypt or decrypt this resource. You can provide either the rawKey or the rsaEncryptedKey. For example: "rawKey": "SGVsbG8gZnJvbSBHb29nbGUgQ2xvdWQgUGxhdGZvcm0=" 
        """
        return pulumi.get(self, "raw_key")

    @raw_key.setter
    def raw_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "raw_key", value)

    @property
    @pulumi.getter(name="rsaEncryptedKey")
    def rsa_encrypted_key(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies an RFC 4648 base64 encoded, RSA-wrapped 2048-bit customer-supplied encryption key to either encrypt or decrypt this resource. You can provide either the rawKey or the rsaEncryptedKey. For example: "rsaEncryptedKey": "ieCx/NcW06PcT7Ep1X6LUTc/hLvUDYyzSZPPVCVPTVEohpeHASqC8uw5TzyO9U+Fka9JFH z0mBibXUInrC/jEk014kCK/NPjYgEMOyssZ4ZINPKxlUh2zn1bV+MCaTICrdmuSBTWlUUiFoD D6PYznLwh8ZNdaheCeZ8ewEXgFQ8V+sDroLaN3Xs3MDTXQEMMoNUXMCZEIpg9Vtp9x2oe==" The key must meet the following requirements before you can provide it to Compute Engine: 1. The key is wrapped using a RSA public key certificate provided by Google. 2. After being wrapped, the key must be encoded in RFC 4648 base64 encoding. Gets the RSA public key certificate provided by Google at: https://cloud-certs.storage.googleapis.com/google-cloud-csek-ingress.pem 
        """
        return pulumi.get(self, "rsa_encrypted_key")

    @rsa_encrypted_key.setter
    def rsa_encrypted_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "rsa_encrypted_key", value)


@pulumi.input_type
class DeprecationStatusArgs:
    def __init__(__self__, *,
                 deleted: Optional[pulumi.Input[str]] = None,
                 deprecated: Optional[pulumi.Input[str]] = None,
                 obsolete: Optional[pulumi.Input[str]] = None,
                 replacement: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input['DeprecationStatusState']] = None,
                 state_override: Optional[pulumi.Input['RolloutPolicyArgs']] = None):
        """
        Deprecation status for a public resource.
        :param pulumi.Input[str] deleted: An optional RFC3339 timestamp on or after which the state of this resource is intended to change to DELETED. This is only informational and the status will not change unless the client explicitly changes it.
        :param pulumi.Input[str] deprecated: An optional RFC3339 timestamp on or after which the state of this resource is intended to change to DEPRECATED. This is only informational and the status will not change unless the client explicitly changes it.
        :param pulumi.Input[str] obsolete: An optional RFC3339 timestamp on or after which the state of this resource is intended to change to OBSOLETE. This is only informational and the status will not change unless the client explicitly changes it.
        :param pulumi.Input[str] replacement: The URL of the suggested replacement for a deprecated resource. The suggested replacement resource must be the same kind of resource as the deprecated resource.
        :param pulumi.Input['DeprecationStatusState'] state: The deprecation state of this resource. This can be ACTIVE, DEPRECATED, OBSOLETE, or DELETED. Operations which communicate the end of life date for an image, can use ACTIVE. Operations which create a new resource using a DEPRECATED resource will return successfully, but with a warning indicating the deprecated resource and recommending its replacement. Operations which use OBSOLETE or DELETED resources will be rejected and result in an error.
        :param pulumi.Input['RolloutPolicyArgs'] state_override: The rollout policy for this deprecation. This policy is only enforced by image family views. The rollout policy restricts the zones where the associated resource is considered in a deprecated state. When the rollout policy does not include the user specified zone, or if the zone is rolled out, the associated resource is considered in a deprecated state. The rollout policy for this deprecation is read-only, except for allowlisted users. This field might not be configured. To view the latest non-deprecated image in a specific zone, use the imageFamilyViews.get method.
        """
        if deleted is not None:
            pulumi.set(__self__, "deleted", deleted)
        if deprecated is not None:
            pulumi.set(__self__, "deprecated", deprecated)
        if obsolete is not None:
            pulumi.set(__self__, "obsolete", obsolete)
        if replacement is not None:
            pulumi.set(__self__, "replacement", replacement)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if state_override is not None:
            pulumi.set(__self__, "state_override", state_override)

    @property
    @pulumi.getter
    def deleted(self) -> Optional[pulumi.Input[str]]:
        """
        An optional RFC3339 timestamp on or after which the state of this resource is intended to change to DELETED. This is only informational and the status will not change unless the client explicitly changes it.
        """
        return pulumi.get(self, "deleted")

    @deleted.setter
    def deleted(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "deleted", value)

    @property
    @pulumi.getter
    def deprecated(self) -> Optional[pulumi.Input[str]]:
        """
        An optional RFC3339 timestamp on or after which the state of this resource is intended to change to DEPRECATED. This is only informational and the status will not change unless the client explicitly changes it.
        """
        return pulumi.get(self, "deprecated")

    @deprecated.setter
    def deprecated(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "deprecated", value)

    @property
    @pulumi.getter
    def obsolete(self) -> Optional[pulumi.Input[str]]:
        """
        An optional RFC3339 timestamp on or after which the state of this resource is intended to change to OBSOLETE. This is only informational and the status will not change unless the client explicitly changes it.
        """
        return pulumi.get(self, "obsolete")

    @obsolete.setter
    def obsolete(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "obsolete", value)

    @property
    @pulumi.getter
    def replacement(self) -> Optional[pulumi.Input[str]]:
        """
        The URL of the suggested replacement for a deprecated resource. The suggested replacement resource must be the same kind of resource as the deprecated resource.
        """
        return pulumi.get(self, "replacement")

    @replacement.setter
    def replacement(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "replacement", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input['DeprecationStatusState']]:
        """
        The deprecation state of this resource. This can be ACTIVE, DEPRECATED, OBSOLETE, or DELETED. Operations which communicate the end of life date for an image, can use ACTIVE. Operations which create a new resource using a DEPRECATED resource will return successfully, but with a warning indicating the deprecated resource and recommending its replacement. Operations which use OBSOLETE or DELETED resources will be rejected and result in an error.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input['DeprecationStatusState']]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="stateOverride")
    def state_override(self) -> Optional[pulumi.Input['RolloutPolicyArgs']]:
        """
        The rollout policy for this deprecation. This policy is only enforced by image family views. The rollout policy restricts the zones where the associated resource is considered in a deprecated state. When the rollout policy does not include the user specified zone, or if the zone is rolled out, the associated resource is considered in a deprecated state. The rollout policy for this deprecation is read-only, except for allowlisted users. This field might not be configured. To view the latest non-deprecated image in a specific zone, use the imageFamilyViews.get method.
        """
        return pulumi.get(self, "state_override")

    @state_override.setter
    def state_override(self, value: Optional[pulumi.Input['RolloutPolicyArgs']]):
        pulumi.set(self, "state_override", value)


@pulumi.input_type
class DiskInstantiationConfigArgs:
    def __init__(__self__, *,
                 auto_delete: Optional[pulumi.Input[bool]] = None,
                 custom_image: Optional[pulumi.Input[str]] = None,
                 device_name: Optional[pulumi.Input[str]] = None,
                 instantiate_from: Optional[pulumi.Input['DiskInstantiationConfigInstantiateFrom']] = None):
        """
        A specification of the desired way to instantiate a disk in the instance template when its created from a source instance.
        :param pulumi.Input[bool] auto_delete: Specifies whether the disk will be auto-deleted when the instance is deleted (but not when the disk is detached from the instance).
        :param pulumi.Input[str] custom_image: The custom source image to be used to restore this disk when instantiating this instance template.
        :param pulumi.Input[str] device_name: Specifies the device name of the disk to which the configurations apply to.
        :param pulumi.Input['DiskInstantiationConfigInstantiateFrom'] instantiate_from: Specifies whether to include the disk and what image to use. Possible values are: - source-image: to use the same image that was used to create the source instance's corresponding disk. Applicable to the boot disk and additional read-write disks. - source-image-family: to use the same image family that was used to create the source instance's corresponding disk. Applicable to the boot disk and additional read-write disks. - custom-image: to use a user-provided image url for disk creation. Applicable to the boot disk and additional read-write disks. - attach-read-only: to attach a read-only disk. Applicable to read-only disks. - do-not-include: to exclude a disk from the template. Applicable to additional read-write disks, local SSDs, and read-only disks. 
        """
        if auto_delete is not None:
            pulumi.set(__self__, "auto_delete", auto_delete)
        if custom_image is not None:
            pulumi.set(__self__, "custom_image", custom_image)
        if device_name is not None:
            pulumi.set(__self__, "device_name", device_name)
        if instantiate_from is not None:
            pulumi.set(__self__, "instantiate_from", instantiate_from)

    @property
    @pulumi.getter(name="autoDelete")
    def auto_delete(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether the disk will be auto-deleted when the instance is deleted (but not when the disk is detached from the instance).
        """
        return pulumi.get(self, "auto_delete")

    @auto_delete.setter
    def auto_delete(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_delete", value)

    @property
    @pulumi.getter(name="customImage")
    def custom_image(self) -> Optional[pulumi.Input[str]]:
        """
        The custom source image to be used to restore this disk when instantiating this instance template.
        """
        return pulumi.get(self, "custom_image")

    @custom_image.setter
    def custom_image(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "custom_image", value)

    @property
    @pulumi.getter(name="deviceName")
    def device_name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the device name of the disk to which the configurations apply to.
        """
        return pulumi.get(self, "device_name")

    @device_name.setter
    def device_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "device_name", value)

    @property
    @pulumi.getter(name="instantiateFrom")
    def instantiate_from(self) -> Optional[pulumi.Input['DiskInstantiationConfigInstantiateFrom']]:
        """
        Specifies whether to include the disk and what image to use. Possible values are: - source-image: to use the same image that was used to create the source instance's corresponding disk. Applicable to the boot disk and additional read-write disks. - source-image-family: to use the same image family that was used to create the source instance's corresponding disk. Applicable to the boot disk and additional read-write disks. - custom-image: to use a user-provided image url for disk creation. Applicable to the boot disk and additional read-write disks. - attach-read-only: to attach a read-only disk. Applicable to read-only disks. - do-not-include: to exclude a disk from the template. Applicable to additional read-write disks, local SSDs, and read-only disks. 
        """
        return pulumi.get(self, "instantiate_from")

    @instantiate_from.setter
    def instantiate_from(self, value: Optional[pulumi.Input['DiskInstantiationConfigInstantiateFrom']]):
        pulumi.set(self, "instantiate_from", value)


@pulumi.input_type
class DisplayDeviceArgs:
    def __init__(__self__, *,
                 enable_display: Optional[pulumi.Input[bool]] = None):
        """
        A set of Display Device options
        :param pulumi.Input[bool] enable_display: Defines whether the instance has Display enabled.
        """
        if enable_display is not None:
            pulumi.set(__self__, "enable_display", enable_display)

    @property
    @pulumi.getter(name="enableDisplay")
    def enable_display(self) -> Optional[pulumi.Input[bool]]:
        """
        Defines whether the instance has Display enabled.
        """
        return pulumi.get(self, "enable_display")

    @enable_display.setter
    def enable_display(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_display", value)


@pulumi.input_type
class DistributionPolicyZoneConfigurationArgs:
    def __init__(__self__, *,
                 zone: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] zone: The URL of the zone. The zone must exist in the region where the managed instance group is located.
        """
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[str]]:
        """
        The URL of the zone. The zone must exist in the region where the managed instance group is located.
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zone", value)


@pulumi.input_type
class DistributionPolicyArgs:
    def __init__(__self__, *,
                 target_shape: Optional[pulumi.Input['DistributionPolicyTargetShape']] = None,
                 zones: Optional[pulumi.Input[Sequence[pulumi.Input['DistributionPolicyZoneConfigurationArgs']]]] = None):
        """
        :param pulumi.Input['DistributionPolicyTargetShape'] target_shape: The distribution shape to which the group converges either proactively or on resize events (depending on the value set in updatePolicy.instanceRedistributionType).
        :param pulumi.Input[Sequence[pulumi.Input['DistributionPolicyZoneConfigurationArgs']]] zones: Zones where the regional managed instance group will create and manage its instances.
        """
        if target_shape is not None:
            pulumi.set(__self__, "target_shape", target_shape)
        if zones is not None:
            pulumi.set(__self__, "zones", zones)

    @property
    @pulumi.getter(name="targetShape")
    def target_shape(self) -> Optional[pulumi.Input['DistributionPolicyTargetShape']]:
        """
        The distribution shape to which the group converges either proactively or on resize events (depending on the value set in updatePolicy.instanceRedistributionType).
        """
        return pulumi.get(self, "target_shape")

    @target_shape.setter
    def target_shape(self, value: Optional[pulumi.Input['DistributionPolicyTargetShape']]):
        pulumi.set(self, "target_shape", value)

    @property
    @pulumi.getter
    def zones(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DistributionPolicyZoneConfigurationArgs']]]]:
        """
        Zones where the regional managed instance group will create and manage its instances.
        """
        return pulumi.get(self, "zones")

    @zones.setter
    def zones(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DistributionPolicyZoneConfigurationArgs']]]]):
        pulumi.set(self, "zones", value)


@pulumi.input_type
class DurationArgs:
    def __init__(__self__, *,
                 nanos: Optional[pulumi.Input[int]] = None,
                 seconds: Optional[pulumi.Input[str]] = None):
        """
        A Duration represents a fixed-length span of time represented as a count of seconds and fractions of seconds at nanosecond resolution. It is independent of any calendar and concepts like "day" or "month". Range is approximately 10,000 years.
        :param pulumi.Input[int] nanos: Span of time that's a fraction of a second at nanosecond resolution. Durations less than one second are represented with a 0 `seconds` field and a positive `nanos` field. Must be from 0 to 999,999,999 inclusive.
        :param pulumi.Input[str] seconds: Span of time at a resolution of a second. Must be from 0 to 315,576,000,000 inclusive. Note: these bounds are computed from: 60 sec/min * 60 min/hr * 24 hr/day * 365.25 days/year * 10000 years
        """
        if nanos is not None:
            pulumi.set(__self__, "nanos", nanos)
        if seconds is not None:
            pulumi.set(__self__, "seconds", seconds)

    @property
    @pulumi.getter
    def nanos(self) -> Optional[pulumi.Input[int]]:
        """
        Span of time that's a fraction of a second at nanosecond resolution. Durations less than one second are represented with a 0 `seconds` field and a positive `nanos` field. Must be from 0 to 999,999,999 inclusive.
        """
        return pulumi.get(self, "nanos")

    @nanos.setter
    def nanos(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "nanos", value)

    @property
    @pulumi.getter
    def seconds(self) -> Optional[pulumi.Input[str]]:
        """
        Span of time at a resolution of a second. Must be from 0 to 315,576,000,000 inclusive. Note: these bounds are computed from: 60 sec/min * 60 min/hr * 24 hr/day * 365.25 days/year * 10000 years
        """
        return pulumi.get(self, "seconds")

    @seconds.setter
    def seconds(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "seconds", value)


@pulumi.input_type
class ExprArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 expression: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 title: Optional[pulumi.Input[str]] = None):
        """
        Represents a textual expression in the Common Expression Language (CEL) syntax. CEL is a C-like expression language. The syntax and semantics of CEL are documented at https://github.com/google/cel-spec. Example (Comparison): title: "Summary size limit" description: "Determines if a summary is less than 100 chars" expression: "document.summary.size() < 100" Example (Equality): title: "Requestor is owner" description: "Determines if requestor is the document owner" expression: "document.owner == request.auth.claims.email" Example (Logic): title: "Public documents" description: "Determine whether the document should be publicly visible" expression: "document.type != 'private' && document.type != 'internal'" Example (Data Manipulation): title: "Notification string" description: "Create a notification string with a timestamp." expression: "'New message received at ' + string(document.create_time)" The exact variables and functions that may be referenced within an expression are determined by the service that evaluates it. See the service documentation for additional information.
        :param pulumi.Input[str] description: Optional. Description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
        :param pulumi.Input[str] expression: Textual representation of an expression in Common Expression Language syntax.
        :param pulumi.Input[str] location: Optional. String indicating the location of the expression for error reporting, e.g. a file name and a position in the file.
        :param pulumi.Input[str] title: Optional. Title for the expression, i.e. a short string describing its purpose. This can be used e.g. in UIs which allow to enter the expression.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if expression is not None:
            pulumi.set(__self__, "expression", expression)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if title is not None:
            pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def expression(self) -> Optional[pulumi.Input[str]]:
        """
        Textual representation of an expression in Common Expression Language syntax.
        """
        return pulumi.get(self, "expression")

    @expression.setter
    def expression(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expression", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. String indicating the location of the expression for error reporting, e.g. a file name and a position in the file.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def title(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Title for the expression, i.e. a short string describing its purpose. This can be used e.g. in UIs which allow to enter the expression.
        """
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "title", value)


@pulumi.input_type
class ExternalVpnGatewayInterfaceArgs:
    def __init__(__self__, *,
                 id: Optional[pulumi.Input[int]] = None,
                 ip_address: Optional[pulumi.Input[str]] = None):
        """
        The interface for the external VPN gateway.
        :param pulumi.Input[int] id: The numeric ID of this interface. The allowed input values for this id for different redundancy types of external VPN gateway: - SINGLE_IP_INTERNALLY_REDUNDANT - 0 - TWO_IPS_REDUNDANCY - 0, 1 - FOUR_IPS_REDUNDANCY - 0, 1, 2, 3 
        :param pulumi.Input[str] ip_address: IP address of the interface in the external VPN gateway. Only IPv4 is supported. This IP address can be either from your on-premise gateway or another Cloud provider's VPN gateway, it cannot be an IP address from Google Compute Engine.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[int]]:
        """
        The numeric ID of this interface. The allowed input values for this id for different redundancy types of external VPN gateway: - SINGLE_IP_INTERNALLY_REDUNDANT - 0 - TWO_IPS_REDUNDANCY - 0, 1 - FOUR_IPS_REDUNDANCY - 0, 1, 2, 3 
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[pulumi.Input[str]]:
        """
        IP address of the interface in the external VPN gateway. Only IPv4 is supported. This IP address can be either from your on-premise gateway or another Cloud provider's VPN gateway, it cannot be an IP address from Google Compute Engine.
        """
        return pulumi.get(self, "ip_address")

    @ip_address.setter
    def ip_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip_address", value)


@pulumi.input_type
class FileContentBufferArgs:
    def __init__(__self__, *,
                 content: Optional[pulumi.Input[str]] = None,
                 file_type: Optional[pulumi.Input['FileContentBufferFileType']] = None):
        """
        :param pulumi.Input[str] content: The raw content in the secure keys file.
        :param pulumi.Input['FileContentBufferFileType'] file_type: The file type of source file.
        """
        if content is not None:
            pulumi.set(__self__, "content", content)
        if file_type is not None:
            pulumi.set(__self__, "file_type", file_type)

    @property
    @pulumi.getter
    def content(self) -> Optional[pulumi.Input[str]]:
        """
        The raw content in the secure keys file.
        """
        return pulumi.get(self, "content")

    @content.setter
    def content(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "content", value)

    @property
    @pulumi.getter(name="fileType")
    def file_type(self) -> Optional[pulumi.Input['FileContentBufferFileType']]:
        """
        The file type of source file.
        """
        return pulumi.get(self, "file_type")

    @file_type.setter
    def file_type(self, value: Optional[pulumi.Input['FileContentBufferFileType']]):
        pulumi.set(self, "file_type", value)


@pulumi.input_type
class FirewallAllowedItemArgs:
    def __init__(__self__, *,
                 ip_protocol: Optional[pulumi.Input[str]] = None,
                 ports: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[str] ip_protocol: The IP protocol to which this rule applies. The protocol type is required when creating a firewall rule. This value can either be one of the following well known protocol strings (tcp, udp, icmp, esp, ah, ipip, sctp) or the IP protocol number.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ports: An optional list of ports to which this rule applies. This field is only applicable for the UDP or TCP protocol. Each entry must be either an integer or a range. If not specified, this rule applies to connections through any port. Example inputs include: ["22"], ["80","443"], and ["12345-12349"].
        """
        if ip_protocol is not None:
            pulumi.set(__self__, "ip_protocol", ip_protocol)
        if ports is not None:
            pulumi.set(__self__, "ports", ports)

    @property
    @pulumi.getter(name="ipProtocol")
    def ip_protocol(self) -> Optional[pulumi.Input[str]]:
        """
        The IP protocol to which this rule applies. The protocol type is required when creating a firewall rule. This value can either be one of the following well known protocol strings (tcp, udp, icmp, esp, ah, ipip, sctp) or the IP protocol number.
        """
        return pulumi.get(self, "ip_protocol")

    @ip_protocol.setter
    def ip_protocol(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip_protocol", value)

    @property
    @pulumi.getter
    def ports(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        An optional list of ports to which this rule applies. This field is only applicable for the UDP or TCP protocol. Each entry must be either an integer or a range. If not specified, this rule applies to connections through any port. Example inputs include: ["22"], ["80","443"], and ["12345-12349"].
        """
        return pulumi.get(self, "ports")

    @ports.setter
    def ports(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "ports", value)


@pulumi.input_type
class FirewallDeniedItemArgs:
    def __init__(__self__, *,
                 ip_protocol: Optional[pulumi.Input[str]] = None,
                 ports: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[str] ip_protocol: The IP protocol to which this rule applies. The protocol type is required when creating a firewall rule. This value can either be one of the following well known protocol strings (tcp, udp, icmp, esp, ah, ipip, sctp) or the IP protocol number.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ports: An optional list of ports to which this rule applies. This field is only applicable for the UDP or TCP protocol. Each entry must be either an integer or a range. If not specified, this rule applies to connections through any port. Example inputs include: ["22"], ["80","443"], and ["12345-12349"].
        """
        if ip_protocol is not None:
            pulumi.set(__self__, "ip_protocol", ip_protocol)
        if ports is not None:
            pulumi.set(__self__, "ports", ports)

    @property
    @pulumi.getter(name="ipProtocol")
    def ip_protocol(self) -> Optional[pulumi.Input[str]]:
        """
        The IP protocol to which this rule applies. The protocol type is required when creating a firewall rule. This value can either be one of the following well known protocol strings (tcp, udp, icmp, esp, ah, ipip, sctp) or the IP protocol number.
        """
        return pulumi.get(self, "ip_protocol")

    @ip_protocol.setter
    def ip_protocol(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip_protocol", value)

    @property
    @pulumi.getter
    def ports(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        An optional list of ports to which this rule applies. This field is only applicable for the UDP or TCP protocol. Each entry must be either an integer or a range. If not specified, this rule applies to connections through any port. Example inputs include: ["22"], ["80","443"], and ["12345-12349"].
        """
        return pulumi.get(self, "ports")

    @ports.setter
    def ports(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "ports", value)


@pulumi.input_type
class FirewallLogConfigArgs:
    def __init__(__self__, *,
                 enable: Optional[pulumi.Input[bool]] = None,
                 metadata: Optional[pulumi.Input['FirewallLogConfigMetadata']] = None):
        """
        The available logging options for a firewall rule.
        :param pulumi.Input[bool] enable: This field denotes whether to enable logging for a particular firewall rule.
        :param pulumi.Input['FirewallLogConfigMetadata'] metadata: This field can only be specified for a particular firewall rule if logging is enabled for that rule. This field denotes whether to include or exclude metadata for firewall logs.
        """
        if enable is not None:
            pulumi.set(__self__, "enable", enable)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)

    @property
    @pulumi.getter
    def enable(self) -> Optional[pulumi.Input[bool]]:
        """
        This field denotes whether to enable logging for a particular firewall rule.
        """
        return pulumi.get(self, "enable")

    @enable.setter
    def enable(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable", value)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input['FirewallLogConfigMetadata']]:
        """
        This field can only be specified for a particular firewall rule if logging is enabled for that rule. This field denotes whether to include or exclude metadata for firewall logs.
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input['FirewallLogConfigMetadata']]):
        pulumi.set(self, "metadata", value)


@pulumi.input_type
class FirewallPolicyAssociationArgs:
    def __init__(__self__, *,
                 attachment_target: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] attachment_target: The target that the firewall policy is attached to.
        :param pulumi.Input[str] name: The name for an association.
        """
        if attachment_target is not None:
            pulumi.set(__self__, "attachment_target", attachment_target)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="attachmentTarget")
    def attachment_target(self) -> Optional[pulumi.Input[str]]:
        """
        The target that the firewall policy is attached to.
        """
        return pulumi.get(self, "attachment_target")

    @attachment_target.setter
    def attachment_target(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "attachment_target", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name for an association.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class FirewallPolicyRuleMatcherLayer4ConfigArgs:
    def __init__(__self__, *,
                 ip_protocol: Optional[pulumi.Input[str]] = None,
                 ports: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[str] ip_protocol: The IP protocol to which this rule applies. The protocol type is required when creating a firewall rule. This value can either be one of the following well known protocol strings (tcp, udp, icmp, esp, ah, ipip, sctp), or the IP protocol number.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ports: An optional list of ports to which this rule applies. This field is only applicable for UDP or TCP protocol. Each entry must be either an integer or a range. If not specified, this rule applies to connections through any port. Example inputs include: ["22"], ["80","443"], and ["12345-12349"].
        """
        if ip_protocol is not None:
            pulumi.set(__self__, "ip_protocol", ip_protocol)
        if ports is not None:
            pulumi.set(__self__, "ports", ports)

    @property
    @pulumi.getter(name="ipProtocol")
    def ip_protocol(self) -> Optional[pulumi.Input[str]]:
        """
        The IP protocol to which this rule applies. The protocol type is required when creating a firewall rule. This value can either be one of the following well known protocol strings (tcp, udp, icmp, esp, ah, ipip, sctp), or the IP protocol number.
        """
        return pulumi.get(self, "ip_protocol")

    @ip_protocol.setter
    def ip_protocol(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip_protocol", value)

    @property
    @pulumi.getter
    def ports(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        An optional list of ports to which this rule applies. This field is only applicable for UDP or TCP protocol. Each entry must be either an integer or a range. If not specified, this rule applies to connections through any port. Example inputs include: ["22"], ["80","443"], and ["12345-12349"].
        """
        return pulumi.get(self, "ports")

    @ports.setter
    def ports(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "ports", value)


@pulumi.input_type
class FirewallPolicyRuleMatcherArgs:
    def __init__(__self__, *,
                 dest_ip_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 layer4_configs: Optional[pulumi.Input[Sequence[pulumi.Input['FirewallPolicyRuleMatcherLayer4ConfigArgs']]]] = None,
                 src_ip_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Represents a match condition that incoming traffic is evaluated against. Exactly one field must be specified.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] dest_ip_ranges: CIDR IP address range. Maximum number of destination CIDR IP ranges allowed is 5000.
        :param pulumi.Input[Sequence[pulumi.Input['FirewallPolicyRuleMatcherLayer4ConfigArgs']]] layer4_configs: Pairs of IP protocols and ports that the rule should match.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] src_ip_ranges: CIDR IP address range. Maximum number of source CIDR IP ranges allowed is 5000.
        """
        if dest_ip_ranges is not None:
            pulumi.set(__self__, "dest_ip_ranges", dest_ip_ranges)
        if layer4_configs is not None:
            pulumi.set(__self__, "layer4_configs", layer4_configs)
        if src_ip_ranges is not None:
            pulumi.set(__self__, "src_ip_ranges", src_ip_ranges)

    @property
    @pulumi.getter(name="destIpRanges")
    def dest_ip_ranges(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        CIDR IP address range. Maximum number of destination CIDR IP ranges allowed is 5000.
        """
        return pulumi.get(self, "dest_ip_ranges")

    @dest_ip_ranges.setter
    def dest_ip_ranges(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "dest_ip_ranges", value)

    @property
    @pulumi.getter(name="layer4Configs")
    def layer4_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FirewallPolicyRuleMatcherLayer4ConfigArgs']]]]:
        """
        Pairs of IP protocols and ports that the rule should match.
        """
        return pulumi.get(self, "layer4_configs")

    @layer4_configs.setter
    def layer4_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FirewallPolicyRuleMatcherLayer4ConfigArgs']]]]):
        pulumi.set(self, "layer4_configs", value)

    @property
    @pulumi.getter(name="srcIpRanges")
    def src_ip_ranges(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        CIDR IP address range. Maximum number of source CIDR IP ranges allowed is 5000.
        """
        return pulumi.get(self, "src_ip_ranges")

    @src_ip_ranges.setter
    def src_ip_ranges(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "src_ip_ranges", value)


@pulumi.input_type
class FirewallPolicyRuleArgs:
    def __init__(__self__, *,
                 action: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 direction: Optional[pulumi.Input['FirewallPolicyRuleDirection']] = None,
                 disabled: Optional[pulumi.Input[bool]] = None,
                 enable_logging: Optional[pulumi.Input[bool]] = None,
                 match: Optional[pulumi.Input['FirewallPolicyRuleMatcherArgs']] = None,
                 priority: Optional[pulumi.Input[int]] = None,
                 target_resources: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 target_service_accounts: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Represents a rule that describes one or more match conditions along with the action to be taken when traffic matches this condition (allow or deny).
        :param pulumi.Input[str] action: The Action to perform when the client connection triggers the rule. Can currently be either "allow" or "deny()" where valid values for status are 403, 404, and 502.
        :param pulumi.Input[str] description: An optional description for this resource.
        :param pulumi.Input['FirewallPolicyRuleDirection'] direction: The direction in which this rule applies.
        :param pulumi.Input[bool] disabled: Denotes whether the firewall policy rule is disabled. When set to true, the firewall policy rule is not enforced and traffic behaves as if it did not exist. If this is unspecified, the firewall policy rule will be enabled.
        :param pulumi.Input[bool] enable_logging: Denotes whether to enable logging for a particular rule. If logging is enabled, logs will be exported to the configured export destination in Stackdriver. Logs may be exported to BigQuery or Pub/Sub. Note: you cannot enable logging on "goto_next" rules.
        :param pulumi.Input['FirewallPolicyRuleMatcherArgs'] match: A match condition that incoming traffic is evaluated against. If it evaluates to true, the corresponding 'action' is enforced.
        :param pulumi.Input[int] priority: An integer indicating the priority of a rule in the list. The priority must be a positive value between 0 and 2147483647. Rules are evaluated from highest to lowest priority where 0 is the highest priority and 2147483647 is the lowest prority.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] target_resources: A list of network resource URLs to which this rule applies. This field allows you to control which network's VMs get this rule. If this field is left blank, all VMs within the organization will receive the rule.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] target_service_accounts: A list of service accounts indicating the sets of instances that are applied with this rule.
        """
        if action is not None:
            pulumi.set(__self__, "action", action)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if direction is not None:
            pulumi.set(__self__, "direction", direction)
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)
        if enable_logging is not None:
            pulumi.set(__self__, "enable_logging", enable_logging)
        if match is not None:
            pulumi.set(__self__, "match", match)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if target_resources is not None:
            pulumi.set(__self__, "target_resources", target_resources)
        if target_service_accounts is not None:
            pulumi.set(__self__, "target_service_accounts", target_service_accounts)

    @property
    @pulumi.getter
    def action(self) -> Optional[pulumi.Input[str]]:
        """
        The Action to perform when the client connection triggers the rule. Can currently be either "allow" or "deny()" where valid values for status are 403, 404, and 502.
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "action", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        An optional description for this resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def direction(self) -> Optional[pulumi.Input['FirewallPolicyRuleDirection']]:
        """
        The direction in which this rule applies.
        """
        return pulumi.get(self, "direction")

    @direction.setter
    def direction(self, value: Optional[pulumi.Input['FirewallPolicyRuleDirection']]):
        pulumi.set(self, "direction", value)

    @property
    @pulumi.getter
    def disabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Denotes whether the firewall policy rule is disabled. When set to true, the firewall policy rule is not enforced and traffic behaves as if it did not exist. If this is unspecified, the firewall policy rule will be enabled.
        """
        return pulumi.get(self, "disabled")

    @disabled.setter
    def disabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disabled", value)

    @property
    @pulumi.getter(name="enableLogging")
    def enable_logging(self) -> Optional[pulumi.Input[bool]]:
        """
        Denotes whether to enable logging for a particular rule. If logging is enabled, logs will be exported to the configured export destination in Stackdriver. Logs may be exported to BigQuery or Pub/Sub. Note: you cannot enable logging on "goto_next" rules.
        """
        return pulumi.get(self, "enable_logging")

    @enable_logging.setter
    def enable_logging(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_logging", value)

    @property
    @pulumi.getter
    def match(self) -> Optional[pulumi.Input['FirewallPolicyRuleMatcherArgs']]:
        """
        A match condition that incoming traffic is evaluated against. If it evaluates to true, the corresponding 'action' is enforced.
        """
        return pulumi.get(self, "match")

    @match.setter
    def match(self, value: Optional[pulumi.Input['FirewallPolicyRuleMatcherArgs']]):
        pulumi.set(self, "match", value)

    @property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[int]]:
        """
        An integer indicating the priority of a rule in the list. The priority must be a positive value between 0 and 2147483647. Rules are evaluated from highest to lowest priority where 0 is the highest priority and 2147483647 is the lowest prority.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "priority", value)

    @property
    @pulumi.getter(name="targetResources")
    def target_resources(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of network resource URLs to which this rule applies. This field allows you to control which network's VMs get this rule. If this field is left blank, all VMs within the organization will receive the rule.
        """
        return pulumi.get(self, "target_resources")

    @target_resources.setter
    def target_resources(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "target_resources", value)

    @property
    @pulumi.getter(name="targetServiceAccounts")
    def target_service_accounts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of service accounts indicating the sets of instances that are applied with this rule.
        """
        return pulumi.get(self, "target_service_accounts")

    @target_service_accounts.setter
    def target_service_accounts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "target_service_accounts", value)


@pulumi.input_type
class FixedOrPercentArgs:
    def __init__(__self__, *,
                 fixed: Optional[pulumi.Input[int]] = None,
                 percent: Optional[pulumi.Input[int]] = None):
        """
        Encapsulates numeric value that can be either absolute or relative.
        :param pulumi.Input[int] fixed: Specifies a fixed number of VM instances. This must be a positive integer.
        :param pulumi.Input[int] percent: Specifies a percentage of instances between 0 to 100%, inclusive. For example, specify 80 for 80%.
        """
        if fixed is not None:
            pulumi.set(__self__, "fixed", fixed)
        if percent is not None:
            pulumi.set(__self__, "percent", percent)

    @property
    @pulumi.getter
    def fixed(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies a fixed number of VM instances. This must be a positive integer.
        """
        return pulumi.get(self, "fixed")

    @fixed.setter
    def fixed(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "fixed", value)

    @property
    @pulumi.getter
    def percent(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies a percentage of instances between 0 to 100%, inclusive. For example, specify 80 for 80%.
        """
        return pulumi.get(self, "percent")

    @percent.setter
    def percent(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "percent", value)


@pulumi.input_type
class ForwardingRuleServiceDirectoryRegistrationArgs:
    def __init__(__self__, *,
                 namespace: Optional[pulumi.Input[str]] = None,
                 service: Optional[pulumi.Input[str]] = None,
                 service_directory_region: Optional[pulumi.Input[str]] = None):
        """
        Describes the auto-registration of the Forwarding Rule to Service Directory. The region and project of the Service Directory resource generated from this registration will be the same as this Forwarding Rule.
        :param pulumi.Input[str] namespace: Service Directory namespace to register the forwarding rule under.
        :param pulumi.Input[str] service: Service Directory service to register the forwarding rule under.
        :param pulumi.Input[str] service_directory_region: [Optional] Service Directory region to register this global forwarding rule under. Default to "us-central1". Only used for PSC for Google APIs. All PSC for Google APIs Forwarding Rules on the same network should use the same Service Directory region.
        """
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if service is not None:
            pulumi.set(__self__, "service", service)
        if service_directory_region is not None:
            pulumi.set(__self__, "service_directory_region", service_directory_region)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[str]]:
        """
        Service Directory namespace to register the forwarding rule under.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter
    def service(self) -> Optional[pulumi.Input[str]]:
        """
        Service Directory service to register the forwarding rule under.
        """
        return pulumi.get(self, "service")

    @service.setter
    def service(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service", value)

    @property
    @pulumi.getter(name="serviceDirectoryRegion")
    def service_directory_region(self) -> Optional[pulumi.Input[str]]:
        """
        [Optional] Service Directory region to register this global forwarding rule under. Default to "us-central1". Only used for PSC for Google APIs. All PSC for Google APIs Forwarding Rules on the same network should use the same Service Directory region.
        """
        return pulumi.get(self, "service_directory_region")

    @service_directory_region.setter
    def service_directory_region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_directory_region", value)


@pulumi.input_type
class GRPCHealthCheckArgs:
    def __init__(__self__, *,
                 grpc_service_name: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 port_name: Optional[pulumi.Input[str]] = None,
                 port_specification: Optional[pulumi.Input['GRPCHealthCheckPortSpecification']] = None):
        """
        :param pulumi.Input[str] grpc_service_name: The gRPC service name for the health check. This field is optional. The value of grpc_service_name has the following meanings by convention: - Empty service_name means the overall status of all services at the backend. - Non-empty service_name means the health of that gRPC service, as defined by the owner of the service. The grpc_service_name can only be ASCII.
        :param pulumi.Input[int] port: The port number for the health check request. Must be specified if port_name and port_specification are not set or if port_specification is USE_FIXED_PORT. Valid values are 1 through 65535.
        :param pulumi.Input[str] port_name: Port name as defined in InstanceGroup#NamedPort#name. If both port and port_name are defined, port takes precedence. The port_name should conform to RFC1035.
        :param pulumi.Input['GRPCHealthCheckPortSpecification'] port_specification: Specifies how port is selected for health checking, can be one of following values: USE_FIXED_PORT: The port number in port is used for health checking. USE_NAMED_PORT: The portName is used for health checking. USE_SERVING_PORT: For NetworkEndpointGroup, the port specified for each network endpoint is used for health checking. For other backends, the port or named port specified in the Backend Service is used for health checking. If not specified, gRPC health check follows behavior specified in port and portName fields.
        """
        if grpc_service_name is not None:
            pulumi.set(__self__, "grpc_service_name", grpc_service_name)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if port_name is not None:
            pulumi.set(__self__, "port_name", port_name)
        if port_specification is not None:
            pulumi.set(__self__, "port_specification", port_specification)

    @property
    @pulumi.getter(name="grpcServiceName")
    def grpc_service_name(self) -> Optional[pulumi.Input[str]]:
        """
        The gRPC service name for the health check. This field is optional. The value of grpc_service_name has the following meanings by convention: - Empty service_name means the overall status of all services at the backend. - Non-empty service_name means the health of that gRPC service, as defined by the owner of the service. The grpc_service_name can only be ASCII.
        """
        return pulumi.get(self, "grpc_service_name")

    @grpc_service_name.setter
    def grpc_service_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "grpc_service_name", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        The port number for the health check request. Must be specified if port_name and port_specification are not set or if port_specification is USE_FIXED_PORT. Valid values are 1 through 65535.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter(name="portName")
    def port_name(self) -> Optional[pulumi.Input[str]]:
        """
        Port name as defined in InstanceGroup#NamedPort#name. If both port and port_name are defined, port takes precedence. The port_name should conform to RFC1035.
        """
        return pulumi.get(self, "port_name")

    @port_name.setter
    def port_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "port_name", value)

    @property
    @pulumi.getter(name="portSpecification")
    def port_specification(self) -> Optional[pulumi.Input['GRPCHealthCheckPortSpecification']]:
        """
        Specifies how port is selected for health checking, can be one of following values: USE_FIXED_PORT: The port number in port is used for health checking. USE_NAMED_PORT: The portName is used for health checking. USE_SERVING_PORT: For NetworkEndpointGroup, the port specified for each network endpoint is used for health checking. For other backends, the port or named port specified in the Backend Service is used for health checking. If not specified, gRPC health check follows behavior specified in port and portName fields.
        """
        return pulumi.get(self, "port_specification")

    @port_specification.setter
    def port_specification(self, value: Optional[pulumi.Input['GRPCHealthCheckPortSpecification']]):
        pulumi.set(self, "port_specification", value)


@pulumi.input_type
class GuestOsFeatureArgs:
    def __init__(__self__, *,
                 type: Optional[pulumi.Input['GuestOsFeatureType']] = None):
        """
        Guest OS features.
        :param pulumi.Input['GuestOsFeatureType'] type: The ID of a supported feature. To add multiple values, use commas to separate values. Set to one or more of the following values: - VIRTIO_SCSI_MULTIQUEUE - WINDOWS - MULTI_IP_SUBNET - UEFI_COMPATIBLE - SECURE_BOOT - GVNIC - SEV_CAPABLE - SUSPEND_RESUME_COMPATIBLE For more information, see Enabling guest operating system features.
        """
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input['GuestOsFeatureType']]:
        """
        The ID of a supported feature. To add multiple values, use commas to separate values. Set to one or more of the following values: - VIRTIO_SCSI_MULTIQUEUE - WINDOWS - MULTI_IP_SUBNET - UEFI_COMPATIBLE - SECURE_BOOT - GVNIC - SEV_CAPABLE - SUSPEND_RESUME_COMPATIBLE For more information, see Enabling guest operating system features.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input['GuestOsFeatureType']]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class HTTP2HealthCheckArgs:
    def __init__(__self__, *,
                 host: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 port_name: Optional[pulumi.Input[str]] = None,
                 port_specification: Optional[pulumi.Input['HTTP2HealthCheckPortSpecification']] = None,
                 proxy_header: Optional[pulumi.Input['HTTP2HealthCheckProxyHeader']] = None,
                 request_path: Optional[pulumi.Input[str]] = None,
                 response: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] host: The value of the host header in the HTTP/2 health check request. If left empty (default value), the IP on behalf of which this health check is performed will be used.
        :param pulumi.Input[int] port: The TCP port number for the health check request. The default value is 443. Valid values are 1 through 65535.
        :param pulumi.Input[str] port_name: Port name as defined in InstanceGroup#NamedPort#name. If both port and port_name are defined, port takes precedence.
        :param pulumi.Input['HTTP2HealthCheckPortSpecification'] port_specification: Specifies how port is selected for health checking, can be one of following values: USE_FIXED_PORT: The port number in port is used for health checking. USE_NAMED_PORT: The portName is used for health checking. USE_SERVING_PORT: For NetworkEndpointGroup, the port specified for each network endpoint is used for health checking. For other backends, the port or named port specified in the Backend Service is used for health checking. If not specified, HTTP2 health check follows behavior specified in port and portName fields.
        :param pulumi.Input['HTTP2HealthCheckProxyHeader'] proxy_header: Specifies the type of proxy header to append before sending data to the backend, either NONE or PROXY_V1. The default is NONE.
        :param pulumi.Input[str] request_path: The request path of the HTTP/2 health check request. The default value is /.
        :param pulumi.Input[str] response: The string to match anywhere in the first 1024 bytes of the response body. If left empty (the default value), the status code determines health. The response data can only be ASCII.
        """
        if host is not None:
            pulumi.set(__self__, "host", host)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if port_name is not None:
            pulumi.set(__self__, "port_name", port_name)
        if port_specification is not None:
            pulumi.set(__self__, "port_specification", port_specification)
        if proxy_header is not None:
            pulumi.set(__self__, "proxy_header", proxy_header)
        if request_path is not None:
            pulumi.set(__self__, "request_path", request_path)
        if response is not None:
            pulumi.set(__self__, "response", response)

    @property
    @pulumi.getter
    def host(self) -> Optional[pulumi.Input[str]]:
        """
        The value of the host header in the HTTP/2 health check request. If left empty (default value), the IP on behalf of which this health check is performed will be used.
        """
        return pulumi.get(self, "host")

    @host.setter
    def host(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "host", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        The TCP port number for the health check request. The default value is 443. Valid values are 1 through 65535.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter(name="portName")
    def port_name(self) -> Optional[pulumi.Input[str]]:
        """
        Port name as defined in InstanceGroup#NamedPort#name. If both port and port_name are defined, port takes precedence.
        """
        return pulumi.get(self, "port_name")

    @port_name.setter
    def port_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "port_name", value)

    @property
    @pulumi.getter(name="portSpecification")
    def port_specification(self) -> Optional[pulumi.Input['HTTP2HealthCheckPortSpecification']]:
        """
        Specifies how port is selected for health checking, can be one of following values: USE_FIXED_PORT: The port number in port is used for health checking. USE_NAMED_PORT: The portName is used for health checking. USE_SERVING_PORT: For NetworkEndpointGroup, the port specified for each network endpoint is used for health checking. For other backends, the port or named port specified in the Backend Service is used for health checking. If not specified, HTTP2 health check follows behavior specified in port and portName fields.
        """
        return pulumi.get(self, "port_specification")

    @port_specification.setter
    def port_specification(self, value: Optional[pulumi.Input['HTTP2HealthCheckPortSpecification']]):
        pulumi.set(self, "port_specification", value)

    @property
    @pulumi.getter(name="proxyHeader")
    def proxy_header(self) -> Optional[pulumi.Input['HTTP2HealthCheckProxyHeader']]:
        """
        Specifies the type of proxy header to append before sending data to the backend, either NONE or PROXY_V1. The default is NONE.
        """
        return pulumi.get(self, "proxy_header")

    @proxy_header.setter
    def proxy_header(self, value: Optional[pulumi.Input['HTTP2HealthCheckProxyHeader']]):
        pulumi.set(self, "proxy_header", value)

    @property
    @pulumi.getter(name="requestPath")
    def request_path(self) -> Optional[pulumi.Input[str]]:
        """
        The request path of the HTTP/2 health check request. The default value is /.
        """
        return pulumi.get(self, "request_path")

    @request_path.setter
    def request_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "request_path", value)

    @property
    @pulumi.getter
    def response(self) -> Optional[pulumi.Input[str]]:
        """
        The string to match anywhere in the first 1024 bytes of the response body. If left empty (the default value), the status code determines health. The response data can only be ASCII.
        """
        return pulumi.get(self, "response")

    @response.setter
    def response(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "response", value)


@pulumi.input_type
class HTTPHealthCheckArgs:
    def __init__(__self__, *,
                 host: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 port_name: Optional[pulumi.Input[str]] = None,
                 port_specification: Optional[pulumi.Input['HTTPHealthCheckPortSpecification']] = None,
                 proxy_header: Optional[pulumi.Input['HTTPHealthCheckProxyHeader']] = None,
                 request_path: Optional[pulumi.Input[str]] = None,
                 response: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] host: The value of the host header in the HTTP health check request. If left empty (default value), the IP on behalf of which this health check is performed will be used.
        :param pulumi.Input[int] port: The TCP port number for the health check request. The default value is 80. Valid values are 1 through 65535.
        :param pulumi.Input[str] port_name: Port name as defined in InstanceGroup#NamedPort#name. If both port and port_name are defined, port takes precedence.
        :param pulumi.Input['HTTPHealthCheckPortSpecification'] port_specification: Specifies how port is selected for health checking, can be one of following values: USE_FIXED_PORT: The port number in port is used for health checking. USE_NAMED_PORT: The portName is used for health checking. USE_SERVING_PORT: For NetworkEndpointGroup, the port specified for each network endpoint is used for health checking. For other backends, the port or named port specified in the Backend Service is used for health checking. If not specified, HTTP health check follows behavior specified in port and portName fields.
        :param pulumi.Input['HTTPHealthCheckProxyHeader'] proxy_header: Specifies the type of proxy header to append before sending data to the backend, either NONE or PROXY_V1. The default is NONE.
        :param pulumi.Input[str] request_path: The request path of the HTTP health check request. The default value is /.
        :param pulumi.Input[str] response: The string to match anywhere in the first 1024 bytes of the response body. If left empty (the default value), the status code determines health. The response data can only be ASCII.
        """
        if host is not None:
            pulumi.set(__self__, "host", host)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if port_name is not None:
            pulumi.set(__self__, "port_name", port_name)
        if port_specification is not None:
            pulumi.set(__self__, "port_specification", port_specification)
        if proxy_header is not None:
            pulumi.set(__self__, "proxy_header", proxy_header)
        if request_path is not None:
            pulumi.set(__self__, "request_path", request_path)
        if response is not None:
            pulumi.set(__self__, "response", response)

    @property
    @pulumi.getter
    def host(self) -> Optional[pulumi.Input[str]]:
        """
        The value of the host header in the HTTP health check request. If left empty (default value), the IP on behalf of which this health check is performed will be used.
        """
        return pulumi.get(self, "host")

    @host.setter
    def host(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "host", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        The TCP port number for the health check request. The default value is 80. Valid values are 1 through 65535.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter(name="portName")
    def port_name(self) -> Optional[pulumi.Input[str]]:
        """
        Port name as defined in InstanceGroup#NamedPort#name. If both port and port_name are defined, port takes precedence.
        """
        return pulumi.get(self, "port_name")

    @port_name.setter
    def port_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "port_name", value)

    @property
    @pulumi.getter(name="portSpecification")
    def port_specification(self) -> Optional[pulumi.Input['HTTPHealthCheckPortSpecification']]:
        """
        Specifies how port is selected for health checking, can be one of following values: USE_FIXED_PORT: The port number in port is used for health checking. USE_NAMED_PORT: The portName is used for health checking. USE_SERVING_PORT: For NetworkEndpointGroup, the port specified for each network endpoint is used for health checking. For other backends, the port or named port specified in the Backend Service is used for health checking. If not specified, HTTP health check follows behavior specified in port and portName fields.
        """
        return pulumi.get(self, "port_specification")

    @port_specification.setter
    def port_specification(self, value: Optional[pulumi.Input['HTTPHealthCheckPortSpecification']]):
        pulumi.set(self, "port_specification", value)

    @property
    @pulumi.getter(name="proxyHeader")
    def proxy_header(self) -> Optional[pulumi.Input['HTTPHealthCheckProxyHeader']]:
        """
        Specifies the type of proxy header to append before sending data to the backend, either NONE or PROXY_V1. The default is NONE.
        """
        return pulumi.get(self, "proxy_header")

    @proxy_header.setter
    def proxy_header(self, value: Optional[pulumi.Input['HTTPHealthCheckProxyHeader']]):
        pulumi.set(self, "proxy_header", value)

    @property
    @pulumi.getter(name="requestPath")
    def request_path(self) -> Optional[pulumi.Input[str]]:
        """
        The request path of the HTTP health check request. The default value is /.
        """
        return pulumi.get(self, "request_path")

    @request_path.setter
    def request_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "request_path", value)

    @property
    @pulumi.getter
    def response(self) -> Optional[pulumi.Input[str]]:
        """
        The string to match anywhere in the first 1024 bytes of the response body. If left empty (the default value), the status code determines health. The response data can only be ASCII.
        """
        return pulumi.get(self, "response")

    @response.setter
    def response(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "response", value)


@pulumi.input_type
class HTTPSHealthCheckArgs:
    def __init__(__self__, *,
                 host: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 port_name: Optional[pulumi.Input[str]] = None,
                 port_specification: Optional[pulumi.Input['HTTPSHealthCheckPortSpecification']] = None,
                 proxy_header: Optional[pulumi.Input['HTTPSHealthCheckProxyHeader']] = None,
                 request_path: Optional[pulumi.Input[str]] = None,
                 response: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] host: The value of the host header in the HTTPS health check request. If left empty (default value), the IP on behalf of which this health check is performed will be used.
        :param pulumi.Input[int] port: The TCP port number for the health check request. The default value is 443. Valid values are 1 through 65535.
        :param pulumi.Input[str] port_name: Port name as defined in InstanceGroup#NamedPort#name. If both port and port_name are defined, port takes precedence.
        :param pulumi.Input['HTTPSHealthCheckPortSpecification'] port_specification: Specifies how port is selected for health checking, can be one of following values: USE_FIXED_PORT: The port number in port is used for health checking. USE_NAMED_PORT: The portName is used for health checking. USE_SERVING_PORT: For NetworkEndpointGroup, the port specified for each network endpoint is used for health checking. For other backends, the port or named port specified in the Backend Service is used for health checking. If not specified, HTTPS health check follows behavior specified in port and portName fields.
        :param pulumi.Input['HTTPSHealthCheckProxyHeader'] proxy_header: Specifies the type of proxy header to append before sending data to the backend, either NONE or PROXY_V1. The default is NONE.
        :param pulumi.Input[str] request_path: The request path of the HTTPS health check request. The default value is /.
        :param pulumi.Input[str] response: The string to match anywhere in the first 1024 bytes of the response body. If left empty (the default value), the status code determines health. The response data can only be ASCII.
        """
        if host is not None:
            pulumi.set(__self__, "host", host)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if port_name is not None:
            pulumi.set(__self__, "port_name", port_name)
        if port_specification is not None:
            pulumi.set(__self__, "port_specification", port_specification)
        if proxy_header is not None:
            pulumi.set(__self__, "proxy_header", proxy_header)
        if request_path is not None:
            pulumi.set(__self__, "request_path", request_path)
        if response is not None:
            pulumi.set(__self__, "response", response)

    @property
    @pulumi.getter
    def host(self) -> Optional[pulumi.Input[str]]:
        """
        The value of the host header in the HTTPS health check request. If left empty (default value), the IP on behalf of which this health check is performed will be used.
        """
        return pulumi.get(self, "host")

    @host.setter
    def host(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "host", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        The TCP port number for the health check request. The default value is 443. Valid values are 1 through 65535.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter(name="portName")
    def port_name(self) -> Optional[pulumi.Input[str]]:
        """
        Port name as defined in InstanceGroup#NamedPort#name. If both port and port_name are defined, port takes precedence.
        """
        return pulumi.get(self, "port_name")

    @port_name.setter
    def port_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "port_name", value)

    @property
    @pulumi.getter(name="portSpecification")
    def port_specification(self) -> Optional[pulumi.Input['HTTPSHealthCheckPortSpecification']]:
        """
        Specifies how port is selected for health checking, can be one of following values: USE_FIXED_PORT: The port number in port is used for health checking. USE_NAMED_PORT: The portName is used for health checking. USE_SERVING_PORT: For NetworkEndpointGroup, the port specified for each network endpoint is used for health checking. For other backends, the port or named port specified in the Backend Service is used for health checking. If not specified, HTTPS health check follows behavior specified in port and portName fields.
        """
        return pulumi.get(self, "port_specification")

    @port_specification.setter
    def port_specification(self, value: Optional[pulumi.Input['HTTPSHealthCheckPortSpecification']]):
        pulumi.set(self, "port_specification", value)

    @property
    @pulumi.getter(name="proxyHeader")
    def proxy_header(self) -> Optional[pulumi.Input['HTTPSHealthCheckProxyHeader']]:
        """
        Specifies the type of proxy header to append before sending data to the backend, either NONE or PROXY_V1. The default is NONE.
        """
        return pulumi.get(self, "proxy_header")

    @proxy_header.setter
    def proxy_header(self, value: Optional[pulumi.Input['HTTPSHealthCheckProxyHeader']]):
        pulumi.set(self, "proxy_header", value)

    @property
    @pulumi.getter(name="requestPath")
    def request_path(self) -> Optional[pulumi.Input[str]]:
        """
        The request path of the HTTPS health check request. The default value is /.
        """
        return pulumi.get(self, "request_path")

    @request_path.setter
    def request_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "request_path", value)

    @property
    @pulumi.getter
    def response(self) -> Optional[pulumi.Input[str]]:
        """
        The string to match anywhere in the first 1024 bytes of the response body. If left empty (the default value), the status code determines health. The response data can only be ASCII.
        """
        return pulumi.get(self, "response")

    @response.setter
    def response(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "response", value)


@pulumi.input_type
class HealthCheckLogConfigArgs:
    def __init__(__self__, *,
                 enable: Optional[pulumi.Input[bool]] = None):
        """
        Configuration of logging on a health check. If logging is enabled, logs will be exported to Stackdriver.
        :param pulumi.Input[bool] enable: Indicates whether or not to export logs. This is false by default, which means no health check logging will be done.
        """
        if enable is not None:
            pulumi.set(__self__, "enable", enable)

    @property
    @pulumi.getter
    def enable(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether or not to export logs. This is false by default, which means no health check logging will be done.
        """
        return pulumi.get(self, "enable")

    @enable.setter
    def enable(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable", value)


@pulumi.input_type
class HostRuleArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 hosts: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 path_matcher: Optional[pulumi.Input[str]] = None):
        """
        UrlMaps A host-matching rule for a URL. If matched, will use the named PathMatcher to select the BackendService.
        :param pulumi.Input[str] description: An optional description of this resource. Provide this property when you create the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] hosts: The list of host patterns to match. They must be valid hostnames with optional port numbers in the format host:port. * matches any string of ([a-z0-9-.]*). In that case, * must be the first character and must be followed in the pattern by either - or .. * based matching is not supported when the URL map is bound to a target gRPC proxy that has the validateForProxyless field set to true.
        :param pulumi.Input[str] path_matcher: The name of the PathMatcher to use to match the path portion of the URL if the hostRule matches the URL's host portion.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if hosts is not None:
            pulumi.set(__self__, "hosts", hosts)
        if path_matcher is not None:
            pulumi.set(__self__, "path_matcher", path_matcher)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        An optional description of this resource. Provide this property when you create the resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def hosts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of host patterns to match. They must be valid hostnames with optional port numbers in the format host:port. * matches any string of ([a-z0-9-.]*). In that case, * must be the first character and must be followed in the pattern by either - or .. * based matching is not supported when the URL map is bound to a target gRPC proxy that has the validateForProxyless field set to true.
        """
        return pulumi.get(self, "hosts")

    @hosts.setter
    def hosts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "hosts", value)

    @property
    @pulumi.getter(name="pathMatcher")
    def path_matcher(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the PathMatcher to use to match the path portion of the URL if the hostRule matches the URL's host portion.
        """
        return pulumi.get(self, "path_matcher")

    @path_matcher.setter
    def path_matcher(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path_matcher", value)


@pulumi.input_type
class HttpFaultAbortArgs:
    def __init__(__self__, *,
                 http_status: Optional[pulumi.Input[int]] = None,
                 percentage: Optional[pulumi.Input[float]] = None):
        """
        Specification for how requests are aborted as part of fault injection.
        :param pulumi.Input[int] http_status: The HTTP status code used to abort the request. The value must be from 200 to 599 inclusive. For gRPC protocol, the gRPC status code is mapped to HTTP status code according to this mapping table. HTTP status 200 is mapped to gRPC status UNKNOWN. Injecting an OK status is currently not supported by Traffic Director.
        :param pulumi.Input[float] percentage: The percentage of traffic for connections, operations, or requests that is aborted as part of fault injection. The value must be from 0.0 to 100.0 inclusive.
        """
        if http_status is not None:
            pulumi.set(__self__, "http_status", http_status)
        if percentage is not None:
            pulumi.set(__self__, "percentage", percentage)

    @property
    @pulumi.getter(name="httpStatus")
    def http_status(self) -> Optional[pulumi.Input[int]]:
        """
        The HTTP status code used to abort the request. The value must be from 200 to 599 inclusive. For gRPC protocol, the gRPC status code is mapped to HTTP status code according to this mapping table. HTTP status 200 is mapped to gRPC status UNKNOWN. Injecting an OK status is currently not supported by Traffic Director.
        """
        return pulumi.get(self, "http_status")

    @http_status.setter
    def http_status(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "http_status", value)

    @property
    @pulumi.getter
    def percentage(self) -> Optional[pulumi.Input[float]]:
        """
        The percentage of traffic for connections, operations, or requests that is aborted as part of fault injection. The value must be from 0.0 to 100.0 inclusive.
        """
        return pulumi.get(self, "percentage")

    @percentage.setter
    def percentage(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "percentage", value)


@pulumi.input_type
class HttpFaultDelayArgs:
    def __init__(__self__, *,
                 fixed_delay: Optional[pulumi.Input['DurationArgs']] = None,
                 percentage: Optional[pulumi.Input[float]] = None):
        """
        Specifies the delay introduced by the load balancer before forwarding the request to the backend service as part of fault injection.
        :param pulumi.Input['DurationArgs'] fixed_delay: Specifies the value of the fixed delay interval.
        :param pulumi.Input[float] percentage: The percentage of traffic for connections, operations, or requests for which a delay is introduced as part of fault injection. The value must be from 0.0 to 100.0 inclusive.
        """
        if fixed_delay is not None:
            pulumi.set(__self__, "fixed_delay", fixed_delay)
        if percentage is not None:
            pulumi.set(__self__, "percentage", percentage)

    @property
    @pulumi.getter(name="fixedDelay")
    def fixed_delay(self) -> Optional[pulumi.Input['DurationArgs']]:
        """
        Specifies the value of the fixed delay interval.
        """
        return pulumi.get(self, "fixed_delay")

    @fixed_delay.setter
    def fixed_delay(self, value: Optional[pulumi.Input['DurationArgs']]):
        pulumi.set(self, "fixed_delay", value)

    @property
    @pulumi.getter
    def percentage(self) -> Optional[pulumi.Input[float]]:
        """
        The percentage of traffic for connections, operations, or requests for which a delay is introduced as part of fault injection. The value must be from 0.0 to 100.0 inclusive.
        """
        return pulumi.get(self, "percentage")

    @percentage.setter
    def percentage(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "percentage", value)


@pulumi.input_type
class HttpFaultInjectionArgs:
    def __init__(__self__, *,
                 abort: Optional[pulumi.Input['HttpFaultAbortArgs']] = None,
                 delay: Optional[pulumi.Input['HttpFaultDelayArgs']] = None):
        """
        The specification for fault injection introduced into traffic to test the resiliency of clients to backend service failure. As part of fault injection, when clients send requests to a backend service, delays can be introduced by the load balancer on a percentage of requests before sending those request to the backend service. Similarly requests from clients can be aborted by the load balancer for a percentage of requests.
        :param pulumi.Input['HttpFaultAbortArgs'] abort: The specification for how client requests are aborted as part of fault injection.
        :param pulumi.Input['HttpFaultDelayArgs'] delay: The specification for how client requests are delayed as part of fault injection, before being sent to a backend service.
        """
        if abort is not None:
            pulumi.set(__self__, "abort", abort)
        if delay is not None:
            pulumi.set(__self__, "delay", delay)

    @property
    @pulumi.getter
    def abort(self) -> Optional[pulumi.Input['HttpFaultAbortArgs']]:
        """
        The specification for how client requests are aborted as part of fault injection.
        """
        return pulumi.get(self, "abort")

    @abort.setter
    def abort(self, value: Optional[pulumi.Input['HttpFaultAbortArgs']]):
        pulumi.set(self, "abort", value)

    @property
    @pulumi.getter
    def delay(self) -> Optional[pulumi.Input['HttpFaultDelayArgs']]:
        """
        The specification for how client requests are delayed as part of fault injection, before being sent to a backend service.
        """
        return pulumi.get(self, "delay")

    @delay.setter
    def delay(self, value: Optional[pulumi.Input['HttpFaultDelayArgs']]):
        pulumi.set(self, "delay", value)


@pulumi.input_type
class HttpFilterConfigArgs:
    def __init__(__self__, *,
                 config: Optional[pulumi.Input[str]] = None,
                 config_type_url: Optional[pulumi.Input[str]] = None,
                 filter_name: Optional[pulumi.Input[str]] = None):
        """
        HttpFilterConfiguration supplies additional contextual settings for networkservices.HttpFilter resources enabled by Traffic Director.
        :param pulumi.Input[str] config: The configuration needed to enable the networkservices.HttpFilter resource. The configuration must be YAML formatted and only contain fields defined in the protobuf identified in configTypeUrl
        :param pulumi.Input[str] config_type_url: The fully qualified versioned proto3 type url of the protobuf that the filter expects for its contextual settings, for example: type.googleapis.com/google.protobuf.Struct
        :param pulumi.Input[str] filter_name: Name of the networkservices.HttpFilter resource this configuration belongs to. This name must be known to the xDS client. Example: envoy.wasm
        """
        if config is not None:
            pulumi.set(__self__, "config", config)
        if config_type_url is not None:
            pulumi.set(__self__, "config_type_url", config_type_url)
        if filter_name is not None:
            pulumi.set(__self__, "filter_name", filter_name)

    @property
    @pulumi.getter
    def config(self) -> Optional[pulumi.Input[str]]:
        """
        The configuration needed to enable the networkservices.HttpFilter resource. The configuration must be YAML formatted and only contain fields defined in the protobuf identified in configTypeUrl
        """
        return pulumi.get(self, "config")

    @config.setter
    def config(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "config", value)

    @property
    @pulumi.getter(name="configTypeUrl")
    def config_type_url(self) -> Optional[pulumi.Input[str]]:
        """
        The fully qualified versioned proto3 type url of the protobuf that the filter expects for its contextual settings, for example: type.googleapis.com/google.protobuf.Struct
        """
        return pulumi.get(self, "config_type_url")

    @config_type_url.setter
    def config_type_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "config_type_url", value)

    @property
    @pulumi.getter(name="filterName")
    def filter_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the networkservices.HttpFilter resource this configuration belongs to. This name must be known to the xDS client. Example: envoy.wasm
        """
        return pulumi.get(self, "filter_name")

    @filter_name.setter
    def filter_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "filter_name", value)


@pulumi.input_type
class HttpHeaderActionArgs:
    def __init__(__self__, *,
                 request_headers_to_add: Optional[pulumi.Input[Sequence[pulumi.Input['HttpHeaderOptionArgs']]]] = None,
                 request_headers_to_remove: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 response_headers_to_add: Optional[pulumi.Input[Sequence[pulumi.Input['HttpHeaderOptionArgs']]]] = None,
                 response_headers_to_remove: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The request and response header transformations that take effect before the request is passed along to the selected backendService.
        :param pulumi.Input[Sequence[pulumi.Input['HttpHeaderOptionArgs']]] request_headers_to_add: Headers to add to a matching request before forwarding the request to the backendService.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] request_headers_to_remove: A list of header names for headers that need to be removed from the request before forwarding the request to the backendService.
        :param pulumi.Input[Sequence[pulumi.Input['HttpHeaderOptionArgs']]] response_headers_to_add: Headers to add the response before sending the response back to the client.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] response_headers_to_remove: A list of header names for headers that need to be removed from the response before sending the response back to the client.
        """
        if request_headers_to_add is not None:
            pulumi.set(__self__, "request_headers_to_add", request_headers_to_add)
        if request_headers_to_remove is not None:
            pulumi.set(__self__, "request_headers_to_remove", request_headers_to_remove)
        if response_headers_to_add is not None:
            pulumi.set(__self__, "response_headers_to_add", response_headers_to_add)
        if response_headers_to_remove is not None:
            pulumi.set(__self__, "response_headers_to_remove", response_headers_to_remove)

    @property
    @pulumi.getter(name="requestHeadersToAdd")
    def request_headers_to_add(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['HttpHeaderOptionArgs']]]]:
        """
        Headers to add to a matching request before forwarding the request to the backendService.
        """
        return pulumi.get(self, "request_headers_to_add")

    @request_headers_to_add.setter
    def request_headers_to_add(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['HttpHeaderOptionArgs']]]]):
        pulumi.set(self, "request_headers_to_add", value)

    @property
    @pulumi.getter(name="requestHeadersToRemove")
    def request_headers_to_remove(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of header names for headers that need to be removed from the request before forwarding the request to the backendService.
        """
        return pulumi.get(self, "request_headers_to_remove")

    @request_headers_to_remove.setter
    def request_headers_to_remove(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "request_headers_to_remove", value)

    @property
    @pulumi.getter(name="responseHeadersToAdd")
    def response_headers_to_add(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['HttpHeaderOptionArgs']]]]:
        """
        Headers to add the response before sending the response back to the client.
        """
        return pulumi.get(self, "response_headers_to_add")

    @response_headers_to_add.setter
    def response_headers_to_add(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['HttpHeaderOptionArgs']]]]):
        pulumi.set(self, "response_headers_to_add", value)

    @property
    @pulumi.getter(name="responseHeadersToRemove")
    def response_headers_to_remove(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of header names for headers that need to be removed from the response before sending the response back to the client.
        """
        return pulumi.get(self, "response_headers_to_remove")

    @response_headers_to_remove.setter
    def response_headers_to_remove(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "response_headers_to_remove", value)


@pulumi.input_type
class HttpHeaderMatchArgs:
    def __init__(__self__, *,
                 exact_match: Optional[pulumi.Input[str]] = None,
                 header_name: Optional[pulumi.Input[str]] = None,
                 invert_match: Optional[pulumi.Input[bool]] = None,
                 prefix_match: Optional[pulumi.Input[str]] = None,
                 present_match: Optional[pulumi.Input[bool]] = None,
                 range_match: Optional[pulumi.Input['Int64RangeMatchArgs']] = None,
                 regex_match: Optional[pulumi.Input[str]] = None,
                 suffix_match: Optional[pulumi.Input[str]] = None):
        """
        matchRule criteria for request header matches.
        :param pulumi.Input[str] exact_match: The value should exactly match contents of exactMatch. Only one of exactMatch, prefixMatch, suffixMatch, regexMatch, presentMatch or rangeMatch must be set.
        :param pulumi.Input[str] header_name: The name of the HTTP header to match. For matching against the HTTP request's authority, use a headerMatch with the header name ":authority". For matching a request's method, use the headerName ":method". When the URL map is bound to a target gRPC proxy that has the validateForProxyless field set to true, only non-binary user-specified custom metadata and the `content-type` header are supported. The following transport-level headers cannot be used in header matching rules: `:authority`, `:method`, `:path`, `:scheme`, `user-agent`, `accept-encoding`, `content-encoding`, `grpc-accept-encoding`, `grpc-encoding`, `grpc-previous-rpc-attempts`, `grpc-tags-bin`, `grpc-timeout` and `grpc-trace-bin`.
        :param pulumi.Input[bool] invert_match: If set to false, the headerMatch is considered a match if the preceding match criteria are met. If set to true, the headerMatch is considered a match if the preceding match criteria are NOT met. The default setting is false. 
        :param pulumi.Input[str] prefix_match: The value of the header must start with the contents of prefixMatch. Only one of exactMatch, prefixMatch, suffixMatch, regexMatch, presentMatch or rangeMatch must be set.
        :param pulumi.Input[bool] present_match: A header with the contents of headerName must exist. The match takes place whether or not the request's header has a value. Only one of exactMatch, prefixMatch, suffixMatch, regexMatch, presentMatch or rangeMatch must be set.
        :param pulumi.Input['Int64RangeMatchArgs'] range_match: The header value must be an integer and its value must be in the range specified in rangeMatch. If the header does not contain an integer, number or is empty, the match fails. For example for a range [-5, 0] - -3 will match. - 0 will not match. - 0.25 will not match. - -3someString will not match. Only one of exactMatch, prefixMatch, suffixMatch, regexMatch, presentMatch or rangeMatch must be set. rangeMatch is not supported for load balancers that have loadBalancingScheme set to EXTERNAL.
        :param pulumi.Input[str] regex_match: The value of the header must match the regular expression specified in regexMatch. For more information about regular expression syntax, see Syntax. For matching against a port specified in the HTTP request, use a headerMatch with headerName set to PORT and a regular expression that satisfies the RFC2616 Host header's port specifier. Only one of exactMatch, prefixMatch, suffixMatch, regexMatch, presentMatch or rangeMatch must be set. regexMatch only applies to load balancers that have loadBalancingScheme set to INTERNAL_SELF_MANAGED.
        :param pulumi.Input[str] suffix_match: The value of the header must end with the contents of suffixMatch. Only one of exactMatch, prefixMatch, suffixMatch, regexMatch, presentMatch or rangeMatch must be set.
        """
        if exact_match is not None:
            pulumi.set(__self__, "exact_match", exact_match)
        if header_name is not None:
            pulumi.set(__self__, "header_name", header_name)
        if invert_match is not None:
            pulumi.set(__self__, "invert_match", invert_match)
        if prefix_match is not None:
            pulumi.set(__self__, "prefix_match", prefix_match)
        if present_match is not None:
            pulumi.set(__self__, "present_match", present_match)
        if range_match is not None:
            pulumi.set(__self__, "range_match", range_match)
        if regex_match is not None:
            pulumi.set(__self__, "regex_match", regex_match)
        if suffix_match is not None:
            pulumi.set(__self__, "suffix_match", suffix_match)

    @property
    @pulumi.getter(name="exactMatch")
    def exact_match(self) -> Optional[pulumi.Input[str]]:
        """
        The value should exactly match contents of exactMatch. Only one of exactMatch, prefixMatch, suffixMatch, regexMatch, presentMatch or rangeMatch must be set.
        """
        return pulumi.get(self, "exact_match")

    @exact_match.setter
    def exact_match(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "exact_match", value)

    @property
    @pulumi.getter(name="headerName")
    def header_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the HTTP header to match. For matching against the HTTP request's authority, use a headerMatch with the header name ":authority". For matching a request's method, use the headerName ":method". When the URL map is bound to a target gRPC proxy that has the validateForProxyless field set to true, only non-binary user-specified custom metadata and the `content-type` header are supported. The following transport-level headers cannot be used in header matching rules: `:authority`, `:method`, `:path`, `:scheme`, `user-agent`, `accept-encoding`, `content-encoding`, `grpc-accept-encoding`, `grpc-encoding`, `grpc-previous-rpc-attempts`, `grpc-tags-bin`, `grpc-timeout` and `grpc-trace-bin`.
        """
        return pulumi.get(self, "header_name")

    @header_name.setter
    def header_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "header_name", value)

    @property
    @pulumi.getter(name="invertMatch")
    def invert_match(self) -> Optional[pulumi.Input[bool]]:
        """
        If set to false, the headerMatch is considered a match if the preceding match criteria are met. If set to true, the headerMatch is considered a match if the preceding match criteria are NOT met. The default setting is false. 
        """
        return pulumi.get(self, "invert_match")

    @invert_match.setter
    def invert_match(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "invert_match", value)

    @property
    @pulumi.getter(name="prefixMatch")
    def prefix_match(self) -> Optional[pulumi.Input[str]]:
        """
        The value of the header must start with the contents of prefixMatch. Only one of exactMatch, prefixMatch, suffixMatch, regexMatch, presentMatch or rangeMatch must be set.
        """
        return pulumi.get(self, "prefix_match")

    @prefix_match.setter
    def prefix_match(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "prefix_match", value)

    @property
    @pulumi.getter(name="presentMatch")
    def present_match(self) -> Optional[pulumi.Input[bool]]:
        """
        A header with the contents of headerName must exist. The match takes place whether or not the request's header has a value. Only one of exactMatch, prefixMatch, suffixMatch, regexMatch, presentMatch or rangeMatch must be set.
        """
        return pulumi.get(self, "present_match")

    @present_match.setter
    def present_match(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "present_match", value)

    @property
    @pulumi.getter(name="rangeMatch")
    def range_match(self) -> Optional[pulumi.Input['Int64RangeMatchArgs']]:
        """
        The header value must be an integer and its value must be in the range specified in rangeMatch. If the header does not contain an integer, number or is empty, the match fails. For example for a range [-5, 0] - -3 will match. - 0 will not match. - 0.25 will not match. - -3someString will not match. Only one of exactMatch, prefixMatch, suffixMatch, regexMatch, presentMatch or rangeMatch must be set. rangeMatch is not supported for load balancers that have loadBalancingScheme set to EXTERNAL.
        """
        return pulumi.get(self, "range_match")

    @range_match.setter
    def range_match(self, value: Optional[pulumi.Input['Int64RangeMatchArgs']]):
        pulumi.set(self, "range_match", value)

    @property
    @pulumi.getter(name="regexMatch")
    def regex_match(self) -> Optional[pulumi.Input[str]]:
        """
        The value of the header must match the regular expression specified in regexMatch. For more information about regular expression syntax, see Syntax. For matching against a port specified in the HTTP request, use a headerMatch with headerName set to PORT and a regular expression that satisfies the RFC2616 Host header's port specifier. Only one of exactMatch, prefixMatch, suffixMatch, regexMatch, presentMatch or rangeMatch must be set. regexMatch only applies to load balancers that have loadBalancingScheme set to INTERNAL_SELF_MANAGED.
        """
        return pulumi.get(self, "regex_match")

    @regex_match.setter
    def regex_match(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "regex_match", value)

    @property
    @pulumi.getter(name="suffixMatch")
    def suffix_match(self) -> Optional[pulumi.Input[str]]:
        """
        The value of the header must end with the contents of suffixMatch. Only one of exactMatch, prefixMatch, suffixMatch, regexMatch, presentMatch or rangeMatch must be set.
        """
        return pulumi.get(self, "suffix_match")

    @suffix_match.setter
    def suffix_match(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "suffix_match", value)


@pulumi.input_type
class HttpHeaderOptionArgs:
    def __init__(__self__, *,
                 header_name: Optional[pulumi.Input[str]] = None,
                 header_value: Optional[pulumi.Input[str]] = None,
                 replace: Optional[pulumi.Input[bool]] = None):
        """
        Specification determining how headers are added to requests or responses.
        :param pulumi.Input[str] header_name: The name of the header.
        :param pulumi.Input[str] header_value: The value of the header to add.
        :param pulumi.Input[bool] replace: If false, headerValue is appended to any values that already exist for the header. If true, headerValue is set for the header, discarding any values that were set for that header. The default value is false. 
        """
        if header_name is not None:
            pulumi.set(__self__, "header_name", header_name)
        if header_value is not None:
            pulumi.set(__self__, "header_value", header_value)
        if replace is not None:
            pulumi.set(__self__, "replace", replace)

    @property
    @pulumi.getter(name="headerName")
    def header_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the header.
        """
        return pulumi.get(self, "header_name")

    @header_name.setter
    def header_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "header_name", value)

    @property
    @pulumi.getter(name="headerValue")
    def header_value(self) -> Optional[pulumi.Input[str]]:
        """
        The value of the header to add.
        """
        return pulumi.get(self, "header_value")

    @header_value.setter
    def header_value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "header_value", value)

    @property
    @pulumi.getter
    def replace(self) -> Optional[pulumi.Input[bool]]:
        """
        If false, headerValue is appended to any values that already exist for the header. If true, headerValue is set for the header, discarding any values that were set for that header. The default value is false. 
        """
        return pulumi.get(self, "replace")

    @replace.setter
    def replace(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "replace", value)


@pulumi.input_type
class HttpQueryParameterMatchArgs:
    def __init__(__self__, *,
                 exact_match: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 present_match: Optional[pulumi.Input[bool]] = None,
                 regex_match: Optional[pulumi.Input[str]] = None):
        """
        HttpRouteRuleMatch criteria for a request's query parameter.
        :param pulumi.Input[str] exact_match: The queryParameterMatch matches if the value of the parameter exactly matches the contents of exactMatch. Only one of presentMatch, exactMatch, or regexMatch must be set. 
        :param pulumi.Input[str] name: The name of the query parameter to match. The query parameter must exist in the request, in the absence of which the request match fails.
        :param pulumi.Input[bool] present_match: Specifies that the queryParameterMatch matches if the request contains the query parameter, irrespective of whether the parameter has a value or not. Only one of presentMatch, exactMatch, or regexMatch must be set. 
        :param pulumi.Input[str] regex_match: The queryParameterMatch matches if the value of the parameter matches the regular expression specified by regexMatch. For more information about regular expression syntax, see Syntax. Only one of presentMatch, exactMatch, or regexMatch must be set. regexMatch only applies when the loadBalancingScheme is set to INTERNAL_SELF_MANAGED. 
        """
        if exact_match is not None:
            pulumi.set(__self__, "exact_match", exact_match)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if present_match is not None:
            pulumi.set(__self__, "present_match", present_match)
        if regex_match is not None:
            pulumi.set(__self__, "regex_match", regex_match)

    @property
    @pulumi.getter(name="exactMatch")
    def exact_match(self) -> Optional[pulumi.Input[str]]:
        """
        The queryParameterMatch matches if the value of the parameter exactly matches the contents of exactMatch. Only one of presentMatch, exactMatch, or regexMatch must be set. 
        """
        return pulumi.get(self, "exact_match")

    @exact_match.setter
    def exact_match(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "exact_match", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the query parameter to match. The query parameter must exist in the request, in the absence of which the request match fails.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="presentMatch")
    def present_match(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies that the queryParameterMatch matches if the request contains the query parameter, irrespective of whether the parameter has a value or not. Only one of presentMatch, exactMatch, or regexMatch must be set. 
        """
        return pulumi.get(self, "present_match")

    @present_match.setter
    def present_match(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "present_match", value)

    @property
    @pulumi.getter(name="regexMatch")
    def regex_match(self) -> Optional[pulumi.Input[str]]:
        """
        The queryParameterMatch matches if the value of the parameter matches the regular expression specified by regexMatch. For more information about regular expression syntax, see Syntax. Only one of presentMatch, exactMatch, or regexMatch must be set. regexMatch only applies when the loadBalancingScheme is set to INTERNAL_SELF_MANAGED. 
        """
        return pulumi.get(self, "regex_match")

    @regex_match.setter
    def regex_match(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "regex_match", value)


@pulumi.input_type
class HttpRedirectActionArgs:
    def __init__(__self__, *,
                 host_redirect: Optional[pulumi.Input[str]] = None,
                 https_redirect: Optional[pulumi.Input[bool]] = None,
                 path_redirect: Optional[pulumi.Input[str]] = None,
                 prefix_redirect: Optional[pulumi.Input[str]] = None,
                 redirect_response_code: Optional[pulumi.Input['HttpRedirectActionRedirectResponseCode']] = None,
                 strip_query: Optional[pulumi.Input[bool]] = None):
        """
        Specifies settings for an HTTP redirect.
        :param pulumi.Input[str] host_redirect: The host that is used in the redirect response instead of the one that was supplied in the request. The value must be from 1 to 255 characters.
        :param pulumi.Input[bool] https_redirect: If set to true, the URL scheme in the redirected request is set to HTTPS. If set to false, the URL scheme of the redirected request remains the same as that of the request. This must only be set for URL maps used in TargetHttpProxys. Setting this true for TargetHttpsProxy is not permitted. The default is set to false.
        :param pulumi.Input[str] path_redirect: The path that is used in the redirect response instead of the one that was supplied in the request. pathRedirect cannot be supplied together with prefixRedirect. Supply one alone or neither. If neither is supplied, the path of the original request is used for the redirect. The value must be from 1 to 1024 characters.
        :param pulumi.Input[str] prefix_redirect: The prefix that replaces the prefixMatch specified in the HttpRouteRuleMatch, retaining the remaining portion of the URL before redirecting the request. prefixRedirect cannot be supplied together with pathRedirect. Supply one alone or neither. If neither is supplied, the path of the original request is used for the redirect. The value must be from 1 to 1024 characters.
        :param pulumi.Input['HttpRedirectActionRedirectResponseCode'] redirect_response_code: The HTTP Status code to use for this RedirectAction. Supported values are: - MOVED_PERMANENTLY_DEFAULT, which is the default value and corresponds to 301. - FOUND, which corresponds to 302. - SEE_OTHER which corresponds to 303. - TEMPORARY_REDIRECT, which corresponds to 307. In this case, the request method is retained. - PERMANENT_REDIRECT, which corresponds to 308. In this case, the request method is retained. 
        :param pulumi.Input[bool] strip_query: If set to true, any accompanying query portion of the original URL is removed before redirecting the request. If set to false, the query portion of the original URL is retained. The default is set to false. 
        """
        if host_redirect is not None:
            pulumi.set(__self__, "host_redirect", host_redirect)
        if https_redirect is not None:
            pulumi.set(__self__, "https_redirect", https_redirect)
        if path_redirect is not None:
            pulumi.set(__self__, "path_redirect", path_redirect)
        if prefix_redirect is not None:
            pulumi.set(__self__, "prefix_redirect", prefix_redirect)
        if redirect_response_code is not None:
            pulumi.set(__self__, "redirect_response_code", redirect_response_code)
        if strip_query is not None:
            pulumi.set(__self__, "strip_query", strip_query)

    @property
    @pulumi.getter(name="hostRedirect")
    def host_redirect(self) -> Optional[pulumi.Input[str]]:
        """
        The host that is used in the redirect response instead of the one that was supplied in the request. The value must be from 1 to 255 characters.
        """
        return pulumi.get(self, "host_redirect")

    @host_redirect.setter
    def host_redirect(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "host_redirect", value)

    @property
    @pulumi.getter(name="httpsRedirect")
    def https_redirect(self) -> Optional[pulumi.Input[bool]]:
        """
        If set to true, the URL scheme in the redirected request is set to HTTPS. If set to false, the URL scheme of the redirected request remains the same as that of the request. This must only be set for URL maps used in TargetHttpProxys. Setting this true for TargetHttpsProxy is not permitted. The default is set to false.
        """
        return pulumi.get(self, "https_redirect")

    @https_redirect.setter
    def https_redirect(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "https_redirect", value)

    @property
    @pulumi.getter(name="pathRedirect")
    def path_redirect(self) -> Optional[pulumi.Input[str]]:
        """
        The path that is used in the redirect response instead of the one that was supplied in the request. pathRedirect cannot be supplied together with prefixRedirect. Supply one alone or neither. If neither is supplied, the path of the original request is used for the redirect. The value must be from 1 to 1024 characters.
        """
        return pulumi.get(self, "path_redirect")

    @path_redirect.setter
    def path_redirect(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path_redirect", value)

    @property
    @pulumi.getter(name="prefixRedirect")
    def prefix_redirect(self) -> Optional[pulumi.Input[str]]:
        """
        The prefix that replaces the prefixMatch specified in the HttpRouteRuleMatch, retaining the remaining portion of the URL before redirecting the request. prefixRedirect cannot be supplied together with pathRedirect. Supply one alone or neither. If neither is supplied, the path of the original request is used for the redirect. The value must be from 1 to 1024 characters.
        """
        return pulumi.get(self, "prefix_redirect")

    @prefix_redirect.setter
    def prefix_redirect(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "prefix_redirect", value)

    @property
    @pulumi.getter(name="redirectResponseCode")
    def redirect_response_code(self) -> Optional[pulumi.Input['HttpRedirectActionRedirectResponseCode']]:
        """
        The HTTP Status code to use for this RedirectAction. Supported values are: - MOVED_PERMANENTLY_DEFAULT, which is the default value and corresponds to 301. - FOUND, which corresponds to 302. - SEE_OTHER which corresponds to 303. - TEMPORARY_REDIRECT, which corresponds to 307. In this case, the request method is retained. - PERMANENT_REDIRECT, which corresponds to 308. In this case, the request method is retained. 
        """
        return pulumi.get(self, "redirect_response_code")

    @redirect_response_code.setter
    def redirect_response_code(self, value: Optional[pulumi.Input['HttpRedirectActionRedirectResponseCode']]):
        pulumi.set(self, "redirect_response_code", value)

    @property
    @pulumi.getter(name="stripQuery")
    def strip_query(self) -> Optional[pulumi.Input[bool]]:
        """
        If set to true, any accompanying query portion of the original URL is removed before redirecting the request. If set to false, the query portion of the original URL is retained. The default is set to false. 
        """
        return pulumi.get(self, "strip_query")

    @strip_query.setter
    def strip_query(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "strip_query", value)


@pulumi.input_type
class HttpRetryPolicyArgs:
    def __init__(__self__, *,
                 num_retries: Optional[pulumi.Input[int]] = None,
                 per_try_timeout: Optional[pulumi.Input['DurationArgs']] = None,
                 retry_conditions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The retry policy associates with HttpRouteRule
        :param pulumi.Input[int] num_retries: Specifies the allowed number retries. This number must be > 0. If not specified, defaults to 1.
        :param pulumi.Input['DurationArgs'] per_try_timeout: Specifies a non-zero timeout per retry attempt. If not specified, will use the timeout set in the HttpRouteAction field. If timeout in the HttpRouteAction field is not set, this field uses the largest timeout among all backend services associated with the route. Not supported when the URL map is bound to a target gRPC proxy that has the validateForProxyless field set to true.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] retry_conditions: Specifies one or more conditions when this retry policy applies. Valid values are: - 5xx: retry is attempted if the instance or endpoint responds with any 5xx response code, or if the instance or endpoint does not respond at all. For example, disconnects, reset, read timeout, connection failure, and refused streams. - gateway-error: Similar to 5xx, but only applies to response codes 502, 503 or 504. - connect-failure: a retry is attempted on failures connecting to the instance or endpoint. For example, connection timeouts. - retriable-4xx: a retry is attempted if the instance or endpoint responds with a 4xx response code. The only error that you can retry is error code 409. - refused-stream: a retry is attempted if the instance or endpoint resets the stream with a REFUSED_STREAM error code. This reset type indicates that it is safe to retry. - cancelled: a retry is attempted if the gRPC status code in the response header is set to cancelled. - deadline-exceeded: a retry is attempted if the gRPC status code in the response header is set to deadline-exceeded. - internal: a retry is attempted if the gRPC status code in the response header is set to internal. - resource-exhausted: a retry is attempted if the gRPC status code in the response header is set to resource-exhausted. - unavailable: a retry is attempted if the gRPC status code in the response header is set to unavailable. Only the following codes are supported when the URL map is bound to target gRPC proxy that has validateForProxyless field set to true. - cancelled - deadline-exceeded - internal - resource-exhausted - unavailable 
        """
        if num_retries is not None:
            pulumi.set(__self__, "num_retries", num_retries)
        if per_try_timeout is not None:
            pulumi.set(__self__, "per_try_timeout", per_try_timeout)
        if retry_conditions is not None:
            pulumi.set(__self__, "retry_conditions", retry_conditions)

    @property
    @pulumi.getter(name="numRetries")
    def num_retries(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the allowed number retries. This number must be > 0. If not specified, defaults to 1.
        """
        return pulumi.get(self, "num_retries")

    @num_retries.setter
    def num_retries(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "num_retries", value)

    @property
    @pulumi.getter(name="perTryTimeout")
    def per_try_timeout(self) -> Optional[pulumi.Input['DurationArgs']]:
        """
        Specifies a non-zero timeout per retry attempt. If not specified, will use the timeout set in the HttpRouteAction field. If timeout in the HttpRouteAction field is not set, this field uses the largest timeout among all backend services associated with the route. Not supported when the URL map is bound to a target gRPC proxy that has the validateForProxyless field set to true.
        """
        return pulumi.get(self, "per_try_timeout")

    @per_try_timeout.setter
    def per_try_timeout(self, value: Optional[pulumi.Input['DurationArgs']]):
        pulumi.set(self, "per_try_timeout", value)

    @property
    @pulumi.getter(name="retryConditions")
    def retry_conditions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies one or more conditions when this retry policy applies. Valid values are: - 5xx: retry is attempted if the instance or endpoint responds with any 5xx response code, or if the instance or endpoint does not respond at all. For example, disconnects, reset, read timeout, connection failure, and refused streams. - gateway-error: Similar to 5xx, but only applies to response codes 502, 503 or 504. - connect-failure: a retry is attempted on failures connecting to the instance or endpoint. For example, connection timeouts. - retriable-4xx: a retry is attempted if the instance or endpoint responds with a 4xx response code. The only error that you can retry is error code 409. - refused-stream: a retry is attempted if the instance or endpoint resets the stream with a REFUSED_STREAM error code. This reset type indicates that it is safe to retry. - cancelled: a retry is attempted if the gRPC status code in the response header is set to cancelled. - deadline-exceeded: a retry is attempted if the gRPC status code in the response header is set to deadline-exceeded. - internal: a retry is attempted if the gRPC status code in the response header is set to internal. - resource-exhausted: a retry is attempted if the gRPC status code in the response header is set to resource-exhausted. - unavailable: a retry is attempted if the gRPC status code in the response header is set to unavailable. Only the following codes are supported when the URL map is bound to target gRPC proxy that has validateForProxyless field set to true. - cancelled - deadline-exceeded - internal - resource-exhausted - unavailable 
        """
        return pulumi.get(self, "retry_conditions")

    @retry_conditions.setter
    def retry_conditions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "retry_conditions", value)


@pulumi.input_type
class HttpRouteActionArgs:
    def __init__(__self__, *,
                 cors_policy: Optional[pulumi.Input['CorsPolicyArgs']] = None,
                 fault_injection_policy: Optional[pulumi.Input['HttpFaultInjectionArgs']] = None,
                 max_stream_duration: Optional[pulumi.Input['DurationArgs']] = None,
                 request_mirror_policy: Optional[pulumi.Input['RequestMirrorPolicyArgs']] = None,
                 retry_policy: Optional[pulumi.Input['HttpRetryPolicyArgs']] = None,
                 timeout: Optional[pulumi.Input['DurationArgs']] = None,
                 url_rewrite: Optional[pulumi.Input['UrlRewriteArgs']] = None,
                 weighted_backend_services: Optional[pulumi.Input[Sequence[pulumi.Input['WeightedBackendServiceArgs']]]] = None):
        """
        :param pulumi.Input['CorsPolicyArgs'] cors_policy: The specification for allowing client-side cross-origin requests. For more information about the W3C recommendation for cross-origin resource sharing (CORS), see Fetch API Living Standard. Not supported when the URL map is bound to a target gRPC proxy.
        :param pulumi.Input['HttpFaultInjectionArgs'] fault_injection_policy: The specification for fault injection introduced into traffic to test the resiliency of clients to backend service failure. As part of fault injection, when clients send requests to a backend service, delays can be introduced by a load balancer on a percentage of requests before sending those requests to the backend service. Similarly requests from clients can be aborted by the load balancer for a percentage of requests. For the requests impacted by fault injection, timeout and retry_policy is ignored by clients that are configured with a fault_injection_policy.
        :param pulumi.Input['DurationArgs'] max_stream_duration: Specifies the maximum duration (timeout) for streams on the selected route. Unlike the timeout field where the timeout duration starts from the time the request has been fully processed (known as *end-of-stream*), the duration in this field is computed from the beginning of the stream until the response has been processed, including all retries. A stream that does not complete in this duration is closed. If not specified, this field uses the maximum maxStreamDuration value among all backend services associated with the route. This field is only allowed if the Url map is used with backend services with loadBalancingScheme set to INTERNAL_SELF_MANAGED.
        :param pulumi.Input['RequestMirrorPolicyArgs'] request_mirror_policy: Specifies the policy on how requests intended for the route's backends are shadowed to a separate mirrored backend service. The load balancer does not wait for responses from the shadow service. Before sending traffic to the shadow service, the host / authority header is suffixed with -shadow. Not supported when the URL map is bound to a target gRPC proxy that has the validateForProxyless field set to true.
        :param pulumi.Input['HttpRetryPolicyArgs'] retry_policy: Specifies the retry policy associated with this route.
        :param pulumi.Input['DurationArgs'] timeout: Specifies the timeout for the selected route. Timeout is computed from the time the request has been fully processed (known as *end-of-stream*) up until the response has been processed. Timeout includes all retries. If not specified, this field uses the largest timeout among all backend services associated with the route. Not supported when the URL map is bound to a target gRPC proxy that has validateForProxyless field set to true.
        :param pulumi.Input['UrlRewriteArgs'] url_rewrite: The spec to modify the URL of the request, before forwarding the request to the matched service. urlRewrite is the only action supported in UrlMaps for external HTTP(S) load balancers. Not supported when the URL map is bound to a target gRPC proxy that has the validateForProxyless field set to true.
        :param pulumi.Input[Sequence[pulumi.Input['WeightedBackendServiceArgs']]] weighted_backend_services: A list of weighted backend services to send traffic to when a route match occurs. The weights determine the fraction of traffic that flows to their corresponding backend service. If all traffic needs to go to a single backend service, there must be one weightedBackendService with weight set to a non-zero number. After a backend service is identified and before forwarding the request to the backend service, advanced routing actions such as URL rewrites and header transformations are applied depending on additional settings specified in this HttpRouteAction.
        """
        if cors_policy is not None:
            pulumi.set(__self__, "cors_policy", cors_policy)
        if fault_injection_policy is not None:
            pulumi.set(__self__, "fault_injection_policy", fault_injection_policy)
        if max_stream_duration is not None:
            pulumi.set(__self__, "max_stream_duration", max_stream_duration)
        if request_mirror_policy is not None:
            pulumi.set(__self__, "request_mirror_policy", request_mirror_policy)
        if retry_policy is not None:
            pulumi.set(__self__, "retry_policy", retry_policy)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)
        if url_rewrite is not None:
            pulumi.set(__self__, "url_rewrite", url_rewrite)
        if weighted_backend_services is not None:
            pulumi.set(__self__, "weighted_backend_services", weighted_backend_services)

    @property
    @pulumi.getter(name="corsPolicy")
    def cors_policy(self) -> Optional[pulumi.Input['CorsPolicyArgs']]:
        """
        The specification for allowing client-side cross-origin requests. For more information about the W3C recommendation for cross-origin resource sharing (CORS), see Fetch API Living Standard. Not supported when the URL map is bound to a target gRPC proxy.
        """
        return pulumi.get(self, "cors_policy")

    @cors_policy.setter
    def cors_policy(self, value: Optional[pulumi.Input['CorsPolicyArgs']]):
        pulumi.set(self, "cors_policy", value)

    @property
    @pulumi.getter(name="faultInjectionPolicy")
    def fault_injection_policy(self) -> Optional[pulumi.Input['HttpFaultInjectionArgs']]:
        """
        The specification for fault injection introduced into traffic to test the resiliency of clients to backend service failure. As part of fault injection, when clients send requests to a backend service, delays can be introduced by a load balancer on a percentage of requests before sending those requests to the backend service. Similarly requests from clients can be aborted by the load balancer for a percentage of requests. For the requests impacted by fault injection, timeout and retry_policy is ignored by clients that are configured with a fault_injection_policy.
        """
        return pulumi.get(self, "fault_injection_policy")

    @fault_injection_policy.setter
    def fault_injection_policy(self, value: Optional[pulumi.Input['HttpFaultInjectionArgs']]):
        pulumi.set(self, "fault_injection_policy", value)

    @property
    @pulumi.getter(name="maxStreamDuration")
    def max_stream_duration(self) -> Optional[pulumi.Input['DurationArgs']]:
        """
        Specifies the maximum duration (timeout) for streams on the selected route. Unlike the timeout field where the timeout duration starts from the time the request has been fully processed (known as *end-of-stream*), the duration in this field is computed from the beginning of the stream until the response has been processed, including all retries. A stream that does not complete in this duration is closed. If not specified, this field uses the maximum maxStreamDuration value among all backend services associated with the route. This field is only allowed if the Url map is used with backend services with loadBalancingScheme set to INTERNAL_SELF_MANAGED.
        """
        return pulumi.get(self, "max_stream_duration")

    @max_stream_duration.setter
    def max_stream_duration(self, value: Optional[pulumi.Input['DurationArgs']]):
        pulumi.set(self, "max_stream_duration", value)

    @property
    @pulumi.getter(name="requestMirrorPolicy")
    def request_mirror_policy(self) -> Optional[pulumi.Input['RequestMirrorPolicyArgs']]:
        """
        Specifies the policy on how requests intended for the route's backends are shadowed to a separate mirrored backend service. The load balancer does not wait for responses from the shadow service. Before sending traffic to the shadow service, the host / authority header is suffixed with -shadow. Not supported when the URL map is bound to a target gRPC proxy that has the validateForProxyless field set to true.
        """
        return pulumi.get(self, "request_mirror_policy")

    @request_mirror_policy.setter
    def request_mirror_policy(self, value: Optional[pulumi.Input['RequestMirrorPolicyArgs']]):
        pulumi.set(self, "request_mirror_policy", value)

    @property
    @pulumi.getter(name="retryPolicy")
    def retry_policy(self) -> Optional[pulumi.Input['HttpRetryPolicyArgs']]:
        """
        Specifies the retry policy associated with this route.
        """
        return pulumi.get(self, "retry_policy")

    @retry_policy.setter
    def retry_policy(self, value: Optional[pulumi.Input['HttpRetryPolicyArgs']]):
        pulumi.set(self, "retry_policy", value)

    @property
    @pulumi.getter
    def timeout(self) -> Optional[pulumi.Input['DurationArgs']]:
        """
        Specifies the timeout for the selected route. Timeout is computed from the time the request has been fully processed (known as *end-of-stream*) up until the response has been processed. Timeout includes all retries. If not specified, this field uses the largest timeout among all backend services associated with the route. Not supported when the URL map is bound to a target gRPC proxy that has validateForProxyless field set to true.
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[pulumi.Input['DurationArgs']]):
        pulumi.set(self, "timeout", value)

    @property
    @pulumi.getter(name="urlRewrite")
    def url_rewrite(self) -> Optional[pulumi.Input['UrlRewriteArgs']]:
        """
        The spec to modify the URL of the request, before forwarding the request to the matched service. urlRewrite is the only action supported in UrlMaps for external HTTP(S) load balancers. Not supported when the URL map is bound to a target gRPC proxy that has the validateForProxyless field set to true.
        """
        return pulumi.get(self, "url_rewrite")

    @url_rewrite.setter
    def url_rewrite(self, value: Optional[pulumi.Input['UrlRewriteArgs']]):
        pulumi.set(self, "url_rewrite", value)

    @property
    @pulumi.getter(name="weightedBackendServices")
    def weighted_backend_services(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WeightedBackendServiceArgs']]]]:
        """
        A list of weighted backend services to send traffic to when a route match occurs. The weights determine the fraction of traffic that flows to their corresponding backend service. If all traffic needs to go to a single backend service, there must be one weightedBackendService with weight set to a non-zero number. After a backend service is identified and before forwarding the request to the backend service, advanced routing actions such as URL rewrites and header transformations are applied depending on additional settings specified in this HttpRouteAction.
        """
        return pulumi.get(self, "weighted_backend_services")

    @weighted_backend_services.setter
    def weighted_backend_services(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WeightedBackendServiceArgs']]]]):
        pulumi.set(self, "weighted_backend_services", value)


@pulumi.input_type
class HttpRouteRuleMatchArgs:
    def __init__(__self__, *,
                 full_path_match: Optional[pulumi.Input[str]] = None,
                 header_matches: Optional[pulumi.Input[Sequence[pulumi.Input['HttpHeaderMatchArgs']]]] = None,
                 ignore_case: Optional[pulumi.Input[bool]] = None,
                 metadata_filters: Optional[pulumi.Input[Sequence[pulumi.Input['MetadataFilterArgs']]]] = None,
                 prefix_match: Optional[pulumi.Input[str]] = None,
                 query_parameter_matches: Optional[pulumi.Input[Sequence[pulumi.Input['HttpQueryParameterMatchArgs']]]] = None,
                 regex_match: Optional[pulumi.Input[str]] = None):
        """
        HttpRouteRuleMatch specifies a set of criteria for matching requests to an HttpRouteRule. All specified criteria must be satisfied for a match to occur.
        :param pulumi.Input[str] full_path_match: For satisfying the matchRule condition, the path of the request must exactly match the value specified in fullPathMatch after removing any query parameters and anchor that may be part of the original URL. fullPathMatch must be from 1 to 1024 characters. Only one of prefixMatch, fullPathMatch or regexMatch must be specified.
        :param pulumi.Input[Sequence[pulumi.Input['HttpHeaderMatchArgs']]] header_matches: Specifies a list of header match criteria, all of which must match corresponding headers in the request.
        :param pulumi.Input[bool] ignore_case: Specifies that prefixMatch and fullPathMatch matches are case sensitive. The default value is false. ignoreCase must not be used with regexMatch. Not supported when the URL map is bound to a target gRPC proxy.
        :param pulumi.Input[Sequence[pulumi.Input['MetadataFilterArgs']]] metadata_filters: Opaque filter criteria used by the load balancer to restrict routing configuration to a limited set of xDS compliant clients. In their xDS requests to the load balancer, xDS clients present node metadata. When there is a match, the relevant routing configuration is made available to those proxies. For each metadataFilter in this list, if its filterMatchCriteria is set to MATCH_ANY, at least one of the filterLabels must match the corresponding label provided in the metadata. If its filterMatchCriteria is set to MATCH_ALL, then all of its filterLabels must match with corresponding labels provided in the metadata. If multiple metadata filters are specified, all of them need to be satisfied in order to be considered a match. metadataFilters specified here is applied after those specified in ForwardingRule that refers to the UrlMap this HttpRouteRuleMatch belongs to. metadataFilters only applies to load balancers that have loadBalancingScheme set to INTERNAL_SELF_MANAGED. Not supported when the URL map is bound to a target gRPC proxy that has validateForProxyless field set to true.
        :param pulumi.Input[str] prefix_match: For satisfying the matchRule condition, the request's path must begin with the specified prefixMatch. prefixMatch must begin with a /. The value must be from 1 to 1024 characters. Only one of prefixMatch, fullPathMatch or regexMatch must be specified.
        :param pulumi.Input[Sequence[pulumi.Input['HttpQueryParameterMatchArgs']]] query_parameter_matches: Specifies a list of query parameter match criteria, all of which must match corresponding query parameters in the request. Not supported when the URL map is bound to a target gRPC proxy.
        :param pulumi.Input[str] regex_match: For satisfying the matchRule condition, the path of the request must satisfy the regular expression specified in regexMatch after removing any query parameters and anchor supplied with the original URL. For more information about regular expression syntax, see Syntax. Only one of prefixMatch, fullPathMatch or regexMatch must be specified. regexMatch only applies to load balancers that have loadBalancingScheme set to INTERNAL_SELF_MANAGED.
        """
        if full_path_match is not None:
            pulumi.set(__self__, "full_path_match", full_path_match)
        if header_matches is not None:
            pulumi.set(__self__, "header_matches", header_matches)
        if ignore_case is not None:
            pulumi.set(__self__, "ignore_case", ignore_case)
        if metadata_filters is not None:
            pulumi.set(__self__, "metadata_filters", metadata_filters)
        if prefix_match is not None:
            pulumi.set(__self__, "prefix_match", prefix_match)
        if query_parameter_matches is not None:
            pulumi.set(__self__, "query_parameter_matches", query_parameter_matches)
        if regex_match is not None:
            pulumi.set(__self__, "regex_match", regex_match)

    @property
    @pulumi.getter(name="fullPathMatch")
    def full_path_match(self) -> Optional[pulumi.Input[str]]:
        """
        For satisfying the matchRule condition, the path of the request must exactly match the value specified in fullPathMatch after removing any query parameters and anchor that may be part of the original URL. fullPathMatch must be from 1 to 1024 characters. Only one of prefixMatch, fullPathMatch or regexMatch must be specified.
        """
        return pulumi.get(self, "full_path_match")

    @full_path_match.setter
    def full_path_match(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "full_path_match", value)

    @property
    @pulumi.getter(name="headerMatches")
    def header_matches(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['HttpHeaderMatchArgs']]]]:
        """
        Specifies a list of header match criteria, all of which must match corresponding headers in the request.
        """
        return pulumi.get(self, "header_matches")

    @header_matches.setter
    def header_matches(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['HttpHeaderMatchArgs']]]]):
        pulumi.set(self, "header_matches", value)

    @property
    @pulumi.getter(name="ignoreCase")
    def ignore_case(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies that prefixMatch and fullPathMatch matches are case sensitive. The default value is false. ignoreCase must not be used with regexMatch. Not supported when the URL map is bound to a target gRPC proxy.
        """
        return pulumi.get(self, "ignore_case")

    @ignore_case.setter
    def ignore_case(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "ignore_case", value)

    @property
    @pulumi.getter(name="metadataFilters")
    def metadata_filters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MetadataFilterArgs']]]]:
        """
        Opaque filter criteria used by the load balancer to restrict routing configuration to a limited set of xDS compliant clients. In their xDS requests to the load balancer, xDS clients present node metadata. When there is a match, the relevant routing configuration is made available to those proxies. For each metadataFilter in this list, if its filterMatchCriteria is set to MATCH_ANY, at least one of the filterLabels must match the corresponding label provided in the metadata. If its filterMatchCriteria is set to MATCH_ALL, then all of its filterLabels must match with corresponding labels provided in the metadata. If multiple metadata filters are specified, all of them need to be satisfied in order to be considered a match. metadataFilters specified here is applied after those specified in ForwardingRule that refers to the UrlMap this HttpRouteRuleMatch belongs to. metadataFilters only applies to load balancers that have loadBalancingScheme set to INTERNAL_SELF_MANAGED. Not supported when the URL map is bound to a target gRPC proxy that has validateForProxyless field set to true.
        """
        return pulumi.get(self, "metadata_filters")

    @metadata_filters.setter
    def metadata_filters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MetadataFilterArgs']]]]):
        pulumi.set(self, "metadata_filters", value)

    @property
    @pulumi.getter(name="prefixMatch")
    def prefix_match(self) -> Optional[pulumi.Input[str]]:
        """
        For satisfying the matchRule condition, the request's path must begin with the specified prefixMatch. prefixMatch must begin with a /. The value must be from 1 to 1024 characters. Only one of prefixMatch, fullPathMatch or regexMatch must be specified.
        """
        return pulumi.get(self, "prefix_match")

    @prefix_match.setter
    def prefix_match(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "prefix_match", value)

    @property
    @pulumi.getter(name="queryParameterMatches")
    def query_parameter_matches(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['HttpQueryParameterMatchArgs']]]]:
        """
        Specifies a list of query parameter match criteria, all of which must match corresponding query parameters in the request. Not supported when the URL map is bound to a target gRPC proxy.
        """
        return pulumi.get(self, "query_parameter_matches")

    @query_parameter_matches.setter
    def query_parameter_matches(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['HttpQueryParameterMatchArgs']]]]):
        pulumi.set(self, "query_parameter_matches", value)

    @property
    @pulumi.getter(name="regexMatch")
    def regex_match(self) -> Optional[pulumi.Input[str]]:
        """
        For satisfying the matchRule condition, the path of the request must satisfy the regular expression specified in regexMatch after removing any query parameters and anchor supplied with the original URL. For more information about regular expression syntax, see Syntax. Only one of prefixMatch, fullPathMatch or regexMatch must be specified. regexMatch only applies to load balancers that have loadBalancingScheme set to INTERNAL_SELF_MANAGED.
        """
        return pulumi.get(self, "regex_match")

    @regex_match.setter
    def regex_match(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "regex_match", value)


@pulumi.input_type
class HttpRouteRuleArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 header_action: Optional[pulumi.Input['HttpHeaderActionArgs']] = None,
                 http_filter_configs: Optional[pulumi.Input[Sequence[pulumi.Input['HttpFilterConfigArgs']]]] = None,
                 http_filter_metadata: Optional[pulumi.Input[Sequence[pulumi.Input['HttpFilterConfigArgs']]]] = None,
                 match_rules: Optional[pulumi.Input[Sequence[pulumi.Input['HttpRouteRuleMatchArgs']]]] = None,
                 priority: Optional[pulumi.Input[int]] = None,
                 route_action: Optional[pulumi.Input['HttpRouteActionArgs']] = None,
                 service: Optional[pulumi.Input[str]] = None,
                 url_redirect: Optional[pulumi.Input['HttpRedirectActionArgs']] = None):
        """
        The HttpRouteRule setting specifies how to match an HTTP request and the corresponding routing action that load balancing proxies perform.
        :param pulumi.Input[str] description: The short description conveying the intent of this routeRule. The description can have a maximum length of 1024 characters.
        :param pulumi.Input['HttpHeaderActionArgs'] header_action: Specifies changes to request and response headers that need to take effect for the selected backendService. The headerAction value specified here is applied before the matching pathMatchers[].headerAction and after pathMatchers[].routeRules[].routeAction.weightedBackendService.backendServiceWeightAction[].headerAction HeaderAction is not supported for load balancers that have their loadBalancingScheme set to EXTERNAL. Not supported when the URL map is bound to a target gRPC proxy that has validateForProxyless field set to true.
        :param pulumi.Input[Sequence[pulumi.Input['HttpFilterConfigArgs']]] http_filter_configs: Outbound route specific configuration for networkservices.HttpFilter resources enabled by Traffic Director. httpFilterConfigs only applies for load balancers with loadBalancingScheme set to INTERNAL_SELF_MANAGED. See ForwardingRule for more details. Not supported when the URL map is bound to a target gRPC proxy that has validateForProxyless field set to true.
        :param pulumi.Input[Sequence[pulumi.Input['HttpFilterConfigArgs']]] http_filter_metadata: Outbound route specific metadata supplied to networkservices.HttpFilter resources enabled by Traffic Director. httpFilterMetadata only applies for load balancers with loadBalancingScheme set to INTERNAL_SELF_MANAGED. See ForwardingRule for more details. The only configTypeUrl supported is type.googleapis.com/google.protobuf.Struct Not supported when the URL map is bound to a target gRPC proxy that has validateForProxyless field set to true.
        :param pulumi.Input[Sequence[pulumi.Input['HttpRouteRuleMatchArgs']]] match_rules: The list of criteria for matching attributes of a request to this routeRule. This list has OR semantics: the request matches this routeRule when any of the matchRules are satisfied. However predicates within a given matchRule have AND semantics. All predicates within a matchRule must match for the request to match the rule.
        :param pulumi.Input[int] priority: For routeRules within a given pathMatcher, priority determines the order in which a load balancer interprets routeRules. RouteRules are evaluated in order of priority, from the lowest to highest number. The priority of a rule decreases as its number increases (1, 2, 3, N+1). The first rule that matches the request is applied. You cannot configure two or more routeRules with the same priority. Priority for each rule must be set to a number from 0 to 2147483647 inclusive. Priority numbers can have gaps, which enable you to add or remove rules in the future without affecting the rest of the rules. For example, 1, 2, 3, 4, 5, 9, 12, 16 is a valid series of priority numbers to which you could add rules numbered from 6 to 8, 10 to 11, and 13 to 15 in the future without any impact on existing rules.
        :param pulumi.Input['HttpRouteActionArgs'] route_action: In response to a matching matchRule, the load balancer performs advanced routing actions, such as URL rewrites and header transformations, before forwarding the request to the selected backend. If routeAction specifies any weightedBackendServices, service must not be set. Conversely if service is set, routeAction cannot contain any weightedBackendServices. Only one of urlRedirect, service or routeAction.weightedBackendService must be set. UrlMaps for external HTTP(S) load balancers support only the urlRewrite action within a route rule's routeAction.
        :param pulumi.Input[str] service: The full or partial URL of the backend service resource to which traffic is directed if this rule is matched. If routeAction is also specified, advanced routing actions, such as URL rewrites, take effect before sending the request to the backend. However, if service is specified, routeAction cannot contain any weightedBackendServices. Conversely, if routeAction specifies any weightedBackendServices, service must not be specified. Only one of urlRedirect, service or routeAction.weightedBackendService must be set.
        :param pulumi.Input['HttpRedirectActionArgs'] url_redirect: When this rule is matched, the request is redirected to a URL specified by urlRedirect. If urlRedirect is specified, service or routeAction must not be set. Not supported when the URL map is bound to a target gRPC proxy.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if header_action is not None:
            pulumi.set(__self__, "header_action", header_action)
        if http_filter_configs is not None:
            pulumi.set(__self__, "http_filter_configs", http_filter_configs)
        if http_filter_metadata is not None:
            pulumi.set(__self__, "http_filter_metadata", http_filter_metadata)
        if match_rules is not None:
            pulumi.set(__self__, "match_rules", match_rules)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if route_action is not None:
            pulumi.set(__self__, "route_action", route_action)
        if service is not None:
            pulumi.set(__self__, "service", service)
        if url_redirect is not None:
            pulumi.set(__self__, "url_redirect", url_redirect)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The short description conveying the intent of this routeRule. The description can have a maximum length of 1024 characters.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="headerAction")
    def header_action(self) -> Optional[pulumi.Input['HttpHeaderActionArgs']]:
        """
        Specifies changes to request and response headers that need to take effect for the selected backendService. The headerAction value specified here is applied before the matching pathMatchers[].headerAction and after pathMatchers[].routeRules[].routeAction.weightedBackendService.backendServiceWeightAction[].headerAction HeaderAction is not supported for load balancers that have their loadBalancingScheme set to EXTERNAL. Not supported when the URL map is bound to a target gRPC proxy that has validateForProxyless field set to true.
        """
        return pulumi.get(self, "header_action")

    @header_action.setter
    def header_action(self, value: Optional[pulumi.Input['HttpHeaderActionArgs']]):
        pulumi.set(self, "header_action", value)

    @property
    @pulumi.getter(name="httpFilterConfigs")
    def http_filter_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['HttpFilterConfigArgs']]]]:
        """
        Outbound route specific configuration for networkservices.HttpFilter resources enabled by Traffic Director. httpFilterConfigs only applies for load balancers with loadBalancingScheme set to INTERNAL_SELF_MANAGED. See ForwardingRule for more details. Not supported when the URL map is bound to a target gRPC proxy that has validateForProxyless field set to true.
        """
        return pulumi.get(self, "http_filter_configs")

    @http_filter_configs.setter
    def http_filter_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['HttpFilterConfigArgs']]]]):
        pulumi.set(self, "http_filter_configs", value)

    @property
    @pulumi.getter(name="httpFilterMetadata")
    def http_filter_metadata(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['HttpFilterConfigArgs']]]]:
        """
        Outbound route specific metadata supplied to networkservices.HttpFilter resources enabled by Traffic Director. httpFilterMetadata only applies for load balancers with loadBalancingScheme set to INTERNAL_SELF_MANAGED. See ForwardingRule for more details. The only configTypeUrl supported is type.googleapis.com/google.protobuf.Struct Not supported when the URL map is bound to a target gRPC proxy that has validateForProxyless field set to true.
        """
        return pulumi.get(self, "http_filter_metadata")

    @http_filter_metadata.setter
    def http_filter_metadata(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['HttpFilterConfigArgs']]]]):
        pulumi.set(self, "http_filter_metadata", value)

    @property
    @pulumi.getter(name="matchRules")
    def match_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['HttpRouteRuleMatchArgs']]]]:
        """
        The list of criteria for matching attributes of a request to this routeRule. This list has OR semantics: the request matches this routeRule when any of the matchRules are satisfied. However predicates within a given matchRule have AND semantics. All predicates within a matchRule must match for the request to match the rule.
        """
        return pulumi.get(self, "match_rules")

    @match_rules.setter
    def match_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['HttpRouteRuleMatchArgs']]]]):
        pulumi.set(self, "match_rules", value)

    @property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[int]]:
        """
        For routeRules within a given pathMatcher, priority determines the order in which a load balancer interprets routeRules. RouteRules are evaluated in order of priority, from the lowest to highest number. The priority of a rule decreases as its number increases (1, 2, 3, N+1). The first rule that matches the request is applied. You cannot configure two or more routeRules with the same priority. Priority for each rule must be set to a number from 0 to 2147483647 inclusive. Priority numbers can have gaps, which enable you to add or remove rules in the future without affecting the rest of the rules. For example, 1, 2, 3, 4, 5, 9, 12, 16 is a valid series of priority numbers to which you could add rules numbered from 6 to 8, 10 to 11, and 13 to 15 in the future without any impact on existing rules.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "priority", value)

    @property
    @pulumi.getter(name="routeAction")
    def route_action(self) -> Optional[pulumi.Input['HttpRouteActionArgs']]:
        """
        In response to a matching matchRule, the load balancer performs advanced routing actions, such as URL rewrites and header transformations, before forwarding the request to the selected backend. If routeAction specifies any weightedBackendServices, service must not be set. Conversely if service is set, routeAction cannot contain any weightedBackendServices. Only one of urlRedirect, service or routeAction.weightedBackendService must be set. UrlMaps for external HTTP(S) load balancers support only the urlRewrite action within a route rule's routeAction.
        """
        return pulumi.get(self, "route_action")

    @route_action.setter
    def route_action(self, value: Optional[pulumi.Input['HttpRouteActionArgs']]):
        pulumi.set(self, "route_action", value)

    @property
    @pulumi.getter
    def service(self) -> Optional[pulumi.Input[str]]:
        """
        The full or partial URL of the backend service resource to which traffic is directed if this rule is matched. If routeAction is also specified, advanced routing actions, such as URL rewrites, take effect before sending the request to the backend. However, if service is specified, routeAction cannot contain any weightedBackendServices. Conversely, if routeAction specifies any weightedBackendServices, service must not be specified. Only one of urlRedirect, service or routeAction.weightedBackendService must be set.
        """
        return pulumi.get(self, "service")

    @service.setter
    def service(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service", value)

    @property
    @pulumi.getter(name="urlRedirect")
    def url_redirect(self) -> Optional[pulumi.Input['HttpRedirectActionArgs']]:
        """
        When this rule is matched, the request is redirected to a URL specified by urlRedirect. If urlRedirect is specified, service or routeAction must not be set. Not supported when the URL map is bound to a target gRPC proxy.
        """
        return pulumi.get(self, "url_redirect")

    @url_redirect.setter
    def url_redirect(self, value: Optional[pulumi.Input['HttpRedirectActionArgs']]):
        pulumi.set(self, "url_redirect", value)


@pulumi.input_type
class ImageRawDiskArgs:
    def __init__(__self__, *,
                 container_type: Optional[pulumi.Input['ImageRawDiskContainerType']] = None,
                 source: Optional[pulumi.Input[str]] = None):
        """
        The parameters of the raw disk image.
        :param pulumi.Input['ImageRawDiskContainerType'] container_type: The format used to encode and transmit the block device, which should be TAR. This is just a container and transmission format and not a runtime format. Provided by the client when the disk image is created.
        :param pulumi.Input[str] source: The full Google Cloud Storage URL where the raw disk image archive is stored. The following are valid formats for the URL: - https://storage.googleapis.com/bucket_name/image_archive_name - https://storage.googleapis.com/bucket_name/folder_name/ image_archive_name In order to create an image, you must provide the full or partial URL of one of the following: - The rawDisk.source URL - The sourceDisk URL - The sourceImage URL - The sourceSnapshot URL 
        """
        if container_type is not None:
            pulumi.set(__self__, "container_type", container_type)
        if source is not None:
            pulumi.set(__self__, "source", source)

    @property
    @pulumi.getter(name="containerType")
    def container_type(self) -> Optional[pulumi.Input['ImageRawDiskContainerType']]:
        """
        The format used to encode and transmit the block device, which should be TAR. This is just a container and transmission format and not a runtime format. Provided by the client when the disk image is created.
        """
        return pulumi.get(self, "container_type")

    @container_type.setter
    def container_type(self, value: Optional[pulumi.Input['ImageRawDiskContainerType']]):
        pulumi.set(self, "container_type", value)

    @property
    @pulumi.getter
    def source(self) -> Optional[pulumi.Input[str]]:
        """
        The full Google Cloud Storage URL where the raw disk image archive is stored. The following are valid formats for the URL: - https://storage.googleapis.com/bucket_name/image_archive_name - https://storage.googleapis.com/bucket_name/folder_name/ image_archive_name In order to create an image, you must provide the full or partial URL of one of the following: - The rawDisk.source URL - The sourceDisk URL - The sourceImage URL - The sourceSnapshot URL 
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source", value)


@pulumi.input_type
class InitialStateConfigArgs:
    def __init__(__self__, *,
                 dbs: Optional[pulumi.Input[Sequence[pulumi.Input['FileContentBufferArgs']]]] = None,
                 dbxs: Optional[pulumi.Input[Sequence[pulumi.Input['FileContentBufferArgs']]]] = None,
                 keks: Optional[pulumi.Input[Sequence[pulumi.Input['FileContentBufferArgs']]]] = None,
                 pk: Optional[pulumi.Input['FileContentBufferArgs']] = None):
        """
        Initial State for shielded instance, these are public keys which are safe to store in public
        :param pulumi.Input[Sequence[pulumi.Input['FileContentBufferArgs']]] dbs: The Key Database (db).
        :param pulumi.Input[Sequence[pulumi.Input['FileContentBufferArgs']]] dbxs: The forbidden key database (dbx).
        :param pulumi.Input[Sequence[pulumi.Input['FileContentBufferArgs']]] keks: The Key Exchange Key (KEK).
        :param pulumi.Input['FileContentBufferArgs'] pk: The Platform Key (PK).
        """
        if dbs is not None:
            pulumi.set(__self__, "dbs", dbs)
        if dbxs is not None:
            pulumi.set(__self__, "dbxs", dbxs)
        if keks is not None:
            pulumi.set(__self__, "keks", keks)
        if pk is not None:
            pulumi.set(__self__, "pk", pk)

    @property
    @pulumi.getter
    def dbs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FileContentBufferArgs']]]]:
        """
        The Key Database (db).
        """
        return pulumi.get(self, "dbs")

    @dbs.setter
    def dbs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FileContentBufferArgs']]]]):
        pulumi.set(self, "dbs", value)

    @property
    @pulumi.getter
    def dbxs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FileContentBufferArgs']]]]:
        """
        The forbidden key database (dbx).
        """
        return pulumi.get(self, "dbxs")

    @dbxs.setter
    def dbxs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FileContentBufferArgs']]]]):
        pulumi.set(self, "dbxs", value)

    @property
    @pulumi.getter
    def keks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FileContentBufferArgs']]]]:
        """
        The Key Exchange Key (KEK).
        """
        return pulumi.get(self, "keks")

    @keks.setter
    def keks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FileContentBufferArgs']]]]):
        pulumi.set(self, "keks", value)

    @property
    @pulumi.getter
    def pk(self) -> Optional[pulumi.Input['FileContentBufferArgs']]:
        """
        The Platform Key (PK).
        """
        return pulumi.get(self, "pk")

    @pk.setter
    def pk(self, value: Optional[pulumi.Input['FileContentBufferArgs']]):
        pulumi.set(self, "pk", value)


@pulumi.input_type
class InstanceGroupManagerAutoHealingPolicyArgs:
    def __init__(__self__, *,
                 health_check: Optional[pulumi.Input[str]] = None,
                 initial_delay_sec: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[str] health_check: The URL for the health check that signals autohealing.
        :param pulumi.Input[int] initial_delay_sec: The number of seconds that the managed instance group waits before it applies autohealing policies to new instances or recently recreated instances. This initial delay allows instances to initialize and run their startup scripts before the instance group determines that they are UNHEALTHY. This prevents the managed instance group from recreating its instances prematurely. This value must be from range [0, 3600].
        """
        if health_check is not None:
            pulumi.set(__self__, "health_check", health_check)
        if initial_delay_sec is not None:
            pulumi.set(__self__, "initial_delay_sec", initial_delay_sec)

    @property
    @pulumi.getter(name="healthCheck")
    def health_check(self) -> Optional[pulumi.Input[str]]:
        """
        The URL for the health check that signals autohealing.
        """
        return pulumi.get(self, "health_check")

    @health_check.setter
    def health_check(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "health_check", value)

    @property
    @pulumi.getter(name="initialDelaySec")
    def initial_delay_sec(self) -> Optional[pulumi.Input[int]]:
        """
        The number of seconds that the managed instance group waits before it applies autohealing policies to new instances or recently recreated instances. This initial delay allows instances to initialize and run their startup scripts before the instance group determines that they are UNHEALTHY. This prevents the managed instance group from recreating its instances prematurely. This value must be from range [0, 3600].
        """
        return pulumi.get(self, "initial_delay_sec")

    @initial_delay_sec.setter
    def initial_delay_sec(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "initial_delay_sec", value)


@pulumi.input_type
class InstanceGroupManagerUpdatePolicyArgs:
    def __init__(__self__, *,
                 instance_redistribution_type: Optional[pulumi.Input['InstanceGroupManagerUpdatePolicyInstanceRedistributionType']] = None,
                 max_surge: Optional[pulumi.Input['FixedOrPercentArgs']] = None,
                 max_unavailable: Optional[pulumi.Input['FixedOrPercentArgs']] = None,
                 min_ready_sec: Optional[pulumi.Input[int]] = None,
                 minimal_action: Optional[pulumi.Input['InstanceGroupManagerUpdatePolicyMinimalAction']] = None,
                 most_disruptive_allowed_action: Optional[pulumi.Input['InstanceGroupManagerUpdatePolicyMostDisruptiveAllowedAction']] = None,
                 replacement_method: Optional[pulumi.Input['InstanceGroupManagerUpdatePolicyReplacementMethod']] = None,
                 type: Optional[pulumi.Input['InstanceGroupManagerUpdatePolicyType']] = None):
        """
        :param pulumi.Input['InstanceGroupManagerUpdatePolicyInstanceRedistributionType'] instance_redistribution_type: The instance redistribution policy for regional managed instance groups. Valid values are: - PROACTIVE (default): The group attempts to maintain an even distribution of VM instances across zones in the region. - NONE: For non-autoscaled groups, proactive redistribution is disabled. 
        :param pulumi.Input['FixedOrPercentArgs'] max_surge: The maximum number of instances that can be created above the specified targetSize during the update process. This value can be either a fixed number or, if the group has 10 or more instances, a percentage. If you set a percentage, the number of instances is rounded if necessary. The default value for maxSurge is a fixed value equal to the number of zones in which the managed instance group operates. At least one of either maxSurge or maxUnavailable must be greater than 0. Learn more about maxSurge.
        :param pulumi.Input['FixedOrPercentArgs'] max_unavailable: The maximum number of instances that can be unavailable during the update process. An instance is considered available if all of the following conditions are satisfied: - The instance's status is RUNNING. - If there is a health check on the instance group, the instance's health check status must be HEALTHY at least once. If there is no health check on the group, then the instance only needs to have a status of RUNNING to be considered available. This value can be either a fixed number or, if the group has 10 or more instances, a percentage. If you set a percentage, the number of instances is rounded if necessary. The default value for maxUnavailable is a fixed value equal to the number of zones in which the managed instance group operates. At least one of either maxSurge or maxUnavailable must be greater than 0. Learn more about maxUnavailable.
        :param pulumi.Input[int] min_ready_sec: Minimum number of seconds to wait for after a newly created instance becomes available. This value must be from range [0, 3600].
        :param pulumi.Input['InstanceGroupManagerUpdatePolicyMinimalAction'] minimal_action: Minimal action to be taken on an instance. You can specify either RESTART to restart existing instances or REPLACE to delete and create new instances from the target template. If you specify a RESTART, the Updater will attempt to perform that action only. However, if the Updater determines that the minimal action you specify is not enough to perform the update, it might perform a more disruptive action.
        :param pulumi.Input['InstanceGroupManagerUpdatePolicyMostDisruptiveAllowedAction'] most_disruptive_allowed_action: Most disruptive action that is allowed to be taken on an instance. You can specify either NONE to forbid any actions, REFRESH to allow actions that do not need instance restart, RESTART to allow actions that can be applied without instance replacing or REPLACE to allow all possible actions. If the Updater determines that the minimal update action needed is more disruptive than most disruptive allowed action you specify it will not perform the update at all.
        :param pulumi.Input['InstanceGroupManagerUpdatePolicyReplacementMethod'] replacement_method: What action should be used to replace instances. See minimal_action.REPLACE
        :param pulumi.Input['InstanceGroupManagerUpdatePolicyType'] type: The type of update process. You can specify either PROACTIVE so that the instance group manager proactively executes actions in order to bring instances to their target versions or OPPORTUNISTIC so that no action is proactively executed but the update will be performed as part of other actions (for example, resizes or recreateInstances calls).
        """
        if instance_redistribution_type is not None:
            pulumi.set(__self__, "instance_redistribution_type", instance_redistribution_type)
        if max_surge is not None:
            pulumi.set(__self__, "max_surge", max_surge)
        if max_unavailable is not None:
            pulumi.set(__self__, "max_unavailable", max_unavailable)
        if min_ready_sec is not None:
            pulumi.set(__self__, "min_ready_sec", min_ready_sec)
        if minimal_action is not None:
            pulumi.set(__self__, "minimal_action", minimal_action)
        if most_disruptive_allowed_action is not None:
            pulumi.set(__self__, "most_disruptive_allowed_action", most_disruptive_allowed_action)
        if replacement_method is not None:
            pulumi.set(__self__, "replacement_method", replacement_method)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="instanceRedistributionType")
    def instance_redistribution_type(self) -> Optional[pulumi.Input['InstanceGroupManagerUpdatePolicyInstanceRedistributionType']]:
        """
        The instance redistribution policy for regional managed instance groups. Valid values are: - PROACTIVE (default): The group attempts to maintain an even distribution of VM instances across zones in the region. - NONE: For non-autoscaled groups, proactive redistribution is disabled. 
        """
        return pulumi.get(self, "instance_redistribution_type")

    @instance_redistribution_type.setter
    def instance_redistribution_type(self, value: Optional[pulumi.Input['InstanceGroupManagerUpdatePolicyInstanceRedistributionType']]):
        pulumi.set(self, "instance_redistribution_type", value)

    @property
    @pulumi.getter(name="maxSurge")
    def max_surge(self) -> Optional[pulumi.Input['FixedOrPercentArgs']]:
        """
        The maximum number of instances that can be created above the specified targetSize during the update process. This value can be either a fixed number or, if the group has 10 or more instances, a percentage. If you set a percentage, the number of instances is rounded if necessary. The default value for maxSurge is a fixed value equal to the number of zones in which the managed instance group operates. At least one of either maxSurge or maxUnavailable must be greater than 0. Learn more about maxSurge.
        """
        return pulumi.get(self, "max_surge")

    @max_surge.setter
    def max_surge(self, value: Optional[pulumi.Input['FixedOrPercentArgs']]):
        pulumi.set(self, "max_surge", value)

    @property
    @pulumi.getter(name="maxUnavailable")
    def max_unavailable(self) -> Optional[pulumi.Input['FixedOrPercentArgs']]:
        """
        The maximum number of instances that can be unavailable during the update process. An instance is considered available if all of the following conditions are satisfied: - The instance's status is RUNNING. - If there is a health check on the instance group, the instance's health check status must be HEALTHY at least once. If there is no health check on the group, then the instance only needs to have a status of RUNNING to be considered available. This value can be either a fixed number or, if the group has 10 or more instances, a percentage. If you set a percentage, the number of instances is rounded if necessary. The default value for maxUnavailable is a fixed value equal to the number of zones in which the managed instance group operates. At least one of either maxSurge or maxUnavailable must be greater than 0. Learn more about maxUnavailable.
        """
        return pulumi.get(self, "max_unavailable")

    @max_unavailable.setter
    def max_unavailable(self, value: Optional[pulumi.Input['FixedOrPercentArgs']]):
        pulumi.set(self, "max_unavailable", value)

    @property
    @pulumi.getter(name="minReadySec")
    def min_ready_sec(self) -> Optional[pulumi.Input[int]]:
        """
        Minimum number of seconds to wait for after a newly created instance becomes available. This value must be from range [0, 3600].
        """
        return pulumi.get(self, "min_ready_sec")

    @min_ready_sec.setter
    def min_ready_sec(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_ready_sec", value)

    @property
    @pulumi.getter(name="minimalAction")
    def minimal_action(self) -> Optional[pulumi.Input['InstanceGroupManagerUpdatePolicyMinimalAction']]:
        """
        Minimal action to be taken on an instance. You can specify either RESTART to restart existing instances or REPLACE to delete and create new instances from the target template. If you specify a RESTART, the Updater will attempt to perform that action only. However, if the Updater determines that the minimal action you specify is not enough to perform the update, it might perform a more disruptive action.
        """
        return pulumi.get(self, "minimal_action")

    @minimal_action.setter
    def minimal_action(self, value: Optional[pulumi.Input['InstanceGroupManagerUpdatePolicyMinimalAction']]):
        pulumi.set(self, "minimal_action", value)

    @property
    @pulumi.getter(name="mostDisruptiveAllowedAction")
    def most_disruptive_allowed_action(self) -> Optional[pulumi.Input['InstanceGroupManagerUpdatePolicyMostDisruptiveAllowedAction']]:
        """
        Most disruptive action that is allowed to be taken on an instance. You can specify either NONE to forbid any actions, REFRESH to allow actions that do not need instance restart, RESTART to allow actions that can be applied without instance replacing or REPLACE to allow all possible actions. If the Updater determines that the minimal update action needed is more disruptive than most disruptive allowed action you specify it will not perform the update at all.
        """
        return pulumi.get(self, "most_disruptive_allowed_action")

    @most_disruptive_allowed_action.setter
    def most_disruptive_allowed_action(self, value: Optional[pulumi.Input['InstanceGroupManagerUpdatePolicyMostDisruptiveAllowedAction']]):
        pulumi.set(self, "most_disruptive_allowed_action", value)

    @property
    @pulumi.getter(name="replacementMethod")
    def replacement_method(self) -> Optional[pulumi.Input['InstanceGroupManagerUpdatePolicyReplacementMethod']]:
        """
        What action should be used to replace instances. See minimal_action.REPLACE
        """
        return pulumi.get(self, "replacement_method")

    @replacement_method.setter
    def replacement_method(self, value: Optional[pulumi.Input['InstanceGroupManagerUpdatePolicyReplacementMethod']]):
        pulumi.set(self, "replacement_method", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input['InstanceGroupManagerUpdatePolicyType']]:
        """
        The type of update process. You can specify either PROACTIVE so that the instance group manager proactively executes actions in order to bring instances to their target versions or OPPORTUNISTIC so that no action is proactively executed but the update will be performed as part of other actions (for example, resizes or recreateInstances calls).
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input['InstanceGroupManagerUpdatePolicyType']]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class InstanceGroupManagerVersionArgs:
    def __init__(__self__, *,
                 instance_template: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 target_size: Optional[pulumi.Input['FixedOrPercentArgs']] = None):
        """
        :param pulumi.Input[str] instance_template: The URL of the instance template that is specified for this managed instance group. The group uses this template to create new instances in the managed instance group until the `targetSize` for this version is reached. The templates for existing instances in the group do not change unless you run recreateInstances, run applyUpdatesToInstances, or set the group's updatePolicy.type to PROACTIVE; in those cases, existing instances are updated until the `targetSize` for this version is reached.
        :param pulumi.Input[str] name: Name of the version. Unique among all versions in the scope of this managed instance group.
        :param pulumi.Input['FixedOrPercentArgs'] target_size: Specifies the intended number of instances to be created from the instanceTemplate. The final number of instances created from the template will be equal to: - If expressed as a fixed number, the minimum of either targetSize.fixed or instanceGroupManager.targetSize is used. - if expressed as a percent, the targetSize would be (targetSize.percent/100 * InstanceGroupManager.targetSize) If there is a remainder, the number is rounded. If unset, this version will update any remaining instances not updated by another version. Read Starting a canary update for more information.
        """
        if instance_template is not None:
            pulumi.set(__self__, "instance_template", instance_template)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if target_size is not None:
            pulumi.set(__self__, "target_size", target_size)

    @property
    @pulumi.getter(name="instanceTemplate")
    def instance_template(self) -> Optional[pulumi.Input[str]]:
        """
        The URL of the instance template that is specified for this managed instance group. The group uses this template to create new instances in the managed instance group until the `targetSize` for this version is reached. The templates for existing instances in the group do not change unless you run recreateInstances, run applyUpdatesToInstances, or set the group's updatePolicy.type to PROACTIVE; in those cases, existing instances are updated until the `targetSize` for this version is reached.
        """
        return pulumi.get(self, "instance_template")

    @instance_template.setter
    def instance_template(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_template", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the version. Unique among all versions in the scope of this managed instance group.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="targetSize")
    def target_size(self) -> Optional[pulumi.Input['FixedOrPercentArgs']]:
        """
        Specifies the intended number of instances to be created from the instanceTemplate. The final number of instances created from the template will be equal to: - If expressed as a fixed number, the minimum of either targetSize.fixed or instanceGroupManager.targetSize is used. - if expressed as a percent, the targetSize would be (targetSize.percent/100 * InstanceGroupManager.targetSize) If there is a remainder, the number is rounded. If unset, this version will update any remaining instances not updated by another version. Read Starting a canary update for more information.
        """
        return pulumi.get(self, "target_size")

    @target_size.setter
    def target_size(self, value: Optional[pulumi.Input['FixedOrPercentArgs']]):
        pulumi.set(self, "target_size", value)


@pulumi.input_type
class InstanceParamsArgs:
    def __init__(__self__, *,
                 resource_manager_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        Additional instance params.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] resource_manager_tags: Resource manager tags to be bound to the instance. Tag keys and values have the same definition as resource manager tags. Keys must be in the format `tagKeys/{tag_key_id}`, and values are in the format `tagValues/456`. The field is ignored (both PUT & PATCH) when empty.
        """
        if resource_manager_tags is not None:
            pulumi.set(__self__, "resource_manager_tags", resource_manager_tags)

    @property
    @pulumi.getter(name="resourceManagerTags")
    def resource_manager_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Resource manager tags to be bound to the instance. Tag keys and values have the same definition as resource manager tags. Keys must be in the format `tagKeys/{tag_key_id}`, and values are in the format `tagValues/456`. The field is ignored (both PUT & PATCH) when empty.
        """
        return pulumi.get(self, "resource_manager_tags")

    @resource_manager_tags.setter
    def resource_manager_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "resource_manager_tags", value)


@pulumi.input_type
class InstancePropertiesArgs:
    def __init__(__self__, *,
                 advanced_machine_features: Optional[pulumi.Input['AdvancedMachineFeaturesArgs']] = None,
                 can_ip_forward: Optional[pulumi.Input[bool]] = None,
                 confidential_instance_config: Optional[pulumi.Input['ConfidentialInstanceConfigArgs']] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 disks: Optional[pulumi.Input[Sequence[pulumi.Input['AttachedDiskArgs']]]] = None,
                 display_device: Optional[pulumi.Input['DisplayDeviceArgs']] = None,
                 guest_accelerators: Optional[pulumi.Input[Sequence[pulumi.Input['AcceleratorConfigArgs']]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 machine_type: Optional[pulumi.Input[str]] = None,
                 metadata: Optional[pulumi.Input['MetadataArgs']] = None,
                 min_cpu_platform: Optional[pulumi.Input[str]] = None,
                 network_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkInterfaceArgs']]]] = None,
                 network_performance_config: Optional[pulumi.Input['NetworkPerformanceConfigArgs']] = None,
                 post_key_revocation_action_type: Optional[pulumi.Input['InstancePropertiesPostKeyRevocationActionType']] = None,
                 private_ipv6_google_access: Optional[pulumi.Input['InstancePropertiesPrivateIpv6GoogleAccess']] = None,
                 reservation_affinity: Optional[pulumi.Input['ReservationAffinityArgs']] = None,
                 resource_manager_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 resource_policies: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 scheduling: Optional[pulumi.Input['SchedulingArgs']] = None,
                 service_accounts: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceAccountArgs']]]] = None,
                 shielded_instance_config: Optional[pulumi.Input['ShieldedInstanceConfigArgs']] = None,
                 shielded_vm_config: Optional[pulumi.Input['ShieldedVmConfigArgs']] = None,
                 tags: Optional[pulumi.Input['TagsArgs']] = None):
        """
        :param pulumi.Input['AdvancedMachineFeaturesArgs'] advanced_machine_features: Controls for advanced machine-related behavior features. Note that for MachineImage, this is not supported yet.
        :param pulumi.Input[bool] can_ip_forward: Enables instances created based on these properties to send packets with source IP addresses other than their own and receive packets with destination IP addresses other than their own. If these instances will be used as an IP gateway or it will be set as the next-hop in a Route resource, specify true. If unsure, leave this set to false. See the Enable IP forwarding documentation for more information.
        :param pulumi.Input['ConfidentialInstanceConfigArgs'] confidential_instance_config: Specifies the Confidential Instance options. Note that for MachineImage, this is not supported yet.
        :param pulumi.Input[str] description: An optional text description for the instances that are created from these properties.
        :param pulumi.Input[Sequence[pulumi.Input['AttachedDiskArgs']]] disks: An array of disks that are associated with the instances that are created from these properties.
        :param pulumi.Input['DisplayDeviceArgs'] display_device: Display Device properties to enable support for remote display products like: Teradici, VNC and TeamViewer Note that for MachineImage, this is not supported yet.
        :param pulumi.Input[Sequence[pulumi.Input['AcceleratorConfigArgs']]] guest_accelerators: A list of guest accelerator cards' type and count to use for instances created from these properties.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Labels to apply to instances that are created from these properties.
        :param pulumi.Input[str] machine_type: The machine type to use for instances that are created from these properties.
        :param pulumi.Input['MetadataArgs'] metadata: The metadata key/value pairs to assign to instances that are created from these properties. These pairs can consist of custom metadata or predefined keys. See Project and instance metadata for more information.
        :param pulumi.Input[str] min_cpu_platform: Minimum cpu/platform to be used by instances. The instance may be scheduled on the specified or newer cpu/platform. Applicable values are the friendly names of CPU platforms, such as minCpuPlatform: "Intel Haswell" or minCpuPlatform: "Intel Sandy Bridge". For more information, read Specifying a Minimum CPU Platform.
        :param pulumi.Input[Sequence[pulumi.Input['NetworkInterfaceArgs']]] network_interfaces: An array of network access configurations for this interface.
        :param pulumi.Input['NetworkPerformanceConfigArgs'] network_performance_config: Note that for MachineImage, this is not supported yet.
        :param pulumi.Input['InstancePropertiesPostKeyRevocationActionType'] post_key_revocation_action_type: PostKeyRevocationActionType of the instance.
        :param pulumi.Input['InstancePropertiesPrivateIpv6GoogleAccess'] private_ipv6_google_access: The private IPv6 google access type for VMs. If not specified, use INHERIT_FROM_SUBNETWORK as default. Note that for MachineImage, this is not supported yet.
        :param pulumi.Input['ReservationAffinityArgs'] reservation_affinity: Specifies the reservations that instances can consume from. Note that for MachineImage, this is not supported yet.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] resource_manager_tags: Resource manager tags to be bound to the instance. Tag keys and values have the same definition as resource manager tags. Keys must be in the format `tagKeys/{tag_key_id}`, and values are in the format `tagValues/456`. The field is ignored (both PUT & PATCH) when empty.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] resource_policies: Resource policies (names, not URLs) applied to instances created from these properties. Note that for MachineImage, this is not supported yet.
        :param pulumi.Input['SchedulingArgs'] scheduling: Specifies the scheduling options for the instances that are created from these properties.
        :param pulumi.Input[Sequence[pulumi.Input['ServiceAccountArgs']]] service_accounts: A list of service accounts with specified scopes. Access tokens for these service accounts are available to the instances that are created from these properties. Use metadata queries to obtain the access tokens for these instances.
        :param pulumi.Input['ShieldedInstanceConfigArgs'] shielded_instance_config: Note that for MachineImage, this is not supported yet.
        :param pulumi.Input['ShieldedVmConfigArgs'] shielded_vm_config: Specifies the Shielded VM options for the instances that are created from these properties.
        :param pulumi.Input['TagsArgs'] tags: A list of tags to apply to the instances that are created from these properties. The tags identify valid sources or targets for network firewalls. The setTags method can modify this list of tags. Each tag within the list must comply with RFC1035.
        """
        if advanced_machine_features is not None:
            pulumi.set(__self__, "advanced_machine_features", advanced_machine_features)
        if can_ip_forward is not None:
            pulumi.set(__self__, "can_ip_forward", can_ip_forward)
        if confidential_instance_config is not None:
            pulumi.set(__self__, "confidential_instance_config", confidential_instance_config)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disks is not None:
            pulumi.set(__self__, "disks", disks)
        if display_device is not None:
            pulumi.set(__self__, "display_device", display_device)
        if guest_accelerators is not None:
            pulumi.set(__self__, "guest_accelerators", guest_accelerators)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if machine_type is not None:
            pulumi.set(__self__, "machine_type", machine_type)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if min_cpu_platform is not None:
            pulumi.set(__self__, "min_cpu_platform", min_cpu_platform)
        if network_interfaces is not None:
            pulumi.set(__self__, "network_interfaces", network_interfaces)
        if network_performance_config is not None:
            pulumi.set(__self__, "network_performance_config", network_performance_config)
        if post_key_revocation_action_type is not None:
            pulumi.set(__self__, "post_key_revocation_action_type", post_key_revocation_action_type)
        if private_ipv6_google_access is not None:
            pulumi.set(__self__, "private_ipv6_google_access", private_ipv6_google_access)
        if reservation_affinity is not None:
            pulumi.set(__self__, "reservation_affinity", reservation_affinity)
        if resource_manager_tags is not None:
            pulumi.set(__self__, "resource_manager_tags", resource_manager_tags)
        if resource_policies is not None:
            pulumi.set(__self__, "resource_policies", resource_policies)
        if scheduling is not None:
            pulumi.set(__self__, "scheduling", scheduling)
        if service_accounts is not None:
            pulumi.set(__self__, "service_accounts", service_accounts)
        if shielded_instance_config is not None:
            pulumi.set(__self__, "shielded_instance_config", shielded_instance_config)
        if shielded_vm_config is not None:
            pulumi.set(__self__, "shielded_vm_config", shielded_vm_config)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="advancedMachineFeatures")
    def advanced_machine_features(self) -> Optional[pulumi.Input['AdvancedMachineFeaturesArgs']]:
        """
        Controls for advanced machine-related behavior features. Note that for MachineImage, this is not supported yet.
        """
        return pulumi.get(self, "advanced_machine_features")

    @advanced_machine_features.setter
    def advanced_machine_features(self, value: Optional[pulumi.Input['AdvancedMachineFeaturesArgs']]):
        pulumi.set(self, "advanced_machine_features", value)

    @property
    @pulumi.getter(name="canIpForward")
    def can_ip_forward(self) -> Optional[pulumi.Input[bool]]:
        """
        Enables instances created based on these properties to send packets with source IP addresses other than their own and receive packets with destination IP addresses other than their own. If these instances will be used as an IP gateway or it will be set as the next-hop in a Route resource, specify true. If unsure, leave this set to false. See the Enable IP forwarding documentation for more information.
        """
        return pulumi.get(self, "can_ip_forward")

    @can_ip_forward.setter
    def can_ip_forward(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "can_ip_forward", value)

    @property
    @pulumi.getter(name="confidentialInstanceConfig")
    def confidential_instance_config(self) -> Optional[pulumi.Input['ConfidentialInstanceConfigArgs']]:
        """
        Specifies the Confidential Instance options. Note that for MachineImage, this is not supported yet.
        """
        return pulumi.get(self, "confidential_instance_config")

    @confidential_instance_config.setter
    def confidential_instance_config(self, value: Optional[pulumi.Input['ConfidentialInstanceConfigArgs']]):
        pulumi.set(self, "confidential_instance_config", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        An optional text description for the instances that are created from these properties.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def disks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AttachedDiskArgs']]]]:
        """
        An array of disks that are associated with the instances that are created from these properties.
        """
        return pulumi.get(self, "disks")

    @disks.setter
    def disks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AttachedDiskArgs']]]]):
        pulumi.set(self, "disks", value)

    @property
    @pulumi.getter(name="displayDevice")
    def display_device(self) -> Optional[pulumi.Input['DisplayDeviceArgs']]:
        """
        Display Device properties to enable support for remote display products like: Teradici, VNC and TeamViewer Note that for MachineImage, this is not supported yet.
        """
        return pulumi.get(self, "display_device")

    @display_device.setter
    def display_device(self, value: Optional[pulumi.Input['DisplayDeviceArgs']]):
        pulumi.set(self, "display_device", value)

    @property
    @pulumi.getter(name="guestAccelerators")
    def guest_accelerators(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AcceleratorConfigArgs']]]]:
        """
        A list of guest accelerator cards' type and count to use for instances created from these properties.
        """
        return pulumi.get(self, "guest_accelerators")

    @guest_accelerators.setter
    def guest_accelerators(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AcceleratorConfigArgs']]]]):
        pulumi.set(self, "guest_accelerators", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Labels to apply to instances that are created from these properties.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter(name="machineType")
    def machine_type(self) -> Optional[pulumi.Input[str]]:
        """
        The machine type to use for instances that are created from these properties.
        """
        return pulumi.get(self, "machine_type")

    @machine_type.setter
    def machine_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "machine_type", value)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input['MetadataArgs']]:
        """
        The metadata key/value pairs to assign to instances that are created from these properties. These pairs can consist of custom metadata or predefined keys. See Project and instance metadata for more information.
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input['MetadataArgs']]):
        pulumi.set(self, "metadata", value)

    @property
    @pulumi.getter(name="minCpuPlatform")
    def min_cpu_platform(self) -> Optional[pulumi.Input[str]]:
        """
        Minimum cpu/platform to be used by instances. The instance may be scheduled on the specified or newer cpu/platform. Applicable values are the friendly names of CPU platforms, such as minCpuPlatform: "Intel Haswell" or minCpuPlatform: "Intel Sandy Bridge". For more information, read Specifying a Minimum CPU Platform.
        """
        return pulumi.get(self, "min_cpu_platform")

    @min_cpu_platform.setter
    def min_cpu_platform(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "min_cpu_platform", value)

    @property
    @pulumi.getter(name="networkInterfaces")
    def network_interfaces(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NetworkInterfaceArgs']]]]:
        """
        An array of network access configurations for this interface.
        """
        return pulumi.get(self, "network_interfaces")

    @network_interfaces.setter
    def network_interfaces(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkInterfaceArgs']]]]):
        pulumi.set(self, "network_interfaces", value)

    @property
    @pulumi.getter(name="networkPerformanceConfig")
    def network_performance_config(self) -> Optional[pulumi.Input['NetworkPerformanceConfigArgs']]:
        """
        Note that for MachineImage, this is not supported yet.
        """
        return pulumi.get(self, "network_performance_config")

    @network_performance_config.setter
    def network_performance_config(self, value: Optional[pulumi.Input['NetworkPerformanceConfigArgs']]):
        pulumi.set(self, "network_performance_config", value)

    @property
    @pulumi.getter(name="postKeyRevocationActionType")
    def post_key_revocation_action_type(self) -> Optional[pulumi.Input['InstancePropertiesPostKeyRevocationActionType']]:
        """
        PostKeyRevocationActionType of the instance.
        """
        return pulumi.get(self, "post_key_revocation_action_type")

    @post_key_revocation_action_type.setter
    def post_key_revocation_action_type(self, value: Optional[pulumi.Input['InstancePropertiesPostKeyRevocationActionType']]):
        pulumi.set(self, "post_key_revocation_action_type", value)

    @property
    @pulumi.getter(name="privateIpv6GoogleAccess")
    def private_ipv6_google_access(self) -> Optional[pulumi.Input['InstancePropertiesPrivateIpv6GoogleAccess']]:
        """
        The private IPv6 google access type for VMs. If not specified, use INHERIT_FROM_SUBNETWORK as default. Note that for MachineImage, this is not supported yet.
        """
        return pulumi.get(self, "private_ipv6_google_access")

    @private_ipv6_google_access.setter
    def private_ipv6_google_access(self, value: Optional[pulumi.Input['InstancePropertiesPrivateIpv6GoogleAccess']]):
        pulumi.set(self, "private_ipv6_google_access", value)

    @property
    @pulumi.getter(name="reservationAffinity")
    def reservation_affinity(self) -> Optional[pulumi.Input['ReservationAffinityArgs']]:
        """
        Specifies the reservations that instances can consume from. Note that for MachineImage, this is not supported yet.
        """
        return pulumi.get(self, "reservation_affinity")

    @reservation_affinity.setter
    def reservation_affinity(self, value: Optional[pulumi.Input['ReservationAffinityArgs']]):
        pulumi.set(self, "reservation_affinity", value)

    @property
    @pulumi.getter(name="resourceManagerTags")
    def resource_manager_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Resource manager tags to be bound to the instance. Tag keys and values have the same definition as resource manager tags. Keys must be in the format `tagKeys/{tag_key_id}`, and values are in the format `tagValues/456`. The field is ignored (both PUT & PATCH) when empty.
        """
        return pulumi.get(self, "resource_manager_tags")

    @resource_manager_tags.setter
    def resource_manager_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "resource_manager_tags", value)

    @property
    @pulumi.getter(name="resourcePolicies")
    def resource_policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Resource policies (names, not URLs) applied to instances created from these properties. Note that for MachineImage, this is not supported yet.
        """
        return pulumi.get(self, "resource_policies")

    @resource_policies.setter
    def resource_policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "resource_policies", value)

    @property
    @pulumi.getter
    def scheduling(self) -> Optional[pulumi.Input['SchedulingArgs']]:
        """
        Specifies the scheduling options for the instances that are created from these properties.
        """
        return pulumi.get(self, "scheduling")

    @scheduling.setter
    def scheduling(self, value: Optional[pulumi.Input['SchedulingArgs']]):
        pulumi.set(self, "scheduling", value)

    @property
    @pulumi.getter(name="serviceAccounts")
    def service_accounts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceAccountArgs']]]]:
        """
        A list of service accounts with specified scopes. Access tokens for these service accounts are available to the instances that are created from these properties. Use metadata queries to obtain the access tokens for these instances.
        """
        return pulumi.get(self, "service_accounts")

    @service_accounts.setter
    def service_accounts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceAccountArgs']]]]):
        pulumi.set(self, "service_accounts", value)

    @property
    @pulumi.getter(name="shieldedInstanceConfig")
    def shielded_instance_config(self) -> Optional[pulumi.Input['ShieldedInstanceConfigArgs']]:
        """
        Note that for MachineImage, this is not supported yet.
        """
        return pulumi.get(self, "shielded_instance_config")

    @shielded_instance_config.setter
    def shielded_instance_config(self, value: Optional[pulumi.Input['ShieldedInstanceConfigArgs']]):
        pulumi.set(self, "shielded_instance_config", value)

    @property
    @pulumi.getter(name="shieldedVmConfig")
    def shielded_vm_config(self) -> Optional[pulumi.Input['ShieldedVmConfigArgs']]:
        """
        Specifies the Shielded VM options for the instances that are created from these properties.
        """
        return pulumi.get(self, "shielded_vm_config")

    @shielded_vm_config.setter
    def shielded_vm_config(self, value: Optional[pulumi.Input['ShieldedVmConfigArgs']]):
        pulumi.set(self, "shielded_vm_config", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input['TagsArgs']]:
        """
        A list of tags to apply to the instances that are created from these properties. The tags identify valid sources or targets for network firewalls. The setTags method can modify this list of tags. Each tag within the list must comply with RFC1035.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input['TagsArgs']]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class Int64RangeMatchArgs:
    def __init__(__self__, *,
                 range_end: Optional[pulumi.Input[str]] = None,
                 range_start: Optional[pulumi.Input[str]] = None):
        """
        HttpRouteRuleMatch criteria for field values that must stay within the specified integer range.
        :param pulumi.Input[str] range_end: The end of the range (exclusive) in signed long integer format.
        :param pulumi.Input[str] range_start: The start of the range (inclusive) in signed long integer format.
        """
        if range_end is not None:
            pulumi.set(__self__, "range_end", range_end)
        if range_start is not None:
            pulumi.set(__self__, "range_start", range_start)

    @property
    @pulumi.getter(name="rangeEnd")
    def range_end(self) -> Optional[pulumi.Input[str]]:
        """
        The end of the range (exclusive) in signed long integer format.
        """
        return pulumi.get(self, "range_end")

    @range_end.setter
    def range_end(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "range_end", value)

    @property
    @pulumi.getter(name="rangeStart")
    def range_start(self) -> Optional[pulumi.Input[str]]:
        """
        The start of the range (inclusive) in signed long integer format.
        """
        return pulumi.get(self, "range_start")

    @range_start.setter
    def range_start(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "range_start", value)


@pulumi.input_type
class InterconnectAttachmentPartnerMetadataArgs:
    def __init__(__self__, *,
                 interconnect_name: Optional[pulumi.Input[str]] = None,
                 partner_name: Optional[pulumi.Input[str]] = None,
                 portal_url: Optional[pulumi.Input[str]] = None):
        """
        Informational metadata about Partner attachments from Partners to display to customers. These fields are propagated from PARTNER_PROVIDER attachments to their corresponding PARTNER attachments.
        :param pulumi.Input[str] interconnect_name: Plain text name of the Interconnect this attachment is connected to, as displayed in the Partner's portal. For instance "Chicago 1". This value may be validated to match approved Partner values.
        :param pulumi.Input[str] partner_name: Plain text name of the Partner providing this attachment. This value may be validated to match approved Partner values.
        :param pulumi.Input[str] portal_url: URL of the Partner's portal for this Attachment. Partners may customise this to be a deep link to the specific resource on the Partner portal. This value may be validated to match approved Partner values.
        """
        if interconnect_name is not None:
            pulumi.set(__self__, "interconnect_name", interconnect_name)
        if partner_name is not None:
            pulumi.set(__self__, "partner_name", partner_name)
        if portal_url is not None:
            pulumi.set(__self__, "portal_url", portal_url)

    @property
    @pulumi.getter(name="interconnectName")
    def interconnect_name(self) -> Optional[pulumi.Input[str]]:
        """
        Plain text name of the Interconnect this attachment is connected to, as displayed in the Partner's portal. For instance "Chicago 1". This value may be validated to match approved Partner values.
        """
        return pulumi.get(self, "interconnect_name")

    @interconnect_name.setter
    def interconnect_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "interconnect_name", value)

    @property
    @pulumi.getter(name="partnerName")
    def partner_name(self) -> Optional[pulumi.Input[str]]:
        """
        Plain text name of the Partner providing this attachment. This value may be validated to match approved Partner values.
        """
        return pulumi.get(self, "partner_name")

    @partner_name.setter
    def partner_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "partner_name", value)

    @property
    @pulumi.getter(name="portalUrl")
    def portal_url(self) -> Optional[pulumi.Input[str]]:
        """
        URL of the Partner's portal for this Attachment. Partners may customise this to be a deep link to the specific resource on the Partner portal. This value may be validated to match approved Partner values.
        """
        return pulumi.get(self, "portal_url")

    @portal_url.setter
    def portal_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "portal_url", value)


@pulumi.input_type
class LicenseResourceCommitmentArgs:
    def __init__(__self__, *,
                 amount: Optional[pulumi.Input[str]] = None,
                 cores_per_license: Optional[pulumi.Input[str]] = None,
                 license: Optional[pulumi.Input[str]] = None):
        """
        Commitment for a particular license resource.
        :param pulumi.Input[str] amount: The number of licenses purchased.
        :param pulumi.Input[str] cores_per_license: Specifies the core range of the instance for which this license applies.
        :param pulumi.Input[str] license: Any applicable license URI.
        """
        if amount is not None:
            pulumi.set(__self__, "amount", amount)
        if cores_per_license is not None:
            pulumi.set(__self__, "cores_per_license", cores_per_license)
        if license is not None:
            pulumi.set(__self__, "license", license)

    @property
    @pulumi.getter
    def amount(self) -> Optional[pulumi.Input[str]]:
        """
        The number of licenses purchased.
        """
        return pulumi.get(self, "amount")

    @amount.setter
    def amount(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "amount", value)

    @property
    @pulumi.getter(name="coresPerLicense")
    def cores_per_license(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the core range of the instance for which this license applies.
        """
        return pulumi.get(self, "cores_per_license")

    @cores_per_license.setter
    def cores_per_license(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cores_per_license", value)

    @property
    @pulumi.getter
    def license(self) -> Optional[pulumi.Input[str]]:
        """
        Any applicable license URI.
        """
        return pulumi.get(self, "license")

    @license.setter
    def license(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "license", value)


@pulumi.input_type
class LicenseResourceRequirementsArgs:
    def __init__(__self__, *,
                 min_guest_cpu_count: Optional[pulumi.Input[int]] = None,
                 min_memory_mb: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[int] min_guest_cpu_count: Minimum number of guest cpus required to use the Instance. Enforced at Instance creation and Instance start.
        :param pulumi.Input[int] min_memory_mb: Minimum memory required to use the Instance. Enforced at Instance creation and Instance start.
        """
        if min_guest_cpu_count is not None:
            pulumi.set(__self__, "min_guest_cpu_count", min_guest_cpu_count)
        if min_memory_mb is not None:
            pulumi.set(__self__, "min_memory_mb", min_memory_mb)

    @property
    @pulumi.getter(name="minGuestCpuCount")
    def min_guest_cpu_count(self) -> Optional[pulumi.Input[int]]:
        """
        Minimum number of guest cpus required to use the Instance. Enforced at Instance creation and Instance start.
        """
        return pulumi.get(self, "min_guest_cpu_count")

    @min_guest_cpu_count.setter
    def min_guest_cpu_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_guest_cpu_count", value)

    @property
    @pulumi.getter(name="minMemoryMb")
    def min_memory_mb(self) -> Optional[pulumi.Input[int]]:
        """
        Minimum memory required to use the Instance. Enforced at Instance creation and Instance start.
        """
        return pulumi.get(self, "min_memory_mb")

    @min_memory_mb.setter
    def min_memory_mb(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_memory_mb", value)


@pulumi.input_type
class LocalDiskArgs:
    def __init__(__self__, *,
                 disk_count: Optional[pulumi.Input[int]] = None,
                 disk_size_gb: Optional[pulumi.Input[int]] = None,
                 disk_type: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[int] disk_count: Specifies the number of such disks.
        :param pulumi.Input[int] disk_size_gb: Specifies the size of the disk in base-2 GB.
        :param pulumi.Input[str] disk_type: Specifies the desired disk type on the node. This disk type must be a local storage type (e.g.: local-ssd). Note that for nodeTemplates, this should be the name of the disk type and not its URL.
        """
        if disk_count is not None:
            pulumi.set(__self__, "disk_count", disk_count)
        if disk_size_gb is not None:
            pulumi.set(__self__, "disk_size_gb", disk_size_gb)
        if disk_type is not None:
            pulumi.set(__self__, "disk_type", disk_type)

    @property
    @pulumi.getter(name="diskCount")
    def disk_count(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the number of such disks.
        """
        return pulumi.get(self, "disk_count")

    @disk_count.setter
    def disk_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "disk_count", value)

    @property
    @pulumi.getter(name="diskSizeGb")
    def disk_size_gb(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the size of the disk in base-2 GB.
        """
        return pulumi.get(self, "disk_size_gb")

    @disk_size_gb.setter
    def disk_size_gb(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "disk_size_gb", value)

    @property
    @pulumi.getter(name="diskType")
    def disk_type(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the desired disk type on the node. This disk type must be a local storage type (e.g.: local-ssd). Note that for nodeTemplates, this should be the name of the disk type and not its URL.
        """
        return pulumi.get(self, "disk_type")

    @disk_type.setter
    def disk_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "disk_type", value)


@pulumi.input_type
class LogConfigCloudAuditOptionsArgs:
    def __init__(__self__, *,
                 authorization_logging_options: Optional[pulumi.Input['AuthorizationLoggingOptionsArgs']] = None,
                 log_name: Optional[pulumi.Input['LogConfigCloudAuditOptionsLogName']] = None):
        """
        This is deprecated and has no effect. Do not use.
        :param pulumi.Input['AuthorizationLoggingOptionsArgs'] authorization_logging_options: This is deprecated and has no effect. Do not use.
        :param pulumi.Input['LogConfigCloudAuditOptionsLogName'] log_name: This is deprecated and has no effect. Do not use.
        """
        if authorization_logging_options is not None:
            pulumi.set(__self__, "authorization_logging_options", authorization_logging_options)
        if log_name is not None:
            pulumi.set(__self__, "log_name", log_name)

    @property
    @pulumi.getter(name="authorizationLoggingOptions")
    def authorization_logging_options(self) -> Optional[pulumi.Input['AuthorizationLoggingOptionsArgs']]:
        """
        This is deprecated and has no effect. Do not use.
        """
        return pulumi.get(self, "authorization_logging_options")

    @authorization_logging_options.setter
    def authorization_logging_options(self, value: Optional[pulumi.Input['AuthorizationLoggingOptionsArgs']]):
        pulumi.set(self, "authorization_logging_options", value)

    @property
    @pulumi.getter(name="logName")
    def log_name(self) -> Optional[pulumi.Input['LogConfigCloudAuditOptionsLogName']]:
        """
        This is deprecated and has no effect. Do not use.
        """
        return pulumi.get(self, "log_name")

    @log_name.setter
    def log_name(self, value: Optional[pulumi.Input['LogConfigCloudAuditOptionsLogName']]):
        pulumi.set(self, "log_name", value)


@pulumi.input_type
class LogConfigCounterOptionsCustomFieldArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[str]] = None):
        """
        This is deprecated and has no effect. Do not use.
        :param pulumi.Input[str] name: This is deprecated and has no effect. Do not use.
        :param pulumi.Input[str] value: This is deprecated and has no effect. Do not use.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        This is deprecated and has no effect. Do not use.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        This is deprecated and has no effect. Do not use.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class LogConfigCounterOptionsArgs:
    def __init__(__self__, *,
                 custom_fields: Optional[pulumi.Input[Sequence[pulumi.Input['LogConfigCounterOptionsCustomFieldArgs']]]] = None,
                 field: Optional[pulumi.Input[str]] = None,
                 metric: Optional[pulumi.Input[str]] = None):
        """
        This is deprecated and has no effect. Do not use.
        :param pulumi.Input[Sequence[pulumi.Input['LogConfigCounterOptionsCustomFieldArgs']]] custom_fields: This is deprecated and has no effect. Do not use.
        :param pulumi.Input[str] field: This is deprecated and has no effect. Do not use.
        :param pulumi.Input[str] metric: This is deprecated and has no effect. Do not use.
        """
        if custom_fields is not None:
            pulumi.set(__self__, "custom_fields", custom_fields)
        if field is not None:
            pulumi.set(__self__, "field", field)
        if metric is not None:
            pulumi.set(__self__, "metric", metric)

    @property
    @pulumi.getter(name="customFields")
    def custom_fields(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LogConfigCounterOptionsCustomFieldArgs']]]]:
        """
        This is deprecated and has no effect. Do not use.
        """
        return pulumi.get(self, "custom_fields")

    @custom_fields.setter
    def custom_fields(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LogConfigCounterOptionsCustomFieldArgs']]]]):
        pulumi.set(self, "custom_fields", value)

    @property
    @pulumi.getter
    def field(self) -> Optional[pulumi.Input[str]]:
        """
        This is deprecated and has no effect. Do not use.
        """
        return pulumi.get(self, "field")

    @field.setter
    def field(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "field", value)

    @property
    @pulumi.getter
    def metric(self) -> Optional[pulumi.Input[str]]:
        """
        This is deprecated and has no effect. Do not use.
        """
        return pulumi.get(self, "metric")

    @metric.setter
    def metric(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "metric", value)


@pulumi.input_type
class LogConfigDataAccessOptionsArgs:
    def __init__(__self__, *,
                 log_mode: Optional[pulumi.Input['LogConfigDataAccessOptionsLogMode']] = None):
        """
        This is deprecated and has no effect. Do not use.
        :param pulumi.Input['LogConfigDataAccessOptionsLogMode'] log_mode: This is deprecated and has no effect. Do not use.
        """
        if log_mode is not None:
            pulumi.set(__self__, "log_mode", log_mode)

    @property
    @pulumi.getter(name="logMode")
    def log_mode(self) -> Optional[pulumi.Input['LogConfigDataAccessOptionsLogMode']]:
        """
        This is deprecated and has no effect. Do not use.
        """
        return pulumi.get(self, "log_mode")

    @log_mode.setter
    def log_mode(self, value: Optional[pulumi.Input['LogConfigDataAccessOptionsLogMode']]):
        pulumi.set(self, "log_mode", value)


@pulumi.input_type
class LogConfigArgs:
    def __init__(__self__, *,
                 cloud_audit: Optional[pulumi.Input['LogConfigCloudAuditOptionsArgs']] = None,
                 counter: Optional[pulumi.Input['LogConfigCounterOptionsArgs']] = None,
                 data_access: Optional[pulumi.Input['LogConfigDataAccessOptionsArgs']] = None):
        """
        This is deprecated and has no effect. Do not use.
        :param pulumi.Input['LogConfigCloudAuditOptionsArgs'] cloud_audit: This is deprecated and has no effect. Do not use.
        :param pulumi.Input['LogConfigCounterOptionsArgs'] counter: This is deprecated and has no effect. Do not use.
        :param pulumi.Input['LogConfigDataAccessOptionsArgs'] data_access: This is deprecated and has no effect. Do not use.
        """
        if cloud_audit is not None:
            pulumi.set(__self__, "cloud_audit", cloud_audit)
        if counter is not None:
            pulumi.set(__self__, "counter", counter)
        if data_access is not None:
            pulumi.set(__self__, "data_access", data_access)

    @property
    @pulumi.getter(name="cloudAudit")
    def cloud_audit(self) -> Optional[pulumi.Input['LogConfigCloudAuditOptionsArgs']]:
        """
        This is deprecated and has no effect. Do not use.
        """
        return pulumi.get(self, "cloud_audit")

    @cloud_audit.setter
    def cloud_audit(self, value: Optional[pulumi.Input['LogConfigCloudAuditOptionsArgs']]):
        pulumi.set(self, "cloud_audit", value)

    @property
    @pulumi.getter
    def counter(self) -> Optional[pulumi.Input['LogConfigCounterOptionsArgs']]:
        """
        This is deprecated and has no effect. Do not use.
        """
        return pulumi.get(self, "counter")

    @counter.setter
    def counter(self, value: Optional[pulumi.Input['LogConfigCounterOptionsArgs']]):
        pulumi.set(self, "counter", value)

    @property
    @pulumi.getter(name="dataAccess")
    def data_access(self) -> Optional[pulumi.Input['LogConfigDataAccessOptionsArgs']]:
        """
        This is deprecated and has no effect. Do not use.
        """
        return pulumi.get(self, "data_access")

    @data_access.setter
    def data_access(self, value: Optional[pulumi.Input['LogConfigDataAccessOptionsArgs']]):
        pulumi.set(self, "data_access", value)


@pulumi.input_type
class MetadataFilterLabelMatchArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[str]] = None):
        """
        MetadataFilter label name value pairs that are expected to match corresponding labels presented as metadata to the load balancer.
        :param pulumi.Input[str] name: Name of metadata label. The name can have a maximum length of 1024 characters and must be at least 1 character long.
        :param pulumi.Input[str] value: The value of the label must match the specified value. value can have a maximum length of 1024 characters.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of metadata label. The name can have a maximum length of 1024 characters and must be at least 1 character long.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        The value of the label must match the specified value. value can have a maximum length of 1024 characters.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class MetadataFilterArgs:
    def __init__(__self__, *,
                 filter_labels: Optional[pulumi.Input[Sequence[pulumi.Input['MetadataFilterLabelMatchArgs']]]] = None,
                 filter_match_criteria: Optional[pulumi.Input['MetadataFilterFilterMatchCriteria']] = None):
        """
        Opaque filter criteria used by load balancers to restrict routing configuration to a limited set of load balancing proxies. Proxies and sidecars involved in load balancing would typically present metadata to the load balancers that need to match criteria specified here. If a match takes place, the relevant configuration is made available to those proxies. For each metadataFilter in this list, if its filterMatchCriteria is set to MATCH_ANY, at least one of the filterLabels must match the corresponding label provided in the metadata. If its filterMatchCriteria is set to MATCH_ALL, then all of its filterLabels must match with corresponding labels provided in the metadata. An example for using metadataFilters would be: if load balancing involves Envoys, they receive routing configuration when values in metadataFilters match values supplied in of their XDS requests to loadbalancers.
        :param pulumi.Input[Sequence[pulumi.Input['MetadataFilterLabelMatchArgs']]] filter_labels: The list of label value pairs that must match labels in the provided metadata based on filterMatchCriteria This list must not be empty and can have at the most 64 entries.
        :param pulumi.Input['MetadataFilterFilterMatchCriteria'] filter_match_criteria: Specifies how individual filter label matches within the list of filterLabels and contributes toward the overall metadataFilter match. Supported values are: - MATCH_ANY: at least one of the filterLabels must have a matching label in the provided metadata. - MATCH_ALL: all filterLabels must have matching labels in the provided metadata. 
        """
        if filter_labels is not None:
            pulumi.set(__self__, "filter_labels", filter_labels)
        if filter_match_criteria is not None:
            pulumi.set(__self__, "filter_match_criteria", filter_match_criteria)

    @property
    @pulumi.getter(name="filterLabels")
    def filter_labels(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MetadataFilterLabelMatchArgs']]]]:
        """
        The list of label value pairs that must match labels in the provided metadata based on filterMatchCriteria This list must not be empty and can have at the most 64 entries.
        """
        return pulumi.get(self, "filter_labels")

    @filter_labels.setter
    def filter_labels(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MetadataFilterLabelMatchArgs']]]]):
        pulumi.set(self, "filter_labels", value)

    @property
    @pulumi.getter(name="filterMatchCriteria")
    def filter_match_criteria(self) -> Optional[pulumi.Input['MetadataFilterFilterMatchCriteria']]:
        """
        Specifies how individual filter label matches within the list of filterLabels and contributes toward the overall metadataFilter match. Supported values are: - MATCH_ANY: at least one of the filterLabels must have a matching label in the provided metadata. - MATCH_ALL: all filterLabels must have matching labels in the provided metadata. 
        """
        return pulumi.get(self, "filter_match_criteria")

    @filter_match_criteria.setter
    def filter_match_criteria(self, value: Optional[pulumi.Input['MetadataFilterFilterMatchCriteria']]):
        pulumi.set(self, "filter_match_criteria", value)


@pulumi.input_type
class MetadataItemsItemArgs:
    def __init__(__self__, *,
                 key: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[str]] = None):
        """
        Metadata
        :param pulumi.Input[str] key: Key for the metadata entry. Keys must conform to the following regexp: [a-zA-Z0-9-_]+, and be less than 128 bytes in length. This is reflected as part of a URL in the metadata server. Additionally, to avoid ambiguity, keys must not conflict with any other metadata keys for the project.
        :param pulumi.Input[str] value: Value for the metadata entry. These are free-form strings, and only have meaning as interpreted by the image running in the instance. The only restriction placed on values is that their size must be less than or equal to 262144 bytes (256 KiB).
        """
        if key is not None:
            pulumi.set(__self__, "key", key)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[str]]:
        """
        Key for the metadata entry. Keys must conform to the following regexp: [a-zA-Z0-9-_]+, and be less than 128 bytes in length. This is reflected as part of a URL in the metadata server. Additionally, to avoid ambiguity, keys must not conflict with any other metadata keys for the project.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        Value for the metadata entry. These are free-form strings, and only have meaning as interpreted by the image running in the instance. The only restriction placed on values is that their size must be less than or equal to 262144 bytes (256 KiB).
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class MetadataArgs:
    def __init__(__self__, *,
                 items: Optional[pulumi.Input[Sequence[pulumi.Input['MetadataItemsItemArgs']]]] = None):
        """
        A metadata key/value entry.
        :param pulumi.Input[Sequence[pulumi.Input['MetadataItemsItemArgs']]] items: Array of key/value pairs. The total size of all keys and values must be less than 512 KB.
        """
        if items is not None:
            pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MetadataItemsItemArgs']]]]:
        """
        Array of key/value pairs. The total size of all keys and values must be less than 512 KB.
        """
        return pulumi.get(self, "items")

    @items.setter
    def items(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MetadataItemsItemArgs']]]]):
        pulumi.set(self, "items", value)


@pulumi.input_type
class NamedPortArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[int]] = None):
        """
        The named port. For example: <"http", 80>.
        :param pulumi.Input[str] name: The name for this named port. The name must be 1-63 characters long, and comply with RFC1035.
        :param pulumi.Input[int] port: The port number, which can be a value between 1 and 65535.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if port is not None:
            pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name for this named port. The name must be 1-63 characters long, and comply with RFC1035.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        The port number, which can be a value between 1 and 65535.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)


@pulumi.input_type
class NetworkEndpointGroupAppEngineArgs:
    def __init__(__self__, *,
                 service: Optional[pulumi.Input[str]] = None,
                 url_mask: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[str]] = None):
        """
        Configuration for an App Engine network endpoint group (NEG). The service is optional, may be provided explicitly or in the URL mask. The version is optional and can only be provided explicitly or in the URL mask when service is present. Note: App Engine service must be in the same project and located in the same region as the Serverless NEG.
        :param pulumi.Input[str] service: Optional serving service. The service name is case-sensitive and must be 1-63 characters long. Example value: "default", "my-service".
        :param pulumi.Input[str] url_mask: A template to parse service and version fields from a request URL. URL mask allows for routing to multiple App Engine services without having to create multiple Network Endpoint Groups and backend services. For example, the request URLs "foo1-dot-appname.appspot.com/v1" and "foo1-dot-appname.appspot.com/v2" can be backed by the same Serverless NEG with URL mask "-dot-appname.appspot.com/". The URL mask will parse them to { service = "foo1", version = "v1" } and { service = "foo1", version = "v2" } respectively.
        :param pulumi.Input[str] version: Optional serving version. The version name is case-sensitive and must be 1-100 characters long. Example value: "v1", "v2".
        """
        if service is not None:
            pulumi.set(__self__, "service", service)
        if url_mask is not None:
            pulumi.set(__self__, "url_mask", url_mask)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def service(self) -> Optional[pulumi.Input[str]]:
        """
        Optional serving service. The service name is case-sensitive and must be 1-63 characters long. Example value: "default", "my-service".
        """
        return pulumi.get(self, "service")

    @service.setter
    def service(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service", value)

    @property
    @pulumi.getter(name="urlMask")
    def url_mask(self) -> Optional[pulumi.Input[str]]:
        """
        A template to parse service and version fields from a request URL. URL mask allows for routing to multiple App Engine services without having to create multiple Network Endpoint Groups and backend services. For example, the request URLs "foo1-dot-appname.appspot.com/v1" and "foo1-dot-appname.appspot.com/v2" can be backed by the same Serverless NEG with URL mask "-dot-appname.appspot.com/". The URL mask will parse them to { service = "foo1", version = "v1" } and { service = "foo1", version = "v2" } respectively.
        """
        return pulumi.get(self, "url_mask")

    @url_mask.setter
    def url_mask(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "url_mask", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[str]]:
        """
        Optional serving version. The version name is case-sensitive and must be 1-100 characters long. Example value: "v1", "v2".
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version", value)


@pulumi.input_type
class NetworkEndpointGroupCloudFunctionArgs:
    def __init__(__self__, *,
                 function: Optional[pulumi.Input[str]] = None,
                 url_mask: Optional[pulumi.Input[str]] = None):
        """
        Configuration for a Cloud Function network endpoint group (NEG). The function must be provided explicitly or in the URL mask. Note: Cloud Function must be in the same project and located in the same region as the Serverless NEG.
        :param pulumi.Input[str] function: A user-defined name of the Cloud Function. The function name is case-sensitive and must be 1-63 characters long. Example value: "func1".
        :param pulumi.Input[str] url_mask: A template to parse function field from a request URL. URL mask allows for routing to multiple Cloud Functions without having to create multiple Network Endpoint Groups and backend services. For example, request URLs " mydomain.com/function1" and "mydomain.com/function2" can be backed by the same Serverless NEG with URL mask "/". The URL mask will parse them to { function = "function1" } and { function = "function2" } respectively.
        """
        if function is not None:
            pulumi.set(__self__, "function", function)
        if url_mask is not None:
            pulumi.set(__self__, "url_mask", url_mask)

    @property
    @pulumi.getter
    def function(self) -> Optional[pulumi.Input[str]]:
        """
        A user-defined name of the Cloud Function. The function name is case-sensitive and must be 1-63 characters long. Example value: "func1".
        """
        return pulumi.get(self, "function")

    @function.setter
    def function(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "function", value)

    @property
    @pulumi.getter(name="urlMask")
    def url_mask(self) -> Optional[pulumi.Input[str]]:
        """
        A template to parse function field from a request URL. URL mask allows for routing to multiple Cloud Functions without having to create multiple Network Endpoint Groups and backend services. For example, request URLs " mydomain.com/function1" and "mydomain.com/function2" can be backed by the same Serverless NEG with URL mask "/". The URL mask will parse them to { function = "function1" } and { function = "function2" } respectively.
        """
        return pulumi.get(self, "url_mask")

    @url_mask.setter
    def url_mask(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "url_mask", value)


@pulumi.input_type
class NetworkEndpointGroupCloudRunArgs:
    def __init__(__self__, *,
                 service: Optional[pulumi.Input[str]] = None,
                 tag: Optional[pulumi.Input[str]] = None,
                 url_mask: Optional[pulumi.Input[str]] = None):
        """
        Configuration for a Cloud Run network endpoint group (NEG). The service must be provided explicitly or in the URL mask. The tag is optional, may be provided explicitly or in the URL mask. Note: Cloud Run service must be in the same project and located in the same region as the Serverless NEG.
        :param pulumi.Input[str] service: Cloud Run service is the main resource of Cloud Run. The service must be 1-63 characters long, and comply with RFC1035. Example value: "run-service".
        :param pulumi.Input[str] tag: Optional Cloud Run tag represents the "named-revision" to provide additional fine-grained traffic routing information. The tag must be 1-63 characters long, and comply with RFC1035. Example value: "revision-0010".
        :param pulumi.Input[str] url_mask: A template to parse service and tag fields from a request URL. URL mask allows for routing to multiple Run services without having to create multiple network endpoint groups and backend services. For example, request URLs "foo1.domain.com/bar1" and "foo1.domain.com/bar2" can be backed by the same Serverless Network Endpoint Group (NEG) with URL mask ".domain.com/". The URL mask will parse them to { service="bar1", tag="foo1" } and { service="bar2", tag="foo2" } respectively.
        """
        if service is not None:
            pulumi.set(__self__, "service", service)
        if tag is not None:
            pulumi.set(__self__, "tag", tag)
        if url_mask is not None:
            pulumi.set(__self__, "url_mask", url_mask)

    @property
    @pulumi.getter
    def service(self) -> Optional[pulumi.Input[str]]:
        """
        Cloud Run service is the main resource of Cloud Run. The service must be 1-63 characters long, and comply with RFC1035. Example value: "run-service".
        """
        return pulumi.get(self, "service")

    @service.setter
    def service(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service", value)

    @property
    @pulumi.getter
    def tag(self) -> Optional[pulumi.Input[str]]:
        """
        Optional Cloud Run tag represents the "named-revision" to provide additional fine-grained traffic routing information. The tag must be 1-63 characters long, and comply with RFC1035. Example value: "revision-0010".
        """
        return pulumi.get(self, "tag")

    @tag.setter
    def tag(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tag", value)

    @property
    @pulumi.getter(name="urlMask")
    def url_mask(self) -> Optional[pulumi.Input[str]]:
        """
        A template to parse service and tag fields from a request URL. URL mask allows for routing to multiple Run services without having to create multiple network endpoint groups and backend services. For example, request URLs "foo1.domain.com/bar1" and "foo1.domain.com/bar2" can be backed by the same Serverless Network Endpoint Group (NEG) with URL mask ".domain.com/". The URL mask will parse them to { service="bar1", tag="foo1" } and { service="bar2", tag="foo2" } respectively.
        """
        return pulumi.get(self, "url_mask")

    @url_mask.setter
    def url_mask(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "url_mask", value)


@pulumi.input_type
class NetworkEndpointGroupServerlessDeploymentArgs:
    def __init__(__self__, *,
                 platform: Optional[pulumi.Input[str]] = None,
                 resource: Optional[pulumi.Input[str]] = None,
                 url_mask: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[str]] = None):
        """
        Configuration for a serverless network endpoint group (NEG). The platform must be provided. Note: The target backend service must be in the same project and located in the same region as the Serverless NEG.
        :param pulumi.Input[str] platform: The platform of the backend target(s) of this NEG. Possible values include: 1. API Gateway: apigateway.googleapis.com 2. App Engine: appengine.googleapis.com 3. Cloud Functions: cloudfunctions.googleapis.com 4. Cloud Run: run.googleapis.com 
        :param pulumi.Input[str] resource: The user-defined name of the workload/instance. This value must be provided explicitly or in the urlMask. The resource identified by this value is platform-specific and is as follows: 1. API Gateway: The gateway ID 2. App Engine: The service name 3. Cloud Functions: The function name 4. Cloud Run: The service name 
        :param pulumi.Input[str] url_mask: A template to parse platform-specific fields from a request URL. URL mask allows for routing to multiple resources on the same serverless platform without having to create multiple Network Endpoint Groups and backend resources. The fields parsed by this template are platform-specific and are as follows: 1. API Gateway: The gateway ID 2. App Engine: The service and version 3. Cloud Functions: The function name 4. Cloud Run: The service and tag 
        :param pulumi.Input[str] version: The optional resource version. The version identified by this value is platform-specific and is follows: 1. API Gateway: Unused 2. App Engine: The service version 3. Cloud Functions: Unused 4. Cloud Run: The service tag 
        """
        if platform is not None:
            pulumi.set(__self__, "platform", platform)
        if resource is not None:
            pulumi.set(__self__, "resource", resource)
        if url_mask is not None:
            pulumi.set(__self__, "url_mask", url_mask)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def platform(self) -> Optional[pulumi.Input[str]]:
        """
        The platform of the backend target(s) of this NEG. Possible values include: 1. API Gateway: apigateway.googleapis.com 2. App Engine: appengine.googleapis.com 3. Cloud Functions: cloudfunctions.googleapis.com 4. Cloud Run: run.googleapis.com 
        """
        return pulumi.get(self, "platform")

    @platform.setter
    def platform(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "platform", value)

    @property
    @pulumi.getter
    def resource(self) -> Optional[pulumi.Input[str]]:
        """
        The user-defined name of the workload/instance. This value must be provided explicitly or in the urlMask. The resource identified by this value is platform-specific and is as follows: 1. API Gateway: The gateway ID 2. App Engine: The service name 3. Cloud Functions: The function name 4. Cloud Run: The service name 
        """
        return pulumi.get(self, "resource")

    @resource.setter
    def resource(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource", value)

    @property
    @pulumi.getter(name="urlMask")
    def url_mask(self) -> Optional[pulumi.Input[str]]:
        """
        A template to parse platform-specific fields from a request URL. URL mask allows for routing to multiple resources on the same serverless platform without having to create multiple Network Endpoint Groups and backend resources. The fields parsed by this template are platform-specific and are as follows: 1. API Gateway: The gateway ID 2. App Engine: The service and version 3. Cloud Functions: The function name 4. Cloud Run: The service and tag 
        """
        return pulumi.get(self, "url_mask")

    @url_mask.setter
    def url_mask(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "url_mask", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[str]]:
        """
        The optional resource version. The version identified by this value is platform-specific and is follows: 1. API Gateway: Unused 2. App Engine: The service version 3. Cloud Functions: Unused 4. Cloud Run: The service tag 
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version", value)


@pulumi.input_type
class NetworkInterfaceArgs:
    def __init__(__self__, *,
                 access_configs: Optional[pulumi.Input[Sequence[pulumi.Input['AccessConfigArgs']]]] = None,
                 alias_ip_ranges: Optional[pulumi.Input[Sequence[pulumi.Input['AliasIpRangeArgs']]]] = None,
                 ipv6_access_configs: Optional[pulumi.Input[Sequence[pulumi.Input['AccessConfigArgs']]]] = None,
                 ipv6_address: Optional[pulumi.Input[str]] = None,
                 network: Optional[pulumi.Input[str]] = None,
                 network_ip: Optional[pulumi.Input[str]] = None,
                 nic_type: Optional[pulumi.Input['NetworkInterfaceNicType']] = None,
                 queue_count: Optional[pulumi.Input[int]] = None,
                 stack_type: Optional[pulumi.Input['NetworkInterfaceStackType']] = None,
                 subnetwork: Optional[pulumi.Input[str]] = None):
        """
        A network interface resource attached to an instance.
        :param pulumi.Input[Sequence[pulumi.Input['AccessConfigArgs']]] access_configs: An array of configurations for this interface. Currently, only one access config, ONE_TO_ONE_NAT, is supported. If there are no accessConfigs specified, then this instance will have no external internet access.
        :param pulumi.Input[Sequence[pulumi.Input['AliasIpRangeArgs']]] alias_ip_ranges: An array of alias IP ranges for this network interface. You can only specify this field for network interfaces in VPC networks.
        :param pulumi.Input[Sequence[pulumi.Input['AccessConfigArgs']]] ipv6_access_configs: An array of IPv6 access configurations for this interface. Currently, only one IPv6 access config, DIRECT_IPV6, is supported. If there is no ipv6AccessConfig specified, then this instance will have no external IPv6 Internet access.
        :param pulumi.Input[str] ipv6_address: An IPv6 internal network address for this network interface.
        :param pulumi.Input[str] network: URL of the VPC network resource for this instance. When creating an instance, if neither the network nor the subnetwork is specified, the default network global/networks/default is used. If the selected project doesn't have the default network, you must specify a network or subnet. If the network is not specified but the subnetwork is specified, the network is inferred. If you specify this property, you can specify the network as a full or partial URL. For example, the following are all valid URLs: - https://www.googleapis.com/compute/v1/projects/project/global/networks/ network - projects/project/global/networks/network - global/networks/default 
        :param pulumi.Input[str] network_ip: An IPv4 internal IP address to assign to the instance for this network interface. If not specified by the user, an unused internal IP is assigned by the system.
        :param pulumi.Input['NetworkInterfaceNicType'] nic_type: The type of vNIC to be used on this interface. This may be gVNIC or VirtioNet.
        :param pulumi.Input[int] queue_count: The networking queue count that's specified by users for the network interface. Both Rx and Tx queues will be set to this number. It'll be empty if not specified by the users.
        :param pulumi.Input['NetworkInterfaceStackType'] stack_type: The stack type for this network interface to identify whether the IPv6 feature is enabled or not. If not specified, IPV4_ONLY will be used. This field can be both set at instance creation and update network interface operations.
        :param pulumi.Input[str] subnetwork: The URL of the Subnetwork resource for this instance. If the network resource is in legacy mode, do not specify this field. If the network is in auto subnet mode, specifying the subnetwork is optional. If the network is in custom subnet mode, specifying the subnetwork is required. If you specify this field, you can specify the subnetwork as a full or partial URL. For example, the following are all valid URLs: - https://www.googleapis.com/compute/v1/projects/project/regions/region /subnetworks/subnetwork - regions/region/subnetworks/subnetwork 
        """
        if access_configs is not None:
            pulumi.set(__self__, "access_configs", access_configs)
        if alias_ip_ranges is not None:
            pulumi.set(__self__, "alias_ip_ranges", alias_ip_ranges)
        if ipv6_access_configs is not None:
            pulumi.set(__self__, "ipv6_access_configs", ipv6_access_configs)
        if ipv6_address is not None:
            pulumi.set(__self__, "ipv6_address", ipv6_address)
        if network is not None:
            pulumi.set(__self__, "network", network)
        if network_ip is not None:
            pulumi.set(__self__, "network_ip", network_ip)
        if nic_type is not None:
            pulumi.set(__self__, "nic_type", nic_type)
        if queue_count is not None:
            pulumi.set(__self__, "queue_count", queue_count)
        if stack_type is not None:
            pulumi.set(__self__, "stack_type", stack_type)
        if subnetwork is not None:
            pulumi.set(__self__, "subnetwork", subnetwork)

    @property
    @pulumi.getter(name="accessConfigs")
    def access_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AccessConfigArgs']]]]:
        """
        An array of configurations for this interface. Currently, only one access config, ONE_TO_ONE_NAT, is supported. If there are no accessConfigs specified, then this instance will have no external internet access.
        """
        return pulumi.get(self, "access_configs")

    @access_configs.setter
    def access_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AccessConfigArgs']]]]):
        pulumi.set(self, "access_configs", value)

    @property
    @pulumi.getter(name="aliasIpRanges")
    def alias_ip_ranges(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AliasIpRangeArgs']]]]:
        """
        An array of alias IP ranges for this network interface. You can only specify this field for network interfaces in VPC networks.
        """
        return pulumi.get(self, "alias_ip_ranges")

    @alias_ip_ranges.setter
    def alias_ip_ranges(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AliasIpRangeArgs']]]]):
        pulumi.set(self, "alias_ip_ranges", value)

    @property
    @pulumi.getter(name="ipv6AccessConfigs")
    def ipv6_access_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AccessConfigArgs']]]]:
        """
        An array of IPv6 access configurations for this interface. Currently, only one IPv6 access config, DIRECT_IPV6, is supported. If there is no ipv6AccessConfig specified, then this instance will have no external IPv6 Internet access.
        """
        return pulumi.get(self, "ipv6_access_configs")

    @ipv6_access_configs.setter
    def ipv6_access_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AccessConfigArgs']]]]):
        pulumi.set(self, "ipv6_access_configs", value)

    @property
    @pulumi.getter(name="ipv6Address")
    def ipv6_address(self) -> Optional[pulumi.Input[str]]:
        """
        An IPv6 internal network address for this network interface.
        """
        return pulumi.get(self, "ipv6_address")

    @ipv6_address.setter
    def ipv6_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ipv6_address", value)

    @property
    @pulumi.getter
    def network(self) -> Optional[pulumi.Input[str]]:
        """
        URL of the VPC network resource for this instance. When creating an instance, if neither the network nor the subnetwork is specified, the default network global/networks/default is used. If the selected project doesn't have the default network, you must specify a network or subnet. If the network is not specified but the subnetwork is specified, the network is inferred. If you specify this property, you can specify the network as a full or partial URL. For example, the following are all valid URLs: - https://www.googleapis.com/compute/v1/projects/project/global/networks/ network - projects/project/global/networks/network - global/networks/default 
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network", value)

    @property
    @pulumi.getter(name="networkIP")
    def network_ip(self) -> Optional[pulumi.Input[str]]:
        """
        An IPv4 internal IP address to assign to the instance for this network interface. If not specified by the user, an unused internal IP is assigned by the system.
        """
        return pulumi.get(self, "network_ip")

    @network_ip.setter
    def network_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network_ip", value)

    @property
    @pulumi.getter(name="nicType")
    def nic_type(self) -> Optional[pulumi.Input['NetworkInterfaceNicType']]:
        """
        The type of vNIC to be used on this interface. This may be gVNIC or VirtioNet.
        """
        return pulumi.get(self, "nic_type")

    @nic_type.setter
    def nic_type(self, value: Optional[pulumi.Input['NetworkInterfaceNicType']]):
        pulumi.set(self, "nic_type", value)

    @property
    @pulumi.getter(name="queueCount")
    def queue_count(self) -> Optional[pulumi.Input[int]]:
        """
        The networking queue count that's specified by users for the network interface. Both Rx and Tx queues will be set to this number. It'll be empty if not specified by the users.
        """
        return pulumi.get(self, "queue_count")

    @queue_count.setter
    def queue_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "queue_count", value)

    @property
    @pulumi.getter(name="stackType")
    def stack_type(self) -> Optional[pulumi.Input['NetworkInterfaceStackType']]:
        """
        The stack type for this network interface to identify whether the IPv6 feature is enabled or not. If not specified, IPV4_ONLY will be used. This field can be both set at instance creation and update network interface operations.
        """
        return pulumi.get(self, "stack_type")

    @stack_type.setter
    def stack_type(self, value: Optional[pulumi.Input['NetworkInterfaceStackType']]):
        pulumi.set(self, "stack_type", value)

    @property
    @pulumi.getter
    def subnetwork(self) -> Optional[pulumi.Input[str]]:
        """
        The URL of the Subnetwork resource for this instance. If the network resource is in legacy mode, do not specify this field. If the network is in auto subnet mode, specifying the subnetwork is optional. If the network is in custom subnet mode, specifying the subnetwork is required. If you specify this field, you can specify the subnetwork as a full or partial URL. For example, the following are all valid URLs: - https://www.googleapis.com/compute/v1/projects/project/regions/region /subnetworks/subnetwork - regions/region/subnetworks/subnetwork 
        """
        return pulumi.get(self, "subnetwork")

    @subnetwork.setter
    def subnetwork(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnetwork", value)


@pulumi.input_type
class NetworkPerformanceConfigArgs:
    def __init__(__self__, *,
                 total_egress_bandwidth_tier: Optional[pulumi.Input['NetworkPerformanceConfigTotalEgressBandwidthTier']] = None):
        if total_egress_bandwidth_tier is not None:
            pulumi.set(__self__, "total_egress_bandwidth_tier", total_egress_bandwidth_tier)

    @property
    @pulumi.getter(name="totalEgressBandwidthTier")
    def total_egress_bandwidth_tier(self) -> Optional[pulumi.Input['NetworkPerformanceConfigTotalEgressBandwidthTier']]:
        return pulumi.get(self, "total_egress_bandwidth_tier")

    @total_egress_bandwidth_tier.setter
    def total_egress_bandwidth_tier(self, value: Optional[pulumi.Input['NetworkPerformanceConfigTotalEgressBandwidthTier']]):
        pulumi.set(self, "total_egress_bandwidth_tier", value)


@pulumi.input_type
class NetworkRoutingConfigArgs:
    def __init__(__self__, *,
                 routing_mode: Optional[pulumi.Input['NetworkRoutingConfigRoutingMode']] = None):
        """
        A routing configuration attached to a network resource. The message includes the list of routers associated with the network, and a flag indicating the type of routing behavior to enforce network-wide.
        :param pulumi.Input['NetworkRoutingConfigRoutingMode'] routing_mode: The network-wide routing mode to use. If set to REGIONAL, this network's Cloud Routers will only advertise routes with subnets of this network in the same region as the router. If set to GLOBAL, this network's Cloud Routers will advertise routes with all subnets of this network, across regions.
        """
        if routing_mode is not None:
            pulumi.set(__self__, "routing_mode", routing_mode)

    @property
    @pulumi.getter(name="routingMode")
    def routing_mode(self) -> Optional[pulumi.Input['NetworkRoutingConfigRoutingMode']]:
        """
        The network-wide routing mode to use. If set to REGIONAL, this network's Cloud Routers will only advertise routes with subnets of this network in the same region as the router. If set to GLOBAL, this network's Cloud Routers will advertise routes with all subnets of this network, across regions.
        """
        return pulumi.get(self, "routing_mode")

    @routing_mode.setter
    def routing_mode(self, value: Optional[pulumi.Input['NetworkRoutingConfigRoutingMode']]):
        pulumi.set(self, "routing_mode", value)


@pulumi.input_type
class NodeGroupAutoscalingPolicyArgs:
    def __init__(__self__, *,
                 max_nodes: Optional[pulumi.Input[int]] = None,
                 min_nodes: Optional[pulumi.Input[int]] = None,
                 mode: Optional[pulumi.Input['NodeGroupAutoscalingPolicyMode']] = None):
        """
        :param pulumi.Input[int] max_nodes: The maximum number of nodes that the group should have. Must be set if autoscaling is enabled. Maximum value allowed is 100.
        :param pulumi.Input[int] min_nodes: The minimum number of nodes that the group should have.
        :param pulumi.Input['NodeGroupAutoscalingPolicyMode'] mode: The autoscaling mode. Set to one of: ON, OFF, or ONLY_SCALE_OUT. For more information, see Autoscaler modes.
        """
        if max_nodes is not None:
            pulumi.set(__self__, "max_nodes", max_nodes)
        if min_nodes is not None:
            pulumi.set(__self__, "min_nodes", min_nodes)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)

    @property
    @pulumi.getter(name="maxNodes")
    def max_nodes(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum number of nodes that the group should have. Must be set if autoscaling is enabled. Maximum value allowed is 100.
        """
        return pulumi.get(self, "max_nodes")

    @max_nodes.setter
    def max_nodes(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_nodes", value)

    @property
    @pulumi.getter(name="minNodes")
    def min_nodes(self) -> Optional[pulumi.Input[int]]:
        """
        The minimum number of nodes that the group should have.
        """
        return pulumi.get(self, "min_nodes")

    @min_nodes.setter
    def min_nodes(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_nodes", value)

    @property
    @pulumi.getter
    def mode(self) -> Optional[pulumi.Input['NodeGroupAutoscalingPolicyMode']]:
        """
        The autoscaling mode. Set to one of: ON, OFF, or ONLY_SCALE_OUT. For more information, see Autoscaler modes.
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: Optional[pulumi.Input['NodeGroupAutoscalingPolicyMode']]):
        pulumi.set(self, "mode", value)


@pulumi.input_type
class NodeGroupMaintenanceWindowArgs:
    def __init__(__self__, *,
                 start_time: Optional[pulumi.Input[str]] = None):
        """
        Time window specified for daily maintenance operations. GCE's internal maintenance will be performed within this window.
        :param pulumi.Input[str] start_time: Start time of the window. This must be in UTC format that resolves to one of 00:00, 04:00, 08:00, 12:00, 16:00, or 20:00. For example, both 13:00-5 and 08:00 are valid.
        """
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[pulumi.Input[str]]:
        """
        Start time of the window. This must be in UTC format that resolves to one of 00:00, 04:00, 08:00, 12:00, 16:00, or 20:00. For example, both 13:00-5 and 08:00 are valid.
        """
        return pulumi.get(self, "start_time")

    @start_time.setter
    def start_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "start_time", value)


@pulumi.input_type
class NodeTemplateNodeTypeFlexibilityArgs:
    def __init__(__self__, *,
                 cpus: Optional[pulumi.Input[str]] = None,
                 local_ssd: Optional[pulumi.Input[str]] = None,
                 memory: Optional[pulumi.Input[str]] = None):
        if cpus is not None:
            pulumi.set(__self__, "cpus", cpus)
        if local_ssd is not None:
            pulumi.set(__self__, "local_ssd", local_ssd)
        if memory is not None:
            pulumi.set(__self__, "memory", memory)

    @property
    @pulumi.getter
    def cpus(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "cpus")

    @cpus.setter
    def cpus(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cpus", value)

    @property
    @pulumi.getter(name="localSsd")
    def local_ssd(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "local_ssd")

    @local_ssd.setter
    def local_ssd(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "local_ssd", value)

    @property
    @pulumi.getter
    def memory(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "memory")

    @memory.setter
    def memory(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "memory", value)


@pulumi.input_type
class NotificationEndpointGrpcSettingsArgs:
    def __init__(__self__, *,
                 authority: Optional[pulumi.Input[str]] = None,
                 endpoint: Optional[pulumi.Input[str]] = None,
                 payload_name: Optional[pulumi.Input[str]] = None,
                 resend_interval: Optional[pulumi.Input['DurationArgs']] = None,
                 retry_duration_sec: Optional[pulumi.Input[int]] = None):
        """
        Represents a gRPC setting that describes one gRPC notification endpoint and the retry duration attempting to send notification to this endpoint.
        :param pulumi.Input[str] authority: Optional. If specified, this field is used to set the authority header by the sender of notifications. See https://tools.ietf.org/html/rfc7540#section-8.1.2.3
        :param pulumi.Input[str] endpoint: Endpoint to which gRPC notifications are sent. This must be a valid gRPCLB DNS name.
        :param pulumi.Input[str] payload_name: Optional. If specified, this field is used to populate the "name" field in gRPC requests.
        :param pulumi.Input['DurationArgs'] resend_interval: Optional. This field is used to configure how often to send a full update of all non-healthy backends. If unspecified, full updates are not sent. If specified, must be in the range between 600 seconds to 3600 seconds. Nanos are disallowed.
        :param pulumi.Input[int] retry_duration_sec: How much time (in seconds) is spent attempting notification retries until a successful response is received. Default is 30s. Limit is 20m (1200s). Must be a positive number.
        """
        if authority is not None:
            pulumi.set(__self__, "authority", authority)
        if endpoint is not None:
            pulumi.set(__self__, "endpoint", endpoint)
        if payload_name is not None:
            pulumi.set(__self__, "payload_name", payload_name)
        if resend_interval is not None:
            pulumi.set(__self__, "resend_interval", resend_interval)
        if retry_duration_sec is not None:
            pulumi.set(__self__, "retry_duration_sec", retry_duration_sec)

    @property
    @pulumi.getter
    def authority(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. If specified, this field is used to set the authority header by the sender of notifications. See https://tools.ietf.org/html/rfc7540#section-8.1.2.3
        """
        return pulumi.get(self, "authority")

    @authority.setter
    def authority(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "authority", value)

    @property
    @pulumi.getter
    def endpoint(self) -> Optional[pulumi.Input[str]]:
        """
        Endpoint to which gRPC notifications are sent. This must be a valid gRPCLB DNS name.
        """
        return pulumi.get(self, "endpoint")

    @endpoint.setter
    def endpoint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "endpoint", value)

    @property
    @pulumi.getter(name="payloadName")
    def payload_name(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. If specified, this field is used to populate the "name" field in gRPC requests.
        """
        return pulumi.get(self, "payload_name")

    @payload_name.setter
    def payload_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "payload_name", value)

    @property
    @pulumi.getter(name="resendInterval")
    def resend_interval(self) -> Optional[pulumi.Input['DurationArgs']]:
        """
        Optional. This field is used to configure how often to send a full update of all non-healthy backends. If unspecified, full updates are not sent. If specified, must be in the range between 600 seconds to 3600 seconds. Nanos are disallowed.
        """
        return pulumi.get(self, "resend_interval")

    @resend_interval.setter
    def resend_interval(self, value: Optional[pulumi.Input['DurationArgs']]):
        pulumi.set(self, "resend_interval", value)

    @property
    @pulumi.getter(name="retryDurationSec")
    def retry_duration_sec(self) -> Optional[pulumi.Input[int]]:
        """
        How much time (in seconds) is spent attempting notification retries until a successful response is received. Default is 30s. Limit is 20m (1200s). Must be a positive number.
        """
        return pulumi.get(self, "retry_duration_sec")

    @retry_duration_sec.setter
    def retry_duration_sec(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "retry_duration_sec", value)


@pulumi.input_type
class OutlierDetectionArgs:
    def __init__(__self__, *,
                 base_ejection_time: Optional[pulumi.Input['DurationArgs']] = None,
                 consecutive_errors: Optional[pulumi.Input[int]] = None,
                 consecutive_gateway_failure: Optional[pulumi.Input[int]] = None,
                 enforcing_consecutive_errors: Optional[pulumi.Input[int]] = None,
                 enforcing_consecutive_gateway_failure: Optional[pulumi.Input[int]] = None,
                 enforcing_success_rate: Optional[pulumi.Input[int]] = None,
                 interval: Optional[pulumi.Input['DurationArgs']] = None,
                 max_ejection_percent: Optional[pulumi.Input[int]] = None,
                 success_rate_minimum_hosts: Optional[pulumi.Input[int]] = None,
                 success_rate_request_volume: Optional[pulumi.Input[int]] = None,
                 success_rate_stdev_factor: Optional[pulumi.Input[int]] = None):
        """
        Settings controlling the eviction of unhealthy hosts from the load balancing pool for the backend service.
        :param pulumi.Input['DurationArgs'] base_ejection_time: The base time that a host is ejected for. The real ejection time is equal to the base ejection time multiplied by the number of times the host has been ejected. Defaults to 30000ms or 30s.
        :param pulumi.Input[int] consecutive_errors: Number of errors before a host is ejected from the connection pool. When the backend host is accessed over HTTP, a 5xx return code qualifies as an error. Defaults to 5.
        :param pulumi.Input[int] consecutive_gateway_failure: The number of consecutive gateway failures (502, 503, 504 status or connection errors that are mapped to one of those status codes) before a consecutive gateway failure ejection occurs. Defaults to 3.
        :param pulumi.Input[int] enforcing_consecutive_errors: The percentage chance that a host will be actually ejected when an outlier status is detected through consecutive 5xx. This setting can be used to disable ejection or to ramp it up slowly. Defaults to 0.
        :param pulumi.Input[int] enforcing_consecutive_gateway_failure: The percentage chance that a host will be actually ejected when an outlier status is detected through consecutive gateway failures. This setting can be used to disable ejection or to ramp it up slowly. Defaults to 100.
        :param pulumi.Input[int] enforcing_success_rate: The percentage chance that a host will be actually ejected when an outlier status is detected through success rate statistics. This setting can be used to disable ejection or to ramp it up slowly. Defaults to 100.
        :param pulumi.Input['DurationArgs'] interval: Time interval between ejection analysis sweeps. This can result in both new ejections as well as hosts being returned to service. Defaults to 1 second.
        :param pulumi.Input[int] max_ejection_percent: Maximum percentage of hosts in the load balancing pool for the backend service that can be ejected. Defaults to 50%.
        :param pulumi.Input[int] success_rate_minimum_hosts: The number of hosts in a cluster that must have enough request volume to detect success rate outliers. If the number of hosts is less than this setting, outlier detection via success rate statistics is not performed for any host in the cluster. Defaults to 5.
        :param pulumi.Input[int] success_rate_request_volume: The minimum number of total requests that must be collected in one interval (as defined by the interval duration above) to include this host in success rate based outlier detection. If the volume is lower than this setting, outlier detection via success rate statistics is not performed for that host. Defaults to 100.
        :param pulumi.Input[int] success_rate_stdev_factor: This factor is used to determine the ejection threshold for success rate outlier ejection. The ejection threshold is the difference between the mean success rate, and the product of this factor and the standard deviation of the mean success rate: mean - (stdev * success_rate_stdev_factor). This factor is divided by a thousand to get a double. That is, if the desired factor is 1.9, the runtime value should be 1900. Defaults to 1900.
        """
        if base_ejection_time is not None:
            pulumi.set(__self__, "base_ejection_time", base_ejection_time)
        if consecutive_errors is not None:
            pulumi.set(__self__, "consecutive_errors", consecutive_errors)
        if consecutive_gateway_failure is not None:
            pulumi.set(__self__, "consecutive_gateway_failure", consecutive_gateway_failure)
        if enforcing_consecutive_errors is not None:
            pulumi.set(__self__, "enforcing_consecutive_errors", enforcing_consecutive_errors)
        if enforcing_consecutive_gateway_failure is not None:
            pulumi.set(__self__, "enforcing_consecutive_gateway_failure", enforcing_consecutive_gateway_failure)
        if enforcing_success_rate is not None:
            pulumi.set(__self__, "enforcing_success_rate", enforcing_success_rate)
        if interval is not None:
            pulumi.set(__self__, "interval", interval)
        if max_ejection_percent is not None:
            pulumi.set(__self__, "max_ejection_percent", max_ejection_percent)
        if success_rate_minimum_hosts is not None:
            pulumi.set(__self__, "success_rate_minimum_hosts", success_rate_minimum_hosts)
        if success_rate_request_volume is not None:
            pulumi.set(__self__, "success_rate_request_volume", success_rate_request_volume)
        if success_rate_stdev_factor is not None:
            pulumi.set(__self__, "success_rate_stdev_factor", success_rate_stdev_factor)

    @property
    @pulumi.getter(name="baseEjectionTime")
    def base_ejection_time(self) -> Optional[pulumi.Input['DurationArgs']]:
        """
        The base time that a host is ejected for. The real ejection time is equal to the base ejection time multiplied by the number of times the host has been ejected. Defaults to 30000ms or 30s.
        """
        return pulumi.get(self, "base_ejection_time")

    @base_ejection_time.setter
    def base_ejection_time(self, value: Optional[pulumi.Input['DurationArgs']]):
        pulumi.set(self, "base_ejection_time", value)

    @property
    @pulumi.getter(name="consecutiveErrors")
    def consecutive_errors(self) -> Optional[pulumi.Input[int]]:
        """
        Number of errors before a host is ejected from the connection pool. When the backend host is accessed over HTTP, a 5xx return code qualifies as an error. Defaults to 5.
        """
        return pulumi.get(self, "consecutive_errors")

    @consecutive_errors.setter
    def consecutive_errors(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "consecutive_errors", value)

    @property
    @pulumi.getter(name="consecutiveGatewayFailure")
    def consecutive_gateway_failure(self) -> Optional[pulumi.Input[int]]:
        """
        The number of consecutive gateway failures (502, 503, 504 status or connection errors that are mapped to one of those status codes) before a consecutive gateway failure ejection occurs. Defaults to 3.
        """
        return pulumi.get(self, "consecutive_gateway_failure")

    @consecutive_gateway_failure.setter
    def consecutive_gateway_failure(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "consecutive_gateway_failure", value)

    @property
    @pulumi.getter(name="enforcingConsecutiveErrors")
    def enforcing_consecutive_errors(self) -> Optional[pulumi.Input[int]]:
        """
        The percentage chance that a host will be actually ejected when an outlier status is detected through consecutive 5xx. This setting can be used to disable ejection or to ramp it up slowly. Defaults to 0.
        """
        return pulumi.get(self, "enforcing_consecutive_errors")

    @enforcing_consecutive_errors.setter
    def enforcing_consecutive_errors(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "enforcing_consecutive_errors", value)

    @property
    @pulumi.getter(name="enforcingConsecutiveGatewayFailure")
    def enforcing_consecutive_gateway_failure(self) -> Optional[pulumi.Input[int]]:
        """
        The percentage chance that a host will be actually ejected when an outlier status is detected through consecutive gateway failures. This setting can be used to disable ejection or to ramp it up slowly. Defaults to 100.
        """
        return pulumi.get(self, "enforcing_consecutive_gateway_failure")

    @enforcing_consecutive_gateway_failure.setter
    def enforcing_consecutive_gateway_failure(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "enforcing_consecutive_gateway_failure", value)

    @property
    @pulumi.getter(name="enforcingSuccessRate")
    def enforcing_success_rate(self) -> Optional[pulumi.Input[int]]:
        """
        The percentage chance that a host will be actually ejected when an outlier status is detected through success rate statistics. This setting can be used to disable ejection or to ramp it up slowly. Defaults to 100.
        """
        return pulumi.get(self, "enforcing_success_rate")

    @enforcing_success_rate.setter
    def enforcing_success_rate(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "enforcing_success_rate", value)

    @property
    @pulumi.getter
    def interval(self) -> Optional[pulumi.Input['DurationArgs']]:
        """
        Time interval between ejection analysis sweeps. This can result in both new ejections as well as hosts being returned to service. Defaults to 1 second.
        """
        return pulumi.get(self, "interval")

    @interval.setter
    def interval(self, value: Optional[pulumi.Input['DurationArgs']]):
        pulumi.set(self, "interval", value)

    @property
    @pulumi.getter(name="maxEjectionPercent")
    def max_ejection_percent(self) -> Optional[pulumi.Input[int]]:
        """
        Maximum percentage of hosts in the load balancing pool for the backend service that can be ejected. Defaults to 50%.
        """
        return pulumi.get(self, "max_ejection_percent")

    @max_ejection_percent.setter
    def max_ejection_percent(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_ejection_percent", value)

    @property
    @pulumi.getter(name="successRateMinimumHosts")
    def success_rate_minimum_hosts(self) -> Optional[pulumi.Input[int]]:
        """
        The number of hosts in a cluster that must have enough request volume to detect success rate outliers. If the number of hosts is less than this setting, outlier detection via success rate statistics is not performed for any host in the cluster. Defaults to 5.
        """
        return pulumi.get(self, "success_rate_minimum_hosts")

    @success_rate_minimum_hosts.setter
    def success_rate_minimum_hosts(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "success_rate_minimum_hosts", value)

    @property
    @pulumi.getter(name="successRateRequestVolume")
    def success_rate_request_volume(self) -> Optional[pulumi.Input[int]]:
        """
        The minimum number of total requests that must be collected in one interval (as defined by the interval duration above) to include this host in success rate based outlier detection. If the volume is lower than this setting, outlier detection via success rate statistics is not performed for that host. Defaults to 100.
        """
        return pulumi.get(self, "success_rate_request_volume")

    @success_rate_request_volume.setter
    def success_rate_request_volume(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "success_rate_request_volume", value)

    @property
    @pulumi.getter(name="successRateStdevFactor")
    def success_rate_stdev_factor(self) -> Optional[pulumi.Input[int]]:
        """
        This factor is used to determine the ejection threshold for success rate outlier ejection. The ejection threshold is the difference between the mean success rate, and the product of this factor and the standard deviation of the mean success rate: mean - (stdev * success_rate_stdev_factor). This factor is divided by a thousand to get a double. That is, if the desired factor is 1.9, the runtime value should be 1900. Defaults to 1900.
        """
        return pulumi.get(self, "success_rate_stdev_factor")

    @success_rate_stdev_factor.setter
    def success_rate_stdev_factor(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "success_rate_stdev_factor", value)


@pulumi.input_type
class PacketMirroringFilterArgs:
    def __init__(__self__, *,
                 cidr_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 direction: Optional[pulumi.Input['PacketMirroringFilterDirection']] = None,
                 ip_protocols: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] cidr_ranges: IP CIDR ranges that apply as filter on the source (ingress) or destination (egress) IP in the IP header. Only IPv4 is supported. If no ranges are specified, all traffic that matches the specified IPProtocols is mirrored. If neither cidrRanges nor IPProtocols is specified, all traffic is mirrored.
        :param pulumi.Input['PacketMirroringFilterDirection'] direction: Direction of traffic to mirror, either INGRESS, EGRESS, or BOTH. The default is BOTH.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ip_protocols: Protocols that apply as filter on mirrored traffic. If no protocols are specified, all traffic that matches the specified CIDR ranges is mirrored. If neither cidrRanges nor IPProtocols is specified, all traffic is mirrored.
        """
        if cidr_ranges is not None:
            pulumi.set(__self__, "cidr_ranges", cidr_ranges)
        if direction is not None:
            pulumi.set(__self__, "direction", direction)
        if ip_protocols is not None:
            pulumi.set(__self__, "ip_protocols", ip_protocols)

    @property
    @pulumi.getter(name="cidrRanges")
    def cidr_ranges(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        IP CIDR ranges that apply as filter on the source (ingress) or destination (egress) IP in the IP header. Only IPv4 is supported. If no ranges are specified, all traffic that matches the specified IPProtocols is mirrored. If neither cidrRanges nor IPProtocols is specified, all traffic is mirrored.
        """
        return pulumi.get(self, "cidr_ranges")

    @cidr_ranges.setter
    def cidr_ranges(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "cidr_ranges", value)

    @property
    @pulumi.getter
    def direction(self) -> Optional[pulumi.Input['PacketMirroringFilterDirection']]:
        """
        Direction of traffic to mirror, either INGRESS, EGRESS, or BOTH. The default is BOTH.
        """
        return pulumi.get(self, "direction")

    @direction.setter
    def direction(self, value: Optional[pulumi.Input['PacketMirroringFilterDirection']]):
        pulumi.set(self, "direction", value)

    @property
    @pulumi.getter(name="ipProtocols")
    def ip_protocols(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Protocols that apply as filter on mirrored traffic. If no protocols are specified, all traffic that matches the specified CIDR ranges is mirrored. If neither cidrRanges nor IPProtocols is specified, all traffic is mirrored.
        """
        return pulumi.get(self, "ip_protocols")

    @ip_protocols.setter
    def ip_protocols(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "ip_protocols", value)


@pulumi.input_type
class PacketMirroringForwardingRuleInfoArgs:
    def __init__(__self__, *,
                 url: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] url: Resource URL to the forwarding rule representing the ILB configured as destination of the mirrored traffic.
        """
        if url is not None:
            pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[str]]:
        """
        Resource URL to the forwarding rule representing the ILB configured as destination of the mirrored traffic.
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "url", value)


@pulumi.input_type
class PacketMirroringMirroredResourceInfoInstanceInfoArgs:
    def __init__(__self__, *,
                 url: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] url: Resource URL to the virtual machine instance which is being mirrored.
        """
        if url is not None:
            pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[str]]:
        """
        Resource URL to the virtual machine instance which is being mirrored.
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "url", value)


@pulumi.input_type
class PacketMirroringMirroredResourceInfoSubnetInfoArgs:
    def __init__(__self__, *,
                 url: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] url: Resource URL to the subnetwork for which traffic from/to all VM instances will be mirrored.
        """
        if url is not None:
            pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[str]]:
        """
        Resource URL to the subnetwork for which traffic from/to all VM instances will be mirrored.
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "url", value)


@pulumi.input_type
class PacketMirroringMirroredResourceInfoArgs:
    def __init__(__self__, *,
                 instances: Optional[pulumi.Input[Sequence[pulumi.Input['PacketMirroringMirroredResourceInfoInstanceInfoArgs']]]] = None,
                 subnetworks: Optional[pulumi.Input[Sequence[pulumi.Input['PacketMirroringMirroredResourceInfoSubnetInfoArgs']]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['PacketMirroringMirroredResourceInfoInstanceInfoArgs']]] instances: A set of virtual machine instances that are being mirrored. They must live in zones contained in the same region as this packetMirroring. Note that this config will apply only to those network interfaces of the Instances that belong to the network specified in this packetMirroring. You may specify a maximum of 50 Instances.
        :param pulumi.Input[Sequence[pulumi.Input['PacketMirroringMirroredResourceInfoSubnetInfoArgs']]] subnetworks: A set of subnetworks for which traffic from/to all VM instances will be mirrored. They must live in the same region as this packetMirroring. You may specify a maximum of 5 subnetworks.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: A set of mirrored tags. Traffic from/to all VM instances that have one or more of these tags will be mirrored.
        """
        if instances is not None:
            pulumi.set(__self__, "instances", instances)
        if subnetworks is not None:
            pulumi.set(__self__, "subnetworks", subnetworks)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def instances(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PacketMirroringMirroredResourceInfoInstanceInfoArgs']]]]:
        """
        A set of virtual machine instances that are being mirrored. They must live in zones contained in the same region as this packetMirroring. Note that this config will apply only to those network interfaces of the Instances that belong to the network specified in this packetMirroring. You may specify a maximum of 50 Instances.
        """
        return pulumi.get(self, "instances")

    @instances.setter
    def instances(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PacketMirroringMirroredResourceInfoInstanceInfoArgs']]]]):
        pulumi.set(self, "instances", value)

    @property
    @pulumi.getter
    def subnetworks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PacketMirroringMirroredResourceInfoSubnetInfoArgs']]]]:
        """
        A set of subnetworks for which traffic from/to all VM instances will be mirrored. They must live in the same region as this packetMirroring. You may specify a maximum of 5 subnetworks.
        """
        return pulumi.get(self, "subnetworks")

    @subnetworks.setter
    def subnetworks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PacketMirroringMirroredResourceInfoSubnetInfoArgs']]]]):
        pulumi.set(self, "subnetworks", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A set of mirrored tags. Traffic from/to all VM instances that have one or more of these tags will be mirrored.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class PacketMirroringNetworkInfoArgs:
    def __init__(__self__, *,
                 url: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] url: URL of the network resource.
        """
        if url is not None:
            pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[str]]:
        """
        URL of the network resource.
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "url", value)


@pulumi.input_type
class PathMatcherArgs:
    def __init__(__self__, *,
                 default_route_action: Optional[pulumi.Input['HttpRouteActionArgs']] = None,
                 default_service: Optional[pulumi.Input[str]] = None,
                 default_url_redirect: Optional[pulumi.Input['HttpRedirectActionArgs']] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 header_action: Optional[pulumi.Input['HttpHeaderActionArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 path_rules: Optional[pulumi.Input[Sequence[pulumi.Input['PathRuleArgs']]]] = None,
                 route_rules: Optional[pulumi.Input[Sequence[pulumi.Input['HttpRouteRuleArgs']]]] = None):
        """
        A matcher for the path portion of the URL. The BackendService from the longest-matched rule will serve the URL. If no rule was matched, the default service is used.
        :param pulumi.Input['HttpRouteActionArgs'] default_route_action: defaultRouteAction takes effect when none of the pathRules or routeRules match. The load balancer performs advanced routing actions, such as URL rewrites and header transformations, before forwarding the request to the selected backend. If defaultRouteAction specifies any weightedBackendServices, defaultService must not be set. Conversely if defaultService is set, defaultRouteAction cannot contain any weightedBackendServices. Only one of defaultRouteAction or defaultUrlRedirect must be set. UrlMaps for external HTTP(S) load balancers support only the urlRewrite action within a path matcher's defaultRouteAction.
        :param pulumi.Input[str] default_service: The full or partial URL to the BackendService resource. This URL is used if none of the pathRules or routeRules defined by this PathMatcher are matched. For example, the following are all valid URLs to a BackendService resource: - https://www.googleapis.com/compute/v1/projects/project /global/backendServices/backendService - compute/v1/projects/project/global/backendServices/backendService - global/backendServices/backendService If defaultRouteAction is also specified, advanced routing actions, such as URL rewrites, take effect before sending the request to the backend. However, if defaultService is specified, defaultRouteAction cannot contain any weightedBackendServices. Conversely, if defaultRouteAction specifies any weightedBackendServices, defaultService must not be specified. Only one of defaultService, defaultUrlRedirect , or defaultRouteAction.weightedBackendService must be set. Authorization requires one or more of the following Google IAM permissions on the specified resource default_service: - compute.backendBuckets.use - compute.backendServices.use 
        :param pulumi.Input['HttpRedirectActionArgs'] default_url_redirect: When none of the specified pathRules or routeRules match, the request is redirected to a URL specified by defaultUrlRedirect. If defaultUrlRedirect is specified, defaultService or defaultRouteAction must not be set. Not supported when the URL map is bound to a target gRPC proxy.
        :param pulumi.Input[str] description: An optional description of this resource. Provide this property when you create the resource.
        :param pulumi.Input['HttpHeaderActionArgs'] header_action: Specifies changes to request and response headers that need to take effect for the selected backend service. HeaderAction specified here are applied after the matching HttpRouteRule HeaderAction and before the HeaderAction in the UrlMap HeaderAction is not supported for load balancers that have their loadBalancingScheme set to EXTERNAL. Not supported when the URL map is bound to a target gRPC proxy that has validateForProxyless field set to true.
        :param pulumi.Input[str] name: The name to which this PathMatcher is referred by the HostRule.
        :param pulumi.Input[Sequence[pulumi.Input['PathRuleArgs']]] path_rules: The list of path rules. Use this list instead of routeRules when routing based on simple path matching is all that's required. The order by which path rules are specified does not matter. Matches are always done on the longest-path-first basis. For example: a pathRule with a path /a/b/c/* will match before /a/b/* irrespective of the order in which those paths appear in this list. Within a given pathMatcher, only one of pathRules or routeRules must be set.
        :param pulumi.Input[Sequence[pulumi.Input['HttpRouteRuleArgs']]] route_rules: The list of HTTP route rules. Use this list instead of pathRules when advanced route matching and routing actions are desired. routeRules are evaluated in order of priority, from the lowest to highest number. Within a given pathMatcher, you can set only one of pathRules or routeRules.
        """
        if default_route_action is not None:
            pulumi.set(__self__, "default_route_action", default_route_action)
        if default_service is not None:
            pulumi.set(__self__, "default_service", default_service)
        if default_url_redirect is not None:
            pulumi.set(__self__, "default_url_redirect", default_url_redirect)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if header_action is not None:
            pulumi.set(__self__, "header_action", header_action)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if path_rules is not None:
            pulumi.set(__self__, "path_rules", path_rules)
        if route_rules is not None:
            pulumi.set(__self__, "route_rules", route_rules)

    @property
    @pulumi.getter(name="defaultRouteAction")
    def default_route_action(self) -> Optional[pulumi.Input['HttpRouteActionArgs']]:
        """
        defaultRouteAction takes effect when none of the pathRules or routeRules match. The load balancer performs advanced routing actions, such as URL rewrites and header transformations, before forwarding the request to the selected backend. If defaultRouteAction specifies any weightedBackendServices, defaultService must not be set. Conversely if defaultService is set, defaultRouteAction cannot contain any weightedBackendServices. Only one of defaultRouteAction or defaultUrlRedirect must be set. UrlMaps for external HTTP(S) load balancers support only the urlRewrite action within a path matcher's defaultRouteAction.
        """
        return pulumi.get(self, "default_route_action")

    @default_route_action.setter
    def default_route_action(self, value: Optional[pulumi.Input['HttpRouteActionArgs']]):
        pulumi.set(self, "default_route_action", value)

    @property
    @pulumi.getter(name="defaultService")
    def default_service(self) -> Optional[pulumi.Input[str]]:
        """
        The full or partial URL to the BackendService resource. This URL is used if none of the pathRules or routeRules defined by this PathMatcher are matched. For example, the following are all valid URLs to a BackendService resource: - https://www.googleapis.com/compute/v1/projects/project /global/backendServices/backendService - compute/v1/projects/project/global/backendServices/backendService - global/backendServices/backendService If defaultRouteAction is also specified, advanced routing actions, such as URL rewrites, take effect before sending the request to the backend. However, if defaultService is specified, defaultRouteAction cannot contain any weightedBackendServices. Conversely, if defaultRouteAction specifies any weightedBackendServices, defaultService must not be specified. Only one of defaultService, defaultUrlRedirect , or defaultRouteAction.weightedBackendService must be set. Authorization requires one or more of the following Google IAM permissions on the specified resource default_service: - compute.backendBuckets.use - compute.backendServices.use 
        """
        return pulumi.get(self, "default_service")

    @default_service.setter
    def default_service(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "default_service", value)

    @property
    @pulumi.getter(name="defaultUrlRedirect")
    def default_url_redirect(self) -> Optional[pulumi.Input['HttpRedirectActionArgs']]:
        """
        When none of the specified pathRules or routeRules match, the request is redirected to a URL specified by defaultUrlRedirect. If defaultUrlRedirect is specified, defaultService or defaultRouteAction must not be set. Not supported when the URL map is bound to a target gRPC proxy.
        """
        return pulumi.get(self, "default_url_redirect")

    @default_url_redirect.setter
    def default_url_redirect(self, value: Optional[pulumi.Input['HttpRedirectActionArgs']]):
        pulumi.set(self, "default_url_redirect", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        An optional description of this resource. Provide this property when you create the resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="headerAction")
    def header_action(self) -> Optional[pulumi.Input['HttpHeaderActionArgs']]:
        """
        Specifies changes to request and response headers that need to take effect for the selected backend service. HeaderAction specified here are applied after the matching HttpRouteRule HeaderAction and before the HeaderAction in the UrlMap HeaderAction is not supported for load balancers that have their loadBalancingScheme set to EXTERNAL. Not supported when the URL map is bound to a target gRPC proxy that has validateForProxyless field set to true.
        """
        return pulumi.get(self, "header_action")

    @header_action.setter
    def header_action(self, value: Optional[pulumi.Input['HttpHeaderActionArgs']]):
        pulumi.set(self, "header_action", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name to which this PathMatcher is referred by the HostRule.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="pathRules")
    def path_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PathRuleArgs']]]]:
        """
        The list of path rules. Use this list instead of routeRules when routing based on simple path matching is all that's required. The order by which path rules are specified does not matter. Matches are always done on the longest-path-first basis. For example: a pathRule with a path /a/b/c/* will match before /a/b/* irrespective of the order in which those paths appear in this list. Within a given pathMatcher, only one of pathRules or routeRules must be set.
        """
        return pulumi.get(self, "path_rules")

    @path_rules.setter
    def path_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PathRuleArgs']]]]):
        pulumi.set(self, "path_rules", value)

    @property
    @pulumi.getter(name="routeRules")
    def route_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['HttpRouteRuleArgs']]]]:
        """
        The list of HTTP route rules. Use this list instead of pathRules when advanced route matching and routing actions are desired. routeRules are evaluated in order of priority, from the lowest to highest number. Within a given pathMatcher, you can set only one of pathRules or routeRules.
        """
        return pulumi.get(self, "route_rules")

    @route_rules.setter
    def route_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['HttpRouteRuleArgs']]]]):
        pulumi.set(self, "route_rules", value)


@pulumi.input_type
class PathRuleArgs:
    def __init__(__self__, *,
                 paths: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 route_action: Optional[pulumi.Input['HttpRouteActionArgs']] = None,
                 service: Optional[pulumi.Input[str]] = None,
                 url_redirect: Optional[pulumi.Input['HttpRedirectActionArgs']] = None):
        """
        A path-matching rule for a URL. If matched, will use the specified BackendService to handle the traffic arriving at this URL.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] paths: The list of path patterns to match. Each must start with / and the only place a * is allowed is at the end following a /. The string fed to the path matcher does not include any text after the first ? or #, and those chars are not allowed here.
        :param pulumi.Input['HttpRouteActionArgs'] route_action: In response to a matching path, the load balancer performs advanced routing actions, such as URL rewrites and header transformations, before forwarding the request to the selected backend. If routeAction specifies any weightedBackendServices, service must not be set. Conversely if service is set, routeAction cannot contain any weightedBackendServices. Only one of routeAction or urlRedirect must be set. URL maps for external HTTP(S) load balancers support only the urlRewrite action within a path rule's routeAction.
        :param pulumi.Input[str] service: The full or partial URL of the backend service resource to which traffic is directed if this rule is matched. If routeAction is also specified, advanced routing actions, such as URL rewrites, take effect before sending the request to the backend. However, if service is specified, routeAction cannot contain any weightedBackendServices. Conversely, if routeAction specifies any weightedBackendServices, service must not be specified. Only one of urlRedirect, service or routeAction.weightedBackendService must be set.
        :param pulumi.Input['HttpRedirectActionArgs'] url_redirect: When a path pattern is matched, the request is redirected to a URL specified by urlRedirect. If urlRedirect is specified, service or routeAction must not be set. Not supported when the URL map is bound to a target gRPC proxy.
        """
        if paths is not None:
            pulumi.set(__self__, "paths", paths)
        if route_action is not None:
            pulumi.set(__self__, "route_action", route_action)
        if service is not None:
            pulumi.set(__self__, "service", service)
        if url_redirect is not None:
            pulumi.set(__self__, "url_redirect", url_redirect)

    @property
    @pulumi.getter
    def paths(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of path patterns to match. Each must start with / and the only place a * is allowed is at the end following a /. The string fed to the path matcher does not include any text after the first ? or #, and those chars are not allowed here.
        """
        return pulumi.get(self, "paths")

    @paths.setter
    def paths(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "paths", value)

    @property
    @pulumi.getter(name="routeAction")
    def route_action(self) -> Optional[pulumi.Input['HttpRouteActionArgs']]:
        """
        In response to a matching path, the load balancer performs advanced routing actions, such as URL rewrites and header transformations, before forwarding the request to the selected backend. If routeAction specifies any weightedBackendServices, service must not be set. Conversely if service is set, routeAction cannot contain any weightedBackendServices. Only one of routeAction or urlRedirect must be set. URL maps for external HTTP(S) load balancers support only the urlRewrite action within a path rule's routeAction.
        """
        return pulumi.get(self, "route_action")

    @route_action.setter
    def route_action(self, value: Optional[pulumi.Input['HttpRouteActionArgs']]):
        pulumi.set(self, "route_action", value)

    @property
    @pulumi.getter
    def service(self) -> Optional[pulumi.Input[str]]:
        """
        The full or partial URL of the backend service resource to which traffic is directed if this rule is matched. If routeAction is also specified, advanced routing actions, such as URL rewrites, take effect before sending the request to the backend. However, if service is specified, routeAction cannot contain any weightedBackendServices. Conversely, if routeAction specifies any weightedBackendServices, service must not be specified. Only one of urlRedirect, service or routeAction.weightedBackendService must be set.
        """
        return pulumi.get(self, "service")

    @service.setter
    def service(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service", value)

    @property
    @pulumi.getter(name="urlRedirect")
    def url_redirect(self) -> Optional[pulumi.Input['HttpRedirectActionArgs']]:
        """
        When a path pattern is matched, the request is redirected to a URL specified by urlRedirect. If urlRedirect is specified, service or routeAction must not be set. Not supported when the URL map is bound to a target gRPC proxy.
        """
        return pulumi.get(self, "url_redirect")

    @url_redirect.setter
    def url_redirect(self, value: Optional[pulumi.Input['HttpRedirectActionArgs']]):
        pulumi.set(self, "url_redirect", value)


@pulumi.input_type
class PublicDelegatedPrefixPublicDelegatedSubPrefixArgs:
    def __init__(__self__, *,
                 delegatee_project: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 ip_cidr_range: Optional[pulumi.Input[str]] = None,
                 is_address: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        Represents a sub PublicDelegatedPrefix.
        :param pulumi.Input[str] delegatee_project: Name of the project scoping this PublicDelegatedSubPrefix.
        :param pulumi.Input[str] description: An optional description of this resource. Provide this property when you create the resource.
        :param pulumi.Input[str] ip_cidr_range: The IPv4 address range, in CIDR format, represented by this sub public delegated prefix.
        :param pulumi.Input[bool] is_address: Whether the sub prefix is delegated to create Address resources in the delegatee project.
        :param pulumi.Input[str] name: The name of the sub public delegated prefix.
        """
        if delegatee_project is not None:
            pulumi.set(__self__, "delegatee_project", delegatee_project)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if ip_cidr_range is not None:
            pulumi.set(__self__, "ip_cidr_range", ip_cidr_range)
        if is_address is not None:
            pulumi.set(__self__, "is_address", is_address)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="delegateeProject")
    def delegatee_project(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the project scoping this PublicDelegatedSubPrefix.
        """
        return pulumi.get(self, "delegatee_project")

    @delegatee_project.setter
    def delegatee_project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "delegatee_project", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        An optional description of this resource. Provide this property when you create the resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="ipCidrRange")
    def ip_cidr_range(self) -> Optional[pulumi.Input[str]]:
        """
        The IPv4 address range, in CIDR format, represented by this sub public delegated prefix.
        """
        return pulumi.get(self, "ip_cidr_range")

    @ip_cidr_range.setter
    def ip_cidr_range(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip_cidr_range", value)

    @property
    @pulumi.getter(name="isAddress")
    def is_address(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the sub prefix is delegated to create Address resources in the delegatee project.
        """
        return pulumi.get(self, "is_address")

    @is_address.setter
    def is_address(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_address", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the sub public delegated prefix.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class RequestMirrorPolicyArgs:
    def __init__(__self__, *,
                 backend_service: Optional[pulumi.Input[str]] = None):
        """
        A policy that specifies how requests intended for the route's backends are shadowed to a separate mirrored backend service. The load balancer doesn't wait for responses from the shadow service. Before sending traffic to the shadow service, the host or authority header is suffixed with -shadow.
        :param pulumi.Input[str] backend_service: The full or partial URL to the BackendService resource being mirrored to.
        """
        if backend_service is not None:
            pulumi.set(__self__, "backend_service", backend_service)

    @property
    @pulumi.getter(name="backendService")
    def backend_service(self) -> Optional[pulumi.Input[str]]:
        """
        The full or partial URL to the BackendService resource being mirrored to.
        """
        return pulumi.get(self, "backend_service")

    @backend_service.setter
    def backend_service(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "backend_service", value)


@pulumi.input_type
class ReservationAffinityArgs:
    def __init__(__self__, *,
                 consume_reservation_type: Optional[pulumi.Input['ReservationAffinityConsumeReservationType']] = None,
                 key: Optional[pulumi.Input[str]] = None,
                 values: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Specifies the reservations that this instance can consume from.
        :param pulumi.Input['ReservationAffinityConsumeReservationType'] consume_reservation_type: Specifies the type of reservation from which this instance can consume resources: ANY_RESERVATION (default), SPECIFIC_RESERVATION, or NO_RESERVATION. See Consuming reserved instances for examples.
        :param pulumi.Input[str] key: Corresponds to the label key of a reservation resource. To target a SPECIFIC_RESERVATION by name, specify googleapis.com/reservation-name as the key and specify the name of your reservation as its value.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] values: Corresponds to the label values of a reservation resource. This can be either a name to a reservation in the same project or "projects/different-project/reservations/some-reservation-name" to target a shared reservation in the same zone but in a different project.
        """
        if consume_reservation_type is not None:
            pulumi.set(__self__, "consume_reservation_type", consume_reservation_type)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if values is not None:
            pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter(name="consumeReservationType")
    def consume_reservation_type(self) -> Optional[pulumi.Input['ReservationAffinityConsumeReservationType']]:
        """
        Specifies the type of reservation from which this instance can consume resources: ANY_RESERVATION (default), SPECIFIC_RESERVATION, or NO_RESERVATION. See Consuming reserved instances for examples.
        """
        return pulumi.get(self, "consume_reservation_type")

    @consume_reservation_type.setter
    def consume_reservation_type(self, value: Optional[pulumi.Input['ReservationAffinityConsumeReservationType']]):
        pulumi.set(self, "consume_reservation_type", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[str]]:
        """
        Corresponds to the label key of a reservation resource. To target a SPECIFIC_RESERVATION by name, specify googleapis.com/reservation-name as the key and specify the name of your reservation as its value.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def values(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Corresponds to the label values of a reservation resource. This can be either a name to a reservation in the same project or "projects/different-project/reservations/some-reservation-name" to target a shared reservation in the same zone but in a different project.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "values", value)


@pulumi.input_type
class ReservationArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 share_settings: Optional[pulumi.Input['ShareSettingsArgs']] = None,
                 specific_reservation: Optional[pulumi.Input['AllocationSpecificSKUReservationArgs']] = None,
                 specific_reservation_required: Optional[pulumi.Input[bool]] = None,
                 zone: Optional[pulumi.Input[str]] = None):
        """
        Represents a reservation resource. A reservation ensures that capacity is held in a specific zone even if the reserved VMs are not running. For more information, read Reserving zonal resources.
        :param pulumi.Input[str] description: An optional description of this resource. Provide this property when you create the resource.
        :param pulumi.Input[str] name: The name of the resource, provided by the client when initially creating the resource. The resource name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
        :param pulumi.Input['ShareSettingsArgs'] share_settings: Share-settings for shared-reservation
        :param pulumi.Input['AllocationSpecificSKUReservationArgs'] specific_reservation: Reservation for instances with specific machine shapes.
        :param pulumi.Input[bool] specific_reservation_required: Indicates whether the reservation can be consumed by VMs with affinity for "any" reservation. If the field is set, then only VMs that target the reservation by name can consume from this reservation.
        :param pulumi.Input[str] zone: Zone in which the reservation resides. A zone must be provided if the reservation is created within a commitment.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if share_settings is not None:
            pulumi.set(__self__, "share_settings", share_settings)
        if specific_reservation is not None:
            pulumi.set(__self__, "specific_reservation", specific_reservation)
        if specific_reservation_required is not None:
            pulumi.set(__self__, "specific_reservation_required", specific_reservation_required)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        An optional description of this resource. Provide this property when you create the resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the resource, provided by the client when initially creating the resource. The resource name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="shareSettings")
    def share_settings(self) -> Optional[pulumi.Input['ShareSettingsArgs']]:
        """
        Share-settings for shared-reservation
        """
        return pulumi.get(self, "share_settings")

    @share_settings.setter
    def share_settings(self, value: Optional[pulumi.Input['ShareSettingsArgs']]):
        pulumi.set(self, "share_settings", value)

    @property
    @pulumi.getter(name="specificReservation")
    def specific_reservation(self) -> Optional[pulumi.Input['AllocationSpecificSKUReservationArgs']]:
        """
        Reservation for instances with specific machine shapes.
        """
        return pulumi.get(self, "specific_reservation")

    @specific_reservation.setter
    def specific_reservation(self, value: Optional[pulumi.Input['AllocationSpecificSKUReservationArgs']]):
        pulumi.set(self, "specific_reservation", value)

    @property
    @pulumi.getter(name="specificReservationRequired")
    def specific_reservation_required(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether the reservation can be consumed by VMs with affinity for "any" reservation. If the field is set, then only VMs that target the reservation by name can consume from this reservation.
        """
        return pulumi.get(self, "specific_reservation_required")

    @specific_reservation_required.setter
    def specific_reservation_required(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "specific_reservation_required", value)

    @property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[str]]:
        """
        Zone in which the reservation resides. A zone must be provided if the reservation is created within a commitment.
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zone", value)


@pulumi.input_type
class ResourceCommitmentArgs:
    def __init__(__self__, *,
                 accelerator_type: Optional[pulumi.Input[str]] = None,
                 amount: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input['ResourceCommitmentType']] = None):
        """
        Commitment for a particular resource (a Commitment is composed of one or more of these).
        :param pulumi.Input[str] accelerator_type: Name of the accelerator type resource. Applicable only when the type is ACCELERATOR.
        :param pulumi.Input[str] amount: The amount of the resource purchased (in a type-dependent unit, such as bytes). For vCPUs, this can just be an integer. For memory, this must be provided in MB. Memory must be a multiple of 256 MB, with up to 6.5GB of memory per every vCPU.
        :param pulumi.Input['ResourceCommitmentType'] type: Type of resource for which this commitment applies. Possible values are VCPU and MEMORY
        """
        if accelerator_type is not None:
            pulumi.set(__self__, "accelerator_type", accelerator_type)
        if amount is not None:
            pulumi.set(__self__, "amount", amount)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="acceleratorType")
    def accelerator_type(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the accelerator type resource. Applicable only when the type is ACCELERATOR.
        """
        return pulumi.get(self, "accelerator_type")

    @accelerator_type.setter
    def accelerator_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "accelerator_type", value)

    @property
    @pulumi.getter
    def amount(self) -> Optional[pulumi.Input[str]]:
        """
        The amount of the resource purchased (in a type-dependent unit, such as bytes). For vCPUs, this can just be an integer. For memory, this must be provided in MB. Memory must be a multiple of 256 MB, with up to 6.5GB of memory per every vCPU.
        """
        return pulumi.get(self, "amount")

    @amount.setter
    def amount(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "amount", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input['ResourceCommitmentType']]:
        """
        Type of resource for which this commitment applies. Possible values are VCPU and MEMORY
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input['ResourceCommitmentType']]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class ResourcePolicyDailyCycleArgs:
    def __init__(__self__, *,
                 days_in_cycle: Optional[pulumi.Input[int]] = None,
                 start_time: Optional[pulumi.Input[str]] = None):
        """
        Time window specified for daily operations.
        :param pulumi.Input[int] days_in_cycle: Defines a schedule with units measured in months. The value determines how many months pass between the start of each cycle.
        :param pulumi.Input[str] start_time: Start time of the window. This must be in UTC format that resolves to one of 00:00, 04:00, 08:00, 12:00, 16:00, or 20:00. For example, both 13:00-5 and 08:00 are valid.
        """
        if days_in_cycle is not None:
            pulumi.set(__self__, "days_in_cycle", days_in_cycle)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)

    @property
    @pulumi.getter(name="daysInCycle")
    def days_in_cycle(self) -> Optional[pulumi.Input[int]]:
        """
        Defines a schedule with units measured in months. The value determines how many months pass between the start of each cycle.
        """
        return pulumi.get(self, "days_in_cycle")

    @days_in_cycle.setter
    def days_in_cycle(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "days_in_cycle", value)

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[pulumi.Input[str]]:
        """
        Start time of the window. This must be in UTC format that resolves to one of 00:00, 04:00, 08:00, 12:00, 16:00, or 20:00. For example, both 13:00-5 and 08:00 are valid.
        """
        return pulumi.get(self, "start_time")

    @start_time.setter
    def start_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "start_time", value)


@pulumi.input_type
class ResourcePolicyGroupPlacementPolicyArgs:
    def __init__(__self__, *,
                 availability_domain_count: Optional[pulumi.Input[int]] = None,
                 collocation: Optional[pulumi.Input['ResourcePolicyGroupPlacementPolicyCollocation']] = None,
                 vm_count: Optional[pulumi.Input[int]] = None):
        """
        A GroupPlacementPolicy specifies resource placement configuration. It specifies the failure bucket separation as well as network locality
        :param pulumi.Input[int] availability_domain_count: The number of availability domains instances will be spread across. If two instances are in different availability domain, they will not be put in the same low latency network
        :param pulumi.Input['ResourcePolicyGroupPlacementPolicyCollocation'] collocation: Specifies network collocation
        :param pulumi.Input[int] vm_count: Number of vms in this placement group
        """
        if availability_domain_count is not None:
            pulumi.set(__self__, "availability_domain_count", availability_domain_count)
        if collocation is not None:
            pulumi.set(__self__, "collocation", collocation)
        if vm_count is not None:
            pulumi.set(__self__, "vm_count", vm_count)

    @property
    @pulumi.getter(name="availabilityDomainCount")
    def availability_domain_count(self) -> Optional[pulumi.Input[int]]:
        """
        The number of availability domains instances will be spread across. If two instances are in different availability domain, they will not be put in the same low latency network
        """
        return pulumi.get(self, "availability_domain_count")

    @availability_domain_count.setter
    def availability_domain_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "availability_domain_count", value)

    @property
    @pulumi.getter
    def collocation(self) -> Optional[pulumi.Input['ResourcePolicyGroupPlacementPolicyCollocation']]:
        """
        Specifies network collocation
        """
        return pulumi.get(self, "collocation")

    @collocation.setter
    def collocation(self, value: Optional[pulumi.Input['ResourcePolicyGroupPlacementPolicyCollocation']]):
        pulumi.set(self, "collocation", value)

    @property
    @pulumi.getter(name="vmCount")
    def vm_count(self) -> Optional[pulumi.Input[int]]:
        """
        Number of vms in this placement group
        """
        return pulumi.get(self, "vm_count")

    @vm_count.setter
    def vm_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "vm_count", value)


@pulumi.input_type
class ResourcePolicyHourlyCycleArgs:
    def __init__(__self__, *,
                 hours_in_cycle: Optional[pulumi.Input[int]] = None,
                 start_time: Optional[pulumi.Input[str]] = None):
        """
        Time window specified for hourly operations.
        :param pulumi.Input[int] hours_in_cycle: Defines a schedule with units measured in hours. The value determines how many hours pass between the start of each cycle.
        :param pulumi.Input[str] start_time: Time within the window to start the operations. It must be in format "HH:MM", where HH : [00-23] and MM : [00-00] GMT.
        """
        if hours_in_cycle is not None:
            pulumi.set(__self__, "hours_in_cycle", hours_in_cycle)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)

    @property
    @pulumi.getter(name="hoursInCycle")
    def hours_in_cycle(self) -> Optional[pulumi.Input[int]]:
        """
        Defines a schedule with units measured in hours. The value determines how many hours pass between the start of each cycle.
        """
        return pulumi.get(self, "hours_in_cycle")

    @hours_in_cycle.setter
    def hours_in_cycle(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "hours_in_cycle", value)

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[pulumi.Input[str]]:
        """
        Time within the window to start the operations. It must be in format "HH:MM", where HH : [00-23] and MM : [00-00] GMT.
        """
        return pulumi.get(self, "start_time")

    @start_time.setter
    def start_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "start_time", value)


@pulumi.input_type
class ResourcePolicyInstanceSchedulePolicyScheduleArgs:
    def __init__(__self__, *,
                 schedule: Optional[pulumi.Input[str]] = None):
        """
        Schedule for an instance operation.
        :param pulumi.Input[str] schedule: Specifies the frequency for the operation, using the unix-cron format.
        """
        if schedule is not None:
            pulumi.set(__self__, "schedule", schedule)

    @property
    @pulumi.getter
    def schedule(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the frequency for the operation, using the unix-cron format.
        """
        return pulumi.get(self, "schedule")

    @schedule.setter
    def schedule(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "schedule", value)


@pulumi.input_type
class ResourcePolicyInstanceSchedulePolicyArgs:
    def __init__(__self__, *,
                 expiration_time: Optional[pulumi.Input[str]] = None,
                 start_time: Optional[pulumi.Input[str]] = None,
                 time_zone: Optional[pulumi.Input[str]] = None,
                 vm_start_schedule: Optional[pulumi.Input['ResourcePolicyInstanceSchedulePolicyScheduleArgs']] = None,
                 vm_stop_schedule: Optional[pulumi.Input['ResourcePolicyInstanceSchedulePolicyScheduleArgs']] = None):
        """
        An InstanceSchedulePolicy specifies when and how frequent certain operations are performed on the instance.
        :param pulumi.Input[str] expiration_time: The expiration time of the schedule. The timestamp is an RFC3339 string.
        :param pulumi.Input[str] start_time: The start time of the schedule. The timestamp is an RFC3339 string.
        :param pulumi.Input[str] time_zone: Specifies the time zone to be used in interpreting Schedule.schedule. The value of this field must be a time zone name from the tz database: http://en.wikipedia.org/wiki/Tz_database.
        :param pulumi.Input['ResourcePolicyInstanceSchedulePolicyScheduleArgs'] vm_start_schedule: Specifies the schedule for starting instances.
        :param pulumi.Input['ResourcePolicyInstanceSchedulePolicyScheduleArgs'] vm_stop_schedule: Specifies the schedule for stopping instances.
        """
        if expiration_time is not None:
            pulumi.set(__self__, "expiration_time", expiration_time)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)
        if time_zone is not None:
            pulumi.set(__self__, "time_zone", time_zone)
        if vm_start_schedule is not None:
            pulumi.set(__self__, "vm_start_schedule", vm_start_schedule)
        if vm_stop_schedule is not None:
            pulumi.set(__self__, "vm_stop_schedule", vm_stop_schedule)

    @property
    @pulumi.getter(name="expirationTime")
    def expiration_time(self) -> Optional[pulumi.Input[str]]:
        """
        The expiration time of the schedule. The timestamp is an RFC3339 string.
        """
        return pulumi.get(self, "expiration_time")

    @expiration_time.setter
    def expiration_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expiration_time", value)

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[pulumi.Input[str]]:
        """
        The start time of the schedule. The timestamp is an RFC3339 string.
        """
        return pulumi.get(self, "start_time")

    @start_time.setter
    def start_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "start_time", value)

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the time zone to be used in interpreting Schedule.schedule. The value of this field must be a time zone name from the tz database: http://en.wikipedia.org/wiki/Tz_database.
        """
        return pulumi.get(self, "time_zone")

    @time_zone.setter
    def time_zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_zone", value)

    @property
    @pulumi.getter(name="vmStartSchedule")
    def vm_start_schedule(self) -> Optional[pulumi.Input['ResourcePolicyInstanceSchedulePolicyScheduleArgs']]:
        """
        Specifies the schedule for starting instances.
        """
        return pulumi.get(self, "vm_start_schedule")

    @vm_start_schedule.setter
    def vm_start_schedule(self, value: Optional[pulumi.Input['ResourcePolicyInstanceSchedulePolicyScheduleArgs']]):
        pulumi.set(self, "vm_start_schedule", value)

    @property
    @pulumi.getter(name="vmStopSchedule")
    def vm_stop_schedule(self) -> Optional[pulumi.Input['ResourcePolicyInstanceSchedulePolicyScheduleArgs']]:
        """
        Specifies the schedule for stopping instances.
        """
        return pulumi.get(self, "vm_stop_schedule")

    @vm_stop_schedule.setter
    def vm_stop_schedule(self, value: Optional[pulumi.Input['ResourcePolicyInstanceSchedulePolicyScheduleArgs']]):
        pulumi.set(self, "vm_stop_schedule", value)


@pulumi.input_type
class ResourcePolicySnapshotSchedulePolicyRetentionPolicyArgs:
    def __init__(__self__, *,
                 max_retention_days: Optional[pulumi.Input[int]] = None,
                 on_source_disk_delete: Optional[pulumi.Input['ResourcePolicySnapshotSchedulePolicyRetentionPolicyOnSourceDiskDelete']] = None):
        """
        Policy for retention of scheduled snapshots.
        :param pulumi.Input[int] max_retention_days: Maximum age of the snapshot that is allowed to be kept.
        :param pulumi.Input['ResourcePolicySnapshotSchedulePolicyRetentionPolicyOnSourceDiskDelete'] on_source_disk_delete: Specifies the behavior to apply to scheduled snapshots when the source disk is deleted.
        """
        if max_retention_days is not None:
            pulumi.set(__self__, "max_retention_days", max_retention_days)
        if on_source_disk_delete is not None:
            pulumi.set(__self__, "on_source_disk_delete", on_source_disk_delete)

    @property
    @pulumi.getter(name="maxRetentionDays")
    def max_retention_days(self) -> Optional[pulumi.Input[int]]:
        """
        Maximum age of the snapshot that is allowed to be kept.
        """
        return pulumi.get(self, "max_retention_days")

    @max_retention_days.setter
    def max_retention_days(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_retention_days", value)

    @property
    @pulumi.getter(name="onSourceDiskDelete")
    def on_source_disk_delete(self) -> Optional[pulumi.Input['ResourcePolicySnapshotSchedulePolicyRetentionPolicyOnSourceDiskDelete']]:
        """
        Specifies the behavior to apply to scheduled snapshots when the source disk is deleted.
        """
        return pulumi.get(self, "on_source_disk_delete")

    @on_source_disk_delete.setter
    def on_source_disk_delete(self, value: Optional[pulumi.Input['ResourcePolicySnapshotSchedulePolicyRetentionPolicyOnSourceDiskDelete']]):
        pulumi.set(self, "on_source_disk_delete", value)


@pulumi.input_type
class ResourcePolicySnapshotSchedulePolicyScheduleArgs:
    def __init__(__self__, *,
                 daily_schedule: Optional[pulumi.Input['ResourcePolicyDailyCycleArgs']] = None,
                 hourly_schedule: Optional[pulumi.Input['ResourcePolicyHourlyCycleArgs']] = None,
                 weekly_schedule: Optional[pulumi.Input['ResourcePolicyWeeklyCycleArgs']] = None):
        """
        A schedule for disks where the schedueled operations are performed.
        """
        if daily_schedule is not None:
            pulumi.set(__self__, "daily_schedule", daily_schedule)
        if hourly_schedule is not None:
            pulumi.set(__self__, "hourly_schedule", hourly_schedule)
        if weekly_schedule is not None:
            pulumi.set(__self__, "weekly_schedule", weekly_schedule)

    @property
    @pulumi.getter(name="dailySchedule")
    def daily_schedule(self) -> Optional[pulumi.Input['ResourcePolicyDailyCycleArgs']]:
        return pulumi.get(self, "daily_schedule")

    @daily_schedule.setter
    def daily_schedule(self, value: Optional[pulumi.Input['ResourcePolicyDailyCycleArgs']]):
        pulumi.set(self, "daily_schedule", value)

    @property
    @pulumi.getter(name="hourlySchedule")
    def hourly_schedule(self) -> Optional[pulumi.Input['ResourcePolicyHourlyCycleArgs']]:
        return pulumi.get(self, "hourly_schedule")

    @hourly_schedule.setter
    def hourly_schedule(self, value: Optional[pulumi.Input['ResourcePolicyHourlyCycleArgs']]):
        pulumi.set(self, "hourly_schedule", value)

    @property
    @pulumi.getter(name="weeklySchedule")
    def weekly_schedule(self) -> Optional[pulumi.Input['ResourcePolicyWeeklyCycleArgs']]:
        return pulumi.get(self, "weekly_schedule")

    @weekly_schedule.setter
    def weekly_schedule(self, value: Optional[pulumi.Input['ResourcePolicyWeeklyCycleArgs']]):
        pulumi.set(self, "weekly_schedule", value)


@pulumi.input_type
class ResourcePolicySnapshotSchedulePolicySnapshotPropertiesArgs:
    def __init__(__self__, *,
                 chain_name: Optional[pulumi.Input[str]] = None,
                 guest_flush: Optional[pulumi.Input[bool]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 storage_locations: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Specified snapshot properties for scheduled snapshots created by this policy.
        :param pulumi.Input[str] chain_name: Chain name that the snapshot is created in.
        :param pulumi.Input[bool] guest_flush: Indication to perform a 'guest aware' snapshot.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Labels to apply to scheduled snapshots. These can be later modified by the setLabels method. Label values may be empty.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] storage_locations: Cloud Storage bucket storage location of the auto snapshot (regional or multi-regional).
        """
        if chain_name is not None:
            pulumi.set(__self__, "chain_name", chain_name)
        if guest_flush is not None:
            pulumi.set(__self__, "guest_flush", guest_flush)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if storage_locations is not None:
            pulumi.set(__self__, "storage_locations", storage_locations)

    @property
    @pulumi.getter(name="chainName")
    def chain_name(self) -> Optional[pulumi.Input[str]]:
        """
        Chain name that the snapshot is created in.
        """
        return pulumi.get(self, "chain_name")

    @chain_name.setter
    def chain_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "chain_name", value)

    @property
    @pulumi.getter(name="guestFlush")
    def guest_flush(self) -> Optional[pulumi.Input[bool]]:
        """
        Indication to perform a 'guest aware' snapshot.
        """
        return pulumi.get(self, "guest_flush")

    @guest_flush.setter
    def guest_flush(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "guest_flush", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Labels to apply to scheduled snapshots. These can be later modified by the setLabels method. Label values may be empty.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter(name="storageLocations")
    def storage_locations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Cloud Storage bucket storage location of the auto snapshot (regional or multi-regional).
        """
        return pulumi.get(self, "storage_locations")

    @storage_locations.setter
    def storage_locations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "storage_locations", value)


@pulumi.input_type
class ResourcePolicySnapshotSchedulePolicyArgs:
    def __init__(__self__, *,
                 retention_policy: Optional[pulumi.Input['ResourcePolicySnapshotSchedulePolicyRetentionPolicyArgs']] = None,
                 schedule: Optional[pulumi.Input['ResourcePolicySnapshotSchedulePolicyScheduleArgs']] = None,
                 snapshot_properties: Optional[pulumi.Input['ResourcePolicySnapshotSchedulePolicySnapshotPropertiesArgs']] = None):
        """
        A snapshot schedule policy specifies when and how frequently snapshots are to be created for the target disk. Also specifies how many and how long these scheduled snapshots should be retained.
        :param pulumi.Input['ResourcePolicySnapshotSchedulePolicyRetentionPolicyArgs'] retention_policy: Retention policy applied to snapshots created by this resource policy.
        :param pulumi.Input['ResourcePolicySnapshotSchedulePolicyScheduleArgs'] schedule: A Vm Maintenance Policy specifies what kind of infrastructure maintenance we are allowed to perform on this VM and when. Schedule that is applied to disks covered by this policy.
        :param pulumi.Input['ResourcePolicySnapshotSchedulePolicySnapshotPropertiesArgs'] snapshot_properties: Properties with which snapshots are created such as labels, encryption keys.
        """
        if retention_policy is not None:
            pulumi.set(__self__, "retention_policy", retention_policy)
        if schedule is not None:
            pulumi.set(__self__, "schedule", schedule)
        if snapshot_properties is not None:
            pulumi.set(__self__, "snapshot_properties", snapshot_properties)

    @property
    @pulumi.getter(name="retentionPolicy")
    def retention_policy(self) -> Optional[pulumi.Input['ResourcePolicySnapshotSchedulePolicyRetentionPolicyArgs']]:
        """
        Retention policy applied to snapshots created by this resource policy.
        """
        return pulumi.get(self, "retention_policy")

    @retention_policy.setter
    def retention_policy(self, value: Optional[pulumi.Input['ResourcePolicySnapshotSchedulePolicyRetentionPolicyArgs']]):
        pulumi.set(self, "retention_policy", value)

    @property
    @pulumi.getter
    def schedule(self) -> Optional[pulumi.Input['ResourcePolicySnapshotSchedulePolicyScheduleArgs']]:
        """
        A Vm Maintenance Policy specifies what kind of infrastructure maintenance we are allowed to perform on this VM and when. Schedule that is applied to disks covered by this policy.
        """
        return pulumi.get(self, "schedule")

    @schedule.setter
    def schedule(self, value: Optional[pulumi.Input['ResourcePolicySnapshotSchedulePolicyScheduleArgs']]):
        pulumi.set(self, "schedule", value)

    @property
    @pulumi.getter(name="snapshotProperties")
    def snapshot_properties(self) -> Optional[pulumi.Input['ResourcePolicySnapshotSchedulePolicySnapshotPropertiesArgs']]:
        """
        Properties with which snapshots are created such as labels, encryption keys.
        """
        return pulumi.get(self, "snapshot_properties")

    @snapshot_properties.setter
    def snapshot_properties(self, value: Optional[pulumi.Input['ResourcePolicySnapshotSchedulePolicySnapshotPropertiesArgs']]):
        pulumi.set(self, "snapshot_properties", value)


@pulumi.input_type
class ResourcePolicyWeeklyCycleDayOfWeekArgs:
    def __init__(__self__, *,
                 day: Optional[pulumi.Input['ResourcePolicyWeeklyCycleDayOfWeekDay']] = None,
                 start_time: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input['ResourcePolicyWeeklyCycleDayOfWeekDay'] day: Defines a schedule that runs on specific days of the week. Specify one or more days. The following options are available: MONDAY, TUESDAY, WEDNESDAY, THURSDAY, FRIDAY, SATURDAY, SUNDAY.
        :param pulumi.Input[str] start_time: Time within the window to start the operations. It must be in format "HH:MM", where HH : [00-23] and MM : [00-00] GMT.
        """
        if day is not None:
            pulumi.set(__self__, "day", day)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)

    @property
    @pulumi.getter
    def day(self) -> Optional[pulumi.Input['ResourcePolicyWeeklyCycleDayOfWeekDay']]:
        """
        Defines a schedule that runs on specific days of the week. Specify one or more days. The following options are available: MONDAY, TUESDAY, WEDNESDAY, THURSDAY, FRIDAY, SATURDAY, SUNDAY.
        """
        return pulumi.get(self, "day")

    @day.setter
    def day(self, value: Optional[pulumi.Input['ResourcePolicyWeeklyCycleDayOfWeekDay']]):
        pulumi.set(self, "day", value)

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[pulumi.Input[str]]:
        """
        Time within the window to start the operations. It must be in format "HH:MM", where HH : [00-23] and MM : [00-00] GMT.
        """
        return pulumi.get(self, "start_time")

    @start_time.setter
    def start_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "start_time", value)


@pulumi.input_type
class ResourcePolicyWeeklyCycleArgs:
    def __init__(__self__, *,
                 day_of_weeks: Optional[pulumi.Input[Sequence[pulumi.Input['ResourcePolicyWeeklyCycleDayOfWeekArgs']]]] = None):
        """
        Time window specified for weekly operations.
        :param pulumi.Input[Sequence[pulumi.Input['ResourcePolicyWeeklyCycleDayOfWeekArgs']]] day_of_weeks: Up to 7 intervals/windows, one for each day of the week.
        """
        if day_of_weeks is not None:
            pulumi.set(__self__, "day_of_weeks", day_of_weeks)

    @property
    @pulumi.getter(name="dayOfWeeks")
    def day_of_weeks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ResourcePolicyWeeklyCycleDayOfWeekArgs']]]]:
        """
        Up to 7 intervals/windows, one for each day of the week.
        """
        return pulumi.get(self, "day_of_weeks")

    @day_of_weeks.setter
    def day_of_weeks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ResourcePolicyWeeklyCycleDayOfWeekArgs']]]]):
        pulumi.set(self, "day_of_weeks", value)


@pulumi.input_type
class RolloutPolicyArgs:
    def __init__(__self__, *,
                 default_rollout_time: Optional[pulumi.Input[str]] = None,
                 location_rollout_policies: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        A rollout policy configuration.
        :param pulumi.Input[str] default_rollout_time: An optional RFC3339 timestamp on or after which the update is considered rolled out to any zone that is not explicitly stated.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] location_rollout_policies: Location based rollout policies to apply to the resource. Currently only zone names are supported and must be represented as valid URLs, like: zones/us-central1-a. The value expects an RFC3339 timestamp on or after which the update is considered rolled out to the specified location.
        """
        if default_rollout_time is not None:
            pulumi.set(__self__, "default_rollout_time", default_rollout_time)
        if location_rollout_policies is not None:
            pulumi.set(__self__, "location_rollout_policies", location_rollout_policies)

    @property
    @pulumi.getter(name="defaultRolloutTime")
    def default_rollout_time(self) -> Optional[pulumi.Input[str]]:
        """
        An optional RFC3339 timestamp on or after which the update is considered rolled out to any zone that is not explicitly stated.
        """
        return pulumi.get(self, "default_rollout_time")

    @default_rollout_time.setter
    def default_rollout_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "default_rollout_time", value)

    @property
    @pulumi.getter(name="locationRolloutPolicies")
    def location_rollout_policies(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Location based rollout policies to apply to the resource. Currently only zone names are supported and must be represented as valid URLs, like: zones/us-central1-a. The value expects an RFC3339 timestamp on or after which the update is considered rolled out to the specified location.
        """
        return pulumi.get(self, "location_rollout_policies")

    @location_rollout_policies.setter
    def location_rollout_policies(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "location_rollout_policies", value)


@pulumi.input_type
class RouterAdvertisedIpRangeArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 range: Optional[pulumi.Input[str]] = None):
        """
        Description-tagged IP ranges for the router to advertise.
        :param pulumi.Input[str] description: User-specified description for the IP range.
        :param pulumi.Input[str] range: The IP range to advertise. The value must be a CIDR-formatted string.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if range is not None:
            pulumi.set(__self__, "range", range)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        User-specified description for the IP range.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def range(self) -> Optional[pulumi.Input[str]]:
        """
        The IP range to advertise. The value must be a CIDR-formatted string.
        """
        return pulumi.get(self, "range")

    @range.setter
    def range(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "range", value)


@pulumi.input_type
class RouterBgpPeerBfdArgs:
    def __init__(__self__, *,
                 min_receive_interval: Optional[pulumi.Input[int]] = None,
                 min_transmit_interval: Optional[pulumi.Input[int]] = None,
                 multiplier: Optional[pulumi.Input[int]] = None,
                 session_initialization_mode: Optional[pulumi.Input['RouterBgpPeerBfdSessionInitializationMode']] = None):
        """
        :param pulumi.Input[int] min_receive_interval: The minimum interval, in milliseconds, between BFD control packets received from the peer router. The actual value is negotiated between the two routers and is equal to the greater of this value and the transmit interval of the other router. If set, this value must be between 1000 and 30000. The default is 1000.
        :param pulumi.Input[int] min_transmit_interval: The minimum interval, in milliseconds, between BFD control packets transmitted to the peer router. The actual value is negotiated between the two routers and is equal to the greater of this value and the corresponding receive interval of the other router. If set, this value must be between 1000 and 30000. The default is 1000.
        :param pulumi.Input[int] multiplier: The number of consecutive BFD packets that must be missed before BFD declares that a peer is unavailable. If set, the value must be a value between 5 and 16. The default is 5.
        :param pulumi.Input['RouterBgpPeerBfdSessionInitializationMode'] session_initialization_mode: The BFD session initialization mode for this BGP peer. If set to ACTIVE, the Cloud Router will initiate the BFD session for this BGP peer. If set to PASSIVE, the Cloud Router will wait for the peer router to initiate the BFD session for this BGP peer. If set to DISABLED, BFD is disabled for this BGP peer. The default is PASSIVE.
        """
        if min_receive_interval is not None:
            pulumi.set(__self__, "min_receive_interval", min_receive_interval)
        if min_transmit_interval is not None:
            pulumi.set(__self__, "min_transmit_interval", min_transmit_interval)
        if multiplier is not None:
            pulumi.set(__self__, "multiplier", multiplier)
        if session_initialization_mode is not None:
            pulumi.set(__self__, "session_initialization_mode", session_initialization_mode)

    @property
    @pulumi.getter(name="minReceiveInterval")
    def min_receive_interval(self) -> Optional[pulumi.Input[int]]:
        """
        The minimum interval, in milliseconds, between BFD control packets received from the peer router. The actual value is negotiated between the two routers and is equal to the greater of this value and the transmit interval of the other router. If set, this value must be between 1000 and 30000. The default is 1000.
        """
        return pulumi.get(self, "min_receive_interval")

    @min_receive_interval.setter
    def min_receive_interval(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_receive_interval", value)

    @property
    @pulumi.getter(name="minTransmitInterval")
    def min_transmit_interval(self) -> Optional[pulumi.Input[int]]:
        """
        The minimum interval, in milliseconds, between BFD control packets transmitted to the peer router. The actual value is negotiated between the two routers and is equal to the greater of this value and the corresponding receive interval of the other router. If set, this value must be between 1000 and 30000. The default is 1000.
        """
        return pulumi.get(self, "min_transmit_interval")

    @min_transmit_interval.setter
    def min_transmit_interval(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_transmit_interval", value)

    @property
    @pulumi.getter
    def multiplier(self) -> Optional[pulumi.Input[int]]:
        """
        The number of consecutive BFD packets that must be missed before BFD declares that a peer is unavailable. If set, the value must be a value between 5 and 16. The default is 5.
        """
        return pulumi.get(self, "multiplier")

    @multiplier.setter
    def multiplier(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "multiplier", value)

    @property
    @pulumi.getter(name="sessionInitializationMode")
    def session_initialization_mode(self) -> Optional[pulumi.Input['RouterBgpPeerBfdSessionInitializationMode']]:
        """
        The BFD session initialization mode for this BGP peer. If set to ACTIVE, the Cloud Router will initiate the BFD session for this BGP peer. If set to PASSIVE, the Cloud Router will wait for the peer router to initiate the BFD session for this BGP peer. If set to DISABLED, BFD is disabled for this BGP peer. The default is PASSIVE.
        """
        return pulumi.get(self, "session_initialization_mode")

    @session_initialization_mode.setter
    def session_initialization_mode(self, value: Optional[pulumi.Input['RouterBgpPeerBfdSessionInitializationMode']]):
        pulumi.set(self, "session_initialization_mode", value)


@pulumi.input_type
class RouterBgpPeerArgs:
    def __init__(__self__, *,
                 advertise_mode: Optional[pulumi.Input['RouterBgpPeerAdvertiseMode']] = None,
                 advertised_groups: Optional[pulumi.Input[Sequence[pulumi.Input['RouterBgpPeerAdvertisedGroupsItem']]]] = None,
                 advertised_ip_ranges: Optional[pulumi.Input[Sequence[pulumi.Input['RouterAdvertisedIpRangeArgs']]]] = None,
                 advertised_route_priority: Optional[pulumi.Input[int]] = None,
                 bfd: Optional[pulumi.Input['RouterBgpPeerBfdArgs']] = None,
                 enable: Optional[pulumi.Input['RouterBgpPeerEnable']] = None,
                 enable_ipv6: Optional[pulumi.Input[bool]] = None,
                 interface_name: Optional[pulumi.Input[str]] = None,
                 ip_address: Optional[pulumi.Input[str]] = None,
                 ipv6_nexthop_address: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 peer_asn: Optional[pulumi.Input[int]] = None,
                 peer_ip_address: Optional[pulumi.Input[str]] = None,
                 peer_ipv6_nexthop_address: Optional[pulumi.Input[str]] = None,
                 router_appliance_instance: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input['RouterBgpPeerAdvertiseMode'] advertise_mode: User-specified flag to indicate which mode to use for advertisement.
        :param pulumi.Input[Sequence[pulumi.Input['RouterBgpPeerAdvertisedGroupsItem']]] advertised_groups: User-specified list of prefix groups to advertise in custom mode, which can take one of the following options: - ALL_SUBNETS: Advertises all available subnets, including peer VPC subnets. - ALL_VPC_SUBNETS: Advertises the router's own VPC subnets. Note that this field can only be populated if advertise_mode is CUSTOM and overrides the list defined for the router (in the "bgp" message). These groups are advertised in addition to any specified prefixes. Leave this field blank to advertise no custom groups.
        :param pulumi.Input[Sequence[pulumi.Input['RouterAdvertisedIpRangeArgs']]] advertised_ip_ranges: User-specified list of individual IP ranges to advertise in custom mode. This field can only be populated if advertise_mode is CUSTOM and overrides the list defined for the router (in the "bgp" message). These IP ranges are advertised in addition to any specified groups. Leave this field blank to advertise no custom IP ranges.
        :param pulumi.Input[int] advertised_route_priority: The priority of routes advertised to this BGP peer. Where there is more than one matching route of maximum length, the routes with the lowest priority value win.
        :param pulumi.Input['RouterBgpPeerBfdArgs'] bfd: BFD configuration for the BGP peering.
        :param pulumi.Input['RouterBgpPeerEnable'] enable: The status of the BGP peer connection. If set to FALSE, any active session with the peer is terminated and all associated routing information is removed. If set to TRUE, the peer connection can be established with routing information. The default is TRUE.
        :param pulumi.Input[bool] enable_ipv6: Enable IPv6 traffic over BGP Peer. If not specified, it is disabled by default.
        :param pulumi.Input[str] interface_name: Name of the interface the BGP peer is associated with.
        :param pulumi.Input[str] ip_address: IP address of the interface inside Google Cloud Platform. Only IPv4 is supported.
        :param pulumi.Input[str] ipv6_nexthop_address: IPv6 address of the interface inside Google Cloud Platform.
        :param pulumi.Input[str] name: Name of this BGP peer. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
        :param pulumi.Input[int] peer_asn: Peer BGP Autonomous System Number (ASN). Each BGP interface may use a different value.
        :param pulumi.Input[str] peer_ip_address: IP address of the BGP interface outside Google Cloud Platform. Only IPv4 is supported.
        :param pulumi.Input[str] peer_ipv6_nexthop_address: IPv6 address of the BGP interface outside Google Cloud Platform.
        :param pulumi.Input[str] router_appliance_instance: URI of the VM instance that is used as third-party router appliances such as Next Gen Firewalls, Virtual Routers, or Router Appliances. The VM instance must be located in zones contained in the same region as this Cloud Router. The VM instance is the peer side of the BGP session.
        """
        if advertise_mode is not None:
            pulumi.set(__self__, "advertise_mode", advertise_mode)
        if advertised_groups is not None:
            pulumi.set(__self__, "advertised_groups", advertised_groups)
        if advertised_ip_ranges is not None:
            pulumi.set(__self__, "advertised_ip_ranges", advertised_ip_ranges)
        if advertised_route_priority is not None:
            pulumi.set(__self__, "advertised_route_priority", advertised_route_priority)
        if bfd is not None:
            pulumi.set(__self__, "bfd", bfd)
        if enable is not None:
            pulumi.set(__self__, "enable", enable)
        if enable_ipv6 is not None:
            pulumi.set(__self__, "enable_ipv6", enable_ipv6)
        if interface_name is not None:
            pulumi.set(__self__, "interface_name", interface_name)
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if ipv6_nexthop_address is not None:
            pulumi.set(__self__, "ipv6_nexthop_address", ipv6_nexthop_address)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if peer_asn is not None:
            pulumi.set(__self__, "peer_asn", peer_asn)
        if peer_ip_address is not None:
            pulumi.set(__self__, "peer_ip_address", peer_ip_address)
        if peer_ipv6_nexthop_address is not None:
            pulumi.set(__self__, "peer_ipv6_nexthop_address", peer_ipv6_nexthop_address)
        if router_appliance_instance is not None:
            pulumi.set(__self__, "router_appliance_instance", router_appliance_instance)

    @property
    @pulumi.getter(name="advertiseMode")
    def advertise_mode(self) -> Optional[pulumi.Input['RouterBgpPeerAdvertiseMode']]:
        """
        User-specified flag to indicate which mode to use for advertisement.
        """
        return pulumi.get(self, "advertise_mode")

    @advertise_mode.setter
    def advertise_mode(self, value: Optional[pulumi.Input['RouterBgpPeerAdvertiseMode']]):
        pulumi.set(self, "advertise_mode", value)

    @property
    @pulumi.getter(name="advertisedGroups")
    def advertised_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RouterBgpPeerAdvertisedGroupsItem']]]]:
        """
        User-specified list of prefix groups to advertise in custom mode, which can take one of the following options: - ALL_SUBNETS: Advertises all available subnets, including peer VPC subnets. - ALL_VPC_SUBNETS: Advertises the router's own VPC subnets. Note that this field can only be populated if advertise_mode is CUSTOM and overrides the list defined for the router (in the "bgp" message). These groups are advertised in addition to any specified prefixes. Leave this field blank to advertise no custom groups.
        """
        return pulumi.get(self, "advertised_groups")

    @advertised_groups.setter
    def advertised_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RouterBgpPeerAdvertisedGroupsItem']]]]):
        pulumi.set(self, "advertised_groups", value)

    @property
    @pulumi.getter(name="advertisedIpRanges")
    def advertised_ip_ranges(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RouterAdvertisedIpRangeArgs']]]]:
        """
        User-specified list of individual IP ranges to advertise in custom mode. This field can only be populated if advertise_mode is CUSTOM and overrides the list defined for the router (in the "bgp" message). These IP ranges are advertised in addition to any specified groups. Leave this field blank to advertise no custom IP ranges.
        """
        return pulumi.get(self, "advertised_ip_ranges")

    @advertised_ip_ranges.setter
    def advertised_ip_ranges(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RouterAdvertisedIpRangeArgs']]]]):
        pulumi.set(self, "advertised_ip_ranges", value)

    @property
    @pulumi.getter(name="advertisedRoutePriority")
    def advertised_route_priority(self) -> Optional[pulumi.Input[int]]:
        """
        The priority of routes advertised to this BGP peer. Where there is more than one matching route of maximum length, the routes with the lowest priority value win.
        """
        return pulumi.get(self, "advertised_route_priority")

    @advertised_route_priority.setter
    def advertised_route_priority(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "advertised_route_priority", value)

    @property
    @pulumi.getter
    def bfd(self) -> Optional[pulumi.Input['RouterBgpPeerBfdArgs']]:
        """
        BFD configuration for the BGP peering.
        """
        return pulumi.get(self, "bfd")

    @bfd.setter
    def bfd(self, value: Optional[pulumi.Input['RouterBgpPeerBfdArgs']]):
        pulumi.set(self, "bfd", value)

    @property
    @pulumi.getter
    def enable(self) -> Optional[pulumi.Input['RouterBgpPeerEnable']]:
        """
        The status of the BGP peer connection. If set to FALSE, any active session with the peer is terminated and all associated routing information is removed. If set to TRUE, the peer connection can be established with routing information. The default is TRUE.
        """
        return pulumi.get(self, "enable")

    @enable.setter
    def enable(self, value: Optional[pulumi.Input['RouterBgpPeerEnable']]):
        pulumi.set(self, "enable", value)

    @property
    @pulumi.getter(name="enableIpv6")
    def enable_ipv6(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable IPv6 traffic over BGP Peer. If not specified, it is disabled by default.
        """
        return pulumi.get(self, "enable_ipv6")

    @enable_ipv6.setter
    def enable_ipv6(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_ipv6", value)

    @property
    @pulumi.getter(name="interfaceName")
    def interface_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the interface the BGP peer is associated with.
        """
        return pulumi.get(self, "interface_name")

    @interface_name.setter
    def interface_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "interface_name", value)

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[pulumi.Input[str]]:
        """
        IP address of the interface inside Google Cloud Platform. Only IPv4 is supported.
        """
        return pulumi.get(self, "ip_address")

    @ip_address.setter
    def ip_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip_address", value)

    @property
    @pulumi.getter(name="ipv6NexthopAddress")
    def ipv6_nexthop_address(self) -> Optional[pulumi.Input[str]]:
        """
        IPv6 address of the interface inside Google Cloud Platform.
        """
        return pulumi.get(self, "ipv6_nexthop_address")

    @ipv6_nexthop_address.setter
    def ipv6_nexthop_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ipv6_nexthop_address", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of this BGP peer. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="peerAsn")
    def peer_asn(self) -> Optional[pulumi.Input[int]]:
        """
        Peer BGP Autonomous System Number (ASN). Each BGP interface may use a different value.
        """
        return pulumi.get(self, "peer_asn")

    @peer_asn.setter
    def peer_asn(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "peer_asn", value)

    @property
    @pulumi.getter(name="peerIpAddress")
    def peer_ip_address(self) -> Optional[pulumi.Input[str]]:
        """
        IP address of the BGP interface outside Google Cloud Platform. Only IPv4 is supported.
        """
        return pulumi.get(self, "peer_ip_address")

    @peer_ip_address.setter
    def peer_ip_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "peer_ip_address", value)

    @property
    @pulumi.getter(name="peerIpv6NexthopAddress")
    def peer_ipv6_nexthop_address(self) -> Optional[pulumi.Input[str]]:
        """
        IPv6 address of the BGP interface outside Google Cloud Platform.
        """
        return pulumi.get(self, "peer_ipv6_nexthop_address")

    @peer_ipv6_nexthop_address.setter
    def peer_ipv6_nexthop_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "peer_ipv6_nexthop_address", value)

    @property
    @pulumi.getter(name="routerApplianceInstance")
    def router_appliance_instance(self) -> Optional[pulumi.Input[str]]:
        """
        URI of the VM instance that is used as third-party router appliances such as Next Gen Firewalls, Virtual Routers, or Router Appliances. The VM instance must be located in zones contained in the same region as this Cloud Router. The VM instance is the peer side of the BGP session.
        """
        return pulumi.get(self, "router_appliance_instance")

    @router_appliance_instance.setter
    def router_appliance_instance(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "router_appliance_instance", value)


@pulumi.input_type
class RouterBgpArgs:
    def __init__(__self__, *,
                 advertise_mode: Optional[pulumi.Input['RouterBgpAdvertiseMode']] = None,
                 advertised_groups: Optional[pulumi.Input[Sequence[pulumi.Input['RouterBgpAdvertisedGroupsItem']]]] = None,
                 advertised_ip_ranges: Optional[pulumi.Input[Sequence[pulumi.Input['RouterAdvertisedIpRangeArgs']]]] = None,
                 asn: Optional[pulumi.Input[int]] = None,
                 keepalive_interval: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input['RouterBgpAdvertiseMode'] advertise_mode: User-specified flag to indicate which mode to use for advertisement. The options are DEFAULT or CUSTOM.
        :param pulumi.Input[Sequence[pulumi.Input['RouterBgpAdvertisedGroupsItem']]] advertised_groups: User-specified list of prefix groups to advertise in custom mode. This field can only be populated if advertise_mode is CUSTOM and is advertised to all peers of the router. These groups will be advertised in addition to any specified prefixes. Leave this field blank to advertise no custom groups.
        :param pulumi.Input[Sequence[pulumi.Input['RouterAdvertisedIpRangeArgs']]] advertised_ip_ranges: User-specified list of individual IP ranges to advertise in custom mode. This field can only be populated if advertise_mode is CUSTOM and is advertised to all peers of the router. These IP ranges will be advertised in addition to any specified groups. Leave this field blank to advertise no custom IP ranges.
        :param pulumi.Input[int] asn: Local BGP Autonomous System Number (ASN). Must be an RFC6996 private ASN, either 16-bit or 32-bit. The value will be fixed for this router resource. All VPN tunnels that link to this router will have the same local ASN.
        :param pulumi.Input[int] keepalive_interval: The interval in seconds between BGP keepalive messages that are sent to the peer. Hold time is three times the interval at which keepalive messages are sent, and the hold time is the maximum number of seconds allowed to elapse between successive keepalive messages that BGP receives from a peer. BGP will use the smaller of either the local hold time value or the peer's hold time value as the hold time for the BGP connection between the two peers. If set, this value must be between 20 and 60. The default is 20.
        """
        if advertise_mode is not None:
            pulumi.set(__self__, "advertise_mode", advertise_mode)
        if advertised_groups is not None:
            pulumi.set(__self__, "advertised_groups", advertised_groups)
        if advertised_ip_ranges is not None:
            pulumi.set(__self__, "advertised_ip_ranges", advertised_ip_ranges)
        if asn is not None:
            pulumi.set(__self__, "asn", asn)
        if keepalive_interval is not None:
            pulumi.set(__self__, "keepalive_interval", keepalive_interval)

    @property
    @pulumi.getter(name="advertiseMode")
    def advertise_mode(self) -> Optional[pulumi.Input['RouterBgpAdvertiseMode']]:
        """
        User-specified flag to indicate which mode to use for advertisement. The options are DEFAULT or CUSTOM.
        """
        return pulumi.get(self, "advertise_mode")

    @advertise_mode.setter
    def advertise_mode(self, value: Optional[pulumi.Input['RouterBgpAdvertiseMode']]):
        pulumi.set(self, "advertise_mode", value)

    @property
    @pulumi.getter(name="advertisedGroups")
    def advertised_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RouterBgpAdvertisedGroupsItem']]]]:
        """
        User-specified list of prefix groups to advertise in custom mode. This field can only be populated if advertise_mode is CUSTOM and is advertised to all peers of the router. These groups will be advertised in addition to any specified prefixes. Leave this field blank to advertise no custom groups.
        """
        return pulumi.get(self, "advertised_groups")

    @advertised_groups.setter
    def advertised_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RouterBgpAdvertisedGroupsItem']]]]):
        pulumi.set(self, "advertised_groups", value)

    @property
    @pulumi.getter(name="advertisedIpRanges")
    def advertised_ip_ranges(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RouterAdvertisedIpRangeArgs']]]]:
        """
        User-specified list of individual IP ranges to advertise in custom mode. This field can only be populated if advertise_mode is CUSTOM and is advertised to all peers of the router. These IP ranges will be advertised in addition to any specified groups. Leave this field blank to advertise no custom IP ranges.
        """
        return pulumi.get(self, "advertised_ip_ranges")

    @advertised_ip_ranges.setter
    def advertised_ip_ranges(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RouterAdvertisedIpRangeArgs']]]]):
        pulumi.set(self, "advertised_ip_ranges", value)

    @property
    @pulumi.getter
    def asn(self) -> Optional[pulumi.Input[int]]:
        """
        Local BGP Autonomous System Number (ASN). Must be an RFC6996 private ASN, either 16-bit or 32-bit. The value will be fixed for this router resource. All VPN tunnels that link to this router will have the same local ASN.
        """
        return pulumi.get(self, "asn")

    @asn.setter
    def asn(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "asn", value)

    @property
    @pulumi.getter(name="keepaliveInterval")
    def keepalive_interval(self) -> Optional[pulumi.Input[int]]:
        """
        The interval in seconds between BGP keepalive messages that are sent to the peer. Hold time is three times the interval at which keepalive messages are sent, and the hold time is the maximum number of seconds allowed to elapse between successive keepalive messages that BGP receives from a peer. BGP will use the smaller of either the local hold time value or the peer's hold time value as the hold time for the BGP connection between the two peers. If set, this value must be between 20 and 60. The default is 20.
        """
        return pulumi.get(self, "keepalive_interval")

    @keepalive_interval.setter
    def keepalive_interval(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "keepalive_interval", value)


@pulumi.input_type
class RouterInterfaceArgs:
    def __init__(__self__, *,
                 ip_range: Optional[pulumi.Input[str]] = None,
                 linked_interconnect_attachment: Optional[pulumi.Input[str]] = None,
                 linked_vpn_tunnel: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 private_ip_address: Optional[pulumi.Input[str]] = None,
                 redundant_interface: Optional[pulumi.Input[str]] = None,
                 subnetwork: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] ip_range: IP address and range of the interface. The IP range must be in the RFC3927 link-local IP address space. The value must be a CIDR-formatted string, for example: 169.254.0.1/30. NOTE: Do not truncate the address as it represents the IP address of the interface.
        :param pulumi.Input[str] linked_interconnect_attachment: URI of the linked Interconnect attachment. It must be in the same region as the router. Each interface can have one linked resource, which can be a VPN tunnel, an Interconnect attachment, or a virtual machine instance.
        :param pulumi.Input[str] linked_vpn_tunnel: URI of the linked VPN tunnel, which must be in the same region as the router. Each interface can have one linked resource, which can be a VPN tunnel, an Interconnect attachment, or a virtual machine instance.
        :param pulumi.Input[str] name: Name of this interface entry. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
        :param pulumi.Input[str] private_ip_address: The regional private internal IP address that is used to establish BGP sessions to a VM instance acting as a third-party Router Appliance, such as a Next Gen Firewall, a Virtual Router, or an SD-WAN VM.
        :param pulumi.Input[str] redundant_interface: Name of the interface that will be redundant with the current interface you are creating. The redundantInterface must belong to the same Cloud Router as the interface here. To establish the BGP session to a Router Appliance VM, you must create two BGP peers. The two BGP peers must be attached to two separate interfaces that are redundant with each other. The redundant_interface must be 1-63 characters long, and comply with RFC1035. Specifically, the redundant_interface must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
        :param pulumi.Input[str] subnetwork: The URI of the subnetwork resource that this interface belongs to, which must be in the same region as the Cloud Router. When you establish a BGP session to a VM instance using this interface, the VM instance must belong to the same subnetwork as the subnetwork specified here.
        """
        if ip_range is not None:
            pulumi.set(__self__, "ip_range", ip_range)
        if linked_interconnect_attachment is not None:
            pulumi.set(__self__, "linked_interconnect_attachment", linked_interconnect_attachment)
        if linked_vpn_tunnel is not None:
            pulumi.set(__self__, "linked_vpn_tunnel", linked_vpn_tunnel)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if private_ip_address is not None:
            pulumi.set(__self__, "private_ip_address", private_ip_address)
        if redundant_interface is not None:
            pulumi.set(__self__, "redundant_interface", redundant_interface)
        if subnetwork is not None:
            pulumi.set(__self__, "subnetwork", subnetwork)

    @property
    @pulumi.getter(name="ipRange")
    def ip_range(self) -> Optional[pulumi.Input[str]]:
        """
        IP address and range of the interface. The IP range must be in the RFC3927 link-local IP address space. The value must be a CIDR-formatted string, for example: 169.254.0.1/30. NOTE: Do not truncate the address as it represents the IP address of the interface.
        """
        return pulumi.get(self, "ip_range")

    @ip_range.setter
    def ip_range(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip_range", value)

    @property
    @pulumi.getter(name="linkedInterconnectAttachment")
    def linked_interconnect_attachment(self) -> Optional[pulumi.Input[str]]:
        """
        URI of the linked Interconnect attachment. It must be in the same region as the router. Each interface can have one linked resource, which can be a VPN tunnel, an Interconnect attachment, or a virtual machine instance.
        """
        return pulumi.get(self, "linked_interconnect_attachment")

    @linked_interconnect_attachment.setter
    def linked_interconnect_attachment(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "linked_interconnect_attachment", value)

    @property
    @pulumi.getter(name="linkedVpnTunnel")
    def linked_vpn_tunnel(self) -> Optional[pulumi.Input[str]]:
        """
        URI of the linked VPN tunnel, which must be in the same region as the router. Each interface can have one linked resource, which can be a VPN tunnel, an Interconnect attachment, or a virtual machine instance.
        """
        return pulumi.get(self, "linked_vpn_tunnel")

    @linked_vpn_tunnel.setter
    def linked_vpn_tunnel(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "linked_vpn_tunnel", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of this interface entry. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="privateIpAddress")
    def private_ip_address(self) -> Optional[pulumi.Input[str]]:
        """
        The regional private internal IP address that is used to establish BGP sessions to a VM instance acting as a third-party Router Appliance, such as a Next Gen Firewall, a Virtual Router, or an SD-WAN VM.
        """
        return pulumi.get(self, "private_ip_address")

    @private_ip_address.setter
    def private_ip_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_ip_address", value)

    @property
    @pulumi.getter(name="redundantInterface")
    def redundant_interface(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the interface that will be redundant with the current interface you are creating. The redundantInterface must belong to the same Cloud Router as the interface here. To establish the BGP session to a Router Appliance VM, you must create two BGP peers. The two BGP peers must be attached to two separate interfaces that are redundant with each other. The redundant_interface must be 1-63 characters long, and comply with RFC1035. Specifically, the redundant_interface must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
        """
        return pulumi.get(self, "redundant_interface")

    @redundant_interface.setter
    def redundant_interface(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "redundant_interface", value)

    @property
    @pulumi.getter
    def subnetwork(self) -> Optional[pulumi.Input[str]]:
        """
        The URI of the subnetwork resource that this interface belongs to, which must be in the same region as the Cloud Router. When you establish a BGP session to a VM instance using this interface, the VM instance must belong to the same subnetwork as the subnetwork specified here.
        """
        return pulumi.get(self, "subnetwork")

    @subnetwork.setter
    def subnetwork(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnetwork", value)


@pulumi.input_type
class RouterNatLogConfigArgs:
    def __init__(__self__, *,
                 enable: Optional[pulumi.Input[bool]] = None,
                 filter: Optional[pulumi.Input['RouterNatLogConfigFilter']] = None):
        """
        Configuration of logging on a NAT.
        :param pulumi.Input[bool] enable: Indicates whether or not to export logs. This is false by default.
        :param pulumi.Input['RouterNatLogConfigFilter'] filter: Specify the desired filtering of logs on this NAT. If unspecified, logs are exported for all connections handled by this NAT. This option can take one of the following values: - ERRORS_ONLY: Export logs only for connection failures. - TRANSLATIONS_ONLY: Export logs only for successful connections. - ALL: Export logs for all connections, successful and unsuccessful. 
        """
        if enable is not None:
            pulumi.set(__self__, "enable", enable)
        if filter is not None:
            pulumi.set(__self__, "filter", filter)

    @property
    @pulumi.getter
    def enable(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether or not to export logs. This is false by default.
        """
        return pulumi.get(self, "enable")

    @enable.setter
    def enable(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable", value)

    @property
    @pulumi.getter
    def filter(self) -> Optional[pulumi.Input['RouterNatLogConfigFilter']]:
        """
        Specify the desired filtering of logs on this NAT. If unspecified, logs are exported for all connections handled by this NAT. This option can take one of the following values: - ERRORS_ONLY: Export logs only for connection failures. - TRANSLATIONS_ONLY: Export logs only for successful connections. - ALL: Export logs for all connections, successful and unsuccessful. 
        """
        return pulumi.get(self, "filter")

    @filter.setter
    def filter(self, value: Optional[pulumi.Input['RouterNatLogConfigFilter']]):
        pulumi.set(self, "filter", value)


@pulumi.input_type
class RouterNatRuleActionArgs:
    def __init__(__self__, *,
                 source_nat_active_ips: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 source_nat_drain_ips: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] source_nat_active_ips: A list of URLs of the IP resources used for this NAT rule. These IP addresses must be valid static external IP addresses assigned to the project. This field is used for public NAT.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] source_nat_drain_ips: A list of URLs of the IP resources to be drained. These IPs must be valid static external IPs that have been assigned to the NAT. These IPs should be used for updating/patching a NAT rule only. This field is used for public NAT.
        """
        if source_nat_active_ips is not None:
            pulumi.set(__self__, "source_nat_active_ips", source_nat_active_ips)
        if source_nat_drain_ips is not None:
            pulumi.set(__self__, "source_nat_drain_ips", source_nat_drain_ips)

    @property
    @pulumi.getter(name="sourceNatActiveIps")
    def source_nat_active_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of URLs of the IP resources used for this NAT rule. These IP addresses must be valid static external IP addresses assigned to the project. This field is used for public NAT.
        """
        return pulumi.get(self, "source_nat_active_ips")

    @source_nat_active_ips.setter
    def source_nat_active_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "source_nat_active_ips", value)

    @property
    @pulumi.getter(name="sourceNatDrainIps")
    def source_nat_drain_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of URLs of the IP resources to be drained. These IPs must be valid static external IPs that have been assigned to the NAT. These IPs should be used for updating/patching a NAT rule only. This field is used for public NAT.
        """
        return pulumi.get(self, "source_nat_drain_ips")

    @source_nat_drain_ips.setter
    def source_nat_drain_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "source_nat_drain_ips", value)


@pulumi.input_type
class RouterNatRuleArgs:
    def __init__(__self__, *,
                 action: Optional[pulumi.Input['RouterNatRuleActionArgs']] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 match: Optional[pulumi.Input[str]] = None,
                 rule_number: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input['RouterNatRuleActionArgs'] action: The action to be enforced for traffic that matches this rule.
        :param pulumi.Input[str] description: An optional description of this rule.
        :param pulumi.Input[str] match: CEL expression that specifies the match condition that egress traffic from a VM is evaluated against. If it evaluates to true, the corresponding `action` is enforced. The following examples are valid match expressions for public NAT: "inIpRange(destination.ip, '1.1.0.0/16') || inIpRange(destination.ip, '2.2.0.0/16')" "destination.ip == '1.1.0.1' || destination.ip == '8.8.8.8'" The following example is a valid match expression for private NAT: "nexthop.hub == 'https://networkconnectivity.googleapis.com/v1alpha1/projects/my-project/global/hub/hub-1'"
        :param pulumi.Input[int] rule_number: An integer uniquely identifying a rule in the list. The rule number must be a positive value between 0 and 65000, and must be unique among rules within a NAT.
        """
        if action is not None:
            pulumi.set(__self__, "action", action)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if match is not None:
            pulumi.set(__self__, "match", match)
        if rule_number is not None:
            pulumi.set(__self__, "rule_number", rule_number)

    @property
    @pulumi.getter
    def action(self) -> Optional[pulumi.Input['RouterNatRuleActionArgs']]:
        """
        The action to be enforced for traffic that matches this rule.
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: Optional[pulumi.Input['RouterNatRuleActionArgs']]):
        pulumi.set(self, "action", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        An optional description of this rule.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def match(self) -> Optional[pulumi.Input[str]]:
        """
        CEL expression that specifies the match condition that egress traffic from a VM is evaluated against. If it evaluates to true, the corresponding `action` is enforced. The following examples are valid match expressions for public NAT: "inIpRange(destination.ip, '1.1.0.0/16') || inIpRange(destination.ip, '2.2.0.0/16')" "destination.ip == '1.1.0.1' || destination.ip == '8.8.8.8'" The following example is a valid match expression for private NAT: "nexthop.hub == 'https://networkconnectivity.googleapis.com/v1alpha1/projects/my-project/global/hub/hub-1'"
        """
        return pulumi.get(self, "match")

    @match.setter
    def match(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "match", value)

    @property
    @pulumi.getter(name="ruleNumber")
    def rule_number(self) -> Optional[pulumi.Input[int]]:
        """
        An integer uniquely identifying a rule in the list. The rule number must be a positive value between 0 and 65000, and must be unique among rules within a NAT.
        """
        return pulumi.get(self, "rule_number")

    @rule_number.setter
    def rule_number(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "rule_number", value)


@pulumi.input_type
class RouterNatSubnetworkToNatArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 secondary_ip_range_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 source_ip_ranges_to_nat: Optional[pulumi.Input[Sequence[pulumi.Input['RouterNatSubnetworkToNatSourceIpRangesToNatItem']]]] = None):
        """
        Defines the IP ranges that want to use NAT for a subnetwork.
        :param pulumi.Input[str] name: URL for the subnetwork resource that will use NAT.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] secondary_ip_range_names: A list of the secondary ranges of the Subnetwork that are allowed to use NAT. This can be populated only if "LIST_OF_SECONDARY_IP_RANGES" is one of the values in source_ip_ranges_to_nat.
        :param pulumi.Input[Sequence[pulumi.Input['RouterNatSubnetworkToNatSourceIpRangesToNatItem']]] source_ip_ranges_to_nat: Specify the options for NAT ranges in the Subnetwork. All options of a single value are valid except NAT_IP_RANGE_OPTION_UNSPECIFIED. The only valid option with multiple values is: ["PRIMARY_IP_RANGE", "LIST_OF_SECONDARY_IP_RANGES"] Default: [ALL_IP_RANGES]
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if secondary_ip_range_names is not None:
            pulumi.set(__self__, "secondary_ip_range_names", secondary_ip_range_names)
        if source_ip_ranges_to_nat is not None:
            pulumi.set(__self__, "source_ip_ranges_to_nat", source_ip_ranges_to_nat)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        URL for the subnetwork resource that will use NAT.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="secondaryIpRangeNames")
    def secondary_ip_range_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of the secondary ranges of the Subnetwork that are allowed to use NAT. This can be populated only if "LIST_OF_SECONDARY_IP_RANGES" is one of the values in source_ip_ranges_to_nat.
        """
        return pulumi.get(self, "secondary_ip_range_names")

    @secondary_ip_range_names.setter
    def secondary_ip_range_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "secondary_ip_range_names", value)

    @property
    @pulumi.getter(name="sourceIpRangesToNat")
    def source_ip_ranges_to_nat(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RouterNatSubnetworkToNatSourceIpRangesToNatItem']]]]:
        """
        Specify the options for NAT ranges in the Subnetwork. All options of a single value are valid except NAT_IP_RANGE_OPTION_UNSPECIFIED. The only valid option with multiple values is: ["PRIMARY_IP_RANGE", "LIST_OF_SECONDARY_IP_RANGES"] Default: [ALL_IP_RANGES]
        """
        return pulumi.get(self, "source_ip_ranges_to_nat")

    @source_ip_ranges_to_nat.setter
    def source_ip_ranges_to_nat(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RouterNatSubnetworkToNatSourceIpRangesToNatItem']]]]):
        pulumi.set(self, "source_ip_ranges_to_nat", value)


@pulumi.input_type
class RouterNatArgs:
    def __init__(__self__, *,
                 drain_nat_ips: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 enable_dynamic_port_allocation: Optional[pulumi.Input[bool]] = None,
                 enable_endpoint_independent_mapping: Optional[pulumi.Input[bool]] = None,
                 icmp_idle_timeout_sec: Optional[pulumi.Input[int]] = None,
                 log_config: Optional[pulumi.Input['RouterNatLogConfigArgs']] = None,
                 max_ports_per_vm: Optional[pulumi.Input[int]] = None,
                 min_ports_per_vm: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 nat_ip_allocate_option: Optional[pulumi.Input['RouterNatNatIpAllocateOption']] = None,
                 nat_ips: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input['RouterNatRuleArgs']]]] = None,
                 source_subnetwork_ip_ranges_to_nat: Optional[pulumi.Input['RouterNatSourceSubnetworkIpRangesToNat']] = None,
                 subnetworks: Optional[pulumi.Input[Sequence[pulumi.Input['RouterNatSubnetworkToNatArgs']]]] = None,
                 tcp_established_idle_timeout_sec: Optional[pulumi.Input[int]] = None,
                 tcp_time_wait_timeout_sec: Optional[pulumi.Input[int]] = None,
                 tcp_transitory_idle_timeout_sec: Optional[pulumi.Input[int]] = None,
                 udp_idle_timeout_sec: Optional[pulumi.Input[int]] = None):
        """
        Represents a Nat resource. It enables the VMs within the specified subnetworks to access Internet without external IP addresses. It specifies a list of subnetworks (and the ranges within) that want to use NAT. Customers can also provide the external IPs that would be used for NAT. GCP would auto-allocate ephemeral IPs if no external IPs are provided.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] drain_nat_ips: A list of URLs of the IP resources to be drained. These IPs must be valid static external IPs that have been assigned to the NAT. These IPs should be used for updating/patching a NAT only.
        :param pulumi.Input[bool] enable_dynamic_port_allocation: Enable Dynamic Port Allocation. If not specified, it is disabled by default. If set to true, - Dynamic Port Allocation will be enabled on this NAT config. - enableEndpointIndependentMapping cannot be set to true. - If minPorts is set, minPortsPerVm must be set to a power of two greater than or equal to 32. If minPortsPerVm is not set, a minimum of 32 ports will be allocated to a VM from this NAT config. 
        :param pulumi.Input[int] icmp_idle_timeout_sec: Timeout (in seconds) for ICMP connections. Defaults to 30s if not set.
        :param pulumi.Input['RouterNatLogConfigArgs'] log_config: Configure logging on this NAT.
        :param pulumi.Input[int] max_ports_per_vm: Maximum number of ports allocated to a VM from this NAT config when Dynamic Port Allocation is enabled. If Dynamic Port Allocation is not enabled, this field has no effect. If Dynamic Port Allocation is enabled, and this field is set, it must be set to a power of two greater than minPortsPerVm, or 64 if minPortsPerVm is not set. If Dynamic Port Allocation is enabled and this field is not set, a maximum of 65536 ports will be allocated to a VM from this NAT config.
        :param pulumi.Input[int] min_ports_per_vm: Minimum number of ports allocated to a VM from this NAT config. If not set, a default number of ports is allocated to a VM. This is rounded up to the nearest power of 2. For example, if the value of this field is 50, at least 64 ports are allocated to a VM.
        :param pulumi.Input[str] name: Unique name of this Nat service. The name must be 1-63 characters long and comply with RFC1035.
        :param pulumi.Input['RouterNatNatIpAllocateOption'] nat_ip_allocate_option: Specify the NatIpAllocateOption, which can take one of the following values: - MANUAL_ONLY: Uses only Nat IP addresses provided by customers. When there are not enough specified Nat IPs, the Nat service fails for new VMs. - AUTO_ONLY: Nat IPs are allocated by Google Cloud Platform; customers can't specify any Nat IPs. When choosing AUTO_ONLY, then nat_ip should be empty. 
        :param pulumi.Input[Sequence[pulumi.Input[str]]] nat_ips: A list of URLs of the IP resources used for this Nat service. These IP addresses must be valid static external IP addresses assigned to the project.
        :param pulumi.Input[Sequence[pulumi.Input['RouterNatRuleArgs']]] rules: A list of rules associated with this NAT.
        :param pulumi.Input['RouterNatSourceSubnetworkIpRangesToNat'] source_subnetwork_ip_ranges_to_nat: Specify the Nat option, which can take one of the following values: - ALL_SUBNETWORKS_ALL_IP_RANGES: All of the IP ranges in every Subnetwork are allowed to Nat. - ALL_SUBNETWORKS_ALL_PRIMARY_IP_RANGES: All of the primary IP ranges in every Subnetwork are allowed to Nat. - LIST_OF_SUBNETWORKS: A list of Subnetworks are allowed to Nat (specified in the field subnetwork below) The default is SUBNETWORK_IP_RANGE_TO_NAT_OPTION_UNSPECIFIED. Note that if this field contains ALL_SUBNETWORKS_ALL_IP_RANGES or ALL_SUBNETWORKS_ALL_PRIMARY_IP_RANGES, then there should not be any other Router.Nat section in any Router for this network in this region.
        :param pulumi.Input[Sequence[pulumi.Input['RouterNatSubnetworkToNatArgs']]] subnetworks: A list of Subnetwork resources whose traffic should be translated by NAT Gateway. It is used only when LIST_OF_SUBNETWORKS is selected for the SubnetworkIpRangeToNatOption above.
        :param pulumi.Input[int] tcp_established_idle_timeout_sec: Timeout (in seconds) for TCP established connections. Defaults to 1200s if not set.
        :param pulumi.Input[int] tcp_time_wait_timeout_sec: Timeout (in seconds) for TCP connections that are in TIME_WAIT state. Defaults to 120s if not set.
        :param pulumi.Input[int] tcp_transitory_idle_timeout_sec: Timeout (in seconds) for TCP transitory connections. Defaults to 30s if not set.
        :param pulumi.Input[int] udp_idle_timeout_sec: Timeout (in seconds) for UDP connections. Defaults to 30s if not set.
        """
        if drain_nat_ips is not None:
            pulumi.set(__self__, "drain_nat_ips", drain_nat_ips)
        if enable_dynamic_port_allocation is not None:
            pulumi.set(__self__, "enable_dynamic_port_allocation", enable_dynamic_port_allocation)
        if enable_endpoint_independent_mapping is not None:
            pulumi.set(__self__, "enable_endpoint_independent_mapping", enable_endpoint_independent_mapping)
        if icmp_idle_timeout_sec is not None:
            pulumi.set(__self__, "icmp_idle_timeout_sec", icmp_idle_timeout_sec)
        if log_config is not None:
            pulumi.set(__self__, "log_config", log_config)
        if max_ports_per_vm is not None:
            pulumi.set(__self__, "max_ports_per_vm", max_ports_per_vm)
        if min_ports_per_vm is not None:
            pulumi.set(__self__, "min_ports_per_vm", min_ports_per_vm)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if nat_ip_allocate_option is not None:
            pulumi.set(__self__, "nat_ip_allocate_option", nat_ip_allocate_option)
        if nat_ips is not None:
            pulumi.set(__self__, "nat_ips", nat_ips)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)
        if source_subnetwork_ip_ranges_to_nat is not None:
            pulumi.set(__self__, "source_subnetwork_ip_ranges_to_nat", source_subnetwork_ip_ranges_to_nat)
        if subnetworks is not None:
            pulumi.set(__self__, "subnetworks", subnetworks)
        if tcp_established_idle_timeout_sec is not None:
            pulumi.set(__self__, "tcp_established_idle_timeout_sec", tcp_established_idle_timeout_sec)
        if tcp_time_wait_timeout_sec is not None:
            pulumi.set(__self__, "tcp_time_wait_timeout_sec", tcp_time_wait_timeout_sec)
        if tcp_transitory_idle_timeout_sec is not None:
            pulumi.set(__self__, "tcp_transitory_idle_timeout_sec", tcp_transitory_idle_timeout_sec)
        if udp_idle_timeout_sec is not None:
            pulumi.set(__self__, "udp_idle_timeout_sec", udp_idle_timeout_sec)

    @property
    @pulumi.getter(name="drainNatIps")
    def drain_nat_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of URLs of the IP resources to be drained. These IPs must be valid static external IPs that have been assigned to the NAT. These IPs should be used for updating/patching a NAT only.
        """
        return pulumi.get(self, "drain_nat_ips")

    @drain_nat_ips.setter
    def drain_nat_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "drain_nat_ips", value)

    @property
    @pulumi.getter(name="enableDynamicPortAllocation")
    def enable_dynamic_port_allocation(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable Dynamic Port Allocation. If not specified, it is disabled by default. If set to true, - Dynamic Port Allocation will be enabled on this NAT config. - enableEndpointIndependentMapping cannot be set to true. - If minPorts is set, minPortsPerVm must be set to a power of two greater than or equal to 32. If minPortsPerVm is not set, a minimum of 32 ports will be allocated to a VM from this NAT config. 
        """
        return pulumi.get(self, "enable_dynamic_port_allocation")

    @enable_dynamic_port_allocation.setter
    def enable_dynamic_port_allocation(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_dynamic_port_allocation", value)

    @property
    @pulumi.getter(name="enableEndpointIndependentMapping")
    def enable_endpoint_independent_mapping(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "enable_endpoint_independent_mapping")

    @enable_endpoint_independent_mapping.setter
    def enable_endpoint_independent_mapping(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_endpoint_independent_mapping", value)

    @property
    @pulumi.getter(name="icmpIdleTimeoutSec")
    def icmp_idle_timeout_sec(self) -> Optional[pulumi.Input[int]]:
        """
        Timeout (in seconds) for ICMP connections. Defaults to 30s if not set.
        """
        return pulumi.get(self, "icmp_idle_timeout_sec")

    @icmp_idle_timeout_sec.setter
    def icmp_idle_timeout_sec(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "icmp_idle_timeout_sec", value)

    @property
    @pulumi.getter(name="logConfig")
    def log_config(self) -> Optional[pulumi.Input['RouterNatLogConfigArgs']]:
        """
        Configure logging on this NAT.
        """
        return pulumi.get(self, "log_config")

    @log_config.setter
    def log_config(self, value: Optional[pulumi.Input['RouterNatLogConfigArgs']]):
        pulumi.set(self, "log_config", value)

    @property
    @pulumi.getter(name="maxPortsPerVm")
    def max_ports_per_vm(self) -> Optional[pulumi.Input[int]]:
        """
        Maximum number of ports allocated to a VM from this NAT config when Dynamic Port Allocation is enabled. If Dynamic Port Allocation is not enabled, this field has no effect. If Dynamic Port Allocation is enabled, and this field is set, it must be set to a power of two greater than minPortsPerVm, or 64 if minPortsPerVm is not set. If Dynamic Port Allocation is enabled and this field is not set, a maximum of 65536 ports will be allocated to a VM from this NAT config.
        """
        return pulumi.get(self, "max_ports_per_vm")

    @max_ports_per_vm.setter
    def max_ports_per_vm(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_ports_per_vm", value)

    @property
    @pulumi.getter(name="minPortsPerVm")
    def min_ports_per_vm(self) -> Optional[pulumi.Input[int]]:
        """
        Minimum number of ports allocated to a VM from this NAT config. If not set, a default number of ports is allocated to a VM. This is rounded up to the nearest power of 2. For example, if the value of this field is 50, at least 64 ports are allocated to a VM.
        """
        return pulumi.get(self, "min_ports_per_vm")

    @min_ports_per_vm.setter
    def min_ports_per_vm(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_ports_per_vm", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Unique name of this Nat service. The name must be 1-63 characters long and comply with RFC1035.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="natIpAllocateOption")
    def nat_ip_allocate_option(self) -> Optional[pulumi.Input['RouterNatNatIpAllocateOption']]:
        """
        Specify the NatIpAllocateOption, which can take one of the following values: - MANUAL_ONLY: Uses only Nat IP addresses provided by customers. When there are not enough specified Nat IPs, the Nat service fails for new VMs. - AUTO_ONLY: Nat IPs are allocated by Google Cloud Platform; customers can't specify any Nat IPs. When choosing AUTO_ONLY, then nat_ip should be empty. 
        """
        return pulumi.get(self, "nat_ip_allocate_option")

    @nat_ip_allocate_option.setter
    def nat_ip_allocate_option(self, value: Optional[pulumi.Input['RouterNatNatIpAllocateOption']]):
        pulumi.set(self, "nat_ip_allocate_option", value)

    @property
    @pulumi.getter(name="natIps")
    def nat_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of URLs of the IP resources used for this Nat service. These IP addresses must be valid static external IP addresses assigned to the project.
        """
        return pulumi.get(self, "nat_ips")

    @nat_ips.setter
    def nat_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "nat_ips", value)

    @property
    @pulumi.getter
    def rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RouterNatRuleArgs']]]]:
        """
        A list of rules associated with this NAT.
        """
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RouterNatRuleArgs']]]]):
        pulumi.set(self, "rules", value)

    @property
    @pulumi.getter(name="sourceSubnetworkIpRangesToNat")
    def source_subnetwork_ip_ranges_to_nat(self) -> Optional[pulumi.Input['RouterNatSourceSubnetworkIpRangesToNat']]:
        """
        Specify the Nat option, which can take one of the following values: - ALL_SUBNETWORKS_ALL_IP_RANGES: All of the IP ranges in every Subnetwork are allowed to Nat. - ALL_SUBNETWORKS_ALL_PRIMARY_IP_RANGES: All of the primary IP ranges in every Subnetwork are allowed to Nat. - LIST_OF_SUBNETWORKS: A list of Subnetworks are allowed to Nat (specified in the field subnetwork below) The default is SUBNETWORK_IP_RANGE_TO_NAT_OPTION_UNSPECIFIED. Note that if this field contains ALL_SUBNETWORKS_ALL_IP_RANGES or ALL_SUBNETWORKS_ALL_PRIMARY_IP_RANGES, then there should not be any other Router.Nat section in any Router for this network in this region.
        """
        return pulumi.get(self, "source_subnetwork_ip_ranges_to_nat")

    @source_subnetwork_ip_ranges_to_nat.setter
    def source_subnetwork_ip_ranges_to_nat(self, value: Optional[pulumi.Input['RouterNatSourceSubnetworkIpRangesToNat']]):
        pulumi.set(self, "source_subnetwork_ip_ranges_to_nat", value)

    @property
    @pulumi.getter
    def subnetworks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RouterNatSubnetworkToNatArgs']]]]:
        """
        A list of Subnetwork resources whose traffic should be translated by NAT Gateway. It is used only when LIST_OF_SUBNETWORKS is selected for the SubnetworkIpRangeToNatOption above.
        """
        return pulumi.get(self, "subnetworks")

    @subnetworks.setter
    def subnetworks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RouterNatSubnetworkToNatArgs']]]]):
        pulumi.set(self, "subnetworks", value)

    @property
    @pulumi.getter(name="tcpEstablishedIdleTimeoutSec")
    def tcp_established_idle_timeout_sec(self) -> Optional[pulumi.Input[int]]:
        """
        Timeout (in seconds) for TCP established connections. Defaults to 1200s if not set.
        """
        return pulumi.get(self, "tcp_established_idle_timeout_sec")

    @tcp_established_idle_timeout_sec.setter
    def tcp_established_idle_timeout_sec(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "tcp_established_idle_timeout_sec", value)

    @property
    @pulumi.getter(name="tcpTimeWaitTimeoutSec")
    def tcp_time_wait_timeout_sec(self) -> Optional[pulumi.Input[int]]:
        """
        Timeout (in seconds) for TCP connections that are in TIME_WAIT state. Defaults to 120s if not set.
        """
        return pulumi.get(self, "tcp_time_wait_timeout_sec")

    @tcp_time_wait_timeout_sec.setter
    def tcp_time_wait_timeout_sec(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "tcp_time_wait_timeout_sec", value)

    @property
    @pulumi.getter(name="tcpTransitoryIdleTimeoutSec")
    def tcp_transitory_idle_timeout_sec(self) -> Optional[pulumi.Input[int]]:
        """
        Timeout (in seconds) for TCP transitory connections. Defaults to 30s if not set.
        """
        return pulumi.get(self, "tcp_transitory_idle_timeout_sec")

    @tcp_transitory_idle_timeout_sec.setter
    def tcp_transitory_idle_timeout_sec(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "tcp_transitory_idle_timeout_sec", value)

    @property
    @pulumi.getter(name="udpIdleTimeoutSec")
    def udp_idle_timeout_sec(self) -> Optional[pulumi.Input[int]]:
        """
        Timeout (in seconds) for UDP connections. Defaults to 30s if not set.
        """
        return pulumi.get(self, "udp_idle_timeout_sec")

    @udp_idle_timeout_sec.setter
    def udp_idle_timeout_sec(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "udp_idle_timeout_sec", value)


@pulumi.input_type
class RuleArgs:
    def __init__(__self__, *,
                 action: Optional[pulumi.Input['RuleAction']] = None,
                 conditions: Optional[pulumi.Input[Sequence[pulumi.Input['ConditionArgs']]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 ins: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 log_configs: Optional[pulumi.Input[Sequence[pulumi.Input['LogConfigArgs']]]] = None,
                 not_ins: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 permissions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        This is deprecated and has no effect. Do not use.
        :param pulumi.Input['RuleAction'] action: This is deprecated and has no effect. Do not use.
        :param pulumi.Input[Sequence[pulumi.Input['ConditionArgs']]] conditions: This is deprecated and has no effect. Do not use.
        :param pulumi.Input[str] description: This is deprecated and has no effect. Do not use.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ins: This is deprecated and has no effect. Do not use.
        :param pulumi.Input[Sequence[pulumi.Input['LogConfigArgs']]] log_configs: This is deprecated and has no effect. Do not use.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] not_ins: This is deprecated and has no effect. Do not use.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] permissions: This is deprecated and has no effect. Do not use.
        """
        if action is not None:
            pulumi.set(__self__, "action", action)
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if ins is not None:
            pulumi.set(__self__, "ins", ins)
        if log_configs is not None:
            pulumi.set(__self__, "log_configs", log_configs)
        if not_ins is not None:
            pulumi.set(__self__, "not_ins", not_ins)
        if permissions is not None:
            pulumi.set(__self__, "permissions", permissions)

    @property
    @pulumi.getter
    def action(self) -> Optional[pulumi.Input['RuleAction']]:
        """
        This is deprecated and has no effect. Do not use.
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: Optional[pulumi.Input['RuleAction']]):
        pulumi.set(self, "action", value)

    @property
    @pulumi.getter
    def conditions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ConditionArgs']]]]:
        """
        This is deprecated and has no effect. Do not use.
        """
        return pulumi.get(self, "conditions")

    @conditions.setter
    def conditions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ConditionArgs']]]]):
        pulumi.set(self, "conditions", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        This is deprecated and has no effect. Do not use.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def ins(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        This is deprecated and has no effect. Do not use.
        """
        return pulumi.get(self, "ins")

    @ins.setter
    def ins(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "ins", value)

    @property
    @pulumi.getter(name="logConfigs")
    def log_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LogConfigArgs']]]]:
        """
        This is deprecated and has no effect. Do not use.
        """
        return pulumi.get(self, "log_configs")

    @log_configs.setter
    def log_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LogConfigArgs']]]]):
        pulumi.set(self, "log_configs", value)

    @property
    @pulumi.getter(name="notIns")
    def not_ins(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        This is deprecated and has no effect. Do not use.
        """
        return pulumi.get(self, "not_ins")

    @not_ins.setter
    def not_ins(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "not_ins", value)

    @property
    @pulumi.getter
    def permissions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        This is deprecated and has no effect. Do not use.
        """
        return pulumi.get(self, "permissions")

    @permissions.setter
    def permissions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "permissions", value)


@pulumi.input_type
class SSLHealthCheckArgs:
    def __init__(__self__, *,
                 port: Optional[pulumi.Input[int]] = None,
                 port_name: Optional[pulumi.Input[str]] = None,
                 port_specification: Optional[pulumi.Input['SSLHealthCheckPortSpecification']] = None,
                 proxy_header: Optional[pulumi.Input['SSLHealthCheckProxyHeader']] = None,
                 request: Optional[pulumi.Input[str]] = None,
                 response: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[int] port: The TCP port number for the health check request. The default value is 443. Valid values are 1 through 65535.
        :param pulumi.Input[str] port_name: Port name as defined in InstanceGroup#NamedPort#name. If both port and port_name are defined, port takes precedence.
        :param pulumi.Input['SSLHealthCheckPortSpecification'] port_specification: Specifies how port is selected for health checking, can be one of following values: USE_FIXED_PORT: The port number in port is used for health checking. USE_NAMED_PORT: The portName is used for health checking. USE_SERVING_PORT: For NetworkEndpointGroup, the port specified for each network endpoint is used for health checking. For other backends, the port or named port specified in the Backend Service is used for health checking. If not specified, SSL health check follows behavior specified in port and portName fields.
        :param pulumi.Input['SSLHealthCheckProxyHeader'] proxy_header: Specifies the type of proxy header to append before sending data to the backend, either NONE or PROXY_V1. The default is NONE.
        :param pulumi.Input[str] request: The application data to send once the SSL connection has been established (default value is empty). If both request and response are empty, the connection establishment alone will indicate health. The request data can only be ASCII.
        :param pulumi.Input[str] response: The bytes to match against the beginning of the response data. If left empty (the default value), any response will indicate health. The response data can only be ASCII.
        """
        if port is not None:
            pulumi.set(__self__, "port", port)
        if port_name is not None:
            pulumi.set(__self__, "port_name", port_name)
        if port_specification is not None:
            pulumi.set(__self__, "port_specification", port_specification)
        if proxy_header is not None:
            pulumi.set(__self__, "proxy_header", proxy_header)
        if request is not None:
            pulumi.set(__self__, "request", request)
        if response is not None:
            pulumi.set(__self__, "response", response)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        The TCP port number for the health check request. The default value is 443. Valid values are 1 through 65535.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter(name="portName")
    def port_name(self) -> Optional[pulumi.Input[str]]:
        """
        Port name as defined in InstanceGroup#NamedPort#name. If both port and port_name are defined, port takes precedence.
        """
        return pulumi.get(self, "port_name")

    @port_name.setter
    def port_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "port_name", value)

    @property
    @pulumi.getter(name="portSpecification")
    def port_specification(self) -> Optional[pulumi.Input['SSLHealthCheckPortSpecification']]:
        """
        Specifies how port is selected for health checking, can be one of following values: USE_FIXED_PORT: The port number in port is used for health checking. USE_NAMED_PORT: The portName is used for health checking. USE_SERVING_PORT: For NetworkEndpointGroup, the port specified for each network endpoint is used for health checking. For other backends, the port or named port specified in the Backend Service is used for health checking. If not specified, SSL health check follows behavior specified in port and portName fields.
        """
        return pulumi.get(self, "port_specification")

    @port_specification.setter
    def port_specification(self, value: Optional[pulumi.Input['SSLHealthCheckPortSpecification']]):
        pulumi.set(self, "port_specification", value)

    @property
    @pulumi.getter(name="proxyHeader")
    def proxy_header(self) -> Optional[pulumi.Input['SSLHealthCheckProxyHeader']]:
        """
        Specifies the type of proxy header to append before sending data to the backend, either NONE or PROXY_V1. The default is NONE.
        """
        return pulumi.get(self, "proxy_header")

    @proxy_header.setter
    def proxy_header(self, value: Optional[pulumi.Input['SSLHealthCheckProxyHeader']]):
        pulumi.set(self, "proxy_header", value)

    @property
    @pulumi.getter
    def request(self) -> Optional[pulumi.Input[str]]:
        """
        The application data to send once the SSL connection has been established (default value is empty). If both request and response are empty, the connection establishment alone will indicate health. The request data can only be ASCII.
        """
        return pulumi.get(self, "request")

    @request.setter
    def request(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "request", value)

    @property
    @pulumi.getter
    def response(self) -> Optional[pulumi.Input[str]]:
        """
        The bytes to match against the beginning of the response data. If left empty (the default value), any response will indicate health. The response data can only be ASCII.
        """
        return pulumi.get(self, "response")

    @response.setter
    def response(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "response", value)


@pulumi.input_type
class SavedDiskArgs:
    def __init__(__self__, *,
                 source_disk: Optional[pulumi.Input[str]] = None):
        """
        An instance-attached disk resource.
        :param pulumi.Input[str] source_disk: Specifies a URL of the disk attached to the source instance.
        """
        if source_disk is not None:
            pulumi.set(__self__, "source_disk", source_disk)

    @property
    @pulumi.getter(name="sourceDisk")
    def source_disk(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies a URL of the disk attached to the source instance.
        """
        return pulumi.get(self, "source_disk")

    @source_disk.setter
    def source_disk(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_disk", value)


@pulumi.input_type
class SchedulingNodeAffinityArgs:
    def __init__(__self__, *,
                 key: Optional[pulumi.Input[str]] = None,
                 operator: Optional[pulumi.Input['SchedulingNodeAffinityOperator']] = None,
                 values: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Node Affinity: the configuration of desired nodes onto which this Instance could be scheduled.
        :param pulumi.Input[str] key: Corresponds to the label key of Node resource.
        :param pulumi.Input['SchedulingNodeAffinityOperator'] operator: Defines the operation of node selection. Valid operators are IN for affinity and NOT_IN for anti-affinity.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] values: Corresponds to the label values of Node resource.
        """
        if key is not None:
            pulumi.set(__self__, "key", key)
        if operator is not None:
            pulumi.set(__self__, "operator", operator)
        if values is not None:
            pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[str]]:
        """
        Corresponds to the label key of Node resource.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def operator(self) -> Optional[pulumi.Input['SchedulingNodeAffinityOperator']]:
        """
        Defines the operation of node selection. Valid operators are IN for affinity and NOT_IN for anti-affinity.
        """
        return pulumi.get(self, "operator")

    @operator.setter
    def operator(self, value: Optional[pulumi.Input['SchedulingNodeAffinityOperator']]):
        pulumi.set(self, "operator", value)

    @property
    @pulumi.getter
    def values(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Corresponds to the label values of Node resource.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "values", value)


@pulumi.input_type
class SchedulingArgs:
    def __init__(__self__, *,
                 automatic_restart: Optional[pulumi.Input[bool]] = None,
                 host_error_timeout_seconds: Optional[pulumi.Input[int]] = None,
                 instance_termination_action: Optional[pulumi.Input['SchedulingInstanceTerminationAction']] = None,
                 location_hint: Optional[pulumi.Input[str]] = None,
                 maintenance_freeze_duration_hours: Optional[pulumi.Input[int]] = None,
                 maintenance_interval: Optional[pulumi.Input['SchedulingMaintenanceInterval']] = None,
                 min_node_cpus: Optional[pulumi.Input[int]] = None,
                 node_affinities: Optional[pulumi.Input[Sequence[pulumi.Input['SchedulingNodeAffinityArgs']]]] = None,
                 on_host_maintenance: Optional[pulumi.Input['SchedulingOnHostMaintenance']] = None,
                 preemptible: Optional[pulumi.Input[bool]] = None,
                 provisioning_model: Optional[pulumi.Input['SchedulingProvisioningModel']] = None):
        """
        Sets the scheduling options for an Instance. NextID: 21
        :param pulumi.Input[bool] automatic_restart: Specifies whether the instance should be automatically restarted if it is terminated by Compute Engine (not terminated by a user). You can only set the automatic restart option for standard instances. Preemptible instances cannot be automatically restarted. By default, this is set to true so an instance is automatically restarted if it is terminated by Compute Engine.
        :param pulumi.Input[int] host_error_timeout_seconds: Specify the time in seconds for host error detection, the value must be within the range of [90, 330] with the increment of 30, if unset, the default behavior of host error recovery will be used.
        :param pulumi.Input['SchedulingInstanceTerminationAction'] instance_termination_action: Specifies the termination action for the instance.
        :param pulumi.Input[str] location_hint: An opaque location hint used to place the instance close to other resources. This field is for use by internal tools that use the public API.
        :param pulumi.Input[int] maintenance_freeze_duration_hours: Specifies the number of hours after VM instance creation where the VM won't be scheduled for maintenance.
        :param pulumi.Input['SchedulingMaintenanceInterval'] maintenance_interval: For more information about maintenance intervals, see Setting maintenance intervals.
        :param pulumi.Input[int] min_node_cpus: The minimum number of virtual CPUs this instance will consume when running on a sole-tenant node.
        :param pulumi.Input[Sequence[pulumi.Input['SchedulingNodeAffinityArgs']]] node_affinities: A set of node affinity and anti-affinity configurations. Refer to Configuring node affinity for more information. Overrides reservationAffinity.
        :param pulumi.Input['SchedulingOnHostMaintenance'] on_host_maintenance: Defines the maintenance behavior for this instance. For standard instances, the default behavior is MIGRATE. For preemptible instances, the default and only possible behavior is TERMINATE. For more information, see Setting Instance Scheduling Options.
        :param pulumi.Input[bool] preemptible: Defines whether the instance is preemptible. This can only be set during instance creation or while the instance is stopped and therefore, in a `TERMINATED` state. See Instance Life Cycle for more information on the possible instance states.
        :param pulumi.Input['SchedulingProvisioningModel'] provisioning_model: Specifies the provisioning model of the instance.
        """
        if automatic_restart is not None:
            pulumi.set(__self__, "automatic_restart", automatic_restart)
        if host_error_timeout_seconds is not None:
            pulumi.set(__self__, "host_error_timeout_seconds", host_error_timeout_seconds)
        if instance_termination_action is not None:
            pulumi.set(__self__, "instance_termination_action", instance_termination_action)
        if location_hint is not None:
            pulumi.set(__self__, "location_hint", location_hint)
        if maintenance_freeze_duration_hours is not None:
            pulumi.set(__self__, "maintenance_freeze_duration_hours", maintenance_freeze_duration_hours)
        if maintenance_interval is not None:
            pulumi.set(__self__, "maintenance_interval", maintenance_interval)
        if min_node_cpus is not None:
            pulumi.set(__self__, "min_node_cpus", min_node_cpus)
        if node_affinities is not None:
            pulumi.set(__self__, "node_affinities", node_affinities)
        if on_host_maintenance is not None:
            pulumi.set(__self__, "on_host_maintenance", on_host_maintenance)
        if preemptible is not None:
            pulumi.set(__self__, "preemptible", preemptible)
        if provisioning_model is not None:
            pulumi.set(__self__, "provisioning_model", provisioning_model)

    @property
    @pulumi.getter(name="automaticRestart")
    def automatic_restart(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether the instance should be automatically restarted if it is terminated by Compute Engine (not terminated by a user). You can only set the automatic restart option for standard instances. Preemptible instances cannot be automatically restarted. By default, this is set to true so an instance is automatically restarted if it is terminated by Compute Engine.
        """
        return pulumi.get(self, "automatic_restart")

    @automatic_restart.setter
    def automatic_restart(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "automatic_restart", value)

    @property
    @pulumi.getter(name="hostErrorTimeoutSeconds")
    def host_error_timeout_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        Specify the time in seconds for host error detection, the value must be within the range of [90, 330] with the increment of 30, if unset, the default behavior of host error recovery will be used.
        """
        return pulumi.get(self, "host_error_timeout_seconds")

    @host_error_timeout_seconds.setter
    def host_error_timeout_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "host_error_timeout_seconds", value)

    @property
    @pulumi.getter(name="instanceTerminationAction")
    def instance_termination_action(self) -> Optional[pulumi.Input['SchedulingInstanceTerminationAction']]:
        """
        Specifies the termination action for the instance.
        """
        return pulumi.get(self, "instance_termination_action")

    @instance_termination_action.setter
    def instance_termination_action(self, value: Optional[pulumi.Input['SchedulingInstanceTerminationAction']]):
        pulumi.set(self, "instance_termination_action", value)

    @property
    @pulumi.getter(name="locationHint")
    def location_hint(self) -> Optional[pulumi.Input[str]]:
        """
        An opaque location hint used to place the instance close to other resources. This field is for use by internal tools that use the public API.
        """
        return pulumi.get(self, "location_hint")

    @location_hint.setter
    def location_hint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location_hint", value)

    @property
    @pulumi.getter(name="maintenanceFreezeDurationHours")
    def maintenance_freeze_duration_hours(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the number of hours after VM instance creation where the VM won't be scheduled for maintenance.
        """
        return pulumi.get(self, "maintenance_freeze_duration_hours")

    @maintenance_freeze_duration_hours.setter
    def maintenance_freeze_duration_hours(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "maintenance_freeze_duration_hours", value)

    @property
    @pulumi.getter(name="maintenanceInterval")
    def maintenance_interval(self) -> Optional[pulumi.Input['SchedulingMaintenanceInterval']]:
        """
        For more information about maintenance intervals, see Setting maintenance intervals.
        """
        return pulumi.get(self, "maintenance_interval")

    @maintenance_interval.setter
    def maintenance_interval(self, value: Optional[pulumi.Input['SchedulingMaintenanceInterval']]):
        pulumi.set(self, "maintenance_interval", value)

    @property
    @pulumi.getter(name="minNodeCpus")
    def min_node_cpus(self) -> Optional[pulumi.Input[int]]:
        """
        The minimum number of virtual CPUs this instance will consume when running on a sole-tenant node.
        """
        return pulumi.get(self, "min_node_cpus")

    @min_node_cpus.setter
    def min_node_cpus(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_node_cpus", value)

    @property
    @pulumi.getter(name="nodeAffinities")
    def node_affinities(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SchedulingNodeAffinityArgs']]]]:
        """
        A set of node affinity and anti-affinity configurations. Refer to Configuring node affinity for more information. Overrides reservationAffinity.
        """
        return pulumi.get(self, "node_affinities")

    @node_affinities.setter
    def node_affinities(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SchedulingNodeAffinityArgs']]]]):
        pulumi.set(self, "node_affinities", value)

    @property
    @pulumi.getter(name="onHostMaintenance")
    def on_host_maintenance(self) -> Optional[pulumi.Input['SchedulingOnHostMaintenance']]:
        """
        Defines the maintenance behavior for this instance. For standard instances, the default behavior is MIGRATE. For preemptible instances, the default and only possible behavior is TERMINATE. For more information, see Setting Instance Scheduling Options.
        """
        return pulumi.get(self, "on_host_maintenance")

    @on_host_maintenance.setter
    def on_host_maintenance(self, value: Optional[pulumi.Input['SchedulingOnHostMaintenance']]):
        pulumi.set(self, "on_host_maintenance", value)

    @property
    @pulumi.getter
    def preemptible(self) -> Optional[pulumi.Input[bool]]:
        """
        Defines whether the instance is preemptible. This can only be set during instance creation or while the instance is stopped and therefore, in a `TERMINATED` state. See Instance Life Cycle for more information on the possible instance states.
        """
        return pulumi.get(self, "preemptible")

    @preemptible.setter
    def preemptible(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "preemptible", value)

    @property
    @pulumi.getter(name="provisioningModel")
    def provisioning_model(self) -> Optional[pulumi.Input['SchedulingProvisioningModel']]:
        """
        Specifies the provisioning model of the instance.
        """
        return pulumi.get(self, "provisioning_model")

    @provisioning_model.setter
    def provisioning_model(self, value: Optional[pulumi.Input['SchedulingProvisioningModel']]):
        pulumi.set(self, "provisioning_model", value)


@pulumi.input_type
class SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfigArgs:
    def __init__(__self__, *,
                 enable: Optional[pulumi.Input[bool]] = None,
                 rule_visibility: Optional[pulumi.Input['SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfigRuleVisibility']] = None):
        """
        Configuration options for L7 DDoS detection.
        :param pulumi.Input[bool] enable: If set to true, enables CAAP for L7 DDoS detection.
        :param pulumi.Input['SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfigRuleVisibility'] rule_visibility: Rule visibility can be one of the following: STANDARD - opaque rules. (default) PREMIUM - transparent rules.
        """
        if enable is not None:
            pulumi.set(__self__, "enable", enable)
        if rule_visibility is not None:
            pulumi.set(__self__, "rule_visibility", rule_visibility)

    @property
    @pulumi.getter
    def enable(self) -> Optional[pulumi.Input[bool]]:
        """
        If set to true, enables CAAP for L7 DDoS detection.
        """
        return pulumi.get(self, "enable")

    @enable.setter
    def enable(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable", value)

    @property
    @pulumi.getter(name="ruleVisibility")
    def rule_visibility(self) -> Optional[pulumi.Input['SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfigRuleVisibility']]:
        """
        Rule visibility can be one of the following: STANDARD - opaque rules. (default) PREMIUM - transparent rules.
        """
        return pulumi.get(self, "rule_visibility")

    @rule_visibility.setter
    def rule_visibility(self, value: Optional[pulumi.Input['SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfigRuleVisibility']]):
        pulumi.set(self, "rule_visibility", value)


@pulumi.input_type
class SecurityPolicyAdaptiveProtectionConfigArgs:
    def __init__(__self__, *,
                 layer7_ddos_defense_config: Optional[pulumi.Input['SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfigArgs']] = None):
        """
        Configuration options for Cloud Armor Adaptive Protection (CAAP).
        :param pulumi.Input['SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfigArgs'] layer7_ddos_defense_config: If set to true, enables Cloud Armor Machine Learning.
        """
        if layer7_ddos_defense_config is not None:
            pulumi.set(__self__, "layer7_ddos_defense_config", layer7_ddos_defense_config)

    @property
    @pulumi.getter(name="layer7DdosDefenseConfig")
    def layer7_ddos_defense_config(self) -> Optional[pulumi.Input['SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfigArgs']]:
        """
        If set to true, enables Cloud Armor Machine Learning.
        """
        return pulumi.get(self, "layer7_ddos_defense_config")

    @layer7_ddos_defense_config.setter
    def layer7_ddos_defense_config(self, value: Optional[pulumi.Input['SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfigArgs']]):
        pulumi.set(self, "layer7_ddos_defense_config", value)


@pulumi.input_type
class SecurityPolicyAdvancedOptionsConfigArgs:
    def __init__(__self__, *,
                 json_parsing: Optional[pulumi.Input['SecurityPolicyAdvancedOptionsConfigJsonParsing']] = None,
                 log_level: Optional[pulumi.Input['SecurityPolicyAdvancedOptionsConfigLogLevel']] = None):
        if json_parsing is not None:
            pulumi.set(__self__, "json_parsing", json_parsing)
        if log_level is not None:
            pulumi.set(__self__, "log_level", log_level)

    @property
    @pulumi.getter(name="jsonParsing")
    def json_parsing(self) -> Optional[pulumi.Input['SecurityPolicyAdvancedOptionsConfigJsonParsing']]:
        return pulumi.get(self, "json_parsing")

    @json_parsing.setter
    def json_parsing(self, value: Optional[pulumi.Input['SecurityPolicyAdvancedOptionsConfigJsonParsing']]):
        pulumi.set(self, "json_parsing", value)

    @property
    @pulumi.getter(name="logLevel")
    def log_level(self) -> Optional[pulumi.Input['SecurityPolicyAdvancedOptionsConfigLogLevel']]:
        return pulumi.get(self, "log_level")

    @log_level.setter
    def log_level(self, value: Optional[pulumi.Input['SecurityPolicyAdvancedOptionsConfigLogLevel']]):
        pulumi.set(self, "log_level", value)


@pulumi.input_type
class SecurityPolicyAssociationArgs:
    def __init__(__self__, *,
                 attachment_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] attachment_id: The resource that the security policy is attached to.
        :param pulumi.Input[str] name: The name for an association.
        """
        if attachment_id is not None:
            pulumi.set(__self__, "attachment_id", attachment_id)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="attachmentId")
    def attachment_id(self) -> Optional[pulumi.Input[str]]:
        """
        The resource that the security policy is attached to.
        """
        return pulumi.get(self, "attachment_id")

    @attachment_id.setter
    def attachment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "attachment_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name for an association.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class SecurityPolicyRecaptchaOptionsConfigArgs:
    def __init__(__self__, *,
                 redirect_site_key: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] redirect_site_key: An optional field to supply a reCAPTCHA site key to be used for all the rules using the redirect action with the type of GOOGLE_RECAPTCHA under the security policy. The specified site key needs to be created from the reCAPTCHA API. The user is responsible for the validity of the specified site key. If not specified, a Google-managed site key is used.
        """
        if redirect_site_key is not None:
            pulumi.set(__self__, "redirect_site_key", redirect_site_key)

    @property
    @pulumi.getter(name="redirectSiteKey")
    def redirect_site_key(self) -> Optional[pulumi.Input[str]]:
        """
        An optional field to supply a reCAPTCHA site key to be used for all the rules using the redirect action with the type of GOOGLE_RECAPTCHA under the security policy. The specified site key needs to be created from the reCAPTCHA API. The user is responsible for the validity of the specified site key. If not specified, a Google-managed site key is used.
        """
        return pulumi.get(self, "redirect_site_key")

    @redirect_site_key.setter
    def redirect_site_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "redirect_site_key", value)


@pulumi.input_type
class SecurityPolicyRuleHttpHeaderActionHttpHeaderOptionArgs:
    def __init__(__self__, *,
                 header_name: Optional[pulumi.Input[str]] = None,
                 header_value: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] header_name: The name of the header to set.
        :param pulumi.Input[str] header_value: The value to set the named header to.
        """
        if header_name is not None:
            pulumi.set(__self__, "header_name", header_name)
        if header_value is not None:
            pulumi.set(__self__, "header_value", header_value)

    @property
    @pulumi.getter(name="headerName")
    def header_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the header to set.
        """
        return pulumi.get(self, "header_name")

    @header_name.setter
    def header_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "header_name", value)

    @property
    @pulumi.getter(name="headerValue")
    def header_value(self) -> Optional[pulumi.Input[str]]:
        """
        The value to set the named header to.
        """
        return pulumi.get(self, "header_value")

    @header_value.setter
    def header_value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "header_value", value)


@pulumi.input_type
class SecurityPolicyRuleHttpHeaderActionArgs:
    def __init__(__self__, *,
                 request_headers_to_adds: Optional[pulumi.Input[Sequence[pulumi.Input['SecurityPolicyRuleHttpHeaderActionHttpHeaderOptionArgs']]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['SecurityPolicyRuleHttpHeaderActionHttpHeaderOptionArgs']]] request_headers_to_adds: The list of request headers to add or overwrite if they're already present.
        """
        if request_headers_to_adds is not None:
            pulumi.set(__self__, "request_headers_to_adds", request_headers_to_adds)

    @property
    @pulumi.getter(name="requestHeadersToAdds")
    def request_headers_to_adds(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SecurityPolicyRuleHttpHeaderActionHttpHeaderOptionArgs']]]]:
        """
        The list of request headers to add or overwrite if they're already present.
        """
        return pulumi.get(self, "request_headers_to_adds")

    @request_headers_to_adds.setter
    def request_headers_to_adds(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SecurityPolicyRuleHttpHeaderActionHttpHeaderOptionArgs']]]]):
        pulumi.set(self, "request_headers_to_adds", value)


@pulumi.input_type
class SecurityPolicyRuleMatcherConfigLayer4ConfigArgs:
    def __init__(__self__, *,
                 ip_protocol: Optional[pulumi.Input[str]] = None,
                 ports: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[str] ip_protocol: The IP protocol to which this rule applies. The protocol type is required when creating a firewall rule. This value can either be one of the following well known protocol strings (tcp, udp, icmp, esp, ah, ipip, sctp), or the IP protocol number.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ports: An optional list of ports to which this rule applies. This field is only applicable for UDP or TCP protocol. Each entry must be either an integer or a range. If not specified, this rule applies to connections through any port. Example inputs include: ["22"], ["80","443"], and ["12345-12349"]. This field may only be specified when versioned_expr is set to FIREWALL.
        """
        if ip_protocol is not None:
            pulumi.set(__self__, "ip_protocol", ip_protocol)
        if ports is not None:
            pulumi.set(__self__, "ports", ports)

    @property
    @pulumi.getter(name="ipProtocol")
    def ip_protocol(self) -> Optional[pulumi.Input[str]]:
        """
        The IP protocol to which this rule applies. The protocol type is required when creating a firewall rule. This value can either be one of the following well known protocol strings (tcp, udp, icmp, esp, ah, ipip, sctp), or the IP protocol number.
        """
        return pulumi.get(self, "ip_protocol")

    @ip_protocol.setter
    def ip_protocol(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip_protocol", value)

    @property
    @pulumi.getter
    def ports(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        An optional list of ports to which this rule applies. This field is only applicable for UDP or TCP protocol. Each entry must be either an integer or a range. If not specified, this rule applies to connections through any port. Example inputs include: ["22"], ["80","443"], and ["12345-12349"]. This field may only be specified when versioned_expr is set to FIREWALL.
        """
        return pulumi.get(self, "ports")

    @ports.setter
    def ports(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "ports", value)


@pulumi.input_type
class SecurityPolicyRuleMatcherConfigArgs:
    def __init__(__self__, *,
                 dest_ip_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 layer4_configs: Optional[pulumi.Input[Sequence[pulumi.Input['SecurityPolicyRuleMatcherConfigLayer4ConfigArgs']]]] = None,
                 src_ip_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] dest_ip_ranges: CIDR IP address range. This field may only be specified when versioned_expr is set to FIREWALL.
        :param pulumi.Input[Sequence[pulumi.Input['SecurityPolicyRuleMatcherConfigLayer4ConfigArgs']]] layer4_configs: Pairs of IP protocols and ports that the rule should match. This field may only be specified when versioned_expr is set to FIREWALL.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] src_ip_ranges: CIDR IP address range. Maximum number of src_ip_ranges allowed is 10.
        """
        if dest_ip_ranges is not None:
            pulumi.set(__self__, "dest_ip_ranges", dest_ip_ranges)
        if layer4_configs is not None:
            pulumi.set(__self__, "layer4_configs", layer4_configs)
        if src_ip_ranges is not None:
            pulumi.set(__self__, "src_ip_ranges", src_ip_ranges)

    @property
    @pulumi.getter(name="destIpRanges")
    def dest_ip_ranges(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        CIDR IP address range. This field may only be specified when versioned_expr is set to FIREWALL.
        """
        return pulumi.get(self, "dest_ip_ranges")

    @dest_ip_ranges.setter
    def dest_ip_ranges(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "dest_ip_ranges", value)

    @property
    @pulumi.getter(name="layer4Configs")
    def layer4_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SecurityPolicyRuleMatcherConfigLayer4ConfigArgs']]]]:
        """
        Pairs of IP protocols and ports that the rule should match. This field may only be specified when versioned_expr is set to FIREWALL.
        """
        return pulumi.get(self, "layer4_configs")

    @layer4_configs.setter
    def layer4_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SecurityPolicyRuleMatcherConfigLayer4ConfigArgs']]]]):
        pulumi.set(self, "layer4_configs", value)

    @property
    @pulumi.getter(name="srcIpRanges")
    def src_ip_ranges(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        CIDR IP address range. Maximum number of src_ip_ranges allowed is 10.
        """
        return pulumi.get(self, "src_ip_ranges")

    @src_ip_ranges.setter
    def src_ip_ranges(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "src_ip_ranges", value)


@pulumi.input_type
class SecurityPolicyRuleMatcherArgs:
    def __init__(__self__, *,
                 config: Optional[pulumi.Input['SecurityPolicyRuleMatcherConfigArgs']] = None,
                 expr: Optional[pulumi.Input['ExprArgs']] = None,
                 versioned_expr: Optional[pulumi.Input['SecurityPolicyRuleMatcherVersionedExpr']] = None):
        """
        Represents a match condition that incoming traffic is evaluated against. Exactly one field must be specified.
        :param pulumi.Input['SecurityPolicyRuleMatcherConfigArgs'] config: The configuration options available when specifying versioned_expr. This field must be specified if versioned_expr is specified and cannot be specified if versioned_expr is not specified.
        :param pulumi.Input['ExprArgs'] expr: User defined CEVAL expression. A CEVAL expression is used to specify match criteria such as origin.ip, source.region_code and contents in the request header.
        :param pulumi.Input['SecurityPolicyRuleMatcherVersionedExpr'] versioned_expr: Preconfigured versioned expression. If this field is specified, config must also be specified. Available preconfigured expressions along with their requirements are: SRC_IPS_V1 - must specify the corresponding src_ip_range field in config.
        """
        if config is not None:
            pulumi.set(__self__, "config", config)
        if expr is not None:
            pulumi.set(__self__, "expr", expr)
        if versioned_expr is not None:
            pulumi.set(__self__, "versioned_expr", versioned_expr)

    @property
    @pulumi.getter
    def config(self) -> Optional[pulumi.Input['SecurityPolicyRuleMatcherConfigArgs']]:
        """
        The configuration options available when specifying versioned_expr. This field must be specified if versioned_expr is specified and cannot be specified if versioned_expr is not specified.
        """
        return pulumi.get(self, "config")

    @config.setter
    def config(self, value: Optional[pulumi.Input['SecurityPolicyRuleMatcherConfigArgs']]):
        pulumi.set(self, "config", value)

    @property
    @pulumi.getter
    def expr(self) -> Optional[pulumi.Input['ExprArgs']]:
        """
        User defined CEVAL expression. A CEVAL expression is used to specify match criteria such as origin.ip, source.region_code and contents in the request header.
        """
        return pulumi.get(self, "expr")

    @expr.setter
    def expr(self, value: Optional[pulumi.Input['ExprArgs']]):
        pulumi.set(self, "expr", value)

    @property
    @pulumi.getter(name="versionedExpr")
    def versioned_expr(self) -> Optional[pulumi.Input['SecurityPolicyRuleMatcherVersionedExpr']]:
        """
        Preconfigured versioned expression. If this field is specified, config must also be specified. Available preconfigured expressions along with their requirements are: SRC_IPS_V1 - must specify the corresponding src_ip_range field in config.
        """
        return pulumi.get(self, "versioned_expr")

    @versioned_expr.setter
    def versioned_expr(self, value: Optional[pulumi.Input['SecurityPolicyRuleMatcherVersionedExpr']]):
        pulumi.set(self, "versioned_expr", value)


@pulumi.input_type
class SecurityPolicyRuleRateLimitOptionsThresholdArgs:
    def __init__(__self__, *,
                 count: Optional[pulumi.Input[int]] = None,
                 interval_sec: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[int] count: Number of HTTP(S) requests for calculating the threshold.
        :param pulumi.Input[int] interval_sec: Interval over which the threshold is computed.
        """
        if count is not None:
            pulumi.set(__self__, "count", count)
        if interval_sec is not None:
            pulumi.set(__self__, "interval_sec", interval_sec)

    @property
    @pulumi.getter
    def count(self) -> Optional[pulumi.Input[int]]:
        """
        Number of HTTP(S) requests for calculating the threshold.
        """
        return pulumi.get(self, "count")

    @count.setter
    def count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "count", value)

    @property
    @pulumi.getter(name="intervalSec")
    def interval_sec(self) -> Optional[pulumi.Input[int]]:
        """
        Interval over which the threshold is computed.
        """
        return pulumi.get(self, "interval_sec")

    @interval_sec.setter
    def interval_sec(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "interval_sec", value)


@pulumi.input_type
class SecurityPolicyRuleRateLimitOptionsArgs:
    def __init__(__self__, *,
                 ban_duration_sec: Optional[pulumi.Input[int]] = None,
                 ban_threshold: Optional[pulumi.Input['SecurityPolicyRuleRateLimitOptionsThresholdArgs']] = None,
                 conform_action: Optional[pulumi.Input[str]] = None,
                 enforce_on_key: Optional[pulumi.Input['SecurityPolicyRuleRateLimitOptionsEnforceOnKey']] = None,
                 enforce_on_key_name: Optional[pulumi.Input[str]] = None,
                 exceed_action: Optional[pulumi.Input[str]] = None,
                 exceed_redirect_options: Optional[pulumi.Input['SecurityPolicyRuleRedirectOptionsArgs']] = None,
                 rate_limit_threshold: Optional[pulumi.Input['SecurityPolicyRuleRateLimitOptionsThresholdArgs']] = None):
        """
        :param pulumi.Input[int] ban_duration_sec: Can only be specified if the action for the rule is "rate_based_ban". If specified, determines the time (in seconds) the traffic will continue to be banned by the rate limit after the rate falls below the threshold.
        :param pulumi.Input['SecurityPolicyRuleRateLimitOptionsThresholdArgs'] ban_threshold: Can only be specified if the action for the rule is "rate_based_ban". If specified, the key will be banned for the configured 'ban_duration_sec' when the number of requests that exceed the 'rate_limit_threshold' also exceed this 'ban_threshold'.
        :param pulumi.Input[str] conform_action: Action to take for requests that are under the configured rate limit threshold. Valid option is "allow" only.
        :param pulumi.Input['SecurityPolicyRuleRateLimitOptionsEnforceOnKey'] enforce_on_key: Determines the key to enforce the rate_limit_threshold on. Possible values are: - ALL: A single rate limit threshold is applied to all the requests matching this rule. This is the default value if this field 'enforce_on_key' is not configured. - IP: The source IP address of the request is the key. Each IP has this limit enforced separately. - HTTP_HEADER: The value of the HTTP header whose name is configured under "enforce_on_key_name". The key value is truncated to the first 128 bytes of the header value. If no such header is present in the request, the key type defaults to ALL. - XFF_IP: The first IP address (i.e. the originating client IP address) specified in the list of IPs under X-Forwarded-For HTTP header. If no such header is present or the value is not a valid IP, the key type defaults to ALL. - HTTP_COOKIE: The value of the HTTP cookie whose name is configured under "enforce_on_key_name". The key value is truncated to the first 128 bytes of the cookie value. If no such cookie is present in the request, the key type defaults to ALL. 
        :param pulumi.Input[str] enforce_on_key_name: Rate limit key name applicable only for the following key types: HTTP_HEADER -- Name of the HTTP header whose value is taken as the key value. HTTP_COOKIE -- Name of the HTTP cookie whose value is taken as the key value.
        :param pulumi.Input[str] exceed_action: Action to take for requests that are above the configured rate limit threshold, to either deny with a specified HTTP response code, or redirect to a different endpoint. Valid options are "deny()" where valid values for status are 403, 404, 429, and 502, and "redirect" where the redirect parameters come from exceed_redirect_options below.
        :param pulumi.Input['SecurityPolicyRuleRedirectOptionsArgs'] exceed_redirect_options: Parameters defining the redirect action that is used as the exceed action. Cannot be specified if the exceed action is not redirect.
        :param pulumi.Input['SecurityPolicyRuleRateLimitOptionsThresholdArgs'] rate_limit_threshold: Threshold at which to begin ratelimiting.
        """
        if ban_duration_sec is not None:
            pulumi.set(__self__, "ban_duration_sec", ban_duration_sec)
        if ban_threshold is not None:
            pulumi.set(__self__, "ban_threshold", ban_threshold)
        if conform_action is not None:
            pulumi.set(__self__, "conform_action", conform_action)
        if enforce_on_key is not None:
            pulumi.set(__self__, "enforce_on_key", enforce_on_key)
        if enforce_on_key_name is not None:
            pulumi.set(__self__, "enforce_on_key_name", enforce_on_key_name)
        if exceed_action is not None:
            pulumi.set(__self__, "exceed_action", exceed_action)
        if exceed_redirect_options is not None:
            pulumi.set(__self__, "exceed_redirect_options", exceed_redirect_options)
        if rate_limit_threshold is not None:
            pulumi.set(__self__, "rate_limit_threshold", rate_limit_threshold)

    @property
    @pulumi.getter(name="banDurationSec")
    def ban_duration_sec(self) -> Optional[pulumi.Input[int]]:
        """
        Can only be specified if the action for the rule is "rate_based_ban". If specified, determines the time (in seconds) the traffic will continue to be banned by the rate limit after the rate falls below the threshold.
        """
        return pulumi.get(self, "ban_duration_sec")

    @ban_duration_sec.setter
    def ban_duration_sec(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ban_duration_sec", value)

    @property
    @pulumi.getter(name="banThreshold")
    def ban_threshold(self) -> Optional[pulumi.Input['SecurityPolicyRuleRateLimitOptionsThresholdArgs']]:
        """
        Can only be specified if the action for the rule is "rate_based_ban". If specified, the key will be banned for the configured 'ban_duration_sec' when the number of requests that exceed the 'rate_limit_threshold' also exceed this 'ban_threshold'.
        """
        return pulumi.get(self, "ban_threshold")

    @ban_threshold.setter
    def ban_threshold(self, value: Optional[pulumi.Input['SecurityPolicyRuleRateLimitOptionsThresholdArgs']]):
        pulumi.set(self, "ban_threshold", value)

    @property
    @pulumi.getter(name="conformAction")
    def conform_action(self) -> Optional[pulumi.Input[str]]:
        """
        Action to take for requests that are under the configured rate limit threshold. Valid option is "allow" only.
        """
        return pulumi.get(self, "conform_action")

    @conform_action.setter
    def conform_action(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "conform_action", value)

    @property
    @pulumi.getter(name="enforceOnKey")
    def enforce_on_key(self) -> Optional[pulumi.Input['SecurityPolicyRuleRateLimitOptionsEnforceOnKey']]:
        """
        Determines the key to enforce the rate_limit_threshold on. Possible values are: - ALL: A single rate limit threshold is applied to all the requests matching this rule. This is the default value if this field 'enforce_on_key' is not configured. - IP: The source IP address of the request is the key. Each IP has this limit enforced separately. - HTTP_HEADER: The value of the HTTP header whose name is configured under "enforce_on_key_name". The key value is truncated to the first 128 bytes of the header value. If no such header is present in the request, the key type defaults to ALL. - XFF_IP: The first IP address (i.e. the originating client IP address) specified in the list of IPs under X-Forwarded-For HTTP header. If no such header is present or the value is not a valid IP, the key type defaults to ALL. - HTTP_COOKIE: The value of the HTTP cookie whose name is configured under "enforce_on_key_name". The key value is truncated to the first 128 bytes of the cookie value. If no such cookie is present in the request, the key type defaults to ALL. 
        """
        return pulumi.get(self, "enforce_on_key")

    @enforce_on_key.setter
    def enforce_on_key(self, value: Optional[pulumi.Input['SecurityPolicyRuleRateLimitOptionsEnforceOnKey']]):
        pulumi.set(self, "enforce_on_key", value)

    @property
    @pulumi.getter(name="enforceOnKeyName")
    def enforce_on_key_name(self) -> Optional[pulumi.Input[str]]:
        """
        Rate limit key name applicable only for the following key types: HTTP_HEADER -- Name of the HTTP header whose value is taken as the key value. HTTP_COOKIE -- Name of the HTTP cookie whose value is taken as the key value.
        """
        return pulumi.get(self, "enforce_on_key_name")

    @enforce_on_key_name.setter
    def enforce_on_key_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "enforce_on_key_name", value)

    @property
    @pulumi.getter(name="exceedAction")
    def exceed_action(self) -> Optional[pulumi.Input[str]]:
        """
        Action to take for requests that are above the configured rate limit threshold, to either deny with a specified HTTP response code, or redirect to a different endpoint. Valid options are "deny()" where valid values for status are 403, 404, 429, and 502, and "redirect" where the redirect parameters come from exceed_redirect_options below.
        """
        return pulumi.get(self, "exceed_action")

    @exceed_action.setter
    def exceed_action(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "exceed_action", value)

    @property
    @pulumi.getter(name="exceedRedirectOptions")
    def exceed_redirect_options(self) -> Optional[pulumi.Input['SecurityPolicyRuleRedirectOptionsArgs']]:
        """
        Parameters defining the redirect action that is used as the exceed action. Cannot be specified if the exceed action is not redirect.
        """
        return pulumi.get(self, "exceed_redirect_options")

    @exceed_redirect_options.setter
    def exceed_redirect_options(self, value: Optional[pulumi.Input['SecurityPolicyRuleRedirectOptionsArgs']]):
        pulumi.set(self, "exceed_redirect_options", value)

    @property
    @pulumi.getter(name="rateLimitThreshold")
    def rate_limit_threshold(self) -> Optional[pulumi.Input['SecurityPolicyRuleRateLimitOptionsThresholdArgs']]:
        """
        Threshold at which to begin ratelimiting.
        """
        return pulumi.get(self, "rate_limit_threshold")

    @rate_limit_threshold.setter
    def rate_limit_threshold(self, value: Optional[pulumi.Input['SecurityPolicyRuleRateLimitOptionsThresholdArgs']]):
        pulumi.set(self, "rate_limit_threshold", value)


@pulumi.input_type
class SecurityPolicyRuleRedirectOptionsArgs:
    def __init__(__self__, *,
                 target: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input['SecurityPolicyRuleRedirectOptionsType']] = None):
        """
        :param pulumi.Input[str] target: Target for the redirect action. This is required if the type is EXTERNAL_302 and cannot be specified for GOOGLE_RECAPTCHA.
        :param pulumi.Input['SecurityPolicyRuleRedirectOptionsType'] type: Type of the redirect action.
        """
        if target is not None:
            pulumi.set(__self__, "target", target)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def target(self) -> Optional[pulumi.Input[str]]:
        """
        Target for the redirect action. This is required if the type is EXTERNAL_302 and cannot be specified for GOOGLE_RECAPTCHA.
        """
        return pulumi.get(self, "target")

    @target.setter
    def target(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input['SecurityPolicyRuleRedirectOptionsType']]:
        """
        Type of the redirect action.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input['SecurityPolicyRuleRedirectOptionsType']]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class SecurityPolicyRuleArgs:
    def __init__(__self__, *,
                 action: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 direction: Optional[pulumi.Input['SecurityPolicyRuleDirection']] = None,
                 enable_logging: Optional[pulumi.Input[bool]] = None,
                 header_action: Optional[pulumi.Input['SecurityPolicyRuleHttpHeaderActionArgs']] = None,
                 match: Optional[pulumi.Input['SecurityPolicyRuleMatcherArgs']] = None,
                 preview: Optional[pulumi.Input[bool]] = None,
                 priority: Optional[pulumi.Input[int]] = None,
                 rate_limit_options: Optional[pulumi.Input['SecurityPolicyRuleRateLimitOptionsArgs']] = None,
                 redirect_options: Optional[pulumi.Input['SecurityPolicyRuleRedirectOptionsArgs']] = None,
                 rule_number: Optional[pulumi.Input[str]] = None,
                 target_resources: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 target_service_accounts: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Represents a rule that describes one or more match conditions along with the action to be taken when traffic matches this condition (allow or deny).
        :param pulumi.Input[str] action: The Action to perform when the rule is matched. The following are the valid actions: - allow: allow access to target. - deny(): deny access to target, returns the HTTP response code specified (valid values are 403, 404, and 502). - rate_based_ban: limit client traffic to the configured threshold and ban the client if the traffic exceeds the threshold. Configure parameters for this action in RateLimitOptions. Requires rate_limit_options to be set. - redirect: redirect to a different target. This can either be an internal reCAPTCHA redirect, or an external URL-based redirect via a 302 response. Parameters for this action can be configured via redirectOptions. - throttle: limit client traffic to the configured threshold. Configure parameters for this action in rateLimitOptions. Requires rate_limit_options to be set for this. 
        :param pulumi.Input[str] description: An optional description of this resource. Provide this property when you create the resource.
        :param pulumi.Input['SecurityPolicyRuleDirection'] direction: The direction in which this rule applies. This field may only be specified when versioned_expr is set to FIREWALL.
        :param pulumi.Input[bool] enable_logging: Denotes whether to enable logging for a particular rule. If logging is enabled, logs will be exported to the configured export destination in Stackdriver. Logs may be exported to BigQuery or Pub/Sub. Note: you cannot enable logging on "goto_next" rules. This field may only be specified when the versioned_expr is set to FIREWALL.
        :param pulumi.Input['SecurityPolicyRuleHttpHeaderActionArgs'] header_action: Optional, additional actions that are performed on headers.
        :param pulumi.Input['SecurityPolicyRuleMatcherArgs'] match: A match condition that incoming traffic is evaluated against. If it evaluates to true, the corresponding 'action' is enforced.
        :param pulumi.Input[bool] preview: If set to true, the specified action is not enforced.
        :param pulumi.Input[int] priority: An integer indicating the priority of a rule in the list. The priority must be a positive value between 0 and 2147483647. Rules are evaluated from highest to lowest priority where 0 is the highest priority and 2147483647 is the lowest priority.
        :param pulumi.Input['SecurityPolicyRuleRateLimitOptionsArgs'] rate_limit_options: Must be specified if the action is "rate_based_ban" or "throttle". Cannot be specified for any other actions.
        :param pulumi.Input['SecurityPolicyRuleRedirectOptionsArgs'] redirect_options: Parameters defining the redirect action. Cannot be specified for any other actions.
        :param pulumi.Input[str] rule_number: Identifier for the rule. This is only unique within the given security policy. This can only be set during rule creation, if rule number is not specified it will be generated by the server.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] target_resources: A list of network resource URLs to which this rule applies. This field allows you to control which network's VMs get this rule. If this field is left blank, all VMs within the organization will receive the rule. This field may only be specified when versioned_expr is set to FIREWALL.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] target_service_accounts: A list of service accounts indicating the sets of instances that are applied with this rule.
        """
        if action is not None:
            pulumi.set(__self__, "action", action)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if direction is not None:
            pulumi.set(__self__, "direction", direction)
        if enable_logging is not None:
            pulumi.set(__self__, "enable_logging", enable_logging)
        if header_action is not None:
            pulumi.set(__self__, "header_action", header_action)
        if match is not None:
            pulumi.set(__self__, "match", match)
        if preview is not None:
            pulumi.set(__self__, "preview", preview)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if rate_limit_options is not None:
            pulumi.set(__self__, "rate_limit_options", rate_limit_options)
        if redirect_options is not None:
            pulumi.set(__self__, "redirect_options", redirect_options)
        if rule_number is not None:
            pulumi.set(__self__, "rule_number", rule_number)
        if target_resources is not None:
            pulumi.set(__self__, "target_resources", target_resources)
        if target_service_accounts is not None:
            pulumi.set(__self__, "target_service_accounts", target_service_accounts)

    @property
    @pulumi.getter
    def action(self) -> Optional[pulumi.Input[str]]:
        """
        The Action to perform when the rule is matched. The following are the valid actions: - allow: allow access to target. - deny(): deny access to target, returns the HTTP response code specified (valid values are 403, 404, and 502). - rate_based_ban: limit client traffic to the configured threshold and ban the client if the traffic exceeds the threshold. Configure parameters for this action in RateLimitOptions. Requires rate_limit_options to be set. - redirect: redirect to a different target. This can either be an internal reCAPTCHA redirect, or an external URL-based redirect via a 302 response. Parameters for this action can be configured via redirectOptions. - throttle: limit client traffic to the configured threshold. Configure parameters for this action in rateLimitOptions. Requires rate_limit_options to be set for this. 
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "action", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        An optional description of this resource. Provide this property when you create the resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def direction(self) -> Optional[pulumi.Input['SecurityPolicyRuleDirection']]:
        """
        The direction in which this rule applies. This field may only be specified when versioned_expr is set to FIREWALL.
        """
        return pulumi.get(self, "direction")

    @direction.setter
    def direction(self, value: Optional[pulumi.Input['SecurityPolicyRuleDirection']]):
        pulumi.set(self, "direction", value)

    @property
    @pulumi.getter(name="enableLogging")
    def enable_logging(self) -> Optional[pulumi.Input[bool]]:
        """
        Denotes whether to enable logging for a particular rule. If logging is enabled, logs will be exported to the configured export destination in Stackdriver. Logs may be exported to BigQuery or Pub/Sub. Note: you cannot enable logging on "goto_next" rules. This field may only be specified when the versioned_expr is set to FIREWALL.
        """
        return pulumi.get(self, "enable_logging")

    @enable_logging.setter
    def enable_logging(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_logging", value)

    @property
    @pulumi.getter(name="headerAction")
    def header_action(self) -> Optional[pulumi.Input['SecurityPolicyRuleHttpHeaderActionArgs']]:
        """
        Optional, additional actions that are performed on headers.
        """
        return pulumi.get(self, "header_action")

    @header_action.setter
    def header_action(self, value: Optional[pulumi.Input['SecurityPolicyRuleHttpHeaderActionArgs']]):
        pulumi.set(self, "header_action", value)

    @property
    @pulumi.getter
    def match(self) -> Optional[pulumi.Input['SecurityPolicyRuleMatcherArgs']]:
        """
        A match condition that incoming traffic is evaluated against. If it evaluates to true, the corresponding 'action' is enforced.
        """
        return pulumi.get(self, "match")

    @match.setter
    def match(self, value: Optional[pulumi.Input['SecurityPolicyRuleMatcherArgs']]):
        pulumi.set(self, "match", value)

    @property
    @pulumi.getter
    def preview(self) -> Optional[pulumi.Input[bool]]:
        """
        If set to true, the specified action is not enforced.
        """
        return pulumi.get(self, "preview")

    @preview.setter
    def preview(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "preview", value)

    @property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[int]]:
        """
        An integer indicating the priority of a rule in the list. The priority must be a positive value between 0 and 2147483647. Rules are evaluated from highest to lowest priority where 0 is the highest priority and 2147483647 is the lowest priority.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "priority", value)

    @property
    @pulumi.getter(name="rateLimitOptions")
    def rate_limit_options(self) -> Optional[pulumi.Input['SecurityPolicyRuleRateLimitOptionsArgs']]:
        """
        Must be specified if the action is "rate_based_ban" or "throttle". Cannot be specified for any other actions.
        """
        return pulumi.get(self, "rate_limit_options")

    @rate_limit_options.setter
    def rate_limit_options(self, value: Optional[pulumi.Input['SecurityPolicyRuleRateLimitOptionsArgs']]):
        pulumi.set(self, "rate_limit_options", value)

    @property
    @pulumi.getter(name="redirectOptions")
    def redirect_options(self) -> Optional[pulumi.Input['SecurityPolicyRuleRedirectOptionsArgs']]:
        """
        Parameters defining the redirect action. Cannot be specified for any other actions.
        """
        return pulumi.get(self, "redirect_options")

    @redirect_options.setter
    def redirect_options(self, value: Optional[pulumi.Input['SecurityPolicyRuleRedirectOptionsArgs']]):
        pulumi.set(self, "redirect_options", value)

    @property
    @pulumi.getter(name="ruleNumber")
    def rule_number(self) -> Optional[pulumi.Input[str]]:
        """
        Identifier for the rule. This is only unique within the given security policy. This can only be set during rule creation, if rule number is not specified it will be generated by the server.
        """
        return pulumi.get(self, "rule_number")

    @rule_number.setter
    def rule_number(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "rule_number", value)

    @property
    @pulumi.getter(name="targetResources")
    def target_resources(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of network resource URLs to which this rule applies. This field allows you to control which network's VMs get this rule. If this field is left blank, all VMs within the organization will receive the rule. This field may only be specified when versioned_expr is set to FIREWALL.
        """
        return pulumi.get(self, "target_resources")

    @target_resources.setter
    def target_resources(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "target_resources", value)

    @property
    @pulumi.getter(name="targetServiceAccounts")
    def target_service_accounts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of service accounts indicating the sets of instances that are applied with this rule.
        """
        return pulumi.get(self, "target_service_accounts")

    @target_service_accounts.setter
    def target_service_accounts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "target_service_accounts", value)


@pulumi.input_type
class SecuritySettingsArgs:
    def __init__(__self__, *,
                 client_tls_policy: Optional[pulumi.Input[str]] = None,
                 subject_alt_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The authentication and authorization settings for a BackendService.
        :param pulumi.Input[str] client_tls_policy: Optional. A URL referring to a networksecurity.ClientTlsPolicy resource that describes how clients should authenticate with this service's backends. clientTlsPolicy only applies to a global BackendService with the loadBalancingScheme set to INTERNAL_SELF_MANAGED. If left blank, communications are not encrypted. Note: This field currently has no impact.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] subject_alt_names: Optional. A list of Subject Alternative Names (SANs) that the client verifies during a mutual TLS handshake with an server/endpoint for this BackendService. When the server presents its X.509 certificate to the client, the client inspects the certificate's subjectAltName field. If the field contains one of the specified values, the communication continues. Otherwise, it fails. This additional check enables the client to verify that the server is authorized to run the requested service. Note that the contents of the server certificate's subjectAltName field are configured by the Public Key Infrastructure which provisions server identities. Only applies to a global BackendService with loadBalancingScheme set to INTERNAL_SELF_MANAGED. Only applies when BackendService has an attached clientTlsPolicy with clientCertificate (mTLS mode). Note: This field currently has no impact.
        """
        if client_tls_policy is not None:
            pulumi.set(__self__, "client_tls_policy", client_tls_policy)
        if subject_alt_names is not None:
            pulumi.set(__self__, "subject_alt_names", subject_alt_names)

    @property
    @pulumi.getter(name="clientTlsPolicy")
    def client_tls_policy(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. A URL referring to a networksecurity.ClientTlsPolicy resource that describes how clients should authenticate with this service's backends. clientTlsPolicy only applies to a global BackendService with the loadBalancingScheme set to INTERNAL_SELF_MANAGED. If left blank, communications are not encrypted. Note: This field currently has no impact.
        """
        return pulumi.get(self, "client_tls_policy")

    @client_tls_policy.setter
    def client_tls_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_tls_policy", value)

    @property
    @pulumi.getter(name="subjectAltNames")
    def subject_alt_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Optional. A list of Subject Alternative Names (SANs) that the client verifies during a mutual TLS handshake with an server/endpoint for this BackendService. When the server presents its X.509 certificate to the client, the client inspects the certificate's subjectAltName field. If the field contains one of the specified values, the communication continues. Otherwise, it fails. This additional check enables the client to verify that the server is authorized to run the requested service. Note that the contents of the server certificate's subjectAltName field are configured by the Public Key Infrastructure which provisions server identities. Only applies to a global BackendService with loadBalancingScheme set to INTERNAL_SELF_MANAGED. Only applies when BackendService has an attached clientTlsPolicy with clientCertificate (mTLS mode). Note: This field currently has no impact.
        """
        return pulumi.get(self, "subject_alt_names")

    @subject_alt_names.setter
    def subject_alt_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "subject_alt_names", value)


@pulumi.input_type
class ServerBindingArgs:
    def __init__(__self__, *,
                 type: Optional[pulumi.Input['ServerBindingType']] = None):
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input['ServerBindingType']]:
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input['ServerBindingType']]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class ServiceAccountArgs:
    def __init__(__self__, *,
                 email: Optional[pulumi.Input[str]] = None,
                 scopes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        A service account.
        :param pulumi.Input[str] email: Email address of the service account.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] scopes: The list of scopes to be made available for this service account.
        """
        if email is not None:
            pulumi.set(__self__, "email", email)
        if scopes is not None:
            pulumi.set(__self__, "scopes", scopes)

    @property
    @pulumi.getter
    def email(self) -> Optional[pulumi.Input[str]]:
        """
        Email address of the service account.
        """
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "email", value)

    @property
    @pulumi.getter
    def scopes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of scopes to be made available for this service account.
        """
        return pulumi.get(self, "scopes")

    @scopes.setter
    def scopes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "scopes", value)


@pulumi.input_type
class ServiceAttachmentConsumerProjectLimitArgs:
    def __init__(__self__, *,
                 connection_limit: Optional[pulumi.Input[int]] = None,
                 project_id_or_num: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[int] connection_limit: The value of the limit to set.
        :param pulumi.Input[str] project_id_or_num: The project id or number for the project to set the limit for.
        """
        if connection_limit is not None:
            pulumi.set(__self__, "connection_limit", connection_limit)
        if project_id_or_num is not None:
            pulumi.set(__self__, "project_id_or_num", project_id_or_num)

    @property
    @pulumi.getter(name="connectionLimit")
    def connection_limit(self) -> Optional[pulumi.Input[int]]:
        """
        The value of the limit to set.
        """
        return pulumi.get(self, "connection_limit")

    @connection_limit.setter
    def connection_limit(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "connection_limit", value)

    @property
    @pulumi.getter(name="projectIdOrNum")
    def project_id_or_num(self) -> Optional[pulumi.Input[str]]:
        """
        The project id or number for the project to set the limit for.
        """
        return pulumi.get(self, "project_id_or_num")

    @project_id_or_num.setter
    def project_id_or_num(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_id_or_num", value)


@pulumi.input_type
class ShareSettingsArgs:
    def __init__(__self__, *,
                 project_map: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 projects: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 share_type: Optional[pulumi.Input['ShareSettingsShareType']] = None):
        """
        The share setting for reservations and sole tenancy node groups.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] project_map: A map of project id and project config. This is only valid when share_type's value is SPECIFIC_PROJECTS.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] projects: A List of Project names to specify consumer projects for this shared-reservation. This is only valid when share_type's value is SPECIFIC_PROJECTS.
        :param pulumi.Input['ShareSettingsShareType'] share_type: Type of sharing for this shared-reservation
        """
        if project_map is not None:
            pulumi.set(__self__, "project_map", project_map)
        if projects is not None:
            pulumi.set(__self__, "projects", projects)
        if share_type is not None:
            pulumi.set(__self__, "share_type", share_type)

    @property
    @pulumi.getter(name="projectMap")
    def project_map(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map of project id and project config. This is only valid when share_type's value is SPECIFIC_PROJECTS.
        """
        return pulumi.get(self, "project_map")

    @project_map.setter
    def project_map(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "project_map", value)

    @property
    @pulumi.getter
    def projects(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A List of Project names to specify consumer projects for this shared-reservation. This is only valid when share_type's value is SPECIFIC_PROJECTS.
        """
        return pulumi.get(self, "projects")

    @projects.setter
    def projects(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "projects", value)

    @property
    @pulumi.getter(name="shareType")
    def share_type(self) -> Optional[pulumi.Input['ShareSettingsShareType']]:
        """
        Type of sharing for this shared-reservation
        """
        return pulumi.get(self, "share_type")

    @share_type.setter
    def share_type(self, value: Optional[pulumi.Input['ShareSettingsShareType']]):
        pulumi.set(self, "share_type", value)


@pulumi.input_type
class ShieldedInstanceConfigArgs:
    def __init__(__self__, *,
                 enable_integrity_monitoring: Optional[pulumi.Input[bool]] = None,
                 enable_secure_boot: Optional[pulumi.Input[bool]] = None,
                 enable_vtpm: Optional[pulumi.Input[bool]] = None):
        """
        A set of Shielded Instance options.
        :param pulumi.Input[bool] enable_integrity_monitoring: Defines whether the instance has integrity monitoring enabled. Enabled by default.
        :param pulumi.Input[bool] enable_secure_boot: Defines whether the instance has Secure Boot enabled. Disabled by default.
        :param pulumi.Input[bool] enable_vtpm: Defines whether the instance has the vTPM enabled. Enabled by default.
        """
        if enable_integrity_monitoring is not None:
            pulumi.set(__self__, "enable_integrity_monitoring", enable_integrity_monitoring)
        if enable_secure_boot is not None:
            pulumi.set(__self__, "enable_secure_boot", enable_secure_boot)
        if enable_vtpm is not None:
            pulumi.set(__self__, "enable_vtpm", enable_vtpm)

    @property
    @pulumi.getter(name="enableIntegrityMonitoring")
    def enable_integrity_monitoring(self) -> Optional[pulumi.Input[bool]]:
        """
        Defines whether the instance has integrity monitoring enabled. Enabled by default.
        """
        return pulumi.get(self, "enable_integrity_monitoring")

    @enable_integrity_monitoring.setter
    def enable_integrity_monitoring(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_integrity_monitoring", value)

    @property
    @pulumi.getter(name="enableSecureBoot")
    def enable_secure_boot(self) -> Optional[pulumi.Input[bool]]:
        """
        Defines whether the instance has Secure Boot enabled. Disabled by default.
        """
        return pulumi.get(self, "enable_secure_boot")

    @enable_secure_boot.setter
    def enable_secure_boot(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_secure_boot", value)

    @property
    @pulumi.getter(name="enableVtpm")
    def enable_vtpm(self) -> Optional[pulumi.Input[bool]]:
        """
        Defines whether the instance has the vTPM enabled. Enabled by default.
        """
        return pulumi.get(self, "enable_vtpm")

    @enable_vtpm.setter
    def enable_vtpm(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_vtpm", value)


@pulumi.input_type
class ShieldedInstanceIntegrityPolicyArgs:
    def __init__(__self__, *,
                 update_auto_learn_policy: Optional[pulumi.Input[bool]] = None):
        """
        The policy describes the baseline against which Instance boot integrity is measured.
        :param pulumi.Input[bool] update_auto_learn_policy: Updates the integrity policy baseline using the measurements from the VM instance's most recent boot.
        """
        if update_auto_learn_policy is not None:
            pulumi.set(__self__, "update_auto_learn_policy", update_auto_learn_policy)

    @property
    @pulumi.getter(name="updateAutoLearnPolicy")
    def update_auto_learn_policy(self) -> Optional[pulumi.Input[bool]]:
        """
        Updates the integrity policy baseline using the measurements from the VM instance's most recent boot.
        """
        return pulumi.get(self, "update_auto_learn_policy")

    @update_auto_learn_policy.setter
    def update_auto_learn_policy(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "update_auto_learn_policy", value)


@pulumi.input_type
class ShieldedVmConfigArgs:
    def __init__(__self__, *,
                 enable_integrity_monitoring: Optional[pulumi.Input[bool]] = None,
                 enable_secure_boot: Optional[pulumi.Input[bool]] = None,
                 enable_vtpm: Optional[pulumi.Input[bool]] = None):
        """
        A set of Shielded VM options.
        :param pulumi.Input[bool] enable_integrity_monitoring: Defines whether the instance has integrity monitoring enabled.
        :param pulumi.Input[bool] enable_secure_boot: Defines whether the instance has Secure Boot enabled.
        :param pulumi.Input[bool] enable_vtpm: Defines whether the instance has the vTPM enabled.
        """
        if enable_integrity_monitoring is not None:
            pulumi.set(__self__, "enable_integrity_monitoring", enable_integrity_monitoring)
        if enable_secure_boot is not None:
            pulumi.set(__self__, "enable_secure_boot", enable_secure_boot)
        if enable_vtpm is not None:
            pulumi.set(__self__, "enable_vtpm", enable_vtpm)

    @property
    @pulumi.getter(name="enableIntegrityMonitoring")
    def enable_integrity_monitoring(self) -> Optional[pulumi.Input[bool]]:
        """
        Defines whether the instance has integrity monitoring enabled.
        """
        return pulumi.get(self, "enable_integrity_monitoring")

    @enable_integrity_monitoring.setter
    def enable_integrity_monitoring(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_integrity_monitoring", value)

    @property
    @pulumi.getter(name="enableSecureBoot")
    def enable_secure_boot(self) -> Optional[pulumi.Input[bool]]:
        """
        Defines whether the instance has Secure Boot enabled.
        """
        return pulumi.get(self, "enable_secure_boot")

    @enable_secure_boot.setter
    def enable_secure_boot(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_secure_boot", value)

    @property
    @pulumi.getter(name="enableVtpm")
    def enable_vtpm(self) -> Optional[pulumi.Input[bool]]:
        """
        Defines whether the instance has the vTPM enabled.
        """
        return pulumi.get(self, "enable_vtpm")

    @enable_vtpm.setter
    def enable_vtpm(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_vtpm", value)


@pulumi.input_type
class ShieldedVmIntegrityPolicyArgs:
    def __init__(__self__, *,
                 update_auto_learn_policy: Optional[pulumi.Input[bool]] = None):
        """
        The policy describes the baseline against which VM instance boot integrity is measured.
        :param pulumi.Input[bool] update_auto_learn_policy: Updates the integrity policy baseline using the measurements from the VM instance's most recent boot.
        """
        if update_auto_learn_policy is not None:
            pulumi.set(__self__, "update_auto_learn_policy", update_auto_learn_policy)

    @property
    @pulumi.getter(name="updateAutoLearnPolicy")
    def update_auto_learn_policy(self) -> Optional[pulumi.Input[bool]]:
        """
        Updates the integrity policy baseline using the measurements from the VM instance's most recent boot.
        """
        return pulumi.get(self, "update_auto_learn_policy")

    @update_auto_learn_policy.setter
    def update_auto_learn_policy(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "update_auto_learn_policy", value)


@pulumi.input_type
class SourceDiskEncryptionKeyArgs:
    def __init__(__self__, *,
                 disk_encryption_key: Optional[pulumi.Input['CustomerEncryptionKeyArgs']] = None,
                 source_disk: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input['CustomerEncryptionKeyArgs'] disk_encryption_key: The customer-supplied encryption key of the source disk. Required if the source disk is protected by a customer-supplied encryption key.
        :param pulumi.Input[str] source_disk: URL of the disk attached to the source instance. This can be a full or valid partial URL. For example, the following are valid values: - https://www.googleapis.com/compute/v1/projects/project/zones/zone /disks/disk - projects/project/zones/zone/disks/disk - zones/zone/disks/disk 
        """
        if disk_encryption_key is not None:
            pulumi.set(__self__, "disk_encryption_key", disk_encryption_key)
        if source_disk is not None:
            pulumi.set(__self__, "source_disk", source_disk)

    @property
    @pulumi.getter(name="diskEncryptionKey")
    def disk_encryption_key(self) -> Optional[pulumi.Input['CustomerEncryptionKeyArgs']]:
        """
        The customer-supplied encryption key of the source disk. Required if the source disk is protected by a customer-supplied encryption key.
        """
        return pulumi.get(self, "disk_encryption_key")

    @disk_encryption_key.setter
    def disk_encryption_key(self, value: Optional[pulumi.Input['CustomerEncryptionKeyArgs']]):
        pulumi.set(self, "disk_encryption_key", value)

    @property
    @pulumi.getter(name="sourceDisk")
    def source_disk(self) -> Optional[pulumi.Input[str]]:
        """
        URL of the disk attached to the source instance. This can be a full or valid partial URL. For example, the following are valid values: - https://www.googleapis.com/compute/v1/projects/project/zones/zone /disks/disk - projects/project/zones/zone/disks/disk - zones/zone/disks/disk 
        """
        return pulumi.get(self, "source_disk")

    @source_disk.setter
    def source_disk(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_disk", value)


@pulumi.input_type
class SourceInstanceParamsArgs:
    def __init__(__self__, *,
                 disk_configs: Optional[pulumi.Input[Sequence[pulumi.Input['DiskInstantiationConfigArgs']]]] = None):
        """
        A specification of the parameters to use when creating the instance template from a source instance.
        :param pulumi.Input[Sequence[pulumi.Input['DiskInstantiationConfigArgs']]] disk_configs: Attached disks configuration. If not provided, defaults are applied: For boot disk and any other R/W disks, new custom images will be created from each disk. For read-only disks, they will be attached in read-only mode. Local SSD disks will be created as blank volumes.
        """
        if disk_configs is not None:
            pulumi.set(__self__, "disk_configs", disk_configs)

    @property
    @pulumi.getter(name="diskConfigs")
    def disk_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DiskInstantiationConfigArgs']]]]:
        """
        Attached disks configuration. If not provided, defaults are applied: For boot disk and any other R/W disks, new custom images will be created from each disk. For read-only disks, they will be attached in read-only mode. Local SSD disks will be created as blank volumes.
        """
        return pulumi.get(self, "disk_configs")

    @disk_configs.setter
    def disk_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DiskInstantiationConfigArgs']]]]):
        pulumi.set(self, "disk_configs", value)


@pulumi.input_type
class SslCertificateManagedSslCertificateArgs:
    def __init__(__self__, *,
                 domains: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Configuration and status of a managed SSL certificate.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] domains: The domains for which a managed SSL certificate will be generated. Each Google-managed SSL certificate supports up to the [maximum number of domains per Google-managed SSL certificate](/load-balancing/docs/quotas#ssl_certificates).
        """
        if domains is not None:
            pulumi.set(__self__, "domains", domains)

    @property
    @pulumi.getter
    def domains(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The domains for which a managed SSL certificate will be generated. Each Google-managed SSL certificate supports up to the [maximum number of domains per Google-managed SSL certificate](/load-balancing/docs/quotas#ssl_certificates).
        """
        return pulumi.get(self, "domains")

    @domains.setter
    def domains(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "domains", value)


@pulumi.input_type
class SslCertificateSelfManagedSslCertificateArgs:
    def __init__(__self__, *,
                 certificate: Optional[pulumi.Input[str]] = None,
                 private_key: Optional[pulumi.Input[str]] = None):
        """
        Configuration and status of a self-managed SSL certificate.
        :param pulumi.Input[str] certificate: A local certificate file. The certificate must be in PEM format. The certificate chain must be no greater than 5 certs long. The chain must include at least one intermediate cert.
        :param pulumi.Input[str] private_key: A write-only private key in PEM format. Only insert requests will include this field.
        """
        if certificate is not None:
            pulumi.set(__self__, "certificate", certificate)
        if private_key is not None:
            pulumi.set(__self__, "private_key", private_key)

    @property
    @pulumi.getter
    def certificate(self) -> Optional[pulumi.Input[str]]:
        """
        A local certificate file. The certificate must be in PEM format. The certificate chain must be no greater than 5 certs long. The chain must include at least one intermediate cert.
        """
        return pulumi.get(self, "certificate")

    @certificate.setter
    def certificate(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "certificate", value)

    @property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> Optional[pulumi.Input[str]]:
        """
        A write-only private key in PEM format. Only insert requests will include this field.
        """
        return pulumi.get(self, "private_key")

    @private_key.setter
    def private_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_key", value)


@pulumi.input_type
class StatefulPolicyPreservedStateArgs:
    def __init__(__self__, *,
                 disks: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 external_ips: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 internal_ips: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        Configuration of preserved resources.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] disks: Disks created on the instances that will be preserved on instance delete, update, etc. This map is keyed with the device names of the disks.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] external_ips: External network IPs assigned to the instances that will be preserved on instance delete, update, etc. This map is keyed with the network interface name.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] internal_ips: Internal network IPs assigned to the instances that will be preserved on instance delete, update, etc. This map is keyed with the network interface name.
        """
        if disks is not None:
            pulumi.set(__self__, "disks", disks)
        if external_ips is not None:
            pulumi.set(__self__, "external_ips", external_ips)
        if internal_ips is not None:
            pulumi.set(__self__, "internal_ips", internal_ips)

    @property
    @pulumi.getter
    def disks(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Disks created on the instances that will be preserved on instance delete, update, etc. This map is keyed with the device names of the disks.
        """
        return pulumi.get(self, "disks")

    @disks.setter
    def disks(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "disks", value)

    @property
    @pulumi.getter(name="externalIPs")
    def external_ips(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        External network IPs assigned to the instances that will be preserved on instance delete, update, etc. This map is keyed with the network interface name.
        """
        return pulumi.get(self, "external_ips")

    @external_ips.setter
    def external_ips(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "external_ips", value)

    @property
    @pulumi.getter(name="internalIPs")
    def internal_ips(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Internal network IPs assigned to the instances that will be preserved on instance delete, update, etc. This map is keyed with the network interface name.
        """
        return pulumi.get(self, "internal_ips")

    @internal_ips.setter
    def internal_ips(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "internal_ips", value)


@pulumi.input_type
class StatefulPolicyArgs:
    def __init__(__self__, *,
                 preserved_state: Optional[pulumi.Input['StatefulPolicyPreservedStateArgs']] = None):
        if preserved_state is not None:
            pulumi.set(__self__, "preserved_state", preserved_state)

    @property
    @pulumi.getter(name="preservedState")
    def preserved_state(self) -> Optional[pulumi.Input['StatefulPolicyPreservedStateArgs']]:
        return pulumi.get(self, "preserved_state")

    @preserved_state.setter
    def preserved_state(self, value: Optional[pulumi.Input['StatefulPolicyPreservedStateArgs']]):
        pulumi.set(self, "preserved_state", value)


@pulumi.input_type
class SubnetworkLogConfigArgs:
    def __init__(__self__, *,
                 aggregation_interval: Optional[pulumi.Input['SubnetworkLogConfigAggregationInterval']] = None,
                 enable: Optional[pulumi.Input[bool]] = None,
                 filter_expr: Optional[pulumi.Input[str]] = None,
                 flow_sampling: Optional[pulumi.Input[float]] = None,
                 metadata: Optional[pulumi.Input['SubnetworkLogConfigMetadata']] = None,
                 metadata_fields: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The available logging options for this subnetwork.
        :param pulumi.Input['SubnetworkLogConfigAggregationInterval'] aggregation_interval: Can only be specified if VPC flow logging for this subnetwork is enabled. Toggles the aggregation interval for collecting flow logs. Increasing the interval time will reduce the amount of generated flow logs for long lasting connections. Default is an interval of 5 seconds per connection.
        :param pulumi.Input[bool] enable: Whether to enable flow logging for this subnetwork. If this field is not explicitly set, it will not appear in get listings. If not set the default behavior is determined by the org policy, if there is no org policy specified, then it will default to disabled.
        :param pulumi.Input[str] filter_expr: Can only be specified if VPC flow logs for this subnetwork is enabled. Export filter used to define which VPC flow logs should be logged.
        :param pulumi.Input[float] flow_sampling: Can only be specified if VPC flow logging for this subnetwork is enabled. The value of the field must be in [0, 1]. Set the sampling rate of VPC flow logs within the subnetwork where 1.0 means all collected logs are reported and 0.0 means no logs are reported. Default is 0.5 unless otherwise specified by the org policy, which means half of all collected logs are reported.
        :param pulumi.Input['SubnetworkLogConfigMetadata'] metadata: Can only be specified if VPC flow logs for this subnetwork is enabled. Configures whether all, none or a subset of metadata fields should be added to the reported VPC flow logs. Default is EXCLUDE_ALL_METADATA.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] metadata_fields: Can only be specified if VPC flow logs for this subnetwork is enabled and "metadata" was set to CUSTOM_METADATA.
        """
        if aggregation_interval is not None:
            pulumi.set(__self__, "aggregation_interval", aggregation_interval)
        if enable is not None:
            pulumi.set(__self__, "enable", enable)
        if filter_expr is not None:
            pulumi.set(__self__, "filter_expr", filter_expr)
        if flow_sampling is not None:
            pulumi.set(__self__, "flow_sampling", flow_sampling)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if metadata_fields is not None:
            pulumi.set(__self__, "metadata_fields", metadata_fields)

    @property
    @pulumi.getter(name="aggregationInterval")
    def aggregation_interval(self) -> Optional[pulumi.Input['SubnetworkLogConfigAggregationInterval']]:
        """
        Can only be specified if VPC flow logging for this subnetwork is enabled. Toggles the aggregation interval for collecting flow logs. Increasing the interval time will reduce the amount of generated flow logs for long lasting connections. Default is an interval of 5 seconds per connection.
        """
        return pulumi.get(self, "aggregation_interval")

    @aggregation_interval.setter
    def aggregation_interval(self, value: Optional[pulumi.Input['SubnetworkLogConfigAggregationInterval']]):
        pulumi.set(self, "aggregation_interval", value)

    @property
    @pulumi.getter
    def enable(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to enable flow logging for this subnetwork. If this field is not explicitly set, it will not appear in get listings. If not set the default behavior is determined by the org policy, if there is no org policy specified, then it will default to disabled.
        """
        return pulumi.get(self, "enable")

    @enable.setter
    def enable(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable", value)

    @property
    @pulumi.getter(name="filterExpr")
    def filter_expr(self) -> Optional[pulumi.Input[str]]:
        """
        Can only be specified if VPC flow logs for this subnetwork is enabled. Export filter used to define which VPC flow logs should be logged.
        """
        return pulumi.get(self, "filter_expr")

    @filter_expr.setter
    def filter_expr(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "filter_expr", value)

    @property
    @pulumi.getter(name="flowSampling")
    def flow_sampling(self) -> Optional[pulumi.Input[float]]:
        """
        Can only be specified if VPC flow logging for this subnetwork is enabled. The value of the field must be in [0, 1]. Set the sampling rate of VPC flow logs within the subnetwork where 1.0 means all collected logs are reported and 0.0 means no logs are reported. Default is 0.5 unless otherwise specified by the org policy, which means half of all collected logs are reported.
        """
        return pulumi.get(self, "flow_sampling")

    @flow_sampling.setter
    def flow_sampling(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "flow_sampling", value)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input['SubnetworkLogConfigMetadata']]:
        """
        Can only be specified if VPC flow logs for this subnetwork is enabled. Configures whether all, none or a subset of metadata fields should be added to the reported VPC flow logs. Default is EXCLUDE_ALL_METADATA.
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input['SubnetworkLogConfigMetadata']]):
        pulumi.set(self, "metadata", value)

    @property
    @pulumi.getter(name="metadataFields")
    def metadata_fields(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Can only be specified if VPC flow logs for this subnetwork is enabled and "metadata" was set to CUSTOM_METADATA.
        """
        return pulumi.get(self, "metadata_fields")

    @metadata_fields.setter
    def metadata_fields(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "metadata_fields", value)


@pulumi.input_type
class SubnetworkSecondaryRangeArgs:
    def __init__(__self__, *,
                 ip_cidr_range: Optional[pulumi.Input[str]] = None,
                 range_name: Optional[pulumi.Input[str]] = None):
        """
        Represents a secondary IP range of a subnetwork.
        :param pulumi.Input[str] ip_cidr_range: The range of IP addresses belonging to this subnetwork secondary range. Provide this property when you create the subnetwork. Ranges must be unique and non-overlapping with all primary and secondary IP ranges within a network. Only IPv4 is supported. The range can be any range listed in the Valid ranges list.
        :param pulumi.Input[str] range_name: The name associated with this subnetwork secondary range, used when adding an alias IP range to a VM instance. The name must be 1-63 characters long, and comply with RFC1035. The name must be unique within the subnetwork.
        """
        if ip_cidr_range is not None:
            pulumi.set(__self__, "ip_cidr_range", ip_cidr_range)
        if range_name is not None:
            pulumi.set(__self__, "range_name", range_name)

    @property
    @pulumi.getter(name="ipCidrRange")
    def ip_cidr_range(self) -> Optional[pulumi.Input[str]]:
        """
        The range of IP addresses belonging to this subnetwork secondary range. Provide this property when you create the subnetwork. Ranges must be unique and non-overlapping with all primary and secondary IP ranges within a network. Only IPv4 is supported. The range can be any range listed in the Valid ranges list.
        """
        return pulumi.get(self, "ip_cidr_range")

    @ip_cidr_range.setter
    def ip_cidr_range(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip_cidr_range", value)

    @property
    @pulumi.getter(name="rangeName")
    def range_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name associated with this subnetwork secondary range, used when adding an alias IP range to a VM instance. The name must be 1-63 characters long, and comply with RFC1035. The name must be unique within the subnetwork.
        """
        return pulumi.get(self, "range_name")

    @range_name.setter
    def range_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "range_name", value)


@pulumi.input_type
class SubsettingArgs:
    def __init__(__self__, *,
                 policy: Optional[pulumi.Input['SubsettingPolicy']] = None,
                 subset_size: Optional[pulumi.Input[int]] = None):
        """
        Subsetting configuration for this BackendService. Currently this is applicable only for Internal TCP/UDP load balancing, Internal HTTP(S) load balancing and Traffic Director.
        :param pulumi.Input[int] subset_size: The number of backends per backend group assigned to each proxy instance or each service mesh client. An input parameter to the `CONSISTENT_HASH_SUBSETTING` algorithm. Can only be set if `policy` is set to `CONSISTENT_HASH_SUBSETTING`. Can only be set if load balancing scheme is `INTERNAL_MANAGED` or `INTERNAL_SELF_MANAGED`. `subset_size` is optional for Internal HTTP(S) load balancing and required for Traffic Director. If you do not provide this value, Cloud Load Balancing will calculate it dynamically to optimize the number of proxies/clients visible to each backend and vice versa. Must be greater than 0. If `subset_size` is larger than the number of backends/endpoints, then subsetting is disabled.
        """
        if policy is not None:
            pulumi.set(__self__, "policy", policy)
        if subset_size is not None:
            pulumi.set(__self__, "subset_size", subset_size)

    @property
    @pulumi.getter
    def policy(self) -> Optional[pulumi.Input['SubsettingPolicy']]:
        return pulumi.get(self, "policy")

    @policy.setter
    def policy(self, value: Optional[pulumi.Input['SubsettingPolicy']]):
        pulumi.set(self, "policy", value)

    @property
    @pulumi.getter(name="subsetSize")
    def subset_size(self) -> Optional[pulumi.Input[int]]:
        """
        The number of backends per backend group assigned to each proxy instance or each service mesh client. An input parameter to the `CONSISTENT_HASH_SUBSETTING` algorithm. Can only be set if `policy` is set to `CONSISTENT_HASH_SUBSETTING`. Can only be set if load balancing scheme is `INTERNAL_MANAGED` or `INTERNAL_SELF_MANAGED`. `subset_size` is optional for Internal HTTP(S) load balancing and required for Traffic Director. If you do not provide this value, Cloud Load Balancing will calculate it dynamically to optimize the number of proxies/clients visible to each backend and vice versa. Must be greater than 0. If `subset_size` is larger than the number of backends/endpoints, then subsetting is disabled.
        """
        return pulumi.get(self, "subset_size")

    @subset_size.setter
    def subset_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "subset_size", value)


@pulumi.input_type
class TCPHealthCheckArgs:
    def __init__(__self__, *,
                 port: Optional[pulumi.Input[int]] = None,
                 port_name: Optional[pulumi.Input[str]] = None,
                 port_specification: Optional[pulumi.Input['TCPHealthCheckPortSpecification']] = None,
                 proxy_header: Optional[pulumi.Input['TCPHealthCheckProxyHeader']] = None,
                 request: Optional[pulumi.Input[str]] = None,
                 response: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[int] port: The TCP port number for the health check request. The default value is 80. Valid values are 1 through 65535.
        :param pulumi.Input[str] port_name: Port name as defined in InstanceGroup#NamedPort#name. If both port and port_name are defined, port takes precedence.
        :param pulumi.Input['TCPHealthCheckPortSpecification'] port_specification: Specifies how port is selected for health checking, can be one of following values: USE_FIXED_PORT: The port number in port is used for health checking. USE_NAMED_PORT: The portName is used for health checking. USE_SERVING_PORT: For NetworkEndpointGroup, the port specified for each network endpoint is used for health checking. For other backends, the port or named port specified in the Backend Service is used for health checking. If not specified, TCP health check follows behavior specified in port and portName fields.
        :param pulumi.Input['TCPHealthCheckProxyHeader'] proxy_header: Specifies the type of proxy header to append before sending data to the backend, either NONE or PROXY_V1. The default is NONE.
        :param pulumi.Input[str] request: The application data to send once the TCP connection has been established (default value is empty). If both request and response are empty, the connection establishment alone will indicate health. The request data can only be ASCII.
        :param pulumi.Input[str] response: The bytes to match against the beginning of the response data. If left empty (the default value), any response will indicate health. The response data can only be ASCII.
        """
        if port is not None:
            pulumi.set(__self__, "port", port)
        if port_name is not None:
            pulumi.set(__self__, "port_name", port_name)
        if port_specification is not None:
            pulumi.set(__self__, "port_specification", port_specification)
        if proxy_header is not None:
            pulumi.set(__self__, "proxy_header", proxy_header)
        if request is not None:
            pulumi.set(__self__, "request", request)
        if response is not None:
            pulumi.set(__self__, "response", response)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        The TCP port number for the health check request. The default value is 80. Valid values are 1 through 65535.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter(name="portName")
    def port_name(self) -> Optional[pulumi.Input[str]]:
        """
        Port name as defined in InstanceGroup#NamedPort#name. If both port and port_name are defined, port takes precedence.
        """
        return pulumi.get(self, "port_name")

    @port_name.setter
    def port_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "port_name", value)

    @property
    @pulumi.getter(name="portSpecification")
    def port_specification(self) -> Optional[pulumi.Input['TCPHealthCheckPortSpecification']]:
        """
        Specifies how port is selected for health checking, can be one of following values: USE_FIXED_PORT: The port number in port is used for health checking. USE_NAMED_PORT: The portName is used for health checking. USE_SERVING_PORT: For NetworkEndpointGroup, the port specified for each network endpoint is used for health checking. For other backends, the port or named port specified in the Backend Service is used for health checking. If not specified, TCP health check follows behavior specified in port and portName fields.
        """
        return pulumi.get(self, "port_specification")

    @port_specification.setter
    def port_specification(self, value: Optional[pulumi.Input['TCPHealthCheckPortSpecification']]):
        pulumi.set(self, "port_specification", value)

    @property
    @pulumi.getter(name="proxyHeader")
    def proxy_header(self) -> Optional[pulumi.Input['TCPHealthCheckProxyHeader']]:
        """
        Specifies the type of proxy header to append before sending data to the backend, either NONE or PROXY_V1. The default is NONE.
        """
        return pulumi.get(self, "proxy_header")

    @proxy_header.setter
    def proxy_header(self, value: Optional[pulumi.Input['TCPHealthCheckProxyHeader']]):
        pulumi.set(self, "proxy_header", value)

    @property
    @pulumi.getter
    def request(self) -> Optional[pulumi.Input[str]]:
        """
        The application data to send once the TCP connection has been established (default value is empty). If both request and response are empty, the connection establishment alone will indicate health. The request data can only be ASCII.
        """
        return pulumi.get(self, "request")

    @request.setter
    def request(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "request", value)

    @property
    @pulumi.getter
    def response(self) -> Optional[pulumi.Input[str]]:
        """
        The bytes to match against the beginning of the response data. If left empty (the default value), any response will indicate health. The response data can only be ASCII.
        """
        return pulumi.get(self, "response")

    @response.setter
    def response(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "response", value)


@pulumi.input_type
class TagsArgs:
    def __init__(__self__, *,
                 items: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        A set of instance tags.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] items: An array of tags. Each tag must be 1-63 characters long, and comply with RFC1035.
        """
        if items is not None:
            pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        An array of tags. Each tag must be 1-63 characters long, and comply with RFC1035.
        """
        return pulumi.get(self, "items")

    @items.setter
    def items(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "items", value)


@pulumi.input_type
class UrlMapTestHeaderArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[str]] = None):
        """
        HTTP headers used in UrlMapTests.
        :param pulumi.Input[str] name: Header name.
        :param pulumi.Input[str] value: Header value.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Header name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        Header value.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class UrlMapTestArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 expected_output_url: Optional[pulumi.Input[str]] = None,
                 expected_redirect_response_code: Optional[pulumi.Input[int]] = None,
                 headers: Optional[pulumi.Input[Sequence[pulumi.Input['UrlMapTestHeaderArgs']]]] = None,
                 host: Optional[pulumi.Input[str]] = None,
                 path: Optional[pulumi.Input[str]] = None,
                 service: Optional[pulumi.Input[str]] = None):
        """
        Message for the expected URL mappings.
        :param pulumi.Input[str] description: Description of this test case.
        :param pulumi.Input[str] expected_output_url: The expected output URL evaluated by the load balancer containing the scheme, host, path and query parameters. For rules that forward requests to backends, the test passes only when expectedOutputUrl matches the request forwarded by the load balancer to backends. For rules with urlRewrite, the test verifies that the forwarded request matches hostRewrite and pathPrefixRewrite in the urlRewrite action. When service is specified, expectedOutputUrl`s scheme is ignored. For rules with urlRedirect, the test passes only if expectedOutputUrl matches the URL in the load balancer's redirect response. If urlRedirect specifies https_redirect, the test passes only if the scheme in expectedOutputUrl is also set to HTTPS. If urlRedirect specifies strip_query, the test passes only if expectedOutputUrl does not contain any query parameters. expectedOutputUrl is optional when service is specified.
        :param pulumi.Input[int] expected_redirect_response_code: For rules with urlRedirect, the test passes only if expectedRedirectResponseCode matches the HTTP status code in load balancer's redirect response. expectedRedirectResponseCode cannot be set when service is set.
        :param pulumi.Input[Sequence[pulumi.Input['UrlMapTestHeaderArgs']]] headers: HTTP headers for this request. If headers contains a host header, then host must also match the header value.
        :param pulumi.Input[str] host: Host portion of the URL. If headers contains a host header, then host must also match the header value.
        :param pulumi.Input[str] path: Path portion of the URL.
        :param pulumi.Input[str] service: Expected BackendService or BackendBucket resource the given URL should be mapped to. The service field cannot be set if expectedRedirectResponseCode is set.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if expected_output_url is not None:
            pulumi.set(__self__, "expected_output_url", expected_output_url)
        if expected_redirect_response_code is not None:
            pulumi.set(__self__, "expected_redirect_response_code", expected_redirect_response_code)
        if headers is not None:
            pulumi.set(__self__, "headers", headers)
        if host is not None:
            pulumi.set(__self__, "host", host)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if service is not None:
            pulumi.set(__self__, "service", service)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of this test case.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="expectedOutputUrl")
    def expected_output_url(self) -> Optional[pulumi.Input[str]]:
        """
        The expected output URL evaluated by the load balancer containing the scheme, host, path and query parameters. For rules that forward requests to backends, the test passes only when expectedOutputUrl matches the request forwarded by the load balancer to backends. For rules with urlRewrite, the test verifies that the forwarded request matches hostRewrite and pathPrefixRewrite in the urlRewrite action. When service is specified, expectedOutputUrl`s scheme is ignored. For rules with urlRedirect, the test passes only if expectedOutputUrl matches the URL in the load balancer's redirect response. If urlRedirect specifies https_redirect, the test passes only if the scheme in expectedOutputUrl is also set to HTTPS. If urlRedirect specifies strip_query, the test passes only if expectedOutputUrl does not contain any query parameters. expectedOutputUrl is optional when service is specified.
        """
        return pulumi.get(self, "expected_output_url")

    @expected_output_url.setter
    def expected_output_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expected_output_url", value)

    @property
    @pulumi.getter(name="expectedRedirectResponseCode")
    def expected_redirect_response_code(self) -> Optional[pulumi.Input[int]]:
        """
        For rules with urlRedirect, the test passes only if expectedRedirectResponseCode matches the HTTP status code in load balancer's redirect response. expectedRedirectResponseCode cannot be set when service is set.
        """
        return pulumi.get(self, "expected_redirect_response_code")

    @expected_redirect_response_code.setter
    def expected_redirect_response_code(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "expected_redirect_response_code", value)

    @property
    @pulumi.getter
    def headers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['UrlMapTestHeaderArgs']]]]:
        """
        HTTP headers for this request. If headers contains a host header, then host must also match the header value.
        """
        return pulumi.get(self, "headers")

    @headers.setter
    def headers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['UrlMapTestHeaderArgs']]]]):
        pulumi.set(self, "headers", value)

    @property
    @pulumi.getter
    def host(self) -> Optional[pulumi.Input[str]]:
        """
        Host portion of the URL. If headers contains a host header, then host must also match the header value.
        """
        return pulumi.get(self, "host")

    @host.setter
    def host(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "host", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        """
        Path portion of the URL.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter
    def service(self) -> Optional[pulumi.Input[str]]:
        """
        Expected BackendService or BackendBucket resource the given URL should be mapped to. The service field cannot be set if expectedRedirectResponseCode is set.
        """
        return pulumi.get(self, "service")

    @service.setter
    def service(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service", value)


@pulumi.input_type
class UrlRewriteArgs:
    def __init__(__self__, *,
                 host_rewrite: Optional[pulumi.Input[str]] = None,
                 path_prefix_rewrite: Optional[pulumi.Input[str]] = None):
        """
        The spec for modifying the path before sending the request to the matched backend service.
        :param pulumi.Input[str] host_rewrite: Before forwarding the request to the selected service, the request's host header is replaced with contents of hostRewrite. The value must be from 1 to 255 characters.
        :param pulumi.Input[str] path_prefix_rewrite: Before forwarding the request to the selected backend service, the matching portion of the request's path is replaced by pathPrefixRewrite. The value must be from 1 to 1024 characters.
        """
        if host_rewrite is not None:
            pulumi.set(__self__, "host_rewrite", host_rewrite)
        if path_prefix_rewrite is not None:
            pulumi.set(__self__, "path_prefix_rewrite", path_prefix_rewrite)

    @property
    @pulumi.getter(name="hostRewrite")
    def host_rewrite(self) -> Optional[pulumi.Input[str]]:
        """
        Before forwarding the request to the selected service, the request's host header is replaced with contents of hostRewrite. The value must be from 1 to 255 characters.
        """
        return pulumi.get(self, "host_rewrite")

    @host_rewrite.setter
    def host_rewrite(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "host_rewrite", value)

    @property
    @pulumi.getter(name="pathPrefixRewrite")
    def path_prefix_rewrite(self) -> Optional[pulumi.Input[str]]:
        """
        Before forwarding the request to the selected backend service, the matching portion of the request's path is replaced by pathPrefixRewrite. The value must be from 1 to 1024 characters.
        """
        return pulumi.get(self, "path_prefix_rewrite")

    @path_prefix_rewrite.setter
    def path_prefix_rewrite(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path_prefix_rewrite", value)


@pulumi.input_type
class VpnGatewayVpnGatewayInterfaceArgs:
    def __init__(__self__, *,
                 interconnect_attachment: Optional[pulumi.Input[str]] = None):
        """
        A VPN gateway interface.
        :param pulumi.Input[str] interconnect_attachment: URL of the VLAN attachment (interconnectAttachment) resource for this VPN gateway interface. When the value of this field is present, the VPN gateway is used for IPsec-encrypted Cloud Interconnect; all egress or ingress traffic for this VPN gateway interface goes through the specified VLAN attachment resource. Not currently available publicly. 
        """
        if interconnect_attachment is not None:
            pulumi.set(__self__, "interconnect_attachment", interconnect_attachment)

    @property
    @pulumi.getter(name="interconnectAttachment")
    def interconnect_attachment(self) -> Optional[pulumi.Input[str]]:
        """
        URL of the VLAN attachment (interconnectAttachment) resource for this VPN gateway interface. When the value of this field is present, the VPN gateway is used for IPsec-encrypted Cloud Interconnect; all egress or ingress traffic for this VPN gateway interface goes through the specified VLAN attachment resource. Not currently available publicly. 
        """
        return pulumi.get(self, "interconnect_attachment")

    @interconnect_attachment.setter
    def interconnect_attachment(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "interconnect_attachment", value)


@pulumi.input_type
class WeightedBackendServiceArgs:
    def __init__(__self__, *,
                 backend_service: Optional[pulumi.Input[str]] = None,
                 header_action: Optional[pulumi.Input['HttpHeaderActionArgs']] = None,
                 weight: Optional[pulumi.Input[int]] = None):
        """
        In contrast to a single BackendService in HttpRouteAction to which all matching traffic is directed to, WeightedBackendService allows traffic to be split across multiple backend services. The volume of traffic for each backend service is proportional to the weight specified in each WeightedBackendService
        :param pulumi.Input[str] backend_service: The full or partial URL to the default BackendService resource. Before forwarding the request to backendService, the load balancer applies any relevant headerActions specified as part of this backendServiceWeight.
        :param pulumi.Input['HttpHeaderActionArgs'] header_action: Specifies changes to request and response headers that need to take effect for the selected backendService. headerAction specified here take effect before headerAction in the enclosing HttpRouteRule, PathMatcher and UrlMap. headerAction is not supported for load balancers that have their loadBalancingScheme set to EXTERNAL. Not supported when the URL map is bound to a target gRPC proxy that has validateForProxyless field set to true.
        :param pulumi.Input[int] weight: Specifies the fraction of traffic sent to a backend service, computed as weight / (sum of all weightedBackendService weights in routeAction) . The selection of a backend service is determined only for new traffic. Once a user's request has been directed to a backend service, subsequent requests are sent to the same backend service as determined by the backend service's session affinity policy. The value must be from 0 to 1000.
        """
        if backend_service is not None:
            pulumi.set(__self__, "backend_service", backend_service)
        if header_action is not None:
            pulumi.set(__self__, "header_action", header_action)
        if weight is not None:
            pulumi.set(__self__, "weight", weight)

    @property
    @pulumi.getter(name="backendService")
    def backend_service(self) -> Optional[pulumi.Input[str]]:
        """
        The full or partial URL to the default BackendService resource. Before forwarding the request to backendService, the load balancer applies any relevant headerActions specified as part of this backendServiceWeight.
        """
        return pulumi.get(self, "backend_service")

    @backend_service.setter
    def backend_service(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "backend_service", value)

    @property
    @pulumi.getter(name="headerAction")
    def header_action(self) -> Optional[pulumi.Input['HttpHeaderActionArgs']]:
        """
        Specifies changes to request and response headers that need to take effect for the selected backendService. headerAction specified here take effect before headerAction in the enclosing HttpRouteRule, PathMatcher and UrlMap. headerAction is not supported for load balancers that have their loadBalancingScheme set to EXTERNAL. Not supported when the URL map is bound to a target gRPC proxy that has validateForProxyless field set to true.
        """
        return pulumi.get(self, "header_action")

    @header_action.setter
    def header_action(self, value: Optional[pulumi.Input['HttpHeaderActionArgs']]):
        pulumi.set(self, "header_action", value)

    @property
    @pulumi.getter
    def weight(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the fraction of traffic sent to a backend service, computed as weight / (sum of all weightedBackendService weights in routeAction) . The selection of a backend service is determined only for new traffic. Once a user's request has been directed to a backend service, subsequent requests are sent to the same backend service as determined by the backend service's session affinity policy. The value must be from 0 to 1000.
        """
        return pulumi.get(self, "weight")

    @weight.setter
    def weight(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "weight", value)


