# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'AccessSelectorResponse',
    'ConditionContextResponse',
    'ExprResponse',
    'FeedOutputConfigResponse',
    'IamPolicyAnalysisQueryResponse',
    'IdentitySelectorResponse',
    'OptionsResponse',
    'PubsubDestinationResponse',
    'QueryContentResponse',
    'ResourceSelectorResponse',
]

@pulumi.output_type
class AccessSelectorResponse(dict):
    """
    Specifies roles and/or permissions to analyze, to determine both the identities possessing them and the resources they control. If multiple values are specified, results will include roles or permissions matching any of them. The total number of roles and permissions should be equal or less than 10.
    """
    def __init__(__self__, *,
                 permissions: Sequence[str],
                 roles: Sequence[str]):
        """
        Specifies roles and/or permissions to analyze, to determine both the identities possessing them and the resources they control. If multiple values are specified, results will include roles or permissions matching any of them. The total number of roles and permissions should be equal or less than 10.
        :param Sequence[str] permissions: Optional. The permissions to appear in result.
        :param Sequence[str] roles: Optional. The roles to appear in result.
        """
        pulumi.set(__self__, "permissions", permissions)
        pulumi.set(__self__, "roles", roles)

    @property
    @pulumi.getter
    def permissions(self) -> Sequence[str]:
        """
        Optional. The permissions to appear in result.
        """
        return pulumi.get(self, "permissions")

    @property
    @pulumi.getter
    def roles(self) -> Sequence[str]:
        """
        Optional. The roles to appear in result.
        """
        return pulumi.get(self, "roles")


@pulumi.output_type
class ConditionContextResponse(dict):
    """
    The IAM conditions context.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessTime":
            suggest = "access_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConditionContextResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConditionContextResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConditionContextResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_time: str):
        """
        The IAM conditions context.
        :param str access_time: The hypothetical access timestamp to evaluate IAM conditions. Note that this value must not be earlier than the current time; otherwise, an INVALID_ARGUMENT error will be returned.
        """
        pulumi.set(__self__, "access_time", access_time)

    @property
    @pulumi.getter(name="accessTime")
    def access_time(self) -> str:
        """
        The hypothetical access timestamp to evaluate IAM conditions. Note that this value must not be earlier than the current time; otherwise, an INVALID_ARGUMENT error will be returned.
        """
        return pulumi.get(self, "access_time")


@pulumi.output_type
class ExprResponse(dict):
    """
    Represents a textual expression in the Common Expression Language (CEL) syntax. CEL is a C-like expression language. The syntax and semantics of CEL are documented at https://github.com/google/cel-spec. Example (Comparison): title: "Summary size limit" description: "Determines if a summary is less than 100 chars" expression: "document.summary.size() < 100" Example (Equality): title: "Requestor is owner" description: "Determines if requestor is the document owner" expression: "document.owner == request.auth.claims.email" Example (Logic): title: "Public documents" description: "Determine whether the document should be publicly visible" expression: "document.type != 'private' && document.type != 'internal'" Example (Data Manipulation): title: "Notification string" description: "Create a notification string with a timestamp." expression: "'New message received at ' + string(document.create_time)" The exact variables and functions that may be referenced within an expression are determined by the service that evaluates it. See the service documentation for additional information.
    """
    def __init__(__self__, *,
                 description: str,
                 expression: str,
                 location: str,
                 title: str):
        """
        Represents a textual expression in the Common Expression Language (CEL) syntax. CEL is a C-like expression language. The syntax and semantics of CEL are documented at https://github.com/google/cel-spec. Example (Comparison): title: "Summary size limit" description: "Determines if a summary is less than 100 chars" expression: "document.summary.size() < 100" Example (Equality): title: "Requestor is owner" description: "Determines if requestor is the document owner" expression: "document.owner == request.auth.claims.email" Example (Logic): title: "Public documents" description: "Determine whether the document should be publicly visible" expression: "document.type != 'private' && document.type != 'internal'" Example (Data Manipulation): title: "Notification string" description: "Create a notification string with a timestamp." expression: "'New message received at ' + string(document.create_time)" The exact variables and functions that may be referenced within an expression are determined by the service that evaluates it. See the service documentation for additional information.
        :param str description: Optional. Description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
        :param str expression: Textual representation of an expression in Common Expression Language syntax.
        :param str location: Optional. String indicating the location of the expression for error reporting, e.g. a file name and a position in the file.
        :param str title: Optional. Title for the expression, i.e. a short string describing its purpose. This can be used e.g. in UIs which allow to enter the expression.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Optional. Description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def expression(self) -> str:
        """
        Textual representation of an expression in Common Expression Language syntax.
        """
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def location(self) -> str:
        """
        Optional. String indicating the location of the expression for error reporting, e.g. a file name and a position in the file.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def title(self) -> str:
        """
        Optional. Title for the expression, i.e. a short string describing its purpose. This can be used e.g. in UIs which allow to enter the expression.
        """
        return pulumi.get(self, "title")


@pulumi.output_type
class FeedOutputConfigResponse(dict):
    """
    Output configuration for asset feed destination.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "pubsubDestination":
            suggest = "pubsub_destination"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FeedOutputConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FeedOutputConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FeedOutputConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 pubsub_destination: 'outputs.PubsubDestinationResponse'):
        """
        Output configuration for asset feed destination.
        :param 'PubsubDestinationResponse' pubsub_destination: Destination on Pub/Sub.
        """
        pulumi.set(__self__, "pubsub_destination", pubsub_destination)

    @property
    @pulumi.getter(name="pubsubDestination")
    def pubsub_destination(self) -> 'outputs.PubsubDestinationResponse':
        """
        Destination on Pub/Sub.
        """
        return pulumi.get(self, "pubsub_destination")


@pulumi.output_type
class IamPolicyAnalysisQueryResponse(dict):
    """
    IAM policy analysis query message.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessSelector":
            suggest = "access_selector"
        elif key == "conditionContext":
            suggest = "condition_context"
        elif key == "identitySelector":
            suggest = "identity_selector"
        elif key == "resourceSelector":
            suggest = "resource_selector"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IamPolicyAnalysisQueryResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IamPolicyAnalysisQueryResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IamPolicyAnalysisQueryResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_selector: 'outputs.AccessSelectorResponse',
                 condition_context: 'outputs.ConditionContextResponse',
                 identity_selector: 'outputs.IdentitySelectorResponse',
                 options: 'outputs.OptionsResponse',
                 resource_selector: 'outputs.ResourceSelectorResponse',
                 scope: str):
        """
        IAM policy analysis query message.
        :param 'AccessSelectorResponse' access_selector: Optional. Specifies roles or permissions for analysis. This is optional.
        :param 'ConditionContextResponse' condition_context: Optional. The hypothetical context for IAM conditions evaluation.
        :param 'IdentitySelectorResponse' identity_selector: Optional. Specifies an identity for analysis.
        :param 'OptionsResponse' options: Optional. The query options.
        :param 'ResourceSelectorResponse' resource_selector: Optional. Specifies a resource for analysis.
        :param str scope: The relative name of the root asset. Only resources and IAM policies within the scope will be analyzed. This can only be an organization number (such as "organizations/123"), a folder number (such as "folders/123"), a project ID (such as "projects/my-project-id"), or a project number (such as "projects/12345"). To know how to get organization id, visit [here ](https://cloud.google.com/resource-manager/docs/creating-managing-organization#retrieving_your_organization_id). To know how to get folder or project id, visit [here ](https://cloud.google.com/resource-manager/docs/creating-managing-folders#viewing_or_listing_folders_and_projects).
        """
        pulumi.set(__self__, "access_selector", access_selector)
        pulumi.set(__self__, "condition_context", condition_context)
        pulumi.set(__self__, "identity_selector", identity_selector)
        pulumi.set(__self__, "options", options)
        pulumi.set(__self__, "resource_selector", resource_selector)
        pulumi.set(__self__, "scope", scope)

    @property
    @pulumi.getter(name="accessSelector")
    def access_selector(self) -> 'outputs.AccessSelectorResponse':
        """
        Optional. Specifies roles or permissions for analysis. This is optional.
        """
        return pulumi.get(self, "access_selector")

    @property
    @pulumi.getter(name="conditionContext")
    def condition_context(self) -> 'outputs.ConditionContextResponse':
        """
        Optional. The hypothetical context for IAM conditions evaluation.
        """
        return pulumi.get(self, "condition_context")

    @property
    @pulumi.getter(name="identitySelector")
    def identity_selector(self) -> 'outputs.IdentitySelectorResponse':
        """
        Optional. Specifies an identity for analysis.
        """
        return pulumi.get(self, "identity_selector")

    @property
    @pulumi.getter
    def options(self) -> 'outputs.OptionsResponse':
        """
        Optional. The query options.
        """
        return pulumi.get(self, "options")

    @property
    @pulumi.getter(name="resourceSelector")
    def resource_selector(self) -> 'outputs.ResourceSelectorResponse':
        """
        Optional. Specifies a resource for analysis.
        """
        return pulumi.get(self, "resource_selector")

    @property
    @pulumi.getter
    def scope(self) -> str:
        """
        The relative name of the root asset. Only resources and IAM policies within the scope will be analyzed. This can only be an organization number (such as "organizations/123"), a folder number (such as "folders/123"), a project ID (such as "projects/my-project-id"), or a project number (such as "projects/12345"). To know how to get organization id, visit [here ](https://cloud.google.com/resource-manager/docs/creating-managing-organization#retrieving_your_organization_id). To know how to get folder or project id, visit [here ](https://cloud.google.com/resource-manager/docs/creating-managing-folders#viewing_or_listing_folders_and_projects).
        """
        return pulumi.get(self, "scope")


@pulumi.output_type
class IdentitySelectorResponse(dict):
    """
    Specifies an identity for which to determine resource access, based on roles assigned either directly to them or to the groups they belong to, directly or indirectly.
    """
    def __init__(__self__, *,
                 identity: str):
        """
        Specifies an identity for which to determine resource access, based on roles assigned either directly to them or to the groups they belong to, directly or indirectly.
        :param str identity: The identity appear in the form of principals in [IAM policy binding](https://cloud.google.com/iam/reference/rest/v1/Binding). The examples of supported forms are: "user:mike@example.com", "group:admins@example.com", "domain:google.com", "serviceAccount:my-project-id@appspot.gserviceaccount.com". Notice that wildcard characters (such as * and ?) are not supported. You must give a specific identity.
        """
        pulumi.set(__self__, "identity", identity)

    @property
    @pulumi.getter
    def identity(self) -> str:
        """
        The identity appear in the form of principals in [IAM policy binding](https://cloud.google.com/iam/reference/rest/v1/Binding). The examples of supported forms are: "user:mike@example.com", "group:admins@example.com", "domain:google.com", "serviceAccount:my-project-id@appspot.gserviceaccount.com". Notice that wildcard characters (such as * and ?) are not supported. You must give a specific identity.
        """
        return pulumi.get(self, "identity")


@pulumi.output_type
class OptionsResponse(dict):
    """
    Contains query options.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "analyzeServiceAccountImpersonation":
            suggest = "analyze_service_account_impersonation"
        elif key == "expandGroups":
            suggest = "expand_groups"
        elif key == "expandResources":
            suggest = "expand_resources"
        elif key == "expandRoles":
            suggest = "expand_roles"
        elif key == "outputGroupEdges":
            suggest = "output_group_edges"
        elif key == "outputResourceEdges":
            suggest = "output_resource_edges"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OptionsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OptionsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OptionsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 analyze_service_account_impersonation: bool,
                 expand_groups: bool,
                 expand_resources: bool,
                 expand_roles: bool,
                 output_group_edges: bool,
                 output_resource_edges: bool):
        """
        Contains query options.
        :param bool analyze_service_account_impersonation: Optional. If true, the response will include access analysis from identities to resources via service account impersonation. This is a very expensive operation, because many derived queries will be executed. We highly recommend you use AssetService.AnalyzeIamPolicyLongrunning rpc instead. For example, if the request analyzes for which resources user A has permission P, and there's an IAM policy states user A has iam.serviceAccounts.getAccessToken permission to a service account SA, and there's another IAM policy states service account SA has permission P to a GCP folder F, then user A potentially has access to the GCP folder F. And those advanced analysis results will be included in AnalyzeIamPolicyResponse.service_account_impersonation_analysis. Another example, if the request analyzes for who has permission P to a GCP folder F, and there's an IAM policy states user A has iam.serviceAccounts.actAs permission to a service account SA, and there's another IAM policy states service account SA has permission P to the GCP folder F, then user A potentially has access to the GCP folder F. And those advanced analysis results will be included in AnalyzeIamPolicyResponse.service_account_impersonation_analysis. Default is false.
        :param bool expand_groups: Optional. If true, the identities section of the result will expand any Google groups appearing in an IAM policy binding. If IamPolicyAnalysisQuery.identity_selector is specified, the identity in the result will be determined by the selector, and this flag is not allowed to set. Default is false.
        :param bool expand_resources: Optional. If true and IamPolicyAnalysisQuery.resource_selector is not specified, the resource section of the result will expand any resource attached to an IAM policy to include resources lower in the resource hierarchy. For example, if the request analyzes for which resources user A has permission P, and the results include an IAM policy with P on a GCP folder, the results will also include resources in that folder with permission P. If true and IamPolicyAnalysisQuery.resource_selector is specified, the resource section of the result will expand the specified resource to include resources lower in the resource hierarchy. Only project or lower resources are supported. Folder and organization resource cannot be used together with this option. For example, if the request analyzes for which users have permission P on a GCP project with this option enabled, the results will include all users who have permission P on that project or any lower resource. Default is false.
        :param bool expand_roles: Optional. If true, the access section of result will expand any roles appearing in IAM policy bindings to include their permissions. If IamPolicyAnalysisQuery.access_selector is specified, the access section of the result will be determined by the selector, and this flag is not allowed to set. Default is false.
        :param bool output_group_edges: Optional. If true, the result will output the relevant membership relationships between groups and other groups, and between groups and principals. Default is false.
        :param bool output_resource_edges: Optional. If true, the result will output the relevant parent/child relationships between resources. Default is false.
        """
        pulumi.set(__self__, "analyze_service_account_impersonation", analyze_service_account_impersonation)
        pulumi.set(__self__, "expand_groups", expand_groups)
        pulumi.set(__self__, "expand_resources", expand_resources)
        pulumi.set(__self__, "expand_roles", expand_roles)
        pulumi.set(__self__, "output_group_edges", output_group_edges)
        pulumi.set(__self__, "output_resource_edges", output_resource_edges)

    @property
    @pulumi.getter(name="analyzeServiceAccountImpersonation")
    def analyze_service_account_impersonation(self) -> bool:
        """
        Optional. If true, the response will include access analysis from identities to resources via service account impersonation. This is a very expensive operation, because many derived queries will be executed. We highly recommend you use AssetService.AnalyzeIamPolicyLongrunning rpc instead. For example, if the request analyzes for which resources user A has permission P, and there's an IAM policy states user A has iam.serviceAccounts.getAccessToken permission to a service account SA, and there's another IAM policy states service account SA has permission P to a GCP folder F, then user A potentially has access to the GCP folder F. And those advanced analysis results will be included in AnalyzeIamPolicyResponse.service_account_impersonation_analysis. Another example, if the request analyzes for who has permission P to a GCP folder F, and there's an IAM policy states user A has iam.serviceAccounts.actAs permission to a service account SA, and there's another IAM policy states service account SA has permission P to the GCP folder F, then user A potentially has access to the GCP folder F. And those advanced analysis results will be included in AnalyzeIamPolicyResponse.service_account_impersonation_analysis. Default is false.
        """
        return pulumi.get(self, "analyze_service_account_impersonation")

    @property
    @pulumi.getter(name="expandGroups")
    def expand_groups(self) -> bool:
        """
        Optional. If true, the identities section of the result will expand any Google groups appearing in an IAM policy binding. If IamPolicyAnalysisQuery.identity_selector is specified, the identity in the result will be determined by the selector, and this flag is not allowed to set. Default is false.
        """
        return pulumi.get(self, "expand_groups")

    @property
    @pulumi.getter(name="expandResources")
    def expand_resources(self) -> bool:
        """
        Optional. If true and IamPolicyAnalysisQuery.resource_selector is not specified, the resource section of the result will expand any resource attached to an IAM policy to include resources lower in the resource hierarchy. For example, if the request analyzes for which resources user A has permission P, and the results include an IAM policy with P on a GCP folder, the results will also include resources in that folder with permission P. If true and IamPolicyAnalysisQuery.resource_selector is specified, the resource section of the result will expand the specified resource to include resources lower in the resource hierarchy. Only project or lower resources are supported. Folder and organization resource cannot be used together with this option. For example, if the request analyzes for which users have permission P on a GCP project with this option enabled, the results will include all users who have permission P on that project or any lower resource. Default is false.
        """
        return pulumi.get(self, "expand_resources")

    @property
    @pulumi.getter(name="expandRoles")
    def expand_roles(self) -> bool:
        """
        Optional. If true, the access section of result will expand any roles appearing in IAM policy bindings to include their permissions. If IamPolicyAnalysisQuery.access_selector is specified, the access section of the result will be determined by the selector, and this flag is not allowed to set. Default is false.
        """
        return pulumi.get(self, "expand_roles")

    @property
    @pulumi.getter(name="outputGroupEdges")
    def output_group_edges(self) -> bool:
        """
        Optional. If true, the result will output the relevant membership relationships between groups and other groups, and between groups and principals. Default is false.
        """
        return pulumi.get(self, "output_group_edges")

    @property
    @pulumi.getter(name="outputResourceEdges")
    def output_resource_edges(self) -> bool:
        """
        Optional. If true, the result will output the relevant parent/child relationships between resources. Default is false.
        """
        return pulumi.get(self, "output_resource_edges")


@pulumi.output_type
class PubsubDestinationResponse(dict):
    """
    A Pub/Sub destination.
    """
    def __init__(__self__, *,
                 topic: str):
        """
        A Pub/Sub destination.
        :param str topic: The name of the Pub/Sub topic to publish to. Example: `projects/PROJECT_ID/topics/TOPIC_ID`.
        """
        pulumi.set(__self__, "topic", topic)

    @property
    @pulumi.getter
    def topic(self) -> str:
        """
        The name of the Pub/Sub topic to publish to. Example: `projects/PROJECT_ID/topics/TOPIC_ID`.
        """
        return pulumi.get(self, "topic")


@pulumi.output_type
class QueryContentResponse(dict):
    """
    The query content.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "iamPolicyAnalysisQuery":
            suggest = "iam_policy_analysis_query"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in QueryContentResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        QueryContentResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        QueryContentResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 iam_policy_analysis_query: 'outputs.IamPolicyAnalysisQueryResponse'):
        """
        The query content.
        :param 'IamPolicyAnalysisQueryResponse' iam_policy_analysis_query: An IAM Policy Analysis query, which could be used in the AssetService.AnalyzeIamPolicy rpc or the AssetService.AnalyzeIamPolicyLongrunning rpc.
        """
        pulumi.set(__self__, "iam_policy_analysis_query", iam_policy_analysis_query)

    @property
    @pulumi.getter(name="iamPolicyAnalysisQuery")
    def iam_policy_analysis_query(self) -> 'outputs.IamPolicyAnalysisQueryResponse':
        """
        An IAM Policy Analysis query, which could be used in the AssetService.AnalyzeIamPolicy rpc or the AssetService.AnalyzeIamPolicyLongrunning rpc.
        """
        return pulumi.get(self, "iam_policy_analysis_query")


@pulumi.output_type
class ResourceSelectorResponse(dict):
    """
    Specifies the resource to analyze for access policies, which may be set directly on the resource, or on ancestors such as organizations, folders or projects.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fullResourceName":
            suggest = "full_resource_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResourceSelectorResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResourceSelectorResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResourceSelectorResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 full_resource_name: str):
        """
        Specifies the resource to analyze for access policies, which may be set directly on the resource, or on ancestors such as organizations, folders or projects.
        :param str full_resource_name: The [full resource name] (https://cloud.google.com/asset-inventory/docs/resource-name-format) of a resource of [supported resource types](https://cloud.google.com/asset-inventory/docs/supported-asset-types#analyzable_asset_types).
        """
        pulumi.set(__self__, "full_resource_name", full_resource_name)

    @property
    @pulumi.getter(name="fullResourceName")
    def full_resource_name(self) -> str:
        """
        The [full resource name] (https://cloud.google.com/asset-inventory/docs/resource-name-format) of a resource of [supported resource types](https://cloud.google.com/asset-inventory/docs/supported-asset-types#analyzable_asset_types).
        """
        return pulumi.get(self, "full_resource_name")


