# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'GoogleCloudApigeeV1AddonsConfigResponse',
    'GoogleCloudApigeeV1AdvancedApiOpsConfigResponse',
    'GoogleCloudApigeeV1ApiCategoryDataResponse',
    'GoogleCloudApigeeV1ApiProductRefResponse',
    'GoogleCloudApigeeV1AsyncQueryResultResponse',
    'GoogleCloudApigeeV1AttributeResponse',
    'GoogleCloudApigeeV1CanaryEvaluationMetricLabelsResponse',
    'GoogleCloudApigeeV1CertInfoResponse',
    'GoogleCloudApigeeV1CertificateResponse',
    'GoogleCloudApigeeV1ConnectorsPlatformConfigResponse',
    'GoogleCloudApigeeV1CredentialResponse',
    'GoogleCloudApigeeV1CustomReportMetricResponse',
    'GoogleCloudApigeeV1DatastoreConfigResponse',
    'GoogleCloudApigeeV1EntityMetadataResponse',
    'GoogleCloudApigeeV1GraphQLOperationConfigResponse',
    'GoogleCloudApigeeV1GraphQLOperationGroupResponse',
    'GoogleCloudApigeeV1GraphQLOperationResponse',
    'GoogleCloudApigeeV1IntegrationConfigResponse',
    'GoogleCloudApigeeV1MonetizationConfigResponse',
    'GoogleCloudApigeeV1OperationConfigResponse',
    'GoogleCloudApigeeV1OperationGroupResponse',
    'GoogleCloudApigeeV1OperationResponse',
    'GoogleCloudApigeeV1PropertiesResponse',
    'GoogleCloudApigeeV1PropertyResponse',
    'GoogleCloudApigeeV1QueryMetadataResponse',
    'GoogleCloudApigeeV1QuotaResponse',
    'GoogleCloudApigeeV1RateRangeResponse',
    'GoogleCloudApigeeV1ReportPropertyResponse',
    'GoogleCloudApigeeV1RevenueShareRangeResponse',
    'GoogleCloudApigeeV1TlsInfoCommonNameResponse',
    'GoogleCloudApigeeV1TlsInfoResponse',
    'GoogleCloudApigeeV1TraceSamplingConfigResponse',
    'GoogleIamV1AuditConfigResponse',
    'GoogleIamV1AuditLogConfigResponse',
    'GoogleIamV1BindingResponse',
    'GoogleTypeExprResponse',
    'GoogleTypeMoneyResponse',
]

@pulumi.output_type
class GoogleCloudApigeeV1AddonsConfigResponse(dict):
    """
    Add-on configurations for the Apigee organization.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "advancedApiOpsConfig":
            suggest = "advanced_api_ops_config"
        elif key == "connectorsPlatformConfig":
            suggest = "connectors_platform_config"
        elif key == "integrationConfig":
            suggest = "integration_config"
        elif key == "monetizationConfig":
            suggest = "monetization_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudApigeeV1AddonsConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudApigeeV1AddonsConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudApigeeV1AddonsConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 advanced_api_ops_config: 'outputs.GoogleCloudApigeeV1AdvancedApiOpsConfigResponse',
                 connectors_platform_config: 'outputs.GoogleCloudApigeeV1ConnectorsPlatformConfigResponse',
                 integration_config: 'outputs.GoogleCloudApigeeV1IntegrationConfigResponse',
                 monetization_config: 'outputs.GoogleCloudApigeeV1MonetizationConfigResponse'):
        """
        Add-on configurations for the Apigee organization.
        :param 'GoogleCloudApigeeV1AdvancedApiOpsConfigResponse' advanced_api_ops_config: Configuration for the Advanced API Ops add-on.
        :param 'GoogleCloudApigeeV1ConnectorsPlatformConfigResponse' connectors_platform_config: Configuration for the Connectors Platform add-on.
        :param 'GoogleCloudApigeeV1IntegrationConfigResponse' integration_config: Configuration for the Integration add-on.
        :param 'GoogleCloudApigeeV1MonetizationConfigResponse' monetization_config: Configuration for the Monetization add-on.
        """
        pulumi.set(__self__, "advanced_api_ops_config", advanced_api_ops_config)
        pulumi.set(__self__, "connectors_platform_config", connectors_platform_config)
        pulumi.set(__self__, "integration_config", integration_config)
        pulumi.set(__self__, "monetization_config", monetization_config)

    @property
    @pulumi.getter(name="advancedApiOpsConfig")
    def advanced_api_ops_config(self) -> 'outputs.GoogleCloudApigeeV1AdvancedApiOpsConfigResponse':
        """
        Configuration for the Advanced API Ops add-on.
        """
        return pulumi.get(self, "advanced_api_ops_config")

    @property
    @pulumi.getter(name="connectorsPlatformConfig")
    def connectors_platform_config(self) -> 'outputs.GoogleCloudApigeeV1ConnectorsPlatformConfigResponse':
        """
        Configuration for the Connectors Platform add-on.
        """
        return pulumi.get(self, "connectors_platform_config")

    @property
    @pulumi.getter(name="integrationConfig")
    def integration_config(self) -> 'outputs.GoogleCloudApigeeV1IntegrationConfigResponse':
        """
        Configuration for the Integration add-on.
        """
        return pulumi.get(self, "integration_config")

    @property
    @pulumi.getter(name="monetizationConfig")
    def monetization_config(self) -> 'outputs.GoogleCloudApigeeV1MonetizationConfigResponse':
        """
        Configuration for the Monetization add-on.
        """
        return pulumi.get(self, "monetization_config")


@pulumi.output_type
class GoogleCloudApigeeV1AdvancedApiOpsConfigResponse(dict):
    """
    Configuration for the Advanced API Ops add-on.
    """
    def __init__(__self__, *,
                 enabled: bool):
        """
        Configuration for the Advanced API Ops add-on.
        :param bool enabled: Flag that specifies whether the Advanced API Ops add-on is enabled.
        """
        pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        Flag that specifies whether the Advanced API Ops add-on is enabled.
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class GoogleCloudApigeeV1ApiCategoryDataResponse(dict):
    """
    the Api category resource.
    """
    def __init__(__self__, *,
                 name: str,
                 site_id: str,
                 update_time: str):
        """
        the Api category resource.
        :param str name: Name of the category.
        :param str site_id: Name of the portal.
        :param str update_time: Time the category was last modified in milliseconds since epoch.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "site_id", site_id)
        pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the category.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="siteId")
    def site_id(self) -> str:
        """
        Name of the portal.
        """
        return pulumi.get(self, "site_id")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> str:
        """
        Time the category was last modified in milliseconds since epoch.
        """
        return pulumi.get(self, "update_time")


@pulumi.output_type
class GoogleCloudApigeeV1ApiProductRefResponse(dict):
    def __init__(__self__, *,
                 apiproduct: str,
                 status: str):
        """
        :param str apiproduct: Name of the API product.
        :param str status: Status of the API product. Valid values are `approved` or `revoked`.
        """
        pulumi.set(__self__, "apiproduct", apiproduct)
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def apiproduct(self) -> str:
        """
        Name of the API product.
        """
        return pulumi.get(self, "apiproduct")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Status of the API product. Valid values are `approved` or `revoked`.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GoogleCloudApigeeV1AsyncQueryResultResponse(dict):
    def __init__(__self__, *,
                 expires: str,
                 self: str):
        """
        :param str expires: Query result will be unaccessable after this time.
        :param str self: Self link of the query results. Example: `/organizations/myorg/environments/myenv/queries/9cfc0d85-0f30-46d6-ae6f-318d0cb961bd/result` or following format if query is running at host level: `/organizations/myorg/hostQueries/9cfc0d85-0f30-46d6-ae6f-318d0cb961bd/result`
        """
        pulumi.set(__self__, "expires", expires)
        pulumi.set(__self__, "self", self)

    @property
    @pulumi.getter
    def expires(self) -> str:
        """
        Query result will be unaccessable after this time.
        """
        return pulumi.get(self, "expires")

    @property
    @pulumi.getter
    def self(self) -> str:
        """
        Self link of the query results. Example: `/organizations/myorg/environments/myenv/queries/9cfc0d85-0f30-46d6-ae6f-318d0cb961bd/result` or following format if query is running at host level: `/organizations/myorg/hostQueries/9cfc0d85-0f30-46d6-ae6f-318d0cb961bd/result`
        """
        return pulumi.get(self, "self")


@pulumi.output_type
class GoogleCloudApigeeV1AttributeResponse(dict):
    """
    Key-value pair to store extra metadata.
    """
    def __init__(__self__, *,
                 name: str,
                 value: str):
        """
        Key-value pair to store extra metadata.
        :param str name: API key of the attribute.
        :param str value: Value of the attribute.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        API key of the attribute.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        Value of the attribute.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GoogleCloudApigeeV1CanaryEvaluationMetricLabelsResponse(dict):
    """
    Labels that can be used to filter Apigee metrics.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "instanceId":
            suggest = "instance_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudApigeeV1CanaryEvaluationMetricLabelsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudApigeeV1CanaryEvaluationMetricLabelsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudApigeeV1CanaryEvaluationMetricLabelsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 env: str,
                 instance_id: str,
                 location: str):
        """
        Labels that can be used to filter Apigee metrics.
        :param str env: The environment ID associated with the metrics.
        :param str instance_id: The instance ID associated with the metrics. In Apigee Hybrid, the value is configured during installation.
        :param str location: The location associated with the metrics.
        """
        pulumi.set(__self__, "env", env)
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "location", location)

    @property
    @pulumi.getter
    def env(self) -> str:
        """
        The environment ID associated with the metrics.
        """
        return pulumi.get(self, "env")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> str:
        """
        The instance ID associated with the metrics. In Apigee Hybrid, the value is configured during installation.
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter
    def location(self) -> str:
        """
        The location associated with the metrics.
        """
        return pulumi.get(self, "location")


@pulumi.output_type
class GoogleCloudApigeeV1CertInfoResponse(dict):
    """
    X.509 certificate as defined in RFC 5280.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "basicConstraints":
            suggest = "basic_constraints"
        elif key == "expiryDate":
            suggest = "expiry_date"
        elif key == "isValid":
            suggest = "is_valid"
        elif key == "publicKey":
            suggest = "public_key"
        elif key == "serialNumber":
            suggest = "serial_number"
        elif key == "sigAlgName":
            suggest = "sig_alg_name"
        elif key == "subjectAlternativeNames":
            suggest = "subject_alternative_names"
        elif key == "validFrom":
            suggest = "valid_from"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudApigeeV1CertInfoResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudApigeeV1CertInfoResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudApigeeV1CertInfoResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 basic_constraints: str,
                 expiry_date: str,
                 is_valid: str,
                 issuer: str,
                 public_key: str,
                 serial_number: str,
                 sig_alg_name: str,
                 subject: str,
                 subject_alternative_names: Sequence[str],
                 valid_from: str,
                 version: int):
        """
        X.509 certificate as defined in RFC 5280.
        :param str basic_constraints: X.509 basic constraints extension.
        :param str expiry_date: X.509 `notAfter` validity period in milliseconds since epoch.
        :param str is_valid: Flag that specifies whether the certificate is valid. Flag is set to `Yes` if the certificate is valid, `No` if expired, or `Not yet` if not yet valid.
        :param str issuer: X.509 issuer.
        :param str public_key: Public key component of the X.509 subject public key info.
        :param str serial_number: X.509 serial number.
        :param str sig_alg_name: X.509 signatureAlgorithm.
        :param str subject: X.509 subject.
        :param Sequence[str] subject_alternative_names: X.509 subject alternative names (SANs) extension.
        :param str valid_from: X.509 `notBefore` validity period in milliseconds since epoch.
        :param int version: X.509 version.
        """
        pulumi.set(__self__, "basic_constraints", basic_constraints)
        pulumi.set(__self__, "expiry_date", expiry_date)
        pulumi.set(__self__, "is_valid", is_valid)
        pulumi.set(__self__, "issuer", issuer)
        pulumi.set(__self__, "public_key", public_key)
        pulumi.set(__self__, "serial_number", serial_number)
        pulumi.set(__self__, "sig_alg_name", sig_alg_name)
        pulumi.set(__self__, "subject", subject)
        pulumi.set(__self__, "subject_alternative_names", subject_alternative_names)
        pulumi.set(__self__, "valid_from", valid_from)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="basicConstraints")
    def basic_constraints(self) -> str:
        """
        X.509 basic constraints extension.
        """
        return pulumi.get(self, "basic_constraints")

    @property
    @pulumi.getter(name="expiryDate")
    def expiry_date(self) -> str:
        """
        X.509 `notAfter` validity period in milliseconds since epoch.
        """
        return pulumi.get(self, "expiry_date")

    @property
    @pulumi.getter(name="isValid")
    def is_valid(self) -> str:
        """
        Flag that specifies whether the certificate is valid. Flag is set to `Yes` if the certificate is valid, `No` if expired, or `Not yet` if not yet valid.
        """
        return pulumi.get(self, "is_valid")

    @property
    @pulumi.getter
    def issuer(self) -> str:
        """
        X.509 issuer.
        """
        return pulumi.get(self, "issuer")

    @property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> str:
        """
        Public key component of the X.509 subject public key info.
        """
        return pulumi.get(self, "public_key")

    @property
    @pulumi.getter(name="serialNumber")
    def serial_number(self) -> str:
        """
        X.509 serial number.
        """
        return pulumi.get(self, "serial_number")

    @property
    @pulumi.getter(name="sigAlgName")
    def sig_alg_name(self) -> str:
        """
        X.509 signatureAlgorithm.
        """
        return pulumi.get(self, "sig_alg_name")

    @property
    @pulumi.getter
    def subject(self) -> str:
        """
        X.509 subject.
        """
        return pulumi.get(self, "subject")

    @property
    @pulumi.getter(name="subjectAlternativeNames")
    def subject_alternative_names(self) -> Sequence[str]:
        """
        X.509 subject alternative names (SANs) extension.
        """
        return pulumi.get(self, "subject_alternative_names")

    @property
    @pulumi.getter(name="validFrom")
    def valid_from(self) -> str:
        """
        X.509 `notBefore` validity period in milliseconds since epoch.
        """
        return pulumi.get(self, "valid_from")

    @property
    @pulumi.getter
    def version(self) -> int:
        """
        X.509 version.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class GoogleCloudApigeeV1CertificateResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "certInfo":
            suggest = "cert_info"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudApigeeV1CertificateResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudApigeeV1CertificateResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudApigeeV1CertificateResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cert_info: Sequence['outputs.GoogleCloudApigeeV1CertInfoResponse']):
        """
        :param Sequence['GoogleCloudApigeeV1CertInfoResponse'] cert_info: Chain of certificates under this name.
        """
        pulumi.set(__self__, "cert_info", cert_info)

    @property
    @pulumi.getter(name="certInfo")
    def cert_info(self) -> Sequence['outputs.GoogleCloudApigeeV1CertInfoResponse']:
        """
        Chain of certificates under this name.
        """
        return pulumi.get(self, "cert_info")


@pulumi.output_type
class GoogleCloudApigeeV1ConnectorsPlatformConfigResponse(dict):
    """
    Configuration for the Connectors Platform add-on.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "expiresAt":
            suggest = "expires_at"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudApigeeV1ConnectorsPlatformConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudApigeeV1ConnectorsPlatformConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudApigeeV1ConnectorsPlatformConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: bool,
                 expires_at: str):
        """
        Configuration for the Connectors Platform add-on.
        :param bool enabled: Flag that specifies whether the Connectors Platform add-on is enabled.
        :param str expires_at: Time at which the Connectors Platform add-on expires in milliseconds since epoch. If unspecified, the add-on will never expire.
        """
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "expires_at", expires_at)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        Flag that specifies whether the Connectors Platform add-on is enabled.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="expiresAt")
    def expires_at(self) -> str:
        """
        Time at which the Connectors Platform add-on expires in milliseconds since epoch. If unspecified, the add-on will never expire.
        """
        return pulumi.get(self, "expires_at")


@pulumi.output_type
class GoogleCloudApigeeV1CredentialResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiProducts":
            suggest = "api_products"
        elif key == "consumerKey":
            suggest = "consumer_key"
        elif key == "consumerSecret":
            suggest = "consumer_secret"
        elif key == "expiresAt":
            suggest = "expires_at"
        elif key == "issuedAt":
            suggest = "issued_at"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudApigeeV1CredentialResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudApigeeV1CredentialResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudApigeeV1CredentialResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 api_products: Sequence['outputs.GoogleCloudApigeeV1ApiProductRefResponse'],
                 attributes: Sequence['outputs.GoogleCloudApigeeV1AttributeResponse'],
                 consumer_key: str,
                 consumer_secret: str,
                 expires_at: str,
                 issued_at: str,
                 scopes: Sequence[str],
                 status: str):
        """
        :param Sequence['GoogleCloudApigeeV1ApiProductRefResponse'] api_products: List of API products this credential can be used for.
        :param Sequence['GoogleCloudApigeeV1AttributeResponse'] attributes: List of attributes associated with this credential.
        :param str consumer_key: Consumer key.
        :param str consumer_secret: Secret key.
        :param str expires_at: Time the credential will expire in milliseconds since epoch.
        :param str issued_at: Time the credential was issued in milliseconds since epoch.
        :param Sequence[str] scopes: List of scopes to apply to the app. Specified scopes must already exist on the API product that you associate with the app.
        :param str status: Status of the credential. Valid values include `approved` or `revoked`.
        """
        pulumi.set(__self__, "api_products", api_products)
        pulumi.set(__self__, "attributes", attributes)
        pulumi.set(__self__, "consumer_key", consumer_key)
        pulumi.set(__self__, "consumer_secret", consumer_secret)
        pulumi.set(__self__, "expires_at", expires_at)
        pulumi.set(__self__, "issued_at", issued_at)
        pulumi.set(__self__, "scopes", scopes)
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="apiProducts")
    def api_products(self) -> Sequence['outputs.GoogleCloudApigeeV1ApiProductRefResponse']:
        """
        List of API products this credential can be used for.
        """
        return pulumi.get(self, "api_products")

    @property
    @pulumi.getter
    def attributes(self) -> Sequence['outputs.GoogleCloudApigeeV1AttributeResponse']:
        """
        List of attributes associated with this credential.
        """
        return pulumi.get(self, "attributes")

    @property
    @pulumi.getter(name="consumerKey")
    def consumer_key(self) -> str:
        """
        Consumer key.
        """
        return pulumi.get(self, "consumer_key")

    @property
    @pulumi.getter(name="consumerSecret")
    def consumer_secret(self) -> str:
        """
        Secret key.
        """
        return pulumi.get(self, "consumer_secret")

    @property
    @pulumi.getter(name="expiresAt")
    def expires_at(self) -> str:
        """
        Time the credential will expire in milliseconds since epoch.
        """
        return pulumi.get(self, "expires_at")

    @property
    @pulumi.getter(name="issuedAt")
    def issued_at(self) -> str:
        """
        Time the credential was issued in milliseconds since epoch.
        """
        return pulumi.get(self, "issued_at")

    @property
    @pulumi.getter
    def scopes(self) -> Sequence[str]:
        """
        List of scopes to apply to the app. Specified scopes must already exist on the API product that you associate with the app.
        """
        return pulumi.get(self, "scopes")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Status of the credential. Valid values include `approved` or `revoked`.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GoogleCloudApigeeV1CustomReportMetricResponse(dict):
    """
    This encapsulates a metric property of the form sum(message_count) where name is message_count and function is sum
    """
    def __init__(__self__, *,
                 function: str,
                 name: str):
        """
        This encapsulates a metric property of the form sum(message_count) where name is message_count and function is sum
        :param str function: aggregate function
        :param str name: name of the metric
        """
        pulumi.set(__self__, "function", function)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def function(self) -> str:
        """
        aggregate function
        """
        return pulumi.get(self, "function")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        name of the metric
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GoogleCloudApigeeV1DatastoreConfigResponse(dict):
    """
    Configuration detail for datastore
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bucketName":
            suggest = "bucket_name"
        elif key == "datasetName":
            suggest = "dataset_name"
        elif key == "tablePrefix":
            suggest = "table_prefix"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudApigeeV1DatastoreConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudApigeeV1DatastoreConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudApigeeV1DatastoreConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket_name: str,
                 dataset_name: str,
                 path: str,
                 project: str,
                 table_prefix: str):
        """
        Configuration detail for datastore
        :param str bucket_name: Name of the Cloud Storage bucket. Required for `gcs` target_type.
        :param str dataset_name: BigQuery dataset name Required for `bigquery` target_type.
        :param str path: Path of Cloud Storage bucket Required for `gcs` target_type.
        :param str project: GCP project in which the datastore exists
        :param str table_prefix: Prefix of BigQuery table Required for `bigquery` target_type.
        """
        pulumi.set(__self__, "bucket_name", bucket_name)
        pulumi.set(__self__, "dataset_name", dataset_name)
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "project", project)
        pulumi.set(__self__, "table_prefix", table_prefix)

    @property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> str:
        """
        Name of the Cloud Storage bucket. Required for `gcs` target_type.
        """
        return pulumi.get(self, "bucket_name")

    @property
    @pulumi.getter(name="datasetName")
    def dataset_name(self) -> str:
        """
        BigQuery dataset name Required for `bigquery` target_type.
        """
        return pulumi.get(self, "dataset_name")

    @property
    @pulumi.getter
    def path(self) -> str:
        """
        Path of Cloud Storage bucket Required for `gcs` target_type.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def project(self) -> str:
        """
        GCP project in which the datastore exists
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="tablePrefix")
    def table_prefix(self) -> str:
        """
        Prefix of BigQuery table Required for `bigquery` target_type.
        """
        return pulumi.get(self, "table_prefix")


@pulumi.output_type
class GoogleCloudApigeeV1EntityMetadataResponse(dict):
    """
    Metadata common to many entities in this API.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createdAt":
            suggest = "created_at"
        elif key == "lastModifiedAt":
            suggest = "last_modified_at"
        elif key == "subType":
            suggest = "sub_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudApigeeV1EntityMetadataResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudApigeeV1EntityMetadataResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudApigeeV1EntityMetadataResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 created_at: str,
                 last_modified_at: str,
                 sub_type: str):
        """
        Metadata common to many entities in this API.
        :param str created_at: Time at which the API proxy was created, in milliseconds since epoch.
        :param str last_modified_at: Time at which the API proxy was most recently modified, in milliseconds since epoch.
        :param str sub_type: The type of entity described
        """
        pulumi.set(__self__, "created_at", created_at)
        pulumi.set(__self__, "last_modified_at", last_modified_at)
        pulumi.set(__self__, "sub_type", sub_type)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> str:
        """
        Time at which the API proxy was created, in milliseconds since epoch.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="lastModifiedAt")
    def last_modified_at(self) -> str:
        """
        Time at which the API proxy was most recently modified, in milliseconds since epoch.
        """
        return pulumi.get(self, "last_modified_at")

    @property
    @pulumi.getter(name="subType")
    def sub_type(self) -> str:
        """
        The type of entity described
        """
        return pulumi.get(self, "sub_type")


@pulumi.output_type
class GoogleCloudApigeeV1GraphQLOperationConfigResponse(dict):
    """
    Binds the resources in a proxy or remote service with the GraphQL operation and its associated quota enforcement.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiSource":
            suggest = "api_source"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudApigeeV1GraphQLOperationConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudApigeeV1GraphQLOperationConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudApigeeV1GraphQLOperationConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 api_source: str,
                 attributes: Sequence['outputs.GoogleCloudApigeeV1AttributeResponse'],
                 operations: Sequence['outputs.GoogleCloudApigeeV1GraphQLOperationResponse'],
                 quota: 'outputs.GoogleCloudApigeeV1QuotaResponse'):
        """
        Binds the resources in a proxy or remote service with the GraphQL operation and its associated quota enforcement.
        :param str api_source: Name of the API proxy endpoint or remote service with which the GraphQL operation and quota are associated.
        :param Sequence['GoogleCloudApigeeV1AttributeResponse'] attributes: Custom attributes associated with the operation.
        :param Sequence['GoogleCloudApigeeV1GraphQLOperationResponse'] operations: List of GraphQL name/operation type pairs for the proxy or remote service to which quota will be applied. If only operation types are specified, the quota will be applied to all GraphQL requests irrespective of the GraphQL name. **Note**: Currently, you can specify only a single GraphQLOperation. Specifying more than one will cause the operation to fail.
        :param 'GoogleCloudApigeeV1QuotaResponse' quota: Quota parameters to be enforced for the resources, methods, and API source combination. If none are specified, quota enforcement will not be done.
        """
        pulumi.set(__self__, "api_source", api_source)
        pulumi.set(__self__, "attributes", attributes)
        pulumi.set(__self__, "operations", operations)
        pulumi.set(__self__, "quota", quota)

    @property
    @pulumi.getter(name="apiSource")
    def api_source(self) -> str:
        """
        Name of the API proxy endpoint or remote service with which the GraphQL operation and quota are associated.
        """
        return pulumi.get(self, "api_source")

    @property
    @pulumi.getter
    def attributes(self) -> Sequence['outputs.GoogleCloudApigeeV1AttributeResponse']:
        """
        Custom attributes associated with the operation.
        """
        return pulumi.get(self, "attributes")

    @property
    @pulumi.getter
    def operations(self) -> Sequence['outputs.GoogleCloudApigeeV1GraphQLOperationResponse']:
        """
        List of GraphQL name/operation type pairs for the proxy or remote service to which quota will be applied. If only operation types are specified, the quota will be applied to all GraphQL requests irrespective of the GraphQL name. **Note**: Currently, you can specify only a single GraphQLOperation. Specifying more than one will cause the operation to fail.
        """
        return pulumi.get(self, "operations")

    @property
    @pulumi.getter
    def quota(self) -> 'outputs.GoogleCloudApigeeV1QuotaResponse':
        """
        Quota parameters to be enforced for the resources, methods, and API source combination. If none are specified, quota enforcement will not be done.
        """
        return pulumi.get(self, "quota")


@pulumi.output_type
class GoogleCloudApigeeV1GraphQLOperationGroupResponse(dict):
    """
    List of graphQL operation configuration details associated with Apigee API proxies or remote services. Remote services are non-Apigee proxies, such as Istio-Envoy.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "operationConfigType":
            suggest = "operation_config_type"
        elif key == "operationConfigs":
            suggest = "operation_configs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudApigeeV1GraphQLOperationGroupResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudApigeeV1GraphQLOperationGroupResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudApigeeV1GraphQLOperationGroupResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 operation_config_type: str,
                 operation_configs: Sequence['outputs.GoogleCloudApigeeV1GraphQLOperationConfigResponse']):
        """
        List of graphQL operation configuration details associated with Apigee API proxies or remote services. Remote services are non-Apigee proxies, such as Istio-Envoy.
        :param str operation_config_type: Flag that specifies whether the configuration is for Apigee API proxy or a remote service. Valid values include `proxy` or `remoteservice`. Defaults to `proxy`. Set to `proxy` when Apigee API proxies are associated with the API product. Set to `remoteservice` when non-Apigee proxies like Istio-Envoy are associated with the API product.
        :param Sequence['GoogleCloudApigeeV1GraphQLOperationConfigResponse'] operation_configs: List of operation configurations for either Apigee API proxies or other remote services that are associated with this API product.
        """
        pulumi.set(__self__, "operation_config_type", operation_config_type)
        pulumi.set(__self__, "operation_configs", operation_configs)

    @property
    @pulumi.getter(name="operationConfigType")
    def operation_config_type(self) -> str:
        """
        Flag that specifies whether the configuration is for Apigee API proxy or a remote service. Valid values include `proxy` or `remoteservice`. Defaults to `proxy`. Set to `proxy` when Apigee API proxies are associated with the API product. Set to `remoteservice` when non-Apigee proxies like Istio-Envoy are associated with the API product.
        """
        return pulumi.get(self, "operation_config_type")

    @property
    @pulumi.getter(name="operationConfigs")
    def operation_configs(self) -> Sequence['outputs.GoogleCloudApigeeV1GraphQLOperationConfigResponse']:
        """
        List of operation configurations for either Apigee API proxies or other remote services that are associated with this API product.
        """
        return pulumi.get(self, "operation_configs")


@pulumi.output_type
class GoogleCloudApigeeV1GraphQLOperationResponse(dict):
    """
    Represents the pairing of GraphQL operation types and the GraphQL operation name.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "operationTypes":
            suggest = "operation_types"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudApigeeV1GraphQLOperationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudApigeeV1GraphQLOperationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudApigeeV1GraphQLOperationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 operation: str,
                 operation_types: Sequence[str]):
        """
        Represents the pairing of GraphQL operation types and the GraphQL operation name.
        :param str operation: GraphQL operation name. The name and operation type will be used to apply quotas. If no name is specified, the quota will be applied to all GraphQL operations irrespective of their operation names in the payload.
        :param Sequence[str] operation_types: GraphQL operation types. Valid values include `query` or `mutation`. **Note**: Apigee does not currently support `subscription` types.
        """
        pulumi.set(__self__, "operation", operation)
        pulumi.set(__self__, "operation_types", operation_types)

    @property
    @pulumi.getter
    def operation(self) -> str:
        """
        GraphQL operation name. The name and operation type will be used to apply quotas. If no name is specified, the quota will be applied to all GraphQL operations irrespective of their operation names in the payload.
        """
        return pulumi.get(self, "operation")

    @property
    @pulumi.getter(name="operationTypes")
    def operation_types(self) -> Sequence[str]:
        """
        GraphQL operation types. Valid values include `query` or `mutation`. **Note**: Apigee does not currently support `subscription` types.
        """
        return pulumi.get(self, "operation_types")


@pulumi.output_type
class GoogleCloudApigeeV1IntegrationConfigResponse(dict):
    """
    Configuration for the Integration add-on.
    """
    def __init__(__self__, *,
                 enabled: bool):
        """
        Configuration for the Integration add-on.
        :param bool enabled: Flag that specifies whether the Integration add-on is enabled.
        """
        pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        Flag that specifies whether the Integration add-on is enabled.
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class GoogleCloudApigeeV1MonetizationConfigResponse(dict):
    """
    Configuration for the Monetization add-on.
    """
    def __init__(__self__, *,
                 enabled: bool):
        """
        Configuration for the Monetization add-on.
        :param bool enabled: Flag that specifies whether the Monetization add-on is enabled.
        """
        pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        Flag that specifies whether the Monetization add-on is enabled.
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class GoogleCloudApigeeV1OperationConfigResponse(dict):
    """
    Binds the resources in an API proxy or remote service with the allowed REST methods and associated quota enforcement.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiSource":
            suggest = "api_source"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudApigeeV1OperationConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudApigeeV1OperationConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudApigeeV1OperationConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 api_source: str,
                 attributes: Sequence['outputs.GoogleCloudApigeeV1AttributeResponse'],
                 operations: Sequence['outputs.GoogleCloudApigeeV1OperationResponse'],
                 quota: 'outputs.GoogleCloudApigeeV1QuotaResponse'):
        """
        Binds the resources in an API proxy or remote service with the allowed REST methods and associated quota enforcement.
        :param str api_source: Name of the API proxy or remote service with which the resources, methods, and quota are associated.
        :param Sequence['GoogleCloudApigeeV1AttributeResponse'] attributes: Custom attributes associated with the operation.
        :param Sequence['GoogleCloudApigeeV1OperationResponse'] operations: List of resource/method pairs for the API proxy or remote service to which quota will applied. **Note**: Currently, you can specify only a single resource/method pair. The call will fail if more than one resource/method pair is provided.
        :param 'GoogleCloudApigeeV1QuotaResponse' quota: Quota parameters to be enforced for the resources, methods, and API source combination. If none are specified, quota enforcement will not be done.
        """
        pulumi.set(__self__, "api_source", api_source)
        pulumi.set(__self__, "attributes", attributes)
        pulumi.set(__self__, "operations", operations)
        pulumi.set(__self__, "quota", quota)

    @property
    @pulumi.getter(name="apiSource")
    def api_source(self) -> str:
        """
        Name of the API proxy or remote service with which the resources, methods, and quota are associated.
        """
        return pulumi.get(self, "api_source")

    @property
    @pulumi.getter
    def attributes(self) -> Sequence['outputs.GoogleCloudApigeeV1AttributeResponse']:
        """
        Custom attributes associated with the operation.
        """
        return pulumi.get(self, "attributes")

    @property
    @pulumi.getter
    def operations(self) -> Sequence['outputs.GoogleCloudApigeeV1OperationResponse']:
        """
        List of resource/method pairs for the API proxy or remote service to which quota will applied. **Note**: Currently, you can specify only a single resource/method pair. The call will fail if more than one resource/method pair is provided.
        """
        return pulumi.get(self, "operations")

    @property
    @pulumi.getter
    def quota(self) -> 'outputs.GoogleCloudApigeeV1QuotaResponse':
        """
        Quota parameters to be enforced for the resources, methods, and API source combination. If none are specified, quota enforcement will not be done.
        """
        return pulumi.get(self, "quota")


@pulumi.output_type
class GoogleCloudApigeeV1OperationGroupResponse(dict):
    """
    List of operation configuration details associated with Apigee API proxies or remote services. Remote services are non-Apigee proxies, such as Istio-Envoy.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "operationConfigType":
            suggest = "operation_config_type"
        elif key == "operationConfigs":
            suggest = "operation_configs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudApigeeV1OperationGroupResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudApigeeV1OperationGroupResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudApigeeV1OperationGroupResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 operation_config_type: str,
                 operation_configs: Sequence['outputs.GoogleCloudApigeeV1OperationConfigResponse']):
        """
        List of operation configuration details associated with Apigee API proxies or remote services. Remote services are non-Apigee proxies, such as Istio-Envoy.
        :param str operation_config_type: Flag that specifes whether the configuration is for Apigee API proxy or a remote service. Valid values include `proxy` or `remoteservice`. Defaults to `proxy`. Set to `proxy` when Apigee API proxies are associated with the API product. Set to `remoteservice` when non-Apigee proxies like Istio-Envoy are associated with the API product.
        :param Sequence['GoogleCloudApigeeV1OperationConfigResponse'] operation_configs: List of operation configurations for either Apigee API proxies or other remote services that are associated with this API product.
        """
        pulumi.set(__self__, "operation_config_type", operation_config_type)
        pulumi.set(__self__, "operation_configs", operation_configs)

    @property
    @pulumi.getter(name="operationConfigType")
    def operation_config_type(self) -> str:
        """
        Flag that specifes whether the configuration is for Apigee API proxy or a remote service. Valid values include `proxy` or `remoteservice`. Defaults to `proxy`. Set to `proxy` when Apigee API proxies are associated with the API product. Set to `remoteservice` when non-Apigee proxies like Istio-Envoy are associated with the API product.
        """
        return pulumi.get(self, "operation_config_type")

    @property
    @pulumi.getter(name="operationConfigs")
    def operation_configs(self) -> Sequence['outputs.GoogleCloudApigeeV1OperationConfigResponse']:
        """
        List of operation configurations for either Apigee API proxies or other remote services that are associated with this API product.
        """
        return pulumi.get(self, "operation_configs")


@pulumi.output_type
class GoogleCloudApigeeV1OperationResponse(dict):
    """
    Represents the pairing of REST resource path and the actions (verbs) allowed on the resource path.
    """
    def __init__(__self__, *,
                 methods: Sequence[str],
                 resource: str):
        """
        Represents the pairing of REST resource path and the actions (verbs) allowed on the resource path.
        :param Sequence[str] methods: methods refers to the REST verbs as in https://www.w3.org/Protocols/rfc2616/rfc2616-sec9.html. When none specified, all verb types are allowed.
        :param str resource: REST resource path associated with the API proxy or remote service.
        """
        pulumi.set(__self__, "methods", methods)
        pulumi.set(__self__, "resource", resource)

    @property
    @pulumi.getter
    def methods(self) -> Sequence[str]:
        """
        methods refers to the REST verbs as in https://www.w3.org/Protocols/rfc2616/rfc2616-sec9.html. When none specified, all verb types are allowed.
        """
        return pulumi.get(self, "methods")

    @property
    @pulumi.getter
    def resource(self) -> str:
        """
        REST resource path associated with the API proxy or remote service.
        """
        return pulumi.get(self, "resource")


@pulumi.output_type
class GoogleCloudApigeeV1PropertiesResponse(dict):
    """
    Message for compatibility with legacy Edge specification for Java Properties object in JSON.
    """
    def __init__(__self__, *,
                 property: Sequence['outputs.GoogleCloudApigeeV1PropertyResponse']):
        """
        Message for compatibility with legacy Edge specification for Java Properties object in JSON.
        :param Sequence['GoogleCloudApigeeV1PropertyResponse'] property: List of all properties in the object
        """
        pulumi.set(__self__, "property", property)

    @property
    @pulumi.getter
    def property(self) -> Sequence['outputs.GoogleCloudApigeeV1PropertyResponse']:
        """
        List of all properties in the object
        """
        return pulumi.get(self, "property")


@pulumi.output_type
class GoogleCloudApigeeV1PropertyResponse(dict):
    """
    A single property entry in the Properties message.
    """
    def __init__(__self__, *,
                 name: str,
                 value: str):
        """
        A single property entry in the Properties message.
        :param str name: The property key
        :param str value: The property value
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The property key
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The property value
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GoogleCloudApigeeV1QueryMetadataResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endTimestamp":
            suggest = "end_timestamp"
        elif key == "outputFormat":
            suggest = "output_format"
        elif key == "startTimestamp":
            suggest = "start_timestamp"
        elif key == "timeUnit":
            suggest = "time_unit"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudApigeeV1QueryMetadataResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudApigeeV1QueryMetadataResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudApigeeV1QueryMetadataResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dimensions: Sequence[str],
                 end_timestamp: str,
                 metrics: Sequence[str],
                 output_format: str,
                 start_timestamp: str,
                 time_unit: str):
        """
        :param Sequence[str] dimensions: Dimensions of the AsyncQuery.
        :param str end_timestamp: End timestamp of the query range.
        :param Sequence[str] metrics: Metrics of the AsyncQuery. Example: ["name:message_count,func:sum,alias:sum_message_count"]
        :param str output_format: Output format.
        :param str start_timestamp: Start timestamp of the query range.
        :param str time_unit: Query GroupBy time unit.
        """
        pulumi.set(__self__, "dimensions", dimensions)
        pulumi.set(__self__, "end_timestamp", end_timestamp)
        pulumi.set(__self__, "metrics", metrics)
        pulumi.set(__self__, "output_format", output_format)
        pulumi.set(__self__, "start_timestamp", start_timestamp)
        pulumi.set(__self__, "time_unit", time_unit)

    @property
    @pulumi.getter
    def dimensions(self) -> Sequence[str]:
        """
        Dimensions of the AsyncQuery.
        """
        return pulumi.get(self, "dimensions")

    @property
    @pulumi.getter(name="endTimestamp")
    def end_timestamp(self) -> str:
        """
        End timestamp of the query range.
        """
        return pulumi.get(self, "end_timestamp")

    @property
    @pulumi.getter
    def metrics(self) -> Sequence[str]:
        """
        Metrics of the AsyncQuery. Example: ["name:message_count,func:sum,alias:sum_message_count"]
        """
        return pulumi.get(self, "metrics")

    @property
    @pulumi.getter(name="outputFormat")
    def output_format(self) -> str:
        """
        Output format.
        """
        return pulumi.get(self, "output_format")

    @property
    @pulumi.getter(name="startTimestamp")
    def start_timestamp(self) -> str:
        """
        Start timestamp of the query range.
        """
        return pulumi.get(self, "start_timestamp")

    @property
    @pulumi.getter(name="timeUnit")
    def time_unit(self) -> str:
        """
        Query GroupBy time unit.
        """
        return pulumi.get(self, "time_unit")


@pulumi.output_type
class GoogleCloudApigeeV1QuotaResponse(dict):
    """
    Quota contains the essential parameters needed that can be applied on the resources, methods, API source combination associated with this API product. While Quota is optional, setting it prevents requests from exceeding the provisioned parameters.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "timeUnit":
            suggest = "time_unit"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudApigeeV1QuotaResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudApigeeV1QuotaResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudApigeeV1QuotaResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 interval: str,
                 limit: str,
                 time_unit: str):
        """
        Quota contains the essential parameters needed that can be applied on the resources, methods, API source combination associated with this API product. While Quota is optional, setting it prevents requests from exceeding the provisioned parameters.
        :param str interval: Time interval over which the number of request messages is calculated.
        :param str limit: Upper limit allowed for the time interval and time unit specified. Requests exceeding this limit will be rejected.
        :param str time_unit: Time unit defined for the `interval`. Valid values include `minute`, `hour`, `day`, or `month`. If `limit` and `interval` are valid, the default value is `hour`; otherwise, the default is null.
        """
        pulumi.set(__self__, "interval", interval)
        pulumi.set(__self__, "limit", limit)
        pulumi.set(__self__, "time_unit", time_unit)

    @property
    @pulumi.getter
    def interval(self) -> str:
        """
        Time interval over which the number of request messages is calculated.
        """
        return pulumi.get(self, "interval")

    @property
    @pulumi.getter
    def limit(self) -> str:
        """
        Upper limit allowed for the time interval and time unit specified. Requests exceeding this limit will be rejected.
        """
        return pulumi.get(self, "limit")

    @property
    @pulumi.getter(name="timeUnit")
    def time_unit(self) -> str:
        """
        Time unit defined for the `interval`. Valid values include `minute`, `hour`, `day`, or `month`. If `limit` and `interval` are valid, the default value is `hour`; otherwise, the default is null.
        """
        return pulumi.get(self, "time_unit")


@pulumi.output_type
class GoogleCloudApigeeV1RateRangeResponse(dict):
    """
    API call volume range and the fees charged when the total number of API calls is within the range.
    """
    def __init__(__self__, *,
                 end: str,
                 fee: 'outputs.GoogleTypeMoneyResponse',
                 start: str):
        """
        API call volume range and the fees charged when the total number of API calls is within the range.
        :param str end: Ending value of the range. Set to 0 or `null` for the last range of values.
        :param 'GoogleTypeMoneyResponse' fee: Fee to charge when total number of API calls falls within this range.
        :param str start: Starting value of the range. Set to 0 or `null` for the initial range of values.
        """
        pulumi.set(__self__, "end", end)
        pulumi.set(__self__, "fee", fee)
        pulumi.set(__self__, "start", start)

    @property
    @pulumi.getter
    def end(self) -> str:
        """
        Ending value of the range. Set to 0 or `null` for the last range of values.
        """
        return pulumi.get(self, "end")

    @property
    @pulumi.getter
    def fee(self) -> 'outputs.GoogleTypeMoneyResponse':
        """
        Fee to charge when total number of API calls falls within this range.
        """
        return pulumi.get(self, "fee")

    @property
    @pulumi.getter
    def start(self) -> str:
        """
        Starting value of the range. Set to 0 or `null` for the initial range of values.
        """
        return pulumi.get(self, "start")


@pulumi.output_type
class GoogleCloudApigeeV1ReportPropertyResponse(dict):
    def __init__(__self__, *,
                 property: str,
                 value: Sequence['outputs.GoogleCloudApigeeV1AttributeResponse']):
        """
        :param str property: name of the property
        :param Sequence['GoogleCloudApigeeV1AttributeResponse'] value: property values
        """
        pulumi.set(__self__, "property", property)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def value(self) -> Sequence['outputs.GoogleCloudApigeeV1AttributeResponse']:
        """
        property values
        """
        return pulumi.get(self, "value")

    @property
    @pulumi.getter
    def property(self) -> str:
        """
        name of the property
        """
        return pulumi.get(self, "property")


@pulumi.output_type
class GoogleCloudApigeeV1RevenueShareRangeResponse(dict):
    """
    API call volume range and the percentage of revenue to share with the developer when the total number of API calls is within the range.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sharePercentage":
            suggest = "share_percentage"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudApigeeV1RevenueShareRangeResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudApigeeV1RevenueShareRangeResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudApigeeV1RevenueShareRangeResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 end: str,
                 share_percentage: float,
                 start: str):
        """
        API call volume range and the percentage of revenue to share with the developer when the total number of API calls is within the range.
        :param str end: Ending value of the range. Set to 0 or `null` for the last range of values.
        :param float share_percentage: Percentage of the revenue to be shared with the developer. For example, to share 21 percent of the total revenue with the developer, set this value to 21. Specify a decimal number with a maximum of two digits following the decimal point.
        :param str start: Starting value of the range. Set to 0 or `null` for the initial range of values.
        """
        pulumi.set(__self__, "end", end)
        pulumi.set(__self__, "share_percentage", share_percentage)
        pulumi.set(__self__, "start", start)

    @property
    @pulumi.getter
    def end(self) -> str:
        """
        Ending value of the range. Set to 0 or `null` for the last range of values.
        """
        return pulumi.get(self, "end")

    @property
    @pulumi.getter(name="sharePercentage")
    def share_percentage(self) -> float:
        """
        Percentage of the revenue to be shared with the developer. For example, to share 21 percent of the total revenue with the developer, set this value to 21. Specify a decimal number with a maximum of two digits following the decimal point.
        """
        return pulumi.get(self, "share_percentage")

    @property
    @pulumi.getter
    def start(self) -> str:
        """
        Starting value of the range. Set to 0 or `null` for the initial range of values.
        """
        return pulumi.get(self, "start")


@pulumi.output_type
class GoogleCloudApigeeV1TlsInfoCommonNameResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "wildcardMatch":
            suggest = "wildcard_match"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudApigeeV1TlsInfoCommonNameResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudApigeeV1TlsInfoCommonNameResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudApigeeV1TlsInfoCommonNameResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 value: str,
                 wildcard_match: bool):
        """
        :param str value: The TLS Common Name string of the certificate.
        :param bool wildcard_match: Indicates whether the cert should be matched against as a wildcard cert.
        """
        pulumi.set(__self__, "value", value)
        pulumi.set(__self__, "wildcard_match", wildcard_match)

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The TLS Common Name string of the certificate.
        """
        return pulumi.get(self, "value")

    @property
    @pulumi.getter(name="wildcardMatch")
    def wildcard_match(self) -> bool:
        """
        Indicates whether the cert should be matched against as a wildcard cert.
        """
        return pulumi.get(self, "wildcard_match")


@pulumi.output_type
class GoogleCloudApigeeV1TlsInfoResponse(dict):
    """
    TLS configuration information for VirtualHosts and TargetServers.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientAuthEnabled":
            suggest = "client_auth_enabled"
        elif key == "commonName":
            suggest = "common_name"
        elif key == "ignoreValidationErrors":
            suggest = "ignore_validation_errors"
        elif key == "keyAlias":
            suggest = "key_alias"
        elif key == "keyStore":
            suggest = "key_store"
        elif key == "trustStore":
            suggest = "trust_store"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudApigeeV1TlsInfoResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudApigeeV1TlsInfoResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudApigeeV1TlsInfoResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ciphers: Sequence[str],
                 client_auth_enabled: bool,
                 common_name: 'outputs.GoogleCloudApigeeV1TlsInfoCommonNameResponse',
                 enabled: bool,
                 ignore_validation_errors: bool,
                 key_alias: str,
                 key_store: str,
                 protocols: Sequence[str],
                 trust_store: str):
        """
        TLS configuration information for VirtualHosts and TargetServers.
        :param Sequence[str] ciphers: The SSL/TLS cipher suites to be used. Must be one of the cipher suite names listed in: http://docs.oracle.com/javase/8/docs/technotes/guides/security/StandardNames.html#ciphersuites
        :param bool client_auth_enabled: Optional. Enables two-way TLS.
        :param 'GoogleCloudApigeeV1TlsInfoCommonNameResponse' common_name: The TLS Common Name of the certificate.
        :param bool enabled: Enables TLS. If false, neither one-way nor two-way TLS will be enabled.
        :param bool ignore_validation_errors: If true, Edge ignores TLS certificate errors. Valid when configuring TLS for target servers and target endpoints, and when configuring virtual hosts that use 2-way TLS. When used with a target endpoint/target server, if the backend system uses SNI and returns a cert with a subject Distinguished Name (DN) that does not match the hostname, there is no way to ignore the error and the connection fails.
        :param str key_alias: Required if `client_auth_enabled` is true. The resource ID for the alias containing the private key and cert.
        :param str key_store: Required if `client_auth_enabled` is true. The resource ID of the keystore. References not yet supported.
        :param Sequence[str] protocols: The TLS versioins to be used.
        :param str trust_store: The resource ID of the truststore. References not yet supported.
        """
        pulumi.set(__self__, "ciphers", ciphers)
        pulumi.set(__self__, "client_auth_enabled", client_auth_enabled)
        pulumi.set(__self__, "common_name", common_name)
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "ignore_validation_errors", ignore_validation_errors)
        pulumi.set(__self__, "key_alias", key_alias)
        pulumi.set(__self__, "key_store", key_store)
        pulumi.set(__self__, "protocols", protocols)
        pulumi.set(__self__, "trust_store", trust_store)

    @property
    @pulumi.getter
    def ciphers(self) -> Sequence[str]:
        """
        The SSL/TLS cipher suites to be used. Must be one of the cipher suite names listed in: http://docs.oracle.com/javase/8/docs/technotes/guides/security/StandardNames.html#ciphersuites
        """
        return pulumi.get(self, "ciphers")

    @property
    @pulumi.getter(name="clientAuthEnabled")
    def client_auth_enabled(self) -> bool:
        """
        Optional. Enables two-way TLS.
        """
        return pulumi.get(self, "client_auth_enabled")

    @property
    @pulumi.getter(name="commonName")
    def common_name(self) -> 'outputs.GoogleCloudApigeeV1TlsInfoCommonNameResponse':
        """
        The TLS Common Name of the certificate.
        """
        return pulumi.get(self, "common_name")

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        Enables TLS. If false, neither one-way nor two-way TLS will be enabled.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="ignoreValidationErrors")
    def ignore_validation_errors(self) -> bool:
        """
        If true, Edge ignores TLS certificate errors. Valid when configuring TLS for target servers and target endpoints, and when configuring virtual hosts that use 2-way TLS. When used with a target endpoint/target server, if the backend system uses SNI and returns a cert with a subject Distinguished Name (DN) that does not match the hostname, there is no way to ignore the error and the connection fails.
        """
        return pulumi.get(self, "ignore_validation_errors")

    @property
    @pulumi.getter(name="keyAlias")
    def key_alias(self) -> str:
        """
        Required if `client_auth_enabled` is true. The resource ID for the alias containing the private key and cert.
        """
        return pulumi.get(self, "key_alias")

    @property
    @pulumi.getter(name="keyStore")
    def key_store(self) -> str:
        """
        Required if `client_auth_enabled` is true. The resource ID of the keystore. References not yet supported.
        """
        return pulumi.get(self, "key_store")

    @property
    @pulumi.getter
    def protocols(self) -> Sequence[str]:
        """
        The TLS versioins to be used.
        """
        return pulumi.get(self, "protocols")

    @property
    @pulumi.getter(name="trustStore")
    def trust_store(self) -> str:
        """
        The resource ID of the truststore. References not yet supported.
        """
        return pulumi.get(self, "trust_store")


@pulumi.output_type
class GoogleCloudApigeeV1TraceSamplingConfigResponse(dict):
    """
    TraceSamplingConfig represents the detail settings of distributed tracing. Only the fields that are defined in the distributed trace configuration can be overridden using the distribute trace configuration override APIs.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "samplingRate":
            suggest = "sampling_rate"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudApigeeV1TraceSamplingConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudApigeeV1TraceSamplingConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudApigeeV1TraceSamplingConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 sampler: str,
                 sampling_rate: float):
        """
        TraceSamplingConfig represents the detail settings of distributed tracing. Only the fields that are defined in the distributed trace configuration can be overridden using the distribute trace configuration override APIs.
        :param str sampler: Sampler of distributed tracing. OFF is the default value.
        :param float sampling_rate: Field sampling rate. This value is only applicable when using the PROBABILITY sampler. The supported values are > 0 and <= 0.5.
        """
        pulumi.set(__self__, "sampler", sampler)
        pulumi.set(__self__, "sampling_rate", sampling_rate)

    @property
    @pulumi.getter
    def sampler(self) -> str:
        """
        Sampler of distributed tracing. OFF is the default value.
        """
        return pulumi.get(self, "sampler")

    @property
    @pulumi.getter(name="samplingRate")
    def sampling_rate(self) -> float:
        """
        Field sampling rate. This value is only applicable when using the PROBABILITY sampler. The supported values are > 0 and <= 0.5.
        """
        return pulumi.get(self, "sampling_rate")


@pulumi.output_type
class GoogleIamV1AuditConfigResponse(dict):
    """
    Specifies the audit configuration for a service. The configuration determines which permission types are logged, and what identities, if any, are exempted from logging. An AuditConfig must have one or more AuditLogConfigs. If there are AuditConfigs for both `allServices` and a specific service, the union of the two AuditConfigs is used for that service: the log_types specified in each AuditConfig are enabled, and the exempted_members in each AuditLogConfig are exempted. Example Policy with multiple AuditConfigs: { "audit_configs": [ { "service": "allServices", "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [ "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" }, { "log_type": "ADMIN_READ" } ] }, { "service": "sampleservice.googleapis.com", "audit_log_configs": [ { "log_type": "DATA_READ" }, { "log_type": "DATA_WRITE", "exempted_members": [ "user:aliya@example.com" ] } ] } ] } For sampleservice, this policy enables DATA_READ, DATA_WRITE and ADMIN_READ logging. It also exempts jose@example.com from DATA_READ logging, and aliya@example.com from DATA_WRITE logging.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "auditLogConfigs":
            suggest = "audit_log_configs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleIamV1AuditConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleIamV1AuditConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleIamV1AuditConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 audit_log_configs: Sequence['outputs.GoogleIamV1AuditLogConfigResponse'],
                 service: str):
        """
        Specifies the audit configuration for a service. The configuration determines which permission types are logged, and what identities, if any, are exempted from logging. An AuditConfig must have one or more AuditLogConfigs. If there are AuditConfigs for both `allServices` and a specific service, the union of the two AuditConfigs is used for that service: the log_types specified in each AuditConfig are enabled, and the exempted_members in each AuditLogConfig are exempted. Example Policy with multiple AuditConfigs: { "audit_configs": [ { "service": "allServices", "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [ "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" }, { "log_type": "ADMIN_READ" } ] }, { "service": "sampleservice.googleapis.com", "audit_log_configs": [ { "log_type": "DATA_READ" }, { "log_type": "DATA_WRITE", "exempted_members": [ "user:aliya@example.com" ] } ] } ] } For sampleservice, this policy enables DATA_READ, DATA_WRITE and ADMIN_READ logging. It also exempts jose@example.com from DATA_READ logging, and aliya@example.com from DATA_WRITE logging.
        :param Sequence['GoogleIamV1AuditLogConfigResponse'] audit_log_configs: The configuration for logging of each type of permission.
        :param str service: Specifies a service that will be enabled for audit logging. For example, `storage.googleapis.com`, `cloudsql.googleapis.com`. `allServices` is a special value that covers all services.
        """
        pulumi.set(__self__, "audit_log_configs", audit_log_configs)
        pulumi.set(__self__, "service", service)

    @property
    @pulumi.getter(name="auditLogConfigs")
    def audit_log_configs(self) -> Sequence['outputs.GoogleIamV1AuditLogConfigResponse']:
        """
        The configuration for logging of each type of permission.
        """
        return pulumi.get(self, "audit_log_configs")

    @property
    @pulumi.getter
    def service(self) -> str:
        """
        Specifies a service that will be enabled for audit logging. For example, `storage.googleapis.com`, `cloudsql.googleapis.com`. `allServices` is a special value that covers all services.
        """
        return pulumi.get(self, "service")


@pulumi.output_type
class GoogleIamV1AuditLogConfigResponse(dict):
    """
    Provides the configuration for logging a type of permissions. Example: { "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [ "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" } ] } This enables 'DATA_READ' and 'DATA_WRITE' logging, while exempting jose@example.com from DATA_READ logging.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "exemptedMembers":
            suggest = "exempted_members"
        elif key == "logType":
            suggest = "log_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleIamV1AuditLogConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleIamV1AuditLogConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleIamV1AuditLogConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 exempted_members: Sequence[str],
                 log_type: str):
        """
        Provides the configuration for logging a type of permissions. Example: { "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [ "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" } ] } This enables 'DATA_READ' and 'DATA_WRITE' logging, while exempting jose@example.com from DATA_READ logging.
        :param Sequence[str] exempted_members: Specifies the identities that do not cause logging for this type of permission. Follows the same format of Binding.members.
        :param str log_type: The log type that this config enables.
        """
        pulumi.set(__self__, "exempted_members", exempted_members)
        pulumi.set(__self__, "log_type", log_type)

    @property
    @pulumi.getter(name="exemptedMembers")
    def exempted_members(self) -> Sequence[str]:
        """
        Specifies the identities that do not cause logging for this type of permission. Follows the same format of Binding.members.
        """
        return pulumi.get(self, "exempted_members")

    @property
    @pulumi.getter(name="logType")
    def log_type(self) -> str:
        """
        The log type that this config enables.
        """
        return pulumi.get(self, "log_type")


@pulumi.output_type
class GoogleIamV1BindingResponse(dict):
    """
    Associates `members`, or principals, with a `role`.
    """
    def __init__(__self__, *,
                 condition: 'outputs.GoogleTypeExprResponse',
                 members: Sequence[str],
                 role: str):
        """
        Associates `members`, or principals, with a `role`.
        :param 'GoogleTypeExprResponse' condition: The condition that is associated with this binding. If the condition evaluates to `true`, then this binding applies to the current request. If the condition evaluates to `false`, then this binding does not apply to the current request. However, a different role binding might grant the same role to one or more of the principals in this binding. To learn which resources support conditions in their IAM policies, see the [IAM documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
        :param Sequence[str] members: Specifies the principals requesting access for a Cloud Platform resource. `members` can have the following values: * `allUsers`: A special identifier that represents anyone who is on the internet; with or without a Google account. * `allAuthenticatedUsers`: A special identifier that represents anyone who is authenticated with a Google account or a service account. * `user:{emailid}`: An email address that represents a specific Google account. For example, `alice@example.com` . * `serviceAccount:{emailid}`: An email address that represents a service account. For example, `my-other-app@appspot.gserviceaccount.com`. * `group:{emailid}`: An email address that represents a Google group. For example, `admins@example.com`. * `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a user that has been recently deleted. For example, `alice@example.com?uid=123456789012345678901`. If the user is recovered, this value reverts to `user:{emailid}` and the recovered user retains the role in the binding. * `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a service account that has been recently deleted. For example, `my-other-app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the service account is undeleted, this value reverts to `serviceAccount:{emailid}` and the undeleted service account retains the role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a Google group that has been recently deleted. For example, `admins@example.com?uid=123456789012345678901`. If the group is recovered, this value reverts to `group:{emailid}` and the recovered group retains the role in the binding. * `domain:{domain}`: The G Suite domain (primary) that represents all the users of that domain. For example, `google.com` or `example.com`. 
        :param str role: Role that is assigned to the list of `members`, or principals. For example, `roles/viewer`, `roles/editor`, or `roles/owner`.
        """
        pulumi.set(__self__, "condition", condition)
        pulumi.set(__self__, "members", members)
        pulumi.set(__self__, "role", role)

    @property
    @pulumi.getter
    def condition(self) -> 'outputs.GoogleTypeExprResponse':
        """
        The condition that is associated with this binding. If the condition evaluates to `true`, then this binding applies to the current request. If the condition evaluates to `false`, then this binding does not apply to the current request. However, a different role binding might grant the same role to one or more of the principals in this binding. To learn which resources support conditions in their IAM policies, see the [IAM documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
        """
        return pulumi.get(self, "condition")

    @property
    @pulumi.getter
    def members(self) -> Sequence[str]:
        """
        Specifies the principals requesting access for a Cloud Platform resource. `members` can have the following values: * `allUsers`: A special identifier that represents anyone who is on the internet; with or without a Google account. * `allAuthenticatedUsers`: A special identifier that represents anyone who is authenticated with a Google account or a service account. * `user:{emailid}`: An email address that represents a specific Google account. For example, `alice@example.com` . * `serviceAccount:{emailid}`: An email address that represents a service account. For example, `my-other-app@appspot.gserviceaccount.com`. * `group:{emailid}`: An email address that represents a Google group. For example, `admins@example.com`. * `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a user that has been recently deleted. For example, `alice@example.com?uid=123456789012345678901`. If the user is recovered, this value reverts to `user:{emailid}` and the recovered user retains the role in the binding. * `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a service account that has been recently deleted. For example, `my-other-app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the service account is undeleted, this value reverts to `serviceAccount:{emailid}` and the undeleted service account retains the role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a Google group that has been recently deleted. For example, `admins@example.com?uid=123456789012345678901`. If the group is recovered, this value reverts to `group:{emailid}` and the recovered group retains the role in the binding. * `domain:{domain}`: The G Suite domain (primary) that represents all the users of that domain. For example, `google.com` or `example.com`. 
        """
        return pulumi.get(self, "members")

    @property
    @pulumi.getter
    def role(self) -> str:
        """
        Role that is assigned to the list of `members`, or principals. For example, `roles/viewer`, `roles/editor`, or `roles/owner`.
        """
        return pulumi.get(self, "role")


@pulumi.output_type
class GoogleTypeExprResponse(dict):
    """
    Represents a textual expression in the Common Expression Language (CEL) syntax. CEL is a C-like expression language. The syntax and semantics of CEL are documented at https://github.com/google/cel-spec. Example (Comparison): title: "Summary size limit" description: "Determines if a summary is less than 100 chars" expression: "document.summary.size() < 100" Example (Equality): title: "Requestor is owner" description: "Determines if requestor is the document owner" expression: "document.owner == request.auth.claims.email" Example (Logic): title: "Public documents" description: "Determine whether the document should be publicly visible" expression: "document.type != 'private' && document.type != 'internal'" Example (Data Manipulation): title: "Notification string" description: "Create a notification string with a timestamp." expression: "'New message received at ' + string(document.create_time)" The exact variables and functions that may be referenced within an expression are determined by the service that evaluates it. See the service documentation for additional information.
    """
    def __init__(__self__, *,
                 description: str,
                 expression: str,
                 location: str,
                 title: str):
        """
        Represents a textual expression in the Common Expression Language (CEL) syntax. CEL is a C-like expression language. The syntax and semantics of CEL are documented at https://github.com/google/cel-spec. Example (Comparison): title: "Summary size limit" description: "Determines if a summary is less than 100 chars" expression: "document.summary.size() < 100" Example (Equality): title: "Requestor is owner" description: "Determines if requestor is the document owner" expression: "document.owner == request.auth.claims.email" Example (Logic): title: "Public documents" description: "Determine whether the document should be publicly visible" expression: "document.type != 'private' && document.type != 'internal'" Example (Data Manipulation): title: "Notification string" description: "Create a notification string with a timestamp." expression: "'New message received at ' + string(document.create_time)" The exact variables and functions that may be referenced within an expression are determined by the service that evaluates it. See the service documentation for additional information.
        :param str description: Optional. Description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
        :param str expression: Textual representation of an expression in Common Expression Language syntax.
        :param str location: Optional. String indicating the location of the expression for error reporting, e.g. a file name and a position in the file.
        :param str title: Optional. Title for the expression, i.e. a short string describing its purpose. This can be used e.g. in UIs which allow to enter the expression.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Optional. Description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def expression(self) -> str:
        """
        Textual representation of an expression in Common Expression Language syntax.
        """
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def location(self) -> str:
        """
        Optional. String indicating the location of the expression for error reporting, e.g. a file name and a position in the file.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def title(self) -> str:
        """
        Optional. Title for the expression, i.e. a short string describing its purpose. This can be used e.g. in UIs which allow to enter the expression.
        """
        return pulumi.get(self, "title")


@pulumi.output_type
class GoogleTypeMoneyResponse(dict):
    """
    Represents an amount of money with its currency type.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "currencyCode":
            suggest = "currency_code"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleTypeMoneyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleTypeMoneyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleTypeMoneyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 currency_code: str,
                 nanos: int,
                 units: str):
        """
        Represents an amount of money with its currency type.
        :param str currency_code: The three-letter currency code defined in ISO 4217.
        :param int nanos: Number of nano (10^-9) units of the amount. The value must be between -999,999,999 and +999,999,999 inclusive. If `units` is positive, `nanos` must be positive or zero. If `units` is zero, `nanos` can be positive, zero, or negative. If `units` is negative, `nanos` must be negative or zero. For example $-1.75 is represented as `units`=-1 and `nanos`=-750,000,000.
        :param str units: The whole units of the amount. For example if `currencyCode` is `"USD"`, then 1 unit is one US dollar.
        """
        pulumi.set(__self__, "currency_code", currency_code)
        pulumi.set(__self__, "nanos", nanos)
        pulumi.set(__self__, "units", units)

    @property
    @pulumi.getter(name="currencyCode")
    def currency_code(self) -> str:
        """
        The three-letter currency code defined in ISO 4217.
        """
        return pulumi.get(self, "currency_code")

    @property
    @pulumi.getter
    def nanos(self) -> int:
        """
        Number of nano (10^-9) units of the amount. The value must be between -999,999,999 and +999,999,999 inclusive. If `units` is positive, `nanos` must be positive or zero. If `units` is zero, `nanos` can be positive, zero, or negative. If `units` is negative, `nanos` must be negative or zero. For example $-1.75 is represented as `units`=-1 and `nanos`=-750,000,000.
        """
        return pulumi.get(self, "nanos")

    @property
    @pulumi.getter
    def units(self) -> str:
        """
        The whole units of the amount. For example if `currencyCode` is `"USD"`, then 1 unit is one US dollar.
        """
        return pulumi.get(self, "units")


