# -*- coding: utf-8 -*-
from setuptools import setup

modules = \
['xbotlib']
install_requires = \
['humanize>=3.2.0,<4.0.0', 'redis>=3.5.3,<4.0.0', 'slixmpp>=1.6.0,<2.0.0']

setup_kwargs = {
    'name': 'xbotlib',
    'version': '0.11.0',
    'description': 'XMPP bots for humans',
    'long_description': '# xbotlib\n\n[![PyPI version](https://badge.fury.io/py/xbotlib.svg)](https://badge.fury.io/py/xbotlib)\n[![Build Status](https://drone.autonomic.zone/api/badges/decentral1se/xbotlib/status.svg?ref=refs/heads/main)](https://drone.autonomic.zone/decentral1se/xbotlib)\n\n## XMPP bots for humans\n\n> status: experimental\n\nA friendly lightweight wrapper around\n[slixmpp](https://slixmpp.readthedocs.io/) for writing XMPP bots in Python. The\ngoal is to make writing and running XMPP bots easy and fun. `xbotlib` is a\n[single file implementation](./xbotlib.py) which can easily be understood and\nextended. It provides a small API surface which reflects the `slixmpp` way of\ndoing things.\n\nThe `xbotlib` source code and ideas are largely\nborrowed/stolen/adapted/reimagined from the XMPP bot experiments that have gone\non and are still going on in\n[Varia](https://git.vvvvvvaria.org/explore/repos?tab=&sort=recentupdate&q=bots).\n\n## Install\n\n```sh\n$ pip install xbotlib\n```\n\n## Example\n\nPut the following in a `echo.py` file.\n\n`xbotlib` provides a number of example bots which you can use to get moving\nfast and try things out.\n\n```python\nfrom xbotlib import EchoBot\n\nEchotBot()\n```\n\nAnd then `python echo.py`. You will be asked a few questions in order to load\nthe account details that your bot will be using. This will generate a\n`echobot.conf` file in the same working directory for further use. See the\n[configuration](#configure-your-bot) section for more.\n\nHere\'s the code for the `EchoBot`.\n\n```python\nclass EchoBot(Bot):\n    def direct(self, message):\n        self.reply(message.text, to=message.sender)\n    def group(self, message):\n        self.reply(message.content, room=message.room)\n```\n\nRead more in the [API reference](#api-reference) for how to write your own bots.\n\n## All examples\n\n- **EchoBot**: Sends back what you sent it\n- **WhisperBot**: Anonymous whispering in group chats\n- **GlossBot**: Building a shared glossary together\n\nSee [xbotlib.py](./xbotlib.py) for all example bots.\n\n## API Reference\n\nWhen writing your own bot, you always sub-class the `Bot` class provided from\n`xbotlib`. Then if you want to respond to a direct message, you write a\n[direct](#botdirectmessage) function. If you want to respond to a group chat\nmessage, you write a [group](#botgroupmessage) function.\n\n### Bot.direct(message)\n\nRespond to direct messages.\n\nArguments:\n\n- **message**: received message (see [SimpleMessage](#simplemessage) below for available attributes)\n\n### Bot.group(message)\n\nRespond to a message in a group chat.\n\nArguments:\n\n- **message**: received message (see [SimpleMessage](#simplemessage) below for available attributes)\n\n### SimpleMessage\n\nA simple message interface.\n\nAttributes:\n\n- **text**: the entire text of the message\n- **content**: the text of the message after the nick\n- **sender**: the user the message came from\n- **room**: the room the message came from\n- **receiver**: the receiver of the message\n- **nick**: the nickname of the sender\n- **type**: the type of message\n\n## Documenting your bot\n\nAdd a `help = "my help"` to your `Bot` class like so.\n\n```python\nclass MyBot(Bot):\n    help = "My help"\n```\n\nSee more in the [commands](#commands) section on how to use this.\n\n## Commands\n\nUsing `@<command>` in direct messages and `<nick>, @<command>` in group chats,\nhere are the supported commands.\n\n- **@uptime**: how long the bot has been running\n- **@help**: the help text for what the bot does\n\nThere are also more general status commands which all bots respond to.\n\n- **@bots**: status check on who is a bot in the group chat\n\n## Avatars\n\nBy default, `xbotlib` will look for an `avatar.png` (so far tested with `.png`\nbut other file types may work) file alongside your Python script which contains\nyour bot implementation. You can also specify another path using the `--avatar`\noption on the command-line interface. The images should ideally have a height\nof `64` and a width of `64` pixels each.\n\n## Configure your bot\n\nAll the ways you can pass configuration details to your bot.\n\n### Using the `.conf` configuration file\n\nIf you run simply run your Python script which contains the bot then `xbotlib`\nwill generate a configuration for you by asking a few questions. This is the\nsimplest way to run your bot locally.\n\nHere is an example of a working configuration.\n\n```conf\n[echobot]\naccount = echobot@vvvvvvaria.org\npassword = ...thepassword...\nnick = echobot\nrooms = test@muc.example.com\n```\n\n### Using the command-line interface\n\nEvery bot accepts a number of comand-line arguments to load configuration. You\ncan use the `--help` option to see what is available (e.g. `python bot.py --help`).\n\n### Using the environment\n\n`xbotlib` will try to read the following configuration values from the\nenvironment if it cannot read them from a configuration file or the\ncommand-line interface. This can be useful when doing remote server\ndeployments.\n\n- **XBOT_ACCOUNT**: The bot account\n- **XBOT_PASSWORD**: The bot password\n- **XBOT_NICK**: The bot nickname\n- **XBOT_AVATAR**: The bot avatar icon\n- **XBOT_REDIS_URL**: Redis key store connection URL\n- **XBOT_ROOMS**: The rooms to automatically join\n- **XBOT_NO_AUTO_JOIN**: Disable auto-joining on invite\n\n## Persistent storage\n\n## Redis key/value storage\n\n`xbotlib` supports using [Redis](https://redis.io/) as a storage back-end. It\nis simple to work with because the interface is exactly like a dictionary. You\ncan quickly run Redis locally using\n[Docker](https://docs.docker.com/engine/install/debian/) or if you\'re on a\nDebian system you can also `sudo apt install -y redis`.\n\n```bash\n$ docker run --network=host --name redis -d redis\n$ export XBOT_REDIS_URL=redis://localhost:6379/0\n```\n\nAnd you access the interface via the `self.db` attribute.\n\n```python\ndef direct(self, message):\n    self.db["mykey"] = message.text\n```\n\nYou should see `INFO Successfully connected to storage` when your bot\ninitialises. Please see the `GlossBot` example for more on how to work with\nthis type of storage.\n\n## Loading Plugins\n\nYou can specify a `plugins = [...]` on your bot definition and they will be\nautomatically loaded.\n\n```python\nclass MyBot(Bot):\n    plugins = ["xep_0066"]\n```\n\n## Deploy your bots\n\nSee [bots.varia.zone](https://bots.varia.zone/).\n\n## Roadmap\n\nSee the [issue tracker](https://git.autonomic.zone/decentral1se/xbotlib/issues).\n\n## Changes\n\nSee the [CHANGELOG.md](./CHANGELOG.md).\n\n## License\n\nSee the [LICENSE](./LICENSE.md).\n',
    'author': 'decentral1se',
    'author_email': 'lukewm@riseup.net',
    'maintainer': 'decentral1se',
    'maintainer_email': 'lukewm@riseup.net',
    'url': 'https://git.autonomic.zone/decentral1se/xbotlib',
    'py_modules': modules,
    'install_requires': install_requires,
    'python_requires': '>=3.6,<4.0',
}


setup(**setup_kwargs)
