# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['coveragepy_lcov']

package_data = \
{'': ['*']}

install_requires = \
['click>=7.1.2', 'coverage>=5.5']

entry_points = \
{'console_scripts': ['coveragepy-lcov = coveragepy_lcov.cli:main']}

setup_kwargs = {
    'name': 'coveragepy-lcov',
    'version': '0.1.2',
    'description': 'A simple .coverage to LCOV converter',
    'long_description': '# coveragepy-lcov\n\n`coveragepy-lcov` is a simple CLI for converting `.coverage` files generated by [Coverage.py](https://github.com/nedbat/coveragepy) to the `LCOV` format.\n\n## Credits\n\nThis tools is based on code from [Coverage.py](https://github.com/nedbat/coveragepy/blob/master/coverage/report.py).\n\n## Installation\n\nUsing pip:\n\n```bash\npip install coveragepy-lcov\n```\n\n## Usage\n\n```bash\n# If the .coverage file is in your current working directory\ncoveragepy-lcov\n\n# Point to a different .coverage file path\ncoveragepy-lcov --data_file_path example/.coverage\n\n# Write the output to a different file path\ncoveragepy-lcov --output_file_path build/lcov.info\n\n# Use relative paths in the LCOV output\ncoveragepy-lcov --relative_path\n```\n\n## Options\n\n```text\nUsage: coveragepy-lcov [OPTIONS]\n\nOptions:\n  --data_file_path TEXT    Path to .coverage file\n  --output_file_path TEXT  lcov.info output file path\n  --config_file TEXT       Path to .coveragerc file\n  --relative_path          Use relative path in LCOV output\n  --preview                Preview LCOV output\n  --help                   Show this message and exit.\n```\n\n## Further reading\n\n- [LCOV format](http://ltp.sourceforge.net/coverage/lcov/geninfo.1.php)\n- https://github.com/nedbat/coveragepy/issues/587\n',
    'author': 'Chay Choong',
    'author_email': 'chaychoong@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/chaychoong/coveragepy-lcov',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.6.3,<4.0.0',
}


setup(**setup_kwargs)
