# coveragepy-lcov

`coveragepy-lcov` is a simple CLI for converting `.coverage` files generated by [Coverage.py](https://github.com/nedbat/coveragepy) to the `LCOV` format.

## Credits

This tools is based on code from [Coverage.py](https://github.com/nedbat/coveragepy/blob/master/coverage/report.py).

## Installation

Using pip:

```bash
pip install coveragepy-lcov
```

## Usage

```bash
# If the .coverage file is in your current working directory
coveragepy-lcov

# Point to a different .coverage file path
coveragepy-lcov --data_file_path example/.coverage

# Write the output to a different file path
coveragepy-lcov --output_file_path build/lcov.info

# Use relative paths in the LCOV output
coveragepy-lcov --relative_path
```

## Options

```text
Usage: coveragepy-lcov [OPTIONS]

Options:
  --data_file_path TEXT    Path to .coverage file
  --output_file_path TEXT  lcov.info output file path
  --config_file TEXT       Path to .coveragerc file
  --relative_path          Use relative path in LCOV output
  --preview                Preview LCOV output
  --help                   Show this message and exit.
```

## Further reading

- [LCOV format](http://ltp.sourceforge.net/coverage/lcov/geninfo.1.php)
- https://github.com/nedbat/coveragepy/issues/587
