# AUTOGENERATED! DO NOT EDIT! File to edit: ../nbs/03_utils.ipynb.

# %% ../nbs/03_utils.ipynb 5
from __future__ import annotations
from fastcore.docments import *
from fastcore.utils import *

import pandas as pd
import numpy as np
from collections import Counter, defaultdict
import copy

# %% auto 0
__all__ = ['restructureWeightsDataList', 'summarizeWeightsData', 'groupedTimeSeriesSplit', 'generateFinalOutput']

# %% ../nbs/03_utils.ipynb 7
def restructureWeightsDataList(weightsDataList, outputType = 'onlyPositiveWeights', y = None, scalingList = None, equalWeights = False):
    
    if outputType == 'all':
        
        weightsDataListAll = list()
        
        for weights, indicesPosWeight in weightsDataList:
            weightsAll = np.zeros(len(y))
            weightsAll[indicesPosWeight] = weights
            weightsDataListAll.append(weightsAll)
        
        return weightsDataListAll
    
    #---
    
    elif outputType == 'onlyPositiveWeights':
        
        return weightsDataList
    
    #---
    
    elif outputType == 'summarized':
        
        weightsDataListSummarized = list()

        for i in range(len(weightsDataList)):
            weightsPos, yWeightPos = weightsDataList[i][0], y[weightsDataList[i][1]]
            
            weightsSummarized, yUnique = summarizeWeightsData(weightsPos = weightsPos, 
                                                              yWeightPos = yWeightPos,
                                                              equalWeights = equalWeights)
            
            if not scalingList is None:
                yUnique = yUnique * scalingList[i]
                
            weightsDataListSummarized.append((weightsSummarized, yUnique))
            
        return weightsDataListSummarized
    
    #---
    
    elif outputType == 'cumulativeDistribution':
        
        distributionDataList = list()
        
        for i in range(len(weightsDataList)):
            weightsPos, yWeightPos = weightsDataList[i][0], y[weightsDataList[i][1]]
            
            indicesSort = np.argsort(yWeightPos)
            
            weightsPosSorted = weightsPos[indicesSort]
            yWeightPosSorted = yWeightPos[indicesSort]
            
            cumulativeProbs = np.cumsum(weightsPosSorted)
            
            if not scalingList is None:
                yWeightPosSorted = yWeightPosSorted * scalingList[i]
            
            distributionDataList.append((cumulativeProbs, yWeightPosSorted))
            
        return distributionDataList
    
    #---
    
    elif outputType == 'cumulativeDistributionSummarized':
        
        distributionDataList = list()
        
        for i in range(len(weightsDataList)):
            weightsPos, yWeightPos = weightsDataList[i][0], y[weightsDataList[i][1]]
            
            weightsSummarizedSorted, yPosWeightUniqueSorted = summarizeWeightsData(weightsPos = weightsPos, 
                                                                                   yWeightPos = yWeightPos,
                                                                                   equalWeights = equalWeights)
            
            cumulativeProbs = np.cumsum(weightsSummarizedSorted)
            
            if not scalingList is None:
                yPosWeightUniqueSorted = yPosWeightUniqueSorted * scalingList[i]
                
            distributionDataList.append((cumulativeProbs, yPosWeightUniqueSorted))
            
        return distributionDataList
    

# %% ../nbs/03_utils.ipynb 9
def summarizeWeightsData(weightsPos, yWeightPos, equalWeights = False):
    
    if equalWeights:
        counterDict = Counter(yWeightPos)
        yUniqueSorted = np.sort(list(counterDict.keys()))

        weightsSummarizedSorted = np.array([counterDict[value] / len(yWeightPos) for value in yUniqueSorted])
    
    else:
        duplicationDict = defaultdict(list)

        for i, yValue in enumerate(yWeightPos):
            duplicationDict[yValue].append(i)

        #---

        weightsSummarized = list()
        yUnique = list()

        for value, indices in duplicationDict.items():        

            weightsSummarized.append(weightsPos[indices].sum())
            yUnique.append(value)

        weightsSummarized, yUnique = np.array(weightsSummarized), np.array(yUnique)

        #---

        indicesSort = np.argsort(yUnique)
        weightsSummarizedSorted, yUniqueSorted = weightsSummarized[indicesSort], yUnique[indicesSort]
    
    return weightsSummarizedSorted, yUniqueSorted

# %% ../nbs/03_utils.ipynb 11
# This function creates the cross-validation folds for every time series. Usually you'd want all test-observations 
# of each fold to refer to the same time period, but this is impossible to ensure in the case of the two-step models,
# because the regression of the non-zero observations will always contain data of different time points. For that
# reason, we refrain from trying to ensure this consistency.
# Instead we organize our splits such that we always move a fixed amount of observations into the future from split
# to split for every time series. This fixed amount of observations is currently set to the test length of the
# corresponding time series.

# In case this function is supposed to be used in the two-step case, data simply has to be filtered before hand
# to only contain positive demand observations.

def groupedTimeSeriesSplit(data, kFolds, testLength, groupFeature, timeFeature):
    
    # We reset the index because we have to access 'group.index' later on and
    # want to make sure that we return the implicit numerical indices for our splits.
    data = data.reset_index(drop = True)

    dataGrouped = data.groupby(groupFeature)
    splitNumbers = np.flip(np.array(range(kFolds)))
    
    foldsList = list()

    for i in splitNumbers:

        trainIndicesList = list()
        valIndicesList = list()

        valIndicesDict = dict()

        for name, group in dataGrouped:

            timeMin = int(group[timeFeature].min())
            timeMax = int(group[timeFeature].max())

            validationTimeMax = timeMax - i * testLength
            trainTimeMax = validationTimeMax - testLength

            trainTimesGroup = np.array(range(timeMin, trainTimeMax + 1))
            valTimesGroup = np.array(range(trainTimeMax + 1, validationTimeMax + 1))

            trainIndicesCheck = [timePoint in trainTimesGroup for timePoint in group[timeFeature]]
            valIndicesCheck = [timePoint in valTimesGroup for timePoint in group[timeFeature]]

            trainIndicesGroup = group.index[trainIndicesCheck]
            valIndicesGroup = group.index[valIndicesCheck]

            trainIndicesList.append(trainIndicesGroup)
            valIndicesList.append(valIndicesGroup)

        trainIndices = np.concatenate(trainIndicesList)
        valIndices = np.concatenate(valIndicesList)
        fold = (trainIndices, valIndices)

        foldsList.append(fold)

    return foldsList

# %% ../nbs/03_utils.ipynb 13
def generateFinalOutput(dataOriginal, 
                        dataDecisions, 
                        targetVariable = 'demand', 
                        mergeOn = None, 
                        variablesToAdd = None, 
                        scaleBy = None, 
                        includeTraining = False, 
                        sortBy = None,
                        longFormat = False,
                        **kwargs):
    
    dataOriginal = dataOriginal.rename(columns = {targetVariable: 'actuals'})
    
    if not scaleBy is None:
        if not isinstance(scaleBy, str): 
            raise ValueError("'scaleBy' has to a string specifying a single feature to scale the target variable!")
        elif scaleBy in dataOriginal.columns:
            dataOriginal['actuals'] = dataOriginal['actuals'] * dataOriginal[scaleBy]
        else:
            raise ValueError(f"The specified feature {scaleBy} is not part of 'dataOriginal'!")
    
    #---
    
    # Adding additional data to the matrix dataDecisions
    # NOTE: This function is written to be useable for all datasets we currently use. 
    colsToAdd = ['id', 'sku_code_prefix', 'sku_code', 'SKU_API',
                 'actuals', 'revenue', 'label',
                 'adi', 'adi_sku', 'adi_product', 'cv2', 'cvDemand_sku', 'cvDemand_product']
    
    if isinstance(mergeOn, list):
        colsToAdd = colsToAdd + mergeOn
    else:
        colsToAdd.append(mergeOn)
    
    if isinstance(variablesToAdd, list):
        colsToAdd = colsToAdd + variablesToAdd
    else:
        colsToAdd.append(variablesToAdd)
        
    if isinstance(sortBy, list):
        colsToAdd = colsToAdd + sortBy
    else:
        colsToAdd.append(sortBy)
    
    colsToAdd = pd.Series(colsToAdd)
    colsToAdd = colsToAdd[colsToAdd.isin(dataOriginal.columns)] 
    colsToAdd = colsToAdd.unique()
    
    dataTestInfoToAdd = dataOriginal.loc[dataOriginal['label'] == 'test', colsToAdd].reset_index(drop = True)
    
    if not longFormat:

        if mergeOn is None:
            dataResults = pd.concat([dataTestInfoToAdd, dataDecisions.reset_index(drop = True)], axis = 1)
        else:
            dataResults = pd.merge(dataTestInfoToAdd, dataDecisions, on = mergeOn)

        #---
    
    #---
    
    else:
        
        dataDecisionsStacked = dataDecisions.stack().reset_index().set_index('level_0')
        dataDecisionsStacked.rename(columns = {'level_1': 'decisionType'}, inplace = True)
        
        dataDecisionsStacked.rename(columns = {0: 'decisions'}, inplace = True)
        dataDecisionsStacked.reset_index(drop = True, inplace = True)
        
        numberOfDecisionTypes = len(dataDecisionsStacked['decisionType'].unique())
        
        infoDuplicatedDf = dataTestInfoToAdd.loc[dataTestInfoToAdd.index.repeat(numberOfDecisionTypes)]
        infoDuplicatedDf.reset_index(drop = True, inplace = True)
        
        dataResults = pd.concat([infoDuplicatedDf, dataDecisionsStacked], axis = 1)
        
    #---
    
    infoToAdd = pd.DataFrame(kwargs, index = [0])
    infoToAdd['label'] = 'test'
    dataResults = pd.merge(dataResults, infoToAdd, on = 'label')
    
    #---
    
    if includeTraining:
        dataTrainInfoToAdd = dataOriginal.loc[dataOriginal['label'] == 'train', colsToAdd].reset_index(drop = True)
        dataResults = pd.concat([dataTrainInfoToAdd, dataResults], axis = 0).reset_index(drop = True)
            
    #---
    
    if not sortBy is None:
        
        if not all([sortByCol in dataResults.columns for sortByCol in sortBy]):
            raise ValueError("Columns specified by 'sortBy' must be part of 'dataOriginal'!")
        else:
            dataResults.sort_values(by = sortBy, axis = 0, inplace = True, ignore_index = True)
    
    return dataResults
