# AUTOGENERATED! DO NOT EDIT! File to edit: ../nbs/00_baseClasses.ipynb.

# %% ../nbs/00_baseClasses.ipynb 5
from __future__ import annotations
from fastcore.docments import *
from fastcore.test import *
from fastcore.utils import *

from sklearn.base import BaseEstimator

from abc import ABC, abstractmethod
import pandas as pd
import numpy as np
from collections import Counter, defaultdict

# %% auto 0
__all__ = ['BaseWeightsBasedEstimator', 'restructureWeightsDataList', 'summarizeWeightsData']

# %% ../nbs/00_baseClasses.ipynb 7
class BaseWeightsBasedEstimator(BaseEstimator, ABC):
    """ 
    Base class that implements the 'prediction'-method for approaches based 
    on a reweighting of the empirical distribution.
    """
    
    # @abstractmethod
    # def getWeights(self, X):
    #     """Compute weights for every sample specified by feature matrix 'X'"""
    #     pass

    # def predictQuantiles(self: BasePredictor, 
    #                      X: np.ndarray, # Feature matrix of samples for which conditional quantiles are computed.
    #                      probs: list | np.ndarray = [0.1, 0.5, 0.9], # Probabilities for which the estimated conditional p-quantiles are computed.
    #                      outputAsDf: bool = False, # Output is either a dataframe with 'probs' as cols or a dict with 'probs' as keys.
    #                      scalingList: list | np.ndarray | None = None, # List or array with same size as self.Y containing floats being multiplied with self.Y.
    #                      ):
    
    def predict(self, 
                X,
                probs = [0.1, 0.5, 0.9], 
                outputAsDf = False, 
                scalingList = None, 
                **kwargs):
        
        distributionDataList = self.getWeights(X = X,
                                               outputType = 'cumulativeDistribution',
                                               scalingList = scalingList,
                                               **kwargs)

        quantilesDict = {prob: [] for prob in probs}

        for probsDistributionFunction, yDistributionFunction in distributionDataList:

            for prob in probs:
                
                quantileIndex = np.where(probsDistributionFunction >= prob)[0][0]
                    
                quantile = yDistributionFunction[quantileIndex]
                quantilesDict[prob].append(quantile)

        quantilesDf = pd.DataFrame(quantilesDict)

        # Just done to make the dictionary contain arrays rather than lists of the quantiles.
        quantilesDict = {prob: np.array(quantiles) for prob, quantiles in quantilesDict.items()}

        #---

        if outputAsDf:
            return quantilesDf

        else:
            return quantilesDict
    

# %% ../nbs/00_baseClasses.ipynb 12
def restructureWeightsDataList(weightsDataList, outputType = 'onlyPositiveWeights', y = None, scalingList = None, equalWeights = False):
    
    if outputType == 'all':
        
        weightsDataListAll = list()
        
        for weights, indicesPosWeight in weightsDataList:
            weightsAll = np.zeros(len(y))
            weightsAll[indicesPosWeight] = weights
            weightsDataListAll.append(weightsAll)
        
        return weightsDataListAll
    
    #---
    
    elif outputType == 'onlyPositiveWeights':
        
        return weightsDataList
    
    #---
    
    elif outputType == 'summarized':
        
        weightsDataListSummarized = list()

        for i in range(len(weightsDataList)):
            weightsPos, yWeightPos = weightsDataList[i][0], y[weightsDataList[i][1]]
            
            weightsSummarized, yUnique = summarizeWeightsData(weightsPos = weightsPos, 
                                                              yWeightPos = yWeightPos,
                                                              equalWeights = equalWeights)
            
            if not scalingList is None:
                yUnique = yUnique * scalingList[i]
                
            weightsDataListSummarized.append((weightsSummarized, yUnique))
            
        return weightsDataListSummarized
    
    #---
    
    elif outputType == 'cumulativeDistribution':
        
        distributionDataList = list()
        
        for i in range(len(weightsDataList)):
            weightsPos, yWeightPos = weightsDataList[i][0], y[weightsDataList[i][1]]
            
            indicesSort = np.argsort(yWeightPos)
            
            weightsPosSorted = weightsPos[indicesSort]
            yWeightPosSorted = yWeightPos[indicesSort]
            
            cumulativeProbs = np.cumsum(weightsPosSorted)
            
            if not scalingList is None:
                yWeightPosSorted = yWeightPosSorted * scalingList[i]
            
            distributionDataList.append((cumulativeProbs, yWeightPosSorted))
            
        return distributionDataList
    
    #---
    
    elif outputType == 'cumulativeDistributionSummarized':
        
        distributionDataList = list()
        
        for i in range(len(weightsDataList)):
            weightsPos, yWeightPos = weightsDataList[i][0], y[weightsDataList[i][1]]
            
            weightsSummarizedSorted, yPosWeightUniqueSorted = summarizeWeightsData(weightsPos = weightsPos, 
                                                                                   yWeightPos = yWeightPos,
                                                                                   equalWeights = equalWeights)
            
            cumulativeProbs = np.cumsum(weightsSummarizedSorted)
            
            if not scalingList is None:
                yPosWeightUniqueSorted = yPosWeightUniqueSorted * scalingList[i]
                
            distributionDataList.append((cumulativeProbs, yPosWeightUniqueSorted))
            
        return distributionDataList
    

# %% ../nbs/00_baseClasses.ipynb 14
def summarizeWeightsData(weightsPos, yWeightPos, equalWeights = False):
    
    if equalWeights:
        counterDict = Counter(yWeightPos)
        yUniqueSorted = np.sort(list(counterDict.keys()))

        weightsSummarizedSorted = np.array([counterDict[value] / len(yWeightPos) for value in yUniqueSorted])
    
    else:
        duplicationDict = defaultdict(list)

        for i, yValue in enumerate(yWeightPos):
            duplicationDict[yValue].append(i)

        #---

        weightsSummarized = list()
        yUnique = list()

        for value, indices in duplicationDict.items():        

            weightsSummarized.append(weightsPos[indices].sum())
            yUnique.append(value)

        weightsSummarized, yUnique = np.array(weightsSummarized), np.array(yUnique)

        #---

        indicesSort = np.argsort(yUnique)
        weightsSummarizedSorted, yUniqueSorted = weightsSummarized[indicesSort], yUnique[indicesSort]
    
    return weightsSummarizedSorted, yUniqueSorted
