"use strict";
var _a, _b, _c, _d, _e, _f, _g;
Object.defineProperty(exports, "__esModule", { value: true });
exports.VehicleModel = exports.CanDefinition = exports.NetworkFileDefinition = exports.CanVehicleSignal = exports.VehicleSignal = exports.CanVehicleInterface = exports.VehicleInterface = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("aws-cdk-lib");
const constructs_1 = require("constructs");
const handler_1 = require("./handler");
const provider_1 = require("./provider");
class VehicleInterface {
    constructor() {
        this.intf = {};
    }
    toObject() {
        return (this.intf);
    }
}
exports.VehicleInterface = VehicleInterface;
_a = JSII_RTTI_SYMBOL_1;
VehicleInterface[_a] = { fqn: "cdk-aws-iotfleetwise.VehicleInterface", version: "0.2.12" };
class CanVehicleInterface extends VehicleInterface {
    constructor(interfaceId, name) {
        super();
        this.intf = {
            type: 'CAN_INTERFACE',
            interfaceId,
            canInterface: {
                name: name,
                protocolName: 'CAN',
                protocolVersion: '2.0b',
            },
        };
    }
}
exports.CanVehicleInterface = CanVehicleInterface;
_b = JSII_RTTI_SYMBOL_1;
CanVehicleInterface[_b] = { fqn: "cdk-aws-iotfleetwise.CanVehicleInterface", version: "0.2.12" };
class VehicleSignal {
    constructor() {
        this.signal = {};
    }
    toObject() {
        return (this.signal);
    }
}
exports.VehicleSignal = VehicleSignal;
_c = JSII_RTTI_SYMBOL_1;
VehicleSignal[_c] = { fqn: "cdk-aws-iotfleetwise.VehicleSignal", version: "0.2.12" };
class CanVehicleSignal extends VehicleSignal {
    constructor(fullyQualifiedName, interfaceId, messageId, factor, isBigEndian, isSigned, length, offset, startBit) {
        super();
        this.signal = {
            type: 'CAN_SIGNAL',
            fullyQualifiedName,
            interfaceId,
            canSignal: {
                factor,
                isBigEndian,
                isSigned,
                length,
                messageId,
                offset,
                startBit,
            },
        };
    }
}
exports.CanVehicleSignal = CanVehicleSignal;
_d = JSII_RTTI_SYMBOL_1;
CanVehicleSignal[_d] = { fqn: "cdk-aws-iotfleetwise.CanVehicleSignal", version: "0.2.12" };
class NetworkFileDefinition {
    constructor() {
        this.definition = {};
    }
    toObject() {
        return (this.definition);
    }
}
exports.NetworkFileDefinition = NetworkFileDefinition;
_e = JSII_RTTI_SYMBOL_1;
NetworkFileDefinition[_e] = { fqn: "cdk-aws-iotfleetwise.NetworkFileDefinition", version: "0.2.12" };
class CanDefinition extends NetworkFileDefinition {
    constructor(networkInterface, signalsMap, canDbcFiles) {
        super();
        this.definition = {
            canDbc: {
                canDbcFiles: canDbcFiles.map(file => Buffer.from(file).toString('base64')),
                networkInterface,
                signalsMap,
            },
        };
    }
}
exports.CanDefinition = CanDefinition;
_f = JSII_RTTI_SYMBOL_1;
CanDefinition[_f] = { fqn: "cdk-aws-iotfleetwise.CanDefinition", version: "0.2.12" };
class VehicleModel extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.name = '';
        this.signalCatalog = {};
        this.name = props.name || '';
        this.signalCatalog = props.signalCatalog;
        const handler = new handler_1.Handler(this, 'Handler', {
            handler: 'vehiclemodelhandler.on_event',
        });
        const resource = new cdk.CustomResource(this, 'Resource', {
            serviceToken: provider_1.Provider.getOrCreate(this, handler).provider.serviceToken,
            properties: {
                name: this.name,
                signal_catalog_arn: props.signalCatalog.arn,
                model_manifest_arn: `arn:aws:iotfleetwise:${cdk.Aws.REGION}:${cdk.Aws.ACCOUNT_ID}:model-manifest/${this.name}`,
                description: props.description,
                network_interfaces: JSON.stringify(props.networkInterfaces.map(i => i.toObject())),
                signals: (props.signals) ? JSON.stringify(props.signals.map(s => s.toObject())) : '{}',
                network_file_definitions: (props.networkFileDefinitions) ? JSON.stringify(props.networkFileDefinitions.map(s => s.toObject())) : '{}',
            },
        });
        resource.node.addDependency(this.signalCatalog);
    }
}
exports.VehicleModel = VehicleModel;
_g = JSII_RTTI_SYMBOL_1;
VehicleModel[_g] = { fqn: "cdk-aws-iotfleetwise.VehicleModel", version: "0.2.12" };
//# sourceMappingURL=data:application/json;base64,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