import { Construct } from 'constructs';
import { VehicleModel } from './vehiclemodel';
/**
 * Interface
 */
export interface VehicleProps {
    readonly vehicleModel: VehicleModel;
    readonly vehicleName: string;
    readonly createIotThing: boolean;
}
/**
 * The vehicle of a specific type from which IoT FleetWise collect signals.
 */
export declare class Vehicle extends Construct {
    readonly arn: string;
    readonly vehicleModel: VehicleModel;
    readonly vehicleName: string;
    readonly endpointAddress?: string;
    readonly certificateId?: string;
    readonly certificateArn?: string;
    readonly certificatePem?: string;
    readonly privateKey?: string;
    constructor(scope: Construct, id: string, props: VehicleProps);
}
