"use strict";
var _a, _b, _c, _d;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SignalCatalog = exports.SignalCatalogSensor = exports.SignalCatalogBranch = exports.SignalCatalogNode = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("aws-cdk-lib");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
const handler_1 = require("./handler");
const provider_1 = require("./provider");
class SignalCatalogNode {
    constructor() {
        this.node = {};
    }
    toObject() {
        return (this.node);
    }
}
exports.SignalCatalogNode = SignalCatalogNode;
_a = JSII_RTTI_SYMBOL_1;
SignalCatalogNode[_a] = { fqn: "cdk-aws-iotfleetwise.SignalCatalogNode", version: "0.2.12" };
class SignalCatalogBranch extends SignalCatalogNode {
    constructor(fullyQualifiedName, description) {
        super();
        this.node = {
            branch: {
                fullyQualifiedName: fullyQualifiedName,
                ...description && { description },
            },
        };
    }
}
exports.SignalCatalogBranch = SignalCatalogBranch;
_b = JSII_RTTI_SYMBOL_1;
SignalCatalogBranch[_b] = { fqn: "cdk-aws-iotfleetwise.SignalCatalogBranch", version: "0.2.12" };
class SignalCatalogSensor extends SignalCatalogNode {
    constructor(fullyQualifiedName, dataType, unit, min, max, description) {
        super();
        this.node = {
            sensor: {
                fullyQualifiedName,
                dataType,
                ...unit && { unit },
                ...min && { min },
                ...max && { max },
                ...description && { description },
            },
        };
    }
}
exports.SignalCatalogSensor = SignalCatalogSensor;
_c = JSII_RTTI_SYMBOL_1;
SignalCatalogSensor[_c] = { fqn: "cdk-aws-iotfleetwise.SignalCatalogSensor", version: "0.2.12" };
/**
 * The Signal Catalog represents the list of all signals that you want to collect from all
 * the vehicles.
 *
 *
 * The AWS IoT Fleetwise preview can only support a single Signal Catalog per account.
 *
 */
class SignalCatalog extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.name = props.name || 'default';
        this.description = props.description;
        this.arn = `arn:aws:iotfleetwise:${cdk.Aws.REGION}:${cdk.Aws.ACCOUNT_ID}:signal-catalog/${this.name}`;
        const handler = new handler_1.Handler(this, 'Handler', {
            handler: 'servicehandler.on_event',
        });
        const isCompleteHandler = new handler_1.Handler(this, 'IsCompleteHandler', {
            handler: 'servicehandler.is_complete',
        });
        handler.role.addToPrincipalPolicy(new aws_cdk_lib_1.aws_iam.PolicyStatement({
            effect: aws_cdk_lib_1.aws_iam.Effect.ALLOW,
            actions: [
                'iam:PassRole',
            ],
            resources: [props.role.roleArn],
        }));
        const provider = provider_1.Provider.getOrCreate(this, handler, isCompleteHandler);
        const serviceResource = new cdk.CustomResource(this, 'ServiceResource', {
            serviceToken: provider.provider.serviceToken,
            properties: {
                role_arn: props.role.roleArn,
                database_name: props.database.databaseName,
                table_name: props.table.tableName,
            },
        });
        const serviceCatalogHandler = new handler_1.Handler(this, 'ServiceCatalogHandler', {
            handler: 'signalcataloghandler.on_event',
        });
        const resourceCatalog = new cdk.CustomResource(this, 'CatalogResource', {
            serviceToken: provider_1.Provider.getOrCreate(this, serviceCatalogHandler).provider.serviceToken,
            properties: {
                name: this.name,
                description: this.description,
                nodes: JSON.stringify(props.nodes.map(node => node.toObject())),
            },
        });
        resourceCatalog.node.addDependency(serviceResource);
    }
}
exports.SignalCatalog = SignalCatalog;
_d = JSII_RTTI_SYMBOL_1;
SignalCatalog[_d] = { fqn: "cdk-aws-iotfleetwise.SignalCatalog", version: "0.2.12" };
//# sourceMappingURL=data:application/json;base64,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