import { aws_iam as iam, aws_timestream as ts } from 'aws-cdk-lib';
import { Construct } from 'constructs';
export declare class SignalCatalogNode {
    protected node: object;
    constructor();
    toObject(): object;
}
export declare class SignalCatalogBranch extends SignalCatalogNode {
    constructor(fullyQualifiedName: string, description?: string);
}
export declare class SignalCatalogSensor extends SignalCatalogNode {
    constructor(fullyQualifiedName: string, dataType: string, unit?: string, min?: number, max?: number, description?: string);
}
export interface SignalCatalogProps {
    readonly name?: string;
    readonly description?: string;
    readonly role: iam.Role;
    readonly database: ts.CfnDatabase;
    readonly table: ts.CfnTable;
    readonly nodes: SignalCatalogNode[];
}
/**
 * The Signal Catalog represents the list of all signals that you want to collect from all
 * the vehicles.
 *
 *
 * The AWS IoT Fleetwise preview can only support a single Signal Catalog per account.
 *
 */
export declare class SignalCatalog extends Construct {
    /**
     * The name of the signal catalog
     */
    readonly name: string;
    readonly description: (string | undefined);
    readonly arn: string;
    constructor(scope: Construct, id: string, props: SignalCatalogProps);
}
