"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.IntegTesting = void 0;
const fs = require("fs");
const path = require("path");
const cdk = require("aws-cdk-lib");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const ifw = require(".");
class IntegTesting {
    constructor() {
        const app = new cdk.App();
        const env = {
            region: process.env.CDK_INTEG_REGION || process.env.CDK_DEFAULT_REGION || 'us-east-1',
            account: process.env.CDK_INTEG_ACCOUNT || process.env.CDK_DEFAULT_ACCOUNT,
        };
        const stack = new cdk.Stack(app, 'integ-stack', { env });
        const databaseName = 'FleetWise';
        const tableName = 'FleetWise';
        const database = new aws_cdk_lib_1.aws_timestream.CfnDatabase(stack, 'Database', {
            databaseName,
        });
        const table = new aws_cdk_lib_1.aws_timestream.CfnTable(stack, 'Table', {
            databaseName,
            tableName,
        });
        table.node.addDependency(database);
        const role = new aws_cdk_lib_1.aws_iam.Role(stack, 'Role', {
            roleName: 'iotfleetwise-role',
            assumedBy: new aws_cdk_lib_1.aws_iam.ServicePrincipal('iotfleetwise.amazonaws.com'),
        });
        role.addToPolicy(new aws_cdk_lib_1.aws_iam.PolicyStatement({
            effect: aws_cdk_lib_1.aws_iam.Effect.ALLOW,
            actions: [
                'timestream:WriteRecords',
                'timestream:Select',
            ],
            resources: ['*'],
        }));
        role.addToPolicy(new aws_cdk_lib_1.aws_iam.PolicyStatement({
            effect: aws_cdk_lib_1.aws_iam.Effect.ALLOW,
            actions: [
                'timestream:DescribeEndpoints',
            ],
            resources: ['*'],
        }));
        const canDbc = fs.readFileSync(path.join(__dirname, '/../hscan.dbc'), 'utf8');
        const nodes = [new ifw.SignalCatalogBranch('Vehicle', 'Vehicle')];
        canDbc.split('\n').filter(line => /^\s+SG_\s+\w+/.test(line)).map(line => {
            const signal_name = line.split(/\s+/)[2];
            nodes.push(new ifw.SignalCatalogSensor(`Vehicle.${signal_name}`, 'DOUBLE'));
        });
        const signalCatalog = new ifw.SignalCatalog(stack, 'SignalCatalog', {
            database,
            table,
            role,
            description: 'my signal catalog',
            nodes,
        });
        const signalsMap = {};
        canDbc.split('\n').filter(line => /^\s+SG_\s+\w+/.test(line)).map(line => {
            const signal_name = line.split(/\s+/)[2];
            signalsMap[signal_name] = `Vehicle.${signal_name}`;
        });
        const model_a = new ifw.VehicleModel(stack, 'ModelA', {
            signalCatalog,
            name: 'modelA',
            description: 'Model A vehicle',
            networkInterfaces: [new ifw.CanVehicleInterface('1', 'vcan0')],
            networkFileDefinitions: [new ifw.CanDefinition('1', signalsMap, [canDbc])],
        });
        const vin100 = new ifw.Vehicle(stack, 'vin100', {
            vehicleName: 'vin100',
            vehicleModel: model_a,
            createIotThing: true,
        });
        new cdk.CfnOutput(stack, 'certificateId', { value: vin100.certificateId });
        new ifw.Fleet(stack, 'fleet1', {
            fleetId: 'fleet1',
            signalCatalog: signalCatalog,
            description: 'my fleet1',
            vehicles: [vin100],
        });
        this.stack = [stack];
    }
}
exports.IntegTesting = IntegTesting;
new IntegTesting();
//# sourceMappingURL=data:application/json;base64,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