"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const monocdk_1 = require("monocdk");
const aws_kms_1 = require("monocdk/aws-kms");
/**
 * KMS Symmetric CMKs have Key Rotation enabled
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_kms_1.CfnKey) {
        const keySpec = monocdk_1.Stack.of(node).resolve(node.keySpec);
        if (keySpec == undefined || keySpec == aws_kms_1.KeySpec.SYMMETRIC_DEFAULT) {
            const enableKeyRotation = monocdk_1.Stack.of(node).resolve(node.enableKeyRotation);
            if (enableKeyRotation == undefined || !enableKeyRotation) {
                return false;
            }
        }
    }
    return true;
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiS01TNS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uL3NyYy9Bd3NTb2x1dGlvbnMvcnVsZXMvc2VjdXJpdHlfYW5kX2NvbXBsaWFuY2UvS01TNS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOztBQUFBOzs7RUFHRTtBQUNGLHFDQUE0QztBQUM1Qyw2Q0FBa0Q7QUFFbEQ7OztHQUdHO0FBQ0gsbUJBQXlCLElBQWdCO0lBQ3ZDLElBQUksSUFBSSxZQUFZLGdCQUFNLEVBQUU7UUFDMUIsTUFBTSxPQUFPLEdBQUcsZUFBSyxDQUFDLEVBQUUsQ0FBQyxJQUFJLENBQUMsQ0FBQyxPQUFPLENBQUMsSUFBSSxDQUFDLE9BQU8sQ0FBQyxDQUFDO1FBQ3JELElBQUksT0FBTyxJQUFJLFNBQVMsSUFBSSxPQUFPLElBQUksaUJBQU8sQ0FBQyxpQkFBaUIsRUFBRTtZQUNoRSxNQUFNLGlCQUFpQixHQUFHLGVBQUssQ0FBQyxFQUFFLENBQUMsSUFBSSxDQUFDLENBQUMsT0FBTyxDQUFDLElBQUksQ0FBQyxpQkFBaUIsQ0FBQyxDQUFDO1lBQ3pFLElBQUksaUJBQWlCLElBQUksU0FBUyxJQUFJLENBQUMsaUJBQWlCLEVBQUU7Z0JBQ3hELE9BQU8sS0FBSyxDQUFDO2FBQ2Q7U0FDRjtLQUNGO0lBQ0QsT0FBTyxJQUFJLENBQUM7QUFDZCxDQUFDO0FBWEQsNEJBV0MiLCJzb3VyY2VzQ29udGVudCI6WyIvKlxuQ29weXJpZ2h0IEFtYXpvbi5jb20sIEluYy4gb3IgaXRzIGFmZmlsaWF0ZXMuIEFsbCBSaWdodHMgUmVzZXJ2ZWQuXG5TUERYLUxpY2Vuc2UtSWRlbnRpZmllcjogQXBhY2hlLTIuMFxuKi9cbmltcG9ydCB7IElDb25zdHJ1Y3QsIFN0YWNrIH0gZnJvbSAnbW9ub2Nkayc7XG5pbXBvcnQgeyBDZm5LZXksIEtleVNwZWMgfSBmcm9tICdtb25vY2RrL2F3cy1rbXMnO1xuXG4vKipcbiAqIEtNUyBTeW1tZXRyaWMgQ01LcyBoYXZlIEtleSBSb3RhdGlvbiBlbmFibGVkXG4gKiBAcGFyYW0gbm9kZSB0aGUgQ2ZuUmVzb3VyY2UgdG8gY2hlY2tcbiAqL1xuZXhwb3J0IGRlZmF1bHQgZnVuY3Rpb24gKG5vZGU6IElDb25zdHJ1Y3QpOiBib29sZWFuIHtcbiAgaWYgKG5vZGUgaW5zdGFuY2VvZiBDZm5LZXkpIHtcbiAgICBjb25zdCBrZXlTcGVjID0gU3RhY2sub2Yobm9kZSkucmVzb2x2ZShub2RlLmtleVNwZWMpO1xuICAgIGlmIChrZXlTcGVjID09IHVuZGVmaW5lZCB8fCBrZXlTcGVjID09IEtleVNwZWMuU1lNTUVUUklDX0RFRkFVTFQpIHtcbiAgICAgIGNvbnN0IGVuYWJsZUtleVJvdGF0aW9uID0gU3RhY2sub2Yobm9kZSkucmVzb2x2ZShub2RlLmVuYWJsZUtleVJvdGF0aW9uKTtcbiAgICAgIGlmIChlbmFibGVLZXlSb3RhdGlvbiA9PSB1bmRlZmluZWQgfHwgIWVuYWJsZUtleVJvdGF0aW9uKSB7XG4gICAgICAgIHJldHVybiBmYWxzZTtcbiAgICAgIH1cbiAgICB9XG4gIH1cbiAgcmV0dXJuIHRydWU7XG59XG4iXX0=