"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const monocdk_1 = require("monocdk");
const aws_cognito_1 = require("monocdk/aws-cognito");
/**
 * Cognito user pools have password policies that minimally specify a password length of at least 8 characters, as well as requiring uppercase, numeric, and special characters
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_cognito_1.CfnUserPool) {
        const policies = monocdk_1.Stack.of(node).resolve(node.policies);
        if (policies == undefined) {
            return false;
        }
        const passwordPolicy = monocdk_1.Stack.of(node).resolve(policies.passwordPolicy);
        if (passwordPolicy == undefined) {
            return false;
        }
        const minimumLength = monocdk_1.Stack.of(node).resolve(passwordPolicy.minimumLength);
        if (minimumLength == undefined || minimumLength < 8) {
            return false;
        }
        const requireUppercase = monocdk_1.Stack.of(node).resolve(passwordPolicy.requireUppercase);
        if (minimumLength == undefined || !requireUppercase) {
            return false;
        }
        const requireNumbers = monocdk_1.Stack.of(node).resolve(passwordPolicy.requireNumbers);
        if (requireNumbers == undefined || !requireNumbers) {
            return false;
        }
        const requireSymbols = monocdk_1.Stack.of(node).resolve(passwordPolicy.requireSymbols);
        if (requireSymbols == undefined || !requireSymbols) {
            return false;
        }
    }
    return true;
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,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