"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const monocdk_1 = require("monocdk");
const aws_elasticloadbalancing_1 = require("monocdk/aws-elasticloadbalancing");
/**
 * ELB listeners should be configured for secure (HTTPs or SSL) protocols for client communication.
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_elasticloadbalancing_1.CfnLoadBalancer) {
        const listeners = monocdk_1.Stack.of(node).resolve(node.listeners);
        for (const listener of listeners) {
            const resolvedListener = monocdk_1.Stack.of(node).resolve(listener);
            if (resolvedListener.protocol.toLowerCase() == 'ssl') {
                if (!(resolvedListener.instanceProtocol == undefined ||
                    resolvedListener.instanceProtocol.toLowerCase() == 'ssl')) {
                    return false;
                }
            }
            else if (resolvedListener.protocol.toLowerCase() == 'https') {
                if (!(resolvedListener.instanceProtocol == undefined ||
                    resolvedListener.instanceProtocol.toLowerCase() == 'https')) {
                    return false;
                }
            }
        }
    }
    return true;
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,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