"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const monocdk_1 = require("monocdk");
const aws_elasticsearch_1 = require("monocdk/aws-elasticsearch");
/**
 * ES domains have encryption at rest enabled
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_elasticsearch_1.CfnDomain) {
        const encryptionAtRestOptions = monocdk_1.Stack.of(node).resolve(node.encryptionAtRestOptions);
        if (encryptionAtRestOptions == undefined) {
            return false;
        }
        const enabled = monocdk_1.Stack.of(node).resolve(encryptionAtRestOptions.enabled);
        if (!enabled) {
            return false;
        }
    }
    return true;
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiRVNIOC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uL3NyYy9Bd3NTb2x1dGlvbnMvcnVsZXMvYW5hbHl0aWNzL0VTSDgudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7QUFBQTs7O0VBR0U7QUFDRixxQ0FBNEM7QUFDNUMsaUVBQXNEO0FBRXREOzs7R0FHRztBQUNILG1CQUF5QixJQUFnQjtJQUN2QyxJQUFJLElBQUksWUFBWSw2QkFBUyxFQUFFO1FBQzdCLE1BQU0sdUJBQXVCLEdBQUcsZUFBSyxDQUFDLEVBQUUsQ0FBQyxJQUFJLENBQUMsQ0FBQyxPQUFPLENBQ3BELElBQUksQ0FBQyx1QkFBdUIsQ0FDN0IsQ0FBQztRQUNGLElBQUksdUJBQXVCLElBQUksU0FBUyxFQUFFO1lBQ3hDLE9BQU8sS0FBSyxDQUFDO1NBQ2Q7UUFDRCxNQUFNLE9BQU8sR0FBRyxlQUFLLENBQUMsRUFBRSxDQUFDLElBQUksQ0FBQyxDQUFDLE9BQU8sQ0FBQyx1QkFBdUIsQ0FBQyxPQUFPLENBQUMsQ0FBQztRQUN4RSxJQUFJLENBQUMsT0FBTyxFQUFFO1lBQ1osT0FBTyxLQUFLLENBQUM7U0FDZDtLQUNGO0lBQ0QsT0FBTyxJQUFJLENBQUM7QUFDZCxDQUFDO0FBZEQsNEJBY0MiLCJzb3VyY2VzQ29udGVudCI6WyIvKlxuQ29weXJpZ2h0IEFtYXpvbi5jb20sIEluYy4gb3IgaXRzIGFmZmlsaWF0ZXMuIEFsbCBSaWdodHMgUmVzZXJ2ZWQuXG5TUERYLUxpY2Vuc2UtSWRlbnRpZmllcjogQXBhY2hlLTIuMFxuKi9cbmltcG9ydCB7IElDb25zdHJ1Y3QsIFN0YWNrIH0gZnJvbSAnbW9ub2Nkayc7XG5pbXBvcnQgeyBDZm5Eb21haW4gfSBmcm9tICdtb25vY2RrL2F3cy1lbGFzdGljc2VhcmNoJztcblxuLyoqXG4gKiBFUyBkb21haW5zIGhhdmUgZW5jcnlwdGlvbiBhdCByZXN0IGVuYWJsZWRcbiAqIEBwYXJhbSBub2RlIHRoZSBDZm5SZXNvdXJjZSB0byBjaGVja1xuICovXG5leHBvcnQgZGVmYXVsdCBmdW5jdGlvbiAobm9kZTogSUNvbnN0cnVjdCk6IGJvb2xlYW4ge1xuICBpZiAobm9kZSBpbnN0YW5jZW9mIENmbkRvbWFpbikge1xuICAgIGNvbnN0IGVuY3J5cHRpb25BdFJlc3RPcHRpb25zID0gU3RhY2sub2Yobm9kZSkucmVzb2x2ZShcbiAgICAgIG5vZGUuZW5jcnlwdGlvbkF0UmVzdE9wdGlvbnMsXG4gICAgKTtcbiAgICBpZiAoZW5jcnlwdGlvbkF0UmVzdE9wdGlvbnMgPT0gdW5kZWZpbmVkKSB7XG4gICAgICByZXR1cm4gZmFsc2U7XG4gICAgfVxuICAgIGNvbnN0IGVuYWJsZWQgPSBTdGFjay5vZihub2RlKS5yZXNvbHZlKGVuY3J5cHRpb25BdFJlc3RPcHRpb25zLmVuYWJsZWQpO1xuICAgIGlmICghZW5hYmxlZCkge1xuICAgICAgcmV0dXJuIGZhbHNlO1xuICAgIH1cbiAgfVxuICByZXR1cm4gdHJ1ZTtcbn1cbiJdfQ==