"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const monocdk_1 = require("monocdk");
const aws_elasticsearch_1 = require("monocdk/aws-elasticsearch");
/**
 * ES domains only grant access via allowlisted IP addresses
 * @param node the CfnResource to check
 */
function default_1(node) {
    var _a, _b;
    if (node instanceof aws_elasticsearch_1.CfnDomain) {
        const accessPolicies = monocdk_1.Stack.of(node).resolve(node.accessPolicies);
        if (accessPolicies == undefined) {
            return false;
        }
        const statements = accessPolicies === null || accessPolicies === void 0 ? void 0 : accessPolicies.Statement;
        if (statements == undefined || statements.length == 0) {
            return false;
        }
        for (const statement of statements) {
            if (statement.Effect == 'Allow') {
                const allowList = (_b = (_a = statement === null || statement === void 0 ? void 0 : statement.Condition) === null || _a === void 0 ? void 0 : _a.IpAddress) === null || _b === void 0 ? void 0 : _b['aws:sourceIp'];
                if (allowList == undefined || allowList.length == 0) {
                    return false;
                }
            }
        }
    }
    return true;
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,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