# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['deep_translator']

package_data = \
{'': ['*']}

install_requires = \
['beautifulsoup4>=4.9.1,<5.0.0', 'requests>=2.23.0,<3.0.0']

entry_points = \
{'console_scripts': ['deep-translator = deep_translator.__main__:main',
                     'dt = deep_translator.__main__:main']}

setup_kwargs = {
    'name': 'deep-translator',
    'version': '1.8.0',
    'description': 'A flexible free and unlimited python tool to translate between different languages in a simple way using multiple translators',
    'long_description': '##################\ndeep-translator\n##################\n\n.. image:: ../assets/icon.jpg\n    :width: 100\n    :align: center\n    :alt: deep-translator-icon\n\n|\n\n\n.. image:: https://img.shields.io/pypi/v/deep-translator.svg\n        :target: https://pypi.python.org/pypi/deep-translator\n.. image:: https://img.shields.io/travis/nidhaloff/deep-translator.svg\n        :target: https://github.com/nidhaloff/deep-translator/actions/workflows/build.yml\n.. image:: https://readthedocs.org/projects/deep-translator/badge/?version=latest\n        :target: https://deep-translator.readthedocs.io/en/latest/?badge=latest\n        :alt: Documentation Status\n.. image:: https://img.shields.io/pypi/l/deep-translator\n        :target: https://pypi.python.org/pypi/deep-translator\n\n.. image:: https://img.shields.io/pypi/status/deep-translator\n        :target: https://pypi.python.org/pypi/deep-translator\n\n.. image:: https://pepy.tech/badge/deep-translator\n    :target: https://pepy.tech/project/deep-translator\n\n\n.. image:: https://img.shields.io/pypi/wheel/deep-translator\n        :target: https://pypi.python.org/pypi/deep-translator\n\n.. image:: https://img.shields.io/twitter/url?url=https%3A%2F%2Ftwitter.com%2FNidhalBaccouri\n        :alt: Twitter URL\n        :target: https://twitter.com/NidhalBaccouri\n\n\n=======================\nTranslation for humans\n=======================\n\nA flexible **FREE** and **UNLIMITED** tool to translate between different languages in a simple way using multiple translators.\n\n\n* Free software: MIT license\n* Documentation: https://deep-translator.readthedocs.io.\n\n\n|\n|\n\n.. contents:: Table of Contents\n    :depth: 3\n\n|\n|\n\n\n==========\nMotivation\n==========\n\nI needed to translate a text using python. It was hard to find a simple way to do it.\nThere are other libraries that can be used for this task, but most of them\nare **buggy, not free, limited, not supported anymore or complex to use.**\n\nTherefore, I decided to build this simple tool. It is 100% free, unlimited, easy to use and provide\nsupport for all languages.\n\nBasically, my goal was to integrate support for multiple famous translators\nin this tool.\n\n======================\nWhen you should use it\n======================\n\n- If you want to translate text using python\n- If you want to translate from a file\n- If you want to get translations from many sources and not only one\n- If you want to automate translations\n- If you want to compare different translations\n- If you want to detect language automatically\n\n======================\nWhy you should use it\n======================\n\n- It\'s the only python tool that integrates many translators\n- multi language support\n- supports batch translation\n- High level of abstraction\n- Automatic language detection\n- Easy to use and extend\n- Support for most famous universal translators\n- Stable and maintained regularly\n- The API is very easy to use\n- Proxy integration is supported\n\n========\nFeatures\n========\n\n* Support for `google translate <https://translate.google.com/>`_\n* Support for the `microsoft translator <https://www.microsoft.com/en-us/translator//>`_ (version >= 1.3.5)\n* Support for `Pons translator <https://de.pons.com/>`_\n* Support for the `Linguee translator <https://www.linguee.com/>`_\n* Support for the `Mymemory translator <https://mymemory.translated.net/>`_\n* Support for the `Yandex translator <https://yandex.com/>`_ (version >= 1.2.1)\n* Support for the `QcriTranslator translator <https://mt.qcri.org/api/>`_ (version >= 1.2.4)\n* Support for the `DeeplTranslator translator <https://www.deepl.com/en/translator/>`_ (version >= 1.2.5)\n* Support for the `Papago translator <https://papago.naver.com/>`_ (version >= 1.4.4)\n* Support for the `Libre translator <https://libretranslate.com/>`_\n* Support for proxy usage\n* Automatic single language detection\n* Batch language detection\n* Translate directly from a text file\n* Get multiple translation for a word\n* Automate the translation of different paragraphs in different languages\n* Translate directly from terminal (version >= 1.1.0)\n\n=============\nInstallation\n=============\n\nInstall the stable release:\n\n.. code-block:: console\n\n    $ pip install -U deep-translator\n\ntake a look at the docs if you want to install from source.\n\n============\nQuick Start\n============\n\n.. code-block:: python\n\n    from deep_translator import GoogleTranslator\n    translated = GoogleTranslator(source=\'auto\', target=\'de\').translate("keep it up, you are awesome")  # output -> Weiter so, du bist großartig\n\nor using proxies:\n\n.. code-block:: python\n\n    from deep_translator import GoogleTranslator\n\n    proxies_example = {\n        "https": "34.195.196.27:8080",\n        "http": "34.195.196.27:8080"\n    }\n    translated = GoogleTranslator(source=\'auto\', target=\'de\', proxies=proxies_example).translate("keep it up, you are awesome")  # output -> Weiter so, du bist großartig\n\n\nor even directly from terminal:\n\n.. code-block:: console\n\n    $ deep-translator --source "en" --target "de" --text "hello world"\n\n    or shorter\n\n    $ dt -tg de -txt "hello world"\n\n\n=====\nUsage\n=====\n\nIn this section, demos on how to use all different integrated translators in this tool are provided.\n\n.. note::\n\n    You can always pass the languages by the name or by abbreviation.\n\n    *Example*: If you want to use english as a source or target language, you can pass **english** or **en** as an argument\n\nImports\n--------\n\n.. code-block:: python\n\n    from deep_translator import (GoogleTranslator,\n                                 MicrosoftTranslator,\n                                 PonsTranslator,\n                                 LingueeTranslator,\n                                 MyMemoryTranslator,\n                                 YandexTranslator,\n                                 PapagoTranslator,\n                                 DeeplTranslator,\n                                 QcriTranslator,\n                                 single_detection,\n                                 batch_detection)\n\n\nCheck Supported Languages\n---------------------------\n\n.. note::\n\n    You can check the supported languages of each translator by calling the\n    get_supported_languages function as a static method.\n\n.. code-block:: python\n\n    # default return type is a list\n    langs_list = GoogleTranslator.get_supported_languages()  # output: [arabic, french, english etc...]\n\n    # alternatively, you can the dictionary containing languages mapped to their abbreviation\n    langs_dict = GoogleTranslator.get_supported_languages(as_dict=True)  # output: {arabic: ar, french: fr, english:en etc...}\n\nLanguage Detection\n------------------\n\n.. note::\n\n    You can also detect language automatically. Notice that this package is free and my goal is to keep it free.\n    Therefore, you will need to get your own api_key if you want to use the language detection function.\n    I figured out you can get one for free here: https://detectlanguage.com/documentation\n\n- Single Text Detection\n\n.. code-block:: python\n\n    lang = single_detection(\'bonjour la vie\', api_key=\'your_api_key\')\n    print(lang) # output: fr\n\n- Batch Detection\n\n.. code-block:: python\n\n    lang = batch_detection([\'bonjour la vie\', \'hello world\'], api_key=\'your_api_key\')\n    print(lang) # output: [fr, en]\n\n\n\nGoogle Translate\n-----------------\n\n.. code-block:: python\n\n    text = \'happy coding\'\n\n- You can use automatic language detection to detect the source language:\n\n.. code-block:: python\n\n    translated = GoogleTranslator(source=\'auto\', target=\'de\').translate(text=text)\n\n- You can pass languages by name or by abbreviation:\n\n.. code-block:: python\n\n    translated = GoogleTranslator(source=\'auto\', target=\'german\').translate(text=text)\n\n    # Alternatively, you can pass languages by their abbreviation:\n    translated = GoogleTranslator(source=\'en\', target=\'de\').translate(text=text)\n\n- Translate batch of texts\n\n.. code-block:: python\n\n    texts = ["hallo welt", "guten morgen"]\n\n    # the translate_sentences function is deprecated, use the translate_batch function instead\n    translated = GoogleTranslator(\'de\', \'en\').translate_batch(texts)\n\n- Translate from a file:\n\n.. code-block:: python\n\n    translated = GoogleTranslator(source=\'auto\', target=\'german\').translate_file(\'path/to/file\')\n\nMymemory Translator\n--------------------\n\n.. note::\n\n    As in google translate, you can use the automatic language detection with mymemory by using "auto" as an\n    argument for the source language. However, this feature in the mymemory translator is not so powerful as\n    in google translate.\n\n- Simple translation\n\n.. code-block:: python\n\n    text = \'Keep it up. You are awesome\'\n\n    translated = MyMemoryTranslator(source=\'auto\', target=\'french\').translate(text)\n\n- Translate batch of texts\n\n.. code-block:: python\n\n    texts = ["hallo welt", "guten morgen"]\n\n    # the translate_sentences function is deprecated, use the translate_batch function instead\n    translated = MyMemoryTranslator(\'de\', \'en\').translate_batch(texts)\n\n- Translate from file\n\n.. code-block:: python\n\n    path = "your_file.txt"\n\n    translated = MyMemoryTranslator(source=\'en\', target=\'fr\').translate_file(path)\n\n\nDeeplTranslator\n-----------------\n\n.. note::\n\n    In order to use the DeeplTranslator translator, you need to generate an api key. Deepl offers a Pro and a free API.\n    deep-translator supports both Pro and free APIs. Just check the examples below.\n    Visit https://www.deepl.com/en/docs-api/ for more information on how to generate your Deepl api key\n\n- Simple translation\n\n.. code-block:: python\n\n    text = \'Keep it up. You are awesome\'\n\n    translated = DeeplTranslator(api_key="your_api_key", source="en", target="en", use_free_api=True).translate(text)\n\n.. note::\n        deep-translator uses free deepl api by default. If you have the pro version then simply set the use_free_api to false.\n\n\n- Translate batch of texts\n\n.. code-block:: python\n\n    texts = ["hallo welt", "guten morgen"]\n\n    # the translate_sentences function is deprecated, use the translate_batch function instead\n    translated = DeeplTranslator("your_api_key").translate_batch(texts)\n\nQcriTranslator\n--------------------\n\n.. note::\n\n    In order to use the QcriTranslator translator, you need to generate a free api key. Visit https://mt.qcri.org/api/\n    for more information\n\n- Check languages\n\n.. code-block:: python\n\n    # as a property\n    print("language pairs: ", QcriTranslator("your_api_key").languages)\n\n- Check domains\n\n.. code-block:: python\n\n    # as a property\n    print("domains: ", QcriTranslator("your_api_key").domains)\n\n- Text translation\n\n.. code-block:: python\n\n    text = \'Education is great\'\n\n    translated = QcriTranslator("your_api_key").translate(source=\'en\', target=\'ar\', domain="news", text=text)\n    # output -> التعليم هو عظيم\n\n    # see docs for batch translation and more.\n\nLinguee Translator\n-------------------\n\n.. code-block:: python\n\n    word = \'good\'\n\n- Simple Translation\n\n.. code-block:: python\n\n    translated_word = LingueeTranslator(source=\'english\', target=\'french\').translate(word)\n\n    # pass language by their abbreviation\n    translated_word = LingueeTranslator(source=\'en\', target=\'fr\').translate(word)\n\n- Return all synonyms or words that matches\n\n.. code-block:: python\n\n    # set the argument return_all to True if you want to get all synonyms of the word to translate\n    translated_word = LingueeTranslator(source=\'english\', target=\'french\').translate(word, return_all=True)\n\n- Translate a batch of words\n\n.. code-block:: python\n\n    translated_words = LingueeTranslator(source=\'english\', target=\'french\').translate_words(["good", "awesome"])\n\nPONS Translator\n----------------\n\n.. note::\n\n    You can pass the languages by the name or by abbreviation just like\n    previous examples using GoogleTranslate\n\n.. code-block:: python\n\n    word = \'awesome\'\n\n- Simple Translation\n\n.. code-block:: python\n\n    translated_word = PonsTranslator(source=\'english\', target=\'french\').translate(word)\n\n    # pass language by their abbreviation\n    translated_word = PonsTranslator(source=\'en\', target=\'fr\').translate(word)\n\n- Return all synonyms or words that matches\n\n.. code-block:: python\n\n    # set the argument return_all to True if you want to get all synonyms of the word to translate\n    translated_word = PonsTranslator(source=\'english\', target=\'french\').translate(word, return_all=True)\n\n- Translate a batch of words\n\n.. code-block:: python\n\n    translated_words = LingueeTranslator(source=\'english\', target=\'french\').translate_words(["good", "awesome"])\n\nYandex Translator\n------------------\n\n.. note::\n\n    You need to require an **private api key** if you want to use the yandex translator.\n    visit the official website for more information about how to get one\n\n- Language detection\n\n.. code-block:: python\n\n    lang = YandexTranslator(\'your_api_key\').detect(\'Hallo, Welt\')\n    print(f"language detected: {lang}")  # output -> language detected: \'de\'\n\n- Text translation\n\n.. code-block:: python\n\n    # with auto detection | meaning provide only the target language and let yandex detect the source\n    translated = YandexTranslator(\'your_api_key\').translate(source="auto", target="en", text=\'Hallo, Welt\')\n    print(f"translated text: {translated}")  # output -> translated text: Hello world\n\n    # provide source and target language explicitly\n    translated = YandexTranslator(\'your_api_key\').translate(source="de", target="en", text=\'Hallo, Welt\')\n    print(f"translated text: {translated}")  # output -> translated text: Hello world\n\n- File translation\n\n.. code-block:: python\n\n    translated = YandexTranslator(\'your_api_key\').translate_file(source="auto", target="en", path="path_to_your_file")\n\n- Batch translation\n\n.. code-block:: python\n\n    translated = YandexTranslator(\'your_api_key\').translate_batch(source="auto", target="de", batch=["hello world", "happy coding"])\n\n\nMicrosoft Translator\n---------------------\n\n.. note::\n\n    You need to require an **api key** if you want to use the microsoft translator.\n    visit the official website for more information about how to get one.\n    Microsoft offers a free tier 0 subscription (2 million characters per month).\n\n- Required and optional attributes\n\n    There are two required attributes, namely "api_key" (string) and "target" (string or list).\n    Attribute "source" is optional.\n    Also, Microsoft API accepts a number of other optional attributes, you can find them here:  https://docs.microsoft.com/azure/cognitive-services/translator/reference/v3-0-translate\n    You can simply add them after the required attributes, see the example.\n\n.. code-block:: python\n\n    text = \'happy coding\'\n    translated = MicrosoftTranslator(api_key=\'some-key\', target=\'de\').translate(text=text)\n    translated_two_targets = MicrosoftTranslator(api_key=\'some-key\', target=[\'de\', \'ru\']).translate(text=text)\n    translated_with_optional_attr = MicrosoftTranslator(api_key=\'some-key\', target=\'de\', textType=\'html\']).translate(text=text)\n\n- You can pass languages by name or by abbreviation:\n\n.. code-block:: python\n\n    translated = MicrosoftTranslator(api_key=\'some-key\', target=\'german\').translate(text=text)\n\n    # Alternatively, you can pass languages by their abbreviation:\n    translated = MicrosoftTranslator(api_key=\'some-key\', target=\'de\').translate(text=text)\n\n- Translate batch of texts\n\n.. code-block:: python\n\n    texts = ["hallo welt", "guten morgen"]\n    translated = MicrosoftTranslator(api_key=\'some-key\', target=\'english\').translate_batch(texts)\n\n- Translate from a file:\n\n.. code-block:: python\n\n    translated = MicrosoftTranslator(api_key=\'some-key\', target=\'german\').translate_file(\'path/to/file\')\n\n\nPapago Translator\n---------------------\n\n.. note::\n\n    You need to require a **client id** and **client secret key** if you want to use the papago translator.\n    visit the official website for more information about how to get one.\n\n.. code-block:: python\n\n    text = \'happy coding\'\n    translated = PapagoTranslator(client_id=\'your_client_id\', secret_key=\'your_secret_key\', source=\'en\', target=\'ko\').translate(text=text)  # output: 행복한 부호화\n\n\nLibre Translator\n---------------------\n\n.. note::\n\n    Libre translate has multiple  `mirrors <https://github.com/LibreTranslate/LibreTranslate#mirrors>`_ which can be used for the API endpoint.\n    Some require an API key to be used. By default the base url is set to `libretranslate.de <https://libretranslate.de/>`_ .\n    This can be set using the "base_url" input parameter.\n\n.. code-block:: python\n\n    text = \'laufen\'\n    translated = LibreTranslator(source=\'auto\', target=\'en\', base_url = \'https://libretranslate.com/\', api_key = \'your_api_key\').translate(text=text)  # output: run\n\n\n- You can pass languages by name or by abbreviation:\n\n.. code-block:: python\n\n    translated = LibreTranslator(source=\'german\', target=\'english\').translate(text=text)\n\n    # Alternatively, you can pass languages by their abbreviation:\n    translated = LibreTranslator(source=\'de\', target=\'en\').translate(text=text)\n\n\n- Translate batch of texts\n\n.. code-block:: python\n\n    texts = ["hallo welt", "guten morgen"]\n    translated = LibreTranslator(source=\'auto\', target=\'en\').translate_batch(texts)\n\n- Translate from a file:\n\n.. code-block:: python\n\n    translated = LibreTranslator(source=\'auto\', target=\'en\').translate_file(\'path/to/file\')\n\n\n\nProxy usage\n-------------\n\ndeep-translator provide out of the box usage of proxies. Just define your proxies config as a dictionary\nand pass it to the corresponding translator. Below is an example using the GoogleTranslator but this feature\ncan be used with all supported translators.\n\n.. code-block:: python\n\n    from deep_translator import GoogleTranslator\n\n    # define your proxy configs:\n    proxies_example = {\n        "https": "your https proxy",  # example: 34.195.196.27:8080\n        "http": "your http proxy if available"\n    }\n    translated = GoogleTranslator(source=\'auto\', target=\'de\', proxies=proxies_example).translate("this package is awesome")\n\n\n\n\nUsage from Terminal\n--------------------\n\nDeep-translator supports a series of command line arguments for quick and simple access to the translators directly in your console.\n\n.. note::\n\n    The program accepts ``deep-translator`` or ``dt`` as a command, feel free to substitute whichever you prefer.\n\nFor a list of available translators:\n\n.. code-block:: console\n\n    $ deep-translator list\n\nTo translate a string or line of text:\n\n.. code-block:: console\n\n    $ deep_translator google --source "english" --target "german" --text "happy coding"\n\nAlternate short option names, along with using language abbreviations:\n\n.. code-block:: console\n\n    $ deep_translator google -src "en" -tgt "de" -txt "happy coding"\n\n\nFinally, to retrieve a list of available languages for a given translator:\n\n.. code-block:: console\n\n    $ deep-translator languages google\n\n======\nTests\n======\n\nDevelopers can install the development version of deep-translator and execute unit tests to verify functionality. For more information on doing this, see `the contribution guidelines <https://deep-translator.readthedocs.io/en/latest/contributing.html/>`_\n\n========\nLinks\n========\nCheck this article on medium to know why you should use the deep-translator package and how to translate text using python.\nhttps://medium.com/@nidhalbacc/how-to-translate-text-with-python-9d203139dcf5\n\n======\nHelp\n======\n\nIf you are facing any problems, please feel free to open an issue.\nAdditionally, you can make contact with the author for further information/questions.\n\nDo you like deep-translator?\nYou can always help the development of this project by:\n\n- Following on github and/or twitter\n- Promote the project (ex: by giving it a star on github)\n- Watch the github repo for new releases\n- Tweet about the package\n- Help others with issues on github\n- Create issues and pull requests\n- Sponsor the project\n\n===========\nNext Steps\n===========\n\nTake a look in the examples folder for more :)\nContributions are always welcome.\nRead the Contribution guidelines `Here <https://deep-translator.readthedocs.io/en/latest/contributing.html/>`_\n\n==========\nCredits\n==========\n\nMany thanks to @KirillSklyarenko for his work on integrating the microsoft translator\n\n==========\nLicense\n==========\n\nMIT license\n\nCopyright (c) 2020-present, Nidhal Baccouri\n\n\n===========================\nThe Translator++ mobile app\n===========================\n\n.. image:: ../assets/app-icon.png\n    :width: 100\n    :alt: Icon of the app\n\n\nAfter developing the deep-translator, I realized how cool this would be if I can use it as an app on my mobile phone.\nSure, there is google translate, pons and linguee apps etc.. but isn\'t it cooler to make an app where all these\ntranslators are integrated?\n\nLong story short, I started working on the app. I decided to use the `kivy framework <https://kivy.org/#home/>`_ since\nI wanted to code in python and to develop a cross platform app.\nI open sourced the `Translator++ app <https://github.com/nidhaloff/deep-translator-app/>`_ on my github too.\nFeel free to take a look at the code or make a pull request ;)\n\n.. note::\n    The Translator++ app is based on the deep-translator package. I just built the app to prove the capabilities\n    of the deep-translator package ;)\n\nI published the first release on google play store on 02-08-2020\n\nHere are some screenshots:\n\n- Phone\n\n.. image:: ../assets/translator1.jpg\n    :width: 30%\n    :height: 200\n    :alt: screenshot1\n.. image:: ../assets/translator2.jpg\n    :width: 30%\n    :height: 200\n    :alt: screenshot2\n.. image:: ../assets/spinner.jpg\n    :width: 30%\n    :height: 200\n    :alt: spinner\n\n- Tablet:\n\n.. image:: ../assets/hz_view.png\n    :width: 100%\n    :height: 300\n    :alt: screenshot3\n',
    'author': 'Nidhal Baccouri',
    'author_email': 'nidhalbacc@gmail.com',
    'maintainer': 'Nidhal Baccouri',
    'maintainer_email': 'nidhalbacc@gmail.com',
    'url': 'https://github.com/nidhaloff/deep_translator',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
