import numpy as np

from secml_malware.attack.whitebox.c_kreuk_evasion import CKreukEvasion
from secml_malware.models import CClassifierEnd2EndMalware


class CSuciuEvasion(CKreukEvasion):
	def __init__(
			self,
			end2end_model: CClassifierEnd2EndMalware,
			how_many_padding_bytes: int,
			epsilon: float,
			is_debug: bool = False,
			threshold: float = 0.5,
			compute_slack: bool = True
	):
		"""
		Create the padding attack by Suciu et al. https://arxiv.org/abs/1810.08280

		Parameters
		----------
		end2end_model : CClassifierEnd2EndMalware
			the target end-to-end model
		how_many_padding_bytes: int, optional, default 512
			how many padding bytes
		epsilon : float
			the distortion amount
		is_debug : bool, optional, default False
			if True, prints debug information during the optimization
		threshold : float, optional, default 0
			the detection threshold to bypass. Default is 0
		compute_slack : bool, optional, default True
			if True, uses also the slack space between sections. Default True
		"""
		super(CSuciuEvasion, self).__init__(
			end2end_model=end2end_model,
			how_many_padding_bytes=how_many_padding_bytes,
			epsilon=epsilon,
			iterations=1,
			is_debug=is_debug,
			threshold=threshold,
			p_norm=np.infty,
			compute_slack=compute_slack
		)
