"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.GitlabRunnerAutoscalingJobRunner = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_ec2_1 = require("aws-cdk-lib/aws-ec2");
const aws_iam_1 = require("aws-cdk-lib/aws-iam");
const constructs_1 = require("constructs");
const pascal_case_1 = require("pascal-case");
class GitlabRunnerAutoscalingJobRunner extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.configuration = {
            ...props.configuration,
            token: props.configuration.token ?? props.token?.stringValue,
            name: props.configuration.name ?? GitlabRunnerAutoscalingJobRunner.generateUniqueName(),
        };
        this.instanceType = props.instanceType || aws_ec2_1.InstanceType.of(aws_ec2_1.InstanceClass.T3, aws_ec2_1.InstanceSize.MICRO);
        this.machineImage =
            props.machineImage ||
                aws_ec2_1.MachineImage.genericLinux({
                    [scope.region]: new aws_ec2_1.LookupMachineImage({
                        name: "ubuntu/images/hvm-ssd/ubuntu-focal-20.04-amd64-server-*",
                        owners: ["099720109477"],
                        filters: {
                            architecture: ["x86_64"],
                            "image-type": ["machine"],
                            state: ["available"],
                            "root-device-type": ["ebs"],
                            "virtualization-type": ["hvm"],
                        },
                    }).getImage(scope).imageId,
                });
        this.role =
            props.role ||
                new aws_iam_1.Role(scope, `RunnersRoleFor${pascal_case_1.pascalCase(this.configuration.name)}`, {
                    assumedBy: new aws_iam_1.ServicePrincipal("ec2.amazonaws.com", {}),
                    managedPolicies: [aws_iam_1.ManagedPolicy.fromAwsManagedPolicyName("AmazonSSMManagedInstanceCore")],
                });
        this.instanceProfile = new aws_iam_1.CfnInstanceProfile(scope, `RunnersInstanceProfileFor${pascal_case_1.pascalCase(this.configuration.name)}`, {
            roles: [this.role.roleName],
        });
        aws_cdk_lib_1.Tags.of(this.instanceProfile).add("RunnersInstanceProfile", "RunnersInstanceProfile");
        aws_cdk_lib_1.Tags.of(this.role).add("RunnersRole", "RunnersRole");
    }
    static generateUniqueName() {
        return `gitlab-runner-${new Date().getTime().toString().toString()}${Math.floor(Math.random() * 100000)}`;
    }
}
exports.GitlabRunnerAutoscalingJobRunner = GitlabRunnerAutoscalingJobRunner;
_a = JSII_RTTI_SYMBOL_1;
GitlabRunnerAutoscalingJobRunner[_a] = { fqn: "@pepperize/cdk-autoscaling-gitlab-runner.GitlabRunnerAutoscalingJobRunner", version: "0.2.101" };
//# sourceMappingURL=data:application/json;base64,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