"""
A source mesh based scaffold generator for human stomach geometry
Provenance information at http://models.cellml.org/workspace/516
"""

from __future__ import division

import numpy as np
from opencmiss.utils.zinc.field import findOrCreateFieldCoordinates, findOrCreateFieldFibres
from opencmiss.zinc.context import Context
from opencmiss.zinc.element import Element
from opencmiss.zinc.field import Field
from opencmiss.zinc.node import Node
from scaffoldmaker.meshtypes.scaffold_base import Scaffold_base
from scaffoldmaker.utils.eftfactory_tricubichermite import eftfactory_tricubichermite
from scipy.interpolate import splprep, splev


class Stomach:
    '''
    Loads stomach mesh generated by Dr. Kumar Mithraratne (p.mithraratne@auckland.ac.nz)
    The original mesh was preprocessed to match expected element numbering and grouped 
    The generated mesh does not support cross derivatives
    '''
    hostMesh = '''EX Version: 2
Region: /
!#nodeset nodes
Shape. Dimension=0
#Fields=2
1) coordinates, coordinate, rectangular cartesian, real, #Components=3
 x. #Values=8 (value,d/ds1,d/ds2,d2/ds1ds2,d/ds3,d2/ds1ds3,d2/ds2ds3,d3/ds1ds2ds3)
 y. #Values=8 (value,d/ds1,d/ds2,d2/ds1ds2,d/ds3,d2/ds1ds3,d2/ds2ds3,d3/ds1ds2ds3)
 z. #Values=8 (value,d/ds1,d/ds2,d2/ds1ds2,d/ds3,d2/ds1ds3,d2/ds2ds3,d3/ds1ds2ds3)
2) fibres, anatomical, fibre, real, #Components=3
 fibre angle. #Values=1 (value)
 imbrication angle. #Values=1 (value)
 sheet angle. #Values=1 (value)
Node: 1
 -1.483455076617652e-01  6.299093764257045e-02  2.966645148221748e-02  0.000000000000000e+00  4.654344990523182e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  4.246475390337134e-01 -1.385040583478302e-01  1.023019756174143e-02  0.000000000000000e+00  1.730574158233883e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  3.715538781367936e-03 -4.528007021556238e-02 -3.418971262881716e-02  0.000000000000000e+00  8.522580732967714e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 2
 -1.103397942306586e-01  4.678114984221743e-02  3.416476566034814e-02  0.000000000000000e+00 -3.640087916392531e-04  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  4.380588594464638e-01 -1.159033105859966e-01  1.202446588060163e-02  0.000000000000000e+00 -8.634944889501783e-05  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -1.567780435063817e-02 -4.788353128734517e-02 -5.525277979486284e-03  0.000000000000000e+00  1.012402438833372e-02  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 3
 -8.001597634106909e-02  3.770667646039940e-02  2.881606273036871e-02  0.000000000000000e+00 -2.801815121851493e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  4.486964707949173e-01 -9.265486567703676e-02  1.005440930645662e-02  0.000000000000000e+00 -9.719652631108022e-04  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -7.335017177604823e-03 -5.069114726018950e-02  2.039839141950060e-02  0.000000000000000e+00  8.333637373544452e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 4
 -5.270766876992098e-02  2.624270912805456e-02  5.615367577321666e-04  0.000000000000000e+00 -6.334828265770070e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  4.581676780593773e-01 -7.621406791186225e-02 -1.173574444593151e-04  0.000000000000000e+00 -2.196952718793888e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  2.511897848836391e-02 -7.186938752711392e-03  5.625691310241067e-02  0.000000000000000e+00  4.305781266489261e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 5
 -7.889290282560514e-02  3.660881928102367e-02 -2.768579536526786e-02  0.000000000000000e+00 -2.763044058544266e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  4.484617559059990e-01 -9.200983834500304e-02 -9.602791009466427e-03  0.000000000000000e+00 -7.502943280469077e-04  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  1.051788090272150e-01 -8.932263005034830e-03  5.242617798807753e-02  0.000000000000000e+00 -6.331546873113575e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 6
 -1.080792595004564e-01  4.498889686101820e-02 -3.547412201904859e-02  0.000000000000000e+00 -2.097575104820781e-04  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  4.389620960404447e-01 -1.160515997455938e-01 -1.205227009802481e-02  0.000000000000000e+00 -7.261897115720672e-05  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  1.299713344645154e-01 -9.461350160421683e-03  4.354275203780844e-03  0.000000000000000e+00 -1.058368744010527e-02  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 7
 -1.498411468637023e-01  6.443637134651606e-02 -3.079671884731819e-02  0.000000000000000e+00  4.854561184634371e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  4.243572157099492e-01 -1.372606110276380e-01 -1.068181585873218e-02  0.000000000000000e+00  1.723785199794187e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  1.138873594347757e-01 -6.935891129283576e-03 -3.863485677876082e-02  0.000000000000000e+00 -9.835462586982723e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 8
 -1.696726971950926e-01  7.237747264916752e-02  7.478196009684246e-04  0.000000000000000e+00  6.855890153700278e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  4.175984643229801e-01 -1.498288801071360e-01  1.451616618819429e-04  0.000000000000000e+00  2.268885166062995e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  5.270162090699446e-02 -1.951595044514380e-02 -5.508591032670507e-02  0.000000000000000e+00  1.554322188001431e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 9
 -8.535457001918974e-02  6.760916193544668e-02  1.686829007873648e-02  0.000000000000000e+00  2.554952492206958e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  2.861434806858957e-01 -8.460033859358682e-02  2.719298232231337e-02  0.000000000000000e+00  4.052321663508482e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -4.156453143419334e-02 -1.376072656727707e-01 -4.837350304991805e-02  0.000000000000000e+00  1.054914694702677e-02  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 10
 -6.355864438845005e-02  7.550043636377285e-02  2.152263506926351e-02  0.000000000000000e+00 -1.992317725902151e-04  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  3.221555488604637e-01 -4.795026088670155e-02  3.494906221599543e-02  0.000000000000000e+00 -3.211406182435372e-04  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -6.356133563797722e-02 -1.986302521421617e-01 -8.230816501804147e-03  0.000000000000000e+00  1.149272001920811e-02  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 11
 -4.230929988067032e-02  9.691062020449706e-02  1.854684237329068e-02  0.000000000000000e+00 -2.517241575137002e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  3.560416051178925e-01  5.688346226494598e-03  2.989903064352184e-02  0.000000000000000e+00 -4.155147685774463e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -5.802616443779458e-02 -1.713135257711497e-01  4.074668768681300e-02  0.000000000000000e+00  1.420757989977419e-02  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 12
 -2.646495964187235e-02  1.044868040187152e-01  1.260816804665374e-05  0.000000000000000e+00 -4.010836209295153e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  3.819536101475191e-01  3.517744582906614e-02  2.051562215525521e-04  0.000000000000000e+00 -6.492227557959238e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  1.793203973563484e-02 -5.852995204016594e-02  7.713635522999511e-02  0.000000000000000e+00  2.120466031308167e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 13
 -4.228408354457362e-02  9.699122918279950e-02 -1.831270149878671e-02  0.000000000000000e+00 -2.524814048434982e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  3.564519175610159e-01  6.840409589294202e-03 -2.952155692634320e-02  0.000000000000000e+00 -4.476212023621404e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  9.624654602217614e-02  1.578037324549497e-02  5.128897228423214e-02  0.000000000000000e+00 -8.741832803221411e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 14
 -6.309036263943592e-02  7.534005137922925e-02 -2.156034598630531e-02  0.000000000000000e+00 -3.911182460938495e-04  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  3.229104962948552e-01 -4.683854987237850e-02 -3.467765643935637e-02  0.000000000000000e+00 -6.308391716977058e-04  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  1.205099843040909e-01  5.167423602891210e-02  5.352461141659791e-03  0.000000000000000e+00 -9.912664020158356e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 15
 -8.540477551718399e-02  6.755585172339518e-02 -1.710243095324306e-02  0.000000000000000e+00  2.317555454155917e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  2.870966046823313e-01 -8.574656650334034e-02 -2.757045603951568e-02  0.000000000000000e+00  3.683200653634963e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  1.069514683054949e-01  5.288246705128574e-02 -4.366215692112164e-02  0.000000000000000e+00 -8.327232513910113e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 16
 -9.729522454591963e-02  5.977237145252726e-02  2.510274899253720e-05  0.000000000000000e+00  3.650159305904697e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  2.677695842158337e-01 -1.108996575161129e-01 -4.765619982152747e-04  0.000000000000000e+00  5.884348796265468e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  3.318567046185100e-02 -1.496089432884582e-02 -7.425799986984530e-02  0.000000000000000e+00  5.073563816171082e-04  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 17
 -1.312718379086833e-02  6.434928790354003e-02  4.539451639345508e-02  0.000000000000000e+00  4.862133657947056e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  2.554468618465513e-01 -5.667754323917583e-02  7.317959419115523e-02  0.000000000000000e+00  7.838195778601398e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -2.714989925641867e-01 -2.077483132630418e-01 -2.178590704421187e-01  0.000000000000000e+00  1.194883752386157e-02  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 18
  4.066107849688944e-02  1.147203201641638e-01  6.346622392939288e-02  0.000000000000000e+00  4.573773876406437e-05  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  3.421583376730535e-01 -1.482338562763998e-02  1.023131507006830e-01  0.000000000000000e+00  7.368689720493871e-05  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -4.129383086349747e-01 -2.485401780848269e-01 -3.923153807784968e-02  0.000000000000000e+00  1.884504139760505e-02  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 19
  1.138052640679202e-01  1.680200821991997e-01  5.780243038531130e-02  0.000000000000000e+00 -4.978219673694505e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  4.600731632479295e-01  3.070901440951997e-02  9.318211602222365e-02  0.000000000000000e+00 -8.025235397599292e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -3.499620687199123e-01 -1.893136975586200e-01  1.604986915214987e-01  0.000000000000000e+00  1.851896541849966e-02  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 20
  1.562659392675022e-01  2.055709550213997e-01  6.421457360438511e-04  0.000000000000000e+00 -8.629514850623202e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  5.285225697175170e-01  6.034567850757415e-02  1.034705918338250e-03  0.000000000000000e+00 -1.391149120463900e-02  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -9.194092559200064e-02 -6.999219178986213e-02  2.433508121190647e-01  0.000000000000000e+00  6.117327192591702e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 21
  1.150895555399900e-01  1.689595232370949e-01 -5.683254800474172e-02  0.000000000000000e+00 -5.043418668789417e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  4.621425750846084e-01  3.085509143659095e-02 -9.161878671091164e-02  0.000000000000000e+00 -8.130426113182654e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  1.367395555181812e-01  7.261732644918774e-02  1.626303660571793e-01  0.000000000000000e+00 -9.572062734218956e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 22
  4.260084325800628e-02  1.157354102103258e-01 -6.490949947844944e-02  0.000000000000000e+00 -9.215700009546357e-04  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  3.452849962956944e-01 -1.548065596899642e-02 -1.046392461906614e-01  0.000000000000000e+00 -1.485637691462829e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  2.333198065223431e-01  1.231639068774492e-01  4.145636900958147e-02  0.000000000000000e+00 -2.020916212882642e-02  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 23
 -1.472944341690175e-02  6.364656238108336e-02 -4.636439877402079e-02  0.000000000000000e+00  5.910239687725001e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  2.528640827032689e-01 -5.692766677533101e-02 -7.474292350246529e-02  0.000000000000000e+00  9.527807344938174e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  2.196522935373479e-01  1.111665182302311e-01 -1.052699871365199e-01  0.000000000000000e+00 -1.944835630143815e-02  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 24
 -5.012795429002682e-02  4.431070615206437e-02  8.011298130165857e-04  0.000000000000000e+00  7.673868719803908e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  1.957991492907464e-01 -7.290017896915185e-02  1.291389571642099e-03  0.000000000000000e+00  1.237085532180816e-02  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  2.277983224929177e-02 -1.281257859534130e-02 -2.455756430507570e-01  0.000000000000000e+00 -5.964525541503184e-04  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 25
  4.334400578789389e-02  4.857612891378466e-02  8.727790409083665e-02  0.000000000000000e+00  7.135465867981441e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  1.727883942075328e-01 -8.572562752478252e-02  8.526977566382690e-02  0.000000000000000e+00  6.428533397341729e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -4.570611579603086e-01 -1.081565773161974e-01 -2.841011025393960e-01  0.000000000000000e+00  1.467376218373273e-02  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 26
  1.658819959398924e-01  1.110748936540809e-01  1.251934293649135e-01  0.000000000000000e+00  1.824966051849897e-05  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  2.925087776051883e-01 -8.652435992708339e-02  1.223356198647003e-01  0.000000000000000e+00 -4.571486282749088e-04  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -5.606416918076471e-01 -8.284268486684139e-02  1.020379920263143e-02  0.000000000000000e+00  1.803379730057469e-02  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 27
  2.937308645177251e-01  1.671255459280051e-01  1.093974772305116e-01  0.000000000000000e+00 -5.801347521573130e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  4.174596339369449e-01 -1.033691388595271e-01  1.050680947787409e-01  0.000000000000000e+00 -6.738460792059572e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -4.366535595550728e-01 -6.723204040184032e-02  2.192946739817913e-01  0.000000000000000e+00  8.114842793347260e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 28
  3.846769504009310e-01  2.033426033027362e-01  9.520492059313795e-04  0.000000000000000e+00 -9.712529982290871e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  5.026449671626718e-01 -1.106088383695551e-01  3.512332486265840e-04  0.000000000000000e+00 -9.448323134887582e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -1.220523438440893e-01 -6.247368717822662e-03  3.390673792378022e-01  0.000000000000000e+00 -2.494578457854654e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 29
  2.956349629295881e-01  1.660247733464265e-01 -1.081482463098491e-01  0.000000000000000e+00 -6.358681556649592e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  4.181621004341977e-01 -1.042600561637621e-01 -1.053478914029025e-01  0.000000000000000e+00 -6.772100462523648e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  2.414811989205295e-01  7.803383618725027e-02  2.444450709515477e-01  0.000000000000000e+00 -1.670204398513389e-02  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 30
  1.683804577812528e-01  1.108636216489295e-01 -1.268733068423160e-01  0.000000000000000e+00 -5.067499133660294e-04  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  2.919491843568610e-01 -8.822930386020510e-02 -1.224604146512751e-01  0.000000000000000e+00 -6.019288880299428e-04  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  3.668377980590073e-01  9.081216022076659e-02  4.390165292270763e-02  0.000000000000000e+00 -2.141602068130515e-02  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 31
  4.188834924499300e-02  5.012522977723598e-02 -8.852713501152151e-02  0.000000000000000e+00  7.174691279762713e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  1.732412711316495e-01 -8.452695681809574e-02 -8.498997903966793e-02  0.000000000000000e+00  5.996252189784133e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  3.292845047659591e-01  8.619414204674278e-02 -1.796386423939259e-01  0.000000000000000e+00 -1.658000853446576e-02  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 32
 -8.673812241786396e-03  3.540513678726792e-02  7.278282714488597e-04  0.000000000000000e+00  1.008085508369815e-02  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  1.219692262775350e-01 -7.160722564866152e-02 -2.264384620543972e-04  0.000000000000000e+00  9.352362351582127e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  7.560513271155103e-03 -1.224729254573607e-02 -3.931728313631242e-01  0.000000000000000e+00 -3.273569511735148e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 33
  8.402507403670265e-02  2.659407188927332e-02  1.210642732602790e-01  0.000000000000000e+00  1.121725615220551e-02  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  8.399560679697729e-02 -1.002795906669891e-01  5.826245991272502e-02  0.000000000000000e+00  6.117461796118412e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -4.878121471965987e-01  5.213670120680663e-03 -2.884544627632329e-01  0.000000000000000e+00  2.269699260955935e-02  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 34
  2.628108658050455e-01  5.798530561556959e-02  1.820156409436175e-01  0.000000000000000e+00 -4.544241229177681e-04  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  1.691096178188895e-01 -1.553561983419402e-01  8.466963936594990e-02  0.000000000000000e+00 -6.305340499877798e-04  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -5.786236783686503e-01  2.620651257565915e-02  1.692998836485465e-03  0.000000000000000e+00  2.573301045215318e-02  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 35
  4.480563559239144e-01  8.967781019217093e-02  1.500701400339699e-01  0.000000000000000e+00 -1.128495406343784e-02  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  2.533348855288793e-01 -2.096894532081373e-01  6.909763757975421e-02  0.000000000000000e+00 -5.505769012821626e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -4.844261495236215e-01  2.922731887653032e-03  2.370940076705113e-01  0.000000000000000e+00  2.139955104220391e-02  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 36
  5.629511458729706e-01  9.884917336988576e-02 -4.586268455415016e-04  0.000000000000000e+00 -1.497873081567563e-02  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  3.073048929784262e-01 -2.484332380692612e-01  1.437886140876754e-04  0.000000000000000e+00 -6.523197413263682e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -1.044356630276389e-01  1.291968843560608e-02  3.886166887081617e-01  0.000000000000000e+00  3.653057445339725e-04  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 37
  4.471391022328070e-01  8.834653152327127e-02 -1.493115296585228e-01  0.000000000000000e+00 -1.077055595205198e-02  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  2.536224627570955e-01 -2.114093862461273e-01 -6.923925220158264e-02  0.000000000000000e+00 -5.430937909229883e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  2.928072278926834e-01  2.115570888585526e-02  2.596898949957654e-01  0.000000000000000e+00 -1.649148422440831e-02  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 38
  2.643280865558941e-01  5.750789903621652e-02 -1.808090430476104e-01  0.000000000000000e+00 -1.065901342017631e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  1.688263885752909e-01 -1.548837173468135e-01 -8.490614684501616e-02  0.000000000000000e+00 -5.856811561403552e-04  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  4.149441269638758e-01  2.726926178617264e-02  4.961667486908142e-02  0.000000000000000e+00 -2.094777969247759e-02  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 39
  8.552101613757179e-02  2.717200305170063e-02 -1.218228836356931e-01  0.000000000000000e+00  1.075753129790666e-02  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  8.381016906705854e-02 -1.009367847278949e-01 -5.812084529092152e-02  0.000000000000000e+00  6.271319427207371e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  3.920405776308448e-01  1.668139975004418e-02 -2.083294399030305e-01  0.000000000000000e+00 -2.046581400447481e-02  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 40
  2.068231928450239e-02  1.512684839340646e-02 -7.479710504326199e-04  0.000000000000000e+00  1.385255258609338e-02  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  5.258469799343743e-02 -7.464688643873893e-02  9.271886495365589e-05  0.000000000000000e+00  6.374603131974112e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -1.714752842185068e-03 -2.083866833363709e-03 -4.399263624137153e-01  0.000000000000000e+00 -2.642233347175578e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 41
  9.653214956644449e-02 -9.719799556633976e-03  1.301363613129986e-01  0.000000000000000e+00  9.829221795846450e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -2.777078712646249e-02 -1.072394554126291e-01  4.560463760619310e-03  0.000000000000000e+00  4.679804496016656e-04  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -4.466338177189528e-01  6.682029942491437e-02 -2.558107231303795e-01  0.000000000000000e+00  2.003005480393823e-02  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 42
  2.818526071710061e-01 -2.089684587555087e-02  1.882771676678157e-01  0.000000000000000e+00  2.269470249330469e-04  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -1.820361907868774e-02 -1.801490931553336e-01  1.292575732356462e-02  0.000000000000000e+00  7.108573447316179e-04  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -5.082286666563351e-01  9.726997432680762e-02  7.912860969597355e-03  0.000000000000000e+00  2.417125405208678e-02  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 43
  4.730864849020660e-01 -2.509771330239181e-02  1.502613449848365e-01  0.000000000000000e+00 -1.050885127469174e-02  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -1.919272479322805e-03 -2.563900880596555e-01  1.199105505143345e-02  0.000000000000000e+00 -3.579077865086471e-04  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -4.308080957797580e-01  8.439689268234468e-02  2.060078498417205e-01  0.000000000000000e+00  2.215555322487703e-02  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 44
  5.823752971406972e-01 -5.423670415672455e-02 -3.792294629823001e-04  0.000000000000000e+00 -1.644930513092913e-02  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  5.778491024182528e-03 -2.937532352438310e-01 -1.368699789356029e-03  0.000000000000000e+00 -1.158623479974179e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -9.621296697288378e-02  3.085598318541630e-02  3.573003562359994e-01  0.000000000000000e+00  2.565718148915319e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 45
  4.723280259761077e-01 -2.568613234031591e-02 -1.494895206435086e-01  0.000000000000000e+00 -1.084779517973775e-02  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -4.656672058041181e-03 -2.564210579150120e-01 -1.179837068046448e-02  0.000000000000000e+00  1.304395386420223e-04  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  2.837926166922538e-01 -3.743211563609243e-02  2.587946443021092e-01  0.000000000000000e+00 -1.695858148823580e-02  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 46
  2.833962558536797e-01 -2.149378394598027e-02 -1.880478353138543e-01  0.000000000000000e+00 -1.108080018296639e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -1.781825033679154e-02 -1.805196634934115e-01 -1.198781313303857e-02  0.000000000000000e+00  7.676099862458019e-04  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  4.213763216313498e-01 -1.610770732216582e-02  3.942734378689676e-02  0.000000000000000e+00 -2.819327716195892e-02  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 47
  9.623235534840648e-02 -1.105372859120807e-02 -1.309081856543325e-01  0.000000000000000e+00  1.087944811812788e-02  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -2.863229832420101e-02 -1.069970743403012e-01 -4.753148131545834e-03  0.000000000000000e+00  8.219216536527940e-04  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  3.626473042660597e-01 -2.588792799473644e-02 -2.089917710134668e-01  0.000000000000000e+00 -2.241723749026706e-02  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 48
  2.157988454502387e-02 -9.285177451451597e-03  1.498971090148418e-04  0.000000000000000e+00  1.615814353244694e-02  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -2.732454659991996e-02 -7.966236297555773e-02  4.307555988724183e-04  0.000000000000000e+00 -4.968144529151819e-04  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  3.392779604433577e-03  9.541010602216092e-03 -4.046405609925101e-01  0.000000000000000e+00 -1.237052890782611e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 49
  6.458547492343927e-02 -4.450350132234671e-02  1.094526048361616e-01  0.000000000000000e+00  8.805044781710229e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -1.304833040282992e-01 -8.709966694437538e-02 -4.222427026705047e-02  0.000000000000000e+00 -3.187225285533578e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -3.541715483467971e-01  1.016900709006661e-01 -2.007254990386408e-01  0.000000000000000e+00  1.604531712689995e-02  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 50
  2.210171740539300e-01 -8.524041656176312e-02  1.666377271978552e-01  0.000000000000000e+00 -2.726090388287250e-05  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -1.911885684917937e-01 -1.534634901257223e-01 -6.448099328105150e-02  0.000000000000000e+00  2.560734098799727e-04  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -3.840837297150376e-01  1.269846343985968e-01  1.926959209393013e-02  0.000000000000000e+00  1.255592671967556e-02  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 51
  3.978609293191653e-01 -1.453975453827915e-01  1.167302817527896e-01  0.000000000000000e+00 -8.718188513005057e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -2.594452905904331e-01 -2.024429647396746e-01 -4.450650450871199e-02  0.000000000000000e+00  3.748420422974699e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -3.156323641589316e-01  1.243307922433985e-01  1.706800165291173e-01  0.000000000000000e+00  1.337849369368627e-02  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 52
  4.544777375595308e-01 -1.799473713105521e-01 -1.047045883501754e-03  0.000000000000000e+00 -1.089216987327907e-02  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -2.802015775092087e-01 -2.295778595131178e-01  1.128187587399326e-04  0.000000000000000e+00  4.210298438018817e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -4.272369665681196e-02  5.868589893520491e-02  2.667876803897195e-01  0.000000000000000e+00  1.854664356217768e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 53
  3.957668375521476e-01 -1.443148331500044e-01 -1.165686094477876e-01  0.000000000000000e+00 -7.771477900676532e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -2.592196530729097e-01 -2.018895120661109e-01  4.399431954879988e-02  0.000000000000000e+00  3.577018292462014e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  2.179429966205216e-01 -4.613569084019521e-02  2.127262044881741e-01  0.000000000000000e+00 -1.014975819942755e-02  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 54
  2.213405186639382e-01 -8.691381957447775e-02 -1.661766392984918e-01  0.000000000000000e+00 -9.942657446437159e-05  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -1.922129384116123e-01 -1.532605460366859e-01  6.451783672967562e-02  0.000000000000000e+00  7.573121277809625e-04  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  3.827287123195531e-01 -5.842450060108585e-02  6.116086251042746e-02  0.000000000000000e+00 -1.763795410023367e-02  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 55
  6.341355895517550e-02 -4.415353946867262e-02 -1.096142771411722e-01  0.000000000000000e+00  8.568556440422571e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -1.301839796135722e-01 -8.713185728664261e-02  4.273645522696252e-02  0.000000000000000e+00 -2.999270301407508e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  3.402647216413688e-01 -5.405890252043032e-02 -1.826807219786485e-01  0.000000000000000e+00 -1.420803738973199e-02  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 56
  2.111964381609875e-03 -2.664420166255265e-02  5.859579841296716e-04  0.000000000000000e+00  1.034899636331627e-02  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -1.067400279576689e-01 -6.574743915147958e-02 -1.496622073641173e-04  0.000000000000000e+00 -4.192219975672141e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  1.736726836224650e-02  1.728677335866247e-02 -3.472181349940750e-01  0.000000000000000e+00 -2.251651281430012e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 57
  7.525146921758197e-03 -8.418235272960028e-02  7.154014641376268e-02  0.000000000000000e+00  4.190758174959372e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -2.019701210152191e-01 -4.600674990285192e-02 -8.315558721363550e-02  0.000000000000000e+00 -5.627512582082966e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -2.432536759176477e-01  1.059615404190702e-01 -1.461128620904473e-01  0.000000000000000e+00  1.136862586370017e-02  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 58
  1.113717740474934e-01 -1.472226628981078e-01  8.738312360737160e-02  0.000000000000000e+00  4.234527071222856e-04  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -3.251305993301416e-01 -7.256492647100818e-02 -1.024175404717363e-01  0.000000000000000e+00 -2.399019582576961e-04  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -2.542593978591299e-01  1.004483287376537e-01  3.055358231234029e-02  0.000000000000000e+00  1.613441329939554e-02  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 59
  1.822913941365078e-01 -2.246830825267110e-01  5.555439023605050e-02  0.000000000000000e+00 -4.511831042991458e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -4.068052019586738e-01 -8.425837341742295e-02 -6.412331433594995e-02  0.000000000000000e+00  5.228413362564424e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -1.821465112929685e-01  8.877941789204835e-02  1.377091143783278e-01  0.000000000000000e+00  1.023256388475395e-02  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 60
  2.224805545195993e-01 -2.483156736945567e-01  7.034827697815216e-04  0.000000000000000e+00 -7.420493763158016e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -4.533772280020337e-01 -9.563792638664355e-02 -8.152471157852892e-04  0.000000000000000e+00  8.680484307546435e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  2.115883089752327e-02  4.673425928541960e-02  1.868338731524237e-01  0.000000000000000e+00 -2.029311153867406e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 61
  1.836983596760750e-01 -2.234043946848766e-01 -5.645596890743149e-02  0.000000000000000e+00 -5.107254618726992e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -4.084356961902713e-01 -8.490412541356429e-02  6.451894279593284e-02  0.000000000000000e+00  5.918522429810211e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  1.915212350119136e-01 -1.210569939868685e-02  1.416842447658102e-01  0.000000000000000e+00 -1.125402462515100e-02  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 62
  1.095686167047500e-01 -1.480491983590431e-01 -8.788654163251339e-02  0.000000000000000e+00  3.783207660929024e-04  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -3.243393424101715e-01 -7.191440694789111e-02  1.027698416463873e-01  0.000000000000000e+00 -8.467127957559328e-06  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  3.045273204291805e-01 -3.410885127584129e-02  3.150413210663826e-02  0.000000000000000e+00 -1.641874331849941e-02  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 63
  7.925276411051665e-03 -8.359158622491335e-02 -7.063856774240670e-02  0.000000000000000e+00  4.477376289425268e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -2.028960128974708e-01 -4.617525337689640e-02  8.275995875364789e-02  0.000000000000000e+00 -5.770690952738154e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  2.545294992251836e-01 -4.692743442710279e-02 -1.332804970537103e-01  0.000000000000000e+00 -1.185413709898898e-02  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 64
 -3.170851878004917e-02 -5.779856842392718e-02 -2.000647446647550e-04  0.000000000000000e+00  7.212856545126062e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -1.588194249028818e-01 -3.827088432362274e-02  4.629459411295833e-04  0.000000000000000e+00 -8.277037103231695e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  3.796632632176573e-02  2.113048975101619e-02 -2.488915875714219e-01  0.000000000000000e+00 -2.207732243892223e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 65
 -1.037792305357460e-01 -9.989466689636861e-02  2.002851036197633e-02  0.000000000000000e+00  1.715922450294678e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -2.224968038340129e-01 -1.144851047963084e-02 -7.651831241443623e-02  0.000000000000000e+00 -5.043433315106156e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -1.422484675086617e-01  9.427089879967804e-02 -1.214076600520115e-01  0.000000000000000e+00  1.091227961418348e-02  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 66
 -7.342815174226817e-02 -1.582510994284678e-01  2.613699740074425e-02  0.000000000000000e+00 -6.686493920972369e-05  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -3.363184214338003e-01  8.753942363427983e-03 -1.027326167956255e-01  0.000000000000000e+00 -3.871994722525196e-04  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -1.831870722397257e-01  8.512149961553606e-02  2.087469566913351e-03  0.000000000000000e+00  1.329374367591761e-02  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 67
 -5.150523573424893e-02 -1.998873594596411e-01  1.563727095634017e-02  0.000000000000000e+00 -1.166918135735882e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -4.279620374252911e-01  9.832776511613628e-03 -6.757950442433570e-02  0.000000000000000e+00  5.856887840830910e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -1.380735283748435e-01  6.381087318709852e-02  1.169659470768833e-01  0.000000000000000e+00  1.076942836971801e-02  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 68
 -4.215360982957503e-02 -2.233731960948678e-01  2.316419583135113e-04  0.000000000000000e+00 -1.588856348299007e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -4.714774302824830e-01  1.202694499463355e-02 -5.329332373902040e-04  0.000000000000000e+00  8.837011753733928e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  5.074482191402140e-02  3.167780673817222e-02  1.659025630990184e-01  0.000000000000000e+00 -2.123554088613627e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 69
 -5.104195181761428e-02 -2.007873100492350e-01 -1.630213411227544e-02  0.000000000000000e+00 -2.199273421221587e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -4.290279039000565e-01  1.107332517539396e-02  6.771783898755883e-02  0.000000000000000e+00  6.706346730279630e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  1.937315978231941e-01  9.500579925719566e-03  1.318830939269213e-01  0.000000000000000e+00 -6.329602540732213e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 70
 -7.475787805415188e-02 -1.571176137622160e-01 -2.636383083851757e-02  0.000000000000000e+00  2.449695114104394e-04  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -3.360417523073440e-01  6.922487334004093e-03  1.032467087663382e-01  0.000000000000000e+00  3.592808341921494e-04  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  3.145110097678685e-01 -8.984474048364444e-03  2.633912748198493e-02  0.000000000000000e+00 -1.448893623399161e-02  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 71
 -1.037696134946521e-01 -9.987251741196906e-02 -1.936364720604517e-02  0.000000000000000e+00  2.051231568192150e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -2.225344863673654e-01 -1.003430941265020e-02  7.637997785121500e-02  0.000000000000000e+00 -5.234515796983329e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  2.464098527871605e-01 -4.719981252062556e-03 -1.274413809517899e-01  0.000000000000000e+00 -1.115863796542357e-02  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 72
 -1.134851724662345e-01 -7.700345872717618e-02 -4.808520544304085e-06  0.000000000000000e+00  2.040478656042146e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -1.832817966049164e-01 -1.266068282275971e-02  1.884126667950348e-05  0.000000000000000e+00 -7.976263360326953e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  5.962824786429383e-02  1.624289560959510e-02 -1.943291601479135e-01  0.000000000000000e+00  5.959950641080975e-04  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 73
 -1.922641868709719e-01 -7.690846204960712e-02 -9.707494287514121e-03  0.000000000000000e+00 -1.550842532632296e-04  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -2.248671419744882e-01  7.897999637213299e-03 -6.174096202744282e-02  0.000000000000000e+00 -4.266211994596404e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -5.471187831830347e-02  4.993028424653959e-02 -7.723425808449971e-02  0.000000000000000e+00  7.504665539938249e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 74
 -2.051304248094417e-01 -1.076327123274270e-01 -1.260956895589908e-02  0.000000000000000e+00  6.836428896904306e-04  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -3.076227146032996e-01  4.234769200586369e-02 -8.113625348048148e-02  0.000000000000000e+00  1.405848359685297e-04  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -8.401639862805621e-02  6.026406778811831e-02  9.355669976220983e-05  0.000000000000000e+00  1.067976033471554e-02  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 75
 -2.174833247827487e-01 -1.317889021617639e-01 -9.567706430356877e-03  0.000000000000000e+00  1.320109270689152e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -3.871396489354590e-01  6.944589589155076e-02 -6.085031170473020e-02  0.000000000000000e+00  4.252481516877224e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -5.452476491877668e-02  5.773900906070025e-02  8.426542150095570e-02  0.000000000000000e+00  8.811371279294157e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 76
 -2.242658376701517e-01 -1.439093650670350e-01 -1.964678198174072e-04  0.000000000000000e+00  1.778243905531461e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -4.293233380127572e-01  8.049366712226604e-02  4.253015479900729e-04  0.000000000000000e+00  7.512402054014183e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  8.451444437385121e-02  6.393422392142925e-03  1.325235798910713e-01  0.000000000000000e+00 -6.224151101860871e-04  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 77
 -2.178762604224050e-01 -1.321789981239279e-01  9.799613425219608e-03  0.000000000000000e+00  1.490944268494283e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -3.862890458394804e-01  7.034352587378367e-02  5.941448513530620e-02  0.000000000000000e+00  4.225630804822245e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  2.105223948633712e-01 -2.441481027719676e-02  1.010219639792919e-01  0.000000000000000e+00 -5.339251118670230e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 78
 -2.046666108196759e-01 -1.064425466985123e-01  1.302825100474764e-02  0.000000000000000e+00  3.864990373114441e-04  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -3.104943677421401e-01  4.322392532693903e-02  8.166220705834729e-02  0.000000000000000e+00  1.807846235634819e-04  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  2.865583723324475e-01 -6.434768048579771e-02  1.728357092884607e-02  0.000000000000000e+00 -1.146675746316884e-02  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 79
 -1.918197584128599e-01 -7.697218441245834e-02  9.475587292622600e-03  0.000000000000000e+00 -7.054516128572816e-04  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -2.229646317227796e-01  7.800894647422313e-03  6.317678859687065e-02  0.000000000000000e+00 -4.485975918869185e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  2.450895367210619e-01 -4.353508908072960e-02 -1.080531273957464e-01  0.000000000000000e+00 -7.499518777734464e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 80
 -1.857154362344108e-01 -6.385567623133294e-02 -2.222142290599430e-04  0.000000000000000e+00 -7.245342455613271e-04  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -1.841407905484027e-01  2.534035947347538e-04 -9.512551258520560e-04  0.000000000000000e+00 -6.828853103864788e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  7.045211754095479e-02 -9.390953890604745e-03 -1.499007075196781e-01  0.000000000000000e+00 -1.304990152296501e-04  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 81
 -2.575961546349530e-01 -6.591720636315433e-02 -2.374852573411500e-02  0.000000000000000e+00 -2.822336524527139e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -2.067008045595924e-01  4.172249758610722e-02 -3.442402400331123e-02  0.000000000000000e+00 -3.949266800092222e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -4.238789901560740e-02 -2.256986758295481e-02 -5.175263837327086e-02  0.000000000000000e+00  6.471538805254622e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 82
 -2.886935763971054e-01 -7.543016381154286e-02 -2.874344271140936e-02  0.000000000000000e+00 -3.643874152723520e-04  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -2.516230374220873e-01  5.970450333734785e-02 -4.118472054129348e-02  0.000000000000000e+00 -3.516527909957351e-04  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -6.265893666348675e-02 -3.272025483106580e-02  9.896194381081698e-03  0.000000000000000e+00  7.340083521654783e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 83
 -3.150830400577526e-01 -8.968117994279072e-02 -2.063938178328178e-02  0.000000000000000e+00  2.385556264452804e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -2.890702456421887e-01  7.658788016832399e-02 -2.943352930792922e-02  0.000000000000000e+00  3.432009191454699e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -2.259551025343687e-02 -2.246790450491637e-02  6.309530168089156e-02  0.000000000000000e+00  4.801471653755026e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 84
 -3.299723399636646e-01 -9.667943259457284e-02 -1.584540038622739e-04  0.000000000000000e+00  2.861183312562021e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -3.104900960379545e-01  9.070170521854694e-02  3.646967448528438e-04  0.000000000000000e+00  4.116168385064761e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  6.353166669830973e-02 -4.201868137436454e-02  8.374874376111853e-02  0.000000000000000e+00 -1.449556983891452e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 85
 -3.153999480654537e-01 -9.466159563372679e-02  2.116468425625127e-02  0.000000000000000e+00  2.629692803633440e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -2.883408521524795e-01  8.047837289566985e-02  3.044809719224445e-02  0.000000000000000e+00  3.242147196511710e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  1.449019772688100e-01 -6.774465791816020e-02  6.114199104898149e-02  0.000000000000000e+00 -5.643481951621461e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 86
 -2.876429714511444e-01 -8.509831910023975e-02  2.884298287294926e-02  0.000000000000000e+00 -2.005190930326889e-04  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -2.495939016534452e-01  6.524189058914455e-02  4.070407753997307e-02  0.000000000000000e+00  1.706393261241626e-04  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  1.858156487962695e-01 -8.910063304031327e-02  7.218848678447062e-03  0.000000000000000e+00 -8.168712237744367e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 87
 -2.577139823195367e-01 -7.207177190197131e-02  2.322322326111495e-02  0.000000000000000e+00 -2.478924860302698e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -2.069326970725307e-01  4.468214020314513e-02  3.340945611900376e-02  0.000000000000000e+00 -3.434450165328624e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  1.593396746256960e-01 -8.077934789607202e-02 -7.248465435658996e-02  0.000000000000000e+00 -7.265855773329249e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 88
 -2.411965249288975e-01 -6.456646643785842e-02  5.891384229181340e-05  0.000000000000000e+00 -3.426014096136923e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -1.827749894154551e-01  3.296004995453788e-02  1.159462564753189e-04  0.000000000000000e+00 -5.245576459605154e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  4.084634008306417e-02 -3.943569297892784e-02 -1.008637868206351e-01  0.000000000000000e+00  7.498260680511935e-04  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 89
 -3.240985995972704e-01 -6.650244496232205e-02 -2.057119166120458e-02  0.000000000000000e+00 -4.891969202804713e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -1.414221468022768e-01  6.527865775731612e-02 -3.499650864463355e-02  0.000000000000000e+00 -5.287988379700514e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -9.985161348421964e-02 -5.746371446861834e-02 -7.051881993664111e-02  0.000000000000000e+00  7.505694892399550e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 90
 -3.559907524324991e-01 -6.729717603539959e-02 -3.637354253554026e-02  0.000000000000000e+00 -1.378417315134550e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -1.882137079286092e-01  6.340932949347619e-02 -4.627087089827153e-02  0.000000000000000e+00  2.865855825683328e-04  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -1.494569082901873e-01 -8.679797162669950e-02  1.955197778076290e-04  0.000000000000000e+00  1.632976151844434e-02  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 91
 -3.968456846683286e-01 -8.176264461057664e-02 -3.081697521340221e-02  0.000000000000000e+00  3.062459653026928e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -2.339638885988121e-01  5.510635704337505e-02 -2.985310982353662e-02  0.000000000000000e+00  5.196680702775791e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -9.946057392860712e-02 -7.686506367516882e-02  7.496699495765835e-02  0.000000000000000e+00  1.039188476834096e-02  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 92
 -4.176247028593026e-01 -8.765236289563022e-02 -5.176883510759067e-03  0.000000000000000e+00  5.605674811478889e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -2.479199275756718e-01  6.257016846228361e-02  4.315794275340679e-03  0.000000000000000e+00  7.083934868144293e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  4.770816251324783e-04 -6.305458507317876e-02  8.724682647782833e-02  0.000000000000000e+00 -4.068229597297413e-04  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 93
 -4.071994516898289e-01 -9.179950362438735e-02  2.138072691956183e-02  0.000000000000000e+00  4.760511066231210e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -2.253323000481388e-01  6.300855210435127e-02  3.395467050592638e-02  0.000000000000000e+00  5.069292381507495e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  7.503307902704692e-02 -6.986889824175889e-02  5.394001231334355e-02  0.000000000000000e+00 -7.921095789131083e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 94
 -3.748632490201533e-01 -8.722027756901027e-02  3.561807473652445e-02  0.000000000000000e+00  1.830039623001989e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -1.800105865638486e-01  6.958331508960616e-02  4.586597436584672e-02  0.000000000000000e+00  7.729496163793037e-04  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  1.083571062518178e-01 -7.745854254445277e-02  4.248880950934009e-03  0.000000000000000e+00 -1.245287710296727e-02  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 95
 -3.359633022167783e-01 -7.824931989724468e-02  3.000743995500477e-02  0.000000000000000e+00 -2.654833415044633e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -1.336003513165222e-01  7.333234575603741e-02  3.089494796229264e-02  0.000000000000000e+00 -4.594065290795923e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  8.353084092890595e-02 -7.580883369678222e-02 -5.838818733436479e-02  0.000000000000000e+00 -9.718002036071094e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 96
 -3.148483691101143e-01 -7.365184418123225e-02  5.932351309734685e-03  0.000000000000000e+00 -5.315421909846130e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -1.182206906393441e-01  6.455429877611986e-02 -3.910897742867014e-03  0.000000000000000e+00 -6.535478562805508e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -8.419268416916568e-03 -4.926560849998567e-02 -9.169122720657397e-02  0.000000000000000e+00  1.836479129759511e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
  0.000000000000000e+00
#Fields=2
1) coordinates, coordinate, rectangular cartesian, real, #Components=3
 x. #Values=8 (value,d/ds1,d/ds2,d2/ds1ds2,d/ds3,d2/ds1ds3,d2/ds2ds3,d3/ds1ds2ds3)
 y. #Values=8 (value,d/ds1,d/ds2,d2/ds1ds2,d/ds3,d2/ds1ds3,d2/ds2ds3,d3/ds1ds2ds3)
 z. #Values=8 (value,d/ds1,d/ds2,d2/ds1ds2,d/ds3,d2/ds1ds3,d2/ds2ds3,d3/ds1ds2ds3)
2) fibres, anatomical, fibre, real, #Components=3
 fibre angle. #Values=2 (value(2))
 imbrication angle. #Values=1 (value)
 sheet angle. #Values=1 (value)
Node: 97
 -1.436911626712403e-01  6.089154514425828e-02  2.605650200954511e-02  0.000000000000000e+00  4.654307128156739e-03 -1.601400000000000e-01 -6.996200000000000e-01  0.000000000000000e+00
  4.263781131919473e-01 -1.361823108425514e-01  9.052580254261408e-03  0.000000000000000e+00  1.730536018017703e-03  3.456800000000000e-01 -2.273800000000000e-01  0.000000000000000e+00
  1.223811951433779e-02 -4.325350400150325e-02 -2.990486152865080e-02  0.000000000000000e+00  8.522637919216062e-03  2.088100000000000e-01  5.488000000000000e-01  0.000000000000000e+00
  0.000000000000000e+00  1.570796326794897e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 98
 -1.107038030223002e-01  4.694592686126183e-02  3.043668560416040e-02  0.000000000000000e+00 -3.639709292724905e-04 -1.136000000000000e-02 -6.779700000000000e-01  0.000000000000000e+00
  4.379725099975669e-01 -1.161381017553451e-01  1.067319616992983e-02  0.000000000000000e+00 -8.638758911191924e-05  5.177000000000000e-02 -2.439100000000000e-01  0.000000000000000e+00
 -5.553779962305121e-03 -4.651483565646053e-02 -5.619749659198685e-03  0.000000000000000e+00  1.012402438833386e-02  1.140600000000000e-01 -1.090000000000000e-02  0.000000000000000e+00
  0.000000000000000e+00  1.570796326794897e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 99
 -8.281779146291963e-02  3.799125000711155e-02  2.583065299330383e-02  0.000000000000000e+00 -2.801777259485855e-03  1.096000000000000e-02 -5.240899999999999e-01  0.000000000000000e+00
  4.477245055318055e-01 -9.583804809969966e-02  8.999107671508397e-03  0.000000000000000e+00 -9.719652631120235e-04 -2.475800000000000e-01 -1.840200000000000e-01  0.000000000000000e+00
  9.986201959406643e-04 -4.481720473395795e-02  1.748926985857779e-02  0.000000000000000e+00  8.333694559791258e-03  4.098800000000000e-01 -3.423200000000000e-01  0.000000000000000e+00
  0.000000000000000e+00  1.570796326794897e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 100
 -5.904249703569207e-02  2.856670118452766e-02  5.809222893856502e-04  0.000000000000000e+00 -6.334790403403675e-03  4.027500000000000e-01  4.100000000000000e-03  0.000000000000000e+00
  4.559707253405826e-01 -8.050934275102430e-02 -6.521976926299189e-06  0.000000000000000e+00 -2.196990859009637e-03 -4.237200000000000e-01  2.484000000000000e-02  0.000000000000000e+00
  2.942475975485857e-02 -9.372253987899478e-03  4.892432097907809e-02  0.000000000000000e+00  4.305781266492247e-03 -7.703000000000000e-02 -1.110750000000000e+00  0.000000000000000e+00
  0.000000000000000e+00  1.570796326794897e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 101
 -8.165594688414793e-02  3.684704929113781e-02 -2.462325998762413e-02  0.000000000000000e+00 -2.763081920908728e-03  1.164500000000000e-01  5.285800000000000e-01  0.000000000000000e+00
  4.477114615779527e-01 -9.573575604056349e-02 -8.540624135647823e-03  0.000000000000000e+00 -7.502943280469770e-04 -3.797600000000000e-01  1.820000000000000e-01  0.000000000000000e+00
  9.884726215410755e-02 -1.134254893515203e-02  4.498144363477363e-02  0.000000000000000e+00 -6.331546873111035e-03 -3.338000000000000e-02 -8.686400000000000e-01  0.000000000000000e+00
  0.000000000000000e+00  1.570796326794897e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 102
 -1.082890170109301e-01  4.480753612540261e-02 -3.166531939746402e-02  0.000000000000000e+00 -2.097953728444554e-04  6.010000000000000e-02  7.362200000000000e-01  0.000000000000000e+00
  4.388894770692879e-01 -1.166098199461361e-01 -1.081523033410481e-02  0.000000000000000e+00 -7.258083094124901e-05 -1.120500000000000e-01  2.378000000000000e-01  0.000000000000000e+00
  1.193876470244109e-01 -8.790326740477368e-03  2.602317346842263e-03  0.000000000000000e+00 -1.058363025385755e-02  3.864000000000000e-02 -2.178000000000000e-01  0.000000000000000e+00
  0.000000000000000e+00  1.570796326794897e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 103
 -1.449865856790646e-01  6.189936561603719e-02 -2.726389501523259e-02  0.000000000000000e+00  4.854599047001751e-03 -1.882700000000000e-01  7.534200000000000e-01  0.000000000000000e+00
  4.260810009097451e-01 -1.353011955737944e-01 -9.511063790123342e-03  0.000000000000000e+00  1.723747059578770e-03  2.638900000000000e-01  2.494800000000000e-01  0.000000000000000e+00
  1.040518968477912e-01 -5.427661056209458e-03 -3.256585196470617e-02  0.000000000000000e+00 -9.835519773229273e-03 -1.388400000000000e-01  8.244300000000000e-01  0.000000000000000e+00
  0.000000000000000e+00  1.570796326794897e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 104
 -1.628168070413903e-01  6.917174180137345e-02  6.477115039102005e-04  0.000000000000000e+00  6.855928016066479e-03 -2.774100000000000e-01 -1.698000000000000e-02  0.000000000000000e+00
  4.198673494890449e-01 -1.462134164769391e-01  1.485561410999175e-04  0.000000000000000e+00  2.268847025848217e-03  4.816600000000000e-01  1.920000000000000e-03  0.000000000000000e+00
  5.425594309499517e-02 -2.056291625152772e-02 -4.590688866672719e-02  0.000000000000000e+00  1.554265001755695e-03 -1.126800000000000e-01  1.101820000000000e+00  0.000000000000000e+00
  0.000000000000000e+00  1.570796326794897e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 105
 -8.279961752699416e-02  6.771305626916693e-02  1.494359453949162e-02  0.000000000000000e+00  2.554990354575870e-03  1.157200000000000e-01 -3.926600000000000e-01  0.000000000000000e+00
  2.901958023494925e-01 -8.154652778344329e-02  2.409023761502840e-02  0.000000000000000e+00  4.052321663530353e-03  5.109600000000000e-01 -6.283900000000000e-01  0.000000000000000e+00
 -3.101538448715547e-02 -1.358941372773295e-01 -4.288082123111125e-02  0.000000000000000e+00  1.054914694702434e-02  1.080100000000000e-01  7.422500000000000e-01  0.000000000000000e+00
  0.000000000000000e+00  1.570796326794897e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 106
 -6.375787616103355e-02  7.570530962896999e-02  1.898653803558684e-02  0.000000000000000e+00 -1.991939101957524e-04  1.006500000000000e-01 -4.098400000000000e-01  0.000000000000000e+00
  3.218344082422169e-01 -4.787024271365163e-02  3.084532754131693e-02  0.000000000000000e+00 -3.211406182444948e-04 -1.876000000000000e-02 -6.579400000000000e-01  0.000000000000000e+00
 -5.206861561875348e-02 -1.942697436375402e-01 -6.401600025434654e-03  0.000000000000000e+00  1.149272001920770e-02  5.196000000000000e-01  2.120400000000000e-01  0.000000000000000e+00
  0.000000000000000e+00  1.570796326794897e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 107
 -4.482654145582048e-02  9.582241792858376e-02  1.664104015493668e-02  0.000000000000000e+00 -2.517203712764424e-03  9.641200000000000e-01 -4.331600000000000e-01  0.000000000000000e+00
  3.518864574321112e-01  2.161711159252844e-03  2.681348717367448e-02  0.000000000000000e+00 -4.155185826010203e-03  1.835280000000000e+00 -6.956000000000000e-01  0.000000000000000e+00
 -4.381858453802835e-02 -1.662208617486679e-01  3.606056069285737e-02  0.000000000000000e+00  1.420763708602065e-02  4.066400000000000e-01 -6.904600000000000e-01  0.000000000000000e+00
  0.000000000000000e+00  1.570796326794897e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 108
 -3.047579585116793e-02  1.033394607262860e-01  8.821931403263546e-06  0.000000000000000e+00 -4.010798346927795e-03  2.518560000000000e+00 -7.600000000000000e-04  0.000000000000000e+00
  3.754613825895654e-01  2.932017658614208e-02  4.462405264069741e-05  0.000000000000000e+00 -6.492265698170456e-03  8.415600000000000e-01 -3.433000000000000e-02  0.000000000000000e+00
  2.005250576694706e-02 -5.762417907712367e-02  6.566164887849474e-02  0.000000000000000e+00  2.120523217550117e-03  4.069000000000000e-02 -1.367580000000000e+00  0.000000000000000e+00
  0.000000000000000e+00  1.570796326794897e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 109
 -4.480889759302612e-02  9.585104187768455e-02 -1.650284251717781e-02  0.000000000000000e+00 -2.524776186067103e-03  2.869160000000000e+00  3.586400000000000e-01  0.000000000000000e+00
  3.519757055374196e-01  3.150343696720626e-03 -2.659086273322007e-02  0.000000000000000e+00 -4.476173883401019e-03  1.859810000000000e+00  5.762900000000000e-01  0.000000000000000e+00
  8.750471321897839e-02  1.416011531491969e-02  4.527240725848278e-02  0.000000000000000e+00 -8.741832803211903e-03 -2.571500000000000e-01 -7.783600000000001e-01  0.000000000000000e+00
  0.000000000000000e+00  1.570796326794897e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 110
 -6.348148088549961e-02  7.498414513397650e-02 -1.913916123501831e-02  0.000000000000000e+00 -3.911561084449927e-04 -1.668100000000000e-01  4.315000000000000e-01  0.000000000000000e+00
  3.222796571231449e-01 -4.754505923252687e-02 -3.059795010073656e-02  0.000000000000000e+00 -6.308010314508422e-04 -1.119400000000000e-01  7.234600000000000e-01  0.000000000000000e+00
  1.105973202839274e-01  4.686149868455576e-02  5.559761286306220e-03  0.000000000000000e+00 -9.912606833910761e-03 -7.815400000000000e-01  2.936000000000000e-02  0.000000000000000e+00
  0.000000000000000e+00  1.570796326794897e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 111
 -8.308722006301544e-02  6.808369097493397e-02 -1.508179217726340e-02  0.000000000000000e+00  2.317555454160137e-03  1.926700000000000e-01  3.998700000000000e-01  0.000000000000000e+00
  2.907798053360240e-01 -8.184455543079855e-02 -2.431286205556017e-02  0.000000000000000e+00  3.683200653648105e-03  6.810200000000000e-01  6.399500000000000e-01  0.000000000000000e+00
  9.862423579159091e-02  4.807602019405788e-02 -3.845214672023347e-02  0.000000000000000e+00 -8.327175327662473e-03 -6.035300000000000e-01  6.825400000000000e-01  0.000000000000000e+00
  0.000000000000000e+00  1.570796326794897e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 112
 -9.364506524001256e-02  6.018136073557837e-02  1.438012680152929e-04  0.000000000000000e+00  3.650197168268692e-03 -1.219500000000000e+00  2.339000000000000e-02  0.000000000000000e+00
  2.736539330120751e-01 -1.058486724382260e-01 -2.920014932984230e-04  0.000000000000000e+00  5.884386936448320e-03  1.217620000000000e+00  3.548000000000000e-02  0.000000000000000e+00
  3.369302684345300e-02 -1.603628169991449e-02 -6.481981013937088e-02  0.000000000000000e+00  5.072991953672685e-04 -1.385200000000000e-01  1.170690000000000e+00  0.000000000000000e+00
  0.000000000000000e+00  1.570796326794897e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 113
 -8.265050132928312e-03  6.663954459143855e-02  4.158045090293699e-02  0.000000000000000e+00  4.862171520295306e-03  4.523600000000000e-01 -7.009000000000000e-01  0.000000000000000e+00
  2.632850576251616e-01 -5.548943737230895e-02  6.703100997885045e-02  0.000000000000000e+00  7.838233918815100e-03  1.799400000000000e-01 -1.121670000000000e+00  0.000000000000000e+00
 -2.595501550404931e-01 -2.056860056446119e-01 -2.081383234661780e-01  0.000000000000000e+00  1.194883752376248e-02  1.653700000000000e-01  1.203060000000000e+00  0.000000000000000e+00
  0.000000000000000e+00  1.570796326794897e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 114
  4.070681623563531e-02  1.148290608807283e-01  5.854604726358858e-02  0.000000000000000e+00  4.569987639937989e-05  6.200000000000000e-03 -8.499500000000000e-01  0.000000000000000e+00
  3.422320245702569e-01 -1.489138963265536e-02  9.438143511258269e-02  0.000000000000000e+00  7.372503742511527e-05 -1.064000000000000e-02 -1.360200000000000e+00  0.000000000000000e+00
 -3.940932672372787e-01 -2.452696394442091e-01 -3.594647413048799e-02  0.000000000000000e+00  1.884498421142073e-02  4.178700000000000e-01  3.820400000000000e-01  0.000000000000000e+00
  0.000000000000000e+00  1.570796326794897e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 115
  1.088270443942559e-01  1.663780292259773e-01  5.346480409060395e-02  0.000000000000000e+00 -4.978181811320689e-03 -5.228300000000000e-01 -8.437900000000000e-01  0.000000000000000e+00
  4.520479278503309e-01  2.941735785637615e-02  8.618952697130523e-02  0.000000000000000e+00 -8.025235397621532e-03 -2.803600000000000e-01 -1.350340000000000e+00  0.000000000000000e+00
 -3.314431033014650e-01 -1.923600661118111e-01  1.541348344189736e-01  0.000000000000000e+00  1.851902260471187e-02 -2.209200000000000e-01 -8.297200000000000e-01  0.000000000000000e+00
  0.000000000000000e+00  1.570796326794897e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 116
  1.476364244169355e-01  2.027201081348713e-01  6.095462384365560e-04  0.000000000000000e+00 -8.629552712942808e-03 -8.236400000000000e-01 -7.080000000000000e-03  0.000000000000000e+00
  5.146110785128798e-01  5.886763071910413e-02  9.821105605483244e-04  0.000000000000000e+00 -1.391149120462901e-02 -3.589000000000000e-01 -1.132000000000000e-02  0.000000000000000e+00
 -8.582359839940272e-02 -7.229971403445379e-02  2.293052980427230e-01  0.000000000000000e+00  6.117384378830935e-03 -2.197200000000000e-01 -1.989720000000000e+00  0.000000000000000e+00
  0.000000000000000e+00  1.570796326794897e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 117
  1.100461368711930e-01  1.670425894829966e-01 -5.297857557993951e-02  0.000000000000000e+00 -5.043418668806062e-03 -4.768100000000000e-01  6.615200000000000e-01  0.000000000000000e+00
  4.540121489714365e-01  2.970714721712275e-02 -8.540585995432778e-02  0.000000000000000e+00 -8.130387972965517e-03 -2.371100000000000e-01  1.058660000000000e+00  0.000000000000000e+00
  1.271674927839535e-01  6.863722085821064e-02  1.494671213964730e-01  0.000000000000000e+00 -9.572119920506411e-03 -5.331700000000000e-01 -1.521520000000000e+00  0.000000000000000e+00
  0.000000000000000e+00  1.570796326794897e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 118
  4.167927325711654e-02  1.156775943766517e-01 -5.943267030021741e-02  0.000000000000000e+00 -9.215700009538481e-04 -1.801000000000000e-02  1.019460000000000e+00  0.000000000000000e+00
  3.437993586042515e-01 -1.546620082716856e-02 -9.581012946162168e-02  0.000000000000000e+00 -1.485599551277673e-03  3.600000000000000e-03  1.631480000000000e+00  0.000000000000000e+00
  2.131106443935004e-01  1.174122285468982e-01  3.651822222598891e-02  0.000000000000000e+00 -2.020921931506907e-02 -6.964800000000000e-01 -6.033600000000000e-01  0.000000000000000e+00
  0.000000000000000e+00  1.570796326794897e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 119
 -8.819203729190544e-03  6.607513029389209e-02 -4.206667941366544e-02  0.000000000000000e+00  5.910277550053925e-03  5.699400000000000e-01  9.254300000000000e-01  0.000000000000000e+00
  2.623918900481897e-01 -5.577114100727496e-02 -6.781467699583711e-02  0.000000000000000e+00  9.527845485098059e-03  1.061900000000000e-01  1.480990000000000e+00  0.000000000000000e+00
  2.002039372359211e-01  1.070401302199485e-01 -9.546363234917787e-02  0.000000000000000e+00 -1.944841348767960e-02 -3.674500000000000e-01  1.397420000000000e+00  0.000000000000000e+00
  0.000000000000000e+00  1.570796326794897e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 120
 -4.245408557021028e-02  4.752605404094960e-02  2.770767981282469e-04  0.000000000000000e+00  7.673830857439209e-03  6.034800000000000e-01 -1.005400000000000e-01  0.000000000000000e+00
  2.081700046125499e-01 -7.116617219147855e-02  4.465837884814611e-04  0.000000000000000e+00  1.237085532181418e-02  2.573700000000000e-01 -1.609000000000000e-01  0.000000000000000e+00
  2.218337969517671e-02 -1.470304154202313e-02 -2.298770461381332e-01  0.000000000000000e+00 -5.964525541439255e-04 -2.289200000000000e-01  1.944960000000000e+00  0.000000000000000e+00
  0.000000000000000e+00  1.570796326794897e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 121
  5.047947165591704e-02  5.175369016089798e-02  8.224660137923166e-02  0.000000000000000e+00  7.135465867987410e-03  6.608700000000000e-01 -1.015860000000000e+00  0.000000000000000e+00
  1.792169276048604e-01 -8.658599451602521e-02  8.036502017390716e-02  0.000000000000000e+00  6.428533397327369e-03 -2.615300000000000e-01 -9.831600000000000e-01  0.000000000000000e+00
 -4.423873957766357e-01 -1.027824997732402e-01 -2.734474191331855e-01  0.000000000000000e+00  1.467381936992544e-02  5.933000000000000e-01  1.448790000000000e+00  0.000000000000000e+00
  0.000000000000000e+00  1.570796326794897e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 122
  1.659002456005509e-01  1.108248127231825e-01  1.187250226700438e-01  0.000000000000000e+00  1.824966053362229e-05  7.081000000000000e-02 -1.257730000000000e+00  0.000000000000000e+00
  2.920516289768860e-01 -8.687647040066454e-02  1.157521227700204e-01  0.000000000000000e+00 -4.571104880818147e-04 -1.589200000000000e-01 -1.269950000000000e+00  0.000000000000000e+00
 -5.426078945070438e-01 -7.939870033963481e-02  6.924339507454594e-03  0.000000000000000e+00  1.803385448685152e-02  3.788200000000000e-01 -4.163100000000000e-01  0.000000000000000e+00
  0.000000000000000e+00  1.570796326794897e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 123
  2.879295169961009e-01  1.639721787331372e-01  1.045320874090682e-01  0.000000000000000e+00 -5.801309659204709e-03 -3.394000000000000e-01 -8.527600000000000e-01  0.000000000000000e+00
  4.107211731448579e-01 -1.021094056671254e-01  1.005725075254580e-01  0.000000000000000e+00 -6.738498932282948e-03  7.914000000000000e-02 -7.803900000000000e-01  0.000000000000000e+00
 -4.285387167617808e-01 -6.579174758994083e-02  2.090304861025794e-01  0.000000000000000e+00  8.114899979567658e-03  1.118300000000000e-01 -1.194620000000000e+00  0.000000000000000e+00
  0.000000000000000e+00  1.570796326794897e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 124
  3.749644204186696e-01  2.001679953201716e-01  6.733821884027588e-04  0.000000000000000e+00 -9.712492119897970e-03 -3.444200000000000e-01 -5.601000000000000e-02  0.000000000000000e+00
  4.931966440277780e-01 -1.069146914738586e-01  3.344134134104226e-04  0.000000000000000e+00 -9.448284994681921e-03  5.614100000000000e-01 -3.360000000000000e-03  0.000000000000000e+00
 -1.245469223019615e-01 -9.123379441850314e-03  3.266589358485896e-01  0.000000000000000e+00 -2.494521271637245e-03 -3.714500000000000e-01 -1.650460000000000e+00  0.000000000000000e+00
  0.000000000000000e+00  1.570796326794897e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 125
  2.892762813729148e-01  1.631612047048058e-01 -1.035453562753965e-01  0.000000000000000e+00 -6.358681556640135e-03 -4.803400000000000e-01  8.759500000000000e-01  0.000000000000000e+00
  4.113899999716484e-01 -1.029103120617756e-01 -1.009246942794571e-01  0.000000000000000e+00 -6.772100462544339e-03  2.169700000000000e-01  8.359200000000000e-01  0.000000000000000e+00
  2.247791549353847e-01  7.457412544215734e-02  2.349843498398390e-01  0.000000000000000e+00 -1.670210117139894e-02 -4.086900000000000e-01 -1.195110000000000e+00  0.000000000000000e+00
  0.000000000000000e+00  1.570796326794897e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 126
  1.678737078678630e-01  1.107914559783800e-01 -1.201066204240911e-01  0.000000000000000e+00 -5.067499133671709e-04 -2.490000000000000e-03  1.266240000000000e+00  0.000000000000000e+00
  2.913472554688359e-01 -8.777932559255808e-02 -1.160762383251106e-01  0.000000000000000e+00 -6.019288880309004e-04  7.385000000000000e-02  1.186560000000000e+00  0.000000000000000e+00
  3.454217773777155e-01  9.044285143894422e-02  4.396267064805161e-02  0.000000000000000e+00 -2.141607786756108e-02 -3.924000000000000e-02  1.030000000000000e-03  0.000000000000000e+00
  0.000000000000000e+00  1.570796326794897e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 127
  4.906304052472205e-02  5.254887558236034e-02 -8.323333251296718e-02  0.000000000000000e+00  7.174653417346842e-03  4.385400000000000e-01  1.010560000000000e+00  0.000000000000000e+00
  1.792375233214699e-01 -8.615520077696903e-02 -8.001283341988562e-02  0.000000000000000e+00  5.996214049566372e-03 -2.991100000000000e-01  9.412400000000000e-01  0.000000000000000e+00
  3.127044962314836e-01  8.568541319522810e-02 -1.705674168091353e-01  0.000000000000000e+00 -1.658000853445456e-02 -5.254000000000000e-02  1.125950000000000e+00  0.000000000000000e+00
  0.000000000000000e+00  1.570796326794897e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 128
  1.407042841898878e-03  3.849447872041192e-02  7.082155655807497e-04  0.000000000000000e+00  1.008089294604141e-02  5.448100000000000e-01 -3.780000000000000e-03  0.000000000000000e+00
  1.313215886291143e-01 -7.460535174358310e-02 -1.029785829782456e-05  0.000000000000000e+00  9.352324211373185e-03 -5.248100000000000e-01  3.912000000000000e-02  0.000000000000000e+00
  4.286943759384970e-03 -1.327018294224660e-02 -3.775459460039981e-01  0.000000000000000e+00 -3.273512325515239e-03 -1.194300000000000e-01  1.958650000000000e+00  0.000000000000000e+00
  0.000000000000000e+00  1.570796326794897e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 129
  9.524233018886392e-02  2.794094985321226e-02  1.139107849057887e-01  0.000000000000000e+00  1.121721828981382e-02  2.376000000000000e-01 -1.542200000000000e+00  0.000000000000000e+00
  9.011306859306728e-02 -1.032598671408459e-01  5.475989132175574e-02  0.000000000000000e+00  6.117423655933821e-03 -5.102500000000000e-01 -7.486500000000000e-01  0.000000000000000e+00
 -4.651151545870062e-01  7.891816430790115e-03 -2.742668408636264e-01  0.000000000000000e+00  2.269693542331955e-02  3.217300000000000e-01  2.055800000000000e+00  0.000000000000000e+00
  0.000000000000000e+00  1.570796326794897e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 130
  2.623564416821746e-01  5.808965429768637e-02  1.707645358357750e-01  0.000000000000000e+00 -4.543862605751736e-04 -1.878000000000000e-02 -2.002020000000000e+00  0.000000000000000e+00
  1.684790837689066e-01 -1.547721953554186e-01  7.885802396149831e-02  0.000000000000000e+00 -6.305340499751684e-04  2.073900000000000e-01 -1.030930000000000e+00  0.000000000000000e+00
 -5.528906679164912e-01  2.927524095139213e-02  1.044278052789442e-03  0.000000000000000e+00  2.573306763840301e-02  3.617900000000000e-01 -7.915999999999999e-02  0.000000000000000e+00
  0.000000000000000e+00  1.570796326794897e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 131
  4.367714018604306e-01  8.732405831566076e-02  1.428079866875722e-01  0.000000000000000e+00 -1.128499192578540e-02 -5.234200000000000e-01 -1.469810000000000e+00  0.000000000000000e+00
  2.478291165160960e-01 -2.064991767053567e-01  6.615130589810504e-02  0.000000000000000e+00 -5.505730872576914e-03  7.902600000000000e-01 -5.971900000000000e-01  0.000000000000000e+00
 -4.630265984814079e-01  9.943087103441987e-03  2.244101553166917e-01  0.000000000000000e+00  2.139949385595648e-02  8.576800000000000e-01 -1.689060000000000e+00  0.000000000000000e+00
  0.000000000000000e+00  1.570796326794897e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 132
  5.479724150573584e-01  9.548078579553201e-02 -2.014277898689590e-04  0.000000000000000e+00 -1.497876867803610e-02 -6.401600000000000e-01  5.077000000000000e-02  0.000000000000000e+00
  3.007816955651262e-01 -2.442883882417705e-01  1.812041658983965e-04  0.000000000000000e+00 -6.523197413260462e-03  7.980699999999999e-01  7.490000000000000e-03  0.000000000000000e+00
 -1.040703572830860e-01  1.544983673900159e-02  3.696711710748335e-01  0.000000000000000e+00  3.653629307638351e-04  3.109800000000000e-01 -2.287120000000000e+00  0.000000000000000e+00
  0.000000000000000e+00  1.570796326794897e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 133
  4.363685462807483e-01  8.610197471174186e-02 -1.423551149217297e-01  0.000000000000000e+00 -1.077059381442459e-02 -4.464200000000000e-01  1.362840000000000e+00  0.000000000000000e+00
  2.481915248479940e-01 -2.079581162455921e-01 -6.627049407305215e-02  0.000000000000000e+00 -5.430976049396598e-03  7.071600000000000e-01  5.795900000000000e-01  0.000000000000000e+00
  2.763157436682530e-01  2.102744013431960e-02  2.490333522772560e-01  0.000000000000000e+00 -1.649142703817154e-02 -2.055000000000000e-02 -1.390560000000000e+00  0.000000000000000e+00
  0.000000000000000e+00  1.570796326794897e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 134
  2.632621852138625e-01  5.720723398376441e-02 -1.700449994226264e-01  0.000000000000000e+00 -1.065863479609970e-03 -4.253000000000000e-02  1.909330000000000e+00  0.000000000000000e+00
  1.682407074192579e-01 -1.541989479097440e-01 -7.905501817691689e-02  0.000000000000000e+00 -5.856430159099715e-04  9.082000000000000e-02  1.033610000000000e+00  0.000000000000000e+00
  3.939963472713754e-01  2.388063354583696e-02  4.762950997907062e-02  0.000000000000000e+00 -2.094783687874171e-02 -4.100000000000000e-01 -2.307200000000000e-01  0.000000000000000e+00
  0.000000000000000e+00  1.570796326794897e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 135
  9.627854743555050e-02  2.902438147088655e-02 -1.143636566716732e-01  0.000000000000000e+00  1.075749343557652e-02  3.469400000000000e-01  1.663240000000000e+00  0.000000000000000e+00
  9.008148849426575e-02 -1.035239499959894e-01 -5.464070314693106e-02  0.000000000000000e+00  6.271281286992836e-03 -4.840300000000000e-01  7.712000000000000e-01  0.000000000000000e+00
  3.715747636263675e-01  1.376278527215305e-02 -1.991766667303703e-01  0.000000000000000e+00 -2.046587119072552e-02 -3.600300000000000e-01  1.377570000000000e+00  0.000000000000000e+00
  0.000000000000000e+00  1.570796326794897e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 136
  3.453487187059667e-02  1.816549261779515e-02 -5.181086233216848e-04  0.000000000000000e+00  1.385255258610611e-02  5.478700000000000e-01  4.167000000000000e-02  0.000000000000000e+00
  5.895930112542040e-02 -7.957147484099424e-02  1.579004939776009e-05  0.000000000000000e+00  6.374641272154839e-03 -8.842400000000000e-01 -1.387000000000000e-02  0.000000000000000e+00
 -4.356986189292662e-03 -1.065608522900180e-03 -4.183449591067425e-01  0.000000000000000e+00 -2.642176160912169e-03  1.212800000000000e-01  2.555270000000000e+00  0.000000000000000e+00
  0.000000000000000e+00  1.570796326794897e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 137
  1.063613713622944e-01 -1.092590524185001e-02  1.221707630592371e-01  0.000000000000000e+00  9.829259658217199e-03 -2.144300000000000e-01 -1.545820000000000e+00  0.000000000000000e+00
 -2.730280667683203e-02 -1.118917989534662e-01  5.164299659421058e-03  0.000000000000000e+00  4.680185897969649e-04 -7.999200000000000e-01  1.279700000000000e-01  0.000000000000000e+00
 -4.266037629150850e-01  6.349446168359708e-02 -2.431065696589246e-01  0.000000000000000e+00  2.003005480390738e-02 -4.104400000000000e-01  1.606340000000000e+00  0.000000000000000e+00
  0.000000000000000e+00  1.570796326794897e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 138
  2.820795541958760e-01 -2.068326426601491e-02  1.781081311325782e-01  0.000000000000000e+00  2.269848872782504e-04  3.957000000000000e-02 -1.825940000000000e+00  0.000000000000000e+00
 -1.749276173392714e-02 -1.797057894254167e-01  1.251281320550492e-02  0.000000000000000e+00  7.108573447518643e-04  8.802000000000000e-02 -7.303999999999999e-02  0.000000000000000e+00
 -4.840574126042607e-01  9.068143246058111e-02  8.975610180108146e-03  0.000000000000000e+00  2.417131123832680e-02 -7.907500000000000e-01  1.283200000000000e-01  0.000000000000000e+00
  0.000000000000000e+00  1.570796326794897e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 139
  4.625776336273347e-01 -2.381433052711941e-02  1.419232189069653e-01  0.000000000000000e+00 -1.050881341237019e-02  2.315200000000000e-01 -1.665860000000000e+00  0.000000000000000e+00
 -2.277180265739427e-03 -2.517629933418136e-01  1.105631463902559e-02  0.000000000000000e+00 -3.579459266877968e-04  8.359400000000000e-01 -1.832400000000000e-01  0.000000000000000e+00
 -4.086525425548597e-01  8.038636400806895e-02  1.952050818901334e-01  0.000000000000000e+00  2.215555322487869e-02 -4.792000000000000e-01 -1.432320000000000e+00  0.000000000000000e+00
  0.000000000000000e+00  1.570796326794897e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 140
  5.659259920097787e-01 -5.219342368555881e-02 -5.487014154871017e-04  0.000000000000000e+00 -1.644930513091673e-02  3.863600000000000e-01 -3.298000000000000e-02  0.000000000000000e+00
  4.619867544241805e-03 -2.883864873181819e-01 -1.124526126857016e-03  0.000000000000000e+00 -1.158661620187209e-03  1.054970000000000e+00  4.704000000000000e-02  0.000000000000000e+00
 -9.364724882399345e-02  3.160066249127384e-02  3.377432888794417e-01  0.000000000000000e+00  2.565775335149414e-03  8.261000000000000e-02 -2.500070000000000e+00  0.000000000000000e+00
  0.000000000000000e+00  1.570796326794897e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 141
  4.614802307963656e-01 -2.418659331461855e-02 -1.418189080871936e-01  0.000000000000000e+00 -1.084775731741008e-02  2.737200000000000e-01  1.376840000000000e+00  0.000000000000000e+00
 -4.526232519513390e-03 -2.519170798141660e-01 -1.083525394733375e-02  0.000000000000000e+00  1.304013984286533e-04  8.489100000000001e-01  1.749800000000000e-01  0.000000000000000e+00
  2.668340352039679e-01 -3.426125262355554e-02  2.434151466467064e-01  0.000000000000000e+00 -1.695863867450762e-02  3.811400000000000e-01 -1.840910000000000e+00  0.000000000000000e+00
  0.000000000000000e+00  1.570796326794897e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 142
  2.822881758353544e-01 -2.101054656217263e-02 -1.771842136649020e-01  0.000000000000000e+00 -1.108080018308401e-03  9.316000000000001e-02  2.124250000000000e+00  0.000000000000000e+00
 -1.705064035070665e-02 -1.798481668514508e-01 -1.164207207541509e-02  0.000000000000000e+00  7.675718459583310e-04  1.704500000000000e-01  7.115000000000000e-02  0.000000000000000e+00
  3.931830444693981e-01 -1.445279452604962e-02  3.669801578590225e-02  0.000000000000000e+00 -2.819333434819403e-02  2.005400000000000e-01 -3.498500000000000e-01  0.000000000000000e+00
  0.000000000000000e+00  1.570796326794897e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 143
  1.071118034665522e-01 -1.214821601996497e-02 -1.222750738789498e-01  0.000000000000000e+00  1.087948598052122e-02 -2.024300000000000e-01  1.684220000000000e+00  0.000000000000000e+00
 -2.781037667061215e-02 -1.116323692045818e-01 -5.385360351021069e-03  0.000000000000000e+00  8.219597938151509e-04 -8.746500000000000e-01 -1.324600000000000e-01  0.000000000000000e+00
  3.402300667758085e-01 -2.275903968737034e-02 -1.955136588778856e-01  0.000000000000000e+00 -2.241729467650729e-02  3.681200000000000e-01  1.738760000000000e+00  0.000000000000000e+00
  0.000000000000000e+00  1.570796326794897e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 144
  3.773802807746905e-02 -1.103695556283010e-02 -3.752160521300132e-04  0.000000000000000e+00  1.615818139482082e-02 -3.275100000000000e-01 -9.551999999999999e-02  0.000000000000000e+00
 -2.782136105280398e-02 -8.494577452940413e-02  2.537849968590267e-04  0.000000000000000e+00 -4.967763127133964e-04 -1.038420000000000e+00 -3.209000000000000e-02  0.000000000000000e+00
  2.155726713674517e-03  9.736301635038235e-03 -3.834169148454226e-01  0.000000000000000e+00 -1.236995704531461e-03  3.052000000000000e-02  2.650600000000000e+00  0.000000000000000e+00
  0.000000000000000e+00  1.570796326794897e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 145
  7.339051970515327e-02 -4.732273313278239e-02  1.042644762025543e-01  0.000000000000000e+00  8.805044781716594e-03 -5.211300000000000e-01 -1.277650000000000e+00  0.000000000000000e+00
 -1.336705293138588e-01 -9.014741346022398e-02 -4.000012357426922e-02  0.000000000000000e+00 -3.187225285558041e-03 -5.718500000000000e-01  5.345200000000000e-01  0.000000000000000e+00
 -3.381262312198936e-01  9.735935643058605e-02 -1.933217100380697e-01  0.000000000000000e+00  1.604531712693925e-02 -4.933900000000000e-01  1.265420000000000e+00  0.000000000000000e+00
  0.000000000000000e+00  1.570796326794897e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 146
  2.209899131500417e-01 -8.514216372062572e-02  1.578761105504943e-01  0.000000000000000e+00 -2.722304151082933e-05 -2.700000000000000e-04 -1.461720000000000e+00  0.000000000000000e+00
 -1.909324950819471e-01 -1.539388697772139e-01 -6.101317042676556e-02  0.000000000000000e+00  2.561115500878154e-04 -1.163500000000000e-01  5.754300000000000e-01  0.000000000000000e+00
 -3.715278029953241e-01  1.229662140222440e-01  1.793618037730350e-02  0.000000000000000e+00  1.255586953345256e-02 -4.584900000000000e-01 -1.503100000000000e-01  0.000000000000000e+00
  0.000000000000000e+00  1.570796326794897e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 147
  3.891427408062287e-01 -1.423990352669570e-01  1.112978272680518e-01  0.000000000000000e+00 -8.718226375360835e-03  5.529300000000000e-01 -1.191900000000000e+00  0.000000000000000e+00
 -2.556968701674765e-01 -1.996498041651762e-01 -4.252939199460027e-02  0.000000000000000e+00  3.748458563185203e-03  5.089200000000000e-01  4.325700000000000e-01  0.000000000000000e+00
 -3.022538704652594e-01  1.183692975733333e-01  1.653293853473712e-01  0.000000000000000e+00  1.337849369368974e-02 -7.317700000000000e-01 -8.131300000000000e-01  0.000000000000000e+00
  0.000000000000000e+00  1.570796326794897e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 148
  4.435855676862372e-01 -1.754329656266685e-01 -5.736905773829418e-04  0.000000000000000e+00 -1.089220773567040e-02  7.586300000000000e-01  8.823000000000000e-02  0.000000000000000e+00
 -2.759912790711726e-01 -2.246583056193716e-01  2.711769350458026e-05  0.000000000000000e+00  4.210298438047225e-03  8.082200000000000e-01 -1.586000000000000e-02  0.000000000000000e+00
 -4.086903230062217e-02  5.638838428383774e-02  2.550235544431789e-01  0.000000000000000e+00  1.854664356211995e-03 -2.637900000000000e-01 -1.450280000000000e+00  0.000000000000000e+00
  0.000000000000000e+00  1.570796326794897e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 149
  3.879953596514644e-01 -1.414445628694984e-01 -1.111722377983818e-01  0.000000000000000e+00 -7.771440038303046e-03  4.999900000000000e-01  1.002170000000000e+00  0.000000000000000e+00
 -2.556426347804044e-01 -1.989954706204923e-01  4.226782639364646e-02  0.000000000000000e+00  3.577056432696984e-03  4.860100000000000e-01 -3.177600000000000e-01  0.000000000000000e+00
  2.077932384211290e-01 -4.328341240861528e-02  2.029798952599422e-01  0.000000000000000e+00 -1.014975819942108e-02  3.456000000000000e-01 -1.198260000000000e+00  0.000000000000000e+00
  0.000000000000000e+00  1.570796326794897e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 150
  2.212410920894790e-01 -8.617061918225111e-02 -1.580066221279421e-01  0.000000000000000e+00 -9.938871210126571e-05  1.054800000000000e-01  1.557780000000000e+00  0.000000000000000e+00
 -1.914556262838322e-01 -1.536485845937119e-01  6.122969243270919e-02  0.000000000000000e+00  7.572739875389353e-04 -1.195000000000000e-01 -6.219000000000000e-01  0.000000000000000e+00
  3.650907582192935e-01 -5.253723367935873e-02  5.913172291526966e-02  0.000000000000000e+00 -1.763789691400333e-02  6.903500000000000e-01 -2.589100000000000e-01  0.000000000000000e+00
  0.000000000000000e+00  1.570796326794897e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 151
  7.198211539565871e-02 -4.735457538305574e-02 -1.043900656723133e-01  0.000000000000000e+00  8.568556440421427e-03 -6.121300000000000e-01  1.071750000000000e+00  0.000000000000000e+00
 -1.331832499149608e-01 -9.042816358981656e-02  4.026168917522971e-02  0.000000000000000e+00 -2.999308441638981e-03 -6.477000000000001e-01 -5.046400000000000e-01  0.000000000000000e+00
  3.260566842516282e-01 -4.877735232479496e-02 -1.749875705692304e-01  0.000000000000000e+00 -1.420803738974159e-02  6.241300000000000e-01  1.043950000000000e+00  0.000000000000000e+00
  0.000000000000000e+00  1.570796326794897e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 152
  1.246096074492959e-02 -3.111684515620105e-02  7.042021547418471e-04  0.000000000000000e+00  1.034903422568622e-02 -7.790500000000000e-01  2.188000000000000e-02  0.000000000000000e+00
 -1.109322479333477e-01 -6.963755047665975e-02 -2.436396994415467e-04  0.000000000000000e+00 -4.192219975666918e-03 -6.511600000000000e-01 -1.719000000000000e-02  0.000000000000000e+00
  1.511561708077705e-02  1.680143368209242e-02 -3.320914577357387e-01  0.000000000000000e+00 -2.251594095203387e-03 -6.276000000000000e-02  1.789370000000000e+00  0.000000000000000e+00
  0.000000000000000e+00  1.570796326794897e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 153
  1.171590509671640e-02 -8.772691389529855e-02  6.814544449474229e-02  0.000000000000000e+00  4.190720312604992e-03 -6.429200000000000e-01 -5.948099999999999e-01  0.000000000000000e+00
 -2.075976335972949e-01 -4.693485391763234e-02 -7.913701964113404e-02  0.000000000000000e+00 -5.627474441817836e-03 -1.645900000000000e-01  7.023100000000000e-01  0.000000000000000e+00
 -2.318850500539782e-01  1.033950216627374e-01 -1.369417893187639e-01  0.000000000000000e+00  1.136862586368649e-02 -3.199400000000000e-01  1.131920000000000e+00  0.000000000000000e+00
  0.000000000000000e+00  1.570796326794897e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 154
  1.117952267545580e-01 -1.472424649157397e-01  8.303182899842357e-02  0.000000000000000e+00  4.234527070896815e-04 -5.545000000000000e-02 -8.256800000000000e-01  0.000000000000000e+00
 -3.253705012884281e-01 -7.288656291203505e-02 -9.698957749939877e-02  0.000000000000000e+00 -2.399019582774303e-04 -8.656999999999999e-02  1.019060000000000e+00  0.000000000000000e+00
 -2.381249845597134e-01  1.008172372157402e-01  2.998555132287615e-02  0.000000000000000e+00  1.613441329939227e-02  7.023000000000000e-02 -7.803000000000000e-02  0.000000000000000e+00
  0.000000000000000e+00  1.570796326794897e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 155
  1.777795630935322e-01 -2.209074473381245e-01  5.163241700092561e-02  0.000000000000000e+00 -4.511793180626302e-03  6.703500000000000e-01 -7.189200000000000e-01  0.000000000000000e+00
 -4.015767885962338e-01 -8.320413970843495e-02 -5.966312120296647e-02  0.000000000000000e+00  5.228451502759350e-03  1.839400000000000e-01  8.112200000000001e-01  0.000000000000000e+00
 -1.719139474082107e-01  8.747488523007201e-02  1.286272521516917e-01  0.000000000000000e+00  1.023250669849552e-02 -1.527000000000000e-01 -1.099600000000000e+00  0.000000000000000e+00
  0.000000000000000e+00  1.570796326794897e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 156
  2.150600607564776e-01 -2.436640169320827e-01  4.057709818824327e-04  0.000000000000000e+00 -7.420455900788360e-03  8.972000000000000e-01 -5.824000000000000e-02  0.000000000000000e+00
 -4.446967436945204e-01 -9.332456972876463e-02 -4.701925820803712e-04  0.000000000000000e+00  8.680446167331449e-03  4.377900000000000e-01  6.700000000000000e-02  0.000000000000000e+00
  1.912951974360889e-02  4.474515006303940e-02  1.760905788975067e-01  0.000000000000000e+00 -2.029253967634279e-03 -2.466800000000000e-01 -1.436270000000000e+00  0.000000000000000e+00
  0.000000000000000e+00  1.570796326794897e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 157
  1.785911050573395e-01 -2.206182924451482e-01 -5.255656164281702e-02  0.000000000000000e+00 -5.107292481105748e-03  4.853500000000000e-01  7.201000000000000e-01  0.000000000000000e+00
 -4.025171737605442e-01 -8.333946119464458e-02  6.017446707824763e-02  0.000000000000000e+00  5.918522429760875e-03  2.748400000000000e-01 -7.968600000000000e-01  0.000000000000000e+00
  1.802672103868295e-01 -1.019562156936209e-02  1.344895286834940e-01  0.000000000000000e+00 -1.125402462511359e-02  2.301900000000000e-01 -8.861800000000000e-01  0.000000000000000e+00
  0.000000000000000e+00  1.570796326794897e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 158
  1.099469374709329e-01 -1.478770003161448e-01 -8.309422617846454e-02  0.000000000000000e+00  3.783586285074185e-04 -1.758000000000000e-02  9.060100000000000e-01  0.000000000000000e+00
 -3.243478095381111e-01 -7.211342259468503e-02  9.692523495515645e-02  0.000000000000000e+00 -8.428987701786239e-06 -6.308000000000000e-02 -1.097430000000000e+00  0.000000000000000e+00
  2.881085771106786e-01 -3.253434234271343e-02  3.120407586968697e-02  0.000000000000000e+00 -1.641880050476596e-02  1.950600000000000e-01 -3.544000000000000e-02  0.000000000000000e+00
  0.000000000000000e+00  1.570796326794897e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 159
  1.240265270050187e-02 -8.685024866106027e-02 -6.722129985293179e-02  0.000000000000000e+00  4.477414151805460e-03 -5.643000000000000e-01  6.207900000000000e-01  0.000000000000000e+00
 -2.086667038501996e-01 -4.729287612470258e-02  7.862567376598990e-02  0.000000000000000e+00 -5.770652812509484e-03 -1.795700000000000e-01 -7.482400000000000e-01  0.000000000000000e+00
  2.426753621261893e-01 -4.540273471494109e-02 -1.261749915164021e-01  0.000000000000000e+00 -1.185413709898888e-02  2.159600000000000e-01  8.635699999999999e-01  0.000000000000000e+00
  0.000000000000000e+00  1.570796326794897e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 160
 -2.449566223487653e-02 -6.195282727759256e-02 -3.433738019223958e-04  0.000000000000000e+00  7.212856545151698e-03 -8.064700000000000e-01 -2.653000000000000e-02  0.000000000000000e+00
 -1.670964620061415e-01 -4.016290601594016e-02  5.345351264597273e-04  0.000000000000000e+00 -8.276998963035853e-03 -3.697300000000000e-01  1.299000000000000e-02  0.000000000000000e+00
  3.575859407783803e-02  2.255431292380669e-02 -2.372802060900501e-01  0.000000000000000e+00 -2.207789430182478e-03  1.833800000000000e-01  1.501030000000000e+00  0.000000000000000e+00
  0.000000000000000e+00  1.570796326794897e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 161
 -1.020633080854451e-01 -1.020675881104778e-01  1.897483856435024e-02  0.000000000000000e+00  1.715960312660253e-03 -3.829100000000000e-01 -2.026900000000000e-01  0.000000000000000e+00
 -2.275402371491254e-01 -1.076786018589102e-02 -7.272378047040401e-02  0.000000000000000e+00 -5.043433315107780e-03  1.193100000000000e-01  7.216100000000000e-01  0.000000000000000e+00
 -1.313361878944493e-01  9.233891863779758e-02 -1.150587857461411e-01  0.000000000000000e+00  1.091227961417241e-02 -2.261000000000000e-01  8.082700000000000e-01  0.000000000000000e+00
  0.000000000000000e+00  1.570796326794897e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 162
 -7.349501668152750e-02 -1.581210043371292e-01  2.469557710775040e-02  0.000000000000000e+00 -6.690280162568313e-05  1.016000000000000e-02 -2.637600000000000e-01  0.000000000000000e+00
 -3.367056209060618e-01  8.944185760564403e-03 -9.728245621765717e-02  0.000000000000000e+00 -3.872376124754440e-04  3.446000000000000e-02  9.901400000000000e-01  0.000000000000000e+00
 -1.698933285638098e-01  8.239417313318208e-02  2.016043944665185e-03  0.000000000000000e+00  1.329380086215757e-02 -3.179800000000000e-01 -8.670000000000001e-03  0.000000000000000e+00
  0.000000000000000e+00  1.570796326794897e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 163
 -5.267215387013317e-02 -1.969713893027275e-01  1.487627525190340e-02  0.000000000000000e+00 -1.166880273442341e-03  5.498700000000000e-01 -1.518400000000000e-01  0.000000000000000e+00
 -4.221051495845292e-01  9.344810588855043e-03 -6.296739881130228e-02  0.000000000000000e+00  5.856849700593608e-03 -8.796000000000000e-02  9.082200000000000e-01  0.000000000000000e+00
 -1.273041000051354e-01  6.310027688437404e-02  1.092572981946197e-01  0.000000000000000e+00  1.076937118348349e-02 -9.016000000000000e-02 -1.012950000000000e+00  0.000000000000000e+00
  0.000000000000000e+00  1.570796326794897e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 164
 -4.374246617786337e-02 -2.187738272605582e-01 -2.845356843465766e-04  0.000000000000000e+00 -1.588894210684987e-03  8.207100000000001e-01 -9.768000000000000e-02  0.000000000000000e+00
 -4.626404185287363e-01  1.144290386788255e-02 -1.082037926315796e-04  0.000000000000000e+00  8.837011753761184e-03 -1.032800000000000e-01  7.983999999999999e-02  0.000000000000000e+00
  4.862126782538202e-02  3.238125476004546e-02  1.573530476438114e-01  0.000000000000000e+00 -2.123554088615393e-03  8.265000000000000e-02 -1.088610000000000e+00  0.000000000000000e+00
  0.000000000000000e+00  1.570796326794897e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 165
 -5.324122523880093e-02 -1.974882106056455e-01 -1.538522118244682e-02  0.000000000000000e+00 -2.199273421202268e-03  6.244800000000000e-01  1.640200000000000e-01  0.000000000000000e+00
 -4.223215571697944e-01  1.022687936294486e-02  6.347897352779444e-02  0.000000000000000e+00  6.706384870466146e-03 -1.516300000000000e-01 -7.535500000000001e-01  0.000000000000000e+00
  1.874019952824778e-01  1.245796667893169e-02  1.257004028542407e-01  0.000000000000000e+00 -6.329659726995063e-03  3.474600000000000e-01 -7.306000000000000e-01  0.000000000000000e+00
  0.000000000000000e+00  1.570796326794897e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 166
 -7.451290854282250e-02 -1.571135246266081e-01 -2.423857834377935e-02  0.000000000000000e+00  2.450073737491239e-04  1.491000000000000e-02  4.323400000000000e-01  0.000000000000000e+00
 -3.356824714731534e-01  7.017113209759236e-03  9.727627750271414e-02  0.000000000000000e+00  3.592426939797860e-04  1.608000000000000e-02 -1.202280000000000e+00  0.000000000000000e+00
  3.000220735338505e-01 -6.508481120685902e-03  2.392460976964459e-02  0.000000000000000e+00 -1.448893623401319e-02  2.921300000000000e-01 -3.254900000000000e-01  0.000000000000000e+00
  0.000000000000000e+00  1.570796326794897e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 167
 -1.017183819265254e-01 -1.024639313630733e-01 -1.846589263364832e-02  0.000000000000000e+00  2.051269430564847e-03 -4.647300000000000e-01  1.744800000000000e-01  0.000000000000000e+00
 -2.277690021643563e-01 -9.391951895717607e-03  7.221220575395694e-02  0.000000000000000e+00 -5.234515796988262e-03  1.121800000000000e-01 -8.045200000000000e-01  0.000000000000000e+00
  2.352512148217373e-01 -2.542672091432531e-03 -1.198989153027252e-01  0.000000000000000e+00 -1.115863796542234e-02  2.548300000000000e-01  9.712700000000000e-01  0.000000000000000e+00
  0.000000000000000e+00  1.570796326794897e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 168
 -1.114446938101971e-01 -8.097215412255084e-02 -1.724630794659749e-04  0.000000000000000e+00  2.040516518377725e-03 -7.095200000000000e-01 -3.081000000000000e-02  0.000000000000000e+00
 -1.912580599652433e-01 -1.193659082306544e-02  1.143825076197237e-04  0.000000000000000e+00 -7.976301500539362e-03  1.273900000000000e-01  1.743000000000000e-02  0.000000000000000e+00
  6.022424292843451e-02  1.728151222392339e-02 -1.832937013581273e-01  0.000000000000000e+00  5.960522503511015e-04  1.228400000000000e-01  1.371440000000000e+00  0.000000000000000e+00
  0.000000000000000e+00  1.570796326794897e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 169
 -1.924192711242029e-01 -7.917759153703480e-02 -9.003405719893415e-03  0.000000000000000e+00 -1.550463908715077e-04 -3.828400000000000e-01  1.313200000000000e-01  0.000000000000000e+00
 -2.291333539690980e-01  8.445082894727996e-03 -5.825624305751623e-02  0.000000000000000e+00 -4.266173854382781e-03  9.551000000000000e-02  6.349200000000000e-01  0.000000000000000e+00
 -4.720721277835836e-02  4.770991384205259e-02 -7.182912840954998e-02  0.000000000000000e+00  7.504608353678967e-03 -2.784700000000000e-01  6.661200000000000e-01  0.000000000000000e+00
  0.000000000000000e+00  1.570796326794897e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 170
 -2.044467819197102e-01 -1.077814735654443e-01 -1.187197219394700e-02  0.000000000000000e+00  6.836807520767367e-04 -2.916000000000000e-02  1.372600000000000e-01  0.000000000000000e+00
 -3.074821297673307e-01  4.236546534649619e-02 -7.687690672473854e-02  0.000000000000000e+00  1.405466957448143e-04  4.070000000000000e-03  7.898600000000000e-01  0.000000000000000e+00
 -7.333663829332909e-02  5.728723771098152e-02  7.469095694372426e-04  0.000000000000000e+00  1.067970314847277e-02 -3.559200000000000e-01  7.782000000000000e-02  0.000000000000000e+00
  0.000000000000000e+00  1.570796326794897e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 171
 -2.161632155119590e-01 -1.300126649616342e-01 -9.020405922509505e-03  0.000000000000000e+00  1.320071408313195e-03  2.813700000000000e-01  1.036700000000000e-01  0.000000000000000e+00
 -3.828871674185891e-01  6.823345656689958e-02 -5.716440309570136e-02  0.000000000000000e+00  4.252519657094424e-03 -1.976700000000000e-01  6.945200000000000e-01  0.000000000000000e+00
 -4.571339363947115e-02  5.475503070272106e-02  7.861433377849651e-02  0.000000000000000e+00  8.811371279314990e-03 -3.502500000000000e-01 -7.125800000000000e-01  0.000000000000000e+00
  0.000000000000000e+00  1.570796326794897e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 172
 -2.224875937645729e-01 -1.416843452366396e-01 -1.110503209921058e-04  0.000000000000000e+00  1.778243905519485e-03  4.203500000000000e-01  1.668000000000000e-02  0.000000000000000e+00
 -4.218109359587388e-01  7.813324543792000e-02  4.118761919674405e-04  0.000000000000000e+00  7.512440194237170e-03 -4.388700000000000e-01 -3.000000000000000e-03  0.000000000000000e+00
  8.389202926368934e-02  6.730420944504704e-03  1.254482686920728e-01  0.000000000000000e+00 -6.223579239450251e-04  4.116000000000000e-02 -9.925100000000000e-01  0.000000000000000e+00
  0.000000000000000e+00  1.570796326794897e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 173
 -2.163853161539154e-01 -1.297645150115164e-01  9.103740991102432e-03  0.000000000000000e+00  1.490982130858787e-03  3.905800000000000e-01 -1.200000000000000e-01  0.000000000000000e+00
 -3.820634150346349e-01  6.861142610689847e-02  5.574867642006995e-02  0.000000000000000e+00  4.225668945038542e-03 -2.893200000000000e-01 -6.208600000000000e-01  0.000000000000000e+00
  2.051831437447224e-01 -2.407174998265664e-02  9.559979280278207e-02  0.000000000000000e+00 -5.339193932414759e-03  3.503000000000000e-02 -6.049900000000000e-01  0.000000000000000e+00
  0.000000000000000e+00  1.570796326794897e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 174
 -2.042801117823266e-01 -1.066652910007053e-01  1.193005306406596e-02  0.000000000000000e+00  3.864990373254329e-04 -3.590000000000000e-02 -2.263400000000000e-01  0.000000000000000e+00
 -3.103135831185665e-01  4.312960457291187e-02  7.730640369648370e-02  0.000000000000000e+00  1.807846235709343e-04 -1.928000000000000e-02 -9.288300000000000e-01  0.000000000000000e+00
  2.750916148692705e-01 -6.118756848765703e-02  1.620343709930567e-02  0.000000000000000e+00 -1.146681464942567e-02  3.870500000000000e-01 -1.511300000000000e-01  0.000000000000000e+00
  0.000000000000000e+00  1.570796326794897e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 175
 -1.925252100257021e-01 -7.923726262667308e-02  8.920070651162522e-03  0.000000000000000e+00 -7.054137504811167e-04 -4.581700000000000e-01 -1.019100000000000e-01  0.000000000000000e+00
 -2.274506076416574e-01  8.700927463254300e-03  5.967196973315207e-02  0.000000000000000e+00 -4.486014059079536e-03  1.721200000000000e-01 -6.350300000000000e-01  0.000000000000000e+00
  2.375900179433287e-01 -4.158869798468157e-02 -1.023849981717741e-01  0.000000000000000e+00 -7.499518777729967e-03  2.330200000000000e-01  6.811800000000000e-01  0.000000000000000e+00
  0.000000000000000e+00  1.570796326794897e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 176
 -1.864399704799747e-01 -6.658892260741375e-02  5.296945073517828e-05  0.000000000000000e+00 -7.244963831959522e-04 -4.544400000000000e-01  5.216000000000000e-02  0.000000000000000e+00
 -1.909696436522763e-01  1.618747045092257e-03 -8.413731637081784e-04  0.000000000000000e+00 -6.828814963656737e-03  2.421700000000000e-01  2.095000000000000e-02  0.000000000000000e+00
  7.032161852575915e-02 -9.314038388673521e-03 -1.423986153608613e-01  0.000000000000000e+00 -1.304418289717647e-04  1.243000000000000e-02  9.715200000000001e-01  0.000000000000000e+00
  0.000000000000000e+00  1.570796326794897e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 177
 -2.604184911594528e-01 -6.828564883793463e-02 -2.221771239367653e-02  0.000000000000000e+00 -2.822336524535021e-03 -3.818600000000000e-01  3.128100000000000e-01  0.000000000000000e+00
 -2.106500713597091e-01  4.121160939356305e-02 -3.197706216899239e-02  0.000000000000000e+00 -3.949266800108795e-03 -1.286600000000000e-01  4.932000000000000e-01  0.000000000000000e+00
 -3.591636021033560e-02 -2.256935290673926e-02 -4.845750964646830e-02  0.000000000000000e+00  6.471538805265482e-03  1.268000000000000e-02  4.461900000000000e-01  0.000000000000000e+00
  0.000000000000000e+00  1.570796326794897e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 178
 -2.890579638124119e-01 -7.646119391397066e-02 -2.613949631690930e-02  0.000000000000000e+00 -3.643495528935919e-04 -3.107000000000000e-02  4.648800000000000e-01  0.000000000000000e+00
 -2.519746902130891e-01  5.977750371065507e-02 -3.749408254550688e-02  0.000000000000000e+00 -3.516527909965261e-04 -1.096400000000000e-01  6.534500000000000e-01  0.000000000000000e+00
 -5.531885314182957e-02 -2.989525423919765e-02  9.061160805321752e-03  0.000000000000000e+00  7.340140707908138e-03  3.848000000000000e-01 -9.805999999999999e-02  0.000000000000000e+00
  0.000000000000000e+00  1.570796326794897e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 179
 -3.126974837933294e-01 -8.881000475168092e-02 -1.902659641932984e-02  0.000000000000000e+00  2.385594126808346e-03  2.863000000000000e-01  3.155000000000000e-01  0.000000000000000e+00
 -2.856382364507018e-01  7.705997976126372e-02 -2.719961871991453e-02  0.000000000000000e+00  3.432047331684993e-03 -2.348000000000000e-02  4.347500000000000e-01  0.000000000000000e+00
 -1.779403859968725e-02 -2.167764776039497e-02  5.870048142812150e-02  0.000000000000000e+00  4.801528840003073e-03  1.162700000000000e-01 -5.742699999999999e-01  0.000000000000000e+00
  0.000000000000000e+00  1.570796326794897e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 180
 -3.271111566511241e-01 -9.476571714160839e-02 -3.638573423959263e-05  0.000000000000000e+00  2.861145450194211e-03  3.798100000000000e-01  2.405000000000000e-02  0.000000000000000e+00
 -3.063739276528676e-01  9.048747162558335e-02  2.697657473604356e-04  0.000000000000000e+00  4.116130244847409e-03 -7.496000000000000e-02 -1.824000000000000e-02  0.000000000000000e+00
  6.208210971444506e-02 -4.191088529915932e-02  7.852626695842178e-02  0.000000000000000e+00 -1.449614170115140e-03  2.416000000000000e-02 -6.111500000000000e-01  0.000000000000000e+00
  0.000000000000000e+00  1.570796326794897e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 181
 -3.127702552617645e-01 -9.302681223488052e-02  1.963383305344833e-02  0.000000000000000e+00  2.629692803659121e-03  2.981400000000000e-01 -2.924800000000000e-01  0.000000000000000e+00
 -2.850987049559608e-01  8.090020368400028e-02  2.847533266277463e-02  0.000000000000000e+00  3.242109056299035e-03  6.601000000000000e-02 -3.761600000000000e-01  0.000000000000000e+00
  1.392584953171898e-01 -6.903558025340380e-02  5.778241342203994e-02  0.000000000000000e+00 -5.643481951626002e-03 -1.465000000000000e-01 -4.311400000000000e-01  0.000000000000000e+00
  0.000000000000000e+00  1.570796326794897e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 182
 -2.878434905441893e-01 -8.437654880741334e-02  2.628867404097755e-02  0.000000000000000e+00 -2.004812306992121e-04  1.362200000000000e-01 -4.599900000000000e-01  0.000000000000000e+00
 -2.494232623273127e-01  6.553797308552994e-02  3.736577885904827e-02  0.000000000000000e+00  1.706774663514932e-04  4.494000000000000e-02 -5.921200000000000e-01  0.000000000000000e+00
  1.776469365584928e-01 -8.959369286019540e-02  6.407661767608975e-03  0.000000000000000e+00 -8.168655051520167e-03 -5.128000000000000e-02 -9.873000000000000e-02  0.000000000000000e+00
  0.000000000000000e+00  1.570796326794897e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 183
 -2.601929071797773e-01 -7.304646280309798e-02  2.161047575955348e-02  0.000000000000000e+00 -2.478924860242489e-03 -1.371500000000000e-01 -3.278100000000000e-01  0.000000000000000e+00
 -2.103671472378380e-01  4.462809551714965e-02  3.070134822611590e-02  0.000000000000000e+00 -3.434450165325276e-03 -3.323000000000000e-02 -5.419700000000000e-01  0.000000000000000e+00
  1.520738188523841e-01 -8.188858952524455e-02 -6.802538520368491e-02  0.000000000000000e+00 -7.265912959580286e-03 -1.037700000000000e-01  6.045100000000000e-01  0.000000000000000e+00
  0.000000000000000e+00  1.570796326794897e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 184
 -2.446225390250565e-01 -6.686191026997546e-02 -1.127919898332198e-04  0.000000000000000e+00 -3.426014096144476e-03 -1.601490000000000e+00 -3.322000000000000e-02  0.000000000000000e+00
 -1.880205658750698e-01  3.310673722506267e-02 -1.414620609182064e-04  0.000000000000000e+00 -5.245538319399647e-03  1.449440000000000e+00 -4.942000000000000e-02  0.000000000000000e+00
  4.159616615109453e-02 -3.845220390646098e-02 -9.399508953134429e-02  0.000000000000000e+00  7.498260680624492e-04  1.442400000000000e-01  8.519700000000000e-01  0.000000000000000e+00
  0.000000000000000e+00  1.570796326794897e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 185
 -3.289905688000215e-01 -6.857207764059277e-02 -1.860268936388201e-02  0.000000000000000e+00 -4.892007065120690e-03 -2.763000000000000e-02  3.473500000000000e-01  0.000000000000000e+00
 -1.467101351820209e-01  6.393993617771304e-02 -3.158547657191371e-02  0.000000000000000e+00 -5.287950239469930e-03  1.710000000000000e-03  5.983600000000000e-01  0.000000000000000e+00
 -9.234591859183215e-02 -5.642955838149263e-02 -6.327217874226528e-02  0.000000000000000e+00  7.505637706169632e-03  1.509900000000000e-01  8.511900000000000e-01  0.000000000000000e+00
  0.000000000000000e+00  1.570796326794897e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 186
 -3.573691697477166e-01 -6.831120593526721e-02 -3.239632810761967e-02  0.000000000000000e+00 -1.378455177550725e-03 -5.244000000000000e-02  8.702200000000000e-01  0.000000000000000e+00
 -1.879271223460075e-01  6.404756786706155e-02 -4.102853635702328e-02  0.000000000000000e+00  2.866237228019985e-04  2.562800000000000e-01  1.134240000000000e+00  0.000000000000000e+00
 -1.331271467717049e-01 -7.780829362989300e-02  1.638614715761474e-03  0.000000000000000e+00  1.632970433221992e-02  2.215000000000000e-01  1.853900000000000e-01  0.000000000000000e+00
  0.000000000000000e+00  1.570796326794897e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 187
 -3.937832250154130e-01 -8.108574122202861e-02 -2.732492915000365e-02  0.000000000000000e+00  3.062459652991317e-03  3.181000000000000e-02  6.455000000000000e-01  0.000000000000000e+00
 -2.287672078960375e-01  5.687102855466743e-02 -2.645443518076540e-02  0.000000000000000e+00  5.196718843020198e-03  3.148000000000000e-01  6.237400000000000e-01  0.000000000000000e+00
 -8.906868916026688e-02 -7.127465056057784e-02  6.659870271855067e-02  0.000000000000000e+00  1.039188476833136e-02  9.427000000000001e-02 -1.023700000000000e+00  0.000000000000000e+00
  0.000000000000000e+00  1.570796326794897e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 188
 -4.120190280478099e-01 -8.490787139668905e-02 -4.327857804096863e-03  0.000000000000000e+00  5.605674811496208e-03  2.528100000000000e-01  1.619800000000000e-01  0.000000000000000e+00
 -2.408359927075661e-01  6.553793494531766e-02  4.252100114711166e-03  0.000000000000000e+00  7.083934868114206e-03  3.394200000000000e-01 -1.224000000000000e-02  0.000000000000000e+00
  7.025866540337776e-05 -6.201185104904403e-02  7.809033619909191e-02  0.000000000000000e+00 -4.067657734783126e-04 -6.304000000000000e-02 -1.157460000000000e+00  0.000000000000000e+00
  0.000000000000000e+00  1.570796326794897e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 189
 -4.024389406236056e-01 -8.966868536184865e-02  1.949290932533615e-02  0.000000000000000e+00  4.760548928627206e-03  2.447200000000000e-01 -3.484700000000000e-01  0.000000000000000e+00
 -2.202630076666164e-01  6.483569728933761e-02  3.079917788004119e-02  0.000000000000000e+00  5.069254241246601e-03  4.808000000000000e-02 -5.791100000000000e-01  0.000000000000000e+00
  6.711198323791046e-02 -7.214651207927189e-02  4.791698524173220e-02  0.000000000000000e+00 -7.921095789135080e-03 -2.402400000000000e-01 -7.408600000000000e-01  0.000000000000000e+00
  0.000000000000000e+00  1.570796326794897e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 190
 -3.730332093971868e-01 -8.518971885297791e-02  3.191040249591187e-02  0.000000000000000e+00  1.830001760613320e-03  1.969100000000000e-01 -7.025500000000000e-01  0.000000000000000e+00
 -1.792376369475314e-01  7.018562537981116e-02  4.103429552969726e-02  0.000000000000000e+00  7.729877566100690e-04 -1.805800000000000e-01 -9.085500000000000e-01  0.000000000000000e+00
  9.590422914883648e-02 -8.174270740964681e-02  3.350427827478103e-03  0.000000000000000e+00 -1.245287710296794e-02 -1.692500000000000e-01 -1.110900000000000e-01  0.000000000000000e+00
  0.000000000000000e+00  1.570796326794897e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 191
 -3.386181356318312e-01 -7.842522845205149e-02  2.643470918860200e-02  0.000000000000000e+00 -2.654833415070140e-03  1.783600000000000e-01 -7.025900000000000e-01  0.000000000000000e+00
 -1.381944166073848e-01  7.217273063050306e-02  2.724073387274445e-02  0.000000000000000e+00 -4.594065290823984e-03 -1.426800000000000e-01 -7.134000000000000e-01  0.000000000000000e+00
  7.381283889284683e-02 -7.826097995953638e-02 -5.124350921799931e-02  0.000000000000000e+00 -9.717944849805260e-03 -3.404000000000000e-02  9.301600000000000e-01  0.000000000000000e+00
  0.000000000000000e+00  1.570796326794897e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 192
 -3.201637910199300e-01 -7.554125199489950e-02  4.813783415857142e-03  0.000000000000000e+00 -5.315421909884710e-03 -4.831000000000000e-02 -2.119500000000000e-01  0.000000000000000e+00
 -1.247561692021782e-01  6.326439667291259e-02 -4.257859287278620e-03  0.000000000000000e+00 -6.535516703025324e-03 -1.444600000000000e-01 -6.562999999999999e-02  0.000000000000000e+00
 -6.582789287208898e-03 -4.817895543828531e-02 -8.307937874231319e-02  0.000000000000000e+00  1.836421943493094e-03 -1.713600000000000e-01  1.078440000000000e+00  0.000000000000000e+00
  0.000000000000000e+00  1.570796326794897e+00
  0.000000000000000e+00
  0.000000000000000e+00
Node: 193
 -1.390368934054484e-01  5.879230409540296e-02  2.244655253687328e-02  0.000000000000000e+00  4.654307128158501e-03 -1.601400000000000e-01 -6.996200000000000e-01  0.000000000000000e+00
  4.281086110697496e-01 -1.338604870566939e-01  7.874962946779709e-03  0.000000000000000e+00  1.730536018017800e-03  3.456800000000000e-01 -2.273800000000000e-01  0.000000000000000e+00
  2.076081461980123e-02 -4.122705215993443e-02 -2.561995324223528e-02  0.000000000000000e+00  8.522637919216532e-03  2.088100000000000e-01  5.488000000000000e-01  0.000000000000000e+00
  1.570796326794897e+00  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 194
 -1.110677360892087e-01  4.711070388037067e-02  2.670868127270476e-02  0.000000000000000e+00 -3.639709292757067e-04 -1.136000000000000e-02 -6.779700000000000e-01  0.000000000000000e+00
  4.378860842682384e-01 -1.163728166442580e-01  9.321964599470905e-03  0.000000000000000e+00 -8.638758911272415e-05  5.177000000000000e-02 -2.439100000000000e-01  0.000000000000000e+00
  4.570244426027927e-03 -4.514614002556852e-02 -5.714221338910432e-03  0.000000000000000e+00  1.012402438833277e-02  1.140600000000000e-01 -1.090000000000000e-02  0.000000000000000e+00
  1.570796326794897e+00  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 195
 -8.561953086003718e-02  3.827582355382312e-02  2.284524325623797e-02  0.000000000000000e+00 -2.801777259485636e-03  1.096000000000000e-02 -5.240899999999999e-01  0.000000000000000e+00
  4.467525402686937e-01 -9.902130680283484e-02  7.943806036558282e-03  0.000000000000000e+00 -9.719652631128561e-04 -2.475800000000000e-01 -1.840200000000000e-01  0.000000000000000e+00
  9.332371941979747e-03 -3.894326220773794e-02  1.458014829766214e-02  0.000000000000000e+00  8.333694559791473e-03  4.098800000000000e-01 -3.423200000000000e-01  0.000000000000000e+00
  1.570796326794897e+00  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 196
 -6.537724957673016e-02  3.089069324099935e-02  6.002320963084951e-04  0.000000000000000e+00 -6.334790403404995e-03  4.027500000000000e-01  4.100000000000000e-03  0.000000000000000e+00
  4.537736963413558e-01 -8.480461759017467e-02  1.043134906065779e-04  0.000000000000000e+00 -2.196990859010040e-03 -4.237200000000000e-01  2.484000000000000e-02  0.000000000000000e+00
  3.373054102135323e-02 -1.155745485060995e-02  4.159167166951025e-02  0.000000000000000e+00  4.305781266495080e-03 -7.703000000000000e-02 -1.110750000000000e+00  0.000000000000000e+00
  1.570796326794897e+00  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 197
 -8.441906666742376e-02  3.708543075070002e-02 -2.156080033470234e-02  0.000000000000000e+00 -2.763081920908111e-03  1.164500000000000e-01  5.285800000000000e-01  0.000000000000000e+00
  4.469611672499061e-01 -9.946159745565859e-02 -7.478380981396915e-03  0.000000000000000e+00 -7.502943280462138e-04 -3.797600000000000e-01  1.820000000000000e-01  0.000000000000000e+00
  9.251571528100007e-02 -1.375283486522680e-02  3.753676646772366e-02  0.000000000000000e+00 -6.331546873108069e-03 -3.338000000000000e-02 -8.686400000000000e-01  0.000000000000000e+00
  1.570796326794897e+00  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 198
 -1.084988502461368e-01  4.462617538984151e-02 -2.785644105113608e-02  0.000000000000000e+00 -2.097953728423980e-04  6.010000000000000e-02  7.362200000000000e-01  0.000000000000000e+00
  4.388169343785627e-01 -1.171680401466298e-01 -9.578228710399248e-03  0.000000000000000e+00 -7.258083094138779e-05 -1.120500000000000e-01  2.378000000000000e-01  0.000000000000000e+00
  1.088040739567999e-01 -8.119303320538951e-03  8.503023036579814e-04  0.000000000000000e+00 -1.058363025385668e-02  3.864000000000000e-02 -2.178000000000000e-01  0.000000000000000e+00
  1.570796326794897e+00  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 199
 -1.401319487696938e-01  5.936228416084862e-02 -2.373099545841112e-02  0.000000000000000e+00  4.854599047002979e-03 -1.882700000000000e-01  7.534200000000000e-01  0.000000000000000e+00
  4.278047098291094e-01 -1.333417038394231e-01 -8.340388001943033e-03  0.000000000000000e+00  1.723747059579991e-03  2.638900000000000e-01  2.494800000000000e-01  0.000000000000000e+00
  9.421631988831297e-02 -3.919202238136882e-03 -2.649696152314537e-02  0.000000000000000e+00 -9.835519773229554e-03 -1.388400000000000e-01  8.244300000000000e-01  0.000000000000000e+00
  1.570796326794897e+00  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 200
 -1.559608411629550e-01  6.596601095357692e-02  5.475276821206160e-04  0.000000000000000e+00  6.855928016066541e-03 -2.774100000000000e-01 -1.698000000000000e-02  0.000000000000000e+00
  4.221361583746780e-01 -1.425978002859762e-01  1.519506203198073e-04  0.000000000000000e+00  2.268847025849396e-03  4.816600000000000e-01  1.920000000000000e-03  0.000000000000000e+00
  5.581015091050227e-02 -2.160988205793466e-02 -3.672775263425265e-02  0.000000000000000e+00  1.554265001755694e-03 -1.126800000000000e-01  1.101820000000000e+00  0.000000000000000e+00
  1.570796326794897e+00  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 201
 -8.024458931006548e-02  6.781702632759071e-02  1.301889900027184e-02  0.000000000000000e+00  2.554990354563729e-03  1.157200000000000e-01 -3.926600000000000e-01  0.000000000000000e+00
  2.942481240130894e-01 -7.849264069279771e-02  2.098745476759276e-02  0.000000000000000e+00  4.052321663566720e-03  5.109600000000000e-01 -6.283900000000000e-01  0.000000000000000e+00
 -2.046623754011759e-02 -1.341810660683175e-01 -3.738808222605607e-02  0.000000000000000e+00  1.054914694704164e-02  1.080100000000000e-01  7.422500000000000e-01  0.000000000000000e+00
  1.570796326794897e+00  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 202
 -6.395703220888400e-02  7.591010716945792e-02  1.645044100194615e-02  0.000000000000000e+00 -1.991939101862288e-04  1.006500000000000e-01 -4.098400000000000e-01  0.000000000000000e+00
  3.215132676239701e-01 -4.779014826016160e-02  2.674155472638574e-02  0.000000000000000e+00 -3.211406182677817e-04 -1.876000000000000e-02 -6.579400000000000e-01  0.000000000000000e+00
 -4.057589559952976e-02 -1.899092923190600e-01 -4.572326362824994e-03  0.000000000000000e+00  1.149272001921217e-02  5.196000000000000e-01  2.120400000000000e-01  0.000000000000000e+00
  1.570796326794897e+00  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 203
 -4.734370730623760e-02  9.473421565268751e-02  1.473523793658749e-02  0.000000000000000e+00 -2.517203712800699e-03  9.641200000000000e-01 -4.331600000000000e-01  0.000000000000000e+00
  3.477312334658979e-01 -1.364923908023147e-03  2.372790556358405e-02  0.000000000000000e+00 -4.155185826036120e-03  1.835280000000000e+00 -6.956000000000000e-01  0.000000000000000e+00
 -2.961089026576852e-02 -1.611281977262558e-01  3.137449088514066e-02  0.000000000000000e+00  1.420763708601741e-02  4.066400000000000e-01 -6.904600000000000e-01  0.000000000000000e+00
  1.570796326794897e+00  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 204
 -3.448655633573051e-02  1.021920417091918e-01  5.035694758750986e-06  0.000000000000000e+00 -4.010798346942200e-03  2.518560000000000e+00 -7.600000000000000e-04  0.000000000000000e+00
  3.689690787511798e-01  2.346294548345477e-02 -1.158318358285351e-04  0.000000000000000e+00 -6.492265698177305e-03  8.415600000000000e-01 -3.433000000000000e-02  0.000000000000000e+00
  2.217308617075287e-02 -5.671834892785058e-02  5.418688534076717e-02  0.000000000000000e+00  2.120523217549991e-03  4.069000000000000e-02 -1.367580000000000e+00  0.000000000000000e+00
  1.570796326794897e+00  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 205
 -4.733363591674557e-02  9.471089243490574e-02 -1.469305926027151e-02  0.000000000000000e+00 -2.524776186073490e-03  2.869160000000000e+00  3.586400000000000e-01  0.000000000000000e+00
  3.474995697942552e-01 -5.396840556123536e-04 -2.366009225963681e-02  0.000000000000000e+00 -4.476173883399014e-03  1.859810000000000e+00  5.762900000000000e-01  0.000000000000000e+00
  7.876288041578061e-02  1.253980019806688e-02  3.925584223275210e-02  0.000000000000000e+00 -8.741832803197942e-03 -2.571500000000000e-01 -7.783600000000001e-01  0.000000000000000e+00
  1.570796326794897e+00  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 206
 -6.387267485629641e-02  7.462827675115088e-02 -1.671801434605261e-02  0.000000000000000e+00 -3.911561084285545e-04 -1.668100000000000e-01  4.315000000000000e-01  0.000000000000000e+00
  3.216488942318663e-01 -4.825156859266844e-02 -2.651828190226421e-02  0.000000000000000e+00 -6.308010314520218e-04 -1.119400000000000e-01  7.234600000000000e-01  0.000000000000000e+00
  1.006847706362576e-01  4.204864696769289e-02  5.767118617200275e-03  0.000000000000000e+00 -9.912606833916291e-03 -7.815400000000000e-01  2.936000000000000e-02  0.000000000000000e+00
  1.570796326794897e+00  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 207
 -8.076966460884691e-02  6.861153022644229e-02 -1.306107767654163e-02  0.000000000000000e+00  2.317555454157783e-03  1.926700000000000e-01  3.998700000000000e-01  0.000000000000000e+00
  2.944630059897168e-01 -7.794246807784352e-02 -2.105526807160572e-02  0.000000000000000e+00  3.683200653688976e-03  6.810200000000000e-01  6.399500000000000e-01  0.000000000000000e+00
  9.029711765018052e-02  4.326957333684422e-02 -3.324225089184661e-02  0.000000000000000e+00 -8.327175327657020e-03 -6.035300000000000e-01  6.825400000000000e-01  0.000000000000000e+00
  1.570796326794897e+00  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 208
 -8.999483020937242e-02  6.059027429390758e-02  2.625376493939069e-04  0.000000000000000e+00  3.650197168269451e-03 -1.219500000000000e+00  2.339000000000000e-02  0.000000000000000e+00
  2.795383580887483e-01 -1.007976492201737e-01 -1.074409883587146e-04  0.000000000000000e+00  5.884386936437357e-03  1.217620000000000e+00  3.548000000000000e-02  0.000000000000000e+00
  3.420026885256139e-02 -1.711161188472435e-02 -5.538167759515237e-02  0.000000000000000e+00  5.072991953714622e-04 -1.385200000000000e-01  1.170690000000000e+00  0.000000000000000e+00
  1.570796326794897e+00  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 209
 -3.402840750255269e-03  6.892976341697300e-02  3.776638541238270e-02  0.000000000000000e+00  4.862171520278102e-03  4.523600000000000e-01 -7.009000000000000e-01  0.000000000000000e+00
  2.711233296842039e-01 -5.430133150546852e-02  6.088246390677794e-02  0.000000000000000e+00  7.838233918822594e-03  1.799400000000000e-01 -1.121670000000000e+00  0.000000000000000e+00
 -2.476013175167994e-01 -2.036236408401872e-01 -1.984176336765807e-01  0.000000000000000e+00  1.194883752359923e-02  1.653700000000000e-01  1.203060000000000e+00  0.000000000000000e+00
  1.570796326794897e+00  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 210
  4.075247824964816e-02  1.149377637349955e-01  5.362587059779822e-02  0.000000000000000e+00  4.569987635703963e-05  6.200000000000000e-03 -8.499500000000000e-01  0.000000000000000e+00
  3.423057877478923e-01 -1.495935549748283e-02  8.644968138425585e-02  0.000000000000000e+00  7.372503742281156e-05 -1.064000000000000e-02 -1.360200000000000e+00  0.000000000000000e+00
 -3.752483402120764e-01 -2.419990436171958e-01 -3.266135299686632e-02  0.000000000000000e+00  1.884498421143505e-02  4.178700000000000e-01  3.820400000000000e-01  0.000000000000000e+00
  1.570796326794897e+00  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 211
  1.038489004453247e-01  1.647359762527461e-01  4.912717779600471e-02  0.000000000000000e+00 -4.978181811250822e-03 -5.228300000000000e-01 -8.437900000000000e-01  0.000000000000000e+00
  4.440226924527320e-01  2.812570130319701e-02  7.919689978016481e-02  0.000000000000000e+00 -8.025235397623787e-03 -2.803600000000000e-01 -1.350340000000000e+00  0.000000000000000e+00
 -3.129240235105242e-01 -1.954064346651194e-01  1.477710916888550e-01  0.000000000000000e+00  1.851902260466587e-02 -2.209200000000000e-01 -8.297200000000000e-01  0.000000000000000e+00
  1.570796326794897e+00  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 212
  1.390068338416357e-01  1.998692612484597e-01  5.769088785309278e-04  0.000000000000000e+00 -8.629552712926650e-03 -8.236400000000000e-01 -7.080000000000000e-03  0.000000000000000e+00
  5.006995873082424e-01  5.738965921107592e-02  9.295533429885400e-04  0.000000000000000e+00 -1.391149120463503e-02 -3.589000000000000e-01 -1.132000000000000e-02  0.000000000000000e+00
 -7.970615683431122e-02 -7.460723627907510e-02  2.152596695938240e-01  0.000000000000000e+00  6.117384378846222e-03 -2.197200000000000e-01 -1.989720000000000e+00  0.000000000000000e+00
  1.570796326794897e+00  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 213
  1.050027182023959e-01  1.651256178664938e-01 -4.912456529276206e-02  0.000000000000000e+00 -5.043418668840781e-03 -4.768100000000000e-01  6.615200000000000e-01  0.000000000000000e+00
  4.458817991386965e-01  2.855916485741422e-02 -7.919289505754505e-02  0.000000000000000e+00 -8.130387972953332e-03 -2.371100000000000e-01  1.058660000000000e+00  0.000000000000000e+00
  1.175953156772321e-01  6.465705808091493e-02  1.363037623632161e-01  0.000000000000000e+00 -9.572119920520386e-03 -5.331700000000000e-01 -1.521520000000000e+00  0.000000000000000e+00
  1.570796326794897e+00  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 214
  4.075770325622677e-02  1.156198164053732e-01 -5.395580325964656e-02  0.000000000000000e+00 -9.215700009112121e-04 -1.801000000000000e-02  1.019460000000000e+00  0.000000000000000e+00
  3.423137971932405e-01 -1.545178382556751e-02 -8.698101273266771e-02  0.000000000000000e+00 -1.485599551291239e-03  3.600000000000000e-03  1.631480000000000e+00  0.000000000000000e+00
  1.929013678921642e-01  1.116604358438302e-01  3.158007544240163e-02  0.000000000000000e+00 -2.020921931508142e-02 -6.964800000000000e-01 -6.033600000000000e-01  0.000000000000000e+00
  1.570796326794897e+00  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 215
 -2.908888316746320e-03  6.850366034422523e-02 -3.776899791571699e-02  0.000000000000000e+00  5.910277550034403e-03  5.699400000000000e-01  9.254300000000000e-01  0.000000000000000e+00
  2.719197736735424e-01 -5.461465337949093e-02 -6.088646862948741e-02  0.000000000000000e+00  9.527845485094763e-03  1.061900000000000e-01  1.480990000000000e+00  0.000000000000000e+00
  1.807554665620006e-01  1.029136850234331e-01 -8.565722037555652e-02  0.000000000000000e+00 -1.944841348767896e-02 -3.674500000000000e-01  1.397420000000000e+00  0.000000000000000e+00
  1.570796326794897e+00  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 216
 -3.478029257512667e-02  5.074140192981928e-02 -2.469762167742256e-04  0.000000000000000e+00  7.673830857436026e-03  6.034800000000000e-01 -1.005400000000000e-01  0.000000000000000e+00
  2.205408599343533e-01 -6.943224169422181e-02 -3.982219946663916e-04  0.000000000000000e+00  1.237085532180975e-02  2.573700000000000e-01 -1.609000000000000e-01  0.000000000000000e+00
  2.158692714106165e-02 -1.659339011623477e-02 -2.141783920394254e-01  0.000000000000000e+00 -5.964525541482650e-04 -2.289200000000000e-01  1.944960000000000e+00  0.000000000000000e+00
  1.570796326794897e+00  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 217
  5.761493752394019e-02  5.493117568325768e-02  7.721526080537772e-02  0.000000000000000e+00  7.135465868013254e-03  6.608700000000000e-01 -1.015860000000000e+00  0.000000000000000e+00
  1.856454610021879e-01 -8.744643778770120e-02  7.546034096436192e-02  0.000000000000000e+00  6.428533397315622e-03 -2.615300000000000e-01 -9.831600000000000e-01  0.000000000000000e+00
 -4.277135192204692e-01 -9.740847941655226e-02 -2.627937357270358e-01  0.000000000000000e+00  1.467381936992707e-02  5.933000000000000e-01  1.448790000000000e+00  0.000000000000000e+00
  1.570796326794897e+00  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 218
  1.659184952612094e-01  1.105748075170841e-01  1.122566538375972e-01  0.000000000000000e+00  1.824966061724290e-05  7.081000000000000e-02 -1.257730000000000e+00  0.000000000000000e+00
  2.915945566290155e-01 -8.722861901448550e-02  1.091685875350678e-01  0.000000000000000e+00 -4.571104881042065e-04 -1.589200000000000e-01 -1.269950000000000e+00  0.000000000000000e+00
 -5.245739828339470e-01 -7.595460143986411e-02  3.644879812247072e-03  0.000000000000000e+00  1.803385448688309e-02  3.788200000000000e-01 -4.163100000000000e-01  0.000000000000000e+00
  1.570796326794897e+00  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 219
  2.821282451992098e-01  1.608187358135082e-01  9.966673544999263e-02  0.000000000000000e+00 -5.801309659212259e-03 -3.394000000000000e-01 -8.527600000000000e-01  0.000000000000000e+00
  4.039826360723393e-01 -1.008496343344955e-01  9.607692027214670e-02  0.000000000000000e+00 -6.738498932311286e-03  7.914000000000000e-02 -7.803900000000000e-01  0.000000000000000e+00
 -4.204237595959953e-01 -6.435156915058209e-02  1.987662982232803e-01  0.000000000000000e+00  8.114899979538452e-03  1.118300000000000e-01 -1.194620000000000e+00  0.000000000000000e+00
  1.570796326794897e+00  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 220
  3.652519661611411e-01  1.969933873376818e-01  3.946773085364008e-04  0.000000000000000e+00 -9.712492119861867e-03 -3.444200000000000e-01 -5.601000000000000e-02  0.000000000000000e+00
  4.837483971733160e-01 -1.032205445781786e-01  3.176317183667815e-04  0.000000000000000e+00 -9.448284994671007e-03  5.614100000000000e-01 -3.360000000000000e-03  0.000000000000000e+00
 -1.270413863873401e-01 -1.199939016591893e-02  3.142503780868370e-01  0.000000000000000e+00 -2.494521271657680e-03 -3.714500000000000e-01 -1.650460000000000e+00  0.000000000000000e+00
  1.570796326794897e+00  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 221
  2.829175998162414e-01  1.602975982007924e-01 -9.894250410329933e-02  0.000000000000000e+00 -6.358681556684516e-03 -4.803400000000000e-01  8.759500000000000e-01  0.000000000000000e+00
  4.046178995090992e-01 -1.015606442401354e-01 -9.650153529626143e-02  0.000000000000000e+00 -6.772100462557655e-03  2.169700000000000e-01  8.359200000000000e-01  0.000000000000000e+00
  2.080769965777463e-01  7.111452906951389e-02  2.255235143556013e-01  0.000000000000000e+00 -1.670210117139810e-02 -4.086900000000000e-01 -1.195110000000000e+00  0.000000000000000e+00
  1.570796326794897e+00  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 222
  1.673669579544732e-01  1.107193281702281e-01 -1.133399718682739e-01  0.000000000000000e+00 -5.067499133187860e-04 -2.490000000000000e-03  1.266240000000000e+00  0.000000000000000e+00
  2.907453265808109e-01 -8.732934732482983e-02 -1.096921001391464e-01  0.000000000000000e+00 -6.019288880353690e-04  7.385000000000000e-02  1.186560000000000e+00  0.000000000000000e+00
  3.240056423239301e-01  9.007354265709588e-02  4.402374555962690e-02  0.000000000000000e+00 -2.141607786756328e-02 -3.924000000000000e-02  1.030000000000000e-03  0.000000000000000e+00
  1.570796326794897e+00  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 223
  5.623765607971808e-02  5.497244566275655e-02 -7.793949215212974e-02  0.000000000000000e+00  7.174653417328820e-03  4.385400000000000e-01  1.010560000000000e+00  0.000000000000000e+00
  1.852336992308586e-01 -8.778352101626634e-02 -7.503572594028969e-02  0.000000000000000e+00  5.996214049586109e-03 -2.991100000000000e-01  9.412400000000000e-01  0.000000000000000e+00
  2.961244876970081e-01  8.517668434370892e-02 -1.614960768518979e-01  0.000000000000000e+00 -1.658000853443536e-02 -5.254000000000000e-02  1.125950000000000e+00  0.000000000000000e+00
  1.570796326794897e+00  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 224
  1.148797365031720e-02  4.158385851589240e-02  6.886407220815906e-04  0.000000000000000e+00  1.008089294603341e-02  5.448100000000000e-01 -3.780000000000000e-03  0.000000000000000e+00
  1.406738747002617e-01 -7.760343969829789e-02  2.058808856693975e-04  0.000000000000000e+00  9.352324211381741e-03 -5.248100000000000e-01  3.912000000000000e-02  0.000000000000000e+00
  1.013488620108437e-03 -1.429301615249680e-02 -3.619190034587631e-01  0.000000000000000e+00 -3.273512325512346e-03 -1.194300000000000e-01  1.958650000000000e+00  0.000000000000000e+00
  1.570796326794897e+00  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 225
  1.064595106162922e-01  2.928786567946998e-02  1.067573344136257e-01  0.000000000000000e+00  1.121721828981611e-02  2.376000000000000e-01 -1.542200000000000e+00  0.000000000000000e+00
  9.623045410872524e-02 -1.062401054744681e-01  5.125728459059713e-02  0.000000000000000e+00  6.117423655943168e-03 -5.102500000000000e-01 -7.486500000000000e-01  0.000000000000000e+00
 -4.424182763499072e-01  1.056990555463431e-02 -2.600792189639793e-01  0.000000000000000e+00  2.269693542333397e-02  3.217300000000000e-01  2.055800000000000e+00  0.000000000000000e+00
  1.570796326794897e+00  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 226
  2.619020932840367e-01  5.819404084209264e-02  1.595134307279505e-01  0.000000000000000e+00 -4.543862605701707e-04 -1.878000000000000e-02 -2.002020000000000e+00  0.000000000000000e+00
  1.678485497189237e-01 -1.541882305090766e-01  7.304648483752899e-02  0.000000000000000e+00 -6.305340499800395e-04  2.073900000000000e-01 -1.030930000000000e+00  0.000000000000000e+00
 -5.271575430918386e-01  3.234396932713066e-02  3.955572691098086e-04  0.000000000000000e+00  2.573306763843176e-02  3.617900000000000e-01 -7.915999999999999e-02  0.000000000000000e+00
  1.570796326794897e+00  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 227
  4.254863720722138e-01  8.497030643908313e-02  1.355457576164918e-01  0.000000000000000e+00 -1.128499192581740e-02 -5.234200000000000e-01 -1.469810000000000e+00  0.000000000000000e+00
  2.423234237837447e-01 -2.033089002024649e-01  6.320497421648488e-02  0.000000000000000e+00 -5.505730872564268e-03  7.902600000000000e-01 -5.971900000000000e-01  0.000000000000000e+00
 -4.416271618116878e-01  1.696338513300404e-02  2.117263029628693e-01  0.000000000000000e+00  2.139949385597512e-02  8.576800000000000e-01 -1.689060000000000e+00  0.000000000000000e+00
  1.570796326794897e+00  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 228
  5.329936085170133e-01  9.211236035885120e-02  5.577126583133224e-05  0.000000000000000e+00 -1.497876867802661e-02 -6.401600000000000e-01  5.077000000000000e-02  0.000000000000000e+00
  2.942584981518262e-01 -2.401436146947049e-01  2.185434373590221e-04  0.000000000000000e+00 -6.523197413264493e-03  7.980699999999999e-01  7.490000000000000e-03  0.000000000000000e+00
 -1.037049371660395e-01  1.797998504232079e-02  3.507257678139698e-01  0.000000000000000e+00  3.653629307596405e-04  3.109800000000000e-01 -2.287120000000000e+00  0.000000000000000e+00
  1.570796326794897e+00  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 229
  4.255979146039566e-01  8.385745576252399e-02 -1.353986244601939e-01  0.000000000000000e+00 -1.077059381441387e-02 -4.464200000000000e-01  1.362840000000000e+00  0.000000000000000e+00
  2.427605106584606e-01 -2.045068843852046e-01 -6.330169780415495e-02  0.000000000000000e+00 -5.430976049337830e-03  7.071600000000000e-01  5.795900000000000e-01  0.000000000000000e+00
  2.598243738163162e-01  2.089917138270897e-02  2.383766951862051e-01  0.000000000000000e+00 -1.649142703819656e-02 -2.055000000000000e-02 -1.390560000000000e+00  0.000000000000000e+00
  1.570796326794897e+00  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 230
  2.621963595965640e-01  5.690656893130910e-02 -1.592809557975341e-01  0.000000000000000e+00 -1.065863479636053e-03 -4.253000000000000e-02  1.909330000000000e+00  0.000000000000000e+00
  1.676551025436567e-01 -1.535142166129676e-01 -7.320388950876011e-02  0.000000000000000e+00 -5.856430159003542e-04  9.082000000000000e-02  1.033610000000000e+00  0.000000000000000e+00
  3.730484532063814e-01  2.049200530552179e-02  4.564223071653432e-02  0.000000000000000e+00 -2.094783687874471e-02 -4.100000000000000e-01 -2.307200000000000e-01  0.000000000000000e+00
  1.570796326794897e+00  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 231
  1.070360030087962e-01  3.087683561489071e-02 -1.069044675699184e-01  0.000000000000000e+00  1.075749343563876e-02  3.469400000000000e-01  1.663240000000000e+00  0.000000000000000e+00
  9.635273164104106e-02 -1.061110389837412e-01 -5.116056100296831e-02  0.000000000000000e+00  6.271281286991425e-03 -4.840300000000000e-01  7.712000000000000e-01  0.000000000000000e+00
  3.511088352493966e-01  1.084411360801524e-02 -1.900237791851700e-01  0.000000000000000e+00 -2.046587119073848e-02 -3.600300000000000e-01  1.377570000000000e+00  0.000000000000000e+00
  1.570796326794897e+00  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 232
  4.838742445669095e-02  2.120413684217803e-02 -2.882461962425472e-04  0.000000000000000e+00  1.385255258611086e-02  5.478700000000000e-01  4.167000000000000e-02  0.000000000000000e+00
  6.533398053783528e-02 -8.449598696284105e-02 -6.113876616913039e-05  0.000000000000000e+00  6.374641272152069e-03 -8.842400000000000e-01 -1.387000000000000e-02  0.000000000000000e+00
 -6.999105163906658e-03 -4.735021235584714e-05 -3.967635557996887e-01  0.000000000000000e+00 -2.642176160888715e-03  1.212800000000000e-01  2.555270000000000e+00  0.000000000000000e+00
  1.570796326794897e+00  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 233
  1.161906688828773e-01 -1.213197306470203e-02  1.142051648054292e-01  0.000000000000000e+00  9.829259658215727e-03 -2.144300000000000e-01 -1.545820000000000e+00  0.000000000000000e+00
 -2.683474994676976e-02 -1.165441043541246e-01  5.768097418016994e-03  0.000000000000000e+00  4.680185898175882e-04 -7.999200000000000e-01  1.279700000000000e-01  0.000000000000000e+00
 -4.065737081112172e-01  6.016868112849334e-02 -2.304024161875452e-01  0.000000000000000e+00  2.003005480385574e-02 -4.104400000000000e-01  1.606340000000000e+00  0.000000000000000e+00
  1.570796326794897e+00  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 234
  2.823065769454789e-01 -2.046968265655947e-02  1.679390945972256e-01  0.000000000000000e+00  2.269848872470948e-04  3.957000000000000e-02 -1.825940000000000e+00  0.000000000000000e+00
 -1.678190438916665e-02 -1.792624475552773e-01  1.209979280709665e-02  0.000000000000000e+00  7.108573447823334e-04  8.802000000000000e-02 -7.303999999999999e-02  0.000000000000000e+00
 -4.598860441796925e-01  8.409277622187347e-02  1.003835939061916e-02  0.000000000000000e+00  2.417131123828706e-02 -7.907500000000000e-01  1.283200000000000e-01  0.000000000000000e+00
  1.570796326794897e+00  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 235
  4.520688580773365e-01 -2.253094775186771e-02  1.335850549666839e-01  0.000000000000000e+00 -1.050881341238367e-02  2.315200000000000e-01 -1.665860000000000e+00  0.000000000000000e+00
 -2.635164332587852e-03 -2.471358986239109e-01  1.012153608649264e-02  0.000000000000000e+00 -3.579459266306903e-04  8.359400000000000e-01 -1.832400000000000e-01  0.000000000000000e+00
 -3.864969893299613e-01  7.637589252004968e-02  1.844023139385338e-01  0.000000000000000e+00  2.215555322488754e-02 -4.792000000000000e-01 -1.432320000000000e+00  0.000000000000000e+00
  1.570796326794897e+00  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 236
  5.494766868788601e-01 -5.015014321440212e-02 -7.181733680104579e-04  0.000000000000000e+00 -1.644930513094663e-02  3.863600000000000e-01 -3.298000000000000e-02  0.000000000000000e+00
  3.461167783869172e-03 -2.830197393924885e-01 -8.803524643770252e-04  0.000000000000000e+00 -1.158661620137784e-03  1.054970000000000e+00  4.704000000000000e-02  0.000000000000000e+00
 -9.108141630260951e-02  3.234528461081905e-02  3.181861643365708e-01  0.000000000000000e+00  2.565775335150134e-03  8.261000000000000e-02 -2.500070000000000e+00  0.000000000000000e+00
  1.570796326794897e+00  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 237
  4.506325113413565e-01 -2.268697856424168e-02 -1.341482955309454e-01  0.000000000000000e+00 -1.084775731742425e-02  2.737200000000000e-01  1.376840000000000e+00  0.000000000000000e+00
 -4.395869261417511e-03 -2.474130254329036e-01 -9.872137214395353e-03  0.000000000000000e+00  1.304013983996865e-04  8.489100000000001e-01  1.749800000000000e-01  0.000000000000000e+00
  2.498753393431885e-01 -3.109044679729945e-02  2.280355346187816e-01  0.000000000000000e+00 -1.695863867451901e-02  3.811400000000000e-01 -1.840910000000000e+00  0.000000000000000e+00
  1.570796326794897e+00  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 238
  2.811800958170290e-01 -2.052730917841974e-02 -1.663205920159436e-01  0.000000000000000e+00 -1.108080018321293e-03  9.316000000000001e-02  2.124250000000000e+00  0.000000000000000e+00
 -1.628310664505357e-02 -1.791767464901010e-01 -1.129625473760175e-02  0.000000000000000e+00  7.675718458457458e-04  1.704500000000000e-01  7.115000000000000e-02  0.000000000000000e+00
  3.649896529349526e-01 -1.279776735742101e-02  3.396868778493928e-02  0.000000000000000e+00 -2.819333434816722e-02  2.005400000000000e-01 -3.498500000000000e-01  0.000000000000000e+00
  1.570796326794897e+00  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 239
  1.179913273094309e-01 -1.324266558632967e-02 -1.136419242411613e-01  0.000000000000000e+00  1.087948598053235e-02 -2.024300000000000e-01  1.684220000000000e+00  0.000000000000000e+00
 -2.698837873659137e-02 -1.162676640689585e-01 -6.017496290150971e-03  0.000000000000000e+00  8.219597937666580e-04 -8.746500000000000e-01 -1.324600000000000e-01  0.000000000000000e+00
  3.178127149130638e-01 -1.963009419376561e-02 -1.820354323697799e-01  0.000000000000000e+00 -2.241729467650383e-02  3.681200000000000e-01  1.738760000000000e+00  0.000000000000000e+00
  1.570796326794897e+00  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 240
  5.389624733464728e-02 -1.278869581184422e-02 -9.003292132651894e-04  0.000000000000000e+00  1.615818139482079e-02 -3.275100000000000e-01 -9.551999999999999e-02  0.000000000000000e+00
 -2.831809922525598e-02 -9.022922422345646e-02  7.681439484542949e-05  0.000000000000000e+00 -4.967763127263830e-04 -1.038420000000000e+00 -3.209000000000000e-02  0.000000000000000e+00
  9.187881954090610e-04  9.931592667843533e-03 -3.621932115121389e-01  0.000000000000000e+00 -1.236995704522038e-03  3.052000000000000e-02  2.650600000000000e+00  0.000000000000000e+00
  1.570796326794897e+00  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 241
  8.219556448686725e-02 -5.014204066794657e-02  9.907634756896531e-02  0.000000000000000e+00  8.805044781719985e-03 -5.211300000000000e-01 -1.277650000000000e+00  0.000000000000000e+00
 -1.368577545994184e-01 -9.319515997605389e-02 -3.777593874131427e-02  0.000000000000000e+00 -3.187225285575593e-03 -5.718500000000000e-01  5.345200000000000e-01  0.000000000000000e+00
 -3.220809140929902e-01  9.302864196048716e-02 -1.859180354099156e-01  0.000000000000000e+00  1.604531712693633e-02 -4.933900000000000e-01  1.265420000000000e+00  0.000000000000000e+00
  1.570796326794897e+00  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 242
  2.209627279708865e-01 -8.504394874193225e-02  1.491144560408254e-01  0.000000000000000e+00 -2.722304149518212e-05 -2.700000000000000e-04 -1.461720000000000e+00  0.000000000000000e+00
 -1.906763453916685e-01 -1.544142494287572e-01 -5.754530943229928e-02  0.000000000000000e+00  2.561115500270134e-04 -1.163500000000000e-01  5.754300000000000e-01  0.000000000000000e+00
 -3.589719906481044e-01  1.189477364596914e-01  1.660276866070459e-02  0.000000000000000e+00  1.255586953347042e-02 -4.584900000000000e-01 -1.503100000000000e-01  0.000000000000000e+00
  1.570796326794897e+00  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 243
  3.804244765685591e-01 -1.394005251510642e-01  1.058652970586099e-01  0.000000000000000e+00 -8.718226375338894e-03  5.529300000000000e-01 -1.191900000000000e+00  0.000000000000000e+00
 -2.519483734640879e-01 -1.968565673103392e-01 -4.055231762069590e-02  0.000000000000000e+00  3.748458563202092e-03  5.089200000000000e-01  4.325700000000000e-01  0.000000000000000e+00
 -2.888753767715871e-01  1.124077457170085e-01  1.599788113518568e-01  0.000000000000000e+00  1.337849369367351e-02 -7.317700000000000e-01 -8.131300000000000e-01  0.000000000000000e+00
  1.570796326794897e+00  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 244
  4.326933220882106e-01 -1.709185220804195e-01 -1.002595465371958e-04  0.000000000000000e+00 -1.089220773569408e-02  7.586300000000000e-01  8.823000000000000e-02  0.000000000000000e+00
 -2.717809806331365e-01 -2.197387517256322e-01 -5.858337167277683e-05  0.000000000000000e+00  4.210298438060700e-03  8.082200000000000e-01 -1.586000000000000e-02  0.000000000000000e+00
 -3.901436794443237e-02  5.409086963243553e-02  2.432594284966700e-01  0.000000000000000e+00  1.854664356169129e-03 -2.637900000000000e-01 -1.450280000000000e+00  0.000000000000000e+00
  1.570796326794897e+00  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 245
  3.802239574755142e-01 -1.385743683137499e-01 -1.057757904242298e-01  0.000000000000000e+00 -7.771440038311858e-03  4.999900000000000e-01  1.002170000000000e+00  0.000000000000000e+00
 -2.520655402074672e-01 -1.961013910347112e-01  4.054129509828744e-02  0.000000000000000e+00  3.577056432722651e-03  4.860100000000000e-01 -3.177600000000000e-01  0.000000000000000e+00
  1.976434802217363e-01 -4.043107679072669e-02  1.932336432179687e-01  0.000000000000000e+00 -1.014975819938009e-02  3.456000000000000e-01 -1.198260000000000e+00  0.000000000000000e+00
  1.570796326794897e+00  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 246
  2.211417412397528e-01 -8.542738092758932e-02 -1.498366428197294e-01  0.000000000000000e+00 -9.938871210753153e-05  1.054800000000000e-01  1.557780000000000e+00  0.000000000000000e+00
 -1.906983904364840e-01 -1.540365468702817e-01  5.794147185528474e-02  0.000000000000000e+00  7.572739875266292e-04 -1.195000000000000e-01 -6.219000000000000e-01  0.000000000000000e+00
  3.474529184915275e-01 -4.664996675765217e-02  5.710258332007112e-02  0.000000000000000e+00 -1.763789691402308e-02  6.903500000000000e-01 -2.589100000000000e-01  0.000000000000000e+00
  1.570796326794897e+00  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 247
  8.055067183614190e-02 -5.055561129740042e-02 -9.916585420342131e-02  0.000000000000000e+00  8.568556440469933e-03 -6.121300000000000e-01  1.071750000000000e+00  0.000000000000000e+00
 -1.361825964967812e-01 -9.372446989297852e-02  3.778696126371821e-02  0.000000000000000e+00 -2.999308441586090e-03 -6.477000000000001e-01 -5.046400000000000e-01  0.000000000000000e+00
  3.118486468618876e-01 -4.349574494293799e-02 -1.672944191598693e-01  0.000000000000000e+00 -1.420803738973815e-02  6.241300000000000e-01  1.043950000000000e+00  0.000000000000000e+00
  1.570796326794897e+00  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 248
  2.281003283298231e-02 -3.558952651216626e-02  8.224463253652496e-04  0.000000000000000e+00  1.034903422569091e-02 -7.790500000000000e-01  2.188000000000000e-02  0.000000000000000e+00
 -1.151244679090265e-01 -7.352766180185352e-02 -3.375790513172137e-04  0.000000000000000e+00 -4.192219975660055e-03 -6.511600000000000e-01 -1.719000000000000e-02  0.000000000000000e+00
  1.286408017180120e-02  1.631597963294151e-02 -3.169647804774052e-01  0.000000000000000e+00 -2.251594095242372e-03 -6.276000000000000e-02  1.789370000000000e+00  0.000000000000000e+00
  1.570796326794897e+00  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 249
  1.590658754694158e-02 -9.127143719862810e-02  6.475074257566238e-02  0.000000000000000e+00  4.190720312600445e-03 -6.429200000000000e-01 -5.948099999999999e-01  0.000000000000000e+00
 -2.132250698989389e-01 -4.786295793236411e-02 -7.511849020882491e-02  0.000000000000000e+00 -5.627474441818239e-03 -1.645900000000000e-01  7.023100000000000e-01  0.000000000000000e+00
 -2.205164241903086e-01  1.008285029063551e-01 -1.277706593608554e-01  0.000000000000000e+00  1.136862586362618e-02 -3.199400000000000e-01  1.131920000000000e+00  0.000000000000000e+00
  1.570796326794897e+00  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 250
  1.122186794616225e-01 -1.472623426582376e-01  7.868061011415371e-02  0.000000000000000e+00  4.234527070382382e-04 -5.545000000000000e-02 -8.256800000000000e-01  0.000000000000000e+00
 -3.256104032467146e-01 -7.320827563354812e-02 -9.156161452717207e-02  0.000000000000000e+00 -2.399019582903714e-04 -8.656999999999999e-02  1.019060000000000e+00  0.000000000000000e+00
 -2.219905712602968e-01  1.011862600663412e-01  2.941746314716526e-02  0.000000000000000e+00  1.613441329939907e-02  7.023000000000000e-02 -7.803000000000000e-02  0.000000000000000e+00
  1.570796326794897e+00  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 251
  1.732678077752895e-01 -2.171317364249391e-01  4.771048162821212e-02  0.000000000000000e+00 -4.511793180575305e-03  6.703500000000000e-01 -7.189200000000000e-01  0.000000000000000e+00
 -3.963482989533620e-01 -8.214998228000503e-02 -5.520296621030799e-02  0.000000000000000e+00  5.228451502708752e-03  1.839400000000000e-01  8.112200000000001e-01  0.000000000000000e+00
 -1.616814978959465e-01  8.617029538184498e-02  1.195454471112476e-01  0.000000000000000e+00  1.023250669850433e-02 -1.527000000000000e-01 -1.099600000000000e+00  0.000000000000000e+00
  1.570796326794897e+00  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 252
  2.076396427180889e-01 -2.390123601695996e-01  1.079834692719814e-04  0.000000000000000e+00 -7.420455900820366e-03  8.972000000000000e-01 -5.824000000000000e-02  0.000000000000000e+00
 -4.360163356674391e-01 -9.101121307089252e-02 -1.251761887153119e-04  0.000000000000000e+00  8.680446167305567e-03  4.377900000000000e-01  6.700000000000000e-02  0.000000000000000e+00
  1.710032296218811e-02  4.275604084061257e-02  1.653473418288610e-01  0.000000000000000e+00 -2.029253967667443e-03 -2.466800000000000e-01 -1.436270000000000e+00  0.000000000000000e+00
  1.570796326794897e+00  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 253
  1.734837747138711e-01 -2.178322280677732e-01 -4.865715437811888e-02  0.000000000000000e+00 -5.107292481131068e-03  4.853500000000000e-01  7.201000000000000e-01  0.000000000000000e+00
 -3.965986513308172e-01 -8.177479697584296e-02  5.583006764093263e-02  0.000000000000000e+00  5.918522429707383e-03  2.748400000000000e-01 -7.968600000000000e-01  0.000000000000000e+00
  1.690131857617454e-01 -8.285600926264337e-03  1.272946982287296e-01  0.000000000000000e+00 -1.125402462510838e-02  2.301900000000000e-01 -8.861800000000000e-01  0.000000000000000e+00
  1.570796326794897e+00  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 254
  1.103253339618488e-01 -1.477048022732413e-01 -7.830183499958758e-02  0.000000000000000e+00  3.783586285200386e-04 -1.758000000000000e-02  9.060100000000000e-01  0.000000000000000e+00
 -3.243562003856187e-01 -7.231243824142278e-02  9.108066640418666e-02  0.000000000000000e+00 -8.428987686395772e-06 -6.308000000000000e-02 -1.097430000000000e+00  0.000000000000000e+00
  2.716897194196832e-01 -3.095989059586669e-02  3.090401963270930e-02  0.000000000000000e+00 -1.641880050475799e-02  1.950600000000000e-01 -3.544000000000000e-02  0.000000000000000e+00
  1.570796326794897e+00  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 255
  1.688010471468512e-02 -9.010887323485200e-02 -6.380406982577244e-02  0.000000000000000e+00  4.477414151793792e-03 -5.643000000000000e-01  6.207900000000000e-01  0.000000000000000e+00
 -2.144373185224966e-01 -4.841046073227952e-02  7.449138877831363e-02  0.000000000000000e+00 -5.770652812518741e-03 -1.795700000000000e-01 -7.482400000000000e-01  0.000000000000000e+00
  2.308212250271949e-01 -4.387803500278686e-02 -1.190694859791625e-01  0.000000000000000e+00 -1.185413709899200e-02  2.159600000000000e-01  8.635699999999999e-01  0.000000000000000e+00
  1.570796326794897e+00  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 256
 -1.728280568970388e-02 -6.610708613123019e-02 -4.867585838549482e-04  0.000000000000000e+00  7.212856545209507e-03 -8.064700000000000e-01 -2.653000000000000e-02  0.000000000000000e+00
 -1.753734228289694e-01 -4.205496584848963e-02  6.061243118140637e-04  0.000000000000000e+00 -8.276998963052947e-03 -3.697300000000000e-01  1.299000000000000e-02  0.000000000000000e+00
  3.355074746141673e-02  2.397813609656542e-02 -2.256688246087763e-01  0.000000000000000e+00 -2.207789430218265e-03  1.833800000000000e-01  1.501030000000000e+00  0.000000000000000e+00
  1.570796326794897e+00  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 257
 -1.003473099104112e-01 -1.042404335998156e-01  1.792109104193433e-02  0.000000000000000e+00  1.715960312664778e-03 -3.829100000000000e-01 -2.026900000000000e-01  0.000000000000000e+00
 -2.325836704642379e-01 -1.008720989216463e-02 -6.892924852637683e-02  0.000000000000000e+00 -5.043433315117380e-03  1.193100000000000e-01  7.216100000000000e-01  0.000000000000000e+00
 -1.204239082802369e-01  9.040688128965998e-02 -1.087099114402630e-01  0.000000000000000e+00  1.091227961418229e-02 -2.261000000000000e-01  8.082700000000000e-01  0.000000000000000e+00
  1.570796326794897e+00  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 258
 -7.356195734551982e-02 -1.579908713834566e-01  2.325415681455140e-02  0.000000000000000e+00 -6.690280166156415e-05  1.016000000000000e-02 -2.637600000000000e-01  0.000000000000000e+00
 -3.370928966587551e-01  9.134391017445023e-03 -9.183233377997399e-02  0.000000000000000e+00 -3.872376124742505e-04  3.446000000000000e-02  9.901400000000000e-01  0.000000000000000e+00
 -1.565994705154002e-01  7.966678946460368e-02  1.944561136178082e-03  0.000000000000000e+00  1.329380086214952e-02 -3.179800000000000e-01 -8.670000000000001e-03  0.000000000000000e+00
  1.570796326794897e+00  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 259
 -5.383899628128443e-02 -1.940554948706515e-01  1.411527954729521e-02  0.000000000000000e+00 -1.166880273465072e-03  5.498700000000000e-01 -1.518400000000000e-01  0.000000000000000e+00
 -4.162483380241993e-01  8.856844666051293e-03 -5.835525505808641e-02  0.000000000000000e+00  5.856849700557602e-03 -8.796000000000000e-02  9.082200000000000e-01  0.000000000000000e+00
 -1.165347860079208e-01  6.238973776792849e-02  1.015485921261066e-01  0.000000000000000e+00  1.076937118349124e-02 -9.016000000000000e-02 -1.012950000000000e+00  0.000000000000000e+00
  1.570796326794897e+00  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 260
 -4.533139825088476e-02 -2.141744962886167e-01 -8.007511893871064e-04  0.000000000000000e+00 -1.588894210661151e-03  8.207100000000001e-01 -9.768000000000000e-02  0.000000000000000e+00
 -4.538034067749897e-01  1.085893902159953e-02  3.166019325524169e-04  0.000000000000000e+00  8.837011753755383e-03 -1.032800000000000e-01  7.983999999999999e-02  0.000000000000000e+00
  4.649771373674266e-02  3.308470278189923e-02  1.488035321885829e-01  0.000000000000000e+00 -2.123554088616587e-03  8.265000000000000e-02 -1.088610000000000e+00  0.000000000000000e+00
  1.570796326794897e+00  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 261
 -5.544049865998758e-02 -1.941890354372892e-01 -1.446823252794405e-02  0.000000000000000e+00 -2.199273421248480e-03  6.244800000000000e-01  1.640200000000000e-01  0.000000000000000e+00
 -4.156151341591003e-01  9.380471690697417e-03  5.924006992778375e-02  0.000000000000000e+00  6.706384870465563e-03 -1.516300000000000e-01 -7.535500000000001e-01  0.000000000000000e+00
  1.810722783692678e-01  1.541541061837839e-02  1.195177117815144e-01  0.000000000000000e+00 -6.329659726995372e-03  3.474600000000000e-01 -7.306000000000000e-01  0.000000000000000e+00
  1.570796326794897e+00  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 262
 -7.426786330676013e-02 -1.571094733534116e-01 -2.211328798678142e-02  0.000000000000000e+00  2.450073736728290e-04  1.491000000000000e-02  4.323400000000000e-01  0.000000000000000e+00
 -3.353232669193947e-01  7.111700945310148e-03  9.130580809888056e-02  0.000000000000000e+00  3.592426939691140e-04  1.608000000000000e-02 -1.202280000000000e+00  0.000000000000000e+00
  2.855331372998325e-01 -4.032488193045691e-03  2.151014924351707e-02  0.000000000000000e+00 -1.448893623403030e-02  2.921300000000000e-01 -3.254900000000000e-01  0.000000000000000e+00
  1.570796326794897e+00  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 263
 -9.966707463366567e-02 -1.050553453141940e-01 -1.756813806130400e-02  0.000000000000000e+00  2.051269430569762e-03 -4.647300000000000e-01  1.744800000000000e-01  0.000000000000000e+00
 -2.330035179613472e-01 -8.749670659223545e-03  6.804443365670268e-02  0.000000000000000e+00 -5.234515796985723e-03  1.121800000000000e-01 -8.045200000000000e-01  0.000000000000000e+00
  2.240925768563142e-01 -3.653629307989008e-04 -1.123563924674013e-01  0.000000000000000e+00 -1.115863796541627e-02  2.548300000000000e-01  9.712700000000000e-01  0.000000000000000e+00
  1.570796326794897e+00  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 264
 -1.094041394294266e-01 -8.494081165558205e-02 -3.401176384013899e-04  0.000000000000000e+00  2.040516518390330e-03 -7.095200000000000e-01 -3.081000000000000e-02  0.000000000000000e+00
 -1.992343996060021e-01 -1.121249882337864e-02  2.099237485641801e-04  0.000000000000000e+00 -7.976301500537214e-03  1.273900000000000e-01  1.743000000000000e-02  0.000000000000000e+00
  6.082035236506877e-02  1.832024321079221e-02 -1.722582425683213e-01  0.000000000000000e+00  5.960522503827420e-04  1.228400000000000e-01  1.371440000000000e+00  0.000000000000000e+00
  1.570796326794897e+00  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 265
 -1.925742796527010e-01 -8.144675888678138e-02 -8.299317152201363e-03  0.000000000000000e+00 -1.550463908637639e-04 -3.828400000000000e-01  1.313200000000000e-01  0.000000000000000e+00
 -2.333994896832758e-01  8.992166152206198e-03 -5.477160036803910e-02  0.000000000000000e+00 -4.266173854392003e-03  9.551000000000000e-02  6.349200000000000e-01  0.000000000000000e+00
 -3.970266161090685e-02  4.548954343757043e-02 -6.642411310709320e-02  0.000000000000000e+00  7.504608353685394e-03 -2.784700000000000e-01  6.661200000000000e-01  0.000000000000000e+00
  1.570796326794897e+00  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 266
 -2.037630633052456e-01 -1.079301590787044e-01 -1.113445115664057e-02  0.000000000000000e+00  6.836807521207466e-04 -2.916000000000000e-02  1.372600000000000e-01  0.000000000000000e+00
 -3.073416212117938e-01  4.238327682732439e-02 -7.261755996900252e-02  0.000000000000000e+00  1.405466957440718e-04  4.070000000000000e-03  7.898600000000000e-01  0.000000000000000e+00
 -6.265699233109558e-02  5.431040763386782e-02  1.400319625386754e-03  0.000000000000000e+00  1.067970314848744e-02 -3.559200000000000e-01  7.782000000000000e-02  0.000000000000000e+00
  1.570796326794897e+00  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 267
 -2.148431819659022e-01 -1.282364277614886e-01 -8.473143276953300e-03  0.000000000000000e+00  1.320071408385866e-03  2.813700000000000e-01  1.036700000000000e-01  0.000000000000000e+00
 -3.786346096212872e-01  6.702109352271543e-02 -5.347841820623338e-02  0.000000000000000e+00  4.252519657091967e-03 -1.976700000000000e-01  6.945200000000000e-01  0.000000000000000e+00
 -3.690202236016563e-02  5.177116671726126e-02  7.296336042854959e-02  0.000000000000000e+00  8.811371279325915e-03 -3.502500000000000e-01 -7.125800000000000e-01  0.000000000000000e+00
  1.570796326794897e+00  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 268
 -2.207093498589941e-01 -1.394593254062511e-01 -2.555709741657378e-05  0.000000000000000e+00  1.778243905507071e-03  4.203500000000000e-01  1.668000000000000e-02  0.000000000000000e+00
 -4.142984576242885e-01  7.577278561338190e-02  3.984508359600458e-04  0.000000000000000e+00  7.512440194246170e-03 -4.388700000000000e-01 -3.000000000000000e-03  0.000000000000000e+00
  8.326972852602106e-02  7.067362310658453e-03  1.183730146793426e-01  0.000000000000000e+00 -6.223579239604711e-04  4.116000000000000e-02 -9.925100000000000e-01  0.000000000000000e+00
  1.570796326794897e+00  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 269
 -2.148942961606928e-01 -1.273500318990488e-01  8.407868557016113e-03  0.000000000000000e+00  1.490982130866934e-03  3.905800000000000e-01 -1.200000000000000e-01  0.000000000000000e+00
 -3.778377079493575e-01  6.687925005959924e-02  5.208282956463846e-02  0.000000000000000e+00  4.225668945057298e-03 -2.893200000000000e-01 -6.208600000000000e-01  0.000000000000000e+00
  1.998440069985673e-01 -2.372863250186011e-02  9.017750725378891e-02  0.000000000000000e+00 -5.339193932418003e-03  3.503000000000000e-02 -6.049900000000000e-01  0.000000000000000e+00
  1.570796326794897e+00  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 270
 -2.038936127449773e-01 -1.068880353029028e-01  1.083185512343543e-02  0.000000000000000e+00  3.864990373268241e-04 -3.590000000000000e-02 -2.263400000000000e-01  0.000000000000000e+00
 -3.101327984949929e-01  4.303536009933121e-02  7.295052405420835e-02  0.000000000000000e+00  1.807846235817104e-04 -1.928000000000000e-02 -9.288300000000000e-01  0.000000000000000e+00
  2.636247430336001e-01 -5.802739930331805e-02  1.512324608351627e-02  0.000000000000000e+00 -1.146681464943693e-02  3.870500000000000e-01 -1.511300000000000e-01  0.000000000000000e+00
  1.570796326794897e+00  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 271
 -1.932305859138112e-01 -8.150237870314664e-02  8.364591872084957e-03  0.000000000000000e+00 -7.054137504771615e-04 -4.581700000000000e-01 -1.019100000000000e-01  0.000000000000000e+00
 -2.319366598409673e-01  9.600960279102323e-03  5.616718900964543e-02  0.000000000000000e+00 -4.486014059054522e-03  1.721200000000000e-01 -6.350300000000000e-01  0.000000000000000e+00
  2.300904991655955e-01 -3.964236407487513e-02 -9.671675457527396e-02  0.000000000000000e+00 -7.499518777730686e-03  2.330200000000000e-01  6.811800000000000e-01  0.000000000000000e+00
  1.570796326794897e+00  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 272
 -1.871644290008057e-01 -6.932220684588894e-02  3.281531305681235e-04  0.000000000000000e+00 -7.244963831560432e-04 -4.544400000000000e-01  5.216000000000000e-02  0.000000000000000e+00
 -1.977984204757181e-01  2.984166775861354e-03 -7.314149211544718e-04  0.000000000000000e+00 -6.828814963662347e-03  2.421700000000000e-01  2.095000000000000e-02  0.000000000000000e+00
  7.019123388305711e-02 -9.237180072952794e-03 -1.348965803882743e-01  0.000000000000000e+00 -1.304418289338367e-04  1.243000000000000e-02  9.715200000000001e-01  0.000000000000000e+00
  1.570796326794897e+00  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 273
 -2.632408276839526e-01 -7.065416703740732e-02 -2.068686119088293e-02  0.000000000000000e+00 -2.822336524508431e-03 -3.818600000000000e-01  3.128100000000000e-01  0.000000000000000e+00
 -2.145993381598259e-01  4.070072120098539e-02 -2.953013847492277e-02  0.000000000000000e+00 -3.949266800115293e-03 -1.286600000000000e-01  4.932000000000000e-01  0.000000000000000e+00
 -2.944482140506381e-02 -2.256883823050427e-02 -4.516232373339289e-02  0.000000000000000e+00  6.471538805276542e-03  1.268000000000000e-02  4.461900000000000e-01  0.000000000000000e+00
  1.570796326794897e+00  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 274
 -2.894222755029856e-01 -7.749229974119033e-02 -2.353551206008050e-02  0.000000000000000e+00 -3.643495529058322e-04 -3.107000000000000e-02  4.648800000000000e-01  0.000000000000000e+00
 -2.523263430040910e-01  5.985058036441260e-02 -3.380340640947758e-02  0.000000000000000e+00 -3.516527909954020e-04 -1.096400000000000e-01  6.534500000000000e-01  0.000000000000000e+00
 -4.797865524767880e-02 -2.707025364730498e-02  8.226184415817784e-03  0.000000000000000e+00  7.340140707907486e-03  3.848000000000000e-01 -9.805999999999999e-02  0.000000000000000e+00
  1.570796326794897e+00  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 275
 -3.103118518041731e-01 -8.793879169827701e-02 -1.741388678015383e-02  0.000000000000000e+00  2.385594126796960e-03  2.863000000000000e-01  3.155000000000000e-01  0.000000000000000e+00
 -2.822061509787829e-01  7.753207935424758e-02 -2.496574627207706e-02  0.000000000000000e+00  3.432047331697281e-03 -2.348000000000000e-02  4.347500000000000e-01  0.000000000000000e+00
 -1.299245257344402e-02 -2.088739101587933e-02  5.430554680289879e-02  0.000000000000000e+00  4.801528840000624e-03  1.162700000000000e-01 -5.742699999999999e-01  0.000000000000000e+00
  1.570796326794897e+00  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 276
 -3.242500490633164e-01 -9.285200168864793e-02  8.564467305587076e-05  0.000000000000000e+00  2.861145450174497e-03  3.798100000000000e-01  2.405000000000000e-02  0.000000000000000e+00
 -3.022578355482127e-01  9.027319989239593e-02  1.747584694324136e-04  0.000000000000000e+00  4.116130244848824e-03 -7.496000000000000e-02 -1.824000000000000e-02  0.000000000000000e+00
  6.063243835808677e-02 -4.180308922391436e-02  7.330373296951445e-02  0.000000000000000e+00 -1.449614170105100e-03  2.416000000000000e-02 -6.111500000000000e-01  0.000000000000000e+00
  1.570796326794897e+00  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 277
 -3.101405624580752e-01 -9.139202883596932e-02  1.810305757538608e-02  0.000000000000000e+00  2.629692803676933e-03  2.981400000000000e-01 -2.924800000000000e-01  0.000000000000000e+00
 -2.818566340398740e-01  8.132195819188251e-02  2.650264441372761e-02  0.000000000000000e+00  3.242109056309180e-03  6.601000000000000e-02 -3.761600000000000e-01  0.000000000000000e+00
  1.336150133655696e-01 -7.032655977490215e-02  5.442295016754961e-02  0.000000000000000e+00 -5.643481951631762e-03 -1.465000000000000e-01 -4.311400000000000e-01  0.000000000000000e+00
  1.570796326794897e+00  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 278
 -2.880439339125011e-01 -8.365481637701278e-02  2.373436520903252e-02  0.000000000000000e+00 -2.004812307114523e-04  1.362200000000000e-01 -4.599900000000000e-01  0.000000000000000e+00
 -2.492525467207482e-01  6.583409372213185e-02  3.402751831835676e-02  0.000000000000000e+00  1.706774663374835e-04  4.494000000000000e-02 -5.921200000000000e-01  0.000000000000000e+00
  1.694783386932096e-01 -9.008669549387195e-02  5.596417670488733e-03  0.000000000000000e+00 -8.168655051546000e-03 -5.128000000000000e-02 -9.873000000000000e-02  0.000000000000000e+00
  1.570796326794897e+00  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 279
 -2.626718320400178e-01 -7.402119156652040e-02  1.999769039567285e-02  0.000000000000000e+00 -2.478924860174349e-03 -1.371500000000000e-01 -3.278100000000000e-01  0.000000000000000e+00
 -2.138015974031454e-01  4.457408897135421e-02  2.799324033323244e-02  0.000000000000000e+00 -3.434450165318549e-03 -3.323000000000000e-02 -5.419700000000000e-01  0.000000000000000e+00
  1.448078487065786e-01 -8.299777396815763e-02 -6.356617323702768e-02  0.000000000000000e+00 -7.265912959570176e-03 -1.037700000000000e-01  6.045100000000000e-01  0.000000000000000e+00
  1.570796326794897e+00  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 280
 -2.480485531212156e-01 -6.915739196449375e-02 -2.844978219857346e-04  0.000000000000000e+00 -3.426014096163311e-03 -1.601490000000000e+00 -3.322000000000000e-02  0.000000000000000e+00
 -1.932660660542525e-01  3.325334821514209e-02 -3.988703783513702e-04  0.000000000000000e+00 -5.245538319409992e-03  1.449440000000000e+00 -4.942000000000000e-02  0.000000000000000e+00
  4.234599221912488e-02 -3.746882920649713e-02 -8.712633505579315e-02  0.000000000000000e+00  7.498260680652118e-04  1.442400000000000e-01  8.519700000000000e-01  0.000000000000000e+00
  1.570796326794897e+00  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 281
 -3.338826137275056e-01 -7.064178604352389e-02 -1.663422492893885e-02  0.000000000000000e+00 -4.892007065113529e-03 -2.763000000000000e-02  3.473500000000000e-01  0.000000000000000e+00
 -1.519980472813331e-01  6.260129087852950e-02 -2.817436821871691e-02  0.000000000000000e+00 -5.287950239504485e-03  1.710000000000000e-03  5.983600000000000e-01  0.000000000000000e+00
 -8.484033807193826e-02 -5.539551666685284e-02 -5.602553754783333e-02  0.000000000000000e+00  7.505637706163887e-03  1.509900000000000e-01  8.511900000000000e-01  0.000000000000000e+00
  1.570796326794897e+00  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 282
 -3.587476627876671e-01 -6.932538728469273e-02 -2.841907581749745e-02  0.000000000000000e+00 -1.378455177576982e-03 -5.244000000000000e-02  8.702200000000000e-01  0.000000000000000e+00
 -1.876404604829739e-01  6.468588252112034e-02 -3.578620181570014e-02  0.000000000000000e+00  2.866237228345836e-04  2.562800000000000e-01  1.134240000000000e+00  0.000000000000000e+00
 -1.167974996257160e-01 -6.881884437803543e-02  3.081766840003816e-03  0.000000000000000e+00  1.632970433226399e-02  2.215000000000000e-01  1.853900000000000e-01  0.000000000000000e+00
  1.570796326794897e+00  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 283
 -3.907207653624973e-01 -8.040891355830433e-02 -2.383284522430848e-02  0.000000000000000e+00  3.062459652942190e-03  3.181000000000000e-02  6.455000000000000e-01  0.000000000000000e+00
 -2.235704509128309e-01  5.863570006598710e-02 -2.305579867821642e-02  0.000000000000000e+00  5.196718843023584e-03  3.148000000000000e-01  6.237400000000000e-01  0.000000000000000e+00
 -7.867680439192665e-02 -6.568435181848965e-02  5.823052485193969e-02  0.000000000000000e+00  1.039188476832947e-02  9.427000000000001e-02 -1.023700000000000e+00  0.000000000000000e+00
  1.570796326794897e+00  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 284
 -4.064133532363171e-01 -8.216330417298863e-02 -3.478794235040161e-03  0.000000000000000e+00  5.605674811492267e-03  2.528100000000000e-01  1.619800000000000e-01  0.000000000000000e+00
 -2.337520578394602e-01  6.850577770873985e-02  4.188329673582347e-03  0.000000000000000e+00  7.083934868107211e-03  3.394200000000000e-01 -1.224000000000000e-02  0.000000000000000e+00
 -3.364499218321238e-04 -6.096888827991891e-02  6.893384592035316e-02  0.000000000000000e+00 -4.067657734739688e-04 -6.304000000000000e-02 -1.157460000000000e+00  0.000000000000000e+00
  1.570796326794897e+00  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 285
 -3.976783538326494e-01 -8.753779137454998e-02  1.760505386870731e-02  0.000000000000000e+00  4.760548928605307e-03  2.447200000000000e-01 -3.484700000000000e-01  0.000000000000000e+00
 -2.151937915655260e-01  6.666284247428851e-02  2.764372339431295e-02  0.000000000000000e+00  5.069254241205440e-03  4.808000000000000e-02 -5.791100000000000e-01  0.000000000000000e+00
  5.919088744877399e-02 -7.442412591679368e-02  4.189390098385455e-02  0.000000000000000e+00 -7.921095789126559e-03 -2.402400000000000e-01 -7.408600000000000e-01  0.000000000000000e+00
  1.570796326794897e+00  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 286
 -3.712032454989532e-01 -8.315931158645157e-02  2.820269239284601e-02  0.000000000000000e+00  1.830001760577488e-03  1.969100000000000e-01 -7.025500000000000e-01  0.000000000000000e+00
 -1.784646110507825e-01  7.078793567000219e-02  3.620265483367681e-02  0.000000000000000e+00  7.729877565742227e-04 -1.805800000000000e-01 -9.085500000000000e-01  0.000000000000000e+00
  8.345135204585515e-02 -8.602698664734068e-02  2.452031890279344e-03  0.000000000000000e+00 -1.245287710297072e-02 -1.692500000000000e-01 -1.110900000000000e-01  0.000000000000000e+00
  1.570796326794897e+00  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 287
 -3.412729690468841e-01 -7.860113700689013e-02  2.286201628451418e-02  0.000000000000000e+00 -2.654833415068808e-03  1.783600000000000e-01 -7.025900000000000e-01  0.000000000000000e+00
 -1.427884818982474e-01  7.101311550490803e-02  2.358644350269125e-02  0.000000000000000e+00 -4.594065290805527e-03 -1.426800000000000e-01 -7.134000000000000e-01  0.000000000000000e+00
  6.409495122928127e-02 -8.071289747728026e-02 -4.409888828790454e-02  0.000000000000000e+00 -9.717944849804261e-03 -3.404000000000000e-02  9.301600000000000e-01  0.000000000000000e+00
  1.570796326794897e+00  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 288
 -3.254792129297456e-01 -7.743065980858585e-02  3.695177659665760e-03  0.000000000000000e+00 -5.315421909867724e-03 -4.831000000000000e-02 -2.119500000000000e-01  0.000000000000000e+00
 -1.312917240454440e-01  6.197434200883061e-02 -4.604782691488146e-03  0.000000000000000e+00 -6.535516703039118e-03 -1.444600000000000e-01 -6.562999999999999e-02  0.000000000000000e+00
 -4.746424529994821e-03 -4.709241674911273e-02 -7.446764465057995e-02  0.000000000000000e+00  1.836421943472347e-03 -1.713600000000000e-01  1.078440000000000e+00  0.000000000000000e+00
  1.570796326794897e+00  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
#Fields=2
1) coordinates, coordinate, rectangular cartesian, real, #Components=3
 x. #Values=8 (value,d/ds1,d/ds2,d2/ds1ds2,d/ds3,d2/ds1ds3,d2/ds2ds3,d3/ds1ds2ds3)
 y. #Values=8 (value,d/ds1,d/ds2,d2/ds1ds2,d/ds3,d2/ds1ds3,d2/ds2ds3,d3/ds1ds2ds3)
 z. #Values=8 (value,d/ds1,d/ds2,d2/ds1ds2,d/ds3,d2/ds1ds3,d2/ds2ds3,d3/ds1ds2ds3)
2) fibres, anatomical, fibre, real, #Components=3
 fibre angle. #Values=1 (value)
 imbrication angle. #Values=1 (value)
 sheet angle. #Values=1 (value)
Node: 289
 -1.343825484149234e-01  5.669291159702738e-02  1.883660306419888e-02  0.000000000000000e+00  4.654344990526707e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  4.298391852279835e-01 -1.315387395513019e-01  6.697345639299829e-03  0.000000000000000e+00  1.730574158234077e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  2.928339535277109e-02 -3.920048594580861e-02 -2.133510214207279e-02  0.000000000000000e+00  8.522580732968656e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 290
 -1.114317448808501e-01  4.727548089941411e-02  2.298060121651278e-02  0.000000000000000e+00 -3.640087916456855e-04  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  4.377997348193415e-01 -1.166076078136914e-01  7.970694888798896e-03  0.000000000000000e+00 -8.634944889662766e-05  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  1.469426881436097e-02 -4.377744439467479e-02 -5.808693018624855e-03  0.000000000000000e+00  1.012402438833155e-02  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 291
 -8.842134598188778e-02  3.856039710038117e-02  1.985983351917241e-02  0.000000000000000e+00 -2.801815121851056e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  4.457805750055819e-01 -1.022044892255592e-01  6.888504401608930e-03  0.000000000000000e+00 -9.719652631124676e-04  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  1.766600931552523e-02 -3.306931968152238e-02  1.167102673674347e-02  0.000000000000000e+00  8.333637373544882e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 292
 -7.171207784250125e-02  3.321468529741678e-02  6.196176279594789e-04  0.000000000000000e+00 -6.334828265772710e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  4.515767436225612e-01 -8.909989242937710e-02  2.151489581397326e-04  0.000000000000000e+00 -2.196952718794692e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  3.803632228784788e-02 -1.374277008578856e-02  3.425907954618451e-02  0.000000000000000e+00  4.305781266494928e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 293
 -8.718211072596654e-02  3.732366076078319e-02 -1.849826495705909e-02  0.000000000000000e+00 -2.763044058543031e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  4.462108729218598e-01 -1.031875151512366e-01 -6.416214107576951e-03  0.000000000000000e+00 -7.502943280453811e-04  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  8.618416840789257e-02 -1.616312079530124e-02  3.009203211442518e-02  0.000000000000000e+00 -6.331546873107642e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 294
 -1.087086077566105e-01  4.444481465425791e-02 -2.404763842955035e-02  0.000000000000000e+00 -2.097575104779634e-04  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  4.387443154074057e-01 -1.177262603472421e-01 -8.341188946476924e-03  0.000000000000000e+00 -7.261897115748428e-05  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  9.822038651669536e-02 -7.448279900618360e-03 -9.016555532798121e-04  0.000000000000000e+00 -1.058368744010352e-02  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 295
 -1.352773875850561e-01  5.682527843035801e-02 -2.019817162632384e-02  0.000000000000000e+00  4.854561184636827e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  4.295284950289053e-01 -1.313822883854394e-01 -7.169635933330337e-03  0.000000000000000e+00  1.723785199796629e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  8.438085730132841e-02 -2.410972165041381e-03 -2.042795670909403e-02  0.000000000000000e+00 -9.835462586983285e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 296
 -1.491049510092528e-01  6.276028010578705e-02  4.474195850664442e-04  0.000000000000000e+00  6.855890153700403e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  4.244050435407427e-01 -1.389823366557616e-01  1.553450995397665e-04  0.000000000000000e+00  2.268885166065354e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  5.736447309850297e-02 -2.265684786430158e-02 -2.754873097427801e-02  0.000000000000000e+00  1.554322188001427e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 297
 -7.768963681786989e-02  6.792092066125902e-02  1.109420346099724e-02  0.000000000000000e+00  2.554952492182676e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  2.983004456766863e-01 -7.543882988258270e-02  1.788471006034381e-02  0.000000000000000e+00  4.052321663581215e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -9.917090593079717e-03 -1.324679376730873e-01 -3.189540040722365e-02  0.000000000000000e+00  1.054914694706136e-02  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 298
 -6.415626398146751e-02  7.611498043456449e-02  1.391434396819709e-02  0.000000000000000e+00 -1.992317725711679e-04  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  3.211921270057233e-01 -4.771013008715688e-02  2.263782005164663e-02  0.000000000000000e+00 -3.211406182901111e-04  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -2.908317558030603e-02 -1.855487838144489e-01 -2.743109886471889e-03  0.000000000000000e+00  1.149272001921705e-02  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 299
 -4.986094888138781e-02  9.364601337682674e-02  1.282943571813840e-02  0.000000000000000e+00 -2.517241575209552e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  3.435760857801165e-01 -4.891558975260418e-03  2.064236209369080e-02  0.000000000000000e+00 -4.155147685826296e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -1.540331036600228e-02 -1.560355337038396e-01  2.668836389117971e-02  0.000000000000000e+00  1.420757989976769e-02  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 300
 -3.849739254502609e-02  1.010446984167148e-01  1.249458072644094e-06  0.000000000000000e+00 -4.010836209323963e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  3.624768511932261e-01  1.760567624048809e-02 -2.763640047691585e-04  0.000000000000000e+00 -6.492227557972935e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  2.429355220206508e-02 -5.581257596478031e-02  4.271217898929230e-02  0.000000000000000e+00  2.120466031307914e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 301
 -4.985844996519802e-02  9.357070512972590e-02 -1.288320027866632e-02  0.000000000000000e+00 -2.524814048447756e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  3.430233577706589e-01 -4.229749948171130e-03 -2.072939806656909e-02  0.000000000000000e+00 -4.476212023617393e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  7.002104761258285e-02  1.091954226754066e-02  3.323927720701170e-02  0.000000000000000e+00 -8.741832803193489e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 302
 -6.426379310236011e-02  7.427237050599592e-02 -1.429682959476234e-02  0.000000000000000e+00 -3.911182460609730e-04  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  3.210180550601558e-01 -4.895807795285187e-02 -2.243857556361971e-02  0.000000000000000e+00 -6.308391717000650e-04  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  9.077210661609421e-02  3.723590962329004e-02  5.974418761846179e-03  0.000000000000000e+00 -9.912664020169416e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 303
 -7.845210915467836e-02  6.913936947797630e-02 -1.104043890056656e-02  0.000000000000000e+00  2.317555454151209e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  2.981462066434096e-01 -7.404045700518969e-02 -1.779767408757048e-02  0.000000000000000e+00  3.683200653716703e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  8.196988513627654e-02  3.846312647962030e-02 -2.803224069093557e-02  0.000000000000000e+00 -8.327232513899208e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 304
 -8.634467090346530e-02  6.099926357695706e-02  3.812361683953602e-04  0.000000000000000e+00  3.650159305906217e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  2.854227068849897e-01 -9.574666414229983e-02  7.711951663727512e-05  0.000000000000000e+00  5.884348796243541e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  3.470762523416338e-02 -1.818699925580158e-02 -4.594348786463441e-02  0.000000000000000e+00  5.073563816254956e-04  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 305
  1.459292907684753e-03  7.122002010489728e-02  3.395231992175679e-02  0.000000000000000e+00  4.862133657912646e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  2.789615254628143e-01 -5.311322563859283e-02  5.473387969448007e-02  0.000000000000000e+00  7.838195778616386e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -2.356524799931057e-01 -2.015613332219605e-01 -1.886968867008831e-01  0.000000000000000e+00  1.194883752353507e-02  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 306
  4.079821598839407e-02  1.150465044516200e-01  4.870569393204073e-02  0.000000000000000e+00  4.573773867938384e-05  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  3.423794746450957e-01 -1.502735950251806e-02  7.851796579615701e-02  0.000000000000000e+00  7.368689720033128e-05  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -3.564032988143805e-01 -2.387285049765597e-01 -2.937628904959994e-02  0.000000000000000e+00  1.884504139763368e-02  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 307
  9.887068077166040e-02  1.630939232796338e-01  4.478955150142662e-02  0.000000000000000e+00 -4.978219673554770e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  4.359974570551333e-01  2.683404475005313e-02  7.220431072924184e-02  0.000000000000000e+00 -8.025235397603803e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -2.944050580920770e-01 -1.984528032183988e-01  1.414072345863008e-01  0.000000000000000e+00  1.851896541840765e-02  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 308
  1.303773189910691e-01  1.970184143619589e-01  5.443093808946697e-04  0.000000000000000e+00 -8.629514850590887e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  4.867880961036051e-01  5.591161142261653e-02  8.769579851967135e-04  0.000000000000000e+00 -1.391149120465104e-02  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -7.358882964171332e-02 -7.691475852365121e-02  2.012141555175384e-01  0.000000000000000e+00  6.117327192622275e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 309
  9.995929953359889e-02  1.632086841122322e-01 -4.527059286787666e-02  0.000000000000000e+00 -5.043418668858855e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  4.377513730255249e-01  2.741122063796281e-02 -7.297996830094089e-02  0.000000000000000e+00 -8.130426113158284e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  1.080232529430044e-01  6.067695249000382e-02  1.231405177024875e-01  0.000000000000000e+00 -9.572062734246906e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 310
  3.983613325533700e-02  1.155620005718720e-01 -4.847897408130762e-02  0.000000000000000e+00 -9.215700008693636e-04  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  3.408281595017976e-01 -1.543732868375013e-02 -7.815189600356900e-02  0.000000000000000e+00 -1.485637691489960e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  1.726922057633214e-01  1.059087575132320e-01  2.664192865875614e-02  0.000000000000000e+00 -2.020916212885113e-02  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 311
  3.001351370964883e-03  7.093222825703618e-02 -3.347127855537201e-02  0.000000000000000e+00  5.910239687685954e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  2.814475810184631e-01 -5.345812761136309e-02 -5.395822212281196e-02  0.000000000000000e+00  9.527807344931583e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  1.613071102605737e-01  9.878729701316863e-02 -7.585086558824256e-02  0.000000000000000e+00 -1.944835630143688e-02  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 312
 -2.710642385531009e-02  5.395674981873072e-02 -7.710292316930323e-04  0.000000000000000e+00  7.673868719797543e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  2.329117152561569e-01 -6.769823491654431e-02 -1.243027777815653e-03  0.000000000000000e+00  1.237085532179930e-02  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  2.099047458694659e-02 -1.848385306291177e-02 -1.984797951270320e-01  0.000000000000000e+00 -5.964525541589973e-04  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 313
  6.475040339196333e-02  5.810873693044666e-02  7.218395809396766e-02  0.000000000000000e+00  7.135465868033129e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  1.920739943995154e-01 -8.830680477896202e-02  7.055558547440380e-02  0.000000000000000e+00  6.428533397318234e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -4.130397570367964e-01 -9.203440187354961e-02 -2.521400523207357e-01  0.000000000000000e+00  1.467376218373599e-02  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 314
  1.659367449218680e-01  1.103247265863815e-01  1.057882471428692e-01  0.000000000000000e+00  1.824966068574019e-05  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  2.911374080007131e-01 -8.758072948810405e-02  1.025850904403104e-01  0.000000000000000e+00 -4.571486283196924e-04  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -5.065401855333437e-01 -7.251061691254845e-02  3.654201170768534e-04  0.000000000000000e+00  1.803379730063784e-02  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 315
  2.763268976775857e-01  1.576653686185361e-01  9.480134562856768e-02  0.000000000000000e+00 -5.801347521588229e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  3.972441752802522e-01 -9.958990114213828e-02  9.158133301885077e-02  0.000000000000000e+00 -6.738460792116249e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -4.123089168027033e-01 -6.291127633868032e-02  1.885021103440468e-01  0.000000000000000e+00  8.114842793288848e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 316
  3.555394361788796e-01  1.938187793551614e-01  1.160102908914218e-04  0.000000000000000e+00 -9.712529982218665e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  4.743000740384222e-01 -9.952639768246768e-02  3.008118831816509e-04  0.000000000000000e+00 -9.448323134865752e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -1.295359648452123e-01 -1.487540088992778e-02  3.018419346976527e-01  0.000000000000000e+00 -2.494578457895524e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 317
  2.765589182595681e-01  1.574340295590861e-01 -9.433961406892344e-02  0.000000000000000e+00 -6.358681556738355e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  3.978457990465499e-01 -1.002109001380851e-01 -9.207833817282218e-02  0.000000000000000e+00 -6.772100462550279e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  1.913749525926015e-01  6.765481832440789e-02  2.160627932439175e-01  0.000000000000000e+00 -1.670204398513220e-02  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 318
  1.668602080410833e-01  1.106471624996810e-01 -1.065732854499613e-01  0.000000000000000e+00 -5.067499132692596e-04  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  2.901433976927857e-01 -8.687936905718144e-02 -1.033079238129430e-01  0.000000000000000e+00 -6.019288880388801e-04  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  3.025896216426384e-01  8.970423387528415e-02  4.408476328498889e-02  0.000000000000000e+00 -2.141602068130954e-02  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 319
  6.341234735944713e-02  5.739609146795299e-02 -7.264568965355106e-02  0.000000000000000e+00  7.174691279726671e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  1.912299514206791e-01 -8.941176497510772e-02 -7.005858032044955e-02  0.000000000000000e+00  5.996252189823609e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  2.795444791625326e-01  8.466795549219408e-02 -1.524248512670613e-01  0.000000000000000e+00 -1.658000853442734e-02  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 320
  2.156882873400250e-02  4.467320044906609e-02  6.690280162615081e-04  0.000000000000000e+00  1.008085508368214e-02  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  1.500262370518409e-01 -8.060156579316058e-02  4.220214894337104e-04  0.000000000000000e+00  9.352362351599239e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -2.260080891661690e-03 -1.531590654896156e-02 -3.462921180995511e-01  0.000000000000000e+00 -3.273569511729362e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 321
  1.176767667684535e-01  3.063474364342278e-02  9.960384605921047e-02  0.000000000000000e+00  1.121725615221009e-02  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  1.023479159048151e-01 -1.092203819482673e-01  4.775471599959668e-02  0.000000000000000e+00  6.117461796137105e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -4.197212837403146e-01  1.324805186467048e-02 -2.458915970642832e-01  0.000000000000000e+00  2.269699260958818e-02  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 322
  2.614476691611657e-01  5.829838952421353e-02  1.482623256200715e-01  0.000000000000000e+00 -4.544241229077622e-04  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  1.672180156689408e-01 -1.536042275225413e-01  6.723486943303486e-02  0.000000000000000e+00 -6.305340499975221e-04  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -5.014245326396796e-01  3.541269770288147e-02 -2.531635144932265e-04  0.000000000000000e+00  2.573301045221069e-02  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 323
  4.142014180087299e-01  8.261655456248712e-02  1.282836042700264e-01  0.000000000000000e+00 -1.128495406350184e-02  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  2.368176547709615e-01 -2.001186236996204e-01  6.025864253480884e-02  0.000000000000000e+00 -5.505769012796334e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -4.202276107694742e-01  2.398374034884310e-02  1.990424506090949e-01  0.000000000000000e+00  2.139955104224117e-02  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 324
  5.180148777014011e-01  8.874397278441176e-02  3.129703215452029e-04  0.000000000000000e+00 -1.497873081565665e-02  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  2.877353007385260e-01 -2.359987648671416e-01  2.559589892313086e-04  0.000000000000000e+00 -6.523197413271745e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -1.033396314214866e-01  2.051013334575257e-02  3.317802501806105e-01  0.000000000000000e+00  3.653057445255833e-04  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 325
  4.148273586518980e-01  8.161289895102558e-02 -1.284422097234659e-01  0.000000000000000e+00 -1.077055595203054e-02  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  2.373295727493592e-01 -2.010556143846574e-01 -6.033293967554482e-02  0.000000000000000e+00 -5.430937909112345e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  2.433328895918858e-01  2.077090263111314e-02  2.277201524676630e-01  0.000000000000000e+00 -1.649148422445836e-02  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 326
  2.611304582545324e-01  5.660590387876097e-02 -1.485169121725442e-01  0.000000000000000e+00 -1.065901342069797e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  1.670694213876237e-01 -1.528294471760247e-01 -6.735276084064543e-02  0.000000000000000e+00 -5.856811561211206e-04  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  3.521006735138810e-01  1.710337706526144e-02  4.365506582650858e-02  0.000000000000000e+00 -2.094777969248358e-02  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 327
  1.177935343067749e-01  3.272921403411155e-02 -9.944524060579714e-02  0.000000000000000e+00  1.075753129803115e-02  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  1.026240510682483e-01 -1.086982042518695e-01 -4.768041885893085e-02  0.000000000000000e+00  6.271319427204550e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  3.306430212449195e-01  7.925499130105151e-03 -1.808710060124972e-01  0.000000000000000e+00 -2.046581400450073e-02  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 328
  6.223997704278525e-02  2.424278106654587e-02 -5.838376909861331e-05  0.000000000000000e+00  1.385255258610289e-02  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  7.170858366981836e-02 -8.942057536507469e-02 -1.380675816908886e-04  0.000000000000000e+00  6.374603131968571e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -9.641338511014251e-03  9.709080981465529e-04 -3.751821524926483e-01  0.000000000000000e+00 -2.642233347128670e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 329
  1.260198906787272e-01 -1.333807874994491e-02  1.062395665516218e-01  0.000000000000000e+00  9.829221795843505e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -2.636676949713930e-02 -1.211964478948971e-01  6.371933316902365e-03  0.000000000000000e+00  4.679804496429121e-04  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -3.865436533073495e-01  5.684284338707268e-02 -2.176982627162307e-01  0.000000000000000e+00  2.003005480383495e-02  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 330
  2.825335239703489e-01 -2.025610104704326e-02  1.577700580619680e-01  0.000000000000000e+00  2.269470248707356e-04  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -1.607104704440605e-02 -1.788191438254311e-01  1.168684868911208e-02  0.000000000000000e+00  7.108573447925561e-04  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -4.357147901276180e-01  7.750423435557829e-02  1.110110860107849e-02  0.000000000000000e+00  2.417125405200730e-02  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 331
  4.415600068026053e-01 -2.124756497657709e-02  1.252469288887476e-01  0.000000000000000e+00 -1.050885127471869e-02  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -2.993072119004474e-03 -2.425088039059638e-01  9.186795674232192e-03  0.000000000000000e+00 -3.579077863944341e-04  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -3.643414361050631e-01  7.236536384576231e-02  1.735995459869731e-01  0.000000000000000e+00  2.215555322489474e-02  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 332
  5.330273817479414e-01 -4.810686274332854e-02 -8.876453205911572e-04  0.000000000000000e+00 -1.644930513098891e-02  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  2.302544303928341e-03 -2.776529914667614e-01 -6.361788018680523e-04  0.000000000000000e+00 -1.158623479875330e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -8.851569815371917e-02  3.308996391663203e-02  2.986290969800384e-01  0.000000000000000e+00  2.565718148916759e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 333
  4.397847161616144e-01 -2.118743953856839e-02 -1.264776829746487e-01  0.000000000000000e+00 -1.084779517976608e-02  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -4.265429722889720e-03 -2.429090473320968e-01 -8.909020481488507e-03  0.000000000000000e+00  1.304395385840888e-04  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  2.329167578549027e-01 -2.791958378470460e-02  2.126560369634345e-01  0.000000000000000e+00 -1.695858148825858e-02  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 334
  2.800720157987036e-01 -2.004407179463009e-02 -1.554569703670229e-01  0.000000000000000e+00 -1.108080018322424e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -1.551549665896868e-02 -1.785052498482576e-01 -1.095051368017085e-02  0.000000000000000e+00  7.676099860206313e-04  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  3.367963757730009e-01 -1.114285456126596e-02  3.123935978398973e-02  0.000000000000000e+00 -2.819327716190530e-02  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 335
  1.288707754275767e-01 -1.433715301505567e-02 -1.050088124658047e-01  0.000000000000000e+00  1.087944811815015e-02  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -2.616645708300240e-02 -1.209029589331681e-01 -6.649708509682883e-03  0.000000000000000e+00  8.219216535558082e-04  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  2.953954774228126e-01 -1.650120588637732e-02 -1.685573202341884e-01  0.000000000000000e+00 -2.241723749026013e-02  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 336
  7.005439086709250e-02 -1.454047392324997e-02 -1.425442374437980e-03  0.000000000000000e+00  1.615814353244690e-02  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -2.881491367813990e-02 -9.551263577729742e-02 -1.001562071100102e-04  0.000000000000000e+00 -4.968144529411550e-04  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -3.182646953499991e-04  1.012688370064353e-02 -3.409695653651181e-01  0.000000000000000e+00 -1.237052890763765e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 337
  9.100060926858125e-02 -5.296127247841576e-02  9.388821893538568e-02  0.000000000000000e+00  8.805044781717012e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -1.400449798849780e-01 -9.624290649196138e-02 -3.555179204864543e-02  0.000000000000000e+00 -3.187225285568682e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -3.060355969660867e-01  8.869792749026384e-02 -1.785142464093725e-01  0.000000000000000e+00  1.604531712689412e-02  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 338
  2.209354670669982e-01 -8.494569590083655e-02  1.403528393935285e-01  0.000000000000000e+00 -2.726090385157809e-05  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -1.904202719818218e-01 -1.548896290803624e-01 -5.407748657810717e-02  0.000000000000000e+00  2.560734097583686e-04  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -3.464160639283910e-01  1.149293160833418e-01  1.526935694405884e-02  0.000000000000000e+00  1.255592671971129e-02  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 339
  3.717062880556224e-01 -1.364020150350995e-01  1.004328425738989e-01  0.000000000000000e+00 -8.718188512961175e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -2.481999530411312e-01 -1.940634067358865e-01 -3.857520510657405e-02  0.000000000000000e+00  3.748420423008478e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -2.754968830779148e-01  1.064462510469452e-01  1.546281801700149e-01  0.000000000000000e+00  1.337849369365381e-02  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 340
  4.218011522149170e-01 -1.664041163966040e-01  3.730957595650675e-04  0.000000000000000e+00 -1.089216987332643e-02  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -2.675706821951004e-01 -2.148191978319720e-01 -1.442844369085039e-04  0.000000000000000e+00  4.210298438045768e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -3.715970358824257e-02  5.179335498096951e-02  2.314953025501568e-01  0.000000000000000e+00  1.854664356132034e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 341
  3.724524795748310e-01 -1.357040980332977e-01 -1.003794187748370e-01  0.000000000000000e+00 -7.771477900694157e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -2.484885219149620e-01 -1.932073495891183e-01  3.881480194315079e-02  0.000000000000000e+00  3.577018292513348e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  1.874937220223436e-01 -3.757879835912131e-02  1.834873339898089e-01  0.000000000000000e+00 -1.014975819934558e-02  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 342
  2.210423146652937e-01 -8.468418053540699e-02 -1.416666256490878e-01  0.000000000000000e+00 -9.942657447690323e-05  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -1.899410783087039e-01 -1.544245854272950e-01  5.465332755842287e-02  0.000000000000000e+00  7.573121277563502e-04  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  3.298149643912679e-01 -4.076269983589054e-02  5.507344372490186e-02  0.000000000000000e+00 -1.763795410027316e-02  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 343
  8.911922827662511e-02 -5.375664721176776e-02 -9.394164273446226e-02  0.000000000000000e+00  8.568556440519584e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -1.391818667981698e-01 -9.702077619607224e-02  3.531219521210763e-02  0.000000000000000e+00 -2.999270301301725e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  2.976406094721470e-01 -3.821419474729226e-02 -1.596012677505043e-01  0.000000000000000e+00 -1.420803738972511e-02  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 344
  3.315902919630200e-02 -4.006217000574575e-02  9.406904959795570e-04  0.000000000000000e+00  1.034899636332565e-02  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -1.193166878847052e-01 -7.741777312702276e-02 -4.315565433682528e-04  0.000000000000000e+00 -4.192219975658416e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  1.061242889033176e-02  1.583063995631397e-02 -3.018381032191705e-01  0.000000000000000e+00 -2.251651281507982e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 345
  2.009734572189979e-02 -9.481599836434457e-02  6.135604065654432e-02  0.000000000000000e+00  4.190758174950278e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -2.188525824810147e-01 -4.879106194721707e-02 -7.109992263639647e-02  0.000000000000000e+00 -5.627512582083771e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -2.091477983266390e-01  9.826198414994092e-02 -1.185995865892838e-01  0.000000000000000e+00  1.136862586357956e-02  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 346
  1.126421321686871e-01 -1.472821446759550e-01  7.432931550522488e-02  0.000000000000000e+00  4.234527070193991e-04  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -3.258503052050011e-01 -7.352991207456883e-02 -8.613365155493356e-02  0.000000000000000e+00 -2.399019582835782e-04  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -2.058561579608803e-01  1.015551685444225e-01  2.884943215774738e-02  0.000000000000000e+00  1.613441329940914e-02  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 347
  1.687559767323138e-01 -2.133561012362128e-01  4.378850839311312e-02  0.000000000000000e+00 -4.511831042889464e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -3.911198855909221e-01 -8.109574857113783e-02 -5.074277307746432e-02  0.000000000000000e+00  5.228413362463227e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -1.514489340111886e-01  8.486576271989310e-02  1.104635848845934e-01  0.000000000000000e+00  1.023256388477157e-02  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 348
  2.002191489549673e-01 -2.343607034071079e-01 -1.897283187387022e-04  0.000000000000000e+00 -7.420493763222027e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -4.273358513599258e-01 -8.869785641313385e-02  2.198783448760233e-04  0.000000000000000e+00  8.680484307494671e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  1.507101180827373e-02  4.076693161818856e-02  1.546040475738541e-01  0.000000000000000e+00 -2.029311153933734e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 349
  1.683765200951356e-01 -2.150461258281874e-01 -4.475774711357872e-02  0.000000000000000e+00 -5.107254618777632e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -3.906801289010901e-01 -8.021013275693184e-02  5.148559192317903e-02  0.000000000000000e+00  5.918522429703227e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  1.577591611366613e-01 -6.375523096970370e-03  1.200999821464168e-01  0.000000000000000e+00 -1.125402462514059e-02  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 350
  1.107036547280316e-01 -1.475326042305078e-01 -7.350951954562814e-02  0.000000000000000e+00  3.783207661181426e-04  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -3.243646675135582e-01 -7.251145388824541e-02  8.523605971290649e-02  0.000000000000000e+00 -8.467127926778395e-06  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  2.552709761011812e-01 -2.938538166269844e-02  3.060396339579324e-02  0.000000000000000e+00 -1.641874331848346e-02  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 351
  2.135748100413535e-02 -9.336753567107847e-02 -6.038680193626629e-02  0.000000000000000e+00  4.477376289401932e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -2.202080094752255e-01 -4.952808348010501e-02  7.035710379062637e-02  0.000000000000000e+00 -5.770690952756667e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  2.189670879282006e-01 -4.235333529062085e-02 -1.119639804418956e-01  0.000000000000000e+00 -1.185413709899522e-02  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 352
 -1.006994914453124e-02 -7.026134498474101e-02 -6.300676410456174e-04  0.000000000000000e+00  7.212856545241680e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -1.836504599322291e-01 -4.394698754081366e-02  6.777134970956666e-04  0.000000000000000e+00 -8.277037103265883e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  3.134301521748901e-02  2.540195926940873e-02 -2.140574431275639e-01  0.000000000000000e+00 -2.207732243963798e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 353
 -9.863138746011027e-02 -1.064133548139271e-01  1.686741924426875e-02  0.000000000000000e+00  1.715922450303730e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -2.376271037793504e-01 -9.406559598460262e-03 -6.513471658233785e-02  0.000000000000000e+00 -5.043433315125356e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -1.095116286660244e-01  8.847490112784595e-02 -1.023610371343654e-01  0.000000000000000e+00  1.091227961420324e-02  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 354
 -7.362882228477914e-02 -1.578607762920765e-01  2.181273652152690e-02  0.000000000000000e+00 -6.686493928148574e-05  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -3.374800961310166e-01  9.324634414609151e-03 -8.638217320203607e-02  0.000000000000000e+00 -3.871994722501326e-04  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -1.433057268394843e-01  7.693946298224202e-02  1.873135513914936e-03  0.000000000000000e+00  1.329374367590152e-02  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 355
 -5.500591441716867e-02 -1.911395247135609e-01  1.335428384294717e-02  0.000000000000000e+00 -1.166918135781344e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -4.103914501834375e-01  8.368878743248986e-03 -5.374314944515306e-02  0.000000000000000e+00  5.856887840758898e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -1.057653576382126e-01  6.167914146519249e-02  9.383994324383282e-02  0.000000000000000e+00  1.076942836973352e-02  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 356
 -4.692025459917305e-02 -2.095751274542382e-01 -1.316928832063663e-03  0.000000000000000e+00 -1.588856348251335e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -4.449663950212431e-01  1.027489789480729e-02  7.413313772801633e-04  0.000000000000000e+00  8.837011753722326e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  4.437415964810329e-02  3.378815080375289e-02  1.402540167333809e-01  0.000000000000000e+00 -2.123554088616015e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 357
 -5.763977208117423e-02 -1.908899359937825e-01 -1.355131959832165e-02  0.000000000000000e+00 -2.199273421314010e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -4.089087874288381e-01  8.534025878323137e-03  5.500120446800497e-02  0.000000000000000e+00  6.706346730278465e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  1.747426758285515e-01  1.837279737158529e-02  1.133350207088274e-01  0.000000000000000e+00 -6.329602540732830e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 358
 -7.402289379543076e-02 -1.571053842179508e-01 -1.998803549218306e-02  0.000000000000000e+00  2.449695112578497e-04  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -3.349639860852041e-01  7.206326821051545e-03  8.533537683523763e-02  0.000000000000000e+00  3.592808341708054e-04  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  2.710442010658144e-01 -1.556495265390423e-03  1.909563153117316e-02  0.000000000000000e+00 -1.448893623402582e-02  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 359
 -9.761584306553898e-02 -1.076467592653269e-01 -1.667038348886391e-02  0.000000000000000e+00  2.051231568201979e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -2.382380337583382e-01 -8.107313142235062e-03  6.387666155945758e-02  0.000000000000000e+00 -5.234515796978249e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  2.129339388908911e-01  1.811946229836520e-03 -1.048139268182627e-01  0.000000000000000e+00 -1.115863796541144e-02  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 360
 -1.073636607733892e-01 -8.890950705079877e-02 -5.077721972498034e-04  0.000000000000000e+00  2.040478656067355e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -2.072106629663291e-01 -1.048840682368574e-02  3.054649894899120e-04  0.000000000000000e+00 -7.976263360322658e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  6.141634742920943e-02  1.935885982525740e-02 -1.612227837784369e-01  0.000000000000000e+00  5.959950641713785e-04  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 361
 -1.927293639059320e-01 -8.371588837415876e-02 -7.595228584533362e-03  0.000000000000000e+00 -1.550842532477420e-04  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -2.376657016778855e-01  9.539249409709433e-03 -5.128688139812188e-02  0.000000000000000e+00 -4.266211994614848e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -3.219799607096174e-02  4.326917303313005e-02 -6.101898343209433e-02  0.000000000000000e+00  7.504665539951104e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 362
 -2.030794204155141e-01 -1.080789203167098e-01 -1.039685439446125e-02  0.000000000000000e+00  6.836428897784505e-04  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -3.072010363758249e-01  4.240105016797945e-02 -6.835821321326022e-02  0.000000000000000e+00  1.405848359670447e-04  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -5.197723199636847e-02  5.133357755673140e-02  2.053672495083148e-03  0.000000000000000e+00  1.067976033474488e-02  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 363
 -2.135230726951125e-01 -1.264601905612271e-01 -7.925842768954534e-03  0.000000000000000e+00  1.320109270834494e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -3.743821281044173e-01  6.580865419807286e-02 -4.979250959721057e-02  0.000000000000000e+00  4.252481516872311e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -2.809065108086011e-02  4.878718835926876e-02  6.731227270606782e-02  0.000000000000000e+00  8.811371279316006e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 364
 -2.189311059534152e-01 -1.372343055759074e-01  5.986040141227333e-05  0.000000000000000e+00  1.778243905506634e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -4.067860555702700e-01  7.341236392905132e-02  3.850254799697694e-04  0.000000000000000e+00  7.512402054032183e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  8.264731341585919e-02  7.404360862998768e-03  1.112977034803049e-01  0.000000000000000e+00 -6.224151102169791e-04  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 365
 -2.134033518922032e-01 -1.249355487866026e-01  7.711996122878886e-03  0.000000000000000e+00  1.490944268510576e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -3.736120771445120e-01  6.514715029275941e-02  4.841702084944438e-02  0.000000000000000e+00  4.225630804859756e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  1.945047558799185e-01 -2.338557220734011e-02  8.475533607724547e-02  0.000000000000000e+00 -5.339251118676717e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 366
 -2.035071137076279e-01 -1.071107796051055e-01  9.733657182709049e-03  0.000000000000000e+00  3.864990373142266e-04  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -3.099520138714193e-01  4.294103934525596e-02  6.859472069240945e-02  0.000000000000000e+00  1.807846235850341e-04  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  2.521579855704231e-01 -5.486728730521873e-02  1.404311225395555e-02  0.000000000000000e+00 -1.146675746319137e-02  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 367
 -1.939360375266534e-01 -8.376745691730107e-02  7.809075230687509e-03  0.000000000000000e+00 -7.054516128493712e-04  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -2.364226357598452e-01  1.050099309500477e-02  5.266237014597665e-02  0.000000000000000e+00 -4.485975918819156e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  2.225909803878623e-01 -3.769597297880903e-02 -9.104862535124661e-02  0.000000000000000e+00 -7.499518777735900e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 368
 -1.878889632463696e-01 -7.205545322193073e-02  6.033368104184228e-04  0.000000000000000e+00 -7.245342454815090e-04  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -2.046272735795917e-01  4.349510226216213e-03 -6.215329590304186e-04  0.000000000000000e+00 -6.828853103876008e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  7.006073486786146e-02 -9.160264570955822e-03 -1.273944882293713e-01  0.000000000000000e+00 -1.304990151537941e-04  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 369
 -2.660631642084523e-01 -7.302260951215467e-02 -1.915604785041419e-02  0.000000000000000e+00 -2.822336524473959e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -2.185486049599426e-01  4.018983300840043e-02 -2.708317664059370e-02  0.000000000000000e+00 -3.949266800105218e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -2.297328259979201e-02 -2.256832355428584e-02 -4.186719500658585e-02  0.000000000000000e+00  6.471538805276743e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 370
 -2.897866629182922e-01 -7.852332984367127e-02 -2.093156566561667e-02  0.000000000000000e+00 -3.643874152968324e-04  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -2.526779957950928e-01  5.992358073775264e-02 -3.011276841367237e-02  0.000000000000000e+00 -3.516527909934869e-04  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -4.063857172602162e-02 -2.424525305541692e-02  7.391150840047045e-03  0.000000000000000e+00  7.340083521653480e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 371
 -3.079262955397500e-01 -8.706761650721405e-02 -1.580110141623065e-02  0.000000000000000e+00  2.385556264430030e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -2.787741417872960e-01  7.800417894718326e-02 -2.273183568404920e-02  0.000000000000000e+00  3.432009191479277e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -8.190980919694389e-03 -2.009713427136145e-02  4.991072655012158e-02  0.000000000000000e+00  4.801471653750129e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 372
 -3.213888657507759e-01 -9.093828623573687e-02  2.077129426546614e-04  0.000000000000000e+00  2.861183312522594e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -2.981416671631259e-01  9.005896629945404e-02  7.982747194054673e-05  0.000000000000000e+00  4.116168385067592e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  5.918288137422210e-02 -4.169529314870823e-02  6.808125616680663e-02  0.000000000000000e+00 -1.449556983871373e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 373
 -3.075108696543858e-01 -8.975724543715813e-02  1.657220637258189e-02  0.000000000000000e+00  2.629692803669065e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -2.786144868433553e-01  8.174378898020809e-02  2.452987988421060e-02  0.000000000000000e+00  3.242147196532000e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  1.279715314139494e-01 -7.161748211013755e-02  5.106337254057711e-02  0.000000000000000e+00 -5.643481951632980e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 374
 -2.882444530055460e-01 -8.293304608420610e-02  2.118005637710507e-02  0.000000000000000e+00 -2.005190930571693e-04  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -2.490819073946156e-01  6.613017621842467e-02  3.068921963740343e-02  0.000000000000000e+00  1.706393260961434e-04  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  1.613096264554329e-01 -9.057975531378151e-02  4.785230759652009e-03  0.000000000000000e+00 -8.168712237796034e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 375
 -2.651507569002584e-01 -7.499588246757853e-02  1.838494289412634e-02  0.000000000000000e+00 -2.478924860166418e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -2.172360475684527e-01  4.452004428541836e-02  2.528513244035971e-02  0.000000000000000e+00 -3.434450165315170e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  1.375419929332668e-01 -8.410701559731501e-02 -5.910690408410722e-02  0.000000000000000e+00 -7.265855773309030e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 376
 -2.514745672173746e-01 -7.145283579661468e-02 -4.562036540796677e-04  0.000000000000000e+00 -3.426014096174594e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -1.985116425138671e-01  3.340003548565745e-02 -6.562786957441946e-04  0.000000000000000e+00 -5.245576459625846e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  4.309581828715525e-02 -3.648534013403561e-02 -8.025763776650008e-02  0.000000000000000e+00  7.498260680567186e-04  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 377
 -3.387745829302568e-01 -7.271141872184239e-02 -1.466572263164673e-02  0.000000000000000e+00 -4.891969202790392e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -1.572860356610772e-01  6.126256929883434e-02 -2.476333614603499e-02  0.000000000000000e+00 -5.287988379769626e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -7.733464317955077e-02 -5.436136057975416e-02 -4.877889635341642e-02  0.000000000000000e+00  7.505694892388060e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 378
 -3.601260801028845e-01 -7.033941718456341e-02 -2.444186138962257e-02  0.000000000000000e+00 -1.378417315187064e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -1.873538749003721e-01  6.532412089475165e-02 -3.054386727443137e-02  0.000000000000000e+00  2.865855826335029e-04  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -1.004677381072336e-01 -5.982916638116709e-02  4.524861778030798e-03  0.000000000000000e+00  1.632976151853249e-02  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 379
 -3.876583057095816e-01 -7.973201016981740e-02 -2.034079916098558e-02  0.000000000000000e+00  3.062459652928673e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -2.183737702100562e-01  6.040037157725264e-02 -1.965712403542308e-02  0.000000000000000e+00  5.196680702782563e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -6.828491962358640e-02 -6.009393870389002e-02  4.986223261284339e-02  0.000000000000000e+00  1.039188476833719e-02  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 380
 -4.008076784248244e-01 -7.941881267406498e-02 -2.629768528475962e-03  0.000000000000000e+00  5.605674811471006e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -2.266681229713545e-01  7.147354419179852e-02  4.124635512998798e-03  0.000000000000000e+00  7.083934868130304e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -7.432728815612294e-04 -5.992615425578005e-02  5.977735564164766e-02  0.000000000000000e+00 -4.068229597210538e-04  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 381
 -3.929178427664263e-01 -8.540697311208514e-02  1.571723627435828e-02  0.000000000000000e+00  4.760511066187412e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -2.101244991840036e-01  6.848998765925080e-02  2.448823076834206e-02  0.000000000000000e+00  5.069292381425172e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  5.126979165963752e-02 -7.670173975428141e-02  3.587087391226362e-02  0.000000000000000e+00 -7.921095789114041e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 382
 -3.693732058759867e-01 -8.112875287047094e-02  2.449502015221833e-02  0.000000000000000e+00  1.830039622930324e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -1.776916614344655e-01  7.139024596013141e-02  3.137097599752434e-02  0.000000000000000e+00  7.729496163076111e-04  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  7.099847494287380e-02 -9.031115151253849e-02  1.553578766806285e-03  0.000000000000000e+00 -1.245287710297283e-02  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 383
 -3.439278024619372e-01 -7.877704556168097e-02  1.928928551821135e-02  0.000000000000000e+00 -2.654833415041968e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -1.473825471891101e-01  6.985350037944904e-02  1.993222941321413e-02  0.000000000000000e+00 -4.594065290759008e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  5.437694919322215e-02 -8.316504374004968e-02 -3.695421017156042e-02  0.000000000000000e+00 -9.718002036069096e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
Node: 384
 -3.307946348395612e-01 -7.932006762218102e-02  2.576609765817528e-03  0.000000000000000e+00 -5.315421909812157e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -1.378272026082779e-01  6.068443990560890e-02 -4.951744235993649e-03  0.000000000000000e+00 -6.535478562833097e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
 -2.909945400287150e-03 -4.600576368742711e-02 -6.585579618635456e-02  0.000000000000000e+00  1.836479129718016e-03  0.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
  7.853981633974483e-01
  0.000000000000000e+00
  0.000000000000000e+00
!#mesh mesh3d, dimension=3, face mesh=mesh2d, nodeset=nodes
Shape. Dimension=3, line*line*line
#Scale factor sets=2
  scaling1, #Scale factors=64, identifiers="element_patch(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0)"
  scaling2, #Scale factors=8, identifiers="element_patch(0,0,0,0,0,0,0,0)"
#Nodes=8
#Fields=2
1) coordinates, coordinate, rectangular cartesian, real, #Components=3
 x. c.Hermite*c.Hermite*c.Hermite, no modify, standard node based. scale factor set=scaling1
  #Nodes=8
  1. #Values=8
   Value labels: value d/ds1 d/ds2 d2/ds1ds2 d/ds3 d2/ds1ds3 d2/ds2ds3 d3/ds1ds2ds3
   Scale factor indices: 1 2 3 4 5 6 7 8
  2. #Values=8
   Value labels: value d/ds1 d/ds2 d2/ds1ds2 d/ds3 d2/ds1ds3 d2/ds2ds3 d3/ds1ds2ds3
   Scale factor indices: 9 10 11 12 13 14 15 16
  3. #Values=8
   Value labels: value d/ds1 d/ds2 d2/ds1ds2 d/ds3 d2/ds1ds3 d2/ds2ds3 d3/ds1ds2ds3
   Scale factor indices: 17 18 19 20 21 22 23 24
  4. #Values=8
   Value labels: value d/ds1 d/ds2 d2/ds1ds2 d/ds3 d2/ds1ds3 d2/ds2ds3 d3/ds1ds2ds3
   Scale factor indices: 25 26 27 28 29 30 31 32
  5. #Values=8
   Value labels: value d/ds1 d/ds2 d2/ds1ds2 d/ds3 d2/ds1ds3 d2/ds2ds3 d3/ds1ds2ds3
   Scale factor indices: 33 34 35 36 37 38 39 40
  6. #Values=8
   Value labels: value d/ds1 d/ds2 d2/ds1ds2 d/ds3 d2/ds1ds3 d2/ds2ds3 d3/ds1ds2ds3
   Scale factor indices: 41 42 43 44 45 46 47 48
  7. #Values=8
   Value labels: value d/ds1 d/ds2 d2/ds1ds2 d/ds3 d2/ds1ds3 d2/ds2ds3 d3/ds1ds2ds3
   Scale factor indices: 49 50 51 52 53 54 55 56
  8. #Values=8
   Value labels: value d/ds1 d/ds2 d2/ds1ds2 d/ds3 d2/ds1ds3 d2/ds2ds3 d3/ds1ds2ds3
   Scale factor indices: 57 58 59 60 61 62 63 64
 y. c.Hermite*c.Hermite*c.Hermite, no modify, standard node based. scale factor set=scaling1
  #Nodes=8
  1. #Values=8
   Value labels: value d/ds1 d/ds2 d2/ds1ds2 d/ds3 d2/ds1ds3 d2/ds2ds3 d3/ds1ds2ds3
   Scale factor indices: 1 2 3 4 5 6 7 8
  2. #Values=8
   Value labels: value d/ds1 d/ds2 d2/ds1ds2 d/ds3 d2/ds1ds3 d2/ds2ds3 d3/ds1ds2ds3
   Scale factor indices: 9 10 11 12 13 14 15 16
  3. #Values=8
   Value labels: value d/ds1 d/ds2 d2/ds1ds2 d/ds3 d2/ds1ds3 d2/ds2ds3 d3/ds1ds2ds3
   Scale factor indices: 17 18 19 20 21 22 23 24
  4. #Values=8
   Value labels: value d/ds1 d/ds2 d2/ds1ds2 d/ds3 d2/ds1ds3 d2/ds2ds3 d3/ds1ds2ds3
   Scale factor indices: 25 26 27 28 29 30 31 32
  5. #Values=8
   Value labels: value d/ds1 d/ds2 d2/ds1ds2 d/ds3 d2/ds1ds3 d2/ds2ds3 d3/ds1ds2ds3
   Scale factor indices: 33 34 35 36 37 38 39 40
  6. #Values=8
   Value labels: value d/ds1 d/ds2 d2/ds1ds2 d/ds3 d2/ds1ds3 d2/ds2ds3 d3/ds1ds2ds3
   Scale factor indices: 41 42 43 44 45 46 47 48
  7. #Values=8
   Value labels: value d/ds1 d/ds2 d2/ds1ds2 d/ds3 d2/ds1ds3 d2/ds2ds3 d3/ds1ds2ds3
   Scale factor indices: 49 50 51 52 53 54 55 56
  8. #Values=8
   Value labels: value d/ds1 d/ds2 d2/ds1ds2 d/ds3 d2/ds1ds3 d2/ds2ds3 d3/ds1ds2ds3
   Scale factor indices: 57 58 59 60 61 62 63 64
 z. c.Hermite*c.Hermite*c.Hermite, no modify, standard node based. scale factor set=scaling1
  #Nodes=8
  1. #Values=8
   Value labels: value d/ds1 d/ds2 d2/ds1ds2 d/ds3 d2/ds1ds3 d2/ds2ds3 d3/ds1ds2ds3
   Scale factor indices: 1 2 3 4 5 6 7 8
  2. #Values=8
   Value labels: value d/ds1 d/ds2 d2/ds1ds2 d/ds3 d2/ds1ds3 d2/ds2ds3 d3/ds1ds2ds3
   Scale factor indices: 9 10 11 12 13 14 15 16
  3. #Values=8
   Value labels: value d/ds1 d/ds2 d2/ds1ds2 d/ds3 d2/ds1ds3 d2/ds2ds3 d3/ds1ds2ds3
   Scale factor indices: 17 18 19 20 21 22 23 24
  4. #Values=8
   Value labels: value d/ds1 d/ds2 d2/ds1ds2 d/ds3 d2/ds1ds3 d2/ds2ds3 d3/ds1ds2ds3
   Scale factor indices: 25 26 27 28 29 30 31 32
  5. #Values=8
   Value labels: value d/ds1 d/ds2 d2/ds1ds2 d/ds3 d2/ds1ds3 d2/ds2ds3 d3/ds1ds2ds3
   Scale factor indices: 33 34 35 36 37 38 39 40
  6. #Values=8
   Value labels: value d/ds1 d/ds2 d2/ds1ds2 d/ds3 d2/ds1ds3 d2/ds2ds3 d3/ds1ds2ds3
   Scale factor indices: 41 42 43 44 45 46 47 48
  7. #Values=8
   Value labels: value d/ds1 d/ds2 d2/ds1ds2 d/ds3 d2/ds1ds3 d2/ds2ds3 d3/ds1ds2ds3
   Scale factor indices: 49 50 51 52 53 54 55 56
  8. #Values=8
   Value labels: value d/ds1 d/ds2 d2/ds1ds2 d/ds3 d2/ds1ds3 d2/ds2ds3 d3/ds1ds2ds3
   Scale factor indices: 57 58 59 60 61 62 63 64
2) fibres, anatomical, fibre, real, #Components=3
 fibre angle. l.Lagrange*l.Lagrange*l.Lagrange, no modify, standard node based. scale factor set=scaling2
  #Nodes=8
  1. #Values=1
   Value labels: value
   Scale factor indices: 65
  2. #Values=1
   Value labels: value
   Scale factor indices: 66
  3. #Values=1
   Value labels: value
   Scale factor indices: 67
  4. #Values=1
   Value labels: value
   Scale factor indices: 68
  5. #Values=1
   Value labels: value
   Scale factor indices: 69
  6. #Values=1
   Value labels: value
   Scale factor indices: 70
  7. #Values=1
   Value labels: value
   Scale factor indices: 71
  8. #Values=1
   Value labels: value
   Scale factor indices: 72
 imbrication angle. l.Lagrange*l.Lagrange*l.Lagrange, no modify, standard node based. scale factor set=scaling2
  #Nodes=8
  1. #Values=1
   Value labels: value
   Scale factor indices: 65
  2. #Values=1
   Value labels: value
   Scale factor indices: 66
  3. #Values=1
   Value labels: value
   Scale factor indices: 67
  4. #Values=1
   Value labels: value
   Scale factor indices: 68
  5. #Values=1
   Value labels: value
   Scale factor indices: 69
  6. #Values=1
   Value labels: value
   Scale factor indices: 70
  7. #Values=1
   Value labels: value
   Scale factor indices: 71
  8. #Values=1
   Value labels: value
   Scale factor indices: 72
 sheet angle. l.Lagrange*l.Lagrange*l.Lagrange, no modify, standard node based. scale factor set=scaling2
  #Nodes=8
  1. #Values=1
   Value labels: value
   Scale factor indices: 65
  2. #Values=1
   Value labels: value
   Scale factor indices: 66
  3. #Values=1
   Value labels: value
   Scale factor indices: 67
  4. #Values=1
   Value labels: value
   Scale factor indices: 68
  5. #Values=1
   Value labels: value
   Scale factor indices: 69
  6. #Values=1
   Value labels: value
   Scale factor indices: 70
  7. #Values=1
   Value labels: value
   Scale factor indices: 71
  8. #Values=1
   Value labels: value
   Scale factor indices: 72
Element: 1
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 8 16 1 9 104 112 97 105
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
Element: 2
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 1 9 2 10 97 105 98 106
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
Element: 3
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 2 10 3 11 98 106 99 107
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
Element: 4
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 3 11 4 12 99 107 100 108
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
Element: 5
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 4 12 5 13 100 108 101 109
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
Element: 6
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 5 13 6 14 101 109 102 110
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
Element: 7
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 6 14 7 15 102 110 103 111
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
Element: 8
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 7 15 8 16 103 111 104 112
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
Element: 9
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 16 24 9 17 112 120 105 113
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
Element: 10
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 9 17 10 18 105 113 106 114
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
Element: 11
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 10 18 11 19 106 114 107 115
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
Element: 12
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 11 19 12 20 107 115 108 116
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
Element: 13
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 12 20 13 21 108 116 109 117
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
Element: 14
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 13 21 14 22 109 117 110 118
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
Element: 15
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 14 22 15 23 110 118 111 119
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
Element: 16
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 15 23 16 24 111 119 112 120
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
Element: 17
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 24 32 17 25 120 128 113 121
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
Element: 18
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 17 25 18 26 113 121 114 122
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
Element: 19
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 18 26 19 27 114 122 115 123
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
Element: 20
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 19 27 20 28 115 123 116 124
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
Element: 21
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 20 28 21 29 116 124 117 125
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
Element: 22
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 21 29 22 30 117 125 118 126
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
Element: 23
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 22 30 23 31 118 126 119 127
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
Element: 24
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 23 31 24 32 119 127 120 128
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
Element: 25
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 32 40 25 33 128 136 121 129
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
Element: 26
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 25 33 26 34 121 129 122 130
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
Element: 27
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 26 34 27 35 122 130 123 131
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
Element: 28
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 27 35 28 36 123 131 124 132
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
Element: 29
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 28 36 29 37 124 132 125 133
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
Element: 30
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 29 37 30 38 125 133 126 134
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
Element: 31
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 30 38 31 39 126 134 127 135
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
Element: 32
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 31 39 32 40 127 135 128 136
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
Element: 33
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 40 48 33 41 136 144 129 137
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
Element: 34
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 33 41 34 42 129 137 130 138
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
Element: 35
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 34 42 35 43 130 138 131 139
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
Element: 36
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 35 43 36 44 131 139 132 140
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
Element: 37
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 36 44 37 45 132 140 133 141
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
Element: 38
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 37 45 38 46 133 141 134 142
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
Element: 39
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 38 46 39 47 134 142 135 143
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
Element: 40
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 39 47 40 48 135 143 136 144
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
Element: 41
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 48 56 41 49 144 152 137 145
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
Element: 42
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 41 49 42 50 137 145 138 146
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
Element: 43
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 42 50 43 51 138 146 139 147
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
Element: 44
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 43 51 44 52 139 147 140 148
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
Element: 45
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 44 52 45 53 140 148 141 149
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
Element: 46
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 45 53 46 54 141 149 142 150
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
Element: 47
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 46 54 47 55 142 150 143 151
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
Element: 48
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 47 55 48 56 143 151 144 152
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
Element: 49
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 56 64 49 57 152 160 145 153
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
Element: 50
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 49 57 50 58 145 153 146 154
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
Element: 51
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 50 58 51 59 146 154 147 155
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
Element: 52
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 51 59 52 60 147 155 148 156
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
Element: 53
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 52 60 53 61 148 156 149 157
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
Element: 54
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 53 61 54 62 149 157 150 158
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
Element: 55
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 54 62 55 63 150 158 151 159
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
Element: 56
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 55 63 56 64 151 159 152 160
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
Element: 57
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 64 72 57 65 160 168 153 161
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
Element: 58
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 57 65 58 66 153 161 154 162
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
Element: 59
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 58 66 59 67 154 162 155 163
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
Element: 60
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 59 67 60 68 155 163 156 164
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
Element: 61
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 60 68 61 69 156 164 157 165
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
Element: 62
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 61 69 62 70 157 165 158 166
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
Element: 63
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 62 70 63 71 158 166 159 167
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
Element: 64
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 63 71 64 72 159 167 160 168
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
Element: 65
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 72 80 65 73 168 176 161 169
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
Element: 66
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 65 73 66 74 161 169 162 170
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
Element: 67
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 66 74 67 75 162 170 163 171
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
Element: 68
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 67 75 68 76 163 171 164 172
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
Element: 69
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 68 76 69 77 164 172 165 173
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
Element: 70
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 69 77 70 78 165 173 166 174
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
Element: 71
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 70 78 71 79 166 174 167 175
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
Element: 72
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 71 79 72 80 167 175 168 176
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
Element: 73
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 80 88 73 81 176 184 169 177
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
Element: 74
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 73 81 74 82 169 177 170 178
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
Element: 75
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 74 82 75 83 170 178 171 179
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
Element: 76
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 75 83 76 84 171 179 172 180
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
Element: 77
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 76 84 77 85 172 180 173 181
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
Element: 78
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 77 85 78 86 173 181 174 182
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
Element: 79
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 78 86 79 87 174 182 175 183
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
Element: 80
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 79 87 80 88 175 183 176 184
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
Element: 81
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 88 96 81 89 184 192 177 185
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
Element: 82
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 81 89 82 90 177 185 178 186
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
Element: 83
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 82 90 83 91 178 186 179 187
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
Element: 84
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 83 91 84 92 179 187 180 188
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
Element: 85
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 84 92 85 93 180 188 181 189
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
Element: 86
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 85 93 86 94 181 189 182 190
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
Element: 87
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 86 94 87 95 182 190 183 191
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
Element: 88
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 87 95 88 96 183 191 184 192
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
#Scale factor sets=3
  scaling1, #Scale factors=64, identifiers="element_patch(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0)"
  scaling2, #Scale factors=8, identifiers="element_patch(0,0,0,0,0,0,0,0)"
  scaling3, #Scale factors=8, identifiers="element_patch(0,0,0,0,0,0,0,0)"
#Nodes=8
#Fields=2
1) coordinates, coordinate, rectangular cartesian, real, #Components=3
 x. c.Hermite*c.Hermite*c.Hermite, no modify, standard node based. scale factor set=scaling1
  #Nodes=8
  1. #Values=8
   Value labels: value d/ds1 d/ds2 d2/ds1ds2 d/ds3 d2/ds1ds3 d2/ds2ds3 d3/ds1ds2ds3
   Scale factor indices: 1 2 3 4 5 6 7 8
  2. #Values=8
   Value labels: value d/ds1 d/ds2 d2/ds1ds2 d/ds3 d2/ds1ds3 d2/ds2ds3 d3/ds1ds2ds3
   Scale factor indices: 9 10 11 12 13 14 15 16
  3. #Values=8
   Value labels: value d/ds1 d/ds2 d2/ds1ds2 d/ds3 d2/ds1ds3 d2/ds2ds3 d3/ds1ds2ds3
   Scale factor indices: 17 18 19 20 21 22 23 24
  4. #Values=8
   Value labels: value d/ds1 d/ds2 d2/ds1ds2 d/ds3 d2/ds1ds3 d2/ds2ds3 d3/ds1ds2ds3
   Scale factor indices: 25 26 27 28 29 30 31 32
  5. #Values=8
   Value labels: value d/ds1 d/ds2 d2/ds1ds2 d/ds3 d2/ds1ds3 d2/ds2ds3 d3/ds1ds2ds3
   Scale factor indices: 33 34 35 36 37 38 39 40
  6. #Values=8
   Value labels: value d/ds1 d/ds2 d2/ds1ds2 d/ds3 d2/ds1ds3 d2/ds2ds3 d3/ds1ds2ds3
   Scale factor indices: 41 42 43 44 45 46 47 48
  7. #Values=8
   Value labels: value d/ds1 d/ds2 d2/ds1ds2 d/ds3 d2/ds1ds3 d2/ds2ds3 d3/ds1ds2ds3
   Scale factor indices: 49 50 51 52 53 54 55 56
  8. #Values=8
   Value labels: value d/ds1 d/ds2 d2/ds1ds2 d/ds3 d2/ds1ds3 d2/ds2ds3 d3/ds1ds2ds3
   Scale factor indices: 57 58 59 60 61 62 63 64
 y. c.Hermite*c.Hermite*c.Hermite, no modify, standard node based. scale factor set=scaling1
  #Nodes=8
  1. #Values=8
   Value labels: value d/ds1 d/ds2 d2/ds1ds2 d/ds3 d2/ds1ds3 d2/ds2ds3 d3/ds1ds2ds3
   Scale factor indices: 1 2 3 4 5 6 7 8
  2. #Values=8
   Value labels: value d/ds1 d/ds2 d2/ds1ds2 d/ds3 d2/ds1ds3 d2/ds2ds3 d3/ds1ds2ds3
   Scale factor indices: 9 10 11 12 13 14 15 16
  3. #Values=8
   Value labels: value d/ds1 d/ds2 d2/ds1ds2 d/ds3 d2/ds1ds3 d2/ds2ds3 d3/ds1ds2ds3
   Scale factor indices: 17 18 19 20 21 22 23 24
  4. #Values=8
   Value labels: value d/ds1 d/ds2 d2/ds1ds2 d/ds3 d2/ds1ds3 d2/ds2ds3 d3/ds1ds2ds3
   Scale factor indices: 25 26 27 28 29 30 31 32
  5. #Values=8
   Value labels: value d/ds1 d/ds2 d2/ds1ds2 d/ds3 d2/ds1ds3 d2/ds2ds3 d3/ds1ds2ds3
   Scale factor indices: 33 34 35 36 37 38 39 40
  6. #Values=8
   Value labels: value d/ds1 d/ds2 d2/ds1ds2 d/ds3 d2/ds1ds3 d2/ds2ds3 d3/ds1ds2ds3
   Scale factor indices: 41 42 43 44 45 46 47 48
  7. #Values=8
   Value labels: value d/ds1 d/ds2 d2/ds1ds2 d/ds3 d2/ds1ds3 d2/ds2ds3 d3/ds1ds2ds3
   Scale factor indices: 49 50 51 52 53 54 55 56
  8. #Values=8
   Value labels: value d/ds1 d/ds2 d2/ds1ds2 d/ds3 d2/ds1ds3 d2/ds2ds3 d3/ds1ds2ds3
   Scale factor indices: 57 58 59 60 61 62 63 64
 z. c.Hermite*c.Hermite*c.Hermite, no modify, standard node based. scale factor set=scaling1
  #Nodes=8
  1. #Values=8
   Value labels: value d/ds1 d/ds2 d2/ds1ds2 d/ds3 d2/ds1ds3 d2/ds2ds3 d3/ds1ds2ds3
   Scale factor indices: 1 2 3 4 5 6 7 8
  2. #Values=8
   Value labels: value d/ds1 d/ds2 d2/ds1ds2 d/ds3 d2/ds1ds3 d2/ds2ds3 d3/ds1ds2ds3
   Scale factor indices: 9 10 11 12 13 14 15 16
  3. #Values=8
   Value labels: value d/ds1 d/ds2 d2/ds1ds2 d/ds3 d2/ds1ds3 d2/ds2ds3 d3/ds1ds2ds3
   Scale factor indices: 17 18 19 20 21 22 23 24
  4. #Values=8
   Value labels: value d/ds1 d/ds2 d2/ds1ds2 d/ds3 d2/ds1ds3 d2/ds2ds3 d3/ds1ds2ds3
   Scale factor indices: 25 26 27 28 29 30 31 32
  5. #Values=8
   Value labels: value d/ds1 d/ds2 d2/ds1ds2 d/ds3 d2/ds1ds3 d2/ds2ds3 d3/ds1ds2ds3
   Scale factor indices: 33 34 35 36 37 38 39 40
  6. #Values=8
   Value labels: value d/ds1 d/ds2 d2/ds1ds2 d/ds3 d2/ds1ds3 d2/ds2ds3 d3/ds1ds2ds3
   Scale factor indices: 41 42 43 44 45 46 47 48
  7. #Values=8
   Value labels: value d/ds1 d/ds2 d2/ds1ds2 d/ds3 d2/ds1ds3 d2/ds2ds3 d3/ds1ds2ds3
   Scale factor indices: 49 50 51 52 53 54 55 56
  8. #Values=8
   Value labels: value d/ds1 d/ds2 d2/ds1ds2 d/ds3 d2/ds1ds3 d2/ds2ds3 d3/ds1ds2ds3
   Scale factor indices: 57 58 59 60 61 62 63 64
2) fibres, anatomical, fibre, real, #Components=3
 fibre angle. l.Lagrange*l.Lagrange*l.Lagrange, no modify, standard node based. scale factor set=scaling2
  #Nodes=8
  1. #Values=1
   Value labels: value(2)
   Scale factor indices: 65
  2. #Values=1
   Value labels: value(2)
   Scale factor indices: 66
  3. #Values=1
   Value labels: value(2)
   Scale factor indices: 67
  4. #Values=1
   Value labels: value(2)
   Scale factor indices: 68
  5. #Values=1
   Value labels: value
   Scale factor indices: 69
  6. #Values=1
   Value labels: value
   Scale factor indices: 70
  7. #Values=1
   Value labels: value
   Scale factor indices: 71
  8. #Values=1
   Value labels: value
   Scale factor indices: 72
 imbrication angle. l.Lagrange*l.Lagrange*l.Lagrange, no modify, standard node based. scale factor set=scaling3
  #Nodes=8
  1. #Values=1
   Value labels: value
   Scale factor indices: 73
  2. #Values=1
   Value labels: value
   Scale factor indices: 74
  3. #Values=1
   Value labels: value
   Scale factor indices: 75
  4. #Values=1
   Value labels: value
   Scale factor indices: 76
  5. #Values=1
   Value labels: value
   Scale factor indices: 77
  6. #Values=1
   Value labels: value
   Scale factor indices: 78
  7. #Values=1
   Value labels: value
   Scale factor indices: 79
  8. #Values=1
   Value labels: value
   Scale factor indices: 80
 sheet angle. l.Lagrange*l.Lagrange*l.Lagrange, no modify, standard node based. scale factor set=scaling3
  #Nodes=8
  1. #Values=1
   Value labels: value
   Scale factor indices: 73
  2. #Values=1
   Value labels: value
   Scale factor indices: 74
  3. #Values=1
   Value labels: value
   Scale factor indices: 75
  4. #Values=1
   Value labels: value
   Scale factor indices: 76
  5. #Values=1
   Value labels: value
   Scale factor indices: 77
  6. #Values=1
   Value labels: value
   Scale factor indices: 78
  7. #Values=1
   Value labels: value
   Scale factor indices: 79
  8. #Values=1
   Value labels: value
   Scale factor indices: 80
Element: 89
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 104 112 97 105 200 208 193 201
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
Element: 90
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 97 105 98 106 193 201 194 202
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
Element: 91
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 98 106 99 107 194 202 195 203
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
Element: 92
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 99 107 100 108 195 203 196 204
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
Element: 93
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 100 108 101 109 196 204 197 205
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
Element: 94
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 101 109 102 110 197 205 198 206
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
Element: 95
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 102 110 103 111 198 206 199 207
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
Element: 96
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 103 111 104 112 199 207 200 208
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
Element: 97
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 112 120 105 113 208 216 201 209
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
Element: 98
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 105 113 106 114 201 209 202 210
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
Element: 99
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 106 114 107 115 202 210 203 211
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
Element: 100
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 107 115 108 116 203 211 204 212
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
Element: 101
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 108 116 109 117 204 212 205 213
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
Element: 102
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 109 117 110 118 205 213 206 214
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
Element: 103
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 110 118 111 119 206 214 207 215
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
Element: 104
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 111 119 112 120 207 215 208 216
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
Element: 105
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 120 128 113 121 216 224 209 217
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
Element: 106
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 113 121 114 122 209 217 210 218
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
Element: 107
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 114 122 115 123 210 218 211 219
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
Element: 108
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 115 123 116 124 211 219 212 220
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
Element: 109
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 116 124 117 125 212 220 213 221
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
Element: 110
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 117 125 118 126 213 221 214 222
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
Element: 111
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 118 126 119 127 214 222 215 223
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
Element: 112
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 119 127 120 128 215 223 216 224
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
Element: 113
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 128 136 121 129 224 232 217 225
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
Element: 114
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 121 129 122 130 217 225 218 226
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
Element: 115
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 122 130 123 131 218 226 219 227
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
Element: 116
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 123 131 124 132 219 227 220 228
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
Element: 117
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 124 132 125 133 220 228 221 229
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
Element: 118
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 125 133 126 134 221 229 222 230
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
Element: 119
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 126 134 127 135 222 230 223 231
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
Element: 120
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 127 135 128 136 223 231 224 232
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
Element: 121
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 136 144 129 137 232 240 225 233
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
Element: 122
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 129 137 130 138 225 233 226 234
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
Element: 123
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 130 138 131 139 226 234 227 235
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
Element: 124
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 131 139 132 140 227 235 228 236
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
Element: 125
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 132 140 133 141 228 236 229 237
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
Element: 126
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 133 141 134 142 229 237 230 238
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
Element: 127
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 134 142 135 143 230 238 231 239
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
Element: 128
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 135 143 136 144 231 239 232 240
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
Element: 129
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 144 152 137 145 240 248 233 241
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
Element: 130
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 137 145 138 146 233 241 234 242
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
Element: 131
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 138 146 139 147 234 242 235 243
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
Element: 132
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 139 147 140 148 235 243 236 244
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
Element: 133
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 140 148 141 149 236 244 237 245
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
Element: 134
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 141 149 142 150 237 245 238 246
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
Element: 135
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 142 150 143 151 238 246 239 247
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
Element: 136
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 143 151 144 152 239 247 240 248
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
Element: 137
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 152 160 145 153 248 256 241 249
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
Element: 138
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 145 153 146 154 241 249 242 250
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
Element: 139
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 146 154 147 155 242 250 243 251
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
Element: 140
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 147 155 148 156 243 251 244 252
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
Element: 141
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 148 156 149 157 244 252 245 253
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
Element: 142
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 149 157 150 158 245 253 246 254
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
Element: 143
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 150 158 151 159 246 254 247 255
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
Element: 144
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 151 159 152 160 247 255 248 256
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
Element: 145
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 160 168 153 161 256 264 249 257
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
Element: 146
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 153 161 154 162 249 257 250 258
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
Element: 147
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 154 162 155 163 250 258 251 259
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
Element: 148
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 155 163 156 164 251 259 252 260
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
Element: 149
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 156 164 157 165 252 260 253 261
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
Element: 150
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 157 165 158 166 253 261 254 262
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
Element: 151
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 158 166 159 167 254 262 255 263
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
Element: 152
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 159 167 160 168 255 263 256 264
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
Element: 153
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 168 176 161 169 264 272 257 265
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
Element: 154
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 161 169 162 170 257 265 258 266
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
Element: 155
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 162 170 163 171 258 266 259 267
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
Element: 156
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 163 171 164 172 259 267 260 268
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
Element: 157
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 164 172 165 173 260 268 261 269
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
Element: 158
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 165 173 166 174 261 269 262 270
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
Element: 159
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 166 174 167 175 262 270 263 271
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
Element: 160
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 167 175 168 176 263 271 264 272
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
Element: 161
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 176 184 169 177 272 280 265 273
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
Element: 162
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 169 177 170 178 265 273 266 274
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
Element: 163
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 170 178 171 179 266 274 267 275
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
Element: 164
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 171 179 172 180 267 275 268 276
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
Element: 165
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 172 180 173 181 268 276 269 277
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
Element: 166
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 173 181 174 182 269 277 270 278
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
Element: 167
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 174 182 175 183 270 278 271 279
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
Element: 168
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 175 183 176 184 271 279 272 280
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
Element: 169
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 184 192 177 185 280 288 273 281
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
Element: 170
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 177 185 178 186 273 281 274 282
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
Element: 171
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 178 186 179 187 274 282 275 283
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
Element: 172
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 179 187 180 188 275 283 276 284
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
Element: 173
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 180 188 181 189 276 284 277 285
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
Element: 174
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 181 189 182 190 277 285 278 286
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
Element: 175
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 182 190 183 191 278 286 279 287
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
Element: 176
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 183 191 184 192 279 287 280 288
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
Element: 177
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 200 208 193 201 296 304 289 297
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
Element: 178
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 193 201 194 202 289 297 290 298
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
Element: 179
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 194 202 195 203 290 298 291 299
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
Element: 180
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 195 203 196 204 291 299 292 300
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
Element: 181
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 196 204 197 205 292 300 293 301
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
Element: 182
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 197 205 198 206 293 301 294 302
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
Element: 183
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 198 206 199 207 294 302 295 303
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
Element: 184
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 199 207 200 208 295 303 296 304
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
Element: 185
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 208 216 201 209 304 312 297 305
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
Element: 186
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 201 209 202 210 297 305 298 306
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
Element: 187
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 202 210 203 211 298 306 299 307
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
Element: 188
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 203 211 204 212 299 307 300 308
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
Element: 189
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 204 212 205 213 300 308 301 309
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
Element: 190
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 205 213 206 214 301 309 302 310
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
Element: 191
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 206 214 207 215 302 310 303 311
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
Element: 192
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 207 215 208 216 303 311 304 312
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
Element: 193
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 216 224 209 217 312 320 305 313
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
Element: 194
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 209 217 210 218 305 313 306 314
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
Element: 195
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 210 218 211 219 306 314 307 315
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
Element: 196
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 211 219 212 220 307 315 308 316
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
Element: 197
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 212 220 213 221 308 316 309 317
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
Element: 198
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 213 221 214 222 309 317 310 318
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
Element: 199
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 214 222 215 223 310 318 311 319
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
Element: 200
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 215 223 216 224 311 319 312 320
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
Element: 201
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 224 232 217 225 320 328 313 321
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
Element: 202
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 217 225 218 226 313 321 314 322
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
Element: 203
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 218 226 219 227 314 322 315 323
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
Element: 204
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 219 227 220 228 315 323 316 324
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
Element: 205
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 220 228 221 229 316 324 317 325
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
Element: 206
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 221 229 222 230 317 325 318 326
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
Element: 207
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 222 230 223 231 318 326 319 327
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
Element: 208
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 223 231 224 232 319 327 320 328
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
Element: 209
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 232 240 225 233 328 336 321 329
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
Element: 210
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 225 233 226 234 321 329 322 330
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
Element: 211
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 226 234 227 235 322 330 323 331
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
Element: 212
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 227 235 228 236 323 331 324 332
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
Element: 213
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 228 236 229 237 324 332 325 333
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
Element: 214
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 229 237 230 238 325 333 326 334
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
Element: 215
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 230 238 231 239 326 334 327 335
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
Element: 216
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 231 239 232 240 327 335 328 336
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
Element: 217
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 240 248 233 241 336 344 329 337
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
Element: 218
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 233 241 234 242 329 337 330 338
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
Element: 219
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 234 242 235 243 330 338 331 339
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
Element: 220
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 235 243 236 244 331 339 332 340
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
Element: 221
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 236 244 237 245 332 340 333 341
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
Element: 222
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 237 245 238 246 333 341 334 342
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
Element: 223
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 238 246 239 247 334 342 335 343
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
Element: 224
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 239 247 240 248 335 343 336 344
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
Element: 225
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 248 256 241 249 344 352 337 345
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
Element: 226
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 241 249 242 250 337 345 338 346
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
Element: 227
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 242 250 243 251 338 346 339 347
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
Element: 228
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 243 251 244 252 339 347 340 348
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
Element: 229
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 244 252 245 253 340 348 341 349
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
Element: 230
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 245 253 246 254 341 349 342 350
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
Element: 231
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 246 254 247 255 342 350 343 351
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
Element: 232
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 247 255 248 256 343 351 344 352
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
Element: 233
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 256 264 249 257 352 360 345 353
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
Element: 234
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 249 257 250 258 345 353 346 354
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
Element: 235
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 250 258 251 259 346 354 347 355
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
Element: 236
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 251 259 252 260 347 355 348 356
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
Element: 237
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 252 260 253 261 348 356 349 357
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
Element: 238
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 253 261 254 262 349 357 350 358
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
Element: 239
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 254 262 255 263 350 358 351 359
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
Element: 240
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 255 263 256 264 351 359 352 360
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
Element: 241
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 264 272 257 265 360 368 353 361
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
Element: 242
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 257 265 258 266 353 361 354 362
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
Element: 243
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 258 266 259 267 354 362 355 363
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
Element: 244
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 259 267 260 268 355 363 356 364
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
Element: 245
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 260 268 261 269 356 364 357 365
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
Element: 246
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 261 269 262 270 357 365 358 366
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
Element: 247
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 262 270 263 271 358 366 359 367
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
Element: 248
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 263 271 264 272 359 367 360 368
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
Element: 249
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 272 280 265 273 368 376 361 369
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
Element: 250
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 265 273 266 274 361 369 362 370
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
Element: 251
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 266 274 267 275 362 370 363 371
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
Element: 252
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 267 275 268 276 363 371 364 372
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
Element: 253
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 268 276 269 277 364 372 365 373
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
Element: 254
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 269 277 270 278 365 373 366 374
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
Element: 255
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 270 278 271 279 366 374 367 375
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
Element: 256
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 271 279 272 280 367 375 368 376
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
Element: 257
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 280 288 273 281 376 384 369 377
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
Element: 258
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 273 281 274 282 369 377 370 378
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
Element: 259
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 274 282 275 283 370 378 371 379
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
Element: 260
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 275 283 276 284 371 379 372 380
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
Element: 261
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 276 284 277 285 372 380 373 381
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
Element: 262
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 277 285 278 286 373 381 374 382
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
Element: 263
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 278 286 279 287 374 382 375 383
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
Element: 264
 Faces:
 -1 -1 -1 -1 -1 -1
 Nodes:
 279 287 280 288 375 383 376 384
 Scale factors:
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0  1.0  1.0
  1.0
  1.0  1.0  1.0  1.0  1.0
  1.0  1.0
  1.0  1.0  1.0
  1.0  1.0  1.0  1.0  1.0
    '''


    def __init__(self,):
        '''
        Ex2 file containing node, element and field information
        '''
        
        self.circumferentialElements = 8
        self.axialElements = 11
        self.wallElements = 3        
        self.ctx = Context('HostMesh')
        region = self.ctx.getDefaultRegion()
        sir  = region.createStreaminformationRegion()
        sir.createStreamresourceMemoryBuffer(str(self.hostMesh)) 
        region.read(sir)
        self.region = region
        fieldModule = self.region.getFieldmodule()
        #Get the elements
        mesh = fieldModule.findMeshByDimension(3)
        ei   = mesh.createElementiterator()
        elemDict = dict()
        elem = ei.next()
        while elem.isValid():
            elemDict[int(elem.getIdentifier())] = elem
            elem = ei.next()
        self.elements = elemDict
    
    def generateTube(self,region,circumferentialElements,axialElements,wallElements,wallThickness=1):
        fieldModule = region.getFieldmodule()
        fieldModule.beginChange()
        coordinates = findOrCreateFieldCoordinates(fieldModule)
        fibres = findOrCreateFieldFibres(fieldModule)

        nodeset = fieldModule.findNodesetByFieldDomainType(Field.DOMAIN_TYPE_NODES)
        nodetemplate = nodeset.createNodetemplate()
        nodetemplate.defineField(coordinates)
        nodetemplate.defineField(fibres)
        for field in [coordinates]:
            nodetemplate.setValueNumberOfVersions(field, -1, Node.VALUE_LABEL_VALUE, 1)
            nodetemplate.setValueNumberOfVersions(field, -1, Node.VALUE_LABEL_D_DS1, 1)
            nodetemplate.setValueNumberOfVersions(field, -1, Node.VALUE_LABEL_D_DS2, 1)
            nodetemplate.setValueNumberOfVersions(field, -1, Node.VALUE_LABEL_D_DS3, 1)
            
        mesh = fieldModule.findMeshByDimension(3)
        tricubichermite = eftfactory_tricubichermite(mesh, False)
        eft = tricubichermite.createEftBasic()
            
        elementtemplate = mesh.createElementtemplate()
        elementtemplate.setElementShapeType(Element.SHAPE_TYPE_CUBE)
        elementtemplate.defineField(coordinates, -1, eft)
        elementtemplate.defineField(fibres, -1, eft)
        fieldCache = fieldModule.createFieldcache()
        nodes = dict()
        # create nodes
        radiansPerElementAround = 2.0*np.pi/circumferentialElements
        wallThicknessPerElement = wallThickness/wallElements
        x = [ 0.0, 0.0, 0.0 ]
        dx_ds1 = [ 0.0, 0.0, 0.0 ]
        dx_ds2 = [ 0.0, 0.0, 1.0 / axialElements ]
        dx_ds3 = [ 0.0, 0.0, 0.0 ]
        numberOfWallNodes = wallElements + 1
        numberOfCircumfrentialNodes = circumferentialElements
        numberOfLengthNodes = axialElements + 1        
        for wallNodeIdx in range(1,numberOfWallNodes+1):
            radius = 0.5 + wallThickness*((wallNodeIdx-1)/(numberOfWallNodes - 1.0))
            for lengthNodeIdx in range(1,numberOfLengthNodes+1):
                x[2] = float(lengthNodeIdx-1)/ axialElements
                for circumfrentialNodeIdx in range(1,numberOfCircumfrentialNodes+1):
                    nodeNumber = circumfrentialNodeIdx + (lengthNodeIdx-1)*numberOfCircumfrentialNodes + (wallNodeIdx-1)*numberOfCircumfrentialNodes*numberOfLengthNodes 
                    radiansAround = circumfrentialNodeIdx*radiansPerElementAround
                    cosRadiansAround = np.cos(radiansAround)
                    sinRadiansAround = np.sin(radiansAround)
                    x[0] = radius*cosRadiansAround
                    x[1] = radius*sinRadiansAround
                    dx_ds1[0] = radiansPerElementAround*radius*-sinRadiansAround
                    dx_ds1[1] = radiansPerElementAround*radius*cosRadiansAround
                    dx_ds3[0] = wallThicknessPerElement*cosRadiansAround
                    dx_ds3[1] = wallThicknessPerElement*sinRadiansAround
                    node = nodeset.createNode(nodeNumber, nodetemplate)
                    nodes[nodeNumber] = node
                    fieldCache.setNode(node)
                    for coord in [coordinates]:
                        coord.setNodeParameters(fieldCache, -1, Node.VALUE_LABEL_VALUE, 1, x)
                        coord.setNodeParameters(fieldCache, -1, Node.VALUE_LABEL_D_DS1, 1, dx_ds1)
                        coord.setNodeParameters(fieldCache, -1, Node.VALUE_LABEL_D_DS2, 1, dx_ds2)
                        coord.setNodeParameters(fieldCache, -1, Node.VALUE_LABEL_D_DS3, 1, dx_ds3)
        # create elements
        elementNumber = 0
        elems = dict()
        for wallElementIdx in range(1,wallElements+1):
            for lengthElementIdx in range(1,axialElements+1):
                for circumfrentialElementIdx in range(1,circumferentialElements+1):
                    elementNumber = elementNumber + 1
                    localNode1 = circumfrentialElementIdx + (lengthElementIdx - 1)*circumferentialElements + \
                        (wallElementIdx-1)*numberOfCircumfrentialNodes*numberOfLengthNodes
                    if circumfrentialElementIdx == circumferentialElements:
                        localNode2 = 1 + (lengthElementIdx-1)*numberOfCircumfrentialNodes + \
                            (wallElementIdx-1)*numberOfCircumfrentialNodes*numberOfLengthNodes
                    else: 
                        localNode2 = localNode1 + 1
                    localNode3 = localNode1 + numberOfCircumfrentialNodes
                    localNode4 = localNode2 + numberOfCircumfrentialNodes
                    localNode5 = localNode1 + numberOfCircumfrentialNodes*numberOfLengthNodes
                    localNode6 = localNode2 + numberOfCircumfrentialNodes*numberOfLengthNodes
                    localNode7 = localNode3 + numberOfCircumfrentialNodes*numberOfLengthNodes
                    localNode8 = localNode4 + numberOfCircumfrentialNodes*numberOfLengthNodes
                    localNodes = [localNode1,localNode2,localNode3,localNode4,localNode5,localNode6,localNode7,localNode8]
                    element = mesh.createElement(elementNumber, elementtemplate)
                    element.setNodesByIdentifier(eft, localNodes)
                    elems[elementNumber] = element
        fieldModule.defineAllFaces()
        fieldModule.endChange()                
    
        return nodes,elems

    def normalizeByCircumferentialLengths(self,nvals,fieldName,circumferentialElements,axialElements,wallElements):
        '''
        Calculate the length of each circumferential cross-section, determine the mean segment length
        for even distribution of element segments and determine the appropriate coordinate values 
        for the nodes
        nvals - dictionary of nodeNumber (starts at 1) and fieldvalues
        fieldName - coordinate field's name 
        '''
        npts = 200
        ilengths = np.zeros(npts-1)
        def arcLength(x, y, z):
            arc = np.sqrt((x[1] - x[0])**2 + (y[1] - y[0])**2 + (z[1] - z[0])**2)
            ilengths[0] = arc
            for k in range(2, npts):
                ilengths[k-1] = np.sqrt((x[k] - x[k-1])**2 + (y[k] - y[k-1])**2 + (z[k] - z[k-1])**2)
                arc = arc + ilengths[k-1]
            return arc,ilengths                
        
        numLengthNodes = axialElements + 1
        numCircumferentialNodes = circumferentialElements
        coordinates = np.zeros((numCircumferentialNodes,3))
        for b in range(wallElements+1):
            woff = b*(numLengthNodes*numCircumferentialNodes)
            for a in range(numLengthNodes):
                axoff = a*numCircumferentialNodes + woff
                #Find the coordinates of a cross-section nodes number go from start-start+numCircumferentialNodes
                for nd in range(numCircumferentialNodes):
                    nid = nd + axoff
                    coordinates[nd] = nvals[nid + 1][fieldName]
                #Create a interpolator
                tck, u = splprep(coordinates.T, u=None, s=0.0, per=1)
                #Sample it finely to determine spine and its length
                u_new = np.linspace(u.min(), u.max(), npts)
                xs, ys, zs = splev(u_new, tck, der=0)
                cLengths,ilengths = arcLength(xs,ys,zs)
                #Find mean segment length
                segmentLength = cLengths/circumferentialElements
                #Find equi distant segments based on length 
                uvalues = [0]  
                cSegLength = ilengths[0]
                for st in range(1,npts-1):
                    cSegLength += ilengths[st]
                    if cSegLength >= segmentLength:
                        cSegLength = 0.0
                        uvalues.append(st)
                uvalues.append(uvalues[0])
                #Parameter u goes from 0-1, so normalize
                uvalues = np.array(uvalues)/(npts-1)
                #Determine the new coordinate values and update
                xs, ys, zs = splev(uvalues, tck, der=0)
                for nd in range(numCircumferentialNodes):
                    nid = nd + axoff
                    nvals[nid + 1][fieldName] = [xs[nd],ys[nd],zs[nd]]
            
        return nvals     
    
    def getInitialValues(self,fieldNames,circumferentialElements,axialElements,wallElements,refineAtLength,refineAtTheta):
        '''
        Determine initial values of fields in fieldNames from source mesh
        based on material coordinates of target mesh nodes
        fieldNames is a dictionary with fieldName,numberOfComponents {'coordinates':3,'label',:1}
        '''
        numberOfCircumfrentialNodes = circumferentialElements
        numberOfLengthNodes = axialElements + 1
        # create node element map
        ev = 0
        nodes = dict()
        linterval = axialElements-len(refineAtLength)
        if linterval > 8:
            lengthElementLocations = np.linspace(0.0, 0.99999, linterval+1)
        elif linterval < 4:
            raise ValueError('At least four elements are required along the axis')
        else:
            eloc= np.linspace(0.0, 1.0, 11)
            le = np.linspace(eloc[1], eloc[-2], linterval-1)
            le1 = [0.0]
            le1.extend(le.tolist())
            le1.append(0.9999)
            lengthElementLocations = np.array(le1)
        cinterval = circumferentialElements-len(refineAtTheta)
        circumferentialElementLocations = np.linspace(0.0, 0.99999, cinterval+1)
        
        ctr = 0
        for elem,xi in refineAtTheta.items():
            nxi = xi/float(cinterval)+circumferentialElementLocations[elem-1]
            circumferentialElementLocations = np.insert(circumferentialElementLocations,elem+ctr,nxi)
            ctr +=1
        ctr = 0
        for elem,xi in refineAtLength.items():
            nxi = xi/float(linterval)+lengthElementLocations[elem-1]
            lengthElementLocations = np.insert(lengthElementLocations,elem+ctr,nxi)
            ctr +=1            
            
        wallElementLocations   = np.linspace(0.0, 0.99999, wallElements+1)
        #Compute the material coordinates of nodes
        for wallElementIdx in range(1,wallElements+1):
            for lengthElementIdx in range(1,axialElements+1):
                for circumfrentialElementIdx in range(1,circumferentialElements+1):
                    #Element coord with respect to elements along each dim
                    
                    localNode1 = circumfrentialElementIdx + (lengthElementIdx - 1)*circumferentialElements + \
                        (wallElementIdx-1)*numberOfCircumfrentialNodes*numberOfLengthNodes
                    if circumfrentialElementIdx == circumferentialElements:
                        localNode2 = 1 + (lengthElementIdx-1)*numberOfCircumfrentialNodes + \
                            (wallElementIdx-1)*numberOfCircumfrentialNodes*numberOfLengthNodes                          
                    else: 
                        localNode2 = localNode1 + 1
                        
                    localNode3 = localNode1 + numberOfCircumfrentialNodes
                    localNode4 = localNode2 + numberOfCircumfrentialNodes
                    localNode5 = localNode1 + numberOfCircumfrentialNodes*numberOfLengthNodes
                    localNode6 = localNode2 + numberOfCircumfrentialNodes*numberOfLengthNodes
                    localNode7 = localNode3 + numberOfCircumfrentialNodes*numberOfLengthNodes
                    localNode8 = localNode4 + numberOfCircumfrentialNodes*numberOfLengthNodes

                    l1xi = [circumferentialElementLocations[circumfrentialElementIdx-1],lengthElementLocations[lengthElementIdx-1],wallElementLocations[wallElementIdx-1]]
                    l2xi = [circumferentialElementLocations[circumfrentialElementIdx],lengthElementLocations[lengthElementIdx-1],wallElementLocations[wallElementIdx-1]]
                    l3xi = [circumferentialElementLocations[circumfrentialElementIdx-1],lengthElementLocations[lengthElementIdx],wallElementLocations[wallElementIdx-1]]
                    l4xi = [circumferentialElementLocations[circumfrentialElementIdx],lengthElementLocations[lengthElementIdx],wallElementLocations[wallElementIdx-1]]
                    l5xi = [circumferentialElementLocations[circumfrentialElementIdx-1],lengthElementLocations[lengthElementIdx-1],wallElementLocations[wallElementIdx]]
                    l6xi = [circumferentialElementLocations[circumfrentialElementIdx],lengthElementLocations[lengthElementIdx-1],wallElementLocations[wallElementIdx]]
                    l7xi = [circumferentialElementLocations[circumfrentialElementIdx-1],lengthElementLocations[lengthElementIdx],wallElementLocations[wallElementIdx]]
                    l8xi = [circumferentialElementLocations[circumfrentialElementIdx],lengthElementLocations[lengthElementIdx],wallElementLocations[wallElementIdx]]
                    
                    ev +=1
                    nds = [localNode1,localNode2,localNode3,localNode4,localNode5,localNode6,localNode7,localNode8]
                    xis = [l1xi,l2xi,l3xi,l4xi,l5xi,l6xi,l7xi,l8xi]
                    for i,nd in enumerate(nds):
                        if not nd in nodes:
                            nodes[nd] = xis[i]

        
        fieldModule = self.region.getFieldmodule()
        #Coordinates is a cubic hermite Field 
        fieldHandles = dict()
        for field in fieldNames.keys():       
            hField = fieldModule.findFieldByName(field)
            fieldHandles[field]=hField

        fieldCache = fieldModule.createFieldcache()        
        for nd,val in nodes.items():
            xpos = int(val[0]*self.circumferentialElements)
            xi1  = val[0]*self.circumferentialElements - xpos    
            ypos = int(val[1]*self.axialElements)
            xi2  = val[1]*self.axialElements - ypos
            zpos = int(val[2]*self.wallElements)
            xi3  = val[2]*self.wallElements - zpos
            eid = xpos + ypos*self.circumferentialElements + zpos*(self.circumferentialElements*self.axialElements) + 1
            fv = dict()
            #xi1 and xi2 are inverted in kumar's mesh
            
            for fn,hfl in fieldHandles.items():
                fieldCache.setMeshLocation(self.elements[eid],[xi2,xi1,xi3])
                _,v = hfl.evaluateReal(fieldCache,fieldNames[fn])                
                fv[fn] = v  
            nodes[nd] = fv
        return nodes    
    
    def generateMesh(self,region,circumferentialElements,axialElements,wallElements,normalizeCircumferentialSegmentLengths,refineAtLength={},refineAtTheta={}):
        '''
        region - opencmiss zinc region where mesh needs to be created
        circumferentialElements - number of elements along the circumference
        axialElements - number of elements along the axis
        wallElements - number of elements along the wall
        normalizeCircumferentialSegmentLengths - If True, the circumferential segment lengths along a lattitute will be nearly equal
        refineAtLength - dict of axial length that need to be refined at an xi 
                        {1:0.25}, a new row of elements will be create by splitting the first row of elements at xi=0.25
        refineAtTheta - list of circumferential elements that need to be refined
                        {1:0.25}, a new column of elements will be create by splitting the first column of elements at xi=0.25
        '''
        totalCircumferentialElements= circumferentialElements+len(refineAtTheta)
        totalAxialElements = axialElements+len(refineAtLength)
        #Generate mesh even if the source is requested. This ensures that all generated meshes have the same derivative numbers
        
        nodes,_ = self.generateTube(region, totalCircumferentialElements, totalAxialElements, wallElements)
        nvals = self.getInitialValues({'coordinates':3,'fibres':3}, \
                                      totalCircumferentialElements, totalAxialElements, \
                                      wallElements,refineAtLength,refineAtTheta)
        if normalizeCircumferentialSegmentLengths:
            nvals = self.normalizeByCircumferentialLengths(nvals, 'coordinates', totalCircumferentialElements, totalAxialElements, wallElements) 
   
        fieldModule = region.getFieldmodule()
        fieldCache = fieldModule.createFieldcache()  
        coordinatesField = fieldModule.findFieldByName('coordinates').castFiniteElement()
        fibresField = fieldModule.findFieldByName('fibres').castFiniteElement()
        fieldModule.beginChange()
        for nd,node in nodes.items():
            fieldCache.setNode(node)
            coordinatesField.setNodeParameters(fieldCache, -1, Node.VALUE_LABEL_VALUE, 1, nvals[nd]['coordinates'])
            fibresField.setNodeParameters(fieldCache, -1, Node.VALUE_LABEL_VALUE, 1, nvals[nd]['fibres'])            
        smoothing = fieldModule.createFieldsmoothing()
        coordinatesField.smooth(smoothing)
        fibresField.smooth(smoothing)
        fieldModule.endChange()
            

class MeshType_3d_stomachhuman1(Scaffold_base):
    '''
    Human stomach mesh generator wrapper for ScaffoldMaker
    Uses data from fitted mesh, which can be refined globally or along lattitude and longitude
    '''
    hostStomach = Stomach()
    
    @staticmethod
    def getName():
        return '3D Stomach Human 1'

    @staticmethod
    def getDefaultOptions(parameterSetName='Default'):
        return {
            'Number of elements along the axis' : 11,
            'Number of elements through the wall' : 3,
            'Number of elements along the circumference' : 8,
            'Normalize Circumferential Segment Lengths': True,
        }

    @staticmethod
    def getOrderedOptionNames():
        return [
            'Number of elements along the circumference',
            'Normalize Circumferential Segment Lengths',
            'Number of elements along the axis',
            'Number of elements through the wall',
        ]

    @staticmethod
    def checkOptions(options):
        if (options['Number of elements along the circumference'] < 4) :
            options['Number of elements along the circumference'] = 4
        if (options['Number of elements through the wall'] < 3) :
            options['Number of elements through the wall'] = 3
        if (options['Number of elements along the axis'] < 6) :
            options['Number of elements along the axis'] = 6

    @classmethod
    def generateBaseMesh(cls, region, options):
        """
        :param region: Zinc region to define model in. Must be empty.
        :param options: Dict containing options. See getDefaultOptions().
        :return: [] empty list of AnnotationGroup
        """
        #print(options)
        axialElements = options['Number of elements along the axis']
        circumferentialElements = options['Number of elements along the circumference']
        wallElements= options['Number of elements through the wall']
        normalizeCircumferentialSegmentLengths = options['Normalize Circumferential Segment Lengths']
        
        cls.hostStomach.generateMesh(region, circumferentialElements,
            axialElements, wallElements, normalizeCircumferentialSegmentLengths,{}, {})
        return []
