# -*- coding: utf-8 -*-

import unittest

import intelmq.lib.test as test
from intelmq.bots.parsers.malwaredomainlist.parser import \
    MalwareDomainListParserBot

EXAMPLE_REPORT = {"feed.name": "Malware Domain List",
                  "feed.url": "http://www.malwaredomainlist.com/updatescsv.php",
                  "raw": "IjIwMTUvMDcvMTBfMTM6MzciLCJ3d3cuZXhhbXBsZS5uZXQvd3At"
                         "Y29udGVudC9wbHVnaW5zL2JhZC9wcm9ncmFtLmV4ZSIsIjE5Mi4w"
                         "LjIuMSIsImV4YW1wbGUuY29tLiIsIlRyb2phbi5FeGFtcGxlIiwi"
                         "UmVnaXN0cmFyIEFidXNlIENvbnRhY3QgZG9tYWluYWJ1c2VAZXhh"
                         "bXBsZS5jb20iLCIxIg==",
                  "__type": "Report",
                  "time.observation": "2015-01-01T00:00:00+00:00",
                  }
EXAMPLE_EVENT = {"feed.name": "Malware Domain List",
                 "feed.url": "http://www.malwaredomainlist.com/updatescsv.php",
                 "__type": "Event",
                 "time.source": "2015-07-10T13:37:00+00:00",
                 "source.url": "http://www.example.net/wp-content/plugins/"
                               "bad/program.exe",
                 "source.ip": "192.0.2.1",
                 "source.reverse_dns": "example.com",
                 'source.abuse_contact': 'domainabuse@example.com',
                 "event_description.text": "Trojan.Example",
                 "source.asn": 1,
                 "classification.type": "malware",
                 "raw": "MjAxNS8wNy8xMF8xMzozNyx3d3cuZXhhbXBsZS5uZXQvd3AtY29u"
                        "dGVudC9wbHVnaW5zL2JhZC9wcm9ncmFtLmV4ZSwxOTIuMC4yLjEs"
                        "ZXhhbXBsZS5jb20uLFRyb2phbi5FeGFtcGxlLFJlZ2lzdHJhciBB"
                        "YnVzZSBDb250YWN0IGRvbWFpbmFidXNlQGV4YW1wbGUuY29tLDEN"
                        "Cg==",
                 "time.observation": "2015-01-01T00:00:00+00:00",
                 }
EXAMPLE_REPORT2 = EXAMPLE_REPORT.copy()
EXAMPLE_REPORT2['raw'] = ("IjIwMTUvMTAvMjRfMDM6NTAiLCItIiwiMTU1LjEzMy4xOC4xMTc"
                          "vMzh5ZXMzLmV4ZSIsInB0ci0xNTUuMTMzLjE4LjExNy52bWxpbm"
                          "UucGwuIiwiVHJvamFuLkFuZHJvbWVkYSIsIi0iLCIxOTcyMjYi")
EXAMPLE_EVENT2 = EXAMPLE_EVENT.copy()
EXAMPLE_EVENT2['time.source'] = "2015-10-24T03:50:00+00:00"
EXAMPLE_EVENT2['source.url'] = "http://155.133.18.117/38yes3.exe"
EXAMPLE_EVENT2['source.asn'] = 197226
del EXAMPLE_EVENT2['source.ip']
del EXAMPLE_EVENT2['source.abuse_contact']
EXAMPLE_EVENT2['source.reverse_dns'] = "ptr-155.133.18.117.vmline.pl"
EXAMPLE_EVENT2['event_description.text'] = "Trojan.Andromeda"
EXAMPLE_EVENT2['raw'] = ('MjAxNS8xMC8yNF8wMzo1MCwtLDE1NS4xMzMuMTguMTE3LzM4eWVz'
                         'My5leGUscHRyLTE1NS4xMzMuMTguMTE3LnZtbGluZS5wbC4sVHJv'
                         'amFuLkFuZHJvbWVkYSwtLDE5NzIyNg0K')

REPORT_HACJEK = EXAMPLE_REPORT.copy()
REPORT_HACJEK['raw'] = "IjIwMTUvMTIvMjNfMTg6NTIiLCJ3d3cuYWdyaW1vbnQuY3ovIiwiOTUuMTY4LjIwNC4yMjUiLCJtYXNha3JhdG9yLnppa3VtLmN6LiIsImNvbXByb21pc2VkIHNpdGUgbGVhZHMgdG8gQW5nbGVyIEVLIiwiTGlib3IgS3LDoWwgLyBpbmZvQHppa3VtLmN6IiwiMzkzOTIi"  # noqa
EVENT_HACJEK = EXAMPLE_EVENT.copy()
EVENT_HACJEK['time.source'] = "2015-12-23T18:52:00+00:00"
EVENT_HACJEK['source.url'] = "http://www.agrimont.cz/"
EVENT_HACJEK['source.ip'] = "95.168.204.225"
EVENT_HACJEK['source.asn'] = 39392
EVENT_HACJEK['source.abuse_contact'] = 'info@zikum.cz'
EVENT_HACJEK['source.reverse_dns'] = "masakrator.zikum.cz"
EVENT_HACJEK['event_description.text'] = "compromised site leads to Angler EK"
EVENT_HACJEK['raw'] = "MjAxNS8xMi8yM18xODo1Mix3d3cuYWdyaW1vbnQuY3ovLDk1LjE2OC4yMDQuMjI1LG1hc2FrcmF0b3IuemlrdW0uY3ouLGNvbXByb21pc2VkIHNpdGUgbGVhZHMgdG8gQW5nbGVyIEVLLExpYm9yIEtyw6FsIC8gaW5mb0B6aWt1bS5jeiwzOTM5Mg0K"  # noqa


class TestMalwareDomainListParserBot(test.BotTestCase, unittest.TestCase):
    """
    A TestCase for a MalwareDomainListParserBot.
    """

    @classmethod
    def set_bot(cls):
        cls.bot_reference = MalwareDomainListParserBot
        cls.default_input_message = EXAMPLE_REPORT

    def test_event(self):
        """ Test if correct Event has been produced. """
        self.run_bot()
        self.assertMessageEqual(0, EXAMPLE_EVENT)

    def test_ip_url(self):
        """ Test if IP is not filled if not given. """
        self.input_message = EXAMPLE_REPORT2
        self.run_bot()
        self.assertMessageEqual(0, EXAMPLE_EVENT2)

    def test_ip_hacjek(self):
        """ Test if hacjek will be correctly handled. """
        self.input_message = REPORT_HACJEK
        self.run_bot()
        self.assertMessageEqual(0, EVENT_HACJEK)


if __name__ == '__main__':  # pragma: no cover
    unittest.main()
