#!/usr/bin/env python
import tkinter as tk

root = tk.Tk()
#~~~~~~~~~~~
# show
#~~~~~~~~~~~
bm_show = tk.Image("bitmap")
bm_show["data"] = """
    #define bm_show_width 6
    #define bm_show_height 6
    static char bm_show_bits[] = {
        0xff, 0xff, 0xff, 0xff, 0xff, 0xff
    };
"""
#~~~~~~~~~~~
# hide
#~~~~~~~~~~~
bm_hide = tk.Image("bitmap")
bm_hide["data"] = """
    #define bm_hide_width 6
    #define bm_hide_height 6
    static char bm_hide_bits[] = {
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00
    };
"""
#~~~~~~~~~~~
# zoom window
#~~~~~~~~~~~
bm_1 = tk.Image("bitmap")
bm_1["data"] = """
    #define bm_1_width 6
    #define bm_1_height 6
    static char bm_1_bits[] = {
        0x00, 0x15, 0x00, 0x15, 0x00, 0x15
    };
"""
#~~~~~~~~~~~
# zoom window
#~~~~~~~~~~~
bm_2 = tk.Image("bitmap")
bm_2["data"] = """
    #define bm_2_width 6
    #define bm_2_height 6
    static char bm_2_bits[] = {
        0x00, 0x12, 0x00, 0x00, 0x12, 0x00
    };
"""
#~~~~~~~~~~~
# move-right
#~~~~~~~~~~~
bm_R = tk.Image("bitmap")
bm_R["data"] = """
    #define bm_R_width 16
    #define bm_R_height 16
    static char bm_R_bits[] = {
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x00,
        0xc0, 0x01, 0x80, 0x07, 0x80, 0x1f, 0xfe, 0x7f,
        0xfe, 0x7f, 0x80, 0x1f, 0x80, 0x07, 0xc0, 0x01,
        0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
    };
"""
#~~~~~~~~~~~
# move-left
#~~~~~~~~~~~
bm_L = tk.Image("bitmap")
bm_L["data"] = """
    #define bm_L_width 16
    #define bm_L_height 16
    static char bm_L_bits[] = {
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06,
        0x80, 0x03, 0xe0, 0x01, 0xf8, 0x01, 0xfe, 0x7f,
        0xfe, 0x7f, 0xf8, 0x01, 0xe0, 0x01, 0x80, 0x03,
        0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
    };
"""
#~~~~~~~~~~~
# move-up
#~~~~~~~~~~~
bm_U = tk.Image("bitmap")
bm_U["data"] = """
    #define bm_U_width 16
    #define bm_U_height 16
    static char bm_U_bits[] = {
        0x00, 0x00, 0x80, 0x01, 0x80, 0x01, 0xc0, 0x03,
        0xc0, 0x03, 0xe0, 0x07, 0xe0, 0x07, 0xf0, 0x0f,
        0xf0, 0x0f, 0x98, 0x19, 0x88, 0x11, 0x80, 0x01,
        0x80, 0x01, 0x80, 0x01, 0x80, 0x01, 0x00, 0x00
    };
"""
#~~~~~~~~~~~
# move-down
#~~~~~~~~~~~
bm_D = tk.Image("bitmap")
bm_D["data"] = """
    #define bm_D_width 16
    #define bm_D_height 16
    static char bm_D_bits[] = {
        0x00, 0x00, 0x80, 0x01, 0x80, 0x01, 0x80, 0x01,
        0x80, 0x01, 0x88, 0x11, 0x98, 0x19, 0xf0, 0x0f,
        0xf0, 0x0f, 0xe0, 0x07, 0xe0, 0x07, 0xc0, 0x03,
        0xc0, 0x03, 0x80, 0x01, 0x80, 0x01, 0x00, 0x00
    };
"""
#~~~~~~~~~~~
# move-in
#~~~~~~~~~~~
bm_I = tk.Image("bitmap")
bm_I["data"] = """
    #define bm_I_width 16
    #define bm_I_height 16
    static char bm_I_bits[] = {
        0xaa, 0xaa, 0x55, 0x55, 0x02, 0x80, 0x01, 0x40,
        0xf2, 0x8f, 0xf1, 0x4f, 0x32, 0x8c, 0x31, 0x4c,
        0x32, 0x8c, 0x31, 0x4c, 0xf2, 0x8f, 0xf1, 0x4f,
        0x02, 0x80, 0x01, 0x40, 0xaa, 0xaa, 0x55, 0x55
    };
"""
#~~~~~~~~~~~
# move-out
#~~~~~~~~~~~
bm_O = tk.Image("bitmap")
bm_O["data"] = """
    #define bm_O_width 16
    #define bm_O_height 16
    static char bm_show_bits[] = {
        0xff, 0xff, 0xff, 0xff, 0x03, 0xc0, 0x03, 0xc0,
        0xa3, 0xca, 0x53, 0xc5, 0x23, 0xc8, 0x13, 0xc4,
        0x23, 0xc8, 0x13, 0xc4, 0xa3, 0xca, 0x53, 0xc5,
        0x03, 0xc0, 0x03, 0xc0, 0xff, 0xff, 0xff, 0xff
    };
"""
#~~~~~~~~~~~
# index forward
#~~~~~~~~~~~
bm_fwd = tk.Image("bitmap")
bm_fwd["data"] = """
    #define bm_fwd_width 16
    #define bm_fwd_height 16
    static char bm_fwd_bits[] = {
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00,
        0x60, 0x00, 0xc0, 0x00, 0x80, 0x03, 0x00, 0x07,
        0x00, 0x0e, 0x00, 0x07, 0x80, 0x03, 0xc0, 0x00,
        0x60, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00
    };
"""
#~~~~~~~~~~~
# index reverse
#~~~~~~~~~~~
bm_rev = tk.Image("bitmap")
bm_rev["data"] = """
    #define bm_rev_width 16
    #define bm_rev_height 16
    static char bm_rev_bits[] = {
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08,
        0x00, 0x06, 0x00, 0x03, 0xc0, 0x01, 0xe0, 0x00,
        0x70, 0x00, 0xe0, 0x00, 0xc0, 0x01, 0x00, 0x03,
        0x00, 0x06, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00
    };
"""
#~~~~~~~~~~~
# index beginning
#~~~~~~~~~~~
bm_beg = tk.Image("bitmap")
bm_beg["data"] = """
    #define bm_beg_width 16
    #define bm_beg_height 16
    static char bm_beg_bits[] = {
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x40,
        0x60, 0x30, 0x30, 0x18, 0x38, 0x0e, 0x1c, 0x07,
        0x8e, 0x03, 0x1c, 0x07, 0x38, 0x0e, 0x30, 0x18,
        0x60, 0x30, 0x80, 0x40, 0x00, 0x00, 0x00, 0x00
    };
"""
#~~~~~~~~~~~
# index end
#~~~~~~~~~~~
bm_end = tk.Image("bitmap")
bm_end["data"] = """
    #define bm_end_width 16
    #define bm_end_height 16
    static char bm_end_bits[] = {
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x01,
        0x0c, 0x06, 0x18, 0x0c, 0x70, 0x1c, 0xe0, 0x38,
        0xc0, 0x71, 0xe0, 0x38, 0x70, 0x1c, 0x18, 0x0c,
        0x0c, 0x06, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00
    };
"""
#~~~~~~~~~~~
# index mid
#~~~~~~~~~~~
bm_mid = tk.Image("bitmap")
bm_mid["data"] = """
    #define bm_mid_width 16
    #define bm_mid_height 16
    static char bm_mid_bits[] = {
        0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x80, 0x00,
        0x80, 0x00, 0xc0, 0x01, 0xc0, 0x01, 0xc0, 0x01,
        0xc0, 0x01, 0xc0, 0x01, 0xc0, 0x01, 0x80, 0x00,
        0x80, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00
    };
"""
#~~~~~~~~~~~
# zoom out
#~~~~~~~~~~~
bm_ao = tk.Image("bitmap")
bm_ao["data"] = """
    #define bm_ao_width 16
    #define bm_ao_height 16
    static char bm_ao_bits[] = {
        0x80, 0x01, 0xc0, 0x03, 0xe0, 0x07, 0x00, 0x00,
        0x00, 0x00, 0x04, 0x20, 0x06, 0x60, 0x07, 0xe0,
        0x07, 0xe0, 0x06, 0x60, 0x04, 0x20, 0x00, 0x00,
        0x00, 0x00, 0xe0, 0x07, 0xc0, 0x03, 0x80, 0x01
    };
"""
#~~~~~~~~~~~
# zoom in
#~~~~~~~~~~~
bm_ai = tk.Image("bitmap")
bm_ai["data"] = """
    #define bm_ai_width 16
    #define bm_ai_height 16
    static char bm_ai_bits[] = {
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 0x07,
        0xc0, 0x03, 0x88, 0x11, 0x18, 0x18, 0x38, 0x1c,
        0x38, 0x1c, 0x18, 0x18, 0x88, 0x11, 0xc0, 0x03,
        0xe0, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
    };
"""
#~~~~~~~~~~~
# zoom original
#~~~~~~~~~~~
bm_az = tk.Image("bitmap")
bm_az["data"] = """
    #define bm_az_width 16
    #define bm_az_height 16
    static char bm_az_bits[] = {
        0x00, 0x00, 0x00, 0x00, 0xfc, 0x3f, 0xfc, 0x3f,
        0x0c, 0x30, 0x0c, 0x30, 0x0c, 0x30, 0x0c, 0x30,
        0x0c, 0x30, 0x0c, 0x30, 0x0c, 0x30, 0x0c, 0x30,
        0xfc, 0x3f, 0xfc, 0x3f, 0x00, 0x00, 0x00, 0x00
    };
"""
#~~~~~~~~~~~
# x-out
#~~~~~~~~~~~
bm_xo = tk.Image("bitmap")
bm_xo["data"] = """
    #define bm_xo_width 16
    #define bm_xo_height 16
    static char bm_xo_bits[] = {
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x08,
        0x18, 0x18, 0x0c, 0x30, 0x0e, 0x70, 0xff, 0xff,
        0xff, 0xff, 0x0e, 0x70, 0x0c, 0x30, 0x18, 0x18,
        0x10, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
    };
"""
#~~~~~~~~~~~
# y-out
#~~~~~~~~~~~
bm_yo = tk.Image("bitmap")
bm_yo["data"] = """
    #define bm_yo_width 16
    #define bm_yo_height 16
    static char bm_yo_bits[] = {
        0x80, 0x01, 0xc0, 0x03, 0xe0, 0x07, 0xf0, 0x0f,
        0x98, 0x19, 0x80, 0x01, 0x80, 0x01, 0x80, 0x01,
        0x80, 0x01, 0x80, 0x01, 0x80, 0x01, 0x98, 0x19,
        0xf0, 0x0f, 0xe0, 0x07, 0xc0, 0x03, 0x80, 0x01
    };
"""
#~~~~~~~~~~~
# calculator PI
#~~~~~~~~~~~
bm_pi = tk.Image("bitmap")
bm_pi["data"] = """
    #define bm_pi_width 16
    #define bm_pi_height 16
    static char bm_pi_bits[] = {
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0xfe, 0x3f, 0x12, 0x04, 0x10, 0x04, 0x10, 0x04,
        0x10, 0x04, 0x10, 0x04, 0x10, 0x04, 0x10, 0x04,
        0x10, 0x04, 0x10, 0x04, 0x1c, 0x04, 0x00, 0x00
    };
"""
#~~~~~~~~~~~
# calculator SQRT
#~~~~~~~~~~~
bm_sqrt = tk.Image("bitmap")
bm_sqrt["data"] = """
    #define bm_sqrt_width 16
    #define bm_sqrt_height 16
    static char bm_sqrt_bits[] = {
        0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x00, 0x02,
        0x00, 0x02, 0x00, 0x03, 0x00, 0x01, 0x00, 0x01,
        0x87, 0x01, 0x8c, 0x00, 0x98, 0x00, 0xf0, 0x00,
        0x60, 0x00, 0x40, 0x00, 0x40, 0x00, 0x00, 0x00
    };
"""
bitmaps = [bm_show, bm_hide, bm_1, bm_2, bm_R, bm_L, bm_U, bm_D, bm_I, bm_O, bm_fwd, bm_rev, bm_beg, bm_end, bm_mid, bm_ao, bm_ai, bm_az, bm_xo, bm_yo, bm_pi, bm_sqrt]

for frame in range(5):
    f = tk.Frame(root)
    f.pack(side="left")
    for bm in bitmaps :
        b = tk.Button(f, image=bm)
        b.pack(side="top")

root.mainloop()
