# -*- coding: utf-8 -*-
#
# This tool helps you rebase your package to the latest version
# Copyright (C) 2013-2019 Red Hat, Inc.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
#
# Authors: Petr Hráček <phracek@redhat.com>
#          Tomáš Hozza <thozza@redhat.com>
#          Nikola Forró <nforro@redhat.com>
#          František Nečas <fifinecas@seznam.cz>

import logging
import os

import pkg_resources


try:
    from rebasehelper.logger import CustomLogger
except ModuleNotFoundError:
    # bootstrap
    pass
else:
    logging.setLoggerClass(CustomLogger)

# ensure that all messages are caught
logging.getLogger(__name__).setLevel(logging.DEBUG)

# make entry points accessible in case this package is not installed
parent_dir: str = os.path.dirname(os.path.dirname(__file__))
pkg_resources.working_set.add_entry(parent_dir)

# set current package version
VERSION: str = pkg_resources.get_distribution(__name__).version
