"""add account roles

Revision ID: 96f2db5bed30
Revises: e4c9cf837311
Create Date: 2021-08-30 11:33:40.481140

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = "96f2db5bed30"
down_revision = "e4c9cf837311"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "account_role",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("name", sa.String(length=80), nullable=True),
        sa.Column("description", sa.String(length=255), nullable=True),
        sa.PrimaryKeyConstraint("id", name=op.f("account_role_pkey")),
        sa.UniqueConstraint("name", name=op.f("account_role_name_key")),
    )
    op.create_table(
        "roles_accounts",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("account_id", sa.Integer(), nullable=True),
        sa.Column("role_id", sa.Integer(), nullable=True),
        sa.ForeignKeyConstraint(
            ["account_id"],
            ["account.id"],
            name=op.f("roles_accounts_account_id_account_fkey"),
        ),
        sa.ForeignKeyConstraint(
            ["role_id"],
            ["account_role.id"],
            name=op.f("roles_accounts_role_id_account_role_fkey"),
        ),
        sa.PrimaryKeyConstraint("id", name=op.f("roles_accounts_pkey")),
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table("roles_accounts")
    op.drop_table("account_role")
    # ### end Alembic commands ###
