# django-hub-sdk

![PyPI](https://img.shields.io/pypi/v/django-hub-sdk)
![PyPI - Python Version](https://img.shields.io/pypi/pyversions/django-hub-sdk)
[![Django Hub SDK](https://github.com/bildvitta/django-hub-sdk/actions/workflows/main.yml/badge.svg)](https://github.com/bildvitta/django-hub-sdk/actions/workflows/main.yml)

## What Is This?

The ISS (International Space Station) aims to be a space station (client) of connection between the microservices of its
ecosystem and the authentication and permissions microservice of the user that here is called in the script as
Hub.permissions modules / microservices (Hub)

## How To Use This

### Installation

```shell
pip install django-hub-sdk
```

or if you are using Pipenv or Poetry

```shell
pipenv install django-hub-sdk
```

```shell
poetry add django-hub-sdk
```

### Settings

Add the app to installed apps

```python
INSTALLED_APPS = [
    ...,
    "django_hub_sdk",
    ...,
]
```

All settings can be modified through environment variables, so if you are using `.env` please use it.

**Mandatory Settings**

```python
import os 

HUB_APP_SLUG = "" # project name on the hub

HUB_BASE_URI = os.environ.get("HUB_BASE_URI", "") # HUB backend url
HUB_BASE_FRONT_URI = os.environ.get(
    "HUB_BASE_FRONT_URI", "" # HUB frontend url
)

HUB_PROGRAMMATIC_CLIENT = os.environ.get("HUB_PROGRAMMATIC_CLIENT", "") # Programmatic user access public key
HUB_PROGRAMMATIC_SECRET = os.environ.get("HUB_PROGRAMMATIC_SECRET", "") # Programmatic user access private key

HUB_OAUTH_CLIENT_ID = os.environ.get("HUB_OAUTH_CLIENT_ID", "") # Public oauth access key
HUB_OAUTH_CLIENT_SECRET = os.environ.get("HUB_OAUTH_CLIENT_SECRET", "") # Private oauth access key
HUB_OAUTH_REDIRECT = os.environ.get("HUB_OAUTH_REDIRECT", "") # oauth access return URL
```

### User Model

To continue the installation, in your User model extend the class below to be able to create the necessary relationships with the HUB

```python
from django.contrib.auth.models import AbstractUser

from django_hub_sdk.models import BaseHubUser # <- Import BaseHubUser


# Create your models here.
class User(AbstractUser, BaseHubUser): # <- Extends this on model
    ...
```

### Urls

Add this line to your urls.py to work with the frontend SDK

```python
from django.urls import path, include

urlpatterns = [
    path("api/", include("django_hub_sdk.urls", namespace="django_hub_sdk"))
]
```

## Use of Authorization

Use of authorizations to use the JWT generated by the Hub

```python
from django_hub_sdk.authentication import HubJWTAuthentication # Import from package

from rest_framework import views

class LogoutView(views.APIView):
    authentication_classes = [HubJWTAuthentication] # <- Use on authentication_classes
```

