from math import inf
from dlubal.api import rstab

# Connect to the RSTAB application
with rstab.Application() as rstab_app:

    # Close all models opened in application without saving
    rstab_app.close_all_models(save_changes=False)

    # Create new model named 'silo' and get its ID.
    silo_id = rstab_app.create_model(name='silo')

    # Create new model named 'steel_hall' and get its ID.
    steel_hall_id = rstab_app.create_model(name='steel_hall')

    # Cleanup both models
    rstab_app.delete_all_objects(optional_model_id=silo_id)
    rstab_app.delete_all_objects(optional_model_id=steel_hall_id)

    # Create materials in silo
    lst = [
        rstab.structure_core.Material(
            no=1,
            name="S450 | EN 1993-1-1:2005-05"),
        rstab.structure_core.Material(
            no=2,
            name="Sand, well-graded (SW) | DIN 18196:2011-05"),
        rstab.structure_core.Material(
            no=3,
            name="Dry air | --"),
        rstab.structure_core.Material(
            no=4,
            name="S450 | EN 1993-1-1:2005-05"),
        rstab.structure_core.Material(
            no=5,
            name="S450 | EN 1993-1-1:2005-05"),
        rstab.structure_core.Material(
            no=6,
            name="S450 | EN 1993-1-1:2005-05"),
        rstab.structure_core.Material(
            no=7,
            name="S450 | EN 1993-1-1:2005-05"),
    ]
    rstab_app.create_object_list(
        lst,
        silo_id)

    # Update material 5 in silo
    rstab_app.update_object(
        rstab.structure_core.Material(
            no=5,
            comment='commented'),
            silo_id)

    # Update materials 1-4 in silo
    lst = [
        rstab.structure_core.Material(
            no=1,
            comment='updated'),
        rstab.structure_core.Material(
            no=2,
            comment='updated'),
        rstab.structure_core.Material(
            no=3,
            comment='updated'),
        rstab.structure_core.Material(
            no=4,
            comment='updated'),
    ]
    rstab_app.update_object_list(lst,
                                silo_id)

    # Create steel hall
    lst = [
        # Material
        rstab.structure_core.Material(
            no=1,
            name="S235 | EN 1993-1-1:2005-05"),

        # Sections
        rstab.structure_core.Section(
            no=1,
            material=1,
            name="HEB 220"),
        rstab.structure_core.Section(
            no=2,
            material=1,
            name="IPE 240"),
        rstab.structure_core.Section(
            no=3,
            material=1,
            name="IPE 100 | -- | British Steel"),
        rstab.structure_core.Section(
            no=4,
            material=1,
            name="L 20x20x3 | ČSN EN 10056-1:2003 | Ferona"),

        # Nodes
        rstab.structure_core.Node(
            no=1,
            coordinate_1=0.0,
            coordinate_2=0.0,
            coordinate_3=0.0),
        rstab.structure_core.Node(
            no=2,
            coordinate_1=0.0,
            coordinate_2=0.0,
            coordinate_3=-2.5),
        rstab.structure_core.Node(
            no=3,
            coordinate_1=0.0,
            coordinate_2=0.0,
            coordinate_3=-3.0),
        rstab.structure_core.Node(
            no=4,
            coordinate_1=6.0,
            coordinate_2=0.0,
            coordinate_3=-4.5),
        rstab.structure_core.Node(
            no=5,
            coordinate_1=12.0,
            coordinate_2=0.0,
            coordinate_3=-3.0),
        rstab.structure_core.Node(
            no=6,
            coordinate_1=12.0,
            coordinate_2=0.0,
            coordinate_3=-2.5),
        rstab.structure_core.Node(
            no=7,
            coordinate_1=12.0,
            coordinate_2=0.0,
            coordinate_3=0.0),
        rstab.structure_core.Node(
            no=8,
            coordinate_1=0.3,
            coordinate_2=0.0,
            coordinate_3=-2.5),
        rstab.structure_core.Node(
            no=9,
            coordinate_1=11.7,
            coordinate_2=0.0,
            coordinate_3=-2.5),
        rstab.structure_core.Node(
            no=10,
            coordinate_1=0.0,
            coordinate_2=5.0,
            coordinate_3=0.0),
        rstab.structure_core.Node(
            no=11,
            coordinate_1=0.0,
            coordinate_2=5.0,
            coordinate_3=-2.5),
        rstab.structure_core.Node(
            no=12,
            coordinate_1=0.0,
            coordinate_2=5.0,
            coordinate_3=-3.0),
        rstab.structure_core.Node(
            no=13,
            coordinate_1=6.0,
            coordinate_2=5.0,
            coordinate_3=-4.5),
        rstab.structure_core.Node(
            no=14,
            coordinate_1=12.0,
            coordinate_2=5.0,
            coordinate_3=-3.0),
        rstab.structure_core.Node(
            no=15,
            coordinate_1=12.0,
            coordinate_2=5.0,
            coordinate_3=-2.5),
        rstab.structure_core.Node(
            no=16,
            coordinate_1=12.0,
            coordinate_2=5.0,
            coordinate_3=0.0),
        rstab.structure_core.Node(
            no=17,
            coordinate_1=0.3,
            coordinate_2=5.0,
            coordinate_3=-2.5),
        rstab.structure_core.Node(
            no=18,
            coordinate_1=11.7,
            coordinate_2=5.0,
            coordinate_3=-2.5),
        rstab.structure_core.Node(
            no=19,
            coordinate_1=0.0,
            coordinate_2=10.0,
            coordinate_3=0.0),
        rstab.structure_core.Node(
            no=20,
            coordinate_1=0.0,
            coordinate_2=10.0,
            coordinate_3=-2.5),
        rstab.structure_core.Node(
            no=21,
            coordinate_1=0.0,
            coordinate_2=10.0,
            coordinate_3=-3.0),
        rstab.structure_core.Node(
            no=22,
            coordinate_1=6.0,
            coordinate_2=10.0,
            coordinate_3=-4.5),
        rstab.structure_core.Node(
            no=23,
            coordinate_1=12.0,
            coordinate_2=10.0,
            coordinate_3=-3.0),
        rstab.structure_core.Node(
            no=24,
            coordinate_1=12.0,
            coordinate_2=10.0,
            coordinate_3=-2.5),
        rstab.structure_core.Node(
            no=25,
            coordinate_1=12.0,
            coordinate_2=10.0,
            coordinate_3=0.0),
        rstab.structure_core.Node(
            no=26,
            coordinate_1=0.3,
            coordinate_2=10.0,
            coordinate_3=-2.5),
        rstab.structure_core.Node(
            no=27,
            coordinate_1=11.7,
            coordinate_2=10.0,
            coordinate_3=-2.5),
        rstab.structure_core.Node(
            no=28,
            coordinate_1=0.0,
            coordinate_2=15.0,
            coordinate_3=0.0),
        rstab.structure_core.Node(
            no=29,
            coordinate_1=0.0,
            coordinate_2=15.0,
            coordinate_3=-2.5),
        rstab.structure_core.Node(
            no=30,
            coordinate_1=0.0,
            coordinate_2=15.0,
            coordinate_3=-3.0),
        rstab.structure_core.Node(
            no=31,
            coordinate_1=6.0,
            coordinate_2=15.0,
            coordinate_3=-4.5),
        rstab.structure_core.Node(
            no=32,
            coordinate_1=12.0,
            coordinate_2=15.0,
            coordinate_3=-3.0),
        rstab.structure_core.Node(
            no=33,
            coordinate_1=12.0,
            coordinate_2=15.0,
            coordinate_3=-2.5),
        rstab.structure_core.Node(
            no=34,
            coordinate_1=12.0,
            coordinate_2=15.0,
            coordinate_3=0.0),
        rstab.structure_core.Node(
            no=35,
            coordinate_1=0.3,
            coordinate_2=15.0,
            coordinate_3=-2.5),
        rstab.structure_core.Node(
            no=36,
            coordinate_1=11.7,
            coordinate_2=15.0,
            coordinate_3=-2.5),
        rstab.structure_core.Node(
            no=37,
            coordinate_1=0.0,
            coordinate_2=20.0,
            coordinate_3=0.0),
        rstab.structure_core.Node(
            no=38,
            coordinate_1=0.0,
            coordinate_2=20.0,
            coordinate_3=-2.5),
        rstab.structure_core.Node(
            no=39,
            coordinate_1=0.0,
            coordinate_2=20.0,
            coordinate_3=-3.0),
        rstab.structure_core.Node(
            no=40,
            coordinate_1=6.0,
            coordinate_2=20.0,
            coordinate_3=-4.5),
        rstab.structure_core.Node(
            no=41,
            coordinate_1=12.0,
            coordinate_2=20.0,
            coordinate_3=-3.0),
        rstab.structure_core.Node(
            no=42,
            coordinate_1=12.0,
            coordinate_2=20.0,
            coordinate_3=-2.5),
        rstab.structure_core.Node(
            no=43,
            coordinate_1=12.0,
            coordinate_2=20.0,
            coordinate_3=0.0),
        rstab.structure_core.Node(
            no=44,
            coordinate_1=0.3,
            coordinate_2=20.0,
            coordinate_3=-2.5),
        rstab.structure_core.Node(
            no=45,
            coordinate_1=11.7,
            coordinate_2=20.0,
            coordinate_3=-2.5),

        # Members
        rstab.structure_core.Member(
            no=1,
            section_start=1,
            node_start=1,
            node_end=2),
        rstab.structure_core.Member(
            no=2,
            section_start=1,
            node_start=2,
            node_end=3),
        rstab.structure_core.Member(
            no=3,
            section_start=2,
            node_start=3,
            node_end=4),
        rstab.structure_core.Member(
            no=4,
            section_start=2,
            node_start=4,
            node_end=5),
        rstab.structure_core.Member(
            no=5,
            section_start=1,
            node_start=5,
            node_end=6),
        rstab.structure_core.Member(
            no=6,
            section_start=2,
            node_start=2,
            node_end=8),
        rstab.structure_core.Member(
            no=7,
            section_start=2,
            node_start=6,
            node_end=9),
        rstab.structure_core.Member(
            no=8,
            section_start=1,
            node_start=6,
            node_end=7),
        rstab.structure_core.Member(
            no=9,
            section_start=1,
            node_start=10,
            node_end=11),
        rstab.structure_core.Member(
            no=10,
            section_start=1,
            node_start=11,
            node_end=12),
        rstab.structure_core.Member(
            no=11,
            section_start=2,
            node_start=12,
            node_end=13),
        rstab.structure_core.Member(
            no=12,
            section_start=2,
            node_start=13,
            node_end=14),
        rstab.structure_core.Member(
            no=13,
            section_start=1,
            node_start=14,
            node_end=15),
        rstab.structure_core.Member(
            no=14,
            section_start=2,
            node_start=11,
            node_end=17),
        rstab.structure_core.Member(
            no=15,
            section_start=2,
            node_start=15,
            node_end=18),
        rstab.structure_core.Member(
            no=16,
            section_start=1,
            node_start=15,
            node_end=16),
        rstab.structure_core.Member(
            no=17,
            section_start=1,
            node_start=19,
            node_end=20),
        rstab.structure_core.Member(
            no=18,
            section_start=1,
            node_start=20,
            node_end=21),
        rstab.structure_core.Member(
            no=19,
            section_start=2,
            node_start=21,
            node_end=22),
        rstab.structure_core.Member(
            no=20,
            section_start=2,
            node_start=22,
            node_end=23),
        rstab.structure_core.Member(
            no=21,
            section_start=1,
            node_start=23,
            node_end=24),
        rstab.structure_core.Member(
            no=22,
            section_start=2,
            node_start=20,
            node_end=26),
        rstab.structure_core.Member(
            no=23,
            section_start=2,
            node_start=24,
            node_end=27),
        rstab.structure_core.Member(
            no=24,
            section_start=1,
            node_start=24,
            node_end=25),
        rstab.structure_core.Member(
            no=25,
            section_start=1,
            node_start=28,
            node_end=29),
        rstab.structure_core.Member(
            no=26,
            section_start=1,
            node_start=29,
            node_end=30),
        rstab.structure_core.Member(
            no=27,
            section_start=2,
            node_start=30,
            node_end=31),
        rstab.structure_core.Member(
            no=28,
            section_start=2,
            node_start=31,
            node_end=32),
        rstab.structure_core.Member(
            no=29,
            section_start=1,
            node_start=32,
            node_end=33),
        rstab.structure_core.Member(
            no=30,
            section_start=2,
            node_start=29,
            node_end=35),
        rstab.structure_core.Member(
            no=31,
            section_start=2,
            node_start=33,
            node_end=36),
        rstab.structure_core.Member(
            no=32,
            section_start=1,
            node_start=33,
            node_end=34),
        rstab.structure_core.Member(
            no=33,
            section_start=1,
            node_start=37,
            node_end=38),
        rstab.structure_core.Member(
            no=34,
            section_start=1,
            node_start=38,
            node_end=39),
        rstab.structure_core.Member(
            no=35,
            section_start=2,
            node_start=39,
            node_end=40),
        rstab.structure_core.Member(
            no=36,
            section_start=2,
            node_start=40,
            node_end=41),
        rstab.structure_core.Member(
            no=37,
            section_start=1,
            node_start=41,
            node_end=42),
        rstab.structure_core.Member(
            no=38,
            section_start=2,
            node_start=38,
            node_end=44),
        rstab.structure_core.Member(
            no=39,
            section_start=2,
            node_start=42,
            node_end=45),
        rstab.structure_core.Member(
            no=40,
            section_start=1,
            node_start=42,
            node_end=43),
        rstab.structure_core.Member(
            no=41,
            section_start=3,
            node_start=2,
            node_end=11),
        rstab.structure_core.Member(
            no=42,
            section_start=3,
            node_start=6,
            node_end=15),
        rstab.structure_core.Member(
            no=43,
            section_start=3,
            node_start=4,
            node_end=13),
        rstab.structure_core.Member(
            no=44,
            section_start=3,
            node_start=5,
            node_end=14),
        rstab.structure_core.Member(
            no=45,
            section_start=3,
            node_start=3,
            node_end=12),
        rstab.structure_core.Member(
            no=46,
            section_start=3,
            node_start=11,
            node_end=20),
        rstab.structure_core.Member(
            no=47,
            section_start=3,
            node_start=15,
            node_end=24),
        rstab.structure_core.Member(
            no=48,
            section_start=3,
            node_start=13,
            node_end=22),
        rstab.structure_core.Member(
            no=49,
            section_start=3,
            node_start=14,
            node_end=23),
        rstab.structure_core.Member(
            no=50,
            section_start=3,
            node_start=12,
            node_end=21),
        rstab.structure_core.Member(
            no=51,
            section_start=3,
            node_start=20,
            node_end=29),
        rstab.structure_core.Member(
            no=52,
            section_start=3,
            node_start=24,
            node_end=33),
        rstab.structure_core.Member(
            no=53,
            section_start=3,
            node_start=22,
            node_end=31),
        rstab.structure_core.Member(
            no=54,
            section_start=3,
            node_start=23,
            node_end=32),
        rstab.structure_core.Member(
            no=55,
            section_start=3,
            node_start=21,
            node_end=30),
        rstab.structure_core.Member(
            no=56,
            section_start=3,
            node_start=29,
            node_end=38),
        rstab.structure_core.Member(
            no=57,
            section_start=3,
            node_start=33,
            node_end=42),
        rstab.structure_core.Member(
            no=58,
            section_start=3,
            node_start=31,
            node_end=40),
        rstab.structure_core.Member(
            no=59,
            section_start=3,
            node_start=32,
            node_end=41),
        rstab.structure_core.Member(
            no=60,
            section_start=3,
            node_start=30,
            node_end=39),
        rstab.structure_core.Member(
            no=61,
            section_start=4,
            node_start=7,
            node_end=14),
        rstab.structure_core.Member(
            no=62,
            section_start=4,
            node_start=5,
            node_end=16),
        rstab.structure_core.Member(
            no=63,
            section_start=4,
            node_start=5,
            node_end=13),
        rstab.structure_core.Member(
            no=64,
            section_start=4,
            node_start=14,
            node_end=4),
        rstab.structure_core.Member(
            no=65,
            section_start=4,
            node_start=13,
            node_end=3),
        rstab.structure_core.Member(
            no=66,
            section_start=4,
            node_start=12,
            node_end=4),
        rstab.structure_core.Member(
            no=67,
            section_start=4,
            node_start=1,
            node_end=12),
        rstab.structure_core.Member(
            no=68,
            section_start=4,
            node_start=3,
            node_end=10),

        # Nodal Support
        rstab.types_for_nodes.NodalSupport(
            no=1,
            nodes=[1, 7, 10, 16, 19, 25, 28, 34, 37, 43],
            spring_x=inf,
            spring_y=inf,
            spring_z=inf,
            rotational_restraint_x=0,
            rotational_restraint_y=inf,
            rotational_restraint_z=inf),

        # Static Analysis Settings
        rstab.loading.StaticAnalysisSettings(
            no=1),
        rstab.loading.StaticAnalysisSettings(
            no=2,
            analysis_type=rstab.loading.StaticAnalysisSettings.ANALYSIS_TYPE_SECOND_ORDER_P_DELTA),
        rstab.loading.StaticAnalysisSettings(
            no=3,
            analysis_type=rstab.loading.StaticAnalysisSettings.ANALYSIS_TYPE_LARGE_DEFORMATIONS,
            number_of_load_increments=10),

        # Load Cases
        rstab.loading.LoadCase(
            no=1,
            name="Self weight",
            static_analysis_settings=1),
        rstab.loading.LoadCase(
            no=2,
            name="Live load",
            static_analysis_settings=2,
            action_category=rstab.loading.LoadCase.ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_H_ROOFS_QI_H),
        rstab.loading.LoadCase(
            no=3,
            name="Wind load",
            static_analysis_settings=2,
            action_category=rstab.loading.LoadCase.ACTION_CATEGORY_WIND_QW),
        rstab.loading.LoadCase(
            no=4,
            name="Wind load 2",
            static_analysis_settings=2,
            action_category=rstab.loading.LoadCase.ACTION_CATEGORY_WIND_QW),
        rstab.loading.LoadCase(
            no=5,
            name="Stability - linear",
            static_analysis_settings=1,
            action_category=rstab.loading.LoadCase.ACTION_CATEGORY_PERMANENT_IMPOSED_GQ,
            self_weight_active=True),
        rstab.loading.LoadCase(
            no=6,
            name="Snow load",
            static_analysis_settings=2,
            action_category=rstab.loading.LoadCase.ACTION_CATEGORY_SNOW_ICE_LOADS_H_LESS_OR_EQUAL_TO_1000_M_QS),
        rstab.loading.LoadCase(
            no=7,
            name="Imperfections",
            static_analysis_settings=2,
            consider_imperfection=True,
            imperfection_case=1,
            action_category=rstab.loading.LoadCase.ACTION_CATEGORY_PERMANENT_IMPOSED_GQ),
        rstab.loading.LoadCase(
            no=8,
            name="Other permanent load",
            static_analysis_settings=2),

        # Imperfection Case
        rstab.imperfections.ImperfectionCase(
            no=1,
            name="Local Imperfections Only 1",
            assigned_to_load_cases=[7]),

        # Design Situation
        rstab.loading.DesignSituation(
            no=1,
            user_defined_name_enabled=True,
            name="DS 1",
            design_situation_type=rstab.loading.DesignSituation.DESIGN_SITUATION_TYPE_EQU_PERMANENT_AND_TRANSIENT),
    ]
    rstab_app.create_object_list(
        lst,
        steel_hall_id)

    # Delete materials 6 and 7 in silo
    rstab_app.delete_object_list([
        rstab.structure_core.Material(
            no=6),
        rstab.structure_core.Material(
            no=7)
    ],
        silo_id)

    # Delete material 5 in silo
    rstab_app.delete_object(
        rstab.structure_core.Material(
            no=5),
            silo_id)

    # Create rest of objects in silo
    lst = [
        # Sections
        rstab.structure_core.Section(
            no=1,
            material=1,
            name="IPN 300"),
        rstab.structure_core.Section(
            no=2,
            material=1,
            name="UPE 200"),
        rstab.structure_core.Section(
            no=3,
            material=1,
            name="MSH KHP 88.9x3.6"),
        rstab.structure_core.Section(
            no=4,
            material=1,
            name="MSH KHP 88.9x3.6"),
        rstab.structure_core.Section(
            no=5,
            material=1,
            name="LU 0.3/0.2/0.01/0.01/0"),

        # Nodes
        rstab.structure_core.Node(
            no=1,
            coordinate_1=0.0,
            coordinate_2=0.0,
            coordinate_3=0.0),
        rstab.structure_core.Node(
            no=2,
            coordinate_1=3.0,
            coordinate_2=0.0,
            coordinate_3=0.0),
        rstab.structure_core.Node(
            no=3,
            coordinate_1=3.0,
            coordinate_2=3.0,
            coordinate_3=0.0),
        rstab.structure_core.Node(
            no=4,
            coordinate_1=0.0,
            coordinate_2=3.0,
            coordinate_3=0.0),
        rstab.structure_core.Node(
            no=5,
            coordinate_1=0.0,
            coordinate_2=0.0,
            coordinate_3=-3.0),
        rstab.structure_core.Node(
            no=6,
            coordinate_1=1.5,
            coordinate_2=0.0,
            coordinate_3=-3.0),
        rstab.structure_core.Node(
            no=7,
            coordinate_1=3.0,
            coordinate_2=0.0,
            coordinate_3=-3.0),
        rstab.structure_core.Node(
            no=8,
            coordinate_1=3.0,
            coordinate_2=1.5,
            coordinate_3=-3.0),
        rstab.structure_core.Node(
            no=9,
            coordinate_1=3.0,
            coordinate_2=3.0,
            coordinate_3=-3.0),
        rstab.structure_core.Node(
            no=10,
            coordinate_1=1.5,
            coordinate_2=3.0,
            coordinate_3=-3.0),
        rstab.structure_core.Node(
            no=11,
            coordinate_1=0.0,
            coordinate_2=3.0,
            coordinate_3=-3.0),
        rstab.structure_core.Node(
            no=12,
            coordinate_1=0.0,
            coordinate_2=1.5,
            coordinate_3=-3.0),
        rstab.structure_core.Node(
            no=13,
            coordinate_1=0.0,
            coordinate_2=0.0,
            coordinate_3=-6.0),
        rstab.structure_core.Node(
            no=14,
            coordinate_1=1.5,
            coordinate_2=0.0,
            coordinate_3=-6.0),
        rstab.structure_core.Node(
            no=15,
            coordinate_1=3.0,
            coordinate_2=0.0,
            coordinate_3=-6.0),
        rstab.structure_core.Node(
            no=16,
            coordinate_1=3.0,
            coordinate_2=1.5,
            coordinate_3=-6.0),
        rstab.structure_core.Node(
            no=17,
            coordinate_1=3.0,
            coordinate_2=3.0,
            coordinate_3=-6.0),
        rstab.structure_core.Node(
            no=18,
            coordinate_1=1.5,
            coordinate_2=3.0,
            coordinate_3=-6.0),
        rstab.structure_core.Node(
            no=19,
            coordinate_1=0.0,
            coordinate_2=3.0,
            coordinate_3=-6.0),
        rstab.structure_core.Node(
            no=20,
            coordinate_1=0.0,
            coordinate_2=1.5,
            coordinate_3=-6.0),
        rstab.structure_core.Node(
            no=21,
            coordinate_1=0.75,
            coordinate_2=0.75,
            coordinate_3=-4.0),
        rstab.structure_core.Node(
            no=22,
            coordinate_1=2.25,
            coordinate_2=0.75,
            coordinate_3=-4.0),
        rstab.structure_core.Node(
            no=23,
            coordinate_1=2.25,
            coordinate_2=2.25,
            coordinate_3=-4.0),
        rstab.structure_core.Node(
            no=24,
            coordinate_1=0.75,
            coordinate_2=2.25,
            coordinate_3=-4.0),
        rstab.structure_core.Node(
            no=25,
            coordinate_1=0.0,
            coordinate_2=0.0,
            coordinate_3=-12.0),
        rstab.structure_core.Node(
            no=26,
            coordinate_1=3.0,
            coordinate_2=0.0,
            coordinate_3=-12.0),
        rstab.structure_core.Node(
            no=27,
            coordinate_1=3.0,
            coordinate_2=3.0,
            coordinate_3=-12.0),
        rstab.structure_core.Node(
            no=28,
            coordinate_1=0.0,
            coordinate_2=3.0,
            coordinate_3=-12.0),

        # Beams
        rstab.structure_core.Member(
            no=1,
            node_start=1,
            node_end=5,
            member_hinge_start=1,
            member_hinge_end=2,
            section_start=1),
        rstab.structure_core.Member(
            no=2,
            node_start=2,
            node_end=7,
            member_hinge_start=1,
            member_hinge_end=2,
            section_start=1),
        rstab.structure_core.Member(
            no=3,
            node_start=3,
            node_end=9,
            member_hinge_start=1,
            member_hinge_end=2,
            section_start=1),
        rstab.structure_core.Member(
            no=4,
            node_start=4,
            node_end=11,
            member_hinge_start=1,
            member_hinge_end=2,
            section_start=1),
        rstab.structure_core.Member(
            no=5,
            node_start=5,
            node_end=13,
            member_hinge_start=1,
            member_hinge_end=2,
            section_start=1),
        rstab.structure_core.Member(
            no=6,
            node_start=7,
            node_end=15,
            member_hinge_start=1,
            member_hinge_end=2,
            section_start=1),
        rstab.structure_core.Member(
            no=7,
            node_start=9,
            node_end=17,
            member_hinge_start=1,
            member_hinge_end=2,
            section_start=1),
        rstab.structure_core.Member(
            no=8,
            node_start=11,
            node_end=19,
            member_hinge_start=1,
            member_hinge_end=2,
            section_start=1),
        rstab.structure_core.Member(
            no=9,
            section_start=2,
            node_start=13,
            node_end=14),
        rstab.structure_core.Member(
            no=10,
            section_start=2,
            node_start=14,
            node_end=15),
        rstab.structure_core.Member(
            no=11,
            section_start=2,
            node_start=15,
            node_end=16),
        rstab.structure_core.Member(
            no=12,
            section_start=2,
            node_start=16,
            node_end=17),
        rstab.structure_core.Member(
            no=13,
            section_start=2,
            node_start=17,
            node_end=18),
        rstab.structure_core.Member(
            no=14,
            section_start=2,
            node_start=18,
            node_end=19),
        rstab.structure_core.Member(
            no=15,
            section_start=2,
            node_start=19,
            node_end=20),
        rstab.structure_core.Member(
            no=16,
            section_start=2,
            node_start=20,
            node_end=13),
        rstab.structure_core.Member(
            no=17,
            node_start=1,
            node_end=6,
            member_hinge_start=1,
            member_hinge_end=2,
            section_start=3),
        rstab.structure_core.Member(
            no=18,
            node_start=2,
            node_end=6,
            member_hinge_start=1,
            member_hinge_end=2,
            section_start=3),
        rstab.structure_core.Member(
            no=19,
            node_start=2,
            node_end=8,
            member_hinge_start=1,
            member_hinge_end=2,
            section_start=3),
        rstab.structure_core.Member(
            no=20,
            node_start=3,
            node_end=8,
            member_hinge_start=1,
            member_hinge_end=2,
            section_start=3),
        rstab.structure_core.Member(
            no=21,
            node_start=3,
            node_end=10,
            member_hinge_start=1,
            member_hinge_end=2,
            section_start=3),
        rstab.structure_core.Member(
            no=22,
            node_start=4,
            node_end=10,
            member_hinge_start=1,
            member_hinge_end=2,
            section_start=3),
        rstab.structure_core.Member(
            no=23,
            node_start=4,
            node_end=12,
            member_hinge_start=1,
            member_hinge_end=2,
            section_start=3),
        rstab.structure_core.Member(
            no=24,
            node_start=1,
            node_end=12,
            member_hinge_start=1,
            member_hinge_end=2,
            section_start=3),
        rstab.structure_core.Member(
            no=25,
            node_start=5,
            node_end=14,
            member_hinge_start=1,
            member_hinge_end=2,
            section_start=3),
        rstab.structure_core.Member(
            no=26,
            node_start=7,
            node_end=14,
            member_hinge_start=1,
            member_hinge_end=2,
            section_start=3),
        rstab.structure_core.Member(
            no=27,
            node_start=7,
            node_end=16,
            member_hinge_start=1,
            member_hinge_end=2,
            section_start=3),
        rstab.structure_core.Member(
            no=28,
            node_start=9,
            node_end=16,
            member_hinge_start=1,
            member_hinge_end=2,
            section_start=3),
        rstab.structure_core.Member(
            no=29,
            node_start=9,
            node_end=18,
            member_hinge_start=1,
            member_hinge_end=2,
            section_start=3),
        rstab.structure_core.Member(
            no=30,
            node_start=11,
            node_end=18,
            member_hinge_start=1,
            member_hinge_end=2,
            section_start=3),
        rstab.structure_core.Member(
            no=31,
            node_start=11,
            node_end=20,
            member_hinge_start=1,
            member_hinge_end=2,
            section_start=3),
        rstab.structure_core.Member(
            no=32,
            node_start=5,
            node_end=20,
            member_hinge_start=1,
            member_hinge_end=2,
            section_start=3),
        rstab.structure_core.Member(
            no=33,
            node_start=5,
            node_end=6,
            section_start=4,
            member_hinge_start=1),
        rstab.structure_core.Member(
            no=34,
            node_start=6,
            node_end=7,
            section_start=4,
            member_hinge_end=2),
        rstab.structure_core.Member(
            no=35,
            node_start=7,
            node_end=8,
            section_start=4,
            member_hinge_start=1),
        rstab.structure_core.Member(
            no=36,
            node_start=8,
            node_end=9,
            section_start=4,
            member_hinge_end=2),
        rstab.structure_core.Member(
            no=37,
            node_start=9,
            node_end=10,
            section_start=4,
            member_hinge_start=1),
        rstab.structure_core.Member(
            no=38,
            node_start=10,
            node_end=11,
            section_start=4,
            member_hinge_end=2),
        rstab.structure_core.Member(
            no=39,
            node_start=11,
            node_end=12,
            section_start=4,
            member_hinge_start=1),
        rstab.structure_core.Member(
            no=40,
            node_start=12,
            node_end=5,
            section_start=5,
            member_hinge_end=2),
        rstab.structure_core.Member(
            no=41,
            node_start=21,
            node_end=22,
            section_start=5,
            rotation_angle=1.57079632679487),
        rstab.structure_core.Member(
            no=42,
            node_start=22,
            node_end=23,
            section_start=5),
        rstab.structure_core.Member(
            no=43,
            node_start=23,
            node_end=24,
            section_start=5,
            rotation_angle=-1.57079632679487),
        rstab.structure_core.Member(
            no=44,
            node_start=24,
            node_end=21,
            section_start=5,
            rotation_angle=3.14159265358974),
        rstab.structure_core.Member(
            no=45,
            node_start=13,
            node_end=21,
            member_hinge_start=1,
            member_hinge_end=2,
            section_start=1),
        rstab.structure_core.Member(
            no=46,
            node_start=15,
            node_end=22,
            member_hinge_start=1,
            member_hinge_end=2,
            section_start=1),
        rstab.structure_core.Member(
            no=47,
            node_start=17,
            node_end=23,
            member_hinge_start=1,
            member_hinge_end=2,
            section_start=1),
        rstab.structure_core.Member(
            no=48,
            node_start=19,
            node_end=24,
            member_hinge_start=1,
            member_hinge_end=2,
            section_start=1),
        rstab.structure_core.Member(
            no=49,
            node_start=13,
            node_end=25,
            member_hinge_start=1,
            member_hinge_end=2,
            section_start=1),
        rstab.structure_core.Member(
            no=50,
            node_start=15,
            node_end=26,
            member_hinge_start=1,
            member_hinge_end=2,
            section_start=1),
        rstab.structure_core.Member(
            no=51,
            node_start=17,
            node_end=27,
            member_hinge_start=1,
            member_hinge_end=2,
            section_start=1),
        rstab.structure_core.Member(
            no=52,
            node_start=19,
            node_end=28,
            member_hinge_start=1,
            member_hinge_end=2,
            section_start=1),
        rstab.structure_core.Member(
            no=53,
            node_start=25,
            node_end=26,
            member_hinge_start=1,
            member_hinge_end=2,
            section_start=1),
        rstab.structure_core.Member(
            no=54,
            node_start=26,
            node_end=27,
            member_hinge_start=1,
            member_hinge_end=2,
            section_start=1),
        rstab.structure_core.Member(
            no=55,
            node_start=27,
            node_end=28,
            member_hinge_start=1,
            member_hinge_end=2,
            section_start=1),
        rstab.structure_core.Member(
            no=56,
            node_start=28,
            node_end=25,
            member_hinge_start=1,
            member_hinge_end=2,
            section_start=1),


        # Nodal Support
        rstab.types_for_nodes.NodalSupport(
            no=1,
            nodes=[1, 2, 3, 4],
            spring_x=700000,
            spring_y=800000,
            spring_z=5000000),

        # Member Hinges
        rstab.types_for_members.MemberHinge(
            no=1,
            moment_release_mt=28000,
            axial_release_n=inf,
            axial_release_vy=inf,
            axial_release_vz=inf),
        rstab.types_for_members.MemberHinge(
            no=2,
            moment_release_mt=29000,
            axial_release_n=inf,
            axial_release_vy=inf,
            axial_release_vz=inf,
            moment_release_mz=inf),

        # Static Analysis Settings
        rstab.loading.StaticAnalysisSettings(
            no=1),
        rstab.loading.StaticAnalysisSettings(
            no=2,
            analysis_type=rstab.loading.StaticAnalysisSettings.ANALYSIS_TYPE_SECOND_ORDER_P_DELTA,
            number_of_load_increments=2),
        rstab.loading.StaticAnalysisSettings(
            no=3,
            analysis_type=rstab.loading.StaticAnalysisSettings.ANALYSIS_TYPE_LARGE_DEFORMATIONS,
            number_of_load_increments=10),

        # Load Cases
        rstab.loading.LoadCase(
            no=1,
            name="Self weight",
            static_analysis_settings=1),
        rstab.loading.LoadCase(
            no=2,
            name="Live load",
            static_analysis_settings=2,
            action_category=rstab.loading.LoadCase.ACTION_CATEGORY_PERMANENT_IMPOSED_GQ),
        rstab.loading.LoadCase(
            no=3,
            name="Stability - linear",
            static_analysis_settings=1,
            action_category=rstab.loading.LoadCase.ACTION_CATEGORY_PERMANENT_IMPOSED_GQ,
            self_weight_active=True),
    ]
    rstab_app.create_object_list(
        lst,
        silo_id)

    # Delete material 3 in silo
    rstab_app.delete_object(
        rstab.structure_core.Material(
            no=3),
            silo_id)

    # Connection is terminated automatically at the end of the script.
