from dlubal.api.common import common_pb2 as _common_pb2
from google.protobuf.internal import containers as _containers
from google.protobuf.internal import enum_type_wrapper as _enum_type_wrapper
from google.protobuf import descriptor as _descriptor
from google.protobuf import message as _message
from typing import ClassVar as _ClassVar, Iterable as _Iterable, Mapping as _Mapping, Optional as _Optional, Union as _Union

DESCRIPTOR: _descriptor.FileDescriptor

class MemberRepresentative(_message.Message):
    __slots__ = ("no", "type", "user_defined_name_enabled", "name", "comment", "number_of_members", "total_length", "total_volume", "total_mass", "total_surface_of_coating", "nodes_on_member_from_start", "is_deactivated_for_calculation", "line", "section_distribution_type", "reference_type", "nodes", "node_start", "node_end", "analytical_length", "analytical_volume", "analytical_mass", "analytical_surface_of_coating", "analytical_center_of_gravity", "analytical_center_of_gravity_x", "analytical_center_of_gravity_y", "analytical_center_of_gravity_z", "length", "volume", "mass", "surface_of_coating", "center_of_gravity", "center_of_gravity_x", "center_of_gravity_y", "center_of_gravity_z", "member_representative", "member_type_rib_alignment", "member_rib_first_surface", "member_rib_second_surface", "member_rib_surface_assignment_autodetect", "member_rib_generating_longitudinal_reinforcement_items_from_surfaces_enabled", "align_local_z_axis_to_local_z_axis_of_surface", "member_rib_shear_joint_between_web_and_flange", "member_rib_surface_roughness_classification", "member_rib_reduction_of_joint_width", "result_beam_integrate_stresses_and_forces", "flange_dimensions", "synchronize_width_mode", "relative_ordinates_mode", "member_type_definable_stiffness", "result_beam_y_z", "result_beam_y_plus", "result_beam_z_plus", "result_beam_y_minus", "result_beam_z_minus", "result_beam_radius", "result_beam_include_surfaces", "result_beam_include_all_surfaces", "result_beam_include_solids", "result_beam_include_all_solids", "result_beam_include_members", "result_beam_include_all_members", "result_beam_exclude_surfaces", "result_beam_exclude_solids", "result_beam_exclude_members", "projected_length", "section_distance_from_start_is_defined_as_relative", "section_distance_from_start_absolute", "section_distance_from_start_relative", "section_distance_from_end_is_defined_as_relative", "section_distance_from_end_absolute", "section_distance_from_end_relative", "section_alignment", "grain_alignment", "is_curved", "curved_member_is_asymmetric_layout", "curved_member_is_cantilevers", "curved_member_cantilevers_type", "curved_member_is_capped_with_loose_ridge_wedge", "curved_member_parameters", "rotation_specification_type", "rotation_angle", "rotation_help_node", "rotation_plane_type", "rotation_surface", "rotation_surface_plane_type", "is_rotated", "section_start", "section_end", "section_internal", "section_material", "members", "member_hinge_start", "member_hinge_end", "member_eccentricity_start", "member_eccentricity_end", "support", "member_transverse_stiffener", "member_openings", "member_nonlinearity", "member_result_intermediate_point", "concrete_effective_lengths", "steel_effective_lengths", "timber_effective_lengths", "aluminum_effective_lengths", "concrete_shear_reinforcement_spans", "concrete_longitudinal_reinforcement_items", "concrete_cover_user_defined_enabled", "concrete_cover_different_at_section_sides_enabled", "concrete_cover", "concrete_cover_top", "concrete_cover_bottom", "concrete_cover_left", "concrete_cover_right", "concrete_cover_min", "concrete_cover_min_top", "concrete_cover_min_bottom", "concrete_cover_min_left", "concrete_cover_min_right", "concrete_durability", "concrete_durability_top", "concrete_durability_bottom", "concrete_durability_left", "concrete_durability_right", "steel_boundary_conditions", "steel_member_local_section_reduction", "steel_member_transverse_weld", "timber_service_class", "timber_moisture_class", "timber_service_conditions", "timber_member_local_section_reduction", "aluminum_boundary_conditions", "aluminum_member_local_section_reduction", "aluminum_member_transverse_weld", "stress_analysis_configuration", "member_aluminum_design_uls_configuration", "member_aluminum_design_sls_configuration", "member_concrete_design_uls_configuration", "member_concrete_design_sls_configuration", "member_concrete_design_fr_configuration", "member_concrete_design_seismic_configuration", "member_steel_design_uls_configuration", "member_steel_design_sls_configuration", "member_steel_design_fr_configuration", "member_timber_design_uls_configuration", "member_timber_design_sls_configuration", "member_timber_design_fr_configuration", "end_modifications_member_start_extension", "end_modifications_member_start_slope_y", "end_modifications_member_start_slope_z", "end_modifications_member_end_extension", "end_modifications_member_end_slope_y", "end_modifications_member_end_slope_z", "has_any_end_modifications", "deflection_check_direction", "deflection_check_displacement_reference", "design_support_on_member_start", "design_support_on_member_end", "design_supports_on_internal_nodes", "is_generated", "generating_object_info", "deflection_segments_defined_length_y_axis_enabled", "deflection_segments_defined_length_z_axis_enabled", "deflection_segments_y_axis", "deflection_segments_z_axis", "concrete_longitudinal_reinforcement_span", "concrete_shear_reinforcement_span", "design_properties_via_member", "design_properties_via_parent_member_set", "design_properties_parent_member_set", "id_for_export_import", "metadata_for_export_import")
    class Type(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
        __slots__ = ()
        TYPE_UNKNOWN: _ClassVar[MemberRepresentative.Type]
        TYPE_ANCHOR: _ClassVar[MemberRepresentative.Type]
        TYPE_BEAM: _ClassVar[MemberRepresentative.Type]
        TYPE_BUCKLING: _ClassVar[MemberRepresentative.Type]
        TYPE_CABLE: _ClassVar[MemberRepresentative.Type]
        TYPE_CABLE_ON_PULLEYS: _ClassVar[MemberRepresentative.Type]
        TYPE_COMPRESSION: _ClassVar[MemberRepresentative.Type]
        TYPE_COUPLING_HINGE_HINGE: _ClassVar[MemberRepresentative.Type]
        TYPE_COUPLING_HINGE_RIGID: _ClassVar[MemberRepresentative.Type]
        TYPE_COUPLING_RIGID_HINGE: _ClassVar[MemberRepresentative.Type]
        TYPE_COUPLING_RIGID_RIGID: _ClassVar[MemberRepresentative.Type]
        TYPE_DAMPER: _ClassVar[MemberRepresentative.Type]
        TYPE_DEEP_BEAM: _ClassVar[MemberRepresentative.Type]
        TYPE_DEFINABLE_STIFFNESS: _ClassVar[MemberRepresentative.Type]
        TYPE_DESIGN_STRIP: _ClassVar[MemberRepresentative.Type]
        TYPE_JOIST: _ClassVar[MemberRepresentative.Type]
        TYPE_PILE: _ClassVar[MemberRepresentative.Type]
        TYPE_RESULT_BEAM: _ClassVar[MemberRepresentative.Type]
        TYPE_RESULT_LINE: _ClassVar[MemberRepresentative.Type]
        TYPE_RIB: _ClassVar[MemberRepresentative.Type]
        TYPE_RIGID: _ClassVar[MemberRepresentative.Type]
        TYPE_SHEAR_WALL: _ClassVar[MemberRepresentative.Type]
        TYPE_SPRING: _ClassVar[MemberRepresentative.Type]
        TYPE_SURFACE_MODEL: _ClassVar[MemberRepresentative.Type]
        TYPE_TENDON: _ClassVar[MemberRepresentative.Type]
        TYPE_TENSION: _ClassVar[MemberRepresentative.Type]
        TYPE_TRUSS: _ClassVar[MemberRepresentative.Type]
        TYPE_TRUSS_ONLY_N: _ClassVar[MemberRepresentative.Type]
    TYPE_UNKNOWN: MemberRepresentative.Type
    TYPE_ANCHOR: MemberRepresentative.Type
    TYPE_BEAM: MemberRepresentative.Type
    TYPE_BUCKLING: MemberRepresentative.Type
    TYPE_CABLE: MemberRepresentative.Type
    TYPE_CABLE_ON_PULLEYS: MemberRepresentative.Type
    TYPE_COMPRESSION: MemberRepresentative.Type
    TYPE_COUPLING_HINGE_HINGE: MemberRepresentative.Type
    TYPE_COUPLING_HINGE_RIGID: MemberRepresentative.Type
    TYPE_COUPLING_RIGID_HINGE: MemberRepresentative.Type
    TYPE_COUPLING_RIGID_RIGID: MemberRepresentative.Type
    TYPE_DAMPER: MemberRepresentative.Type
    TYPE_DEEP_BEAM: MemberRepresentative.Type
    TYPE_DEFINABLE_STIFFNESS: MemberRepresentative.Type
    TYPE_DESIGN_STRIP: MemberRepresentative.Type
    TYPE_JOIST: MemberRepresentative.Type
    TYPE_PILE: MemberRepresentative.Type
    TYPE_RESULT_BEAM: MemberRepresentative.Type
    TYPE_RESULT_LINE: MemberRepresentative.Type
    TYPE_RIB: MemberRepresentative.Type
    TYPE_RIGID: MemberRepresentative.Type
    TYPE_SHEAR_WALL: MemberRepresentative.Type
    TYPE_SPRING: MemberRepresentative.Type
    TYPE_SURFACE_MODEL: MemberRepresentative.Type
    TYPE_TENDON: MemberRepresentative.Type
    TYPE_TENSION: MemberRepresentative.Type
    TYPE_TRUSS: MemberRepresentative.Type
    TYPE_TRUSS_ONLY_N: MemberRepresentative.Type
    class SectionDistributionType(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
        __slots__ = ()
        SECTION_DISTRIBUTION_TYPE_UNIFORM: _ClassVar[MemberRepresentative.SectionDistributionType]
        SECTION_DISTRIBUTION_TYPE_CURVED: _ClassVar[MemberRepresentative.SectionDistributionType]
        SECTION_DISTRIBUTION_TYPE_FISH_BEAM_LINEAR: _ClassVar[MemberRepresentative.SectionDistributionType]
        SECTION_DISTRIBUTION_TYPE_FISH_BEAM_PARABOLIC: _ClassVar[MemberRepresentative.SectionDistributionType]
        SECTION_DISTRIBUTION_TYPE_LINEAR: _ClassVar[MemberRepresentative.SectionDistributionType]
        SECTION_DISTRIBUTION_TYPE_NONE: _ClassVar[MemberRepresentative.SectionDistributionType]
        SECTION_DISTRIBUTION_TYPE_OFFSET_AT_BOTH_SIDES: _ClassVar[MemberRepresentative.SectionDistributionType]
        SECTION_DISTRIBUTION_TYPE_OFFSET_AT_END_OF_MEMBER: _ClassVar[MemberRepresentative.SectionDistributionType]
        SECTION_DISTRIBUTION_TYPE_OFFSET_AT_START_OF_MEMBER: _ClassVar[MemberRepresentative.SectionDistributionType]
        SECTION_DISTRIBUTION_TYPE_PITCHED_CAMBERED_BEAM_WITH_CONSTANT_HEIGHT: _ClassVar[MemberRepresentative.SectionDistributionType]
        SECTION_DISTRIBUTION_TYPE_PITCHED_CAMBERED_BEAM_WITH_VARIABLE_HEIGHT: _ClassVar[MemberRepresentative.SectionDistributionType]
        SECTION_DISTRIBUTION_TYPE_SADDLE: _ClassVar[MemberRepresentative.SectionDistributionType]
        SECTION_DISTRIBUTION_TYPE_TAPERED_AND_OFFSET_AT_BOTH_SIDES: _ClassVar[MemberRepresentative.SectionDistributionType]
        SECTION_DISTRIBUTION_TYPE_TAPERED_AND_OFFSET_AT_END_OF_MEMBER: _ClassVar[MemberRepresentative.SectionDistributionType]
        SECTION_DISTRIBUTION_TYPE_TAPERED_AND_OFFSET_AT_START_OF_MEMBER: _ClassVar[MemberRepresentative.SectionDistributionType]
        SECTION_DISTRIBUTION_TYPE_TAPERED_AT_BOTH_SIDES: _ClassVar[MemberRepresentative.SectionDistributionType]
        SECTION_DISTRIBUTION_TYPE_TAPERED_AT_END_OF_MEMBER: _ClassVar[MemberRepresentative.SectionDistributionType]
        SECTION_DISTRIBUTION_TYPE_TAPERED_AT_START_OF_MEMBER: _ClassVar[MemberRepresentative.SectionDistributionType]
    SECTION_DISTRIBUTION_TYPE_UNIFORM: MemberRepresentative.SectionDistributionType
    SECTION_DISTRIBUTION_TYPE_CURVED: MemberRepresentative.SectionDistributionType
    SECTION_DISTRIBUTION_TYPE_FISH_BEAM_LINEAR: MemberRepresentative.SectionDistributionType
    SECTION_DISTRIBUTION_TYPE_FISH_BEAM_PARABOLIC: MemberRepresentative.SectionDistributionType
    SECTION_DISTRIBUTION_TYPE_LINEAR: MemberRepresentative.SectionDistributionType
    SECTION_DISTRIBUTION_TYPE_NONE: MemberRepresentative.SectionDistributionType
    SECTION_DISTRIBUTION_TYPE_OFFSET_AT_BOTH_SIDES: MemberRepresentative.SectionDistributionType
    SECTION_DISTRIBUTION_TYPE_OFFSET_AT_END_OF_MEMBER: MemberRepresentative.SectionDistributionType
    SECTION_DISTRIBUTION_TYPE_OFFSET_AT_START_OF_MEMBER: MemberRepresentative.SectionDistributionType
    SECTION_DISTRIBUTION_TYPE_PITCHED_CAMBERED_BEAM_WITH_CONSTANT_HEIGHT: MemberRepresentative.SectionDistributionType
    SECTION_DISTRIBUTION_TYPE_PITCHED_CAMBERED_BEAM_WITH_VARIABLE_HEIGHT: MemberRepresentative.SectionDistributionType
    SECTION_DISTRIBUTION_TYPE_SADDLE: MemberRepresentative.SectionDistributionType
    SECTION_DISTRIBUTION_TYPE_TAPERED_AND_OFFSET_AT_BOTH_SIDES: MemberRepresentative.SectionDistributionType
    SECTION_DISTRIBUTION_TYPE_TAPERED_AND_OFFSET_AT_END_OF_MEMBER: MemberRepresentative.SectionDistributionType
    SECTION_DISTRIBUTION_TYPE_TAPERED_AND_OFFSET_AT_START_OF_MEMBER: MemberRepresentative.SectionDistributionType
    SECTION_DISTRIBUTION_TYPE_TAPERED_AT_BOTH_SIDES: MemberRepresentative.SectionDistributionType
    SECTION_DISTRIBUTION_TYPE_TAPERED_AT_END_OF_MEMBER: MemberRepresentative.SectionDistributionType
    SECTION_DISTRIBUTION_TYPE_TAPERED_AT_START_OF_MEMBER: MemberRepresentative.SectionDistributionType
    class ReferenceType(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
        __slots__ = ()
        REFERENCE_TYPE_L: _ClassVar[MemberRepresentative.ReferenceType]
        REFERENCE_TYPE_XY: _ClassVar[MemberRepresentative.ReferenceType]
        REFERENCE_TYPE_XZ: _ClassVar[MemberRepresentative.ReferenceType]
        REFERENCE_TYPE_YZ: _ClassVar[MemberRepresentative.ReferenceType]
    REFERENCE_TYPE_L: MemberRepresentative.ReferenceType
    REFERENCE_TYPE_XY: MemberRepresentative.ReferenceType
    REFERENCE_TYPE_XZ: MemberRepresentative.ReferenceType
    REFERENCE_TYPE_YZ: MemberRepresentative.ReferenceType
    class MemberTypeRibAlignment(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
        __slots__ = ()
        MEMBER_TYPE_RIB_ALIGNMENT_ON_Z_SIDE_NEGATIVE: _ClassVar[MemberRepresentative.MemberTypeRibAlignment]
        MEMBER_TYPE_RIB_ALIGNMENT_CENTRIC: _ClassVar[MemberRepresentative.MemberTypeRibAlignment]
        MEMBER_TYPE_RIB_ALIGNMENT_ON_Z_SIDE_POSITIVE: _ClassVar[MemberRepresentative.MemberTypeRibAlignment]
        MEMBER_TYPE_RIB_ALIGNMENT_USER_DEFINED_VIA_MEMBER_ECCENTRICITY: _ClassVar[MemberRepresentative.MemberTypeRibAlignment]
    MEMBER_TYPE_RIB_ALIGNMENT_ON_Z_SIDE_NEGATIVE: MemberRepresentative.MemberTypeRibAlignment
    MEMBER_TYPE_RIB_ALIGNMENT_CENTRIC: MemberRepresentative.MemberTypeRibAlignment
    MEMBER_TYPE_RIB_ALIGNMENT_ON_Z_SIDE_POSITIVE: MemberRepresentative.MemberTypeRibAlignment
    MEMBER_TYPE_RIB_ALIGNMENT_USER_DEFINED_VIA_MEMBER_ECCENTRICITY: MemberRepresentative.MemberTypeRibAlignment
    class MemberRibSurfaceRoughnessClassification(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
        __slots__ = ()
        MEMBER_RIB_SURFACE_ROUGHNESS_CLASSIFICATION_INDENTED: _ClassVar[MemberRepresentative.MemberRibSurfaceRoughnessClassification]
        MEMBER_RIB_SURFACE_ROUGHNESS_CLASSIFICATION_ROUGH: _ClassVar[MemberRepresentative.MemberRibSurfaceRoughnessClassification]
        MEMBER_RIB_SURFACE_ROUGHNESS_CLASSIFICATION_SMOOTH: _ClassVar[MemberRepresentative.MemberRibSurfaceRoughnessClassification]
        MEMBER_RIB_SURFACE_ROUGHNESS_CLASSIFICATION_VERY_SMOOTH: _ClassVar[MemberRepresentative.MemberRibSurfaceRoughnessClassification]
    MEMBER_RIB_SURFACE_ROUGHNESS_CLASSIFICATION_INDENTED: MemberRepresentative.MemberRibSurfaceRoughnessClassification
    MEMBER_RIB_SURFACE_ROUGHNESS_CLASSIFICATION_ROUGH: MemberRepresentative.MemberRibSurfaceRoughnessClassification
    MEMBER_RIB_SURFACE_ROUGHNESS_CLASSIFICATION_SMOOTH: MemberRepresentative.MemberRibSurfaceRoughnessClassification
    MEMBER_RIB_SURFACE_ROUGHNESS_CLASSIFICATION_VERY_SMOOTH: MemberRepresentative.MemberRibSurfaceRoughnessClassification
    class ResultBeamIntegrateStressesAndForces(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
        __slots__ = ()
        RESULT_BEAM_INTEGRATE_STRESSES_AND_FORCES_WITHIN_CUBOID_QUADRATIC: _ClassVar[MemberRepresentative.ResultBeamIntegrateStressesAndForces]
        RESULT_BEAM_INTEGRATE_STRESSES_AND_FORCES_FROM_LISTED_INCLUDE_OBJECTS: _ClassVar[MemberRepresentative.ResultBeamIntegrateStressesAndForces]
        RESULT_BEAM_INTEGRATE_STRESSES_AND_FORCES_WITHIN_CUBOID_GENERAL: _ClassVar[MemberRepresentative.ResultBeamIntegrateStressesAndForces]
        RESULT_BEAM_INTEGRATE_STRESSES_AND_FORCES_WITHIN_CYLINDER: _ClassVar[MemberRepresentative.ResultBeamIntegrateStressesAndForces]
    RESULT_BEAM_INTEGRATE_STRESSES_AND_FORCES_WITHIN_CUBOID_QUADRATIC: MemberRepresentative.ResultBeamIntegrateStressesAndForces
    RESULT_BEAM_INTEGRATE_STRESSES_AND_FORCES_FROM_LISTED_INCLUDE_OBJECTS: MemberRepresentative.ResultBeamIntegrateStressesAndForces
    RESULT_BEAM_INTEGRATE_STRESSES_AND_FORCES_WITHIN_CUBOID_GENERAL: MemberRepresentative.ResultBeamIntegrateStressesAndForces
    RESULT_BEAM_INTEGRATE_STRESSES_AND_FORCES_WITHIN_CYLINDER: MemberRepresentative.ResultBeamIntegrateStressesAndForces
    class SectionAlignment(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
        __slots__ = ()
        SECTION_ALIGNMENT_TOP: _ClassVar[MemberRepresentative.SectionAlignment]
        SECTION_ALIGNMENT_BOTTOM: _ClassVar[MemberRepresentative.SectionAlignment]
        SECTION_ALIGNMENT_CENTRIC: _ClassVar[MemberRepresentative.SectionAlignment]
    SECTION_ALIGNMENT_TOP: MemberRepresentative.SectionAlignment
    SECTION_ALIGNMENT_BOTTOM: MemberRepresentative.SectionAlignment
    SECTION_ALIGNMENT_CENTRIC: MemberRepresentative.SectionAlignment
    class GrainAlignment(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
        __slots__ = ()
        GRAIN_ALIGNMENT_TOP: _ClassVar[MemberRepresentative.GrainAlignment]
        GRAIN_ALIGNMENT_BOTTOM: _ClassVar[MemberRepresentative.GrainAlignment]
        GRAIN_ALIGNMENT_CENTRIC: _ClassVar[MemberRepresentative.GrainAlignment]
    GRAIN_ALIGNMENT_TOP: MemberRepresentative.GrainAlignment
    GRAIN_ALIGNMENT_BOTTOM: MemberRepresentative.GrainAlignment
    GRAIN_ALIGNMENT_CENTRIC: MemberRepresentative.GrainAlignment
    class CurvedMemberCantileversType(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
        __slots__ = ()
        CURVED_MEMBER_CANTILEVERS_TYPE_HORIZONTAL: _ClassVar[MemberRepresentative.CurvedMemberCantileversType]
        CURVED_MEMBER_CANTILEVERS_TYPE_OFFSET: _ClassVar[MemberRepresentative.CurvedMemberCantileversType]
        CURVED_MEMBER_CANTILEVERS_TYPE_PARALLEL: _ClassVar[MemberRepresentative.CurvedMemberCantileversType]
        CURVED_MEMBER_CANTILEVERS_TYPE_TAPER: _ClassVar[MemberRepresentative.CurvedMemberCantileversType]
    CURVED_MEMBER_CANTILEVERS_TYPE_HORIZONTAL: MemberRepresentative.CurvedMemberCantileversType
    CURVED_MEMBER_CANTILEVERS_TYPE_OFFSET: MemberRepresentative.CurvedMemberCantileversType
    CURVED_MEMBER_CANTILEVERS_TYPE_PARALLEL: MemberRepresentative.CurvedMemberCantileversType
    CURVED_MEMBER_CANTILEVERS_TYPE_TAPER: MemberRepresentative.CurvedMemberCantileversType
    class RotationSpecificationType(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
        __slots__ = ()
        ROTATION_SPECIFICATION_TYPE_BY_ANGLE: _ClassVar[MemberRepresentative.RotationSpecificationType]
        ROTATION_SPECIFICATION_TYPE_INSIDE: _ClassVar[MemberRepresentative.RotationSpecificationType]
        ROTATION_SPECIFICATION_TYPE_SURFACE: _ClassVar[MemberRepresentative.RotationSpecificationType]
        ROTATION_SPECIFICATION_TYPE_TO_NODE: _ClassVar[MemberRepresentative.RotationSpecificationType]
    ROTATION_SPECIFICATION_TYPE_BY_ANGLE: MemberRepresentative.RotationSpecificationType
    ROTATION_SPECIFICATION_TYPE_INSIDE: MemberRepresentative.RotationSpecificationType
    ROTATION_SPECIFICATION_TYPE_SURFACE: MemberRepresentative.RotationSpecificationType
    ROTATION_SPECIFICATION_TYPE_TO_NODE: MemberRepresentative.RotationSpecificationType
    class RotationPlaneType(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
        __slots__ = ()
        ROTATION_PLANE_TYPE_ROTATION_PLANE_XY: _ClassVar[MemberRepresentative.RotationPlaneType]
        ROTATION_PLANE_TYPE_ROTATION_PLANE_XZ: _ClassVar[MemberRepresentative.RotationPlaneType]
    ROTATION_PLANE_TYPE_ROTATION_PLANE_XY: MemberRepresentative.RotationPlaneType
    ROTATION_PLANE_TYPE_ROTATION_PLANE_XZ: MemberRepresentative.RotationPlaneType
    class RotationSurfacePlaneType(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
        __slots__ = ()
        ROTATION_SURFACE_PLANE_TYPE_ROTATION_PLANE_XY: _ClassVar[MemberRepresentative.RotationSurfacePlaneType]
        ROTATION_SURFACE_PLANE_TYPE_ROTATION_PLANE_XZ: _ClassVar[MemberRepresentative.RotationSurfacePlaneType]
    ROTATION_SURFACE_PLANE_TYPE_ROTATION_PLANE_XY: MemberRepresentative.RotationSurfacePlaneType
    ROTATION_SURFACE_PLANE_TYPE_ROTATION_PLANE_XZ: MemberRepresentative.RotationSurfacePlaneType
    class DeflectionCheckDirection(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
        __slots__ = ()
        DEFLECTION_CHECK_DIRECTION_LOCAL_AXIS_Z: _ClassVar[MemberRepresentative.DeflectionCheckDirection]
        DEFLECTION_CHECK_DIRECTION_AUXILIARY_LOCAL_AXIS_Y: _ClassVar[MemberRepresentative.DeflectionCheckDirection]
        DEFLECTION_CHECK_DIRECTION_AUXILIARY_LOCAL_AXIS_Z: _ClassVar[MemberRepresentative.DeflectionCheckDirection]
        DEFLECTION_CHECK_DIRECTION_AUXILIARY_LOCAL_AXIS_Z_AND_Y: _ClassVar[MemberRepresentative.DeflectionCheckDirection]
        DEFLECTION_CHECK_DIRECTION_LOCAL_AXIS_Y: _ClassVar[MemberRepresentative.DeflectionCheckDirection]
        DEFLECTION_CHECK_DIRECTION_LOCAL_AXIS_Z_AND_Y: _ClassVar[MemberRepresentative.DeflectionCheckDirection]
        DEFLECTION_CHECK_DIRECTION_RESULTING_AXIS: _ClassVar[MemberRepresentative.DeflectionCheckDirection]
    DEFLECTION_CHECK_DIRECTION_LOCAL_AXIS_Z: MemberRepresentative.DeflectionCheckDirection
    DEFLECTION_CHECK_DIRECTION_AUXILIARY_LOCAL_AXIS_Y: MemberRepresentative.DeflectionCheckDirection
    DEFLECTION_CHECK_DIRECTION_AUXILIARY_LOCAL_AXIS_Z: MemberRepresentative.DeflectionCheckDirection
    DEFLECTION_CHECK_DIRECTION_AUXILIARY_LOCAL_AXIS_Z_AND_Y: MemberRepresentative.DeflectionCheckDirection
    DEFLECTION_CHECK_DIRECTION_LOCAL_AXIS_Y: MemberRepresentative.DeflectionCheckDirection
    DEFLECTION_CHECK_DIRECTION_LOCAL_AXIS_Z_AND_Y: MemberRepresentative.DeflectionCheckDirection
    DEFLECTION_CHECK_DIRECTION_RESULTING_AXIS: MemberRepresentative.DeflectionCheckDirection
    class DeflectionCheckDisplacementReference(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
        __slots__ = ()
        DEFLECTION_CHECK_DISPLACEMENT_REFERENCE_DEFORMED_SEGMENT_ENDS: _ClassVar[MemberRepresentative.DeflectionCheckDisplacementReference]
        DEFLECTION_CHECK_DISPLACEMENT_REFERENCE_DEFORMED_UNDEFORMED_SYSTEM: _ClassVar[MemberRepresentative.DeflectionCheckDisplacementReference]
    DEFLECTION_CHECK_DISPLACEMENT_REFERENCE_DEFORMED_SEGMENT_ENDS: MemberRepresentative.DeflectionCheckDisplacementReference
    DEFLECTION_CHECK_DISPLACEMENT_REFERENCE_DEFORMED_UNDEFORMED_SYSTEM: MemberRepresentative.DeflectionCheckDisplacementReference
    class FlangeDimensionsTable(_message.Message):
        __slots__ = ("rows",)
        ROWS_FIELD_NUMBER: _ClassVar[int]
        rows: _containers.RepeatedCompositeFieldContainer[MemberRepresentative.FlangeDimensionsRow]
        def __init__(self, rows: _Optional[_Iterable[_Union[MemberRepresentative.FlangeDimensionsRow, _Mapping]]] = ...) -> None: ...
    class FlangeDimensionsRow(_message.Message):
        __slots__ = ("no", "description", "end_ordinate", "length", "reference_length_definition_type", "reference_length", "reference_length_width", "width_minus_y_integrative", "width_minus_y_effictive", "width_minus_y_maximal", "width_plus_y_integrative", "width_plus_y_effictive", "width_plus_y_maximal", "distribution_linearity")
        class ReferenceLengthDefinitionType(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            REFERENCE_LENGTH_DEFINITION_TYPE_REFERENCE_LENGTH_TYPE_SEGMENT_LENGTH: _ClassVar[MemberRepresentative.FlangeDimensionsRow.ReferenceLengthDefinitionType]
            REFERENCE_LENGTH_DEFINITION_TYPE_REFERENCE_LENGTH_TYPE_MEMBER_LENGTH: _ClassVar[MemberRepresentative.FlangeDimensionsRow.ReferenceLengthDefinitionType]
            REFERENCE_LENGTH_DEFINITION_TYPE_REFERENCE_LENGTH_TYPE_USER_DEFINED: _ClassVar[MemberRepresentative.FlangeDimensionsRow.ReferenceLengthDefinitionType]
        REFERENCE_LENGTH_DEFINITION_TYPE_REFERENCE_LENGTH_TYPE_SEGMENT_LENGTH: MemberRepresentative.FlangeDimensionsRow.ReferenceLengthDefinitionType
        REFERENCE_LENGTH_DEFINITION_TYPE_REFERENCE_LENGTH_TYPE_MEMBER_LENGTH: MemberRepresentative.FlangeDimensionsRow.ReferenceLengthDefinitionType
        REFERENCE_LENGTH_DEFINITION_TYPE_REFERENCE_LENGTH_TYPE_USER_DEFINED: MemberRepresentative.FlangeDimensionsRow.ReferenceLengthDefinitionType
        class ReferenceLengthWidth(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            REFERENCE_LENGTH_WIDTH_NONE: _ClassVar[MemberRepresentative.FlangeDimensionsRow.ReferenceLengthWidth]
            REFERENCE_LENGTH_WIDTH_EC2: _ClassVar[MemberRepresentative.FlangeDimensionsRow.ReferenceLengthWidth]
            REFERENCE_LENGTH_WIDTH_EIGHTH: _ClassVar[MemberRepresentative.FlangeDimensionsRow.ReferenceLengthWidth]
            REFERENCE_LENGTH_WIDTH_SIXTH: _ClassVar[MemberRepresentative.FlangeDimensionsRow.ReferenceLengthWidth]
        REFERENCE_LENGTH_WIDTH_NONE: MemberRepresentative.FlangeDimensionsRow.ReferenceLengthWidth
        REFERENCE_LENGTH_WIDTH_EC2: MemberRepresentative.FlangeDimensionsRow.ReferenceLengthWidth
        REFERENCE_LENGTH_WIDTH_EIGHTH: MemberRepresentative.FlangeDimensionsRow.ReferenceLengthWidth
        REFERENCE_LENGTH_WIDTH_SIXTH: MemberRepresentative.FlangeDimensionsRow.ReferenceLengthWidth
        class DistributionLinearity(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            DISTRIBUTION_LINEARITY_SEGMENT_LINEARITY_NONE: _ClassVar[MemberRepresentative.FlangeDimensionsRow.DistributionLinearity]
            DISTRIBUTION_LINEARITY_SEGMENT_LINEARITY_FROM_START: _ClassVar[MemberRepresentative.FlangeDimensionsRow.DistributionLinearity]
            DISTRIBUTION_LINEARITY_SEGMENT_LINEARITY_TO_END: _ClassVar[MemberRepresentative.FlangeDimensionsRow.DistributionLinearity]
        DISTRIBUTION_LINEARITY_SEGMENT_LINEARITY_NONE: MemberRepresentative.FlangeDimensionsRow.DistributionLinearity
        DISTRIBUTION_LINEARITY_SEGMENT_LINEARITY_FROM_START: MemberRepresentative.FlangeDimensionsRow.DistributionLinearity
        DISTRIBUTION_LINEARITY_SEGMENT_LINEARITY_TO_END: MemberRepresentative.FlangeDimensionsRow.DistributionLinearity
        NO_FIELD_NUMBER: _ClassVar[int]
        DESCRIPTION_FIELD_NUMBER: _ClassVar[int]
        END_ORDINATE_FIELD_NUMBER: _ClassVar[int]
        LENGTH_FIELD_NUMBER: _ClassVar[int]
        REFERENCE_LENGTH_DEFINITION_TYPE_FIELD_NUMBER: _ClassVar[int]
        REFERENCE_LENGTH_FIELD_NUMBER: _ClassVar[int]
        REFERENCE_LENGTH_WIDTH_FIELD_NUMBER: _ClassVar[int]
        WIDTH_MINUS_Y_INTEGRATIVE_FIELD_NUMBER: _ClassVar[int]
        WIDTH_MINUS_Y_EFFICTIVE_FIELD_NUMBER: _ClassVar[int]
        WIDTH_MINUS_Y_MAXIMAL_FIELD_NUMBER: _ClassVar[int]
        WIDTH_PLUS_Y_INTEGRATIVE_FIELD_NUMBER: _ClassVar[int]
        WIDTH_PLUS_Y_EFFICTIVE_FIELD_NUMBER: _ClassVar[int]
        WIDTH_PLUS_Y_MAXIMAL_FIELD_NUMBER: _ClassVar[int]
        DISTRIBUTION_LINEARITY_FIELD_NUMBER: _ClassVar[int]
        no: int
        description: str
        end_ordinate: float
        length: float
        reference_length_definition_type: MemberRepresentative.FlangeDimensionsRow.ReferenceLengthDefinitionType
        reference_length: float
        reference_length_width: MemberRepresentative.FlangeDimensionsRow.ReferenceLengthWidth
        width_minus_y_integrative: float
        width_minus_y_effictive: float
        width_minus_y_maximal: float
        width_plus_y_integrative: float
        width_plus_y_effictive: float
        width_plus_y_maximal: float
        distribution_linearity: MemberRepresentative.FlangeDimensionsRow.DistributionLinearity
        def __init__(self, no: _Optional[int] = ..., description: _Optional[str] = ..., end_ordinate: _Optional[float] = ..., length: _Optional[float] = ..., reference_length_definition_type: _Optional[_Union[MemberRepresentative.FlangeDimensionsRow.ReferenceLengthDefinitionType, str]] = ..., reference_length: _Optional[float] = ..., reference_length_width: _Optional[_Union[MemberRepresentative.FlangeDimensionsRow.ReferenceLengthWidth, str]] = ..., width_minus_y_integrative: _Optional[float] = ..., width_minus_y_effictive: _Optional[float] = ..., width_minus_y_maximal: _Optional[float] = ..., width_plus_y_integrative: _Optional[float] = ..., width_plus_y_effictive: _Optional[float] = ..., width_plus_y_maximal: _Optional[float] = ..., distribution_linearity: _Optional[_Union[MemberRepresentative.FlangeDimensionsRow.DistributionLinearity, str]] = ...) -> None: ...
    class CurvedMemberParametersTreeTable(_message.Message):
        __slots__ = ("rows",)
        ROWS_FIELD_NUMBER: _ClassVar[int]
        rows: _containers.RepeatedCompositeFieldContainer[MemberRepresentative.CurvedMemberParametersTreeTableRow]
        def __init__(self, rows: _Optional[_Iterable[_Union[MemberRepresentative.CurvedMemberParametersTreeTableRow, _Mapping]]] = ...) -> None: ...
    class CurvedMemberParametersTreeTableRow(_message.Message):
        __slots__ = ("key", "caption", "symbol", "value", "unit", "note", "rows")
        KEY_FIELD_NUMBER: _ClassVar[int]
        CAPTION_FIELD_NUMBER: _ClassVar[int]
        SYMBOL_FIELD_NUMBER: _ClassVar[int]
        VALUE_FIELD_NUMBER: _ClassVar[int]
        UNIT_FIELD_NUMBER: _ClassVar[int]
        NOTE_FIELD_NUMBER: _ClassVar[int]
        ROWS_FIELD_NUMBER: _ClassVar[int]
        key: str
        caption: str
        symbol: str
        value: float
        unit: str
        note: str
        rows: _containers.RepeatedCompositeFieldContainer[MemberRepresentative.CurvedMemberParametersTreeTableRow]
        def __init__(self, key: _Optional[str] = ..., caption: _Optional[str] = ..., symbol: _Optional[str] = ..., value: _Optional[float] = ..., unit: _Optional[str] = ..., note: _Optional[str] = ..., rows: _Optional[_Iterable[_Union[MemberRepresentative.CurvedMemberParametersTreeTableRow, _Mapping]]] = ...) -> None: ...
    class ConcreteShearReinforcementSpansTable(_message.Message):
        __slots__ = ("rows",)
        ROWS_FIELD_NUMBER: _ClassVar[int]
        rows: _containers.RepeatedCompositeFieldContainer[MemberRepresentative.ConcreteShearReinforcementSpansRow]
        def __init__(self, rows: _Optional[_Iterable[_Union[MemberRepresentative.ConcreteShearReinforcementSpansRow, _Mapping]]] = ...) -> None: ...
    class ConcreteShearReinforcementSpansRow(_message.Message):
        __slots__ = ("no", "description", "name", "stirrup_type", "material", "stirrup_count", "stirrup_bar_size", "stirrup_bar_size_calculated", "stirrup_diameter", "stirrup_diameter_calculated", "stirrup_diameter_auto_enabled", "stirrup_bar_size_auto_minimum", "stirrup_diameter_auto_minimum", "stirrup_bar_size_auto_maximum", "stirrup_diameter_auto_maximum", "stirrup_diameter_auto_diameters_enabled", "stirrup_diameter_auto_bar_sizes", "stirrup_diameter_auto_diameters", "stirrup_diameter_auto_priority", "stirrup_distances", "stirrup_distances_calculated", "stirrup_distances_auto_enabled", "stirrup_distances_auto_minimum", "stirrup_distances_auto_maximum", "stirrup_distances_auto_increment", "stirrup_distances_auto_priority", "crossties_active", "crossties_diameter", "reinforcement_area", "horizontal_crosstie_reinforcement_area", "minimal_maximal_horizontal_crosstie_reinforcement_area", "vertical_crosstie_reinforcement_area", "minimal_maximal_vertical_crosstie_reinforcement_area", "total_horizontal_reinforcement_area", "minimal_maximal_total_horizontal_reinforcement_area", "total_vertical_reinforcement_area", "minimal_maximal_total_vertical_reinforcement_area", "span_position_reference_type", "span_position_reference_internal_node", "span_position_reference_x_location_relative", "span_position_reference_x_location_absolute", "span_position_definition_format", "span_start_relative", "span_start_absolute", "span_start_auto_enabled", "span_start_relative_auto_calculated", "span_start_relative_auto_minimum", "span_start_relative_auto_maximum", "span_start_absolute_auto_calculated", "span_start_absolute_auto_minimum", "span_start_absolute_auto_maximum", "span_end_relative", "span_end_absolute", "span_end_auto_enabled", "span_end_relative_auto_calculated", "span_end_relative_auto_minimum", "span_end_relative_auto_maximum", "span_end_absolute_auto_calculated", "span_end_absolute_auto_minimum", "span_end_absolute_auto_maximum", "span_location_auto_increment", "span_location_auto_priority", "span_length", "stirrup_layout_rule", "stirrup_start_offset", "stirrup_end_offset", "one_stirrup_length", "minimal_and_maximal_stirrup_length", "all_stirrups_length", "one_stirrup_weight", "minimal_and_maximal_stirrup_weight", "all_stirrups_weight", "one_crosstie_length", "minimal_and_maximal_crosstie_length", "all_crossties_lenght", "one_crosstie_weight", "minimal_and_maximal_crosstie_weight", "all_crossties_weight")
        class StirrupType(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            STIRRUP_TYPE_TWO_LEGGED_CLOSED_HOOK_135: _ClassVar[MemberRepresentative.ConcreteShearReinforcementSpansRow.StirrupType]
            STIRRUP_TYPE_FOUR_LEGGED_CLOSED_HOOK_135: _ClassVar[MemberRepresentative.ConcreteShearReinforcementSpansRow.StirrupType]
            STIRRUP_TYPE_FOUR_LEGGED_CLOSED_HOOK_90: _ClassVar[MemberRepresentative.ConcreteShearReinforcementSpansRow.StirrupType]
            STIRRUP_TYPE_FOUR_LEGGED_OVERLAP_HOOK_180: _ClassVar[MemberRepresentative.ConcreteShearReinforcementSpansRow.StirrupType]
            STIRRUP_TYPE_THREE_LEGGED_CLOSED_HOOK_135: _ClassVar[MemberRepresentative.ConcreteShearReinforcementSpansRow.StirrupType]
            STIRRUP_TYPE_THREE_LEGGED_CLOSED_HOOK_90: _ClassVar[MemberRepresentative.ConcreteShearReinforcementSpansRow.StirrupType]
            STIRRUP_TYPE_THREE_LEGGED_OVERLAP_HOOK_180: _ClassVar[MemberRepresentative.ConcreteShearReinforcementSpansRow.StirrupType]
            STIRRUP_TYPE_TWO_LEGGED_CLOSED_HOOK_90: _ClassVar[MemberRepresentative.ConcreteShearReinforcementSpansRow.StirrupType]
            STIRRUP_TYPE_TWO_LEGGED_OPEN: _ClassVar[MemberRepresentative.ConcreteShearReinforcementSpansRow.StirrupType]
            STIRRUP_TYPE_TWO_LEGGED_OVERLAP_HOOK_180: _ClassVar[MemberRepresentative.ConcreteShearReinforcementSpansRow.StirrupType]
        STIRRUP_TYPE_TWO_LEGGED_CLOSED_HOOK_135: MemberRepresentative.ConcreteShearReinforcementSpansRow.StirrupType
        STIRRUP_TYPE_FOUR_LEGGED_CLOSED_HOOK_135: MemberRepresentative.ConcreteShearReinforcementSpansRow.StirrupType
        STIRRUP_TYPE_FOUR_LEGGED_CLOSED_HOOK_90: MemberRepresentative.ConcreteShearReinforcementSpansRow.StirrupType
        STIRRUP_TYPE_FOUR_LEGGED_OVERLAP_HOOK_180: MemberRepresentative.ConcreteShearReinforcementSpansRow.StirrupType
        STIRRUP_TYPE_THREE_LEGGED_CLOSED_HOOK_135: MemberRepresentative.ConcreteShearReinforcementSpansRow.StirrupType
        STIRRUP_TYPE_THREE_LEGGED_CLOSED_HOOK_90: MemberRepresentative.ConcreteShearReinforcementSpansRow.StirrupType
        STIRRUP_TYPE_THREE_LEGGED_OVERLAP_HOOK_180: MemberRepresentative.ConcreteShearReinforcementSpansRow.StirrupType
        STIRRUP_TYPE_TWO_LEGGED_CLOSED_HOOK_90: MemberRepresentative.ConcreteShearReinforcementSpansRow.StirrupType
        STIRRUP_TYPE_TWO_LEGGED_OPEN: MemberRepresentative.ConcreteShearReinforcementSpansRow.StirrupType
        STIRRUP_TYPE_TWO_LEGGED_OVERLAP_HOOK_180: MemberRepresentative.ConcreteShearReinforcementSpansRow.StirrupType
        class StirrupBarSizeCalculated(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            STIRRUP_BAR_SIZE_CALCULATED_UNKNOWN: _ClassVar[MemberRepresentative.ConcreteShearReinforcementSpansRow.StirrupBarSizeCalculated]
            STIRRUP_BAR_SIZE_CALCULATED_ACI_1: _ClassVar[MemberRepresentative.ConcreteShearReinforcementSpansRow.StirrupBarSizeCalculated]
            STIRRUP_BAR_SIZE_CALCULATED_ACI_10: _ClassVar[MemberRepresentative.ConcreteShearReinforcementSpansRow.StirrupBarSizeCalculated]
            STIRRUP_BAR_SIZE_CALCULATED_ACI_11: _ClassVar[MemberRepresentative.ConcreteShearReinforcementSpansRow.StirrupBarSizeCalculated]
            STIRRUP_BAR_SIZE_CALCULATED_ACI_12: _ClassVar[MemberRepresentative.ConcreteShearReinforcementSpansRow.StirrupBarSizeCalculated]
            STIRRUP_BAR_SIZE_CALCULATED_ACI_14: _ClassVar[MemberRepresentative.ConcreteShearReinforcementSpansRow.StirrupBarSizeCalculated]
            STIRRUP_BAR_SIZE_CALCULATED_ACI_16: _ClassVar[MemberRepresentative.ConcreteShearReinforcementSpansRow.StirrupBarSizeCalculated]
            STIRRUP_BAR_SIZE_CALCULATED_ACI_18: _ClassVar[MemberRepresentative.ConcreteShearReinforcementSpansRow.StirrupBarSizeCalculated]
            STIRRUP_BAR_SIZE_CALCULATED_ACI_1p5: _ClassVar[MemberRepresentative.ConcreteShearReinforcementSpansRow.StirrupBarSizeCalculated]
            STIRRUP_BAR_SIZE_CALCULATED_ACI_2: _ClassVar[MemberRepresentative.ConcreteShearReinforcementSpansRow.StirrupBarSizeCalculated]
            STIRRUP_BAR_SIZE_CALCULATED_ACI_2p5: _ClassVar[MemberRepresentative.ConcreteShearReinforcementSpansRow.StirrupBarSizeCalculated]
            STIRRUP_BAR_SIZE_CALCULATED_ACI_3: _ClassVar[MemberRepresentative.ConcreteShearReinforcementSpansRow.StirrupBarSizeCalculated]
            STIRRUP_BAR_SIZE_CALCULATED_ACI_4: _ClassVar[MemberRepresentative.ConcreteShearReinforcementSpansRow.StirrupBarSizeCalculated]
            STIRRUP_BAR_SIZE_CALCULATED_ACI_5: _ClassVar[MemberRepresentative.ConcreteShearReinforcementSpansRow.StirrupBarSizeCalculated]
            STIRRUP_BAR_SIZE_CALCULATED_ACI_6: _ClassVar[MemberRepresentative.ConcreteShearReinforcementSpansRow.StirrupBarSizeCalculated]
            STIRRUP_BAR_SIZE_CALCULATED_ACI_7: _ClassVar[MemberRepresentative.ConcreteShearReinforcementSpansRow.StirrupBarSizeCalculated]
            STIRRUP_BAR_SIZE_CALCULATED_ACI_8: _ClassVar[MemberRepresentative.ConcreteShearReinforcementSpansRow.StirrupBarSizeCalculated]
            STIRRUP_BAR_SIZE_CALCULATED_ACI_9: _ClassVar[MemberRepresentative.ConcreteShearReinforcementSpansRow.StirrupBarSizeCalculated]
            STIRRUP_BAR_SIZE_CALCULATED_CSA_10: _ClassVar[MemberRepresentative.ConcreteShearReinforcementSpansRow.StirrupBarSizeCalculated]
            STIRRUP_BAR_SIZE_CALCULATED_CSA_15: _ClassVar[MemberRepresentative.ConcreteShearReinforcementSpansRow.StirrupBarSizeCalculated]
            STIRRUP_BAR_SIZE_CALCULATED_CSA_20: _ClassVar[MemberRepresentative.ConcreteShearReinforcementSpansRow.StirrupBarSizeCalculated]
            STIRRUP_BAR_SIZE_CALCULATED_CSA_25: _ClassVar[MemberRepresentative.ConcreteShearReinforcementSpansRow.StirrupBarSizeCalculated]
            STIRRUP_BAR_SIZE_CALCULATED_CSA_30: _ClassVar[MemberRepresentative.ConcreteShearReinforcementSpansRow.StirrupBarSizeCalculated]
            STIRRUP_BAR_SIZE_CALCULATED_CSA_35: _ClassVar[MemberRepresentative.ConcreteShearReinforcementSpansRow.StirrupBarSizeCalculated]
            STIRRUP_BAR_SIZE_CALCULATED_CSA_45: _ClassVar[MemberRepresentative.ConcreteShearReinforcementSpansRow.StirrupBarSizeCalculated]
            STIRRUP_BAR_SIZE_CALCULATED_CSA_55: _ClassVar[MemberRepresentative.ConcreteShearReinforcementSpansRow.StirrupBarSizeCalculated]
        STIRRUP_BAR_SIZE_CALCULATED_UNKNOWN: MemberRepresentative.ConcreteShearReinforcementSpansRow.StirrupBarSizeCalculated
        STIRRUP_BAR_SIZE_CALCULATED_ACI_1: MemberRepresentative.ConcreteShearReinforcementSpansRow.StirrupBarSizeCalculated
        STIRRUP_BAR_SIZE_CALCULATED_ACI_10: MemberRepresentative.ConcreteShearReinforcementSpansRow.StirrupBarSizeCalculated
        STIRRUP_BAR_SIZE_CALCULATED_ACI_11: MemberRepresentative.ConcreteShearReinforcementSpansRow.StirrupBarSizeCalculated
        STIRRUP_BAR_SIZE_CALCULATED_ACI_12: MemberRepresentative.ConcreteShearReinforcementSpansRow.StirrupBarSizeCalculated
        STIRRUP_BAR_SIZE_CALCULATED_ACI_14: MemberRepresentative.ConcreteShearReinforcementSpansRow.StirrupBarSizeCalculated
        STIRRUP_BAR_SIZE_CALCULATED_ACI_16: MemberRepresentative.ConcreteShearReinforcementSpansRow.StirrupBarSizeCalculated
        STIRRUP_BAR_SIZE_CALCULATED_ACI_18: MemberRepresentative.ConcreteShearReinforcementSpansRow.StirrupBarSizeCalculated
        STIRRUP_BAR_SIZE_CALCULATED_ACI_1p5: MemberRepresentative.ConcreteShearReinforcementSpansRow.StirrupBarSizeCalculated
        STIRRUP_BAR_SIZE_CALCULATED_ACI_2: MemberRepresentative.ConcreteShearReinforcementSpansRow.StirrupBarSizeCalculated
        STIRRUP_BAR_SIZE_CALCULATED_ACI_2p5: MemberRepresentative.ConcreteShearReinforcementSpansRow.StirrupBarSizeCalculated
        STIRRUP_BAR_SIZE_CALCULATED_ACI_3: MemberRepresentative.ConcreteShearReinforcementSpansRow.StirrupBarSizeCalculated
        STIRRUP_BAR_SIZE_CALCULATED_ACI_4: MemberRepresentative.ConcreteShearReinforcementSpansRow.StirrupBarSizeCalculated
        STIRRUP_BAR_SIZE_CALCULATED_ACI_5: MemberRepresentative.ConcreteShearReinforcementSpansRow.StirrupBarSizeCalculated
        STIRRUP_BAR_SIZE_CALCULATED_ACI_6: MemberRepresentative.ConcreteShearReinforcementSpansRow.StirrupBarSizeCalculated
        STIRRUP_BAR_SIZE_CALCULATED_ACI_7: MemberRepresentative.ConcreteShearReinforcementSpansRow.StirrupBarSizeCalculated
        STIRRUP_BAR_SIZE_CALCULATED_ACI_8: MemberRepresentative.ConcreteShearReinforcementSpansRow.StirrupBarSizeCalculated
        STIRRUP_BAR_SIZE_CALCULATED_ACI_9: MemberRepresentative.ConcreteShearReinforcementSpansRow.StirrupBarSizeCalculated
        STIRRUP_BAR_SIZE_CALCULATED_CSA_10: MemberRepresentative.ConcreteShearReinforcementSpansRow.StirrupBarSizeCalculated
        STIRRUP_BAR_SIZE_CALCULATED_CSA_15: MemberRepresentative.ConcreteShearReinforcementSpansRow.StirrupBarSizeCalculated
        STIRRUP_BAR_SIZE_CALCULATED_CSA_20: MemberRepresentative.ConcreteShearReinforcementSpansRow.StirrupBarSizeCalculated
        STIRRUP_BAR_SIZE_CALCULATED_CSA_25: MemberRepresentative.ConcreteShearReinforcementSpansRow.StirrupBarSizeCalculated
        STIRRUP_BAR_SIZE_CALCULATED_CSA_30: MemberRepresentative.ConcreteShearReinforcementSpansRow.StirrupBarSizeCalculated
        STIRRUP_BAR_SIZE_CALCULATED_CSA_35: MemberRepresentative.ConcreteShearReinforcementSpansRow.StirrupBarSizeCalculated
        STIRRUP_BAR_SIZE_CALCULATED_CSA_45: MemberRepresentative.ConcreteShearReinforcementSpansRow.StirrupBarSizeCalculated
        STIRRUP_BAR_SIZE_CALCULATED_CSA_55: MemberRepresentative.ConcreteShearReinforcementSpansRow.StirrupBarSizeCalculated
        class StirrupBarSizeAutoMinimum(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            STIRRUP_BAR_SIZE_AUTO_MINIMUM_UNKNOWN: _ClassVar[MemberRepresentative.ConcreteShearReinforcementSpansRow.StirrupBarSizeAutoMinimum]
        STIRRUP_BAR_SIZE_AUTO_MINIMUM_UNKNOWN: MemberRepresentative.ConcreteShearReinforcementSpansRow.StirrupBarSizeAutoMinimum
        class StirrupBarSizeAutoMaximum(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            STIRRUP_BAR_SIZE_AUTO_MAXIMUM_UNKNOWN: _ClassVar[MemberRepresentative.ConcreteShearReinforcementSpansRow.StirrupBarSizeAutoMaximum]
        STIRRUP_BAR_SIZE_AUTO_MAXIMUM_UNKNOWN: MemberRepresentative.ConcreteShearReinforcementSpansRow.StirrupBarSizeAutoMaximum
        class StirrupDiameterAutoBarSizes(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            STIRRUP_DIAMETER_AUTO_BAR_SIZES_UNKNOWN: _ClassVar[MemberRepresentative.ConcreteShearReinforcementSpansRow.StirrupDiameterAutoBarSizes]
            STIRRUP_DIAMETER_AUTO_BAR_SIZES_ACI_1: _ClassVar[MemberRepresentative.ConcreteShearReinforcementSpansRow.StirrupDiameterAutoBarSizes]
            STIRRUP_DIAMETER_AUTO_BAR_SIZES_ACI_10: _ClassVar[MemberRepresentative.ConcreteShearReinforcementSpansRow.StirrupDiameterAutoBarSizes]
            STIRRUP_DIAMETER_AUTO_BAR_SIZES_ACI_11: _ClassVar[MemberRepresentative.ConcreteShearReinforcementSpansRow.StirrupDiameterAutoBarSizes]
            STIRRUP_DIAMETER_AUTO_BAR_SIZES_ACI_12: _ClassVar[MemberRepresentative.ConcreteShearReinforcementSpansRow.StirrupDiameterAutoBarSizes]
            STIRRUP_DIAMETER_AUTO_BAR_SIZES_ACI_14: _ClassVar[MemberRepresentative.ConcreteShearReinforcementSpansRow.StirrupDiameterAutoBarSizes]
            STIRRUP_DIAMETER_AUTO_BAR_SIZES_ACI_16: _ClassVar[MemberRepresentative.ConcreteShearReinforcementSpansRow.StirrupDiameterAutoBarSizes]
            STIRRUP_DIAMETER_AUTO_BAR_SIZES_ACI_18: _ClassVar[MemberRepresentative.ConcreteShearReinforcementSpansRow.StirrupDiameterAutoBarSizes]
            STIRRUP_DIAMETER_AUTO_BAR_SIZES_ACI_1p5: _ClassVar[MemberRepresentative.ConcreteShearReinforcementSpansRow.StirrupDiameterAutoBarSizes]
            STIRRUP_DIAMETER_AUTO_BAR_SIZES_ACI_2: _ClassVar[MemberRepresentative.ConcreteShearReinforcementSpansRow.StirrupDiameterAutoBarSizes]
            STIRRUP_DIAMETER_AUTO_BAR_SIZES_ACI_2p5: _ClassVar[MemberRepresentative.ConcreteShearReinforcementSpansRow.StirrupDiameterAutoBarSizes]
            STIRRUP_DIAMETER_AUTO_BAR_SIZES_ACI_3: _ClassVar[MemberRepresentative.ConcreteShearReinforcementSpansRow.StirrupDiameterAutoBarSizes]
            STIRRUP_DIAMETER_AUTO_BAR_SIZES_ACI_4: _ClassVar[MemberRepresentative.ConcreteShearReinforcementSpansRow.StirrupDiameterAutoBarSizes]
            STIRRUP_DIAMETER_AUTO_BAR_SIZES_ACI_5: _ClassVar[MemberRepresentative.ConcreteShearReinforcementSpansRow.StirrupDiameterAutoBarSizes]
            STIRRUP_DIAMETER_AUTO_BAR_SIZES_ACI_6: _ClassVar[MemberRepresentative.ConcreteShearReinforcementSpansRow.StirrupDiameterAutoBarSizes]
            STIRRUP_DIAMETER_AUTO_BAR_SIZES_ACI_7: _ClassVar[MemberRepresentative.ConcreteShearReinforcementSpansRow.StirrupDiameterAutoBarSizes]
            STIRRUP_DIAMETER_AUTO_BAR_SIZES_ACI_8: _ClassVar[MemberRepresentative.ConcreteShearReinforcementSpansRow.StirrupDiameterAutoBarSizes]
            STIRRUP_DIAMETER_AUTO_BAR_SIZES_ACI_9: _ClassVar[MemberRepresentative.ConcreteShearReinforcementSpansRow.StirrupDiameterAutoBarSizes]
            STIRRUP_DIAMETER_AUTO_BAR_SIZES_CSA_10: _ClassVar[MemberRepresentative.ConcreteShearReinforcementSpansRow.StirrupDiameterAutoBarSizes]
            STIRRUP_DIAMETER_AUTO_BAR_SIZES_CSA_15: _ClassVar[MemberRepresentative.ConcreteShearReinforcementSpansRow.StirrupDiameterAutoBarSizes]
            STIRRUP_DIAMETER_AUTO_BAR_SIZES_CSA_20: _ClassVar[MemberRepresentative.ConcreteShearReinforcementSpansRow.StirrupDiameterAutoBarSizes]
            STIRRUP_DIAMETER_AUTO_BAR_SIZES_CSA_25: _ClassVar[MemberRepresentative.ConcreteShearReinforcementSpansRow.StirrupDiameterAutoBarSizes]
            STIRRUP_DIAMETER_AUTO_BAR_SIZES_CSA_30: _ClassVar[MemberRepresentative.ConcreteShearReinforcementSpansRow.StirrupDiameterAutoBarSizes]
            STIRRUP_DIAMETER_AUTO_BAR_SIZES_CSA_35: _ClassVar[MemberRepresentative.ConcreteShearReinforcementSpansRow.StirrupDiameterAutoBarSizes]
            STIRRUP_DIAMETER_AUTO_BAR_SIZES_CSA_45: _ClassVar[MemberRepresentative.ConcreteShearReinforcementSpansRow.StirrupDiameterAutoBarSizes]
            STIRRUP_DIAMETER_AUTO_BAR_SIZES_CSA_55: _ClassVar[MemberRepresentative.ConcreteShearReinforcementSpansRow.StirrupDiameterAutoBarSizes]
        STIRRUP_DIAMETER_AUTO_BAR_SIZES_UNKNOWN: MemberRepresentative.ConcreteShearReinforcementSpansRow.StirrupDiameterAutoBarSizes
        STIRRUP_DIAMETER_AUTO_BAR_SIZES_ACI_1: MemberRepresentative.ConcreteShearReinforcementSpansRow.StirrupDiameterAutoBarSizes
        STIRRUP_DIAMETER_AUTO_BAR_SIZES_ACI_10: MemberRepresentative.ConcreteShearReinforcementSpansRow.StirrupDiameterAutoBarSizes
        STIRRUP_DIAMETER_AUTO_BAR_SIZES_ACI_11: MemberRepresentative.ConcreteShearReinforcementSpansRow.StirrupDiameterAutoBarSizes
        STIRRUP_DIAMETER_AUTO_BAR_SIZES_ACI_12: MemberRepresentative.ConcreteShearReinforcementSpansRow.StirrupDiameterAutoBarSizes
        STIRRUP_DIAMETER_AUTO_BAR_SIZES_ACI_14: MemberRepresentative.ConcreteShearReinforcementSpansRow.StirrupDiameterAutoBarSizes
        STIRRUP_DIAMETER_AUTO_BAR_SIZES_ACI_16: MemberRepresentative.ConcreteShearReinforcementSpansRow.StirrupDiameterAutoBarSizes
        STIRRUP_DIAMETER_AUTO_BAR_SIZES_ACI_18: MemberRepresentative.ConcreteShearReinforcementSpansRow.StirrupDiameterAutoBarSizes
        STIRRUP_DIAMETER_AUTO_BAR_SIZES_ACI_1p5: MemberRepresentative.ConcreteShearReinforcementSpansRow.StirrupDiameterAutoBarSizes
        STIRRUP_DIAMETER_AUTO_BAR_SIZES_ACI_2: MemberRepresentative.ConcreteShearReinforcementSpansRow.StirrupDiameterAutoBarSizes
        STIRRUP_DIAMETER_AUTO_BAR_SIZES_ACI_2p5: MemberRepresentative.ConcreteShearReinforcementSpansRow.StirrupDiameterAutoBarSizes
        STIRRUP_DIAMETER_AUTO_BAR_SIZES_ACI_3: MemberRepresentative.ConcreteShearReinforcementSpansRow.StirrupDiameterAutoBarSizes
        STIRRUP_DIAMETER_AUTO_BAR_SIZES_ACI_4: MemberRepresentative.ConcreteShearReinforcementSpansRow.StirrupDiameterAutoBarSizes
        STIRRUP_DIAMETER_AUTO_BAR_SIZES_ACI_5: MemberRepresentative.ConcreteShearReinforcementSpansRow.StirrupDiameterAutoBarSizes
        STIRRUP_DIAMETER_AUTO_BAR_SIZES_ACI_6: MemberRepresentative.ConcreteShearReinforcementSpansRow.StirrupDiameterAutoBarSizes
        STIRRUP_DIAMETER_AUTO_BAR_SIZES_ACI_7: MemberRepresentative.ConcreteShearReinforcementSpansRow.StirrupDiameterAutoBarSizes
        STIRRUP_DIAMETER_AUTO_BAR_SIZES_ACI_8: MemberRepresentative.ConcreteShearReinforcementSpansRow.StirrupDiameterAutoBarSizes
        STIRRUP_DIAMETER_AUTO_BAR_SIZES_ACI_9: MemberRepresentative.ConcreteShearReinforcementSpansRow.StirrupDiameterAutoBarSizes
        STIRRUP_DIAMETER_AUTO_BAR_SIZES_CSA_10: MemberRepresentative.ConcreteShearReinforcementSpansRow.StirrupDiameterAutoBarSizes
        STIRRUP_DIAMETER_AUTO_BAR_SIZES_CSA_15: MemberRepresentative.ConcreteShearReinforcementSpansRow.StirrupDiameterAutoBarSizes
        STIRRUP_DIAMETER_AUTO_BAR_SIZES_CSA_20: MemberRepresentative.ConcreteShearReinforcementSpansRow.StirrupDiameterAutoBarSizes
        STIRRUP_DIAMETER_AUTO_BAR_SIZES_CSA_25: MemberRepresentative.ConcreteShearReinforcementSpansRow.StirrupDiameterAutoBarSizes
        STIRRUP_DIAMETER_AUTO_BAR_SIZES_CSA_30: MemberRepresentative.ConcreteShearReinforcementSpansRow.StirrupDiameterAutoBarSizes
        STIRRUP_DIAMETER_AUTO_BAR_SIZES_CSA_35: MemberRepresentative.ConcreteShearReinforcementSpansRow.StirrupDiameterAutoBarSizes
        STIRRUP_DIAMETER_AUTO_BAR_SIZES_CSA_45: MemberRepresentative.ConcreteShearReinforcementSpansRow.StirrupDiameterAutoBarSizes
        STIRRUP_DIAMETER_AUTO_BAR_SIZES_CSA_55: MemberRepresentative.ConcreteShearReinforcementSpansRow.StirrupDiameterAutoBarSizes
        class SpanPositionReferenceType(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            SPAN_POSITION_REFERENCE_TYPE_START: _ClassVar[MemberRepresentative.ConcreteShearReinforcementSpansRow.SpanPositionReferenceType]
            SPAN_POSITION_REFERENCE_TYPE_END: _ClassVar[MemberRepresentative.ConcreteShearReinforcementSpansRow.SpanPositionReferenceType]
            SPAN_POSITION_REFERENCE_TYPE_INTERNAL_NODE: _ClassVar[MemberRepresentative.ConcreteShearReinforcementSpansRow.SpanPositionReferenceType]
            SPAN_POSITION_REFERENCE_TYPE_X_LOCATION: _ClassVar[MemberRepresentative.ConcreteShearReinforcementSpansRow.SpanPositionReferenceType]
        SPAN_POSITION_REFERENCE_TYPE_START: MemberRepresentative.ConcreteShearReinforcementSpansRow.SpanPositionReferenceType
        SPAN_POSITION_REFERENCE_TYPE_END: MemberRepresentative.ConcreteShearReinforcementSpansRow.SpanPositionReferenceType
        SPAN_POSITION_REFERENCE_TYPE_INTERNAL_NODE: MemberRepresentative.ConcreteShearReinforcementSpansRow.SpanPositionReferenceType
        SPAN_POSITION_REFERENCE_TYPE_X_LOCATION: MemberRepresentative.ConcreteShearReinforcementSpansRow.SpanPositionReferenceType
        class SpanPositionDefinitionFormat(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            SPAN_POSITION_DEFINITION_FORMAT_ABSOLUTE: _ClassVar[MemberRepresentative.ConcreteShearReinforcementSpansRow.SpanPositionDefinitionFormat]
            SPAN_POSITION_DEFINITION_FORMAT_RELATIVE: _ClassVar[MemberRepresentative.ConcreteShearReinforcementSpansRow.SpanPositionDefinitionFormat]
        SPAN_POSITION_DEFINITION_FORMAT_ABSOLUTE: MemberRepresentative.ConcreteShearReinforcementSpansRow.SpanPositionDefinitionFormat
        SPAN_POSITION_DEFINITION_FORMAT_RELATIVE: MemberRepresentative.ConcreteShearReinforcementSpansRow.SpanPositionDefinitionFormat
        class StirrupLayoutRule(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            STIRRUP_LAYOUT_RULE_START_EQUALS_END: _ClassVar[MemberRepresentative.ConcreteShearReinforcementSpansRow.StirrupLayoutRule]
            STIRRUP_LAYOUT_RULE_END_DEFINED: _ClassVar[MemberRepresentative.ConcreteShearReinforcementSpansRow.StirrupLayoutRule]
            STIRRUP_LAYOUT_RULE_END_EQUALS_REST_LENGTH_TO_STIRRUP_DISTANCED: _ClassVar[MemberRepresentative.ConcreteShearReinforcementSpansRow.StirrupLayoutRule]
            STIRRUP_LAYOUT_RULE_START_DEFINED: _ClassVar[MemberRepresentative.ConcreteShearReinforcementSpansRow.StirrupLayoutRule]
            STIRRUP_LAYOUT_RULE_START_EQUALS_REST_LENGTH_TO_STIRRUP_DISTANCED: _ClassVar[MemberRepresentative.ConcreteShearReinforcementSpansRow.StirrupLayoutRule]
        STIRRUP_LAYOUT_RULE_START_EQUALS_END: MemberRepresentative.ConcreteShearReinforcementSpansRow.StirrupLayoutRule
        STIRRUP_LAYOUT_RULE_END_DEFINED: MemberRepresentative.ConcreteShearReinforcementSpansRow.StirrupLayoutRule
        STIRRUP_LAYOUT_RULE_END_EQUALS_REST_LENGTH_TO_STIRRUP_DISTANCED: MemberRepresentative.ConcreteShearReinforcementSpansRow.StirrupLayoutRule
        STIRRUP_LAYOUT_RULE_START_DEFINED: MemberRepresentative.ConcreteShearReinforcementSpansRow.StirrupLayoutRule
        STIRRUP_LAYOUT_RULE_START_EQUALS_REST_LENGTH_TO_STIRRUP_DISTANCED: MemberRepresentative.ConcreteShearReinforcementSpansRow.StirrupLayoutRule
        NO_FIELD_NUMBER: _ClassVar[int]
        DESCRIPTION_FIELD_NUMBER: _ClassVar[int]
        NAME_FIELD_NUMBER: _ClassVar[int]
        STIRRUP_TYPE_FIELD_NUMBER: _ClassVar[int]
        MATERIAL_FIELD_NUMBER: _ClassVar[int]
        STIRRUP_COUNT_FIELD_NUMBER: _ClassVar[int]
        STIRRUP_BAR_SIZE_FIELD_NUMBER: _ClassVar[int]
        STIRRUP_BAR_SIZE_CALCULATED_FIELD_NUMBER: _ClassVar[int]
        STIRRUP_DIAMETER_FIELD_NUMBER: _ClassVar[int]
        STIRRUP_DIAMETER_CALCULATED_FIELD_NUMBER: _ClassVar[int]
        STIRRUP_DIAMETER_AUTO_ENABLED_FIELD_NUMBER: _ClassVar[int]
        STIRRUP_BAR_SIZE_AUTO_MINIMUM_FIELD_NUMBER: _ClassVar[int]
        STIRRUP_DIAMETER_AUTO_MINIMUM_FIELD_NUMBER: _ClassVar[int]
        STIRRUP_BAR_SIZE_AUTO_MAXIMUM_FIELD_NUMBER: _ClassVar[int]
        STIRRUP_DIAMETER_AUTO_MAXIMUM_FIELD_NUMBER: _ClassVar[int]
        STIRRUP_DIAMETER_AUTO_DIAMETERS_ENABLED_FIELD_NUMBER: _ClassVar[int]
        STIRRUP_DIAMETER_AUTO_BAR_SIZES_FIELD_NUMBER: _ClassVar[int]
        STIRRUP_DIAMETER_AUTO_DIAMETERS_FIELD_NUMBER: _ClassVar[int]
        STIRRUP_DIAMETER_AUTO_PRIORITY_FIELD_NUMBER: _ClassVar[int]
        STIRRUP_DISTANCES_FIELD_NUMBER: _ClassVar[int]
        STIRRUP_DISTANCES_CALCULATED_FIELD_NUMBER: _ClassVar[int]
        STIRRUP_DISTANCES_AUTO_ENABLED_FIELD_NUMBER: _ClassVar[int]
        STIRRUP_DISTANCES_AUTO_MINIMUM_FIELD_NUMBER: _ClassVar[int]
        STIRRUP_DISTANCES_AUTO_MAXIMUM_FIELD_NUMBER: _ClassVar[int]
        STIRRUP_DISTANCES_AUTO_INCREMENT_FIELD_NUMBER: _ClassVar[int]
        STIRRUP_DISTANCES_AUTO_PRIORITY_FIELD_NUMBER: _ClassVar[int]
        CROSSTIES_ACTIVE_FIELD_NUMBER: _ClassVar[int]
        CROSSTIES_DIAMETER_FIELD_NUMBER: _ClassVar[int]
        REINFORCEMENT_AREA_FIELD_NUMBER: _ClassVar[int]
        HORIZONTAL_CROSSTIE_REINFORCEMENT_AREA_FIELD_NUMBER: _ClassVar[int]
        MINIMAL_MAXIMAL_HORIZONTAL_CROSSTIE_REINFORCEMENT_AREA_FIELD_NUMBER: _ClassVar[int]
        VERTICAL_CROSSTIE_REINFORCEMENT_AREA_FIELD_NUMBER: _ClassVar[int]
        MINIMAL_MAXIMAL_VERTICAL_CROSSTIE_REINFORCEMENT_AREA_FIELD_NUMBER: _ClassVar[int]
        TOTAL_HORIZONTAL_REINFORCEMENT_AREA_FIELD_NUMBER: _ClassVar[int]
        MINIMAL_MAXIMAL_TOTAL_HORIZONTAL_REINFORCEMENT_AREA_FIELD_NUMBER: _ClassVar[int]
        TOTAL_VERTICAL_REINFORCEMENT_AREA_FIELD_NUMBER: _ClassVar[int]
        MINIMAL_MAXIMAL_TOTAL_VERTICAL_REINFORCEMENT_AREA_FIELD_NUMBER: _ClassVar[int]
        SPAN_POSITION_REFERENCE_TYPE_FIELD_NUMBER: _ClassVar[int]
        SPAN_POSITION_REFERENCE_INTERNAL_NODE_FIELD_NUMBER: _ClassVar[int]
        SPAN_POSITION_REFERENCE_X_LOCATION_RELATIVE_FIELD_NUMBER: _ClassVar[int]
        SPAN_POSITION_REFERENCE_X_LOCATION_ABSOLUTE_FIELD_NUMBER: _ClassVar[int]
        SPAN_POSITION_DEFINITION_FORMAT_FIELD_NUMBER: _ClassVar[int]
        SPAN_START_RELATIVE_FIELD_NUMBER: _ClassVar[int]
        SPAN_START_ABSOLUTE_FIELD_NUMBER: _ClassVar[int]
        SPAN_START_AUTO_ENABLED_FIELD_NUMBER: _ClassVar[int]
        SPAN_START_RELATIVE_AUTO_CALCULATED_FIELD_NUMBER: _ClassVar[int]
        SPAN_START_RELATIVE_AUTO_MINIMUM_FIELD_NUMBER: _ClassVar[int]
        SPAN_START_RELATIVE_AUTO_MAXIMUM_FIELD_NUMBER: _ClassVar[int]
        SPAN_START_ABSOLUTE_AUTO_CALCULATED_FIELD_NUMBER: _ClassVar[int]
        SPAN_START_ABSOLUTE_AUTO_MINIMUM_FIELD_NUMBER: _ClassVar[int]
        SPAN_START_ABSOLUTE_AUTO_MAXIMUM_FIELD_NUMBER: _ClassVar[int]
        SPAN_END_RELATIVE_FIELD_NUMBER: _ClassVar[int]
        SPAN_END_ABSOLUTE_FIELD_NUMBER: _ClassVar[int]
        SPAN_END_AUTO_ENABLED_FIELD_NUMBER: _ClassVar[int]
        SPAN_END_RELATIVE_AUTO_CALCULATED_FIELD_NUMBER: _ClassVar[int]
        SPAN_END_RELATIVE_AUTO_MINIMUM_FIELD_NUMBER: _ClassVar[int]
        SPAN_END_RELATIVE_AUTO_MAXIMUM_FIELD_NUMBER: _ClassVar[int]
        SPAN_END_ABSOLUTE_AUTO_CALCULATED_FIELD_NUMBER: _ClassVar[int]
        SPAN_END_ABSOLUTE_AUTO_MINIMUM_FIELD_NUMBER: _ClassVar[int]
        SPAN_END_ABSOLUTE_AUTO_MAXIMUM_FIELD_NUMBER: _ClassVar[int]
        SPAN_LOCATION_AUTO_INCREMENT_FIELD_NUMBER: _ClassVar[int]
        SPAN_LOCATION_AUTO_PRIORITY_FIELD_NUMBER: _ClassVar[int]
        SPAN_LENGTH_FIELD_NUMBER: _ClassVar[int]
        STIRRUP_LAYOUT_RULE_FIELD_NUMBER: _ClassVar[int]
        STIRRUP_START_OFFSET_FIELD_NUMBER: _ClassVar[int]
        STIRRUP_END_OFFSET_FIELD_NUMBER: _ClassVar[int]
        ONE_STIRRUP_LENGTH_FIELD_NUMBER: _ClassVar[int]
        MINIMAL_AND_MAXIMAL_STIRRUP_LENGTH_FIELD_NUMBER: _ClassVar[int]
        ALL_STIRRUPS_LENGTH_FIELD_NUMBER: _ClassVar[int]
        ONE_STIRRUP_WEIGHT_FIELD_NUMBER: _ClassVar[int]
        MINIMAL_AND_MAXIMAL_STIRRUP_WEIGHT_FIELD_NUMBER: _ClassVar[int]
        ALL_STIRRUPS_WEIGHT_FIELD_NUMBER: _ClassVar[int]
        ONE_CROSSTIE_LENGTH_FIELD_NUMBER: _ClassVar[int]
        MINIMAL_AND_MAXIMAL_CROSSTIE_LENGTH_FIELD_NUMBER: _ClassVar[int]
        ALL_CROSSTIES_LENGHT_FIELD_NUMBER: _ClassVar[int]
        ONE_CROSSTIE_WEIGHT_FIELD_NUMBER: _ClassVar[int]
        MINIMAL_AND_MAXIMAL_CROSSTIE_WEIGHT_FIELD_NUMBER: _ClassVar[int]
        ALL_CROSSTIES_WEIGHT_FIELD_NUMBER: _ClassVar[int]
        no: int
        description: str
        name: str
        stirrup_type: MemberRepresentative.ConcreteShearReinforcementSpansRow.StirrupType
        material: int
        stirrup_count: int
        stirrup_bar_size: float
        stirrup_bar_size_calculated: MemberRepresentative.ConcreteShearReinforcementSpansRow.StirrupBarSizeCalculated
        stirrup_diameter: float
        stirrup_diameter_calculated: float
        stirrup_diameter_auto_enabled: bool
        stirrup_bar_size_auto_minimum: MemberRepresentative.ConcreteShearReinforcementSpansRow.StirrupBarSizeAutoMinimum
        stirrup_diameter_auto_minimum: float
        stirrup_bar_size_auto_maximum: MemberRepresentative.ConcreteShearReinforcementSpansRow.StirrupBarSizeAutoMaximum
        stirrup_diameter_auto_maximum: float
        stirrup_diameter_auto_diameters_enabled: bool
        stirrup_diameter_auto_bar_sizes: _containers.RepeatedScalarFieldContainer[MemberRepresentative.ConcreteShearReinforcementSpansRow.StirrupDiameterAutoBarSizes]
        stirrup_diameter_auto_diameters: _containers.RepeatedScalarFieldContainer[float]
        stirrup_diameter_auto_priority: int
        stirrup_distances: float
        stirrup_distances_calculated: float
        stirrup_distances_auto_enabled: bool
        stirrup_distances_auto_minimum: float
        stirrup_distances_auto_maximum: float
        stirrup_distances_auto_increment: float
        stirrup_distances_auto_priority: int
        crossties_active: bool
        crossties_diameter: float
        reinforcement_area: float
        horizontal_crosstie_reinforcement_area: float
        minimal_maximal_horizontal_crosstie_reinforcement_area: str
        vertical_crosstie_reinforcement_area: float
        minimal_maximal_vertical_crosstie_reinforcement_area: str
        total_horizontal_reinforcement_area: float
        minimal_maximal_total_horizontal_reinforcement_area: str
        total_vertical_reinforcement_area: float
        minimal_maximal_total_vertical_reinforcement_area: str
        span_position_reference_type: MemberRepresentative.ConcreteShearReinforcementSpansRow.SpanPositionReferenceType
        span_position_reference_internal_node: int
        span_position_reference_x_location_relative: float
        span_position_reference_x_location_absolute: float
        span_position_definition_format: MemberRepresentative.ConcreteShearReinforcementSpansRow.SpanPositionDefinitionFormat
        span_start_relative: float
        span_start_absolute: float
        span_start_auto_enabled: bool
        span_start_relative_auto_calculated: float
        span_start_relative_auto_minimum: float
        span_start_relative_auto_maximum: float
        span_start_absolute_auto_calculated: float
        span_start_absolute_auto_minimum: float
        span_start_absolute_auto_maximum: float
        span_end_relative: float
        span_end_absolute: float
        span_end_auto_enabled: bool
        span_end_relative_auto_calculated: float
        span_end_relative_auto_minimum: float
        span_end_relative_auto_maximum: float
        span_end_absolute_auto_calculated: float
        span_end_absolute_auto_minimum: float
        span_end_absolute_auto_maximum: float
        span_location_auto_increment: float
        span_location_auto_priority: int
        span_length: float
        stirrup_layout_rule: MemberRepresentative.ConcreteShearReinforcementSpansRow.StirrupLayoutRule
        stirrup_start_offset: float
        stirrup_end_offset: float
        one_stirrup_length: float
        minimal_and_maximal_stirrup_length: str
        all_stirrups_length: float
        one_stirrup_weight: float
        minimal_and_maximal_stirrup_weight: str
        all_stirrups_weight: float
        one_crosstie_length: float
        minimal_and_maximal_crosstie_length: str
        all_crossties_lenght: float
        one_crosstie_weight: float
        minimal_and_maximal_crosstie_weight: str
        all_crossties_weight: float
        def __init__(self, no: _Optional[int] = ..., description: _Optional[str] = ..., name: _Optional[str] = ..., stirrup_type: _Optional[_Union[MemberRepresentative.ConcreteShearReinforcementSpansRow.StirrupType, str]] = ..., material: _Optional[int] = ..., stirrup_count: _Optional[int] = ..., stirrup_bar_size: _Optional[float] = ..., stirrup_bar_size_calculated: _Optional[_Union[MemberRepresentative.ConcreteShearReinforcementSpansRow.StirrupBarSizeCalculated, str]] = ..., stirrup_diameter: _Optional[float] = ..., stirrup_diameter_calculated: _Optional[float] = ..., stirrup_diameter_auto_enabled: bool = ..., stirrup_bar_size_auto_minimum: _Optional[_Union[MemberRepresentative.ConcreteShearReinforcementSpansRow.StirrupBarSizeAutoMinimum, str]] = ..., stirrup_diameter_auto_minimum: _Optional[float] = ..., stirrup_bar_size_auto_maximum: _Optional[_Union[MemberRepresentative.ConcreteShearReinforcementSpansRow.StirrupBarSizeAutoMaximum, str]] = ..., stirrup_diameter_auto_maximum: _Optional[float] = ..., stirrup_diameter_auto_diameters_enabled: bool = ..., stirrup_diameter_auto_bar_sizes: _Optional[_Iterable[_Union[MemberRepresentative.ConcreteShearReinforcementSpansRow.StirrupDiameterAutoBarSizes, str]]] = ..., stirrup_diameter_auto_diameters: _Optional[_Iterable[float]] = ..., stirrup_diameter_auto_priority: _Optional[int] = ..., stirrup_distances: _Optional[float] = ..., stirrup_distances_calculated: _Optional[float] = ..., stirrup_distances_auto_enabled: bool = ..., stirrup_distances_auto_minimum: _Optional[float] = ..., stirrup_distances_auto_maximum: _Optional[float] = ..., stirrup_distances_auto_increment: _Optional[float] = ..., stirrup_distances_auto_priority: _Optional[int] = ..., crossties_active: bool = ..., crossties_diameter: _Optional[float] = ..., reinforcement_area: _Optional[float] = ..., horizontal_crosstie_reinforcement_area: _Optional[float] = ..., minimal_maximal_horizontal_crosstie_reinforcement_area: _Optional[str] = ..., vertical_crosstie_reinforcement_area: _Optional[float] = ..., minimal_maximal_vertical_crosstie_reinforcement_area: _Optional[str] = ..., total_horizontal_reinforcement_area: _Optional[float] = ..., minimal_maximal_total_horizontal_reinforcement_area: _Optional[str] = ..., total_vertical_reinforcement_area: _Optional[float] = ..., minimal_maximal_total_vertical_reinforcement_area: _Optional[str] = ..., span_position_reference_type: _Optional[_Union[MemberRepresentative.ConcreteShearReinforcementSpansRow.SpanPositionReferenceType, str]] = ..., span_position_reference_internal_node: _Optional[int] = ..., span_position_reference_x_location_relative: _Optional[float] = ..., span_position_reference_x_location_absolute: _Optional[float] = ..., span_position_definition_format: _Optional[_Union[MemberRepresentative.ConcreteShearReinforcementSpansRow.SpanPositionDefinitionFormat, str]] = ..., span_start_relative: _Optional[float] = ..., span_start_absolute: _Optional[float] = ..., span_start_auto_enabled: bool = ..., span_start_relative_auto_calculated: _Optional[float] = ..., span_start_relative_auto_minimum: _Optional[float] = ..., span_start_relative_auto_maximum: _Optional[float] = ..., span_start_absolute_auto_calculated: _Optional[float] = ..., span_start_absolute_auto_minimum: _Optional[float] = ..., span_start_absolute_auto_maximum: _Optional[float] = ..., span_end_relative: _Optional[float] = ..., span_end_absolute: _Optional[float] = ..., span_end_auto_enabled: bool = ..., span_end_relative_auto_calculated: _Optional[float] = ..., span_end_relative_auto_minimum: _Optional[float] = ..., span_end_relative_auto_maximum: _Optional[float] = ..., span_end_absolute_auto_calculated: _Optional[float] = ..., span_end_absolute_auto_minimum: _Optional[float] = ..., span_end_absolute_auto_maximum: _Optional[float] = ..., span_location_auto_increment: _Optional[float] = ..., span_location_auto_priority: _Optional[int] = ..., span_length: _Optional[float] = ..., stirrup_layout_rule: _Optional[_Union[MemberRepresentative.ConcreteShearReinforcementSpansRow.StirrupLayoutRule, str]] = ..., stirrup_start_offset: _Optional[float] = ..., stirrup_end_offset: _Optional[float] = ..., one_stirrup_length: _Optional[float] = ..., minimal_and_maximal_stirrup_length: _Optional[str] = ..., all_stirrups_length: _Optional[float] = ..., one_stirrup_weight: _Optional[float] = ..., minimal_and_maximal_stirrup_weight: _Optional[str] = ..., all_stirrups_weight: _Optional[float] = ..., one_crosstie_length: _Optional[float] = ..., minimal_and_maximal_crosstie_length: _Optional[str] = ..., all_crossties_lenght: _Optional[float] = ..., one_crosstie_weight: _Optional[float] = ..., minimal_and_maximal_crosstie_weight: _Optional[str] = ..., all_crossties_weight: _Optional[float] = ...) -> None: ...
    class ConcreteLongitudinalReinforcementItemsTable(_message.Message):
        __slots__ = ("rows",)
        ROWS_FIELD_NUMBER: _ClassVar[int]
        rows: _containers.RepeatedCompositeFieldContainer[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow]
        def __init__(self, rows: _Optional[_Iterable[_Union[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow, _Mapping]]] = ...) -> None: ...
    class ConcreteLongitudinalReinforcementItemsRow(_message.Message):
        __slots__ = ("no", "description", "name", "rebar_type", "material", "reinforcement_placed_in_bending_corner_enabled", "bar_count_symmetrical", "bar_count_symmetrical_calculated", "bar_count_symmetrical_auto_enabled", "bar_count_symmetrical_auto_minimum", "bar_count_symmetrical_auto_maximum", "bar_count_symmetrical_auto_increment", "bar_count_symmetrical_auto_priority", "bar_count_unsymmetrical_at_side", "bar_count_unsymmetrical_top_side", "bar_count_unsymmetrical_top_side_calculated", "bar_count_unsymmetrical_top_side_auto_enabled", "bar_count_unsymmetrical_top_side_auto_minimum", "bar_count_unsymmetrical_top_side_auto_maximum", "bar_count_unsymmetrical_top_side_auto_increment", "bar_count_unsymmetrical_top_side_auto_priority", "bar_count_unsymmetrical_bottom_side", "bar_count_unsymmetrical_bottom_side_calculated", "bar_count_unsymmetrical_bottom_side_auto_enabled", "bar_count_unsymmetrical_bottom_side_auto_minimum", "bar_count_unsymmetrical_bottom_side_auto_maximum", "bar_count_unsymmetrical_bottom_side_auto_increment", "bar_count_unsymmetrical_bottom_side_auto_priority", "bar_count_uniformly_surrounding", "bar_count_uniformly_surrounding_calculated", "bar_count_uniformly_surrounding_auto_enabled", "bar_count_uniformly_surrounding_auto_minimum", "bar_count_uniformly_surrounding_auto_maximum", "bar_count_uniformly_surrounding_auto_increment", "bar_count_uniformly_surrounding_auto_priority", "bar_count_line", "bar_count_line_calculated", "bar_count_line_auto_enabled", "bar_count_line_auto_minimum", "bar_count_line_auto_maximum", "bar_count_line_auto_increment", "bar_count_line_auto_priority", "bar_count_corner", "bar_size_designation_symmetrical", "bar_size_designation_symmetrical_calculated", "bar_diameter_symmetrical", "bar_diameter_symmetrical_calculated", "bar_diameter_symmetrical_auto_enabled", "bar_size_designation_symmetrical_auto_minimum", "bar_diameter_symmetrical_auto_minimum", "bar_size_designation_symmetrical_auto_maximum", "bar_diameter_symmetrical_auto_maximum", "bar_diameter_symmetrical_auto_diameters_enabled", "bar_diameter_symmetrical_auto_bar_sizes", "bar_diameter_symmetrical_auto_diameters", "bar_diameter_symmetrical_auto_priority", "bar_size_designation_unsymmetrical_at_side", "bar_diameter_unsymmetrical_at_side", "bar_size_designation_unsymmetrical_top_side", "bar_size_designation_unsymmetrical_top_side_calculated", "bar_diameter_unsymmetrical_top_side", "bar_diameter_unsymmetrical_top_side_calculated", "bar_diameter_unsymmetrical_top_side_auto_enabled", "bar_size_designation_unsymmetrical_top_side_auto_minimum", "bar_diameter_unsymmetrical_top_side_auto_minimum", "bar_size_designation_unsymmetrical_top_side_auto_maximum", "bar_diameter_unsymmetrical_top_side_auto_maximum", "bar_diameter_unsymmetrical_top_side_auto_diameters_enabled", "bar_diameter_unsymmetrical_top_side_auto_bar_sizes", "bar_diameter_unsymmetrical_top_side_auto_diameters", "bar_diameter_unsymmetrical_top_side_auto_priority", "bar_size_designation_unsymmetrical_bottom_side", "bar_size_designation_unsymmetrical_bottom_side_calculated", "bar_diameter_unsymmetrical_bottom_side", "bar_diameter_unsymmetrical_bottom_side_calculated", "bar_diameter_unsymmetrical_bottom_side_auto_enabled", "bar_size_designation_unsymmetrical_bottom_side_auto_minimum", "bar_diameter_unsymmetrical_bottom_side_auto_minimum", "bar_size_designation_unsymmetrical_bottom_side_auto_maximum", "bar_diameter_unsymmetrical_bottom_side_auto_maximum", "bar_diameter_unsymmetrical_bottom_side_auto_diameters_enabled", "bar_diameter_unsymmetrical_bottom_side_auto_bar_sizes", "bar_diameter_unsymmetrical_bottom_side_auto_diameters", "bar_diameter_unsymmetrical_bottom_side_auto_priority", "bar_size_designation_uniformly_surrounding", "bar_size_designation_uniformly_surrounding_calculated", "bar_diameter_uniformly_surrounding", "bar_diameter_uniformly_surrounding_calculated", "bar_diameter_uniformly_surrounding_auto_enabled", "bar_size_designation_uniformly_surrounding_auto_minimum", "bar_diameter_uniformly_surrounding_auto_minimum", "bar_size_designation_uniformly_surrounding_auto_maximum", "bar_diameter_uniformly_surrounding_auto_maximum", "bar_diameter_uniformly_surrounding_auto_diameters_enabled", "bar_diameter_uniformly_surrounding_auto_bar_sizes", "bar_diameter_uniformly_surrounding_auto_diameters", "bar_diameter_uniformly_surrounding_auto_priority", "bar_size_designation_line", "bar_size_designation_line_calculated", "bar_diameter_line", "bar_diameter_line_calculated", "bar_diameter_line_auto_enabled", "bar_size_designation_line_auto_minimum", "bar_diameter_line_auto_minimum", "bar_size_designation_line_auto_maximum", "bar_diameter_line_auto_maximum", "bar_diameter_line_auto_diameters_enabled", "bar_diameter_line_auto_bar_sizes", "bar_diameter_line_auto_diameters", "bar_diameter_line_auto_priority", "bar_size_designation_single", "bar_size_designation_single_calculated", "bar_diameter_single", "bar_diameter_single_calculated", "bar_diameter_single_auto_enabled", "bar_size_designation_single_auto_minimum", "bar_diameter_single_auto_minimum", "bar_size_designation_single_auto_maximum", "bar_diameter_single_auto_maximum", "bar_diameter_single_auto_diameters_enabled", "bar_diameter_single_auto_bar_sizes", "bar_diameter_single_auto_diameters", "bar_diameter_single_auto_priority", "bar_size_designation_corner", "bar_diameter_corner", "base_diamter_reduced_multi_edit", "corner_reinforcement_enabled", "reinforcement_area_symmetrical", "reinforcement_area_unsymmetrical_at_side", "reinforcement_area_unsymmetrical_top_side", "reinforcement_area_unsymmetrical_bottom_side", "reinforcement_area_uniformly_surrounding", "reinforcement_area_line", "reinforcement_area_single", "reinforcement_area_corner", "reinforcement_area_total", "span_position_reference_type", "span_position_reference_internal_node", "span_position_reference_x_location_relative", "span_position_reference_x_location_absolute", "span_position_definition_format", "span_start_relative", "span_start_absolute", "span_start_auto_enabled", "span_start_relative_auto_calculated", "span_start_relative_auto_minimum", "span_start_relative_auto_maximum", "span_start_absolute_auto_calculated", "span_start_absolute_auto_minimum", "span_start_absolute_auto_maximum", "span_end_relative", "span_end_absolute", "span_end_auto_enabled", "span_end_relative_auto_calculated", "span_end_relative_auto_minimum", "span_end_relative_auto_maximum", "span_end_absolute_auto_calculated", "span_end_absolute_auto_minimum", "span_end_absolute_auto_maximum", "span_location_auto_increment", "span_location_auto_priority", "span_length", "additional_offset_type", "additional_offset_type_single_line", "additional_offset_circle", "additional_offset_top_side", "additional_offset_bottom_side", "additional_offset_left_side", "additional_offset_right_side", "additional_offset_reference_type", "additional_offset_reference_type_at_start", "additional_offset_reference_type_at_end", "additional_horizontal_offset", "additional_horizontal_offset_at_start", "additional_horizontal_offset_at_end", "additional_vertical_offset", "additional_vertical_offset_at_start", "additional_vertical_offset_at_end", "anchorage_start_anchor_type", "anchorage_start_anchor_length", "anchorage_start_bending_diameter", "anchorage_end_anchor_type", "anchorage_end_anchor_length", "anchorage_end_bending_diameter", "one_rebar_length", "one_rebar_minimal_and_maximal_length", "one_rebar_unsymmetrical_at_side_length", "one_rebar_unsymmetrical_at_side_minimal_and_maximal_length", "one_rebar_unsymmetrical_top_side_length", "one_rebar_unsymmetrical_top_side_minimal_and_maximal_length", "one_rebar_unsymmetrical_bottom_side_length", "one_rebar_unsymmetrical_bottom_side_minimal_and_maximal_length", "one_rebar_corner_length", "one_rebar_corner_minimal_and_maximal_length", "length", "one_rebar_weight", "one_rebar_minimal_and_maximal_weight", "one_rebar_unsymmetrical_at_side_weight", "one_rebar_unsymmetrical_at_side_minimal_and_maximal_weight", "one_rebar_unsymmetrical_top_side_weight", "one_rebar_unsymmetrical_top_side_minimal_and_maximal_weight", "one_rebar_unsymmetrical_bottom_side_weight", "one_rebar_unsymmetrical_bottom_side_minimal_and_maximal_weight", "one_rebar_corner_weight", "one_rebar_corner_minimal_and_maximal_weight", "weight")
        class RebarType(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            REBAR_TYPE_SYMMETRICAL: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.RebarType]
            REBAR_TYPE_LINE: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.RebarType]
            REBAR_TYPE_SINGLE: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.RebarType]
            REBAR_TYPE_UNIFORMLY_SURROUNDING: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.RebarType]
            REBAR_TYPE_UNSYMMETRICAL: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.RebarType]
        REBAR_TYPE_SYMMETRICAL: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.RebarType
        REBAR_TYPE_LINE: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.RebarType
        REBAR_TYPE_SINGLE: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.RebarType
        REBAR_TYPE_UNIFORMLY_SURROUNDING: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.RebarType
        REBAR_TYPE_UNSYMMETRICAL: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.RebarType
        class BarSizeDesignationSymmetricalCalculated(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_UNKNOWN: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalCalculated]
            BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_ACI_1: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalCalculated]
            BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_ACI_10: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalCalculated]
            BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_ACI_11: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalCalculated]
            BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_ACI_12: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalCalculated]
            BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_ACI_14: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalCalculated]
            BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_ACI_16: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalCalculated]
            BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_ACI_18: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalCalculated]
            BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_ACI_1p5: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalCalculated]
            BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_ACI_2: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalCalculated]
            BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_ACI_2p5: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalCalculated]
            BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_ACI_3: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalCalculated]
            BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_ACI_4: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalCalculated]
            BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_ACI_5: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalCalculated]
            BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_ACI_6: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalCalculated]
            BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_ACI_7: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalCalculated]
            BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_ACI_8: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalCalculated]
            BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_ACI_9: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalCalculated]
            BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_CSA_10: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalCalculated]
            BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_CSA_15: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalCalculated]
            BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_CSA_20: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalCalculated]
            BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_CSA_25: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalCalculated]
            BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_CSA_30: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalCalculated]
            BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_CSA_35: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalCalculated]
            BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_CSA_45: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalCalculated]
            BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_CSA_55: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalCalculated]
        BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_UNKNOWN: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalCalculated
        BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_ACI_1: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalCalculated
        BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_ACI_10: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalCalculated
        BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_ACI_11: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalCalculated
        BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_ACI_12: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalCalculated
        BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_ACI_14: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalCalculated
        BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_ACI_16: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalCalculated
        BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_ACI_18: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalCalculated
        BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_ACI_1p5: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalCalculated
        BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_ACI_2: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalCalculated
        BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_ACI_2p5: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalCalculated
        BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_ACI_3: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalCalculated
        BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_ACI_4: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalCalculated
        BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_ACI_5: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalCalculated
        BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_ACI_6: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalCalculated
        BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_ACI_7: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalCalculated
        BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_ACI_8: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalCalculated
        BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_ACI_9: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalCalculated
        BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_CSA_10: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalCalculated
        BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_CSA_15: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalCalculated
        BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_CSA_20: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalCalculated
        BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_CSA_25: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalCalculated
        BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_CSA_30: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalCalculated
        BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_CSA_35: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalCalculated
        BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_CSA_45: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalCalculated
        BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_CSA_55: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalCalculated
        class BarSizeDesignationSymmetricalAutoMinimum(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            BAR_SIZE_DESIGNATION_SYMMETRICAL_AUTO_MINIMUM_UNKNOWN: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalAutoMinimum]
        BAR_SIZE_DESIGNATION_SYMMETRICAL_AUTO_MINIMUM_UNKNOWN: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalAutoMinimum
        class BarSizeDesignationSymmetricalAutoMaximum(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            BAR_SIZE_DESIGNATION_SYMMETRICAL_AUTO_MAXIMUM_UNKNOWN: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalAutoMaximum]
        BAR_SIZE_DESIGNATION_SYMMETRICAL_AUTO_MAXIMUM_UNKNOWN: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalAutoMaximum
        class BarDiameterSymmetricalAutoBarSizes(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            BAR_DIAMETER_SYMMETRICAL_AUTO_BAR_SIZES_UNKNOWN: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterSymmetricalAutoBarSizes]
            BAR_DIAMETER_SYMMETRICAL_AUTO_BAR_SIZES_ACI_1: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterSymmetricalAutoBarSizes]
            BAR_DIAMETER_SYMMETRICAL_AUTO_BAR_SIZES_ACI_10: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterSymmetricalAutoBarSizes]
            BAR_DIAMETER_SYMMETRICAL_AUTO_BAR_SIZES_ACI_11: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterSymmetricalAutoBarSizes]
            BAR_DIAMETER_SYMMETRICAL_AUTO_BAR_SIZES_ACI_12: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterSymmetricalAutoBarSizes]
            BAR_DIAMETER_SYMMETRICAL_AUTO_BAR_SIZES_ACI_14: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterSymmetricalAutoBarSizes]
            BAR_DIAMETER_SYMMETRICAL_AUTO_BAR_SIZES_ACI_16: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterSymmetricalAutoBarSizes]
            BAR_DIAMETER_SYMMETRICAL_AUTO_BAR_SIZES_ACI_18: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterSymmetricalAutoBarSizes]
            BAR_DIAMETER_SYMMETRICAL_AUTO_BAR_SIZES_ACI_1p5: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterSymmetricalAutoBarSizes]
            BAR_DIAMETER_SYMMETRICAL_AUTO_BAR_SIZES_ACI_2: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterSymmetricalAutoBarSizes]
            BAR_DIAMETER_SYMMETRICAL_AUTO_BAR_SIZES_ACI_2p5: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterSymmetricalAutoBarSizes]
            BAR_DIAMETER_SYMMETRICAL_AUTO_BAR_SIZES_ACI_3: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterSymmetricalAutoBarSizes]
            BAR_DIAMETER_SYMMETRICAL_AUTO_BAR_SIZES_ACI_4: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterSymmetricalAutoBarSizes]
            BAR_DIAMETER_SYMMETRICAL_AUTO_BAR_SIZES_ACI_5: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterSymmetricalAutoBarSizes]
            BAR_DIAMETER_SYMMETRICAL_AUTO_BAR_SIZES_ACI_6: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterSymmetricalAutoBarSizes]
            BAR_DIAMETER_SYMMETRICAL_AUTO_BAR_SIZES_ACI_7: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterSymmetricalAutoBarSizes]
            BAR_DIAMETER_SYMMETRICAL_AUTO_BAR_SIZES_ACI_8: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterSymmetricalAutoBarSizes]
            BAR_DIAMETER_SYMMETRICAL_AUTO_BAR_SIZES_ACI_9: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterSymmetricalAutoBarSizes]
            BAR_DIAMETER_SYMMETRICAL_AUTO_BAR_SIZES_CSA_10: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterSymmetricalAutoBarSizes]
            BAR_DIAMETER_SYMMETRICAL_AUTO_BAR_SIZES_CSA_15: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterSymmetricalAutoBarSizes]
            BAR_DIAMETER_SYMMETRICAL_AUTO_BAR_SIZES_CSA_20: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterSymmetricalAutoBarSizes]
            BAR_DIAMETER_SYMMETRICAL_AUTO_BAR_SIZES_CSA_25: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterSymmetricalAutoBarSizes]
            BAR_DIAMETER_SYMMETRICAL_AUTO_BAR_SIZES_CSA_30: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterSymmetricalAutoBarSizes]
            BAR_DIAMETER_SYMMETRICAL_AUTO_BAR_SIZES_CSA_35: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterSymmetricalAutoBarSizes]
            BAR_DIAMETER_SYMMETRICAL_AUTO_BAR_SIZES_CSA_45: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterSymmetricalAutoBarSizes]
            BAR_DIAMETER_SYMMETRICAL_AUTO_BAR_SIZES_CSA_55: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterSymmetricalAutoBarSizes]
        BAR_DIAMETER_SYMMETRICAL_AUTO_BAR_SIZES_UNKNOWN: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterSymmetricalAutoBarSizes
        BAR_DIAMETER_SYMMETRICAL_AUTO_BAR_SIZES_ACI_1: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterSymmetricalAutoBarSizes
        BAR_DIAMETER_SYMMETRICAL_AUTO_BAR_SIZES_ACI_10: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterSymmetricalAutoBarSizes
        BAR_DIAMETER_SYMMETRICAL_AUTO_BAR_SIZES_ACI_11: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterSymmetricalAutoBarSizes
        BAR_DIAMETER_SYMMETRICAL_AUTO_BAR_SIZES_ACI_12: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterSymmetricalAutoBarSizes
        BAR_DIAMETER_SYMMETRICAL_AUTO_BAR_SIZES_ACI_14: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterSymmetricalAutoBarSizes
        BAR_DIAMETER_SYMMETRICAL_AUTO_BAR_SIZES_ACI_16: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterSymmetricalAutoBarSizes
        BAR_DIAMETER_SYMMETRICAL_AUTO_BAR_SIZES_ACI_18: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterSymmetricalAutoBarSizes
        BAR_DIAMETER_SYMMETRICAL_AUTO_BAR_SIZES_ACI_1p5: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterSymmetricalAutoBarSizes
        BAR_DIAMETER_SYMMETRICAL_AUTO_BAR_SIZES_ACI_2: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterSymmetricalAutoBarSizes
        BAR_DIAMETER_SYMMETRICAL_AUTO_BAR_SIZES_ACI_2p5: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterSymmetricalAutoBarSizes
        BAR_DIAMETER_SYMMETRICAL_AUTO_BAR_SIZES_ACI_3: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterSymmetricalAutoBarSizes
        BAR_DIAMETER_SYMMETRICAL_AUTO_BAR_SIZES_ACI_4: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterSymmetricalAutoBarSizes
        BAR_DIAMETER_SYMMETRICAL_AUTO_BAR_SIZES_ACI_5: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterSymmetricalAutoBarSizes
        BAR_DIAMETER_SYMMETRICAL_AUTO_BAR_SIZES_ACI_6: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterSymmetricalAutoBarSizes
        BAR_DIAMETER_SYMMETRICAL_AUTO_BAR_SIZES_ACI_7: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterSymmetricalAutoBarSizes
        BAR_DIAMETER_SYMMETRICAL_AUTO_BAR_SIZES_ACI_8: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterSymmetricalAutoBarSizes
        BAR_DIAMETER_SYMMETRICAL_AUTO_BAR_SIZES_ACI_9: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterSymmetricalAutoBarSizes
        BAR_DIAMETER_SYMMETRICAL_AUTO_BAR_SIZES_CSA_10: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterSymmetricalAutoBarSizes
        BAR_DIAMETER_SYMMETRICAL_AUTO_BAR_SIZES_CSA_15: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterSymmetricalAutoBarSizes
        BAR_DIAMETER_SYMMETRICAL_AUTO_BAR_SIZES_CSA_20: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterSymmetricalAutoBarSizes
        BAR_DIAMETER_SYMMETRICAL_AUTO_BAR_SIZES_CSA_25: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterSymmetricalAutoBarSizes
        BAR_DIAMETER_SYMMETRICAL_AUTO_BAR_SIZES_CSA_30: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterSymmetricalAutoBarSizes
        BAR_DIAMETER_SYMMETRICAL_AUTO_BAR_SIZES_CSA_35: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterSymmetricalAutoBarSizes
        BAR_DIAMETER_SYMMETRICAL_AUTO_BAR_SIZES_CSA_45: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterSymmetricalAutoBarSizes
        BAR_DIAMETER_SYMMETRICAL_AUTO_BAR_SIZES_CSA_55: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterSymmetricalAutoBarSizes
        class BarSizeDesignationUnsymmetricalAtSide(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_AT_SIDE_UNKNOWN: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalAtSide]
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_AT_SIDE_UNKNOWN: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalAtSide
        class BarSizeDesignationUnsymmetricalTopSideCalculated(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_UNKNOWN: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_ACI_1: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_ACI_10: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_ACI_11: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_ACI_12: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_ACI_14: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_ACI_16: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_ACI_18: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_ACI_1p5: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_ACI_2: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_ACI_2p5: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_ACI_3: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_ACI_4: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_ACI_5: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_ACI_6: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_ACI_7: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_ACI_8: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_ACI_9: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_CSA_10: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_CSA_15: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_CSA_20: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_CSA_25: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_CSA_30: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_CSA_35: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_CSA_45: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_CSA_55: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideCalculated]
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_UNKNOWN: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_ACI_1: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_ACI_10: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_ACI_11: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_ACI_12: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_ACI_14: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_ACI_16: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_ACI_18: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_ACI_1p5: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_ACI_2: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_ACI_2p5: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_ACI_3: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_ACI_4: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_ACI_5: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_ACI_6: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_ACI_7: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_ACI_8: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_ACI_9: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_CSA_10: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_CSA_15: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_CSA_20: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_CSA_25: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_CSA_30: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_CSA_35: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_CSA_45: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_CSA_55: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideCalculated
        class BarSizeDesignationUnsymmetricalTopSideAutoMinimum(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_AUTO_MINIMUM_UNKNOWN: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideAutoMinimum]
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_AUTO_MINIMUM_UNKNOWN: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideAutoMinimum
        class BarSizeDesignationUnsymmetricalTopSideAutoMaximum(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_AUTO_MAXIMUM_UNKNOWN: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideAutoMaximum]
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_AUTO_MAXIMUM_UNKNOWN: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideAutoMaximum
        class BarDiameterUnsymmetricalTopSideAutoBarSizes(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            BAR_DIAMETER_UNSYMMETRICAL_TOP_SIDE_AUTO_BAR_SIZES_UNKNOWN: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterUnsymmetricalTopSideAutoBarSizes]
            BAR_DIAMETER_UNSYMMETRICAL_TOP_SIDE_AUTO_BAR_SIZES_ACI_1: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterUnsymmetricalTopSideAutoBarSizes]
            BAR_DIAMETER_UNSYMMETRICAL_TOP_SIDE_AUTO_BAR_SIZES_ACI_10: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterUnsymmetricalTopSideAutoBarSizes]
            BAR_DIAMETER_UNSYMMETRICAL_TOP_SIDE_AUTO_BAR_SIZES_ACI_11: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterUnsymmetricalTopSideAutoBarSizes]
            BAR_DIAMETER_UNSYMMETRICAL_TOP_SIDE_AUTO_BAR_SIZES_ACI_12: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterUnsymmetricalTopSideAutoBarSizes]
            BAR_DIAMETER_UNSYMMETRICAL_TOP_SIDE_AUTO_BAR_SIZES_ACI_14: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterUnsymmetricalTopSideAutoBarSizes]
            BAR_DIAMETER_UNSYMMETRICAL_TOP_SIDE_AUTO_BAR_SIZES_ACI_16: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterUnsymmetricalTopSideAutoBarSizes]
            BAR_DIAMETER_UNSYMMETRICAL_TOP_SIDE_AUTO_BAR_SIZES_ACI_18: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterUnsymmetricalTopSideAutoBarSizes]
            BAR_DIAMETER_UNSYMMETRICAL_TOP_SIDE_AUTO_BAR_SIZES_ACI_1p5: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterUnsymmetricalTopSideAutoBarSizes]
            BAR_DIAMETER_UNSYMMETRICAL_TOP_SIDE_AUTO_BAR_SIZES_ACI_2: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterUnsymmetricalTopSideAutoBarSizes]
            BAR_DIAMETER_UNSYMMETRICAL_TOP_SIDE_AUTO_BAR_SIZES_ACI_2p5: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterUnsymmetricalTopSideAutoBarSizes]
            BAR_DIAMETER_UNSYMMETRICAL_TOP_SIDE_AUTO_BAR_SIZES_ACI_3: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterUnsymmetricalTopSideAutoBarSizes]
            BAR_DIAMETER_UNSYMMETRICAL_TOP_SIDE_AUTO_BAR_SIZES_ACI_4: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterUnsymmetricalTopSideAutoBarSizes]
            BAR_DIAMETER_UNSYMMETRICAL_TOP_SIDE_AUTO_BAR_SIZES_ACI_5: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterUnsymmetricalTopSideAutoBarSizes]
            BAR_DIAMETER_UNSYMMETRICAL_TOP_SIDE_AUTO_BAR_SIZES_ACI_6: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterUnsymmetricalTopSideAutoBarSizes]
            BAR_DIAMETER_UNSYMMETRICAL_TOP_SIDE_AUTO_BAR_SIZES_ACI_7: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterUnsymmetricalTopSideAutoBarSizes]
            BAR_DIAMETER_UNSYMMETRICAL_TOP_SIDE_AUTO_BAR_SIZES_ACI_8: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterUnsymmetricalTopSideAutoBarSizes]
            BAR_DIAMETER_UNSYMMETRICAL_TOP_SIDE_AUTO_BAR_SIZES_ACI_9: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterUnsymmetricalTopSideAutoBarSizes]
            BAR_DIAMETER_UNSYMMETRICAL_TOP_SIDE_AUTO_BAR_SIZES_CSA_10: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterUnsymmetricalTopSideAutoBarSizes]
            BAR_DIAMETER_UNSYMMETRICAL_TOP_SIDE_AUTO_BAR_SIZES_CSA_15: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterUnsymmetricalTopSideAutoBarSizes]
            BAR_DIAMETER_UNSYMMETRICAL_TOP_SIDE_AUTO_BAR_SIZES_CSA_20: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterUnsymmetricalTopSideAutoBarSizes]
            BAR_DIAMETER_UNSYMMETRICAL_TOP_SIDE_AUTO_BAR_SIZES_CSA_25: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterUnsymmetricalTopSideAutoBarSizes]
            BAR_DIAMETER_UNSYMMETRICAL_TOP_SIDE_AUTO_BAR_SIZES_CSA_30: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterUnsymmetricalTopSideAutoBarSizes]
            BAR_DIAMETER_UNSYMMETRICAL_TOP_SIDE_AUTO_BAR_SIZES_CSA_35: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterUnsymmetricalTopSideAutoBarSizes]
            BAR_DIAMETER_UNSYMMETRICAL_TOP_SIDE_AUTO_BAR_SIZES_CSA_45: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterUnsymmetricalTopSideAutoBarSizes]
            BAR_DIAMETER_UNSYMMETRICAL_TOP_SIDE_AUTO_BAR_SIZES_CSA_55: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterUnsymmetricalTopSideAutoBarSizes]
        BAR_DIAMETER_UNSYMMETRICAL_TOP_SIDE_AUTO_BAR_SIZES_UNKNOWN: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterUnsymmetricalTopSideAutoBarSizes
        BAR_DIAMETER_UNSYMMETRICAL_TOP_SIDE_AUTO_BAR_SIZES_ACI_1: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterUnsymmetricalTopSideAutoBarSizes
        BAR_DIAMETER_UNSYMMETRICAL_TOP_SIDE_AUTO_BAR_SIZES_ACI_10: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterUnsymmetricalTopSideAutoBarSizes
        BAR_DIAMETER_UNSYMMETRICAL_TOP_SIDE_AUTO_BAR_SIZES_ACI_11: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterUnsymmetricalTopSideAutoBarSizes
        BAR_DIAMETER_UNSYMMETRICAL_TOP_SIDE_AUTO_BAR_SIZES_ACI_12: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterUnsymmetricalTopSideAutoBarSizes
        BAR_DIAMETER_UNSYMMETRICAL_TOP_SIDE_AUTO_BAR_SIZES_ACI_14: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterUnsymmetricalTopSideAutoBarSizes
        BAR_DIAMETER_UNSYMMETRICAL_TOP_SIDE_AUTO_BAR_SIZES_ACI_16: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterUnsymmetricalTopSideAutoBarSizes
        BAR_DIAMETER_UNSYMMETRICAL_TOP_SIDE_AUTO_BAR_SIZES_ACI_18: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterUnsymmetricalTopSideAutoBarSizes
        BAR_DIAMETER_UNSYMMETRICAL_TOP_SIDE_AUTO_BAR_SIZES_ACI_1p5: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterUnsymmetricalTopSideAutoBarSizes
        BAR_DIAMETER_UNSYMMETRICAL_TOP_SIDE_AUTO_BAR_SIZES_ACI_2: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterUnsymmetricalTopSideAutoBarSizes
        BAR_DIAMETER_UNSYMMETRICAL_TOP_SIDE_AUTO_BAR_SIZES_ACI_2p5: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterUnsymmetricalTopSideAutoBarSizes
        BAR_DIAMETER_UNSYMMETRICAL_TOP_SIDE_AUTO_BAR_SIZES_ACI_3: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterUnsymmetricalTopSideAutoBarSizes
        BAR_DIAMETER_UNSYMMETRICAL_TOP_SIDE_AUTO_BAR_SIZES_ACI_4: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterUnsymmetricalTopSideAutoBarSizes
        BAR_DIAMETER_UNSYMMETRICAL_TOP_SIDE_AUTO_BAR_SIZES_ACI_5: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterUnsymmetricalTopSideAutoBarSizes
        BAR_DIAMETER_UNSYMMETRICAL_TOP_SIDE_AUTO_BAR_SIZES_ACI_6: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterUnsymmetricalTopSideAutoBarSizes
        BAR_DIAMETER_UNSYMMETRICAL_TOP_SIDE_AUTO_BAR_SIZES_ACI_7: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterUnsymmetricalTopSideAutoBarSizes
        BAR_DIAMETER_UNSYMMETRICAL_TOP_SIDE_AUTO_BAR_SIZES_ACI_8: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterUnsymmetricalTopSideAutoBarSizes
        BAR_DIAMETER_UNSYMMETRICAL_TOP_SIDE_AUTO_BAR_SIZES_ACI_9: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterUnsymmetricalTopSideAutoBarSizes
        BAR_DIAMETER_UNSYMMETRICAL_TOP_SIDE_AUTO_BAR_SIZES_CSA_10: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterUnsymmetricalTopSideAutoBarSizes
        BAR_DIAMETER_UNSYMMETRICAL_TOP_SIDE_AUTO_BAR_SIZES_CSA_15: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterUnsymmetricalTopSideAutoBarSizes
        BAR_DIAMETER_UNSYMMETRICAL_TOP_SIDE_AUTO_BAR_SIZES_CSA_20: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterUnsymmetricalTopSideAutoBarSizes
        BAR_DIAMETER_UNSYMMETRICAL_TOP_SIDE_AUTO_BAR_SIZES_CSA_25: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterUnsymmetricalTopSideAutoBarSizes
        BAR_DIAMETER_UNSYMMETRICAL_TOP_SIDE_AUTO_BAR_SIZES_CSA_30: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterUnsymmetricalTopSideAutoBarSizes
        BAR_DIAMETER_UNSYMMETRICAL_TOP_SIDE_AUTO_BAR_SIZES_CSA_35: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterUnsymmetricalTopSideAutoBarSizes
        BAR_DIAMETER_UNSYMMETRICAL_TOP_SIDE_AUTO_BAR_SIZES_CSA_45: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterUnsymmetricalTopSideAutoBarSizes
        BAR_DIAMETER_UNSYMMETRICAL_TOP_SIDE_AUTO_BAR_SIZES_CSA_55: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterUnsymmetricalTopSideAutoBarSizes
        class BarSizeDesignationUnsymmetricalBottomSideCalculated(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_UNKNOWN: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_ACI_1: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_ACI_10: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_ACI_11: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_ACI_12: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_ACI_14: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_ACI_16: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_ACI_18: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_ACI_1p5: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_ACI_2: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_ACI_2p5: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_ACI_3: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_ACI_4: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_ACI_5: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_ACI_6: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_ACI_7: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_ACI_8: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_ACI_9: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_CSA_10: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_CSA_15: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_CSA_20: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_CSA_25: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_CSA_30: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_CSA_35: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_CSA_45: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_CSA_55: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideCalculated]
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_UNKNOWN: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_ACI_1: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_ACI_10: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_ACI_11: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_ACI_12: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_ACI_14: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_ACI_16: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_ACI_18: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_ACI_1p5: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_ACI_2: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_ACI_2p5: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_ACI_3: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_ACI_4: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_ACI_5: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_ACI_6: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_ACI_7: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_ACI_8: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_ACI_9: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_CSA_10: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_CSA_15: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_CSA_20: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_CSA_25: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_CSA_30: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_CSA_35: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_CSA_45: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_CSA_55: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideCalculated
        class BarSizeDesignationUnsymmetricalBottomSideAutoMinimum(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_AUTO_MINIMUM_UNKNOWN: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideAutoMinimum]
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_AUTO_MINIMUM_UNKNOWN: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideAutoMinimum
        class BarSizeDesignationUnsymmetricalBottomSideAutoMaximum(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_AUTO_MAXIMUM_UNKNOWN: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideAutoMaximum]
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_AUTO_MAXIMUM_UNKNOWN: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideAutoMaximum
        class BarDiameterUnsymmetricalBottomSideAutoBarSizes(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            BAR_DIAMETER_UNSYMMETRICAL_BOTTOM_SIDE_AUTO_BAR_SIZES_UNKNOWN: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterUnsymmetricalBottomSideAutoBarSizes]
            BAR_DIAMETER_UNSYMMETRICAL_BOTTOM_SIDE_AUTO_BAR_SIZES_ACI_1: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterUnsymmetricalBottomSideAutoBarSizes]
            BAR_DIAMETER_UNSYMMETRICAL_BOTTOM_SIDE_AUTO_BAR_SIZES_ACI_10: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterUnsymmetricalBottomSideAutoBarSizes]
            BAR_DIAMETER_UNSYMMETRICAL_BOTTOM_SIDE_AUTO_BAR_SIZES_ACI_11: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterUnsymmetricalBottomSideAutoBarSizes]
            BAR_DIAMETER_UNSYMMETRICAL_BOTTOM_SIDE_AUTO_BAR_SIZES_ACI_12: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterUnsymmetricalBottomSideAutoBarSizes]
            BAR_DIAMETER_UNSYMMETRICAL_BOTTOM_SIDE_AUTO_BAR_SIZES_ACI_14: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterUnsymmetricalBottomSideAutoBarSizes]
            BAR_DIAMETER_UNSYMMETRICAL_BOTTOM_SIDE_AUTO_BAR_SIZES_ACI_16: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterUnsymmetricalBottomSideAutoBarSizes]
            BAR_DIAMETER_UNSYMMETRICAL_BOTTOM_SIDE_AUTO_BAR_SIZES_ACI_18: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterUnsymmetricalBottomSideAutoBarSizes]
            BAR_DIAMETER_UNSYMMETRICAL_BOTTOM_SIDE_AUTO_BAR_SIZES_ACI_1p5: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterUnsymmetricalBottomSideAutoBarSizes]
            BAR_DIAMETER_UNSYMMETRICAL_BOTTOM_SIDE_AUTO_BAR_SIZES_ACI_2: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterUnsymmetricalBottomSideAutoBarSizes]
            BAR_DIAMETER_UNSYMMETRICAL_BOTTOM_SIDE_AUTO_BAR_SIZES_ACI_2p5: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterUnsymmetricalBottomSideAutoBarSizes]
            BAR_DIAMETER_UNSYMMETRICAL_BOTTOM_SIDE_AUTO_BAR_SIZES_ACI_3: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterUnsymmetricalBottomSideAutoBarSizes]
            BAR_DIAMETER_UNSYMMETRICAL_BOTTOM_SIDE_AUTO_BAR_SIZES_ACI_4: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterUnsymmetricalBottomSideAutoBarSizes]
            BAR_DIAMETER_UNSYMMETRICAL_BOTTOM_SIDE_AUTO_BAR_SIZES_ACI_5: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterUnsymmetricalBottomSideAutoBarSizes]
            BAR_DIAMETER_UNSYMMETRICAL_BOTTOM_SIDE_AUTO_BAR_SIZES_ACI_6: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterUnsymmetricalBottomSideAutoBarSizes]
            BAR_DIAMETER_UNSYMMETRICAL_BOTTOM_SIDE_AUTO_BAR_SIZES_ACI_7: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterUnsymmetricalBottomSideAutoBarSizes]
            BAR_DIAMETER_UNSYMMETRICAL_BOTTOM_SIDE_AUTO_BAR_SIZES_ACI_8: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterUnsymmetricalBottomSideAutoBarSizes]
            BAR_DIAMETER_UNSYMMETRICAL_BOTTOM_SIDE_AUTO_BAR_SIZES_ACI_9: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterUnsymmetricalBottomSideAutoBarSizes]
            BAR_DIAMETER_UNSYMMETRICAL_BOTTOM_SIDE_AUTO_BAR_SIZES_CSA_10: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterUnsymmetricalBottomSideAutoBarSizes]
            BAR_DIAMETER_UNSYMMETRICAL_BOTTOM_SIDE_AUTO_BAR_SIZES_CSA_15: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterUnsymmetricalBottomSideAutoBarSizes]
            BAR_DIAMETER_UNSYMMETRICAL_BOTTOM_SIDE_AUTO_BAR_SIZES_CSA_20: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterUnsymmetricalBottomSideAutoBarSizes]
            BAR_DIAMETER_UNSYMMETRICAL_BOTTOM_SIDE_AUTO_BAR_SIZES_CSA_25: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterUnsymmetricalBottomSideAutoBarSizes]
            BAR_DIAMETER_UNSYMMETRICAL_BOTTOM_SIDE_AUTO_BAR_SIZES_CSA_30: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterUnsymmetricalBottomSideAutoBarSizes]
            BAR_DIAMETER_UNSYMMETRICAL_BOTTOM_SIDE_AUTO_BAR_SIZES_CSA_35: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterUnsymmetricalBottomSideAutoBarSizes]
            BAR_DIAMETER_UNSYMMETRICAL_BOTTOM_SIDE_AUTO_BAR_SIZES_CSA_45: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterUnsymmetricalBottomSideAutoBarSizes]
            BAR_DIAMETER_UNSYMMETRICAL_BOTTOM_SIDE_AUTO_BAR_SIZES_CSA_55: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterUnsymmetricalBottomSideAutoBarSizes]
        BAR_DIAMETER_UNSYMMETRICAL_BOTTOM_SIDE_AUTO_BAR_SIZES_UNKNOWN: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterUnsymmetricalBottomSideAutoBarSizes
        BAR_DIAMETER_UNSYMMETRICAL_BOTTOM_SIDE_AUTO_BAR_SIZES_ACI_1: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterUnsymmetricalBottomSideAutoBarSizes
        BAR_DIAMETER_UNSYMMETRICAL_BOTTOM_SIDE_AUTO_BAR_SIZES_ACI_10: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterUnsymmetricalBottomSideAutoBarSizes
        BAR_DIAMETER_UNSYMMETRICAL_BOTTOM_SIDE_AUTO_BAR_SIZES_ACI_11: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterUnsymmetricalBottomSideAutoBarSizes
        BAR_DIAMETER_UNSYMMETRICAL_BOTTOM_SIDE_AUTO_BAR_SIZES_ACI_12: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterUnsymmetricalBottomSideAutoBarSizes
        BAR_DIAMETER_UNSYMMETRICAL_BOTTOM_SIDE_AUTO_BAR_SIZES_ACI_14: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterUnsymmetricalBottomSideAutoBarSizes
        BAR_DIAMETER_UNSYMMETRICAL_BOTTOM_SIDE_AUTO_BAR_SIZES_ACI_16: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterUnsymmetricalBottomSideAutoBarSizes
        BAR_DIAMETER_UNSYMMETRICAL_BOTTOM_SIDE_AUTO_BAR_SIZES_ACI_18: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterUnsymmetricalBottomSideAutoBarSizes
        BAR_DIAMETER_UNSYMMETRICAL_BOTTOM_SIDE_AUTO_BAR_SIZES_ACI_1p5: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterUnsymmetricalBottomSideAutoBarSizes
        BAR_DIAMETER_UNSYMMETRICAL_BOTTOM_SIDE_AUTO_BAR_SIZES_ACI_2: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterUnsymmetricalBottomSideAutoBarSizes
        BAR_DIAMETER_UNSYMMETRICAL_BOTTOM_SIDE_AUTO_BAR_SIZES_ACI_2p5: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterUnsymmetricalBottomSideAutoBarSizes
        BAR_DIAMETER_UNSYMMETRICAL_BOTTOM_SIDE_AUTO_BAR_SIZES_ACI_3: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterUnsymmetricalBottomSideAutoBarSizes
        BAR_DIAMETER_UNSYMMETRICAL_BOTTOM_SIDE_AUTO_BAR_SIZES_ACI_4: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterUnsymmetricalBottomSideAutoBarSizes
        BAR_DIAMETER_UNSYMMETRICAL_BOTTOM_SIDE_AUTO_BAR_SIZES_ACI_5: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterUnsymmetricalBottomSideAutoBarSizes
        BAR_DIAMETER_UNSYMMETRICAL_BOTTOM_SIDE_AUTO_BAR_SIZES_ACI_6: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterUnsymmetricalBottomSideAutoBarSizes
        BAR_DIAMETER_UNSYMMETRICAL_BOTTOM_SIDE_AUTO_BAR_SIZES_ACI_7: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterUnsymmetricalBottomSideAutoBarSizes
        BAR_DIAMETER_UNSYMMETRICAL_BOTTOM_SIDE_AUTO_BAR_SIZES_ACI_8: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterUnsymmetricalBottomSideAutoBarSizes
        BAR_DIAMETER_UNSYMMETRICAL_BOTTOM_SIDE_AUTO_BAR_SIZES_ACI_9: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterUnsymmetricalBottomSideAutoBarSizes
        BAR_DIAMETER_UNSYMMETRICAL_BOTTOM_SIDE_AUTO_BAR_SIZES_CSA_10: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterUnsymmetricalBottomSideAutoBarSizes
        BAR_DIAMETER_UNSYMMETRICAL_BOTTOM_SIDE_AUTO_BAR_SIZES_CSA_15: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterUnsymmetricalBottomSideAutoBarSizes
        BAR_DIAMETER_UNSYMMETRICAL_BOTTOM_SIDE_AUTO_BAR_SIZES_CSA_20: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterUnsymmetricalBottomSideAutoBarSizes
        BAR_DIAMETER_UNSYMMETRICAL_BOTTOM_SIDE_AUTO_BAR_SIZES_CSA_25: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterUnsymmetricalBottomSideAutoBarSizes
        BAR_DIAMETER_UNSYMMETRICAL_BOTTOM_SIDE_AUTO_BAR_SIZES_CSA_30: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterUnsymmetricalBottomSideAutoBarSizes
        BAR_DIAMETER_UNSYMMETRICAL_BOTTOM_SIDE_AUTO_BAR_SIZES_CSA_35: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterUnsymmetricalBottomSideAutoBarSizes
        BAR_DIAMETER_UNSYMMETRICAL_BOTTOM_SIDE_AUTO_BAR_SIZES_CSA_45: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterUnsymmetricalBottomSideAutoBarSizes
        BAR_DIAMETER_UNSYMMETRICAL_BOTTOM_SIDE_AUTO_BAR_SIZES_CSA_55: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterUnsymmetricalBottomSideAutoBarSizes
        class BarSizeDesignationUniformlySurroundingCalculated(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_UNKNOWN: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingCalculated]
            BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_ACI_1: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingCalculated]
            BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_ACI_10: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingCalculated]
            BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_ACI_11: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingCalculated]
            BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_ACI_12: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingCalculated]
            BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_ACI_14: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingCalculated]
            BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_ACI_16: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingCalculated]
            BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_ACI_18: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingCalculated]
            BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_ACI_1p5: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingCalculated]
            BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_ACI_2: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingCalculated]
            BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_ACI_2p5: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingCalculated]
            BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_ACI_3: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingCalculated]
            BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_ACI_4: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingCalculated]
            BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_ACI_5: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingCalculated]
            BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_ACI_6: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingCalculated]
            BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_ACI_7: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingCalculated]
            BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_ACI_8: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingCalculated]
            BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_ACI_9: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingCalculated]
            BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_CSA_10: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingCalculated]
            BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_CSA_15: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingCalculated]
            BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_CSA_20: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingCalculated]
            BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_CSA_25: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingCalculated]
            BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_CSA_30: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingCalculated]
            BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_CSA_35: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingCalculated]
            BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_CSA_45: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingCalculated]
            BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_CSA_55: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingCalculated]
        BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_UNKNOWN: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingCalculated
        BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_ACI_1: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingCalculated
        BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_ACI_10: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingCalculated
        BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_ACI_11: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingCalculated
        BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_ACI_12: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingCalculated
        BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_ACI_14: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingCalculated
        BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_ACI_16: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingCalculated
        BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_ACI_18: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingCalculated
        BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_ACI_1p5: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingCalculated
        BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_ACI_2: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingCalculated
        BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_ACI_2p5: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingCalculated
        BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_ACI_3: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingCalculated
        BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_ACI_4: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingCalculated
        BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_ACI_5: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingCalculated
        BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_ACI_6: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingCalculated
        BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_ACI_7: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingCalculated
        BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_ACI_8: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingCalculated
        BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_ACI_9: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingCalculated
        BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_CSA_10: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingCalculated
        BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_CSA_15: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingCalculated
        BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_CSA_20: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingCalculated
        BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_CSA_25: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingCalculated
        BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_CSA_30: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingCalculated
        BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_CSA_35: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingCalculated
        BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_CSA_45: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingCalculated
        BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_CSA_55: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingCalculated
        class BarSizeDesignationUniformlySurroundingAutoMinimum(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_AUTO_MINIMUM_UNKNOWN: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingAutoMinimum]
        BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_AUTO_MINIMUM_UNKNOWN: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingAutoMinimum
        class BarSizeDesignationUniformlySurroundingAutoMaximum(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_AUTO_MAXIMUM_UNKNOWN: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingAutoMaximum]
        BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_AUTO_MAXIMUM_UNKNOWN: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingAutoMaximum
        class BarDiameterUniformlySurroundingAutoBarSizes(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            BAR_DIAMETER_UNIFORMLY_SURROUNDING_AUTO_BAR_SIZES_UNKNOWN: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterUniformlySurroundingAutoBarSizes]
            BAR_DIAMETER_UNIFORMLY_SURROUNDING_AUTO_BAR_SIZES_ACI_1: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterUniformlySurroundingAutoBarSizes]
            BAR_DIAMETER_UNIFORMLY_SURROUNDING_AUTO_BAR_SIZES_ACI_10: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterUniformlySurroundingAutoBarSizes]
            BAR_DIAMETER_UNIFORMLY_SURROUNDING_AUTO_BAR_SIZES_ACI_11: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterUniformlySurroundingAutoBarSizes]
            BAR_DIAMETER_UNIFORMLY_SURROUNDING_AUTO_BAR_SIZES_ACI_12: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterUniformlySurroundingAutoBarSizes]
            BAR_DIAMETER_UNIFORMLY_SURROUNDING_AUTO_BAR_SIZES_ACI_14: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterUniformlySurroundingAutoBarSizes]
            BAR_DIAMETER_UNIFORMLY_SURROUNDING_AUTO_BAR_SIZES_ACI_16: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterUniformlySurroundingAutoBarSizes]
            BAR_DIAMETER_UNIFORMLY_SURROUNDING_AUTO_BAR_SIZES_ACI_18: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterUniformlySurroundingAutoBarSizes]
            BAR_DIAMETER_UNIFORMLY_SURROUNDING_AUTO_BAR_SIZES_ACI_1p5: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterUniformlySurroundingAutoBarSizes]
            BAR_DIAMETER_UNIFORMLY_SURROUNDING_AUTO_BAR_SIZES_ACI_2: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterUniformlySurroundingAutoBarSizes]
            BAR_DIAMETER_UNIFORMLY_SURROUNDING_AUTO_BAR_SIZES_ACI_2p5: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterUniformlySurroundingAutoBarSizes]
            BAR_DIAMETER_UNIFORMLY_SURROUNDING_AUTO_BAR_SIZES_ACI_3: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterUniformlySurroundingAutoBarSizes]
            BAR_DIAMETER_UNIFORMLY_SURROUNDING_AUTO_BAR_SIZES_ACI_4: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterUniformlySurroundingAutoBarSizes]
            BAR_DIAMETER_UNIFORMLY_SURROUNDING_AUTO_BAR_SIZES_ACI_5: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterUniformlySurroundingAutoBarSizes]
            BAR_DIAMETER_UNIFORMLY_SURROUNDING_AUTO_BAR_SIZES_ACI_6: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterUniformlySurroundingAutoBarSizes]
            BAR_DIAMETER_UNIFORMLY_SURROUNDING_AUTO_BAR_SIZES_ACI_7: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterUniformlySurroundingAutoBarSizes]
            BAR_DIAMETER_UNIFORMLY_SURROUNDING_AUTO_BAR_SIZES_ACI_8: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterUniformlySurroundingAutoBarSizes]
            BAR_DIAMETER_UNIFORMLY_SURROUNDING_AUTO_BAR_SIZES_ACI_9: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterUniformlySurroundingAutoBarSizes]
            BAR_DIAMETER_UNIFORMLY_SURROUNDING_AUTO_BAR_SIZES_CSA_10: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterUniformlySurroundingAutoBarSizes]
            BAR_DIAMETER_UNIFORMLY_SURROUNDING_AUTO_BAR_SIZES_CSA_15: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterUniformlySurroundingAutoBarSizes]
            BAR_DIAMETER_UNIFORMLY_SURROUNDING_AUTO_BAR_SIZES_CSA_20: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterUniformlySurroundingAutoBarSizes]
            BAR_DIAMETER_UNIFORMLY_SURROUNDING_AUTO_BAR_SIZES_CSA_25: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterUniformlySurroundingAutoBarSizes]
            BAR_DIAMETER_UNIFORMLY_SURROUNDING_AUTO_BAR_SIZES_CSA_30: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterUniformlySurroundingAutoBarSizes]
            BAR_DIAMETER_UNIFORMLY_SURROUNDING_AUTO_BAR_SIZES_CSA_35: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterUniformlySurroundingAutoBarSizes]
            BAR_DIAMETER_UNIFORMLY_SURROUNDING_AUTO_BAR_SIZES_CSA_45: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterUniformlySurroundingAutoBarSizes]
            BAR_DIAMETER_UNIFORMLY_SURROUNDING_AUTO_BAR_SIZES_CSA_55: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterUniformlySurroundingAutoBarSizes]
        BAR_DIAMETER_UNIFORMLY_SURROUNDING_AUTO_BAR_SIZES_UNKNOWN: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterUniformlySurroundingAutoBarSizes
        BAR_DIAMETER_UNIFORMLY_SURROUNDING_AUTO_BAR_SIZES_ACI_1: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterUniformlySurroundingAutoBarSizes
        BAR_DIAMETER_UNIFORMLY_SURROUNDING_AUTO_BAR_SIZES_ACI_10: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterUniformlySurroundingAutoBarSizes
        BAR_DIAMETER_UNIFORMLY_SURROUNDING_AUTO_BAR_SIZES_ACI_11: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterUniformlySurroundingAutoBarSizes
        BAR_DIAMETER_UNIFORMLY_SURROUNDING_AUTO_BAR_SIZES_ACI_12: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterUniformlySurroundingAutoBarSizes
        BAR_DIAMETER_UNIFORMLY_SURROUNDING_AUTO_BAR_SIZES_ACI_14: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterUniformlySurroundingAutoBarSizes
        BAR_DIAMETER_UNIFORMLY_SURROUNDING_AUTO_BAR_SIZES_ACI_16: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterUniformlySurroundingAutoBarSizes
        BAR_DIAMETER_UNIFORMLY_SURROUNDING_AUTO_BAR_SIZES_ACI_18: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterUniformlySurroundingAutoBarSizes
        BAR_DIAMETER_UNIFORMLY_SURROUNDING_AUTO_BAR_SIZES_ACI_1p5: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterUniformlySurroundingAutoBarSizes
        BAR_DIAMETER_UNIFORMLY_SURROUNDING_AUTO_BAR_SIZES_ACI_2: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterUniformlySurroundingAutoBarSizes
        BAR_DIAMETER_UNIFORMLY_SURROUNDING_AUTO_BAR_SIZES_ACI_2p5: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterUniformlySurroundingAutoBarSizes
        BAR_DIAMETER_UNIFORMLY_SURROUNDING_AUTO_BAR_SIZES_ACI_3: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterUniformlySurroundingAutoBarSizes
        BAR_DIAMETER_UNIFORMLY_SURROUNDING_AUTO_BAR_SIZES_ACI_4: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterUniformlySurroundingAutoBarSizes
        BAR_DIAMETER_UNIFORMLY_SURROUNDING_AUTO_BAR_SIZES_ACI_5: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterUniformlySurroundingAutoBarSizes
        BAR_DIAMETER_UNIFORMLY_SURROUNDING_AUTO_BAR_SIZES_ACI_6: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterUniformlySurroundingAutoBarSizes
        BAR_DIAMETER_UNIFORMLY_SURROUNDING_AUTO_BAR_SIZES_ACI_7: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterUniformlySurroundingAutoBarSizes
        BAR_DIAMETER_UNIFORMLY_SURROUNDING_AUTO_BAR_SIZES_ACI_8: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterUniformlySurroundingAutoBarSizes
        BAR_DIAMETER_UNIFORMLY_SURROUNDING_AUTO_BAR_SIZES_ACI_9: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterUniformlySurroundingAutoBarSizes
        BAR_DIAMETER_UNIFORMLY_SURROUNDING_AUTO_BAR_SIZES_CSA_10: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterUniformlySurroundingAutoBarSizes
        BAR_DIAMETER_UNIFORMLY_SURROUNDING_AUTO_BAR_SIZES_CSA_15: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterUniformlySurroundingAutoBarSizes
        BAR_DIAMETER_UNIFORMLY_SURROUNDING_AUTO_BAR_SIZES_CSA_20: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterUniformlySurroundingAutoBarSizes
        BAR_DIAMETER_UNIFORMLY_SURROUNDING_AUTO_BAR_SIZES_CSA_25: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterUniformlySurroundingAutoBarSizes
        BAR_DIAMETER_UNIFORMLY_SURROUNDING_AUTO_BAR_SIZES_CSA_30: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterUniformlySurroundingAutoBarSizes
        BAR_DIAMETER_UNIFORMLY_SURROUNDING_AUTO_BAR_SIZES_CSA_35: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterUniformlySurroundingAutoBarSizes
        BAR_DIAMETER_UNIFORMLY_SURROUNDING_AUTO_BAR_SIZES_CSA_45: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterUniformlySurroundingAutoBarSizes
        BAR_DIAMETER_UNIFORMLY_SURROUNDING_AUTO_BAR_SIZES_CSA_55: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterUniformlySurroundingAutoBarSizes
        class BarSizeDesignationLineCalculated(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            BAR_SIZE_DESIGNATION_LINE_CALCULATED_UNKNOWN: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineCalculated]
            BAR_SIZE_DESIGNATION_LINE_CALCULATED_ACI_1: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineCalculated]
            BAR_SIZE_DESIGNATION_LINE_CALCULATED_ACI_10: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineCalculated]
            BAR_SIZE_DESIGNATION_LINE_CALCULATED_ACI_11: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineCalculated]
            BAR_SIZE_DESIGNATION_LINE_CALCULATED_ACI_12: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineCalculated]
            BAR_SIZE_DESIGNATION_LINE_CALCULATED_ACI_14: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineCalculated]
            BAR_SIZE_DESIGNATION_LINE_CALCULATED_ACI_16: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineCalculated]
            BAR_SIZE_DESIGNATION_LINE_CALCULATED_ACI_18: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineCalculated]
            BAR_SIZE_DESIGNATION_LINE_CALCULATED_ACI_1p5: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineCalculated]
            BAR_SIZE_DESIGNATION_LINE_CALCULATED_ACI_2: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineCalculated]
            BAR_SIZE_DESIGNATION_LINE_CALCULATED_ACI_2p5: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineCalculated]
            BAR_SIZE_DESIGNATION_LINE_CALCULATED_ACI_3: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineCalculated]
            BAR_SIZE_DESIGNATION_LINE_CALCULATED_ACI_4: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineCalculated]
            BAR_SIZE_DESIGNATION_LINE_CALCULATED_ACI_5: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineCalculated]
            BAR_SIZE_DESIGNATION_LINE_CALCULATED_ACI_6: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineCalculated]
            BAR_SIZE_DESIGNATION_LINE_CALCULATED_ACI_7: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineCalculated]
            BAR_SIZE_DESIGNATION_LINE_CALCULATED_ACI_8: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineCalculated]
            BAR_SIZE_DESIGNATION_LINE_CALCULATED_ACI_9: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineCalculated]
            BAR_SIZE_DESIGNATION_LINE_CALCULATED_CSA_10: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineCalculated]
            BAR_SIZE_DESIGNATION_LINE_CALCULATED_CSA_15: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineCalculated]
            BAR_SIZE_DESIGNATION_LINE_CALCULATED_CSA_20: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineCalculated]
            BAR_SIZE_DESIGNATION_LINE_CALCULATED_CSA_25: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineCalculated]
            BAR_SIZE_DESIGNATION_LINE_CALCULATED_CSA_30: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineCalculated]
            BAR_SIZE_DESIGNATION_LINE_CALCULATED_CSA_35: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineCalculated]
            BAR_SIZE_DESIGNATION_LINE_CALCULATED_CSA_45: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineCalculated]
            BAR_SIZE_DESIGNATION_LINE_CALCULATED_CSA_55: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineCalculated]
        BAR_SIZE_DESIGNATION_LINE_CALCULATED_UNKNOWN: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineCalculated
        BAR_SIZE_DESIGNATION_LINE_CALCULATED_ACI_1: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineCalculated
        BAR_SIZE_DESIGNATION_LINE_CALCULATED_ACI_10: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineCalculated
        BAR_SIZE_DESIGNATION_LINE_CALCULATED_ACI_11: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineCalculated
        BAR_SIZE_DESIGNATION_LINE_CALCULATED_ACI_12: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineCalculated
        BAR_SIZE_DESIGNATION_LINE_CALCULATED_ACI_14: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineCalculated
        BAR_SIZE_DESIGNATION_LINE_CALCULATED_ACI_16: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineCalculated
        BAR_SIZE_DESIGNATION_LINE_CALCULATED_ACI_18: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineCalculated
        BAR_SIZE_DESIGNATION_LINE_CALCULATED_ACI_1p5: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineCalculated
        BAR_SIZE_DESIGNATION_LINE_CALCULATED_ACI_2: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineCalculated
        BAR_SIZE_DESIGNATION_LINE_CALCULATED_ACI_2p5: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineCalculated
        BAR_SIZE_DESIGNATION_LINE_CALCULATED_ACI_3: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineCalculated
        BAR_SIZE_DESIGNATION_LINE_CALCULATED_ACI_4: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineCalculated
        BAR_SIZE_DESIGNATION_LINE_CALCULATED_ACI_5: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineCalculated
        BAR_SIZE_DESIGNATION_LINE_CALCULATED_ACI_6: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineCalculated
        BAR_SIZE_DESIGNATION_LINE_CALCULATED_ACI_7: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineCalculated
        BAR_SIZE_DESIGNATION_LINE_CALCULATED_ACI_8: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineCalculated
        BAR_SIZE_DESIGNATION_LINE_CALCULATED_ACI_9: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineCalculated
        BAR_SIZE_DESIGNATION_LINE_CALCULATED_CSA_10: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineCalculated
        BAR_SIZE_DESIGNATION_LINE_CALCULATED_CSA_15: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineCalculated
        BAR_SIZE_DESIGNATION_LINE_CALCULATED_CSA_20: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineCalculated
        BAR_SIZE_DESIGNATION_LINE_CALCULATED_CSA_25: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineCalculated
        BAR_SIZE_DESIGNATION_LINE_CALCULATED_CSA_30: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineCalculated
        BAR_SIZE_DESIGNATION_LINE_CALCULATED_CSA_35: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineCalculated
        BAR_SIZE_DESIGNATION_LINE_CALCULATED_CSA_45: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineCalculated
        BAR_SIZE_DESIGNATION_LINE_CALCULATED_CSA_55: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineCalculated
        class BarSizeDesignationLineAutoMinimum(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            BAR_SIZE_DESIGNATION_LINE_AUTO_MINIMUM_UNKNOWN: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineAutoMinimum]
        BAR_SIZE_DESIGNATION_LINE_AUTO_MINIMUM_UNKNOWN: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineAutoMinimum
        class BarSizeDesignationLineAutoMaximum(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            BAR_SIZE_DESIGNATION_LINE_AUTO_MAXIMUM_UNKNOWN: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineAutoMaximum]
        BAR_SIZE_DESIGNATION_LINE_AUTO_MAXIMUM_UNKNOWN: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineAutoMaximum
        class BarDiameterLineAutoBarSizes(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            BAR_DIAMETER_LINE_AUTO_BAR_SIZES_UNKNOWN: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterLineAutoBarSizes]
            BAR_DIAMETER_LINE_AUTO_BAR_SIZES_ACI_1: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterLineAutoBarSizes]
            BAR_DIAMETER_LINE_AUTO_BAR_SIZES_ACI_10: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterLineAutoBarSizes]
            BAR_DIAMETER_LINE_AUTO_BAR_SIZES_ACI_11: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterLineAutoBarSizes]
            BAR_DIAMETER_LINE_AUTO_BAR_SIZES_ACI_12: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterLineAutoBarSizes]
            BAR_DIAMETER_LINE_AUTO_BAR_SIZES_ACI_14: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterLineAutoBarSizes]
            BAR_DIAMETER_LINE_AUTO_BAR_SIZES_ACI_16: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterLineAutoBarSizes]
            BAR_DIAMETER_LINE_AUTO_BAR_SIZES_ACI_18: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterLineAutoBarSizes]
            BAR_DIAMETER_LINE_AUTO_BAR_SIZES_ACI_1p5: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterLineAutoBarSizes]
            BAR_DIAMETER_LINE_AUTO_BAR_SIZES_ACI_2: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterLineAutoBarSizes]
            BAR_DIAMETER_LINE_AUTO_BAR_SIZES_ACI_2p5: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterLineAutoBarSizes]
            BAR_DIAMETER_LINE_AUTO_BAR_SIZES_ACI_3: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterLineAutoBarSizes]
            BAR_DIAMETER_LINE_AUTO_BAR_SIZES_ACI_4: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterLineAutoBarSizes]
            BAR_DIAMETER_LINE_AUTO_BAR_SIZES_ACI_5: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterLineAutoBarSizes]
            BAR_DIAMETER_LINE_AUTO_BAR_SIZES_ACI_6: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterLineAutoBarSizes]
            BAR_DIAMETER_LINE_AUTO_BAR_SIZES_ACI_7: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterLineAutoBarSizes]
            BAR_DIAMETER_LINE_AUTO_BAR_SIZES_ACI_8: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterLineAutoBarSizes]
            BAR_DIAMETER_LINE_AUTO_BAR_SIZES_ACI_9: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterLineAutoBarSizes]
            BAR_DIAMETER_LINE_AUTO_BAR_SIZES_CSA_10: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterLineAutoBarSizes]
            BAR_DIAMETER_LINE_AUTO_BAR_SIZES_CSA_15: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterLineAutoBarSizes]
            BAR_DIAMETER_LINE_AUTO_BAR_SIZES_CSA_20: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterLineAutoBarSizes]
            BAR_DIAMETER_LINE_AUTO_BAR_SIZES_CSA_25: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterLineAutoBarSizes]
            BAR_DIAMETER_LINE_AUTO_BAR_SIZES_CSA_30: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterLineAutoBarSizes]
            BAR_DIAMETER_LINE_AUTO_BAR_SIZES_CSA_35: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterLineAutoBarSizes]
            BAR_DIAMETER_LINE_AUTO_BAR_SIZES_CSA_45: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterLineAutoBarSizes]
            BAR_DIAMETER_LINE_AUTO_BAR_SIZES_CSA_55: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterLineAutoBarSizes]
        BAR_DIAMETER_LINE_AUTO_BAR_SIZES_UNKNOWN: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterLineAutoBarSizes
        BAR_DIAMETER_LINE_AUTO_BAR_SIZES_ACI_1: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterLineAutoBarSizes
        BAR_DIAMETER_LINE_AUTO_BAR_SIZES_ACI_10: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterLineAutoBarSizes
        BAR_DIAMETER_LINE_AUTO_BAR_SIZES_ACI_11: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterLineAutoBarSizes
        BAR_DIAMETER_LINE_AUTO_BAR_SIZES_ACI_12: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterLineAutoBarSizes
        BAR_DIAMETER_LINE_AUTO_BAR_SIZES_ACI_14: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterLineAutoBarSizes
        BAR_DIAMETER_LINE_AUTO_BAR_SIZES_ACI_16: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterLineAutoBarSizes
        BAR_DIAMETER_LINE_AUTO_BAR_SIZES_ACI_18: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterLineAutoBarSizes
        BAR_DIAMETER_LINE_AUTO_BAR_SIZES_ACI_1p5: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterLineAutoBarSizes
        BAR_DIAMETER_LINE_AUTO_BAR_SIZES_ACI_2: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterLineAutoBarSizes
        BAR_DIAMETER_LINE_AUTO_BAR_SIZES_ACI_2p5: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterLineAutoBarSizes
        BAR_DIAMETER_LINE_AUTO_BAR_SIZES_ACI_3: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterLineAutoBarSizes
        BAR_DIAMETER_LINE_AUTO_BAR_SIZES_ACI_4: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterLineAutoBarSizes
        BAR_DIAMETER_LINE_AUTO_BAR_SIZES_ACI_5: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterLineAutoBarSizes
        BAR_DIAMETER_LINE_AUTO_BAR_SIZES_ACI_6: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterLineAutoBarSizes
        BAR_DIAMETER_LINE_AUTO_BAR_SIZES_ACI_7: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterLineAutoBarSizes
        BAR_DIAMETER_LINE_AUTO_BAR_SIZES_ACI_8: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterLineAutoBarSizes
        BAR_DIAMETER_LINE_AUTO_BAR_SIZES_ACI_9: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterLineAutoBarSizes
        BAR_DIAMETER_LINE_AUTO_BAR_SIZES_CSA_10: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterLineAutoBarSizes
        BAR_DIAMETER_LINE_AUTO_BAR_SIZES_CSA_15: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterLineAutoBarSizes
        BAR_DIAMETER_LINE_AUTO_BAR_SIZES_CSA_20: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterLineAutoBarSizes
        BAR_DIAMETER_LINE_AUTO_BAR_SIZES_CSA_25: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterLineAutoBarSizes
        BAR_DIAMETER_LINE_AUTO_BAR_SIZES_CSA_30: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterLineAutoBarSizes
        BAR_DIAMETER_LINE_AUTO_BAR_SIZES_CSA_35: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterLineAutoBarSizes
        BAR_DIAMETER_LINE_AUTO_BAR_SIZES_CSA_45: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterLineAutoBarSizes
        BAR_DIAMETER_LINE_AUTO_BAR_SIZES_CSA_55: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterLineAutoBarSizes
        class BarSizeDesignationSingleCalculated(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_UNKNOWN: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleCalculated]
            BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_ACI_1: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleCalculated]
            BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_ACI_10: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleCalculated]
            BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_ACI_11: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleCalculated]
            BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_ACI_12: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleCalculated]
            BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_ACI_14: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleCalculated]
            BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_ACI_16: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleCalculated]
            BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_ACI_18: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleCalculated]
            BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_ACI_1p5: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleCalculated]
            BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_ACI_2: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleCalculated]
            BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_ACI_2p5: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleCalculated]
            BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_ACI_3: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleCalculated]
            BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_ACI_4: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleCalculated]
            BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_ACI_5: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleCalculated]
            BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_ACI_6: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleCalculated]
            BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_ACI_7: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleCalculated]
            BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_ACI_8: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleCalculated]
            BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_ACI_9: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleCalculated]
            BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_CSA_10: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleCalculated]
            BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_CSA_15: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleCalculated]
            BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_CSA_20: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleCalculated]
            BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_CSA_25: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleCalculated]
            BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_CSA_30: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleCalculated]
            BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_CSA_35: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleCalculated]
            BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_CSA_45: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleCalculated]
            BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_CSA_55: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleCalculated]
        BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_UNKNOWN: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleCalculated
        BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_ACI_1: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleCalculated
        BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_ACI_10: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleCalculated
        BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_ACI_11: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleCalculated
        BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_ACI_12: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleCalculated
        BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_ACI_14: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleCalculated
        BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_ACI_16: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleCalculated
        BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_ACI_18: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleCalculated
        BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_ACI_1p5: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleCalculated
        BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_ACI_2: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleCalculated
        BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_ACI_2p5: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleCalculated
        BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_ACI_3: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleCalculated
        BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_ACI_4: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleCalculated
        BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_ACI_5: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleCalculated
        BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_ACI_6: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleCalculated
        BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_ACI_7: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleCalculated
        BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_ACI_8: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleCalculated
        BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_ACI_9: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleCalculated
        BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_CSA_10: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleCalculated
        BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_CSA_15: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleCalculated
        BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_CSA_20: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleCalculated
        BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_CSA_25: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleCalculated
        BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_CSA_30: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleCalculated
        BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_CSA_35: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleCalculated
        BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_CSA_45: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleCalculated
        BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_CSA_55: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleCalculated
        class BarSizeDesignationSingleAutoMinimum(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            BAR_SIZE_DESIGNATION_SINGLE_AUTO_MINIMUM_UNKNOWN: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleAutoMinimum]
        BAR_SIZE_DESIGNATION_SINGLE_AUTO_MINIMUM_UNKNOWN: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleAutoMinimum
        class BarSizeDesignationSingleAutoMaximum(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            BAR_SIZE_DESIGNATION_SINGLE_AUTO_MAXIMUM_UNKNOWN: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleAutoMaximum]
        BAR_SIZE_DESIGNATION_SINGLE_AUTO_MAXIMUM_UNKNOWN: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleAutoMaximum
        class BarDiameterSingleAutoBarSizes(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            BAR_DIAMETER_SINGLE_AUTO_BAR_SIZES_UNKNOWN: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterSingleAutoBarSizes]
            BAR_DIAMETER_SINGLE_AUTO_BAR_SIZES_ACI_1: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterSingleAutoBarSizes]
            BAR_DIAMETER_SINGLE_AUTO_BAR_SIZES_ACI_10: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterSingleAutoBarSizes]
            BAR_DIAMETER_SINGLE_AUTO_BAR_SIZES_ACI_11: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterSingleAutoBarSizes]
            BAR_DIAMETER_SINGLE_AUTO_BAR_SIZES_ACI_12: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterSingleAutoBarSizes]
            BAR_DIAMETER_SINGLE_AUTO_BAR_SIZES_ACI_14: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterSingleAutoBarSizes]
            BAR_DIAMETER_SINGLE_AUTO_BAR_SIZES_ACI_16: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterSingleAutoBarSizes]
            BAR_DIAMETER_SINGLE_AUTO_BAR_SIZES_ACI_18: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterSingleAutoBarSizes]
            BAR_DIAMETER_SINGLE_AUTO_BAR_SIZES_ACI_1p5: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterSingleAutoBarSizes]
            BAR_DIAMETER_SINGLE_AUTO_BAR_SIZES_ACI_2: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterSingleAutoBarSizes]
            BAR_DIAMETER_SINGLE_AUTO_BAR_SIZES_ACI_2p5: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterSingleAutoBarSizes]
            BAR_DIAMETER_SINGLE_AUTO_BAR_SIZES_ACI_3: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterSingleAutoBarSizes]
            BAR_DIAMETER_SINGLE_AUTO_BAR_SIZES_ACI_4: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterSingleAutoBarSizes]
            BAR_DIAMETER_SINGLE_AUTO_BAR_SIZES_ACI_5: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterSingleAutoBarSizes]
            BAR_DIAMETER_SINGLE_AUTO_BAR_SIZES_ACI_6: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterSingleAutoBarSizes]
            BAR_DIAMETER_SINGLE_AUTO_BAR_SIZES_ACI_7: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterSingleAutoBarSizes]
            BAR_DIAMETER_SINGLE_AUTO_BAR_SIZES_ACI_8: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterSingleAutoBarSizes]
            BAR_DIAMETER_SINGLE_AUTO_BAR_SIZES_ACI_9: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterSingleAutoBarSizes]
            BAR_DIAMETER_SINGLE_AUTO_BAR_SIZES_CSA_10: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterSingleAutoBarSizes]
            BAR_DIAMETER_SINGLE_AUTO_BAR_SIZES_CSA_15: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterSingleAutoBarSizes]
            BAR_DIAMETER_SINGLE_AUTO_BAR_SIZES_CSA_20: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterSingleAutoBarSizes]
            BAR_DIAMETER_SINGLE_AUTO_BAR_SIZES_CSA_25: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterSingleAutoBarSizes]
            BAR_DIAMETER_SINGLE_AUTO_BAR_SIZES_CSA_30: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterSingleAutoBarSizes]
            BAR_DIAMETER_SINGLE_AUTO_BAR_SIZES_CSA_35: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterSingleAutoBarSizes]
            BAR_DIAMETER_SINGLE_AUTO_BAR_SIZES_CSA_45: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterSingleAutoBarSizes]
            BAR_DIAMETER_SINGLE_AUTO_BAR_SIZES_CSA_55: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterSingleAutoBarSizes]
        BAR_DIAMETER_SINGLE_AUTO_BAR_SIZES_UNKNOWN: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterSingleAutoBarSizes
        BAR_DIAMETER_SINGLE_AUTO_BAR_SIZES_ACI_1: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterSingleAutoBarSizes
        BAR_DIAMETER_SINGLE_AUTO_BAR_SIZES_ACI_10: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterSingleAutoBarSizes
        BAR_DIAMETER_SINGLE_AUTO_BAR_SIZES_ACI_11: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterSingleAutoBarSizes
        BAR_DIAMETER_SINGLE_AUTO_BAR_SIZES_ACI_12: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterSingleAutoBarSizes
        BAR_DIAMETER_SINGLE_AUTO_BAR_SIZES_ACI_14: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterSingleAutoBarSizes
        BAR_DIAMETER_SINGLE_AUTO_BAR_SIZES_ACI_16: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterSingleAutoBarSizes
        BAR_DIAMETER_SINGLE_AUTO_BAR_SIZES_ACI_18: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterSingleAutoBarSizes
        BAR_DIAMETER_SINGLE_AUTO_BAR_SIZES_ACI_1p5: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterSingleAutoBarSizes
        BAR_DIAMETER_SINGLE_AUTO_BAR_SIZES_ACI_2: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterSingleAutoBarSizes
        BAR_DIAMETER_SINGLE_AUTO_BAR_SIZES_ACI_2p5: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterSingleAutoBarSizes
        BAR_DIAMETER_SINGLE_AUTO_BAR_SIZES_ACI_3: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterSingleAutoBarSizes
        BAR_DIAMETER_SINGLE_AUTO_BAR_SIZES_ACI_4: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterSingleAutoBarSizes
        BAR_DIAMETER_SINGLE_AUTO_BAR_SIZES_ACI_5: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterSingleAutoBarSizes
        BAR_DIAMETER_SINGLE_AUTO_BAR_SIZES_ACI_6: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterSingleAutoBarSizes
        BAR_DIAMETER_SINGLE_AUTO_BAR_SIZES_ACI_7: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterSingleAutoBarSizes
        BAR_DIAMETER_SINGLE_AUTO_BAR_SIZES_ACI_8: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterSingleAutoBarSizes
        BAR_DIAMETER_SINGLE_AUTO_BAR_SIZES_ACI_9: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterSingleAutoBarSizes
        BAR_DIAMETER_SINGLE_AUTO_BAR_SIZES_CSA_10: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterSingleAutoBarSizes
        BAR_DIAMETER_SINGLE_AUTO_BAR_SIZES_CSA_15: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterSingleAutoBarSizes
        BAR_DIAMETER_SINGLE_AUTO_BAR_SIZES_CSA_20: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterSingleAutoBarSizes
        BAR_DIAMETER_SINGLE_AUTO_BAR_SIZES_CSA_25: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterSingleAutoBarSizes
        BAR_DIAMETER_SINGLE_AUTO_BAR_SIZES_CSA_30: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterSingleAutoBarSizes
        BAR_DIAMETER_SINGLE_AUTO_BAR_SIZES_CSA_35: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterSingleAutoBarSizes
        BAR_DIAMETER_SINGLE_AUTO_BAR_SIZES_CSA_45: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterSingleAutoBarSizes
        BAR_DIAMETER_SINGLE_AUTO_BAR_SIZES_CSA_55: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterSingleAutoBarSizes
        class BarSizeDesignationCorner(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            BAR_SIZE_DESIGNATION_CORNER_UNKNOWN: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationCorner]
        BAR_SIZE_DESIGNATION_CORNER_UNKNOWN: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationCorner
        class SpanPositionReferenceType(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            SPAN_POSITION_REFERENCE_TYPE_START: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.SpanPositionReferenceType]
            SPAN_POSITION_REFERENCE_TYPE_END: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.SpanPositionReferenceType]
            SPAN_POSITION_REFERENCE_TYPE_INTERNAL_NODE: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.SpanPositionReferenceType]
            SPAN_POSITION_REFERENCE_TYPE_X_LOCATION: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.SpanPositionReferenceType]
        SPAN_POSITION_REFERENCE_TYPE_START: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.SpanPositionReferenceType
        SPAN_POSITION_REFERENCE_TYPE_END: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.SpanPositionReferenceType
        SPAN_POSITION_REFERENCE_TYPE_INTERNAL_NODE: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.SpanPositionReferenceType
        SPAN_POSITION_REFERENCE_TYPE_X_LOCATION: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.SpanPositionReferenceType
        class SpanPositionDefinitionFormat(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            SPAN_POSITION_DEFINITION_FORMAT_ABSOLUTE: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.SpanPositionDefinitionFormat]
            SPAN_POSITION_DEFINITION_FORMAT_RELATIVE: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.SpanPositionDefinitionFormat]
        SPAN_POSITION_DEFINITION_FORMAT_ABSOLUTE: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.SpanPositionDefinitionFormat
        SPAN_POSITION_DEFINITION_FORMAT_RELATIVE: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.SpanPositionDefinitionFormat
        class AdditionalOffsetType(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            ADDITIONAL_OFFSET_TYPE_NONE: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetType]
            ADDITIONAL_OFFSET_TYPE_FROM_CONCRETE_COVER: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetType]
            ADDITIONAL_OFFSET_TYPE_FROM_SECTION_SURFACE: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetType]
            ADDITIONAL_OFFSET_TYPE_FROM_STIRRUP: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetType]
        ADDITIONAL_OFFSET_TYPE_NONE: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetType
        ADDITIONAL_OFFSET_TYPE_FROM_CONCRETE_COVER: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetType
        ADDITIONAL_OFFSET_TYPE_FROM_SECTION_SURFACE: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetType
        ADDITIONAL_OFFSET_TYPE_FROM_STIRRUP: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetType
        class AdditionalOffsetTypeSingleLine(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            ADDITIONAL_OFFSET_TYPE_SINGLE_LINE_NONE: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetTypeSingleLine]
            ADDITIONAL_OFFSET_TYPE_SINGLE_LINE_FROM_CONCRETE_COVER: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetTypeSingleLine]
            ADDITIONAL_OFFSET_TYPE_SINGLE_LINE_FROM_SECTION_SURFACE: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetTypeSingleLine]
            ADDITIONAL_OFFSET_TYPE_SINGLE_LINE_FROM_STIRRUP: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetTypeSingleLine]
        ADDITIONAL_OFFSET_TYPE_SINGLE_LINE_NONE: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetTypeSingleLine
        ADDITIONAL_OFFSET_TYPE_SINGLE_LINE_FROM_CONCRETE_COVER: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetTypeSingleLine
        ADDITIONAL_OFFSET_TYPE_SINGLE_LINE_FROM_SECTION_SURFACE: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetTypeSingleLine
        ADDITIONAL_OFFSET_TYPE_SINGLE_LINE_FROM_STIRRUP: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetTypeSingleLine
        class AdditionalOffsetReferenceType(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            ADDITIONAL_OFFSET_REFERENCE_TYPE_LEFT_TOP: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceType]
            ADDITIONAL_OFFSET_REFERENCE_TYPE_CENTER_BOTTOM: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceType]
            ADDITIONAL_OFFSET_REFERENCE_TYPE_CENTER_CENTER: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceType]
            ADDITIONAL_OFFSET_REFERENCE_TYPE_CENTER_TOP: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceType]
            ADDITIONAL_OFFSET_REFERENCE_TYPE_LEFT_BOTTOM: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceType]
            ADDITIONAL_OFFSET_REFERENCE_TYPE_LEFT_CENTER: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceType]
            ADDITIONAL_OFFSET_REFERENCE_TYPE_RIGHT_BOTTOM: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceType]
            ADDITIONAL_OFFSET_REFERENCE_TYPE_RIGHT_CENTER: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceType]
            ADDITIONAL_OFFSET_REFERENCE_TYPE_RIGHT_TOP: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceType]
        ADDITIONAL_OFFSET_REFERENCE_TYPE_LEFT_TOP: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceType
        ADDITIONAL_OFFSET_REFERENCE_TYPE_CENTER_BOTTOM: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceType
        ADDITIONAL_OFFSET_REFERENCE_TYPE_CENTER_CENTER: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceType
        ADDITIONAL_OFFSET_REFERENCE_TYPE_CENTER_TOP: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceType
        ADDITIONAL_OFFSET_REFERENCE_TYPE_LEFT_BOTTOM: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceType
        ADDITIONAL_OFFSET_REFERENCE_TYPE_LEFT_CENTER: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceType
        ADDITIONAL_OFFSET_REFERENCE_TYPE_RIGHT_BOTTOM: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceType
        ADDITIONAL_OFFSET_REFERENCE_TYPE_RIGHT_CENTER: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceType
        ADDITIONAL_OFFSET_REFERENCE_TYPE_RIGHT_TOP: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceType
        class AdditionalOffsetReferenceTypeAtStart(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            ADDITIONAL_OFFSET_REFERENCE_TYPE_AT_START_LEFT_TOP: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceTypeAtStart]
            ADDITIONAL_OFFSET_REFERENCE_TYPE_AT_START_CENTER_BOTTOM: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceTypeAtStart]
            ADDITIONAL_OFFSET_REFERENCE_TYPE_AT_START_CENTER_CENTER: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceTypeAtStart]
            ADDITIONAL_OFFSET_REFERENCE_TYPE_AT_START_CENTER_TOP: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceTypeAtStart]
            ADDITIONAL_OFFSET_REFERENCE_TYPE_AT_START_LEFT_BOTTOM: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceTypeAtStart]
            ADDITIONAL_OFFSET_REFERENCE_TYPE_AT_START_LEFT_CENTER: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceTypeAtStart]
            ADDITIONAL_OFFSET_REFERENCE_TYPE_AT_START_RIGHT_BOTTOM: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceTypeAtStart]
            ADDITIONAL_OFFSET_REFERENCE_TYPE_AT_START_RIGHT_CENTER: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceTypeAtStart]
            ADDITIONAL_OFFSET_REFERENCE_TYPE_AT_START_RIGHT_TOP: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceTypeAtStart]
        ADDITIONAL_OFFSET_REFERENCE_TYPE_AT_START_LEFT_TOP: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceTypeAtStart
        ADDITIONAL_OFFSET_REFERENCE_TYPE_AT_START_CENTER_BOTTOM: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceTypeAtStart
        ADDITIONAL_OFFSET_REFERENCE_TYPE_AT_START_CENTER_CENTER: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceTypeAtStart
        ADDITIONAL_OFFSET_REFERENCE_TYPE_AT_START_CENTER_TOP: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceTypeAtStart
        ADDITIONAL_OFFSET_REFERENCE_TYPE_AT_START_LEFT_BOTTOM: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceTypeAtStart
        ADDITIONAL_OFFSET_REFERENCE_TYPE_AT_START_LEFT_CENTER: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceTypeAtStart
        ADDITIONAL_OFFSET_REFERENCE_TYPE_AT_START_RIGHT_BOTTOM: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceTypeAtStart
        ADDITIONAL_OFFSET_REFERENCE_TYPE_AT_START_RIGHT_CENTER: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceTypeAtStart
        ADDITIONAL_OFFSET_REFERENCE_TYPE_AT_START_RIGHT_TOP: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceTypeAtStart
        class AdditionalOffsetReferenceTypeAtEnd(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            ADDITIONAL_OFFSET_REFERENCE_TYPE_AT_END_LEFT_TOP: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceTypeAtEnd]
            ADDITIONAL_OFFSET_REFERENCE_TYPE_AT_END_CENTER_BOTTOM: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceTypeAtEnd]
            ADDITIONAL_OFFSET_REFERENCE_TYPE_AT_END_CENTER_CENTER: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceTypeAtEnd]
            ADDITIONAL_OFFSET_REFERENCE_TYPE_AT_END_CENTER_TOP: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceTypeAtEnd]
            ADDITIONAL_OFFSET_REFERENCE_TYPE_AT_END_LEFT_BOTTOM: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceTypeAtEnd]
            ADDITIONAL_OFFSET_REFERENCE_TYPE_AT_END_LEFT_CENTER: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceTypeAtEnd]
            ADDITIONAL_OFFSET_REFERENCE_TYPE_AT_END_RIGHT_BOTTOM: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceTypeAtEnd]
            ADDITIONAL_OFFSET_REFERENCE_TYPE_AT_END_RIGHT_CENTER: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceTypeAtEnd]
            ADDITIONAL_OFFSET_REFERENCE_TYPE_AT_END_RIGHT_TOP: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceTypeAtEnd]
        ADDITIONAL_OFFSET_REFERENCE_TYPE_AT_END_LEFT_TOP: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceTypeAtEnd
        ADDITIONAL_OFFSET_REFERENCE_TYPE_AT_END_CENTER_BOTTOM: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceTypeAtEnd
        ADDITIONAL_OFFSET_REFERENCE_TYPE_AT_END_CENTER_CENTER: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceTypeAtEnd
        ADDITIONAL_OFFSET_REFERENCE_TYPE_AT_END_CENTER_TOP: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceTypeAtEnd
        ADDITIONAL_OFFSET_REFERENCE_TYPE_AT_END_LEFT_BOTTOM: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceTypeAtEnd
        ADDITIONAL_OFFSET_REFERENCE_TYPE_AT_END_LEFT_CENTER: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceTypeAtEnd
        ADDITIONAL_OFFSET_REFERENCE_TYPE_AT_END_RIGHT_BOTTOM: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceTypeAtEnd
        ADDITIONAL_OFFSET_REFERENCE_TYPE_AT_END_RIGHT_CENTER: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceTypeAtEnd
        ADDITIONAL_OFFSET_REFERENCE_TYPE_AT_END_RIGHT_TOP: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceTypeAtEnd
        class AnchorageStartAnchorType(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            ANCHORAGE_START_ANCHOR_TYPE_NONE: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.AnchorageStartAnchorType]
            ANCHORAGE_START_ANCHOR_TYPE_BEND: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.AnchorageStartAnchorType]
            ANCHORAGE_START_ANCHOR_TYPE_HOOK: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.AnchorageStartAnchorType]
            ANCHORAGE_START_ANCHOR_TYPE_HOOK_WITH_TRANSVERSE_BAR: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.AnchorageStartAnchorType]
            ANCHORAGE_START_ANCHOR_TYPE_STRAIGHT: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.AnchorageStartAnchorType]
            ANCHORAGE_START_ANCHOR_TYPE_STRAIGHT_WITH_TRANSVERSE_BAR: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.AnchorageStartAnchorType]
            ANCHORAGE_START_ANCHOR_TYPE_STRAIGHT_WITH_TWO_TRANSVERSE_BARS: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.AnchorageStartAnchorType]
        ANCHORAGE_START_ANCHOR_TYPE_NONE: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.AnchorageStartAnchorType
        ANCHORAGE_START_ANCHOR_TYPE_BEND: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.AnchorageStartAnchorType
        ANCHORAGE_START_ANCHOR_TYPE_HOOK: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.AnchorageStartAnchorType
        ANCHORAGE_START_ANCHOR_TYPE_HOOK_WITH_TRANSVERSE_BAR: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.AnchorageStartAnchorType
        ANCHORAGE_START_ANCHOR_TYPE_STRAIGHT: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.AnchorageStartAnchorType
        ANCHORAGE_START_ANCHOR_TYPE_STRAIGHT_WITH_TRANSVERSE_BAR: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.AnchorageStartAnchorType
        ANCHORAGE_START_ANCHOR_TYPE_STRAIGHT_WITH_TWO_TRANSVERSE_BARS: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.AnchorageStartAnchorType
        class AnchorageEndAnchorType(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            ANCHORAGE_END_ANCHOR_TYPE_NONE: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.AnchorageEndAnchorType]
            ANCHORAGE_END_ANCHOR_TYPE_BEND: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.AnchorageEndAnchorType]
            ANCHORAGE_END_ANCHOR_TYPE_HOOK: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.AnchorageEndAnchorType]
            ANCHORAGE_END_ANCHOR_TYPE_HOOK_WITH_TRANSVERSE_BAR: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.AnchorageEndAnchorType]
            ANCHORAGE_END_ANCHOR_TYPE_STRAIGHT: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.AnchorageEndAnchorType]
            ANCHORAGE_END_ANCHOR_TYPE_STRAIGHT_WITH_TRANSVERSE_BAR: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.AnchorageEndAnchorType]
            ANCHORAGE_END_ANCHOR_TYPE_STRAIGHT_WITH_TWO_TRANSVERSE_BARS: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.AnchorageEndAnchorType]
        ANCHORAGE_END_ANCHOR_TYPE_NONE: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.AnchorageEndAnchorType
        ANCHORAGE_END_ANCHOR_TYPE_BEND: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.AnchorageEndAnchorType
        ANCHORAGE_END_ANCHOR_TYPE_HOOK: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.AnchorageEndAnchorType
        ANCHORAGE_END_ANCHOR_TYPE_HOOK_WITH_TRANSVERSE_BAR: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.AnchorageEndAnchorType
        ANCHORAGE_END_ANCHOR_TYPE_STRAIGHT: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.AnchorageEndAnchorType
        ANCHORAGE_END_ANCHOR_TYPE_STRAIGHT_WITH_TRANSVERSE_BAR: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.AnchorageEndAnchorType
        ANCHORAGE_END_ANCHOR_TYPE_STRAIGHT_WITH_TWO_TRANSVERSE_BARS: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.AnchorageEndAnchorType
        NO_FIELD_NUMBER: _ClassVar[int]
        DESCRIPTION_FIELD_NUMBER: _ClassVar[int]
        NAME_FIELD_NUMBER: _ClassVar[int]
        REBAR_TYPE_FIELD_NUMBER: _ClassVar[int]
        MATERIAL_FIELD_NUMBER: _ClassVar[int]
        REINFORCEMENT_PLACED_IN_BENDING_CORNER_ENABLED_FIELD_NUMBER: _ClassVar[int]
        BAR_COUNT_SYMMETRICAL_FIELD_NUMBER: _ClassVar[int]
        BAR_COUNT_SYMMETRICAL_CALCULATED_FIELD_NUMBER: _ClassVar[int]
        BAR_COUNT_SYMMETRICAL_AUTO_ENABLED_FIELD_NUMBER: _ClassVar[int]
        BAR_COUNT_SYMMETRICAL_AUTO_MINIMUM_FIELD_NUMBER: _ClassVar[int]
        BAR_COUNT_SYMMETRICAL_AUTO_MAXIMUM_FIELD_NUMBER: _ClassVar[int]
        BAR_COUNT_SYMMETRICAL_AUTO_INCREMENT_FIELD_NUMBER: _ClassVar[int]
        BAR_COUNT_SYMMETRICAL_AUTO_PRIORITY_FIELD_NUMBER: _ClassVar[int]
        BAR_COUNT_UNSYMMETRICAL_AT_SIDE_FIELD_NUMBER: _ClassVar[int]
        BAR_COUNT_UNSYMMETRICAL_TOP_SIDE_FIELD_NUMBER: _ClassVar[int]
        BAR_COUNT_UNSYMMETRICAL_TOP_SIDE_CALCULATED_FIELD_NUMBER: _ClassVar[int]
        BAR_COUNT_UNSYMMETRICAL_TOP_SIDE_AUTO_ENABLED_FIELD_NUMBER: _ClassVar[int]
        BAR_COUNT_UNSYMMETRICAL_TOP_SIDE_AUTO_MINIMUM_FIELD_NUMBER: _ClassVar[int]
        BAR_COUNT_UNSYMMETRICAL_TOP_SIDE_AUTO_MAXIMUM_FIELD_NUMBER: _ClassVar[int]
        BAR_COUNT_UNSYMMETRICAL_TOP_SIDE_AUTO_INCREMENT_FIELD_NUMBER: _ClassVar[int]
        BAR_COUNT_UNSYMMETRICAL_TOP_SIDE_AUTO_PRIORITY_FIELD_NUMBER: _ClassVar[int]
        BAR_COUNT_UNSYMMETRICAL_BOTTOM_SIDE_FIELD_NUMBER: _ClassVar[int]
        BAR_COUNT_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_FIELD_NUMBER: _ClassVar[int]
        BAR_COUNT_UNSYMMETRICAL_BOTTOM_SIDE_AUTO_ENABLED_FIELD_NUMBER: _ClassVar[int]
        BAR_COUNT_UNSYMMETRICAL_BOTTOM_SIDE_AUTO_MINIMUM_FIELD_NUMBER: _ClassVar[int]
        BAR_COUNT_UNSYMMETRICAL_BOTTOM_SIDE_AUTO_MAXIMUM_FIELD_NUMBER: _ClassVar[int]
        BAR_COUNT_UNSYMMETRICAL_BOTTOM_SIDE_AUTO_INCREMENT_FIELD_NUMBER: _ClassVar[int]
        BAR_COUNT_UNSYMMETRICAL_BOTTOM_SIDE_AUTO_PRIORITY_FIELD_NUMBER: _ClassVar[int]
        BAR_COUNT_UNIFORMLY_SURROUNDING_FIELD_NUMBER: _ClassVar[int]
        BAR_COUNT_UNIFORMLY_SURROUNDING_CALCULATED_FIELD_NUMBER: _ClassVar[int]
        BAR_COUNT_UNIFORMLY_SURROUNDING_AUTO_ENABLED_FIELD_NUMBER: _ClassVar[int]
        BAR_COUNT_UNIFORMLY_SURROUNDING_AUTO_MINIMUM_FIELD_NUMBER: _ClassVar[int]
        BAR_COUNT_UNIFORMLY_SURROUNDING_AUTO_MAXIMUM_FIELD_NUMBER: _ClassVar[int]
        BAR_COUNT_UNIFORMLY_SURROUNDING_AUTO_INCREMENT_FIELD_NUMBER: _ClassVar[int]
        BAR_COUNT_UNIFORMLY_SURROUNDING_AUTO_PRIORITY_FIELD_NUMBER: _ClassVar[int]
        BAR_COUNT_LINE_FIELD_NUMBER: _ClassVar[int]
        BAR_COUNT_LINE_CALCULATED_FIELD_NUMBER: _ClassVar[int]
        BAR_COUNT_LINE_AUTO_ENABLED_FIELD_NUMBER: _ClassVar[int]
        BAR_COUNT_LINE_AUTO_MINIMUM_FIELD_NUMBER: _ClassVar[int]
        BAR_COUNT_LINE_AUTO_MAXIMUM_FIELD_NUMBER: _ClassVar[int]
        BAR_COUNT_LINE_AUTO_INCREMENT_FIELD_NUMBER: _ClassVar[int]
        BAR_COUNT_LINE_AUTO_PRIORITY_FIELD_NUMBER: _ClassVar[int]
        BAR_COUNT_CORNER_FIELD_NUMBER: _ClassVar[int]
        BAR_SIZE_DESIGNATION_SYMMETRICAL_FIELD_NUMBER: _ClassVar[int]
        BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_SYMMETRICAL_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_SYMMETRICAL_CALCULATED_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_SYMMETRICAL_AUTO_ENABLED_FIELD_NUMBER: _ClassVar[int]
        BAR_SIZE_DESIGNATION_SYMMETRICAL_AUTO_MINIMUM_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_SYMMETRICAL_AUTO_MINIMUM_FIELD_NUMBER: _ClassVar[int]
        BAR_SIZE_DESIGNATION_SYMMETRICAL_AUTO_MAXIMUM_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_SYMMETRICAL_AUTO_MAXIMUM_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_SYMMETRICAL_AUTO_DIAMETERS_ENABLED_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_SYMMETRICAL_AUTO_BAR_SIZES_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_SYMMETRICAL_AUTO_DIAMETERS_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_SYMMETRICAL_AUTO_PRIORITY_FIELD_NUMBER: _ClassVar[int]
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_AT_SIDE_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_UNSYMMETRICAL_AT_SIDE_FIELD_NUMBER: _ClassVar[int]
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_FIELD_NUMBER: _ClassVar[int]
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_UNSYMMETRICAL_TOP_SIDE_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_UNSYMMETRICAL_TOP_SIDE_CALCULATED_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_UNSYMMETRICAL_TOP_SIDE_AUTO_ENABLED_FIELD_NUMBER: _ClassVar[int]
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_AUTO_MINIMUM_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_UNSYMMETRICAL_TOP_SIDE_AUTO_MINIMUM_FIELD_NUMBER: _ClassVar[int]
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_AUTO_MAXIMUM_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_UNSYMMETRICAL_TOP_SIDE_AUTO_MAXIMUM_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_UNSYMMETRICAL_TOP_SIDE_AUTO_DIAMETERS_ENABLED_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_UNSYMMETRICAL_TOP_SIDE_AUTO_BAR_SIZES_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_UNSYMMETRICAL_TOP_SIDE_AUTO_DIAMETERS_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_UNSYMMETRICAL_TOP_SIDE_AUTO_PRIORITY_FIELD_NUMBER: _ClassVar[int]
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_FIELD_NUMBER: _ClassVar[int]
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_UNSYMMETRICAL_BOTTOM_SIDE_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_UNSYMMETRICAL_BOTTOM_SIDE_AUTO_ENABLED_FIELD_NUMBER: _ClassVar[int]
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_AUTO_MINIMUM_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_UNSYMMETRICAL_BOTTOM_SIDE_AUTO_MINIMUM_FIELD_NUMBER: _ClassVar[int]
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_AUTO_MAXIMUM_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_UNSYMMETRICAL_BOTTOM_SIDE_AUTO_MAXIMUM_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_UNSYMMETRICAL_BOTTOM_SIDE_AUTO_DIAMETERS_ENABLED_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_UNSYMMETRICAL_BOTTOM_SIDE_AUTO_BAR_SIZES_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_UNSYMMETRICAL_BOTTOM_SIDE_AUTO_DIAMETERS_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_UNSYMMETRICAL_BOTTOM_SIDE_AUTO_PRIORITY_FIELD_NUMBER: _ClassVar[int]
        BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_FIELD_NUMBER: _ClassVar[int]
        BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_UNIFORMLY_SURROUNDING_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_UNIFORMLY_SURROUNDING_CALCULATED_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_UNIFORMLY_SURROUNDING_AUTO_ENABLED_FIELD_NUMBER: _ClassVar[int]
        BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_AUTO_MINIMUM_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_UNIFORMLY_SURROUNDING_AUTO_MINIMUM_FIELD_NUMBER: _ClassVar[int]
        BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_AUTO_MAXIMUM_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_UNIFORMLY_SURROUNDING_AUTO_MAXIMUM_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_UNIFORMLY_SURROUNDING_AUTO_DIAMETERS_ENABLED_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_UNIFORMLY_SURROUNDING_AUTO_BAR_SIZES_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_UNIFORMLY_SURROUNDING_AUTO_DIAMETERS_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_UNIFORMLY_SURROUNDING_AUTO_PRIORITY_FIELD_NUMBER: _ClassVar[int]
        BAR_SIZE_DESIGNATION_LINE_FIELD_NUMBER: _ClassVar[int]
        BAR_SIZE_DESIGNATION_LINE_CALCULATED_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_LINE_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_LINE_CALCULATED_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_LINE_AUTO_ENABLED_FIELD_NUMBER: _ClassVar[int]
        BAR_SIZE_DESIGNATION_LINE_AUTO_MINIMUM_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_LINE_AUTO_MINIMUM_FIELD_NUMBER: _ClassVar[int]
        BAR_SIZE_DESIGNATION_LINE_AUTO_MAXIMUM_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_LINE_AUTO_MAXIMUM_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_LINE_AUTO_DIAMETERS_ENABLED_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_LINE_AUTO_BAR_SIZES_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_LINE_AUTO_DIAMETERS_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_LINE_AUTO_PRIORITY_FIELD_NUMBER: _ClassVar[int]
        BAR_SIZE_DESIGNATION_SINGLE_FIELD_NUMBER: _ClassVar[int]
        BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_SINGLE_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_SINGLE_CALCULATED_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_SINGLE_AUTO_ENABLED_FIELD_NUMBER: _ClassVar[int]
        BAR_SIZE_DESIGNATION_SINGLE_AUTO_MINIMUM_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_SINGLE_AUTO_MINIMUM_FIELD_NUMBER: _ClassVar[int]
        BAR_SIZE_DESIGNATION_SINGLE_AUTO_MAXIMUM_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_SINGLE_AUTO_MAXIMUM_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_SINGLE_AUTO_DIAMETERS_ENABLED_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_SINGLE_AUTO_BAR_SIZES_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_SINGLE_AUTO_DIAMETERS_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_SINGLE_AUTO_PRIORITY_FIELD_NUMBER: _ClassVar[int]
        BAR_SIZE_DESIGNATION_CORNER_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_CORNER_FIELD_NUMBER: _ClassVar[int]
        BASE_DIAMTER_REDUCED_MULTI_EDIT_FIELD_NUMBER: _ClassVar[int]
        CORNER_REINFORCEMENT_ENABLED_FIELD_NUMBER: _ClassVar[int]
        REINFORCEMENT_AREA_SYMMETRICAL_FIELD_NUMBER: _ClassVar[int]
        REINFORCEMENT_AREA_UNSYMMETRICAL_AT_SIDE_FIELD_NUMBER: _ClassVar[int]
        REINFORCEMENT_AREA_UNSYMMETRICAL_TOP_SIDE_FIELD_NUMBER: _ClassVar[int]
        REINFORCEMENT_AREA_UNSYMMETRICAL_BOTTOM_SIDE_FIELD_NUMBER: _ClassVar[int]
        REINFORCEMENT_AREA_UNIFORMLY_SURROUNDING_FIELD_NUMBER: _ClassVar[int]
        REINFORCEMENT_AREA_LINE_FIELD_NUMBER: _ClassVar[int]
        REINFORCEMENT_AREA_SINGLE_FIELD_NUMBER: _ClassVar[int]
        REINFORCEMENT_AREA_CORNER_FIELD_NUMBER: _ClassVar[int]
        REINFORCEMENT_AREA_TOTAL_FIELD_NUMBER: _ClassVar[int]
        SPAN_POSITION_REFERENCE_TYPE_FIELD_NUMBER: _ClassVar[int]
        SPAN_POSITION_REFERENCE_INTERNAL_NODE_FIELD_NUMBER: _ClassVar[int]
        SPAN_POSITION_REFERENCE_X_LOCATION_RELATIVE_FIELD_NUMBER: _ClassVar[int]
        SPAN_POSITION_REFERENCE_X_LOCATION_ABSOLUTE_FIELD_NUMBER: _ClassVar[int]
        SPAN_POSITION_DEFINITION_FORMAT_FIELD_NUMBER: _ClassVar[int]
        SPAN_START_RELATIVE_FIELD_NUMBER: _ClassVar[int]
        SPAN_START_ABSOLUTE_FIELD_NUMBER: _ClassVar[int]
        SPAN_START_AUTO_ENABLED_FIELD_NUMBER: _ClassVar[int]
        SPAN_START_RELATIVE_AUTO_CALCULATED_FIELD_NUMBER: _ClassVar[int]
        SPAN_START_RELATIVE_AUTO_MINIMUM_FIELD_NUMBER: _ClassVar[int]
        SPAN_START_RELATIVE_AUTO_MAXIMUM_FIELD_NUMBER: _ClassVar[int]
        SPAN_START_ABSOLUTE_AUTO_CALCULATED_FIELD_NUMBER: _ClassVar[int]
        SPAN_START_ABSOLUTE_AUTO_MINIMUM_FIELD_NUMBER: _ClassVar[int]
        SPAN_START_ABSOLUTE_AUTO_MAXIMUM_FIELD_NUMBER: _ClassVar[int]
        SPAN_END_RELATIVE_FIELD_NUMBER: _ClassVar[int]
        SPAN_END_ABSOLUTE_FIELD_NUMBER: _ClassVar[int]
        SPAN_END_AUTO_ENABLED_FIELD_NUMBER: _ClassVar[int]
        SPAN_END_RELATIVE_AUTO_CALCULATED_FIELD_NUMBER: _ClassVar[int]
        SPAN_END_RELATIVE_AUTO_MINIMUM_FIELD_NUMBER: _ClassVar[int]
        SPAN_END_RELATIVE_AUTO_MAXIMUM_FIELD_NUMBER: _ClassVar[int]
        SPAN_END_ABSOLUTE_AUTO_CALCULATED_FIELD_NUMBER: _ClassVar[int]
        SPAN_END_ABSOLUTE_AUTO_MINIMUM_FIELD_NUMBER: _ClassVar[int]
        SPAN_END_ABSOLUTE_AUTO_MAXIMUM_FIELD_NUMBER: _ClassVar[int]
        SPAN_LOCATION_AUTO_INCREMENT_FIELD_NUMBER: _ClassVar[int]
        SPAN_LOCATION_AUTO_PRIORITY_FIELD_NUMBER: _ClassVar[int]
        SPAN_LENGTH_FIELD_NUMBER: _ClassVar[int]
        ADDITIONAL_OFFSET_TYPE_FIELD_NUMBER: _ClassVar[int]
        ADDITIONAL_OFFSET_TYPE_SINGLE_LINE_FIELD_NUMBER: _ClassVar[int]
        ADDITIONAL_OFFSET_CIRCLE_FIELD_NUMBER: _ClassVar[int]
        ADDITIONAL_OFFSET_TOP_SIDE_FIELD_NUMBER: _ClassVar[int]
        ADDITIONAL_OFFSET_BOTTOM_SIDE_FIELD_NUMBER: _ClassVar[int]
        ADDITIONAL_OFFSET_LEFT_SIDE_FIELD_NUMBER: _ClassVar[int]
        ADDITIONAL_OFFSET_RIGHT_SIDE_FIELD_NUMBER: _ClassVar[int]
        ADDITIONAL_OFFSET_REFERENCE_TYPE_FIELD_NUMBER: _ClassVar[int]
        ADDITIONAL_OFFSET_REFERENCE_TYPE_AT_START_FIELD_NUMBER: _ClassVar[int]
        ADDITIONAL_OFFSET_REFERENCE_TYPE_AT_END_FIELD_NUMBER: _ClassVar[int]
        ADDITIONAL_HORIZONTAL_OFFSET_FIELD_NUMBER: _ClassVar[int]
        ADDITIONAL_HORIZONTAL_OFFSET_AT_START_FIELD_NUMBER: _ClassVar[int]
        ADDITIONAL_HORIZONTAL_OFFSET_AT_END_FIELD_NUMBER: _ClassVar[int]
        ADDITIONAL_VERTICAL_OFFSET_FIELD_NUMBER: _ClassVar[int]
        ADDITIONAL_VERTICAL_OFFSET_AT_START_FIELD_NUMBER: _ClassVar[int]
        ADDITIONAL_VERTICAL_OFFSET_AT_END_FIELD_NUMBER: _ClassVar[int]
        ANCHORAGE_START_ANCHOR_TYPE_FIELD_NUMBER: _ClassVar[int]
        ANCHORAGE_START_ANCHOR_LENGTH_FIELD_NUMBER: _ClassVar[int]
        ANCHORAGE_START_BENDING_DIAMETER_FIELD_NUMBER: _ClassVar[int]
        ANCHORAGE_END_ANCHOR_TYPE_FIELD_NUMBER: _ClassVar[int]
        ANCHORAGE_END_ANCHOR_LENGTH_FIELD_NUMBER: _ClassVar[int]
        ANCHORAGE_END_BENDING_DIAMETER_FIELD_NUMBER: _ClassVar[int]
        ONE_REBAR_LENGTH_FIELD_NUMBER: _ClassVar[int]
        ONE_REBAR_MINIMAL_AND_MAXIMAL_LENGTH_FIELD_NUMBER: _ClassVar[int]
        ONE_REBAR_UNSYMMETRICAL_AT_SIDE_LENGTH_FIELD_NUMBER: _ClassVar[int]
        ONE_REBAR_UNSYMMETRICAL_AT_SIDE_MINIMAL_AND_MAXIMAL_LENGTH_FIELD_NUMBER: _ClassVar[int]
        ONE_REBAR_UNSYMMETRICAL_TOP_SIDE_LENGTH_FIELD_NUMBER: _ClassVar[int]
        ONE_REBAR_UNSYMMETRICAL_TOP_SIDE_MINIMAL_AND_MAXIMAL_LENGTH_FIELD_NUMBER: _ClassVar[int]
        ONE_REBAR_UNSYMMETRICAL_BOTTOM_SIDE_LENGTH_FIELD_NUMBER: _ClassVar[int]
        ONE_REBAR_UNSYMMETRICAL_BOTTOM_SIDE_MINIMAL_AND_MAXIMAL_LENGTH_FIELD_NUMBER: _ClassVar[int]
        ONE_REBAR_CORNER_LENGTH_FIELD_NUMBER: _ClassVar[int]
        ONE_REBAR_CORNER_MINIMAL_AND_MAXIMAL_LENGTH_FIELD_NUMBER: _ClassVar[int]
        LENGTH_FIELD_NUMBER: _ClassVar[int]
        ONE_REBAR_WEIGHT_FIELD_NUMBER: _ClassVar[int]
        ONE_REBAR_MINIMAL_AND_MAXIMAL_WEIGHT_FIELD_NUMBER: _ClassVar[int]
        ONE_REBAR_UNSYMMETRICAL_AT_SIDE_WEIGHT_FIELD_NUMBER: _ClassVar[int]
        ONE_REBAR_UNSYMMETRICAL_AT_SIDE_MINIMAL_AND_MAXIMAL_WEIGHT_FIELD_NUMBER: _ClassVar[int]
        ONE_REBAR_UNSYMMETRICAL_TOP_SIDE_WEIGHT_FIELD_NUMBER: _ClassVar[int]
        ONE_REBAR_UNSYMMETRICAL_TOP_SIDE_MINIMAL_AND_MAXIMAL_WEIGHT_FIELD_NUMBER: _ClassVar[int]
        ONE_REBAR_UNSYMMETRICAL_BOTTOM_SIDE_WEIGHT_FIELD_NUMBER: _ClassVar[int]
        ONE_REBAR_UNSYMMETRICAL_BOTTOM_SIDE_MINIMAL_AND_MAXIMAL_WEIGHT_FIELD_NUMBER: _ClassVar[int]
        ONE_REBAR_CORNER_WEIGHT_FIELD_NUMBER: _ClassVar[int]
        ONE_REBAR_CORNER_MINIMAL_AND_MAXIMAL_WEIGHT_FIELD_NUMBER: _ClassVar[int]
        WEIGHT_FIELD_NUMBER: _ClassVar[int]
        no: int
        description: str
        name: str
        rebar_type: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.RebarType
        material: int
        reinforcement_placed_in_bending_corner_enabled: bool
        bar_count_symmetrical: int
        bar_count_symmetrical_calculated: int
        bar_count_symmetrical_auto_enabled: bool
        bar_count_symmetrical_auto_minimum: int
        bar_count_symmetrical_auto_maximum: int
        bar_count_symmetrical_auto_increment: int
        bar_count_symmetrical_auto_priority: int
        bar_count_unsymmetrical_at_side: int
        bar_count_unsymmetrical_top_side: int
        bar_count_unsymmetrical_top_side_calculated: int
        bar_count_unsymmetrical_top_side_auto_enabled: bool
        bar_count_unsymmetrical_top_side_auto_minimum: int
        bar_count_unsymmetrical_top_side_auto_maximum: int
        bar_count_unsymmetrical_top_side_auto_increment: int
        bar_count_unsymmetrical_top_side_auto_priority: int
        bar_count_unsymmetrical_bottom_side: int
        bar_count_unsymmetrical_bottom_side_calculated: int
        bar_count_unsymmetrical_bottom_side_auto_enabled: bool
        bar_count_unsymmetrical_bottom_side_auto_minimum: int
        bar_count_unsymmetrical_bottom_side_auto_maximum: int
        bar_count_unsymmetrical_bottom_side_auto_increment: int
        bar_count_unsymmetrical_bottom_side_auto_priority: int
        bar_count_uniformly_surrounding: int
        bar_count_uniformly_surrounding_calculated: int
        bar_count_uniformly_surrounding_auto_enabled: bool
        bar_count_uniformly_surrounding_auto_minimum: int
        bar_count_uniformly_surrounding_auto_maximum: int
        bar_count_uniformly_surrounding_auto_increment: int
        bar_count_uniformly_surrounding_auto_priority: int
        bar_count_line: int
        bar_count_line_calculated: int
        bar_count_line_auto_enabled: bool
        bar_count_line_auto_minimum: int
        bar_count_line_auto_maximum: int
        bar_count_line_auto_increment: int
        bar_count_line_auto_priority: int
        bar_count_corner: int
        bar_size_designation_symmetrical: float
        bar_size_designation_symmetrical_calculated: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalCalculated
        bar_diameter_symmetrical: float
        bar_diameter_symmetrical_calculated: float
        bar_diameter_symmetrical_auto_enabled: bool
        bar_size_designation_symmetrical_auto_minimum: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalAutoMinimum
        bar_diameter_symmetrical_auto_minimum: float
        bar_size_designation_symmetrical_auto_maximum: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalAutoMaximum
        bar_diameter_symmetrical_auto_maximum: float
        bar_diameter_symmetrical_auto_diameters_enabled: bool
        bar_diameter_symmetrical_auto_bar_sizes: _containers.RepeatedScalarFieldContainer[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterSymmetricalAutoBarSizes]
        bar_diameter_symmetrical_auto_diameters: _containers.RepeatedScalarFieldContainer[float]
        bar_diameter_symmetrical_auto_priority: int
        bar_size_designation_unsymmetrical_at_side: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalAtSide
        bar_diameter_unsymmetrical_at_side: float
        bar_size_designation_unsymmetrical_top_side: float
        bar_size_designation_unsymmetrical_top_side_calculated: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideCalculated
        bar_diameter_unsymmetrical_top_side: float
        bar_diameter_unsymmetrical_top_side_calculated: float
        bar_diameter_unsymmetrical_top_side_auto_enabled: bool
        bar_size_designation_unsymmetrical_top_side_auto_minimum: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideAutoMinimum
        bar_diameter_unsymmetrical_top_side_auto_minimum: float
        bar_size_designation_unsymmetrical_top_side_auto_maximum: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideAutoMaximum
        bar_diameter_unsymmetrical_top_side_auto_maximum: float
        bar_diameter_unsymmetrical_top_side_auto_diameters_enabled: bool
        bar_diameter_unsymmetrical_top_side_auto_bar_sizes: _containers.RepeatedScalarFieldContainer[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterUnsymmetricalTopSideAutoBarSizes]
        bar_diameter_unsymmetrical_top_side_auto_diameters: _containers.RepeatedScalarFieldContainer[float]
        bar_diameter_unsymmetrical_top_side_auto_priority: int
        bar_size_designation_unsymmetrical_bottom_side: float
        bar_size_designation_unsymmetrical_bottom_side_calculated: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideCalculated
        bar_diameter_unsymmetrical_bottom_side: float
        bar_diameter_unsymmetrical_bottom_side_calculated: float
        bar_diameter_unsymmetrical_bottom_side_auto_enabled: bool
        bar_size_designation_unsymmetrical_bottom_side_auto_minimum: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideAutoMinimum
        bar_diameter_unsymmetrical_bottom_side_auto_minimum: float
        bar_size_designation_unsymmetrical_bottom_side_auto_maximum: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideAutoMaximum
        bar_diameter_unsymmetrical_bottom_side_auto_maximum: float
        bar_diameter_unsymmetrical_bottom_side_auto_diameters_enabled: bool
        bar_diameter_unsymmetrical_bottom_side_auto_bar_sizes: _containers.RepeatedScalarFieldContainer[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterUnsymmetricalBottomSideAutoBarSizes]
        bar_diameter_unsymmetrical_bottom_side_auto_diameters: _containers.RepeatedScalarFieldContainer[float]
        bar_diameter_unsymmetrical_bottom_side_auto_priority: int
        bar_size_designation_uniformly_surrounding: float
        bar_size_designation_uniformly_surrounding_calculated: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingCalculated
        bar_diameter_uniformly_surrounding: float
        bar_diameter_uniformly_surrounding_calculated: float
        bar_diameter_uniformly_surrounding_auto_enabled: bool
        bar_size_designation_uniformly_surrounding_auto_minimum: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingAutoMinimum
        bar_diameter_uniformly_surrounding_auto_minimum: float
        bar_size_designation_uniformly_surrounding_auto_maximum: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingAutoMaximum
        bar_diameter_uniformly_surrounding_auto_maximum: float
        bar_diameter_uniformly_surrounding_auto_diameters_enabled: bool
        bar_diameter_uniformly_surrounding_auto_bar_sizes: _containers.RepeatedScalarFieldContainer[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterUniformlySurroundingAutoBarSizes]
        bar_diameter_uniformly_surrounding_auto_diameters: _containers.RepeatedScalarFieldContainer[float]
        bar_diameter_uniformly_surrounding_auto_priority: int
        bar_size_designation_line: float
        bar_size_designation_line_calculated: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineCalculated
        bar_diameter_line: float
        bar_diameter_line_calculated: float
        bar_diameter_line_auto_enabled: bool
        bar_size_designation_line_auto_minimum: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineAutoMinimum
        bar_diameter_line_auto_minimum: float
        bar_size_designation_line_auto_maximum: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineAutoMaximum
        bar_diameter_line_auto_maximum: float
        bar_diameter_line_auto_diameters_enabled: bool
        bar_diameter_line_auto_bar_sizes: _containers.RepeatedScalarFieldContainer[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterLineAutoBarSizes]
        bar_diameter_line_auto_diameters: _containers.RepeatedScalarFieldContainer[float]
        bar_diameter_line_auto_priority: int
        bar_size_designation_single: float
        bar_size_designation_single_calculated: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleCalculated
        bar_diameter_single: float
        bar_diameter_single_calculated: float
        bar_diameter_single_auto_enabled: bool
        bar_size_designation_single_auto_minimum: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleAutoMinimum
        bar_diameter_single_auto_minimum: float
        bar_size_designation_single_auto_maximum: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleAutoMaximum
        bar_diameter_single_auto_maximum: float
        bar_diameter_single_auto_diameters_enabled: bool
        bar_diameter_single_auto_bar_sizes: _containers.RepeatedScalarFieldContainer[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterSingleAutoBarSizes]
        bar_diameter_single_auto_diameters: _containers.RepeatedScalarFieldContainer[float]
        bar_diameter_single_auto_priority: int
        bar_size_designation_corner: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationCorner
        bar_diameter_corner: float
        base_diamter_reduced_multi_edit: float
        corner_reinforcement_enabled: bool
        reinforcement_area_symmetrical: float
        reinforcement_area_unsymmetrical_at_side: float
        reinforcement_area_unsymmetrical_top_side: float
        reinforcement_area_unsymmetrical_bottom_side: float
        reinforcement_area_uniformly_surrounding: float
        reinforcement_area_line: float
        reinforcement_area_single: float
        reinforcement_area_corner: float
        reinforcement_area_total: float
        span_position_reference_type: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.SpanPositionReferenceType
        span_position_reference_internal_node: int
        span_position_reference_x_location_relative: float
        span_position_reference_x_location_absolute: float
        span_position_definition_format: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.SpanPositionDefinitionFormat
        span_start_relative: float
        span_start_absolute: float
        span_start_auto_enabled: bool
        span_start_relative_auto_calculated: float
        span_start_relative_auto_minimum: float
        span_start_relative_auto_maximum: float
        span_start_absolute_auto_calculated: float
        span_start_absolute_auto_minimum: float
        span_start_absolute_auto_maximum: float
        span_end_relative: float
        span_end_absolute: float
        span_end_auto_enabled: bool
        span_end_relative_auto_calculated: float
        span_end_relative_auto_minimum: float
        span_end_relative_auto_maximum: float
        span_end_absolute_auto_calculated: float
        span_end_absolute_auto_minimum: float
        span_end_absolute_auto_maximum: float
        span_location_auto_increment: float
        span_location_auto_priority: int
        span_length: float
        additional_offset_type: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetType
        additional_offset_type_single_line: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetTypeSingleLine
        additional_offset_circle: float
        additional_offset_top_side: float
        additional_offset_bottom_side: float
        additional_offset_left_side: float
        additional_offset_right_side: float
        additional_offset_reference_type: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceType
        additional_offset_reference_type_at_start: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceTypeAtStart
        additional_offset_reference_type_at_end: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceTypeAtEnd
        additional_horizontal_offset: float
        additional_horizontal_offset_at_start: float
        additional_horizontal_offset_at_end: float
        additional_vertical_offset: float
        additional_vertical_offset_at_start: float
        additional_vertical_offset_at_end: float
        anchorage_start_anchor_type: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.AnchorageStartAnchorType
        anchorage_start_anchor_length: float
        anchorage_start_bending_diameter: float
        anchorage_end_anchor_type: MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.AnchorageEndAnchorType
        anchorage_end_anchor_length: float
        anchorage_end_bending_diameter: float
        one_rebar_length: float
        one_rebar_minimal_and_maximal_length: str
        one_rebar_unsymmetrical_at_side_length: float
        one_rebar_unsymmetrical_at_side_minimal_and_maximal_length: str
        one_rebar_unsymmetrical_top_side_length: float
        one_rebar_unsymmetrical_top_side_minimal_and_maximal_length: str
        one_rebar_unsymmetrical_bottom_side_length: float
        one_rebar_unsymmetrical_bottom_side_minimal_and_maximal_length: str
        one_rebar_corner_length: float
        one_rebar_corner_minimal_and_maximal_length: str
        length: float
        one_rebar_weight: float
        one_rebar_minimal_and_maximal_weight: str
        one_rebar_unsymmetrical_at_side_weight: float
        one_rebar_unsymmetrical_at_side_minimal_and_maximal_weight: str
        one_rebar_unsymmetrical_top_side_weight: float
        one_rebar_unsymmetrical_top_side_minimal_and_maximal_weight: str
        one_rebar_unsymmetrical_bottom_side_weight: float
        one_rebar_unsymmetrical_bottom_side_minimal_and_maximal_weight: str
        one_rebar_corner_weight: float
        one_rebar_corner_minimal_and_maximal_weight: str
        weight: float
        def __init__(self, no: _Optional[int] = ..., description: _Optional[str] = ..., name: _Optional[str] = ..., rebar_type: _Optional[_Union[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.RebarType, str]] = ..., material: _Optional[int] = ..., reinforcement_placed_in_bending_corner_enabled: bool = ..., bar_count_symmetrical: _Optional[int] = ..., bar_count_symmetrical_calculated: _Optional[int] = ..., bar_count_symmetrical_auto_enabled: bool = ..., bar_count_symmetrical_auto_minimum: _Optional[int] = ..., bar_count_symmetrical_auto_maximum: _Optional[int] = ..., bar_count_symmetrical_auto_increment: _Optional[int] = ..., bar_count_symmetrical_auto_priority: _Optional[int] = ..., bar_count_unsymmetrical_at_side: _Optional[int] = ..., bar_count_unsymmetrical_top_side: _Optional[int] = ..., bar_count_unsymmetrical_top_side_calculated: _Optional[int] = ..., bar_count_unsymmetrical_top_side_auto_enabled: bool = ..., bar_count_unsymmetrical_top_side_auto_minimum: _Optional[int] = ..., bar_count_unsymmetrical_top_side_auto_maximum: _Optional[int] = ..., bar_count_unsymmetrical_top_side_auto_increment: _Optional[int] = ..., bar_count_unsymmetrical_top_side_auto_priority: _Optional[int] = ..., bar_count_unsymmetrical_bottom_side: _Optional[int] = ..., bar_count_unsymmetrical_bottom_side_calculated: _Optional[int] = ..., bar_count_unsymmetrical_bottom_side_auto_enabled: bool = ..., bar_count_unsymmetrical_bottom_side_auto_minimum: _Optional[int] = ..., bar_count_unsymmetrical_bottom_side_auto_maximum: _Optional[int] = ..., bar_count_unsymmetrical_bottom_side_auto_increment: _Optional[int] = ..., bar_count_unsymmetrical_bottom_side_auto_priority: _Optional[int] = ..., bar_count_uniformly_surrounding: _Optional[int] = ..., bar_count_uniformly_surrounding_calculated: _Optional[int] = ..., bar_count_uniformly_surrounding_auto_enabled: bool = ..., bar_count_uniformly_surrounding_auto_minimum: _Optional[int] = ..., bar_count_uniformly_surrounding_auto_maximum: _Optional[int] = ..., bar_count_uniformly_surrounding_auto_increment: _Optional[int] = ..., bar_count_uniformly_surrounding_auto_priority: _Optional[int] = ..., bar_count_line: _Optional[int] = ..., bar_count_line_calculated: _Optional[int] = ..., bar_count_line_auto_enabled: bool = ..., bar_count_line_auto_minimum: _Optional[int] = ..., bar_count_line_auto_maximum: _Optional[int] = ..., bar_count_line_auto_increment: _Optional[int] = ..., bar_count_line_auto_priority: _Optional[int] = ..., bar_count_corner: _Optional[int] = ..., bar_size_designation_symmetrical: _Optional[float] = ..., bar_size_designation_symmetrical_calculated: _Optional[_Union[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalCalculated, str]] = ..., bar_diameter_symmetrical: _Optional[float] = ..., bar_diameter_symmetrical_calculated: _Optional[float] = ..., bar_diameter_symmetrical_auto_enabled: bool = ..., bar_size_designation_symmetrical_auto_minimum: _Optional[_Union[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalAutoMinimum, str]] = ..., bar_diameter_symmetrical_auto_minimum: _Optional[float] = ..., bar_size_designation_symmetrical_auto_maximum: _Optional[_Union[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalAutoMaximum, str]] = ..., bar_diameter_symmetrical_auto_maximum: _Optional[float] = ..., bar_diameter_symmetrical_auto_diameters_enabled: bool = ..., bar_diameter_symmetrical_auto_bar_sizes: _Optional[_Iterable[_Union[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterSymmetricalAutoBarSizes, str]]] = ..., bar_diameter_symmetrical_auto_diameters: _Optional[_Iterable[float]] = ..., bar_diameter_symmetrical_auto_priority: _Optional[int] = ..., bar_size_designation_unsymmetrical_at_side: _Optional[_Union[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalAtSide, str]] = ..., bar_diameter_unsymmetrical_at_side: _Optional[float] = ..., bar_size_designation_unsymmetrical_top_side: _Optional[float] = ..., bar_size_designation_unsymmetrical_top_side_calculated: _Optional[_Union[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideCalculated, str]] = ..., bar_diameter_unsymmetrical_top_side: _Optional[float] = ..., bar_diameter_unsymmetrical_top_side_calculated: _Optional[float] = ..., bar_diameter_unsymmetrical_top_side_auto_enabled: bool = ..., bar_size_designation_unsymmetrical_top_side_auto_minimum: _Optional[_Union[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideAutoMinimum, str]] = ..., bar_diameter_unsymmetrical_top_side_auto_minimum: _Optional[float] = ..., bar_size_designation_unsymmetrical_top_side_auto_maximum: _Optional[_Union[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideAutoMaximum, str]] = ..., bar_diameter_unsymmetrical_top_side_auto_maximum: _Optional[float] = ..., bar_diameter_unsymmetrical_top_side_auto_diameters_enabled: bool = ..., bar_diameter_unsymmetrical_top_side_auto_bar_sizes: _Optional[_Iterable[_Union[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterUnsymmetricalTopSideAutoBarSizes, str]]] = ..., bar_diameter_unsymmetrical_top_side_auto_diameters: _Optional[_Iterable[float]] = ..., bar_diameter_unsymmetrical_top_side_auto_priority: _Optional[int] = ..., bar_size_designation_unsymmetrical_bottom_side: _Optional[float] = ..., bar_size_designation_unsymmetrical_bottom_side_calculated: _Optional[_Union[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideCalculated, str]] = ..., bar_diameter_unsymmetrical_bottom_side: _Optional[float] = ..., bar_diameter_unsymmetrical_bottom_side_calculated: _Optional[float] = ..., bar_diameter_unsymmetrical_bottom_side_auto_enabled: bool = ..., bar_size_designation_unsymmetrical_bottom_side_auto_minimum: _Optional[_Union[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideAutoMinimum, str]] = ..., bar_diameter_unsymmetrical_bottom_side_auto_minimum: _Optional[float] = ..., bar_size_designation_unsymmetrical_bottom_side_auto_maximum: _Optional[_Union[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideAutoMaximum, str]] = ..., bar_diameter_unsymmetrical_bottom_side_auto_maximum: _Optional[float] = ..., bar_diameter_unsymmetrical_bottom_side_auto_diameters_enabled: bool = ..., bar_diameter_unsymmetrical_bottom_side_auto_bar_sizes: _Optional[_Iterable[_Union[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterUnsymmetricalBottomSideAutoBarSizes, str]]] = ..., bar_diameter_unsymmetrical_bottom_side_auto_diameters: _Optional[_Iterable[float]] = ..., bar_diameter_unsymmetrical_bottom_side_auto_priority: _Optional[int] = ..., bar_size_designation_uniformly_surrounding: _Optional[float] = ..., bar_size_designation_uniformly_surrounding_calculated: _Optional[_Union[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingCalculated, str]] = ..., bar_diameter_uniformly_surrounding: _Optional[float] = ..., bar_diameter_uniformly_surrounding_calculated: _Optional[float] = ..., bar_diameter_uniformly_surrounding_auto_enabled: bool = ..., bar_size_designation_uniformly_surrounding_auto_minimum: _Optional[_Union[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingAutoMinimum, str]] = ..., bar_diameter_uniformly_surrounding_auto_minimum: _Optional[float] = ..., bar_size_designation_uniformly_surrounding_auto_maximum: _Optional[_Union[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingAutoMaximum, str]] = ..., bar_diameter_uniformly_surrounding_auto_maximum: _Optional[float] = ..., bar_diameter_uniformly_surrounding_auto_diameters_enabled: bool = ..., bar_diameter_uniformly_surrounding_auto_bar_sizes: _Optional[_Iterable[_Union[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterUniformlySurroundingAutoBarSizes, str]]] = ..., bar_diameter_uniformly_surrounding_auto_diameters: _Optional[_Iterable[float]] = ..., bar_diameter_uniformly_surrounding_auto_priority: _Optional[int] = ..., bar_size_designation_line: _Optional[float] = ..., bar_size_designation_line_calculated: _Optional[_Union[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineCalculated, str]] = ..., bar_diameter_line: _Optional[float] = ..., bar_diameter_line_calculated: _Optional[float] = ..., bar_diameter_line_auto_enabled: bool = ..., bar_size_designation_line_auto_minimum: _Optional[_Union[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineAutoMinimum, str]] = ..., bar_diameter_line_auto_minimum: _Optional[float] = ..., bar_size_designation_line_auto_maximum: _Optional[_Union[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineAutoMaximum, str]] = ..., bar_diameter_line_auto_maximum: _Optional[float] = ..., bar_diameter_line_auto_diameters_enabled: bool = ..., bar_diameter_line_auto_bar_sizes: _Optional[_Iterable[_Union[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterLineAutoBarSizes, str]]] = ..., bar_diameter_line_auto_diameters: _Optional[_Iterable[float]] = ..., bar_diameter_line_auto_priority: _Optional[int] = ..., bar_size_designation_single: _Optional[float] = ..., bar_size_designation_single_calculated: _Optional[_Union[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleCalculated, str]] = ..., bar_diameter_single: _Optional[float] = ..., bar_diameter_single_calculated: _Optional[float] = ..., bar_diameter_single_auto_enabled: bool = ..., bar_size_designation_single_auto_minimum: _Optional[_Union[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleAutoMinimum, str]] = ..., bar_diameter_single_auto_minimum: _Optional[float] = ..., bar_size_designation_single_auto_maximum: _Optional[_Union[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleAutoMaximum, str]] = ..., bar_diameter_single_auto_maximum: _Optional[float] = ..., bar_diameter_single_auto_diameters_enabled: bool = ..., bar_diameter_single_auto_bar_sizes: _Optional[_Iterable[_Union[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarDiameterSingleAutoBarSizes, str]]] = ..., bar_diameter_single_auto_diameters: _Optional[_Iterable[float]] = ..., bar_diameter_single_auto_priority: _Optional[int] = ..., bar_size_designation_corner: _Optional[_Union[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationCorner, str]] = ..., bar_diameter_corner: _Optional[float] = ..., base_diamter_reduced_multi_edit: _Optional[float] = ..., corner_reinforcement_enabled: bool = ..., reinforcement_area_symmetrical: _Optional[float] = ..., reinforcement_area_unsymmetrical_at_side: _Optional[float] = ..., reinforcement_area_unsymmetrical_top_side: _Optional[float] = ..., reinforcement_area_unsymmetrical_bottom_side: _Optional[float] = ..., reinforcement_area_uniformly_surrounding: _Optional[float] = ..., reinforcement_area_line: _Optional[float] = ..., reinforcement_area_single: _Optional[float] = ..., reinforcement_area_corner: _Optional[float] = ..., reinforcement_area_total: _Optional[float] = ..., span_position_reference_type: _Optional[_Union[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.SpanPositionReferenceType, str]] = ..., span_position_reference_internal_node: _Optional[int] = ..., span_position_reference_x_location_relative: _Optional[float] = ..., span_position_reference_x_location_absolute: _Optional[float] = ..., span_position_definition_format: _Optional[_Union[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.SpanPositionDefinitionFormat, str]] = ..., span_start_relative: _Optional[float] = ..., span_start_absolute: _Optional[float] = ..., span_start_auto_enabled: bool = ..., span_start_relative_auto_calculated: _Optional[float] = ..., span_start_relative_auto_minimum: _Optional[float] = ..., span_start_relative_auto_maximum: _Optional[float] = ..., span_start_absolute_auto_calculated: _Optional[float] = ..., span_start_absolute_auto_minimum: _Optional[float] = ..., span_start_absolute_auto_maximum: _Optional[float] = ..., span_end_relative: _Optional[float] = ..., span_end_absolute: _Optional[float] = ..., span_end_auto_enabled: bool = ..., span_end_relative_auto_calculated: _Optional[float] = ..., span_end_relative_auto_minimum: _Optional[float] = ..., span_end_relative_auto_maximum: _Optional[float] = ..., span_end_absolute_auto_calculated: _Optional[float] = ..., span_end_absolute_auto_minimum: _Optional[float] = ..., span_end_absolute_auto_maximum: _Optional[float] = ..., span_location_auto_increment: _Optional[float] = ..., span_location_auto_priority: _Optional[int] = ..., span_length: _Optional[float] = ..., additional_offset_type: _Optional[_Union[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetType, str]] = ..., additional_offset_type_single_line: _Optional[_Union[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetTypeSingleLine, str]] = ..., additional_offset_circle: _Optional[float] = ..., additional_offset_top_side: _Optional[float] = ..., additional_offset_bottom_side: _Optional[float] = ..., additional_offset_left_side: _Optional[float] = ..., additional_offset_right_side: _Optional[float] = ..., additional_offset_reference_type: _Optional[_Union[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceType, str]] = ..., additional_offset_reference_type_at_start: _Optional[_Union[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceTypeAtStart, str]] = ..., additional_offset_reference_type_at_end: _Optional[_Union[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceTypeAtEnd, str]] = ..., additional_horizontal_offset: _Optional[float] = ..., additional_horizontal_offset_at_start: _Optional[float] = ..., additional_horizontal_offset_at_end: _Optional[float] = ..., additional_vertical_offset: _Optional[float] = ..., additional_vertical_offset_at_start: _Optional[float] = ..., additional_vertical_offset_at_end: _Optional[float] = ..., anchorage_start_anchor_type: _Optional[_Union[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.AnchorageStartAnchorType, str]] = ..., anchorage_start_anchor_length: _Optional[float] = ..., anchorage_start_bending_diameter: _Optional[float] = ..., anchorage_end_anchor_type: _Optional[_Union[MemberRepresentative.ConcreteLongitudinalReinforcementItemsRow.AnchorageEndAnchorType, str]] = ..., anchorage_end_anchor_length: _Optional[float] = ..., anchorage_end_bending_diameter: _Optional[float] = ..., one_rebar_length: _Optional[float] = ..., one_rebar_minimal_and_maximal_length: _Optional[str] = ..., one_rebar_unsymmetrical_at_side_length: _Optional[float] = ..., one_rebar_unsymmetrical_at_side_minimal_and_maximal_length: _Optional[str] = ..., one_rebar_unsymmetrical_top_side_length: _Optional[float] = ..., one_rebar_unsymmetrical_top_side_minimal_and_maximal_length: _Optional[str] = ..., one_rebar_unsymmetrical_bottom_side_length: _Optional[float] = ..., one_rebar_unsymmetrical_bottom_side_minimal_and_maximal_length: _Optional[str] = ..., one_rebar_corner_length: _Optional[float] = ..., one_rebar_corner_minimal_and_maximal_length: _Optional[str] = ..., length: _Optional[float] = ..., one_rebar_weight: _Optional[float] = ..., one_rebar_minimal_and_maximal_weight: _Optional[str] = ..., one_rebar_unsymmetrical_at_side_weight: _Optional[float] = ..., one_rebar_unsymmetrical_at_side_minimal_and_maximal_weight: _Optional[str] = ..., one_rebar_unsymmetrical_top_side_weight: _Optional[float] = ..., one_rebar_unsymmetrical_top_side_minimal_and_maximal_weight: _Optional[str] = ..., one_rebar_unsymmetrical_bottom_side_weight: _Optional[float] = ..., one_rebar_unsymmetrical_bottom_side_minimal_and_maximal_weight: _Optional[str] = ..., one_rebar_corner_weight: _Optional[float] = ..., one_rebar_corner_minimal_and_maximal_weight: _Optional[str] = ..., weight: _Optional[float] = ...) -> None: ...
    class DesignSupportsOnInternalNodesTable(_message.Message):
        __slots__ = ("rows",)
        ROWS_FIELD_NUMBER: _ClassVar[int]
        rows: _containers.RepeatedCompositeFieldContainer[MemberRepresentative.DesignSupportsOnInternalNodesRow]
        def __init__(self, rows: _Optional[_Iterable[_Union[MemberRepresentative.DesignSupportsOnInternalNodesRow, _Mapping]]] = ...) -> None: ...
    class DesignSupportsOnInternalNodesRow(_message.Message):
        __slots__ = ("no", "description", "node", "design_support")
        NO_FIELD_NUMBER: _ClassVar[int]
        DESCRIPTION_FIELD_NUMBER: _ClassVar[int]
        NODE_FIELD_NUMBER: _ClassVar[int]
        DESIGN_SUPPORT_FIELD_NUMBER: _ClassVar[int]
        no: int
        description: str
        node: str
        design_support: int
        def __init__(self, no: _Optional[int] = ..., description: _Optional[str] = ..., node: _Optional[str] = ..., design_support: _Optional[int] = ...) -> None: ...
    class DeflectionSegmentsYAxisTable(_message.Message):
        __slots__ = ("rows",)
        ROWS_FIELD_NUMBER: _ClassVar[int]
        rows: _containers.RepeatedCompositeFieldContainer[MemberRepresentative.DeflectionSegmentsYAxisRow]
        def __init__(self, rows: _Optional[_Iterable[_Union[MemberRepresentative.DeflectionSegmentsYAxisRow, _Mapping]]] = ...) -> None: ...
    class DeflectionSegmentsYAxisRow(_message.Message):
        __slots__ = ("no", "description", "active", "length", "precamber", "segment_type")
        NO_FIELD_NUMBER: _ClassVar[int]
        DESCRIPTION_FIELD_NUMBER: _ClassVar[int]
        ACTIVE_FIELD_NUMBER: _ClassVar[int]
        LENGTH_FIELD_NUMBER: _ClassVar[int]
        PRECAMBER_FIELD_NUMBER: _ClassVar[int]
        SEGMENT_TYPE_FIELD_NUMBER: _ClassVar[int]
        no: int
        description: str
        active: bool
        length: float
        precamber: float
        segment_type: str
        def __init__(self, no: _Optional[int] = ..., description: _Optional[str] = ..., active: bool = ..., length: _Optional[float] = ..., precamber: _Optional[float] = ..., segment_type: _Optional[str] = ...) -> None: ...
    class DeflectionSegmentsZAxisTable(_message.Message):
        __slots__ = ("rows",)
        ROWS_FIELD_NUMBER: _ClassVar[int]
        rows: _containers.RepeatedCompositeFieldContainer[MemberRepresentative.DeflectionSegmentsZAxisRow]
        def __init__(self, rows: _Optional[_Iterable[_Union[MemberRepresentative.DeflectionSegmentsZAxisRow, _Mapping]]] = ...) -> None: ...
    class DeflectionSegmentsZAxisRow(_message.Message):
        __slots__ = ("no", "description", "active", "length", "precamber", "segment_type")
        NO_FIELD_NUMBER: _ClassVar[int]
        DESCRIPTION_FIELD_NUMBER: _ClassVar[int]
        ACTIVE_FIELD_NUMBER: _ClassVar[int]
        LENGTH_FIELD_NUMBER: _ClassVar[int]
        PRECAMBER_FIELD_NUMBER: _ClassVar[int]
        SEGMENT_TYPE_FIELD_NUMBER: _ClassVar[int]
        no: int
        description: str
        active: bool
        length: float
        precamber: float
        segment_type: str
        def __init__(self, no: _Optional[int] = ..., description: _Optional[str] = ..., active: bool = ..., length: _Optional[float] = ..., precamber: _Optional[float] = ..., segment_type: _Optional[str] = ...) -> None: ...
    class ConcreteLongitudinalReinforcementSpanTable(_message.Message):
        __slots__ = ("rows",)
        ROWS_FIELD_NUMBER: _ClassVar[int]
        rows: _containers.RepeatedCompositeFieldContainer[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow]
        def __init__(self, rows: _Optional[_Iterable[_Union[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow, _Mapping]]] = ...) -> None: ...
    class ConcreteLongitudinalReinforcementSpanRow(_message.Message):
        __slots__ = ("no", "description", "name", "rebar_type", "material", "reinforcement_placed_in_bending_corner_enabled", "bar_count_symmetrical", "bar_count_symmetrical_calculated", "bar_count_symmetrical_auto_enabled", "bar_count_symmetrical_auto_minimum", "bar_count_symmetrical_auto_maximum", "bar_count_symmetrical_auto_increment", "bar_count_symmetrical_auto_priority", "bar_count_unsymmetrical_at_side", "bar_count_unsymmetrical_top_side", "bar_count_unsymmetrical_top_side_calculated", "bar_count_unsymmetrical_top_side_auto_enabled", "bar_count_unsymmetrical_top_side_auto_minimum", "bar_count_unsymmetrical_top_side_auto_maximum", "bar_count_unsymmetrical_top_side_auto_increment", "bar_count_unsymmetrical_top_side_auto_priority", "bar_count_unsymmetrical_bottom_side", "bar_count_unsymmetrical_bottom_side_calculated", "bar_count_unsymmetrical_bottom_side_auto_enabled", "bar_count_unsymmetrical_bottom_side_auto_minimum", "bar_count_unsymmetrical_bottom_side_auto_maximum", "bar_count_unsymmetrical_bottom_side_auto_increment", "bar_count_unsymmetrical_bottom_side_auto_priority", "bar_count_uniformly_surrounding", "bar_count_uniformly_surrounding_calculated", "bar_count_uniformly_surrounding_auto_enabled", "bar_count_uniformly_surrounding_auto_minimum", "bar_count_uniformly_surrounding_auto_maximum", "bar_count_uniformly_surrounding_auto_increment", "bar_count_uniformly_surrounding_auto_priority", "bar_count_line", "bar_count_line_calculated", "bar_count_line_auto_enabled", "bar_count_line_auto_minimum", "bar_count_line_auto_maximum", "bar_count_line_auto_increment", "bar_count_line_auto_priority", "bar_count_corner", "bar_size_designation_symmetrical", "bar_size_designation_symmetrical_calculated", "bar_diameter_symmetrical", "bar_diameter_symmetrical_calculated", "bar_diameter_symmetrical_auto_enabled", "bar_size_designation_symmetrical_auto_minimum", "bar_diameter_symmetrical_auto_minimum", "bar_size_designation_symmetrical_auto_maximum", "bar_diameter_symmetrical_auto_maximum", "bar_diameter_symmetrical_auto_diameters_enabled", "bar_diameter_symmetrical_auto_bar_sizes", "bar_diameter_symmetrical_auto_diameters", "bar_diameter_symmetrical_auto_priority", "bar_size_designation_unsymmetrical_at_side", "bar_diameter_unsymmetrical_at_side", "bar_size_designation_unsymmetrical_top_side", "bar_size_designation_unsymmetrical_top_side_calculated", "bar_diameter_unsymmetrical_top_side", "bar_diameter_unsymmetrical_top_side_calculated", "bar_diameter_unsymmetrical_top_side_auto_enabled", "bar_size_designation_unsymmetrical_top_side_auto_minimum", "bar_diameter_unsymmetrical_top_side_auto_minimum", "bar_size_designation_unsymmetrical_top_side_auto_maximum", "bar_diameter_unsymmetrical_top_side_auto_maximum", "bar_diameter_unsymmetrical_top_side_auto_diameters_enabled", "bar_diameter_unsymmetrical_top_side_auto_bar_sizes", "bar_diameter_unsymmetrical_top_side_auto_diameters", "bar_diameter_unsymmetrical_top_side_auto_priority", "bar_size_designation_unsymmetrical_bottom_side", "bar_size_designation_unsymmetrical_bottom_side_calculated", "bar_diameter_unsymmetrical_bottom_side", "bar_diameter_unsymmetrical_bottom_side_calculated", "bar_diameter_unsymmetrical_bottom_side_auto_enabled", "bar_size_designation_unsymmetrical_bottom_side_auto_minimum", "bar_diameter_unsymmetrical_bottom_side_auto_minimum", "bar_size_designation_unsymmetrical_bottom_side_auto_maximum", "bar_diameter_unsymmetrical_bottom_side_auto_maximum", "bar_diameter_unsymmetrical_bottom_side_auto_diameters_enabled", "bar_diameter_unsymmetrical_bottom_side_auto_bar_sizes", "bar_diameter_unsymmetrical_bottom_side_auto_diameters", "bar_diameter_unsymmetrical_bottom_side_auto_priority", "bar_size_designation_uniformly_surrounding", "bar_size_designation_uniformly_surrounding_calculated", "bar_diameter_uniformly_surrounding", "bar_diameter_uniformly_surrounding_calculated", "bar_diameter_uniformly_surrounding_auto_enabled", "bar_size_designation_uniformly_surrounding_auto_minimum", "bar_diameter_uniformly_surrounding_auto_minimum", "bar_size_designation_uniformly_surrounding_auto_maximum", "bar_diameter_uniformly_surrounding_auto_maximum", "bar_diameter_uniformly_surrounding_auto_diameters_enabled", "bar_diameter_uniformly_surrounding_auto_bar_sizes", "bar_diameter_uniformly_surrounding_auto_diameters", "bar_diameter_uniformly_surrounding_auto_priority", "bar_size_designation_line", "bar_size_designation_line_calculated", "bar_diameter_line", "bar_diameter_line_calculated", "bar_diameter_line_auto_enabled", "bar_size_designation_line_auto_minimum", "bar_diameter_line_auto_minimum", "bar_size_designation_line_auto_maximum", "bar_diameter_line_auto_maximum", "bar_diameter_line_auto_diameters_enabled", "bar_diameter_line_auto_bar_sizes", "bar_diameter_line_auto_diameters", "bar_diameter_line_auto_priority", "bar_size_designation_single", "bar_size_designation_single_calculated", "bar_diameter_single", "bar_diameter_single_calculated", "bar_diameter_single_auto_enabled", "bar_size_designation_single_auto_minimum", "bar_diameter_single_auto_minimum", "bar_size_designation_single_auto_maximum", "bar_diameter_single_auto_maximum", "bar_diameter_single_auto_diameters_enabled", "bar_diameter_single_auto_bar_sizes", "bar_diameter_single_auto_diameters", "bar_diameter_single_auto_priority", "bar_size_designation_corner", "bar_diameter_corner", "base_diamter_reduced_multi_edit", "corner_reinforcement_enabled", "reinforcement_area_symmetrical", "reinforcement_area_unsymmetrical_at_side", "reinforcement_area_unsymmetrical_top_side", "reinforcement_area_unsymmetrical_bottom_side", "reinforcement_area_uniformly_surrounding", "reinforcement_area_line", "reinforcement_area_single", "reinforcement_area_corner", "reinforcement_area_total", "span_position_reference_type", "span_position_reference_internal_node", "span_position_reference_x_location_relative", "span_position_reference_x_location_absolute", "span_position_definition_format", "span_start_relative", "span_start_absolute", "span_start_auto_enabled", "span_start_relative_auto_calculated", "span_start_relative_auto_minimum", "span_start_relative_auto_maximum", "span_start_absolute_auto_calculated", "span_start_absolute_auto_minimum", "span_start_absolute_auto_maximum", "span_end_relative", "span_end_absolute", "span_end_auto_enabled", "span_end_relative_auto_calculated", "span_end_relative_auto_minimum", "span_end_relative_auto_maximum", "span_end_absolute_auto_calculated", "span_end_absolute_auto_minimum", "span_end_absolute_auto_maximum", "span_location_auto_increment", "span_location_auto_priority", "span_length", "additional_offset_type", "additional_offset_type_single_line", "additional_offset_circle", "additional_offset_top_side", "additional_offset_bottom_side", "additional_offset_left_side", "additional_offset_right_side", "additional_offset_reference_type", "additional_offset_reference_type_at_start", "additional_offset_reference_type_at_end", "additional_horizontal_offset", "additional_horizontal_offset_at_start", "additional_horizontal_offset_at_end", "additional_vertical_offset", "additional_vertical_offset_at_start", "additional_vertical_offset_at_end", "anchorage_start_anchor_type", "anchorage_start_anchor_length", "anchorage_start_bending_diameter", "anchorage_end_anchor_type", "anchorage_end_anchor_length", "anchorage_end_bending_diameter", "one_rebar_length", "one_rebar_minimal_and_maximal_length", "one_rebar_unsymmetrical_at_side_length", "one_rebar_unsymmetrical_at_side_minimal_and_maximal_length", "one_rebar_unsymmetrical_top_side_length", "one_rebar_unsymmetrical_top_side_minimal_and_maximal_length", "one_rebar_unsymmetrical_bottom_side_length", "one_rebar_unsymmetrical_bottom_side_minimal_and_maximal_length", "one_rebar_corner_length", "one_rebar_corner_minimal_and_maximal_length", "length", "one_rebar_weight", "one_rebar_minimal_and_maximal_weight", "one_rebar_unsymmetrical_at_side_weight", "one_rebar_unsymmetrical_at_side_minimal_and_maximal_weight", "one_rebar_unsymmetrical_top_side_weight", "one_rebar_unsymmetrical_top_side_minimal_and_maximal_weight", "one_rebar_unsymmetrical_bottom_side_weight", "one_rebar_unsymmetrical_bottom_side_minimal_and_maximal_weight", "one_rebar_corner_weight", "one_rebar_corner_minimal_and_maximal_weight", "weight")
        class RebarType(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            REBAR_TYPE_SYMMETRICAL: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.RebarType]
            REBAR_TYPE_LINE: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.RebarType]
            REBAR_TYPE_SINGLE: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.RebarType]
            REBAR_TYPE_UNIFORMLY_SURROUNDING: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.RebarType]
            REBAR_TYPE_UNSYMMETRICAL: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.RebarType]
        REBAR_TYPE_SYMMETRICAL: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.RebarType
        REBAR_TYPE_LINE: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.RebarType
        REBAR_TYPE_SINGLE: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.RebarType
        REBAR_TYPE_UNIFORMLY_SURROUNDING: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.RebarType
        REBAR_TYPE_UNSYMMETRICAL: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.RebarType
        class BarSizeDesignationSymmetricalCalculated(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_UNKNOWN: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationSymmetricalCalculated]
            BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_ACI_1: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationSymmetricalCalculated]
            BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_ACI_10: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationSymmetricalCalculated]
            BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_ACI_11: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationSymmetricalCalculated]
            BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_ACI_12: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationSymmetricalCalculated]
            BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_ACI_14: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationSymmetricalCalculated]
            BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_ACI_16: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationSymmetricalCalculated]
            BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_ACI_18: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationSymmetricalCalculated]
            BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_ACI_1p5: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationSymmetricalCalculated]
            BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_ACI_2: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationSymmetricalCalculated]
            BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_ACI_2p5: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationSymmetricalCalculated]
            BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_ACI_3: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationSymmetricalCalculated]
            BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_ACI_4: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationSymmetricalCalculated]
            BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_ACI_5: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationSymmetricalCalculated]
            BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_ACI_6: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationSymmetricalCalculated]
            BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_ACI_7: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationSymmetricalCalculated]
            BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_ACI_8: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationSymmetricalCalculated]
            BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_ACI_9: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationSymmetricalCalculated]
            BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_CSA_10: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationSymmetricalCalculated]
            BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_CSA_15: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationSymmetricalCalculated]
            BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_CSA_20: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationSymmetricalCalculated]
            BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_CSA_25: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationSymmetricalCalculated]
            BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_CSA_30: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationSymmetricalCalculated]
            BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_CSA_35: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationSymmetricalCalculated]
            BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_CSA_45: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationSymmetricalCalculated]
            BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_CSA_55: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationSymmetricalCalculated]
        BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_UNKNOWN: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationSymmetricalCalculated
        BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_ACI_1: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationSymmetricalCalculated
        BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_ACI_10: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationSymmetricalCalculated
        BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_ACI_11: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationSymmetricalCalculated
        BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_ACI_12: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationSymmetricalCalculated
        BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_ACI_14: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationSymmetricalCalculated
        BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_ACI_16: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationSymmetricalCalculated
        BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_ACI_18: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationSymmetricalCalculated
        BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_ACI_1p5: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationSymmetricalCalculated
        BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_ACI_2: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationSymmetricalCalculated
        BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_ACI_2p5: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationSymmetricalCalculated
        BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_ACI_3: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationSymmetricalCalculated
        BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_ACI_4: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationSymmetricalCalculated
        BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_ACI_5: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationSymmetricalCalculated
        BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_ACI_6: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationSymmetricalCalculated
        BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_ACI_7: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationSymmetricalCalculated
        BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_ACI_8: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationSymmetricalCalculated
        BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_ACI_9: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationSymmetricalCalculated
        BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_CSA_10: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationSymmetricalCalculated
        BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_CSA_15: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationSymmetricalCalculated
        BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_CSA_20: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationSymmetricalCalculated
        BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_CSA_25: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationSymmetricalCalculated
        BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_CSA_30: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationSymmetricalCalculated
        BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_CSA_35: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationSymmetricalCalculated
        BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_CSA_45: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationSymmetricalCalculated
        BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_CSA_55: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationSymmetricalCalculated
        class BarSizeDesignationSymmetricalAutoMinimum(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            BAR_SIZE_DESIGNATION_SYMMETRICAL_AUTO_MINIMUM_UNKNOWN: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationSymmetricalAutoMinimum]
        BAR_SIZE_DESIGNATION_SYMMETRICAL_AUTO_MINIMUM_UNKNOWN: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationSymmetricalAutoMinimum
        class BarSizeDesignationSymmetricalAutoMaximum(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            BAR_SIZE_DESIGNATION_SYMMETRICAL_AUTO_MAXIMUM_UNKNOWN: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationSymmetricalAutoMaximum]
        BAR_SIZE_DESIGNATION_SYMMETRICAL_AUTO_MAXIMUM_UNKNOWN: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationSymmetricalAutoMaximum
        class BarDiameterSymmetricalAutoBarSizes(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            BAR_DIAMETER_SYMMETRICAL_AUTO_BAR_SIZES_UNKNOWN: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterSymmetricalAutoBarSizes]
            BAR_DIAMETER_SYMMETRICAL_AUTO_BAR_SIZES_ACI_1: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterSymmetricalAutoBarSizes]
            BAR_DIAMETER_SYMMETRICAL_AUTO_BAR_SIZES_ACI_10: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterSymmetricalAutoBarSizes]
            BAR_DIAMETER_SYMMETRICAL_AUTO_BAR_SIZES_ACI_11: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterSymmetricalAutoBarSizes]
            BAR_DIAMETER_SYMMETRICAL_AUTO_BAR_SIZES_ACI_12: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterSymmetricalAutoBarSizes]
            BAR_DIAMETER_SYMMETRICAL_AUTO_BAR_SIZES_ACI_14: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterSymmetricalAutoBarSizes]
            BAR_DIAMETER_SYMMETRICAL_AUTO_BAR_SIZES_ACI_16: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterSymmetricalAutoBarSizes]
            BAR_DIAMETER_SYMMETRICAL_AUTO_BAR_SIZES_ACI_18: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterSymmetricalAutoBarSizes]
            BAR_DIAMETER_SYMMETRICAL_AUTO_BAR_SIZES_ACI_1p5: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterSymmetricalAutoBarSizes]
            BAR_DIAMETER_SYMMETRICAL_AUTO_BAR_SIZES_ACI_2: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterSymmetricalAutoBarSizes]
            BAR_DIAMETER_SYMMETRICAL_AUTO_BAR_SIZES_ACI_2p5: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterSymmetricalAutoBarSizes]
            BAR_DIAMETER_SYMMETRICAL_AUTO_BAR_SIZES_ACI_3: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterSymmetricalAutoBarSizes]
            BAR_DIAMETER_SYMMETRICAL_AUTO_BAR_SIZES_ACI_4: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterSymmetricalAutoBarSizes]
            BAR_DIAMETER_SYMMETRICAL_AUTO_BAR_SIZES_ACI_5: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterSymmetricalAutoBarSizes]
            BAR_DIAMETER_SYMMETRICAL_AUTO_BAR_SIZES_ACI_6: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterSymmetricalAutoBarSizes]
            BAR_DIAMETER_SYMMETRICAL_AUTO_BAR_SIZES_ACI_7: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterSymmetricalAutoBarSizes]
            BAR_DIAMETER_SYMMETRICAL_AUTO_BAR_SIZES_ACI_8: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterSymmetricalAutoBarSizes]
            BAR_DIAMETER_SYMMETRICAL_AUTO_BAR_SIZES_ACI_9: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterSymmetricalAutoBarSizes]
            BAR_DIAMETER_SYMMETRICAL_AUTO_BAR_SIZES_CSA_10: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterSymmetricalAutoBarSizes]
            BAR_DIAMETER_SYMMETRICAL_AUTO_BAR_SIZES_CSA_15: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterSymmetricalAutoBarSizes]
            BAR_DIAMETER_SYMMETRICAL_AUTO_BAR_SIZES_CSA_20: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterSymmetricalAutoBarSizes]
            BAR_DIAMETER_SYMMETRICAL_AUTO_BAR_SIZES_CSA_25: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterSymmetricalAutoBarSizes]
            BAR_DIAMETER_SYMMETRICAL_AUTO_BAR_SIZES_CSA_30: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterSymmetricalAutoBarSizes]
            BAR_DIAMETER_SYMMETRICAL_AUTO_BAR_SIZES_CSA_35: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterSymmetricalAutoBarSizes]
            BAR_DIAMETER_SYMMETRICAL_AUTO_BAR_SIZES_CSA_45: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterSymmetricalAutoBarSizes]
            BAR_DIAMETER_SYMMETRICAL_AUTO_BAR_SIZES_CSA_55: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterSymmetricalAutoBarSizes]
        BAR_DIAMETER_SYMMETRICAL_AUTO_BAR_SIZES_UNKNOWN: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterSymmetricalAutoBarSizes
        BAR_DIAMETER_SYMMETRICAL_AUTO_BAR_SIZES_ACI_1: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterSymmetricalAutoBarSizes
        BAR_DIAMETER_SYMMETRICAL_AUTO_BAR_SIZES_ACI_10: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterSymmetricalAutoBarSizes
        BAR_DIAMETER_SYMMETRICAL_AUTO_BAR_SIZES_ACI_11: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterSymmetricalAutoBarSizes
        BAR_DIAMETER_SYMMETRICAL_AUTO_BAR_SIZES_ACI_12: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterSymmetricalAutoBarSizes
        BAR_DIAMETER_SYMMETRICAL_AUTO_BAR_SIZES_ACI_14: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterSymmetricalAutoBarSizes
        BAR_DIAMETER_SYMMETRICAL_AUTO_BAR_SIZES_ACI_16: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterSymmetricalAutoBarSizes
        BAR_DIAMETER_SYMMETRICAL_AUTO_BAR_SIZES_ACI_18: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterSymmetricalAutoBarSizes
        BAR_DIAMETER_SYMMETRICAL_AUTO_BAR_SIZES_ACI_1p5: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterSymmetricalAutoBarSizes
        BAR_DIAMETER_SYMMETRICAL_AUTO_BAR_SIZES_ACI_2: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterSymmetricalAutoBarSizes
        BAR_DIAMETER_SYMMETRICAL_AUTO_BAR_SIZES_ACI_2p5: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterSymmetricalAutoBarSizes
        BAR_DIAMETER_SYMMETRICAL_AUTO_BAR_SIZES_ACI_3: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterSymmetricalAutoBarSizes
        BAR_DIAMETER_SYMMETRICAL_AUTO_BAR_SIZES_ACI_4: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterSymmetricalAutoBarSizes
        BAR_DIAMETER_SYMMETRICAL_AUTO_BAR_SIZES_ACI_5: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterSymmetricalAutoBarSizes
        BAR_DIAMETER_SYMMETRICAL_AUTO_BAR_SIZES_ACI_6: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterSymmetricalAutoBarSizes
        BAR_DIAMETER_SYMMETRICAL_AUTO_BAR_SIZES_ACI_7: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterSymmetricalAutoBarSizes
        BAR_DIAMETER_SYMMETRICAL_AUTO_BAR_SIZES_ACI_8: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterSymmetricalAutoBarSizes
        BAR_DIAMETER_SYMMETRICAL_AUTO_BAR_SIZES_ACI_9: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterSymmetricalAutoBarSizes
        BAR_DIAMETER_SYMMETRICAL_AUTO_BAR_SIZES_CSA_10: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterSymmetricalAutoBarSizes
        BAR_DIAMETER_SYMMETRICAL_AUTO_BAR_SIZES_CSA_15: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterSymmetricalAutoBarSizes
        BAR_DIAMETER_SYMMETRICAL_AUTO_BAR_SIZES_CSA_20: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterSymmetricalAutoBarSizes
        BAR_DIAMETER_SYMMETRICAL_AUTO_BAR_SIZES_CSA_25: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterSymmetricalAutoBarSizes
        BAR_DIAMETER_SYMMETRICAL_AUTO_BAR_SIZES_CSA_30: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterSymmetricalAutoBarSizes
        BAR_DIAMETER_SYMMETRICAL_AUTO_BAR_SIZES_CSA_35: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterSymmetricalAutoBarSizes
        BAR_DIAMETER_SYMMETRICAL_AUTO_BAR_SIZES_CSA_45: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterSymmetricalAutoBarSizes
        BAR_DIAMETER_SYMMETRICAL_AUTO_BAR_SIZES_CSA_55: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterSymmetricalAutoBarSizes
        class BarSizeDesignationUnsymmetricalAtSide(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_AT_SIDE_UNKNOWN: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUnsymmetricalAtSide]
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_AT_SIDE_UNKNOWN: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUnsymmetricalAtSide
        class BarSizeDesignationUnsymmetricalTopSideCalculated(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_UNKNOWN: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUnsymmetricalTopSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_ACI_1: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUnsymmetricalTopSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_ACI_10: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUnsymmetricalTopSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_ACI_11: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUnsymmetricalTopSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_ACI_12: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUnsymmetricalTopSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_ACI_14: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUnsymmetricalTopSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_ACI_16: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUnsymmetricalTopSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_ACI_18: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUnsymmetricalTopSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_ACI_1p5: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUnsymmetricalTopSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_ACI_2: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUnsymmetricalTopSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_ACI_2p5: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUnsymmetricalTopSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_ACI_3: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUnsymmetricalTopSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_ACI_4: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUnsymmetricalTopSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_ACI_5: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUnsymmetricalTopSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_ACI_6: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUnsymmetricalTopSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_ACI_7: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUnsymmetricalTopSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_ACI_8: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUnsymmetricalTopSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_ACI_9: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUnsymmetricalTopSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_CSA_10: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUnsymmetricalTopSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_CSA_15: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUnsymmetricalTopSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_CSA_20: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUnsymmetricalTopSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_CSA_25: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUnsymmetricalTopSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_CSA_30: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUnsymmetricalTopSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_CSA_35: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUnsymmetricalTopSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_CSA_45: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUnsymmetricalTopSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_CSA_55: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUnsymmetricalTopSideCalculated]
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_UNKNOWN: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUnsymmetricalTopSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_ACI_1: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUnsymmetricalTopSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_ACI_10: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUnsymmetricalTopSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_ACI_11: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUnsymmetricalTopSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_ACI_12: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUnsymmetricalTopSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_ACI_14: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUnsymmetricalTopSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_ACI_16: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUnsymmetricalTopSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_ACI_18: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUnsymmetricalTopSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_ACI_1p5: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUnsymmetricalTopSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_ACI_2: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUnsymmetricalTopSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_ACI_2p5: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUnsymmetricalTopSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_ACI_3: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUnsymmetricalTopSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_ACI_4: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUnsymmetricalTopSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_ACI_5: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUnsymmetricalTopSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_ACI_6: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUnsymmetricalTopSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_ACI_7: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUnsymmetricalTopSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_ACI_8: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUnsymmetricalTopSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_ACI_9: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUnsymmetricalTopSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_CSA_10: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUnsymmetricalTopSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_CSA_15: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUnsymmetricalTopSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_CSA_20: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUnsymmetricalTopSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_CSA_25: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUnsymmetricalTopSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_CSA_30: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUnsymmetricalTopSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_CSA_35: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUnsymmetricalTopSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_CSA_45: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUnsymmetricalTopSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_CSA_55: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUnsymmetricalTopSideCalculated
        class BarSizeDesignationUnsymmetricalTopSideAutoMinimum(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_AUTO_MINIMUM_UNKNOWN: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUnsymmetricalTopSideAutoMinimum]
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_AUTO_MINIMUM_UNKNOWN: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUnsymmetricalTopSideAutoMinimum
        class BarSizeDesignationUnsymmetricalTopSideAutoMaximum(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_AUTO_MAXIMUM_UNKNOWN: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUnsymmetricalTopSideAutoMaximum]
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_AUTO_MAXIMUM_UNKNOWN: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUnsymmetricalTopSideAutoMaximum
        class BarDiameterUnsymmetricalTopSideAutoBarSizes(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            BAR_DIAMETER_UNSYMMETRICAL_TOP_SIDE_AUTO_BAR_SIZES_UNKNOWN: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterUnsymmetricalTopSideAutoBarSizes]
            BAR_DIAMETER_UNSYMMETRICAL_TOP_SIDE_AUTO_BAR_SIZES_ACI_1: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterUnsymmetricalTopSideAutoBarSizes]
            BAR_DIAMETER_UNSYMMETRICAL_TOP_SIDE_AUTO_BAR_SIZES_ACI_10: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterUnsymmetricalTopSideAutoBarSizes]
            BAR_DIAMETER_UNSYMMETRICAL_TOP_SIDE_AUTO_BAR_SIZES_ACI_11: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterUnsymmetricalTopSideAutoBarSizes]
            BAR_DIAMETER_UNSYMMETRICAL_TOP_SIDE_AUTO_BAR_SIZES_ACI_12: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterUnsymmetricalTopSideAutoBarSizes]
            BAR_DIAMETER_UNSYMMETRICAL_TOP_SIDE_AUTO_BAR_SIZES_ACI_14: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterUnsymmetricalTopSideAutoBarSizes]
            BAR_DIAMETER_UNSYMMETRICAL_TOP_SIDE_AUTO_BAR_SIZES_ACI_16: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterUnsymmetricalTopSideAutoBarSizes]
            BAR_DIAMETER_UNSYMMETRICAL_TOP_SIDE_AUTO_BAR_SIZES_ACI_18: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterUnsymmetricalTopSideAutoBarSizes]
            BAR_DIAMETER_UNSYMMETRICAL_TOP_SIDE_AUTO_BAR_SIZES_ACI_1p5: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterUnsymmetricalTopSideAutoBarSizes]
            BAR_DIAMETER_UNSYMMETRICAL_TOP_SIDE_AUTO_BAR_SIZES_ACI_2: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterUnsymmetricalTopSideAutoBarSizes]
            BAR_DIAMETER_UNSYMMETRICAL_TOP_SIDE_AUTO_BAR_SIZES_ACI_2p5: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterUnsymmetricalTopSideAutoBarSizes]
            BAR_DIAMETER_UNSYMMETRICAL_TOP_SIDE_AUTO_BAR_SIZES_ACI_3: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterUnsymmetricalTopSideAutoBarSizes]
            BAR_DIAMETER_UNSYMMETRICAL_TOP_SIDE_AUTO_BAR_SIZES_ACI_4: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterUnsymmetricalTopSideAutoBarSizes]
            BAR_DIAMETER_UNSYMMETRICAL_TOP_SIDE_AUTO_BAR_SIZES_ACI_5: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterUnsymmetricalTopSideAutoBarSizes]
            BAR_DIAMETER_UNSYMMETRICAL_TOP_SIDE_AUTO_BAR_SIZES_ACI_6: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterUnsymmetricalTopSideAutoBarSizes]
            BAR_DIAMETER_UNSYMMETRICAL_TOP_SIDE_AUTO_BAR_SIZES_ACI_7: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterUnsymmetricalTopSideAutoBarSizes]
            BAR_DIAMETER_UNSYMMETRICAL_TOP_SIDE_AUTO_BAR_SIZES_ACI_8: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterUnsymmetricalTopSideAutoBarSizes]
            BAR_DIAMETER_UNSYMMETRICAL_TOP_SIDE_AUTO_BAR_SIZES_ACI_9: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterUnsymmetricalTopSideAutoBarSizes]
            BAR_DIAMETER_UNSYMMETRICAL_TOP_SIDE_AUTO_BAR_SIZES_CSA_10: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterUnsymmetricalTopSideAutoBarSizes]
            BAR_DIAMETER_UNSYMMETRICAL_TOP_SIDE_AUTO_BAR_SIZES_CSA_15: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterUnsymmetricalTopSideAutoBarSizes]
            BAR_DIAMETER_UNSYMMETRICAL_TOP_SIDE_AUTO_BAR_SIZES_CSA_20: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterUnsymmetricalTopSideAutoBarSizes]
            BAR_DIAMETER_UNSYMMETRICAL_TOP_SIDE_AUTO_BAR_SIZES_CSA_25: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterUnsymmetricalTopSideAutoBarSizes]
            BAR_DIAMETER_UNSYMMETRICAL_TOP_SIDE_AUTO_BAR_SIZES_CSA_30: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterUnsymmetricalTopSideAutoBarSizes]
            BAR_DIAMETER_UNSYMMETRICAL_TOP_SIDE_AUTO_BAR_SIZES_CSA_35: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterUnsymmetricalTopSideAutoBarSizes]
            BAR_DIAMETER_UNSYMMETRICAL_TOP_SIDE_AUTO_BAR_SIZES_CSA_45: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterUnsymmetricalTopSideAutoBarSizes]
            BAR_DIAMETER_UNSYMMETRICAL_TOP_SIDE_AUTO_BAR_SIZES_CSA_55: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterUnsymmetricalTopSideAutoBarSizes]
        BAR_DIAMETER_UNSYMMETRICAL_TOP_SIDE_AUTO_BAR_SIZES_UNKNOWN: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterUnsymmetricalTopSideAutoBarSizes
        BAR_DIAMETER_UNSYMMETRICAL_TOP_SIDE_AUTO_BAR_SIZES_ACI_1: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterUnsymmetricalTopSideAutoBarSizes
        BAR_DIAMETER_UNSYMMETRICAL_TOP_SIDE_AUTO_BAR_SIZES_ACI_10: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterUnsymmetricalTopSideAutoBarSizes
        BAR_DIAMETER_UNSYMMETRICAL_TOP_SIDE_AUTO_BAR_SIZES_ACI_11: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterUnsymmetricalTopSideAutoBarSizes
        BAR_DIAMETER_UNSYMMETRICAL_TOP_SIDE_AUTO_BAR_SIZES_ACI_12: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterUnsymmetricalTopSideAutoBarSizes
        BAR_DIAMETER_UNSYMMETRICAL_TOP_SIDE_AUTO_BAR_SIZES_ACI_14: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterUnsymmetricalTopSideAutoBarSizes
        BAR_DIAMETER_UNSYMMETRICAL_TOP_SIDE_AUTO_BAR_SIZES_ACI_16: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterUnsymmetricalTopSideAutoBarSizes
        BAR_DIAMETER_UNSYMMETRICAL_TOP_SIDE_AUTO_BAR_SIZES_ACI_18: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterUnsymmetricalTopSideAutoBarSizes
        BAR_DIAMETER_UNSYMMETRICAL_TOP_SIDE_AUTO_BAR_SIZES_ACI_1p5: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterUnsymmetricalTopSideAutoBarSizes
        BAR_DIAMETER_UNSYMMETRICAL_TOP_SIDE_AUTO_BAR_SIZES_ACI_2: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterUnsymmetricalTopSideAutoBarSizes
        BAR_DIAMETER_UNSYMMETRICAL_TOP_SIDE_AUTO_BAR_SIZES_ACI_2p5: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterUnsymmetricalTopSideAutoBarSizes
        BAR_DIAMETER_UNSYMMETRICAL_TOP_SIDE_AUTO_BAR_SIZES_ACI_3: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterUnsymmetricalTopSideAutoBarSizes
        BAR_DIAMETER_UNSYMMETRICAL_TOP_SIDE_AUTO_BAR_SIZES_ACI_4: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterUnsymmetricalTopSideAutoBarSizes
        BAR_DIAMETER_UNSYMMETRICAL_TOP_SIDE_AUTO_BAR_SIZES_ACI_5: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterUnsymmetricalTopSideAutoBarSizes
        BAR_DIAMETER_UNSYMMETRICAL_TOP_SIDE_AUTO_BAR_SIZES_ACI_6: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterUnsymmetricalTopSideAutoBarSizes
        BAR_DIAMETER_UNSYMMETRICAL_TOP_SIDE_AUTO_BAR_SIZES_ACI_7: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterUnsymmetricalTopSideAutoBarSizes
        BAR_DIAMETER_UNSYMMETRICAL_TOP_SIDE_AUTO_BAR_SIZES_ACI_8: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterUnsymmetricalTopSideAutoBarSizes
        BAR_DIAMETER_UNSYMMETRICAL_TOP_SIDE_AUTO_BAR_SIZES_ACI_9: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterUnsymmetricalTopSideAutoBarSizes
        BAR_DIAMETER_UNSYMMETRICAL_TOP_SIDE_AUTO_BAR_SIZES_CSA_10: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterUnsymmetricalTopSideAutoBarSizes
        BAR_DIAMETER_UNSYMMETRICAL_TOP_SIDE_AUTO_BAR_SIZES_CSA_15: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterUnsymmetricalTopSideAutoBarSizes
        BAR_DIAMETER_UNSYMMETRICAL_TOP_SIDE_AUTO_BAR_SIZES_CSA_20: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterUnsymmetricalTopSideAutoBarSizes
        BAR_DIAMETER_UNSYMMETRICAL_TOP_SIDE_AUTO_BAR_SIZES_CSA_25: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterUnsymmetricalTopSideAutoBarSizes
        BAR_DIAMETER_UNSYMMETRICAL_TOP_SIDE_AUTO_BAR_SIZES_CSA_30: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterUnsymmetricalTopSideAutoBarSizes
        BAR_DIAMETER_UNSYMMETRICAL_TOP_SIDE_AUTO_BAR_SIZES_CSA_35: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterUnsymmetricalTopSideAutoBarSizes
        BAR_DIAMETER_UNSYMMETRICAL_TOP_SIDE_AUTO_BAR_SIZES_CSA_45: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterUnsymmetricalTopSideAutoBarSizes
        BAR_DIAMETER_UNSYMMETRICAL_TOP_SIDE_AUTO_BAR_SIZES_CSA_55: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterUnsymmetricalTopSideAutoBarSizes
        class BarSizeDesignationUnsymmetricalBottomSideCalculated(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_UNKNOWN: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUnsymmetricalBottomSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_ACI_1: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUnsymmetricalBottomSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_ACI_10: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUnsymmetricalBottomSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_ACI_11: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUnsymmetricalBottomSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_ACI_12: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUnsymmetricalBottomSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_ACI_14: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUnsymmetricalBottomSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_ACI_16: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUnsymmetricalBottomSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_ACI_18: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUnsymmetricalBottomSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_ACI_1p5: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUnsymmetricalBottomSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_ACI_2: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUnsymmetricalBottomSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_ACI_2p5: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUnsymmetricalBottomSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_ACI_3: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUnsymmetricalBottomSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_ACI_4: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUnsymmetricalBottomSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_ACI_5: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUnsymmetricalBottomSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_ACI_6: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUnsymmetricalBottomSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_ACI_7: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUnsymmetricalBottomSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_ACI_8: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUnsymmetricalBottomSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_ACI_9: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUnsymmetricalBottomSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_CSA_10: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUnsymmetricalBottomSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_CSA_15: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUnsymmetricalBottomSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_CSA_20: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUnsymmetricalBottomSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_CSA_25: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUnsymmetricalBottomSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_CSA_30: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUnsymmetricalBottomSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_CSA_35: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUnsymmetricalBottomSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_CSA_45: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUnsymmetricalBottomSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_CSA_55: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUnsymmetricalBottomSideCalculated]
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_UNKNOWN: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUnsymmetricalBottomSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_ACI_1: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUnsymmetricalBottomSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_ACI_10: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUnsymmetricalBottomSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_ACI_11: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUnsymmetricalBottomSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_ACI_12: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUnsymmetricalBottomSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_ACI_14: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUnsymmetricalBottomSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_ACI_16: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUnsymmetricalBottomSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_ACI_18: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUnsymmetricalBottomSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_ACI_1p5: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUnsymmetricalBottomSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_ACI_2: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUnsymmetricalBottomSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_ACI_2p5: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUnsymmetricalBottomSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_ACI_3: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUnsymmetricalBottomSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_ACI_4: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUnsymmetricalBottomSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_ACI_5: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUnsymmetricalBottomSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_ACI_6: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUnsymmetricalBottomSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_ACI_7: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUnsymmetricalBottomSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_ACI_8: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUnsymmetricalBottomSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_ACI_9: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUnsymmetricalBottomSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_CSA_10: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUnsymmetricalBottomSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_CSA_15: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUnsymmetricalBottomSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_CSA_20: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUnsymmetricalBottomSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_CSA_25: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUnsymmetricalBottomSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_CSA_30: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUnsymmetricalBottomSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_CSA_35: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUnsymmetricalBottomSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_CSA_45: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUnsymmetricalBottomSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_CSA_55: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUnsymmetricalBottomSideCalculated
        class BarSizeDesignationUnsymmetricalBottomSideAutoMinimum(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_AUTO_MINIMUM_UNKNOWN: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUnsymmetricalBottomSideAutoMinimum]
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_AUTO_MINIMUM_UNKNOWN: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUnsymmetricalBottomSideAutoMinimum
        class BarSizeDesignationUnsymmetricalBottomSideAutoMaximum(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_AUTO_MAXIMUM_UNKNOWN: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUnsymmetricalBottomSideAutoMaximum]
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_AUTO_MAXIMUM_UNKNOWN: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUnsymmetricalBottomSideAutoMaximum
        class BarDiameterUnsymmetricalBottomSideAutoBarSizes(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            BAR_DIAMETER_UNSYMMETRICAL_BOTTOM_SIDE_AUTO_BAR_SIZES_UNKNOWN: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterUnsymmetricalBottomSideAutoBarSizes]
            BAR_DIAMETER_UNSYMMETRICAL_BOTTOM_SIDE_AUTO_BAR_SIZES_ACI_1: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterUnsymmetricalBottomSideAutoBarSizes]
            BAR_DIAMETER_UNSYMMETRICAL_BOTTOM_SIDE_AUTO_BAR_SIZES_ACI_10: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterUnsymmetricalBottomSideAutoBarSizes]
            BAR_DIAMETER_UNSYMMETRICAL_BOTTOM_SIDE_AUTO_BAR_SIZES_ACI_11: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterUnsymmetricalBottomSideAutoBarSizes]
            BAR_DIAMETER_UNSYMMETRICAL_BOTTOM_SIDE_AUTO_BAR_SIZES_ACI_12: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterUnsymmetricalBottomSideAutoBarSizes]
            BAR_DIAMETER_UNSYMMETRICAL_BOTTOM_SIDE_AUTO_BAR_SIZES_ACI_14: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterUnsymmetricalBottomSideAutoBarSizes]
            BAR_DIAMETER_UNSYMMETRICAL_BOTTOM_SIDE_AUTO_BAR_SIZES_ACI_16: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterUnsymmetricalBottomSideAutoBarSizes]
            BAR_DIAMETER_UNSYMMETRICAL_BOTTOM_SIDE_AUTO_BAR_SIZES_ACI_18: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterUnsymmetricalBottomSideAutoBarSizes]
            BAR_DIAMETER_UNSYMMETRICAL_BOTTOM_SIDE_AUTO_BAR_SIZES_ACI_1p5: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterUnsymmetricalBottomSideAutoBarSizes]
            BAR_DIAMETER_UNSYMMETRICAL_BOTTOM_SIDE_AUTO_BAR_SIZES_ACI_2: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterUnsymmetricalBottomSideAutoBarSizes]
            BAR_DIAMETER_UNSYMMETRICAL_BOTTOM_SIDE_AUTO_BAR_SIZES_ACI_2p5: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterUnsymmetricalBottomSideAutoBarSizes]
            BAR_DIAMETER_UNSYMMETRICAL_BOTTOM_SIDE_AUTO_BAR_SIZES_ACI_3: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterUnsymmetricalBottomSideAutoBarSizes]
            BAR_DIAMETER_UNSYMMETRICAL_BOTTOM_SIDE_AUTO_BAR_SIZES_ACI_4: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterUnsymmetricalBottomSideAutoBarSizes]
            BAR_DIAMETER_UNSYMMETRICAL_BOTTOM_SIDE_AUTO_BAR_SIZES_ACI_5: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterUnsymmetricalBottomSideAutoBarSizes]
            BAR_DIAMETER_UNSYMMETRICAL_BOTTOM_SIDE_AUTO_BAR_SIZES_ACI_6: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterUnsymmetricalBottomSideAutoBarSizes]
            BAR_DIAMETER_UNSYMMETRICAL_BOTTOM_SIDE_AUTO_BAR_SIZES_ACI_7: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterUnsymmetricalBottomSideAutoBarSizes]
            BAR_DIAMETER_UNSYMMETRICAL_BOTTOM_SIDE_AUTO_BAR_SIZES_ACI_8: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterUnsymmetricalBottomSideAutoBarSizes]
            BAR_DIAMETER_UNSYMMETRICAL_BOTTOM_SIDE_AUTO_BAR_SIZES_ACI_9: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterUnsymmetricalBottomSideAutoBarSizes]
            BAR_DIAMETER_UNSYMMETRICAL_BOTTOM_SIDE_AUTO_BAR_SIZES_CSA_10: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterUnsymmetricalBottomSideAutoBarSizes]
            BAR_DIAMETER_UNSYMMETRICAL_BOTTOM_SIDE_AUTO_BAR_SIZES_CSA_15: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterUnsymmetricalBottomSideAutoBarSizes]
            BAR_DIAMETER_UNSYMMETRICAL_BOTTOM_SIDE_AUTO_BAR_SIZES_CSA_20: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterUnsymmetricalBottomSideAutoBarSizes]
            BAR_DIAMETER_UNSYMMETRICAL_BOTTOM_SIDE_AUTO_BAR_SIZES_CSA_25: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterUnsymmetricalBottomSideAutoBarSizes]
            BAR_DIAMETER_UNSYMMETRICAL_BOTTOM_SIDE_AUTO_BAR_SIZES_CSA_30: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterUnsymmetricalBottomSideAutoBarSizes]
            BAR_DIAMETER_UNSYMMETRICAL_BOTTOM_SIDE_AUTO_BAR_SIZES_CSA_35: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterUnsymmetricalBottomSideAutoBarSizes]
            BAR_DIAMETER_UNSYMMETRICAL_BOTTOM_SIDE_AUTO_BAR_SIZES_CSA_45: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterUnsymmetricalBottomSideAutoBarSizes]
            BAR_DIAMETER_UNSYMMETRICAL_BOTTOM_SIDE_AUTO_BAR_SIZES_CSA_55: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterUnsymmetricalBottomSideAutoBarSizes]
        BAR_DIAMETER_UNSYMMETRICAL_BOTTOM_SIDE_AUTO_BAR_SIZES_UNKNOWN: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterUnsymmetricalBottomSideAutoBarSizes
        BAR_DIAMETER_UNSYMMETRICAL_BOTTOM_SIDE_AUTO_BAR_SIZES_ACI_1: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterUnsymmetricalBottomSideAutoBarSizes
        BAR_DIAMETER_UNSYMMETRICAL_BOTTOM_SIDE_AUTO_BAR_SIZES_ACI_10: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterUnsymmetricalBottomSideAutoBarSizes
        BAR_DIAMETER_UNSYMMETRICAL_BOTTOM_SIDE_AUTO_BAR_SIZES_ACI_11: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterUnsymmetricalBottomSideAutoBarSizes
        BAR_DIAMETER_UNSYMMETRICAL_BOTTOM_SIDE_AUTO_BAR_SIZES_ACI_12: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterUnsymmetricalBottomSideAutoBarSizes
        BAR_DIAMETER_UNSYMMETRICAL_BOTTOM_SIDE_AUTO_BAR_SIZES_ACI_14: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterUnsymmetricalBottomSideAutoBarSizes
        BAR_DIAMETER_UNSYMMETRICAL_BOTTOM_SIDE_AUTO_BAR_SIZES_ACI_16: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterUnsymmetricalBottomSideAutoBarSizes
        BAR_DIAMETER_UNSYMMETRICAL_BOTTOM_SIDE_AUTO_BAR_SIZES_ACI_18: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterUnsymmetricalBottomSideAutoBarSizes
        BAR_DIAMETER_UNSYMMETRICAL_BOTTOM_SIDE_AUTO_BAR_SIZES_ACI_1p5: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterUnsymmetricalBottomSideAutoBarSizes
        BAR_DIAMETER_UNSYMMETRICAL_BOTTOM_SIDE_AUTO_BAR_SIZES_ACI_2: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterUnsymmetricalBottomSideAutoBarSizes
        BAR_DIAMETER_UNSYMMETRICAL_BOTTOM_SIDE_AUTO_BAR_SIZES_ACI_2p5: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterUnsymmetricalBottomSideAutoBarSizes
        BAR_DIAMETER_UNSYMMETRICAL_BOTTOM_SIDE_AUTO_BAR_SIZES_ACI_3: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterUnsymmetricalBottomSideAutoBarSizes
        BAR_DIAMETER_UNSYMMETRICAL_BOTTOM_SIDE_AUTO_BAR_SIZES_ACI_4: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterUnsymmetricalBottomSideAutoBarSizes
        BAR_DIAMETER_UNSYMMETRICAL_BOTTOM_SIDE_AUTO_BAR_SIZES_ACI_5: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterUnsymmetricalBottomSideAutoBarSizes
        BAR_DIAMETER_UNSYMMETRICAL_BOTTOM_SIDE_AUTO_BAR_SIZES_ACI_6: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterUnsymmetricalBottomSideAutoBarSizes
        BAR_DIAMETER_UNSYMMETRICAL_BOTTOM_SIDE_AUTO_BAR_SIZES_ACI_7: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterUnsymmetricalBottomSideAutoBarSizes
        BAR_DIAMETER_UNSYMMETRICAL_BOTTOM_SIDE_AUTO_BAR_SIZES_ACI_8: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterUnsymmetricalBottomSideAutoBarSizes
        BAR_DIAMETER_UNSYMMETRICAL_BOTTOM_SIDE_AUTO_BAR_SIZES_ACI_9: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterUnsymmetricalBottomSideAutoBarSizes
        BAR_DIAMETER_UNSYMMETRICAL_BOTTOM_SIDE_AUTO_BAR_SIZES_CSA_10: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterUnsymmetricalBottomSideAutoBarSizes
        BAR_DIAMETER_UNSYMMETRICAL_BOTTOM_SIDE_AUTO_BAR_SIZES_CSA_15: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterUnsymmetricalBottomSideAutoBarSizes
        BAR_DIAMETER_UNSYMMETRICAL_BOTTOM_SIDE_AUTO_BAR_SIZES_CSA_20: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterUnsymmetricalBottomSideAutoBarSizes
        BAR_DIAMETER_UNSYMMETRICAL_BOTTOM_SIDE_AUTO_BAR_SIZES_CSA_25: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterUnsymmetricalBottomSideAutoBarSizes
        BAR_DIAMETER_UNSYMMETRICAL_BOTTOM_SIDE_AUTO_BAR_SIZES_CSA_30: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterUnsymmetricalBottomSideAutoBarSizes
        BAR_DIAMETER_UNSYMMETRICAL_BOTTOM_SIDE_AUTO_BAR_SIZES_CSA_35: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterUnsymmetricalBottomSideAutoBarSizes
        BAR_DIAMETER_UNSYMMETRICAL_BOTTOM_SIDE_AUTO_BAR_SIZES_CSA_45: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterUnsymmetricalBottomSideAutoBarSizes
        BAR_DIAMETER_UNSYMMETRICAL_BOTTOM_SIDE_AUTO_BAR_SIZES_CSA_55: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterUnsymmetricalBottomSideAutoBarSizes
        class BarSizeDesignationUniformlySurroundingCalculated(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_UNKNOWN: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUniformlySurroundingCalculated]
            BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_ACI_1: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUniformlySurroundingCalculated]
            BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_ACI_10: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUniformlySurroundingCalculated]
            BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_ACI_11: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUniformlySurroundingCalculated]
            BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_ACI_12: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUniformlySurroundingCalculated]
            BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_ACI_14: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUniformlySurroundingCalculated]
            BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_ACI_16: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUniformlySurroundingCalculated]
            BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_ACI_18: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUniformlySurroundingCalculated]
            BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_ACI_1p5: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUniformlySurroundingCalculated]
            BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_ACI_2: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUniformlySurroundingCalculated]
            BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_ACI_2p5: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUniformlySurroundingCalculated]
            BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_ACI_3: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUniformlySurroundingCalculated]
            BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_ACI_4: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUniformlySurroundingCalculated]
            BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_ACI_5: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUniformlySurroundingCalculated]
            BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_ACI_6: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUniformlySurroundingCalculated]
            BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_ACI_7: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUniformlySurroundingCalculated]
            BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_ACI_8: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUniformlySurroundingCalculated]
            BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_ACI_9: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUniformlySurroundingCalculated]
            BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_CSA_10: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUniformlySurroundingCalculated]
            BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_CSA_15: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUniformlySurroundingCalculated]
            BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_CSA_20: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUniformlySurroundingCalculated]
            BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_CSA_25: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUniformlySurroundingCalculated]
            BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_CSA_30: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUniformlySurroundingCalculated]
            BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_CSA_35: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUniformlySurroundingCalculated]
            BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_CSA_45: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUniformlySurroundingCalculated]
            BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_CSA_55: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUniformlySurroundingCalculated]
        BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_UNKNOWN: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUniformlySurroundingCalculated
        BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_ACI_1: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUniformlySurroundingCalculated
        BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_ACI_10: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUniformlySurroundingCalculated
        BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_ACI_11: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUniformlySurroundingCalculated
        BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_ACI_12: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUniformlySurroundingCalculated
        BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_ACI_14: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUniformlySurroundingCalculated
        BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_ACI_16: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUniformlySurroundingCalculated
        BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_ACI_18: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUniformlySurroundingCalculated
        BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_ACI_1p5: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUniformlySurroundingCalculated
        BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_ACI_2: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUniformlySurroundingCalculated
        BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_ACI_2p5: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUniformlySurroundingCalculated
        BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_ACI_3: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUniformlySurroundingCalculated
        BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_ACI_4: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUniformlySurroundingCalculated
        BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_ACI_5: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUniformlySurroundingCalculated
        BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_ACI_6: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUniformlySurroundingCalculated
        BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_ACI_7: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUniformlySurroundingCalculated
        BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_ACI_8: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUniformlySurroundingCalculated
        BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_ACI_9: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUniformlySurroundingCalculated
        BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_CSA_10: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUniformlySurroundingCalculated
        BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_CSA_15: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUniformlySurroundingCalculated
        BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_CSA_20: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUniformlySurroundingCalculated
        BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_CSA_25: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUniformlySurroundingCalculated
        BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_CSA_30: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUniformlySurroundingCalculated
        BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_CSA_35: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUniformlySurroundingCalculated
        BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_CSA_45: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUniformlySurroundingCalculated
        BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_CSA_55: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUniformlySurroundingCalculated
        class BarSizeDesignationUniformlySurroundingAutoMinimum(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_AUTO_MINIMUM_UNKNOWN: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUniformlySurroundingAutoMinimum]
        BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_AUTO_MINIMUM_UNKNOWN: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUniformlySurroundingAutoMinimum
        class BarSizeDesignationUniformlySurroundingAutoMaximum(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_AUTO_MAXIMUM_UNKNOWN: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUniformlySurroundingAutoMaximum]
        BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_AUTO_MAXIMUM_UNKNOWN: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUniformlySurroundingAutoMaximum
        class BarDiameterUniformlySurroundingAutoBarSizes(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            BAR_DIAMETER_UNIFORMLY_SURROUNDING_AUTO_BAR_SIZES_UNKNOWN: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterUniformlySurroundingAutoBarSizes]
            BAR_DIAMETER_UNIFORMLY_SURROUNDING_AUTO_BAR_SIZES_ACI_1: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterUniformlySurroundingAutoBarSizes]
            BAR_DIAMETER_UNIFORMLY_SURROUNDING_AUTO_BAR_SIZES_ACI_10: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterUniformlySurroundingAutoBarSizes]
            BAR_DIAMETER_UNIFORMLY_SURROUNDING_AUTO_BAR_SIZES_ACI_11: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterUniformlySurroundingAutoBarSizes]
            BAR_DIAMETER_UNIFORMLY_SURROUNDING_AUTO_BAR_SIZES_ACI_12: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterUniformlySurroundingAutoBarSizes]
            BAR_DIAMETER_UNIFORMLY_SURROUNDING_AUTO_BAR_SIZES_ACI_14: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterUniformlySurroundingAutoBarSizes]
            BAR_DIAMETER_UNIFORMLY_SURROUNDING_AUTO_BAR_SIZES_ACI_16: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterUniformlySurroundingAutoBarSizes]
            BAR_DIAMETER_UNIFORMLY_SURROUNDING_AUTO_BAR_SIZES_ACI_18: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterUniformlySurroundingAutoBarSizes]
            BAR_DIAMETER_UNIFORMLY_SURROUNDING_AUTO_BAR_SIZES_ACI_1p5: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterUniformlySurroundingAutoBarSizes]
            BAR_DIAMETER_UNIFORMLY_SURROUNDING_AUTO_BAR_SIZES_ACI_2: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterUniformlySurroundingAutoBarSizes]
            BAR_DIAMETER_UNIFORMLY_SURROUNDING_AUTO_BAR_SIZES_ACI_2p5: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterUniformlySurroundingAutoBarSizes]
            BAR_DIAMETER_UNIFORMLY_SURROUNDING_AUTO_BAR_SIZES_ACI_3: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterUniformlySurroundingAutoBarSizes]
            BAR_DIAMETER_UNIFORMLY_SURROUNDING_AUTO_BAR_SIZES_ACI_4: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterUniformlySurroundingAutoBarSizes]
            BAR_DIAMETER_UNIFORMLY_SURROUNDING_AUTO_BAR_SIZES_ACI_5: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterUniformlySurroundingAutoBarSizes]
            BAR_DIAMETER_UNIFORMLY_SURROUNDING_AUTO_BAR_SIZES_ACI_6: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterUniformlySurroundingAutoBarSizes]
            BAR_DIAMETER_UNIFORMLY_SURROUNDING_AUTO_BAR_SIZES_ACI_7: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterUniformlySurroundingAutoBarSizes]
            BAR_DIAMETER_UNIFORMLY_SURROUNDING_AUTO_BAR_SIZES_ACI_8: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterUniformlySurroundingAutoBarSizes]
            BAR_DIAMETER_UNIFORMLY_SURROUNDING_AUTO_BAR_SIZES_ACI_9: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterUniformlySurroundingAutoBarSizes]
            BAR_DIAMETER_UNIFORMLY_SURROUNDING_AUTO_BAR_SIZES_CSA_10: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterUniformlySurroundingAutoBarSizes]
            BAR_DIAMETER_UNIFORMLY_SURROUNDING_AUTO_BAR_SIZES_CSA_15: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterUniformlySurroundingAutoBarSizes]
            BAR_DIAMETER_UNIFORMLY_SURROUNDING_AUTO_BAR_SIZES_CSA_20: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterUniformlySurroundingAutoBarSizes]
            BAR_DIAMETER_UNIFORMLY_SURROUNDING_AUTO_BAR_SIZES_CSA_25: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterUniformlySurroundingAutoBarSizes]
            BAR_DIAMETER_UNIFORMLY_SURROUNDING_AUTO_BAR_SIZES_CSA_30: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterUniformlySurroundingAutoBarSizes]
            BAR_DIAMETER_UNIFORMLY_SURROUNDING_AUTO_BAR_SIZES_CSA_35: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterUniformlySurroundingAutoBarSizes]
            BAR_DIAMETER_UNIFORMLY_SURROUNDING_AUTO_BAR_SIZES_CSA_45: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterUniformlySurroundingAutoBarSizes]
            BAR_DIAMETER_UNIFORMLY_SURROUNDING_AUTO_BAR_SIZES_CSA_55: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterUniformlySurroundingAutoBarSizes]
        BAR_DIAMETER_UNIFORMLY_SURROUNDING_AUTO_BAR_SIZES_UNKNOWN: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterUniformlySurroundingAutoBarSizes
        BAR_DIAMETER_UNIFORMLY_SURROUNDING_AUTO_BAR_SIZES_ACI_1: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterUniformlySurroundingAutoBarSizes
        BAR_DIAMETER_UNIFORMLY_SURROUNDING_AUTO_BAR_SIZES_ACI_10: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterUniformlySurroundingAutoBarSizes
        BAR_DIAMETER_UNIFORMLY_SURROUNDING_AUTO_BAR_SIZES_ACI_11: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterUniformlySurroundingAutoBarSizes
        BAR_DIAMETER_UNIFORMLY_SURROUNDING_AUTO_BAR_SIZES_ACI_12: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterUniformlySurroundingAutoBarSizes
        BAR_DIAMETER_UNIFORMLY_SURROUNDING_AUTO_BAR_SIZES_ACI_14: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterUniformlySurroundingAutoBarSizes
        BAR_DIAMETER_UNIFORMLY_SURROUNDING_AUTO_BAR_SIZES_ACI_16: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterUniformlySurroundingAutoBarSizes
        BAR_DIAMETER_UNIFORMLY_SURROUNDING_AUTO_BAR_SIZES_ACI_18: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterUniformlySurroundingAutoBarSizes
        BAR_DIAMETER_UNIFORMLY_SURROUNDING_AUTO_BAR_SIZES_ACI_1p5: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterUniformlySurroundingAutoBarSizes
        BAR_DIAMETER_UNIFORMLY_SURROUNDING_AUTO_BAR_SIZES_ACI_2: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterUniformlySurroundingAutoBarSizes
        BAR_DIAMETER_UNIFORMLY_SURROUNDING_AUTO_BAR_SIZES_ACI_2p5: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterUniformlySurroundingAutoBarSizes
        BAR_DIAMETER_UNIFORMLY_SURROUNDING_AUTO_BAR_SIZES_ACI_3: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterUniformlySurroundingAutoBarSizes
        BAR_DIAMETER_UNIFORMLY_SURROUNDING_AUTO_BAR_SIZES_ACI_4: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterUniformlySurroundingAutoBarSizes
        BAR_DIAMETER_UNIFORMLY_SURROUNDING_AUTO_BAR_SIZES_ACI_5: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterUniformlySurroundingAutoBarSizes
        BAR_DIAMETER_UNIFORMLY_SURROUNDING_AUTO_BAR_SIZES_ACI_6: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterUniformlySurroundingAutoBarSizes
        BAR_DIAMETER_UNIFORMLY_SURROUNDING_AUTO_BAR_SIZES_ACI_7: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterUniformlySurroundingAutoBarSizes
        BAR_DIAMETER_UNIFORMLY_SURROUNDING_AUTO_BAR_SIZES_ACI_8: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterUniformlySurroundingAutoBarSizes
        BAR_DIAMETER_UNIFORMLY_SURROUNDING_AUTO_BAR_SIZES_ACI_9: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterUniformlySurroundingAutoBarSizes
        BAR_DIAMETER_UNIFORMLY_SURROUNDING_AUTO_BAR_SIZES_CSA_10: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterUniformlySurroundingAutoBarSizes
        BAR_DIAMETER_UNIFORMLY_SURROUNDING_AUTO_BAR_SIZES_CSA_15: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterUniformlySurroundingAutoBarSizes
        BAR_DIAMETER_UNIFORMLY_SURROUNDING_AUTO_BAR_SIZES_CSA_20: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterUniformlySurroundingAutoBarSizes
        BAR_DIAMETER_UNIFORMLY_SURROUNDING_AUTO_BAR_SIZES_CSA_25: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterUniformlySurroundingAutoBarSizes
        BAR_DIAMETER_UNIFORMLY_SURROUNDING_AUTO_BAR_SIZES_CSA_30: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterUniformlySurroundingAutoBarSizes
        BAR_DIAMETER_UNIFORMLY_SURROUNDING_AUTO_BAR_SIZES_CSA_35: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterUniformlySurroundingAutoBarSizes
        BAR_DIAMETER_UNIFORMLY_SURROUNDING_AUTO_BAR_SIZES_CSA_45: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterUniformlySurroundingAutoBarSizes
        BAR_DIAMETER_UNIFORMLY_SURROUNDING_AUTO_BAR_SIZES_CSA_55: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterUniformlySurroundingAutoBarSizes
        class BarSizeDesignationLineCalculated(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            BAR_SIZE_DESIGNATION_LINE_CALCULATED_UNKNOWN: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationLineCalculated]
            BAR_SIZE_DESIGNATION_LINE_CALCULATED_ACI_1: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationLineCalculated]
            BAR_SIZE_DESIGNATION_LINE_CALCULATED_ACI_10: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationLineCalculated]
            BAR_SIZE_DESIGNATION_LINE_CALCULATED_ACI_11: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationLineCalculated]
            BAR_SIZE_DESIGNATION_LINE_CALCULATED_ACI_12: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationLineCalculated]
            BAR_SIZE_DESIGNATION_LINE_CALCULATED_ACI_14: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationLineCalculated]
            BAR_SIZE_DESIGNATION_LINE_CALCULATED_ACI_16: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationLineCalculated]
            BAR_SIZE_DESIGNATION_LINE_CALCULATED_ACI_18: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationLineCalculated]
            BAR_SIZE_DESIGNATION_LINE_CALCULATED_ACI_1p5: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationLineCalculated]
            BAR_SIZE_DESIGNATION_LINE_CALCULATED_ACI_2: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationLineCalculated]
            BAR_SIZE_DESIGNATION_LINE_CALCULATED_ACI_2p5: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationLineCalculated]
            BAR_SIZE_DESIGNATION_LINE_CALCULATED_ACI_3: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationLineCalculated]
            BAR_SIZE_DESIGNATION_LINE_CALCULATED_ACI_4: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationLineCalculated]
            BAR_SIZE_DESIGNATION_LINE_CALCULATED_ACI_5: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationLineCalculated]
            BAR_SIZE_DESIGNATION_LINE_CALCULATED_ACI_6: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationLineCalculated]
            BAR_SIZE_DESIGNATION_LINE_CALCULATED_ACI_7: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationLineCalculated]
            BAR_SIZE_DESIGNATION_LINE_CALCULATED_ACI_8: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationLineCalculated]
            BAR_SIZE_DESIGNATION_LINE_CALCULATED_ACI_9: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationLineCalculated]
            BAR_SIZE_DESIGNATION_LINE_CALCULATED_CSA_10: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationLineCalculated]
            BAR_SIZE_DESIGNATION_LINE_CALCULATED_CSA_15: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationLineCalculated]
            BAR_SIZE_DESIGNATION_LINE_CALCULATED_CSA_20: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationLineCalculated]
            BAR_SIZE_DESIGNATION_LINE_CALCULATED_CSA_25: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationLineCalculated]
            BAR_SIZE_DESIGNATION_LINE_CALCULATED_CSA_30: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationLineCalculated]
            BAR_SIZE_DESIGNATION_LINE_CALCULATED_CSA_35: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationLineCalculated]
            BAR_SIZE_DESIGNATION_LINE_CALCULATED_CSA_45: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationLineCalculated]
            BAR_SIZE_DESIGNATION_LINE_CALCULATED_CSA_55: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationLineCalculated]
        BAR_SIZE_DESIGNATION_LINE_CALCULATED_UNKNOWN: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationLineCalculated
        BAR_SIZE_DESIGNATION_LINE_CALCULATED_ACI_1: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationLineCalculated
        BAR_SIZE_DESIGNATION_LINE_CALCULATED_ACI_10: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationLineCalculated
        BAR_SIZE_DESIGNATION_LINE_CALCULATED_ACI_11: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationLineCalculated
        BAR_SIZE_DESIGNATION_LINE_CALCULATED_ACI_12: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationLineCalculated
        BAR_SIZE_DESIGNATION_LINE_CALCULATED_ACI_14: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationLineCalculated
        BAR_SIZE_DESIGNATION_LINE_CALCULATED_ACI_16: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationLineCalculated
        BAR_SIZE_DESIGNATION_LINE_CALCULATED_ACI_18: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationLineCalculated
        BAR_SIZE_DESIGNATION_LINE_CALCULATED_ACI_1p5: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationLineCalculated
        BAR_SIZE_DESIGNATION_LINE_CALCULATED_ACI_2: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationLineCalculated
        BAR_SIZE_DESIGNATION_LINE_CALCULATED_ACI_2p5: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationLineCalculated
        BAR_SIZE_DESIGNATION_LINE_CALCULATED_ACI_3: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationLineCalculated
        BAR_SIZE_DESIGNATION_LINE_CALCULATED_ACI_4: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationLineCalculated
        BAR_SIZE_DESIGNATION_LINE_CALCULATED_ACI_5: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationLineCalculated
        BAR_SIZE_DESIGNATION_LINE_CALCULATED_ACI_6: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationLineCalculated
        BAR_SIZE_DESIGNATION_LINE_CALCULATED_ACI_7: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationLineCalculated
        BAR_SIZE_DESIGNATION_LINE_CALCULATED_ACI_8: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationLineCalculated
        BAR_SIZE_DESIGNATION_LINE_CALCULATED_ACI_9: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationLineCalculated
        BAR_SIZE_DESIGNATION_LINE_CALCULATED_CSA_10: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationLineCalculated
        BAR_SIZE_DESIGNATION_LINE_CALCULATED_CSA_15: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationLineCalculated
        BAR_SIZE_DESIGNATION_LINE_CALCULATED_CSA_20: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationLineCalculated
        BAR_SIZE_DESIGNATION_LINE_CALCULATED_CSA_25: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationLineCalculated
        BAR_SIZE_DESIGNATION_LINE_CALCULATED_CSA_30: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationLineCalculated
        BAR_SIZE_DESIGNATION_LINE_CALCULATED_CSA_35: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationLineCalculated
        BAR_SIZE_DESIGNATION_LINE_CALCULATED_CSA_45: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationLineCalculated
        BAR_SIZE_DESIGNATION_LINE_CALCULATED_CSA_55: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationLineCalculated
        class BarSizeDesignationLineAutoMinimum(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            BAR_SIZE_DESIGNATION_LINE_AUTO_MINIMUM_UNKNOWN: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationLineAutoMinimum]
        BAR_SIZE_DESIGNATION_LINE_AUTO_MINIMUM_UNKNOWN: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationLineAutoMinimum
        class BarSizeDesignationLineAutoMaximum(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            BAR_SIZE_DESIGNATION_LINE_AUTO_MAXIMUM_UNKNOWN: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationLineAutoMaximum]
        BAR_SIZE_DESIGNATION_LINE_AUTO_MAXIMUM_UNKNOWN: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationLineAutoMaximum
        class BarDiameterLineAutoBarSizes(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            BAR_DIAMETER_LINE_AUTO_BAR_SIZES_UNKNOWN: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterLineAutoBarSizes]
            BAR_DIAMETER_LINE_AUTO_BAR_SIZES_ACI_1: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterLineAutoBarSizes]
            BAR_DIAMETER_LINE_AUTO_BAR_SIZES_ACI_10: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterLineAutoBarSizes]
            BAR_DIAMETER_LINE_AUTO_BAR_SIZES_ACI_11: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterLineAutoBarSizes]
            BAR_DIAMETER_LINE_AUTO_BAR_SIZES_ACI_12: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterLineAutoBarSizes]
            BAR_DIAMETER_LINE_AUTO_BAR_SIZES_ACI_14: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterLineAutoBarSizes]
            BAR_DIAMETER_LINE_AUTO_BAR_SIZES_ACI_16: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterLineAutoBarSizes]
            BAR_DIAMETER_LINE_AUTO_BAR_SIZES_ACI_18: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterLineAutoBarSizes]
            BAR_DIAMETER_LINE_AUTO_BAR_SIZES_ACI_1p5: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterLineAutoBarSizes]
            BAR_DIAMETER_LINE_AUTO_BAR_SIZES_ACI_2: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterLineAutoBarSizes]
            BAR_DIAMETER_LINE_AUTO_BAR_SIZES_ACI_2p5: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterLineAutoBarSizes]
            BAR_DIAMETER_LINE_AUTO_BAR_SIZES_ACI_3: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterLineAutoBarSizes]
            BAR_DIAMETER_LINE_AUTO_BAR_SIZES_ACI_4: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterLineAutoBarSizes]
            BAR_DIAMETER_LINE_AUTO_BAR_SIZES_ACI_5: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterLineAutoBarSizes]
            BAR_DIAMETER_LINE_AUTO_BAR_SIZES_ACI_6: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterLineAutoBarSizes]
            BAR_DIAMETER_LINE_AUTO_BAR_SIZES_ACI_7: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterLineAutoBarSizes]
            BAR_DIAMETER_LINE_AUTO_BAR_SIZES_ACI_8: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterLineAutoBarSizes]
            BAR_DIAMETER_LINE_AUTO_BAR_SIZES_ACI_9: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterLineAutoBarSizes]
            BAR_DIAMETER_LINE_AUTO_BAR_SIZES_CSA_10: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterLineAutoBarSizes]
            BAR_DIAMETER_LINE_AUTO_BAR_SIZES_CSA_15: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterLineAutoBarSizes]
            BAR_DIAMETER_LINE_AUTO_BAR_SIZES_CSA_20: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterLineAutoBarSizes]
            BAR_DIAMETER_LINE_AUTO_BAR_SIZES_CSA_25: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterLineAutoBarSizes]
            BAR_DIAMETER_LINE_AUTO_BAR_SIZES_CSA_30: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterLineAutoBarSizes]
            BAR_DIAMETER_LINE_AUTO_BAR_SIZES_CSA_35: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterLineAutoBarSizes]
            BAR_DIAMETER_LINE_AUTO_BAR_SIZES_CSA_45: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterLineAutoBarSizes]
            BAR_DIAMETER_LINE_AUTO_BAR_SIZES_CSA_55: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterLineAutoBarSizes]
        BAR_DIAMETER_LINE_AUTO_BAR_SIZES_UNKNOWN: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterLineAutoBarSizes
        BAR_DIAMETER_LINE_AUTO_BAR_SIZES_ACI_1: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterLineAutoBarSizes
        BAR_DIAMETER_LINE_AUTO_BAR_SIZES_ACI_10: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterLineAutoBarSizes
        BAR_DIAMETER_LINE_AUTO_BAR_SIZES_ACI_11: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterLineAutoBarSizes
        BAR_DIAMETER_LINE_AUTO_BAR_SIZES_ACI_12: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterLineAutoBarSizes
        BAR_DIAMETER_LINE_AUTO_BAR_SIZES_ACI_14: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterLineAutoBarSizes
        BAR_DIAMETER_LINE_AUTO_BAR_SIZES_ACI_16: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterLineAutoBarSizes
        BAR_DIAMETER_LINE_AUTO_BAR_SIZES_ACI_18: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterLineAutoBarSizes
        BAR_DIAMETER_LINE_AUTO_BAR_SIZES_ACI_1p5: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterLineAutoBarSizes
        BAR_DIAMETER_LINE_AUTO_BAR_SIZES_ACI_2: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterLineAutoBarSizes
        BAR_DIAMETER_LINE_AUTO_BAR_SIZES_ACI_2p5: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterLineAutoBarSizes
        BAR_DIAMETER_LINE_AUTO_BAR_SIZES_ACI_3: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterLineAutoBarSizes
        BAR_DIAMETER_LINE_AUTO_BAR_SIZES_ACI_4: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterLineAutoBarSizes
        BAR_DIAMETER_LINE_AUTO_BAR_SIZES_ACI_5: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterLineAutoBarSizes
        BAR_DIAMETER_LINE_AUTO_BAR_SIZES_ACI_6: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterLineAutoBarSizes
        BAR_DIAMETER_LINE_AUTO_BAR_SIZES_ACI_7: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterLineAutoBarSizes
        BAR_DIAMETER_LINE_AUTO_BAR_SIZES_ACI_8: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterLineAutoBarSizes
        BAR_DIAMETER_LINE_AUTO_BAR_SIZES_ACI_9: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterLineAutoBarSizes
        BAR_DIAMETER_LINE_AUTO_BAR_SIZES_CSA_10: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterLineAutoBarSizes
        BAR_DIAMETER_LINE_AUTO_BAR_SIZES_CSA_15: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterLineAutoBarSizes
        BAR_DIAMETER_LINE_AUTO_BAR_SIZES_CSA_20: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterLineAutoBarSizes
        BAR_DIAMETER_LINE_AUTO_BAR_SIZES_CSA_25: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterLineAutoBarSizes
        BAR_DIAMETER_LINE_AUTO_BAR_SIZES_CSA_30: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterLineAutoBarSizes
        BAR_DIAMETER_LINE_AUTO_BAR_SIZES_CSA_35: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterLineAutoBarSizes
        BAR_DIAMETER_LINE_AUTO_BAR_SIZES_CSA_45: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterLineAutoBarSizes
        BAR_DIAMETER_LINE_AUTO_BAR_SIZES_CSA_55: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterLineAutoBarSizes
        class BarSizeDesignationSingleCalculated(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_UNKNOWN: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationSingleCalculated]
            BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_ACI_1: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationSingleCalculated]
            BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_ACI_10: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationSingleCalculated]
            BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_ACI_11: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationSingleCalculated]
            BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_ACI_12: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationSingleCalculated]
            BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_ACI_14: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationSingleCalculated]
            BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_ACI_16: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationSingleCalculated]
            BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_ACI_18: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationSingleCalculated]
            BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_ACI_1p5: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationSingleCalculated]
            BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_ACI_2: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationSingleCalculated]
            BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_ACI_2p5: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationSingleCalculated]
            BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_ACI_3: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationSingleCalculated]
            BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_ACI_4: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationSingleCalculated]
            BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_ACI_5: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationSingleCalculated]
            BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_ACI_6: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationSingleCalculated]
            BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_ACI_7: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationSingleCalculated]
            BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_ACI_8: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationSingleCalculated]
            BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_ACI_9: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationSingleCalculated]
            BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_CSA_10: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationSingleCalculated]
            BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_CSA_15: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationSingleCalculated]
            BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_CSA_20: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationSingleCalculated]
            BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_CSA_25: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationSingleCalculated]
            BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_CSA_30: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationSingleCalculated]
            BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_CSA_35: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationSingleCalculated]
            BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_CSA_45: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationSingleCalculated]
            BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_CSA_55: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationSingleCalculated]
        BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_UNKNOWN: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationSingleCalculated
        BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_ACI_1: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationSingleCalculated
        BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_ACI_10: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationSingleCalculated
        BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_ACI_11: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationSingleCalculated
        BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_ACI_12: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationSingleCalculated
        BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_ACI_14: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationSingleCalculated
        BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_ACI_16: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationSingleCalculated
        BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_ACI_18: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationSingleCalculated
        BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_ACI_1p5: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationSingleCalculated
        BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_ACI_2: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationSingleCalculated
        BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_ACI_2p5: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationSingleCalculated
        BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_ACI_3: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationSingleCalculated
        BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_ACI_4: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationSingleCalculated
        BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_ACI_5: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationSingleCalculated
        BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_ACI_6: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationSingleCalculated
        BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_ACI_7: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationSingleCalculated
        BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_ACI_8: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationSingleCalculated
        BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_ACI_9: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationSingleCalculated
        BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_CSA_10: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationSingleCalculated
        BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_CSA_15: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationSingleCalculated
        BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_CSA_20: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationSingleCalculated
        BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_CSA_25: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationSingleCalculated
        BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_CSA_30: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationSingleCalculated
        BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_CSA_35: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationSingleCalculated
        BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_CSA_45: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationSingleCalculated
        BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_CSA_55: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationSingleCalculated
        class BarSizeDesignationSingleAutoMinimum(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            BAR_SIZE_DESIGNATION_SINGLE_AUTO_MINIMUM_UNKNOWN: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationSingleAutoMinimum]
        BAR_SIZE_DESIGNATION_SINGLE_AUTO_MINIMUM_UNKNOWN: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationSingleAutoMinimum
        class BarSizeDesignationSingleAutoMaximum(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            BAR_SIZE_DESIGNATION_SINGLE_AUTO_MAXIMUM_UNKNOWN: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationSingleAutoMaximum]
        BAR_SIZE_DESIGNATION_SINGLE_AUTO_MAXIMUM_UNKNOWN: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationSingleAutoMaximum
        class BarDiameterSingleAutoBarSizes(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            BAR_DIAMETER_SINGLE_AUTO_BAR_SIZES_UNKNOWN: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterSingleAutoBarSizes]
            BAR_DIAMETER_SINGLE_AUTO_BAR_SIZES_ACI_1: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterSingleAutoBarSizes]
            BAR_DIAMETER_SINGLE_AUTO_BAR_SIZES_ACI_10: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterSingleAutoBarSizes]
            BAR_DIAMETER_SINGLE_AUTO_BAR_SIZES_ACI_11: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterSingleAutoBarSizes]
            BAR_DIAMETER_SINGLE_AUTO_BAR_SIZES_ACI_12: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterSingleAutoBarSizes]
            BAR_DIAMETER_SINGLE_AUTO_BAR_SIZES_ACI_14: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterSingleAutoBarSizes]
            BAR_DIAMETER_SINGLE_AUTO_BAR_SIZES_ACI_16: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterSingleAutoBarSizes]
            BAR_DIAMETER_SINGLE_AUTO_BAR_SIZES_ACI_18: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterSingleAutoBarSizes]
            BAR_DIAMETER_SINGLE_AUTO_BAR_SIZES_ACI_1p5: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterSingleAutoBarSizes]
            BAR_DIAMETER_SINGLE_AUTO_BAR_SIZES_ACI_2: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterSingleAutoBarSizes]
            BAR_DIAMETER_SINGLE_AUTO_BAR_SIZES_ACI_2p5: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterSingleAutoBarSizes]
            BAR_DIAMETER_SINGLE_AUTO_BAR_SIZES_ACI_3: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterSingleAutoBarSizes]
            BAR_DIAMETER_SINGLE_AUTO_BAR_SIZES_ACI_4: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterSingleAutoBarSizes]
            BAR_DIAMETER_SINGLE_AUTO_BAR_SIZES_ACI_5: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterSingleAutoBarSizes]
            BAR_DIAMETER_SINGLE_AUTO_BAR_SIZES_ACI_6: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterSingleAutoBarSizes]
            BAR_DIAMETER_SINGLE_AUTO_BAR_SIZES_ACI_7: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterSingleAutoBarSizes]
            BAR_DIAMETER_SINGLE_AUTO_BAR_SIZES_ACI_8: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterSingleAutoBarSizes]
            BAR_DIAMETER_SINGLE_AUTO_BAR_SIZES_ACI_9: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterSingleAutoBarSizes]
            BAR_DIAMETER_SINGLE_AUTO_BAR_SIZES_CSA_10: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterSingleAutoBarSizes]
            BAR_DIAMETER_SINGLE_AUTO_BAR_SIZES_CSA_15: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterSingleAutoBarSizes]
            BAR_DIAMETER_SINGLE_AUTO_BAR_SIZES_CSA_20: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterSingleAutoBarSizes]
            BAR_DIAMETER_SINGLE_AUTO_BAR_SIZES_CSA_25: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterSingleAutoBarSizes]
            BAR_DIAMETER_SINGLE_AUTO_BAR_SIZES_CSA_30: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterSingleAutoBarSizes]
            BAR_DIAMETER_SINGLE_AUTO_BAR_SIZES_CSA_35: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterSingleAutoBarSizes]
            BAR_DIAMETER_SINGLE_AUTO_BAR_SIZES_CSA_45: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterSingleAutoBarSizes]
            BAR_DIAMETER_SINGLE_AUTO_BAR_SIZES_CSA_55: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterSingleAutoBarSizes]
        BAR_DIAMETER_SINGLE_AUTO_BAR_SIZES_UNKNOWN: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterSingleAutoBarSizes
        BAR_DIAMETER_SINGLE_AUTO_BAR_SIZES_ACI_1: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterSingleAutoBarSizes
        BAR_DIAMETER_SINGLE_AUTO_BAR_SIZES_ACI_10: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterSingleAutoBarSizes
        BAR_DIAMETER_SINGLE_AUTO_BAR_SIZES_ACI_11: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterSingleAutoBarSizes
        BAR_DIAMETER_SINGLE_AUTO_BAR_SIZES_ACI_12: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterSingleAutoBarSizes
        BAR_DIAMETER_SINGLE_AUTO_BAR_SIZES_ACI_14: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterSingleAutoBarSizes
        BAR_DIAMETER_SINGLE_AUTO_BAR_SIZES_ACI_16: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterSingleAutoBarSizes
        BAR_DIAMETER_SINGLE_AUTO_BAR_SIZES_ACI_18: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterSingleAutoBarSizes
        BAR_DIAMETER_SINGLE_AUTO_BAR_SIZES_ACI_1p5: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterSingleAutoBarSizes
        BAR_DIAMETER_SINGLE_AUTO_BAR_SIZES_ACI_2: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterSingleAutoBarSizes
        BAR_DIAMETER_SINGLE_AUTO_BAR_SIZES_ACI_2p5: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterSingleAutoBarSizes
        BAR_DIAMETER_SINGLE_AUTO_BAR_SIZES_ACI_3: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterSingleAutoBarSizes
        BAR_DIAMETER_SINGLE_AUTO_BAR_SIZES_ACI_4: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterSingleAutoBarSizes
        BAR_DIAMETER_SINGLE_AUTO_BAR_SIZES_ACI_5: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterSingleAutoBarSizes
        BAR_DIAMETER_SINGLE_AUTO_BAR_SIZES_ACI_6: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterSingleAutoBarSizes
        BAR_DIAMETER_SINGLE_AUTO_BAR_SIZES_ACI_7: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterSingleAutoBarSizes
        BAR_DIAMETER_SINGLE_AUTO_BAR_SIZES_ACI_8: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterSingleAutoBarSizes
        BAR_DIAMETER_SINGLE_AUTO_BAR_SIZES_ACI_9: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterSingleAutoBarSizes
        BAR_DIAMETER_SINGLE_AUTO_BAR_SIZES_CSA_10: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterSingleAutoBarSizes
        BAR_DIAMETER_SINGLE_AUTO_BAR_SIZES_CSA_15: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterSingleAutoBarSizes
        BAR_DIAMETER_SINGLE_AUTO_BAR_SIZES_CSA_20: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterSingleAutoBarSizes
        BAR_DIAMETER_SINGLE_AUTO_BAR_SIZES_CSA_25: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterSingleAutoBarSizes
        BAR_DIAMETER_SINGLE_AUTO_BAR_SIZES_CSA_30: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterSingleAutoBarSizes
        BAR_DIAMETER_SINGLE_AUTO_BAR_SIZES_CSA_35: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterSingleAutoBarSizes
        BAR_DIAMETER_SINGLE_AUTO_BAR_SIZES_CSA_45: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterSingleAutoBarSizes
        BAR_DIAMETER_SINGLE_AUTO_BAR_SIZES_CSA_55: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterSingleAutoBarSizes
        class BarSizeDesignationCorner(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            BAR_SIZE_DESIGNATION_CORNER_UNKNOWN: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationCorner]
        BAR_SIZE_DESIGNATION_CORNER_UNKNOWN: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationCorner
        class SpanPositionReferenceType(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            SPAN_POSITION_REFERENCE_TYPE_START: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.SpanPositionReferenceType]
            SPAN_POSITION_REFERENCE_TYPE_END: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.SpanPositionReferenceType]
            SPAN_POSITION_REFERENCE_TYPE_INTERNAL_NODE: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.SpanPositionReferenceType]
            SPAN_POSITION_REFERENCE_TYPE_X_LOCATION: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.SpanPositionReferenceType]
        SPAN_POSITION_REFERENCE_TYPE_START: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.SpanPositionReferenceType
        SPAN_POSITION_REFERENCE_TYPE_END: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.SpanPositionReferenceType
        SPAN_POSITION_REFERENCE_TYPE_INTERNAL_NODE: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.SpanPositionReferenceType
        SPAN_POSITION_REFERENCE_TYPE_X_LOCATION: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.SpanPositionReferenceType
        class SpanPositionDefinitionFormat(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            SPAN_POSITION_DEFINITION_FORMAT_ABSOLUTE: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.SpanPositionDefinitionFormat]
            SPAN_POSITION_DEFINITION_FORMAT_RELATIVE: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.SpanPositionDefinitionFormat]
        SPAN_POSITION_DEFINITION_FORMAT_ABSOLUTE: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.SpanPositionDefinitionFormat
        SPAN_POSITION_DEFINITION_FORMAT_RELATIVE: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.SpanPositionDefinitionFormat
        class AdditionalOffsetType(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            ADDITIONAL_OFFSET_TYPE_NONE: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.AdditionalOffsetType]
            ADDITIONAL_OFFSET_TYPE_FROM_CONCRETE_COVER: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.AdditionalOffsetType]
            ADDITIONAL_OFFSET_TYPE_FROM_SECTION_SURFACE: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.AdditionalOffsetType]
            ADDITIONAL_OFFSET_TYPE_FROM_STIRRUP: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.AdditionalOffsetType]
        ADDITIONAL_OFFSET_TYPE_NONE: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.AdditionalOffsetType
        ADDITIONAL_OFFSET_TYPE_FROM_CONCRETE_COVER: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.AdditionalOffsetType
        ADDITIONAL_OFFSET_TYPE_FROM_SECTION_SURFACE: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.AdditionalOffsetType
        ADDITIONAL_OFFSET_TYPE_FROM_STIRRUP: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.AdditionalOffsetType
        class AdditionalOffsetTypeSingleLine(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            ADDITIONAL_OFFSET_TYPE_SINGLE_LINE_NONE: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.AdditionalOffsetTypeSingleLine]
            ADDITIONAL_OFFSET_TYPE_SINGLE_LINE_FROM_CONCRETE_COVER: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.AdditionalOffsetTypeSingleLine]
            ADDITIONAL_OFFSET_TYPE_SINGLE_LINE_FROM_SECTION_SURFACE: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.AdditionalOffsetTypeSingleLine]
            ADDITIONAL_OFFSET_TYPE_SINGLE_LINE_FROM_STIRRUP: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.AdditionalOffsetTypeSingleLine]
        ADDITIONAL_OFFSET_TYPE_SINGLE_LINE_NONE: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.AdditionalOffsetTypeSingleLine
        ADDITIONAL_OFFSET_TYPE_SINGLE_LINE_FROM_CONCRETE_COVER: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.AdditionalOffsetTypeSingleLine
        ADDITIONAL_OFFSET_TYPE_SINGLE_LINE_FROM_SECTION_SURFACE: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.AdditionalOffsetTypeSingleLine
        ADDITIONAL_OFFSET_TYPE_SINGLE_LINE_FROM_STIRRUP: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.AdditionalOffsetTypeSingleLine
        class AdditionalOffsetReferenceType(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            ADDITIONAL_OFFSET_REFERENCE_TYPE_LEFT_TOP: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.AdditionalOffsetReferenceType]
            ADDITIONAL_OFFSET_REFERENCE_TYPE_CENTER_BOTTOM: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.AdditionalOffsetReferenceType]
            ADDITIONAL_OFFSET_REFERENCE_TYPE_CENTER_CENTER: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.AdditionalOffsetReferenceType]
            ADDITIONAL_OFFSET_REFERENCE_TYPE_CENTER_TOP: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.AdditionalOffsetReferenceType]
            ADDITIONAL_OFFSET_REFERENCE_TYPE_LEFT_BOTTOM: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.AdditionalOffsetReferenceType]
            ADDITIONAL_OFFSET_REFERENCE_TYPE_LEFT_CENTER: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.AdditionalOffsetReferenceType]
            ADDITIONAL_OFFSET_REFERENCE_TYPE_RIGHT_BOTTOM: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.AdditionalOffsetReferenceType]
            ADDITIONAL_OFFSET_REFERENCE_TYPE_RIGHT_CENTER: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.AdditionalOffsetReferenceType]
            ADDITIONAL_OFFSET_REFERENCE_TYPE_RIGHT_TOP: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.AdditionalOffsetReferenceType]
        ADDITIONAL_OFFSET_REFERENCE_TYPE_LEFT_TOP: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.AdditionalOffsetReferenceType
        ADDITIONAL_OFFSET_REFERENCE_TYPE_CENTER_BOTTOM: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.AdditionalOffsetReferenceType
        ADDITIONAL_OFFSET_REFERENCE_TYPE_CENTER_CENTER: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.AdditionalOffsetReferenceType
        ADDITIONAL_OFFSET_REFERENCE_TYPE_CENTER_TOP: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.AdditionalOffsetReferenceType
        ADDITIONAL_OFFSET_REFERENCE_TYPE_LEFT_BOTTOM: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.AdditionalOffsetReferenceType
        ADDITIONAL_OFFSET_REFERENCE_TYPE_LEFT_CENTER: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.AdditionalOffsetReferenceType
        ADDITIONAL_OFFSET_REFERENCE_TYPE_RIGHT_BOTTOM: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.AdditionalOffsetReferenceType
        ADDITIONAL_OFFSET_REFERENCE_TYPE_RIGHT_CENTER: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.AdditionalOffsetReferenceType
        ADDITIONAL_OFFSET_REFERENCE_TYPE_RIGHT_TOP: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.AdditionalOffsetReferenceType
        class AdditionalOffsetReferenceTypeAtStart(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            ADDITIONAL_OFFSET_REFERENCE_TYPE_AT_START_LEFT_TOP: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.AdditionalOffsetReferenceTypeAtStart]
            ADDITIONAL_OFFSET_REFERENCE_TYPE_AT_START_CENTER_BOTTOM: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.AdditionalOffsetReferenceTypeAtStart]
            ADDITIONAL_OFFSET_REFERENCE_TYPE_AT_START_CENTER_CENTER: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.AdditionalOffsetReferenceTypeAtStart]
            ADDITIONAL_OFFSET_REFERENCE_TYPE_AT_START_CENTER_TOP: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.AdditionalOffsetReferenceTypeAtStart]
            ADDITIONAL_OFFSET_REFERENCE_TYPE_AT_START_LEFT_BOTTOM: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.AdditionalOffsetReferenceTypeAtStart]
            ADDITIONAL_OFFSET_REFERENCE_TYPE_AT_START_LEFT_CENTER: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.AdditionalOffsetReferenceTypeAtStart]
            ADDITIONAL_OFFSET_REFERENCE_TYPE_AT_START_RIGHT_BOTTOM: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.AdditionalOffsetReferenceTypeAtStart]
            ADDITIONAL_OFFSET_REFERENCE_TYPE_AT_START_RIGHT_CENTER: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.AdditionalOffsetReferenceTypeAtStart]
            ADDITIONAL_OFFSET_REFERENCE_TYPE_AT_START_RIGHT_TOP: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.AdditionalOffsetReferenceTypeAtStart]
        ADDITIONAL_OFFSET_REFERENCE_TYPE_AT_START_LEFT_TOP: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.AdditionalOffsetReferenceTypeAtStart
        ADDITIONAL_OFFSET_REFERENCE_TYPE_AT_START_CENTER_BOTTOM: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.AdditionalOffsetReferenceTypeAtStart
        ADDITIONAL_OFFSET_REFERENCE_TYPE_AT_START_CENTER_CENTER: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.AdditionalOffsetReferenceTypeAtStart
        ADDITIONAL_OFFSET_REFERENCE_TYPE_AT_START_CENTER_TOP: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.AdditionalOffsetReferenceTypeAtStart
        ADDITIONAL_OFFSET_REFERENCE_TYPE_AT_START_LEFT_BOTTOM: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.AdditionalOffsetReferenceTypeAtStart
        ADDITIONAL_OFFSET_REFERENCE_TYPE_AT_START_LEFT_CENTER: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.AdditionalOffsetReferenceTypeAtStart
        ADDITIONAL_OFFSET_REFERENCE_TYPE_AT_START_RIGHT_BOTTOM: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.AdditionalOffsetReferenceTypeAtStart
        ADDITIONAL_OFFSET_REFERENCE_TYPE_AT_START_RIGHT_CENTER: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.AdditionalOffsetReferenceTypeAtStart
        ADDITIONAL_OFFSET_REFERENCE_TYPE_AT_START_RIGHT_TOP: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.AdditionalOffsetReferenceTypeAtStart
        class AdditionalOffsetReferenceTypeAtEnd(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            ADDITIONAL_OFFSET_REFERENCE_TYPE_AT_END_LEFT_TOP: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.AdditionalOffsetReferenceTypeAtEnd]
            ADDITIONAL_OFFSET_REFERENCE_TYPE_AT_END_CENTER_BOTTOM: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.AdditionalOffsetReferenceTypeAtEnd]
            ADDITIONAL_OFFSET_REFERENCE_TYPE_AT_END_CENTER_CENTER: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.AdditionalOffsetReferenceTypeAtEnd]
            ADDITIONAL_OFFSET_REFERENCE_TYPE_AT_END_CENTER_TOP: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.AdditionalOffsetReferenceTypeAtEnd]
            ADDITIONAL_OFFSET_REFERENCE_TYPE_AT_END_LEFT_BOTTOM: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.AdditionalOffsetReferenceTypeAtEnd]
            ADDITIONAL_OFFSET_REFERENCE_TYPE_AT_END_LEFT_CENTER: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.AdditionalOffsetReferenceTypeAtEnd]
            ADDITIONAL_OFFSET_REFERENCE_TYPE_AT_END_RIGHT_BOTTOM: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.AdditionalOffsetReferenceTypeAtEnd]
            ADDITIONAL_OFFSET_REFERENCE_TYPE_AT_END_RIGHT_CENTER: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.AdditionalOffsetReferenceTypeAtEnd]
            ADDITIONAL_OFFSET_REFERENCE_TYPE_AT_END_RIGHT_TOP: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.AdditionalOffsetReferenceTypeAtEnd]
        ADDITIONAL_OFFSET_REFERENCE_TYPE_AT_END_LEFT_TOP: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.AdditionalOffsetReferenceTypeAtEnd
        ADDITIONAL_OFFSET_REFERENCE_TYPE_AT_END_CENTER_BOTTOM: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.AdditionalOffsetReferenceTypeAtEnd
        ADDITIONAL_OFFSET_REFERENCE_TYPE_AT_END_CENTER_CENTER: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.AdditionalOffsetReferenceTypeAtEnd
        ADDITIONAL_OFFSET_REFERENCE_TYPE_AT_END_CENTER_TOP: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.AdditionalOffsetReferenceTypeAtEnd
        ADDITIONAL_OFFSET_REFERENCE_TYPE_AT_END_LEFT_BOTTOM: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.AdditionalOffsetReferenceTypeAtEnd
        ADDITIONAL_OFFSET_REFERENCE_TYPE_AT_END_LEFT_CENTER: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.AdditionalOffsetReferenceTypeAtEnd
        ADDITIONAL_OFFSET_REFERENCE_TYPE_AT_END_RIGHT_BOTTOM: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.AdditionalOffsetReferenceTypeAtEnd
        ADDITIONAL_OFFSET_REFERENCE_TYPE_AT_END_RIGHT_CENTER: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.AdditionalOffsetReferenceTypeAtEnd
        ADDITIONAL_OFFSET_REFERENCE_TYPE_AT_END_RIGHT_TOP: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.AdditionalOffsetReferenceTypeAtEnd
        class AnchorageStartAnchorType(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            ANCHORAGE_START_ANCHOR_TYPE_NONE: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.AnchorageStartAnchorType]
            ANCHORAGE_START_ANCHOR_TYPE_BEND: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.AnchorageStartAnchorType]
            ANCHORAGE_START_ANCHOR_TYPE_HOOK: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.AnchorageStartAnchorType]
            ANCHORAGE_START_ANCHOR_TYPE_HOOK_WITH_TRANSVERSE_BAR: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.AnchorageStartAnchorType]
            ANCHORAGE_START_ANCHOR_TYPE_STRAIGHT: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.AnchorageStartAnchorType]
            ANCHORAGE_START_ANCHOR_TYPE_STRAIGHT_WITH_TRANSVERSE_BAR: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.AnchorageStartAnchorType]
            ANCHORAGE_START_ANCHOR_TYPE_STRAIGHT_WITH_TWO_TRANSVERSE_BARS: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.AnchorageStartAnchorType]
        ANCHORAGE_START_ANCHOR_TYPE_NONE: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.AnchorageStartAnchorType
        ANCHORAGE_START_ANCHOR_TYPE_BEND: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.AnchorageStartAnchorType
        ANCHORAGE_START_ANCHOR_TYPE_HOOK: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.AnchorageStartAnchorType
        ANCHORAGE_START_ANCHOR_TYPE_HOOK_WITH_TRANSVERSE_BAR: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.AnchorageStartAnchorType
        ANCHORAGE_START_ANCHOR_TYPE_STRAIGHT: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.AnchorageStartAnchorType
        ANCHORAGE_START_ANCHOR_TYPE_STRAIGHT_WITH_TRANSVERSE_BAR: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.AnchorageStartAnchorType
        ANCHORAGE_START_ANCHOR_TYPE_STRAIGHT_WITH_TWO_TRANSVERSE_BARS: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.AnchorageStartAnchorType
        class AnchorageEndAnchorType(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            ANCHORAGE_END_ANCHOR_TYPE_NONE: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.AnchorageEndAnchorType]
            ANCHORAGE_END_ANCHOR_TYPE_BEND: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.AnchorageEndAnchorType]
            ANCHORAGE_END_ANCHOR_TYPE_HOOK: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.AnchorageEndAnchorType]
            ANCHORAGE_END_ANCHOR_TYPE_HOOK_WITH_TRANSVERSE_BAR: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.AnchorageEndAnchorType]
            ANCHORAGE_END_ANCHOR_TYPE_STRAIGHT: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.AnchorageEndAnchorType]
            ANCHORAGE_END_ANCHOR_TYPE_STRAIGHT_WITH_TRANSVERSE_BAR: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.AnchorageEndAnchorType]
            ANCHORAGE_END_ANCHOR_TYPE_STRAIGHT_WITH_TWO_TRANSVERSE_BARS: _ClassVar[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.AnchorageEndAnchorType]
        ANCHORAGE_END_ANCHOR_TYPE_NONE: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.AnchorageEndAnchorType
        ANCHORAGE_END_ANCHOR_TYPE_BEND: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.AnchorageEndAnchorType
        ANCHORAGE_END_ANCHOR_TYPE_HOOK: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.AnchorageEndAnchorType
        ANCHORAGE_END_ANCHOR_TYPE_HOOK_WITH_TRANSVERSE_BAR: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.AnchorageEndAnchorType
        ANCHORAGE_END_ANCHOR_TYPE_STRAIGHT: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.AnchorageEndAnchorType
        ANCHORAGE_END_ANCHOR_TYPE_STRAIGHT_WITH_TRANSVERSE_BAR: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.AnchorageEndAnchorType
        ANCHORAGE_END_ANCHOR_TYPE_STRAIGHT_WITH_TWO_TRANSVERSE_BARS: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.AnchorageEndAnchorType
        NO_FIELD_NUMBER: _ClassVar[int]
        DESCRIPTION_FIELD_NUMBER: _ClassVar[int]
        NAME_FIELD_NUMBER: _ClassVar[int]
        REBAR_TYPE_FIELD_NUMBER: _ClassVar[int]
        MATERIAL_FIELD_NUMBER: _ClassVar[int]
        REINFORCEMENT_PLACED_IN_BENDING_CORNER_ENABLED_FIELD_NUMBER: _ClassVar[int]
        BAR_COUNT_SYMMETRICAL_FIELD_NUMBER: _ClassVar[int]
        BAR_COUNT_SYMMETRICAL_CALCULATED_FIELD_NUMBER: _ClassVar[int]
        BAR_COUNT_SYMMETRICAL_AUTO_ENABLED_FIELD_NUMBER: _ClassVar[int]
        BAR_COUNT_SYMMETRICAL_AUTO_MINIMUM_FIELD_NUMBER: _ClassVar[int]
        BAR_COUNT_SYMMETRICAL_AUTO_MAXIMUM_FIELD_NUMBER: _ClassVar[int]
        BAR_COUNT_SYMMETRICAL_AUTO_INCREMENT_FIELD_NUMBER: _ClassVar[int]
        BAR_COUNT_SYMMETRICAL_AUTO_PRIORITY_FIELD_NUMBER: _ClassVar[int]
        BAR_COUNT_UNSYMMETRICAL_AT_SIDE_FIELD_NUMBER: _ClassVar[int]
        BAR_COUNT_UNSYMMETRICAL_TOP_SIDE_FIELD_NUMBER: _ClassVar[int]
        BAR_COUNT_UNSYMMETRICAL_TOP_SIDE_CALCULATED_FIELD_NUMBER: _ClassVar[int]
        BAR_COUNT_UNSYMMETRICAL_TOP_SIDE_AUTO_ENABLED_FIELD_NUMBER: _ClassVar[int]
        BAR_COUNT_UNSYMMETRICAL_TOP_SIDE_AUTO_MINIMUM_FIELD_NUMBER: _ClassVar[int]
        BAR_COUNT_UNSYMMETRICAL_TOP_SIDE_AUTO_MAXIMUM_FIELD_NUMBER: _ClassVar[int]
        BAR_COUNT_UNSYMMETRICAL_TOP_SIDE_AUTO_INCREMENT_FIELD_NUMBER: _ClassVar[int]
        BAR_COUNT_UNSYMMETRICAL_TOP_SIDE_AUTO_PRIORITY_FIELD_NUMBER: _ClassVar[int]
        BAR_COUNT_UNSYMMETRICAL_BOTTOM_SIDE_FIELD_NUMBER: _ClassVar[int]
        BAR_COUNT_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_FIELD_NUMBER: _ClassVar[int]
        BAR_COUNT_UNSYMMETRICAL_BOTTOM_SIDE_AUTO_ENABLED_FIELD_NUMBER: _ClassVar[int]
        BAR_COUNT_UNSYMMETRICAL_BOTTOM_SIDE_AUTO_MINIMUM_FIELD_NUMBER: _ClassVar[int]
        BAR_COUNT_UNSYMMETRICAL_BOTTOM_SIDE_AUTO_MAXIMUM_FIELD_NUMBER: _ClassVar[int]
        BAR_COUNT_UNSYMMETRICAL_BOTTOM_SIDE_AUTO_INCREMENT_FIELD_NUMBER: _ClassVar[int]
        BAR_COUNT_UNSYMMETRICAL_BOTTOM_SIDE_AUTO_PRIORITY_FIELD_NUMBER: _ClassVar[int]
        BAR_COUNT_UNIFORMLY_SURROUNDING_FIELD_NUMBER: _ClassVar[int]
        BAR_COUNT_UNIFORMLY_SURROUNDING_CALCULATED_FIELD_NUMBER: _ClassVar[int]
        BAR_COUNT_UNIFORMLY_SURROUNDING_AUTO_ENABLED_FIELD_NUMBER: _ClassVar[int]
        BAR_COUNT_UNIFORMLY_SURROUNDING_AUTO_MINIMUM_FIELD_NUMBER: _ClassVar[int]
        BAR_COUNT_UNIFORMLY_SURROUNDING_AUTO_MAXIMUM_FIELD_NUMBER: _ClassVar[int]
        BAR_COUNT_UNIFORMLY_SURROUNDING_AUTO_INCREMENT_FIELD_NUMBER: _ClassVar[int]
        BAR_COUNT_UNIFORMLY_SURROUNDING_AUTO_PRIORITY_FIELD_NUMBER: _ClassVar[int]
        BAR_COUNT_LINE_FIELD_NUMBER: _ClassVar[int]
        BAR_COUNT_LINE_CALCULATED_FIELD_NUMBER: _ClassVar[int]
        BAR_COUNT_LINE_AUTO_ENABLED_FIELD_NUMBER: _ClassVar[int]
        BAR_COUNT_LINE_AUTO_MINIMUM_FIELD_NUMBER: _ClassVar[int]
        BAR_COUNT_LINE_AUTO_MAXIMUM_FIELD_NUMBER: _ClassVar[int]
        BAR_COUNT_LINE_AUTO_INCREMENT_FIELD_NUMBER: _ClassVar[int]
        BAR_COUNT_LINE_AUTO_PRIORITY_FIELD_NUMBER: _ClassVar[int]
        BAR_COUNT_CORNER_FIELD_NUMBER: _ClassVar[int]
        BAR_SIZE_DESIGNATION_SYMMETRICAL_FIELD_NUMBER: _ClassVar[int]
        BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_SYMMETRICAL_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_SYMMETRICAL_CALCULATED_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_SYMMETRICAL_AUTO_ENABLED_FIELD_NUMBER: _ClassVar[int]
        BAR_SIZE_DESIGNATION_SYMMETRICAL_AUTO_MINIMUM_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_SYMMETRICAL_AUTO_MINIMUM_FIELD_NUMBER: _ClassVar[int]
        BAR_SIZE_DESIGNATION_SYMMETRICAL_AUTO_MAXIMUM_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_SYMMETRICAL_AUTO_MAXIMUM_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_SYMMETRICAL_AUTO_DIAMETERS_ENABLED_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_SYMMETRICAL_AUTO_BAR_SIZES_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_SYMMETRICAL_AUTO_DIAMETERS_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_SYMMETRICAL_AUTO_PRIORITY_FIELD_NUMBER: _ClassVar[int]
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_AT_SIDE_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_UNSYMMETRICAL_AT_SIDE_FIELD_NUMBER: _ClassVar[int]
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_FIELD_NUMBER: _ClassVar[int]
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_UNSYMMETRICAL_TOP_SIDE_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_UNSYMMETRICAL_TOP_SIDE_CALCULATED_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_UNSYMMETRICAL_TOP_SIDE_AUTO_ENABLED_FIELD_NUMBER: _ClassVar[int]
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_AUTO_MINIMUM_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_UNSYMMETRICAL_TOP_SIDE_AUTO_MINIMUM_FIELD_NUMBER: _ClassVar[int]
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_AUTO_MAXIMUM_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_UNSYMMETRICAL_TOP_SIDE_AUTO_MAXIMUM_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_UNSYMMETRICAL_TOP_SIDE_AUTO_DIAMETERS_ENABLED_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_UNSYMMETRICAL_TOP_SIDE_AUTO_BAR_SIZES_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_UNSYMMETRICAL_TOP_SIDE_AUTO_DIAMETERS_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_UNSYMMETRICAL_TOP_SIDE_AUTO_PRIORITY_FIELD_NUMBER: _ClassVar[int]
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_FIELD_NUMBER: _ClassVar[int]
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_UNSYMMETRICAL_BOTTOM_SIDE_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_UNSYMMETRICAL_BOTTOM_SIDE_AUTO_ENABLED_FIELD_NUMBER: _ClassVar[int]
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_AUTO_MINIMUM_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_UNSYMMETRICAL_BOTTOM_SIDE_AUTO_MINIMUM_FIELD_NUMBER: _ClassVar[int]
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_AUTO_MAXIMUM_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_UNSYMMETRICAL_BOTTOM_SIDE_AUTO_MAXIMUM_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_UNSYMMETRICAL_BOTTOM_SIDE_AUTO_DIAMETERS_ENABLED_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_UNSYMMETRICAL_BOTTOM_SIDE_AUTO_BAR_SIZES_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_UNSYMMETRICAL_BOTTOM_SIDE_AUTO_DIAMETERS_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_UNSYMMETRICAL_BOTTOM_SIDE_AUTO_PRIORITY_FIELD_NUMBER: _ClassVar[int]
        BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_FIELD_NUMBER: _ClassVar[int]
        BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_UNIFORMLY_SURROUNDING_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_UNIFORMLY_SURROUNDING_CALCULATED_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_UNIFORMLY_SURROUNDING_AUTO_ENABLED_FIELD_NUMBER: _ClassVar[int]
        BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_AUTO_MINIMUM_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_UNIFORMLY_SURROUNDING_AUTO_MINIMUM_FIELD_NUMBER: _ClassVar[int]
        BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_AUTO_MAXIMUM_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_UNIFORMLY_SURROUNDING_AUTO_MAXIMUM_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_UNIFORMLY_SURROUNDING_AUTO_DIAMETERS_ENABLED_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_UNIFORMLY_SURROUNDING_AUTO_BAR_SIZES_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_UNIFORMLY_SURROUNDING_AUTO_DIAMETERS_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_UNIFORMLY_SURROUNDING_AUTO_PRIORITY_FIELD_NUMBER: _ClassVar[int]
        BAR_SIZE_DESIGNATION_LINE_FIELD_NUMBER: _ClassVar[int]
        BAR_SIZE_DESIGNATION_LINE_CALCULATED_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_LINE_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_LINE_CALCULATED_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_LINE_AUTO_ENABLED_FIELD_NUMBER: _ClassVar[int]
        BAR_SIZE_DESIGNATION_LINE_AUTO_MINIMUM_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_LINE_AUTO_MINIMUM_FIELD_NUMBER: _ClassVar[int]
        BAR_SIZE_DESIGNATION_LINE_AUTO_MAXIMUM_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_LINE_AUTO_MAXIMUM_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_LINE_AUTO_DIAMETERS_ENABLED_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_LINE_AUTO_BAR_SIZES_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_LINE_AUTO_DIAMETERS_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_LINE_AUTO_PRIORITY_FIELD_NUMBER: _ClassVar[int]
        BAR_SIZE_DESIGNATION_SINGLE_FIELD_NUMBER: _ClassVar[int]
        BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_SINGLE_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_SINGLE_CALCULATED_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_SINGLE_AUTO_ENABLED_FIELD_NUMBER: _ClassVar[int]
        BAR_SIZE_DESIGNATION_SINGLE_AUTO_MINIMUM_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_SINGLE_AUTO_MINIMUM_FIELD_NUMBER: _ClassVar[int]
        BAR_SIZE_DESIGNATION_SINGLE_AUTO_MAXIMUM_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_SINGLE_AUTO_MAXIMUM_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_SINGLE_AUTO_DIAMETERS_ENABLED_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_SINGLE_AUTO_BAR_SIZES_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_SINGLE_AUTO_DIAMETERS_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_SINGLE_AUTO_PRIORITY_FIELD_NUMBER: _ClassVar[int]
        BAR_SIZE_DESIGNATION_CORNER_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_CORNER_FIELD_NUMBER: _ClassVar[int]
        BASE_DIAMTER_REDUCED_MULTI_EDIT_FIELD_NUMBER: _ClassVar[int]
        CORNER_REINFORCEMENT_ENABLED_FIELD_NUMBER: _ClassVar[int]
        REINFORCEMENT_AREA_SYMMETRICAL_FIELD_NUMBER: _ClassVar[int]
        REINFORCEMENT_AREA_UNSYMMETRICAL_AT_SIDE_FIELD_NUMBER: _ClassVar[int]
        REINFORCEMENT_AREA_UNSYMMETRICAL_TOP_SIDE_FIELD_NUMBER: _ClassVar[int]
        REINFORCEMENT_AREA_UNSYMMETRICAL_BOTTOM_SIDE_FIELD_NUMBER: _ClassVar[int]
        REINFORCEMENT_AREA_UNIFORMLY_SURROUNDING_FIELD_NUMBER: _ClassVar[int]
        REINFORCEMENT_AREA_LINE_FIELD_NUMBER: _ClassVar[int]
        REINFORCEMENT_AREA_SINGLE_FIELD_NUMBER: _ClassVar[int]
        REINFORCEMENT_AREA_CORNER_FIELD_NUMBER: _ClassVar[int]
        REINFORCEMENT_AREA_TOTAL_FIELD_NUMBER: _ClassVar[int]
        SPAN_POSITION_REFERENCE_TYPE_FIELD_NUMBER: _ClassVar[int]
        SPAN_POSITION_REFERENCE_INTERNAL_NODE_FIELD_NUMBER: _ClassVar[int]
        SPAN_POSITION_REFERENCE_X_LOCATION_RELATIVE_FIELD_NUMBER: _ClassVar[int]
        SPAN_POSITION_REFERENCE_X_LOCATION_ABSOLUTE_FIELD_NUMBER: _ClassVar[int]
        SPAN_POSITION_DEFINITION_FORMAT_FIELD_NUMBER: _ClassVar[int]
        SPAN_START_RELATIVE_FIELD_NUMBER: _ClassVar[int]
        SPAN_START_ABSOLUTE_FIELD_NUMBER: _ClassVar[int]
        SPAN_START_AUTO_ENABLED_FIELD_NUMBER: _ClassVar[int]
        SPAN_START_RELATIVE_AUTO_CALCULATED_FIELD_NUMBER: _ClassVar[int]
        SPAN_START_RELATIVE_AUTO_MINIMUM_FIELD_NUMBER: _ClassVar[int]
        SPAN_START_RELATIVE_AUTO_MAXIMUM_FIELD_NUMBER: _ClassVar[int]
        SPAN_START_ABSOLUTE_AUTO_CALCULATED_FIELD_NUMBER: _ClassVar[int]
        SPAN_START_ABSOLUTE_AUTO_MINIMUM_FIELD_NUMBER: _ClassVar[int]
        SPAN_START_ABSOLUTE_AUTO_MAXIMUM_FIELD_NUMBER: _ClassVar[int]
        SPAN_END_RELATIVE_FIELD_NUMBER: _ClassVar[int]
        SPAN_END_ABSOLUTE_FIELD_NUMBER: _ClassVar[int]
        SPAN_END_AUTO_ENABLED_FIELD_NUMBER: _ClassVar[int]
        SPAN_END_RELATIVE_AUTO_CALCULATED_FIELD_NUMBER: _ClassVar[int]
        SPAN_END_RELATIVE_AUTO_MINIMUM_FIELD_NUMBER: _ClassVar[int]
        SPAN_END_RELATIVE_AUTO_MAXIMUM_FIELD_NUMBER: _ClassVar[int]
        SPAN_END_ABSOLUTE_AUTO_CALCULATED_FIELD_NUMBER: _ClassVar[int]
        SPAN_END_ABSOLUTE_AUTO_MINIMUM_FIELD_NUMBER: _ClassVar[int]
        SPAN_END_ABSOLUTE_AUTO_MAXIMUM_FIELD_NUMBER: _ClassVar[int]
        SPAN_LOCATION_AUTO_INCREMENT_FIELD_NUMBER: _ClassVar[int]
        SPAN_LOCATION_AUTO_PRIORITY_FIELD_NUMBER: _ClassVar[int]
        SPAN_LENGTH_FIELD_NUMBER: _ClassVar[int]
        ADDITIONAL_OFFSET_TYPE_FIELD_NUMBER: _ClassVar[int]
        ADDITIONAL_OFFSET_TYPE_SINGLE_LINE_FIELD_NUMBER: _ClassVar[int]
        ADDITIONAL_OFFSET_CIRCLE_FIELD_NUMBER: _ClassVar[int]
        ADDITIONAL_OFFSET_TOP_SIDE_FIELD_NUMBER: _ClassVar[int]
        ADDITIONAL_OFFSET_BOTTOM_SIDE_FIELD_NUMBER: _ClassVar[int]
        ADDITIONAL_OFFSET_LEFT_SIDE_FIELD_NUMBER: _ClassVar[int]
        ADDITIONAL_OFFSET_RIGHT_SIDE_FIELD_NUMBER: _ClassVar[int]
        ADDITIONAL_OFFSET_REFERENCE_TYPE_FIELD_NUMBER: _ClassVar[int]
        ADDITIONAL_OFFSET_REFERENCE_TYPE_AT_START_FIELD_NUMBER: _ClassVar[int]
        ADDITIONAL_OFFSET_REFERENCE_TYPE_AT_END_FIELD_NUMBER: _ClassVar[int]
        ADDITIONAL_HORIZONTAL_OFFSET_FIELD_NUMBER: _ClassVar[int]
        ADDITIONAL_HORIZONTAL_OFFSET_AT_START_FIELD_NUMBER: _ClassVar[int]
        ADDITIONAL_HORIZONTAL_OFFSET_AT_END_FIELD_NUMBER: _ClassVar[int]
        ADDITIONAL_VERTICAL_OFFSET_FIELD_NUMBER: _ClassVar[int]
        ADDITIONAL_VERTICAL_OFFSET_AT_START_FIELD_NUMBER: _ClassVar[int]
        ADDITIONAL_VERTICAL_OFFSET_AT_END_FIELD_NUMBER: _ClassVar[int]
        ANCHORAGE_START_ANCHOR_TYPE_FIELD_NUMBER: _ClassVar[int]
        ANCHORAGE_START_ANCHOR_LENGTH_FIELD_NUMBER: _ClassVar[int]
        ANCHORAGE_START_BENDING_DIAMETER_FIELD_NUMBER: _ClassVar[int]
        ANCHORAGE_END_ANCHOR_TYPE_FIELD_NUMBER: _ClassVar[int]
        ANCHORAGE_END_ANCHOR_LENGTH_FIELD_NUMBER: _ClassVar[int]
        ANCHORAGE_END_BENDING_DIAMETER_FIELD_NUMBER: _ClassVar[int]
        ONE_REBAR_LENGTH_FIELD_NUMBER: _ClassVar[int]
        ONE_REBAR_MINIMAL_AND_MAXIMAL_LENGTH_FIELD_NUMBER: _ClassVar[int]
        ONE_REBAR_UNSYMMETRICAL_AT_SIDE_LENGTH_FIELD_NUMBER: _ClassVar[int]
        ONE_REBAR_UNSYMMETRICAL_AT_SIDE_MINIMAL_AND_MAXIMAL_LENGTH_FIELD_NUMBER: _ClassVar[int]
        ONE_REBAR_UNSYMMETRICAL_TOP_SIDE_LENGTH_FIELD_NUMBER: _ClassVar[int]
        ONE_REBAR_UNSYMMETRICAL_TOP_SIDE_MINIMAL_AND_MAXIMAL_LENGTH_FIELD_NUMBER: _ClassVar[int]
        ONE_REBAR_UNSYMMETRICAL_BOTTOM_SIDE_LENGTH_FIELD_NUMBER: _ClassVar[int]
        ONE_REBAR_UNSYMMETRICAL_BOTTOM_SIDE_MINIMAL_AND_MAXIMAL_LENGTH_FIELD_NUMBER: _ClassVar[int]
        ONE_REBAR_CORNER_LENGTH_FIELD_NUMBER: _ClassVar[int]
        ONE_REBAR_CORNER_MINIMAL_AND_MAXIMAL_LENGTH_FIELD_NUMBER: _ClassVar[int]
        LENGTH_FIELD_NUMBER: _ClassVar[int]
        ONE_REBAR_WEIGHT_FIELD_NUMBER: _ClassVar[int]
        ONE_REBAR_MINIMAL_AND_MAXIMAL_WEIGHT_FIELD_NUMBER: _ClassVar[int]
        ONE_REBAR_UNSYMMETRICAL_AT_SIDE_WEIGHT_FIELD_NUMBER: _ClassVar[int]
        ONE_REBAR_UNSYMMETRICAL_AT_SIDE_MINIMAL_AND_MAXIMAL_WEIGHT_FIELD_NUMBER: _ClassVar[int]
        ONE_REBAR_UNSYMMETRICAL_TOP_SIDE_WEIGHT_FIELD_NUMBER: _ClassVar[int]
        ONE_REBAR_UNSYMMETRICAL_TOP_SIDE_MINIMAL_AND_MAXIMAL_WEIGHT_FIELD_NUMBER: _ClassVar[int]
        ONE_REBAR_UNSYMMETRICAL_BOTTOM_SIDE_WEIGHT_FIELD_NUMBER: _ClassVar[int]
        ONE_REBAR_UNSYMMETRICAL_BOTTOM_SIDE_MINIMAL_AND_MAXIMAL_WEIGHT_FIELD_NUMBER: _ClassVar[int]
        ONE_REBAR_CORNER_WEIGHT_FIELD_NUMBER: _ClassVar[int]
        ONE_REBAR_CORNER_MINIMAL_AND_MAXIMAL_WEIGHT_FIELD_NUMBER: _ClassVar[int]
        WEIGHT_FIELD_NUMBER: _ClassVar[int]
        no: int
        description: str
        name: str
        rebar_type: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.RebarType
        material: int
        reinforcement_placed_in_bending_corner_enabled: bool
        bar_count_symmetrical: int
        bar_count_symmetrical_calculated: int
        bar_count_symmetrical_auto_enabled: bool
        bar_count_symmetrical_auto_minimum: int
        bar_count_symmetrical_auto_maximum: int
        bar_count_symmetrical_auto_increment: int
        bar_count_symmetrical_auto_priority: int
        bar_count_unsymmetrical_at_side: int
        bar_count_unsymmetrical_top_side: int
        bar_count_unsymmetrical_top_side_calculated: int
        bar_count_unsymmetrical_top_side_auto_enabled: bool
        bar_count_unsymmetrical_top_side_auto_minimum: int
        bar_count_unsymmetrical_top_side_auto_maximum: int
        bar_count_unsymmetrical_top_side_auto_increment: int
        bar_count_unsymmetrical_top_side_auto_priority: int
        bar_count_unsymmetrical_bottom_side: int
        bar_count_unsymmetrical_bottom_side_calculated: int
        bar_count_unsymmetrical_bottom_side_auto_enabled: bool
        bar_count_unsymmetrical_bottom_side_auto_minimum: int
        bar_count_unsymmetrical_bottom_side_auto_maximum: int
        bar_count_unsymmetrical_bottom_side_auto_increment: int
        bar_count_unsymmetrical_bottom_side_auto_priority: int
        bar_count_uniformly_surrounding: int
        bar_count_uniformly_surrounding_calculated: int
        bar_count_uniformly_surrounding_auto_enabled: bool
        bar_count_uniformly_surrounding_auto_minimum: int
        bar_count_uniformly_surrounding_auto_maximum: int
        bar_count_uniformly_surrounding_auto_increment: int
        bar_count_uniformly_surrounding_auto_priority: int
        bar_count_line: int
        bar_count_line_calculated: int
        bar_count_line_auto_enabled: bool
        bar_count_line_auto_minimum: int
        bar_count_line_auto_maximum: int
        bar_count_line_auto_increment: int
        bar_count_line_auto_priority: int
        bar_count_corner: int
        bar_size_designation_symmetrical: float
        bar_size_designation_symmetrical_calculated: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationSymmetricalCalculated
        bar_diameter_symmetrical: float
        bar_diameter_symmetrical_calculated: float
        bar_diameter_symmetrical_auto_enabled: bool
        bar_size_designation_symmetrical_auto_minimum: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationSymmetricalAutoMinimum
        bar_diameter_symmetrical_auto_minimum: float
        bar_size_designation_symmetrical_auto_maximum: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationSymmetricalAutoMaximum
        bar_diameter_symmetrical_auto_maximum: float
        bar_diameter_symmetrical_auto_diameters_enabled: bool
        bar_diameter_symmetrical_auto_bar_sizes: _containers.RepeatedScalarFieldContainer[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterSymmetricalAutoBarSizes]
        bar_diameter_symmetrical_auto_diameters: _containers.RepeatedScalarFieldContainer[float]
        bar_diameter_symmetrical_auto_priority: int
        bar_size_designation_unsymmetrical_at_side: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUnsymmetricalAtSide
        bar_diameter_unsymmetrical_at_side: float
        bar_size_designation_unsymmetrical_top_side: float
        bar_size_designation_unsymmetrical_top_side_calculated: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUnsymmetricalTopSideCalculated
        bar_diameter_unsymmetrical_top_side: float
        bar_diameter_unsymmetrical_top_side_calculated: float
        bar_diameter_unsymmetrical_top_side_auto_enabled: bool
        bar_size_designation_unsymmetrical_top_side_auto_minimum: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUnsymmetricalTopSideAutoMinimum
        bar_diameter_unsymmetrical_top_side_auto_minimum: float
        bar_size_designation_unsymmetrical_top_side_auto_maximum: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUnsymmetricalTopSideAutoMaximum
        bar_diameter_unsymmetrical_top_side_auto_maximum: float
        bar_diameter_unsymmetrical_top_side_auto_diameters_enabled: bool
        bar_diameter_unsymmetrical_top_side_auto_bar_sizes: _containers.RepeatedScalarFieldContainer[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterUnsymmetricalTopSideAutoBarSizes]
        bar_diameter_unsymmetrical_top_side_auto_diameters: _containers.RepeatedScalarFieldContainer[float]
        bar_diameter_unsymmetrical_top_side_auto_priority: int
        bar_size_designation_unsymmetrical_bottom_side: float
        bar_size_designation_unsymmetrical_bottom_side_calculated: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUnsymmetricalBottomSideCalculated
        bar_diameter_unsymmetrical_bottom_side: float
        bar_diameter_unsymmetrical_bottom_side_calculated: float
        bar_diameter_unsymmetrical_bottom_side_auto_enabled: bool
        bar_size_designation_unsymmetrical_bottom_side_auto_minimum: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUnsymmetricalBottomSideAutoMinimum
        bar_diameter_unsymmetrical_bottom_side_auto_minimum: float
        bar_size_designation_unsymmetrical_bottom_side_auto_maximum: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUnsymmetricalBottomSideAutoMaximum
        bar_diameter_unsymmetrical_bottom_side_auto_maximum: float
        bar_diameter_unsymmetrical_bottom_side_auto_diameters_enabled: bool
        bar_diameter_unsymmetrical_bottom_side_auto_bar_sizes: _containers.RepeatedScalarFieldContainer[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterUnsymmetricalBottomSideAutoBarSizes]
        bar_diameter_unsymmetrical_bottom_side_auto_diameters: _containers.RepeatedScalarFieldContainer[float]
        bar_diameter_unsymmetrical_bottom_side_auto_priority: int
        bar_size_designation_uniformly_surrounding: float
        bar_size_designation_uniformly_surrounding_calculated: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUniformlySurroundingCalculated
        bar_diameter_uniformly_surrounding: float
        bar_diameter_uniformly_surrounding_calculated: float
        bar_diameter_uniformly_surrounding_auto_enabled: bool
        bar_size_designation_uniformly_surrounding_auto_minimum: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUniformlySurroundingAutoMinimum
        bar_diameter_uniformly_surrounding_auto_minimum: float
        bar_size_designation_uniformly_surrounding_auto_maximum: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUniformlySurroundingAutoMaximum
        bar_diameter_uniformly_surrounding_auto_maximum: float
        bar_diameter_uniformly_surrounding_auto_diameters_enabled: bool
        bar_diameter_uniformly_surrounding_auto_bar_sizes: _containers.RepeatedScalarFieldContainer[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterUniformlySurroundingAutoBarSizes]
        bar_diameter_uniformly_surrounding_auto_diameters: _containers.RepeatedScalarFieldContainer[float]
        bar_diameter_uniformly_surrounding_auto_priority: int
        bar_size_designation_line: float
        bar_size_designation_line_calculated: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationLineCalculated
        bar_diameter_line: float
        bar_diameter_line_calculated: float
        bar_diameter_line_auto_enabled: bool
        bar_size_designation_line_auto_minimum: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationLineAutoMinimum
        bar_diameter_line_auto_minimum: float
        bar_size_designation_line_auto_maximum: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationLineAutoMaximum
        bar_diameter_line_auto_maximum: float
        bar_diameter_line_auto_diameters_enabled: bool
        bar_diameter_line_auto_bar_sizes: _containers.RepeatedScalarFieldContainer[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterLineAutoBarSizes]
        bar_diameter_line_auto_diameters: _containers.RepeatedScalarFieldContainer[float]
        bar_diameter_line_auto_priority: int
        bar_size_designation_single: float
        bar_size_designation_single_calculated: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationSingleCalculated
        bar_diameter_single: float
        bar_diameter_single_calculated: float
        bar_diameter_single_auto_enabled: bool
        bar_size_designation_single_auto_minimum: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationSingleAutoMinimum
        bar_diameter_single_auto_minimum: float
        bar_size_designation_single_auto_maximum: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationSingleAutoMaximum
        bar_diameter_single_auto_maximum: float
        bar_diameter_single_auto_diameters_enabled: bool
        bar_diameter_single_auto_bar_sizes: _containers.RepeatedScalarFieldContainer[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterSingleAutoBarSizes]
        bar_diameter_single_auto_diameters: _containers.RepeatedScalarFieldContainer[float]
        bar_diameter_single_auto_priority: int
        bar_size_designation_corner: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationCorner
        bar_diameter_corner: float
        base_diamter_reduced_multi_edit: float
        corner_reinforcement_enabled: bool
        reinforcement_area_symmetrical: float
        reinforcement_area_unsymmetrical_at_side: float
        reinforcement_area_unsymmetrical_top_side: float
        reinforcement_area_unsymmetrical_bottom_side: float
        reinforcement_area_uniformly_surrounding: float
        reinforcement_area_line: float
        reinforcement_area_single: float
        reinforcement_area_corner: float
        reinforcement_area_total: float
        span_position_reference_type: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.SpanPositionReferenceType
        span_position_reference_internal_node: int
        span_position_reference_x_location_relative: float
        span_position_reference_x_location_absolute: float
        span_position_definition_format: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.SpanPositionDefinitionFormat
        span_start_relative: float
        span_start_absolute: float
        span_start_auto_enabled: bool
        span_start_relative_auto_calculated: float
        span_start_relative_auto_minimum: float
        span_start_relative_auto_maximum: float
        span_start_absolute_auto_calculated: float
        span_start_absolute_auto_minimum: float
        span_start_absolute_auto_maximum: float
        span_end_relative: float
        span_end_absolute: float
        span_end_auto_enabled: bool
        span_end_relative_auto_calculated: float
        span_end_relative_auto_minimum: float
        span_end_relative_auto_maximum: float
        span_end_absolute_auto_calculated: float
        span_end_absolute_auto_minimum: float
        span_end_absolute_auto_maximum: float
        span_location_auto_increment: float
        span_location_auto_priority: int
        span_length: float
        additional_offset_type: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.AdditionalOffsetType
        additional_offset_type_single_line: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.AdditionalOffsetTypeSingleLine
        additional_offset_circle: float
        additional_offset_top_side: float
        additional_offset_bottom_side: float
        additional_offset_left_side: float
        additional_offset_right_side: float
        additional_offset_reference_type: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.AdditionalOffsetReferenceType
        additional_offset_reference_type_at_start: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.AdditionalOffsetReferenceTypeAtStart
        additional_offset_reference_type_at_end: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.AdditionalOffsetReferenceTypeAtEnd
        additional_horizontal_offset: float
        additional_horizontal_offset_at_start: float
        additional_horizontal_offset_at_end: float
        additional_vertical_offset: float
        additional_vertical_offset_at_start: float
        additional_vertical_offset_at_end: float
        anchorage_start_anchor_type: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.AnchorageStartAnchorType
        anchorage_start_anchor_length: float
        anchorage_start_bending_diameter: float
        anchorage_end_anchor_type: MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.AnchorageEndAnchorType
        anchorage_end_anchor_length: float
        anchorage_end_bending_diameter: float
        one_rebar_length: float
        one_rebar_minimal_and_maximal_length: str
        one_rebar_unsymmetrical_at_side_length: float
        one_rebar_unsymmetrical_at_side_minimal_and_maximal_length: str
        one_rebar_unsymmetrical_top_side_length: float
        one_rebar_unsymmetrical_top_side_minimal_and_maximal_length: str
        one_rebar_unsymmetrical_bottom_side_length: float
        one_rebar_unsymmetrical_bottom_side_minimal_and_maximal_length: str
        one_rebar_corner_length: float
        one_rebar_corner_minimal_and_maximal_length: str
        length: float
        one_rebar_weight: float
        one_rebar_minimal_and_maximal_weight: str
        one_rebar_unsymmetrical_at_side_weight: float
        one_rebar_unsymmetrical_at_side_minimal_and_maximal_weight: str
        one_rebar_unsymmetrical_top_side_weight: float
        one_rebar_unsymmetrical_top_side_minimal_and_maximal_weight: str
        one_rebar_unsymmetrical_bottom_side_weight: float
        one_rebar_unsymmetrical_bottom_side_minimal_and_maximal_weight: str
        one_rebar_corner_weight: float
        one_rebar_corner_minimal_and_maximal_weight: str
        weight: float
        def __init__(self, no: _Optional[int] = ..., description: _Optional[str] = ..., name: _Optional[str] = ..., rebar_type: _Optional[_Union[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.RebarType, str]] = ..., material: _Optional[int] = ..., reinforcement_placed_in_bending_corner_enabled: bool = ..., bar_count_symmetrical: _Optional[int] = ..., bar_count_symmetrical_calculated: _Optional[int] = ..., bar_count_symmetrical_auto_enabled: bool = ..., bar_count_symmetrical_auto_minimum: _Optional[int] = ..., bar_count_symmetrical_auto_maximum: _Optional[int] = ..., bar_count_symmetrical_auto_increment: _Optional[int] = ..., bar_count_symmetrical_auto_priority: _Optional[int] = ..., bar_count_unsymmetrical_at_side: _Optional[int] = ..., bar_count_unsymmetrical_top_side: _Optional[int] = ..., bar_count_unsymmetrical_top_side_calculated: _Optional[int] = ..., bar_count_unsymmetrical_top_side_auto_enabled: bool = ..., bar_count_unsymmetrical_top_side_auto_minimum: _Optional[int] = ..., bar_count_unsymmetrical_top_side_auto_maximum: _Optional[int] = ..., bar_count_unsymmetrical_top_side_auto_increment: _Optional[int] = ..., bar_count_unsymmetrical_top_side_auto_priority: _Optional[int] = ..., bar_count_unsymmetrical_bottom_side: _Optional[int] = ..., bar_count_unsymmetrical_bottom_side_calculated: _Optional[int] = ..., bar_count_unsymmetrical_bottom_side_auto_enabled: bool = ..., bar_count_unsymmetrical_bottom_side_auto_minimum: _Optional[int] = ..., bar_count_unsymmetrical_bottom_side_auto_maximum: _Optional[int] = ..., bar_count_unsymmetrical_bottom_side_auto_increment: _Optional[int] = ..., bar_count_unsymmetrical_bottom_side_auto_priority: _Optional[int] = ..., bar_count_uniformly_surrounding: _Optional[int] = ..., bar_count_uniformly_surrounding_calculated: _Optional[int] = ..., bar_count_uniformly_surrounding_auto_enabled: bool = ..., bar_count_uniformly_surrounding_auto_minimum: _Optional[int] = ..., bar_count_uniformly_surrounding_auto_maximum: _Optional[int] = ..., bar_count_uniformly_surrounding_auto_increment: _Optional[int] = ..., bar_count_uniformly_surrounding_auto_priority: _Optional[int] = ..., bar_count_line: _Optional[int] = ..., bar_count_line_calculated: _Optional[int] = ..., bar_count_line_auto_enabled: bool = ..., bar_count_line_auto_minimum: _Optional[int] = ..., bar_count_line_auto_maximum: _Optional[int] = ..., bar_count_line_auto_increment: _Optional[int] = ..., bar_count_line_auto_priority: _Optional[int] = ..., bar_count_corner: _Optional[int] = ..., bar_size_designation_symmetrical: _Optional[float] = ..., bar_size_designation_symmetrical_calculated: _Optional[_Union[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationSymmetricalCalculated, str]] = ..., bar_diameter_symmetrical: _Optional[float] = ..., bar_diameter_symmetrical_calculated: _Optional[float] = ..., bar_diameter_symmetrical_auto_enabled: bool = ..., bar_size_designation_symmetrical_auto_minimum: _Optional[_Union[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationSymmetricalAutoMinimum, str]] = ..., bar_diameter_symmetrical_auto_minimum: _Optional[float] = ..., bar_size_designation_symmetrical_auto_maximum: _Optional[_Union[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationSymmetricalAutoMaximum, str]] = ..., bar_diameter_symmetrical_auto_maximum: _Optional[float] = ..., bar_diameter_symmetrical_auto_diameters_enabled: bool = ..., bar_diameter_symmetrical_auto_bar_sizes: _Optional[_Iterable[_Union[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterSymmetricalAutoBarSizes, str]]] = ..., bar_diameter_symmetrical_auto_diameters: _Optional[_Iterable[float]] = ..., bar_diameter_symmetrical_auto_priority: _Optional[int] = ..., bar_size_designation_unsymmetrical_at_side: _Optional[_Union[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUnsymmetricalAtSide, str]] = ..., bar_diameter_unsymmetrical_at_side: _Optional[float] = ..., bar_size_designation_unsymmetrical_top_side: _Optional[float] = ..., bar_size_designation_unsymmetrical_top_side_calculated: _Optional[_Union[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUnsymmetricalTopSideCalculated, str]] = ..., bar_diameter_unsymmetrical_top_side: _Optional[float] = ..., bar_diameter_unsymmetrical_top_side_calculated: _Optional[float] = ..., bar_diameter_unsymmetrical_top_side_auto_enabled: bool = ..., bar_size_designation_unsymmetrical_top_side_auto_minimum: _Optional[_Union[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUnsymmetricalTopSideAutoMinimum, str]] = ..., bar_diameter_unsymmetrical_top_side_auto_minimum: _Optional[float] = ..., bar_size_designation_unsymmetrical_top_side_auto_maximum: _Optional[_Union[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUnsymmetricalTopSideAutoMaximum, str]] = ..., bar_diameter_unsymmetrical_top_side_auto_maximum: _Optional[float] = ..., bar_diameter_unsymmetrical_top_side_auto_diameters_enabled: bool = ..., bar_diameter_unsymmetrical_top_side_auto_bar_sizes: _Optional[_Iterable[_Union[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterUnsymmetricalTopSideAutoBarSizes, str]]] = ..., bar_diameter_unsymmetrical_top_side_auto_diameters: _Optional[_Iterable[float]] = ..., bar_diameter_unsymmetrical_top_side_auto_priority: _Optional[int] = ..., bar_size_designation_unsymmetrical_bottom_side: _Optional[float] = ..., bar_size_designation_unsymmetrical_bottom_side_calculated: _Optional[_Union[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUnsymmetricalBottomSideCalculated, str]] = ..., bar_diameter_unsymmetrical_bottom_side: _Optional[float] = ..., bar_diameter_unsymmetrical_bottom_side_calculated: _Optional[float] = ..., bar_diameter_unsymmetrical_bottom_side_auto_enabled: bool = ..., bar_size_designation_unsymmetrical_bottom_side_auto_minimum: _Optional[_Union[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUnsymmetricalBottomSideAutoMinimum, str]] = ..., bar_diameter_unsymmetrical_bottom_side_auto_minimum: _Optional[float] = ..., bar_size_designation_unsymmetrical_bottom_side_auto_maximum: _Optional[_Union[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUnsymmetricalBottomSideAutoMaximum, str]] = ..., bar_diameter_unsymmetrical_bottom_side_auto_maximum: _Optional[float] = ..., bar_diameter_unsymmetrical_bottom_side_auto_diameters_enabled: bool = ..., bar_diameter_unsymmetrical_bottom_side_auto_bar_sizes: _Optional[_Iterable[_Union[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterUnsymmetricalBottomSideAutoBarSizes, str]]] = ..., bar_diameter_unsymmetrical_bottom_side_auto_diameters: _Optional[_Iterable[float]] = ..., bar_diameter_unsymmetrical_bottom_side_auto_priority: _Optional[int] = ..., bar_size_designation_uniformly_surrounding: _Optional[float] = ..., bar_size_designation_uniformly_surrounding_calculated: _Optional[_Union[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUniformlySurroundingCalculated, str]] = ..., bar_diameter_uniformly_surrounding: _Optional[float] = ..., bar_diameter_uniformly_surrounding_calculated: _Optional[float] = ..., bar_diameter_uniformly_surrounding_auto_enabled: bool = ..., bar_size_designation_uniformly_surrounding_auto_minimum: _Optional[_Union[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUniformlySurroundingAutoMinimum, str]] = ..., bar_diameter_uniformly_surrounding_auto_minimum: _Optional[float] = ..., bar_size_designation_uniformly_surrounding_auto_maximum: _Optional[_Union[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationUniformlySurroundingAutoMaximum, str]] = ..., bar_diameter_uniformly_surrounding_auto_maximum: _Optional[float] = ..., bar_diameter_uniformly_surrounding_auto_diameters_enabled: bool = ..., bar_diameter_uniformly_surrounding_auto_bar_sizes: _Optional[_Iterable[_Union[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterUniformlySurroundingAutoBarSizes, str]]] = ..., bar_diameter_uniformly_surrounding_auto_diameters: _Optional[_Iterable[float]] = ..., bar_diameter_uniformly_surrounding_auto_priority: _Optional[int] = ..., bar_size_designation_line: _Optional[float] = ..., bar_size_designation_line_calculated: _Optional[_Union[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationLineCalculated, str]] = ..., bar_diameter_line: _Optional[float] = ..., bar_diameter_line_calculated: _Optional[float] = ..., bar_diameter_line_auto_enabled: bool = ..., bar_size_designation_line_auto_minimum: _Optional[_Union[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationLineAutoMinimum, str]] = ..., bar_diameter_line_auto_minimum: _Optional[float] = ..., bar_size_designation_line_auto_maximum: _Optional[_Union[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationLineAutoMaximum, str]] = ..., bar_diameter_line_auto_maximum: _Optional[float] = ..., bar_diameter_line_auto_diameters_enabled: bool = ..., bar_diameter_line_auto_bar_sizes: _Optional[_Iterable[_Union[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterLineAutoBarSizes, str]]] = ..., bar_diameter_line_auto_diameters: _Optional[_Iterable[float]] = ..., bar_diameter_line_auto_priority: _Optional[int] = ..., bar_size_designation_single: _Optional[float] = ..., bar_size_designation_single_calculated: _Optional[_Union[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationSingleCalculated, str]] = ..., bar_diameter_single: _Optional[float] = ..., bar_diameter_single_calculated: _Optional[float] = ..., bar_diameter_single_auto_enabled: bool = ..., bar_size_designation_single_auto_minimum: _Optional[_Union[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationSingleAutoMinimum, str]] = ..., bar_diameter_single_auto_minimum: _Optional[float] = ..., bar_size_designation_single_auto_maximum: _Optional[_Union[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationSingleAutoMaximum, str]] = ..., bar_diameter_single_auto_maximum: _Optional[float] = ..., bar_diameter_single_auto_diameters_enabled: bool = ..., bar_diameter_single_auto_bar_sizes: _Optional[_Iterable[_Union[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarDiameterSingleAutoBarSizes, str]]] = ..., bar_diameter_single_auto_diameters: _Optional[_Iterable[float]] = ..., bar_diameter_single_auto_priority: _Optional[int] = ..., bar_size_designation_corner: _Optional[_Union[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.BarSizeDesignationCorner, str]] = ..., bar_diameter_corner: _Optional[float] = ..., base_diamter_reduced_multi_edit: _Optional[float] = ..., corner_reinforcement_enabled: bool = ..., reinforcement_area_symmetrical: _Optional[float] = ..., reinforcement_area_unsymmetrical_at_side: _Optional[float] = ..., reinforcement_area_unsymmetrical_top_side: _Optional[float] = ..., reinforcement_area_unsymmetrical_bottom_side: _Optional[float] = ..., reinforcement_area_uniformly_surrounding: _Optional[float] = ..., reinforcement_area_line: _Optional[float] = ..., reinforcement_area_single: _Optional[float] = ..., reinforcement_area_corner: _Optional[float] = ..., reinforcement_area_total: _Optional[float] = ..., span_position_reference_type: _Optional[_Union[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.SpanPositionReferenceType, str]] = ..., span_position_reference_internal_node: _Optional[int] = ..., span_position_reference_x_location_relative: _Optional[float] = ..., span_position_reference_x_location_absolute: _Optional[float] = ..., span_position_definition_format: _Optional[_Union[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.SpanPositionDefinitionFormat, str]] = ..., span_start_relative: _Optional[float] = ..., span_start_absolute: _Optional[float] = ..., span_start_auto_enabled: bool = ..., span_start_relative_auto_calculated: _Optional[float] = ..., span_start_relative_auto_minimum: _Optional[float] = ..., span_start_relative_auto_maximum: _Optional[float] = ..., span_start_absolute_auto_calculated: _Optional[float] = ..., span_start_absolute_auto_minimum: _Optional[float] = ..., span_start_absolute_auto_maximum: _Optional[float] = ..., span_end_relative: _Optional[float] = ..., span_end_absolute: _Optional[float] = ..., span_end_auto_enabled: bool = ..., span_end_relative_auto_calculated: _Optional[float] = ..., span_end_relative_auto_minimum: _Optional[float] = ..., span_end_relative_auto_maximum: _Optional[float] = ..., span_end_absolute_auto_calculated: _Optional[float] = ..., span_end_absolute_auto_minimum: _Optional[float] = ..., span_end_absolute_auto_maximum: _Optional[float] = ..., span_location_auto_increment: _Optional[float] = ..., span_location_auto_priority: _Optional[int] = ..., span_length: _Optional[float] = ..., additional_offset_type: _Optional[_Union[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.AdditionalOffsetType, str]] = ..., additional_offset_type_single_line: _Optional[_Union[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.AdditionalOffsetTypeSingleLine, str]] = ..., additional_offset_circle: _Optional[float] = ..., additional_offset_top_side: _Optional[float] = ..., additional_offset_bottom_side: _Optional[float] = ..., additional_offset_left_side: _Optional[float] = ..., additional_offset_right_side: _Optional[float] = ..., additional_offset_reference_type: _Optional[_Union[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.AdditionalOffsetReferenceType, str]] = ..., additional_offset_reference_type_at_start: _Optional[_Union[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.AdditionalOffsetReferenceTypeAtStart, str]] = ..., additional_offset_reference_type_at_end: _Optional[_Union[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.AdditionalOffsetReferenceTypeAtEnd, str]] = ..., additional_horizontal_offset: _Optional[float] = ..., additional_horizontal_offset_at_start: _Optional[float] = ..., additional_horizontal_offset_at_end: _Optional[float] = ..., additional_vertical_offset: _Optional[float] = ..., additional_vertical_offset_at_start: _Optional[float] = ..., additional_vertical_offset_at_end: _Optional[float] = ..., anchorage_start_anchor_type: _Optional[_Union[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.AnchorageStartAnchorType, str]] = ..., anchorage_start_anchor_length: _Optional[float] = ..., anchorage_start_bending_diameter: _Optional[float] = ..., anchorage_end_anchor_type: _Optional[_Union[MemberRepresentative.ConcreteLongitudinalReinforcementSpanRow.AnchorageEndAnchorType, str]] = ..., anchorage_end_anchor_length: _Optional[float] = ..., anchorage_end_bending_diameter: _Optional[float] = ..., one_rebar_length: _Optional[float] = ..., one_rebar_minimal_and_maximal_length: _Optional[str] = ..., one_rebar_unsymmetrical_at_side_length: _Optional[float] = ..., one_rebar_unsymmetrical_at_side_minimal_and_maximal_length: _Optional[str] = ..., one_rebar_unsymmetrical_top_side_length: _Optional[float] = ..., one_rebar_unsymmetrical_top_side_minimal_and_maximal_length: _Optional[str] = ..., one_rebar_unsymmetrical_bottom_side_length: _Optional[float] = ..., one_rebar_unsymmetrical_bottom_side_minimal_and_maximal_length: _Optional[str] = ..., one_rebar_corner_length: _Optional[float] = ..., one_rebar_corner_minimal_and_maximal_length: _Optional[str] = ..., length: _Optional[float] = ..., one_rebar_weight: _Optional[float] = ..., one_rebar_minimal_and_maximal_weight: _Optional[str] = ..., one_rebar_unsymmetrical_at_side_weight: _Optional[float] = ..., one_rebar_unsymmetrical_at_side_minimal_and_maximal_weight: _Optional[str] = ..., one_rebar_unsymmetrical_top_side_weight: _Optional[float] = ..., one_rebar_unsymmetrical_top_side_minimal_and_maximal_weight: _Optional[str] = ..., one_rebar_unsymmetrical_bottom_side_weight: _Optional[float] = ..., one_rebar_unsymmetrical_bottom_side_minimal_and_maximal_weight: _Optional[str] = ..., one_rebar_corner_weight: _Optional[float] = ..., one_rebar_corner_minimal_and_maximal_weight: _Optional[str] = ..., weight: _Optional[float] = ...) -> None: ...
    class ConcreteShearReinforcementSpanTable(_message.Message):
        __slots__ = ("rows",)
        ROWS_FIELD_NUMBER: _ClassVar[int]
        rows: _containers.RepeatedCompositeFieldContainer[MemberRepresentative.ConcreteShearReinforcementSpanRow]
        def __init__(self, rows: _Optional[_Iterable[_Union[MemberRepresentative.ConcreteShearReinforcementSpanRow, _Mapping]]] = ...) -> None: ...
    class ConcreteShearReinforcementSpanRow(_message.Message):
        __slots__ = ("no", "description", "name", "stirrup_type", "material", "stirrup_count", "stirrup_bar_size", "stirrup_bar_size_calculated", "stirrup_diameter", "stirrup_diameter_calculated", "stirrup_diameter_auto_enabled", "stirrup_bar_size_auto_minimum", "stirrup_diameter_auto_minimum", "stirrup_bar_size_auto_maximum", "stirrup_diameter_auto_maximum", "stirrup_diameter_auto_diameters_enabled", "stirrup_diameter_auto_bar_sizes", "stirrup_diameter_auto_diameters", "stirrup_diameter_auto_priority", "stirrup_distances", "stirrup_distances_calculated", "stirrup_distances_auto_enabled", "stirrup_distances_auto_minimum", "stirrup_distances_auto_maximum", "stirrup_distances_auto_increment", "stirrup_distances_auto_priority", "crossties_active", "crossties_diameter", "reinforcement_area", "horizontal_crosstie_reinforcement_area", "minimal_maximal_horizontal_crosstie_reinforcement_area", "vertical_crosstie_reinforcement_area", "minimal_maximal_vertical_crosstie_reinforcement_area", "total_horizontal_reinforcement_area", "minimal_maximal_total_horizontal_reinforcement_area", "total_vertical_reinforcement_area", "minimal_maximal_total_vertical_reinforcement_area", "span_position_reference_type", "span_position_reference_internal_node", "span_position_reference_x_location_relative", "span_position_reference_x_location_absolute", "span_position_definition_format", "span_start_relative", "span_start_absolute", "span_start_auto_enabled", "span_start_relative_auto_calculated", "span_start_relative_auto_minimum", "span_start_relative_auto_maximum", "span_start_absolute_auto_calculated", "span_start_absolute_auto_minimum", "span_start_absolute_auto_maximum", "span_end_relative", "span_end_absolute", "span_end_auto_enabled", "span_end_relative_auto_calculated", "span_end_relative_auto_minimum", "span_end_relative_auto_maximum", "span_end_absolute_auto_calculated", "span_end_absolute_auto_minimum", "span_end_absolute_auto_maximum", "span_location_auto_increment", "span_location_auto_priority", "span_length", "stirrup_layout_rule", "stirrup_start_offset", "stirrup_end_offset", "one_stirrup_length", "minimal_and_maximal_stirrup_length", "all_stirrups_length", "one_stirrup_weight", "minimal_and_maximal_stirrup_weight", "all_stirrups_weight", "one_crosstie_length", "minimal_and_maximal_crosstie_length", "all_crossties_lenght", "one_crosstie_weight", "minimal_and_maximal_crosstie_weight", "all_crossties_weight")
        class StirrupType(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            STIRRUP_TYPE_TWO_LEGGED_CLOSED_HOOK_135: _ClassVar[MemberRepresentative.ConcreteShearReinforcementSpanRow.StirrupType]
            STIRRUP_TYPE_FOUR_LEGGED_CLOSED_HOOK_135: _ClassVar[MemberRepresentative.ConcreteShearReinforcementSpanRow.StirrupType]
            STIRRUP_TYPE_FOUR_LEGGED_CLOSED_HOOK_90: _ClassVar[MemberRepresentative.ConcreteShearReinforcementSpanRow.StirrupType]
            STIRRUP_TYPE_FOUR_LEGGED_OVERLAP_HOOK_180: _ClassVar[MemberRepresentative.ConcreteShearReinforcementSpanRow.StirrupType]
            STIRRUP_TYPE_THREE_LEGGED_CLOSED_HOOK_135: _ClassVar[MemberRepresentative.ConcreteShearReinforcementSpanRow.StirrupType]
            STIRRUP_TYPE_THREE_LEGGED_CLOSED_HOOK_90: _ClassVar[MemberRepresentative.ConcreteShearReinforcementSpanRow.StirrupType]
            STIRRUP_TYPE_THREE_LEGGED_OVERLAP_HOOK_180: _ClassVar[MemberRepresentative.ConcreteShearReinforcementSpanRow.StirrupType]
            STIRRUP_TYPE_TWO_LEGGED_CLOSED_HOOK_90: _ClassVar[MemberRepresentative.ConcreteShearReinforcementSpanRow.StirrupType]
            STIRRUP_TYPE_TWO_LEGGED_OPEN: _ClassVar[MemberRepresentative.ConcreteShearReinforcementSpanRow.StirrupType]
            STIRRUP_TYPE_TWO_LEGGED_OVERLAP_HOOK_180: _ClassVar[MemberRepresentative.ConcreteShearReinforcementSpanRow.StirrupType]
        STIRRUP_TYPE_TWO_LEGGED_CLOSED_HOOK_135: MemberRepresentative.ConcreteShearReinforcementSpanRow.StirrupType
        STIRRUP_TYPE_FOUR_LEGGED_CLOSED_HOOK_135: MemberRepresentative.ConcreteShearReinforcementSpanRow.StirrupType
        STIRRUP_TYPE_FOUR_LEGGED_CLOSED_HOOK_90: MemberRepresentative.ConcreteShearReinforcementSpanRow.StirrupType
        STIRRUP_TYPE_FOUR_LEGGED_OVERLAP_HOOK_180: MemberRepresentative.ConcreteShearReinforcementSpanRow.StirrupType
        STIRRUP_TYPE_THREE_LEGGED_CLOSED_HOOK_135: MemberRepresentative.ConcreteShearReinforcementSpanRow.StirrupType
        STIRRUP_TYPE_THREE_LEGGED_CLOSED_HOOK_90: MemberRepresentative.ConcreteShearReinforcementSpanRow.StirrupType
        STIRRUP_TYPE_THREE_LEGGED_OVERLAP_HOOK_180: MemberRepresentative.ConcreteShearReinforcementSpanRow.StirrupType
        STIRRUP_TYPE_TWO_LEGGED_CLOSED_HOOK_90: MemberRepresentative.ConcreteShearReinforcementSpanRow.StirrupType
        STIRRUP_TYPE_TWO_LEGGED_OPEN: MemberRepresentative.ConcreteShearReinforcementSpanRow.StirrupType
        STIRRUP_TYPE_TWO_LEGGED_OVERLAP_HOOK_180: MemberRepresentative.ConcreteShearReinforcementSpanRow.StirrupType
        class StirrupBarSizeCalculated(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            STIRRUP_BAR_SIZE_CALCULATED_UNKNOWN: _ClassVar[MemberRepresentative.ConcreteShearReinforcementSpanRow.StirrupBarSizeCalculated]
            STIRRUP_BAR_SIZE_CALCULATED_ACI_1: _ClassVar[MemberRepresentative.ConcreteShearReinforcementSpanRow.StirrupBarSizeCalculated]
            STIRRUP_BAR_SIZE_CALCULATED_ACI_10: _ClassVar[MemberRepresentative.ConcreteShearReinforcementSpanRow.StirrupBarSizeCalculated]
            STIRRUP_BAR_SIZE_CALCULATED_ACI_11: _ClassVar[MemberRepresentative.ConcreteShearReinforcementSpanRow.StirrupBarSizeCalculated]
            STIRRUP_BAR_SIZE_CALCULATED_ACI_12: _ClassVar[MemberRepresentative.ConcreteShearReinforcementSpanRow.StirrupBarSizeCalculated]
            STIRRUP_BAR_SIZE_CALCULATED_ACI_14: _ClassVar[MemberRepresentative.ConcreteShearReinforcementSpanRow.StirrupBarSizeCalculated]
            STIRRUP_BAR_SIZE_CALCULATED_ACI_16: _ClassVar[MemberRepresentative.ConcreteShearReinforcementSpanRow.StirrupBarSizeCalculated]
            STIRRUP_BAR_SIZE_CALCULATED_ACI_18: _ClassVar[MemberRepresentative.ConcreteShearReinforcementSpanRow.StirrupBarSizeCalculated]
            STIRRUP_BAR_SIZE_CALCULATED_ACI_1p5: _ClassVar[MemberRepresentative.ConcreteShearReinforcementSpanRow.StirrupBarSizeCalculated]
            STIRRUP_BAR_SIZE_CALCULATED_ACI_2: _ClassVar[MemberRepresentative.ConcreteShearReinforcementSpanRow.StirrupBarSizeCalculated]
            STIRRUP_BAR_SIZE_CALCULATED_ACI_2p5: _ClassVar[MemberRepresentative.ConcreteShearReinforcementSpanRow.StirrupBarSizeCalculated]
            STIRRUP_BAR_SIZE_CALCULATED_ACI_3: _ClassVar[MemberRepresentative.ConcreteShearReinforcementSpanRow.StirrupBarSizeCalculated]
            STIRRUP_BAR_SIZE_CALCULATED_ACI_4: _ClassVar[MemberRepresentative.ConcreteShearReinforcementSpanRow.StirrupBarSizeCalculated]
            STIRRUP_BAR_SIZE_CALCULATED_ACI_5: _ClassVar[MemberRepresentative.ConcreteShearReinforcementSpanRow.StirrupBarSizeCalculated]
            STIRRUP_BAR_SIZE_CALCULATED_ACI_6: _ClassVar[MemberRepresentative.ConcreteShearReinforcementSpanRow.StirrupBarSizeCalculated]
            STIRRUP_BAR_SIZE_CALCULATED_ACI_7: _ClassVar[MemberRepresentative.ConcreteShearReinforcementSpanRow.StirrupBarSizeCalculated]
            STIRRUP_BAR_SIZE_CALCULATED_ACI_8: _ClassVar[MemberRepresentative.ConcreteShearReinforcementSpanRow.StirrupBarSizeCalculated]
            STIRRUP_BAR_SIZE_CALCULATED_ACI_9: _ClassVar[MemberRepresentative.ConcreteShearReinforcementSpanRow.StirrupBarSizeCalculated]
            STIRRUP_BAR_SIZE_CALCULATED_CSA_10: _ClassVar[MemberRepresentative.ConcreteShearReinforcementSpanRow.StirrupBarSizeCalculated]
            STIRRUP_BAR_SIZE_CALCULATED_CSA_15: _ClassVar[MemberRepresentative.ConcreteShearReinforcementSpanRow.StirrupBarSizeCalculated]
            STIRRUP_BAR_SIZE_CALCULATED_CSA_20: _ClassVar[MemberRepresentative.ConcreteShearReinforcementSpanRow.StirrupBarSizeCalculated]
            STIRRUP_BAR_SIZE_CALCULATED_CSA_25: _ClassVar[MemberRepresentative.ConcreteShearReinforcementSpanRow.StirrupBarSizeCalculated]
            STIRRUP_BAR_SIZE_CALCULATED_CSA_30: _ClassVar[MemberRepresentative.ConcreteShearReinforcementSpanRow.StirrupBarSizeCalculated]
            STIRRUP_BAR_SIZE_CALCULATED_CSA_35: _ClassVar[MemberRepresentative.ConcreteShearReinforcementSpanRow.StirrupBarSizeCalculated]
            STIRRUP_BAR_SIZE_CALCULATED_CSA_45: _ClassVar[MemberRepresentative.ConcreteShearReinforcementSpanRow.StirrupBarSizeCalculated]
            STIRRUP_BAR_SIZE_CALCULATED_CSA_55: _ClassVar[MemberRepresentative.ConcreteShearReinforcementSpanRow.StirrupBarSizeCalculated]
        STIRRUP_BAR_SIZE_CALCULATED_UNKNOWN: MemberRepresentative.ConcreteShearReinforcementSpanRow.StirrupBarSizeCalculated
        STIRRUP_BAR_SIZE_CALCULATED_ACI_1: MemberRepresentative.ConcreteShearReinforcementSpanRow.StirrupBarSizeCalculated
        STIRRUP_BAR_SIZE_CALCULATED_ACI_10: MemberRepresentative.ConcreteShearReinforcementSpanRow.StirrupBarSizeCalculated
        STIRRUP_BAR_SIZE_CALCULATED_ACI_11: MemberRepresentative.ConcreteShearReinforcementSpanRow.StirrupBarSizeCalculated
        STIRRUP_BAR_SIZE_CALCULATED_ACI_12: MemberRepresentative.ConcreteShearReinforcementSpanRow.StirrupBarSizeCalculated
        STIRRUP_BAR_SIZE_CALCULATED_ACI_14: MemberRepresentative.ConcreteShearReinforcementSpanRow.StirrupBarSizeCalculated
        STIRRUP_BAR_SIZE_CALCULATED_ACI_16: MemberRepresentative.ConcreteShearReinforcementSpanRow.StirrupBarSizeCalculated
        STIRRUP_BAR_SIZE_CALCULATED_ACI_18: MemberRepresentative.ConcreteShearReinforcementSpanRow.StirrupBarSizeCalculated
        STIRRUP_BAR_SIZE_CALCULATED_ACI_1p5: MemberRepresentative.ConcreteShearReinforcementSpanRow.StirrupBarSizeCalculated
        STIRRUP_BAR_SIZE_CALCULATED_ACI_2: MemberRepresentative.ConcreteShearReinforcementSpanRow.StirrupBarSizeCalculated
        STIRRUP_BAR_SIZE_CALCULATED_ACI_2p5: MemberRepresentative.ConcreteShearReinforcementSpanRow.StirrupBarSizeCalculated
        STIRRUP_BAR_SIZE_CALCULATED_ACI_3: MemberRepresentative.ConcreteShearReinforcementSpanRow.StirrupBarSizeCalculated
        STIRRUP_BAR_SIZE_CALCULATED_ACI_4: MemberRepresentative.ConcreteShearReinforcementSpanRow.StirrupBarSizeCalculated
        STIRRUP_BAR_SIZE_CALCULATED_ACI_5: MemberRepresentative.ConcreteShearReinforcementSpanRow.StirrupBarSizeCalculated
        STIRRUP_BAR_SIZE_CALCULATED_ACI_6: MemberRepresentative.ConcreteShearReinforcementSpanRow.StirrupBarSizeCalculated
        STIRRUP_BAR_SIZE_CALCULATED_ACI_7: MemberRepresentative.ConcreteShearReinforcementSpanRow.StirrupBarSizeCalculated
        STIRRUP_BAR_SIZE_CALCULATED_ACI_8: MemberRepresentative.ConcreteShearReinforcementSpanRow.StirrupBarSizeCalculated
        STIRRUP_BAR_SIZE_CALCULATED_ACI_9: MemberRepresentative.ConcreteShearReinforcementSpanRow.StirrupBarSizeCalculated
        STIRRUP_BAR_SIZE_CALCULATED_CSA_10: MemberRepresentative.ConcreteShearReinforcementSpanRow.StirrupBarSizeCalculated
        STIRRUP_BAR_SIZE_CALCULATED_CSA_15: MemberRepresentative.ConcreteShearReinforcementSpanRow.StirrupBarSizeCalculated
        STIRRUP_BAR_SIZE_CALCULATED_CSA_20: MemberRepresentative.ConcreteShearReinforcementSpanRow.StirrupBarSizeCalculated
        STIRRUP_BAR_SIZE_CALCULATED_CSA_25: MemberRepresentative.ConcreteShearReinforcementSpanRow.StirrupBarSizeCalculated
        STIRRUP_BAR_SIZE_CALCULATED_CSA_30: MemberRepresentative.ConcreteShearReinforcementSpanRow.StirrupBarSizeCalculated
        STIRRUP_BAR_SIZE_CALCULATED_CSA_35: MemberRepresentative.ConcreteShearReinforcementSpanRow.StirrupBarSizeCalculated
        STIRRUP_BAR_SIZE_CALCULATED_CSA_45: MemberRepresentative.ConcreteShearReinforcementSpanRow.StirrupBarSizeCalculated
        STIRRUP_BAR_SIZE_CALCULATED_CSA_55: MemberRepresentative.ConcreteShearReinforcementSpanRow.StirrupBarSizeCalculated
        class StirrupBarSizeAutoMinimum(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            STIRRUP_BAR_SIZE_AUTO_MINIMUM_UNKNOWN: _ClassVar[MemberRepresentative.ConcreteShearReinforcementSpanRow.StirrupBarSizeAutoMinimum]
        STIRRUP_BAR_SIZE_AUTO_MINIMUM_UNKNOWN: MemberRepresentative.ConcreteShearReinforcementSpanRow.StirrupBarSizeAutoMinimum
        class StirrupBarSizeAutoMaximum(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            STIRRUP_BAR_SIZE_AUTO_MAXIMUM_UNKNOWN: _ClassVar[MemberRepresentative.ConcreteShearReinforcementSpanRow.StirrupBarSizeAutoMaximum]
        STIRRUP_BAR_SIZE_AUTO_MAXIMUM_UNKNOWN: MemberRepresentative.ConcreteShearReinforcementSpanRow.StirrupBarSizeAutoMaximum
        class StirrupDiameterAutoBarSizes(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            STIRRUP_DIAMETER_AUTO_BAR_SIZES_UNKNOWN: _ClassVar[MemberRepresentative.ConcreteShearReinforcementSpanRow.StirrupDiameterAutoBarSizes]
            STIRRUP_DIAMETER_AUTO_BAR_SIZES_ACI_1: _ClassVar[MemberRepresentative.ConcreteShearReinforcementSpanRow.StirrupDiameterAutoBarSizes]
            STIRRUP_DIAMETER_AUTO_BAR_SIZES_ACI_10: _ClassVar[MemberRepresentative.ConcreteShearReinforcementSpanRow.StirrupDiameterAutoBarSizes]
            STIRRUP_DIAMETER_AUTO_BAR_SIZES_ACI_11: _ClassVar[MemberRepresentative.ConcreteShearReinforcementSpanRow.StirrupDiameterAutoBarSizes]
            STIRRUP_DIAMETER_AUTO_BAR_SIZES_ACI_12: _ClassVar[MemberRepresentative.ConcreteShearReinforcementSpanRow.StirrupDiameterAutoBarSizes]
            STIRRUP_DIAMETER_AUTO_BAR_SIZES_ACI_14: _ClassVar[MemberRepresentative.ConcreteShearReinforcementSpanRow.StirrupDiameterAutoBarSizes]
            STIRRUP_DIAMETER_AUTO_BAR_SIZES_ACI_16: _ClassVar[MemberRepresentative.ConcreteShearReinforcementSpanRow.StirrupDiameterAutoBarSizes]
            STIRRUP_DIAMETER_AUTO_BAR_SIZES_ACI_18: _ClassVar[MemberRepresentative.ConcreteShearReinforcementSpanRow.StirrupDiameterAutoBarSizes]
            STIRRUP_DIAMETER_AUTO_BAR_SIZES_ACI_1p5: _ClassVar[MemberRepresentative.ConcreteShearReinforcementSpanRow.StirrupDiameterAutoBarSizes]
            STIRRUP_DIAMETER_AUTO_BAR_SIZES_ACI_2: _ClassVar[MemberRepresentative.ConcreteShearReinforcementSpanRow.StirrupDiameterAutoBarSizes]
            STIRRUP_DIAMETER_AUTO_BAR_SIZES_ACI_2p5: _ClassVar[MemberRepresentative.ConcreteShearReinforcementSpanRow.StirrupDiameterAutoBarSizes]
            STIRRUP_DIAMETER_AUTO_BAR_SIZES_ACI_3: _ClassVar[MemberRepresentative.ConcreteShearReinforcementSpanRow.StirrupDiameterAutoBarSizes]
            STIRRUP_DIAMETER_AUTO_BAR_SIZES_ACI_4: _ClassVar[MemberRepresentative.ConcreteShearReinforcementSpanRow.StirrupDiameterAutoBarSizes]
            STIRRUP_DIAMETER_AUTO_BAR_SIZES_ACI_5: _ClassVar[MemberRepresentative.ConcreteShearReinforcementSpanRow.StirrupDiameterAutoBarSizes]
            STIRRUP_DIAMETER_AUTO_BAR_SIZES_ACI_6: _ClassVar[MemberRepresentative.ConcreteShearReinforcementSpanRow.StirrupDiameterAutoBarSizes]
            STIRRUP_DIAMETER_AUTO_BAR_SIZES_ACI_7: _ClassVar[MemberRepresentative.ConcreteShearReinforcementSpanRow.StirrupDiameterAutoBarSizes]
            STIRRUP_DIAMETER_AUTO_BAR_SIZES_ACI_8: _ClassVar[MemberRepresentative.ConcreteShearReinforcementSpanRow.StirrupDiameterAutoBarSizes]
            STIRRUP_DIAMETER_AUTO_BAR_SIZES_ACI_9: _ClassVar[MemberRepresentative.ConcreteShearReinforcementSpanRow.StirrupDiameterAutoBarSizes]
            STIRRUP_DIAMETER_AUTO_BAR_SIZES_CSA_10: _ClassVar[MemberRepresentative.ConcreteShearReinforcementSpanRow.StirrupDiameterAutoBarSizes]
            STIRRUP_DIAMETER_AUTO_BAR_SIZES_CSA_15: _ClassVar[MemberRepresentative.ConcreteShearReinforcementSpanRow.StirrupDiameterAutoBarSizes]
            STIRRUP_DIAMETER_AUTO_BAR_SIZES_CSA_20: _ClassVar[MemberRepresentative.ConcreteShearReinforcementSpanRow.StirrupDiameterAutoBarSizes]
            STIRRUP_DIAMETER_AUTO_BAR_SIZES_CSA_25: _ClassVar[MemberRepresentative.ConcreteShearReinforcementSpanRow.StirrupDiameterAutoBarSizes]
            STIRRUP_DIAMETER_AUTO_BAR_SIZES_CSA_30: _ClassVar[MemberRepresentative.ConcreteShearReinforcementSpanRow.StirrupDiameterAutoBarSizes]
            STIRRUP_DIAMETER_AUTO_BAR_SIZES_CSA_35: _ClassVar[MemberRepresentative.ConcreteShearReinforcementSpanRow.StirrupDiameterAutoBarSizes]
            STIRRUP_DIAMETER_AUTO_BAR_SIZES_CSA_45: _ClassVar[MemberRepresentative.ConcreteShearReinforcementSpanRow.StirrupDiameterAutoBarSizes]
            STIRRUP_DIAMETER_AUTO_BAR_SIZES_CSA_55: _ClassVar[MemberRepresentative.ConcreteShearReinforcementSpanRow.StirrupDiameterAutoBarSizes]
        STIRRUP_DIAMETER_AUTO_BAR_SIZES_UNKNOWN: MemberRepresentative.ConcreteShearReinforcementSpanRow.StirrupDiameterAutoBarSizes
        STIRRUP_DIAMETER_AUTO_BAR_SIZES_ACI_1: MemberRepresentative.ConcreteShearReinforcementSpanRow.StirrupDiameterAutoBarSizes
        STIRRUP_DIAMETER_AUTO_BAR_SIZES_ACI_10: MemberRepresentative.ConcreteShearReinforcementSpanRow.StirrupDiameterAutoBarSizes
        STIRRUP_DIAMETER_AUTO_BAR_SIZES_ACI_11: MemberRepresentative.ConcreteShearReinforcementSpanRow.StirrupDiameterAutoBarSizes
        STIRRUP_DIAMETER_AUTO_BAR_SIZES_ACI_12: MemberRepresentative.ConcreteShearReinforcementSpanRow.StirrupDiameterAutoBarSizes
        STIRRUP_DIAMETER_AUTO_BAR_SIZES_ACI_14: MemberRepresentative.ConcreteShearReinforcementSpanRow.StirrupDiameterAutoBarSizes
        STIRRUP_DIAMETER_AUTO_BAR_SIZES_ACI_16: MemberRepresentative.ConcreteShearReinforcementSpanRow.StirrupDiameterAutoBarSizes
        STIRRUP_DIAMETER_AUTO_BAR_SIZES_ACI_18: MemberRepresentative.ConcreteShearReinforcementSpanRow.StirrupDiameterAutoBarSizes
        STIRRUP_DIAMETER_AUTO_BAR_SIZES_ACI_1p5: MemberRepresentative.ConcreteShearReinforcementSpanRow.StirrupDiameterAutoBarSizes
        STIRRUP_DIAMETER_AUTO_BAR_SIZES_ACI_2: MemberRepresentative.ConcreteShearReinforcementSpanRow.StirrupDiameterAutoBarSizes
        STIRRUP_DIAMETER_AUTO_BAR_SIZES_ACI_2p5: MemberRepresentative.ConcreteShearReinforcementSpanRow.StirrupDiameterAutoBarSizes
        STIRRUP_DIAMETER_AUTO_BAR_SIZES_ACI_3: MemberRepresentative.ConcreteShearReinforcementSpanRow.StirrupDiameterAutoBarSizes
        STIRRUP_DIAMETER_AUTO_BAR_SIZES_ACI_4: MemberRepresentative.ConcreteShearReinforcementSpanRow.StirrupDiameterAutoBarSizes
        STIRRUP_DIAMETER_AUTO_BAR_SIZES_ACI_5: MemberRepresentative.ConcreteShearReinforcementSpanRow.StirrupDiameterAutoBarSizes
        STIRRUP_DIAMETER_AUTO_BAR_SIZES_ACI_6: MemberRepresentative.ConcreteShearReinforcementSpanRow.StirrupDiameterAutoBarSizes
        STIRRUP_DIAMETER_AUTO_BAR_SIZES_ACI_7: MemberRepresentative.ConcreteShearReinforcementSpanRow.StirrupDiameterAutoBarSizes
        STIRRUP_DIAMETER_AUTO_BAR_SIZES_ACI_8: MemberRepresentative.ConcreteShearReinforcementSpanRow.StirrupDiameterAutoBarSizes
        STIRRUP_DIAMETER_AUTO_BAR_SIZES_ACI_9: MemberRepresentative.ConcreteShearReinforcementSpanRow.StirrupDiameterAutoBarSizes
        STIRRUP_DIAMETER_AUTO_BAR_SIZES_CSA_10: MemberRepresentative.ConcreteShearReinforcementSpanRow.StirrupDiameterAutoBarSizes
        STIRRUP_DIAMETER_AUTO_BAR_SIZES_CSA_15: MemberRepresentative.ConcreteShearReinforcementSpanRow.StirrupDiameterAutoBarSizes
        STIRRUP_DIAMETER_AUTO_BAR_SIZES_CSA_20: MemberRepresentative.ConcreteShearReinforcementSpanRow.StirrupDiameterAutoBarSizes
        STIRRUP_DIAMETER_AUTO_BAR_SIZES_CSA_25: MemberRepresentative.ConcreteShearReinforcementSpanRow.StirrupDiameterAutoBarSizes
        STIRRUP_DIAMETER_AUTO_BAR_SIZES_CSA_30: MemberRepresentative.ConcreteShearReinforcementSpanRow.StirrupDiameterAutoBarSizes
        STIRRUP_DIAMETER_AUTO_BAR_SIZES_CSA_35: MemberRepresentative.ConcreteShearReinforcementSpanRow.StirrupDiameterAutoBarSizes
        STIRRUP_DIAMETER_AUTO_BAR_SIZES_CSA_45: MemberRepresentative.ConcreteShearReinforcementSpanRow.StirrupDiameterAutoBarSizes
        STIRRUP_DIAMETER_AUTO_BAR_SIZES_CSA_55: MemberRepresentative.ConcreteShearReinforcementSpanRow.StirrupDiameterAutoBarSizes
        class SpanPositionReferenceType(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            SPAN_POSITION_REFERENCE_TYPE_START: _ClassVar[MemberRepresentative.ConcreteShearReinforcementSpanRow.SpanPositionReferenceType]
            SPAN_POSITION_REFERENCE_TYPE_END: _ClassVar[MemberRepresentative.ConcreteShearReinforcementSpanRow.SpanPositionReferenceType]
            SPAN_POSITION_REFERENCE_TYPE_INTERNAL_NODE: _ClassVar[MemberRepresentative.ConcreteShearReinforcementSpanRow.SpanPositionReferenceType]
            SPAN_POSITION_REFERENCE_TYPE_X_LOCATION: _ClassVar[MemberRepresentative.ConcreteShearReinforcementSpanRow.SpanPositionReferenceType]
        SPAN_POSITION_REFERENCE_TYPE_START: MemberRepresentative.ConcreteShearReinforcementSpanRow.SpanPositionReferenceType
        SPAN_POSITION_REFERENCE_TYPE_END: MemberRepresentative.ConcreteShearReinforcementSpanRow.SpanPositionReferenceType
        SPAN_POSITION_REFERENCE_TYPE_INTERNAL_NODE: MemberRepresentative.ConcreteShearReinforcementSpanRow.SpanPositionReferenceType
        SPAN_POSITION_REFERENCE_TYPE_X_LOCATION: MemberRepresentative.ConcreteShearReinforcementSpanRow.SpanPositionReferenceType
        class SpanPositionDefinitionFormat(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            SPAN_POSITION_DEFINITION_FORMAT_ABSOLUTE: _ClassVar[MemberRepresentative.ConcreteShearReinforcementSpanRow.SpanPositionDefinitionFormat]
            SPAN_POSITION_DEFINITION_FORMAT_RELATIVE: _ClassVar[MemberRepresentative.ConcreteShearReinforcementSpanRow.SpanPositionDefinitionFormat]
        SPAN_POSITION_DEFINITION_FORMAT_ABSOLUTE: MemberRepresentative.ConcreteShearReinforcementSpanRow.SpanPositionDefinitionFormat
        SPAN_POSITION_DEFINITION_FORMAT_RELATIVE: MemberRepresentative.ConcreteShearReinforcementSpanRow.SpanPositionDefinitionFormat
        class StirrupLayoutRule(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            STIRRUP_LAYOUT_RULE_START_EQUALS_END: _ClassVar[MemberRepresentative.ConcreteShearReinforcementSpanRow.StirrupLayoutRule]
            STIRRUP_LAYOUT_RULE_END_DEFINED: _ClassVar[MemberRepresentative.ConcreteShearReinforcementSpanRow.StirrupLayoutRule]
            STIRRUP_LAYOUT_RULE_END_EQUALS_REST_LENGTH_TO_STIRRUP_DISTANCED: _ClassVar[MemberRepresentative.ConcreteShearReinforcementSpanRow.StirrupLayoutRule]
            STIRRUP_LAYOUT_RULE_START_DEFINED: _ClassVar[MemberRepresentative.ConcreteShearReinforcementSpanRow.StirrupLayoutRule]
            STIRRUP_LAYOUT_RULE_START_EQUALS_REST_LENGTH_TO_STIRRUP_DISTANCED: _ClassVar[MemberRepresentative.ConcreteShearReinforcementSpanRow.StirrupLayoutRule]
        STIRRUP_LAYOUT_RULE_START_EQUALS_END: MemberRepresentative.ConcreteShearReinforcementSpanRow.StirrupLayoutRule
        STIRRUP_LAYOUT_RULE_END_DEFINED: MemberRepresentative.ConcreteShearReinforcementSpanRow.StirrupLayoutRule
        STIRRUP_LAYOUT_RULE_END_EQUALS_REST_LENGTH_TO_STIRRUP_DISTANCED: MemberRepresentative.ConcreteShearReinforcementSpanRow.StirrupLayoutRule
        STIRRUP_LAYOUT_RULE_START_DEFINED: MemberRepresentative.ConcreteShearReinforcementSpanRow.StirrupLayoutRule
        STIRRUP_LAYOUT_RULE_START_EQUALS_REST_LENGTH_TO_STIRRUP_DISTANCED: MemberRepresentative.ConcreteShearReinforcementSpanRow.StirrupLayoutRule
        NO_FIELD_NUMBER: _ClassVar[int]
        DESCRIPTION_FIELD_NUMBER: _ClassVar[int]
        NAME_FIELD_NUMBER: _ClassVar[int]
        STIRRUP_TYPE_FIELD_NUMBER: _ClassVar[int]
        MATERIAL_FIELD_NUMBER: _ClassVar[int]
        STIRRUP_COUNT_FIELD_NUMBER: _ClassVar[int]
        STIRRUP_BAR_SIZE_FIELD_NUMBER: _ClassVar[int]
        STIRRUP_BAR_SIZE_CALCULATED_FIELD_NUMBER: _ClassVar[int]
        STIRRUP_DIAMETER_FIELD_NUMBER: _ClassVar[int]
        STIRRUP_DIAMETER_CALCULATED_FIELD_NUMBER: _ClassVar[int]
        STIRRUP_DIAMETER_AUTO_ENABLED_FIELD_NUMBER: _ClassVar[int]
        STIRRUP_BAR_SIZE_AUTO_MINIMUM_FIELD_NUMBER: _ClassVar[int]
        STIRRUP_DIAMETER_AUTO_MINIMUM_FIELD_NUMBER: _ClassVar[int]
        STIRRUP_BAR_SIZE_AUTO_MAXIMUM_FIELD_NUMBER: _ClassVar[int]
        STIRRUP_DIAMETER_AUTO_MAXIMUM_FIELD_NUMBER: _ClassVar[int]
        STIRRUP_DIAMETER_AUTO_DIAMETERS_ENABLED_FIELD_NUMBER: _ClassVar[int]
        STIRRUP_DIAMETER_AUTO_BAR_SIZES_FIELD_NUMBER: _ClassVar[int]
        STIRRUP_DIAMETER_AUTO_DIAMETERS_FIELD_NUMBER: _ClassVar[int]
        STIRRUP_DIAMETER_AUTO_PRIORITY_FIELD_NUMBER: _ClassVar[int]
        STIRRUP_DISTANCES_FIELD_NUMBER: _ClassVar[int]
        STIRRUP_DISTANCES_CALCULATED_FIELD_NUMBER: _ClassVar[int]
        STIRRUP_DISTANCES_AUTO_ENABLED_FIELD_NUMBER: _ClassVar[int]
        STIRRUP_DISTANCES_AUTO_MINIMUM_FIELD_NUMBER: _ClassVar[int]
        STIRRUP_DISTANCES_AUTO_MAXIMUM_FIELD_NUMBER: _ClassVar[int]
        STIRRUP_DISTANCES_AUTO_INCREMENT_FIELD_NUMBER: _ClassVar[int]
        STIRRUP_DISTANCES_AUTO_PRIORITY_FIELD_NUMBER: _ClassVar[int]
        CROSSTIES_ACTIVE_FIELD_NUMBER: _ClassVar[int]
        CROSSTIES_DIAMETER_FIELD_NUMBER: _ClassVar[int]
        REINFORCEMENT_AREA_FIELD_NUMBER: _ClassVar[int]
        HORIZONTAL_CROSSTIE_REINFORCEMENT_AREA_FIELD_NUMBER: _ClassVar[int]
        MINIMAL_MAXIMAL_HORIZONTAL_CROSSTIE_REINFORCEMENT_AREA_FIELD_NUMBER: _ClassVar[int]
        VERTICAL_CROSSTIE_REINFORCEMENT_AREA_FIELD_NUMBER: _ClassVar[int]
        MINIMAL_MAXIMAL_VERTICAL_CROSSTIE_REINFORCEMENT_AREA_FIELD_NUMBER: _ClassVar[int]
        TOTAL_HORIZONTAL_REINFORCEMENT_AREA_FIELD_NUMBER: _ClassVar[int]
        MINIMAL_MAXIMAL_TOTAL_HORIZONTAL_REINFORCEMENT_AREA_FIELD_NUMBER: _ClassVar[int]
        TOTAL_VERTICAL_REINFORCEMENT_AREA_FIELD_NUMBER: _ClassVar[int]
        MINIMAL_MAXIMAL_TOTAL_VERTICAL_REINFORCEMENT_AREA_FIELD_NUMBER: _ClassVar[int]
        SPAN_POSITION_REFERENCE_TYPE_FIELD_NUMBER: _ClassVar[int]
        SPAN_POSITION_REFERENCE_INTERNAL_NODE_FIELD_NUMBER: _ClassVar[int]
        SPAN_POSITION_REFERENCE_X_LOCATION_RELATIVE_FIELD_NUMBER: _ClassVar[int]
        SPAN_POSITION_REFERENCE_X_LOCATION_ABSOLUTE_FIELD_NUMBER: _ClassVar[int]
        SPAN_POSITION_DEFINITION_FORMAT_FIELD_NUMBER: _ClassVar[int]
        SPAN_START_RELATIVE_FIELD_NUMBER: _ClassVar[int]
        SPAN_START_ABSOLUTE_FIELD_NUMBER: _ClassVar[int]
        SPAN_START_AUTO_ENABLED_FIELD_NUMBER: _ClassVar[int]
        SPAN_START_RELATIVE_AUTO_CALCULATED_FIELD_NUMBER: _ClassVar[int]
        SPAN_START_RELATIVE_AUTO_MINIMUM_FIELD_NUMBER: _ClassVar[int]
        SPAN_START_RELATIVE_AUTO_MAXIMUM_FIELD_NUMBER: _ClassVar[int]
        SPAN_START_ABSOLUTE_AUTO_CALCULATED_FIELD_NUMBER: _ClassVar[int]
        SPAN_START_ABSOLUTE_AUTO_MINIMUM_FIELD_NUMBER: _ClassVar[int]
        SPAN_START_ABSOLUTE_AUTO_MAXIMUM_FIELD_NUMBER: _ClassVar[int]
        SPAN_END_RELATIVE_FIELD_NUMBER: _ClassVar[int]
        SPAN_END_ABSOLUTE_FIELD_NUMBER: _ClassVar[int]
        SPAN_END_AUTO_ENABLED_FIELD_NUMBER: _ClassVar[int]
        SPAN_END_RELATIVE_AUTO_CALCULATED_FIELD_NUMBER: _ClassVar[int]
        SPAN_END_RELATIVE_AUTO_MINIMUM_FIELD_NUMBER: _ClassVar[int]
        SPAN_END_RELATIVE_AUTO_MAXIMUM_FIELD_NUMBER: _ClassVar[int]
        SPAN_END_ABSOLUTE_AUTO_CALCULATED_FIELD_NUMBER: _ClassVar[int]
        SPAN_END_ABSOLUTE_AUTO_MINIMUM_FIELD_NUMBER: _ClassVar[int]
        SPAN_END_ABSOLUTE_AUTO_MAXIMUM_FIELD_NUMBER: _ClassVar[int]
        SPAN_LOCATION_AUTO_INCREMENT_FIELD_NUMBER: _ClassVar[int]
        SPAN_LOCATION_AUTO_PRIORITY_FIELD_NUMBER: _ClassVar[int]
        SPAN_LENGTH_FIELD_NUMBER: _ClassVar[int]
        STIRRUP_LAYOUT_RULE_FIELD_NUMBER: _ClassVar[int]
        STIRRUP_START_OFFSET_FIELD_NUMBER: _ClassVar[int]
        STIRRUP_END_OFFSET_FIELD_NUMBER: _ClassVar[int]
        ONE_STIRRUP_LENGTH_FIELD_NUMBER: _ClassVar[int]
        MINIMAL_AND_MAXIMAL_STIRRUP_LENGTH_FIELD_NUMBER: _ClassVar[int]
        ALL_STIRRUPS_LENGTH_FIELD_NUMBER: _ClassVar[int]
        ONE_STIRRUP_WEIGHT_FIELD_NUMBER: _ClassVar[int]
        MINIMAL_AND_MAXIMAL_STIRRUP_WEIGHT_FIELD_NUMBER: _ClassVar[int]
        ALL_STIRRUPS_WEIGHT_FIELD_NUMBER: _ClassVar[int]
        ONE_CROSSTIE_LENGTH_FIELD_NUMBER: _ClassVar[int]
        MINIMAL_AND_MAXIMAL_CROSSTIE_LENGTH_FIELD_NUMBER: _ClassVar[int]
        ALL_CROSSTIES_LENGHT_FIELD_NUMBER: _ClassVar[int]
        ONE_CROSSTIE_WEIGHT_FIELD_NUMBER: _ClassVar[int]
        MINIMAL_AND_MAXIMAL_CROSSTIE_WEIGHT_FIELD_NUMBER: _ClassVar[int]
        ALL_CROSSTIES_WEIGHT_FIELD_NUMBER: _ClassVar[int]
        no: int
        description: str
        name: str
        stirrup_type: MemberRepresentative.ConcreteShearReinforcementSpanRow.StirrupType
        material: int
        stirrup_count: int
        stirrup_bar_size: float
        stirrup_bar_size_calculated: MemberRepresentative.ConcreteShearReinforcementSpanRow.StirrupBarSizeCalculated
        stirrup_diameter: float
        stirrup_diameter_calculated: float
        stirrup_diameter_auto_enabled: bool
        stirrup_bar_size_auto_minimum: MemberRepresentative.ConcreteShearReinforcementSpanRow.StirrupBarSizeAutoMinimum
        stirrup_diameter_auto_minimum: float
        stirrup_bar_size_auto_maximum: MemberRepresentative.ConcreteShearReinforcementSpanRow.StirrupBarSizeAutoMaximum
        stirrup_diameter_auto_maximum: float
        stirrup_diameter_auto_diameters_enabled: bool
        stirrup_diameter_auto_bar_sizes: _containers.RepeatedScalarFieldContainer[MemberRepresentative.ConcreteShearReinforcementSpanRow.StirrupDiameterAutoBarSizes]
        stirrup_diameter_auto_diameters: _containers.RepeatedScalarFieldContainer[float]
        stirrup_diameter_auto_priority: int
        stirrup_distances: float
        stirrup_distances_calculated: float
        stirrup_distances_auto_enabled: bool
        stirrup_distances_auto_minimum: float
        stirrup_distances_auto_maximum: float
        stirrup_distances_auto_increment: float
        stirrup_distances_auto_priority: int
        crossties_active: bool
        crossties_diameter: float
        reinforcement_area: float
        horizontal_crosstie_reinforcement_area: float
        minimal_maximal_horizontal_crosstie_reinforcement_area: str
        vertical_crosstie_reinforcement_area: float
        minimal_maximal_vertical_crosstie_reinforcement_area: str
        total_horizontal_reinforcement_area: float
        minimal_maximal_total_horizontal_reinforcement_area: str
        total_vertical_reinforcement_area: float
        minimal_maximal_total_vertical_reinforcement_area: str
        span_position_reference_type: MemberRepresentative.ConcreteShearReinforcementSpanRow.SpanPositionReferenceType
        span_position_reference_internal_node: int
        span_position_reference_x_location_relative: float
        span_position_reference_x_location_absolute: float
        span_position_definition_format: MemberRepresentative.ConcreteShearReinforcementSpanRow.SpanPositionDefinitionFormat
        span_start_relative: float
        span_start_absolute: float
        span_start_auto_enabled: bool
        span_start_relative_auto_calculated: float
        span_start_relative_auto_minimum: float
        span_start_relative_auto_maximum: float
        span_start_absolute_auto_calculated: float
        span_start_absolute_auto_minimum: float
        span_start_absolute_auto_maximum: float
        span_end_relative: float
        span_end_absolute: float
        span_end_auto_enabled: bool
        span_end_relative_auto_calculated: float
        span_end_relative_auto_minimum: float
        span_end_relative_auto_maximum: float
        span_end_absolute_auto_calculated: float
        span_end_absolute_auto_minimum: float
        span_end_absolute_auto_maximum: float
        span_location_auto_increment: float
        span_location_auto_priority: int
        span_length: float
        stirrup_layout_rule: MemberRepresentative.ConcreteShearReinforcementSpanRow.StirrupLayoutRule
        stirrup_start_offset: float
        stirrup_end_offset: float
        one_stirrup_length: float
        minimal_and_maximal_stirrup_length: str
        all_stirrups_length: float
        one_stirrup_weight: float
        minimal_and_maximal_stirrup_weight: str
        all_stirrups_weight: float
        one_crosstie_length: float
        minimal_and_maximal_crosstie_length: str
        all_crossties_lenght: float
        one_crosstie_weight: float
        minimal_and_maximal_crosstie_weight: str
        all_crossties_weight: float
        def __init__(self, no: _Optional[int] = ..., description: _Optional[str] = ..., name: _Optional[str] = ..., stirrup_type: _Optional[_Union[MemberRepresentative.ConcreteShearReinforcementSpanRow.StirrupType, str]] = ..., material: _Optional[int] = ..., stirrup_count: _Optional[int] = ..., stirrup_bar_size: _Optional[float] = ..., stirrup_bar_size_calculated: _Optional[_Union[MemberRepresentative.ConcreteShearReinforcementSpanRow.StirrupBarSizeCalculated, str]] = ..., stirrup_diameter: _Optional[float] = ..., stirrup_diameter_calculated: _Optional[float] = ..., stirrup_diameter_auto_enabled: bool = ..., stirrup_bar_size_auto_minimum: _Optional[_Union[MemberRepresentative.ConcreteShearReinforcementSpanRow.StirrupBarSizeAutoMinimum, str]] = ..., stirrup_diameter_auto_minimum: _Optional[float] = ..., stirrup_bar_size_auto_maximum: _Optional[_Union[MemberRepresentative.ConcreteShearReinforcementSpanRow.StirrupBarSizeAutoMaximum, str]] = ..., stirrup_diameter_auto_maximum: _Optional[float] = ..., stirrup_diameter_auto_diameters_enabled: bool = ..., stirrup_diameter_auto_bar_sizes: _Optional[_Iterable[_Union[MemberRepresentative.ConcreteShearReinforcementSpanRow.StirrupDiameterAutoBarSizes, str]]] = ..., stirrup_diameter_auto_diameters: _Optional[_Iterable[float]] = ..., stirrup_diameter_auto_priority: _Optional[int] = ..., stirrup_distances: _Optional[float] = ..., stirrup_distances_calculated: _Optional[float] = ..., stirrup_distances_auto_enabled: bool = ..., stirrup_distances_auto_minimum: _Optional[float] = ..., stirrup_distances_auto_maximum: _Optional[float] = ..., stirrup_distances_auto_increment: _Optional[float] = ..., stirrup_distances_auto_priority: _Optional[int] = ..., crossties_active: bool = ..., crossties_diameter: _Optional[float] = ..., reinforcement_area: _Optional[float] = ..., horizontal_crosstie_reinforcement_area: _Optional[float] = ..., minimal_maximal_horizontal_crosstie_reinforcement_area: _Optional[str] = ..., vertical_crosstie_reinforcement_area: _Optional[float] = ..., minimal_maximal_vertical_crosstie_reinforcement_area: _Optional[str] = ..., total_horizontal_reinforcement_area: _Optional[float] = ..., minimal_maximal_total_horizontal_reinforcement_area: _Optional[str] = ..., total_vertical_reinforcement_area: _Optional[float] = ..., minimal_maximal_total_vertical_reinforcement_area: _Optional[str] = ..., span_position_reference_type: _Optional[_Union[MemberRepresentative.ConcreteShearReinforcementSpanRow.SpanPositionReferenceType, str]] = ..., span_position_reference_internal_node: _Optional[int] = ..., span_position_reference_x_location_relative: _Optional[float] = ..., span_position_reference_x_location_absolute: _Optional[float] = ..., span_position_definition_format: _Optional[_Union[MemberRepresentative.ConcreteShearReinforcementSpanRow.SpanPositionDefinitionFormat, str]] = ..., span_start_relative: _Optional[float] = ..., span_start_absolute: _Optional[float] = ..., span_start_auto_enabled: bool = ..., span_start_relative_auto_calculated: _Optional[float] = ..., span_start_relative_auto_minimum: _Optional[float] = ..., span_start_relative_auto_maximum: _Optional[float] = ..., span_start_absolute_auto_calculated: _Optional[float] = ..., span_start_absolute_auto_minimum: _Optional[float] = ..., span_start_absolute_auto_maximum: _Optional[float] = ..., span_end_relative: _Optional[float] = ..., span_end_absolute: _Optional[float] = ..., span_end_auto_enabled: bool = ..., span_end_relative_auto_calculated: _Optional[float] = ..., span_end_relative_auto_minimum: _Optional[float] = ..., span_end_relative_auto_maximum: _Optional[float] = ..., span_end_absolute_auto_calculated: _Optional[float] = ..., span_end_absolute_auto_minimum: _Optional[float] = ..., span_end_absolute_auto_maximum: _Optional[float] = ..., span_location_auto_increment: _Optional[float] = ..., span_location_auto_priority: _Optional[int] = ..., span_length: _Optional[float] = ..., stirrup_layout_rule: _Optional[_Union[MemberRepresentative.ConcreteShearReinforcementSpanRow.StirrupLayoutRule, str]] = ..., stirrup_start_offset: _Optional[float] = ..., stirrup_end_offset: _Optional[float] = ..., one_stirrup_length: _Optional[float] = ..., minimal_and_maximal_stirrup_length: _Optional[str] = ..., all_stirrups_length: _Optional[float] = ..., one_stirrup_weight: _Optional[float] = ..., minimal_and_maximal_stirrup_weight: _Optional[str] = ..., all_stirrups_weight: _Optional[float] = ..., one_crosstie_length: _Optional[float] = ..., minimal_and_maximal_crosstie_length: _Optional[str] = ..., all_crossties_lenght: _Optional[float] = ..., one_crosstie_weight: _Optional[float] = ..., minimal_and_maximal_crosstie_weight: _Optional[str] = ..., all_crossties_weight: _Optional[float] = ...) -> None: ...
    NO_FIELD_NUMBER: _ClassVar[int]
    TYPE_FIELD_NUMBER: _ClassVar[int]
    USER_DEFINED_NAME_ENABLED_FIELD_NUMBER: _ClassVar[int]
    NAME_FIELD_NUMBER: _ClassVar[int]
    COMMENT_FIELD_NUMBER: _ClassVar[int]
    NUMBER_OF_MEMBERS_FIELD_NUMBER: _ClassVar[int]
    TOTAL_LENGTH_FIELD_NUMBER: _ClassVar[int]
    TOTAL_VOLUME_FIELD_NUMBER: _ClassVar[int]
    TOTAL_MASS_FIELD_NUMBER: _ClassVar[int]
    TOTAL_SURFACE_OF_COATING_FIELD_NUMBER: _ClassVar[int]
    NODES_ON_MEMBER_FROM_START_FIELD_NUMBER: _ClassVar[int]
    IS_DEACTIVATED_FOR_CALCULATION_FIELD_NUMBER: _ClassVar[int]
    LINE_FIELD_NUMBER: _ClassVar[int]
    SECTION_DISTRIBUTION_TYPE_FIELD_NUMBER: _ClassVar[int]
    REFERENCE_TYPE_FIELD_NUMBER: _ClassVar[int]
    NODES_FIELD_NUMBER: _ClassVar[int]
    NODE_START_FIELD_NUMBER: _ClassVar[int]
    NODE_END_FIELD_NUMBER: _ClassVar[int]
    ANALYTICAL_LENGTH_FIELD_NUMBER: _ClassVar[int]
    ANALYTICAL_VOLUME_FIELD_NUMBER: _ClassVar[int]
    ANALYTICAL_MASS_FIELD_NUMBER: _ClassVar[int]
    ANALYTICAL_SURFACE_OF_COATING_FIELD_NUMBER: _ClassVar[int]
    ANALYTICAL_CENTER_OF_GRAVITY_FIELD_NUMBER: _ClassVar[int]
    ANALYTICAL_CENTER_OF_GRAVITY_X_FIELD_NUMBER: _ClassVar[int]
    ANALYTICAL_CENTER_OF_GRAVITY_Y_FIELD_NUMBER: _ClassVar[int]
    ANALYTICAL_CENTER_OF_GRAVITY_Z_FIELD_NUMBER: _ClassVar[int]
    LENGTH_FIELD_NUMBER: _ClassVar[int]
    VOLUME_FIELD_NUMBER: _ClassVar[int]
    MASS_FIELD_NUMBER: _ClassVar[int]
    SURFACE_OF_COATING_FIELD_NUMBER: _ClassVar[int]
    CENTER_OF_GRAVITY_FIELD_NUMBER: _ClassVar[int]
    CENTER_OF_GRAVITY_X_FIELD_NUMBER: _ClassVar[int]
    CENTER_OF_GRAVITY_Y_FIELD_NUMBER: _ClassVar[int]
    CENTER_OF_GRAVITY_Z_FIELD_NUMBER: _ClassVar[int]
    MEMBER_REPRESENTATIVE_FIELD_NUMBER: _ClassVar[int]
    MEMBER_TYPE_RIB_ALIGNMENT_FIELD_NUMBER: _ClassVar[int]
    MEMBER_RIB_FIRST_SURFACE_FIELD_NUMBER: _ClassVar[int]
    MEMBER_RIB_SECOND_SURFACE_FIELD_NUMBER: _ClassVar[int]
    MEMBER_RIB_SURFACE_ASSIGNMENT_AUTODETECT_FIELD_NUMBER: _ClassVar[int]
    MEMBER_RIB_GENERATING_LONGITUDINAL_REINFORCEMENT_ITEMS_FROM_SURFACES_ENABLED_FIELD_NUMBER: _ClassVar[int]
    ALIGN_LOCAL_Z_AXIS_TO_LOCAL_Z_AXIS_OF_SURFACE_FIELD_NUMBER: _ClassVar[int]
    MEMBER_RIB_SHEAR_JOINT_BETWEEN_WEB_AND_FLANGE_FIELD_NUMBER: _ClassVar[int]
    MEMBER_RIB_SURFACE_ROUGHNESS_CLASSIFICATION_FIELD_NUMBER: _ClassVar[int]
    MEMBER_RIB_REDUCTION_OF_JOINT_WIDTH_FIELD_NUMBER: _ClassVar[int]
    RESULT_BEAM_INTEGRATE_STRESSES_AND_FORCES_FIELD_NUMBER: _ClassVar[int]
    FLANGE_DIMENSIONS_FIELD_NUMBER: _ClassVar[int]
    SYNCHRONIZE_WIDTH_MODE_FIELD_NUMBER: _ClassVar[int]
    RELATIVE_ORDINATES_MODE_FIELD_NUMBER: _ClassVar[int]
    MEMBER_TYPE_DEFINABLE_STIFFNESS_FIELD_NUMBER: _ClassVar[int]
    RESULT_BEAM_Y_Z_FIELD_NUMBER: _ClassVar[int]
    RESULT_BEAM_Y_PLUS_FIELD_NUMBER: _ClassVar[int]
    RESULT_BEAM_Z_PLUS_FIELD_NUMBER: _ClassVar[int]
    RESULT_BEAM_Y_MINUS_FIELD_NUMBER: _ClassVar[int]
    RESULT_BEAM_Z_MINUS_FIELD_NUMBER: _ClassVar[int]
    RESULT_BEAM_RADIUS_FIELD_NUMBER: _ClassVar[int]
    RESULT_BEAM_INCLUDE_SURFACES_FIELD_NUMBER: _ClassVar[int]
    RESULT_BEAM_INCLUDE_ALL_SURFACES_FIELD_NUMBER: _ClassVar[int]
    RESULT_BEAM_INCLUDE_SOLIDS_FIELD_NUMBER: _ClassVar[int]
    RESULT_BEAM_INCLUDE_ALL_SOLIDS_FIELD_NUMBER: _ClassVar[int]
    RESULT_BEAM_INCLUDE_MEMBERS_FIELD_NUMBER: _ClassVar[int]
    RESULT_BEAM_INCLUDE_ALL_MEMBERS_FIELD_NUMBER: _ClassVar[int]
    RESULT_BEAM_EXCLUDE_SURFACES_FIELD_NUMBER: _ClassVar[int]
    RESULT_BEAM_EXCLUDE_SOLIDS_FIELD_NUMBER: _ClassVar[int]
    RESULT_BEAM_EXCLUDE_MEMBERS_FIELD_NUMBER: _ClassVar[int]
    PROJECTED_LENGTH_FIELD_NUMBER: _ClassVar[int]
    SECTION_DISTANCE_FROM_START_IS_DEFINED_AS_RELATIVE_FIELD_NUMBER: _ClassVar[int]
    SECTION_DISTANCE_FROM_START_ABSOLUTE_FIELD_NUMBER: _ClassVar[int]
    SECTION_DISTANCE_FROM_START_RELATIVE_FIELD_NUMBER: _ClassVar[int]
    SECTION_DISTANCE_FROM_END_IS_DEFINED_AS_RELATIVE_FIELD_NUMBER: _ClassVar[int]
    SECTION_DISTANCE_FROM_END_ABSOLUTE_FIELD_NUMBER: _ClassVar[int]
    SECTION_DISTANCE_FROM_END_RELATIVE_FIELD_NUMBER: _ClassVar[int]
    SECTION_ALIGNMENT_FIELD_NUMBER: _ClassVar[int]
    GRAIN_ALIGNMENT_FIELD_NUMBER: _ClassVar[int]
    IS_CURVED_FIELD_NUMBER: _ClassVar[int]
    CURVED_MEMBER_IS_ASYMMETRIC_LAYOUT_FIELD_NUMBER: _ClassVar[int]
    CURVED_MEMBER_IS_CANTILEVERS_FIELD_NUMBER: _ClassVar[int]
    CURVED_MEMBER_CANTILEVERS_TYPE_FIELD_NUMBER: _ClassVar[int]
    CURVED_MEMBER_IS_CAPPED_WITH_LOOSE_RIDGE_WEDGE_FIELD_NUMBER: _ClassVar[int]
    CURVED_MEMBER_PARAMETERS_FIELD_NUMBER: _ClassVar[int]
    ROTATION_SPECIFICATION_TYPE_FIELD_NUMBER: _ClassVar[int]
    ROTATION_ANGLE_FIELD_NUMBER: _ClassVar[int]
    ROTATION_HELP_NODE_FIELD_NUMBER: _ClassVar[int]
    ROTATION_PLANE_TYPE_FIELD_NUMBER: _ClassVar[int]
    ROTATION_SURFACE_FIELD_NUMBER: _ClassVar[int]
    ROTATION_SURFACE_PLANE_TYPE_FIELD_NUMBER: _ClassVar[int]
    IS_ROTATED_FIELD_NUMBER: _ClassVar[int]
    SECTION_START_FIELD_NUMBER: _ClassVar[int]
    SECTION_END_FIELD_NUMBER: _ClassVar[int]
    SECTION_INTERNAL_FIELD_NUMBER: _ClassVar[int]
    SECTION_MATERIAL_FIELD_NUMBER: _ClassVar[int]
    MEMBERS_FIELD_NUMBER: _ClassVar[int]
    MEMBER_HINGE_START_FIELD_NUMBER: _ClassVar[int]
    MEMBER_HINGE_END_FIELD_NUMBER: _ClassVar[int]
    MEMBER_ECCENTRICITY_START_FIELD_NUMBER: _ClassVar[int]
    MEMBER_ECCENTRICITY_END_FIELD_NUMBER: _ClassVar[int]
    SUPPORT_FIELD_NUMBER: _ClassVar[int]
    MEMBER_TRANSVERSE_STIFFENER_FIELD_NUMBER: _ClassVar[int]
    MEMBER_OPENINGS_FIELD_NUMBER: _ClassVar[int]
    MEMBER_NONLINEARITY_FIELD_NUMBER: _ClassVar[int]
    MEMBER_RESULT_INTERMEDIATE_POINT_FIELD_NUMBER: _ClassVar[int]
    CONCRETE_EFFECTIVE_LENGTHS_FIELD_NUMBER: _ClassVar[int]
    STEEL_EFFECTIVE_LENGTHS_FIELD_NUMBER: _ClassVar[int]
    TIMBER_EFFECTIVE_LENGTHS_FIELD_NUMBER: _ClassVar[int]
    ALUMINUM_EFFECTIVE_LENGTHS_FIELD_NUMBER: _ClassVar[int]
    CONCRETE_SHEAR_REINFORCEMENT_SPANS_FIELD_NUMBER: _ClassVar[int]
    CONCRETE_LONGITUDINAL_REINFORCEMENT_ITEMS_FIELD_NUMBER: _ClassVar[int]
    CONCRETE_COVER_USER_DEFINED_ENABLED_FIELD_NUMBER: _ClassVar[int]
    CONCRETE_COVER_DIFFERENT_AT_SECTION_SIDES_ENABLED_FIELD_NUMBER: _ClassVar[int]
    CONCRETE_COVER_FIELD_NUMBER: _ClassVar[int]
    CONCRETE_COVER_TOP_FIELD_NUMBER: _ClassVar[int]
    CONCRETE_COVER_BOTTOM_FIELD_NUMBER: _ClassVar[int]
    CONCRETE_COVER_LEFT_FIELD_NUMBER: _ClassVar[int]
    CONCRETE_COVER_RIGHT_FIELD_NUMBER: _ClassVar[int]
    CONCRETE_COVER_MIN_FIELD_NUMBER: _ClassVar[int]
    CONCRETE_COVER_MIN_TOP_FIELD_NUMBER: _ClassVar[int]
    CONCRETE_COVER_MIN_BOTTOM_FIELD_NUMBER: _ClassVar[int]
    CONCRETE_COVER_MIN_LEFT_FIELD_NUMBER: _ClassVar[int]
    CONCRETE_COVER_MIN_RIGHT_FIELD_NUMBER: _ClassVar[int]
    CONCRETE_DURABILITY_FIELD_NUMBER: _ClassVar[int]
    CONCRETE_DURABILITY_TOP_FIELD_NUMBER: _ClassVar[int]
    CONCRETE_DURABILITY_BOTTOM_FIELD_NUMBER: _ClassVar[int]
    CONCRETE_DURABILITY_LEFT_FIELD_NUMBER: _ClassVar[int]
    CONCRETE_DURABILITY_RIGHT_FIELD_NUMBER: _ClassVar[int]
    STEEL_BOUNDARY_CONDITIONS_FIELD_NUMBER: _ClassVar[int]
    STEEL_MEMBER_LOCAL_SECTION_REDUCTION_FIELD_NUMBER: _ClassVar[int]
    STEEL_MEMBER_TRANSVERSE_WELD_FIELD_NUMBER: _ClassVar[int]
    TIMBER_SERVICE_CLASS_FIELD_NUMBER: _ClassVar[int]
    TIMBER_MOISTURE_CLASS_FIELD_NUMBER: _ClassVar[int]
    TIMBER_SERVICE_CONDITIONS_FIELD_NUMBER: _ClassVar[int]
    TIMBER_MEMBER_LOCAL_SECTION_REDUCTION_FIELD_NUMBER: _ClassVar[int]
    ALUMINUM_BOUNDARY_CONDITIONS_FIELD_NUMBER: _ClassVar[int]
    ALUMINUM_MEMBER_LOCAL_SECTION_REDUCTION_FIELD_NUMBER: _ClassVar[int]
    ALUMINUM_MEMBER_TRANSVERSE_WELD_FIELD_NUMBER: _ClassVar[int]
    STRESS_ANALYSIS_CONFIGURATION_FIELD_NUMBER: _ClassVar[int]
    MEMBER_ALUMINUM_DESIGN_ULS_CONFIGURATION_FIELD_NUMBER: _ClassVar[int]
    MEMBER_ALUMINUM_DESIGN_SLS_CONFIGURATION_FIELD_NUMBER: _ClassVar[int]
    MEMBER_CONCRETE_DESIGN_ULS_CONFIGURATION_FIELD_NUMBER: _ClassVar[int]
    MEMBER_CONCRETE_DESIGN_SLS_CONFIGURATION_FIELD_NUMBER: _ClassVar[int]
    MEMBER_CONCRETE_DESIGN_FR_CONFIGURATION_FIELD_NUMBER: _ClassVar[int]
    MEMBER_CONCRETE_DESIGN_SEISMIC_CONFIGURATION_FIELD_NUMBER: _ClassVar[int]
    MEMBER_STEEL_DESIGN_ULS_CONFIGURATION_FIELD_NUMBER: _ClassVar[int]
    MEMBER_STEEL_DESIGN_SLS_CONFIGURATION_FIELD_NUMBER: _ClassVar[int]
    MEMBER_STEEL_DESIGN_FR_CONFIGURATION_FIELD_NUMBER: _ClassVar[int]
    MEMBER_TIMBER_DESIGN_ULS_CONFIGURATION_FIELD_NUMBER: _ClassVar[int]
    MEMBER_TIMBER_DESIGN_SLS_CONFIGURATION_FIELD_NUMBER: _ClassVar[int]
    MEMBER_TIMBER_DESIGN_FR_CONFIGURATION_FIELD_NUMBER: _ClassVar[int]
    END_MODIFICATIONS_MEMBER_START_EXTENSION_FIELD_NUMBER: _ClassVar[int]
    END_MODIFICATIONS_MEMBER_START_SLOPE_Y_FIELD_NUMBER: _ClassVar[int]
    END_MODIFICATIONS_MEMBER_START_SLOPE_Z_FIELD_NUMBER: _ClassVar[int]
    END_MODIFICATIONS_MEMBER_END_EXTENSION_FIELD_NUMBER: _ClassVar[int]
    END_MODIFICATIONS_MEMBER_END_SLOPE_Y_FIELD_NUMBER: _ClassVar[int]
    END_MODIFICATIONS_MEMBER_END_SLOPE_Z_FIELD_NUMBER: _ClassVar[int]
    HAS_ANY_END_MODIFICATIONS_FIELD_NUMBER: _ClassVar[int]
    DEFLECTION_CHECK_DIRECTION_FIELD_NUMBER: _ClassVar[int]
    DEFLECTION_CHECK_DISPLACEMENT_REFERENCE_FIELD_NUMBER: _ClassVar[int]
    DESIGN_SUPPORT_ON_MEMBER_START_FIELD_NUMBER: _ClassVar[int]
    DESIGN_SUPPORT_ON_MEMBER_END_FIELD_NUMBER: _ClassVar[int]
    DESIGN_SUPPORTS_ON_INTERNAL_NODES_FIELD_NUMBER: _ClassVar[int]
    IS_GENERATED_FIELD_NUMBER: _ClassVar[int]
    GENERATING_OBJECT_INFO_FIELD_NUMBER: _ClassVar[int]
    DEFLECTION_SEGMENTS_DEFINED_LENGTH_Y_AXIS_ENABLED_FIELD_NUMBER: _ClassVar[int]
    DEFLECTION_SEGMENTS_DEFINED_LENGTH_Z_AXIS_ENABLED_FIELD_NUMBER: _ClassVar[int]
    DEFLECTION_SEGMENTS_Y_AXIS_FIELD_NUMBER: _ClassVar[int]
    DEFLECTION_SEGMENTS_Z_AXIS_FIELD_NUMBER: _ClassVar[int]
    CONCRETE_LONGITUDINAL_REINFORCEMENT_SPAN_FIELD_NUMBER: _ClassVar[int]
    CONCRETE_SHEAR_REINFORCEMENT_SPAN_FIELD_NUMBER: _ClassVar[int]
    DESIGN_PROPERTIES_VIA_MEMBER_FIELD_NUMBER: _ClassVar[int]
    DESIGN_PROPERTIES_VIA_PARENT_MEMBER_SET_FIELD_NUMBER: _ClassVar[int]
    DESIGN_PROPERTIES_PARENT_MEMBER_SET_FIELD_NUMBER: _ClassVar[int]
    ID_FOR_EXPORT_IMPORT_FIELD_NUMBER: _ClassVar[int]
    METADATA_FOR_EXPORT_IMPORT_FIELD_NUMBER: _ClassVar[int]
    no: int
    type: MemberRepresentative.Type
    user_defined_name_enabled: bool
    name: str
    comment: str
    number_of_members: int
    total_length: float
    total_volume: float
    total_mass: float
    total_surface_of_coating: float
    nodes_on_member_from_start: _containers.RepeatedScalarFieldContainer[float]
    is_deactivated_for_calculation: bool
    line: int
    section_distribution_type: MemberRepresentative.SectionDistributionType
    reference_type: MemberRepresentative.ReferenceType
    nodes: _containers.RepeatedScalarFieldContainer[int]
    node_start: int
    node_end: int
    analytical_length: float
    analytical_volume: float
    analytical_mass: float
    analytical_surface_of_coating: float
    analytical_center_of_gravity: _common_pb2.Vector3d
    analytical_center_of_gravity_x: float
    analytical_center_of_gravity_y: float
    analytical_center_of_gravity_z: float
    length: float
    volume: float
    mass: float
    surface_of_coating: float
    center_of_gravity: _common_pb2.Vector3d
    center_of_gravity_x: float
    center_of_gravity_y: float
    center_of_gravity_z: float
    member_representative: int
    member_type_rib_alignment: MemberRepresentative.MemberTypeRibAlignment
    member_rib_first_surface: int
    member_rib_second_surface: int
    member_rib_surface_assignment_autodetect: bool
    member_rib_generating_longitudinal_reinforcement_items_from_surfaces_enabled: bool
    align_local_z_axis_to_local_z_axis_of_surface: bool
    member_rib_shear_joint_between_web_and_flange: bool
    member_rib_surface_roughness_classification: MemberRepresentative.MemberRibSurfaceRoughnessClassification
    member_rib_reduction_of_joint_width: float
    result_beam_integrate_stresses_and_forces: MemberRepresentative.ResultBeamIntegrateStressesAndForces
    flange_dimensions: MemberRepresentative.FlangeDimensionsTable
    synchronize_width_mode: bool
    relative_ordinates_mode: bool
    member_type_definable_stiffness: int
    result_beam_y_z: float
    result_beam_y_plus: float
    result_beam_z_plus: float
    result_beam_y_minus: float
    result_beam_z_minus: float
    result_beam_radius: float
    result_beam_include_surfaces: _containers.RepeatedScalarFieldContainer[int]
    result_beam_include_all_surfaces: bool
    result_beam_include_solids: _containers.RepeatedScalarFieldContainer[int]
    result_beam_include_all_solids: bool
    result_beam_include_members: _containers.RepeatedScalarFieldContainer[int]
    result_beam_include_all_members: bool
    result_beam_exclude_surfaces: _containers.RepeatedScalarFieldContainer[int]
    result_beam_exclude_solids: _containers.RepeatedScalarFieldContainer[int]
    result_beam_exclude_members: _containers.RepeatedScalarFieldContainer[int]
    projected_length: float
    section_distance_from_start_is_defined_as_relative: bool
    section_distance_from_start_absolute: float
    section_distance_from_start_relative: float
    section_distance_from_end_is_defined_as_relative: bool
    section_distance_from_end_absolute: float
    section_distance_from_end_relative: float
    section_alignment: MemberRepresentative.SectionAlignment
    grain_alignment: MemberRepresentative.GrainAlignment
    is_curved: bool
    curved_member_is_asymmetric_layout: bool
    curved_member_is_cantilevers: bool
    curved_member_cantilevers_type: MemberRepresentative.CurvedMemberCantileversType
    curved_member_is_capped_with_loose_ridge_wedge: bool
    curved_member_parameters: MemberRepresentative.CurvedMemberParametersTreeTable
    rotation_specification_type: MemberRepresentative.RotationSpecificationType
    rotation_angle: float
    rotation_help_node: int
    rotation_plane_type: MemberRepresentative.RotationPlaneType
    rotation_surface: int
    rotation_surface_plane_type: MemberRepresentative.RotationSurfacePlaneType
    is_rotated: bool
    section_start: int
    section_end: int
    section_internal: int
    section_material: int
    members: _containers.RepeatedScalarFieldContainer[int]
    member_hinge_start: int
    member_hinge_end: int
    member_eccentricity_start: int
    member_eccentricity_end: int
    support: int
    member_transverse_stiffener: int
    member_openings: int
    member_nonlinearity: int
    member_result_intermediate_point: int
    concrete_effective_lengths: int
    steel_effective_lengths: int
    timber_effective_lengths: int
    aluminum_effective_lengths: int
    concrete_shear_reinforcement_spans: MemberRepresentative.ConcreteShearReinforcementSpansTable
    concrete_longitudinal_reinforcement_items: MemberRepresentative.ConcreteLongitudinalReinforcementItemsTable
    concrete_cover_user_defined_enabled: bool
    concrete_cover_different_at_section_sides_enabled: bool
    concrete_cover: float
    concrete_cover_top: float
    concrete_cover_bottom: float
    concrete_cover_left: float
    concrete_cover_right: float
    concrete_cover_min: _containers.RepeatedScalarFieldContainer[float]
    concrete_cover_min_top: _containers.RepeatedScalarFieldContainer[float]
    concrete_cover_min_bottom: _containers.RepeatedScalarFieldContainer[float]
    concrete_cover_min_left: _containers.RepeatedScalarFieldContainer[float]
    concrete_cover_min_right: _containers.RepeatedScalarFieldContainer[float]
    concrete_durability: int
    concrete_durability_top: int
    concrete_durability_bottom: int
    concrete_durability_left: int
    concrete_durability_right: int
    steel_boundary_conditions: int
    steel_member_local_section_reduction: int
    steel_member_transverse_weld: int
    timber_service_class: int
    timber_moisture_class: int
    timber_service_conditions: int
    timber_member_local_section_reduction: int
    aluminum_boundary_conditions: int
    aluminum_member_local_section_reduction: int
    aluminum_member_transverse_weld: int
    stress_analysis_configuration: int
    member_aluminum_design_uls_configuration: int
    member_aluminum_design_sls_configuration: int
    member_concrete_design_uls_configuration: int
    member_concrete_design_sls_configuration: int
    member_concrete_design_fr_configuration: int
    member_concrete_design_seismic_configuration: int
    member_steel_design_uls_configuration: int
    member_steel_design_sls_configuration: int
    member_steel_design_fr_configuration: int
    member_timber_design_uls_configuration: int
    member_timber_design_sls_configuration: int
    member_timber_design_fr_configuration: int
    end_modifications_member_start_extension: float
    end_modifications_member_start_slope_y: float
    end_modifications_member_start_slope_z: float
    end_modifications_member_end_extension: float
    end_modifications_member_end_slope_y: float
    end_modifications_member_end_slope_z: float
    has_any_end_modifications: bool
    deflection_check_direction: MemberRepresentative.DeflectionCheckDirection
    deflection_check_displacement_reference: MemberRepresentative.DeflectionCheckDisplacementReference
    design_support_on_member_start: int
    design_support_on_member_end: int
    design_supports_on_internal_nodes: MemberRepresentative.DesignSupportsOnInternalNodesTable
    is_generated: bool
    generating_object_info: str
    deflection_segments_defined_length_y_axis_enabled: bool
    deflection_segments_defined_length_z_axis_enabled: bool
    deflection_segments_y_axis: MemberRepresentative.DeflectionSegmentsYAxisTable
    deflection_segments_z_axis: MemberRepresentative.DeflectionSegmentsZAxisTable
    concrete_longitudinal_reinforcement_span: MemberRepresentative.ConcreteLongitudinalReinforcementSpanTable
    concrete_shear_reinforcement_span: MemberRepresentative.ConcreteShearReinforcementSpanTable
    design_properties_via_member: bool
    design_properties_via_parent_member_set: bool
    design_properties_parent_member_set: int
    id_for_export_import: str
    metadata_for_export_import: str
    def __init__(self, no: _Optional[int] = ..., type: _Optional[_Union[MemberRepresentative.Type, str]] = ..., user_defined_name_enabled: bool = ..., name: _Optional[str] = ..., comment: _Optional[str] = ..., number_of_members: _Optional[int] = ..., total_length: _Optional[float] = ..., total_volume: _Optional[float] = ..., total_mass: _Optional[float] = ..., total_surface_of_coating: _Optional[float] = ..., nodes_on_member_from_start: _Optional[_Iterable[float]] = ..., is_deactivated_for_calculation: bool = ..., line: _Optional[int] = ..., section_distribution_type: _Optional[_Union[MemberRepresentative.SectionDistributionType, str]] = ..., reference_type: _Optional[_Union[MemberRepresentative.ReferenceType, str]] = ..., nodes: _Optional[_Iterable[int]] = ..., node_start: _Optional[int] = ..., node_end: _Optional[int] = ..., analytical_length: _Optional[float] = ..., analytical_volume: _Optional[float] = ..., analytical_mass: _Optional[float] = ..., analytical_surface_of_coating: _Optional[float] = ..., analytical_center_of_gravity: _Optional[_Union[_common_pb2.Vector3d, _Mapping]] = ..., analytical_center_of_gravity_x: _Optional[float] = ..., analytical_center_of_gravity_y: _Optional[float] = ..., analytical_center_of_gravity_z: _Optional[float] = ..., length: _Optional[float] = ..., volume: _Optional[float] = ..., mass: _Optional[float] = ..., surface_of_coating: _Optional[float] = ..., center_of_gravity: _Optional[_Union[_common_pb2.Vector3d, _Mapping]] = ..., center_of_gravity_x: _Optional[float] = ..., center_of_gravity_y: _Optional[float] = ..., center_of_gravity_z: _Optional[float] = ..., member_representative: _Optional[int] = ..., member_type_rib_alignment: _Optional[_Union[MemberRepresentative.MemberTypeRibAlignment, str]] = ..., member_rib_first_surface: _Optional[int] = ..., member_rib_second_surface: _Optional[int] = ..., member_rib_surface_assignment_autodetect: bool = ..., member_rib_generating_longitudinal_reinforcement_items_from_surfaces_enabled: bool = ..., align_local_z_axis_to_local_z_axis_of_surface: bool = ..., member_rib_shear_joint_between_web_and_flange: bool = ..., member_rib_surface_roughness_classification: _Optional[_Union[MemberRepresentative.MemberRibSurfaceRoughnessClassification, str]] = ..., member_rib_reduction_of_joint_width: _Optional[float] = ..., result_beam_integrate_stresses_and_forces: _Optional[_Union[MemberRepresentative.ResultBeamIntegrateStressesAndForces, str]] = ..., flange_dimensions: _Optional[_Union[MemberRepresentative.FlangeDimensionsTable, _Mapping]] = ..., synchronize_width_mode: bool = ..., relative_ordinates_mode: bool = ..., member_type_definable_stiffness: _Optional[int] = ..., result_beam_y_z: _Optional[float] = ..., result_beam_y_plus: _Optional[float] = ..., result_beam_z_plus: _Optional[float] = ..., result_beam_y_minus: _Optional[float] = ..., result_beam_z_minus: _Optional[float] = ..., result_beam_radius: _Optional[float] = ..., result_beam_include_surfaces: _Optional[_Iterable[int]] = ..., result_beam_include_all_surfaces: bool = ..., result_beam_include_solids: _Optional[_Iterable[int]] = ..., result_beam_include_all_solids: bool = ..., result_beam_include_members: _Optional[_Iterable[int]] = ..., result_beam_include_all_members: bool = ..., result_beam_exclude_surfaces: _Optional[_Iterable[int]] = ..., result_beam_exclude_solids: _Optional[_Iterable[int]] = ..., result_beam_exclude_members: _Optional[_Iterable[int]] = ..., projected_length: _Optional[float] = ..., section_distance_from_start_is_defined_as_relative: bool = ..., section_distance_from_start_absolute: _Optional[float] = ..., section_distance_from_start_relative: _Optional[float] = ..., section_distance_from_end_is_defined_as_relative: bool = ..., section_distance_from_end_absolute: _Optional[float] = ..., section_distance_from_end_relative: _Optional[float] = ..., section_alignment: _Optional[_Union[MemberRepresentative.SectionAlignment, str]] = ..., grain_alignment: _Optional[_Union[MemberRepresentative.GrainAlignment, str]] = ..., is_curved: bool = ..., curved_member_is_asymmetric_layout: bool = ..., curved_member_is_cantilevers: bool = ..., curved_member_cantilevers_type: _Optional[_Union[MemberRepresentative.CurvedMemberCantileversType, str]] = ..., curved_member_is_capped_with_loose_ridge_wedge: bool = ..., curved_member_parameters: _Optional[_Union[MemberRepresentative.CurvedMemberParametersTreeTable, _Mapping]] = ..., rotation_specification_type: _Optional[_Union[MemberRepresentative.RotationSpecificationType, str]] = ..., rotation_angle: _Optional[float] = ..., rotation_help_node: _Optional[int] = ..., rotation_plane_type: _Optional[_Union[MemberRepresentative.RotationPlaneType, str]] = ..., rotation_surface: _Optional[int] = ..., rotation_surface_plane_type: _Optional[_Union[MemberRepresentative.RotationSurfacePlaneType, str]] = ..., is_rotated: bool = ..., section_start: _Optional[int] = ..., section_end: _Optional[int] = ..., section_internal: _Optional[int] = ..., section_material: _Optional[int] = ..., members: _Optional[_Iterable[int]] = ..., member_hinge_start: _Optional[int] = ..., member_hinge_end: _Optional[int] = ..., member_eccentricity_start: _Optional[int] = ..., member_eccentricity_end: _Optional[int] = ..., support: _Optional[int] = ..., member_transverse_stiffener: _Optional[int] = ..., member_openings: _Optional[int] = ..., member_nonlinearity: _Optional[int] = ..., member_result_intermediate_point: _Optional[int] = ..., concrete_effective_lengths: _Optional[int] = ..., steel_effective_lengths: _Optional[int] = ..., timber_effective_lengths: _Optional[int] = ..., aluminum_effective_lengths: _Optional[int] = ..., concrete_shear_reinforcement_spans: _Optional[_Union[MemberRepresentative.ConcreteShearReinforcementSpansTable, _Mapping]] = ..., concrete_longitudinal_reinforcement_items: _Optional[_Union[MemberRepresentative.ConcreteLongitudinalReinforcementItemsTable, _Mapping]] = ..., concrete_cover_user_defined_enabled: bool = ..., concrete_cover_different_at_section_sides_enabled: bool = ..., concrete_cover: _Optional[float] = ..., concrete_cover_top: _Optional[float] = ..., concrete_cover_bottom: _Optional[float] = ..., concrete_cover_left: _Optional[float] = ..., concrete_cover_right: _Optional[float] = ..., concrete_cover_min: _Optional[_Iterable[float]] = ..., concrete_cover_min_top: _Optional[_Iterable[float]] = ..., concrete_cover_min_bottom: _Optional[_Iterable[float]] = ..., concrete_cover_min_left: _Optional[_Iterable[float]] = ..., concrete_cover_min_right: _Optional[_Iterable[float]] = ..., concrete_durability: _Optional[int] = ..., concrete_durability_top: _Optional[int] = ..., concrete_durability_bottom: _Optional[int] = ..., concrete_durability_left: _Optional[int] = ..., concrete_durability_right: _Optional[int] = ..., steel_boundary_conditions: _Optional[int] = ..., steel_member_local_section_reduction: _Optional[int] = ..., steel_member_transverse_weld: _Optional[int] = ..., timber_service_class: _Optional[int] = ..., timber_moisture_class: _Optional[int] = ..., timber_service_conditions: _Optional[int] = ..., timber_member_local_section_reduction: _Optional[int] = ..., aluminum_boundary_conditions: _Optional[int] = ..., aluminum_member_local_section_reduction: _Optional[int] = ..., aluminum_member_transverse_weld: _Optional[int] = ..., stress_analysis_configuration: _Optional[int] = ..., member_aluminum_design_uls_configuration: _Optional[int] = ..., member_aluminum_design_sls_configuration: _Optional[int] = ..., member_concrete_design_uls_configuration: _Optional[int] = ..., member_concrete_design_sls_configuration: _Optional[int] = ..., member_concrete_design_fr_configuration: _Optional[int] = ..., member_concrete_design_seismic_configuration: _Optional[int] = ..., member_steel_design_uls_configuration: _Optional[int] = ..., member_steel_design_sls_configuration: _Optional[int] = ..., member_steel_design_fr_configuration: _Optional[int] = ..., member_timber_design_uls_configuration: _Optional[int] = ..., member_timber_design_sls_configuration: _Optional[int] = ..., member_timber_design_fr_configuration: _Optional[int] = ..., end_modifications_member_start_extension: _Optional[float] = ..., end_modifications_member_start_slope_y: _Optional[float] = ..., end_modifications_member_start_slope_z: _Optional[float] = ..., end_modifications_member_end_extension: _Optional[float] = ..., end_modifications_member_end_slope_y: _Optional[float] = ..., end_modifications_member_end_slope_z: _Optional[float] = ..., has_any_end_modifications: bool = ..., deflection_check_direction: _Optional[_Union[MemberRepresentative.DeflectionCheckDirection, str]] = ..., deflection_check_displacement_reference: _Optional[_Union[MemberRepresentative.DeflectionCheckDisplacementReference, str]] = ..., design_support_on_member_start: _Optional[int] = ..., design_support_on_member_end: _Optional[int] = ..., design_supports_on_internal_nodes: _Optional[_Union[MemberRepresentative.DesignSupportsOnInternalNodesTable, _Mapping]] = ..., is_generated: bool = ..., generating_object_info: _Optional[str] = ..., deflection_segments_defined_length_y_axis_enabled: bool = ..., deflection_segments_defined_length_z_axis_enabled: bool = ..., deflection_segments_y_axis: _Optional[_Union[MemberRepresentative.DeflectionSegmentsYAxisTable, _Mapping]] = ..., deflection_segments_z_axis: _Optional[_Union[MemberRepresentative.DeflectionSegmentsZAxisTable, _Mapping]] = ..., concrete_longitudinal_reinforcement_span: _Optional[_Union[MemberRepresentative.ConcreteLongitudinalReinforcementSpanTable, _Mapping]] = ..., concrete_shear_reinforcement_span: _Optional[_Union[MemberRepresentative.ConcreteShearReinforcementSpanTable, _Mapping]] = ..., design_properties_via_member: bool = ..., design_properties_via_parent_member_set: bool = ..., design_properties_parent_member_set: _Optional[int] = ..., id_for_export_import: _Optional[str] = ..., metadata_for_export_import: _Optional[str] = ...) -> None: ...
