from typing import List
from .tools import motifs
from .tools import pssm_matrix


default_train_motifs = [
'LEVLFLHGNQLENDPY',
'VTYLNLTHTGLQGTLT',
'LQIFSIGGCHIKGSIP',
'LKLLHLHHNFVRGTIP',
'LITMNFSANRLFGNLP',
'LNVIKLQHNQFNGPVP',
'LNELQLGDNHITGFLP',
'IDRLLLNENKLEGSIP',
'LALLTFHANNLTGPIP',
'LLELYLNDNMLSSPIP',
'ISHLYLGNNRLFGELP',
'IKVMYLGFNSLTGSIP',
'LETIHLGNNLLHGSIP',
'LRGLDLRSNGLSGQLP',
'LRVLALRNNSLQGSIP',
'LEEIHLSSNRLHGSIP',
'LQVLRVSQNQLEGKIP',
'LLEVDLSGNSFSGLLP',
'LLFLNLSFNGFEGPIP',
'LRCLDLSRNSLSGNLP',
'LENLDLSLNSFQGTIP',
'LKYMDISSNKLSGEIP',
'LQRLILSYNRLEGSIP',
'LENLNLGGNQLSGPIP',
'LQTLILDDNILNDIFP',
'IVTLALRNNTFSANIP',
'LQALSLVSLGLWGEIP',
'LEVLDLGENNLGPQFP',
'IQYLNLAGNKLTGSLV',
'LKRLDLSFNKLVGPIL',
'LQVLNMSSNFLYGGIP',
'LSVLSLSDNSIHGLIP',
'LRLLNLSRNSLSGNVP',
'LEYLDISDNLLTGKLP',
'VANISLQGKGLSGSVP',
'LNVLALQHNHLRGAIP',
'LQALELCCNQLTGSIP',
'LNVLDVRNNTLSGNVP',
'LTGLYLHYNSLTGPIP',
'LTDLYLNVNSLSGSIP',
'LTRLDLSFNLLFGSIP',
'IMELNFSGRVLGGLFP',
'LRTLKLGGNWFHGDFP',
'IRKLILSTCGLVGQIP',
'LQYFLALNNKFSGGLP',
'LLRFRVSNNSLSGKIV',
'LASLQLYNNCLTGKIP',
'LNLLLLQKNNLVGAIP',
'ISIIDLAFNGFEGSIP',
'PNSLDFSNNRLSGTVP',
'FILLDVSENQLSGQLP',
'LMGLSLYENYLTGELP',
'LEELNLTMNHFSGQLP',
'LSELYLQNNQFSSEIP',
'LRDLDISVNKLTGNIP',
'LQDLELSGNHLVGQIP',
'LQLLELYYNQLSGSIP',
'LNVLNLSNNLLTGKVP',
'LKVLDLSYNQFSGEFP',
'LVKLDLSGNLLNGSIP',
'LEVLNFNMIPKFFMRE',
'VVQVILASKGLSGTLS',
'LNTLGLQGNDITGNIP',
'LIELQLAFNDLSGKIP',
'LQILILSENNFNGSIP',
'LTHLDLGNNYLSGDIP',
'VTQIRLENQKLRGRID',
'LQSLDISNNNFSGYTD',
'MTHLNLSNNRLRGRIP',
'LQVLNLAGNYIEGNIP',
'LTTLILTKNFNGERIP',
'PPALYLSNNRLNGMIW',
'LSLLSLSNNSFQNISR',
'VKKLALRGLSLKGVIS',
'LKELSIPANNFFGRFS',
'LMVFALGNCGLWGEIP',
'LRELYMGFNALAGRLP',
'IRSLNISSNLFNGSLV',
'IQVMDLSENRFSGELK',
'LVSLVIFGNRFFGPLP',
'IKVVDLRNNSLSGTID',
'LFYLDVSNNSLTREVP',
'LEVLDLSYNMLRGSVL',
'LSKFSVAHNYLEGEIP',
'LTVFNISSNSFTGPIV',
'LEQLIAHSNSFTGTLP',
'LKTLSLARNNLVGQVP',
'LSSLDLATNRFNGELP',
'LQYLILSFNLLEGELP',
'LHILDLSRNNITGTIP',
'LQVLDLSWNRLSGGIP',
'LELLDLSYNELNGSIP',
'FSNSSFEGNLGLCGSP',
'LQLLLLHTNSLGSYSS',
'VTHLELGRLQLGGVIS',
'IWSLQLVANDFSGVFP',
'LKLLGIGYNHFSGSLR',
'MENLYLQGNSFYGDIP',
'ILSFNMGGNYFTGSIP',
'LLNLRLDSNHLGGDVP',
'LLELWIRDNKLNGTIP',
'LETLGIGQNRLGGDLP',
'LEYLDMGINFLRGPIP',
'LVQLNLYGNNMRGKIP',
'LITLDLGGTLISGRIP',
'LLRLDMSRNSLFGSLP',
'LEYLNLSVNNFEGNVP',
'LERLGMNENNLTGSIP',
'LQKLILDENMLSGPLP',
'LGTLSVGNNKLSGKLP',
'VKEVDFSNNNLSGSIP',
'LETLDLSNNSFEGIVP',
'LVSLDLYENFFSGTIP',
'LQQLALSHNNLEGEIP',
'LRYLSLFSNRLSGEIP',
'VTSLVLSGRRLSGYIP',
'LIKLDLARNNFSKPLP',
'FVSLDLGHNNLTGKIP',
'LTHIDFSSNLLNGSLP',
'VGTLNLSYNRFSGEIP',
'LRYIDLSHNSISGPIP',
'LQFLYLSYNHFISHNN',
'VIELDISGKDLGGEIS',
'LVQIHLDQNRIHGSIP',
'LKHLNFSFNLFSGNVS',
'LEELELAGNSLGGEIS',
'LKWMDLESNLLTGELP',
'LRFLLLWSNKLTGTVP',
'KLYLNLSSNHLSGPIP',
'LRRLLLYGNHLSGTVP',
'VLSVDLSSNELSGKIP',
'LKQLSLSENLLQGDIP',
'LEHLNLSRNSFSSTLP',
'LKELDVSSNRLNGAIP',
'LTVLDLSRNFFVGKIP',
'LERVYLSNNHLTGEIP',
'LGLLDVSRNKLSGSIP',
'LEILDLSHNNLSGNIP',
'LVYLDLGSNRLTGSIP',
'LTLLNLSSNLLSGPIP',
'LQYIDLSNNSLTGEIP',
'LKHLNLAWNRFNRGMF',
'LKTLSLAGNKIHGRDT',
'LQSLDLSNNKISALPS',
'LRVLNLDHNVFQMSIP',
'VIVLIASGMSLSGQIP',
'ISSLNISGNQFEGSVT',
'LEVADLSKNRFQGHIS',
'LIYLDLSENELSGDIF',
'LEYLNLSNTNLYGHIP',
'LVSIDLSSNQLEGFLP',
'LKNLNLSFNKISGSFP',
'LVAIDVSRNNLSGEIP',
'LSTLDVSGNHLSGHIP',
'LESLDISHNNFSGAIP',
'VISLNIGGFKLTGVIS',
'MVFFQIALNSFSGGFP',
'LSTVDLSSNQLGHGVP',
'MEFLYMQGNSFDGAIP',
'LLDLWIDTNRLNGTIP',
'LEFLSLADNSFSGNLR',
'LQKLDFAYNQMGGEIP',
'LRFLNLGDNSFGSTIP',
'LQKLHLNSNSFHGRIP',
'LVGLGASYNKLSGQIP',
'LQELSMETNKLSGELP',
'LAYIDLSNNFLTGHFP',
'LQYLNMSYNLLQGRIP',
'LRWLLLGSNQFTGAIP',
'LEHLDVGYNRLGGELP',
'LTSLFLGQNLISGTIP',
'LRNLNLSMNNFEGSVP',
'LQVVDLYSNAISGEIP',
'LAILDLSKNNLTGNFP',
'LEWFDISSNYLTGSIP',
'LTNVDFSNNNLSGRIP',
'IIAINLDRRGLSGELK',
'LRSLDLHKNEIWGDVG',
'VEFVDLSCNRFHGGLS',
'CLVIDLSGNTFSGDVS',
'LRHLNLSHNALNGKFF',
'MVGFNVSYNDLSGIIP',
'LRILKLARNQLFGLVP',
'LRNLSLSGNSFSGRVV',
'LSVLSIRNNSVSGSLP',
'MELLDLSTNSLTGMVP',
'FSVIDFSSNKFSGSIP',
'LEIVDLENNQINGELP',
'LNHLNLSSNKFEGGFP',
'LLFLDLSNNTFKGQIP',
'PDVLDLSSNNLSGSLP',
'LLELDLSRNGFTGSIS',
'LQHLDLSDNGFYGPIP',
'IRVLNLANNKLSGELP',
'LTMLNLSSNGLSGDLP',
'LRSLNLSMNNLEGPIP',
'VTSLTLSDMNFSGTLS',
'LKTLTLKGNGITGEIP',
'LLNLLLDSNSLSGQIP',
'LQFLTLSRNKLNGTIP',
'LTSLDLEDNQLTGRIP',
'VYSLSLPSLSLKGHLS',
'LKNFGAPSCFFKGPLP',
'LSILNLVSAELIGLIP',
'LMEFSASYNRLEGYLP',
'LAKLDLSYNPLKCSIP',
'LLTFSAERNQLSGSLP',
'LSDLYMGLNSFSGQIP',
'HGIFDLSYNRLSGSIP',
'LVKLNLTKNKLDGSVP',
'LVGLYIEQNKFTGEIP',
'LVELVLTNNQINGSIP',
'LMAVDLDSNNFTGEIP',
'LEFLNLAKNNLRGEVP',
'LTHMDLSFNNLSGELS',
'LEEIDLSGNLLSGTIE',
'LQGLNLANNQLNGYIP',
'LSVLNLNSNKLQGKIP',
'LTRLVLSDNQLKGEIP',
'LQCLVLSYNNLSGSIP',
'LDSLLLANNRFSGEIP',
'LKTLMLSFNSLSGSLP',
'LKELRLAGNQFSGKIP',
'LVEILLSNNHLSGEIP',
'LTTLDLGNNNLQGQIP',
'LKHLSLASNLLTGSIP',
'LLYLDLSDNHFSGSLP',
'LEYLDVSENLLSGEIP',
'LQTLDLSGNSLTGLLP',
'LSVLDLSENSLSGQIP',
'LTILDLSGNALTGSIP',
'LSSLDVSNNSLSGEIP',
'VTALHLPGASLLGVIP',
'LQILSLRSNGLRGPFP',
'LKAISLSNNRFSGPLP',
'LHRLNFSNNNLTGSIP',
'LVSLNLAKNSFSGEIP',
'LTVLDLSGNRFNGSIP',
'VVSLSIPKKKLVGYLP',
'KVYVNLAYNNLSGPIP',
'QGTLDLSHNSFSGSIP',
'LRHLNLRSNELSGNLP',
'LQSLVLYGNFLSGSIP',
'LQKLDLSSNNLNGLVP',
'LRSFDLSQNNLTGSVP',
'LQILDFSRNSLNGSIP',
'LKHLNFSTNKFSSSPG',
'LESLDVSNNRLSSIPD',
'LRRFAANRNQFTGRIP',
'LAVLDFSHNVLSGNIG',
'QISLNLSYNLFEGSIP',
'LIELQLGQNQLRGRIP',
'LNLLNLAMNEFTGNLP',
'LENLDLSFNKLAESIP',
'LVSVDLSFNHLVGWIP',
'LTYLEMDNNSLTGNIP',
'LQVIKLQENKLTGEIP',
'LVRLRLGSNKLTGKVP',
'LSSMNLQGNNLSGTIP',
'LLILNISWNSLSGSIP',
'LEKLEVSDNGLSGTIP',
'LESLLLSNNYLSGLIP',
'LTQLILSNNQLTGNIP',
'LRSLNLSFNSLTGSVP',
'LKLIDLSDNQLSGSIP',
'LEVLDLSNNKFSGEIP',
'VISLSLSNFDLSNSSF',
'VSEIQLKGMDLQGSLP',
'VQTIAIYTSLLSGPIP',
'AISLNLSCNGFVGEIP',
'LGVLDISHNQLTGNLI',
'LTMFFAWQNKLTGSIP',
'LQSLLLWQNNLVGKMP',
'LVMLGLAETSLSGRLP',
'LYRLRLNGNRIAGSIP',
'LTKLLLLSNDLSGFIP',
'LEFLDLHSNSLSGSLL',
'LTSLTLSSLNLTGVIP',
'LNFVDISENRLVGTIP',
'LTHLEIDNNLISGEIP',
'LKTLSLNTNNLEGRIP',
'LLELMLFDNKLSGEIP',
'LVSLNVSFNDFSGDLP',
'LWLIDLSENLLTGNIP',
'LQELQLSVNQISGTIP',
'LQNLYLYQNSISGSIP',
'LKFIDFSDNSLSGPLP',
'LQLLNLGENAFSGEIP',
'LTKLNLAKNRFSGEIP',
'LQAIDLSYNSLSGSIP',
'LELLDLSDNSLSGDIP',
'LQVFRAGGNKNLRGEL',
'LLSLQLPSANLTGSLP',
'LVSFKIHGNNLSGVLP',
'LSDVDLSGNALAGVLP',
'LKSLDLSSNVFEGLVP',
'LQSVFLNINSLSGSIP',
'LESLNLSHNNFSGMLP',
'LQVLDLGGNKFSGEFP',
'VSKLVLENLNLTGSLN',
'LYMLYVEDNLFSGSIP',
'LRVLSFKGNSLFGSIP',
'LRFFNVSNNHLSGHIP',
'LKSLYLNDNNFSGEFP',
'LKTVVLSGNRFSGKIP',
'VVSINLPYMQLGGIIS',
'LRAMYLRANFLQGGIP',
'LQRLALHQNSLHGIIP',
'LTILDLSSNTLKGPIP',
'LRSLNLSTNFFSGEIP',
'VVRLVIEDLYLGGRLV',
'LHTFNVSVNNLTGSVP',
'LIYLRLDSNRFNGAVP',
'LRVLSLKNTSLTGPLP',
'LKSLFLDHNSFSGSFP',
'LRTLDFSFNNLTGPIP',
'TRLELANNNQLEGSIP',
'VTAIDLSGYNISGGFP',
'LINITLSQNNLNGTID',
'VYQIELYDNRLSGKLP',
'LERLEMQENMLDGEIP',
'LQKIITFSNQLSGEIP',
'LVEFKIFNNSFTGTLP',
'LTELRLTHSNLVGEIP',
'IQVLILNVNNFSGKLP',
'LNYIRMADNKLSGEVP',
'LNQFNVSDNKLYGKIP',
'LISFNLNDNFFTGELP',
'LQVLNLNGNPLSGIVP',
'LSEIDVSTNRFTGELP',
'LSQLEISDNNFSGVIP',
'LAELNLSNNRLRGGIP',
'LRNFDVSQNNLTGELP',
'LRVLELESNLFTGEIP',
'LENLDLAMNGLTGEIP',
'LRVIDLSRNRFSGPLP',
'LNYLDLSNNQLTGEIP',
'LTRLDLAYISFDSGPI',
'IVRLVLSGVGLRGYFS',
'LTSLNLEFNRFNGTLP',
'LRVLSLENNSLFGPIP',
'LKSLFLSRNQFSGTFP',
'LTSFNVSGNNLTGVIP',
'LMILSLSRNNFSGSIP',
'VTRLDLGSANLSGELV',
'LVSLDLFANNISGPIP',
'LQYLELFNNNITGEIP',
'LDVLDISNNRLSGDIP',
'LRFLRLYNNSLSGEIP',
'IISLNLSASGLTGSLP',
'IQELDLSNNSLTGLVP',
'LSLLDLSGNNFTGSVP',
'LTTLVLTLNFHGEALP',
'LSYFSLSNSSLANISS',
'IRVVKLAVNYFAGNFT',
'PPTIELGHNNLSGPIW',
'LKFFLGQTNGFIGGIP',
'VIRLELGNKKLSGKLS',
'IRVLNLSRNFIKDSIP',
'LKVLVVANCRLTGSMP',
'LKNVNLARNTFHGQVP',
'LNLLGIQENRLSGSLS',
'LNLLNLRNNSLSGRLM',
'LHVFDLKWNALSGSIP',
'LEHLCLGMNDLTGNIP',
'LSKFSVAYNNLSGVIP',
'LNSLDLGTNRFNGRLP',
'LVRLDVSWNLFSGEIP',
'LQSFDLSSNKFNGSLP',
'LQLLDLSWNRLTGAIP',
'LQTLDLSSNDLSGGIP',
'LFYLDLSNNSFTGEIP',
'LEALDLSNNRLSGSIP',
'VEMLDLSGLQLRGNVT',
'LTYFEADKNNLSGEIV',
'QIALNLSFNHLHGSLP',
'LRVFTAYENDLVGEIP',
'LSSIRIGNNELVGVIP',
'LQYLLLDQNSIRGDIP',
'LIEVNFSNNLLNGPVP',
'LTLLNLAANGFAGTIP',
'LEEFQVSGNGLNGSIP',
'LRAFNISNNLLVGEIP',
'LKVLVLTQNRLTGELP',
'LLQLQLGRNYLTGTIP',
'LEFLDLSLNRFVGAIP',
'LELLNLHSNQLEGKIP',
'LQELILSGNSLFGEIP',
'LKHLDLSGNNFNGRIP',
'LNKLDLSNNRLNGTIP',
'LVSLDVSNNLLTGSIP',
'LEFVNLSGNNNLGGVI',
'VTSIDLNGFGLLGSFS',
'IRHLNVSGNSLVGELF',
'CAIIDLSNNKISGELS',
'LTNIGLSHNSLGGVLS',
'VEYVDISRNNFSGSLD',
'LKMFTVSANNLSGNVP',
'LTSLKAANNSLQGVLP',
'LKILRLQDNQLSASLP',
'LTDLDLSLNQLEGPIG',
'LKYLDLQGNSFSGEVM',
'LQNLSIANNQFSGTLS',
'LKYLDVSGNLFHGALP',
'VEIIRLSSNSLTGTLP',
'LEVFDASSNQLSGSVP',
'LISLDLSYNNFEGNIP',
'LKEIDLSHNQLSGVIP',
'LEKLNLSSNRLSGSLP',
'LTELNLSNNNFSGSLP',
'LKELKLAYNLFSPSQI',
'VVSVDLSSFMLVGPFP',
'IIEISGAENDFSGEIP',
'LHSLSLYNNSINGSLS',
'VEQIELFNNSFSGELP',
'LQVLWLAGCNLVGPIP',
'LEYLILIDNSFSGEIS',
'LKFLEISGNNLSDTIP',
'LKRFDASMNKLTGKIP',
'LSELKLFNNRLTGVLP',
'LESLNLFENMLEGPLP',
'LSNLRISKNRFSGSIP',
'LVNLDLTFNQLTGSIP',
'LTRVRLSNNKLSGQIP',
'LISLDLSENLLVGSIP',
'LSLLELSDNSFTGSIP',
'LESLNLAGNFLSGTIP',
'LNELNLANNHLSGEIP',
'LNVLNLSYNHLSGKIP',
'LQYVDLSYNRFSGEIP',
'LSRLDLSKNQLSGEIP',
'LNYLDLSSNQFSGEIP',
'LKFLNVSSNTLDFPGK',
'LKHLAISGNKISGDVD',
'LEVLDLSANSISGANV',
'LESLFLSNSHINGSVS',
'MMFLDMSYNMLSGYIP',
'LRDLKLWLNMLEGEIP',
'LEFLDVSSNNFSTGIP',
'LTGLDLSGNHFYGAVP',
'LIWLDLNTNLFNGTIP',
'LQHLDISGNKLSGDFS',
'LFILNLGHNDISGSIP',
'LLTLDLSSNNFSGPIL',
'LQELYLQNNGFTGKIP',
'LKLLNISSNQFVGPIP',
'LTSLDLSRNSLSGPVT',
'LETLILDFNDLTGEIP',
'LAILKLSNNSFSGNIP',
'LNILDLSSNKLDGRIP',
'LNWISLSNNRLTGEIP',
'LVSLHLSFNYLSGTIP',
'LQYLSLAENKFTGEIP',
'LESLALSSNNFSGELP',
'LKVLDLSFNEFSGELP',
'LTEIDLSNNNLSGPIP',
'VTSIDLSSKPLNVGFS',
'LWRFRLGQNFLTSKLP',
'LNYLNVSWNSFNQSLP',
'LEVLNISSNVFEGELE',
'ITRLDLSNLNISGTIS',
'LKILILFNNFLFGPLP',
'LLKIDMSRNNFSGKFP',
'LTSADFSHNNFSGSVP',
'LQLFNLFFNRLHGEIP',
'LEVLFLQTNELTGSVP',
'LVTLDAYDNSFNGSLP',
'LVHLDLANCSLKGSIP',
'LQILKLWHNNFTGKIP',
'LKFLSLSGNDLRGRIP',
'LIEIDLSTNKLTGLIP',
'LSLLELQNNFLTGEIP',
'LQILLLGANRLSGQIP',
'LEHLDLGGNYFDGEIP',
'LTYLDLSHNQISGQIP',
'LVFLDISSNSFSGELP',
'LKTLDLSNNFLEGEIP',
'LTQINLSNNRLSGPIP',
'LVQLYLGYYNDYRGGI',
'VSEIQLKGMDLQGSLP',
'VQTIAIYTSLLSGPIP',
'LTMFFAWQNKLTGNIP',
'AISLNLSCNRFVGEIP',
'LGVLDVSHNQLTGNLN',
'LVMLGLAETSLSGKLP',
'LKFIDFSDNALSSTLP',
'LEFLDLHTNSLSGSLL',
'LTKLLLLSNDLSGFIP',
'LYRLRLNGNRLAGSIP',
'LWLIDFSENLLTGTIP',
'LTSLTLSSLNLTGVIP',
'LKTLSLNTNNLEGHIP',
'LQSLLLWQNNLVGKIP',
'LTHLEIDNNLITGEIP',
'LNFVDISENRLVGSIP',
'LVSLNISYNDFSGDLP',
'LVELMLFDNKLSGEIP',
'LQELQLSVNQISGTIP',
'LQNLYLYQNSISGSIP',
'LQLLNLGENDFSGEIP',
'LTKLNLAKNRLSGEIP',
'LQAIDLSYNSLSGSIP',
'LELLDLSDNSLSGDIP',
'LQVLRAGGNKNLRGEL',
'LKHLNFSTNKFSTSPG',
'LESLDVSNNRLSSIPE',
'LAVLDFSHNVLSGNVG',
'LRRFAANRNRFTGEIP',
'QISLNLSYNLFEGSIP',
'LNLLNLAMNEFTGILP',
'LIELQLGQNQLRGRIP',
'LTYLEMDNNSLTGFIP',
'LSNMNLQGNNLNGTIP',
'LVSVDLSSNQLVGWIP',
'LQVIKLQQNKLTGEIP',
'LLILNISCNSLSGSIP',
'LVRLRLGSNKLTGSVP',
'LEKLEVSDNSLSGTIP',
'LESLLLSNNYLSGLIP',
'LTLIDLSDNQLNGSIP',
'LTQLILSNNQLTGNIP',
'LENLDLSFNSLAGSIP',
'LRSLNLSFNRLTGSVP',
'LEVLDLSNNNFSGEIP',
'VISLSLSNFDLSNSSF',
'VIRVDLGNADLSGQLV',
'LQYLELYSNNITGPVP',
'LVSLDLYLNSFTGPIP',
'LRFLRLNNNSLTGPIP',
'LQVLDLSNNRLSGSVP',
'IISLDLSTSGLTGEIL',
'LKLINLSGNELNGSIP',
'LEVLDLSNNSLTGSVP',
'LQNLYLQGNYFSSGGD',
'IVGLDLRNSGLTGTLN',
'LQVLDLSSNSISDYSM',
'MIYFDISYNAVSGFIP',
'LTFFSLSQNNLSGDKF',
'LVSVNISNNKLVGKLG',
'LQNLNLGNNYLSGDFL',
'ITYLYVAYNNISGSVP',
'LSDLVMWANNLTGTIP',
'IGVLDLSHNNLQGYLP',
'LTTVDLSYNILSDKIP',
'LEKILIANNYLSGTVP',
'LKYLDLTHNNLSGDFS',
'MIWISLSSNRLTGKIP',
'LAILQLGNNSLSGNVP',
'LIWLDLNSNNLTGDLP',
'LETLNISRNNLAGKIP',
'LQVLNLGHNRITGTIP',
'LRVLDLSSNGFTGNVP',
'LKTIDLSFNELTGPIP',
'LETLILNNNLLTGSIP',
'LKQLSLAHNRLSGEIP',
'LVILDLSGNTFSGELP',
'LSDLDVSNNNLTGPIP',
'VTALRLPGVALSGDIP',
'LRTLSLRLNALSGSLP',
'LVQFNVSNNSLNGSIP',
'LVRLNLASNSFTGEIS',
'LRHLYLQGNRFSGEIP',
'LKTLFLENNQLSGSIP',
'VASLNFTRSRVSGQLG',
'LDALVIVSGNLSGTIP',
'LTTLFVGNNSLQGPVR',
'LKIATLFNNSFYGAIP',
'IRRFILRENNLSGLLP',
'LSTLQIARNAFGGEIP',
'LNLLKLNDNQLVGGIP',
'LVELSMYANQFSGNIP',
'LERFDVGFNSLNGSVP',
'LGYMNLSRNLLEGSLP',
'LATLDLSENGFSDKIP',
'LLTLDLSYNEFEGGVP',
'LEEVDFIGNKLTGEIP',
'LTQLLVYQNNLTGELP',
'LQILYLHRNKLVGSLP',
'LEVLYLYINFLTGELP',
'LSFLDFNSNNFEGPIP',
'LRILNLGSNLLHGTIP',
'IYDLDLSGNGLTGEIP',
'LLHVDVSNNQFTGPIP',
'LTRLNISNNNLTGSLS',
'LSSINLSRNRFTGQIP',
'LTTLVLSENRFSGGIP',
'LESLELFENRFSGEIP',
'LQVLYLDYNNLTGPIP',
'LQILDLSTNNFSGTIP',
'LTILNLSENRLSGSIP',
'LLELSLSDTTGIKSFP',
'QSYIDLSYNNFSWSSS',
'ITELALKTMSLRGKLP',
'PKNIYLTGNLLSGNIE',
'LERVRICDNNFTGIIP',
'LKILDLSFNKLNGIVQ',
'LTSISVCANNLSGNLP',
'LKRLILRNVGLSGPIP',
'LQKLHLYASGLTGPIP',
'LKSIELCRNYLSGTIP',
'LTGLELASNKFTGILP',
'LTFLGVEGNQFSGPIP',
'LVVLSLGDNPFDATAD',
'VTEIDLSRRGLSGNFP',
'LEIIDIEMNNFEGPIT',
'FDFIDASENLLTGPIP',
'LQFLYLNNSAFSGVFP',
'LTYLDASTNLLQGDLS',
'LSWLYLSNCSIAGKIP',
'LGALYLGFNKLSDELP',
'LSDVNMAQNSISGEIP',
'MKALLLLQNNLTGSIP',
'LQRFRVSENNLNGTVP',
'LVSLQMFENEFSGEIP',
'LSSLKMQSNGFSGEIP',
'LRNLEISDSGLTGEIP',
'LWQLELYNNSLTGKLP',
'LTKVELNNNRFTGKIP',
'LVNLSLYTNKLTGSLP',
'LKYLDLGNNLFSGAFP',
'LEKLSLGFNSLSGIIP',
'LNALNLSDNKLSGRIP',
'LSLLDLSNNRLSGRIP',
'VEKIVLWNTSLAGTLT',
'LSHVDIGSNSFDGVAS',
'LEFVSVRRNLLSGDVF',
'LIGFDFSYNGITGLLP',
'LTYFNVSGNRFRGEIG',
'LSVIRLGDNFIDGKLP',
'LWKINVSSNALSGLVP',
'LRVLTLFGNRITGNLP',
'TKFVSLSHNNLSGSIP',
'LQVLNLHNLNLVGEIP',
'LEFLDASSNELTGNVP',
'LTHFNVSYNNLSGIIP',
'LRFLDLSKNAFFGEIP',
'LEILDLHRNRISGNIP',
'LKLLDLESNRLNGSVP',
'LLELDVSGNGLEGEIP',
'IQFLDLSENLLSGPIP',
'LTVLGLAETSVSGNLP',
'LETLSIYTTMISGEIP',
'LTLFFAWSNQLEGSIP',
'LSILDLSHNMLEGDLA',
'LQKLTISGANLTGTLP',
'INFLDFSSNRLHGKVP',
'LVQLQLDKNQISGLIP',
'LEQLFLWQNSLVGGIP',
'EIALNLSSNRLTGKIP',
'LEEFMISDNKFSGSIP',
'LTKLLLISNSLSGFIP',
'LVSLNISYNSFSGYLP',
'LVRLRLGFNRITGEIP',
'LKMIDLSLNLLSGSIP',
'LNKLILSKNLFSGSIP',
'LVDLFLYENSLSGSIP',
'LKSLILFDNLLTGSIP',
'LQMIDLSNNSLEGSLP',
'LETLILNSNQLTGKIP',
'LQVLDVSANQFSGKIP',
'LKVLDLSSNGLVGDIP',
'LQLLDLGSNELSGEIP',
'LQALDLSRNSLTGTIP',
'LEVIRIGGNKEISGQI',
'ITSLNLSSTGLTGNIA',
'LSFINLSKNNLNGSIP',
'LDKLDLSNNNLTGGVP',
'VTALRLPGSGLYGPLP',
'IRSLYFHENNFSGTIP',
'LRIISLRSNHLQGNIP',
'LKYLNLSFNNLNGSVP',
'LTDLSLQNNSLSGPIP',
'LVNLDLSANSLSGNIP',
'VVSLNLSSLNLGGEIS',
'TGKLYLHGNMLTGPIP',
'LQYLGLRGNMLTGTLS',
'IQMIDVSFNLLSGVIP',
'VATLSLQGNRLTGRIP',
'LWYFDVRGNNLTGTIP',
'LNQFNVHGNLLSGSIP',
'FQILDISYNQITGEIP',
'LNSLILNNNKLHGKIP',
'LQSIDLQGNKLAGQIP',
'LVNLNVSFNNLSGIVP',
'LSYLQLNDNKLVGTIP',
'LFELNLANNRLVGPIP',
'LETLNLKNNQLTGPVP',
'LKRLDLAGNHLTGEIS',
'LVYLDLSENLLYGDIP',
'LLILNLSRNHLSGQLP',
'LAVLDLSDNELVGPIP',
'LTYLNLSSNNFKGKIP',
'LDKLDLSGNNFSGSIP',
'VVSVSLLEKQLEGVLS',
'LQALRIYKNKLTSSIP',
'QLYLNFSNNLLTGTIP',
'LKHLKLASNNLKGHVP',
'LQMFVAAGNHLTGSIP',
'LQGLRMYSNDLEGPIP',
'LETLSVADNNLTGTLK',
'LVLIGFDYNNLTGKIP',
'IFYLDLRNNLLSGDVP',
'VFTLDFSQNNLSGHIP',
'LTHLGLSENHLVGPIS',
'LQSLVLTENLLEGDIP',
'LRNLSAHDNLLTGPIP',
'LNQLILYLNYFSGSIP',
'LTVLTVGFNNISGELP',
'LNILYLHSNGFTGRIP',
'LTFISIGRNHFTGEIP',
'LEVLTLHSNNFTGEFP',
'LNTFDISDNLLTGTIP',
'LVQLELYDNQLTGKIP',
'LTYLSLQGNKFNGSIP',
'LRILQVSYNSLTGPIP',
'LKLLDLSHNQMTGEIP',
'VQEIDLSNNLFSGSIP',
'IISLNLSRNSFSGEIP',
'LQVLDLTSNSFTGKIP',
'LTDLDLSGNQLTGKIP',
'LSVLDLSNNKFSGQIP',
'LVSLDLSSNNLTGEIP',
'VVILNLRDLSLQGTLA',
'LEILDLCDNNFGQPFP',
'LKSLILRNNSFSGKVP',
'VTSLDLGGFKLSGSIS',
'LRSLNLGDNSFQSNIP',
'LWRFRSQNNRLNGTIP',
'FYRIELQGNSLNGTIP',
'LQYLNLSTNFFHRKLP',
'LQIFSASFSNLIGEIP',
'LQHMEIGYNHFNGNIP',
'LKVFNAFSNNFEGLLP',
'LKFIHLAGNVLGGKLP',
'VISLDLSHRNLSGRIP',
'LYKLILFSNMFEGELP',
'ITTFNVSYNQLIGPIP',
'LEELNFGGSYFEGEIP',
'LTTLDISRNSFDSSFP',
'LLCLNLSQNHLNGIIP',
'IADVDLSHNLLTGTIP',
'LTFVDLSNNRFTDQIP',
'LKYFDVSNCSLSGSLP',
'LTTLFLWNNNFTGVLP',
'LTWLSLISNNLSGEVP',
'LETLFLFQNGFTGEIP',
'LETMDVSNNSFTGTIP',
'LLYLNLSGNSLEGSFP',
'LKLLDFSSNQLSGSIP',
'VVQLRLPGVGLVGAIP',
'LRSMFLQNNLISGAIP',
'LQVLSLRSNRIFGAIP',
'LRAVRLEGNRLSGKIP',
'LTAFNVSDNNLNGSIP',
'LERLVLSHNNLSGPIP',
'VTELQLLKMNLSGTLA',
'LKILQADNNNFSGSSI',
'LLKLSLRNCSLQGVIP',
'LQFLSIEGNRLDGAVP',
'LNRLQIDENQISGPIP',
'MRHLHLNNNSLSGQIP',
'LKLITLNGNQLSGTLP',
'ITTIDLSHNFLNGTIP',
'LLHLLVDSNNLSGPLP',
'LKTLDFMWNNLTGSIP',
'LGYLDLSWNQLTGSIP',
'LSSLSLKNNNFTGSLR',
'LAELDVSGNRLKGHIP',
'LVTLNLARNSFVGPVP',
'LKLLYLSGNGFSGPFP',
'LRRLDLSGNRFSGTIP',
'LQFLSLTVNAFTNISG',
'VTRVSLPGRGLGGKIS',
'VRLMVVENCDLSGQIP',
'MTALRVAGNELSGQLA',
'LQQLSLPSNQIQGRLD',
'LAVLDFSLNAFGGAIS',
'LRYLDLRSNSFVGDLG',
'LAVFDVASNNFTGTMP',
'LSSFNVAHNDFEGPIP',
'AAVIDVSYNRLSGSLP',
'AATLNLSDNYFSGAIP',
'LVSLNASNNSFGGPVP',
'LRVLSAGRNNLTGELP',
'LVKLDLTYNALTGELP',
'LTHLNLSGNSLAGPFP',
'LQVLDLSHNNLSGGIT',
'LYYIDLSDNHLSGEIP',
'LEELRLGKNNLTGTIP',
'LQVLDVSSNHLSGPFP',
'LEILDLRRNSLTGPIP',
'LNVLNLAGNRLTGPIP',
'LAALLVSYNFYGEAMP',
'LVTLKAEHNGFHGGLR',
'VRRFNVSMNMLAGEIP',
'LRHLLLSHNDLTGPLN',
'LRVLAVRGNSLSGPLP',
'VAMLRLPGRALAGDVP',
'LQNVILNGNKLSGDFP',
'LHTLSLRFNALSGSLP',
'LKVLLLNNNRFVGQIP',
'LQQFNVSFNQLNGSIP',
'LVRLALDGNDLSGPIP',
'VTGLTLPSLNLTGKVP',
'WVEFDVSTNRLTGQIS',
'LYDIVVFNNDFSGQLP',
'LTYLWMSNMNVTGEIP',
'FNLLNMSSNQLIGEVP',
'LHVFKAENNLLSGELP',
'LNNLMMYNNRFSGEFP',
'LKSLLLDTNQFTGSYP',
'LTTLMIQNNGFTGALP',
'LQLVYLFTNGLNGELP',
'LTRIEMGNNKFSGSFP',
'LGNLEVCNNNLSGPLP',
'LKDIRLFENKLSGELP',
'LRFLDLSYNAFDGALP',
'LNSLNMSGNRISGAIP',
'MEHLNLSNNHFSGVLP',
'LTLLFLYKNQLTGTIP',
'LSDLLIAGNRLSGSIP',
'LARLDLSSNKLSGAFP',
'LTLLDLSHNELTGAIP',
'LTVLGLSTNNLTGEIP',
'LQQLTLALNAFEPAPA',
'LVRVRLEQNKLEGDIS',
'LHALLLQGNQIRGSIP',
'LENLELYENTLTGSSP',
'LHFLELSGNQISSEIP',
'LTTLYLHGNQLAGHIP',
'LSTLYLSHNQLSSHIP',
'LTTLYIWGNKLSGHIP',
'LTTLYIWGNKLSGHIP',
'LVDLELNGNILTGSIP',
'LADLELSNNTLTGAIP',
'LTTLYLHDNQLSGHIP',
'LVDLELNGNTLTGSIP',
'LTTLYLYENQLSGHIP',
'LEELGLSDNTLTGAIP',
'LSILDLSNNKISSSIP',
'LTTLYLYNNQLSGHIP',
'LEVLGLGNNSITGSIP',
'LEVLGLGNNSITGSIP',
'LASLDLSSNELDGSIP',
'LVNLNLSGNHLTGPIP',
'VVALRFHSANLLGPVS',
'ERYIHGHKNAFSGRLP',
'TSLLQLCYNFFDGVVP',
'SLSISIDHNRFHGQIP',
'LQNLFLQNNILTSTIP',
'LMMLDLKRNHLQGEIP',
'LEVLEMGANKLEGVLP',
'LVVINAESNKLTGAIP',
'LMHLSLSGNEISGIIP',
'LLWLSLGYNNLSGAVP',
'LRELDLGDNHLAGLIP',
'SVNLDLSHNNLEGSIP',
'LRHLALSTNMLSGAIP',
'LNYLNLSFNSFIGEVP',
'LQELNLSVNSLHGSIP',
'MEYLSLGGNRLSGEIP',
'LLALDLSGNSFTGPIP',
'LQNLDLSNNSFTGTLP',
'LENLDLSGNNLSGQIP',
'ILEIEAGALGIGGLLP',
'VTKLALNDMNISGTIP',
'LYLLDVENNRLADELP',
'MSHLNLELNKIEGPIP',
'VQVIDLSWNNFTGPIS',
'LKHVNLSYNNFIGDVP',
'ITLMNLSSNQLNGTVP',
'VFVLNLFSNRLTGKLP',
'IVSLNLSCNRISGELP',
'LFYLRLRENRLSGPIP',
'LGLVDFANNNLSGEIP',
'LENLYLQSNRLSGAIP',
'LGVLNLGRNQLSGGIP',
'LRSLDMSSNFLTGQIP',
'LEVLDLSHNSLRGDLP',
'LQNLDVSDNSLTGQIP',
'LGELDLSGNALSGSIP',
'LLHLDLSDNRLTGEIP',
'LERLSLSNNNLTGEIP',
'LVYLHLSNNDRFLSHD',
'LIGLRLVRHNLSGKFD',
'LHTINLRHNAFAGPLP',
'LLELHLDHNRIDGPVP',
'LRALYLSHNAFSGPVP',
'LRLFNVSHNRLTGSLP',
'LKKLYLDNNELTGPLP',
'VIRVDLGNAQLSGALV',
'LVSLDLYLNNFTGVIP',
'LQYLELYSNNISGTIP',
'LRFLRLNNNSLSGQIP',
'LQVLDLSNNNLSGEVP',
'VISLKLSNASLKGFIA',
'LTVGDFSYNFLAGKIP',
'SSVIKLHSNGLTGSIP',
'LQELYLDHNLLFGTIP',
'VRVLDLSVNRLAGPIP',
'LVELRLDRNRLKGSIP',
'VTSIQLLESQLEGTLT',
'MWALGLEANNLTGQIP',
'LSNASMAFNGFSGSLP',
'QMYLNLSHNAFTGTIP',
'LEGLILTVNTFTGVIP',
'LKALRVYDNALSSTIP',
'LTTLNVSGNDFHGEIL',
'LEIFQAYINSLSGELP',
'LQTVDVSRNAFEGRVP',
'LIGLTLGRNKFSGRVP',
'LQVLDLTSNAFFGLIP',
'VQAIDLSNNELSGGVP',
'LLALGLSMNELTGNIP',
'LQSLTLHENRLTGTVP',
'LRELNLSWNRFEGPVP',
'LRTLNLAENNLTGRLS',
'LMRLSFSDNSLSGPLP',
'LTLLNIYSNRFTGAIP',
'LKILQLFENRFSGKIP',
'LSLLDLSHNMLNGTVP',
'LRLLQLQGNALSGSIP',
'LQVLDLLQNRLSGALP',
'LQVLIIHGNSLSGPIP',
'LVFLSLGDNSLEGTIP',
'LTVLTLASNRFTGPIP',
'LYTLDISSNSLTGELP',
'LLKLDLSHNRLSGAIP',
'LTTLDLSGNQLSGRVP',
'LQILDLSNNSLHGTIP',
'VSAVNLSGSGLSGALA',
'IVRVDLTGNRFHGAIP',
'LQMFSAADNGFTGRIP',
'SKTLNISNNRLSSQIP',
'LAILDLGDNLFDGGFP',
'LQNLLLDRNNFTSAIP',
'LLELQLGDNYFEGAIP',
'LTVLYLPDNEISGEVP',
'LEELVVSNNWFTGSVP',
'LQKLYLFNNLLHGPVP',
'LYRLKLNNNQISGSLP',
'LSEITLYSNSFTGELP',
'LSYVDMSGNRLEGRIP',
'LLYLSLFSNKLAGELP',
'LVTLRMSSNMLTGLIP',
'LVCLDLGNNLLNGSLP',
'LTELVLAFNLLSGTVP',
'LLVVNLSFNELSGQLP',
'LRKLDLNTNALTGDIP',
'LQKLYLGDNAFTGELP',
'LTMLYLNGNRFTGSIP',
'LVDLELQNNSLSGTIP',
'LTMLDLSGNNLLGPIP',
'LAALDLSRNSLTGPVP',
'LEVLDLSENSLYGPIP',
'LEYLDLSANSFSGEIP',
'LTYLDLSNNNLSGPIP',
'VAHLNLSYYGVSGSIG',
'MVRVRLQNNSLIGVVP',
'LIEIDFTNNIFVGGIP',
'MASLDWSKNKLAGPIP',
'SIALNLSSNGLMGDIP',
'LIELQLGGNVLGGNLP',
'LEILDLSHNSLNGSAL',
'LENVLLYRNNLSGWLP',
'MSKLRLQENKFSGGIP',
'LRLLHVSRNSFTGDIS',
'LQYVKLFDNLFTGVIP',
'LESLELDANHLEGTVP',
'LASLDLSFNNLSGGLD',
'LKRLFLFENHLTGEFP',
'LSILVLTKNSLTGPIP',
'LNFIDLSHNFLSGHIP',
'LEEFALSSNQISGKIP',
'LTTLGFYNNSLSGKIP',
'LEQINLSRNNISGLIP',
'LEVLILGNNFLNGTIP',
'LYVLNLSFNRFSGPVP',
'LSQLYLSGNQLNGSLP',
'LTLLDLSNNSLSGGIP',
'LRHMNLAFNKLSLGNL',
'LSAIDLSNNRFSRLNF',
'VVAFAAAGMGLSGPVP',
'LRSLDLSGNRLTALPN',
'LEYVNLSSTELHEQIP',
'LMYLDLSSNELVGEFG',
'LRGLNLSRNAIRGALP',
'LRVLDASHNQFQGQVP',
'LVSMDLSSNALDGDLP',
'LKVLDLSKNNVSGVVP',
'LQVLDVSRNGFSGPLP',
'LRVLDLSVNNLTGEIP',
'VMGLQLENMGLSGKLD',
'LRTLSFMDNHFAGPMP',
'LRAVFFSGNGFSGQIP',
'LLELRLNDNGFQGKIP',
'LKKVYLGNNSFFGPIP',
'LKVVDVANNDLEGEIP',
'VTQLKLPGLELSGTLG',
'LKYLNLGHNQFKGQVA',
'LQRLNLANNQFTGAAQ',
'LKSLYLQNNQFSGTLN',
'LTTLDFSFNSFTLSLP',
'LETLNIANNDFTGWIP',
'LTELDLSSNNLGGDLP',
'ATHLNMAYNNLTQSLL',
'IVALQLRGLSLLGSLG',
'LNSLYLQHNRFTGSII',
'LTDLNIEDNQFSGIFP',
'LKNMDVSFNNLQGDIP',
'LLSLNLSHNSLSGPLA',
'IKEMDLSFNNLTGDLP',
'LSILDISHNMLEGDLA',
'LTVLGLAETSVSGNLP',
'LQTLSIYTTMISGEIP',
'LQKLTISGANITGTIP',
'LTLFFAWSNQLEGSIP',
'LVQLQLDKNQISGLIP',
'LEQLFLWQNSLVGGIP',
'EIALNLSSNRLSGKIP',
'LEEFMISDNNFSGSIP',
'LVDIFLYENSLSGSIP',
'LNKLILGKNLFSGSIP',
'LKSLILFDNLLTGGIP',
'LVSLNISYNSFSGYLP',
'LNFLDLSSNRLHGKVP',
'LVRLRLGFNRITGEIP',
'LQMIDLSNNSLQGSLP',
'LKMIDLSLNLLSGSIP',
'LTKLLLISNSLSGSIP',
'LETLILNSNQLTGRIP',
'LQVLDVSANQLSGKIP',
'LQALDLSRNALTGTIP',
'LTVLDLSSNSLVGDIP',
'LQLLDLGSNELSGEIP',
'LEEIRIGGNKELSGKI',
'VTSLVLPNKHLLGSIA',
'NATVDLSFNNLTGPIP',
'LTAVSLSKNSFSGDIP',
'LSVISLGSNNLSGDLP',
'VEVLDLSSNLLNGSLP',
'LQLLNLSANAFTGKIP',
'LRILDLSSNFFNGSLP',
'LHYLSLSHNKLSGEIP',
'VKVLTLVSLGLWGRLP',
'LVTLILSKNMFRSAVS',
'LQVLDLESNSFGPMFP',
'ITYLNISHNKLTGRLS',
'LAVLSLRKNAFNGSLP',
'LQTLILDENMFSGLVP',
'LEILNVSSNFLFGSLP',
'LQRLDLSFNTFVGPFP',
'LRVLALANNRFSGALP',
'LISVDLSSNLLTGSLP',
'ITYLNLTSSGLKGFIA',
'LMLINLSKNNLIGFIP',
'LEKLDLSNNNLTGEIP',
'VTALRLPGFALSGNIP',
'LKTLYLENNKLSGSLL',
'LRTLSLRLNALTGSLP',
'LDQFNVSNNSLNGSIP',
'LVRLDLGENEFTGEIS',
'LRRLYLQGNRFSGEIP',
'IISLNLTGSNLTGTIT',
'LRELDLSNNGLSGEIP',
'VTGLSLPSLSLRGPLT',
'LLELNVSYNELHGKVT',
'ILTIRLQDNELTGRIP',
'LRLLDLHDNRLNGTVS',
'MIRLDLSDNNIRGVIP',
'LRLVYLAGNDISGEIP',
'ITALKVYAIDVVGPIP',
'MEWMSFGINALYGPLP',
'LEDVLLNDVDLTGQVP',
'LIKIYIGNTGLAGEIP',
'LSKLVFRNSNLTGTIP',
'LTILRIQGTSLSGPIP',
'LTNLNLGKNYLTGSLS',
'LKSLAIGVNNFSGSIP',
'LTNLFLGNNTLNGSLP',
'LSNIDVSYNDLSGSLP',
'LQHVDLSFNKLHGPIP',
'LRELSLGDIPNGSISL',
'VTGIRLSNKGFAGSLP',
'LQVFEITGNQISGIIP',
'LQVVSLSSNLLQGPTP',
'LLLIDLSYNHLAGTIP',
'LRLLDVSYNQLHGKLP',
'IISLNLSASGLTGEIL',
'LKVINLSNNELNGSIP',
'LEVLDLSNNTLTGSVP',
'VLSLLLQNNYITGHIP',
'LKTLDLSTNNFTGQIP',
'LISVSLKNNSFRSKLS',
'LNTLYLTSLGISGPLS',
'LKSLVLTDNLLNGSVF',
'LQELDLGGNNLGPELP',
'LQTLSFAQNMFSGSLP',
'VRTLDVSHNLLTGKLP',
'LQSLNLSSNFISGSIP',
'LQSLDLSSNEFTGSIP',
'VTSVDLSNANLAGPFP',
'LQVLWLTECNLIGEIP',
'VSLLELINNSFSGEIS',
'LSHLSFSNNSITSDLP',
'LYDLRIFGNRLTGALP',
'VIQIELYNNSLTGAIP',
'LTRVRLAYNRFTGRVP',
'LSMLVLTNNEFTGSLP',
'LEELLVINNSLSGVLP',
'LEALSLISNLLDGTIP',
'LGTLDLHGNRFTGELS',
'LESLILYENDLEGELP',
'LNRIDVSENEFSGELP',
'LKTLDLSQCLFTGKIP',
'LVNLDLALNNLVGPIP',
'LNELNLADNEFSGKIP',
'LRLLDASMNRLTGSIP',
'LSELSASGNKLSGSLP',
'LNQLNLSNNRLTGDVP',
'LNYLDLSGNLFSGEIP',
'LTSLDLSGNNFSGDIP',
'LKMLNLSYNPFAPGRI',
'ITRLDISNLNIYGTLS',
'LNYLNVSWNFLNQSLP',
'LQVFNLFFNRLHGEIH',
'LWLLELQNNFLTGEIE',
'LWKFRLGQNFLTGKLP',
'LEVLNISNNAFEGELK',
'LLKIDMSMNSLSGKVP',
'LKILILFNNFLFGSLP',
'LVLLDLANCSLRGSVP',
'LVTLDAYNNNFKGSLP',
'LTSADFSHNNFSGSVP',
'LEILKLWHNNFTGKIP',
'LEVLFLQINELTGSIP',
'LGYLNLGGNYFNGEIP',
'LVEIDLSTNKLTGLIP',
'LQILLLGGNRFTGQIP',
'LKHLDLSGNDLSGRIP',
'LSQINLSNNRLSGPIP',
'LTYLDLSHNQLSGQIP',
'LKTLDLSYNSLEGEIP',
'LEKLYLGYDNDFHGIP',
'VTALRLPGAGLFGSLP',
'VIRINLGENRFSGRIP',
'LQQFNVSSNQLNGSVP',
'LRYLYLQGNAFSGEIP',
'LVTLYLEKNQLTGSIP',
'LQTLSLRFNSLSGPIP',
'VSNISLQGKGLSGKLS',
'LTGLFLHYNALVGDIP',
'LSVLALQSNKLSGAIP',
'LRVLDIRNNSLSGNVP',
'LTDLYLNVNNLSGEIP',
'LERLDLSYNHLFGSVP',
'LQVLQLCYNNLTGSIP',
'VSGIHVTRLGLSGTIS',
'LKRLFLDHNQFVGKIP',
'LKSIMLSNNTFSGEIP',
'LKTVRLDNNLLSGPLP',
'LEELHLQDNKFSGEIP',
'LKSLDLSNNQLEGEVP',
'VTALRLPGVALSGQIP',
'LKTLYLENNKLSGPLV',
'LRTLSLRLNALTGTLP',
'LDQFNVSNNLLNGSIP',
'LVRLDLGDNGFSGEIS',
'LRRLYLQGNRFSGEIP',
'VTSINLDRLGLSGELK',
'LRSLDLHGNDVYGDVT',
'CLVIDLSGNTFSGDVS',
'LRHLNLSHNELNGGFF',
'VEFVDLSSNRFHGGLS',
'MVRFNVSYNDLSGVVP',
'LRNLTLSGNRFSGRVV',
'LRILRLARNQLFGAVP',
'LTVLNIRNNSVSGSLP',
'FSVIDLSSNKFSGAIP',
'PEFLDLSSNSLSGALP',
'LNYLNLSANKFSGGFP',
'LEVLDLENNEINGELP',
'IKVLNLANNKLSGEVP',
'LRSLNLSMNNLEGAIP',
'LQHLDLSDNGFYGPIP',
'LQELDLSRNGFTGSIS',
'MESLDLSTNSLTGELP',
'LEYLDLSNNGFNGQLP',
'LTLLNLSSNGLSGELP',
'IQQVKLRNNALNNTLD',
'LQLVDLQDNEISSVTL',
'LNYVDLSNNSFDASDA',
'VTSLGLSTMGLKGKLT',
'LTTLIMEFGSLQGTLP',
'AKHFHFNKNQLSGSIP',
'LNILILAGCSFGGNIP',
'VEVLRLDRNFLTGEVP',
'LIHILFDGNNLSGTIP',
'INELNLAHNKFTGPLP',
'LSFLALNSNNFTGKIP',
'LYWLDLADNQLTGPIP',
'LRSLDLSFNRGLTGPL',
'VQVLDFSFNNFSEFDF',
'LVRLSFSHNAISSNEF',
'LAQLDLSRNRVSDVDL',
'LQNLILRGNSFSSFNL',
'LSYLNLSNNLITAGPG',
'VSAIDLSGAALSGTLH',
'MIWVSLASNRLTGEIT',
'LQSLNLARNYFSGNFL',
'LVFLNFSDNKLAGQLS',
'LEVLDLSHNELMMEIP',
'LTDLIMWANKLTGEIP',
'LKYLNAAFNNITGPVP',
'LENLILAGNYLSGTVP',
'LKTIDFSFNSLNGSIP',
'IGVLDLSHNSLNGSIP',
'LAILQLGNNSLSGRIP',
'LETLILNNNLISGSIP',
'LIWLDLNSNNLTGDIP',
'LKSLFLAHNKFSGEIP',
'MIYLDLSYNLLSGSIP',
'LSTLDLSYNLFSGKVP',
'LETLDLSHNNFSGKFP',
'LQVLNLGHNRLSGNIP',
'LRVLDLSSNRFSGNVP',
'LSDLDVSNNNLTGSIP',
'LVELDLSENNLSGSLP',
'VVRFVAQSMGLRGPFP',
'LIALRLNSNHFSGTLP',
'LKSLFLDHNNFSGSFP',
'LRVLSLRNNSLFGPIP',
'LLTLSLSHNRLSGPLP',
'LKVLDLSYNNLSGPVP',
'TQLFLGYYNQFDGGIP',
'MNYLNVSWNHLSQSLP',
'LRFLNISGNAFSGDMR',
'LEVLDAYDNEFNCSLP',
'VVSLDISNFNLSGTLS',
'LRILILLNNFLFGSLP',
'LALLELQNNYLSGWLP',
'LNFLSLAGNDLRGLIP',
'LVSVSLAGNGFSGVFP',
'LNSLNFGGNYFFGEIP',
'ILKLDMSVNNFSGSIP',
'LTSADFSHNDFSGSIP',
'LEVLKLWQNNFTGAIP',
'LTLLNLFINRLHGEIP',
'LDTLFLQTNQLSGSIP',
'LQRVRLGQNYLTGSIP',
'LAELDLSTNKLTGLVP',
'LTHLDLANCGLTGPIP',
'LKCLDLSNNELTGDIP',
'LQILLLHGNRLSGEIP',
'LTYLDLSQNQLAGPIP',
'LGQLNLSNNRLSGSLP',
'VIMLRLPAMGLSGSLP',
'LRNLYLQGNFFSGQVS',
'LDQFNVSFNSLTGSIP',
'LQTLSLRFNALTGQIP',
'LATLYLERNNFTGSIP',
'LVRLNLGNNNFSGEIS',
'VSEVSLDGLGLSGKIG',
'LRYLNLSWNDLHSQMP',
'LSYFKASNNHFNSEFP',
'FKEILLQGNQFSGPLS',
'LHHISLARNIFDGPIP',
'LNSINLSNNRFSGNVD',
'LYLLSSSHNNLTGSIP',
'LSVVQLRGNGFNGTIP',
'LLAVNISYNRLTGRLP',
'LTVLDLRNSALHGSIP',
'LAVLQLDGNSFEGNIP',
'LKILKLEFNELSGEIP',
'IRFLDLSENSFSGPVP',
'LTHLSISNNKLVGTIP',
'LTNLDLSDNHLQGNIP',
'LSRLDFSDNQLSGELP',
'LTVLSLSHNSLSGSIS',
'LEDIDLSHNGLSGSIP',
'LERLNLSHNALSGSIP',
'LEYLELSNNQFTGSIP',
'LRTLDLSNNALSGSLP',
'VIEIHLPGAGFKGSIP',
'LKILSLHSNGLRGNLP',
'LTWLYLQNNSISGAIP',
'LQYVNLQQNNFSGLIP',
'LIALDISSNNFSGSIP',
'LKYLNLSYNNLNGSIP',
'VVHIRLENLNLSGTID',
'LRVVSLANNNIRGTIP',
'LTHLNVTSNQLSGRLP',
'LRNLDISNNNFSGMIP',
'VRKLVLEHSNLTGSLD',
'LKSIFLNENNFSGDFP',
'VKVIVLSQNHISGEIP',
'LYVLYLQDNALTGRIP',
'LRVLSFKGNSLSGQIP',
'LRYLNVSKNRLSGEIP',
'VTEISLDNKSLSGDIF',
'LAWLYLGGSHLIGDIP',
'LRFLLALQNNFSGTFP',
'LSHIVLTKNRFSGKLP',
'LQEIDLSANNMYGRLP',
'LIGFSIYRNSFTGTIP',
'VEIIDLAYNDFTGEVP',
'LETLDISRNKISGRLS',
'LKRFRISMNRLSGKIP',
'LQVLSLPSNLISGKLP',
'LYKIELFSNNLTGEIP',
'LESIDISENQFSGDFP',
'LVVFQLYENNFSGELP',
'LRVLNLTGNQLVGAIP',
'LSSVDFSENQLSGRIP',
'LVDLNLAWNSLSGNIP',
'LSSLHLEENSLTGSIP',
'LNSLNISGNKLSGSIP',
'LQVLDLSANYFSGSIP',
'LEKLYLSNNNFSGEIP',
'LVSLGLGENEYNEGEI',
'LVSIDLSETGIYGDFP',
'LQSLSVASNFLTNSIS',
'VEQIELFENQLFGELP',
'IEDFDVSTNDLVGELP',
'LEHLITFANRFSGTLP',
'LQFLEMSNNRFQGSVS',
'LNQFNVSGNKLHGVVP',
'LETLFLADVNLVGEIP',
'LMEIDFSKNRFTGEVP',
'LQYVRIQSNQFSGPVP',
'LICLDLSQNALTGKLP',
'LRLLNLSDNYFVGVLP',
'LKQLKLFNNSFTGKLP',
'LQKLRLQENMFTGEIP',
'LQSLNLNDNFLRGEIP',
'LTKLILSGNSFSGQFP',
'MTELDLSFNRFTGSIP',
'LKNFDLSQNSLSGTIP',
'LRELDLSKNNFTGDIP',
'LTYLDLAVNSLTGEIP',
'LRTLVLSGNLLSGTIP',
'LTRLELAYNPFKPGPL',
'VSVLGLPSQNLSGTLS',
'LQSVLLQNNAISGRIP',
'LNYLRLNNNSLTGSCP',
'LTLVDLSYNNLSGSLP',
'LQTLDISNNAFSGEIP',
'IKFLNVSHNNLKASTT',
'LESLDLSHNNLGTLPS',
'LHHLDLSNCNIKGNVK',
'LQNLNLSHNRFTNRLH',
'IKGINLSSKNLSGNIS',
'LLVVNLSSNRFGGSIN',
'LKVLDLSGNFLQGQVP',
'LSFLDLSNNTLNGSFP',
'VTEIKLPGRSLSGSLG',
'LIVLNLGHNQLQQALN',
'IRTMYLQNNQFTGTID',
'LDTLNVGNNHFTGWIP',
'VTNLDLSNNNLGGTIP',
'LQYLNLANNNFNGAIP',
'LSTLDLSFNSLTGDLP',
'ISILQLNLNKLGSNSS',
'VKELNLRGYHLHGFIS',
'LHVLNFADNTLWGEFP',
'LNVFIITKNQFNGSFP',
'LEELLIGRNYLTRQIP',
'LITLAMEKNFLTGIIP',
'LTQLIVGRNHFFGKIP',
'LEYLYLEGNSFHGSMP',
'MQLLSLGVNKLIGEIP',
'LNFFAVGANQFSGSIP',
'LEYFNASFNMLEGEVP',
'IEWLDVSKNYISGVIP',
'IQTLDIGNNLLVGQVP',
'LRILLLNDNSFYGEVP',
'LTCLSLRSNKLEGNIP',
'LYYLELSSNMFDGNIP',
'LSTALVSHNSLSGSLP',
'LEILDIGDNNFGGPFP',
'LIHLSLEGNRFIGEIP',
'LRILRVSDNKLSGYIP',
'LQFLNLSNNNITGAIP',
'LRKLDLSRNNLSGSIP',
'VERIVLWNTSLGGVLS',
'LVHLDFGSNRFTDFAP',
'LSYVSLRSNALSGSVQ',
'LIVIKLGNNSIGGMIP',
'TKFVSLSHNNLAGSIP',
'LKLLALEMNRLEGIIP',
'LEGFDFSLNNLSGAVP',
'LELLDLHNLNLVGQIP',
'IQYLDLSHNSLSGPIL',
'LTYLNLSYNGFGGHIP',
'LEIFDASGNSLDGEIP',
'IRFLDLSKNDFTGEIP',
'LWKINLSSNALSGSIP',
'LRILTLFGNRFSGSIP',
'LLGLDVSGNKLEGEIP',
'LESLNLHHNQLNGSIP',
'LTHFDLSFNNLSGRIP',
'VSGLVLEDLNLTGSIL',
'LLTLRINTNNLRGRIP',
'LRILSLKRNRFDGPIP',
'LKLLFLSHNKFSGKFP',
'LQDFNVSGNRLSGKIP',
'LYRLDLSYNNLSGQIP',
'NLQLNLVANNLTIESS',
'ITKLKVYALSVVGEIP',
'LKIVYMNDVELRGRIP',
'MEYLTFGINALSGELP',
'LNILELRNNNISDSIP',
'LEQLYLGSSGISGSIP',
'LNVLRFQGNSFEGSIP',
'LTELDLRQNHLTGSIS',
'LKSLSFSSNNFSGSFP',
'LLYIDLSYNDLSGTLP',
'LSYLFLGNNKLSGTLP',
'LTQLDLSFNNITGQIP',
'LIELRISGLFNGSSSL',
'VISLEMASAGLSGTIS',
'LSFLDLSFNNLSGPTP',
'LKTLLLQNNQLSGPIP',
'LSYLRLSKNKLSGQIP',
'LQTLDLSGNQLDGEIP',
'VLSLTLRDFKLSGKIP',
'IQKLDLASNSFSLEIP',
'LRKFSVANNRLSGTIS',
'LNELVLSNNQLSGSIP',
'LVSLDLSSNQLSGFIP',
'INSLHLVDLSLSGAID',
'LRSISFVNNSFSGPIP',
'LTELHLENNEFSGPVP',
'LKKIWISNNKFSGPIP',
'IKSLDMSNNKLQGEIP',
'LKSLYLAHNQFSGQIP',
'KQNIDLSLNNFTETSA',
'VTSISLKGLNISGPIP',
'LDRLDLQGTSMEGPIP',
'LTMFRIDGSSLSGKIP',
'LQRLELRNCLITGPIP',
'VVTLSLLGNRLTGSIP',
'LNYLFLTNNSLSGRIP',
'LQELNLEDNQLEGPLP',
'LLRLLLSTNNFTGTIP',
'LEILDLTRNNFNGSIP',
'LKTIDLSSNMLTGTIP',
'LTELRISDLKGPAMTF',
'VTALSLPSLNLRGPLD',
'LKELNMTNNEFYGRLP',
'LLRLDLSDNNLRGKVD',
'LRLLNLHDNRLNGTVS',
'LITLRLQNNLLSGEIP',
'LQLLYLSSNDFSGEIP',
'VIKLNLSGASLRGFLA',
'VMKINLQSNGLTGRLP',
'LKVADFSCNFFVGSIP',
'LQELILHGNSLIGVIP',
'LQELRLDRNKLQGSLP',
'LKVLDLGMNQLTGPIP',
'VTGLDLSGLGLSGHLS',
'IRVIRMASNLLEGTVP',
'LKNISFGTNFLTGWIP',
'VASIDFSSNQLFGGIP',
'LLVFNFCFNKFTGGIP',
'LNFLAIDGNMLEGVIP',
'LVNLALAANSLWGEIP',
'LRLLNMSTNMLEGKLP',
'SNVLNLSMNFLSGPIP',
'LQALKLGRNSLYGAIP',
'LTKLYMGQNRFNGSIP',
'LQILDLSSNKIASKIP',
'LIELDLTLNNLTGTVP',
'LNQIDLSKNKLVGRIP',
'LKLLNLSYNSIFGDIP',
'LQELSLAGNEISGGIP',
'LKFLNLSYNDLEGVIP',
'LLYMDLSSNKLDGSIP',
'LQSLQLQNNQLTGVIP',
'LENLFLARNQLSGPIP',
'LETLDLSSNQLFGAIP',
'LRMYNIGYNRIVSSGV',
'LRTLSFMNNDFEGAWP',
'LKKVHLSNNHFTGAVP',
'LIELRLEGNKFNGPIP',
'LKSFSVANNELSGEIP',
'LKSIYLSNNKFSGEIP',
'VTVLRLENQNWGGTLG',
'LRKLILSNIDLHAQIP',
'IQIFVLAKNQLCGTLP',
'LTEFTMVDNYLEGTIP',
'LRKLLLGANDLVGTIT',
'LHKLILEGNQFGGVLP',
'LRDFLVGGNNFNGSFP',
'MQSVGVADNNLSGDIP',
'LVRFTLEGNYLSGNIP',
'LTELVLERNYFHGSIP',
'LQNITLARNHLEGTIP',
'LTLLDIGKNQISGMIP',
'LHVFDISLNGFSGSIP',
'LKELNLGLNHLSGVVP',
'LSELYLRTNNLEGSIP',
'LNTLNLSFNHLYGEVP',
'LEVINLLYNKLTGKLP',
'LSILYLNENKLSGEIP',
'LEILDLSNNDLSSTIP',
'LQVLDLSHNNLHGQIP',
'LINLDLSNNSFTGSIP',
'LTRFHIAYNSFGSGRA',
'LKTLWMPMCNLIGAIP',
'LEVLGLAYNSFVNQTP',
'LSRLEIRNNLFSGKIF',
'LTDFKVFGNKLNGTLP',
'IVSFEVANNQLSGGLP',
'LNTLMLDENQLYGKLP',
'LKGVIAFSNNLSGELP',
'LRTLLLYRNEFNGTFP',
'LAHLNLSDNNIAGQFP',
'LVVFDARNNMLSGEIP',
'LRTVQLYNNSFSGELP',
'LNTLSLSRNKLFGNIP',
'LNEIDLAMNNLTGSIP',
'LTTLMLSNNSFSGEFP',
'LKLLDLSQNYLAGPIP',
'LQFLYLYHNGLSGEIP',
'LTILHLFSNQLTGEIP',
'LELLDLSFNFLTGNIP',
'LNYLDLGGNSFSGDIP',
'LVYLDLAENNISGEIP',
'LVFLNLSSNKLSGSVP',
'GVVFNLSNNMFYGLLN',
'FKMIDLSSNFLEGEVL',
'LVEVDLSMNFLSRSLS',
'LETFNASGFKLNGSIP',
'LEELDLSLCSIKGSIP',
'LKVLLLSGNFLTGRMP',
'LEVLILRGNLLDGVLP',
'LSVLDLSGNSLSWPVP',
'LHFLDVSSNNLTGTLP',
'LSRLDLSYNFLSGSVP',
'LQFLNLSGNSFTGSVP',
'LSYINLSYNSFDFSQD',
'LYDVDLSHNNFTILSP',
'LTMLLLDSNHIEGKLM',
'LTYLFLDSNHIEGRLM',
'LVFLILDSNHIQGELM',
'MINLFLDSNQITGPIP',
'IHNLNLSHNFLKGEIP',
'LVYLDLNGMALTGTIP',
'LDSLDLSYNNLTGKLH',
'LTYLVLSNNCLQGSIP',
'LKHLDVSWNSLRGVIP',
'LGHLSLHSNKFEGTIP',
'LEHLSLYSNKFEGLLP',
'LVKLYLQSNQFEGPLP',
'IQKVDLSYNLLNGSIP',
'LEHLSLHSNKLEGTIP',
'LQELILSNNSLTGSIS',
'LKHLDVSRNSLSGVIP',
'LTNLSLSSNQITGPIP',
'LILLNLSHNFLSGSIP',
'LVELYLDNNSLTGSIP',
'LEQLDVSGNSLSGVIP',
'LKILSLSNNLLTGSIP',
'LKELYLSNNSLTGSIP',
'LQILELNNISAHGKIP',
'VLEINLSDANLTGTLT',
'INYLYMYKNLFSGLIP',
'LEYLNLTNSGLQGKLS',
'LIRVRLDDNQFTGNIT',
'LVFVSLGGNQLVGDLS',
'LQIFDVNTNNLYGEVP',
'ISELGLSENSFSGQLS',
'LWSLDLRNNFLNSTIP',
'QIMLDLSSNYLSGAIP',
'LTYLDISQNNWNGTIP',
'IQVMNLFFNELSGTIP',
'LKELRIGNNMFNGSVP',
'LTEMEMGSNKLSGKIP',
'LSYFSVFTNNFSGSIP',
'LTFLAANNNSFSGPLP',
'LTQLNLTANHFGGSIP',
'LRHLSLHSNEFTGHIP',
'LTLLDFGNNLFEGTLP',
'LQYLSFYDNSLNGTIP',
'MIELDLSQNAFSGPIP',
'LISLQLQNNKFTGRIP',
'LLLFNMSSNHLSGEIP',
'LTYVYLSNNSFSGVLP',
'LEVLNVSHNHLTGTIP',
'LTFLSLAGNSLSGPLP',
'LQSIDFSYNNLSGSIP',
'LLRLNLSHNNLSGEIP',
'LNFLDLSNNNFSGSIP',
'VWYMDLGSNYFITPPD',
'LTRLALHQNPTLTGEF',
'LESVFLDGNNFTSIPD',
'VTIIKIASQSLGGTLP',
'IITVNLAKQNLTGTIS',
'LVKLDLGNANLIGTLP',
'LFDLQLRDNQLTGVVP',
'LQNVSLDNNALQGPVP',
'LSQVWLQKNQFTGPIP',
'LRNLFLNDNNLGGSIP',
'LTSLSLQNNKLSGALP',
'LQELRLSYNNLTGGLP',
'LEVLNVSNNNLSGDVP',
'LQTLSMADSVNLAPWT',
'IQNLWLNNQNGFGFSG',
'LLILDLNTNSLTEVIL',
'LTELNLSNNEIFNLIP',
'ILVLDMSRNMLAGEIP',
'LVHLNLAALGISGSIP',
'TRILDLSYNELNGTIP',
'LTYLDLSFNDIMGTIP',
'LKYLNISNNKFFGEIP',
'LEKLILSHNNINGSIP',
'LALIDLSHNSISGEIP',
'LIELDLSDNSFIGPIP',
'LKHLSLGENKLNGSIP',
'LVTLNLARNKLSGLIP',
'LGRLDLSYNSLEGEIP',
'VSTINLPNYGLSGTLH',
'WYSLLLHENDFTGHLP',
'IQRIRLEGNQLEGDIA',
'LVYFSAFGNRFTGSVP',
'LEYIDLSDNKFYGQIS',
'LNVLNFSLNLFRGSIP',
'LISVNISYNQLEGPLP',
'LDALSLQVNNLSGTIP',
'LLSLNIYNNSFYGTIP',
'LSYLDLSVCNFSGHIP',
'LKDIDLARNVLSGTLP',
'LGKLHLSSNHLNGKLP',
'LENLRISRNKLFGSIP',
'LETLKISGNNISGGIP',
'LEQLTVANNHLSGSIP',
'LIKLYLGMNNLSGSIP',
'LRNLNLSNNKINGSVP',
'LIVLELSTNKLNGSIP',
'LTLLYLDKNNLSGSIP',
'LIELQLSNNHLSGTIP',
'LEDLDLGDNQLSGTIP',
'LKLLNLSRNNLSGGIP',
'LESLDLSGNLLSGTIP',
'LRGLDLSQCSELSGEI',
'LNLLRLSNNSYLSGPI',
'LQEVEAGAVGMRGQLP',
'LTYLHLSNNRFLSHDN',
'VVGLSLANVGIAGAIP',
'TGHLNLELNAIEGPIP',
'LMTLDVENNLLDDELP',
'VEKIDLSWNNFNGEIL',
'LGAIHLRGNQLHGGIP',
'MFYLGLEQNDLSGTIP',
'LEYLYMQNNNVSGGIP',
'LESLFLNNNDISDTIP',
'FVVINLYSNNLNGTLP',
'MMWLNLSSNLLNGTIP',
'LRNVDVSYNLISGDIP',
'MKTLNLSRNQLGGKLP',
'LQTLTLQRNELSGAIP',
'LGEIDLSGNVLSGAIP',
'LLELEMSGNQLTGQIP',
'LLVIDLSCNSLTGVIP',
'LKYLNLSYNDFSGVVP',
'LQSLNVSDNNISGAIP',
'LTVLDLSHNSLAGDLP',
'LALLDVGDNNLSGEIP',
'LRILDLSNNKISGQVP',
'LERLVLSNNALTGEIP',
'LESLNVSNNHLSGEIP',
'RTVLLLGNNKLSGEEE',
'LRALSFPSAGLGGEIP',
'LVRMDLSRNLLHGRLP',
'LRRLRLSSNWLAGTIP',
'LQALNLAGNSLRGRLP',
'LEFLNLSNNSLSREVP',
'LRVLDLSGNRLTGGVP',
'LRFLSLSGNNFSGEIP',
'LKSLDLSGNRLSGGIP',
'VIRVDLGNAALSGTLV',
'LQYLELYSNNISGTIP',
'LVSLDLYLNNFTGPIP',
'LRFLRLNNNSLSGSIP',
'LQVLDLSNNNLSGEVP',
'ATTLDLSSNALVGTIL',
'VLSLSLSGFGLVGSIP',
'LNSLTLSGNQLSGQIP',
'LVTLDLSSNQLTGAIP',
'LKSLDLSGNQLSGQIP',
'MTYLNLSLDSFHGPIP',
'LRAMKIQRNYLAGSIP',
'LRVLSLAINALSGALA',
'LSVLNLTNASLAGAIP',
'MDRMDLSANRLVGSLP',
'VEFFSVARNRFSGPIP',
'LQYLILQVNNLSGLVP',
'LKVLDLGHNALSSGIP',
'LQRLSLSENSFQGVVP',
'MKTLDLSHNNISGAIP',
'LQLLHLQFNLLSGPIP',
'LTSLNLSFNELRGQIP',
'LTHLNMGNNSLSGPIP',
'VQVICLYENHLDAAPI',
'VTSIELVDTGLRGTLT',
'MAGLSVFNNDLTGAVP',
'LYNASMGFNEFSGPLP',
'LNIVHMFENRFSGAIP',
'LIALQLGGNGFVGRVP',
'QMYLNLSNNGFTGPIP',
'LQKLTLQQNRLDGALP',
'IQTLDASRNAFTGALP',
'LRKLMLHANRLTGEVP',
'LRTLTLAGNSFTGSLS',
'LKVLLLYGNALSSEIP',
'LNELVLSLNSLDGELP',
'LSFLDMSNNALNGTVP',
'LSLLQLQGNALSGAIP',
'LQLLDLTSNRFGGGIP',
'LRSLNLSWNQFEGPVP',
'LEGLVLGANNLTGAIP',
'LTVLSVASNRFVGPIP',
'VQSIDLSNNRLSGGVP',
'LTSLNISGNELDGDIP',
'LLTLDLSHNRLAGAIP',
'LTTLNVYSNRLTGAIP',
'LQLLDLSNNTLRGGIP',
'LQVLVIQNNSLSGPIP',
'LYSLDLSANNLTGALP',
'LTYLSFSYNSLSGPLP',
'LVSLQLSMNQLTGSIP',
'LETLDLSGNQFSGPIP',
'LHFLSLADNDKLSGDI',
'VTQIKLPRQNLSGIIS',
'LETLQLNNQKSDGKLS',
'VTGINLVKLHLSGTLS',
'LETLVLDGNAFSALPP',
'LQTFSASNASVSGSLP',
'LQDVSLSNNFLQGPKP',
'LQSLQLQGNVLEGDVP',
'LEIFNVRDNKLTGPVP',
'LKTLWLQSNLFTGPIP',
'LKYLDVSNNRLTGQVP',
'LQTLRLSYNNLTGVLP',
'LQRLDLSNNQLTGVIP',
'LLKLSMDNLPLNPWSI',
'VTELHLPGVGLVGAVP',
'LEAFNVSFNDLQGPIP',
'LRALYLQGNLLSGAVP',
'LQVLSLRDNRLAGPVP',
'LRSLKLDANRLSGGLP',
'LEHLALSRNQLSGPIP',
'VTNLTLGSAGVAGPFP',
'IVSLWASQCNLTGGFP',
'FRYLTAMNNKLTGSIP',
'LLIVEADYNELTGAIP',
'LQQLFLYDNNFSGDVV',
'LRKFTAENNQFSGQIP',
'LQHLTLDTNRFVGTVP',
'LSIFRFGNNRFTGALP',
'LNYVTLPGNQLSGSLP',
'LKTLALDNNQLSGDVP',
'LTHLDVSNNSISGAFP',
'LTQLDMSRNQLIGEIP',
'LTTLDMGNNRFSGNIP',
'LSTLVLSNNQFDGSIP',
'LTQLYLFSNNFSGEIP',
'LTSLNLSSNQLSGQVP',
'LSVLDLSSNELSGAIP',
'LLTLNLSGNRLSGDIP',
'LQYLDLSQNKLTGELP',
'LEVLDLSNNMLTGSIP',
'LQTLWLAANRFVPAQL',
'LTHIDLSENYKLTGPI',
'PVHVDLSCNQFSGSLA',
'CSVVDLSGNMLYGNLS',
'LQYLNVSHNVLSGTLF',
'LKYLDLHDNGFTGKLD',
'LQMVDLSSNRLTGSWP',
'LTELDLSCNQLTGPIR',
'LIFIDLSINQLHGPLP',
'LGYLNLSSNGFRGALP',
'LEIFDASFNMLSGNIP',
'LVEFNVSYNYLSGSVP',
'LRNLSLSDNKLEGFLP',
'LSYVDLSSNFLHGSLP',
'LKYLNLSHNNLQGTLP',
'LTLLNLRQNNFTGEIP',
'LLYIDLSSNNFNGSIP',
'LTSLRISNNLLSGELP',
'LKVLRLQNNNFSGSIP',
'LTFLNLSGNSFTGTLP',
'LQLLDLSNNRFSGSIP',
'VTQLVLSGKQLGGAVS',
'LQYLYLSYNNLSSHGG',
'LRDANFSYNNFSGVVP',
'LGLVDFSGNRLAGAIP',
'LEWIDLESNYLAGELP',
'KLYLNLSNNRLEGPLP',
'LRRLMLHHNQLSGAIP',
'ILALDLSANRLAGTIP',
'LRQLHLEDNAISGSIP',
'VAVLDLSSNSFAGAIP',
'LQELELAGNGLGGRLP',
'LTQLSLANNLLEGAVP',
'LRYLLLWSNELSGAIP',
'LEYLNLSGNTLRGALP',
'LQYLDLANNSLAGGIP',
'LQVLDVSRNALSGPLP',
'LEILDLSYNGLQGPIP',
'LYFLDLSGNRLSGGIP',
'LTYLNLSNNLLNGSIP',
'LERLYLSNNLLSGEIP',
'LTVFGAAVTALSGPIP',
'GISLDLSLNKFVGELP',
'LQTLALYDTSVSGSIP',
'LQLLNLSACNVSGAIP',
'LQVLCVQDNLLNGTIP',
'LTALQLDKNGFSGAIP',
'LSKLLLLGNELSGPLP',
'LQSLNLASNGLYGSIS',
'LRNLYLHMNKLTGPIP',
'LVRLRLGENKLVGQIP',
'LQVLFLWGNALSGAIP',
'LTSLLLWGNALSGKIP',
'LYALDLSKNRFSGGIP',
'LELLDVHNNSFTGGIP',
'LQFLLLNSNRLTGGIP',
'LVFLDLYSNRFTGKLP',
'LEQLHLSDNQLTGRIP',
'LTSLNISYNNFSGAIP',
'LNKLILSGNNLSGPLP',
'LEQLDLSMNELTGEIP',
'LRVLDLSSNALTGDIP',
'LVVLDLSGNRLTGEVP',
'LTMLDLSNNSFSGPIP',
'LQQFRVGGNPALSGPI',
'LRQLSLSNNCFQWPLI',
'VVMLNLKDLSLKGTLG',
'LRALELSNNFFSGAIP',
'LEILDLSNNNLSGEVP',
'VANVSLQGKGLAGTLP',
'LTGLYLHYNALRGGIP',
'LTDLYLDVNNFSGPVP',
'LQVVQLCYNQLTGSIP',
'LTVLALQSNRLNGAIP',
'LVALDVRNNSLTGSVP',
'LARLDLSFNRLFGSIP',
'VVEVRLPGVGLVGAIP',
'LRALSLRSNRVLGTIP',
'LKALFLQHNLLSGPIP',
'LGSFDVSDNNLNGSIP',
'LRVLRLDGNRLSGSIP',
'LERLVLSRNNLSGPIP',
'VDELDLSGKNLSGKVT',
'LAVLNLSSNAFATALP',
'LSFIDLSHNHLQYTLP',
'LQTVDLRGSFFGGGIP',
'LRLLNLMCNHLDGTVP',
'LDTVNASGNNFVGALP',
'LAKLIMFNNGFTGGIP',
'LQYLDLAVGNLDGPIP',
'LQSFLASDNLISGELP',
'LVRVRMQSNRLTGTIP',
'LESLIIGYNALEGTIP',
'LRVLDVSQNSFEGAFP',
'LTALYLYKNNLEGKIP',
'LQWVDVSSNSFTGPVP',
'LAALDLSNNRLAGAIP',
'MAILDLSSNSLTGHIP',
'LEVLELWNNSLTGQLP',
'LRFLGLSGNNITGKIP',
'LVKLNLRHNRLTGEIP',
'LQRLELAGNDLSGEIP',
'LETLNLSYNNLTGPVP',
'LVFLDLSDNSLTGPIP',
'VVSLQMANNGLSGTLS',
'LNALDLSSNEFIGDIP',
'LQTMSLQNNRISGEIP',
'LNYLRLDRNNLSGPIP',
'LTFLDLSFNNLSGPVP',
'VTGLEAPSQNLSGILS',
'LETVLLQNNNINGLIP',
'LQYLRLNNNTLSGAFP',
'LIFLDLSYNNLSGPIP',
'LKTLDLSSNHFSGEIP',
'VTGIQLGECGMTGVFS',
'LRHIYADTNKFHGGVP',
'LSIVNFSGNKLSGVIA',
'LTDLILYGNMLNGSIN',
'VVFLNFYKNFLTGPIP',
'LETFYAYENQLTGGIP',
'LSDLRLNNNALGGVIP',
'LEYFYLSANRMSGTLP',
'LSILLMQNNQLVGSIP',
'LTGLKLQSNQLEGVIP',
'LKAFVIGENRLTGEIP',
'LTFFDASSNQLSGPLS',
'LERLGLAGNMLEGRLP',
'LAFLNLQFNFFNGSIP',
'SVMLDLGSNSLTGSIP',
'MENLTLSDNQLTGTIP',
'LTSLDLMANNLSGILP',
'LRRFRLHNNRLTGTIP',
'LTDLELDNNFLTGSLP',
'LKTLLLYQNRLEGSIP',
'LQILHVRNNSLTGSIP',
'LGELDLSRNNLVGLIP',
'LETVELFSNNLSGTIP',
'LELLDVSSNDLHGEIP',
'LTELNISNNQLVGPLP',
'LIELRLGNNRLSGAIP',
'LERLNLSSNFLSGRVP',
'LKNLDLDMNNLTGPIP',
'LQVLDLSWNRLTGRIP',
'LEVMDLSNNSLTGPIP',
'LTRLNVADNGFSSYTL',
'LSVVDLESNLLDGDTV',
'VSMLNLTGFGLSGQIP',
'LVQVDLSTNKFEGDVL',
'LRHLNLAYNSLTNPVS',
'LRVLKLGRNKFSGPLK',
'LKVLDLSFNDLVNDIP',
'LEVLNLSRTNLGGNIS',
'LVNLNLARNNFSGSVT',
'LTDLNLSDNNLTESLP',
'LENLNLASNHLQGAIP',
'LEDVDLHGNNFSGKLP',
'LRTLHLGSNRFTGLIP',
'LEELHLARNDFSGPIP',
'LLSLNLSSNSFVGPFP',
'LKRLGLADNQLSGSVP',
'LLRLDFSSNSFSGPVP',
'LEYLDLSFNQFEGGLP',
'LEYLDLSSNLFTGAFP',
'LTNLDLSGNNFNGTIP',
'LSSLDLSNNNLSGIIP',
'IEHLHMDHNLFTESLP',
'LNFFACESNKLTGPIP',
'IVSLSLAGCNLTGPIP',
'LLSLQIQRNSITGSIP',
'LTHIVLNDNLLTGTLP',
'LETLKITNNSLTGNIP',
'LEVLDLSGNPLESTIP',
'ITDLRLRSNRLSGSIP',
'LKHLKLDGNKISGEIP',
'LEIIDLSQNNLVGTIP',
'LTSLSLVNNQLSGEIP',
'LKSLDLGGNYFTGSIP',
'LVLFEAHMNTFNSSLP',
'VVELNFHNANLTGPVP',
'VKHVDLSNNELDGDIT',
'LEVLGLSWCLLQGNIP',
'LSDYNFSYNNLSGVLP',
'LELIHFHTNSLNGSIP',
'LELLDLSYNLIVDVLP',
'LIILIASNNNFHGELP',
'LYDLKLFNNLLTGQIP',
'LEALYVNNNLFSGSFP',
'LSKLNVSWNYLVGTIP',
'LQRIRLQNNKLNGSVP',
'LDTLILFDNELSGDIP',
'LTALYLEDNSLAGSIP',
'LRELQLYQNKLSGQIP',
'LQTLDVSSNSLVGLIP',
'LVEIDLSENQLVGPIP',
'LTKLELANNDLTGPIP',
'LLVLNLSYNNFSGHIP',
'LTHLDLSANLLEGSIP',
'LNVLDLSHNKLSGPVP',
'LSTLNLSGNQLVGEIP',
'LVVLDLSNNSLTGGIP',
'LTRLSIPGMGFSGSIT',
'FASLYLENNQLEGDLS',
'LKSLKVSNNSLTGECF',
'LNVLYLVNNQLNGTLK',
'LYELLLGNNDLTGSLD',
'MTDMDLSHNILTGRIP',
'AVKADLSYNNFSGPLP',
'LVVVKLSFNRLTGDVS',
'LQSLQVQGNQLSGNLS',
'LEILELHNNHLSGSLG',
'LLKLDLASNQLTGDVP',
'LEVIDLSSNNLTGPIP',
'LQVLDLRKNDFFGNLD',
'LKSLNMSFNKFDSKIP',
'LKFMWISQCNLIGNIP',
'VTTIQLYKNSFLGEVP',
'MSRLEIRNNNFSGQIS',
'LLGVIAFSNNLSGNLP',
'LVAFEVSENQLVGGLP',
'LRNFRVFDNKLNGTLP',
'LVVFDARNNTFSGEFP',
'LNSLFLFRNRLFGVIP',
'LQTLHLFQNNFNGTFP',
'LNTLTISRNKISGQIP',
'LIKLDLSNNSIAGDFP',
'FIFLNLSSNKLTGNIP',
'LMFLHLYSNQLSGEIP',
'LSTLMLSDNLFSGKLP',
'LTTLMLDGNQLSGTLP',
'LRYLDLSQNYFAGQIP',
'LTHIDLAMNNLTGAIP',
'LTYFNLGGNSFTGDIP',
'LEQLDLSMNNLTGNIP',
'LVYLDLSENNITGEIP',
'LEILGLAYNYRLKPME',
'LKRVRLQQNQLTANIT',
'LTRFSTSNNQFIGLVP',
'IRILVLKNNSFYGVVP',
'LEYMELSDNNFYGHLS',
'FEILQLCNNNFTGHLP',
'LTSILLDDNKLCGHIP',
'ITILELATNNFSGFIP',
'LIQLLISSNHLVGEVP',
'LTKLSLISNALTGNIP',
'IENLDLSENVLNGTIP',
'LTSLKVFNNNISGSIP',
'LLDLNLSQNKFEGDIP',
'LTTIDISYNQFEGPIP',
'LTTIQLSGNNLSGPIP',
'LETLDLSLNRLSGNIP',
'LETLNLSHNNFSGTIP',
'LTILDLSSNQLTGEIP',
'VVSLNLSSCNIHAPLR',
'LSQFAAVESNLVGTIP',
'MDKFDVGFNFLNGSLP',
'LQDLYFNENQFQGVIP',
'IYGLNLSSNGLIGDIP',
'LVEINMSYNSFQGPVP',
'LLFMEISNNKINGTIP',
'LRRVILKQNNFTGPLP',
'LLQLDFINNRFTGNLP',
'LSELRLGGNMFGGRIP',
'LSVLNMGINQLQGSIP',
'LNTLILTENHFSGGIP',
'LNGLQLYSNRLEGNIP',
'LKNISLFDNLFSGVIP',
'LRYLYLDTNQFSGIIP',
'LRTLILDHNNLEGPLP',
'LEYLLVYNNTLSGELP',
'LLRLNVASNKLTGIIP',
'LLFLDISFNAFSGGIP',
'LTDLILSTNKFSGLIP',
'LQDLELFSNQLSGQIP',
'LQLLDLSQNNLTGSIQ',
'LTYLSLSTNLLTGPFP',
'LHFLDLYFNQLTGSIP',
'LKHLRLSDNHLSGKIP',
'LNYLDLSSNYFTGQIP',
'VTSLNLQGYGLLGLIP',
'LLLFNIPRNNFVGQVP',
'LEYLNLQGNIFQGVMP',
'LTHISIASNKLYGMLP',
'LTFFSAGVNQFNGSLP',
'LQQFGIGMNKISGPIP',
'LSVLIFGINNLEGNLP',
'LKELYLTNNTFKGQIP',
'SVLLNLSHNSFHGSLP',
'LSQFYIGGNQITGTIP',
'IQSLTLNVNKLSGKIP',
'LQVLDLNLNNFGGYLP',
'LRYVNLQNNSFYGEIP',
'LIGFDLEFNLLSGSIP',
'LQYLNISFNMLNGEVP',
'LKSLSLTGNKLVGKIP',
'LFQLDLSNNMLEGNIP',
'INKLDVSKNSLSGEIP',
'LEFLSIGMNNLSGEIP',
'LQYLDLSNNHLSGNIP',
'LRYLDLSQNNLSGSIP',
'IWSIAMEYNHLGSNSS',
'VLNLKLSNMGLKGEFP',
'LTGLDFSLNSLSKSIP',
'LNSIKLDQNQLTGQIP',
'LKTFSVSNNLLSGQVP',
'VTTLDLSSNDFTGEIP',
'DYTKNKGDNNLNGAIP',
'VDYVDISYNCLEGPIP',
'LTDLDFSSNYLKGQVG',
'LETLVISSVELHGTIP',
'YYTLILSNNNLTGTIP',
'LEDLYISNNYIEGHIP',
'LQYLDISHNFLIGTLP',
'LEDLDISYNNLKGQLP',
'LLSMDLSHNLISGKIP',
'LQLLNISHNNIQGSIP',
'LTFLYLSYNKFKGEIP',
'LTILDLSHNRLNGNFP',
'LTFLDLSYNMFKGEIP',
'LTYLDLSGNYLNGELP',
'IISILLSGKNLTGNIP',
'LKIIHLENNQFNGVLP',
'LRELYVQNNMLSGEVP',
'LVELWLDGNMLTGPIP',
'VIALSLPSLNLRGPVD',
'LIELNITNNELQGHLP',
'LRFLDLHDNRLNGTIV',
'LIRLDISDNNIHGEIP',
'LLTLRLQNNELSGEVP',
'LELLYLSGNDFSGEIP',
'LTDLNLNHNQLQQALN',
'ITTMYLQNNQFTGAID',
'VTQINLSNLALTGTLP',
'LNSLNVENNNFTGWIP',
'LHRLNFANNNLTGPLP',
'LTILDMSNNNLVGTIP',
'LSKLDLSFNSLTGDLP',
'LETLVIWSVKLHGTIP',
'VNYVDISYNCLEGPIP',
'LLSMDLSHNLISGQIP',
'LEYLDISHNFLIGSLP',
'LQQLNISHNNIQGSIP',
'LQELDISHNNIQGSIP',
'LTFLYLSYNRFKGEIP',
'IYNLNLSNNNLTGTIP',
'LTHLDLSGNYLKGELP',
'LSTLDLSHNRLNGNLP',
'LTILDLSYNRFKGEIP',
'LRIVQLGFNGFTDFVG',
'VTELRLPRLQLAGKLS',
'LTTLLVDHNHLGGVVP',
'LSVVDFEGNKFAGEVP',
'LMELKVANNSFNGVIP',
'LQFLWLDHNFLGGTLP',
'LQVLDIQHNSIRGTFP',
'LMILNVAQNHLTGTVP',
'LQVIALQENRLSGVVP',
'LETLSLRSNRLNGTMP',
'LTTLDLSDNKFNGEIY',
'LVHLSAEGNSLSGVIP',
'LRKLSLRSNFFNGTIP',
'LKVLSLGGNQFIGSVP',
'LRFLFLQDNQFSGDIP',
'LKVLDLGGNKLTGDMP',
'LVYFNVSGNNLEGKIP',
'IEVLELGSNSLSGQIP',
'LTTLDLSKQNLSGELP',
'LTVLNLSGNDFSGKIS',
'LQSVNLSSNAFSGQIP',
'LVVLSLSHNRITGTIP',
'LQVMSLSHNNLTGSIP',
'LQLVNLSYNQFSGEIP',
'LKYLDVSSNAFSGEIP',
'LAMLDLSANNLSGEIP',
'LSVLDLSSNALSGEIP',
'IVKLDCMNNKFNGNIP',
'FYGLNLSANGLIGGIP',
'MDRFDIGFNFLNGSLP',
'LTYINLSRNKFARLIP',
'LLELNMGINQLQGGIP',
'ITTLILRENYFTGGIP',
'LIEVNISHNLFNGSVP',
'LQNLVLLGNGFTGNVP',
'LLHILVHNNSLSGELP',
'LLRLYLHRNMFSGTIP',
'LRNISLFDNQFSGVIP',
'LQSLDISLNNLTGSID',
'LRELQLGGNLLGGKIP',
'LKYMDISKNNISGPIP',
'LRRLFLNQNNFTGSLP',
'LEEVSLHSNLLSGPIP',
'LVILELSHNNLEGPLP',
'LEDLNLSFNRLRGEIP',
'LKVIGLSSNLLTGEIP',
'LEYLDLSKNRFSGKIP',
'LRRLNLELNSLGNNST',
'VAELNLEGYQLHGLIS',
'LTIMSVFLNRLSNTLP',
'LTLLSMELNNFEGIIP',
'LYHLSVGDNMLEGNIP',
'LRQLHLGCNMISGKIP',
'LLVFSISFNNFGGNLP',
'LTFISAAFNNFNGSLP',
'LFNLDLDQNNLVGQVP',
'LAILSVGDNLLEGDIP',
'LEFLYLTGNHLIGKIP',
'MQLLVLQGNKFSGEIP',
'LEHLNVSFNMLEGEVP',
'INKLDVSENLLSGDIP',
'LRNLNLAHNSFFGKIP',
'SNLLNLSRNSLSGSLP',
'LEYLFLQGNSFNGTIP',
'LQYLAIGGNQFSGTIP',
'LQELVLIDNSLTGEIP',
'LQVLEISKNNLTGRIP',
'LQYLDLAQNNLRGTIP',
'LQYLDLSRNRLYGPIP',
'LKLLFLSHNHFSGDFP',
'LLTLRLDENKFSGVIP',
'LRVLSLKGNRFSGSLP',
'LQDFNVSGNRFSGEIP',
'LYRLDLSYNNFSGEIP',
'LTFLNLCCNGFESSLS',
'VEKLNLSHMNLSGSVS',
'LKYLDLAEGNVGGEIP',
'LEYMIIGYNEFEGGIP',
'LSFIDFSRNNLHSSLP',
'LNTVFLYKNSFEGKIP',
'LVRVRIQNNFFSGTIP',
'LTKLILFNNAFKGPIP',
'LQLLNFMRNKLSGPVP',
'LETLDLRGSFFEGSIP',
'LKSLDVSQNFFTGGFP',
'LQTFIVSENNLEGDIP',
'LETFNVSYNKLEGPVP',
'LLTLNASSNNFSGFLP',
'LVKLSLQNNLLTGGIP',
'LEVLELWNNSLSGPLP',
'LGVLDLSSNFFSGVIP',
'LQRLELANNSLTGGIP',
'LVLLDLSDNMLSGNIP',
'LKYLGLSGNNLTGKIP',
'LSILDLANNSLTGQIP',
'LQWLDVSSNSLSGEIP',
'VIRVDLGNAALSGTLV',
'LRFLRLNNNSLMGPIP',
'LVSLDLYLNRFNGPIP',
'LQYLELYSNNITGPIP',
'LQVLDLSNNQLSGVVP',
'LQFLYINNNNFTSMPS',
'VTAIQIAGLNIQGSLP',
'ITIIDFQNKGFTGSIS',
'LKVFSAMNASLVGVIP',
'LNRFECNGNALSGDFP',
'LFDVSLRDNQLTGVVP',
'LKQIWVHGNSFTGRIP',
'LTVVNLTNNYLQGSLP',
'LTNLYLSFNFLEGNLP',
'LKELDVSNNLLYGHIP',
'LTKLLLANNNLTGTLP',
'LIEVSIGYNPFPQWQI',
'LEYLDLSSNTMFPSWK',
'VTGITLSQMNITQTIP',
'LRELRIQYCLLNGTVS',
'LTHVDFSSNFIPGDFP',
'LSNFMVSKNKFNGVIP',
'VVVFNARNNFLNGSIP',
'ISRFEIGNNQFSGRIP',
'LQYLNLGSTNFHGGVP',
'LKVLYVYGSNLIGEIP',
'LKTFHVSNNSLIGKLP',
'LLDLKIYSNEFTGTIP',
'LLNLTAYENSLSGELP',
'LVDFRVFSNNLSGTIP',
'LTTLLLDQNQFTGQIP',
'LVYLDLSMNNFDGIIP',
'LTNLNLSSNHLIGRIP',
'LTMLDLARNNFEGKIP',
'LSQLFLFDNKLSGEIP',
'LTWLSLSLNSLSGVIP',
'LSQLSIYNNKLSGEIP',
'LETLDMSRNGLTGEIP',
'LVTLNLSQNQLSGQIP',
'LSQLDLSENELSGEIP',
'VLGLELKGMKLSGKIP',
'LHKFSVANNELSGDIP',
'LNELMLDNNHLTGSIP',
'LQRLDLGSNSLSSVIP',
'LVTMDLSGNNLNGEIP',
'IVSLNLSRSGLSGNID',
'LKYLDLRGNQLSGFVS',
'LETLDLCNNSLTGSIP',
'VTGLTLFNYNINQTIP',
'LKVFYMYVCNLFGEMP',
'LTHVDFNNNYIPGMFP',
'LLEMKIYKNDFYGNIP',
'LETLDLSNNLFKSSTL',
'LRFLALQVCLFNGTFP',
'LRSFHVTTNRFEGRLP',
'LIDFKVFMNNLSGTLP',
'LGYFMISHNKFNGELP',
'VVEFIASKNNLNGSIP',
'LNYLNLSYTNFTDDIP',
'LQNLTAYENHLSGELP',
'LTNIELTQNNLTGKIP',
'LQTLSLDQNQLKGPLP',
'ISLLDISYNQFSGGIP',
'LRRLLLATNDLSGELP',
'ITVLDLSSNRLTGRVP',
'LEDLDISQNGLTGKIP',
'LEYLDLSMNNFVGKIP',
'LTELSLSLNNFSGEIP',
'LLTLNLSQNQLSGEIP',
'LSVLDLSDNQFSGEIP',
'LETVLLDSNNFSSVPD',
'VTSIKLASMSLIGTIP',
'IITLNLANQKLKGTIS',
'LDLIDLANTNLVGPLP',
'LKNVSLDNNHLQGPFP',
'LFDLQLRDNQLTGVVP',
'LTQVWLMNNKFTGQIP',
'LTSLVLFSNSLSGALP',
'LKNLRLSYNNLTGDLP',
'LRNLYLGDNNLTGSIP',
'LQVLDVSNNNLSGDVP',
'LQKLSMRNNINLAPWT',
'VVGIALAGKSLQGYIP',
'LRRLNLHDNEFYGVVP',
'LHSIFLHRNNLSGPFP',
'TVNFDLRSNNLVGEIP',
'SGTLNLSFNHFSGRIP',
'LQRLILARNKFSGEVP',
'LVQLDLSGNDFKGSIP',
'LQNLDLSDNSFSGDIP',
'VIAIDLPSEGIIGPIS',
'LTYVNLGNNALTGGNC',
'LTELYMDYNQLSEKIP',
'LQMLYLADNKLTGIMP',
'LEYLEMQSNFFVGSIP',
'LTKLMLDGNNLQGNLP',
'IEGLILSANKFKGSIP',
'SIVLDLSYNYLSGSIS',
'LERIFLANNKLQGRIP',
'LGKLSFARNRLSGQIP',
'LTSLVAANNSLTGRLP',
'LEELNLNLNNFSGAVP',
'LQRLWLTNNKISGPIP',
'IKVMDISHNNLSGEIP',
'LQVLNLSFNNFDGAVP',
'LNKLIISYNRLSGDIP',
'LTRLQLSNNSFHGGIP',
'LNNLNLDWNNLSGSIP',
'LEILNLAHNSLDGTIP',
'LQILDLQSNSLQGEIP',
'LRNLNLSRNSLEGNIP',
'LRVLFLANNRLSGDIP',
'LEDLDVAYNMLEAGDW',
'IEVFNISLNSFKEQHP',
'PPSLILSHNMLIGPIL',
'VIGLDLQGMKLRGELA',
'LAMFDAGYNMFTGHID',
'LTYISLSNNSFTNVSS',
'IQVFVIANSHLSGSVP',
'LRDLSLQENQLSGRMT',
'LKMLYLRNNSFHGQID',
'LEYFSAQSNLFRGPLP',
'LSSLDLGTNKFIGTID',
'IRVLRFTSNLLSGEFP',
'LEELYVDLNSITGSLP',
'LSSFSVAFNNLTGAIP',
'LQWLNLSSNNLHGAVP',
'LSKLDISFNSFSGYLP',
'LHVLDLSNNHISGMIP',
'LFYLDLSNNTLSGGIP',
'LQRLDLSDNEFSGEFP',
'LKVLDLSWNKLSGNIP',
'LRSLNLATNNLTGEIP',
'LESLDLSHNNLTGSIP',
'LTSLVLTKNFNDGKAL',
'LQYLYLVGNQLEADNT',
'NLDIYAFYCNLEGPIP',
'LTFASVVGNNLCSGIP',
'VAALDLPSSNLTGTLP',
'IQVFGLDVNRFTGVIP',
'LMMLQVGNNMLHGSIP',
'MEALYLEENSFEGGIP',
'LWQLDVSFNKLQGEVP',
'SWFLDLSYNSLSGPLP',
'LLVLDMDHNSISGVIP',
'LTDLYLSDNKFTGFVP',
'LQEFVLANNSFSGQLP',
'LTILNLTMNKLSGRIP',
'LEKLQLRKNSLTGKIP',
'LNGMDLSGNQLSGQIP',
'LRYLFLNANNLSGELP',
'LQHLSLSYNKLEGLIP',
'LQQLFLAHNNFSGPIP',
'LQMLNLENNNISGSIP',
'LFVLDLSYNHLNGSIP',
'LRRLNLSSNQLHGEIP',
'LTILRIQSNPQLGGRI',
'LDRLILGSNRLEAEDW',
'VVSINLTSKELSGVLP',
'LFILNLSMNKLSGQIL',
'LKLLIMSMNLFDGSIP',
'IQQIDLSNNNLIGQVP',
'LLELSMDGNNLNGSLP',
'LETLRFGGNQISGIIP',
'SLGLDLSNNKLSGLIP',
'LSMLDLSANMLSGYVP',
'LTRLEIHSNMLSGKIP',
'LVTVDLQTNSFVGEIP',
'LLSLNMEGNNLSGIIP',
'LRFLGLTGNLLSGRIP',
'LNMLNLSMNNLGGSIP',
'LAHLDLSYNKFEGPVP',
'LSSILLGQNKLSGPIP',
'LEFFDIGSNKLSGQIP',
'LAQLYLDNNSLSGNIP',
'LQSLLLARNNLEGTIP',
'LVLLNFSNNQLSGEIP',
'LIELNLSRNNLSGEIP',
'LQILDLSNNSLSGSVP',
'VVGVALAGKNLSGYIP',
'AGTLNLSHNRFSGVVP',
'LRRLNLHDNRLAGGVP',
'TVTLDLRFNNLSGAIP',
'LHSLFLYGNRLTGALP',
'LQNLDVSRNTLSGGLP',
'LQRLILAGNSFSGEVP',
'LQQLDISSNGFNGSIP',
'VTALNLSSSVLIGPVN',
'LKFLDLSSNKLSGSIP',
'LQYLDLSNNSLSGPIP',
'VQRLRLHGEGLEGVLS',
'MSYISVRSNSLSGAID',
'LLNLGANGQGLTGGIP',
'LDLFDVGSNSFSGAAP',
'FAYLDASRNKLTGSVP',
'LAGFDFSYNNLDGELP',
'LRYVSLAHNALTGRVP',
'ITYFNVSSNNFAGEIP',
'LAHFNVSFNNLTGSIP',
'LESVSLFGNRLSGVIP',
'LNFLDLSENALTGVIP',
'LHKLNLSGNTLSGEIP',
'LRLLDLSYNAFSGEIP',
'LKVLMLGDNALQATKS',
'INRFNTLFNSFEGILP',
'LIYFSVQDNQLEGHVP',
'LELLLLHGNKYHGLIP',
'VTTLNLSNTGLVGTIS',
'ISGIDLSANQIIGTIP',
'LTHFVLEGNIFTGNIP',
'INSIYLSYNRIEGQIP',
'LELLDIGHNNLVGAMP',
'MSSLNLQGNLLQGQIP',
'LQYMDLSGNALMGQIP',
'LAVFDVGHNNLTGDIP',
'IRFFDLGFNRLSGSLP',
'TRLLNLSNNVLTGSIP',
'LIFLSVSNNLLDGSIP',
'LVSLNLNHNLFTGTLP',
'LRAMNLSRNHLSGTIP',
'LHVLDLSANNLDGDIP',
'LIKMDLSMNKLSGEIP',
'LTNLNLSFNKLSGPVP',
'LEILDLSNNNLAGPIP',
'LTKFIVERNFIYGQDL',
'LVKLNLGENHFDGGSI',
'LTYFVIFENSLQGDLK',
'IAYLNLSVNSFQNSIP',
'LQAFIARRNNISGVLP',
'LQVFSLIQNLFEGALP',
'LWFFSIDANNFTGPIP',
'MNIMDLSSNHFTGILP',
'VQRLFLGTNQFSGSIS',
'LSDLLIARNQLRGPIP',
'LGVIALALNGLTGPIP',
'LKYLDLSDNQLHSTIS',
'LQFLDLQVNQLAGPVP',
'LSVLEIDSNYFTGNLP',
'LSVLNLTITNLTGSIP',
'LGVLRLPFNQLSGQIP',
'LASLELSTCNLTGTIP',
'LSSINIRNNGLTGSIP',
'LSRLDLSTNLLDGSVP',
'LVKLDLSHNFLSGALP',
'LQWLDLSENSLFGPIP',
'LELLDLGNNAFSGVIP',
'LSYLNIANNSLSGSIP',
'LETLDLSHNNISGTIP',
'VVALELPNVPLQGELS',
'LTDFIVSENRLHGDLN',
'LQEFRSHRNKLTGQLP',
'LININIQTNYLTGLVP',
'LQTISMHDNLFEGVLP',
'LELLDLGHNAMLGGIP',
'LSWIYIGMNYFTGSIP',
'INSMDLSRNRFLGSLP',
'LSVLNLTNTGLTGLLP',
'LARLVLNENQLDGSVP',
'AEHLFLQGNKFSGSIP',
'LQRIYISINNFTGQIP',
'LWELQLLGNQLTGPIP',
'LEWLVLQHNNLTGPVP',
'ITILNLSTNSIDGSIP',
'LRVIELSDNQLQGAIP',
'LTALDLNGCNLTGAIP',
'LIQLNLSQNFLSGALP',
'LTVIALASNGLTGPIP',
'LRRLIMGNNSLSGPIP',
'LEILRLSNNQLSSTLP',
'LQLLNLQFNQLSGRIP',
'LTSLNLSFNNLHGQIP',
'LLELDLSGNSLVGSIP',
'LQTLDLSHNRISGTIP',
'LTGLTLSWNNFDAGPI',
'VDGLDLESENITGQIF',
'LTDLDLGDNKLESGDW',
'ISRIHMPGNQLNGHIS',
'LESVRLEANFLQGGIP',
'SKGLDISYNQLTGHIP',
'LTAILMGNNMLSGQIP',
'LTEIYFGRNSFTGIIP',
'LSALFIPNNELTGTIP',
'LQNLWLGGNNLQGVLP',
'LTSFILHGNQFEGPIP',
'LRYLCLTNNYISGEIP',
'LQQIILSSNHIHGSIP',
'LTYLNFGDNRFVGRIP',
'LIELYLQENELTGQIP',
'IIEIDFSQNNLSGEIP',
'LVWVNLQNNSLVGEIP',
'LETINLYSNSIEGKIP',
'LSKLMLSGNNLEGTIP',
'ITYIDLSQNGLSGTIP',
'LQILNLVQNQLTGSIP',
'LQLLDLSYNNLSGIIS',
'LRSLNLSFNNLEGPVP',
'LVELNISRNNLNGSIP',
'LRYLNLSVNALSGEIP',
'LLILSLSHNKLSGEIP',
'LNSLNISNNQLSGEIP',
'LVRLSLSSNRLEANNM',
'LNILAAYDAHLEGPIP',
'VVGLSLPSSNLAGTLP',
'LAIITLYSTRLSGLIP',
'SWFLILSDNTLSGPIP',
'LTDVYLDGNKFSGFVP',
'LWHLDVSFNNLQGKVP',
'LQKFFLRGNSVSGSIP',
'LNSIELSGNQLSDQIP',
'LQQLDIAENSFIGQLP',
'LFALDLSINHLNGSVP',
'LINLTLGYNQLSGHIP',
'LDTLDLGSTSLSGVIP',
'LEYLLLDSNSFEGGIP',
'LAILNLTMNKFSGSIP',
'LRILDLGSNSFSGAFP',
'LQQLCLAHNNLSGSIP',
'LRWLNLSSNGLHGEIP',
'LQFLSLTINSFVNISG',
'MKALRVSHNLIGGQVA',
'LTALLVSYNFYGEALP',
'ITRLSLPGRGLGGTIS',
'VTIVDVSYNCISDELP',
'VRVIVMENCALTGTIP',
'LQHLHLPSNQIEGRLD',
'LRCIDLRSNRFTGDLT',
'AATLNLSDNGITGTIS',
'LAIFNVAYNDLEGPIP',
'LAVLDLSVNMLTGAIS',
'LQVLDVSSNLLAGQFP',
'LEELRLIHNNLTGKLP',
'LTIFDVDSNNFTGTIP',
'LVSLNASNNSFRGTIP',
'LRVLSAGRNNLTGELP',
'LQILDLRWNHLTGTIP',
'LVTLDLSYNLLAGELP',
'LVYLNLSGNDLSGPFP',
'LQVLDVSYNNLSGGIP',
'LYYLDLSGNLLSGEIP',
'LNILNLSGNRLTGPIP',
'LRGVYLFNNRFSGAVP',
'LMRLNLSHNTISGDIP',
'LRRLSLHDNAISGPIP',
'LQAFDASNNLLTGAIP',
'LQAFNVSNNNLSGQVP',
'LAVLELSHNSLDGQIP',
'LVFLSLSHNKLSGHIP',
'LQVMDLSGNRLNGTIP',
'LKTLDLSGNALTGEIP',
'VVQVRLPGVGLIGAIP',
'LQVLSLRSNRILGGIP',
'LAVFNVSDNNLNGSIP',
'LRLLFLQNNLLSGAIP',
'LRALRLDGNKLSGNIP',
'LERLVLSSNNLSGPIP',
'ITSITLNAANLGGQLG',
'LTSLNIENNLFSGPVP',
'LANLDFSSNNLTGPLP',
'LITFFLSGNQLSGSIP',
'LTGLSLNNNHLSGEIP',
'VTSLALPGTPLHGQLS',
'LEQFDVGENHLQGDLG',
'LSHVNFANDTLSGSIP',
'LAVLNLTGAGITGPIP',
'LTGILFGGNELVGTIP',
'LTILELSVNRLSGSFL',
'ARIISLSQNLFTGPIP',
'LSSLILLNNQLSQEIP',
'LSRLDFSFCKLYGEIP',
'LDFLNMQINHLSGEIP',
'LEYISLSQNNLSSGLP',
'LERIDIARNNFAGPIP',
'IDKIDLSDNSLVGSIP',
'LQLLSLHTNSFTGRLP',
'LVVFDVDSNRLTGGIP',
'LRMLYMANNNLTGPIP',
'LTILNLSFNELHGPVP',
'LVQLYLYNNEFSGSIP',
'LQVISLSLNNFTGPIP',
'LTYLNLSHNSFEGSVP',
'LVHLNLSHNSLTGALP',
'IQFLDLSINSLSGEIP',
'LAALDLSSNNLSGTIP',
'VQGLQLERLGLSGAAP',
'LRVLSLANNAIAGAFP',
'LLELSLAHNQFNGPLP',
'LTMLYLSRNRFSGVVP',
'LRKLHLSSNELSGPIP',
'LRYVDVSSNNLSGPIP',
'VTGLEFEDMALEGTIS',
'LNTIGMSYNAFEGSLL',
'LRRIFVDGNQLSGNLE',
'MEIFVADNNRITGSIP',
'LQAIAVTRNNLRGPIP',
'LSSLVLSNTTLIGPVP',
'LEVFSLNENWFDGPIP',
'LDAISLAVNNFTGSVP',
'MIYMNLSSNLLQGSIP',
'LRYISFANNQITGTIP',
'LESLYLNSNKFFGGIP',
'LQVVVLSQNSLSSTIP',
'LTAIYLSTNELTGKIP',
'LSRIQLGSNRLTGAIP',
'ITKMDLSRNQLSGDIP',
'LVKLHLANNQLVGPIP',
'LLMLSLSGNQLSGMIP',
'IEELDLSSNVLSGVIP',
'LTTIDLFGNGLTGSVP',
'LEMLVLENNLLSGSIP',
'LANLNLSFNRLEGQIP',
'LLALDLSENKLEGEIP',
'LQILRLSDNDLSGPIP',
'LQTLVLSYNSLSGTIP',
'LIELDLSQNSLSGSLP',
'LQELNLSNNTLSGTIP',
'VDRLELSGKNLSGKVA',
'LETIDMRGSFFGGAIP',
'LAVLNISNNAFATTLP',
'LSFIDVSRNHLQYSIP',
'LRLLNLMCNHLDGVVP',
'LVAVNASGNNFAGPLP',
'LVRMRVHGNRLNGTIP',
'LQYLDLAVGNLDGPIP',
'LIKLIMFNNGFTGGIP',
'LQSFLASDNMISGELP',
'LKVFDVSQNSFEGGFP',
'LESLIIGYNELEGGIP',
'LQWVDVSSNGFTGGIP',
'LVKLNLRRNKLAGEIP',
'LTSLYLYKNNLEGKIP',
'LAALDLSNNRLAGAIP',
'LAILDLSSNVLTGGIP',
'LKFLGLSGNNITGKIP',
'LVFLDLSDNAFTGAIP',
'LEVLELWNNSLTGSLP',
'LQRLELAGNDLSGEIP',
'LETLNLAYNNLTGPVP',
'VVGVAVAGKNLSGYVP',
'AGTLNLSRNHLSGGVP',
'LHSLFLYGNSLTGGLP',
'TVTLDLRFNNLSGEIP',
'LRRLNLHGNRLSGTVP',
'LQRLMLSGNGFSGEIP',
'LQLLDLSDNSLTGAIP',
'LQNLDLSDNSLTGSLP',
'VAALNLSGVGLTGALS',
'VTHLDISGNLLKRRIP',
'MVELFLNDNRLSGEVH',
'LLRVDFTRNRFRGAIP',
'LAVLDLGNNQFDGGFS',
'LEMFSMAENGITGSIP',
'LKFLGLYRNQIAGELP',
'VATLLLGGNNLSGGVP',
'LEKLVVTANRFTGTIP',
'LQKLYLDDNHFAGELP',
'LQKLYLYNNLLHGPVP',
'LPVLDLSGNGFTGAVP',
'SQGLNISNNRLSGPIP',
'LSVVNISFNELSGQLP',
'LDTLLMSSNRLTGAIP',
'LREITLYNNNFTGELP',
'LLELQLGSNNLEGGIP',
'LVDLQLHKNSLTGTIP',
'LYRVNLNNNKLSGSLP',
'LQNLLLGGNKLAGPIP',
'LRYLDLSINRLTGPMP',
'LIMLYLNSNNFTGSIP',
'LVEVDLNGNALTGEIP',
'LAHLDLGNNLLNGSIP',
'LTVLFLSYNNLTGEVP',
'LTRLDVSGNKFSGPIP',
'LEYLDLSGNSLSGAVP',
'LEVLDLSNNSLSGPIP',
'LESFLASRIKLSESIM',
'VVMLFLQNNEFSGSII',
'LTELIISENGLQGDLN',
'LKILDLGHNDMLGGVP',
'IYKMDLSSNHFLGSLP',
'LKVFSLLDNLIEGPLP',
'LSVLCINSNRFTGILP',
'LRSINIQMNYLTGLIP',
'ITYLNLSINSFNDSIP',
'LSVLLLDDNHLDGLLP',
'LSVLNLSNTGLMGSVP',
'LERLVLQCNNLTGPVP',
'LNFLDLAMCNLTGAIP',
'LQFFSLDYNYFTGQIP',
'LHVIALASNGLTGPIP',
'LEHLRLSNNQLSSTVP',
'LASLNLSFNNLHGQIP',
'LHMLDLSGNNLAGSIP',
'LKHLIIGNNSLSGPIP',
'LIELDLSRNLFSGALP',
'LDVLDLEFNSLSGPIP',
'LSVLRLSTNQLTGPIP',
'LQTLDLSHNNISGTIP',
'LNVISLGENLLVVGPI',
'LLSIRLPASALAGHLP',
'LSLLRLHGNALHGPIP',
'IHSLNLSYNNFSGQLP',
'LASIFLAHNSLSGPIP',
'LSLLDLSANRLSGPFP',
'LRSLDLSDNRLHGPIP',
'LSLLDLASNRLSGSLP',
'LTSLVLTNNFRGGETM',
'LSNRSLSRNSLRGGEA',
'LSYLSLTGNGFTNLSS',
'MQVLVLANCALLGTVP',
'PSSLILSNNKLVGPIL',
'LNNFDAGTNKLRGAIP',
'IEVVNVSSNGFTGPHP',
'VKVLRFSANAFSGDVP',
'LTVLDITGNAFSGGIN',
'LRKLSLQENKLSGSLD',
'ITQIDLSYNMFNGNIP',
'LRRLDLSANGLAGAFP',
'LRVVSLRNNSLSGEIT',
'LNDLFLDGNGLTGSLP',
'LSVLDISWNNLHGEIP',
'LRTLNLARNKLQGELP',
'LSKFDVSYNNLSGDIP',
'LESLNLASNQLNGTLP',
'LFYIDLSNNSFSGELP',
'LEILDLAHNDLSGSIP',
'LHVLDLSFNNFSGPIP',
'IIGLSLSGFGLQGGIP',
'ATTLDLSNNALVGVIP',
'VVNLDLSGNQLSGQLP',
'LNSLKLSGNSFSGQIP',
'LKSLDLSDNRLDGQIP',
'LQVIDVGDNWLGPAFP',
'LERLDVSWNRFVGPFM',
'LKVLTLSGLGLWGPLP',
'IRYLNVAGNRFTGVLS',
'LEIVNMSGNYLYGGVP',
'VVTVVLSRNRFTGGLP',
'LAVLSLRNNSLGGAVP',
'LQFVDLSSNLLTGSEP',
'LQTLILDDNLLAGELP',
'LRSLVLASNNLTGNLP',
'ISALRVPAAGLIGAIP',
'LQSIFLQDNELSGDLP',
'LNTIDLSYNSFAGQIP',
'LQVLSLRSNRLIGSIP',
'LRQLNLSNNELNGSIP',
'LSTLNLSKNSLSGPIP',
'VTGLNLAAMNLSGAIP',
'LQLLNLMCNKIKGGIP',
'LQTFAAADNELTGGVP',
'LETLDFRGGFFSGGIP',
'LVRVRAHNNRLNGTVP',
'LNTVYLYKNNIGGQIP',
'LQYLDMAIGSLEGPIP',
'LSFIDLSHNQLRSALP',
'LTSIVLQSNAFDGELP',
'LRELDVSDNNFKGRFP',
'LEQLIIGYNEFSGAIP',
'LTKLILFNNVFTGAIP',
'LTHLNASGNNFAGPLP',
'LQWLDVSTNALSGPVP',
'LIMLDLSDNAITGTIP',
'LKFLGLSGNNLNGALP',
'LEMLNLAYNNLTGPVP',
'LVSLSLRNNRFTGQIP',
'LEVLELWNNSLTGPLP',
'LQRLELAGNELSGEIP',
'LSALDLSNNRLSGAIP',
'LSVLDLSNNFFSGEIP',
'VTAIKLPSLGLSGNLA',
'LIEIDMSQNNLGGGQQ',
'LKKLYLQNNQFTGYIN',
'LKYLNLNHNQLQGNIT',
'LDDLNVANNHFTGWIP',
'LTTLDLSFNSLAGDLP',
'LERLNLAGNQFTGNLP',
'RELYLGYFNSFTGGIP',
'LVRLDMANCGISGVVP',
'LTQIELHDNLLSGELR',
'LETFIALGNSLFGSIP',
'LDTLFLQINALSGRLP',
'LQSLNLSNNILNSTFP',
'LVHLHLGGNFFFGSIP',
'IGELSLYNNRLSGPVP',
'LEVLQLWENNFTGGVP',
'LRIVDVSTNRLTGVLP',
'VLSLDLSGLNLSGPIP',
'LTAVDFSDNNLSGEVP',
'LSKADLSGNLISGEIP',
'LTRLRLGENYLNGTIP',
'LTLLNLFRNRLAGEIP',
'LRVLDFYNNNLTGALP',
'LQKLLVAGNRLSGELP',
'IKYLALSGNELTGEIP',
'LNYLNLSHNALDGEIP',
'LKSLDLSNNLFVGEIP',
'LTFLDLSGNRLSGRIP',
'LKSLLLDTNQFDGRYP',
'LSVVMIQNNNFSGTFP',
'LYSIVVFNNSFSGKLP',
'MKVFRAANNLLSGEIP',
'LQILYLYANRFTGEIE',
'LTHLDVSYNNISSPFP',
'LTYLWLSNMNITGEIP',
'LTDIRLFNNMLSGSLP',
'LQNLMLYNNNFSGEFP',
'VRLVDLSGNQISGSLP',
'LVEIDVSANELTGTIP',
'FTRLDISNNRFSGPIP',
'LKYLDLSNNAFAGKLP',
'LNVLDLSSNKIQGKIP',
'LNTLYLSGNQISGNIP',
'LANLEVSNNNLSGELP',
'LTLLFLYFNKLSGSIP',
'LEHLNLSSNHFTGRIP',
'LSFLNLSMNQLTGEIP',
'LNDLDLSSNKLSGEIP',
'LERLTLAVNPFVPAPF',
'VTSLSFQSFQIANPIP',
'INNIMAYNNHFVGDFP',
'LEMLYLFASNFSGEIG',
'LKNFMAENNQFSGALP',
'ITRIEIGNNMFSGALP',
'LKSLVLDTNSFNGSYP',
'LYDLVVFNNSFSGVFP',
'LINIMIYNNNFTGNLP',
'LTYLWLSWMNLTGDIP',
'MQHLNLSSNYFIGDVP',
'LILLDLSKNKMQGKIP',
'LGNFEVSNNNLSGELP',
'LTDIRLFNNKLSGPLP',
'VNFLNLSSNQLSGEVP',
'MQELDLSMNKLTGSIP',
'LRLLYLYYNNLTGSIP',
'LKYLDLSYNNLTGDFP',
'LTELDLAGNRLSGLIP',
'LNILDLSNNKLTGHIP',
'LTSLNLSSNQISGEIP',
'LQFLDLSNNELTGSLP',
'VELEILTLASNPFMPG',
'VTGLSLPSLHIARPIP',
'INNIMAYNNHFVGDFP',
'LFDIVVFNNSFSGVFP',
'ISRIEMENNRFSGALP',
'LKSLVLDTNRFNGNYP',
'LENLYLYASNLSGEIG',
'LKMLWLSWMNLTGTIP',
'LKSFTAENNQFSGELP',
'LTNVMIYNNNFTGTLP',
'MQHLNLSSNAFTGDVP',
'LTLLDLSQNKMQGQIP',
'LTYIDLSCNNLTGDFP',
'LGNFEVSNNNLSGELP',
'LTDIRLFNNKLSGPLP',
'LRLLYLYYNNLTGPIP',
'LYILDLSDNGLTGDIP',
'LNFLNLSSNQLSGEVP',
'LTSLNLSRNQISGEIP',
'LQELDLSMNKFSGSIP',
'LEFLDLSNNQLSGRLP',
'LTELNLAGNQLSGSIP',
'VELETLTLASNPFEPG',
'LGALVAHNNFLTGSPP',
'VVALSLGSSSLSGLIS',
'LTILTLASNKIVGNMP',
'LETFDAGENMFDGHIP',
'LKHFSVENNELSGMLP',
'LSRFQIAENHFSGVIP',
'SIYLDISYNHLDGSIP',
'LNALGIQHNQLSGGIP',
'LYFLNLGFNMLFGEIP',
'LRILWLDNNYFSGPFP',
'LTSLLLQANGLIGSIP',
'LSSLRFSFNNFIGTIP',
'LQILYLQNNSFIGNIP',
'LYDLNLSYNNFDGEVP',
'LEVLELEANKFSGTLP',
'MDSLDLGRNNFSGSIP',
'LESLSLDSNHLRGEIP',
'LVYLDARYNQLSGEIP',
'LRVLDLGANQLVGQIP',
'LAYLNLRANNLSGEIP',
'LRELNLSGNSLEGGIP',
'LEILDLSSNNFSGQIP',
'LKWFILTENDLEAKES',
'LTSYDVSGNSFAGHVD',
'LSFLSLTGNSFSNVSS',
'IEVLVIANGELHGAIP',
'MREFNVSYNAFNGSHP',
'PPSLVLARNNLTGGVP',
'LQVLDVSVNALEGAVA',
'LVELSLDGNAIAGALP',
'LRILNLRNNSLAGDIG',
'VHVVDLSWNALSGPIP',
'LQELSAPSNLLTGVLP',
'LRTLRLSMNGFSGDFP',
'LSHFDVAYNNLSGEVP',
'VESLDVSHNALSGAIP',
'LQVLSLHTNSLSGHLP',
'LRVLNLSSNALRGALP',
'LKVLDLSWNHLAGPIP',
'MTALNLGRNNLTGEIP',
'LFYLDVSNNSLHGEIP',
'LVRLDVSFNNFTGDLP',
'LVYLDLGVNRFTGPIP',
'LTSLVLTKNFHGGEAM',
'VVSLQMANNGLAGTLS',
'LQTMLLQNNMISGGIP',
'LNYLRLDKNNLSGQIP',
'LKALDLSGNQFVGEIP',
'LTFLDLSSNNLSGPVP',
'IEVFNISLNSFKEQHP',
'PPSLILSHNMLIGPIL',
'VIGLDLQGMKLRGELA',
'LAMFDAGYNMFTGHID',
'LTYISLSNNSFTNVSS',
'IQVFVIANSHLSGSVP',
'LRDLSLQENQLSGRMT',
'LKMLYLRNNSFHGQID',
'LEYFSAQSNLFRGPLP',
'LSSLDLGTNKFIGTID',
'IRVLRFTSNLLSGEFP',
'LEELYVDLNSITGSLP',
'LSSFSVAFNNLTGAIP',
'LQWLNLSSNNLHGAVP',
'LSKLDISFNSFSGYLP',
'LHVLDLSNNHISGMIP',
'LFYLDLSNNTLSGGIP',
'LQRLDLSDNEFSGEFP',
'LKVLDLSWNKLSGNIP',
'LRSLNLATNNLTGEIP',
'LESLDLSHNNLTGSIP',
'LTSLVLTKNFNDGKAL',
'VTNITLEGQNFTGELP',
'MKTIILRNCSINGSIP',
'LGKLQIEGSLLEGPIP',
'LLQLDLSRSLLHGGVP',
'VDHIYLTGNSLTGSIP',
'LTNLSIEGNNFYGPIP',
'MEKLILSANEFSGPLP',
'LQGLSLMGNNLSGPFP',
'LTDLRISGNNFSGRVP',
'LKHLDLSFNKLTGEIP',
'LYDLRISDLRGRGSVF',
'LRVLILSTTCMHGGVP',
'VTAIDVTSWRLSGRLP',
'LREVRLGYNDIRGGFP',
'LEVLNLSCSGVSGAVP',
'LLRFRVSNNHLDGDVP',
'ASIIDLSYNHLTGPVP',
'LQYILVLSNLLTGAIP',
'FNVLEVSENQLTGPLP',
'LTSLFASNNRMSGVLP',
'LRVLQMYTNKLTGAIP',
'LQLLELYYNLLEGVVP',
'PNSLDFSNNNLSGPVP',
'LVKIDLSNNQIGGAIP',
'LRILSVYRNQLTGELP',
'LRVLDVSNNYFSGAFP',
'LNQLSLQGNRLNGSIP',
'LNVLNLSYNALAGEIP',
'LTDLELSGNLLTGHIP',
'LTDIDLSENNLTGGIP',
'LEVANFNENPGFDIWW',
'VTSLSLPNVAVAGAVP',
'ITVLLQNNGHLTGSLP',
'LTVLNLQNTSVGGVFP',
'LKTVWLAQCNLTGDFP',
'LQYLFLYTNQLTGDVV',
'LWIISAAGNRLNGSIP',
'LKVFTLNCNQLTGTIP',
'ITSIDLSMNSIGGELP',
'LRDIEVDNNDLTGPIP',
'LVIMKLFENNLTGQIP',
'LSQMNFSRNQFTGDIP',
'LQKFNAENNLFSGEIP',
'LTRLYIHNNRFSGRLP',
'LLSLQLQDNELSGEVP',
'LTNLALMTNNFSGEIP',
'LTYLALNNNNFTGVIP',
'INQLNLSSNQLTGEIP',
'MEYLDLSQNSFTGSIP',
'LIYLDISENQLTGTIP',
'LQELDLSRNQLSGAIP',
'LTLLDLSSNKLSGGIP',
'LETLKLEVNQFTPGEL',
'VVALELPNVPLQGELS',
'LTDFIVSENRLHGDLN',
'LQEFRSHRNKLTGQLP',
'LININIQTNYLTGLVP',
'LQTISMHDNLFEGVLP',
'LELLDLGHNAMLGGIP',
'LSWIYIGMNYFTGSIP',
'INSMDLSRNRFLGSLP',
'LSVLNLTNTGLTGLLP',
'LARLVLNENQLDGSVP',
'AEHLFLQGNKFSGSIP',
'LQRIYISINNFTGQIP',
'LWELQLLGNQLTGPIP',
'LEWLVLQHNNLTGPVP',
'ITILNLSTNSIDGSIP',
'LRVIELSDNQLQGAIP',
'LTALDLNGCNLTGAIP',
'LIQLNLSQNFLSGALP',
'LTVIALASNGLTGPIP',
'LRRLIMGNNSLSGPIP',
'LEILRLSNNQLSSTLP',
'LQLLNLQFNQLSGRIP',
'LTSLNLSFNNLHGQIP',
'LLELDLSGNSLVGSIP',
'LQTLDLSHNRISGTIP',
'VDGLDLESENITGQIF',
'LTDLDLGDNKLESGDW',
'ISRIHMPGNQLNGHIS',
'LESVRLEANFLQGGIP',
'SKGLDISYNQLTGHIP',
'LTAILMGNNMLSGQIP',
'LTEIYFGRNSFTGIIP',
'LSALFIPNNELTGTIP',
'LQNLWLGGNNLQGVLP',
'LTSFILHGNQFEGPIP',
'LRYLCLTNNYISGEIP',
'LTYLNFGDNRFVGRIP',
'LQQIILSNNHIHGSIP',
'LIELYLQENELTGQIP',
'IIEIDFSQNNLSGEIP',
'LVWVNLQNNSLVGEIP',
'LETINLYSNSIEGKIP',
'LSKLMLSGNNLEGTIP',
'ITYIDLSQNGLSGTIP',
'LQILNLVQNQLTGSIP',
'LQLLDLSYNNLSGIIS',
'LRSLNLSFNNLEGPVP',
'LVELNISRNNLNGSIP',
'LRYLNLSVNALSGEIP',
'LLILSLSHNKLSGEIP',
'LNSLNISNNQLSGEIP',
'IRKISLSFNNLDAPLH',
'VTSLNLTNRGLVGKIS',
'LNIFSMKDNLLEGHVP',
'LKELIFVSNQIEGNIP',
'LYMLDIALNYFTGIIP',
'LKAIWLDSNDLVGQIP',
'LKVLYAGANKLEGKFP',
'LQDLGLAANLFQGHIP',
'LTMLGLEDNKFTGIVP',
'LEELFLESNQLYGYIP',
'LQGIELANNFFTGLIP',
'LEDIELDHNVFSGSIP',
'LQFLYLSNNTLQGMIP',
'LQHLLLGTNKLSGDFP',
'LKFLLLPTNSLTGEIP',
'LTYLQLSSNNITGYIP',
'LSVLSMSNNSLHGSIP',
'LEQLDLSFNNLKGEVP',
'LTGLSLAYNNLSGELP',
'LQQLQLYNNNLTGTIP',
'LKVLKLSNNNLTGSIP',
'LKYFACVNTSIEGNIP',
'VVALNLTNRDLVGTIS',
'LSWLNLEENKLHGRNN',
'LQIIKFDHNIFTGGIP',
'LYLIDVSNNNFSGGLA',
'LQMFSISWNRLEGRLP',
'LQYVHMGQNQLSGQFP',
'LTELSFAINDLHGEVP',
'LMVLDLYRNNLAGKFP',
'LQAFELGGNHFNGKIP',
'LQKLTVGDNNFTGLIP',
'IQYIDLSFNNLEGLLP',
'LGQLDFSFNHLNGEVP',
'LERLGISNNNFDGTVP',
'LEKLRLSFNNIMGTIP',
'LKFLHLGINKLTGSFP',
'LQTLSLASNTLQGRIP',
'LVHLFLYSNKFSGQLP',
'LKHLNLTGNAFTGQIP',
'LVVIELSGNRFSGVLP',
'LIYLVLSSNNLSGEIP',
'LTLLNLSYNNLTGPIP',
'VLNLHLSNMGLQGQFP',
'LTTFSVADNLLTGPIP',
'LNILNLQHNRLSGQIP',
'VTSLDLSYNSFSGEIP',
'LTGLDLSSNNFSGPIP',
'VIGLNLANLGLSGKID',
'LMELLLDDNAFEGAIP',
'LKKLWLDHNDFSGPVP',
'LRAINFNNNSFSGPLP',
'LKTFNAANNKLSGPIP',
'LKSIYLAGNKFSGSIP',
'LNYLNVSHNSLSQQIG',
'LTTLNIANDNFSGWIP',
'LSSLYLQDNQLTGPVN',
'LKTLNLAKNNLSGNLP',
'LSELDLSFNNLTGDLP',
'LLVFHFCFNKFTGQYP',
'VSTLDLKGLGLSGSIS',
'IQSIRMSHNFLVGSVP',
'LETFAFASNELHGEFP',
'LAYLAIDENHLEGVIP',
'NSLMNLSNNFLTGPLP',
'LNTLDLALNTIYGKIP',
'LSKLYMGGNRIYGSIP',
'LQILNASSNLIGGAIP',
'MEVLSMSDNSFTGLIP',
'LQELQISVNKLTGTVP',
'LQFLYLQDNHFTGDLP',
'LIHLELYGNELEGTIP',
'LRILGLAGNKLLGEIP',
'LRVLKLGQNLLTGNIP',
'LTLLNMSHNLISGEIP',
'LIALDLSNNLLSGKIS',
'LQFLNLSLNNLEGEIP',
'LLSLDLSTNRLNGSIP',
'LTTLNLGTNNLSGPIP',
'LQSLDLSSNKLSGSIP',
'LHDLIMYNIGFNFFVS',
'LASLFLYSNLLSVLRL',
'LATIALAACNLTGSMP',
'LLSFDLTNNSFNFEIP',
'LQMLTLYHNGLVGQLP',
'LRMIDFFGNQFAGSIP',
'ITRVNLSNNRLNGSIL',
'LVRLDLSYNGLRGRLD',
'LYELQLSRNLFSEEIP',
'QSTLDLSFNKLIGEIP',
'LRIMNLADNSLQGAIP',
'LEQFMLYNNSLEGSIP',
'LSFLHLRQNGLSGAIP',
'LTDLVLNNNSLSGSIT',
'LSHIVLNDNHLSGSIP',
'LLKLSLDNNLLNGSLP',
'LERIRLGSNRLVGEIP',
'AVALDLSSNRLTGSIP',
'LVYLNLGGNHLQGPIP',
'LSFLVLSQNNLSGRLP',
'LNVLNLAHNQFSGAIP',
'LENLVLRENQLTGSIP',
'LMQLDLANNSLTGAIP',
'LGELRLSSNGFSGSLP',
'LQHLLLSTNNFSGRIP',
'LEILYLYENQLSGEIP',
'LQTLDLSVNKLEGEIP',
'LTILDLADNQLSGRIP',
'LEELNLSHNLLSGEVP',
'LSLLYLSSNSLTGEIP',
'VQLGLAANNFQEGDIP',
'VIGISLANLSLSGKIS',
'AVIIDVSDNSFTGGIS',
'LTIFHIYSNNFWGEIP',
'LSSLHLENNELIGYVP',
'LTWLFLAQCNLRGEIP',
'LQFLLALDNNFSGEFP',
'LQRFRICQNNFSGKIP',
'LVSFSIYQNNFSGEFP',
'LSSLDLGANAISGIVP',
'LYKIELYQNNLTGEIP',
'LNAVDISENSFSGEFP',
'LTQLYVQNNRFSGKLP',
'LQKLFAFNNSFSGKIP',
'LRVLDLSTNRFIGKFP',
'LGTLDFSGNQISGKLP',
'LSLIDFSENQLSGRIP',
'LVDLNIAQNSLSGDIP',
'LREFDISRNQLTGKLP',
'LQVLNLSTNSLIGQLP',
'LNSLNLSDNKLTGSIP',
'VAELSLDGFSLSGKIG',
'IGAISLAKNAFSGVIP',
'LQQILISENKLHGSIE',
'LKELKLSSNHFMGSFP',
'LSVVDFNQNSLTGNLP',
'CTSLSLSSNSFTGEVP',
'LRSISLRGNRLSGHLP',
'LLSFNISHNLLSGAIP',
'LKELRLEKNSLSGGIP',
'LRTLSLSKNNFSGSLS',
'LQFLNLSCNSFSGSIP',
'LQVINLSRNRLTGNIP',
'LRSLDLSDNALVGEIP',
'LETLDLSRNGFSGQLP',
'LAALDLSSNRLSGSLP',
'LQVLDLSSNAFSGNIP',
'LKSLDLGGNLLSGSLP',
'LATLDLSQNNLTGPIP',
'LRNLDLSENKLSGPIP',
'LEFLDLSGNRLNGSIP',
'LKVLSLTSLGLWGPLP',
'LQVLDLERNFLGPQFP',
'LRYLNVAGNRFTGKLF',
'LQTLILDRNLFGGRIP',
'LEIVNLSSNFLYGAIP',
'LAVLSARNNSLSGPLP',
'LQQLDISSNRFVGPFP',
'LRVLALSSNSLSGQVP',
'LEFIDLSSNLLSGNLP',
'VTSIKLSNMGLNGKVE',
'LVTLDNFNSAITGGIP',
'LISIKLNNNKLTGTLN',
'LSVLDLSHNKLNSEII',
'LDTLDVSNNMLTGYLP',
'MTALDLSYNQLTGSFP',
'LQFLNMQNNKLTGSIP',
'VQEILLQQYNLQGPLA',
'LHAVYLFENEFSGNIP',
'LQVFSASQNLIVGGIP',
'IQSMDLSYNALDGALP',
'LEVLDLSDIGLYGNLP',
'LRRLNMHTNRLNGNIP',
'LNTLELTHNNLTGGVP',
'LVLLDVSYNDLHGAIP',
'LTRLALARNRFTGEIS',
'LLELNVAANSLSGVLP',
'LRSLDLHVNKFTGAIP',
'LQFLALDRNLLNGSIP',
'LRSLDLTSNKIVGSIP',
'LASFNVSRNNLTGTIP',
'LETLNLQRNALSGGIP',
'LRTLNLSGQSFTGSIP',
'LQVLQLGANELSGSLP',
'LQTLNISRNHFTGGIP',
'LTTLSLATNDLTGPIP',
'LQILRLGENLLSGPLP',
'LERLDLSRNQIGGEIP',
'LNVLALGNNLLSGSIP',
'LRELDLDDNRLNGSIP',
'LTVLSLSGNSLSGSIS',
'LQVLDLRENSLSGPIP',
'LRVLSLSGNKLSGSLP',
'LRVLSLMNNNISKVIY',
'IIGLTLQNASIVGSLP',
'LSVLDLSFNQLTTDPN',
'LRSVNLSRNAFTGAVL',
'LQELYLDNNLINGTLN',
'LYVLDLHDNAFEGEFP',
'LQILNIARNDFKGPIP',
'LVELDLSSNALNGTAP',
'LLTLDLSGNKFNGSFP',
'LQVLDLSSNMFTGTLP',
'LTTLELTGNPQLTGPL',
'VTNISLQGRSLTGFIP',
'LTALFLHFNELRGGIP',
'LTDMYLNWNQLSGAIP',
'LETLAVNANNLNGTIP',
'LIYLDVSHNLLSGPVP',
'LQVLELSCNNLEGEIP',
'LQRLDVSNNTLTGKIP',
'VTSLDLSNSQLSGDVA',
'LESLNASGNNLVGHVQ',
'LHYLNIANNQFSGPLP',
'LRDLDLSDNQLSGTLD',
'LQTFNIENNQFTGNYP',
'LTVVNLSNNNLTGNMN',
'VETFDVSYNQLEGTLP',
'LTQMILNNNKLTGGLP',
'LRIFDASNNNIEGNIP',
'LRFLNLQNNKFNGKLP',
'VAFIDLPYANLTGTIS',
'LEVLNMRSNAISGNIP',
'LKRLSLLNNQFRGKIP',
'LLYLNLSNNLLVGRVP',
'LRLMDLSNNELEGPIP',
'VIGLGTPSQNLSGTLS',
'LQTVLLQSNNITGPIP',
'LEYMRLNNNSLSGEFP',
'LHTLDLSDNFFTGKIP',
'LVLLDLSFNNLSGPVP',
'VVELRLPGVGLLGHVP',
'LNTLSLRSNVLEGDLP',
'LQNLFLQHNNFSGGVP',
'IKHLNLSYNHLNGSIP',
'LTGLSLQNNALSGPIP',
'LNVLDLSFNSFTGNIP',
'LYKLTLHNNHLCGVIP',
'LNFLYLDKNNLTRRIP',
'LFRFRLDGNQLSGNIS',
'LVNFTAANNHFSGPIP',
'LNYVDLSHNDLSGELK',
'LTAVDISYNELEGPIP',
'LACLLLSNNNISGEIP',
'LVELKLSSNNFTGHLP',
'LETMNLSHNKLSGLIP',
'LLTLNLGNNSLYGTIP',
'LQIIDLSSNLLKGTIP',
'LGHLDLSGNLLAGEIP',
'LSILNLKNNKLSGSIP',
'LQSLNLASNNLGGSIP',
'LLQLNLSHNKFTGSIP',
'LTRLDLNNNNLSGSVP',
'LTYLDMRNNSFDDTEF',
'VTSITLASMGLKGSLS',
'LTNLILVGCSFWGPIP',
'TKHFHLGLNQLSGTIP',
'VSTMFLSNNDLTGPLP',
'LIHVLFESNKLTGSIP',
'LEVVRLDNNSFRGPVP',
'LASLSLNSNGFTGSIP',
'LYWLDLADNRLTGTIP',
'LQILDLSYNKGLSGPL',
'VWSLDLNSMNLSGTLS',
'LLGCNFSYNELTGSLP',
'LVEFVAYTNKLTGPLP',
'QIGMNLSYNSLTGSIP',
'ATEIDFSENFLTGKIP',
'LSAIELNQNMFTGPLP',
'LQRLHIANNYFTSELP',
'LVQLRLVGNKFTGGFP',
'LKLLGLAQNKIGGELP',
'LKTIRAGQNQISGSIP',
'LETLALYANALAGPIP',
'LWVVDFSDNDLTGRIP',
'MLQLQLFNNSLSGGIP',
'LTELILWENQISGLIP',
'LERLNICNNQISGSLP',
'LILLNLDSNRLYGNIP',
'LTELQMGGNSFSGRIP',
'LQRLDLSHNSFSDALP',
'LKKLYLYRNGLNGTIP',
'LRLLYLFQNQLTGVIP',
'LVTFNASSNLLTGKIP',
'LRYFDLSHNEITGDIP',
'LQYFYLNNNQLSGEIP',
'LEFLLLNNNHLTGEIP',
'LELLRLSENKFSGNIP',
'LTKLDLSINHLTGPIP',
'LRELYLGSNRFTSIPT',
'LQKLNLAENILTSKSL',
'LEELYAFDCRIIGNIP',
'LAYLRFNGNPLRGRLP',
'LRLINLRANSLSGILQ',
'VTSLNLYSMRLEGTLP',
'LKTFNVSFNRLQGEIL',
'LMEIHVENNNLTGVIP',
'LAHFSLSDNRMQGPIP',
'LETLNLEGNFIEGNIS',
'LRRVNMAYNYLSGHLP',
'LKDMNLAYNNFAGDIP',
'LEKLGLEVNGLNGNIP',
'LIGLILQQNELTGAIP',
'LQDFSLASNKLQGHIP',
'LVSINLSNNSFHGYLP',
'LKILDLGHNHFSGVIS',
'LSYLYLLENGFSGSLP',
'VTVIDFSSNQLSGDIP',
'LQHLFLTNNSLAGSIP',
'LEELYLEKNELSGPIP',
'LEVLNLGYNQLHGRIP',
'LKELYLGKNNLTGQIP',
'LLQINLSFNSLTGTLP',
'LQELDLGFNNITGSIP',
'LRVLDLESNRFTGSIP',
'LIVLDLSYNSFSGRIP',
'LEFLDLSRNSLSGAIP',
'ITSFQLKDYSLPGRLP',
'RQFTFLSGNKLTGTVQ',
'RQFLVLRNINLTGTIP',
'VQKIDFTRNYLYGTIP',
'LQKLELYATGLQGPIP',
'EKTLDLTFNKLVGEIP',
'LKDFRVSDNNLNGTVP',
'LSFISLTANRLSGNIP',
'LTYLSLESNQFSGVVP',
'LKSLILSGNKLVGTLP',
'LSDLRIADMPGPEFQL',
'ITVIELSGKNISGKIS',
'VYFLDISSNNLSGRID',
'LFKLILFSNSLEDEIP',
'LVQVNISHNHFHGSLP',
'LQMLSLARNSFLGGLP',
'LRRVRLQDNSLSGELS',
'IMQLRLSKNKISGEIP',
'LQYLFLYQNMLAGPIP',
'LEVLTLASNQLVGQIP',
'LKFLDLGGNVLVGKIP',
'LNHLDLVYNNLTGQIP',
'LKWIYLGYNNLSGEIP',
'LEILHLFSNNFTGKIP',
'IQTIDLSSNQLSGKLP',
'LQILQLWSNKLSGEIP',
'LGLLDLSHNELSGKIP',
'LENLDLSQNLFSGAIP',
'LVSLDLSHNKLSGQIP',
'LRFLNLSNNNFTGPIP',
'LETLDLSNNMLSGKIP',
'LTVLDLSSNSLTGRIP',
'LISLDLSDNSLSGEIP',
'LQSVYLDFNQFDSIPS',
'VNVVTVGNPLLTGGSP',
'LQSLALDKNNFNASTG',
'VTQIQVQNMSLKGTLP',
'LTNLSCMFCNLAGPLP',
'VNSIALPSSNLSGTLS',
'VNVLWLHGNQFTGTIP',
'LQDLNLNGNKLVGFVP',
'LIQIKLGSNNLSGQVP',
'LKTLDLSTNNISPPLP',
'LQRLGLQRNQFTGALP',
'LEHLDLNNNQLMGPIP',
'LQNLRLSGNNLSGEIP',
'LQNLWLNDQNGGGLSG',
'LFSMNLEGNRLDNQIP',
'LRKISLHDNVLGGTVP',
'LSMLNLKNNRFKGPIP',
'LIFLAIQHNNLTGPIP',
'LQFLTLDHNRISGTIP',
'LYRLNLSFNSLMGSIP',
'LRGVYLFNNRLSGSIP',
'INQLDLAQNNFSGEIP',
'LTYFNVSYNNLSGSVP',
'LQEISLSHNQLSGAIP',
'LQSLDVSNNSLIGTIP',
'LQKLDISNNAFSGSIP',
'VTSLSLPDKNFTGYIP',
'LTRLTLSRNNFSKSIP',
'TGALNLSYNSFSGEIP',
'MVSLDLRHNNLSGKVP',
'LTHLDLSSNCLNGSLP',
'LRFLDLSHNSLSGPIP',
'GLTLDLRNNSLSSILG',
'VRELQLLNMNLSGHLT',
'LRILQLDNNKFIGSGI',
'VKHLHMNNNSIRGQIP',
'LQRLSLENNLLIGYVS',
'LDRLQVDMNYISGPIP',
'LKILDFMWNELGGSIP',
'LAKLSLRNCSLQGSIP',
'LQLLLLNGNKLSGFLP',
'LRHLLLDNNNLSGYLP',
'ITTIDLSDNHLNGSIP',
'LLYLDLSKNELNGPLP',
'VVAVHLPGVGLYGPIP',
'LHSIYLQHNNFSGNIP',
'TSMLDLSFNSFTGLIP',
'LTILSLRSNFLSGDLP',
'ITQLNLSYNLLNGSIP',
'LTSLSLQNNLLSGPIP',
'LTDLRISDLSDGGSSL',
'LSILMLRNDNISASIP',
'LEQIYFDSSGVSGEIP',
'MQYLTIGINALSGELP',
'LATVWASDNELTGRIP',
'LLNVDVSYNNLAGGFP',
'LRVFGFGSNNFNGSLP',
'LTSLRFEGNAFEGPIP',
'LTNLNLGQNYLTGNLS',
'LTYLFLGNNKLNGTLP',
'LTQLDLSFNNIEGQIP',
'FKFLDLSFNKIVGSNA',
'LKSLDLSGNSIEFSVH',
'LESLSLKSANISGSIS',
'LEHLDISANKFYGDLG',
'LKHLALKGNKLSGDID',
'LSYLDLSQSSLSGSVS',
'LAILKLSNNSFYGRIP',
'LSEIDMSNNHLTGMIP',
'LRDLNLWFNQLHGEIP',
'LQYLDVSANNFSSSVP',
'LYVLILGHNNFSGNIP',
'LIWLDLNSNFLNGTIP',
'LETLILDFNELTGVIP',
'LKRLDLAYNAFTGGLP',
'LETLHISINNFTGELP',
'LQSLSLGGNLFEGGIP',
'LKELYLQNNRFTGSVP',
'MIFLDLSYNMLSGSIP',
'LTALHLSFNYLTGTIP',
'LDILDLSNNRLEGIIP',
'LFMLDLSSNNLTGSVP',
'LNWISLSNNRLSGEIP',
'LNFLNVSSNKFSGSIP',
'LESLDLSSNSLSGPIP',
'LQTLITLSNFLFGPIP',
'LDTLFLQVNGLSGSLT',
'LSQVELQDNLLAGEFP',
'LTKMDFSHNKFSGPIA',
'LVRFDAANCGLSGQIP',
'LRSLNLSNNIFNSTFP',
'LSRIRMGENFLNGSIP',
'VTSLDLSGLNLSGTLS',
'LRHLHLGGNYYSGKIP',
'LQVLQLWENNFTSTIP',
'VQKFLLDGNKFSGSIP',
'LTLLNLFRNKLYGAIP',
'LTSVDFSYNNLSGLVP',
'LQVLDLYNNNMTGGLP',
'LEYLAISGNELEGSIP',
'LQNLSLAVNQFSGPIP',
'LNYLNLSRNHLVGSIP',
'LKSMDLSNNMFTGEIP',
'LGQLSLSNNRLTGSLP',
'LTFVDLSRNELSGEIP',
'LEILDLSSNKLTGTLP',
'LRELYIGYFNTYEGGL',
'VTELRLPRLQLRGQLS',
'LEELKMGGNGFREVVP',
'LQVIALQENMLSGDVH',
'LRIVQLGFNGFSGVVG',
'LVHFSANGNRLGGLIP',
'LEYLWLDYNILEGTLP',
'LQVLDLQENHIRGVFP',
'LRKISLRSNFLNGTLP',
'LQVVSLSENKFVGAVP',
'VMLLNLSGNGFSGRIP',
'LRALFLQYNSFSGNLP',
'LTMLDVSRNLFSGVVP',
'LVVLSLSKNHISGLIP',
'LVYLNVSRNNLEGGIP',
'LQVLDLHGNDLAGEIP',
'LSSLDLSRQSLSGELP',
'LKVLSLGENQFSGSVP',
'LETLELESNSLTGNIP',
'LQVLNIAQNRFSGEIP',
'LETLNLGGNGLNGSLP',
'LSSLSLDSNHLSGSIP',
'LQLINLSYNQFSGSIP',
'LRYLNLSSNGFSGQIP',
'LKYLDLSSNTFSGSIP',
'LTSLDLSTNNLSGQIP',
'LKVLDLGRNNLSGEIP',
'LTTLDLSGNGFSGEIP',
'VVSLNLSNLNLGGEIS',
'TGKLYLHGNKLTGPIP',
'LNQFNVHGNHLSGIIP',
'IVSLILNNNDLQGEIP',
'LWYFDVRDNKLTGTIP',
'LQYLGLRGNLLTGTLS',
'VATLSLQGNNLTGRIP',
'IQIIDLSFNNVTGSIP',
'LANLNFSYNNLSGIVP',
'LQSIDFQGNMLTGQIP',
'LLTLNLSRNHLHGRLP',
'FEILDISYNQFTGEIP',
'LYHLDLSGNLLYGDIP',
'LSYLQLNDNQLVGSIP',
'LFELNLANNHLEGPIP',
'LTYLNLSSNDFKGSVP',
'LDTLNLKNNQLTGPIP',
'LAVLDLSDNELVGPIP',
'LKTLDLAKNQLTGEIP',
'LDTLDLSSNNFSGPIP',
'LQSFDFSGNSFLEGPV',
'ITRLVFKSQRLTGFLS',
'LKELSLTNNQLVDHLP',
'LDILELGNNKFSGEVP',
'LRVLDLSRNLFSGNLS',
'LENLSLANNLFTGKVP',
'LTSLNLCCNGFSSSLT',
'VEKLDLSHMNLTGHVS',
'LEKIIIGYNEFEGGIP',
'LKDIDVSQNLFIGSFP',
'LSFIDISRNRLRSSLP',
'LVRVRMQNNFLSGAIP',
'LETVFLYQNNLEGKLP',
'LQTFMASNNNLEGEIP',
'LETLDLRGSFFEGSIP',
'LEMLNVSYNKLQGPVP',
'LKYLDLAIGNLSGEIP',
'LTLLNASSNNFSGIIP',
'LSVLELWSNSLSGPLP',
'LTKLILFNNSFSGPIP',
'LVNLNLKNNRLTGEIP',
'LKFLGLSGNSLTGQLP',
'LQLLNLMSNQLSGSIP',
'LQRLELANNSLTGQIP',
'LAVLDLSNNSLTGGLP',
'LSALDLSSNHFSGSIP',
'LQWLDVSSNSLSGEIP',
'LQLLDLSDNNLSGEIP',
'RYEIDLSYNNFTSEAK',
'VIAIYLKRQDLDGSLP',
'LDTLEIQAGGFTGPIP',
'IKYLLLSNCNLSGNFP',
'LEKMYLTRNMLTGPIP',
'LRSLNVQNNMFSGTVP',
'LEILSIGVNNLTGKIP',
'LKHLDLWANYLSGNIP',
'LENLTLSANYLTGELP',
'LKELRLSSNNFTGGIP',
'LKILDLSFNRLNGSLP',
'LTDLKISNLLGDGSEF',
'VTNLTLQSFGLRGTLY',
'VSEFYLEKNKLSSPIP',
'LYRVRLDRNQLTGNIS',
'LHGLALDGNEFTGHLP',
'LKICTASNNYFSGSIP',
'LQDLDLSCNFLTRDIP',
'MTSLQISKNNVSGEIP',
'LHVLALAGNKFHGPLP',
'LLLLNLSGNKFRESIP',
'LNYIDLSYNNFYGELS',
'LYKLILNNNHLSGAIP',
'LFFLGLSYNQLSGLIP',
'LHLLDLSSNQLKGGIP',
'LNILDLADNVLTGRIP',
'LLFLVLPNNSLSGTIP',
'LTTVDISSNKLQGPIP',
'LTGLALYQNNLTGSIP',
'LETLNVSHNMLSGRIP',
'LSFLALSWNQLSGSIP',
'LSVLYLWDNQLSGSIP',
'LSELNLWGNKLSGSIP',
'LQILNLASNNLSGLIP',
'LEILYLHSNNLVSNSS',
'LYYSNLLNNRIRGEIP',
'LTQLERAVNYFTGQIP',
'MKNFNLSYNRLTGEFS',
'GLSVNLSNNNLDGEIP',
'LEYLNMKENKLSGAFP',
'MMQLDLSFNNLQGPLP',
'VQAIDLSVNRFSGIIP',
'LETLFLHLNFLEGTIP',
'LQKLYFLNNNISGRIP',
'LKKLHLGSCLFSGSLP',
'ITLLDLSVNYLEGEVP',
'LREISLIENLLSGEIP',
'LEYLNLSKNMIQGTIP',
'LTKLSLQGNNFRGEIP',
'LSFLALSVNNLTGVIP',
'LQRLYLGRNKLQGSIP',
'LKALDLAFNQLTGSVP',
'LKFLDLSVNNLSGVIP',
'LRYLYLSRNSLSGNIP',
'LGLLDLGNNSLTGSIP',
'IREFEAADNEISGFLA',
'LQILWAPRANLDGRLP',
'LNFSGTSTTRLSGTLP',
'VIVHDFSWNHFVGSLP',
'LDGFRLEFNAFEGGVP',
'MMYFNVSQNNISGAVP',
'SFSVNLSANHISGEIP',
'LRVIDLSNNRLTGGMQ',
'LRHLKLSNNLLENNIP',
'SYRLLLSSNGFTGSLP',
'LRTLLLDGNILQGPIP',
'LRVLHLGQNSLRGVVP',
'LRVLDVSTNSLTQTIP',
'LEIVLLNNNDLSGAIP',
'LRTLVLSHNCFSGEIP',
'LRSVLLGMNNLTGEIP',
'LTVLDLSHNAVTGSIP',
'LVVLNVSFNNLSGHIP',
'LEVLELQGNNFSGKIP',
'LRRLDLRRNRLSGSLP',
'LRFLNLSFNSFTGDIP',
'LTFLDLSSNYLTGDLP',
'VISFKLKGFNLTGVLP',
'RKDLDLSYNNFTGSAD',
'MEKLILRNCSLTGSIQ',
'LKSLVLEDNLLGGSLH',
'LNDFRIDGSELSGKIP',
'ITTLDLQGTSMEGPIP',
'IKFMFLNNNLLTGEVP',
'LQSLSLLANRLSGSIP',
'LREIDLSRNYLNGSIP',
'LERLLLSANNFSGTIP',
'LDTLDLSFNKLTGPIP',
'LTTLRISDLKGSNSTF',
'VANISLQGKGLSGTIS',
'LQVLELCCNQLAGYIP',
'LSVLALQYNRLVGQIP',
'LSDLYLNVNNLSGSIP',
'LSGLYLHYNSLSGEIP',
'LEVLDVRNNSLSGTVP',
'LKRLDMSFNYLSGTIP',
'LQILNFGFNKIGDKNN',
'VIALNLSSLQLAGFLS',
'LKEIGLYKSNLGGLLP',
'LRAPGLLKNHLTGSLP',
'LSTVAMVSNNLSGRLP',
'LYYLVMWGNYITGTIP',
'TLGLLLGSNRLSGRLP',
'LKEFYVHLNKISGEIP',
'SQALDLADNMLTGRLP',
'LQTLYLGLNRFLGPVP',
'LIQLDISRNKICGEIP',
'LQYLSLSNNSFQDELP',
'LRFLGMEGNNLTGKIP',
'IRVLDVSCNNLSGQIP',
'LSNLNLSFNEFEGKVP',
'LLKLDLGVNLLEGTIP',
'LETLNMSGNFLRGTIP',
'LNLLDISHNHLSGFIP',
'LRRIDLSKNNFHGTIP',
'LAYLDLSFNNLSGMVP',
'LVSLSLRENNLEGSIP',
'LEYLDLASNSFSGPVP',
'VTVLRLPGFALTGEIP',
'LRTLSLRLNALSGKLP',
'LVRLNLGENNFTGEIS',
'LEQFNVSNNLLNGSIP',
'LRNLYLQGNLFSGEIP',
'LRTLFLEDNSLSGSLP',
'LKSVNLNGNMITQAIG',
'LQTLKIDKGFLNGTIP',
'VVHMMVENNALTGEIP',
'LSISALNMNKLTGSIP',
'VTWFDIAQNGLTGPLP',
'LEILRVDNNRVQGTIP',
'LQYLSLQGCNFYGSVP',
'LESVSLSNNQLSGTVT',
'LLELHLANNSLVGTLP',
'ILLLNVGENVYGPQPF',
'VTGIDVAFLGLQGIVS',
'LAAIYLDNNPLNGTAG',
'VSVIDLAGSQLVGRLS',
'LVQLWLQVNEIAGTIP',
'LANLSLTNSSVVGSIP',
'LEYLGMQGNALSGSMP',
'LQQVDLHNNNLSGDLP',
'LQDLKLNDNRLTGPIP',
'LTVLRLNGNNISGGIP',
'LKVLNLAYNRLTGGIP',
'LKIAYFDNNDFSSIPG',
'LRNLILTKINLVGKIP',
'FFELRLFKNNFTGRIP',
'AYIVDLSENELSGSIS',
'FSSFNVSYNRLSGRVP',
'VERILMNNNKLNGSIP',
'LNVLFVHDNKLEGQIP',
'LESLNLGNNEIGGGFP',
'EEILDLSWNGLSGSLP',
'LRLLHLWQNELTGAIP',
'LTRLQLYGNMFEGELP',
'LVELILFNNGITGGIP',
'LKSLNLSMNLFVGLLP',
'LLELNLTNNLLNGTVP',
'ITDIDISNNRLTGSIP',
'LKLLELYDNQLEGEIP',
'LEVFDVSNNMLEGPIP',
'LENLDLCGNNFTGEIP',
'LAQLNLAGNQLTGSIP',
'LTTLNLYGNKLSGPLP',
'LTLLDLSRNMLTGDIP',
'LQRLDLAYNPMAEGPI',
'LRLLNATGFVMLGTLP',
'LLVLNVSDNFLNDTVP',
'LQVLDFSACSINGSVP',
'LQELVLGKNLLAGELP',
'LRRLSLARNNLMGGIP',
'LRSVRLSDNRLDGSVP',
'LQSLDLSNNTFYGPLP',
'LRDLDLSGNIFSGPIP',
'LELLDLSGNMLSGVLP',
'LTLLDLSLNNFTGTIP',
'IQSINAAANMLNRSLA',
'APFLNVSNNELSGPVL',
'LRILSLRNNDLGGEMA',
'PPSIILASNNLSGVIP',
'VRVLSLPGLKLAGEIP',
'IKLLDLSTNAIPGGIP',
'LVMLVLSKNSFTEPLP',
'LQLLAIGNAGLSGSIP',
'LTALTLGKNELRGDIP',
'IESLDLSYNFFAGALP',
'LAAFNVSFNRLSGAIP',
'IVRLNLSDNLLEGPIP',
'LEELFLGYNSLGGEIP',
'LETLSLSGNELGGGIP',
'LEAVDLSANQISGSIP',
'LQVLDLSWNRLVGDIP',
'LKLLDLSANNLSGALP',
'LTELDLSYNRISGNIP',
'LFYLDLSNNSFTGSIP',
'LVSLDLSNNRLVGSIP',
'LESLDLSSNGLSGSIP',
'LVHLGLDNNPFVESRF',
'LQALYLNNNMLRNVSV',
'VTRIDWQGWELRGSIP',
'LQHLNFSYNDLIPSSG',
'LVMLNLSRNDFQDLVP',
'LQYLNLSRNLLQGSMS',
'LKELDLKNNEFSGPVS',
'VETLRLDGNSLSGLLP',
'LFFLDLSQNHLAGQIP',
'LEYLNLSATQLTGGIP',
'LRTLDLSYNRISGVFP',
'LLYLNLYNNSISGTLP',
'LKQLDLSHNELNGTLP',
'LTSLDMSYNQLNGSIP',
'LAYLDLSTNRLSGPLP',
'VVELRLPGLELRGAIS',
'VQVLEIANNNITGTRT',
'INVMLLDENQLSGELS',
'LQKLDVHGNKIAGSMP',
'LQTFAASNNRLGGFLP',
'LASLVLGSNDLSDTVP',
'VQALDFSRNNLSGSIG',
'LTSFSMSNNLLSSDIP',
'LTNFSVAANNLSGQLP',
'LEFLHLEDNSLAGGIP',
'LFSLILGNNALSGQLP',
'LQRIDLQSNQLSSSLP',
'LQSLDLSNNFLNGSVT',
'LRVFNVSGNSLEGVIP',
'LRRLSLHSNRFNGTIP',
'LMVLDLSSNLLGGGIP',
'LRLLNVSGNTFSGQIP',
'LVVLDLSNQQLTGGIP',
'LRSLDAGSNQLSGAIP',
'LRSLVLGRNLFSGPIP',
'LQHLSLSRNNLTGPVP',
'LQVVNLSRNGFSGSIP',
'LSSLDVSQNRLSGSIP',
'LKQLNLSFNGLSGSIP',
'LRVLNLSNNQLTGVIP',
'LQELDLSGNNLTGKIP',
'LEVLALDDNPLNATSG',
'PLKLILSGNSLLNSSP',
'IQQIQVMGLGLKGSLP',
'VIVINLPKSNLSGTLS',
'LTNLTLMNCNLVGSLP',
'LQDLNVNSNDLVGLIP',
'LVLLDLSNNHISLPLP',
'LGHLDLNNNHFMGPIP',
'LTNLGLQRNKFSGKLP',
'LTSLWLHGNHFSGKIP',
'LTHIYLGSNNISGSIP',
'LDVLLLSKNRLSGTIP',
'LRYAFLDFNMFDSIPL',
'LAKFIAYDNKFIGRVP',
'LSRVRLDGNQLSSNIS',
'LWYLNLSKNMLNTTIP',
'LQLINFTNNSIHGTLP',
'LQTFQVAENNFSGHLP',
'LLELDLHENRISGETP',
'LVHLCLLRNKLNGSLP',
'LELLFLSVNELYGPVP',
'LVYMDLSHNKLYGELS',
'LRSIDISCNQLVGPLP',
'LKHLDLSINRFIGFIP',
'LSFLYLSYNQFDGVIP',
'LTSLKISNNNLVGAIP',
'LTRLDLGANNMSGTIP',
'LERMNLSRNNLSGSIP',
'LAYLDLSYNMLSGEIP',
'LRMLDLSSNHLTGEIP',
'VSSLGLPSQSLSGTLS',
'LESILLQNNAIYGYIP',
'LALVDVSFNNLSGPLP',
'LNYLRLNNNSLTGNIP',
'LQTLDLSNNKFDGEIP',
'LQTLYLGFNRFTDNYT',
'LQTLNLMENNLSSDQS',
'AIRIDLSHNQFSNGIP',
'LEKILASDCQIKGDIP',
'LKGLYLSFNKLQGHMP',
'VTSLNISNMGITGTIP',
'LRGIKLNSNRLSSNIP',
'LGNIYLGENQFSGLVP',
'LQEFSLANNRLKGSIG',
'LVMIGMERNQLTGSIP',
'LKQLSLSFNPLNGMLP',
'LESIGFSQNGLSGDLP',
'LRLIDLTDNTLSGTLP',
'LNYFNVSFNSLQGEIP',
'LKLMKLSYNNFSGEVP',
'LNWLIIENNQLTGSIP',
'LEVLTLKNNSFTGLIP',
'LEKLILSYNFLHGNIP',
'LVSLDLDSNNFFGNLP',
'LEALDLAFNTLEGNIP',
'LQLLSLQNNNFTGSLS',
'LIYLSLAQNKLQGSIP',
'LVDIDLGSNRFSGSFP',
'LQGLYLGQNMLTGEIP',
'LRGLNLGHNNLTGTVP',
'LQLLSLSNNDFDGPIP',
'LIYLFLYGNRLTGPIP',
'LLELDLSSNNMSGSLP',
'LTALDLSLNKLSGSIP',
'LEFLDLSNNNLSGSIP',
'IELLYLGGLTNLAGSM',
'LENLSISSCNIYGNPK',
'IQRLDLSFNRFTNLGS',
'ITEINLSSRNLTGIVS',
'LVQVNLSKNKLGGAVA',
'LKHLDVSVNHMDGKLP',
'LHSIDLSNNSLKGSVH',
'LNFLNISFNNFTGEIP',
'LTSLDLSHNDIKFLPF',
'VVRLVLQGFSLRGTFP',
'LKTLFLDHNFFSGTFP',
'LNYLRLDSNWFNGSIP',
'LQIFNVSNNNLTGPVP',
'LRILNLRNNSLSGPIP',
'LVILDLSRNNLTGSLP',
'VINISLVGMHLKGEIS',
'QFYLNFSSNLLDGEVP',
'LIDLVLHKNSFSGVIS',
'LTHLGLSHNEQTGKIP',
'LRVLRAHSNSFLGPIP',
'LTFLSLGSNKMWGEIP',
'LHRLRLYNNKLNSSIP',
'LYELLLQNNNFFGPIP',
'LLFVSLINNSLTGKLP',
'LKNLTASDNLLEGPIP',
'LRVLTLTFNRITGKIP',
'LQLLEAYRNNLVGSIP',
'VQGIDMSNNNLSGNIP',
'LVTLDMYNNQFTGGVP',
'LMTLDISHNLLTGTFP',
'LQVLDLTLNSFTGNVP',
'LFSLDLSGNMLSGPAP',
'LQVLTLHSNRLYGEIP',
'LEILQLHHNFLSGKIP',
'LRSLDLSQNKFKGIIP',
'LVQLILYRNFLSGEIP',
'LIYLNLSFNQLEGHIP',
'LEVLDLSGNNFSGKLK',
'LQGLSLSDNKLEGELP',
'LVFLNLSRNRLEGKLP',
'LQLLDFGNNSLSGRIP',
'LTYLSLSFNLFTGSLP',
'LSLLDLSGNKLNGTIP',
'LQTLDLSSNQFSGPIP',
'LKRLFLAENNLTEGTS',
'LQIFSAFGSKIKGTIP',
'VTSLNVSGFRLSGTIA',
'LGDIYISHNMIRGAIP',
'LESIFMNDNTFDGLIP',
'LIIVDTKYNVLTGSIP',
'FEVIQLADNMLTGSIS',
'LKKLNVHGNHLSGVIA',
'LKSIDLTGNSLTGGLA',
'ATDVDLSWNQFSGDIP',
'LEMLSLRGGSLTGQIP',
'LERIYLEYNRLEGHLP',
'LQGIFLSANQLHGLIP',
'LTGMYLDSNELTGVIP',
'LQRVFLDSNNLTSTIP',
'LVALNLSTNSFKGYLP',
'LATIYMSLNSFTGSIP',
'LKTLYLGINNLIGGIP',
'LRYFNVSVNELEGEIP',
'LETVDVSLNQLNGVLP',
'IVYLSLAHNRLQGPIP',
'LKRLVLSYNMLHGNIP',
'LQEINVGFNDLSGEIP',
'LQILNLAENNFTGRLP',
'LQELYLGENELTGSIP',
'LQILDLNRNRLTGTLP',
'LQDLSLSYNQFSGKIP',
'LTSLDISNNNFSGLIP',
'LETLDLSSNNLSGMIP',
'LKQLDLSNNSLSGSLP',
'LAEIYLNDNGFTSVPQ',
'VDVVTLGKLRLSGFIS',
'LITVYASNASLFGVIP',
'VVSINLDSQGLSGVLP',
'LLSISLQNNKLQGPMP',
'ISDLQLRDNDFTGVIP',
'LSQVWLHANSFTGPIP',
'LKILSVQRNSLSGVLP',
'LRNLLLNDNNLTGSIP',
'LQDLRLSYNNFTGSLP',
'LQTLDVSNNNLSGPVP',
'LQIFSISENWKLSPWQ',
'IKNLWLNNQVKGLSGT',
'LSTLVLTLNFRDEELP',
'VVKLELGKRRLNGKLS',
'PPTLELGNNFLTGAIL',
'VSVIKMGVNYFNGSLP',
'VSSLSLRNNSLGGIIE',
'LKALIIANCRLTGVVP',
'LTYLSAHSNRFFGNIP',
'LKLFCVGSNLLSGSLP',
'LVSLDLATNGFRGLVP',
'MSKFSVAYNKLSGEIP',
'LTVLSLQENRFSGQLS',
'LQVFNISDNSFGGPVP',
'LVHLDICSNGFSGNIP',
'LRTLNLSHNFFKGPVP',
'LEVLDLSNNDFFGLFP',
'LQTINLARNSFTGQLP',
'VENLDLSHNNLIGSIP',
'LHVLDLKSNNLSGTIP',
'LFYLDFSNNSFTGEIP',
'LQLLDLSWNRLSGTLP',
'LSSLSVSNNSMHNIDA',
'ITSIALKAQNISANIP',
'NKNIDVSNNNFTWETS',
'VKILVLRNCLIHGEMP',
'VDFIYLTANKLTGLVP',
'IEKLHIQGCSLEGPIP',
'LLELSFMGNHLSGRFP',
'MEKLVLSSNKLTGALP',
'LTDLRINDNNFTGKIP',
'LRNLSIEGNKFSGTIP',
'LKYLDLSRNYLNGSIP',
'LKTLDLSFNSLSGEIP',
'LIDLRISDLKSGKSGF',
'LEYFNVSNNPNLGGVI',
'IIGLDLSVKNLGGILS',
'VIHMEIGYNLYEGSIP',
'LQNFSATNCSISGDFP',
'LDTLLLWDNWFKGSLP',
'LVRIRIEDNLFSGDIS',
'LKLLSVMYNDLSGTVP',
'LLVLELSMNNVSGILP',
'IQYLDIASANLSGSIP',
'LQRLILFSNNFTGGLS',
'LVELNLSHNSFSEKLP',
'LKYVDVSTNYFVGSIP',
'LSYVDMSRNRFTGGIP',
'LDFIHLAGNSLSGKIP',
'LVILDAFSNSFSGPLP',
'LRSLDISRNNFSGHFP',
'LQLLNVSFNDLSGLIP',
'ISVVDLSHNSFSGSIP',
'LESLFLFRNQLSGKIP',
'LSSLDLSDNYLSGPIP',
'LLSLDLANNNLSGEIP',
'MLAFSAANNWLWGTLP',
'LQIFLAPSCLLEGPLP',
'LVGLYVQQNRLSGGLD',
'VVSLILSSLSLKGPIS',
'VLSFSAENNQLSGALP',
'HGVYDLSHNKLSGSIP',
'LKRFDLSYNPLKCSIP',
'LETIKLGSNCFIGEIP',
'LSQLGLMDNSIAGVIP',
'LADIELGNNFLTGSID',
'LDILNFTDNKLKGTIP',
'LTILNLAYSEINGSIP',
'LTDLYIGENRFSGHLP',
'LMSVMLSFNSLSGSLP',
'LQCLVLSHNDLSGGIP',
'MDSLLLSSNRFSGKIP',
'LEIIDLGTNSFTGALP',
'LSVLNLNSNLLEGYIP',
'LQVLALGNNLLSGSLS',
'LTSFDVSNNTLSGIIP',
'IVDLLLSNNMLSGEIP',
'LEYLDVSGNSLMGQIP',
'LTHLDLSSNILDGELP',
'LQGFYLGNNQLTGSIP',
'LVKLNLTGNMLSGPIP',
'LQSLVLSNNQITGVIP',
'LSHISLSNNLLTGPIP',
'LTILDLHANSLTGEIP',
'LTTLDLGNNRLRGSIP',
'LKVLDLSNNQLYGELP',
'LTTLDLTGNSLTGTIP',
'LKLLDLSGNALTGKIP',
'LVVLDLDSNNLTGPIP',
'VTSLDISGFNLTGTLT',
'LDTLFLQVNGLSGSVT',
'LQTLITLGNFLFGPIP',
'LRYLNLSNNIFNLSFP',
'LNRIRMGENFLNGSIP',
'LSQVELQDNLLTGTFP',
'LTLLNLFRNKLYGSMP',
'LGQICLSNNRFTGPLP',
'LIRLDAANCGLSGEIP',
'LLNLSVAVNQFSGPIP',
'VQKLLLDGNKFSGQIP',
'LEYLAVSGNALVGRIP',
'LNVLDIYNNNMTGELP',
'LSKMDFSGNSFSGLIP',
'LTSVDFSYNNLSGLVP',
'LTNVDISTNKLTGNLP',
'LRHLHLGGNFFSGSIP',
'LNYLNVSRNQLVGSIP',
'LEVLQLWENNFTGSIP',
'LTYVDLSRNKLSGEVP',
'LKSLDLSNNMLSGEIP',
'LRELYIGYYNTFSGGL',
'VYAFLAGSNRFTGPFA',
'LRMIWAPRSTLSGKFP',
'AVFHNFGVNNFTGNLP',
'GMIVNVSNNALSGQIP',
'LEIVNLAQNYYTGVIS',
'LRLLDGSKNQIVGTVP',
'LQSLVLYSNLLEEAIP',
'LQSLEMAGNILGGVIP',
'LRVLSLPFNELRGDIP',
'LQIFNLAGNRVNGTIP',
'LHFLDLSSNRLTGQLV',
'MFVFDVSGNYLSGSIP',
'LVALNLSWNHLRGQIP',
'LAAFNVSFNNLSGPLP',
'LRVLNLGFNQIVGAIP',
'LRGIYLSFNELSGSIP',
'LSYLSLAGNNLVGPIP',
'LEVLDLQGNLITGSLP',
'LTSLLLNNNNLSGKIP',
'LEILDLSRNSLSGRLP',
'LETLELSSNSLSGEIP',
'VTGIVLNDSNLGGELS',
'LSTLHLQNNQLSGILD',
'IIQIDLSNNHIGGSIP',
'LTDLSLNNNHLNGVIP',
'LTDLNIENNLFSGPIP',
'LINMDLSGNSLSGQLP',
'LKTLSLSGNQLTGSIP',
'VVALRLPGIGLYGPIP',
'LRFIFIQQNKFSGEIP',
'LTTLSLHSNALTGNLP',
'LTQLNMSNNQLNGSIP',
'LNFIDLSFNSFSGEIP',
'LTGLNLQNNSLTGSIP',
'VVRLVLQGFSLRGTFP',
'LKTLFLDHNFFSGTFP',
'LNYLRLDSNWFNGSIP',
'LQIFNVSNNNLTGPVP',
'LRILNLRNNSLSGPIP',
'LVILDLSRNNLTGSLP',
'VIELRLPGYGLSGEMP',
'LIRVSFSGNRISGEIS',
'MRTLYLENNNFSGSLP',
'LNEFNVSFNRLTGSIP',
'LRTLSLRSNSLSGLLP',
'LRILNLENNDFSGSIP',
'IEMFNIENGQINGQIP',
'VIALNLPNMNLQGKIS',
'LEFLNLGGNQLTNEPG',
'LGDTFLHENELSGAIP',
'LRAVYLVNNSLSGSFL',
'LQFLGCVNNHISGTIP',
'LEVIDVHNNQLEGTLH',
'LESFYITQNAISGTIP',
'LIFLNVTRNSIQGELP',
'LKGIFLPDNQLEGEIP',
'LQRLSFGFNKFTSSLP',
'LTKLNFSNNIFQGTLP',
'LKMLGFDFNNLTGVIP',
'LQFLILANNPLNGVLP',
'LEYIAFSDNDLSGRIP',
'IEGIDFSSNQLSGVIP',
'MLSLVLNGNQLTGTIP',
'LIELELSYNLFTGIVP',
'LRYLSLSNNSLRSAIP',
'LEVIDLSYNRIIGEIP',
'LNEINLSYNHLEGEIP',
'LQRLYLSKNKLQGSIP',
'LERLRLDGNRFSGKIP',
'LRTLVLSYNNLTGQIP',
'LKFLDLSSNELSGNIP',
'LVELDLSHNQFSGSIP',
'VIALGAPSQGLSGVLS',
'LKQVLLQNNNISGHIP',
'LETLDLSNNHFSGHVP',
'LQYLRLNNNSLSGAIP',
'LAFLDLSFNNLSGPIP',
'LVSLVLRKNKFSLGVP',
'LKVLSLVSLGLRGTLP',
'LQVLDLESNNLGPNFP',
'LKKLDISSNELVGPFS',
'LSYLDISGNKLTGKLL',
'LEIINISSNFFYGEIP',
'LSVLSFKNNSFSGSLP',
'LQTLILDDNKFTGQVP',
'LRILSISGNNFSGVVP',
'LSFVNLSSNYLTGELP',
'LKLIDLQNNSIDAYTV',
'LYYLDMSNNTFSSADF',
'VISIKLSSINLKGELS',
'LQTVNLRGNKINGTLN',
'LSILILVGCGFSGLIP',
'LTTLVMENTQLQGEIP',
'TKHFHLGGNQFSGEIP',
'LEYLSLNLNNFIGPIP',
'LEVVRLDRNSLDGSIP',
'MSELFLSNNKFTGPLP',
'LKHLLLDQNQLTGKIP',
'LHWLDLADNKLSGPLP',
'ELQILDLSYNKGLTGS',
'LKKLSLVSLGLWGSLP',
'IQSISIAKNQLSGALP',
'LEVLNITSNFILGEIP',
'LKFVDFSSNLLMGKLP',
'LVSLNLSNNIFRSEIP',
'LEELDLSGNNLGPKFP',
'LKSLVLARNLLNGSVP',
'LQNLDLSSNKLVGPMP',
'VSALALPSQSLAGTLS',
'LQYVLLQNNAISGHIP',
'LNYLDVSYNNLSGTLP',
'LQTLDLSNNKFEGEIP',
'LRFLNISGNSFLEGPV',
'VTRIVFRSNGLKGTLS',
'LRVVDFSSNEFSGNLD',
'LKELSLSDNQLSEQIP',
'LEILELQRNRFSGKIP',
'LEKLSLADNMFTGKIP',
'VRFLMLHGNSYIGGIV',
'LEVLDLTMNRIHGLMI',
'LAVANISNNNFTSGSG',
'VTGIDLSESNLAGKLF',
'MSMMHLGANEFSGRLP',
'LKFLNLSHNIIVGELN',
'PGYIQLSDNKLSGEIP',
'LKELCLGSNNFSSDIP',
'LNMFSASHNNLSGSLP',
'LNSLDLSKNTFSESIP',
'LVFLDLSRNNFGGEIQ',
'LQGLDLSENMFFGELP',
'LKYLDLSYNYLTGNLS',
'LLWLMLANNSLSGEIP',
'LEFLILAHNQFSGNIP',
'LQAVDLSSNRINGSIP',
'LLNLDLSFNNFSGPFP',
'LLWLNLANNQLTGPIP',
'LVELNLWGNSFSGSIP',
'LVVLNVSQNKFSGEIP',
'LSRLDLSDNHFSGPLP',
'MQNFQGNGCKLKGVIP',
'LEILNLEMNNFISDSS',
'VTALDISSMQLHGTIT',
'LEVFLCGGNNLSGFIS',
'VIHMSLFNNKLAGHIP',
'LRALRFNENALDGALP',
'LTELYLKALHLEGEIP',
'LTELYLKALHLEGEIP',
'LTELYLKALHLEGEIP',
'LTELYLKALHLEGEIP',
'LTELYLKALHLEGEIP',
'LTELYLKALHLEGEIP',
'LTELYLKALHLEGEIP',
'LTELYLETLHLEGEIP',
'LQEFYLHSNEIKGTIP',
'MQIITLTDNNLTGKLP',
'LTELYLRALHLEGEIP',
'LHIMYLWRNQFSGKIP',
'MQIIDFTGNNLTGKLP',
'MQIIDFTGNNLTGKLP',
'MQIIDFTGNNLTGKLP',
'MQIIDFTGNNLTGKLP',
'MQIIDFTGNNLTGKLP',
'MQIIDFTGNNLTGKLP',
'MQIIDFTGNNLTGKLP',
'LINLPLAHNRLEGPIP',
'MQVIALTGNNLTGKLP',
'MQVIALTGNNLTGKLP',
'LQILSLSYNEFIGIVP',
'LQILSLSYNEFIGIVP',
'LTELYLGDLHLEGEIP',
'LRYLNLAYNRLNSRLP',
'LEGLHLTSNSLDGVIP',
'LEGLHLTSNSLDGVIP',
'LQVLALSLNEFIGTIP',
'LQVLALSLNEFIGTIP',
'LQVLALSLNEFIGTIP',
'LQVLALSLNEFIGTIP',
'LQVLALSLNEFIGTIP',
'LQVLALSLNEFIGTIP',
'LQVLALSLNEFIGTIP',
'LQVLALSLNEFIGTIP',
'LKVIDVTSNNFTGEFP',
'LVSLNISNNAFHGDLP',
'VTLIDLSKNDFSGKIP',
'LQVLSIQNNFLQGEIP',
'LKIIDFGQNKLSGTLP',
'LRMFDISFNSFTGPIP',
'LQRLYLSKNSLDGVIP',
'LKYMNFSFNKLSGEIP',
'LQVLQLAENELTGSVP',
'LIELSVSSNSLSGHIP',
'LGALDLSGNHFSGSVP',
'LSILDLQYNGLTGSIP',
'LTILDLQFNQLSGSIP',
'LTILDLQFNQLSGSIP',
'LTILDLQFNQLSGSIP',
'LTILDLQFNQLSGSIP',
'LTILDLQFNQLSGSIP',
'LTILDLQFNQLSGSIP',
'LTILDLQFNQLSGSIP',
'LTILDLQFNQLSGSIP',
'LTILDLQFNQLSGSIP',
'LEFLDLSYNNLSGEIP',
'VSAVILPSFNLRGPIT',
'LRLLDLRNNRLNGTLT',
'LKELNFSNNELYGSVP',
'LLTLRLQNNELSGTIP',
'LKLIYLSGNDFSGEIP',
'LLRLDVSNNNLEGSIP',
'VIAIHLPAVGLFGPIP',
'LKVLSLRANYLNGSVP',
'LQSVYLQHNSFSGDIP',
'LTNLNLSYNMLNGSVP',
'LSVLNLQFNSLTGEIP',
'LGVLDLSFNSFTGEIP',
'VANISLQGKGLKGKLS',
'LTGLYLHYNSLYGEIP',
'LMRVDLSYNSLFGSIP',
'LEVLDIRNNKISGNVP',
'LTDLYLNVNDLSGEIP',
'LQVLQLCYNHFTGSIP',
'LNVLALQSNQLTGAIP',
'INKLNISNSGVIGTLH',
'FKWVRFNNNSFIGNLS',
'AKLFYAFSNELAGSIP',
'AKIFYAFSNELSGPIP',
'LVRLSVQNNNISGNIY',
'LRVLTMTKNQLSGHLP',
'LFQLNLSNNKFGQKIP',
'LVEVALDTNQLTGHIP',
'LERFTVTSNKLTGPIP',
'LLDVVLSYNDLEGPIP',
'LQFIDLSDNNFHGELS',
'LVDLLFQRNNLSGPIP',
'LIDLRVARNNISGSIP',
'LVEVDLDTNKLTGHIP',
'LLGLDLSSNHLLGQIP',
'LNDLVLSENQLTGSVP',
'LQTLHLHTNKLSGSIP',
'LKILYLYSNQLSGPIP',
'LSNLNLSHNGLSGRIP',
'LTLLDLSHNLLDGEIP',
'LEYVDLSMNNLSGPIP',
'LESLSLQRNNLSGSIP',
'LESLDLSDNRLNGSIP'
]
default_matrix = pssm_matrix.calc_pssm_matrix(default_train_motifs)


class LrrResult(motifs.Motif):
    pass


def predict(seq, matrix=None) -> List[LrrResult]:
    """Predict motifs from the `seq` str. If the `matrix` is None, using the built-in matrix to predict motifs"""
    if matrix is None:
        matrix = default_matrix
    return motifs.lrr_search(matrix, seq)
