import os

ES_CONNECTION_PARAMETERS = {
    "use_ssl": os.getenv("TEXTA_ES_USE_SSL", default=False),
    "verify_certs": os.getenv("TEXTA_ES_VERIFY_CERTS", default=False),
    "ca_certs": os.getenv("TEXTA_ES_CA_CERT_PATH", default=None),
    "client_cert": os.getenv("TEXTA_ES_CLIENT_CERT_PATH", default=None),
    "client_key": os.getenv("TEXTA_ES_CLIENT_KEY_PATH", default=None),
    "timeout": os.getenv("TEXTA_ES_TIMEOUT", default=60),
    "sniff_on_start": os.getenv("TEXTA_ES_SNIFF_ON_START", default=True),
    "sniff_on_connection_fail": os.getenv("TEXTA_ES_SNIFF_ON_FAIL", default=True)
}

TEXTA_ES_URL = os.getenv("TEXTA_ES_URL", default="http://localhost:9200")
TEXTA_ES_PREFIX = os.getenv("TEXTA_ES_PREFIX", default="")
TEXTA_ES_USERNAME = os.getenv("TEXTA_ES_USER", default="")
TEXTA_ES_PASSWORD = os.getenv("TEXTA_ES_PASSWORD", default="")
TEXTA_EVALUATOR_MEMORY_BUFFER_GB = os.getenv("TEXTA_EVALUATOR_MEMORY_BUFFER_GB", default="")

ERROR_LOGGER = "error_logger"

TEXTA_TAGS_KEY = "texta_facts"

TEST_INDEX = "texta_test_index"

TEST_FIELD = "comment_content_lemmas"

TEST_FIELD_CHOICE = [TEST_FIELD]

TEST_FACT_NAME = "TEEMA"

BASE_DIR = os.path.dirname(os.path.dirname(os.path.abspath(__file__)))

# data dir for files generated by TK
DATA_DIR = os.getenv("TEXTA_DATA_DIR", default=os.path.join(BASE_DIR, "data"))

# Path to the directory containing test files
TEST_DATA_DIR = os.path.join(DATA_DIR, "test")
