#!py

import base64

CERTS = [
    {
        'id': 'SV-52961r3_rule',
        'keys': [
            r'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\SystemCertificates\Root\Certificates\8C941B34EA1EA6ED9AE2BC54CF687252B4C9B561',
            r'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\EnterpriseCertificates\Root\Certificates\8C941B34EA1EA6ED9AE2BC54CF687252B4C9B561',
            r'HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\SystemCertificates\Root\Certificates\8C941B34EA1EA6ED9AE2BC54CF687252B4C9B561',
            r'HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\EnterpriseCertificates\Root\Certificates\8C941B34EA1EA6ED9AE2BC54CF687252B4C9B561',
        ],
        'vdata': base64.b16decode(
            '5c0000000100000004000000000800001900000001000000100000000369ec22'
            '2bd877c01803f7e32eeaf6990f00000001000000140000008df2c761ae6d13b7'
            '1643f207be9b82362dcc14920300000001000000140000008c941b34ea1ea6ed'
            '9ae2bc54cf687252b4c9b5611400000001000000140000004974bb0c5eba7afe'
            '0254ef7ba0c695c609807096040000000100000010000000477892db8aec1b53'
            '68f01d009c34775e2000000001000000740300003082037030820258a0030201'
            '02020105300d06092a864886f70d0101050500305b310b300906035504061302'
            '555331183016060355040a130f552e532e20476f7665726e6d656e74310c300a'
            '060355040b1303446f44310c300a060355040b1303504b493116301406035504'
            '03130d446f4420526f6f742043412032301e170d303431323133313530303130'
            '5a170d3239313230353135303031305a305b310b300906035504061302555331'
            '183016060355040a130f552e532e20476f7665726e6d656e74310c300a060355'
            '040b1303446f44310c300a060355040b1303504b49311630140603550403130d'
            '446f4420526f6f74204341203230820122300d06092a864886f70d0101010500'
            '0382010f003082010a0282010100c02cc1f68d3bacff3f3cd671beb8742207ec'
            '704115fcab40e307aac1c3d89ffeda4c3abf3fc8d8287b4b3601c0ac4525c3d2'
            '0e0a8f851864103d1a13702a6f8ed7dc8d93b3410f3821cdadabc23d2a05d357'
            '11370dcd8c51f993e3cc4649218e14b4cdcb143e38cd7231eeab12f265ea342e'
            '565dffee6375cb6dba9134fc9ef3f42d1cbe50c442df5988ff6ab3faa86c3dcb'
            '5671710596bb9f80e58045596741b0ebc3ad60a4807506179c0ef443e0990e1b'
            'fb7ff5b3ccb28182b1fd32c1b8be41a464b5603a5a51308ccede412c19475c49'
            '1064b974a98741af7d6ebac1b8a1bf65313a0467f9b5bb8e928a0063b8b1e68c'
            '385f83ff50d53ba25d6bb210cc630203010001a33f303d301d0603551d0e0416'
            '04144974bb0c5eba7afe0254ef7ba0c695c609807096300b0603551d0f040403'
            '020186300f0603551d130101ff040530030101ff300d06092a864886f70d0101'
            '050500038201010098918d3f89c8bbf5c06973293b35acbab308763d700992e9'
            '844421017d14761bee516c1d8d15372d7b3169f49a44b8af46cc34fa23cb0327'
            '19d28321752be7e01b9926dc844095e8a8d2ccf6585c66ef3f4a9710821dba0a'
            'a2dd5b062b9da7644eeb2e0135a4b43f13ad55e4d573a8699b11f198f2311e6f'
            '40d4f8789f8e91a06f70049066aa062bcee17a92b57de1e0d196e7a13a2dccb1'
            '9d1f0544ed8799d34d1a7039c1040ce57ed9f1afd7200ef1227a25a47399cc3f'
            'a4072796a8a295ed82b916d39e0b87c2c1f288f562df68dfc7bc6951edb15cdc'
            '5454290f09399aac03c1db0c4dae6f0a7a1649f1bf91d23894d3f6952cb76cc9'
            '42b68dca908d85d9'
            .upper()
        ),
    },
    {
        'id': 'SV-52957r3_rule',
        'keys': [
            r'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\SystemCertificates\Disallowed\Certificates\99C494ECE4FC093EEE13C4D65B1B1E01B9B5D434',
            r'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\EnterpriseCertificates\Disallowed\Certificates\99C494ECE4FC093EEE13C4D65B1B1E01B9B5D434',
            r'HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\SystemCertificates\Disallowed\Certificates\99C494ECE4FC093EEE13C4D65B1B1E01B9B5D434',
            r'HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\EnterpriseCertificates\Disallowed\Certificates\99C494ECE4FC093EEE13C4D65B1B1E01B9B5D434',
        ],
        'vdata': base64.b16decode(
            '0f0000000100000014000000d937493704bb4e086b379c6f3b5f98716e5ef385'
            '03000000010000001400000099c494ece4fc093eee13c4d65b1b1e01b9b5d434'
            '20000000010000001b05000030820517308203ffa00302010202020378300d06'
            '092a864886f70d0101050500306c310b30090603550406130255533118301606'
            '0355040a130f552e532e20476f7665726e6d656e74310c300a060355040b1303'
            '446f44310c300a060355040b1303504b49312730250603550403131e446f4420'
            '496e7465726f7065726162696c69747920526f6f742043412031301e170d3133'
            '313031303133313534305a170d3136313030393133313534305a305b310b3009'
            '06035504061302555331183016060355040a130f552e532e20476f7665726e6d'
            '656e74310c300a060355040b1303446f44310c300a060355040b1303504b4931'
            '1630140603550403130d446f4420526f6f74204341203230820122300d06092a'
            '864886f70d01010105000382010f003082010a0282010100c02cc1f68d3bacff'
            '3f3cd671beb8742207ec704115fcab40e307aac1c3d89ffeda4c3abf3fc8d828'
            '7b4b3601c0ac4525c3d20e0a8f851864103d1a13702a6f8ed7dc8d93b3410f38'
            '21cdadabc23d2a05d35711370dcd8c51f993e3cc4649218e14b4cdcb143e38cd'
            '7231eeab12f265ea342e565dffee6375cb6dba9134fc9ef3f42d1cbe50c442df'
            '5988ff6ab3faa86c3dcb5671710596bb9f80e58045596741b0ebc3ad60a48075'
            '06179c0ef443e0990e1bfb7ff5b3ccb28182b1fd32c1b8be41a464b5603a5a51'
            '308ccede412c19475c491064b974a98741af7d6ebac1b8a1bf65313a0467f9b5'
            'bb8e928a0063b8b1e68c385f83ff50d53ba25d6bb210cc630203010001a38201'
            'd2308201ce301d0603551d0e041604144974bb0c5eba7afe0254ef7ba0c695c6'
            '09807096301f0603551d2304183016801476861edfed00c97e14317c5b948221'
            '4957be7007300e0603551d0f0101ff040403020106304a0603551d2004433041'
            '300b0609608648016502010b05300b0609608648016502010b09300b06096086'
            '48016502010b11300b0609608648016502010b12300b0609608648016502010b'
            '13307c06082b060105050701010470306e304a06082b06010505073002863e68'
            '7474703a2f2f63726c2e646973612e6d696c2f697373756564746f2f444f4449'
            '4e5445524f5045524142494c495459524f4f544341315f49542e703763302006'
            '082b060105050730018614687474703a2f2f6f6373702e646973612e6d696c30'
            '4a06082b0601050507010b043e303c303a06082b06010505073005862e687474'
            '703a2f2f63726c2e646973612e6d696c2f69737375656462792f444f44524f4f'
            '544341325f49422e703763300f0603551d130101ff040530030101ff300c0603'
            '551d240405300380010030470603551d1f0440303e303ca03aa0388636687474'
            '703a2f2f63726c2e646973612e6d696c2f63726c2f444f44494e5445524f5045'
            '524142494c495459524f4f544341312e63726c300d06092a864886f70d010105'
            '050003820101006d41168cc949e166ae06a1475bf4c014ca9e64d7ea49a788ae'
            '4eebac46e815e5ded4bfaee38b97b69a377c5400a613f2c9825aecfcc561c02d'
            '63d33cebcf2e905797bb2a93f421ba7c255bbe84918be8facd18c72b6099fe73'
            'b569191b37ef551cd688a690af7358559e41dfeb5604f8425571b0bbd762223f'
            'c1125bfdcc90a19b2ecb97b04218ef2892e3dccd3e02f4c5aec3bda377f6959d'
            '188caebbfd22554dda39797ce018aa0c134330e5626310716b2c9279d3654ccc'
            '561032a62a9ad7b327d0ffa056ed0eff0e048a617b27f689f9e535de56491bb4'
            '59ed11b50a6e209e80652a3b4d373a2d4a08f1e3fbdccc4407a589e759992cfa'
            '9a3ba52aa9271a'
            .upper()
        ),
    },
    {
        'id': 'SV-52196r3_rule',
        'keys': [
            r'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\SystemCertificates\Disallowed\Certificates\7DA8E84296EE238818EE427287774508B26D094A',
            r'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\EnterpriseCertificates\Disallowed\Certificates\7DA8E84296EE238818EE427287774508B26D094A',
            r'HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\SystemCertificates\Disallowed\Certificates\7DA8E84296EE238818EE427287774508B26D094A',
            r'HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\EnterpriseCertificates\Disallowed\Certificates\7DA8E84296EE238818EE427287774508B26D094A',
        ],
        'vdata': base64.b16decode(
            '0f0000000100000014000000511d2d92ef7908cf8157d5c16789db198db3c3a7'
            '0300000001000000140000007da8e84296ee238818ee427287774508b26d094a'
            '2000000001000000320500003082052e30820416a00302010202014e300d0609'
            '2a864886f70d01010505003074310b3009060355040613025553311830160603'
            '55040a130f552e532e20476f7665726e6d656e74310c300a060355040b130344'
            '6f44310c300a060355040b1303504b49312f302d06035504031326555320446f'
            '44204343454220496e7465726f7065726162696c69747920526f6f7420434120'
            '31301e170d3133303530313132353333315a170d313630353031313235333331'
            '5a305b310b300906035504061302555331183016060355040a130f552e532e20'
            '476f7665726e6d656e74310c300a060355040b1303446f44310c300a06035504'
            '0b1303504b49311630140603550403130d446f4420526f6f7420434120323082'
            '0122300d06092a864886f70d01010105000382010f003082010a0282010100c0'
            '2cc1f68d3bacff3f3cd671beb8742207ec704115fcab40e307aac1c3d89ffeda'
            '4c3abf3fc8d8287b4b3601c0ac4525c3d20e0a8f851864103d1a13702a6f8ed7'
            'dc8d93b3410f3821cdadabc23d2a05d35711370dcd8c51f993e3cc4649218e14'
            'b4cdcb143e38cd7231eeab12f265ea342e565dffee6375cb6dba9134fc9ef3f4'
            '2d1cbe50c442df5988ff6ab3faa86c3dcb5671710596bb9f80e58045596741b0'
            'ebc3ad60a4807506179c0ef443e0990e1bfb7ff5b3ccb28182b1fd32c1b8be41'
            'a464b5603a5a51308ccede412c19475c491064b974a98741af7d6ebac1b8a1bf'
            '65313a0467f9b5bb8e928a0063b8b1e68c385f83ff50d53ba25d6bb210cc6302'
            '03010001a38201e2308201de301f0603551d2304183016801497185fab7bb0ac'
            'e483b95063d5618b4c80014d21301d0603551d0e041604144974bb0c5eba7afe'
            '0254ef7ba0c695c609807096300e0603551d0f0101ff040403020106304a0603'
            '551d2004433041300b0609608648016502010b05300b0609608648016502010b'
            '09300b0609608648016502010b11300b0609608648016502010b12300b060960'
            '8648016502010b13300f0603551d130101ff040530030101ff300f0603551d24'
            '0101ff04053003800100304d0603551d1f044630443042a040a03e863c687474'
            '703a2f2f63726c2e646973612e6d696c2f63726c2f5553444f4443434542494e'
            '5445524f5045524142494c495459524f4f544341312e63726c30818206082b06'
            '01050507010104763074305006082b060105050730028644687474703a2f2f63'
            '726c2e646973612e6d696c2f697373756564746f2f5553444f4443434542494e'
            '5445524f5045524142494c495459524f4f544341315f49542e70376330200608'
            '2b060105050730018614687474703a2f2f6f6373702e646973612e6d696c304a'
            '06082b0601050507010b043e303c303a06082b06010505073005862e68747470'
            '3a2f2f63726c2e646973612e6d696c2f69737375656462792f444f44524f4f54'
            '4341325f49422e703763300d06092a864886f70d010105050003820101003496'
            'cea3da8213503c20cf8016dac3f6cf3f25c418388f1cf18aec0645eb9f305b1b'
            'be7f167ec66b7334d495b1102b832c18e8508752013df2187318203cd9654172'
            'ec9ad7ea05830f4e1aa3870393d2bd520870e940f29917b22f18c9f6a395c0a3'
            'd711888e783312fb4f0d5c05d469dcb72578e7f70e74a1e23a330aa343ab4397'
            'bc024ad4d2b9a03a8da1be0acbb905c4253523bba5621153faea9000672f057c'
            'dec103aa385016de75f148d975a37c653c92aedeee55d216ba755c5f2304276c'
            '8b9116f6f25820f95c007721ba8a9106920762b67587b0dc30be0bc2b3fe181a'
            '9528f7cd066ece81f65a566ad072f571a182762c2b4f0f84b39f9877818a'
            .upper()
        ),
    },
    {
        'id': 'SV-48308r2_rule',
        'keys': [
            r'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\SystemCertificates\Root\Certificates\C313F919A6ED4E0E8451AFA930FB419A20F181E4',
            r'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\EnterpriseCertificates\Root\Certificates\C313F919A6ED4E0E8451AFA930FB419A20F181E4',
            r'HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\SystemCertificates\Root\Certificates\C313F919A6ED4E0E8451AFA930FB419A20F181E4',
            r'HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\EnterpriseCertificates\Root\Certificates\C313F919A6ED4E0E8451AFA930FB419A20F181E4',
        ],
        'vdata': base64.b16decode(
            '190000000100000010000000e58952d37187ad771faa5ad3177a21de0f000000'
            '0100000014000000d224113ec1b44b8da2850f5428b931d092b7e87a03000000'
            '0100000014000000c313f919a6ed4e0e8451afa930fb419a20f181e414000000'
            '0100000014000000ede487d027c450e6843af7ccf7eb3a49fc524e2120000000'
            '010000003e0400003082043a30820322a003020102020105300d06092a864886'
            'f70d0101050500304d310b300906035504061302555331183016060355040a13'
            '0f552e532e20476f7665726e6d656e74310c300a060355040b13034543413116'
            '30140603550403130d45434120526f6f742043412032301e170d303830343034'
            '3134323434395a170d3238303333303134323434395a304d310b300906035504'
            '061302555331183016060355040a130f552e532e20476f7665726e6d656e7431'
            '0c300a060355040b1303454341311630140603550403130d45434120526f6f74'
            '204341203230820122300d06092a864886f70d01010105000382010f00308201'
            '0a0282010100b390d81eef9aed6e47b14661468da356089c4a32c745f2d2a4a4'
            '66be7e3d9780efe9d76be9e0c03b8de2f812fa1335a4cd5a868bb0d02f348cf7'
            '05ed876fa73017d016c65846bd95f9561a88d44e1e7e581f1ba273159d5e8b06'
            '2413763c9f6062adb0b5f4e024c153f7d91c371de63cf0fad3f1f9a198f13785'
            'd8cf0260f0a038944b512809c217fc40a461790eb48c1b208262f5e49ad6298a'
            '36fa1f81c0a111314bfe56fdd8bf51932759daf5833e44a4dfd52067eb9f00a7'
            'fbde31b663311c3df71c6c098d7ff4ba9ca87c1f01c6806d0101d837a8fe2d7d'
            '2bc2cbd6e99cba948d7616decc8175047b4177156515c9ac00b6bfeb1cdcb98d'
            '642dff35dbc50203010001a38201233082011f301d0603551d0e04160414ede4'
            '87d027c450e6843af7ccf7eb3a49fc524e21300e0603551d0f0101ff04040302'
            '0186300f0603551d130101ff040530030101ff3081dc06082b0601050507010b'
            '0481cf3081cc304306082b060105050730058637687474703a2f2f63726c2e67'
            '64732e646973612e6d696c2f67657449737375656442793f454341253230526f'
            '6f7425323043412532303230818406082b0601050507300586786c6461703a2f'
            '2f63726c2e6764732e646973612e6d696c2f636e253364454341253230526f6f'
            '742532304341253230322532636f752533644543412532636f253364552e532e'
            '253230476f7665726e6d656e742532636325336455533f63726f737343657274'
            '69666963617465506169723b62696e617279300d06092a864886f70d01010505'
            '0003820101004acc1be785889323d9b9becfbaf13594c14b3c13705d832e4e7e'
            'c1560f2dc17e1f0de9ddfe02997c60e386aab98623c3177ec7110fe3d04256a3'
            '1cf3708fb18891b5bc0e892566c83f5f362a0e3eb667408c3d40dfa762e03818'
            'fa246d2d23d3c0b8745e9544547a21970f5acdc3fc953d222215dd18605d8537'
            'a94df781fcbd4aa6588c4fbfc765a1ffe2d334481a170132f284f3de05b26449'
            '9837cd21f5a8815b64c5da7c58b061611fadc0aded34b694abc79cec65972985'
            '949433c435248b3dcdfc372abbfaa4b61b90f295571748e0efa99dad00e2b164'
            'd967791183b99ae80b3236ce2067e37a6d4bea5e53e52f3041ddf8e5549da9d7'
            '69c675d94547'
            .upper()
        ),
    },
    {
        'id': 'SV-42596r4_rule_01',
        'keys': [
            r'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\SystemCertificates\Root\Certificates\D73CA91102A2204A36459ED32213B467D7CE97FB',
            r'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\EnterpriseCertificates\Root\Certificates\D73CA91102A2204A36459ED32213B467D7CE97FB',
            r'HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\SystemCertificates\Root\Certificates\D73CA91102A2204A36459ED32213B467D7CE97FB',
            r'HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\EnterpriseCertificates\Root\Certificates\D73CA91102A2204A36459ED32213B467D7CE97FB',
        ],
        'vdata': base64.b16decode(
            '1900000001000000100000003fefe339eef97b84e5601e839776e0020f000000'
            '01000000200000006f45ab48c624f991878aee783dc906786c6127e306f7f1bd'
            'f90d546f16876c85030000000100000014000000d73ca91102a2204a36459ed3'
            '2213b467d7ce97fb1400000001000000140000006c8a94a277b180721d817a16'
            'aaf2dcce66ee45c0200000000100000077030000308203733082025ba0030201'
            '02020101300d06092a864886f70d01010b0500305b310b300906035504061302'
            '555331183016060355040a130f552e532e20476f7665726e6d656e74310c300a'
            '060355040b1303446f44310c300a060355040b1303504b493116301406035504'
            '03130d446f4420526f6f742043412033301e170d313230333230313834363431'
            '5a170d3239313233303138343634315a305b310b300906035504061302555331'
            '183016060355040a130f552e532e20476f7665726e6d656e74310c300a060355'
            '040b1303446f44310c300a060355040b1303504b49311630140603550403130d'
            '446f4420526f6f74204341203330820122300d06092a864886f70d0101010500'
            '0382010f003082010a0282010100a9ec14728ae84b70a3da100384a6fba7360d'
            '2a3a5216bf30155286054720cfaaa6cd75c4646eeff16023cb0a6640aeb4c868'
            '2a0051684937e959324d95bc4327e9408d3a10ce14bc4318a1f9decce7857673'
            '5e181a235bbd3f1ff2ed8d19cc03d140a48fa720024c275a7936f6a337218e00'
            '5a0616cad355966f3129bb720ecbe24851f2d437a435d66fee17b3b106ab0b19'
            '86e8236d311b287865c5de6252bcc17debeea05d5404fbb2cb2bb2235491824c'
            'f0bfba74403b0c044580675cc5eba257c31a7f0a2dbd7fb9dcc199b0c807e40c'
            '8636943a252ff27de6973c1b94b4975906c93ae40bd9eae9fc3b73346ffde798'
            'e4f3a1c2905f1cf53f2ed719d37f0203010001a3423040301d0603551d0e0416'
            '04146c8a94a277b180721d817a16aaf2dcce66ee45c0300e0603551d0f0101ff'
            '040403020186300f0603551d130101ff040530030101ff300d06092a864886f7'
            '0d01010b050003820101009f71a4c0b696d28043a048e91f7604f9c53cad6618'
            '58639bc3b6e8688a855a426612b4d2e68b887f87f498f5a8c609c91ff02c1fec'
            '82b8f4a54738c1332bdf4c7e9abe0b0bb1cb0f7c502810cf8a8da2e9baac86d7'
            'd4b1935f228f9605b44e0c75917dd3f2e794c29414764f8f0cab108758328507'
            '7586120b5eea53b40ac84c84921febe841863cbaf44e414ad16c584741c3865a'
            'f2eee9f2982782ea2e36d6f8065e82f1a052934409bad2a9195a58a3a85d206d'
            '4f64f830871b90134881cdca90c70dc1d4983f8ef20e576833128e9909b1f0e4'
            'f610f436f249bdeaa338c8564123839adfa11b357ceb3f41b3f56f4b3a5eae6f'
            '937698d2f1999d45c48e72'
            .upper()
        ),
    },
    {
        'id': 'SV-42596r4_rule_02',
        'keys': [
            r'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\SystemCertificates\Root\Certificates\B8269F25DBD937ECAFD4C35A9838571723F2D026',
            r'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\EnterpriseCertificates\Root\Certificates\B8269F25DBD937ECAFD4C35A9838571723F2D026',
            r'HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\SystemCertificates\Root\Certificates\B8269F25DBD937ECAFD4C35A9838571723F2D026',
            r'HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\EnterpriseCertificates\Root\Certificates\B8269F25DBD937ECAFD4C35A9838571723F2D026',
        ],
        'vdata': base64.b16decode(
            '190000000100000010000000c3389765b1fcb8cbafb185d70a34dde90f000000'
            '010000002000000046ebd21f903e3ac4f51ba1913fc1bbfc8e4284df4d9a555b'
            '969bd4a7d6b890cc030000000100000014000000b8269f25dbd937ecafd4c35a'
            '9838571723f2d026140000000100000014000000bdc1b96b4df41dec3090bf62'
            '73c08433f27124852000000001000000ef010000308201eb3082018fa0030201'
            '02020101300c06082a8648ce3d0403020500305b310b30090603550406130255'
            '5331183016060355040a130f552e532e20476f7665726e6d656e74310c300a06'
            '0355040b1303446f44310c300a060355040b1303504b49311630140603550403'
            '130d446f4420526f6f742043412034301e170d3132303733303139343832335a'
            '170d3332303732353139343832335a305b310b30090603550406130255533118'
            '3016060355040a130f552e532e20476f7665726e6d656e74310c300a06035504'
            '0b1303446f44310c300a060355040b1303504b49311630140603550403130d44'
            '6f4420526f6f7420434120343059301306072a8648ce3d020106082a8648ce3d'
            '0301070342000476c8d843cb0f07d22c0f2ad038f182cd4255e7dc1d5a80b708'
            '914b54d64fb2668534968d2e3ef4e04a917ccccd869f11e052a16682c6cb9023'
            'ec5f5ff5f03c45a3423040301d0603551d0e04160414bdc1b96b4df41dec3090'
            'bf6273c08433f2712485300e0603551d0f0101ff040403020186300f0603551d'
            '130101ff040530030101ff300c06082a8648ce3d040302050003480030450221'
            '00e8618af7dcaa09a507d2449e82035a445347842399cf5cd3de4a5ed6bb3535'
            '460220760fb8c47c16357fd412ed883d80116b64074c4565df53ae5f01edf143'
            'd2f5b7'
            .upper()
        ),
    },
    {
        'id': 'SV-SV-78073r2_rule_02',
        'keys': [
            r'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\SystemCertificates\Root\Certificates\73E8BB08E337D6A5A6AEF90CFFDD97D9176CB582',
            r'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\EnterpriseCertificates\Root\Certificates\73E8BB08E337D6A5A6AEF90CFFDD97D9176CB582',
            r'HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\SystemCertificates\Root\Certificates\73E8BB08E337D6A5A6AEF90CFFDD97D9176CB582',
            r'HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\EnterpriseCertificates\Root\Certificates\73E8BB08E337D6A5A6AEF90CFFDD97D9176CB582',
        ],
        'vdata': base64.b16decode(
            '03000000010000001400000073e8bb08e337d6a5a6aef90cffdd97d9176cb582'
            '20000000010000005b030000308203573082023fa003020102020101300d0609'
            '2a864886f70d01010b0500304d310b3009060355040613025553311830160603'
            '55040a130f552e532e20476f7665726e6d656e74310c300a060355040b130345'
            '4341311630140603550403130d45434120526f6f742043412034301e170d3132'
            '303332303136313330345a170d3239313233303136313330345a304d310b3009'
            '06035504061302555331183016060355040a130f552e532e20476f7665726e6d'
            '656e74310c300a060355040b1303454341311630140603550403130d45434120'
            '526f6f74204341203430820122300d06092a864886f70d01010105000382010f'
            '003082010a0282010100b8706957bd805a41c019e695e7d48213dc2c384b8a82'
            'ca1c885d8e7e3c0c6f65e1dab81c7118b6de140879dbc68a99edfa21dd621800'
            '2df014cc5a4e779ef2e877140314c6a9fdb212a067ff1f377ad0708f96d77024'
            '0e2d9d455e3c0013eea03a311a90205765e43017c6c90479dd1effa0c8ef5fac'
            '00253a01bf969c04958ead52b39170f4f4ec33e10f081782b8860a3f39d1dc90'
            '39c73eb9332983d90ae813e05e3d0d2580c46ccf2c2e802ad02d40491bc49cb6'
            'f3362926ec3100731acd7795ade52c4bf1142936e8315cdef55c8f765bab01d6'
            'cfe7cd27abf4b4735042342587575a1e54993b9b01eac5dd95a3b072b6ec70a1'
            '2aaa85faf1a9389415070203010001a3423040301d0603551d0e04160414335b'
            'a56f7a55602b814b2614cc79bf4aba8b32bd300e0603551d0f0101ff04040302'
            '0186300f0603551d130101ff040530030101ff300d06092a864886f70d01010b'
            '05000382010100b61f617886beb57a71178af1d7450215f7ba20c5e59369255e'
            '1571394ec1d1d8e87b43bb8d19d1c020dfe74dab8a5d7f80208d8def02688ad5'
            '009c21b705ace7b78fb194533db96ef8f7e88255d128246580e516c7b0440bd3'
            '84524323c8dafb5ef60186d937bffd6eb850c80de63c74fa0b6e8ff28cc3df50'
            'b79f28f8ae501c9accbe766e4adaf4b52835a11d7291761a20ef3ac84490c01d'
            '067bb0cdb8c1e6b25b4f48155a23a36ac9065a7c8c884471899ae76ade3d09af'
            'd1cbbc95a708578e51a13111d371f083ef50c7ee796c3b2363f89a666e0e2920'
            '1bad25cdb9b8bf1bd2734000c34dac8964f173a083890e1a7498a8943cb674ec'
            '944e0215eb316e'
            .upper()
        ),
    },
    {
        'id': 'SV-42607r6_rule_01',
        'keys': [
            r'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\SystemCertificates\Disallowed\Certificates\FCE1B1E25374DD94F5935BEB86CA643D8C8D1FF4',
            r'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\EnterpriseCertificates\Disallowed\Certificates\FCE1B1E25374DD94F5935BEB86CA643D8C8D1FF4',
            r'HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\SystemCertificates\Disallowed\Certificates\FCE1B1E25374DD94F5935BEB86CA643D8C8D1FF4',
            r'HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\EnterpriseCertificates\Disallowed\Certificates\FCE1B1E25374DD94F5935BEB86CA643D8C8D1FF4',
        ],
        'vdata': base64.b16decode(
            '0f0000000100000020000000b864c3addc824d5b7fb7fec4c07343b6ff9754ab'
            'e46bddf36d521b1f4a6ec0d2030000000100000014000000fce1b1e25374dd94'
            'f5935beb86ca643d8c8d1ff420000000010000002e0500003082052a30820412'
            'a003020102020202ec300d06092a864886f70d01010b0500306c310b30090603'
            '5504061302555331183016060355040a130f552e532e20476f7665726e6d656e'
            '74310c300a060355040b1303446f44310c300a060355040b1303504b49312730'
            '250603550403131e446f4420496e7465726f7065726162696c69747920526f6f'
            '742043412032301e170d3136303231373134333231315a170d31393032313731'
            '34333231315a305b310b300906035504061302555331183016060355040a130f'
            '552e532e20476f7665726e6d656e74310c300a060355040b1303446f44310c30'
            '0a060355040b1303504b49311630140603550403130d446f4420526f6f742043'
            '41203330820122300d06092a864886f70d01010105000382010f003082010a02'
            '82010100a9ec14728ae84b70a3da100384a6fba7360d2a3a5216bf3015528605'
            '4720cfaaa6cd75c4646eeff16023cb0a6640aeb4c8682a0051684937e959324d'
            '95bc4327e9408d3a10ce14bc4318a1f9decce78576735e181a235bbd3f1ff2ed'
            '8d19cc03d140a48fa720024c275a7936f6a337218e005a0616cad355966f3129'
            'bb720ecbe24851f2d437a435d66fee17b3b106ab0b1986e8236d311b287865c5'
            'de6252bcc17debeea05d5404fbb2cb2bb2235491824cf0bfba74403b0c044580'
            '675cc5eba257c31a7f0a2dbd7fb9dcc199b0c807e40c8636943a252ff27de697'
            '3c1b94b4975906c93ae40bd9eae9fc3b73346ffde798e4f3a1c2905f1cf53f2e'
            'd719d37f0203010001a38201e5308201e1301f0603551d23041830168014fff8'
            'ae138b922b799241a3765c2c819e9ac59c78301d0603551d0e041604146c8a94'
            'a277b180721d817a16aaf2dcce66ee45c0300f0603551d130101ff0405300301'
            '01ff300e0603551d0f0101ff04040302010630470603551d1f0440303e303ca0'
            '3aa0388636687474703a2f2f63726c2e646973612e6d696c2f63726c2f444f44'
            '494e5445524f5045524142494c495459524f4f544341322e63726c307c06082b'
            '060105050701010470306e304a06082b06010505073002863e687474703a2f2f'
            '63726c2e646973612e6d696c2f697373756564746f2f444f44494e5445524f50'
            '45524142494c495459524f4f544341325f49542e703763302006082b06010505'
            '0730018614687474703a2f2f6f6373702e646973612e6d696c305a0603551d20'
            '04533051300b0609608648016502010b24300b0609608648016502010b27300b'
            '0609608648016502010b2a300c060a6086480165030201030d300c060a608648'
            '01650302010311300c060a60864801650302010327300f0603551d240101ff04'
            '053003800100304a06082b0601050507010b043e303c303a06082b0601050507'
            '3005862e687474703a2f2f63726c2e646973612e6d696c2f6973737565646279'
            '2f444f44524f4f544341335f49422e703763300d06092a864886f70d01010b05'
            '00038201010077f6ef07258de58560056a3983fb1cc4da6fd791780d16cbd9a6'
            '6d37941dc74471d1e9418fd2bb05025275470a1084ce4de7e4045d421e2139c5'
            '88e30ab65005313f8fd08c5675d4433efedf1c4d869770e722623f4076966686'
            '418f17012930b70aa79f6aa241be88a7fa59752ff3dee6a4f0f42c60650f74c5'
            '655cb4bdd2c7e733d87416d2ffa929c78dd0c723043ae9eb1b6f9a59243e865f'
            'e59e0dacc32c6bc0643001eb135daaa7f6319e88fd29dbbae554a686c21e8e34'
            '7702ea1f6cccf60b83e6278bb04a88925c3a39108bc948c9e31b341e41436e95'
            'deb0c797f0a5e2930cde6adf729dbe3eee4c629c10b0ed2bfbc695f84a241e8e'
            '291bdc93f5e4'
            .upper()
        ),
    },
    {
        'id': 'SV-42607r6_rule_02',
        'keys': [
            r'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\SystemCertificates\Disallowed\Certificates\FFAD03329B9E527A43EEC66A56F9CBB5393E6E13',
            r'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\EnterpriseCertificates\Disallowed\Certificates\FFAD03329B9E527A43EEC66A56F9CBB5393E6E13',
            r'HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\SystemCertificates\Disallowed\Certificates\FFAD03329B9E527A43EEC66A56F9CBB5393E6E13',
            r'HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\EnterpriseCertificates\Disallowed\Certificates\FFAD03329B9E527A43EEC66A56F9CBB5393E6E13',
        ],
        'vdata': base64.b16decode(
            '0f00000001000000200000008d9fe58f0c646620ce8bf641514f26dd79c6242b'
            'ec58c0f53f1bf3df7c8bd4ba030000000100000014000000ffad03329b9e527a'
            '43eec66a56f9cbb5393e6e132000000001000000200500003082051c30820404'
            'a0030201020202028f300d06092a864886f70d01010b0500306c310b30090603'
            '5504061302555331183016060355040a130f552e532e20476f7665726e6d656e'
            '74310c300a060355040b1303446f44310c300a060355040b1303504b49312730'
            '250603550403131e446f4420496e7465726f7065726162696c69747920526f6f'
            '742043412032301e170d3135303932333136333732355a170d31383039323331'
            '36333732355a305b310b300906035504061302555331183016060355040a130f'
            '552e532e20476f7665726e6d656e74310c300a060355040b1303446f44310c30'
            '0a060355040b1303504b49311630140603550403130d446f4420526f6f742043'
            '41203330820122300d06092a864886f70d01010105000382010f003082010a02'
            '82010100a9ec14728ae84b70a3da100384a6fba7360d2a3a5216bf3015528605'
            '4720cfaaa6cd75c4646eeff16023cb0a6640aeb4c8682a0051684937e959324d'
            '95bc4327e9408d3a10ce14bc4318a1f9decce78576735e181a235bbd3f1ff2ed'
            '8d19cc03d140a48fa720024c275a7936f6a337218e005a0616cad355966f3129'
            'bb720ecbe24851f2d437a435d66fee17b3b106ab0b1986e8236d311b287865c5'
            'de6252bcc17debeea05d5404fbb2cb2bb2235491824cf0bfba74403b0c044580'
            '675cc5eba257c31a7f0a2dbd7fb9dcc199b0c807e40c8636943a252ff27de697'
            '3c1b94b4975906c93ae40bd9eae9fc3b73346ffde798e4f3a1c2905f1cf53f2e'
            'd719d37f0203010001a38201d7308201d3301f0603551d23041830168014fff8'
            'ae138b922b799241a3765c2c819e9ac59c78301d0603551d0e041604146c8a94'
            'a277b180721d817a16aaf2dcce66ee45c0300f0603551d130101ff0405300301'
            '01ff300e0603551d0f0101ff04040302010630470603551d1f0440303e303ca0'
            '3aa0388636687474703a2f2f63726c2e646973612e6d696c2f63726c2f444f44'
            '494e5445524f5045524142494c495459524f4f544341322e63726c307c06082b'
            '060105050701010470306e304a06082b06010505073002863e687474703a2f2f'
            '63726c2e646973612e6d696c2f697373756564746f2f444f44494e5445524f50'
            '45524142494c495459524f4f544341325f49542e703763302006082b06010505'
            '0730018614687474703a2f2f6f6373702e646973612e6d696c304c0603551d20'
            '04453043300b0609608648016502010b24300b0609608648016502010b27300b'
            '0609608648016502010b2a300c060a6086480165030201030d300c060a608648'
            '01650302010311300f0603551d240101ff04053003800100304a06082b060105'
            '0507010b043e303c303a06082b06010505073005862e687474703a2f2f63726c'
            '2e646973612e6d696c2f69737375656462792f444f44524f4f544341335f4942'
            '2e703763300d06092a864886f70d01010b050003820101008c308713a97dfb98'
            'fc50caa1208a9c107b0cc4d70cd94d5e362624ed2b5f75ed9a0ab8e96e5f20a3'
            '19ef39243e9ea2e119c5b353fc58e68eca84facd3594386df2e33e0431dc7bec'
            'd5fc3a2e34461ce450c174cee9fc878921a6a527a29ffbf0883ad895a4d1b978'
            'd0fdc3541ab98d9fdfafb660968c66bb5592d9085394ca35f4e387932a64e3ba'
            '69d15cf31d2e7b1c4f3a95c2f6b3bce040c883c29e3d5002cf7bebf42db20698'
            '2d075dd3062ade6ee14d570c81b608e4189822ce449400b67fae8d84576640b5'
            'b667956741534b8be93fe728e9b280dd7dd97c89402e55e1455fd5476a9bb634'
            '03975e32a5ec3e02d649a5c94f8521d8f80e9fa82d6c02f0'
            .upper()
        ),
    },
    {
        'id': 'SV-42607r6_rule_03_BADTHUMBPRINT',
        'keys': [
            r'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\SystemCertificates\Disallowed\Certificates\22BBE981F0694D246CC1472ED2B021DC8540A22F',
            r'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\EnterpriseCertificates\Disallowed\Certificates\22BBE981F0694D246CC1472ED2B021DC8540A22F',
            r'HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\SystemCertificates\Disallowed\Certificates\22BBE981F0694D246CC1472ED2B021DC8540A22F',
            r'HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\EnterpriseCertificates\Disallowed\Certificates\22BBE981F0694D246CC1472ED2B021DC8540A22F',
        ],
        'vdata': base64.b16decode(
            '0f0000000100000014000000d937493704bb4e086b379c6f3b5f98716e5ef385'
            '03000000010000001400000099c494ece4fc093eee13c4d65b1b1e01b9b5d434'
            '20000000010000001b05000030820517308203ffa00302010202020378300d06'
            '092a864886f70d0101050500306c310b30090603550406130255533118301606'
            '0355040a130f552e532e20476f7665726e6d656e74310c300a060355040b1303'
            '446f44310c300a060355040b1303504b49312730250603550403131e446f4420'
            '496e7465726f7065726162696c69747920526f6f742043412031301e170d3133'
            '313031303133313534305a170d3136313030393133313534305a305b310b3009'
            '06035504061302555331183016060355040a130f552e532e20476f7665726e6d'
            '656e74310c300a060355040b1303446f44310c300a060355040b1303504b4931'
            '1630140603550403130d446f4420526f6f74204341203230820122300d06092a'
            '864886f70d01010105000382010f003082010a0282010100c02cc1f68d3bacff'
            '3f3cd671beb8742207ec704115fcab40e307aac1c3d89ffeda4c3abf3fc8d828'
            '7b4b3601c0ac4525c3d20e0a8f851864103d1a13702a6f8ed7dc8d93b3410f38'
            '21cdadabc23d2a05d35711370dcd8c51f993e3cc4649218e14b4cdcb143e38cd'
            '7231eeab12f265ea342e565dffee6375cb6dba9134fc9ef3f42d1cbe50c442df'
            '5988ff6ab3faa86c3dcb5671710596bb9f80e58045596741b0ebc3ad60a48075'
            '06179c0ef443e0990e1bfb7ff5b3ccb28182b1fd32c1b8be41a464b5603a5a51'
            '308ccede412c19475c491064b974a98741af7d6ebac1b8a1bf65313a0467f9b5'
            'bb8e928a0063b8b1e68c385f83ff50d53ba25d6bb210cc630203010001a38201'
            'd2308201ce301d0603551d0e041604144974bb0c5eba7afe0254ef7ba0c695c6'
            '09807096301f0603551d2304183016801476861edfed00c97e14317c5b948221'
            '4957be7007300e0603551d0f0101ff040403020106304a0603551d2004433041'
            '300b0609608648016502010b05300b0609608648016502010b09300b06096086'
            '48016502010b11300b0609608648016502010b12300b0609608648016502010b'
            '13307c06082b060105050701010470306e304a06082b06010505073002863e68'
            '7474703a2f2f63726c2e646973612e6d696c2f697373756564746f2f444f4449'
            '4e5445524f5045524142494c495459524f4f544341315f49542e703763302006'
            '082b060105050730018614687474703a2f2f6f6373702e646973612e6d696c30'
            '4a06082b0601050507010b043e303c303a06082b06010505073005862e687474'
            '703a2f2f63726c2e646973612e6d696c2f69737375656462792f444f44524f4f'
            '544341325f49422e703763300f0603551d130101ff040530030101ff300c0603'
            '551d240405300380010030470603551d1f0440303e303ca03aa0388636687474'
            '703a2f2f63726c2e646973612e6d696c2f63726c2f444f44494e5445524f5045'
            '524142494c495459524f4f544341312e63726c300d06092a864886f70d010105'
            '050003820101006d41168cc949e166ae06a1475bf4c014ca9e64d7ea49a788ae'
            '4eebac46e815e5ded4bfaee38b97b69a377c5400a613f2c9825aecfcc561c02d'
            '63d33cebcf2e905797bb2a93f421ba7c255bbe84918be8facd18c72b6099fe73'
            'b569191b37ef551cd688a690af7358559e41dfeb5604f8425571b0bbd762223f'
            'c1125bfdcc90a19b2ecb97b04218ef2892e3dccd3e02f4c5aec3bda377f6959d'
            '188caebbfd22554dda39797ce018aa0c134330e5626310716b2c9279d3654ccc'
            '561032a62a9ad7b327d0ffa056ed0eff0e048a617b27f689f9e535de56491bb4'
            '59ed11b50a6e209e80652a3b4d373a2d4a08f1e3fbdccc4407a589e759992cfa'
            '9a3ba52aa9271a'
            .upper()
        ),
    },
    {
        'id': 'SV-52397r3_rule',
        'keys': [
            r'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\SystemCertificates\Disallowed\Certificates\DA36FAF56B2F6FBA1604F5BE46D864C9FA013BA3',
            r'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\EnterpriseCertificates\Disallowed\Certificates\DA36FAF56B2F6FBA1604F5BE46D864C9FA013BA3',
            r'HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\SystemCertificates\Disallowed\Certificates\DA36FAF56B2F6FBA1604F5BE46D864C9FA013BA3',
            r'HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\EnterpriseCertificates\Disallowed\Certificates\DA36FAF56B2F6FBA1604F5BE46D864C9FA013BA3',
        ],
        'vdata': base64.b16decode(
            '0f000000010000001400000019ac38d13b85a0e572864a09ff7c8948f99907a3'
            '030000000100000014000000da36faf56b2f6fba1604f5be46d864c9fa013ba3'
            '2000000001000000330500003082052f30820417a003020102020202fa300d06'
            '092a864886f70d01010505003074310b30090603550406130255533118301606'
            '0355040a130f552e532e20476f7665726e6d656e74310c300a060355040b1303'
            '446f44310c300a060355040b1303504b49312f302d0603550403132655532044'
            '6f44204343454220496e7465726f7065726162696c69747920526f6f74204341'
            '2031301e170d3136303330383135303833395a170d3139303330393135303833'
            '395a305b310b300906035504061302555331183016060355040a130f552e532e'
            '20476f7665726e6d656e74310c300a060355040b1303446f44310c300a060355'
            '040b1303504b49311630140603550403130d446f4420526f6f74204341203230'
            '820122300d06092a864886f70d01010105000382010f003082010a0282010100'
            'c02cc1f68d3bacff3f3cd671beb8742207ec704115fcab40e307aac1c3d89ffe'
            'da4c3abf3fc8d8287b4b3601c0ac4525c3d20e0a8f851864103d1a13702a6f8e'
            'd7dc8d93b3410f3821cdadabc23d2a05d35711370dcd8c51f993e3cc4649218e'
            '14b4cdcb143e38cd7231eeab12f265ea342e565dffee6375cb6dba9134fc9ef3'
            'f42d1cbe50c442df5988ff6ab3faa86c3dcb5671710596bb9f80e58045596741'
            'b0ebc3ad60a4807506179c0ef443e0990e1bfb7ff5b3ccb28182b1fd32c1b8be'
            '41a464b5603a5a51308ccede412c19475c491064b974a98741af7d6ebac1b8a1'
            'bf65313a0467f9b5bb8e928a0063b8b1e68c385f83ff50d53ba25d6bb210cc63'
            '0203010001a38201e2308201de301f0603551d2304183016801497185fab7bb0'
            'ace483b95063d5618b4c80014d21301d0603551d0e041604144974bb0c5eba7a'
            'fe0254ef7ba0c695c609807096300e0603551d0f0101ff040403020106304a06'
            '03551d2004433041300b0609608648016502010b05300b060960864801650201'
            '0b09300b0609608648016502010b11300b0609608648016502010b12300b0609'
            '608648016502010b13300f0603551d130101ff040530030101ff300f0603551d'
            '240101ff04053003800100304d0603551d1f044630443042a040a03e863c6874'
            '74703a2f2f63726c2e646973612e6d696c2f63726c2f5553444f444343454249'
            '4e5445524f5045524142494c495459524f4f544341312e63726c30818206082b'
            '0601050507010104763074305006082b060105050730028644687474703a2f2f'
            '63726c2e646973612e6d696c2f697373756564746f2f5553444f444343454249'
            '4e5445524f5045524142494c495459524f4f544341315f49542e703763302006'
            '082b060105050730018614687474703a2f2f6f6373702e646973612e6d696c30'
            '4a06082b0601050507010b043e303c303a06082b06010505073005862e687474'
            '703a2f2f63726c2e646973612e6d696c2f69737375656462792f444f44524f4f'
            '544341325f49422e703763300d06092a864886f70d0101050500038201010020'
            '29ad61108af1e54e6f923f29eab5f7a5c7722a19ca4815ad76355464ef000552'
            'ced07a5866b0e1ba3dcc12a15c5ffca38846cb22992c9646bda63f653681b507'
            'f94273905aa3d983dc747c290371e9da8c8ce8e51f8dd2cbd3d08a661a17a95c'
            'c4b02f43282356c7a968c9c171525c247250afa351307ad743456f25322492e5'
            '3ea75de29045167f5c1d1350610303cbc77a43b15dbbc749d55969013d1c31b9'
            '87ce1c887acdf4dd1726522cb98609f666b63a75e35a401d25cda0925a9e9d03'
            '72129d83bb3f15d8f2e81f02a740bce43399f14e1d441a574f2817d7916a61a7'
            'f93d4bc00e2bd221b68800d0a09a35bfc5b59c5b2fdc487a576577b98606cf'
            .upper()
        ),
    },
    {
        'id': 'SV-103573r1_rule',
        'keys': [
            r'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\SystemCertificates\Root\Certificates\4ECB5CC3095670454DA1CBD410FC921F46B8564B',
            r'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\EnterpriseCertificates\Root\Certificates\4ECB5CC3095670454DA1CBD410FC921F46B8564B',
            r'HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\SystemCertificates\Root\Certificates\4ECB5CC3095670454DA1CBD410FC921F46B8564B',
            r'HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\EnterpriseCertificates\Root\Certificates\4ECB5CC3095670454DA1CBD410FC921F46B8564B',
        ],
        'vdata': base64.b16decode(
            '59000000010000001a000000450043004400530041002f00530048004100330'
            '038003400000004000000010000001000000079c299767356d93c7e768dbc12'
            '7b3c4114000000010000001400000086c01542fb7176dc3e2d115b21104435c'
            'ac1dc140300000001000000140000004ecb5cc3095670454da1cbd410fc921f'
            '46b8564b0f0000000100000030000000a5fa4ce0a10afa4d82b29de69e30f0c'
            '26978740f636bad61271ef188131451884c55618b0b716f48baea46f5a05bd4'
            '77190000000100000010000000f25d3e060307f59f238e1c147e6b3db55c000'
            '000010000000400000080010000200000000100000028020000308202243082'
            '01aaa00302010202010f300a06082a8648ce3d040303305b310b30090603550'
            '4061302555331183016060355040a130f552e532e20476f7665726e6d656e74'
            '310c300a060355040b1303446f44310c300a060355040b1303504b493116301'
            '40603550403130d446f4420526f6f742043412035301e170d31363036313431'
            '37313732375a170d3431303631343137313732375a305b310b3009060355040'
            '61302555331183016060355040a130f552e532e20476f7665726e6d656e7431'
            '0c300a060355040b1303446f44310c300a060355040b1303504b49311630140'
            '603550403130d446f4420526f6f7420434120353076301006072a8648ce3d02'
            '0106052b81040022036200043662de0b4ec0c7d729453a7f1c99e62a2176b10'
            '0dd8c47ffc0b1b4face3a4e52fba7ed362d1c1e1c908d97aa2ba6e2d373737c'
            '5c1cd067f40a29d39084eb51e5f15e1cc0d28684c56dd124490eec1789e468c'
            '8de1a5c1a06d038193329011a81a3423040301d0603551d0e0416041486c015'
            '42fb7176dc3e2d115b21104435cac1dc14300e0603551d0f0101ff040403020'
            '106300f0603551d130101ff040530030101ff300a06082a8648ce3d04030303'
            '6800306502304106e4dede62349ddfb8aa16d96da2381f392257c970841f930'
            'f577e052fa54b33cd15ea57d5d22b1f9b8d7cce6ab6cc023100b781d2e13b93'
            'cf1164dc0b2f17d26dd5d805e450726265dca43cca61a5069ac9fbedc430c97'
            'b89e0a5be6355e69c11e3'
            .upper()
        ),
    },
    {
        'id': 'SV-103575r1_rule',
        'keys': [
            r'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\SystemCertificates\Disallowed\Certificates\AC06108CA348CC03B53795C64BF84403C1DBD341',
            r'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\EnterpriseCertificates\Disallowed\Certificates\AC06108CA348CC03B53795C64BF84403C1DBD341',
            r'HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\SystemCertificates\Disallowed\Certificates\AC06108CA348CC03B53795C64BF84403C1DBD341',
            r'HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\EnterpriseCertificates\Disallowed\Certificates\AC06108CA348CC03B53795C64BF84403C1DBD341',
        ],
        'vdata': base64.b16decode(
            '0f0000000100000020000000423a768a6661b4faeaca2710c4a40862d1b0ca96'
            'c80ea0abf75ffe42c0872297030000000100000014000000ac06108ca348cc03'
            'b53795c64bf84403c1dbd34120000000010000002e0500003082052a30820412'
            'a00302010202020566300d06092a864886f70d01010b0500306c310b30090603'
            '5504061302555331183016060355040a130f552e532e20476f7665726e6d656e'
            '74310c300a060355040b1303446f44310c300a060355040b1303504b49312730'
            '250603550403131e446f4420496e7465726f7065726162696c69747920526f6f'
            '742043412032301e170d3139303132323135323235365a170d32323031323231'
            '35323235365a305b310b300906035504061302555331183016060355040a130f'
            '552e532e20476f7665726e6d656e74310c300a060355040b1303446f44310c30'
            '0a060355040b1303504b49311630140603550403130d446f4420526f6f742043'
            '41203330820122300d06092a864886f70d01010105000382010f003082010a02'
            '82010100a9ec14728ae84b70a3da100384a6fba7360d2a3a5216bf3015528605'
            '4720cfaaa6cd75c4646eeff16023cb0a6640aeb4c8682a0051684937e959324d'
            '95bc4327e9408d3a10ce14bc4318a1f9decce78576735e181a235bbd3f1ff2ed'
            '8d19cc03d140a48fa720024c275a7936f6a337218e005a0616cad355966f3129'
            'bb720ecbe24851f2d437a435d66fee17b3b106ab0b1986e8236d311b287865c5'
            'de6252bcc17debeea05d5404fbb2cb2bb2235491824cf0bfba74403b0c044580'
            '675cc5eba257c31a7f0a2dbd7fb9dcc199b0c807e40c8636943a252ff27de697'
            '3c1b94b4975906c93ae40bd9eae9fc3b73346ffde798e4f3a1c2905f1cf53f2e'
            'd719d37f0203010001a38201e5308201e1301f0603551d23041830168014fff8'
            'ae138b922b799241a3765c2c819e9ac59c78300f0603551d130101ff04053003'
            '0101ff300e0603551d0f0101ff04040302010630470603551d1f0440303e303c'
            'a03aa0388636687474703a2f2f63726c2e646973612e6d696c2f63726c2f444f'
            '44494e5445524f5045524142494c495459524f4f544341322e63726c301d0603'
            '551d0e041604146c8a94a277b180721d817a16aaf2dcce66ee45c0307c06082b'
            '060105050701010470306e304a06082b06010505073002863e687474703a2f2f'
            '63726c2e646973612e6d696c2f697373756564746f2f444f44494e5445524f50'
            '45524142494c495459524f4f544341325f49542e703763302006082b06010505'
            '0730018614687474703a2f2f6f6373702e646973612e6d696c305a0603551d20'
            '04533051300b0609608648016502010b24300b0609608648016502010b27300b'
            '0609608648016502010b2a300c060a6086480165030201030d300c060a608648'
            '01650302010311300c060a60864801650302010327300f0603551d240101ff04'
            '053003800100304a06082b0601050507010b043e303c303a06082b0601050507'
            '3005862e687474703a2f2f63726c2e646973612e6d696c2f6973737565646279'
            '2f444f44524f4f544341335f49422e703763300d06092a864886f70d01010b05'
            '00038201010014a3edf21d74a1f23e7205ba5302beddaa14900c58f1464d12ab'
            'e9cbeb671e0a1853984bf300a58ae38d7f24f345f1508ef711bcd13066da7831'
            '2f8474c176a1c46d7bed843d87e65877599ec9eebe2f2d553fc07d5d293ef9fe'
            '330cc971075a563200e7504fe1fcc1cee70ef3c6ea86c4e669a9306d4a1d0ffb'
            'ba907cb572ebc328337a87c4043b242f69132459e0c1e528d4473bc5e088428a'
            'e4c6490238729c2cdb40c19495ac90912314ba1211c15e9c124d59d9d8a4ca4c'
            '1f7a9080b6441caa59f03f1aa4fa5dede048ebe0534e6e44e863ce1787fdd868'
            'dc3911fc3a0a9447f6721bed6c527ccc65c7b534f877c8da8562c5b439e4c289'
            '1a9672e9549e'
            .upper()
        ),
    },
    {
        'id': 'SV-103577r1_rule',
        'keys': [
            r'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\SystemCertificates\Disallowed\Certificates\929BF3196896994C0A201DF4A5B71F603FEFBF2E',
            r'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\EnterpriseCertificates\Disallowed\Certificates\929BF3196896994C0A201DF4A5B71F603FEFBF2E',
            r'HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\SystemCertificates\Disallowed\Certificates\929BF3196896994C0A201DF4A5B71F603FEFBF2E',
            r'HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\EnterpriseCertificates\Disallowed\Certificates\929BF3196896994C0A201DF4A5B71F603FEFBF2E',
        ],
        'vdata': base64.b16decode(
                '5900000001000000160000005200530041002f00530048004100320035003600'
                '00001900000001000000100000003fefe339eef97b84e5601e839776e0020400'
                '000001000000100000003b0c5b937bd49cfcb818737b2b31c67c030000000100'
                '000014000000929bf3196896994c0a201df4a5b71f603fefbf2e0f0000000100'
                '000020000000f08c2f8e8dc56c4b64f3097a99f26e6720456c53d82f57eeb367'
                '0c30d611240d1400000001000000140000006c8a94a277b180721d817a16aaf2'
                'dcce66ee45c05c00000001000000040000000008000020000000010000001805'
                '000030820514308203fca00302010202011c300d06092a864886f70d01010b05'
                '003074310b300906035504061302555331183016060355040a130f552e532e20'
                '476f7665726e6d656e74310c300a060355040b1303446f44310c300a06035504'
                '0b1303504b49312f302d06035504031326555320446f44204343454220496e74'
                '65726f7065726162696c69747920526f6f742043412032301e170d3136303932'
                '373132343134315a170d3139303932373132343134315a305b310b3009060355'
                '04061302555331183016060355040a130f552e532e20476f7665726e6d656e74'
                '310c300a060355040b1303446f44310c300a060355040b1303504b4931163014'
                '0603550403130d446f4420526f6f74204341203330820122300d06092a864886'
                'f70d01010105000382010f003082010a0282010100a9ec14728ae84b70a3da10'
                '0384a6fba7360d2a3a5216bf30155286054720cfaaa6cd75c4646eeff16023cb'
                '0a6640aeb4c8682a0051684937e959324d95bc4327e9408d3a10ce14bc4318a1'
                'f9decce78576735e181a235bbd3f1ff2ed8d19cc03d140a48fa720024c275a79'
                '36f6a337218e005a0616cad355966f3129bb720ecbe24851f2d437a435d66fee'
                '17b3b106ab0b1986e8236d311b287865c5de6252bcc17debeea05d5404fbb2cb'
                '2bb2235491824cf0bfba74403b0c044580675cc5eba257c31a7f0a2dbd7fb9dc'
                'c199b0c807e40c8636943a252ff27de6973c1b94b4975906c93ae40bd9eae9fc'
                '3b73346ffde798e4f3a1c2905f1cf53f2ed719d37f0203010001a38201c83082'
                '01c4301f0603551d23041830168014162b91dae2170c96ab5c7dde7d48f25da8'
                '00ace7301d0603551d0e041604146c8a94a277b180721d817a16aaf2dcce66ee'
                '45c0300e0603551d0f0101ff04040302010630300603551d2004293027300b06'
                '09608648016502010b24300b0609608648016502010b27300b06096086480165'
                '02010b2a300f0603551d130101ff040530030101ff300f0603551d240101ff04'
                '053003800100304d0603551d1f044630443042a040a03e863c687474703a2f2f'
                '63726c2e646973612e6d696c2f63726c2f5553444f4443434542494e5445524f'
                '5045524142494c495459524f4f544341322e63726c30818206082b0601050507'
                '010104763074305006082b060105050730028644687474703a2f2f63726c2e64'
                '6973612e6d696c2f697373756564746f2f5553444f4443434542494e5445524f'
                '5045524142494c495459524f4f544341325f49542e703763302006082b060105'
                '050730018614687474703a2f2f6f6373702e646973612e6d696c304a06082b06'
                '01050507010b043e303c303a06082b06010505073005862e687474703a2f2f63'
                '726c2e646973612e6d696c2f69737375656462792f444f44524f4f544341335f'
                '49422e703763300d06092a864886f70d01010b0500038201010047e19848c97c'
                '2a1f60aa17fc51bf57e1461d6eaf2a476447d3f8232cd06faaae4c9395b618da'
                'f41ab197e9091e10b21266a57c0315e5b1ff987bc211d31f3cfa9743cbbc8366'
                '1e01fd86fdc3c80fbb0fca827277d57f087ebab1d327033ad994819df84417b1'
                'bf202ee88ed367d68de6f654bc7ffacd373df6e6f8ddb60189b4a8b97ca140e4'
                '2b00d578bea127f1264844e7f911c4dcdf597b8670c4620a4479aa745f25ac2f'
                '9f7ad1d7f285868389e42024579fe7b5f0bed0c62d94aef9016af3b669b14a73'
                '7633a2725a5a2a968b543ef4de9078618817e5db8c4fa613f710f88da5b42d7f'
                'b219657f15fc4f088a0f06a562a9b39aee2fb19731b204c2e447'
            .upper()
        ),
    },
]

def run():
    config = {}
    for cert in CERTS:
        for index,key in enumerate(cert['keys']):
            config['{0}_{1}'.format(cert['id'],index)] = {
                'reg.present' : [
                    { 'name': key },
                    { 'vname': 'Blob' },
                    { 'vdata': cert['vdata'] },
                    { 'vtype': 'REG_BINARY' },
                ],
            }
    return config
