# Finding ID:	RHEL-07-030610
# Version:	RHEL-07-030610_rule
# SRG ID:	SRG-OS-000392-GPOS-00172
# Finding Level:	medium
# 
# Rule Summary:
#	The operating system must generate audit records for all
#	unsuccessful account access events.
#
# CCI-000172 
# CCI-002884 
# CCI-000126 
#    NIST SP 800-53 :: AU-12 c 
#    NIST SP 800-53A :: AU-12.1 (iv) 
#    NIST SP 800-53 Revision 4 :: AU-12 c 
#    NIST SP 800-53 Revision 4 :: MA-4 (1) (a) 
#    NIST SP 800-53 :: AU-2 d 
#    NIST SP 800-53A :: AU-2.1 (v) 
#    NIST SP 800-53 Revision 4 :: AU-2 d 
#
#################################################################
{%- set stig_id = 'RHEL-07-030610' %}
{%- set helperLoc = 'ash-linux/el7/STIGbyID/cat2/files' %}
{%- set audit_cfg_file = '/etc/audit/rules.d/audit.rules' %}
{%- set watchFile = '/var/run/faillock' %}

script_{{ stig_id }}-describe:
  cmd.script:
    - source: salt://{{ helperLoc }}/{{ stig_id }}.sh
    - cwd: /root

file_{{ stig_id }}-{{ audit_cfg_file }}:
  file.replace:
    - name: '{{ audit_cfg_file }}'
    - pattern: '^.*{{ watchFile }}.*$'
    - repl: '-w {{ watchFile }} -p wa -k logins'
    - append_if_not_found: True
