```eval_rst
.. image:: images/cropped-plus3it-logo-cmyk.png
   :width: 140px
   :alt: Powered by Plus3 IT Systems
   :align: right
   :target: https://www.plus3it.com
```
<br>

# Frequently Asked Questions

## How do I know if watchmaker has installed?

To determine whether watchmaker is installed, the simplest method is to run the
command `watchmaker --help`. If it displays the cli help page, watchmaker is
installed. Another option is to check `pip list | grep watchmaker`.

## What do I do if watchmaker failed to install?

First, review the [installation](installation) document. Then double-check
the output of a failed installation. Usually, the output points pretty clearly
at the source of the problem. Watchmaker can be re-installed over itself with
no problem, so once the root cause is resolved, simply re-install watchmaker.

## Why does the watchmaker install fail if my system is FIPS enabled?

This is primarily a question for Red Hat (and derived distributions). As of this
writing, the `pip` utility in all Red Hat releases up through 7.4.1708, default
to looking for pypi packages signed with MD5 signatures. If you've enabled FIPS
(or are using a build that has FIPS pre-enabled), MD5 is disabled in the kernel
(due to being a weak hashing-method). You can either disable FIPS (not
recommended) or explicitly force `pip` to use a different signature-index. The
latter is detailed in the Linux section of the [usage](usage) document.

## How do I know if watchmaker has completed without errors?

By default, watchmaker will reboot the system after a sucessful execution.
Therefore, if the system reboots, watchmaker executed successfully. If you are
investigating sometime after watchmaker completed, check the logs for errors.
If anything fails, watchmaker will suppress the reboot. (Though note that the
`--no-reboot` flag can be used to suppress the reboot even after a successful
execution.)

You can also test the watchmaker exit code programmatically. If watchmaker
fails, it will return a non-zero exit code. If watchmaker completes
successfully, it will return an exit code of zero. You would typically pass the
`--no-reboot` flag if you intend to test the exit code and determine what to do
from there.

## What do I do if watchmaker failed to complete or completes with errors?

Start by checking the logs generated by watchmaker. The logs are stored in the
directory specified by the `--log-dir` argument. Search the log for entries
that have `[ERROR]`, this will give you a starting point to begin
troubleshooting. Also, if a salt state failed, look for the pattern
`Result: False`. If it is not an obvious or simple issue, feel free to create
an issue on the watchmaker github page. If there is a salt_call.debug.log in
the watchmaker log directory, you can look for `[ERROR]` messages in there as
well. However, this log file can be very noisy and a message with the error
label may not be related to the error you are encountering.

## Does watchmaker support Enterprise Linux 7?

Watchmaker is supported on RedHat 7 and CentOS 7. See the [index](index)
page for a list of all supported operating systems.

## How can I exclude salt states when executing watchmaker?

The Salt worker in Watchmaker supports an `exclude_states` argument. When
present, the value is passed directly to the `exclude` option of the
[salt highstate execution module](https://docs.saltstack.com/en/latest/ref/modules/all/salt.modules.state.html#salt.modules.state.highstate).
To use this option with watchmaker from the command line, pass the argument
`--exclude-states <sls_glob>`. For example:

```shell
# Exclude the state "foo" with an exact match
watchmaker --exclude-states foo

# Exclude all state names that begin with "foo"
watchmaker --exclude-states foo*

# Exclude multiple states "foo" and "bar" with an exact match
watchmaker --exclude-states foo,bar
```

## Can I use the underlying salt functionality directly?

Yes, by passing watchmaker's salt configuration directory to the salt command,
using the `-c|--config-dir` argument:

*   Linux: `/opt/watchmaker/salt`
*   Windows: `C:\Watchmaker\salt\conf`

For example:

```shell
# -c|--config-dir
salt-call -c /opt/watchmaker/salt state.show_top
```

## Can I use watchmaker to toggle my RedHat/Centos host's FIPS mode?

Yes, indirectly. Because watchmaker implements most of its functionality via
[SaltStack](https://www.saltstack.com) modules, you can directly-use the underlying
SaltStack functionality to effect the desired change. This is done from the
commandline - as root - by executing:

*   Disable FIPS-mode: `salt-call -c /opt/watchmaker/salt ash.fips_disable`
*   Enable FIPS-mode: `salt-call -c /opt/watchmaker/salt ash.fips_enable`

And then rebooting the system.

## How do I install watchmaker when I am using Python 2.6?

The trouble here is that a lot of the Python ecosystem has begun deprecating
support for Python 2.6. Watchmaker still supports Python 2.6, and does control
its dependency versions based on the Python version. However, there are three
python "setup" packages needed just to install ``watchmaker``, and these
packages cannot be platform-restricted within the ``watchmaker`` package
specification.

Below is the list of packages in question, and the versions that no longer
support Python 2.6:

*   ``pip>=10``
*   ``wheel>=0.30.0``
*   ``setuptools>=37``

In order to install pip in Python 2.6, you can get it from:

*   <https://bootstrap.pypa.io/2.6/get-pip.py>

Once a Python 2.6-compatible ``pip`` version is installed, you can install
compatible versions of the other packages like this:

```shell
pip install --upgrade "pip<10" "wheel<0.30.0" "setuptools<37"
```

You can then [install watchmaker](installation) normally.

## How do I get Watchmaker release/project notifications?

Users may use an RSS reader of their choice to subscribe to the Watchmaker Release feed to get notifications on Watchmaker releases. The Watchmaker RSS release feed is https://github.com/plus3it/watchmaker/releases.atom.

Users can also "watch" the GitHub project to receive notifications on all project activity, https://github.com/plus3it/watchmaker/subscription.
