# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._inputs import *

__all__ = ['GlossaryEntryArgs', 'GlossaryEntry']

@pulumi.input_type
class GlossaryEntryArgs:
    def __init__(__self__, *,
                 glossary_id: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 terms_pair: Optional[pulumi.Input['GlossaryTermsPairArgs']] = None,
                 terms_set: Optional[pulumi.Input['GlossaryTermsSetArgs']] = None):
        """
        The set of arguments for constructing a GlossaryEntry resource.
        :param pulumi.Input[str] description: Describes the glossary entry.
        :param pulumi.Input[str] name: The resource name of the entry. Format: "projects/*/locations/*/glossaries/*/glossaryEntries/*"
        :param pulumi.Input['GlossaryTermsPairArgs'] terms_pair: Used for an unidirectional glossary.
        :param pulumi.Input['GlossaryTermsSetArgs'] terms_set: Used for an equivalent term sets glossary.
        """
        pulumi.set(__self__, "glossary_id", glossary_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if terms_pair is not None:
            pulumi.set(__self__, "terms_pair", terms_pair)
        if terms_set is not None:
            pulumi.set(__self__, "terms_set", terms_set)

    @property
    @pulumi.getter(name="glossaryId")
    def glossary_id(self) -> pulumi.Input[str]:
        return pulumi.get(self, "glossary_id")

    @glossary_id.setter
    def glossary_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "glossary_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Describes the glossary entry.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The resource name of the entry. Format: "projects/*/locations/*/glossaries/*/glossaryEntries/*"
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="termsPair")
    def terms_pair(self) -> Optional[pulumi.Input['GlossaryTermsPairArgs']]:
        """
        Used for an unidirectional glossary.
        """
        return pulumi.get(self, "terms_pair")

    @terms_pair.setter
    def terms_pair(self, value: Optional[pulumi.Input['GlossaryTermsPairArgs']]):
        pulumi.set(self, "terms_pair", value)

    @property
    @pulumi.getter(name="termsSet")
    def terms_set(self) -> Optional[pulumi.Input['GlossaryTermsSetArgs']]:
        """
        Used for an equivalent term sets glossary.
        """
        return pulumi.get(self, "terms_set")

    @terms_set.setter
    def terms_set(self, value: Optional[pulumi.Input['GlossaryTermsSetArgs']]):
        pulumi.set(self, "terms_set", value)


class GlossaryEntry(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 glossary_id: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 terms_pair: Optional[pulumi.Input[pulumi.InputType['GlossaryTermsPairArgs']]] = None,
                 terms_set: Optional[pulumi.Input[pulumi.InputType['GlossaryTermsSetArgs']]] = None,
                 __props__=None):
        """
        Creates a glossary entry.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: Describes the glossary entry.
        :param pulumi.Input[str] name: The resource name of the entry. Format: "projects/*/locations/*/glossaries/*/glossaryEntries/*"
        :param pulumi.Input[pulumi.InputType['GlossaryTermsPairArgs']] terms_pair: Used for an unidirectional glossary.
        :param pulumi.Input[pulumi.InputType['GlossaryTermsSetArgs']] terms_set: Used for an equivalent term sets glossary.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: GlossaryEntryArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates a glossary entry.

        :param str resource_name: The name of the resource.
        :param GlossaryEntryArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(GlossaryEntryArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 glossary_id: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 terms_pair: Optional[pulumi.Input[pulumi.InputType['GlossaryTermsPairArgs']]] = None,
                 terms_set: Optional[pulumi.Input[pulumi.InputType['GlossaryTermsSetArgs']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = GlossaryEntryArgs.__new__(GlossaryEntryArgs)

            __props__.__dict__["description"] = description
            if glossary_id is None and not opts.urn:
                raise TypeError("Missing required property 'glossary_id'")
            __props__.__dict__["glossary_id"] = glossary_id
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            __props__.__dict__["project"] = project
            __props__.__dict__["terms_pair"] = terms_pair
            __props__.__dict__["terms_set"] = terms_set
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["glossary_id", "location", "project"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(GlossaryEntry, __self__).__init__(
            'google-native:translate/v3:GlossaryEntry',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'GlossaryEntry':
        """
        Get an existing GlossaryEntry resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = GlossaryEntryArgs.__new__(GlossaryEntryArgs)

        __props__.__dict__["description"] = None
        __props__.__dict__["glossary_id"] = None
        __props__.__dict__["location"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["project"] = None
        __props__.__dict__["terms_pair"] = None
        __props__.__dict__["terms_set"] = None
        return GlossaryEntry(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        Describes the glossary entry.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="glossaryId")
    def glossary_id(self) -> pulumi.Output[str]:
        return pulumi.get(self, "glossary_id")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[str]:
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The resource name of the entry. Format: "projects/*/locations/*/glossaries/*/glossaryEntries/*"
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="termsPair")
    def terms_pair(self) -> pulumi.Output['outputs.GlossaryTermsPairResponse']:
        """
        Used for an unidirectional glossary.
        """
        return pulumi.get(self, "terms_pair")

    @property
    @pulumi.getter(name="termsSet")
    def terms_set(self) -> pulumi.Output['outputs.GlossaryTermsSetResponse']:
        """
        Used for an equivalent term sets glossary.
        """
        return pulumi.get(self, "terms_set")

