# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'ApiResponse',
    'AuditConfigResponse',
    'AuditLogConfigResponse',
    'AuthProviderResponse',
    'AuthRequirementResponse',
    'AuthenticationResponse',
    'AuthenticationRuleResponse',
    'BackendResponse',
    'BackendRuleResponse',
    'BillingDestinationResponse',
    'BillingResponse',
    'BindingResponse',
    'ContextResponse',
    'ContextRuleResponse',
    'ControlResponse',
    'CustomErrorResponse',
    'CustomErrorRuleResponse',
    'CustomHttpPatternResponse',
    'DeleteServiceStrategyResponse',
    'DocumentationResponse',
    'DocumentationRuleResponse',
    'EndpointResponse',
    'EnumResponse',
    'EnumValueResponse',
    'ExprResponse',
    'FieldResponse',
    'HttpResponse',
    'HttpRuleResponse',
    'JwtLocationResponse',
    'LabelDescriptorResponse',
    'LogDescriptorResponse',
    'LoggingDestinationResponse',
    'LoggingResponse',
    'MethodResponse',
    'MetricDescriptorMetadataResponse',
    'MetricDescriptorResponse',
    'MetricRuleResponse',
    'MixinResponse',
    'MonitoredResourceDescriptorResponse',
    'MonitoringDestinationResponse',
    'MonitoringResponse',
    'OAuthRequirementsResponse',
    'OptionResponse',
    'PageResponse',
    'QuotaLimitResponse',
    'QuotaResponse',
    'SourceContextResponse',
    'SourceInfoResponse',
    'SystemParameterResponse',
    'SystemParameterRuleResponse',
    'SystemParametersResponse',
    'TrafficPercentStrategyResponse',
    'TypeResponse',
    'UsageResponse',
    'UsageRuleResponse',
]

@pulumi.output_type
class ApiResponse(dict):
    """
    Api is a light-weight descriptor for an API Interface. Interfaces are also described as "protocol buffer services" in some contexts, such as by the "service" keyword in a .proto file, but they are different from API Services, which represent a concrete implementation of an interface as opposed to simply a description of methods and bindings. They are also sometimes simply referred to as "APIs" in other contexts, such as the name of this message itself. See https://cloud.google.com/apis/design/glossary for detailed terminology.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sourceContext":
            suggest = "source_context"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApiResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApiResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApiResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 methods: Sequence['outputs.MethodResponse'],
                 mixins: Sequence['outputs.MixinResponse'],
                 name: str,
                 options: Sequence['outputs.OptionResponse'],
                 source_context: 'outputs.SourceContextResponse',
                 syntax: str,
                 version: str):
        """
        Api is a light-weight descriptor for an API Interface. Interfaces are also described as "protocol buffer services" in some contexts, such as by the "service" keyword in a .proto file, but they are different from API Services, which represent a concrete implementation of an interface as opposed to simply a description of methods and bindings. They are also sometimes simply referred to as "APIs" in other contexts, such as the name of this message itself. See https://cloud.google.com/apis/design/glossary for detailed terminology.
        :param Sequence['MethodResponse'] methods: The methods of this interface, in unspecified order.
        :param Sequence['MixinResponse'] mixins: Included interfaces. See Mixin.
        :param str name: The fully qualified name of this interface, including package name followed by the interface's simple name.
        :param Sequence['OptionResponse'] options: Any metadata attached to the interface.
        :param 'SourceContextResponse' source_context: Source context for the protocol buffer service represented by this message.
        :param str syntax: The source syntax of the service.
        :param str version: A version string for this interface. If specified, must have the form `major-version.minor-version`, as in `1.10`. If the minor version is omitted, it defaults to zero. If the entire version field is empty, the major version is derived from the package name, as outlined below. If the field is not empty, the version in the package name will be verified to be consistent with what is provided here. The versioning schema uses [semantic versioning](http://semver.org) where the major version number indicates a breaking change and the minor version an additive, non-breaking change. Both version numbers are signals to users what to expect from different versions, and should be carefully chosen based on the product plan. The major version is also reflected in the package name of the interface, which must end in `v`, as in `google.feature.v1`. For major versions 0 and 1, the suffix can be omitted. Zero major versions must only be used for experimental, non-GA interfaces. 
        """
        pulumi.set(__self__, "methods", methods)
        pulumi.set(__self__, "mixins", mixins)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "options", options)
        pulumi.set(__self__, "source_context", source_context)
        pulumi.set(__self__, "syntax", syntax)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def methods(self) -> Sequence['outputs.MethodResponse']:
        """
        The methods of this interface, in unspecified order.
        """
        return pulumi.get(self, "methods")

    @property
    @pulumi.getter
    def mixins(self) -> Sequence['outputs.MixinResponse']:
        """
        Included interfaces. See Mixin.
        """
        return pulumi.get(self, "mixins")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The fully qualified name of this interface, including package name followed by the interface's simple name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def options(self) -> Sequence['outputs.OptionResponse']:
        """
        Any metadata attached to the interface.
        """
        return pulumi.get(self, "options")

    @property
    @pulumi.getter(name="sourceContext")
    def source_context(self) -> 'outputs.SourceContextResponse':
        """
        Source context for the protocol buffer service represented by this message.
        """
        return pulumi.get(self, "source_context")

    @property
    @pulumi.getter
    def syntax(self) -> str:
        """
        The source syntax of the service.
        """
        return pulumi.get(self, "syntax")

    @property
    @pulumi.getter
    def version(self) -> str:
        """
        A version string for this interface. If specified, must have the form `major-version.minor-version`, as in `1.10`. If the minor version is omitted, it defaults to zero. If the entire version field is empty, the major version is derived from the package name, as outlined below. If the field is not empty, the version in the package name will be verified to be consistent with what is provided here. The versioning schema uses [semantic versioning](http://semver.org) where the major version number indicates a breaking change and the minor version an additive, non-breaking change. Both version numbers are signals to users what to expect from different versions, and should be carefully chosen based on the product plan. The major version is also reflected in the package name of the interface, which must end in `v`, as in `google.feature.v1`. For major versions 0 and 1, the suffix can be omitted. Zero major versions must only be used for experimental, non-GA interfaces. 
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class AuditConfigResponse(dict):
    """
    Specifies the audit configuration for a service. The configuration determines which permission types are logged, and what identities, if any, are exempted from logging. An AuditConfig must have one or more AuditLogConfigs. If there are AuditConfigs for both `allServices` and a specific service, the union of the two AuditConfigs is used for that service: the log_types specified in each AuditConfig are enabled, and the exempted_members in each AuditLogConfig are exempted. Example Policy with multiple AuditConfigs: { "audit_configs": [ { "service": "allServices", "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [ "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" }, { "log_type": "ADMIN_READ" } ] }, { "service": "sampleservice.googleapis.com", "audit_log_configs": [ { "log_type": "DATA_READ" }, { "log_type": "DATA_WRITE", "exempted_members": [ "user:aliya@example.com" ] } ] } ] } For sampleservice, this policy enables DATA_READ, DATA_WRITE and ADMIN_READ logging. It also exempts `jose@example.com` from DATA_READ logging, and `aliya@example.com` from DATA_WRITE logging.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "auditLogConfigs":
            suggest = "audit_log_configs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AuditConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AuditConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AuditConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 audit_log_configs: Sequence['outputs.AuditLogConfigResponse'],
                 service: str):
        """
        Specifies the audit configuration for a service. The configuration determines which permission types are logged, and what identities, if any, are exempted from logging. An AuditConfig must have one or more AuditLogConfigs. If there are AuditConfigs for both `allServices` and a specific service, the union of the two AuditConfigs is used for that service: the log_types specified in each AuditConfig are enabled, and the exempted_members in each AuditLogConfig are exempted. Example Policy with multiple AuditConfigs: { "audit_configs": [ { "service": "allServices", "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [ "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" }, { "log_type": "ADMIN_READ" } ] }, { "service": "sampleservice.googleapis.com", "audit_log_configs": [ { "log_type": "DATA_READ" }, { "log_type": "DATA_WRITE", "exempted_members": [ "user:aliya@example.com" ] } ] } ] } For sampleservice, this policy enables DATA_READ, DATA_WRITE and ADMIN_READ logging. It also exempts `jose@example.com` from DATA_READ logging, and `aliya@example.com` from DATA_WRITE logging.
        :param Sequence['AuditLogConfigResponse'] audit_log_configs: The configuration for logging of each type of permission.
        :param str service: Specifies a service that will be enabled for audit logging. For example, `storage.googleapis.com`, `cloudsql.googleapis.com`. `allServices` is a special value that covers all services.
        """
        pulumi.set(__self__, "audit_log_configs", audit_log_configs)
        pulumi.set(__self__, "service", service)

    @property
    @pulumi.getter(name="auditLogConfigs")
    def audit_log_configs(self) -> Sequence['outputs.AuditLogConfigResponse']:
        """
        The configuration for logging of each type of permission.
        """
        return pulumi.get(self, "audit_log_configs")

    @property
    @pulumi.getter
    def service(self) -> str:
        """
        Specifies a service that will be enabled for audit logging. For example, `storage.googleapis.com`, `cloudsql.googleapis.com`. `allServices` is a special value that covers all services.
        """
        return pulumi.get(self, "service")


@pulumi.output_type
class AuditLogConfigResponse(dict):
    """
    Provides the configuration for logging a type of permissions. Example: { "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [ "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" } ] } This enables 'DATA_READ' and 'DATA_WRITE' logging, while exempting jose@example.com from DATA_READ logging.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "exemptedMembers":
            suggest = "exempted_members"
        elif key == "logType":
            suggest = "log_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AuditLogConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AuditLogConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AuditLogConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 exempted_members: Sequence[str],
                 log_type: str):
        """
        Provides the configuration for logging a type of permissions. Example: { "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [ "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" } ] } This enables 'DATA_READ' and 'DATA_WRITE' logging, while exempting jose@example.com from DATA_READ logging.
        :param Sequence[str] exempted_members: Specifies the identities that do not cause logging for this type of permission. Follows the same format of Binding.members.
        :param str log_type: The log type that this config enables.
        """
        pulumi.set(__self__, "exempted_members", exempted_members)
        pulumi.set(__self__, "log_type", log_type)

    @property
    @pulumi.getter(name="exemptedMembers")
    def exempted_members(self) -> Sequence[str]:
        """
        Specifies the identities that do not cause logging for this type of permission. Follows the same format of Binding.members.
        """
        return pulumi.get(self, "exempted_members")

    @property
    @pulumi.getter(name="logType")
    def log_type(self) -> str:
        """
        The log type that this config enables.
        """
        return pulumi.get(self, "log_type")


@pulumi.output_type
class AuthProviderResponse(dict):
    """
    Configuration for an authentication provider, including support for [JSON Web Token (JWT)](https://tools.ietf.org/html/draft-ietf-oauth-json-web-token-32).
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authorizationUrl":
            suggest = "authorization_url"
        elif key == "jwksUri":
            suggest = "jwks_uri"
        elif key == "jwtLocations":
            suggest = "jwt_locations"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AuthProviderResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AuthProviderResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AuthProviderResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 audiences: str,
                 authorization_url: str,
                 issuer: str,
                 jwks_uri: str,
                 jwt_locations: Sequence['outputs.JwtLocationResponse']):
        """
        Configuration for an authentication provider, including support for [JSON Web Token (JWT)](https://tools.ietf.org/html/draft-ietf-oauth-json-web-token-32).
        :param str audiences: The list of JWT [audiences](https://tools.ietf.org/html/draft-ietf-oauth-json-web-token-32#section-4.1.3). that are allowed to access. A JWT containing any of these audiences will be accepted. When this setting is absent, JWTs with audiences: - "https://[service.name]/[google.protobuf.Api.name]" - "https://[service.name]/" will be accepted. For example, if no audiences are in the setting, LibraryService API will accept JWTs with the following audiences: - https://library-example.googleapis.com/google.example.library.v1.LibraryService - https://library-example.googleapis.com/ Example: audiences: bookstore_android.apps.googleusercontent.com, bookstore_web.apps.googleusercontent.com
        :param str authorization_url: Redirect URL if JWT token is required but not present or is expired. Implement authorizationUrl of securityDefinitions in OpenAPI spec.
        :param str issuer: Identifies the principal that issued the JWT. See https://tools.ietf.org/html/draft-ietf-oauth-json-web-token-32#section-4.1.1 Usually a URL or an email address. Example: https://securetoken.google.com Example: 1234567-compute@developer.gserviceaccount.com
        :param str jwks_uri: URL of the provider's public key set to validate signature of the JWT. See [OpenID Discovery](https://openid.net/specs/openid-connect-discovery-1_0.html#ProviderMetadata). Optional if the key set document: - can be retrieved from [OpenID Discovery](https://openid.net/specs/openid-connect-discovery-1_0.html) of the issuer. - can be inferred from the email domain of the issuer (e.g. a Google service account). Example: https://www.googleapis.com/oauth2/v1/certs
        :param Sequence['JwtLocationResponse'] jwt_locations: Defines the locations to extract the JWT. For now it is only used by the Cloud Endpoints to store the OpenAPI extension [x-google-jwt-locations] (https://cloud.google.com/endpoints/docs/openapi/openapi-extensions#x-google-jwt-locations) JWT locations can be one of HTTP headers, URL query parameters or cookies. The rule is that the first match wins. If not specified, default to use following 3 locations: 1) Authorization: Bearer 2) x-goog-iap-jwt-assertion 3) access_token query parameter Default locations can be specified as followings: jwt_locations: - header: Authorization value_prefix: "Bearer " - header: x-goog-iap-jwt-assertion - query: access_token
        """
        pulumi.set(__self__, "audiences", audiences)
        pulumi.set(__self__, "authorization_url", authorization_url)
        pulumi.set(__self__, "issuer", issuer)
        pulumi.set(__self__, "jwks_uri", jwks_uri)
        pulumi.set(__self__, "jwt_locations", jwt_locations)

    @property
    @pulumi.getter
    def audiences(self) -> str:
        """
        The list of JWT [audiences](https://tools.ietf.org/html/draft-ietf-oauth-json-web-token-32#section-4.1.3). that are allowed to access. A JWT containing any of these audiences will be accepted. When this setting is absent, JWTs with audiences: - "https://[service.name]/[google.protobuf.Api.name]" - "https://[service.name]/" will be accepted. For example, if no audiences are in the setting, LibraryService API will accept JWTs with the following audiences: - https://library-example.googleapis.com/google.example.library.v1.LibraryService - https://library-example.googleapis.com/ Example: audiences: bookstore_android.apps.googleusercontent.com, bookstore_web.apps.googleusercontent.com
        """
        return pulumi.get(self, "audiences")

    @property
    @pulumi.getter(name="authorizationUrl")
    def authorization_url(self) -> str:
        """
        Redirect URL if JWT token is required but not present or is expired. Implement authorizationUrl of securityDefinitions in OpenAPI spec.
        """
        return pulumi.get(self, "authorization_url")

    @property
    @pulumi.getter
    def issuer(self) -> str:
        """
        Identifies the principal that issued the JWT. See https://tools.ietf.org/html/draft-ietf-oauth-json-web-token-32#section-4.1.1 Usually a URL or an email address. Example: https://securetoken.google.com Example: 1234567-compute@developer.gserviceaccount.com
        """
        return pulumi.get(self, "issuer")

    @property
    @pulumi.getter(name="jwksUri")
    def jwks_uri(self) -> str:
        """
        URL of the provider's public key set to validate signature of the JWT. See [OpenID Discovery](https://openid.net/specs/openid-connect-discovery-1_0.html#ProviderMetadata). Optional if the key set document: - can be retrieved from [OpenID Discovery](https://openid.net/specs/openid-connect-discovery-1_0.html) of the issuer. - can be inferred from the email domain of the issuer (e.g. a Google service account). Example: https://www.googleapis.com/oauth2/v1/certs
        """
        return pulumi.get(self, "jwks_uri")

    @property
    @pulumi.getter(name="jwtLocations")
    def jwt_locations(self) -> Sequence['outputs.JwtLocationResponse']:
        """
        Defines the locations to extract the JWT. For now it is only used by the Cloud Endpoints to store the OpenAPI extension [x-google-jwt-locations] (https://cloud.google.com/endpoints/docs/openapi/openapi-extensions#x-google-jwt-locations) JWT locations can be one of HTTP headers, URL query parameters or cookies. The rule is that the first match wins. If not specified, default to use following 3 locations: 1) Authorization: Bearer 2) x-goog-iap-jwt-assertion 3) access_token query parameter Default locations can be specified as followings: jwt_locations: - header: Authorization value_prefix: "Bearer " - header: x-goog-iap-jwt-assertion - query: access_token
        """
        return pulumi.get(self, "jwt_locations")


@pulumi.output_type
class AuthRequirementResponse(dict):
    """
    User-defined authentication requirements, including support for [JSON Web Token (JWT)](https://tools.ietf.org/html/draft-ietf-oauth-json-web-token-32).
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "providerId":
            suggest = "provider_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AuthRequirementResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AuthRequirementResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AuthRequirementResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 audiences: str,
                 provider_id: str):
        """
        User-defined authentication requirements, including support for [JSON Web Token (JWT)](https://tools.ietf.org/html/draft-ietf-oauth-json-web-token-32).
        :param str audiences: NOTE: This will be deprecated soon, once AuthProvider.audiences is implemented and accepted in all the runtime components. The list of JWT [audiences](https://tools.ietf.org/html/draft-ietf-oauth-json-web-token-32#section-4.1.3). that are allowed to access. A JWT containing any of these audiences will be accepted. When this setting is absent, only JWTs with audience "https://Service_name/API_name" will be accepted. For example, if no audiences are in the setting, LibraryService API will only accept JWTs with the following audience "https://library-example.googleapis.com/google.example.library.v1.LibraryService". Example: audiences: bookstore_android.apps.googleusercontent.com, bookstore_web.apps.googleusercontent.com
        :param str provider_id: id from authentication provider. Example: provider_id: bookstore_auth
        """
        pulumi.set(__self__, "audiences", audiences)
        pulumi.set(__self__, "provider_id", provider_id)

    @property
    @pulumi.getter
    def audiences(self) -> str:
        """
        NOTE: This will be deprecated soon, once AuthProvider.audiences is implemented and accepted in all the runtime components. The list of JWT [audiences](https://tools.ietf.org/html/draft-ietf-oauth-json-web-token-32#section-4.1.3). that are allowed to access. A JWT containing any of these audiences will be accepted. When this setting is absent, only JWTs with audience "https://Service_name/API_name" will be accepted. For example, if no audiences are in the setting, LibraryService API will only accept JWTs with the following audience "https://library-example.googleapis.com/google.example.library.v1.LibraryService". Example: audiences: bookstore_android.apps.googleusercontent.com, bookstore_web.apps.googleusercontent.com
        """
        return pulumi.get(self, "audiences")

    @property
    @pulumi.getter(name="providerId")
    def provider_id(self) -> str:
        """
        id from authentication provider. Example: provider_id: bookstore_auth
        """
        return pulumi.get(self, "provider_id")


@pulumi.output_type
class AuthenticationResponse(dict):
    """
    `Authentication` defines the authentication configuration for API methods provided by an API service. Example: name: calendar.googleapis.com authentication: providers: - id: google_calendar_auth jwks_uri: https://www.googleapis.com/oauth2/v1/certs issuer: https://securetoken.google.com rules: - selector: "*" requirements: provider_id: google_calendar_auth - selector: google.calendar.Delegate oauth: canonical_scopes: https://www.googleapis.com/auth/calendar.read
    """
    def __init__(__self__, *,
                 providers: Sequence['outputs.AuthProviderResponse'],
                 rules: Sequence['outputs.AuthenticationRuleResponse']):
        """
        `Authentication` defines the authentication configuration for API methods provided by an API service. Example: name: calendar.googleapis.com authentication: providers: - id: google_calendar_auth jwks_uri: https://www.googleapis.com/oauth2/v1/certs issuer: https://securetoken.google.com rules: - selector: "*" requirements: provider_id: google_calendar_auth - selector: google.calendar.Delegate oauth: canonical_scopes: https://www.googleapis.com/auth/calendar.read
        :param Sequence['AuthProviderResponse'] providers: Defines a set of authentication providers that a service supports.
        :param Sequence['AuthenticationRuleResponse'] rules: A list of authentication rules that apply to individual API methods. **NOTE:** All service configuration rules follow "last one wins" order.
        """
        pulumi.set(__self__, "providers", providers)
        pulumi.set(__self__, "rules", rules)

    @property
    @pulumi.getter
    def providers(self) -> Sequence['outputs.AuthProviderResponse']:
        """
        Defines a set of authentication providers that a service supports.
        """
        return pulumi.get(self, "providers")

    @property
    @pulumi.getter
    def rules(self) -> Sequence['outputs.AuthenticationRuleResponse']:
        """
        A list of authentication rules that apply to individual API methods. **NOTE:** All service configuration rules follow "last one wins" order.
        """
        return pulumi.get(self, "rules")


@pulumi.output_type
class AuthenticationRuleResponse(dict):
    """
    Authentication rules for the service. By default, if a method has any authentication requirements, every request must include a valid credential matching one of the requirements. It's an error to include more than one kind of credential in a single request. If a method doesn't have any auth requirements, request credentials will be ignored.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowWithoutCredential":
            suggest = "allow_without_credential"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AuthenticationRuleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AuthenticationRuleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AuthenticationRuleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allow_without_credential: bool,
                 oauth: 'outputs.OAuthRequirementsResponse',
                 requirements: Sequence['outputs.AuthRequirementResponse'],
                 selector: str):
        """
        Authentication rules for the service. By default, if a method has any authentication requirements, every request must include a valid credential matching one of the requirements. It's an error to include more than one kind of credential in a single request. If a method doesn't have any auth requirements, request credentials will be ignored.
        :param bool allow_without_credential: If true, the service accepts API keys without any other credential. This flag only applies to HTTP and gRPC requests.
        :param 'OAuthRequirementsResponse' oauth: The requirements for OAuth credentials.
        :param Sequence['AuthRequirementResponse'] requirements: Requirements for additional authentication providers.
        :param str selector: Selects the methods to which this rule applies. Refer to selector for syntax details.
        """
        pulumi.set(__self__, "allow_without_credential", allow_without_credential)
        pulumi.set(__self__, "oauth", oauth)
        pulumi.set(__self__, "requirements", requirements)
        pulumi.set(__self__, "selector", selector)

    @property
    @pulumi.getter(name="allowWithoutCredential")
    def allow_without_credential(self) -> bool:
        """
        If true, the service accepts API keys without any other credential. This flag only applies to HTTP and gRPC requests.
        """
        return pulumi.get(self, "allow_without_credential")

    @property
    @pulumi.getter
    def oauth(self) -> 'outputs.OAuthRequirementsResponse':
        """
        The requirements for OAuth credentials.
        """
        return pulumi.get(self, "oauth")

    @property
    @pulumi.getter
    def requirements(self) -> Sequence['outputs.AuthRequirementResponse']:
        """
        Requirements for additional authentication providers.
        """
        return pulumi.get(self, "requirements")

    @property
    @pulumi.getter
    def selector(self) -> str:
        """
        Selects the methods to which this rule applies. Refer to selector for syntax details.
        """
        return pulumi.get(self, "selector")


@pulumi.output_type
class BackendResponse(dict):
    """
    `Backend` defines the backend configuration for a service.
    """
    def __init__(__self__, *,
                 rules: Sequence['outputs.BackendRuleResponse']):
        """
        `Backend` defines the backend configuration for a service.
        :param Sequence['BackendRuleResponse'] rules: A list of API backend rules that apply to individual API methods. **NOTE:** All service configuration rules follow "last one wins" order.
        """
        pulumi.set(__self__, "rules", rules)

    @property
    @pulumi.getter
    def rules(self) -> Sequence['outputs.BackendRuleResponse']:
        """
        A list of API backend rules that apply to individual API methods. **NOTE:** All service configuration rules follow "last one wins" order.
        """
        return pulumi.get(self, "rules")


@pulumi.output_type
class BackendRuleResponse(dict):
    """
    A backend rule provides configuration for an individual API element.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "disableAuth":
            suggest = "disable_auth"
        elif key == "jwtAudience":
            suggest = "jwt_audience"
        elif key == "operationDeadline":
            suggest = "operation_deadline"
        elif key == "pathTranslation":
            suggest = "path_translation"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BackendRuleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BackendRuleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BackendRuleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 address: str,
                 deadline: float,
                 disable_auth: bool,
                 jwt_audience: str,
                 operation_deadline: float,
                 path_translation: str,
                 protocol: str,
                 selector: str):
        """
        A backend rule provides configuration for an individual API element.
        :param str address: The address of the API backend. The scheme is used to determine the backend protocol and security. The following schemes are accepted: SCHEME PROTOCOL SECURITY http:// HTTP None https:// HTTP TLS grpc:// gRPC None grpcs:// gRPC TLS It is recommended to explicitly include a scheme. Leaving out the scheme may cause constrasting behaviors across platforms. If the port is unspecified, the default is: - 80 for schemes without TLS - 443 for schemes with TLS For HTTP backends, use protocol to specify the protocol version.
        :param float deadline: The number of seconds to wait for a response from a request. The default varies based on the request protocol and deployment environment.
        :param bool disable_auth: When disable_auth is true, a JWT ID token won't be generated and the original "Authorization" HTTP header will be preserved. If the header is used to carry the original token and is expected by the backend, this field must be set to true to preserve the header.
        :param str jwt_audience: The JWT audience is used when generating a JWT ID token for the backend. This ID token will be added in the HTTP "authorization" header, and sent to the backend.
        :param float operation_deadline: The number of seconds to wait for the completion of a long running operation. The default is no deadline.
        :param str protocol: The protocol used for sending a request to the backend. The supported values are "http/1.1" and "h2". The default value is inferred from the scheme in the address field: SCHEME PROTOCOL http:// http/1.1 https:// http/1.1 grpc:// h2 grpcs:// h2 For secure HTTP backends (https://) that support HTTP/2, set this field to "h2" for improved performance. Configuring this field to non-default values is only supported for secure HTTP backends. This field will be ignored for all other backends. See https://www.iana.org/assignments/tls-extensiontype-values/tls-extensiontype-values.xhtml#alpn-protocol-ids for more details on the supported values.
        :param str selector: Selects the methods to which this rule applies. Refer to selector for syntax details.
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "deadline", deadline)
        pulumi.set(__self__, "disable_auth", disable_auth)
        pulumi.set(__self__, "jwt_audience", jwt_audience)
        pulumi.set(__self__, "operation_deadline", operation_deadline)
        pulumi.set(__self__, "path_translation", path_translation)
        pulumi.set(__self__, "protocol", protocol)
        pulumi.set(__self__, "selector", selector)

    @property
    @pulumi.getter
    def address(self) -> str:
        """
        The address of the API backend. The scheme is used to determine the backend protocol and security. The following schemes are accepted: SCHEME PROTOCOL SECURITY http:// HTTP None https:// HTTP TLS grpc:// gRPC None grpcs:// gRPC TLS It is recommended to explicitly include a scheme. Leaving out the scheme may cause constrasting behaviors across platforms. If the port is unspecified, the default is: - 80 for schemes without TLS - 443 for schemes with TLS For HTTP backends, use protocol to specify the protocol version.
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter
    def deadline(self) -> float:
        """
        The number of seconds to wait for a response from a request. The default varies based on the request protocol and deployment environment.
        """
        return pulumi.get(self, "deadline")

    @property
    @pulumi.getter(name="disableAuth")
    def disable_auth(self) -> bool:
        """
        When disable_auth is true, a JWT ID token won't be generated and the original "Authorization" HTTP header will be preserved. If the header is used to carry the original token and is expected by the backend, this field must be set to true to preserve the header.
        """
        return pulumi.get(self, "disable_auth")

    @property
    @pulumi.getter(name="jwtAudience")
    def jwt_audience(self) -> str:
        """
        The JWT audience is used when generating a JWT ID token for the backend. This ID token will be added in the HTTP "authorization" header, and sent to the backend.
        """
        return pulumi.get(self, "jwt_audience")

    @property
    @pulumi.getter(name="operationDeadline")
    def operation_deadline(self) -> float:
        """
        The number of seconds to wait for the completion of a long running operation. The default is no deadline.
        """
        return pulumi.get(self, "operation_deadline")

    @property
    @pulumi.getter(name="pathTranslation")
    def path_translation(self) -> str:
        return pulumi.get(self, "path_translation")

    @property
    @pulumi.getter
    def protocol(self) -> str:
        """
        The protocol used for sending a request to the backend. The supported values are "http/1.1" and "h2". The default value is inferred from the scheme in the address field: SCHEME PROTOCOL http:// http/1.1 https:// http/1.1 grpc:// h2 grpcs:// h2 For secure HTTP backends (https://) that support HTTP/2, set this field to "h2" for improved performance. Configuring this field to non-default values is only supported for secure HTTP backends. This field will be ignored for all other backends. See https://www.iana.org/assignments/tls-extensiontype-values/tls-extensiontype-values.xhtml#alpn-protocol-ids for more details on the supported values.
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter
    def selector(self) -> str:
        """
        Selects the methods to which this rule applies. Refer to selector for syntax details.
        """
        return pulumi.get(self, "selector")


@pulumi.output_type
class BillingDestinationResponse(dict):
    """
    Configuration of a specific billing destination (Currently only support bill against consumer project).
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "monitoredResource":
            suggest = "monitored_resource"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BillingDestinationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BillingDestinationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BillingDestinationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 metrics: Sequence[str],
                 monitored_resource: str):
        """
        Configuration of a specific billing destination (Currently only support bill against consumer project).
        :param Sequence[str] metrics: Names of the metrics to report to this billing destination. Each name must be defined in Service.metrics section.
        :param str monitored_resource: The monitored resource type. The type must be defined in Service.monitored_resources section.
        """
        pulumi.set(__self__, "metrics", metrics)
        pulumi.set(__self__, "monitored_resource", monitored_resource)

    @property
    @pulumi.getter
    def metrics(self) -> Sequence[str]:
        """
        Names of the metrics to report to this billing destination. Each name must be defined in Service.metrics section.
        """
        return pulumi.get(self, "metrics")

    @property
    @pulumi.getter(name="monitoredResource")
    def monitored_resource(self) -> str:
        """
        The monitored resource type. The type must be defined in Service.monitored_resources section.
        """
        return pulumi.get(self, "monitored_resource")


@pulumi.output_type
class BillingResponse(dict):
    """
    Billing related configuration of the service. The following example shows how to configure monitored resources and metrics for billing, `consumer_destinations` is the only supported destination and the monitored resources need at least one label key `cloud.googleapis.com/location` to indicate the location of the billing usage, using different monitored resources between monitoring and billing is recommended so they can be evolved independently: monitored_resources: - type: library.googleapis.com/billing_branch labels: - key: cloud.googleapis.com/location description: | Predefined label to support billing location restriction. - key: city description: | Custom label to define the city where the library branch is located in. - key: name description: Custom label to define the name of the library branch. metrics: - name: library.googleapis.com/book/borrowed_count metric_kind: DELTA value_type: INT64 unit: "1" billing: consumer_destinations: - monitored_resource: library.googleapis.com/billing_branch metrics: - library.googleapis.com/book/borrowed_count
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "consumerDestinations":
            suggest = "consumer_destinations"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BillingResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BillingResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BillingResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 consumer_destinations: Sequence['outputs.BillingDestinationResponse']):
        """
        Billing related configuration of the service. The following example shows how to configure monitored resources and metrics for billing, `consumer_destinations` is the only supported destination and the monitored resources need at least one label key `cloud.googleapis.com/location` to indicate the location of the billing usage, using different monitored resources between monitoring and billing is recommended so they can be evolved independently: monitored_resources: - type: library.googleapis.com/billing_branch labels: - key: cloud.googleapis.com/location description: | Predefined label to support billing location restriction. - key: city description: | Custom label to define the city where the library branch is located in. - key: name description: Custom label to define the name of the library branch. metrics: - name: library.googleapis.com/book/borrowed_count metric_kind: DELTA value_type: INT64 unit: "1" billing: consumer_destinations: - monitored_resource: library.googleapis.com/billing_branch metrics: - library.googleapis.com/book/borrowed_count
        :param Sequence['BillingDestinationResponse'] consumer_destinations: Billing configurations for sending metrics to the consumer project. There can be multiple consumer destinations per service, each one must have a different monitored resource type. A metric can be used in at most one consumer destination.
        """
        pulumi.set(__self__, "consumer_destinations", consumer_destinations)

    @property
    @pulumi.getter(name="consumerDestinations")
    def consumer_destinations(self) -> Sequence['outputs.BillingDestinationResponse']:
        """
        Billing configurations for sending metrics to the consumer project. There can be multiple consumer destinations per service, each one must have a different monitored resource type. A metric can be used in at most one consumer destination.
        """
        return pulumi.get(self, "consumer_destinations")


@pulumi.output_type
class BindingResponse(dict):
    """
    Associates `members`, or principals, with a `role`.
    """
    def __init__(__self__, *,
                 condition: 'outputs.ExprResponse',
                 members: Sequence[str],
                 role: str):
        """
        Associates `members`, or principals, with a `role`.
        :param 'ExprResponse' condition: The condition that is associated with this binding. If the condition evaluates to `true`, then this binding applies to the current request. If the condition evaluates to `false`, then this binding does not apply to the current request. However, a different role binding might grant the same role to one or more of the principals in this binding. To learn which resources support conditions in their IAM policies, see the [IAM documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
        :param Sequence[str] members: Specifies the principals requesting access for a Google Cloud resource. `members` can have the following values: * `allUsers`: A special identifier that represents anyone who is on the internet; with or without a Google account. * `allAuthenticatedUsers`: A special identifier that represents anyone who is authenticated with a Google account or a service account. Does not include identities that come from external identity providers (IdPs) through identity federation. * `user:{emailid}`: An email address that represents a specific Google account. For example, `alice@example.com` . * `serviceAccount:{emailid}`: An email address that represents a Google service account. For example, `my-other-app@appspot.gserviceaccount.com`. * `serviceAccount:{projectid}.svc.id.goog[{namespace}/{kubernetes-sa}]`: An identifier for a [Kubernetes service account](https://cloud.google.com/kubernetes-engine/docs/how-to/kubernetes-service-accounts). For example, `my-project.svc.id.goog[my-namespace/my-kubernetes-sa]`. * `group:{emailid}`: An email address that represents a Google group. For example, `admins@example.com`. * `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a user that has been recently deleted. For example, `alice@example.com?uid=123456789012345678901`. If the user is recovered, this value reverts to `user:{emailid}` and the recovered user retains the role in the binding. * `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a service account that has been recently deleted. For example, `my-other-app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the service account is undeleted, this value reverts to `serviceAccount:{emailid}` and the undeleted service account retains the role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a Google group that has been recently deleted. For example, `admins@example.com?uid=123456789012345678901`. If the group is recovered, this value reverts to `group:{emailid}` and the recovered group retains the role in the binding. * `domain:{domain}`: The G Suite domain (primary) that represents all the users of that domain. For example, `google.com` or `example.com`. 
        :param str role: Role that is assigned to the list of `members`, or principals. For example, `roles/viewer`, `roles/editor`, or `roles/owner`.
        """
        pulumi.set(__self__, "condition", condition)
        pulumi.set(__self__, "members", members)
        pulumi.set(__self__, "role", role)

    @property
    @pulumi.getter
    def condition(self) -> 'outputs.ExprResponse':
        """
        The condition that is associated with this binding. If the condition evaluates to `true`, then this binding applies to the current request. If the condition evaluates to `false`, then this binding does not apply to the current request. However, a different role binding might grant the same role to one or more of the principals in this binding. To learn which resources support conditions in their IAM policies, see the [IAM documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
        """
        return pulumi.get(self, "condition")

    @property
    @pulumi.getter
    def members(self) -> Sequence[str]:
        """
        Specifies the principals requesting access for a Google Cloud resource. `members` can have the following values: * `allUsers`: A special identifier that represents anyone who is on the internet; with or without a Google account. * `allAuthenticatedUsers`: A special identifier that represents anyone who is authenticated with a Google account or a service account. Does not include identities that come from external identity providers (IdPs) through identity federation. * `user:{emailid}`: An email address that represents a specific Google account. For example, `alice@example.com` . * `serviceAccount:{emailid}`: An email address that represents a Google service account. For example, `my-other-app@appspot.gserviceaccount.com`. * `serviceAccount:{projectid}.svc.id.goog[{namespace}/{kubernetes-sa}]`: An identifier for a [Kubernetes service account](https://cloud.google.com/kubernetes-engine/docs/how-to/kubernetes-service-accounts). For example, `my-project.svc.id.goog[my-namespace/my-kubernetes-sa]`. * `group:{emailid}`: An email address that represents a Google group. For example, `admins@example.com`. * `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a user that has been recently deleted. For example, `alice@example.com?uid=123456789012345678901`. If the user is recovered, this value reverts to `user:{emailid}` and the recovered user retains the role in the binding. * `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a service account that has been recently deleted. For example, `my-other-app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the service account is undeleted, this value reverts to `serviceAccount:{emailid}` and the undeleted service account retains the role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a Google group that has been recently deleted. For example, `admins@example.com?uid=123456789012345678901`. If the group is recovered, this value reverts to `group:{emailid}` and the recovered group retains the role in the binding. * `domain:{domain}`: The G Suite domain (primary) that represents all the users of that domain. For example, `google.com` or `example.com`. 
        """
        return pulumi.get(self, "members")

    @property
    @pulumi.getter
    def role(self) -> str:
        """
        Role that is assigned to the list of `members`, or principals. For example, `roles/viewer`, `roles/editor`, or `roles/owner`.
        """
        return pulumi.get(self, "role")


@pulumi.output_type
class ContextResponse(dict):
    """
    `Context` defines which contexts an API requests. Example: context: rules: - selector: "*" requested: - google.rpc.context.ProjectContext - google.rpc.context.OriginContext The above specifies that all methods in the API request `google.rpc.context.ProjectContext` and `google.rpc.context.OriginContext`. Available context types are defined in package `google.rpc.context`. This also provides mechanism to allowlist any protobuf message extension that can be sent in grpc metadata using “x-goog-ext--bin” and “x-goog-ext--jspb” format. For example, list any service specific protobuf types that can appear in grpc metadata as follows in your yaml file: Example: context: rules: - selector: "google.example.library.v1.LibraryService.CreateBook" allowed_request_extensions: - google.foo.v1.NewExtension allowed_response_extensions: - google.foo.v1.NewExtension You can also specify extension ID instead of fully qualified extension name here.
    """
    def __init__(__self__, *,
                 rules: Sequence['outputs.ContextRuleResponse']):
        """
        `Context` defines which contexts an API requests. Example: context: rules: - selector: "*" requested: - google.rpc.context.ProjectContext - google.rpc.context.OriginContext The above specifies that all methods in the API request `google.rpc.context.ProjectContext` and `google.rpc.context.OriginContext`. Available context types are defined in package `google.rpc.context`. This also provides mechanism to allowlist any protobuf message extension that can be sent in grpc metadata using “x-goog-ext--bin” and “x-goog-ext--jspb” format. For example, list any service specific protobuf types that can appear in grpc metadata as follows in your yaml file: Example: context: rules: - selector: "google.example.library.v1.LibraryService.CreateBook" allowed_request_extensions: - google.foo.v1.NewExtension allowed_response_extensions: - google.foo.v1.NewExtension You can also specify extension ID instead of fully qualified extension name here.
        :param Sequence['ContextRuleResponse'] rules: A list of RPC context rules that apply to individual API methods. **NOTE:** All service configuration rules follow "last one wins" order.
        """
        pulumi.set(__self__, "rules", rules)

    @property
    @pulumi.getter
    def rules(self) -> Sequence['outputs.ContextRuleResponse']:
        """
        A list of RPC context rules that apply to individual API methods. **NOTE:** All service configuration rules follow "last one wins" order.
        """
        return pulumi.get(self, "rules")


@pulumi.output_type
class ContextRuleResponse(dict):
    """
    A context rule provides information about the context for an individual API element.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowedRequestExtensions":
            suggest = "allowed_request_extensions"
        elif key == "allowedResponseExtensions":
            suggest = "allowed_response_extensions"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContextRuleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContextRuleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContextRuleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allowed_request_extensions: Sequence[str],
                 allowed_response_extensions: Sequence[str],
                 provided: Sequence[str],
                 requested: Sequence[str],
                 selector: str):
        """
        A context rule provides information about the context for an individual API element.
        :param Sequence[str] allowed_request_extensions: A list of full type names or extension IDs of extensions allowed in grpc side channel from client to backend.
        :param Sequence[str] allowed_response_extensions: A list of full type names or extension IDs of extensions allowed in grpc side channel from backend to client.
        :param Sequence[str] provided: A list of full type names of provided contexts.
        :param Sequence[str] requested: A list of full type names of requested contexts.
        :param str selector: Selects the methods to which this rule applies. Refer to selector for syntax details.
        """
        pulumi.set(__self__, "allowed_request_extensions", allowed_request_extensions)
        pulumi.set(__self__, "allowed_response_extensions", allowed_response_extensions)
        pulumi.set(__self__, "provided", provided)
        pulumi.set(__self__, "requested", requested)
        pulumi.set(__self__, "selector", selector)

    @property
    @pulumi.getter(name="allowedRequestExtensions")
    def allowed_request_extensions(self) -> Sequence[str]:
        """
        A list of full type names or extension IDs of extensions allowed in grpc side channel from client to backend.
        """
        return pulumi.get(self, "allowed_request_extensions")

    @property
    @pulumi.getter(name="allowedResponseExtensions")
    def allowed_response_extensions(self) -> Sequence[str]:
        """
        A list of full type names or extension IDs of extensions allowed in grpc side channel from backend to client.
        """
        return pulumi.get(self, "allowed_response_extensions")

    @property
    @pulumi.getter
    def provided(self) -> Sequence[str]:
        """
        A list of full type names of provided contexts.
        """
        return pulumi.get(self, "provided")

    @property
    @pulumi.getter
    def requested(self) -> Sequence[str]:
        """
        A list of full type names of requested contexts.
        """
        return pulumi.get(self, "requested")

    @property
    @pulumi.getter
    def selector(self) -> str:
        """
        Selects the methods to which this rule applies. Refer to selector for syntax details.
        """
        return pulumi.get(self, "selector")


@pulumi.output_type
class ControlResponse(dict):
    """
    Selects and configures the service controller used by the service. The service controller handles two things: - **What is allowed:** for each API request, Chemist checks the project status, activation status, abuse status, billing status, service status, location restrictions, VPC Service Controls, SuperQuota, and other policies. - **What has happened:** for each API response, Chemist reports the telemetry data to analytics, auditing, billing, eventing, logging, monitoring, sawmill, and tracing. Chemist also accepts telemetry data not associated with API traffic, such as billing metrics. Example: control: environment: servicecontrol.googleapis.com
    """
    def __init__(__self__, *,
                 environment: str):
        """
        Selects and configures the service controller used by the service. The service controller handles two things: - **What is allowed:** for each API request, Chemist checks the project status, activation status, abuse status, billing status, service status, location restrictions, VPC Service Controls, SuperQuota, and other policies. - **What has happened:** for each API response, Chemist reports the telemetry data to analytics, auditing, billing, eventing, logging, monitoring, sawmill, and tracing. Chemist also accepts telemetry data not associated with API traffic, such as billing metrics. Example: control: environment: servicecontrol.googleapis.com
        :param str environment: The service controller environment to use. If empty, no control plane feature (like quota and billing) will be enabled. The recommended value for most services is servicecontrol.googleapis.com
        """
        pulumi.set(__self__, "environment", environment)

    @property
    @pulumi.getter
    def environment(self) -> str:
        """
        The service controller environment to use. If empty, no control plane feature (like quota and billing) will be enabled. The recommended value for most services is servicecontrol.googleapis.com
        """
        return pulumi.get(self, "environment")


@pulumi.output_type
class CustomErrorResponse(dict):
    """
    Customize service error responses. For example, list any service specific protobuf types that can appear in error detail lists of error responses. Example: custom_error: types: - google.foo.v1.CustomError - google.foo.v1.AnotherError
    """
    def __init__(__self__, *,
                 rules: Sequence['outputs.CustomErrorRuleResponse'],
                 types: Sequence[str]):
        """
        Customize service error responses. For example, list any service specific protobuf types that can appear in error detail lists of error responses. Example: custom_error: types: - google.foo.v1.CustomError - google.foo.v1.AnotherError
        :param Sequence['CustomErrorRuleResponse'] rules: The list of custom error rules that apply to individual API messages. **NOTE:** All service configuration rules follow "last one wins" order.
        :param Sequence[str] types: The list of custom error detail types, e.g. 'google.foo.v1.CustomError'.
        """
        pulumi.set(__self__, "rules", rules)
        pulumi.set(__self__, "types", types)

    @property
    @pulumi.getter
    def rules(self) -> Sequence['outputs.CustomErrorRuleResponse']:
        """
        The list of custom error rules that apply to individual API messages. **NOTE:** All service configuration rules follow "last one wins" order.
        """
        return pulumi.get(self, "rules")

    @property
    @pulumi.getter
    def types(self) -> Sequence[str]:
        """
        The list of custom error detail types, e.g. 'google.foo.v1.CustomError'.
        """
        return pulumi.get(self, "types")


@pulumi.output_type
class CustomErrorRuleResponse(dict):
    """
    A custom error rule.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "isErrorType":
            suggest = "is_error_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CustomErrorRuleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CustomErrorRuleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CustomErrorRuleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 is_error_type: bool,
                 selector: str):
        """
        A custom error rule.
        :param bool is_error_type: Mark this message as possible payload in error response. Otherwise, objects of this type will be filtered when they appear in error payload.
        :param str selector: Selects messages to which this rule applies. Refer to selector for syntax details.
        """
        pulumi.set(__self__, "is_error_type", is_error_type)
        pulumi.set(__self__, "selector", selector)

    @property
    @pulumi.getter(name="isErrorType")
    def is_error_type(self) -> bool:
        """
        Mark this message as possible payload in error response. Otherwise, objects of this type will be filtered when they appear in error payload.
        """
        return pulumi.get(self, "is_error_type")

    @property
    @pulumi.getter
    def selector(self) -> str:
        """
        Selects messages to which this rule applies. Refer to selector for syntax details.
        """
        return pulumi.get(self, "selector")


@pulumi.output_type
class CustomHttpPatternResponse(dict):
    """
    A custom pattern is used for defining custom HTTP verb.
    """
    def __init__(__self__, *,
                 kind: str,
                 path: str):
        """
        A custom pattern is used for defining custom HTTP verb.
        :param str kind: The name of this custom HTTP verb.
        :param str path: The path matched by this custom verb.
        """
        pulumi.set(__self__, "kind", kind)
        pulumi.set(__self__, "path", path)

    @property
    @pulumi.getter
    def kind(self) -> str:
        """
        The name of this custom HTTP verb.
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter
    def path(self) -> str:
        """
        The path matched by this custom verb.
        """
        return pulumi.get(self, "path")


@pulumi.output_type
class DeleteServiceStrategyResponse(dict):
    """
    Strategy used to delete a service. This strategy is a placeholder only used by the system generated rollout to delete a service.
    """
    def __init__(__self__):
        """
        Strategy used to delete a service. This strategy is a placeholder only used by the system generated rollout to delete a service.
        """
        pass


@pulumi.output_type
class DocumentationResponse(dict):
    """
    `Documentation` provides the information for describing a service. Example: documentation: summary: > The Google Calendar API gives access to most calendar features. pages: - name: Overview content: (== include google/foo/overview.md ==) - name: Tutorial content: (== include google/foo/tutorial.md ==) subpages; - name: Java content: (== include google/foo/tutorial_java.md ==) rules: - selector: google.calendar.Calendar.Get description: > ... - selector: google.calendar.Calendar.Put description: > ... Documentation is provided in markdown syntax. In addition to standard markdown features, definition lists, tables and fenced code blocks are supported. Section headers can be provided and are interpreted relative to the section nesting of the context where a documentation fragment is embedded. Documentation from the IDL is merged with documentation defined via the config at normalization time, where documentation provided by config rules overrides IDL provided. A number of constructs specific to the API platform are supported in documentation text. In order to reference a proto element, the following notation can be used: [fully.qualified.proto.name][] To override the display text used for the link, this can be used: [display text][fully.qualified.proto.name] Text can be excluded from doc using the following notation: (-- internal comment --) A few directives are available in documentation. Note that directives must appear on a single line to be properly identified. The `include` directive includes a markdown file from an external source: (== include path/to/file ==) The `resource_for` directive marks a message to be the resource of a collection in REST view. If it is not specified, tools attempt to infer the resource from the operations in a collection: (== resource_for v1.shelves.books ==) The directive `suppress_warning` does not directly affect documentation and is documented together with service config validation.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "documentationRootUrl":
            suggest = "documentation_root_url"
        elif key == "serviceRootUrl":
            suggest = "service_root_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DocumentationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DocumentationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DocumentationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 documentation_root_url: str,
                 overview: str,
                 pages: Sequence['outputs.PageResponse'],
                 rules: Sequence['outputs.DocumentationRuleResponse'],
                 service_root_url: str,
                 summary: str):
        """
        `Documentation` provides the information for describing a service. Example: documentation: summary: > The Google Calendar API gives access to most calendar features. pages: - name: Overview content: (== include google/foo/overview.md ==) - name: Tutorial content: (== include google/foo/tutorial.md ==) subpages; - name: Java content: (== include google/foo/tutorial_java.md ==) rules: - selector: google.calendar.Calendar.Get description: > ... - selector: google.calendar.Calendar.Put description: > ... Documentation is provided in markdown syntax. In addition to standard markdown features, definition lists, tables and fenced code blocks are supported. Section headers can be provided and are interpreted relative to the section nesting of the context where a documentation fragment is embedded. Documentation from the IDL is merged with documentation defined via the config at normalization time, where documentation provided by config rules overrides IDL provided. A number of constructs specific to the API platform are supported in documentation text. In order to reference a proto element, the following notation can be used: [fully.qualified.proto.name][] To override the display text used for the link, this can be used: [display text][fully.qualified.proto.name] Text can be excluded from doc using the following notation: (-- internal comment --) A few directives are available in documentation. Note that directives must appear on a single line to be properly identified. The `include` directive includes a markdown file from an external source: (== include path/to/file ==) The `resource_for` directive marks a message to be the resource of a collection in REST view. If it is not specified, tools attempt to infer the resource from the operations in a collection: (== resource_for v1.shelves.books ==) The directive `suppress_warning` does not directly affect documentation and is documented together with service config validation.
        :param str documentation_root_url: The URL to the root of documentation.
        :param str overview: Declares a single overview page. For example: documentation: summary: ... overview: (== include overview.md ==) This is a shortcut for the following declaration (using pages style): documentation: summary: ... pages: - name: Overview content: (== include overview.md ==) Note: you cannot specify both `overview` field and `pages` field.
        :param Sequence['PageResponse'] pages: The top level pages for the documentation set.
        :param Sequence['DocumentationRuleResponse'] rules: A list of documentation rules that apply to individual API elements. **NOTE:** All service configuration rules follow "last one wins" order.
        :param str service_root_url: Specifies the service root url if the default one (the service name from the yaml file) is not suitable. This can be seen in any fully specified service urls as well as sections that show a base that other urls are relative to.
        :param str summary: A short description of what the service does. The summary must be plain text. It becomes the overview of the service displayed in Google Cloud Console. NOTE: This field is equivalent to the standard field `description`.
        """
        pulumi.set(__self__, "documentation_root_url", documentation_root_url)
        pulumi.set(__self__, "overview", overview)
        pulumi.set(__self__, "pages", pages)
        pulumi.set(__self__, "rules", rules)
        pulumi.set(__self__, "service_root_url", service_root_url)
        pulumi.set(__self__, "summary", summary)

    @property
    @pulumi.getter(name="documentationRootUrl")
    def documentation_root_url(self) -> str:
        """
        The URL to the root of documentation.
        """
        return pulumi.get(self, "documentation_root_url")

    @property
    @pulumi.getter
    def overview(self) -> str:
        """
        Declares a single overview page. For example: documentation: summary: ... overview: (== include overview.md ==) This is a shortcut for the following declaration (using pages style): documentation: summary: ... pages: - name: Overview content: (== include overview.md ==) Note: you cannot specify both `overview` field and `pages` field.
        """
        return pulumi.get(self, "overview")

    @property
    @pulumi.getter
    def pages(self) -> Sequence['outputs.PageResponse']:
        """
        The top level pages for the documentation set.
        """
        return pulumi.get(self, "pages")

    @property
    @pulumi.getter
    def rules(self) -> Sequence['outputs.DocumentationRuleResponse']:
        """
        A list of documentation rules that apply to individual API elements. **NOTE:** All service configuration rules follow "last one wins" order.
        """
        return pulumi.get(self, "rules")

    @property
    @pulumi.getter(name="serviceRootUrl")
    def service_root_url(self) -> str:
        """
        Specifies the service root url if the default one (the service name from the yaml file) is not suitable. This can be seen in any fully specified service urls as well as sections that show a base that other urls are relative to.
        """
        return pulumi.get(self, "service_root_url")

    @property
    @pulumi.getter
    def summary(self) -> str:
        """
        A short description of what the service does. The summary must be plain text. It becomes the overview of the service displayed in Google Cloud Console. NOTE: This field is equivalent to the standard field `description`.
        """
        return pulumi.get(self, "summary")


@pulumi.output_type
class DocumentationRuleResponse(dict):
    """
    A documentation rule provides information about individual API elements.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deprecationDescription":
            suggest = "deprecation_description"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DocumentationRuleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DocumentationRuleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DocumentationRuleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 deprecation_description: str,
                 description: str,
                 selector: str):
        """
        A documentation rule provides information about individual API elements.
        :param str deprecation_description: Deprecation description of the selected element(s). It can be provided if an element is marked as `deprecated`.
        :param str description: Description of the selected proto element (e.g. a message, a method, a 'service' definition, or a field). Defaults to leading & trailing comments taken from the proto source definition of the proto element.
        :param str selector: The selector is a comma-separated list of patterns for any element such as a method, a field, an enum value. Each pattern is a qualified name of the element which may end in "*", indicating a wildcard. Wildcards are only allowed at the end and for a whole component of the qualified name, i.e. "foo.*" is ok, but not "foo.b*" or "foo.*.bar". A wildcard will match one or more components. To specify a default for all applicable elements, the whole pattern "*" is used.
        """
        pulumi.set(__self__, "deprecation_description", deprecation_description)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "selector", selector)

    @property
    @pulumi.getter(name="deprecationDescription")
    def deprecation_description(self) -> str:
        """
        Deprecation description of the selected element(s). It can be provided if an element is marked as `deprecated`.
        """
        return pulumi.get(self, "deprecation_description")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Description of the selected proto element (e.g. a message, a method, a 'service' definition, or a field). Defaults to leading & trailing comments taken from the proto source definition of the proto element.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def selector(self) -> str:
        """
        The selector is a comma-separated list of patterns for any element such as a method, a field, an enum value. Each pattern is a qualified name of the element which may end in "*", indicating a wildcard. Wildcards are only allowed at the end and for a whole component of the qualified name, i.e. "foo.*" is ok, but not "foo.b*" or "foo.*.bar". A wildcard will match one or more components. To specify a default for all applicable elements, the whole pattern "*" is used.
        """
        return pulumi.get(self, "selector")


@pulumi.output_type
class EndpointResponse(dict):
    """
    `Endpoint` describes a network address of a service that serves a set of APIs. It is commonly known as a service endpoint. A service may expose any number of service endpoints, and all service endpoints share the same service definition, such as quota limits and monitoring metrics. Example: type: google.api.Service name: library-example.googleapis.com endpoints: # Declares network address `https://library-example.googleapis.com` # for service `library-example.googleapis.com`. The `https` scheme # is implicit for all service endpoints. Other schemes may be # supported in the future. - name: library-example.googleapis.com allow_cors: false - name: content-staging-library-example.googleapis.com # Allows HTTP OPTIONS calls to be passed to the API frontend, for it # to decide whether the subsequent cross-origin request is allowed # to proceed. allow_cors: true
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowCors":
            suggest = "allow_cors"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EndpointResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EndpointResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EndpointResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allow_cors: bool,
                 name: str,
                 target: str):
        """
        `Endpoint` describes a network address of a service that serves a set of APIs. It is commonly known as a service endpoint. A service may expose any number of service endpoints, and all service endpoints share the same service definition, such as quota limits and monitoring metrics. Example: type: google.api.Service name: library-example.googleapis.com endpoints: # Declares network address `https://library-example.googleapis.com` # for service `library-example.googleapis.com`. The `https` scheme # is implicit for all service endpoints. Other schemes may be # supported in the future. - name: library-example.googleapis.com allow_cors: false - name: content-staging-library-example.googleapis.com # Allows HTTP OPTIONS calls to be passed to the API frontend, for it # to decide whether the subsequent cross-origin request is allowed # to proceed. allow_cors: true
        :param bool allow_cors: Allowing [CORS](https://en.wikipedia.org/wiki/Cross-origin_resource_sharing), aka cross-domain traffic, would allow the backends served from this endpoint to receive and respond to HTTP OPTIONS requests. The response will be used by the browser to determine whether the subsequent cross-origin request is allowed to proceed.
        :param str name: The canonical name of this endpoint.
        :param str target: The specification of an Internet routable address of API frontend that will handle requests to this [API Endpoint](https://cloud.google.com/apis/design/glossary). It should be either a valid IPv4 address or a fully-qualified domain name. For example, "8.8.8.8" or "myservice.appspot.com".
        """
        pulumi.set(__self__, "allow_cors", allow_cors)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "target", target)

    @property
    @pulumi.getter(name="allowCors")
    def allow_cors(self) -> bool:
        """
        Allowing [CORS](https://en.wikipedia.org/wiki/Cross-origin_resource_sharing), aka cross-domain traffic, would allow the backends served from this endpoint to receive and respond to HTTP OPTIONS requests. The response will be used by the browser to determine whether the subsequent cross-origin request is allowed to proceed.
        """
        return pulumi.get(self, "allow_cors")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The canonical name of this endpoint.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def target(self) -> str:
        """
        The specification of an Internet routable address of API frontend that will handle requests to this [API Endpoint](https://cloud.google.com/apis/design/glossary). It should be either a valid IPv4 address or a fully-qualified domain name. For example, "8.8.8.8" or "myservice.appspot.com".
        """
        return pulumi.get(self, "target")


@pulumi.output_type
class EnumResponse(dict):
    """
    Enum type definition.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sourceContext":
            suggest = "source_context"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EnumResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EnumResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EnumResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enumvalue: Sequence['outputs.EnumValueResponse'],
                 name: str,
                 options: Sequence['outputs.OptionResponse'],
                 source_context: 'outputs.SourceContextResponse',
                 syntax: str):
        """
        Enum type definition.
        :param Sequence['EnumValueResponse'] enumvalue: Enum value definitions.
        :param str name: Enum type name.
        :param Sequence['OptionResponse'] options: Protocol buffer options.
        :param 'SourceContextResponse' source_context: The source context.
        :param str syntax: The source syntax.
        """
        pulumi.set(__self__, "enumvalue", enumvalue)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "options", options)
        pulumi.set(__self__, "source_context", source_context)
        pulumi.set(__self__, "syntax", syntax)

    @property
    @pulumi.getter
    def enumvalue(self) -> Sequence['outputs.EnumValueResponse']:
        """
        Enum value definitions.
        """
        return pulumi.get(self, "enumvalue")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Enum type name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def options(self) -> Sequence['outputs.OptionResponse']:
        """
        Protocol buffer options.
        """
        return pulumi.get(self, "options")

    @property
    @pulumi.getter(name="sourceContext")
    def source_context(self) -> 'outputs.SourceContextResponse':
        """
        The source context.
        """
        return pulumi.get(self, "source_context")

    @property
    @pulumi.getter
    def syntax(self) -> str:
        """
        The source syntax.
        """
        return pulumi.get(self, "syntax")


@pulumi.output_type
class EnumValueResponse(dict):
    """
    Enum value definition.
    """
    def __init__(__self__, *,
                 name: str,
                 number: int,
                 options: Sequence['outputs.OptionResponse']):
        """
        Enum value definition.
        :param str name: Enum value name.
        :param int number: Enum value number.
        :param Sequence['OptionResponse'] options: Protocol buffer options.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "number", number)
        pulumi.set(__self__, "options", options)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Enum value name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def number(self) -> int:
        """
        Enum value number.
        """
        return pulumi.get(self, "number")

    @property
    @pulumi.getter
    def options(self) -> Sequence['outputs.OptionResponse']:
        """
        Protocol buffer options.
        """
        return pulumi.get(self, "options")


@pulumi.output_type
class ExprResponse(dict):
    """
    Represents a textual expression in the Common Expression Language (CEL) syntax. CEL is a C-like expression language. The syntax and semantics of CEL are documented at https://github.com/google/cel-spec. Example (Comparison): title: "Summary size limit" description: "Determines if a summary is less than 100 chars" expression: "document.summary.size() < 100" Example (Equality): title: "Requestor is owner" description: "Determines if requestor is the document owner" expression: "document.owner == request.auth.claims.email" Example (Logic): title: "Public documents" description: "Determine whether the document should be publicly visible" expression: "document.type != 'private' && document.type != 'internal'" Example (Data Manipulation): title: "Notification string" description: "Create a notification string with a timestamp." expression: "'New message received at ' + string(document.create_time)" The exact variables and functions that may be referenced within an expression are determined by the service that evaluates it. See the service documentation for additional information.
    """
    def __init__(__self__, *,
                 description: str,
                 expression: str,
                 location: str,
                 title: str):
        """
        Represents a textual expression in the Common Expression Language (CEL) syntax. CEL is a C-like expression language. The syntax and semantics of CEL are documented at https://github.com/google/cel-spec. Example (Comparison): title: "Summary size limit" description: "Determines if a summary is less than 100 chars" expression: "document.summary.size() < 100" Example (Equality): title: "Requestor is owner" description: "Determines if requestor is the document owner" expression: "document.owner == request.auth.claims.email" Example (Logic): title: "Public documents" description: "Determine whether the document should be publicly visible" expression: "document.type != 'private' && document.type != 'internal'" Example (Data Manipulation): title: "Notification string" description: "Create a notification string with a timestamp." expression: "'New message received at ' + string(document.create_time)" The exact variables and functions that may be referenced within an expression are determined by the service that evaluates it. See the service documentation for additional information.
        :param str description: Optional. Description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
        :param str expression: Textual representation of an expression in Common Expression Language syntax.
        :param str location: Optional. String indicating the location of the expression for error reporting, e.g. a file name and a position in the file.
        :param str title: Optional. Title for the expression, i.e. a short string describing its purpose. This can be used e.g. in UIs which allow to enter the expression.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Optional. Description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def expression(self) -> str:
        """
        Textual representation of an expression in Common Expression Language syntax.
        """
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def location(self) -> str:
        """
        Optional. String indicating the location of the expression for error reporting, e.g. a file name and a position in the file.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def title(self) -> str:
        """
        Optional. Title for the expression, i.e. a short string describing its purpose. This can be used e.g. in UIs which allow to enter the expression.
        """
        return pulumi.get(self, "title")


@pulumi.output_type
class FieldResponse(dict):
    """
    A single field of a message type.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultValue":
            suggest = "default_value"
        elif key == "jsonName":
            suggest = "json_name"
        elif key == "oneofIndex":
            suggest = "oneof_index"
        elif key == "typeUrl":
            suggest = "type_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FieldResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FieldResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FieldResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cardinality: str,
                 default_value: str,
                 json_name: str,
                 kind: str,
                 name: str,
                 number: int,
                 oneof_index: int,
                 options: Sequence['outputs.OptionResponse'],
                 packed: bool,
                 type_url: str):
        """
        A single field of a message type.
        :param str cardinality: The field cardinality.
        :param str default_value: The string value of the default value of this field. Proto2 syntax only.
        :param str json_name: The field JSON name.
        :param str kind: The field type.
        :param str name: The field name.
        :param int number: The field number.
        :param int oneof_index: The index of the field type in `Type.oneofs`, for message or enumeration types. The first type has index 1; zero means the type is not in the list.
        :param Sequence['OptionResponse'] options: The protocol buffer options.
        :param bool packed: Whether to use alternative packed wire representation.
        :param str type_url: The field type URL, without the scheme, for message or enumeration types. Example: `"type.googleapis.com/google.protobuf.Timestamp"`.
        """
        pulumi.set(__self__, "cardinality", cardinality)
        pulumi.set(__self__, "default_value", default_value)
        pulumi.set(__self__, "json_name", json_name)
        pulumi.set(__self__, "kind", kind)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "number", number)
        pulumi.set(__self__, "oneof_index", oneof_index)
        pulumi.set(__self__, "options", options)
        pulumi.set(__self__, "packed", packed)
        pulumi.set(__self__, "type_url", type_url)

    @property
    @pulumi.getter
    def cardinality(self) -> str:
        """
        The field cardinality.
        """
        return pulumi.get(self, "cardinality")

    @property
    @pulumi.getter(name="defaultValue")
    def default_value(self) -> str:
        """
        The string value of the default value of this field. Proto2 syntax only.
        """
        return pulumi.get(self, "default_value")

    @property
    @pulumi.getter(name="jsonName")
    def json_name(self) -> str:
        """
        The field JSON name.
        """
        return pulumi.get(self, "json_name")

    @property
    @pulumi.getter
    def kind(self) -> str:
        """
        The field type.
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The field name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def number(self) -> int:
        """
        The field number.
        """
        return pulumi.get(self, "number")

    @property
    @pulumi.getter(name="oneofIndex")
    def oneof_index(self) -> int:
        """
        The index of the field type in `Type.oneofs`, for message or enumeration types. The first type has index 1; zero means the type is not in the list.
        """
        return pulumi.get(self, "oneof_index")

    @property
    @pulumi.getter
    def options(self) -> Sequence['outputs.OptionResponse']:
        """
        The protocol buffer options.
        """
        return pulumi.get(self, "options")

    @property
    @pulumi.getter
    def packed(self) -> bool:
        """
        Whether to use alternative packed wire representation.
        """
        return pulumi.get(self, "packed")

    @property
    @pulumi.getter(name="typeUrl")
    def type_url(self) -> str:
        """
        The field type URL, without the scheme, for message or enumeration types. Example: `"type.googleapis.com/google.protobuf.Timestamp"`.
        """
        return pulumi.get(self, "type_url")


@pulumi.output_type
class HttpResponse(dict):
    """
    Defines the HTTP configuration for an API service. It contains a list of HttpRule, each specifying the mapping of an RPC method to one or more HTTP REST API methods.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fullyDecodeReservedExpansion":
            suggest = "fully_decode_reserved_expansion"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HttpResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HttpResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HttpResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 fully_decode_reserved_expansion: bool,
                 rules: Sequence['outputs.HttpRuleResponse']):
        """
        Defines the HTTP configuration for an API service. It contains a list of HttpRule, each specifying the mapping of an RPC method to one or more HTTP REST API methods.
        :param bool fully_decode_reserved_expansion: When set to true, URL path parameters will be fully URI-decoded except in cases of single segment matches in reserved expansion, where "%2F" will be left encoded. The default behavior is to not decode RFC 6570 reserved characters in multi segment matches.
        :param Sequence['HttpRuleResponse'] rules: A list of HTTP configuration rules that apply to individual API methods. **NOTE:** All service configuration rules follow "last one wins" order.
        """
        pulumi.set(__self__, "fully_decode_reserved_expansion", fully_decode_reserved_expansion)
        pulumi.set(__self__, "rules", rules)

    @property
    @pulumi.getter(name="fullyDecodeReservedExpansion")
    def fully_decode_reserved_expansion(self) -> bool:
        """
        When set to true, URL path parameters will be fully URI-decoded except in cases of single segment matches in reserved expansion, where "%2F" will be left encoded. The default behavior is to not decode RFC 6570 reserved characters in multi segment matches.
        """
        return pulumi.get(self, "fully_decode_reserved_expansion")

    @property
    @pulumi.getter
    def rules(self) -> Sequence['outputs.HttpRuleResponse']:
        """
        A list of HTTP configuration rules that apply to individual API methods. **NOTE:** All service configuration rules follow "last one wins" order.
        """
        return pulumi.get(self, "rules")


@pulumi.output_type
class HttpRuleResponse(dict):
    """
    # gRPC Transcoding gRPC Transcoding is a feature for mapping between a gRPC method and one or more HTTP REST endpoints. It allows developers to build a single API service that supports both gRPC APIs and REST APIs. Many systems, including [Google APIs](https://github.com/googleapis/googleapis), [Cloud Endpoints](https://cloud.google.com/endpoints), [gRPC Gateway](https://github.com/grpc-ecosystem/grpc-gateway), and [Envoy](https://github.com/envoyproxy/envoy) proxy support this feature and use it for large scale production services. `HttpRule` defines the schema of the gRPC/REST mapping. The mapping specifies how different portions of the gRPC request message are mapped to the URL path, URL query parameters, and HTTP request body. It also controls how the gRPC response message is mapped to the HTTP response body. `HttpRule` is typically specified as an `google.api.http` annotation on the gRPC method. Each mapping specifies a URL path template and an HTTP method. The path template may refer to one or more fields in the gRPC request message, as long as each field is a non-repeated field with a primitive (non-message) type. The path template controls how fields of the request message are mapped to the URL path. Example: service Messaging { rpc GetMessage(GetMessageRequest) returns (Message) { option (google.api.http) = { get: "/v1/{name=messages/*}" }; } } message GetMessageRequest { string name = 1; // Mapped to URL path. } message Message { string text = 1; // The resource content. } This enables an HTTP REST to gRPC mapping as below: HTTP | gRPC -----|----- `GET /v1/messages/123456` | `GetMessage(name: "messages/123456")` Any fields in the request message which are not bound by the path template automatically become HTTP query parameters if there is no HTTP request body. For example: service Messaging { rpc GetMessage(GetMessageRequest) returns (Message) { option (google.api.http) = { get:"/v1/messages/{message_id}" }; } } message GetMessageRequest { message SubMessage { string subfield = 1; } string message_id = 1; // Mapped to URL path. int64 revision = 2; // Mapped to URL query parameter `revision`. SubMessage sub = 3; // Mapped to URL query parameter `sub.subfield`. } This enables a HTTP JSON to RPC mapping as below: HTTP | gRPC -----|----- `GET /v1/messages/123456?revision=2&sub.subfield=foo` | `GetMessage(message_id: "123456" revision: 2 sub: SubMessage(subfield: "foo"))` Note that fields which are mapped to URL query parameters must have a primitive type or a repeated primitive type or a non-repeated message type. In the case of a repeated type, the parameter can be repeated in the URL as `...?param=A&param=B`. In the case of a message type, each field of the message is mapped to a separate parameter, such as `...?foo.a=A&foo.b=B&foo.c=C`. For HTTP methods that allow a request body, the `body` field specifies the mapping. Consider a REST update method on the message resource collection: service Messaging { rpc UpdateMessage(UpdateMessageRequest) returns (Message) { option (google.api.http) = { patch: "/v1/messages/{message_id}" body: "message" }; } } message UpdateMessageRequest { string message_id = 1; // mapped to the URL Message message = 2; // mapped to the body } The following HTTP JSON to RPC mapping is enabled, where the representation of the JSON in the request body is determined by protos JSON encoding: HTTP | gRPC -----|----- `PATCH /v1/messages/123456 { "text": "Hi!" }` | `UpdateMessage(message_id: "123456" message { text: "Hi!" })` The special name `*` can be used in the body mapping to define that every field not bound by the path template should be mapped to the request body. This enables the following alternative definition of the update method: service Messaging { rpc UpdateMessage(Message) returns (Message) { option (google.api.http) = { patch: "/v1/messages/{message_id}" body: "*" }; } } message Message { string message_id = 1; string text = 2; } The following HTTP JSON to RPC mapping is enabled: HTTP | gRPC -----|----- `PATCH /v1/messages/123456 { "text": "Hi!" }` | `UpdateMessage(message_id: "123456" text: "Hi!")` Note that when using `*` in the body mapping, it is not possible to have HTTP parameters, as all fields not bound by the path end in the body. This makes this option more rarely used in practice when defining REST APIs. The common usage of `*` is in custom methods which don't use the URL at all for transferring data. It is possible to define multiple HTTP methods for one RPC by using the `additional_bindings` option. Example: service Messaging { rpc GetMessage(GetMessageRequest) returns (Message) { option (google.api.http) = { get: "/v1/messages/{message_id}" additional_bindings { get: "/v1/users/{user_id}/messages/{message_id}" } }; } } message GetMessageRequest { string message_id = 1; string user_id = 2; } This enables the following two alternative HTTP JSON to RPC mappings: HTTP | gRPC -----|----- `GET /v1/messages/123456` | `GetMessage(message_id: "123456")` `GET /v1/users/me/messages/123456` | `GetMessage(user_id: "me" message_id: "123456")` ## Rules for HTTP mapping 1. Leaf request fields (recursive expansion nested messages in the request message) are classified into three categories: - Fields referred by the path template. They are passed via the URL path. - Fields referred by the HttpRule.body. They are passed via the HTTP request body. - All other fields are passed via the URL query parameters, and the parameter name is the field path in the request message. A repeated field can be represented as multiple query parameters under the same name. 2. If HttpRule.body is "*", there is no URL query parameter, all fields are passed via URL path and HTTP request body. 3. If HttpRule.body is omitted, there is no HTTP request body, all fields are passed via URL path and URL query parameters. ### Path template syntax Template = "/" Segments [ Verb ] ; Segments = Segment { "/" Segment } ; Segment = "*" | "**" | LITERAL | Variable ; Variable = "{" FieldPath [ "=" Segments ] "}" ; FieldPath = IDENT { "." IDENT } ; Verb = ":" LITERAL ; The syntax `*` matches a single URL path segment. The syntax `**` matches zero or more URL path segments, which must be the last part of the URL path except the `Verb`. The syntax `Variable` matches part of the URL path as specified by its template. A variable template must not contain other variables. If a variable matches a single path segment, its template may be omitted, e.g. `{var}` is equivalent to `{var=*}`. The syntax `LITERAL` matches literal text in the URL path. If the `LITERAL` contains any reserved character, such characters should be percent-encoded before the matching. If a variable contains exactly one path segment, such as `"{var}"` or `"{var=*}"`, when such a variable is expanded into a URL path on the client side, all characters except `[-_.~0-9a-zA-Z]` are percent-encoded. The server side does the reverse decoding. Such variables show up in the [Discovery Document](https://developers.google.com/discovery/v1/reference/apis) as `{var}`. If a variable contains multiple path segments, such as `"{var=foo/*}"` or `"{var=**}"`, when such a variable is expanded into a URL path on the client side, all characters except `[-_.~/0-9a-zA-Z]` are percent-encoded. The server side does the reverse decoding, except "%2F" and "%2f" are left unchanged. Such variables show up in the [Discovery Document](https://developers.google.com/discovery/v1/reference/apis) as `{+var}`. ## Using gRPC API Service Configuration gRPC API Service Configuration (service config) is a configuration language for configuring a gRPC service to become a user-facing product. The service config is simply the YAML representation of the `google.api.Service` proto message. As an alternative to annotating your proto file, you can configure gRPC transcoding in your service config YAML files. You do this by specifying a `HttpRule` that maps the gRPC method to a REST endpoint, achieving the same effect as the proto annotation. This can be particularly useful if you have a proto that is reused in multiple services. Note that any transcoding specified in the service config will override any matching transcoding configuration in the proto. Example: http: rules: # Selects a gRPC method and applies HttpRule to it. - selector: example.v1.Messaging.GetMessage get: /v1/messages/{message_id}/{sub.subfield} ## Special notes When gRPC Transcoding is used to map a gRPC to JSON REST endpoints, the proto to JSON conversion must follow the [proto3 specification](https://developers.google.com/protocol-buffers/docs/proto3#json). While the single segment variable follows the semantics of [RFC 6570](https://tools.ietf.org/html/rfc6570) Section 3.2.2 Simple String Expansion, the multi segment variable **does not** follow RFC 6570 Section 3.2.3 Reserved Expansion. The reason is that the Reserved Expansion does not expand special characters like `?` and `#`, which would lead to invalid URLs. As the result, gRPC Transcoding uses a custom encoding for multi segment variables. The path variables **must not** refer to any repeated or mapped field, because client libraries are not capable of handling such variable expansion. The path variables **must not** capture the leading "/" character. The reason is that the most common use case "{var}" does not capture the leading "/" character. For consistency, all path variables must share the same behavior. Repeated message fields must not be mapped to URL query parameters, because no client library can support such complicated mapping. If an API needs to use a JSON array for request or response body, it can map the request or response body to a repeated field. However, some gRPC Transcoding implementations may not support this feature.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "additionalBindings":
            suggest = "additional_bindings"
        elif key == "responseBody":
            suggest = "response_body"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HttpRuleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HttpRuleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HttpRuleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 additional_bindings: Sequence['outputs.HttpRuleResponse'],
                 body: str,
                 custom: 'outputs.CustomHttpPatternResponse',
                 delete: str,
                 get: str,
                 patch: str,
                 post: str,
                 put: str,
                 response_body: str,
                 selector: str):
        """
        # gRPC Transcoding gRPC Transcoding is a feature for mapping between a gRPC method and one or more HTTP REST endpoints. It allows developers to build a single API service that supports both gRPC APIs and REST APIs. Many systems, including [Google APIs](https://github.com/googleapis/googleapis), [Cloud Endpoints](https://cloud.google.com/endpoints), [gRPC Gateway](https://github.com/grpc-ecosystem/grpc-gateway), and [Envoy](https://github.com/envoyproxy/envoy) proxy support this feature and use it for large scale production services. `HttpRule` defines the schema of the gRPC/REST mapping. The mapping specifies how different portions of the gRPC request message are mapped to the URL path, URL query parameters, and HTTP request body. It also controls how the gRPC response message is mapped to the HTTP response body. `HttpRule` is typically specified as an `google.api.http` annotation on the gRPC method. Each mapping specifies a URL path template and an HTTP method. The path template may refer to one or more fields in the gRPC request message, as long as each field is a non-repeated field with a primitive (non-message) type. The path template controls how fields of the request message are mapped to the URL path. Example: service Messaging { rpc GetMessage(GetMessageRequest) returns (Message) { option (google.api.http) = { get: "/v1/{name=messages/*}" }; } } message GetMessageRequest { string name = 1; // Mapped to URL path. } message Message { string text = 1; // The resource content. } This enables an HTTP REST to gRPC mapping as below: HTTP | gRPC -----|----- `GET /v1/messages/123456` | `GetMessage(name: "messages/123456")` Any fields in the request message which are not bound by the path template automatically become HTTP query parameters if there is no HTTP request body. For example: service Messaging { rpc GetMessage(GetMessageRequest) returns (Message) { option (google.api.http) = { get:"/v1/messages/{message_id}" }; } } message GetMessageRequest { message SubMessage { string subfield = 1; } string message_id = 1; // Mapped to URL path. int64 revision = 2; // Mapped to URL query parameter `revision`. SubMessage sub = 3; // Mapped to URL query parameter `sub.subfield`. } This enables a HTTP JSON to RPC mapping as below: HTTP | gRPC -----|----- `GET /v1/messages/123456?revision=2&sub.subfield=foo` | `GetMessage(message_id: "123456" revision: 2 sub: SubMessage(subfield: "foo"))` Note that fields which are mapped to URL query parameters must have a primitive type or a repeated primitive type or a non-repeated message type. In the case of a repeated type, the parameter can be repeated in the URL as `...?param=A&param=B`. In the case of a message type, each field of the message is mapped to a separate parameter, such as `...?foo.a=A&foo.b=B&foo.c=C`. For HTTP methods that allow a request body, the `body` field specifies the mapping. Consider a REST update method on the message resource collection: service Messaging { rpc UpdateMessage(UpdateMessageRequest) returns (Message) { option (google.api.http) = { patch: "/v1/messages/{message_id}" body: "message" }; } } message UpdateMessageRequest { string message_id = 1; // mapped to the URL Message message = 2; // mapped to the body } The following HTTP JSON to RPC mapping is enabled, where the representation of the JSON in the request body is determined by protos JSON encoding: HTTP | gRPC -----|----- `PATCH /v1/messages/123456 { "text": "Hi!" }` | `UpdateMessage(message_id: "123456" message { text: "Hi!" })` The special name `*` can be used in the body mapping to define that every field not bound by the path template should be mapped to the request body. This enables the following alternative definition of the update method: service Messaging { rpc UpdateMessage(Message) returns (Message) { option (google.api.http) = { patch: "/v1/messages/{message_id}" body: "*" }; } } message Message { string message_id = 1; string text = 2; } The following HTTP JSON to RPC mapping is enabled: HTTP | gRPC -----|----- `PATCH /v1/messages/123456 { "text": "Hi!" }` | `UpdateMessage(message_id: "123456" text: "Hi!")` Note that when using `*` in the body mapping, it is not possible to have HTTP parameters, as all fields not bound by the path end in the body. This makes this option more rarely used in practice when defining REST APIs. The common usage of `*` is in custom methods which don't use the URL at all for transferring data. It is possible to define multiple HTTP methods for one RPC by using the `additional_bindings` option. Example: service Messaging { rpc GetMessage(GetMessageRequest) returns (Message) { option (google.api.http) = { get: "/v1/messages/{message_id}" additional_bindings { get: "/v1/users/{user_id}/messages/{message_id}" } }; } } message GetMessageRequest { string message_id = 1; string user_id = 2; } This enables the following two alternative HTTP JSON to RPC mappings: HTTP | gRPC -----|----- `GET /v1/messages/123456` | `GetMessage(message_id: "123456")` `GET /v1/users/me/messages/123456` | `GetMessage(user_id: "me" message_id: "123456")` ## Rules for HTTP mapping 1. Leaf request fields (recursive expansion nested messages in the request message) are classified into three categories: - Fields referred by the path template. They are passed via the URL path. - Fields referred by the HttpRule.body. They are passed via the HTTP request body. - All other fields are passed via the URL query parameters, and the parameter name is the field path in the request message. A repeated field can be represented as multiple query parameters under the same name. 2. If HttpRule.body is "*", there is no URL query parameter, all fields are passed via URL path and HTTP request body. 3. If HttpRule.body is omitted, there is no HTTP request body, all fields are passed via URL path and URL query parameters. ### Path template syntax Template = "/" Segments [ Verb ] ; Segments = Segment { "/" Segment } ; Segment = "*" | "**" | LITERAL | Variable ; Variable = "{" FieldPath [ "=" Segments ] "}" ; FieldPath = IDENT { "." IDENT } ; Verb = ":" LITERAL ; The syntax `*` matches a single URL path segment. The syntax `**` matches zero or more URL path segments, which must be the last part of the URL path except the `Verb`. The syntax `Variable` matches part of the URL path as specified by its template. A variable template must not contain other variables. If a variable matches a single path segment, its template may be omitted, e.g. `{var}` is equivalent to `{var=*}`. The syntax `LITERAL` matches literal text in the URL path. If the `LITERAL` contains any reserved character, such characters should be percent-encoded before the matching. If a variable contains exactly one path segment, such as `"{var}"` or `"{var=*}"`, when such a variable is expanded into a URL path on the client side, all characters except `[-_.~0-9a-zA-Z]` are percent-encoded. The server side does the reverse decoding. Such variables show up in the [Discovery Document](https://developers.google.com/discovery/v1/reference/apis) as `{var}`. If a variable contains multiple path segments, such as `"{var=foo/*}"` or `"{var=**}"`, when such a variable is expanded into a URL path on the client side, all characters except `[-_.~/0-9a-zA-Z]` are percent-encoded. The server side does the reverse decoding, except "%2F" and "%2f" are left unchanged. Such variables show up in the [Discovery Document](https://developers.google.com/discovery/v1/reference/apis) as `{+var}`. ## Using gRPC API Service Configuration gRPC API Service Configuration (service config) is a configuration language for configuring a gRPC service to become a user-facing product. The service config is simply the YAML representation of the `google.api.Service` proto message. As an alternative to annotating your proto file, you can configure gRPC transcoding in your service config YAML files. You do this by specifying a `HttpRule` that maps the gRPC method to a REST endpoint, achieving the same effect as the proto annotation. This can be particularly useful if you have a proto that is reused in multiple services. Note that any transcoding specified in the service config will override any matching transcoding configuration in the proto. Example: http: rules: # Selects a gRPC method and applies HttpRule to it. - selector: example.v1.Messaging.GetMessage get: /v1/messages/{message_id}/{sub.subfield} ## Special notes When gRPC Transcoding is used to map a gRPC to JSON REST endpoints, the proto to JSON conversion must follow the [proto3 specification](https://developers.google.com/protocol-buffers/docs/proto3#json). While the single segment variable follows the semantics of [RFC 6570](https://tools.ietf.org/html/rfc6570) Section 3.2.2 Simple String Expansion, the multi segment variable **does not** follow RFC 6570 Section 3.2.3 Reserved Expansion. The reason is that the Reserved Expansion does not expand special characters like `?` and `#`, which would lead to invalid URLs. As the result, gRPC Transcoding uses a custom encoding for multi segment variables. The path variables **must not** refer to any repeated or mapped field, because client libraries are not capable of handling such variable expansion. The path variables **must not** capture the leading "/" character. The reason is that the most common use case "{var}" does not capture the leading "/" character. For consistency, all path variables must share the same behavior. Repeated message fields must not be mapped to URL query parameters, because no client library can support such complicated mapping. If an API needs to use a JSON array for request or response body, it can map the request or response body to a repeated field. However, some gRPC Transcoding implementations may not support this feature.
        :param Sequence['HttpRuleResponse'] additional_bindings: Additional HTTP bindings for the selector. Nested bindings must not contain an `additional_bindings` field themselves (that is, the nesting may only be one level deep).
        :param str body: The name of the request field whose value is mapped to the HTTP request body, or `*` for mapping all request fields not captured by the path pattern to the HTTP body, or omitted for not having any HTTP request body. NOTE: the referred field must be present at the top-level of the request message type.
        :param 'CustomHttpPatternResponse' custom: The custom pattern is used for specifying an HTTP method that is not included in the `pattern` field, such as HEAD, or "*" to leave the HTTP method unspecified for this rule. The wild-card rule is useful for services that provide content to Web (HTML) clients.
        :param str delete: Maps to HTTP DELETE. Used for deleting a resource.
        :param str get: Maps to HTTP GET. Used for listing and getting information about resources.
        :param str patch: Maps to HTTP PATCH. Used for updating a resource.
        :param str post: Maps to HTTP POST. Used for creating a resource or performing an action.
        :param str put: Maps to HTTP PUT. Used for replacing a resource.
        :param str response_body: Optional. The name of the response field whose value is mapped to the HTTP response body. When omitted, the entire response message will be used as the HTTP response body. NOTE: The referred field must be present at the top-level of the response message type.
        :param str selector: Selects a method to which this rule applies. Refer to selector for syntax details.
        """
        pulumi.set(__self__, "additional_bindings", additional_bindings)
        pulumi.set(__self__, "body", body)
        pulumi.set(__self__, "custom", custom)
        pulumi.set(__self__, "delete", delete)
        pulumi.set(__self__, "get", get)
        pulumi.set(__self__, "patch", patch)
        pulumi.set(__self__, "post", post)
        pulumi.set(__self__, "put", put)
        pulumi.set(__self__, "response_body", response_body)
        pulumi.set(__self__, "selector", selector)

    @property
    @pulumi.getter(name="additionalBindings")
    def additional_bindings(self) -> Sequence['outputs.HttpRuleResponse']:
        """
        Additional HTTP bindings for the selector. Nested bindings must not contain an `additional_bindings` field themselves (that is, the nesting may only be one level deep).
        """
        return pulumi.get(self, "additional_bindings")

    @property
    @pulumi.getter
    def body(self) -> str:
        """
        The name of the request field whose value is mapped to the HTTP request body, or `*` for mapping all request fields not captured by the path pattern to the HTTP body, or omitted for not having any HTTP request body. NOTE: the referred field must be present at the top-level of the request message type.
        """
        return pulumi.get(self, "body")

    @property
    @pulumi.getter
    def custom(self) -> 'outputs.CustomHttpPatternResponse':
        """
        The custom pattern is used for specifying an HTTP method that is not included in the `pattern` field, such as HEAD, or "*" to leave the HTTP method unspecified for this rule. The wild-card rule is useful for services that provide content to Web (HTML) clients.
        """
        return pulumi.get(self, "custom")

    @property
    @pulumi.getter
    def delete(self) -> str:
        """
        Maps to HTTP DELETE. Used for deleting a resource.
        """
        return pulumi.get(self, "delete")

    @property
    @pulumi.getter
    def get(self) -> str:
        """
        Maps to HTTP GET. Used for listing and getting information about resources.
        """
        return pulumi.get(self, "get")

    @property
    @pulumi.getter
    def patch(self) -> str:
        """
        Maps to HTTP PATCH. Used for updating a resource.
        """
        return pulumi.get(self, "patch")

    @property
    @pulumi.getter
    def post(self) -> str:
        """
        Maps to HTTP POST. Used for creating a resource or performing an action.
        """
        return pulumi.get(self, "post")

    @property
    @pulumi.getter
    def put(self) -> str:
        """
        Maps to HTTP PUT. Used for replacing a resource.
        """
        return pulumi.get(self, "put")

    @property
    @pulumi.getter(name="responseBody")
    def response_body(self) -> str:
        """
        Optional. The name of the response field whose value is mapped to the HTTP response body. When omitted, the entire response message will be used as the HTTP response body. NOTE: The referred field must be present at the top-level of the response message type.
        """
        return pulumi.get(self, "response_body")

    @property
    @pulumi.getter
    def selector(self) -> str:
        """
        Selects a method to which this rule applies. Refer to selector for syntax details.
        """
        return pulumi.get(self, "selector")


@pulumi.output_type
class JwtLocationResponse(dict):
    """
    Specifies a location to extract JWT from an API request.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "valuePrefix":
            suggest = "value_prefix"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JwtLocationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JwtLocationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JwtLocationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cookie: str,
                 header: str,
                 query: str,
                 value_prefix: str):
        """
        Specifies a location to extract JWT from an API request.
        :param str cookie: Specifies cookie name to extract JWT token.
        :param str header: Specifies HTTP header name to extract JWT token.
        :param str query: Specifies URL query parameter name to extract JWT token.
        :param str value_prefix: The value prefix. The value format is "value_prefix{token}" Only applies to "in" header type. Must be empty for "in" query type. If not empty, the header value has to match (case sensitive) this prefix. If not matched, JWT will not be extracted. If matched, JWT will be extracted after the prefix is removed. For example, for "Authorization: Bearer {JWT}", value_prefix="Bearer " with a space at the end.
        """
        pulumi.set(__self__, "cookie", cookie)
        pulumi.set(__self__, "header", header)
        pulumi.set(__self__, "query", query)
        pulumi.set(__self__, "value_prefix", value_prefix)

    @property
    @pulumi.getter
    def cookie(self) -> str:
        """
        Specifies cookie name to extract JWT token.
        """
        return pulumi.get(self, "cookie")

    @property
    @pulumi.getter
    def header(self) -> str:
        """
        Specifies HTTP header name to extract JWT token.
        """
        return pulumi.get(self, "header")

    @property
    @pulumi.getter
    def query(self) -> str:
        """
        Specifies URL query parameter name to extract JWT token.
        """
        return pulumi.get(self, "query")

    @property
    @pulumi.getter(name="valuePrefix")
    def value_prefix(self) -> str:
        """
        The value prefix. The value format is "value_prefix{token}" Only applies to "in" header type. Must be empty for "in" query type. If not empty, the header value has to match (case sensitive) this prefix. If not matched, JWT will not be extracted. If matched, JWT will be extracted after the prefix is removed. For example, for "Authorization: Bearer {JWT}", value_prefix="Bearer " with a space at the end.
        """
        return pulumi.get(self, "value_prefix")


@pulumi.output_type
class LabelDescriptorResponse(dict):
    """
    A description of a label.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "valueType":
            suggest = "value_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LabelDescriptorResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LabelDescriptorResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LabelDescriptorResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 description: str,
                 key: str,
                 value_type: str):
        """
        A description of a label.
        :param str description: A human-readable description for the label.
        :param str key: The label key.
        :param str value_type: The type of data that can be assigned to the label.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value_type", value_type)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        A human-readable description for the label.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        The label key.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter(name="valueType")
    def value_type(self) -> str:
        """
        The type of data that can be assigned to the label.
        """
        return pulumi.get(self, "value_type")


@pulumi.output_type
class LogDescriptorResponse(dict):
    """
    A description of a log type. Example in YAML format: - name: library.googleapis.com/activity_history description: The history of borrowing and returning library items. display_name: Activity labels: - key: /customer_id description: Identifier of a library customer
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "displayName":
            suggest = "display_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LogDescriptorResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LogDescriptorResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LogDescriptorResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 description: str,
                 display_name: str,
                 labels: Sequence['outputs.LabelDescriptorResponse'],
                 name: str):
        """
        A description of a log type. Example in YAML format: - name: library.googleapis.com/activity_history description: The history of borrowing and returning library items. display_name: Activity labels: - key: /customer_id description: Identifier of a library customer
        :param str description: A human-readable description of this log. This information appears in the documentation and can contain details.
        :param str display_name: The human-readable name for this log. This information appears on the user interface and should be concise.
        :param Sequence['LabelDescriptorResponse'] labels: The set of labels that are available to describe a specific log entry. Runtime requests that contain labels not specified here are considered invalid.
        :param str name: The name of the log. It must be less than 512 characters long and can include the following characters: upper- and lower-case alphanumeric characters [A-Za-z0-9], and punctuation characters including slash, underscore, hyphen, period [/_-.].
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "labels", labels)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        A human-readable description of this log. This information appears in the documentation and can contain details.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        The human-readable name for this log. This information appears on the user interface and should be concise.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def labels(self) -> Sequence['outputs.LabelDescriptorResponse']:
        """
        The set of labels that are available to describe a specific log entry. Runtime requests that contain labels not specified here are considered invalid.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the log. It must be less than 512 characters long and can include the following characters: upper- and lower-case alphanumeric characters [A-Za-z0-9], and punctuation characters including slash, underscore, hyphen, period [/_-.].
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class LoggingDestinationResponse(dict):
    """
    Configuration of a specific logging destination (the producer project or the consumer project).
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "monitoredResource":
            suggest = "monitored_resource"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LoggingDestinationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LoggingDestinationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LoggingDestinationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 logs: Sequence[str],
                 monitored_resource: str):
        """
        Configuration of a specific logging destination (the producer project or the consumer project).
        :param Sequence[str] logs: Names of the logs to be sent to this destination. Each name must be defined in the Service.logs section. If the log name is not a domain scoped name, it will be automatically prefixed with the service name followed by "/".
        :param str monitored_resource: The monitored resource type. The type must be defined in the Service.monitored_resources section.
        """
        pulumi.set(__self__, "logs", logs)
        pulumi.set(__self__, "monitored_resource", monitored_resource)

    @property
    @pulumi.getter
    def logs(self) -> Sequence[str]:
        """
        Names of the logs to be sent to this destination. Each name must be defined in the Service.logs section. If the log name is not a domain scoped name, it will be automatically prefixed with the service name followed by "/".
        """
        return pulumi.get(self, "logs")

    @property
    @pulumi.getter(name="monitoredResource")
    def monitored_resource(self) -> str:
        """
        The monitored resource type. The type must be defined in the Service.monitored_resources section.
        """
        return pulumi.get(self, "monitored_resource")


@pulumi.output_type
class LoggingResponse(dict):
    """
    Logging configuration of the service. The following example shows how to configure logs to be sent to the producer and consumer projects. In the example, the `activity_history` log is sent to both the producer and consumer projects, whereas the `purchase_history` log is only sent to the producer project. monitored_resources: - type: library.googleapis.com/branch labels: - key: /city description: The city where the library branch is located in. - key: /name description: The name of the branch. logs: - name: activity_history labels: - key: /customer_id - name: purchase_history logging: producer_destinations: - monitored_resource: library.googleapis.com/branch logs: - activity_history - purchase_history consumer_destinations: - monitored_resource: library.googleapis.com/branch logs: - activity_history
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "consumerDestinations":
            suggest = "consumer_destinations"
        elif key == "producerDestinations":
            suggest = "producer_destinations"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LoggingResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LoggingResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LoggingResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 consumer_destinations: Sequence['outputs.LoggingDestinationResponse'],
                 producer_destinations: Sequence['outputs.LoggingDestinationResponse']):
        """
        Logging configuration of the service. The following example shows how to configure logs to be sent to the producer and consumer projects. In the example, the `activity_history` log is sent to both the producer and consumer projects, whereas the `purchase_history` log is only sent to the producer project. monitored_resources: - type: library.googleapis.com/branch labels: - key: /city description: The city where the library branch is located in. - key: /name description: The name of the branch. logs: - name: activity_history labels: - key: /customer_id - name: purchase_history logging: producer_destinations: - monitored_resource: library.googleapis.com/branch logs: - activity_history - purchase_history consumer_destinations: - monitored_resource: library.googleapis.com/branch logs: - activity_history
        :param Sequence['LoggingDestinationResponse'] consumer_destinations: Logging configurations for sending logs to the consumer project. There can be multiple consumer destinations, each one must have a different monitored resource type. A log can be used in at most one consumer destination.
        :param Sequence['LoggingDestinationResponse'] producer_destinations: Logging configurations for sending logs to the producer project. There can be multiple producer destinations, each one must have a different monitored resource type. A log can be used in at most one producer destination.
        """
        pulumi.set(__self__, "consumer_destinations", consumer_destinations)
        pulumi.set(__self__, "producer_destinations", producer_destinations)

    @property
    @pulumi.getter(name="consumerDestinations")
    def consumer_destinations(self) -> Sequence['outputs.LoggingDestinationResponse']:
        """
        Logging configurations for sending logs to the consumer project. There can be multiple consumer destinations, each one must have a different monitored resource type. A log can be used in at most one consumer destination.
        """
        return pulumi.get(self, "consumer_destinations")

    @property
    @pulumi.getter(name="producerDestinations")
    def producer_destinations(self) -> Sequence['outputs.LoggingDestinationResponse']:
        """
        Logging configurations for sending logs to the producer project. There can be multiple producer destinations, each one must have a different monitored resource type. A log can be used in at most one producer destination.
        """
        return pulumi.get(self, "producer_destinations")


@pulumi.output_type
class MethodResponse(dict):
    """
    Method represents a method of an API interface.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "requestStreaming":
            suggest = "request_streaming"
        elif key == "requestTypeUrl":
            suggest = "request_type_url"
        elif key == "responseStreaming":
            suggest = "response_streaming"
        elif key == "responseTypeUrl":
            suggest = "response_type_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MethodResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MethodResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MethodResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 options: Sequence['outputs.OptionResponse'],
                 request_streaming: bool,
                 request_type_url: str,
                 response_streaming: bool,
                 response_type_url: str,
                 syntax: str):
        """
        Method represents a method of an API interface.
        :param str name: The simple name of this method.
        :param Sequence['OptionResponse'] options: Any metadata attached to the method.
        :param bool request_streaming: If true, the request is streamed.
        :param str request_type_url: A URL of the input message type.
        :param bool response_streaming: If true, the response is streamed.
        :param str response_type_url: The URL of the output message type.
        :param str syntax: The source syntax of this method.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "options", options)
        pulumi.set(__self__, "request_streaming", request_streaming)
        pulumi.set(__self__, "request_type_url", request_type_url)
        pulumi.set(__self__, "response_streaming", response_streaming)
        pulumi.set(__self__, "response_type_url", response_type_url)
        pulumi.set(__self__, "syntax", syntax)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The simple name of this method.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def options(self) -> Sequence['outputs.OptionResponse']:
        """
        Any metadata attached to the method.
        """
        return pulumi.get(self, "options")

    @property
    @pulumi.getter(name="requestStreaming")
    def request_streaming(self) -> bool:
        """
        If true, the request is streamed.
        """
        return pulumi.get(self, "request_streaming")

    @property
    @pulumi.getter(name="requestTypeUrl")
    def request_type_url(self) -> str:
        """
        A URL of the input message type.
        """
        return pulumi.get(self, "request_type_url")

    @property
    @pulumi.getter(name="responseStreaming")
    def response_streaming(self) -> bool:
        """
        If true, the response is streamed.
        """
        return pulumi.get(self, "response_streaming")

    @property
    @pulumi.getter(name="responseTypeUrl")
    def response_type_url(self) -> str:
        """
        The URL of the output message type.
        """
        return pulumi.get(self, "response_type_url")

    @property
    @pulumi.getter
    def syntax(self) -> str:
        """
        The source syntax of this method.
        """
        return pulumi.get(self, "syntax")


@pulumi.output_type
class MetricDescriptorMetadataResponse(dict):
    """
    Additional annotations that can be used to guide the usage of a metric.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ingestDelay":
            suggest = "ingest_delay"
        elif key == "launchStage":
            suggest = "launch_stage"
        elif key == "samplePeriod":
            suggest = "sample_period"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MetricDescriptorMetadataResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MetricDescriptorMetadataResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MetricDescriptorMetadataResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ingest_delay: str,
                 launch_stage: str,
                 sample_period: str):
        """
        Additional annotations that can be used to guide the usage of a metric.
        :param str ingest_delay: The delay of data points caused by ingestion. Data points older than this age are guaranteed to be ingested and available to be read, excluding data loss due to errors.
        :param str launch_stage: Deprecated. Must use the MetricDescriptor.launch_stage instead.
        :param str sample_period: The sampling period of metric data points. For metrics which are written periodically, consecutive data points are stored at this time interval, excluding data loss due to errors. Metrics with a higher granularity have a smaller sampling period.
        """
        pulumi.set(__self__, "ingest_delay", ingest_delay)
        pulumi.set(__self__, "launch_stage", launch_stage)
        pulumi.set(__self__, "sample_period", sample_period)

    @property
    @pulumi.getter(name="ingestDelay")
    def ingest_delay(self) -> str:
        """
        The delay of data points caused by ingestion. Data points older than this age are guaranteed to be ingested and available to be read, excluding data loss due to errors.
        """
        return pulumi.get(self, "ingest_delay")

    @property
    @pulumi.getter(name="launchStage")
    def launch_stage(self) -> str:
        """
        Deprecated. Must use the MetricDescriptor.launch_stage instead.
        """
        return pulumi.get(self, "launch_stage")

    @property
    @pulumi.getter(name="samplePeriod")
    def sample_period(self) -> str:
        """
        The sampling period of metric data points. For metrics which are written periodically, consecutive data points are stored at this time interval, excluding data loss due to errors. Metrics with a higher granularity have a smaller sampling period.
        """
        return pulumi.get(self, "sample_period")


@pulumi.output_type
class MetricDescriptorResponse(dict):
    """
    Defines a metric type and its schema. Once a metric descriptor is created, deleting or altering it stops data collection and makes the metric type's existing data unusable. 
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "displayName":
            suggest = "display_name"
        elif key == "launchStage":
            suggest = "launch_stage"
        elif key == "metricKind":
            suggest = "metric_kind"
        elif key == "monitoredResourceTypes":
            suggest = "monitored_resource_types"
        elif key == "valueType":
            suggest = "value_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MetricDescriptorResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MetricDescriptorResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MetricDescriptorResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 description: str,
                 display_name: str,
                 labels: Sequence['outputs.LabelDescriptorResponse'],
                 launch_stage: str,
                 metadata: 'outputs.MetricDescriptorMetadataResponse',
                 metric_kind: str,
                 monitored_resource_types: Sequence[str],
                 name: str,
                 type: str,
                 unit: str,
                 value_type: str):
        """
        Defines a metric type and its schema. Once a metric descriptor is created, deleting or altering it stops data collection and makes the metric type's existing data unusable. 
        :param str description: A detailed description of the metric, which can be used in documentation.
        :param str display_name: A concise name for the metric, which can be displayed in user interfaces. Use sentence case without an ending period, for example "Request count". This field is optional but it is recommended to be set for any metrics associated with user-visible concepts, such as Quota.
        :param Sequence['LabelDescriptorResponse'] labels: The set of labels that can be used to describe a specific instance of this metric type. For example, the `appengine.googleapis.com/http/server/response_latencies` metric type has a label for the HTTP response code, `response_code`, so you can look at latencies for successful responses or just for responses that failed.
        :param str launch_stage: Optional. The launch stage of the metric definition.
        :param 'MetricDescriptorMetadataResponse' metadata: Optional. Metadata which can be used to guide usage of the metric.
        :param str metric_kind: Whether the metric records instantaneous values, changes to a value, etc. Some combinations of `metric_kind` and `value_type` might not be supported.
        :param Sequence[str] monitored_resource_types: Read-only. If present, then a time series, which is identified partially by a metric type and a MonitoredResourceDescriptor, that is associated with this metric type can only be associated with one of the monitored resource types listed here.
        :param str name: The resource name of the metric descriptor.
        :param str type: The metric type, including its DNS name prefix. The type is not URL-encoded. All user-defined metric types have the DNS name `custom.googleapis.com` or `external.googleapis.com`. Metric types should use a natural hierarchical grouping. For example: "custom.googleapis.com/invoice/paid/amount" "external.googleapis.com/prometheus/up" "appengine.googleapis.com/http/server/response_latencies"
        :param str unit: The units in which the metric value is reported. It is only applicable if the `value_type` is `INT64`, `DOUBLE`, or `DISTRIBUTION`. The `unit` defines the representation of the stored metric values. Different systems might scale the values to be more easily displayed (so a value of `0.02kBy` _might_ be displayed as `20By`, and a value of `3523kBy` _might_ be displayed as `3.5MBy`). However, if the `unit` is `kBy`, then the value of the metric is always in thousands of bytes, no matter how it might be displayed. If you want a custom metric to record the exact number of CPU-seconds used by a job, you can create an `INT64 CUMULATIVE` metric whose `unit` is `s{CPU}` (or equivalently `1s{CPU}` or just `s`). If the job uses 12,005 CPU-seconds, then the value is written as `12005`. Alternatively, if you want a custom metric to record data in a more granular way, you can create a `DOUBLE CUMULATIVE` metric whose `unit` is `ks{CPU}`, and then write the value `12.005` (which is `12005/1000`), or use `Kis{CPU}` and write `11.723` (which is `12005/1024`). The supported units are a subset of [The Unified Code for Units of Measure](https://unitsofmeasure.org/ucum.html) standard: **Basic units (UNIT)** * `bit` bit * `By` byte * `s` second * `min` minute * `h` hour * `d` day * `1` dimensionless **Prefixes (PREFIX)** * `k` kilo (10^3) * `M` mega (10^6) * `G` giga (10^9) * `T` tera (10^12) * `P` peta (10^15) * `E` exa (10^18) * `Z` zetta (10^21) * `Y` yotta (10^24) * `m` milli (10^-3) * `u` micro (10^-6) * `n` nano (10^-9) * `p` pico (10^-12) * `f` femto (10^-15) * `a` atto (10^-18) * `z` zepto (10^-21) * `y` yocto (10^-24) * `Ki` kibi (2^10) * `Mi` mebi (2^20) * `Gi` gibi (2^30) * `Ti` tebi (2^40) * `Pi` pebi (2^50) **Grammar** The grammar also includes these connectors: * `/` division or ratio (as an infix operator). For examples, `kBy/{email}` or `MiBy/10ms` (although you should almost never have `/s` in a metric `unit`; rates should always be computed at query time from the underlying cumulative or delta value). * `.` multiplication or composition (as an infix operator). For examples, `GBy.d` or `k{watt}.h`. The grammar for a unit is as follows: Expression = Component { "." Component } { "/" Component } ; Component = ( [ PREFIX ] UNIT | "%" ) [ Annotation ] | Annotation | "1" ; Annotation = "{" NAME "}" ; Notes: * `Annotation` is just a comment if it follows a `UNIT`. If the annotation is used alone, then the unit is equivalent to `1`. For examples, `{request}/s == 1/s`, `By{transmitted}/s == By/s`. * `NAME` is a sequence of non-blank printable ASCII characters not containing `{` or `}`. * `1` represents a unitary [dimensionless unit](https://en.wikipedia.org/wiki/Dimensionless_quantity) of 1, such as in `1/s`. It is typically used when none of the basic units are appropriate. For example, "new users per day" can be represented as `1/d` or `{new-users}/d` (and a metric value `5` would mean "5 new users). Alternatively, "thousands of page views per day" would be represented as `1000/d` or `k1/d` or `k{page_views}/d` (and a metric value of `5.3` would mean "5300 page views per day"). * `%` represents dimensionless value of 1/100, and annotates values giving a percentage (so the metric values are typically in the range of 0..100, and a metric value `3` means "3 percent"). * `10^2.%` indicates a metric contains a ratio, typically in the range 0..1, that will be multiplied by 100 and displayed as a percentage (so a metric value `0.03` means "3 percent").
        :param str value_type: Whether the measurement is an integer, a floating-point number, etc. Some combinations of `metric_kind` and `value_type` might not be supported.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "labels", labels)
        pulumi.set(__self__, "launch_stage", launch_stage)
        pulumi.set(__self__, "metadata", metadata)
        pulumi.set(__self__, "metric_kind", metric_kind)
        pulumi.set(__self__, "monitored_resource_types", monitored_resource_types)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "unit", unit)
        pulumi.set(__self__, "value_type", value_type)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        A detailed description of the metric, which can be used in documentation.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        A concise name for the metric, which can be displayed in user interfaces. Use sentence case without an ending period, for example "Request count". This field is optional but it is recommended to be set for any metrics associated with user-visible concepts, such as Quota.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def labels(self) -> Sequence['outputs.LabelDescriptorResponse']:
        """
        The set of labels that can be used to describe a specific instance of this metric type. For example, the `appengine.googleapis.com/http/server/response_latencies` metric type has a label for the HTTP response code, `response_code`, so you can look at latencies for successful responses or just for responses that failed.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter(name="launchStage")
    def launch_stage(self) -> str:
        """
        Optional. The launch stage of the metric definition.
        """
        return pulumi.get(self, "launch_stage")

    @property
    @pulumi.getter
    def metadata(self) -> 'outputs.MetricDescriptorMetadataResponse':
        """
        Optional. Metadata which can be used to guide usage of the metric.
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter(name="metricKind")
    def metric_kind(self) -> str:
        """
        Whether the metric records instantaneous values, changes to a value, etc. Some combinations of `metric_kind` and `value_type` might not be supported.
        """
        return pulumi.get(self, "metric_kind")

    @property
    @pulumi.getter(name="monitoredResourceTypes")
    def monitored_resource_types(self) -> Sequence[str]:
        """
        Read-only. If present, then a time series, which is identified partially by a metric type and a MonitoredResourceDescriptor, that is associated with this metric type can only be associated with one of the monitored resource types listed here.
        """
        return pulumi.get(self, "monitored_resource_types")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The resource name of the metric descriptor.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The metric type, including its DNS name prefix. The type is not URL-encoded. All user-defined metric types have the DNS name `custom.googleapis.com` or `external.googleapis.com`. Metric types should use a natural hierarchical grouping. For example: "custom.googleapis.com/invoice/paid/amount" "external.googleapis.com/prometheus/up" "appengine.googleapis.com/http/server/response_latencies"
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def unit(self) -> str:
        """
        The units in which the metric value is reported. It is only applicable if the `value_type` is `INT64`, `DOUBLE`, or `DISTRIBUTION`. The `unit` defines the representation of the stored metric values. Different systems might scale the values to be more easily displayed (so a value of `0.02kBy` _might_ be displayed as `20By`, and a value of `3523kBy` _might_ be displayed as `3.5MBy`). However, if the `unit` is `kBy`, then the value of the metric is always in thousands of bytes, no matter how it might be displayed. If you want a custom metric to record the exact number of CPU-seconds used by a job, you can create an `INT64 CUMULATIVE` metric whose `unit` is `s{CPU}` (or equivalently `1s{CPU}` or just `s`). If the job uses 12,005 CPU-seconds, then the value is written as `12005`. Alternatively, if you want a custom metric to record data in a more granular way, you can create a `DOUBLE CUMULATIVE` metric whose `unit` is `ks{CPU}`, and then write the value `12.005` (which is `12005/1000`), or use `Kis{CPU}` and write `11.723` (which is `12005/1024`). The supported units are a subset of [The Unified Code for Units of Measure](https://unitsofmeasure.org/ucum.html) standard: **Basic units (UNIT)** * `bit` bit * `By` byte * `s` second * `min` minute * `h` hour * `d` day * `1` dimensionless **Prefixes (PREFIX)** * `k` kilo (10^3) * `M` mega (10^6) * `G` giga (10^9) * `T` tera (10^12) * `P` peta (10^15) * `E` exa (10^18) * `Z` zetta (10^21) * `Y` yotta (10^24) * `m` milli (10^-3) * `u` micro (10^-6) * `n` nano (10^-9) * `p` pico (10^-12) * `f` femto (10^-15) * `a` atto (10^-18) * `z` zepto (10^-21) * `y` yocto (10^-24) * `Ki` kibi (2^10) * `Mi` mebi (2^20) * `Gi` gibi (2^30) * `Ti` tebi (2^40) * `Pi` pebi (2^50) **Grammar** The grammar also includes these connectors: * `/` division or ratio (as an infix operator). For examples, `kBy/{email}` or `MiBy/10ms` (although you should almost never have `/s` in a metric `unit`; rates should always be computed at query time from the underlying cumulative or delta value). * `.` multiplication or composition (as an infix operator). For examples, `GBy.d` or `k{watt}.h`. The grammar for a unit is as follows: Expression = Component { "." Component } { "/" Component } ; Component = ( [ PREFIX ] UNIT | "%" ) [ Annotation ] | Annotation | "1" ; Annotation = "{" NAME "}" ; Notes: * `Annotation` is just a comment if it follows a `UNIT`. If the annotation is used alone, then the unit is equivalent to `1`. For examples, `{request}/s == 1/s`, `By{transmitted}/s == By/s`. * `NAME` is a sequence of non-blank printable ASCII characters not containing `{` or `}`. * `1` represents a unitary [dimensionless unit](https://en.wikipedia.org/wiki/Dimensionless_quantity) of 1, such as in `1/s`. It is typically used when none of the basic units are appropriate. For example, "new users per day" can be represented as `1/d` or `{new-users}/d` (and a metric value `5` would mean "5 new users). Alternatively, "thousands of page views per day" would be represented as `1000/d` or `k1/d` or `k{page_views}/d` (and a metric value of `5.3` would mean "5300 page views per day"). * `%` represents dimensionless value of 1/100, and annotates values giving a percentage (so the metric values are typically in the range of 0..100, and a metric value `3` means "3 percent"). * `10^2.%` indicates a metric contains a ratio, typically in the range 0..1, that will be multiplied by 100 and displayed as a percentage (so a metric value `0.03` means "3 percent").
        """
        return pulumi.get(self, "unit")

    @property
    @pulumi.getter(name="valueType")
    def value_type(self) -> str:
        """
        Whether the measurement is an integer, a floating-point number, etc. Some combinations of `metric_kind` and `value_type` might not be supported.
        """
        return pulumi.get(self, "value_type")


@pulumi.output_type
class MetricRuleResponse(dict):
    """
    Bind API methods to metrics. Binding a method to a metric causes that metric's configured quota behaviors to apply to the method call.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "metricCosts":
            suggest = "metric_costs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MetricRuleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MetricRuleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MetricRuleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 metric_costs: Mapping[str, str],
                 selector: str):
        """
        Bind API methods to metrics. Binding a method to a metric causes that metric's configured quota behaviors to apply to the method call.
        :param Mapping[str, str] metric_costs: Metrics to update when the selected methods are called, and the associated cost applied to each metric. The key of the map is the metric name, and the values are the amount increased for the metric against which the quota limits are defined. The value must not be negative.
        :param str selector: Selects the methods to which this rule applies. Refer to selector for syntax details.
        """
        pulumi.set(__self__, "metric_costs", metric_costs)
        pulumi.set(__self__, "selector", selector)

    @property
    @pulumi.getter(name="metricCosts")
    def metric_costs(self) -> Mapping[str, str]:
        """
        Metrics to update when the selected methods are called, and the associated cost applied to each metric. The key of the map is the metric name, and the values are the amount increased for the metric against which the quota limits are defined. The value must not be negative.
        """
        return pulumi.get(self, "metric_costs")

    @property
    @pulumi.getter
    def selector(self) -> str:
        """
        Selects the methods to which this rule applies. Refer to selector for syntax details.
        """
        return pulumi.get(self, "selector")


@pulumi.output_type
class MixinResponse(dict):
    """
    Declares an API Interface to be included in this interface. The including interface must redeclare all the methods from the included interface, but documentation and options are inherited as follows: - If after comment and whitespace stripping, the documentation string of the redeclared method is empty, it will be inherited from the original method. - Each annotation belonging to the service config (http, visibility) which is not set in the redeclared method will be inherited. - If an http annotation is inherited, the path pattern will be modified as follows. Any version prefix will be replaced by the version of the including interface plus the root path if specified. Example of a simple mixin: package google.acl.v1; service AccessControl { // Get the underlying ACL object. rpc GetAcl(GetAclRequest) returns (Acl) { option (google.api.http).get = "/v1/{resource=**}:getAcl"; } } package google.storage.v2; service Storage { // rpc GetAcl(GetAclRequest) returns (Acl); // Get a data record. rpc GetData(GetDataRequest) returns (Data) { option (google.api.http).get = "/v2/{resource=**}"; } } Example of a mixin configuration: apis: - name: google.storage.v2.Storage mixins: - name: google.acl.v1.AccessControl The mixin construct implies that all methods in `AccessControl` are also declared with same name and request/response types in `Storage`. A documentation generator or annotation processor will see the effective `Storage.GetAcl` method after inheriting documentation and annotations as follows: service Storage { // Get the underlying ACL object. rpc GetAcl(GetAclRequest) returns (Acl) { option (google.api.http).get = "/v2/{resource=**}:getAcl"; } ... } Note how the version in the path pattern changed from `v1` to `v2`. If the `root` field in the mixin is specified, it should be a relative path under which inherited HTTP paths are placed. Example: apis: - name: google.storage.v2.Storage mixins: - name: google.acl.v1.AccessControl root: acls This implies the following inherited HTTP annotation: service Storage { // Get the underlying ACL object. rpc GetAcl(GetAclRequest) returns (Acl) { option (google.api.http).get = "/v2/acls/{resource=**}:getAcl"; } ... }
    """
    def __init__(__self__, *,
                 name: str,
                 root: str):
        """
        Declares an API Interface to be included in this interface. The including interface must redeclare all the methods from the included interface, but documentation and options are inherited as follows: - If after comment and whitespace stripping, the documentation string of the redeclared method is empty, it will be inherited from the original method. - Each annotation belonging to the service config (http, visibility) which is not set in the redeclared method will be inherited. - If an http annotation is inherited, the path pattern will be modified as follows. Any version prefix will be replaced by the version of the including interface plus the root path if specified. Example of a simple mixin: package google.acl.v1; service AccessControl { // Get the underlying ACL object. rpc GetAcl(GetAclRequest) returns (Acl) { option (google.api.http).get = "/v1/{resource=**}:getAcl"; } } package google.storage.v2; service Storage { // rpc GetAcl(GetAclRequest) returns (Acl); // Get a data record. rpc GetData(GetDataRequest) returns (Data) { option (google.api.http).get = "/v2/{resource=**}"; } } Example of a mixin configuration: apis: - name: google.storage.v2.Storage mixins: - name: google.acl.v1.AccessControl The mixin construct implies that all methods in `AccessControl` are also declared with same name and request/response types in `Storage`. A documentation generator or annotation processor will see the effective `Storage.GetAcl` method after inheriting documentation and annotations as follows: service Storage { // Get the underlying ACL object. rpc GetAcl(GetAclRequest) returns (Acl) { option (google.api.http).get = "/v2/{resource=**}:getAcl"; } ... } Note how the version in the path pattern changed from `v1` to `v2`. If the `root` field in the mixin is specified, it should be a relative path under which inherited HTTP paths are placed. Example: apis: - name: google.storage.v2.Storage mixins: - name: google.acl.v1.AccessControl root: acls This implies the following inherited HTTP annotation: service Storage { // Get the underlying ACL object. rpc GetAcl(GetAclRequest) returns (Acl) { option (google.api.http).get = "/v2/acls/{resource=**}:getAcl"; } ... }
        :param str name: The fully qualified name of the interface which is included.
        :param str root: If non-empty specifies a path under which inherited HTTP paths are rooted.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "root", root)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The fully qualified name of the interface which is included.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def root(self) -> str:
        """
        If non-empty specifies a path under which inherited HTTP paths are rooted.
        """
        return pulumi.get(self, "root")


@pulumi.output_type
class MonitoredResourceDescriptorResponse(dict):
    """
    An object that describes the schema of a MonitoredResource object using a type name and a set of labels. For example, the monitored resource descriptor for Google Compute Engine VM instances has a type of `"gce_instance"` and specifies the use of the labels `"instance_id"` and `"zone"` to identify particular VM instances. Different APIs can support different monitored resource types. APIs generally provide a `list` method that returns the monitored resource descriptors used by the API. 
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "displayName":
            suggest = "display_name"
        elif key == "launchStage":
            suggest = "launch_stage"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MonitoredResourceDescriptorResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MonitoredResourceDescriptorResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MonitoredResourceDescriptorResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 description: str,
                 display_name: str,
                 labels: Sequence['outputs.LabelDescriptorResponse'],
                 launch_stage: str,
                 name: str,
                 type: str):
        """
        An object that describes the schema of a MonitoredResource object using a type name and a set of labels. For example, the monitored resource descriptor for Google Compute Engine VM instances has a type of `"gce_instance"` and specifies the use of the labels `"instance_id"` and `"zone"` to identify particular VM instances. Different APIs can support different monitored resource types. APIs generally provide a `list` method that returns the monitored resource descriptors used by the API. 
        :param str description: Optional. A detailed description of the monitored resource type that might be used in documentation.
        :param str display_name: Optional. A concise name for the monitored resource type that might be displayed in user interfaces. It should be a Title Cased Noun Phrase, without any article or other determiners. For example, `"Google Cloud SQL Database"`.
        :param Sequence['LabelDescriptorResponse'] labels: A set of labels used to describe instances of this monitored resource type. For example, an individual Google Cloud SQL database is identified by values for the labels `"database_id"` and `"zone"`.
        :param str launch_stage: Optional. The launch stage of the monitored resource definition.
        :param str name: Optional. The resource name of the monitored resource descriptor: `"projects/{project_id}/monitoredResourceDescriptors/{type}"` where {type} is the value of the `type` field in this object and {project_id} is a project ID that provides API-specific context for accessing the type. APIs that do not use project information can use the resource name format `"monitoredResourceDescriptors/{type}"`.
        :param str type: The monitored resource type. For example, the type `"cloudsql_database"` represents databases in Google Cloud SQL. For a list of types, see [Monitoring resource types](https://cloud.google.com/monitoring/api/resources) and [Logging resource types](https://cloud.google.com/logging/docs/api/v2/resource-list).
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "labels", labels)
        pulumi.set(__self__, "launch_stage", launch_stage)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Optional. A detailed description of the monitored resource type that might be used in documentation.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        Optional. A concise name for the monitored resource type that might be displayed in user interfaces. It should be a Title Cased Noun Phrase, without any article or other determiners. For example, `"Google Cloud SQL Database"`.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def labels(self) -> Sequence['outputs.LabelDescriptorResponse']:
        """
        A set of labels used to describe instances of this monitored resource type. For example, an individual Google Cloud SQL database is identified by values for the labels `"database_id"` and `"zone"`.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter(name="launchStage")
    def launch_stage(self) -> str:
        """
        Optional. The launch stage of the monitored resource definition.
        """
        return pulumi.get(self, "launch_stage")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Optional. The resource name of the monitored resource descriptor: `"projects/{project_id}/monitoredResourceDescriptors/{type}"` where {type} is the value of the `type` field in this object and {project_id} is a project ID that provides API-specific context for accessing the type. APIs that do not use project information can use the resource name format `"monitoredResourceDescriptors/{type}"`.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The monitored resource type. For example, the type `"cloudsql_database"` represents databases in Google Cloud SQL. For a list of types, see [Monitoring resource types](https://cloud.google.com/monitoring/api/resources) and [Logging resource types](https://cloud.google.com/logging/docs/api/v2/resource-list).
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class MonitoringDestinationResponse(dict):
    """
    Configuration of a specific monitoring destination (the producer project or the consumer project).
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "monitoredResource":
            suggest = "monitored_resource"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MonitoringDestinationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MonitoringDestinationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MonitoringDestinationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 metrics: Sequence[str],
                 monitored_resource: str):
        """
        Configuration of a specific monitoring destination (the producer project or the consumer project).
        :param Sequence[str] metrics: Types of the metrics to report to this monitoring destination. Each type must be defined in Service.metrics section.
        :param str monitored_resource: The monitored resource type. The type must be defined in Service.monitored_resources section.
        """
        pulumi.set(__self__, "metrics", metrics)
        pulumi.set(__self__, "monitored_resource", monitored_resource)

    @property
    @pulumi.getter
    def metrics(self) -> Sequence[str]:
        """
        Types of the metrics to report to this monitoring destination. Each type must be defined in Service.metrics section.
        """
        return pulumi.get(self, "metrics")

    @property
    @pulumi.getter(name="monitoredResource")
    def monitored_resource(self) -> str:
        """
        The monitored resource type. The type must be defined in Service.monitored_resources section.
        """
        return pulumi.get(self, "monitored_resource")


@pulumi.output_type
class MonitoringResponse(dict):
    """
    Monitoring configuration of the service. The example below shows how to configure monitored resources and metrics for monitoring. In the example, a monitored resource and two metrics are defined. The `library.googleapis.com/book/returned_count` metric is sent to both producer and consumer projects, whereas the `library.googleapis.com/book/num_overdue` metric is only sent to the consumer project. monitored_resources: - type: library.googleapis.com/Branch display_name: "Library Branch" description: "A branch of a library." launch_stage: GA labels: - key: resource_container description: "The Cloud container (ie. project id) for the Branch." - key: location description: "The location of the library branch." - key: branch_id description: "The id of the branch." metrics: - name: library.googleapis.com/book/returned_count display_name: "Books Returned" description: "The count of books that have been returned." launch_stage: GA metric_kind: DELTA value_type: INT64 unit: "1" labels: - key: customer_id description: "The id of the customer." - name: library.googleapis.com/book/num_overdue display_name: "Books Overdue" description: "The current number of overdue books." launch_stage: GA metric_kind: GAUGE value_type: INT64 unit: "1" labels: - key: customer_id description: "The id of the customer." monitoring: producer_destinations: - monitored_resource: library.googleapis.com/Branch metrics: - library.googleapis.com/book/returned_count consumer_destinations: - monitored_resource: library.googleapis.com/Branch metrics: - library.googleapis.com/book/returned_count - library.googleapis.com/book/num_overdue
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "consumerDestinations":
            suggest = "consumer_destinations"
        elif key == "producerDestinations":
            suggest = "producer_destinations"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MonitoringResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MonitoringResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MonitoringResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 consumer_destinations: Sequence['outputs.MonitoringDestinationResponse'],
                 producer_destinations: Sequence['outputs.MonitoringDestinationResponse']):
        """
        Monitoring configuration of the service. The example below shows how to configure monitored resources and metrics for monitoring. In the example, a monitored resource and two metrics are defined. The `library.googleapis.com/book/returned_count` metric is sent to both producer and consumer projects, whereas the `library.googleapis.com/book/num_overdue` metric is only sent to the consumer project. monitored_resources: - type: library.googleapis.com/Branch display_name: "Library Branch" description: "A branch of a library." launch_stage: GA labels: - key: resource_container description: "The Cloud container (ie. project id) for the Branch." - key: location description: "The location of the library branch." - key: branch_id description: "The id of the branch." metrics: - name: library.googleapis.com/book/returned_count display_name: "Books Returned" description: "The count of books that have been returned." launch_stage: GA metric_kind: DELTA value_type: INT64 unit: "1" labels: - key: customer_id description: "The id of the customer." - name: library.googleapis.com/book/num_overdue display_name: "Books Overdue" description: "The current number of overdue books." launch_stage: GA metric_kind: GAUGE value_type: INT64 unit: "1" labels: - key: customer_id description: "The id of the customer." monitoring: producer_destinations: - monitored_resource: library.googleapis.com/Branch metrics: - library.googleapis.com/book/returned_count consumer_destinations: - monitored_resource: library.googleapis.com/Branch metrics: - library.googleapis.com/book/returned_count - library.googleapis.com/book/num_overdue
        :param Sequence['MonitoringDestinationResponse'] consumer_destinations: Monitoring configurations for sending metrics to the consumer project. There can be multiple consumer destinations. A monitored resource type may appear in multiple monitoring destinations if different aggregations are needed for different sets of metrics associated with that monitored resource type. A monitored resource and metric pair may only be used once in the Monitoring configuration.
        :param Sequence['MonitoringDestinationResponse'] producer_destinations: Monitoring configurations for sending metrics to the producer project. There can be multiple producer destinations. A monitored resource type may appear in multiple monitoring destinations if different aggregations are needed for different sets of metrics associated with that monitored resource type. A monitored resource and metric pair may only be used once in the Monitoring configuration.
        """
        pulumi.set(__self__, "consumer_destinations", consumer_destinations)
        pulumi.set(__self__, "producer_destinations", producer_destinations)

    @property
    @pulumi.getter(name="consumerDestinations")
    def consumer_destinations(self) -> Sequence['outputs.MonitoringDestinationResponse']:
        """
        Monitoring configurations for sending metrics to the consumer project. There can be multiple consumer destinations. A monitored resource type may appear in multiple monitoring destinations if different aggregations are needed for different sets of metrics associated with that monitored resource type. A monitored resource and metric pair may only be used once in the Monitoring configuration.
        """
        return pulumi.get(self, "consumer_destinations")

    @property
    @pulumi.getter(name="producerDestinations")
    def producer_destinations(self) -> Sequence['outputs.MonitoringDestinationResponse']:
        """
        Monitoring configurations for sending metrics to the producer project. There can be multiple producer destinations. A monitored resource type may appear in multiple monitoring destinations if different aggregations are needed for different sets of metrics associated with that monitored resource type. A monitored resource and metric pair may only be used once in the Monitoring configuration.
        """
        return pulumi.get(self, "producer_destinations")


@pulumi.output_type
class OAuthRequirementsResponse(dict):
    """
    OAuth scopes are a way to define data and permissions on data. For example, there are scopes defined for "Read-only access to Google Calendar" and "Access to Cloud Platform". Users can consent to a scope for an application, giving it permission to access that data on their behalf. OAuth scope specifications should be fairly coarse grained; a user will need to see and understand the text description of what your scope means. In most cases: use one or at most two OAuth scopes for an entire family of products. If your product has multiple APIs, you should probably be sharing the OAuth scope across all of those APIs. When you need finer grained OAuth consent screens: talk with your product management about how developers will use them in practice. Please note that even though each of the canonical scopes is enough for a request to be accepted and passed to the backend, a request can still fail due to the backend requiring additional scopes or permissions.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "canonicalScopes":
            suggest = "canonical_scopes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OAuthRequirementsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OAuthRequirementsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OAuthRequirementsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 canonical_scopes: str):
        """
        OAuth scopes are a way to define data and permissions on data. For example, there are scopes defined for "Read-only access to Google Calendar" and "Access to Cloud Platform". Users can consent to a scope for an application, giving it permission to access that data on their behalf. OAuth scope specifications should be fairly coarse grained; a user will need to see and understand the text description of what your scope means. In most cases: use one or at most two OAuth scopes for an entire family of products. If your product has multiple APIs, you should probably be sharing the OAuth scope across all of those APIs. When you need finer grained OAuth consent screens: talk with your product management about how developers will use them in practice. Please note that even though each of the canonical scopes is enough for a request to be accepted and passed to the backend, a request can still fail due to the backend requiring additional scopes or permissions.
        :param str canonical_scopes: The list of publicly documented OAuth scopes that are allowed access. An OAuth token containing any of these scopes will be accepted. Example: canonical_scopes: https://www.googleapis.com/auth/calendar, https://www.googleapis.com/auth/calendar.read
        """
        pulumi.set(__self__, "canonical_scopes", canonical_scopes)

    @property
    @pulumi.getter(name="canonicalScopes")
    def canonical_scopes(self) -> str:
        """
        The list of publicly documented OAuth scopes that are allowed access. An OAuth token containing any of these scopes will be accepted. Example: canonical_scopes: https://www.googleapis.com/auth/calendar, https://www.googleapis.com/auth/calendar.read
        """
        return pulumi.get(self, "canonical_scopes")


@pulumi.output_type
class OptionResponse(dict):
    """
    A protocol buffer option, which can be attached to a message, field, enumeration, etc.
    """
    def __init__(__self__, *,
                 name: str,
                 value: Mapping[str, str]):
        """
        A protocol buffer option, which can be attached to a message, field, enumeration, etc.
        :param str name: The option's name. For protobuf built-in options (options defined in descriptor.proto), this is the short name. For example, `"map_entry"`. For custom options, it should be the fully-qualified name. For example, `"google.api.http"`.
        :param Mapping[str, str] value: The option's value packed in an Any message. If the value is a primitive, the corresponding wrapper type defined in google/protobuf/wrappers.proto should be used. If the value is an enum, it should be stored as an int32 value using the google.protobuf.Int32Value type.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The option's name. For protobuf built-in options (options defined in descriptor.proto), this is the short name. For example, `"map_entry"`. For custom options, it should be the fully-qualified name. For example, `"google.api.http"`.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> Mapping[str, str]:
        """
        The option's value packed in an Any message. If the value is a primitive, the corresponding wrapper type defined in google/protobuf/wrappers.proto should be used. If the value is an enum, it should be stored as an int32 value using the google.protobuf.Int32Value type.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class PageResponse(dict):
    """
    Represents a documentation page. A page can contain subpages to represent nested documentation set structure.
    """
    def __init__(__self__, *,
                 content: str,
                 name: str,
                 subpages: Sequence['outputs.PageResponse']):
        """
        Represents a documentation page. A page can contain subpages to represent nested documentation set structure.
        :param str content: The Markdown content of the page. You can use (== include {path} ==) to include content from a Markdown file. The content can be used to produce the documentation page such as HTML format page.
        :param str name: The name of the page. It will be used as an identity of the page to generate URI of the page, text of the link to this page in navigation, etc. The full page name (start from the root page name to this page concatenated with `.`) can be used as reference to the page in your documentation. For example: pages: - name: Tutorial content: (== include tutorial.md ==) subpages: - name: Java content: (== include tutorial_java.md ==) You can reference `Java` page using Markdown reference link syntax: `Java`.
        :param Sequence['PageResponse'] subpages: Subpages of this page. The order of subpages specified here will be honored in the generated docset.
        """
        pulumi.set(__self__, "content", content)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "subpages", subpages)

    @property
    @pulumi.getter
    def content(self) -> str:
        """
        The Markdown content of the page. You can use (== include {path} ==) to include content from a Markdown file. The content can be used to produce the documentation page such as HTML format page.
        """
        return pulumi.get(self, "content")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the page. It will be used as an identity of the page to generate URI of the page, text of the link to this page in navigation, etc. The full page name (start from the root page name to this page concatenated with `.`) can be used as reference to the page in your documentation. For example: pages: - name: Tutorial content: (== include tutorial.md ==) subpages: - name: Java content: (== include tutorial_java.md ==) You can reference `Java` page using Markdown reference link syntax: `Java`.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def subpages(self) -> Sequence['outputs.PageResponse']:
        """
        Subpages of this page. The order of subpages specified here will be honored in the generated docset.
        """
        return pulumi.get(self, "subpages")


@pulumi.output_type
class QuotaLimitResponse(dict):
    """
    `QuotaLimit` defines a specific limit that applies over a specified duration for a limit type. There can be at most one limit for a duration and limit type combination defined within a `QuotaGroup`.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultLimit":
            suggest = "default_limit"
        elif key == "displayName":
            suggest = "display_name"
        elif key == "freeTier":
            suggest = "free_tier"
        elif key == "maxLimit":
            suggest = "max_limit"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in QuotaLimitResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        QuotaLimitResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        QuotaLimitResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 default_limit: str,
                 description: str,
                 display_name: str,
                 duration: str,
                 free_tier: str,
                 max_limit: str,
                 metric: str,
                 name: str,
                 unit: str,
                 values: Mapping[str, str]):
        """
        `QuotaLimit` defines a specific limit that applies over a specified duration for a limit type. There can be at most one limit for a duration and limit type combination defined within a `QuotaGroup`.
        :param str default_limit: Default number of tokens that can be consumed during the specified duration. This is the number of tokens assigned when a client application developer activates the service for his/her project. Specifying a value of 0 will block all requests. This can be used if you are provisioning quota to selected consumers and blocking others. Similarly, a value of -1 will indicate an unlimited quota. No other negative values are allowed. Used by group-based quotas only.
        :param str description: Optional. User-visible, extended description for this quota limit. Should be used only when more context is needed to understand this limit than provided by the limit's display name (see: `display_name`).
        :param str display_name: User-visible display name for this limit. Optional. If not set, the UI will provide a default display name based on the quota configuration. This field can be used to override the default display name generated from the configuration.
        :param str duration: Duration of this limit in textual notation. Must be "100s" or "1d". Used by group-based quotas only.
        :param str free_tier: Free tier value displayed in the Developers Console for this limit. The free tier is the number of tokens that will be subtracted from the billed amount when billing is enabled. This field can only be set on a limit with duration "1d", in a billable group; it is invalid on any other limit. If this field is not set, it defaults to 0, indicating that there is no free tier for this service. Used by group-based quotas only.
        :param str max_limit: Maximum number of tokens that can be consumed during the specified duration. Client application developers can override the default limit up to this maximum. If specified, this value cannot be set to a value less than the default limit. If not specified, it is set to the default limit. To allow clients to apply overrides with no upper bound, set this to -1, indicating unlimited maximum quota. Used by group-based quotas only.
        :param str metric: The name of the metric this quota limit applies to. The quota limits with the same metric will be checked together during runtime. The metric must be defined within the service config.
        :param str name: Name of the quota limit. The name must be provided, and it must be unique within the service. The name can only include alphanumeric characters as well as '-'. The maximum length of the limit name is 64 characters.
        :param str unit: Specify the unit of the quota limit. It uses the same syntax as Metric.unit. The supported unit kinds are determined by the quota backend system. Here are some examples: * "1/min/{project}" for quota per minute per project. Note: the order of unit components is insignificant. The "1" at the beginning is required to follow the metric unit syntax.
        :param Mapping[str, str] values: Tiered limit values. You must specify this as a key:value pair, with an integer value that is the maximum number of requests allowed for the specified unit. Currently only STANDARD is supported.
        """
        pulumi.set(__self__, "default_limit", default_limit)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "duration", duration)
        pulumi.set(__self__, "free_tier", free_tier)
        pulumi.set(__self__, "max_limit", max_limit)
        pulumi.set(__self__, "metric", metric)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "unit", unit)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter(name="defaultLimit")
    def default_limit(self) -> str:
        """
        Default number of tokens that can be consumed during the specified duration. This is the number of tokens assigned when a client application developer activates the service for his/her project. Specifying a value of 0 will block all requests. This can be used if you are provisioning quota to selected consumers and blocking others. Similarly, a value of -1 will indicate an unlimited quota. No other negative values are allowed. Used by group-based quotas only.
        """
        return pulumi.get(self, "default_limit")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Optional. User-visible, extended description for this quota limit. Should be used only when more context is needed to understand this limit than provided by the limit's display name (see: `display_name`).
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        User-visible display name for this limit. Optional. If not set, the UI will provide a default display name based on the quota configuration. This field can be used to override the default display name generated from the configuration.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def duration(self) -> str:
        """
        Duration of this limit in textual notation. Must be "100s" or "1d". Used by group-based quotas only.
        """
        return pulumi.get(self, "duration")

    @property
    @pulumi.getter(name="freeTier")
    def free_tier(self) -> str:
        """
        Free tier value displayed in the Developers Console for this limit. The free tier is the number of tokens that will be subtracted from the billed amount when billing is enabled. This field can only be set on a limit with duration "1d", in a billable group; it is invalid on any other limit. If this field is not set, it defaults to 0, indicating that there is no free tier for this service. Used by group-based quotas only.
        """
        return pulumi.get(self, "free_tier")

    @property
    @pulumi.getter(name="maxLimit")
    def max_limit(self) -> str:
        """
        Maximum number of tokens that can be consumed during the specified duration. Client application developers can override the default limit up to this maximum. If specified, this value cannot be set to a value less than the default limit. If not specified, it is set to the default limit. To allow clients to apply overrides with no upper bound, set this to -1, indicating unlimited maximum quota. Used by group-based quotas only.
        """
        return pulumi.get(self, "max_limit")

    @property
    @pulumi.getter
    def metric(self) -> str:
        """
        The name of the metric this quota limit applies to. The quota limits with the same metric will be checked together during runtime. The metric must be defined within the service config.
        """
        return pulumi.get(self, "metric")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the quota limit. The name must be provided, and it must be unique within the service. The name can only include alphanumeric characters as well as '-'. The maximum length of the limit name is 64 characters.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def unit(self) -> str:
        """
        Specify the unit of the quota limit. It uses the same syntax as Metric.unit. The supported unit kinds are determined by the quota backend system. Here are some examples: * "1/min/{project}" for quota per minute per project. Note: the order of unit components is insignificant. The "1" at the beginning is required to follow the metric unit syntax.
        """
        return pulumi.get(self, "unit")

    @property
    @pulumi.getter
    def values(self) -> Mapping[str, str]:
        """
        Tiered limit values. You must specify this as a key:value pair, with an integer value that is the maximum number of requests allowed for the specified unit. Currently only STANDARD is supported.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class QuotaResponse(dict):
    """
    Quota configuration helps to achieve fairness and budgeting in service usage. The metric based quota configuration works this way: - The service configuration defines a set of metrics. - For API calls, the quota.metric_rules maps methods to metrics with corresponding costs. - The quota.limits defines limits on the metrics, which will be used for quota checks at runtime. An example quota configuration in yaml format: quota: limits: - name: apiWriteQpsPerProject metric: library.googleapis.com/write_calls unit: "1/min/{project}" # rate limit for consumer projects values: STANDARD: 10000 # The metric rules bind all methods to the read_calls metric, # except for the UpdateBook and DeleteBook methods. These two methods # are mapped to the write_calls metric, with the UpdateBook method # consuming at twice rate as the DeleteBook method. metric_rules: - selector: "*" metric_costs: library.googleapis.com/read_calls: 1 - selector: google.example.library.v1.LibraryService.UpdateBook metric_costs: library.googleapis.com/write_calls: 2 - selector: google.example.library.v1.LibraryService.DeleteBook metric_costs: library.googleapis.com/write_calls: 1 Corresponding Metric definition: metrics: - name: library.googleapis.com/read_calls display_name: Read requests metric_kind: DELTA value_type: INT64 - name: library.googleapis.com/write_calls display_name: Write requests metric_kind: DELTA value_type: INT64 
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "metricRules":
            suggest = "metric_rules"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in QuotaResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        QuotaResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        QuotaResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 limits: Sequence['outputs.QuotaLimitResponse'],
                 metric_rules: Sequence['outputs.MetricRuleResponse']):
        """
        Quota configuration helps to achieve fairness and budgeting in service usage. The metric based quota configuration works this way: - The service configuration defines a set of metrics. - For API calls, the quota.metric_rules maps methods to metrics with corresponding costs. - The quota.limits defines limits on the metrics, which will be used for quota checks at runtime. An example quota configuration in yaml format: quota: limits: - name: apiWriteQpsPerProject metric: library.googleapis.com/write_calls unit: "1/min/{project}" # rate limit for consumer projects values: STANDARD: 10000 # The metric rules bind all methods to the read_calls metric, # except for the UpdateBook and DeleteBook methods. These two methods # are mapped to the write_calls metric, with the UpdateBook method # consuming at twice rate as the DeleteBook method. metric_rules: - selector: "*" metric_costs: library.googleapis.com/read_calls: 1 - selector: google.example.library.v1.LibraryService.UpdateBook metric_costs: library.googleapis.com/write_calls: 2 - selector: google.example.library.v1.LibraryService.DeleteBook metric_costs: library.googleapis.com/write_calls: 1 Corresponding Metric definition: metrics: - name: library.googleapis.com/read_calls display_name: Read requests metric_kind: DELTA value_type: INT64 - name: library.googleapis.com/write_calls display_name: Write requests metric_kind: DELTA value_type: INT64 
        :param Sequence['QuotaLimitResponse'] limits: List of `QuotaLimit` definitions for the service.
        :param Sequence['MetricRuleResponse'] metric_rules: List of `MetricRule` definitions, each one mapping a selected method to one or more metrics.
        """
        pulumi.set(__self__, "limits", limits)
        pulumi.set(__self__, "metric_rules", metric_rules)

    @property
    @pulumi.getter
    def limits(self) -> Sequence['outputs.QuotaLimitResponse']:
        """
        List of `QuotaLimit` definitions for the service.
        """
        return pulumi.get(self, "limits")

    @property
    @pulumi.getter(name="metricRules")
    def metric_rules(self) -> Sequence['outputs.MetricRuleResponse']:
        """
        List of `MetricRule` definitions, each one mapping a selected method to one or more metrics.
        """
        return pulumi.get(self, "metric_rules")


@pulumi.output_type
class SourceContextResponse(dict):
    """
    `SourceContext` represents information about the source of a protobuf element, like the file in which it is defined.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fileName":
            suggest = "file_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SourceContextResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SourceContextResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SourceContextResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 file_name: str):
        """
        `SourceContext` represents information about the source of a protobuf element, like the file in which it is defined.
        :param str file_name: The path-qualified name of the .proto file that contained the associated protobuf element. For example: `"google/protobuf/source_context.proto"`.
        """
        pulumi.set(__self__, "file_name", file_name)

    @property
    @pulumi.getter(name="fileName")
    def file_name(self) -> str:
        """
        The path-qualified name of the .proto file that contained the associated protobuf element. For example: `"google/protobuf/source_context.proto"`.
        """
        return pulumi.get(self, "file_name")


@pulumi.output_type
class SourceInfoResponse(dict):
    """
    Source information used to create a Service Config
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sourceFiles":
            suggest = "source_files"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SourceInfoResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SourceInfoResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SourceInfoResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 source_files: Sequence[Mapping[str, str]]):
        """
        Source information used to create a Service Config
        :param Sequence[Mapping[str, str]] source_files: All files used during config generation.
        """
        pulumi.set(__self__, "source_files", source_files)

    @property
    @pulumi.getter(name="sourceFiles")
    def source_files(self) -> Sequence[Mapping[str, str]]:
        """
        All files used during config generation.
        """
        return pulumi.get(self, "source_files")


@pulumi.output_type
class SystemParameterResponse(dict):
    """
    Define a parameter's name and location. The parameter may be passed as either an HTTP header or a URL query parameter, and if both are passed the behavior is implementation-dependent.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "httpHeader":
            suggest = "http_header"
        elif key == "urlQueryParameter":
            suggest = "url_query_parameter"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SystemParameterResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SystemParameterResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SystemParameterResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 http_header: str,
                 name: str,
                 url_query_parameter: str):
        """
        Define a parameter's name and location. The parameter may be passed as either an HTTP header or a URL query parameter, and if both are passed the behavior is implementation-dependent.
        :param str http_header: Define the HTTP header name to use for the parameter. It is case insensitive.
        :param str name: Define the name of the parameter, such as "api_key" . It is case sensitive.
        :param str url_query_parameter: Define the URL query parameter name to use for the parameter. It is case sensitive.
        """
        pulumi.set(__self__, "http_header", http_header)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "url_query_parameter", url_query_parameter)

    @property
    @pulumi.getter(name="httpHeader")
    def http_header(self) -> str:
        """
        Define the HTTP header name to use for the parameter. It is case insensitive.
        """
        return pulumi.get(self, "http_header")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Define the name of the parameter, such as "api_key" . It is case sensitive.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="urlQueryParameter")
    def url_query_parameter(self) -> str:
        """
        Define the URL query parameter name to use for the parameter. It is case sensitive.
        """
        return pulumi.get(self, "url_query_parameter")


@pulumi.output_type
class SystemParameterRuleResponse(dict):
    """
    Define a system parameter rule mapping system parameter definitions to methods.
    """
    def __init__(__self__, *,
                 parameters: Sequence['outputs.SystemParameterResponse'],
                 selector: str):
        """
        Define a system parameter rule mapping system parameter definitions to methods.
        :param Sequence['SystemParameterResponse'] parameters: Define parameters. Multiple names may be defined for a parameter. For a given method call, only one of them should be used. If multiple names are used the behavior is implementation-dependent. If none of the specified names are present the behavior is parameter-dependent.
        :param str selector: Selects the methods to which this rule applies. Use '*' to indicate all methods in all APIs. Refer to selector for syntax details.
        """
        pulumi.set(__self__, "parameters", parameters)
        pulumi.set(__self__, "selector", selector)

    @property
    @pulumi.getter
    def parameters(self) -> Sequence['outputs.SystemParameterResponse']:
        """
        Define parameters. Multiple names may be defined for a parameter. For a given method call, only one of them should be used. If multiple names are used the behavior is implementation-dependent. If none of the specified names are present the behavior is parameter-dependent.
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter
    def selector(self) -> str:
        """
        Selects the methods to which this rule applies. Use '*' to indicate all methods in all APIs. Refer to selector for syntax details.
        """
        return pulumi.get(self, "selector")


@pulumi.output_type
class SystemParametersResponse(dict):
    """
    ### System parameter configuration A system parameter is a special kind of parameter defined by the API system, not by an individual API. It is typically mapped to an HTTP header and/or a URL query parameter. This configuration specifies which methods change the names of the system parameters.
    """
    def __init__(__self__, *,
                 rules: Sequence['outputs.SystemParameterRuleResponse']):
        """
        ### System parameter configuration A system parameter is a special kind of parameter defined by the API system, not by an individual API. It is typically mapped to an HTTP header and/or a URL query parameter. This configuration specifies which methods change the names of the system parameters.
        :param Sequence['SystemParameterRuleResponse'] rules: Define system parameters. The parameters defined here will override the default parameters implemented by the system. If this field is missing from the service config, default system parameters will be used. Default system parameters and names is implementation-dependent. Example: define api key for all methods system_parameters rules: - selector: "*" parameters: - name: api_key url_query_parameter: api_key Example: define 2 api key names for a specific method. system_parameters rules: - selector: "/ListShelves" parameters: - name: api_key http_header: Api-Key1 - name: api_key http_header: Api-Key2 **NOTE:** All service configuration rules follow "last one wins" order.
        """
        pulumi.set(__self__, "rules", rules)

    @property
    @pulumi.getter
    def rules(self) -> Sequence['outputs.SystemParameterRuleResponse']:
        """
        Define system parameters. The parameters defined here will override the default parameters implemented by the system. If this field is missing from the service config, default system parameters will be used. Default system parameters and names is implementation-dependent. Example: define api key for all methods system_parameters rules: - selector: "*" parameters: - name: api_key url_query_parameter: api_key Example: define 2 api key names for a specific method. system_parameters rules: - selector: "/ListShelves" parameters: - name: api_key http_header: Api-Key1 - name: api_key http_header: Api-Key2 **NOTE:** All service configuration rules follow "last one wins" order.
        """
        return pulumi.get(self, "rules")


@pulumi.output_type
class TrafficPercentStrategyResponse(dict):
    """
    Strategy that specifies how clients of Google Service Controller want to send traffic to use different config versions. This is generally used by API proxy to split traffic based on your configured percentage for each config version. One example of how to gradually rollout a new service configuration using this strategy: Day 1 Rollout { id: "example.googleapis.com/rollout_20160206" traffic_percent_strategy { percentages: { "example.googleapis.com/20160201": 70.00 "example.googleapis.com/20160206": 30.00 } } } Day 2 Rollout { id: "example.googleapis.com/rollout_20160207" traffic_percent_strategy: { percentages: { "example.googleapis.com/20160206": 100.00 } } }
    """
    def __init__(__self__, *,
                 percentages: Mapping[str, str]):
        """
        Strategy that specifies how clients of Google Service Controller want to send traffic to use different config versions. This is generally used by API proxy to split traffic based on your configured percentage for each config version. One example of how to gradually rollout a new service configuration using this strategy: Day 1 Rollout { id: "example.googleapis.com/rollout_20160206" traffic_percent_strategy { percentages: { "example.googleapis.com/20160201": 70.00 "example.googleapis.com/20160206": 30.00 } } } Day 2 Rollout { id: "example.googleapis.com/rollout_20160207" traffic_percent_strategy: { percentages: { "example.googleapis.com/20160206": 100.00 } } }
        :param Mapping[str, str] percentages: Maps service configuration IDs to their corresponding traffic percentage. Key is the service configuration ID, Value is the traffic percentage which must be greater than 0.0 and the sum must equal to 100.0.
        """
        pulumi.set(__self__, "percentages", percentages)

    @property
    @pulumi.getter
    def percentages(self) -> Mapping[str, str]:
        """
        Maps service configuration IDs to their corresponding traffic percentage. Key is the service configuration ID, Value is the traffic percentage which must be greater than 0.0 and the sum must equal to 100.0.
        """
        return pulumi.get(self, "percentages")


@pulumi.output_type
class TypeResponse(dict):
    """
    A protocol buffer message type.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sourceContext":
            suggest = "source_context"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TypeResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TypeResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TypeResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 fields: Sequence['outputs.FieldResponse'],
                 name: str,
                 oneofs: Sequence[str],
                 options: Sequence['outputs.OptionResponse'],
                 source_context: 'outputs.SourceContextResponse',
                 syntax: str):
        """
        A protocol buffer message type.
        :param Sequence['FieldResponse'] fields: The list of fields.
        :param str name: The fully qualified message name.
        :param Sequence[str] oneofs: The list of types appearing in `oneof` definitions in this type.
        :param Sequence['OptionResponse'] options: The protocol buffer options.
        :param 'SourceContextResponse' source_context: The source context.
        :param str syntax: The source syntax.
        """
        pulumi.set(__self__, "fields", fields)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "oneofs", oneofs)
        pulumi.set(__self__, "options", options)
        pulumi.set(__self__, "source_context", source_context)
        pulumi.set(__self__, "syntax", syntax)

    @property
    @pulumi.getter
    def fields(self) -> Sequence['outputs.FieldResponse']:
        """
        The list of fields.
        """
        return pulumi.get(self, "fields")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The fully qualified message name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def oneofs(self) -> Sequence[str]:
        """
        The list of types appearing in `oneof` definitions in this type.
        """
        return pulumi.get(self, "oneofs")

    @property
    @pulumi.getter
    def options(self) -> Sequence['outputs.OptionResponse']:
        """
        The protocol buffer options.
        """
        return pulumi.get(self, "options")

    @property
    @pulumi.getter(name="sourceContext")
    def source_context(self) -> 'outputs.SourceContextResponse':
        """
        The source context.
        """
        return pulumi.get(self, "source_context")

    @property
    @pulumi.getter
    def syntax(self) -> str:
        """
        The source syntax.
        """
        return pulumi.get(self, "syntax")


@pulumi.output_type
class UsageResponse(dict):
    """
    Configuration controlling usage of a service.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "producerNotificationChannel":
            suggest = "producer_notification_channel"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UsageResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UsageResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UsageResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 producer_notification_channel: str,
                 requirements: Sequence[str],
                 rules: Sequence['outputs.UsageRuleResponse']):
        """
        Configuration controlling usage of a service.
        :param str producer_notification_channel: The full resource name of a channel used for sending notifications to the service producer. Google Service Management currently only supports [Google Cloud Pub/Sub](https://cloud.google.com/pubsub) as a notification channel. To use Google Cloud Pub/Sub as the channel, this must be the name of a Cloud Pub/Sub topic that uses the Cloud Pub/Sub topic name format documented in https://cloud.google.com/pubsub/docs/overview.
        :param Sequence[str] requirements: Requirements that must be satisfied before a consumer project can use the service. Each requirement is of the form /; for example 'serviceusage.googleapis.com/billing-enabled'. For Google APIs, a Terms of Service requirement must be included here. Google Cloud APIs must include "serviceusage.googleapis.com/tos/cloud". Other Google APIs should include "serviceusage.googleapis.com/tos/universal". Additional ToS can be included based on the business needs.
        :param Sequence['UsageRuleResponse'] rules: A list of usage rules that apply to individual API methods. **NOTE:** All service configuration rules follow "last one wins" order.
        """
        pulumi.set(__self__, "producer_notification_channel", producer_notification_channel)
        pulumi.set(__self__, "requirements", requirements)
        pulumi.set(__self__, "rules", rules)

    @property
    @pulumi.getter(name="producerNotificationChannel")
    def producer_notification_channel(self) -> str:
        """
        The full resource name of a channel used for sending notifications to the service producer. Google Service Management currently only supports [Google Cloud Pub/Sub](https://cloud.google.com/pubsub) as a notification channel. To use Google Cloud Pub/Sub as the channel, this must be the name of a Cloud Pub/Sub topic that uses the Cloud Pub/Sub topic name format documented in https://cloud.google.com/pubsub/docs/overview.
        """
        return pulumi.get(self, "producer_notification_channel")

    @property
    @pulumi.getter
    def requirements(self) -> Sequence[str]:
        """
        Requirements that must be satisfied before a consumer project can use the service. Each requirement is of the form /; for example 'serviceusage.googleapis.com/billing-enabled'. For Google APIs, a Terms of Service requirement must be included here. Google Cloud APIs must include "serviceusage.googleapis.com/tos/cloud". Other Google APIs should include "serviceusage.googleapis.com/tos/universal". Additional ToS can be included based on the business needs.
        """
        return pulumi.get(self, "requirements")

    @property
    @pulumi.getter
    def rules(self) -> Sequence['outputs.UsageRuleResponse']:
        """
        A list of usage rules that apply to individual API methods. **NOTE:** All service configuration rules follow "last one wins" order.
        """
        return pulumi.get(self, "rules")


@pulumi.output_type
class UsageRuleResponse(dict):
    """
    Usage configuration rules for the service. NOTE: Under development. Use this rule to configure unregistered calls for the service. Unregistered calls are calls that do not contain consumer project identity. (Example: calls that do not contain an API key). By default, API methods do not allow unregistered calls, and each method call must be identified by a consumer project identity. Use this rule to allow/disallow unregistered calls. Example of an API that wants to allow unregistered calls for entire service. usage: rules: - selector: "*" allow_unregistered_calls: true Example of a method that wants to allow unregistered calls. usage: rules: - selector: "google.example.library.v1.LibraryService.CreateBook" allow_unregistered_calls: true
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowUnregisteredCalls":
            suggest = "allow_unregistered_calls"
        elif key == "skipServiceControl":
            suggest = "skip_service_control"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UsageRuleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UsageRuleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UsageRuleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allow_unregistered_calls: bool,
                 selector: str,
                 skip_service_control: bool):
        """
        Usage configuration rules for the service. NOTE: Under development. Use this rule to configure unregistered calls for the service. Unregistered calls are calls that do not contain consumer project identity. (Example: calls that do not contain an API key). By default, API methods do not allow unregistered calls, and each method call must be identified by a consumer project identity. Use this rule to allow/disallow unregistered calls. Example of an API that wants to allow unregistered calls for entire service. usage: rules: - selector: "*" allow_unregistered_calls: true Example of a method that wants to allow unregistered calls. usage: rules: - selector: "google.example.library.v1.LibraryService.CreateBook" allow_unregistered_calls: true
        :param bool allow_unregistered_calls: If true, the selected method allows unregistered calls, e.g. calls that don't identify any user or application.
        :param str selector: Selects the methods to which this rule applies. Use '*' to indicate all methods in all APIs. Refer to selector for syntax details.
        :param bool skip_service_control: If true, the selected method should skip service control and the control plane features, such as quota and billing, will not be available. This flag is used by Google Cloud Endpoints to bypass checks for internal methods, such as service health check methods.
        """
        pulumi.set(__self__, "allow_unregistered_calls", allow_unregistered_calls)
        pulumi.set(__self__, "selector", selector)
        pulumi.set(__self__, "skip_service_control", skip_service_control)

    @property
    @pulumi.getter(name="allowUnregisteredCalls")
    def allow_unregistered_calls(self) -> bool:
        """
        If true, the selected method allows unregistered calls, e.g. calls that don't identify any user or application.
        """
        return pulumi.get(self, "allow_unregistered_calls")

    @property
    @pulumi.getter
    def selector(self) -> str:
        """
        Selects the methods to which this rule applies. Use '*' to indicate all methods in all APIs. Refer to selector for syntax details.
        """
        return pulumi.get(self, "selector")

    @property
    @pulumi.getter(name="skipServiceControl")
    def skip_service_control(self) -> bool:
        """
        If true, the selected method should skip service control and the control plane features, such as quota and billing, will not be available. This flag is used by Google Cloud Endpoints to bypass checks for internal methods, such as service health check methods.
        """
        return pulumi.get(self, "skip_service_control")


