# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

from enum import Enum

__all__ = [
    'AptRepositoryArchiveType',
    'AptSettingsType',
    'ExecStepConfigInterpreter',
    'PackageDesiredState',
    'PackageManager',
    'PatchConfigRebootConfig',
    'PatchRolloutMode',
    'RecurringScheduleFrequency',
    'SoftwareRecipeDesiredState',
    'SoftwareRecipeStepExtractArchiveType',
    'SoftwareRecipeStepRunScriptInterpreter',
    'WeekDayOfMonthDayOfWeek',
    'WeeklyScheduleDayOfWeek',
    'WindowsUpdateSettingsClassificationsItem',
]


class AptRepositoryArchiveType(str, Enum):
    """
    Type of archive files in this repository. The default behavior is DEB.
    """
    ARCHIVE_TYPE_UNSPECIFIED = "ARCHIVE_TYPE_UNSPECIFIED"
    """
    Unspecified.
    """
    DEB = "DEB"
    """
    DEB indicates that the archive contains binary files.
    """
    DEB_SRC = "DEB_SRC"
    """
    DEB_SRC indicates that the archive contains source files.
    """


class AptSettingsType(str, Enum):
    """
    By changing the type to DIST, the patching is performed using `apt-get dist-upgrade` instead.
    """
    TYPE_UNSPECIFIED = "TYPE_UNSPECIFIED"
    """
    By default, upgrade will be performed.
    """
    DIST = "DIST"
    """
    Runs `apt-get dist-upgrade`.
    """
    UPGRADE = "UPGRADE"
    """
    Runs `apt-get upgrade`.
    """


class ExecStepConfigInterpreter(str, Enum):
    """
    The script interpreter to use to run the script. If no interpreter is specified the script will be executed directly, which will likely only succeed for scripts with [shebang lines] (https://en.wikipedia.org/wiki/Shebang_\\(Unix\\)).
    """
    INTERPRETER_UNSPECIFIED = "INTERPRETER_UNSPECIFIED"
    """
    If the interpreter is not specified, the value defaults to `NONE`.
    """
    NONE = "NONE"
    """
    Indicates that the file is run as follows on each operating system: + For Linux VMs, the file is ran as an executable and the interpreter might be parsed from the [shebang line](https://wikipedia.org/wiki/Shebang_(Unix)) of the file. + For Windows VM, this value is not supported.
    """
    SHELL = "SHELL"
    """
    Indicates that the file is run with `/bin/sh` on Linux and `cmd` on Windows.
    """
    POWERSHELL = "POWERSHELL"
    """
    Indicates that the file is run with PowerShell.
    """


class PackageDesiredState(str, Enum):
    """
    The desired_state the agent should maintain for this package. The default is to ensure the package is installed.
    """
    DESIRED_STATE_UNSPECIFIED = "DESIRED_STATE_UNSPECIFIED"
    """
    The default is to ensure the package is installed.
    """
    INSTALLED = "INSTALLED"
    """
    The agent ensures that the package is installed.
    """
    UPDATED = "UPDATED"
    """
    The agent ensures that the package is installed and periodically checks for and install any updates.
    """
    REMOVED = "REMOVED"
    """
    The agent ensures that the package is not installed and uninstall it if detected.
    """


class PackageManager(str, Enum):
    """
    Type of package manager that can be used to install this package. If a system does not have the package manager, the package is not installed or removed no error message is returned. By default, or if you specify `ANY`, the agent attempts to install and remove this package using the default package manager. This is useful when creating a policy that applies to different types of systems. The default behavior is ANY.
    """
    MANAGER_UNSPECIFIED = "MANAGER_UNSPECIFIED"
    """
    The default behavior is ANY.
    """
    ANY = "ANY"
    """
    Apply this package config using the default system package manager.
    """
    APT = "APT"
    """
    Apply this package config only if Apt is available on the system.
    """
    YUM = "YUM"
    """
    Apply this package config only if Yum is available on the system.
    """
    ZYPPER = "ZYPPER"
    """
    Apply this package config only if Zypper is available on the system.
    """
    GOO = "GOO"
    """
    Apply this package config only if GooGet is available on the system.
    """


class PatchConfigRebootConfig(str, Enum):
    """
    Post-patch reboot settings.
    """
    REBOOT_CONFIG_UNSPECIFIED = "REBOOT_CONFIG_UNSPECIFIED"
    """
    The default behavior is DEFAULT.
    """
    DEFAULT = "DEFAULT"
    """
    The agent decides if a reboot is necessary by checking signals such as registry keys on Windows or `/var/run/reboot-required` on APT based systems. On RPM based systems, a set of core system package install times are compared with system boot time.
    """
    ALWAYS = "ALWAYS"
    """
    Always reboot the machine after the update completes.
    """
    NEVER = "NEVER"
    """
    Never reboot the machine after the update completes.
    """


class PatchRolloutMode(str, Enum):
    """
    Mode of the patch rollout.
    """
    MODE_UNSPECIFIED = "MODE_UNSPECIFIED"
    """
    Mode must be specified.
    """
    ZONE_BY_ZONE = "ZONE_BY_ZONE"
    """
    Patches are applied one zone at a time. The patch job begins in the region with the lowest number of targeted VMs. Within the region, patching begins in the zone with the lowest number of targeted VMs. If multiple regions (or zones within a region) have the same number of targeted VMs, a tie-breaker is achieved by sorting the regions or zones in alphabetical order.
    """
    CONCURRENT_ZONES = "CONCURRENT_ZONES"
    """
    Patches are applied to VMs in all zones at the same time.
    """


class RecurringScheduleFrequency(str, Enum):
    """
    Required. The frequency unit of this recurring schedule.
    """
    FREQUENCY_UNSPECIFIED = "FREQUENCY_UNSPECIFIED"
    """
    Invalid. A frequency must be specified.
    """
    WEEKLY = "WEEKLY"
    """
    Indicates that the frequency of recurrence should be expressed in terms of weeks.
    """
    MONTHLY = "MONTHLY"
    """
    Indicates that the frequency of recurrence should be expressed in terms of months.
    """
    DAILY = "DAILY"
    """
    Indicates that the frequency of recurrence should be expressed in terms of days.
    """


class SoftwareRecipeDesiredState(str, Enum):
    """
    Default is INSTALLED. The desired state the agent should maintain for this recipe. INSTALLED: The software recipe is installed on the instance but won't be updated to new versions. UPDATED: The software recipe is installed on the instance. The recipe is updated to a higher version, if a higher version of the recipe is assigned to this instance. REMOVE: Remove is unsupported for software recipes and attempts to create or update a recipe to the REMOVE state is rejected.
    """
    DESIRED_STATE_UNSPECIFIED = "DESIRED_STATE_UNSPECIFIED"
    """
    The default is to ensure the package is installed.
    """
    INSTALLED = "INSTALLED"
    """
    The agent ensures that the package is installed.
    """
    UPDATED = "UPDATED"
    """
    The agent ensures that the package is installed and periodically checks for and install any updates.
    """
    REMOVED = "REMOVED"
    """
    The agent ensures that the package is not installed and uninstall it if detected.
    """


class SoftwareRecipeStepExtractArchiveType(str, Enum):
    """
    Required. The type of the archive to extract.
    """
    ARCHIVE_TYPE_UNSPECIFIED = "ARCHIVE_TYPE_UNSPECIFIED"
    """
    Indicates that the archive type isn't specified.
    """
    TAR = "TAR"
    """
    Indicates that the archive is a tar archive with no encryption.
    """
    TAR_GZIP = "TAR_GZIP"
    """
    Indicates that the archive is a tar archive with gzip encryption.
    """
    TAR_BZIP = "TAR_BZIP"
    """
    Indicates that the archive is a tar archive with bzip encryption.
    """
    TAR_LZMA = "TAR_LZMA"
    """
    Indicates that the archive is a tar archive with lzma encryption.
    """
    TAR_XZ = "TAR_XZ"
    """
    Indicates that the archive is a tar archive with xz encryption.
    """
    ZIP = "ZIP"
    """
    Indicates that the archive is a zip archive.
    """


class SoftwareRecipeStepRunScriptInterpreter(str, Enum):
    """
    The script interpreter to use to run the script. If no interpreter is specified the script is executed directly, which likely only succeed for scripts with [shebang lines](https://en.wikipedia.org/wiki/Shebang_\\(Unix\\)).
    """
    INTERPRETER_UNSPECIFIED = "INTERPRETER_UNSPECIFIED"
    """
    Default value for ScriptType.
    """
    SHELL = "SHELL"
    """
    Indicates that the script is run with `/bin/sh` on Linux and `cmd` on windows.
    """
    POWERSHELL = "POWERSHELL"
    """
    Indicates that the script is run with powershell.
    """


class WeekDayOfMonthDayOfWeek(str, Enum):
    """
    Required. A day of the week.
    """
    DAY_OF_WEEK_UNSPECIFIED = "DAY_OF_WEEK_UNSPECIFIED"
    """
    The day of the week is unspecified.
    """
    MONDAY = "MONDAY"
    """
    Monday
    """
    TUESDAY = "TUESDAY"
    """
    Tuesday
    """
    WEDNESDAY = "WEDNESDAY"
    """
    Wednesday
    """
    THURSDAY = "THURSDAY"
    """
    Thursday
    """
    FRIDAY = "FRIDAY"
    """
    Friday
    """
    SATURDAY = "SATURDAY"
    """
    Saturday
    """
    SUNDAY = "SUNDAY"
    """
    Sunday
    """


class WeeklyScheduleDayOfWeek(str, Enum):
    """
    Required. Day of the week.
    """
    DAY_OF_WEEK_UNSPECIFIED = "DAY_OF_WEEK_UNSPECIFIED"
    """
    The day of the week is unspecified.
    """
    MONDAY = "MONDAY"
    """
    Monday
    """
    TUESDAY = "TUESDAY"
    """
    Tuesday
    """
    WEDNESDAY = "WEDNESDAY"
    """
    Wednesday
    """
    THURSDAY = "THURSDAY"
    """
    Thursday
    """
    FRIDAY = "FRIDAY"
    """
    Friday
    """
    SATURDAY = "SATURDAY"
    """
    Saturday
    """
    SUNDAY = "SUNDAY"
    """
    Sunday
    """


class WindowsUpdateSettingsClassificationsItem(str, Enum):
    CLASSIFICATION_UNSPECIFIED = "CLASSIFICATION_UNSPECIFIED"
    """
    Invalid. If classifications are included, they must be specified.
    """
    CRITICAL = "CRITICAL"
    """
    "A widely released fix for a specific problem that addresses a critical, non-security-related bug." [1]
    """
    SECURITY = "SECURITY"
    """
    "A widely released fix for a product-specific, security-related vulnerability. Security vulnerabilities are rated by their severity. The severity rating is indicated in the Microsoft security bulletin as critical, important, moderate, or low." [1]
    """
    DEFINITION = "DEFINITION"
    """
    "A widely released and frequent software update that contains additions to a product's definition database. Definition databases are often used to detect objects that have specific attributes, such as malicious code, phishing websites, or junk mail." [1]
    """
    DRIVER = "DRIVER"
    """
    "Software that controls the input and output of a device." [1]
    """
    FEATURE_PACK = "FEATURE_PACK"
    """
    "New product functionality that is first distributed outside the context of a product release and that is typically included in the next full product release." [1]
    """
    SERVICE_PACK = "SERVICE_PACK"
    """
    "A tested, cumulative set of all hotfixes, security updates, critical updates, and updates. Additionally, service packs may contain additional fixes for problems that are found internally since the release of the product. Service packs my also contain a limited number of customer-requested design changes or features." [1]
    """
    TOOL = "TOOL"
    """
    "A utility or feature that helps complete a task or set of tasks." [1]
    """
    UPDATE_ROLLUP = "UPDATE_ROLLUP"
    """
    "A tested, cumulative set of hotfixes, security updates, critical updates, and updates that are packaged together for easy deployment. A rollup generally targets a specific area, such as security, or a component of a product, such as Internet Information Services (IIS)." [1]
    """
    UPDATE = "UPDATE"
    """
    "A widely released fix for a specific problem. An update addresses a noncritical, non-security-related bug." [1]
    """
