# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'FixedOrPercentResponse',
    'OSPolicyAssignmentInstanceFilterInventoryResponse',
    'OSPolicyAssignmentInstanceFilterResponse',
    'OSPolicyAssignmentLabelSetResponse',
    'OSPolicyAssignmentRolloutResponse',
    'OSPolicyInventoryFilterResponse',
    'OSPolicyOSFilterResponse',
    'OSPolicyResourceExecResourceExecResponse',
    'OSPolicyResourceExecResourceResponse',
    'OSPolicyResourceFileGcsResponse',
    'OSPolicyResourceFileRemoteResponse',
    'OSPolicyResourceFileResourceResponse',
    'OSPolicyResourceFileResponse',
    'OSPolicyResourceGroupResponse',
    'OSPolicyResourcePackageResourceAPTResponse',
    'OSPolicyResourcePackageResourceDebResponse',
    'OSPolicyResourcePackageResourceGooGetResponse',
    'OSPolicyResourcePackageResourceMSIResponse',
    'OSPolicyResourcePackageResourceRPMResponse',
    'OSPolicyResourcePackageResourceResponse',
    'OSPolicyResourcePackageResourceYUMResponse',
    'OSPolicyResourcePackageResourceZypperResponse',
    'OSPolicyResourceRepositoryResourceAptRepositoryResponse',
    'OSPolicyResourceRepositoryResourceGooRepositoryResponse',
    'OSPolicyResourceRepositoryResourceResponse',
    'OSPolicyResourceRepositoryResourceYumRepositoryResponse',
    'OSPolicyResourceRepositoryResourceZypperRepositoryResponse',
    'OSPolicyResourceResponse',
    'OSPolicyResponse',
]

@pulumi.output_type
class FixedOrPercentResponse(dict):
    """
    Message encapsulating a value that can be either absolute ("fixed") or relative ("percent") to a value.
    """
    def __init__(__self__, *,
                 fixed: int,
                 percent: int):
        """
        Message encapsulating a value that can be either absolute ("fixed") or relative ("percent") to a value.
        :param int fixed: Specifies a fixed value.
        :param int percent: Specifies the relative value defined as a percentage, which will be multiplied by a reference value.
        """
        pulumi.set(__self__, "fixed", fixed)
        pulumi.set(__self__, "percent", percent)

    @property
    @pulumi.getter
    def fixed(self) -> int:
        """
        Specifies a fixed value.
        """
        return pulumi.get(self, "fixed")

    @property
    @pulumi.getter
    def percent(self) -> int:
        """
        Specifies the relative value defined as a percentage, which will be multiplied by a reference value.
        """
        return pulumi.get(self, "percent")


@pulumi.output_type
class OSPolicyAssignmentInstanceFilterInventoryResponse(dict):
    """
    VM inventory details.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "osShortName":
            suggest = "os_short_name"
        elif key == "osVersion":
            suggest = "os_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OSPolicyAssignmentInstanceFilterInventoryResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OSPolicyAssignmentInstanceFilterInventoryResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OSPolicyAssignmentInstanceFilterInventoryResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 os_short_name: str,
                 os_version: str):
        """
        VM inventory details.
        :param str os_short_name: The OS short name
        :param str os_version: The OS version Prefix matches are supported if asterisk(*) is provided as the last character. For example, to match all versions with a major version of `7`, specify the following value for this field `7.*` An empty string matches all OS versions.
        """
        pulumi.set(__self__, "os_short_name", os_short_name)
        pulumi.set(__self__, "os_version", os_version)

    @property
    @pulumi.getter(name="osShortName")
    def os_short_name(self) -> str:
        """
        The OS short name
        """
        return pulumi.get(self, "os_short_name")

    @property
    @pulumi.getter(name="osVersion")
    def os_version(self) -> str:
        """
        The OS version Prefix matches are supported if asterisk(*) is provided as the last character. For example, to match all versions with a major version of `7`, specify the following value for this field `7.*` An empty string matches all OS versions.
        """
        return pulumi.get(self, "os_version")


@pulumi.output_type
class OSPolicyAssignmentInstanceFilterResponse(dict):
    """
    Filters to select target VMs for an assignment. If more than one filter criteria is specified below, a VM will be selected if and only if it satisfies all of them.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "exclusionLabels":
            suggest = "exclusion_labels"
        elif key == "inclusionLabels":
            suggest = "inclusion_labels"
        elif key == "osShortNames":
            suggest = "os_short_names"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OSPolicyAssignmentInstanceFilterResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OSPolicyAssignmentInstanceFilterResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OSPolicyAssignmentInstanceFilterResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 all: bool,
                 exclusion_labels: Sequence['outputs.OSPolicyAssignmentLabelSetResponse'],
                 inclusion_labels: Sequence['outputs.OSPolicyAssignmentLabelSetResponse'],
                 inventories: Sequence['outputs.OSPolicyAssignmentInstanceFilterInventoryResponse'],
                 os_short_names: Sequence[str]):
        """
        Filters to select target VMs for an assignment. If more than one filter criteria is specified below, a VM will be selected if and only if it satisfies all of them.
        :param bool all: Target all VMs in the project. If true, no other criteria is permitted.
        :param Sequence['OSPolicyAssignmentLabelSetResponse'] exclusion_labels: List of label sets used for VM exclusion. If the list has more than one label set, the VM is excluded if any of the label sets are applicable for the VM.
        :param Sequence['OSPolicyAssignmentLabelSetResponse'] inclusion_labels: List of label sets used for VM inclusion. If the list has more than one `LabelSet`, the VM is included if any of the label sets are applicable for the VM.
        :param Sequence['OSPolicyAssignmentInstanceFilterInventoryResponse'] inventories: List of inventories to select VMs. A VM is selected if its inventory data matches at least one of the following inventories.
        :param Sequence[str] os_short_names: Deprecated. Use the `inventories` field instead. A VM is selected if it's OS short name matches with any of the values provided in this list.
        """
        pulumi.set(__self__, "all", all)
        pulumi.set(__self__, "exclusion_labels", exclusion_labels)
        pulumi.set(__self__, "inclusion_labels", inclusion_labels)
        pulumi.set(__self__, "inventories", inventories)
        pulumi.set(__self__, "os_short_names", os_short_names)

    @property
    @pulumi.getter
    def all(self) -> bool:
        """
        Target all VMs in the project. If true, no other criteria is permitted.
        """
        return pulumi.get(self, "all")

    @property
    @pulumi.getter(name="exclusionLabels")
    def exclusion_labels(self) -> Sequence['outputs.OSPolicyAssignmentLabelSetResponse']:
        """
        List of label sets used for VM exclusion. If the list has more than one label set, the VM is excluded if any of the label sets are applicable for the VM.
        """
        return pulumi.get(self, "exclusion_labels")

    @property
    @pulumi.getter(name="inclusionLabels")
    def inclusion_labels(self) -> Sequence['outputs.OSPolicyAssignmentLabelSetResponse']:
        """
        List of label sets used for VM inclusion. If the list has more than one `LabelSet`, the VM is included if any of the label sets are applicable for the VM.
        """
        return pulumi.get(self, "inclusion_labels")

    @property
    @pulumi.getter
    def inventories(self) -> Sequence['outputs.OSPolicyAssignmentInstanceFilterInventoryResponse']:
        """
        List of inventories to select VMs. A VM is selected if its inventory data matches at least one of the following inventories.
        """
        return pulumi.get(self, "inventories")

    @property
    @pulumi.getter(name="osShortNames")
    def os_short_names(self) -> Sequence[str]:
        """
        Deprecated. Use the `inventories` field instead. A VM is selected if it's OS short name matches with any of the values provided in this list.
        """
        return pulumi.get(self, "os_short_names")


@pulumi.output_type
class OSPolicyAssignmentLabelSetResponse(dict):
    """
    Message representing label set. * A label is a key value pair set for a VM. * A LabelSet is a set of labels. * Labels within a LabelSet are ANDed. In other words, a LabelSet is applicable for a VM only if it matches all the labels in the LabelSet. * Example: A LabelSet with 2 labels: `env=prod` and `type=webserver` will only be applicable for those VMs with both labels present.
    """
    def __init__(__self__, *,
                 labels: Mapping[str, str]):
        """
        Message representing label set. * A label is a key value pair set for a VM. * A LabelSet is a set of labels. * Labels within a LabelSet are ANDed. In other words, a LabelSet is applicable for a VM only if it matches all the labels in the LabelSet. * Example: A LabelSet with 2 labels: `env=prod` and `type=webserver` will only be applicable for those VMs with both labels present.
        :param Mapping[str, str] labels: Labels are identified by key/value pairs in this map. A VM should contain all the key/value pairs specified in this map to be selected.
        """
        pulumi.set(__self__, "labels", labels)

    @property
    @pulumi.getter
    def labels(self) -> Mapping[str, str]:
        """
        Labels are identified by key/value pairs in this map. A VM should contain all the key/value pairs specified in this map to be selected.
        """
        return pulumi.get(self, "labels")


@pulumi.output_type
class OSPolicyAssignmentRolloutResponse(dict):
    """
    Message to configure the rollout at the zonal level for the OS policy assignment.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "disruptionBudget":
            suggest = "disruption_budget"
        elif key == "minWaitDuration":
            suggest = "min_wait_duration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OSPolicyAssignmentRolloutResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OSPolicyAssignmentRolloutResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OSPolicyAssignmentRolloutResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 disruption_budget: 'outputs.FixedOrPercentResponse',
                 min_wait_duration: str):
        """
        Message to configure the rollout at the zonal level for the OS policy assignment.
        :param 'FixedOrPercentResponse' disruption_budget: The maximum number (or percentage) of VMs per zone to disrupt at any given moment.
        :param str min_wait_duration: This determines the minimum duration of time to wait after the configuration changes are applied through the current rollout. A VM continues to count towards the `disruption_budget` at least until this duration of time has passed after configuration changes are applied.
        """
        pulumi.set(__self__, "disruption_budget", disruption_budget)
        pulumi.set(__self__, "min_wait_duration", min_wait_duration)

    @property
    @pulumi.getter(name="disruptionBudget")
    def disruption_budget(self) -> 'outputs.FixedOrPercentResponse':
        """
        The maximum number (or percentage) of VMs per zone to disrupt at any given moment.
        """
        return pulumi.get(self, "disruption_budget")

    @property
    @pulumi.getter(name="minWaitDuration")
    def min_wait_duration(self) -> str:
        """
        This determines the minimum duration of time to wait after the configuration changes are applied through the current rollout. A VM continues to count towards the `disruption_budget` at least until this duration of time has passed after configuration changes are applied.
        """
        return pulumi.get(self, "min_wait_duration")


@pulumi.output_type
class OSPolicyInventoryFilterResponse(dict):
    """
    Filtering criteria to select VMs based on inventory details.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "osShortName":
            suggest = "os_short_name"
        elif key == "osVersion":
            suggest = "os_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OSPolicyInventoryFilterResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OSPolicyInventoryFilterResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OSPolicyInventoryFilterResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 os_short_name: str,
                 os_version: str):
        """
        Filtering criteria to select VMs based on inventory details.
        :param str os_short_name: The OS short name
        :param str os_version: The OS version Prefix matches are supported if asterisk(*) is provided as the last character. For example, to match all versions with a major version of `7`, specify the following value for this field `7.*` An empty string matches all OS versions.
        """
        pulumi.set(__self__, "os_short_name", os_short_name)
        pulumi.set(__self__, "os_version", os_version)

    @property
    @pulumi.getter(name="osShortName")
    def os_short_name(self) -> str:
        """
        The OS short name
        """
        return pulumi.get(self, "os_short_name")

    @property
    @pulumi.getter(name="osVersion")
    def os_version(self) -> str:
        """
        The OS version Prefix matches are supported if asterisk(*) is provided as the last character. For example, to match all versions with a major version of `7`, specify the following value for this field `7.*` An empty string matches all OS versions.
        """
        return pulumi.get(self, "os_version")


@pulumi.output_type
class OSPolicyOSFilterResponse(dict):
    """
    Filtering criteria to select VMs based on OS details.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "osShortName":
            suggest = "os_short_name"
        elif key == "osVersion":
            suggest = "os_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OSPolicyOSFilterResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OSPolicyOSFilterResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OSPolicyOSFilterResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 os_short_name: str,
                 os_version: str):
        """
        Filtering criteria to select VMs based on OS details.
        :param str os_short_name: This should match OS short name emitted by the OS inventory agent. An empty value matches any OS.
        :param str os_version: This value should match the version emitted by the OS inventory agent. Prefix matches are supported if asterisk(*) is provided as the last character. For example, to match all versions with a major version of `7`, specify the following value for this field `7.*`
        """
        pulumi.set(__self__, "os_short_name", os_short_name)
        pulumi.set(__self__, "os_version", os_version)

    @property
    @pulumi.getter(name="osShortName")
    def os_short_name(self) -> str:
        """
        This should match OS short name emitted by the OS inventory agent. An empty value matches any OS.
        """
        return pulumi.get(self, "os_short_name")

    @property
    @pulumi.getter(name="osVersion")
    def os_version(self) -> str:
        """
        This value should match the version emitted by the OS inventory agent. Prefix matches are supported if asterisk(*) is provided as the last character. For example, to match all versions with a major version of `7`, specify the following value for this field `7.*`
        """
        return pulumi.get(self, "os_version")


@pulumi.output_type
class OSPolicyResourceExecResourceExecResponse(dict):
    """
    A file or script to execute.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "outputFilePath":
            suggest = "output_file_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OSPolicyResourceExecResourceExecResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OSPolicyResourceExecResourceExecResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OSPolicyResourceExecResourceExecResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 args: Sequence[str],
                 file: 'outputs.OSPolicyResourceFileResponse',
                 interpreter: str,
                 output_file_path: str,
                 script: str):
        """
        A file or script to execute.
        :param Sequence[str] args: Optional arguments to pass to the source during execution.
        :param 'OSPolicyResourceFileResponse' file: A remote or local file.
        :param str interpreter: The script interpreter to use.
        :param str output_file_path: Only recorded for enforce Exec. Path to an output file (that is created by this Exec) whose content will be recorded in OSPolicyResourceCompliance after a successful run. Absence or failure to read this file will result in this ExecResource being non-compliant. Output file size is limited to 100K bytes.
        :param str script: An inline script. The size of the script is limited to 1024 characters.
        """
        pulumi.set(__self__, "args", args)
        pulumi.set(__self__, "file", file)
        pulumi.set(__self__, "interpreter", interpreter)
        pulumi.set(__self__, "output_file_path", output_file_path)
        pulumi.set(__self__, "script", script)

    @property
    @pulumi.getter
    def args(self) -> Sequence[str]:
        """
        Optional arguments to pass to the source during execution.
        """
        return pulumi.get(self, "args")

    @property
    @pulumi.getter
    def file(self) -> 'outputs.OSPolicyResourceFileResponse':
        """
        A remote or local file.
        """
        return pulumi.get(self, "file")

    @property
    @pulumi.getter
    def interpreter(self) -> str:
        """
        The script interpreter to use.
        """
        return pulumi.get(self, "interpreter")

    @property
    @pulumi.getter(name="outputFilePath")
    def output_file_path(self) -> str:
        """
        Only recorded for enforce Exec. Path to an output file (that is created by this Exec) whose content will be recorded in OSPolicyResourceCompliance after a successful run. Absence or failure to read this file will result in this ExecResource being non-compliant. Output file size is limited to 100K bytes.
        """
        return pulumi.get(self, "output_file_path")

    @property
    @pulumi.getter
    def script(self) -> str:
        """
        An inline script. The size of the script is limited to 1024 characters.
        """
        return pulumi.get(self, "script")


@pulumi.output_type
class OSPolicyResourceExecResourceResponse(dict):
    """
    A resource that allows executing scripts on the VM. The `ExecResource` has 2 stages: `validate` and `enforce` and both stages accept a script as an argument to execute. When the `ExecResource` is applied by the agent, it first executes the script in the `validate` stage. The `validate` stage can signal that the `ExecResource` is already in the desired state by returning an exit code of `100`. If the `ExecResource` is not in the desired state, it should return an exit code of `101`. Any other exit code returned by this stage is considered an error. If the `ExecResource` is not in the desired state based on the exit code from the `validate` stage, the agent proceeds to execute the script from the `enforce` stage. If the `ExecResource` is already in the desired state, the `enforce` stage will not be run. Similar to `validate` stage, the `enforce` stage should return an exit code of `100` to indicate that the resource in now in its desired state. Any other exit code is considered an error. NOTE: An exit code of `100` was chosen over `0` (and `101` vs `1`) to have an explicit indicator of `in desired state`, `not in desired state` and errors. Because, for example, Powershell will always return an exit code of `0` unless an `exit` statement is provided in the script. So, for reasons of consistency and being explicit, exit codes `100` and `101` were chosen.
    """
    def __init__(__self__, *,
                 enforce: 'outputs.OSPolicyResourceExecResourceExecResponse',
                 validate: 'outputs.OSPolicyResourceExecResourceExecResponse'):
        """
        A resource that allows executing scripts on the VM. The `ExecResource` has 2 stages: `validate` and `enforce` and both stages accept a script as an argument to execute. When the `ExecResource` is applied by the agent, it first executes the script in the `validate` stage. The `validate` stage can signal that the `ExecResource` is already in the desired state by returning an exit code of `100`. If the `ExecResource` is not in the desired state, it should return an exit code of `101`. Any other exit code returned by this stage is considered an error. If the `ExecResource` is not in the desired state based on the exit code from the `validate` stage, the agent proceeds to execute the script from the `enforce` stage. If the `ExecResource` is already in the desired state, the `enforce` stage will not be run. Similar to `validate` stage, the `enforce` stage should return an exit code of `100` to indicate that the resource in now in its desired state. Any other exit code is considered an error. NOTE: An exit code of `100` was chosen over `0` (and `101` vs `1`) to have an explicit indicator of `in desired state`, `not in desired state` and errors. Because, for example, Powershell will always return an exit code of `0` unless an `exit` statement is provided in the script. So, for reasons of consistency and being explicit, exit codes `100` and `101` were chosen.
        :param 'OSPolicyResourceExecResourceExecResponse' enforce: What to run to bring this resource into the desired state. An exit code of 100 indicates "success", any other exit code indicates a failure running enforce.
        :param 'OSPolicyResourceExecResourceExecResponse' validate: What to run to validate this resource is in the desired state. An exit code of 100 indicates "in desired state", and exit code of 101 indicates "not in desired state". Any other exit code indicates a failure running validate.
        """
        pulumi.set(__self__, "enforce", enforce)
        pulumi.set(__self__, "validate", validate)

    @property
    @pulumi.getter
    def enforce(self) -> 'outputs.OSPolicyResourceExecResourceExecResponse':
        """
        What to run to bring this resource into the desired state. An exit code of 100 indicates "success", any other exit code indicates a failure running enforce.
        """
        return pulumi.get(self, "enforce")

    @property
    @pulumi.getter
    def validate(self) -> 'outputs.OSPolicyResourceExecResourceExecResponse':
        """
        What to run to validate this resource is in the desired state. An exit code of 100 indicates "in desired state", and exit code of 101 indicates "not in desired state". Any other exit code indicates a failure running validate.
        """
        return pulumi.get(self, "validate")


@pulumi.output_type
class OSPolicyResourceFileGcsResponse(dict):
    """
    Specifies a file available as a Cloud Storage Object.
    """
    def __init__(__self__, *,
                 bucket: str,
                 generation: str,
                 object: str):
        """
        Specifies a file available as a Cloud Storage Object.
        :param str bucket: Bucket of the Cloud Storage object.
        :param str generation: Generation number of the Cloud Storage object.
        :param str object: Name of the Cloud Storage object.
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "generation", generation)
        pulumi.set(__self__, "object", object)

    @property
    @pulumi.getter
    def bucket(self) -> str:
        """
        Bucket of the Cloud Storage object.
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter
    def generation(self) -> str:
        """
        Generation number of the Cloud Storage object.
        """
        return pulumi.get(self, "generation")

    @property
    @pulumi.getter
    def object(self) -> str:
        """
        Name of the Cloud Storage object.
        """
        return pulumi.get(self, "object")


@pulumi.output_type
class OSPolicyResourceFileRemoteResponse(dict):
    """
    Specifies a file available via some URI.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sha256Checksum":
            suggest = "sha256_checksum"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OSPolicyResourceFileRemoteResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OSPolicyResourceFileRemoteResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OSPolicyResourceFileRemoteResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 sha256_checksum: str,
                 uri: str):
        """
        Specifies a file available via some URI.
        :param str sha256_checksum: SHA256 checksum of the remote file.
        :param str uri: URI from which to fetch the object. It should contain both the protocol and path following the format `{protocol}://{location}`.
        """
        pulumi.set(__self__, "sha256_checksum", sha256_checksum)
        pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter(name="sha256Checksum")
    def sha256_checksum(self) -> str:
        """
        SHA256 checksum of the remote file.
        """
        return pulumi.get(self, "sha256_checksum")

    @property
    @pulumi.getter
    def uri(self) -> str:
        """
        URI from which to fetch the object. It should contain both the protocol and path following the format `{protocol}://{location}`.
        """
        return pulumi.get(self, "uri")


@pulumi.output_type
class OSPolicyResourceFileResourceResponse(dict):
    """
    A resource that manages the state of a file.
    """
    def __init__(__self__, *,
                 content: str,
                 file: 'outputs.OSPolicyResourceFileResponse',
                 path: str,
                 permissions: str,
                 state: str):
        """
        A resource that manages the state of a file.
        :param str content: A a file with this content. The size of the content is limited to 1024 characters.
        :param 'OSPolicyResourceFileResponse' file: A remote or local source.
        :param str path: The absolute path of the file within the VM.
        :param str permissions: Consists of three octal digits which represent, in order, the permissions of the owner, group, and other users for the file (similarly to the numeric mode used in the linux chmod utility). Each digit represents a three bit number with the 4 bit corresponding to the read permissions, the 2 bit corresponds to the write bit, and the one bit corresponds to the execute permission. Default behavior is 755. Below are some examples of permissions and their associated values: read, write, and execute: 7 read and execute: 5 read and write: 6 read only: 4
        :param str state: Desired state of the file.
        """
        pulumi.set(__self__, "content", content)
        pulumi.set(__self__, "file", file)
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "permissions", permissions)
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter
    def content(self) -> str:
        """
        A a file with this content. The size of the content is limited to 1024 characters.
        """
        return pulumi.get(self, "content")

    @property
    @pulumi.getter
    def file(self) -> 'outputs.OSPolicyResourceFileResponse':
        """
        A remote or local source.
        """
        return pulumi.get(self, "file")

    @property
    @pulumi.getter
    def path(self) -> str:
        """
        The absolute path of the file within the VM.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def permissions(self) -> str:
        """
        Consists of three octal digits which represent, in order, the permissions of the owner, group, and other users for the file (similarly to the numeric mode used in the linux chmod utility). Each digit represents a three bit number with the 4 bit corresponding to the read permissions, the 2 bit corresponds to the write bit, and the one bit corresponds to the execute permission. Default behavior is 755. Below are some examples of permissions and their associated values: read, write, and execute: 7 read and execute: 5 read and write: 6 read only: 4
        """
        return pulumi.get(self, "permissions")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        Desired state of the file.
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class OSPolicyResourceFileResponse(dict):
    """
    A remote or local file.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowInsecure":
            suggest = "allow_insecure"
        elif key == "localPath":
            suggest = "local_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OSPolicyResourceFileResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OSPolicyResourceFileResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OSPolicyResourceFileResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allow_insecure: bool,
                 gcs: 'outputs.OSPolicyResourceFileGcsResponse',
                 local_path: str,
                 remote: 'outputs.OSPolicyResourceFileRemoteResponse'):
        """
        A remote or local file.
        :param bool allow_insecure: Defaults to false. When false, files are subject to validations based on the file type: Remote: A checksum must be specified. Cloud Storage: An object generation number must be specified.
        :param 'OSPolicyResourceFileGcsResponse' gcs: A Cloud Storage object.
        :param str local_path: A local path within the VM to use.
        :param 'OSPolicyResourceFileRemoteResponse' remote: A generic remote file.
        """
        pulumi.set(__self__, "allow_insecure", allow_insecure)
        pulumi.set(__self__, "gcs", gcs)
        pulumi.set(__self__, "local_path", local_path)
        pulumi.set(__self__, "remote", remote)

    @property
    @pulumi.getter(name="allowInsecure")
    def allow_insecure(self) -> bool:
        """
        Defaults to false. When false, files are subject to validations based on the file type: Remote: A checksum must be specified. Cloud Storage: An object generation number must be specified.
        """
        return pulumi.get(self, "allow_insecure")

    @property
    @pulumi.getter
    def gcs(self) -> 'outputs.OSPolicyResourceFileGcsResponse':
        """
        A Cloud Storage object.
        """
        return pulumi.get(self, "gcs")

    @property
    @pulumi.getter(name="localPath")
    def local_path(self) -> str:
        """
        A local path within the VM to use.
        """
        return pulumi.get(self, "local_path")

    @property
    @pulumi.getter
    def remote(self) -> 'outputs.OSPolicyResourceFileRemoteResponse':
        """
        A generic remote file.
        """
        return pulumi.get(self, "remote")


@pulumi.output_type
class OSPolicyResourceGroupResponse(dict):
    """
    Resource groups provide a mechanism to group OS policy resources. Resource groups enable OS policy authors to create a single OS policy to be applied to VMs running different operating Systems. When the OS policy is applied to a target VM, the appropriate resource group within the OS policy is selected based on the `OSFilter` specified within the resource group.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "inventoryFilters":
            suggest = "inventory_filters"
        elif key == "osFilter":
            suggest = "os_filter"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OSPolicyResourceGroupResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OSPolicyResourceGroupResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OSPolicyResourceGroupResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 inventory_filters: Sequence['outputs.OSPolicyInventoryFilterResponse'],
                 os_filter: 'outputs.OSPolicyOSFilterResponse',
                 resources: Sequence['outputs.OSPolicyResourceResponse']):
        """
        Resource groups provide a mechanism to group OS policy resources. Resource groups enable OS policy authors to create a single OS policy to be applied to VMs running different operating Systems. When the OS policy is applied to a target VM, the appropriate resource group within the OS policy is selected based on the `OSFilter` specified within the resource group.
        :param Sequence['OSPolicyInventoryFilterResponse'] inventory_filters: List of inventory filters for the resource group. The resources in this resource group are applied to the target VM if it satisfies at least one of the following inventory filters. For example, to apply this resource group to VMs running either `RHEL` or `CentOS` operating systems, specify 2 items for the list with following values: inventory_filters[0].os_short_name='rhel' and inventory_filters[1].os_short_name='centos' If the list is empty, this resource group will be applied to the target VM unconditionally.
        :param 'OSPolicyOSFilterResponse' os_filter: Deprecated. Use the `inventory_filters` field instead. Used to specify the OS filter for a resource group
        :param Sequence['OSPolicyResourceResponse'] resources: List of resources configured for this resource group. The resources are executed in the exact order specified here.
        """
        pulumi.set(__self__, "inventory_filters", inventory_filters)
        pulumi.set(__self__, "os_filter", os_filter)
        pulumi.set(__self__, "resources", resources)

    @property
    @pulumi.getter(name="inventoryFilters")
    def inventory_filters(self) -> Sequence['outputs.OSPolicyInventoryFilterResponse']:
        """
        List of inventory filters for the resource group. The resources in this resource group are applied to the target VM if it satisfies at least one of the following inventory filters. For example, to apply this resource group to VMs running either `RHEL` or `CentOS` operating systems, specify 2 items for the list with following values: inventory_filters[0].os_short_name='rhel' and inventory_filters[1].os_short_name='centos' If the list is empty, this resource group will be applied to the target VM unconditionally.
        """
        return pulumi.get(self, "inventory_filters")

    @property
    @pulumi.getter(name="osFilter")
    def os_filter(self) -> 'outputs.OSPolicyOSFilterResponse':
        """
        Deprecated. Use the `inventory_filters` field instead. Used to specify the OS filter for a resource group
        """
        return pulumi.get(self, "os_filter")

    @property
    @pulumi.getter
    def resources(self) -> Sequence['outputs.OSPolicyResourceResponse']:
        """
        List of resources configured for this resource group. The resources are executed in the exact order specified here.
        """
        return pulumi.get(self, "resources")


@pulumi.output_type
class OSPolicyResourcePackageResourceAPTResponse(dict):
    """
    A package managed by APT. - install: `apt-get update && apt-get -y install [name]` - remove: `apt-get -y remove [name]`
    """
    def __init__(__self__, *,
                 name: str):
        """
        A package managed by APT. - install: `apt-get update && apt-get -y install [name]` - remove: `apt-get -y remove [name]`
        :param str name: Package name.
        """
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Package name.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class OSPolicyResourcePackageResourceDebResponse(dict):
    """
    A deb package file. dpkg packages only support INSTALLED state.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "pullDeps":
            suggest = "pull_deps"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OSPolicyResourcePackageResourceDebResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OSPolicyResourcePackageResourceDebResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OSPolicyResourcePackageResourceDebResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 pull_deps: bool,
                 source: 'outputs.OSPolicyResourceFileResponse'):
        """
        A deb package file. dpkg packages only support INSTALLED state.
        :param bool pull_deps: Whether dependencies should also be installed. - install when false: `dpkg -i package` - install when true: `apt-get update && apt-get -y install package.deb`
        :param 'OSPolicyResourceFileResponse' source: A deb package.
        """
        pulumi.set(__self__, "pull_deps", pull_deps)
        pulumi.set(__self__, "source", source)

    @property
    @pulumi.getter(name="pullDeps")
    def pull_deps(self) -> bool:
        """
        Whether dependencies should also be installed. - install when false: `dpkg -i package` - install when true: `apt-get update && apt-get -y install package.deb`
        """
        return pulumi.get(self, "pull_deps")

    @property
    @pulumi.getter
    def source(self) -> 'outputs.OSPolicyResourceFileResponse':
        """
        A deb package.
        """
        return pulumi.get(self, "source")


@pulumi.output_type
class OSPolicyResourcePackageResourceGooGetResponse(dict):
    """
    A package managed by GooGet. - install: `googet -noconfirm install package` - remove: `googet -noconfirm remove package`
    """
    def __init__(__self__, *,
                 name: str):
        """
        A package managed by GooGet. - install: `googet -noconfirm install package` - remove: `googet -noconfirm remove package`
        :param str name: Package name.
        """
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Package name.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class OSPolicyResourcePackageResourceMSIResponse(dict):
    """
    An MSI package. MSI packages only support INSTALLED state.
    """
    def __init__(__self__, *,
                 properties: Sequence[str],
                 source: 'outputs.OSPolicyResourceFileResponse'):
        """
        An MSI package. MSI packages only support INSTALLED state.
        :param Sequence[str] properties: Additional properties to use during installation. This should be in the format of Property=Setting. Appended to the defaults of `ACTION=INSTALL REBOOT=ReallySuppress`.
        :param 'OSPolicyResourceFileResponse' source: The MSI package.
        """
        pulumi.set(__self__, "properties", properties)
        pulumi.set(__self__, "source", source)

    @property
    @pulumi.getter
    def properties(self) -> Sequence[str]:
        """
        Additional properties to use during installation. This should be in the format of Property=Setting. Appended to the defaults of `ACTION=INSTALL REBOOT=ReallySuppress`.
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter
    def source(self) -> 'outputs.OSPolicyResourceFileResponse':
        """
        The MSI package.
        """
        return pulumi.get(self, "source")


@pulumi.output_type
class OSPolicyResourcePackageResourceRPMResponse(dict):
    """
    An RPM package file. RPM packages only support INSTALLED state.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "pullDeps":
            suggest = "pull_deps"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OSPolicyResourcePackageResourceRPMResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OSPolicyResourcePackageResourceRPMResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OSPolicyResourcePackageResourceRPMResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 pull_deps: bool,
                 source: 'outputs.OSPolicyResourceFileResponse'):
        """
        An RPM package file. RPM packages only support INSTALLED state.
        :param bool pull_deps: Whether dependencies should also be installed. - install when false: `rpm --upgrade --replacepkgs package.rpm` - install when true: `yum -y install package.rpm` or `zypper -y install package.rpm`
        :param 'OSPolicyResourceFileResponse' source: An rpm package.
        """
        pulumi.set(__self__, "pull_deps", pull_deps)
        pulumi.set(__self__, "source", source)

    @property
    @pulumi.getter(name="pullDeps")
    def pull_deps(self) -> bool:
        """
        Whether dependencies should also be installed. - install when false: `rpm --upgrade --replacepkgs package.rpm` - install when true: `yum -y install package.rpm` or `zypper -y install package.rpm`
        """
        return pulumi.get(self, "pull_deps")

    @property
    @pulumi.getter
    def source(self) -> 'outputs.OSPolicyResourceFileResponse':
        """
        An rpm package.
        """
        return pulumi.get(self, "source")


@pulumi.output_type
class OSPolicyResourcePackageResourceResponse(dict):
    """
    A resource that manages a system package.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "desiredState":
            suggest = "desired_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OSPolicyResourcePackageResourceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OSPolicyResourcePackageResourceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OSPolicyResourcePackageResourceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 apt: 'outputs.OSPolicyResourcePackageResourceAPTResponse',
                 deb: 'outputs.OSPolicyResourcePackageResourceDebResponse',
                 desired_state: str,
                 googet: 'outputs.OSPolicyResourcePackageResourceGooGetResponse',
                 msi: 'outputs.OSPolicyResourcePackageResourceMSIResponse',
                 rpm: 'outputs.OSPolicyResourcePackageResourceRPMResponse',
                 yum: 'outputs.OSPolicyResourcePackageResourceYUMResponse',
                 zypper: 'outputs.OSPolicyResourcePackageResourceZypperResponse'):
        """
        A resource that manages a system package.
        :param 'OSPolicyResourcePackageResourceAPTResponse' apt: A package managed by Apt.
        :param 'OSPolicyResourcePackageResourceDebResponse' deb: A deb package file.
        :param str desired_state: The desired state the agent should maintain for this package.
        :param 'OSPolicyResourcePackageResourceGooGetResponse' googet: A package managed by GooGet.
        :param 'OSPolicyResourcePackageResourceMSIResponse' msi: An MSI package.
        :param 'OSPolicyResourcePackageResourceRPMResponse' rpm: An rpm package file.
        :param 'OSPolicyResourcePackageResourceYUMResponse' yum: A package managed by YUM.
        :param 'OSPolicyResourcePackageResourceZypperResponse' zypper: A package managed by Zypper.
        """
        pulumi.set(__self__, "apt", apt)
        pulumi.set(__self__, "deb", deb)
        pulumi.set(__self__, "desired_state", desired_state)
        pulumi.set(__self__, "googet", googet)
        pulumi.set(__self__, "msi", msi)
        pulumi.set(__self__, "rpm", rpm)
        pulumi.set(__self__, "yum", yum)
        pulumi.set(__self__, "zypper", zypper)

    @property
    @pulumi.getter
    def apt(self) -> 'outputs.OSPolicyResourcePackageResourceAPTResponse':
        """
        A package managed by Apt.
        """
        return pulumi.get(self, "apt")

    @property
    @pulumi.getter
    def deb(self) -> 'outputs.OSPolicyResourcePackageResourceDebResponse':
        """
        A deb package file.
        """
        return pulumi.get(self, "deb")

    @property
    @pulumi.getter(name="desiredState")
    def desired_state(self) -> str:
        """
        The desired state the agent should maintain for this package.
        """
        return pulumi.get(self, "desired_state")

    @property
    @pulumi.getter
    def googet(self) -> 'outputs.OSPolicyResourcePackageResourceGooGetResponse':
        """
        A package managed by GooGet.
        """
        return pulumi.get(self, "googet")

    @property
    @pulumi.getter
    def msi(self) -> 'outputs.OSPolicyResourcePackageResourceMSIResponse':
        """
        An MSI package.
        """
        return pulumi.get(self, "msi")

    @property
    @pulumi.getter
    def rpm(self) -> 'outputs.OSPolicyResourcePackageResourceRPMResponse':
        """
        An rpm package file.
        """
        return pulumi.get(self, "rpm")

    @property
    @pulumi.getter
    def yum(self) -> 'outputs.OSPolicyResourcePackageResourceYUMResponse':
        """
        A package managed by YUM.
        """
        return pulumi.get(self, "yum")

    @property
    @pulumi.getter
    def zypper(self) -> 'outputs.OSPolicyResourcePackageResourceZypperResponse':
        """
        A package managed by Zypper.
        """
        return pulumi.get(self, "zypper")


@pulumi.output_type
class OSPolicyResourcePackageResourceYUMResponse(dict):
    """
    A package managed by YUM. - install: `yum -y install package` - remove: `yum -y remove package`
    """
    def __init__(__self__, *,
                 name: str):
        """
        A package managed by YUM. - install: `yum -y install package` - remove: `yum -y remove package`
        :param str name: Package name.
        """
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Package name.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class OSPolicyResourcePackageResourceZypperResponse(dict):
    """
    A package managed by Zypper. - install: `zypper -y install package` - remove: `zypper -y rm package`
    """
    def __init__(__self__, *,
                 name: str):
        """
        A package managed by Zypper. - install: `zypper -y install package` - remove: `zypper -y rm package`
        :param str name: Package name.
        """
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Package name.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class OSPolicyResourceRepositoryResourceAptRepositoryResponse(dict):
    """
    Represents a single apt package repository. These will be added to a repo file that will be managed at `/etc/apt/sources.list.d/google_osconfig.list`.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "archiveType":
            suggest = "archive_type"
        elif key == "gpgKey":
            suggest = "gpg_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OSPolicyResourceRepositoryResourceAptRepositoryResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OSPolicyResourceRepositoryResourceAptRepositoryResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OSPolicyResourceRepositoryResourceAptRepositoryResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 archive_type: str,
                 components: Sequence[str],
                 distribution: str,
                 gpg_key: str,
                 uri: str):
        """
        Represents a single apt package repository. These will be added to a repo file that will be managed at `/etc/apt/sources.list.d/google_osconfig.list`.
        :param str archive_type: Type of archive files in this repository.
        :param Sequence[str] components: List of components for this repository. Must contain at least one item.
        :param str distribution: Distribution of this repository.
        :param str gpg_key: URI of the key file for this repository. The agent maintains a keyring at `/etc/apt/trusted.gpg.d/osconfig_agent_managed.gpg`.
        :param str uri: URI for this repository.
        """
        pulumi.set(__self__, "archive_type", archive_type)
        pulumi.set(__self__, "components", components)
        pulumi.set(__self__, "distribution", distribution)
        pulumi.set(__self__, "gpg_key", gpg_key)
        pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter(name="archiveType")
    def archive_type(self) -> str:
        """
        Type of archive files in this repository.
        """
        return pulumi.get(self, "archive_type")

    @property
    @pulumi.getter
    def components(self) -> Sequence[str]:
        """
        List of components for this repository. Must contain at least one item.
        """
        return pulumi.get(self, "components")

    @property
    @pulumi.getter
    def distribution(self) -> str:
        """
        Distribution of this repository.
        """
        return pulumi.get(self, "distribution")

    @property
    @pulumi.getter(name="gpgKey")
    def gpg_key(self) -> str:
        """
        URI of the key file for this repository. The agent maintains a keyring at `/etc/apt/trusted.gpg.d/osconfig_agent_managed.gpg`.
        """
        return pulumi.get(self, "gpg_key")

    @property
    @pulumi.getter
    def uri(self) -> str:
        """
        URI for this repository.
        """
        return pulumi.get(self, "uri")


@pulumi.output_type
class OSPolicyResourceRepositoryResourceGooRepositoryResponse(dict):
    """
    Represents a Goo package repository. These are added to a repo file that is managed at `C:/ProgramData/GooGet/repos/google_osconfig.repo`.
    """
    def __init__(__self__, *,
                 name: str,
                 url: str):
        """
        Represents a Goo package repository. These are added to a repo file that is managed at `C:/ProgramData/GooGet/repos/google_osconfig.repo`.
        :param str name: The name of the repository.
        :param str url: The url of the repository.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the repository.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def url(self) -> str:
        """
        The url of the repository.
        """
        return pulumi.get(self, "url")


@pulumi.output_type
class OSPolicyResourceRepositoryResourceResponse(dict):
    """
    A resource that manages a package repository.
    """
    def __init__(__self__, *,
                 apt: 'outputs.OSPolicyResourceRepositoryResourceAptRepositoryResponse',
                 goo: 'outputs.OSPolicyResourceRepositoryResourceGooRepositoryResponse',
                 yum: 'outputs.OSPolicyResourceRepositoryResourceYumRepositoryResponse',
                 zypper: 'outputs.OSPolicyResourceRepositoryResourceZypperRepositoryResponse'):
        """
        A resource that manages a package repository.
        :param 'OSPolicyResourceRepositoryResourceAptRepositoryResponse' apt: An Apt Repository.
        :param 'OSPolicyResourceRepositoryResourceGooRepositoryResponse' goo: A Goo Repository.
        :param 'OSPolicyResourceRepositoryResourceYumRepositoryResponse' yum: A Yum Repository.
        :param 'OSPolicyResourceRepositoryResourceZypperRepositoryResponse' zypper: A Zypper Repository.
        """
        pulumi.set(__self__, "apt", apt)
        pulumi.set(__self__, "goo", goo)
        pulumi.set(__self__, "yum", yum)
        pulumi.set(__self__, "zypper", zypper)

    @property
    @pulumi.getter
    def apt(self) -> 'outputs.OSPolicyResourceRepositoryResourceAptRepositoryResponse':
        """
        An Apt Repository.
        """
        return pulumi.get(self, "apt")

    @property
    @pulumi.getter
    def goo(self) -> 'outputs.OSPolicyResourceRepositoryResourceGooRepositoryResponse':
        """
        A Goo Repository.
        """
        return pulumi.get(self, "goo")

    @property
    @pulumi.getter
    def yum(self) -> 'outputs.OSPolicyResourceRepositoryResourceYumRepositoryResponse':
        """
        A Yum Repository.
        """
        return pulumi.get(self, "yum")

    @property
    @pulumi.getter
    def zypper(self) -> 'outputs.OSPolicyResourceRepositoryResourceZypperRepositoryResponse':
        """
        A Zypper Repository.
        """
        return pulumi.get(self, "zypper")


@pulumi.output_type
class OSPolicyResourceRepositoryResourceYumRepositoryResponse(dict):
    """
    Represents a single yum package repository. These are added to a repo file that is managed at `/etc/yum.repos.d/google_osconfig.repo`.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "baseUrl":
            suggest = "base_url"
        elif key == "displayName":
            suggest = "display_name"
        elif key == "gpgKeys":
            suggest = "gpg_keys"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OSPolicyResourceRepositoryResourceYumRepositoryResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OSPolicyResourceRepositoryResourceYumRepositoryResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OSPolicyResourceRepositoryResourceYumRepositoryResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 base_url: str,
                 display_name: str,
                 gpg_keys: Sequence[str]):
        """
        Represents a single yum package repository. These are added to a repo file that is managed at `/etc/yum.repos.d/google_osconfig.repo`.
        :param str base_url: The location of the repository directory.
        :param str display_name: The display name of the repository.
        :param Sequence[str] gpg_keys: URIs of GPG keys.
        """
        pulumi.set(__self__, "base_url", base_url)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "gpg_keys", gpg_keys)

    @property
    @pulumi.getter(name="baseUrl")
    def base_url(self) -> str:
        """
        The location of the repository directory.
        """
        return pulumi.get(self, "base_url")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        The display name of the repository.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="gpgKeys")
    def gpg_keys(self) -> Sequence[str]:
        """
        URIs of GPG keys.
        """
        return pulumi.get(self, "gpg_keys")


@pulumi.output_type
class OSPolicyResourceRepositoryResourceZypperRepositoryResponse(dict):
    """
    Represents a single zypper package repository. These are added to a repo file that is managed at `/etc/zypp/repos.d/google_osconfig.repo`.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "baseUrl":
            suggest = "base_url"
        elif key == "displayName":
            suggest = "display_name"
        elif key == "gpgKeys":
            suggest = "gpg_keys"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OSPolicyResourceRepositoryResourceZypperRepositoryResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OSPolicyResourceRepositoryResourceZypperRepositoryResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OSPolicyResourceRepositoryResourceZypperRepositoryResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 base_url: str,
                 display_name: str,
                 gpg_keys: Sequence[str]):
        """
        Represents a single zypper package repository. These are added to a repo file that is managed at `/etc/zypp/repos.d/google_osconfig.repo`.
        :param str base_url: The location of the repository directory.
        :param str display_name: The display name of the repository.
        :param Sequence[str] gpg_keys: URIs of GPG keys.
        """
        pulumi.set(__self__, "base_url", base_url)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "gpg_keys", gpg_keys)

    @property
    @pulumi.getter(name="baseUrl")
    def base_url(self) -> str:
        """
        The location of the repository directory.
        """
        return pulumi.get(self, "base_url")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        The display name of the repository.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="gpgKeys")
    def gpg_keys(self) -> Sequence[str]:
        """
        URIs of GPG keys.
        """
        return pulumi.get(self, "gpg_keys")


@pulumi.output_type
class OSPolicyResourceResponse(dict):
    """
    An OS policy resource is used to define the desired state configuration and provides a specific functionality like installing/removing packages, executing a script etc. The system ensures that resources are always in their desired state by taking necessary actions if they have drifted from their desired state.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "exec":
            suggest = "exec_"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OSPolicyResourceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OSPolicyResourceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OSPolicyResourceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 exec_: 'outputs.OSPolicyResourceExecResourceResponse',
                 file: 'outputs.OSPolicyResourceFileResourceResponse',
                 pkg: 'outputs.OSPolicyResourcePackageResourceResponse',
                 repository: 'outputs.OSPolicyResourceRepositoryResourceResponse'):
        """
        An OS policy resource is used to define the desired state configuration and provides a specific functionality like installing/removing packages, executing a script etc. The system ensures that resources are always in their desired state by taking necessary actions if they have drifted from their desired state.
        :param 'OSPolicyResourceExecResourceResponse' exec_: Exec resource
        :param 'OSPolicyResourceFileResourceResponse' file: File resource
        :param 'OSPolicyResourcePackageResourceResponse' pkg: Package resource
        :param 'OSPolicyResourceRepositoryResourceResponse' repository: Package repository resource
        """
        pulumi.set(__self__, "exec_", exec_)
        pulumi.set(__self__, "file", file)
        pulumi.set(__self__, "pkg", pkg)
        pulumi.set(__self__, "repository", repository)

    @property
    @pulumi.getter(name="exec")
    def exec_(self) -> 'outputs.OSPolicyResourceExecResourceResponse':
        """
        Exec resource
        """
        return pulumi.get(self, "exec_")

    @property
    @pulumi.getter
    def file(self) -> 'outputs.OSPolicyResourceFileResourceResponse':
        """
        File resource
        """
        return pulumi.get(self, "file")

    @property
    @pulumi.getter
    def pkg(self) -> 'outputs.OSPolicyResourcePackageResourceResponse':
        """
        Package resource
        """
        return pulumi.get(self, "pkg")

    @property
    @pulumi.getter
    def repository(self) -> 'outputs.OSPolicyResourceRepositoryResourceResponse':
        """
        Package repository resource
        """
        return pulumi.get(self, "repository")


@pulumi.output_type
class OSPolicyResponse(dict):
    """
    An OS policy defines the desired state configuration for a VM.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowNoResourceGroupMatch":
            suggest = "allow_no_resource_group_match"
        elif key == "resourceGroups":
            suggest = "resource_groups"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OSPolicyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OSPolicyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OSPolicyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allow_no_resource_group_match: bool,
                 description: str,
                 mode: str,
                 resource_groups: Sequence['outputs.OSPolicyResourceGroupResponse']):
        """
        An OS policy defines the desired state configuration for a VM.
        :param bool allow_no_resource_group_match: This flag determines the OS policy compliance status when none of the resource groups within the policy are applicable for a VM. Set this value to `true` if the policy needs to be reported as compliant even if the policy has nothing to validate or enforce.
        :param str description: Policy description. Length of the description is limited to 1024 characters.
        :param str mode: Policy mode
        :param Sequence['OSPolicyResourceGroupResponse'] resource_groups: List of resource groups for the policy. For a particular VM, resource groups are evaluated in the order specified and the first resource group that is applicable is selected and the rest are ignored. If none of the resource groups are applicable for a VM, the VM is considered to be non-compliant w.r.t this policy. This behavior can be toggled by the flag `allow_no_resource_group_match`
        """
        pulumi.set(__self__, "allow_no_resource_group_match", allow_no_resource_group_match)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "mode", mode)
        pulumi.set(__self__, "resource_groups", resource_groups)

    @property
    @pulumi.getter(name="allowNoResourceGroupMatch")
    def allow_no_resource_group_match(self) -> bool:
        """
        This flag determines the OS policy compliance status when none of the resource groups within the policy are applicable for a VM. Set this value to `true` if the policy needs to be reported as compliant even if the policy has nothing to validate or enforce.
        """
        return pulumi.get(self, "allow_no_resource_group_match")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Policy description. Length of the description is limited to 1024 characters.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def mode(self) -> str:
        """
        Policy mode
        """
        return pulumi.get(self, "mode")

    @property
    @pulumi.getter(name="resourceGroups")
    def resource_groups(self) -> Sequence['outputs.OSPolicyResourceGroupResponse']:
        """
        List of resource groups for the policy. For a particular VM, resource groups are evaluated in the order specified and the first resource group that is applicable is selected and the rest are ignored. If none of the resource groups are applicable for a VM, the VM is considered to be non-compliant w.r.t this policy. This behavior can be toggled by the flag `allow_no_resource_group_match`
        """
        return pulumi.get(self, "resource_groups")


