# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = [
    'DnsKeySpecArgs',
    'ExprArgs',
    'GoogleIamV1AuditConfigArgs',
    'GoogleIamV1AuditLogConfigArgs',
    'GoogleIamV1BindingArgs',
    'ManagedZoneCloudLoggingConfigArgs',
    'ManagedZoneDnsSecConfigArgs',
    'ManagedZoneForwardingConfigNameServerTargetArgs',
    'ManagedZoneForwardingConfigArgs',
    'ManagedZonePeeringConfigTargetNetworkArgs',
    'ManagedZonePeeringConfigArgs',
    'ManagedZonePrivateVisibilityConfigGKEClusterArgs',
    'ManagedZonePrivateVisibilityConfigNetworkArgs',
    'ManagedZonePrivateVisibilityConfigArgs',
    'ManagedZoneReverseLookupConfigArgs',
    'ManagedZoneServiceDirectoryConfigNamespaceArgs',
    'ManagedZoneServiceDirectoryConfigArgs',
    'PolicyAlternativeNameServerConfigTargetNameServerArgs',
    'PolicyAlternativeNameServerConfigArgs',
    'PolicyNetworkArgs',
    'RRSetRoutingPolicyGeoPolicyGeoPolicyItemArgs',
    'RRSetRoutingPolicyGeoPolicyArgs',
    'RRSetRoutingPolicyHealthCheckTargetsArgs',
    'RRSetRoutingPolicyLoadBalancerTargetArgs',
    'RRSetRoutingPolicyPrimaryBackupPolicyArgs',
    'RRSetRoutingPolicyWrrPolicyWrrPolicyItemArgs',
    'RRSetRoutingPolicyWrrPolicyArgs',
    'RRSetRoutingPolicyArgs',
    'ResourceRecordSetArgs',
]

@pulumi.input_type
class DnsKeySpecArgs:
    def __init__(__self__, *,
                 algorithm: Optional[pulumi.Input['DnsKeySpecAlgorithm']] = None,
                 key_length: Optional[pulumi.Input[int]] = None,
                 key_type: Optional[pulumi.Input['DnsKeySpecKeyType']] = None,
                 kind: Optional[pulumi.Input[str]] = None):
        """
        Parameters for DnsKey key generation. Used for generating initial keys for a new ManagedZone and as default when adding a new DnsKey.
        :param pulumi.Input['DnsKeySpecAlgorithm'] algorithm: String mnemonic specifying the DNSSEC algorithm of this key.
        :param pulumi.Input[int] key_length: Length of the keys in bits.
        :param pulumi.Input['DnsKeySpecKeyType'] key_type: Specifies whether this is a key signing key (KSK) or a zone signing key (ZSK). Key signing keys have the Secure Entry Point flag set and, when active, are only used to sign resource record sets of type DNSKEY. Zone signing keys do not have the Secure Entry Point flag set and are used to sign all other types of resource record sets.
        """
        if algorithm is not None:
            pulumi.set(__self__, "algorithm", algorithm)
        if key_length is not None:
            pulumi.set(__self__, "key_length", key_length)
        if key_type is not None:
            pulumi.set(__self__, "key_type", key_type)
        if kind is not None:
            pulumi.set(__self__, "kind", kind)

    @property
    @pulumi.getter
    def algorithm(self) -> Optional[pulumi.Input['DnsKeySpecAlgorithm']]:
        """
        String mnemonic specifying the DNSSEC algorithm of this key.
        """
        return pulumi.get(self, "algorithm")

    @algorithm.setter
    def algorithm(self, value: Optional[pulumi.Input['DnsKeySpecAlgorithm']]):
        pulumi.set(self, "algorithm", value)

    @property
    @pulumi.getter(name="keyLength")
    def key_length(self) -> Optional[pulumi.Input[int]]:
        """
        Length of the keys in bits.
        """
        return pulumi.get(self, "key_length")

    @key_length.setter
    def key_length(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "key_length", value)

    @property
    @pulumi.getter(name="keyType")
    def key_type(self) -> Optional[pulumi.Input['DnsKeySpecKeyType']]:
        """
        Specifies whether this is a key signing key (KSK) or a zone signing key (ZSK). Key signing keys have the Secure Entry Point flag set and, when active, are only used to sign resource record sets of type DNSKEY. Zone signing keys do not have the Secure Entry Point flag set and are used to sign all other types of resource record sets.
        """
        return pulumi.get(self, "key_type")

    @key_type.setter
    def key_type(self, value: Optional[pulumi.Input['DnsKeySpecKeyType']]):
        pulumi.set(self, "key_type", value)

    @property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kind", value)


@pulumi.input_type
class ExprArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 expression: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 title: Optional[pulumi.Input[str]] = None):
        """
        Represents a textual expression in the Common Expression Language (CEL) syntax. CEL is a C-like expression language. The syntax and semantics of CEL are documented at https://github.com/google/cel-spec. Example (Comparison): title: "Summary size limit" description: "Determines if a summary is less than 100 chars" expression: "document.summary.size() < 100" Example (Equality): title: "Requestor is owner" description: "Determines if requestor is the document owner" expression: "document.owner == request.auth.claims.email" Example (Logic): title: "Public documents" description: "Determine whether the document should be publicly visible" expression: "document.type != 'private' && document.type != 'internal'" Example (Data Manipulation): title: "Notification string" description: "Create a notification string with a timestamp." expression: "'New message received at ' + string(document.create_time)" The exact variables and functions that may be referenced within an expression are determined by the service that evaluates it. See the service documentation for additional information.
        :param pulumi.Input[str] description: Optional. Description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
        :param pulumi.Input[str] expression: Textual representation of an expression in Common Expression Language syntax.
        :param pulumi.Input[str] location: Optional. String indicating the location of the expression for error reporting, e.g. a file name and a position in the file.
        :param pulumi.Input[str] title: Optional. Title for the expression, i.e. a short string describing its purpose. This can be used e.g. in UIs which allow to enter the expression.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if expression is not None:
            pulumi.set(__self__, "expression", expression)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if title is not None:
            pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def expression(self) -> Optional[pulumi.Input[str]]:
        """
        Textual representation of an expression in Common Expression Language syntax.
        """
        return pulumi.get(self, "expression")

    @expression.setter
    def expression(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expression", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. String indicating the location of the expression for error reporting, e.g. a file name and a position in the file.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def title(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Title for the expression, i.e. a short string describing its purpose. This can be used e.g. in UIs which allow to enter the expression.
        """
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "title", value)


@pulumi.input_type
class GoogleIamV1AuditConfigArgs:
    def __init__(__self__, *,
                 audit_log_configs: Optional[pulumi.Input[Sequence[pulumi.Input['GoogleIamV1AuditLogConfigArgs']]]] = None,
                 service: Optional[pulumi.Input[str]] = None):
        """
        Specifies the audit configuration for a service. The configuration determines which permission types are logged, and what identities, if any, are exempted from logging. An AuditConfig must have one or more AuditLogConfigs. If there are AuditConfigs for both `allServices` and a specific service, the union of the two AuditConfigs is used for that service: the log_types specified in each AuditConfig are enabled, and the exempted_members in each AuditLogConfig are exempted. Example Policy with multiple AuditConfigs: { "audit_configs": [ { "service": "allServices", "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [ "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" }, { "log_type": "ADMIN_READ" } ] }, { "service": "sampleservice.googleapis.com", "audit_log_configs": [ { "log_type": "DATA_READ" }, { "log_type": "DATA_WRITE", "exempted_members": [ "user:aliya@example.com" ] } ] } ] } For sampleservice, this policy enables DATA_READ, DATA_WRITE and ADMIN_READ logging. It also exempts `jose@example.com` from DATA_READ logging, and `aliya@example.com` from DATA_WRITE logging.
        :param pulumi.Input[Sequence[pulumi.Input['GoogleIamV1AuditLogConfigArgs']]] audit_log_configs: The configuration for logging of each type of permission.
        :param pulumi.Input[str] service: Specifies a service that will be enabled for audit logging. For example, `storage.googleapis.com`, `cloudsql.googleapis.com`. `allServices` is a special value that covers all services.
        """
        if audit_log_configs is not None:
            pulumi.set(__self__, "audit_log_configs", audit_log_configs)
        if service is not None:
            pulumi.set(__self__, "service", service)

    @property
    @pulumi.getter(name="auditLogConfigs")
    def audit_log_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GoogleIamV1AuditLogConfigArgs']]]]:
        """
        The configuration for logging of each type of permission.
        """
        return pulumi.get(self, "audit_log_configs")

    @audit_log_configs.setter
    def audit_log_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GoogleIamV1AuditLogConfigArgs']]]]):
        pulumi.set(self, "audit_log_configs", value)

    @property
    @pulumi.getter
    def service(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies a service that will be enabled for audit logging. For example, `storage.googleapis.com`, `cloudsql.googleapis.com`. `allServices` is a special value that covers all services.
        """
        return pulumi.get(self, "service")

    @service.setter
    def service(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service", value)


@pulumi.input_type
class GoogleIamV1AuditLogConfigArgs:
    def __init__(__self__, *,
                 exempted_members: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 log_type: Optional[pulumi.Input['GoogleIamV1AuditLogConfigLogType']] = None):
        """
        Provides the configuration for logging a type of permissions. Example: { "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [ "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" } ] } This enables 'DATA_READ' and 'DATA_WRITE' logging, while exempting jose@example.com from DATA_READ logging.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] exempted_members: Specifies the identities that do not cause logging for this type of permission. Follows the same format of Binding.members.
        :param pulumi.Input['GoogleIamV1AuditLogConfigLogType'] log_type: The log type that this config enables.
        """
        if exempted_members is not None:
            pulumi.set(__self__, "exempted_members", exempted_members)
        if log_type is not None:
            pulumi.set(__self__, "log_type", log_type)

    @property
    @pulumi.getter(name="exemptedMembers")
    def exempted_members(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies the identities that do not cause logging for this type of permission. Follows the same format of Binding.members.
        """
        return pulumi.get(self, "exempted_members")

    @exempted_members.setter
    def exempted_members(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "exempted_members", value)

    @property
    @pulumi.getter(name="logType")
    def log_type(self) -> Optional[pulumi.Input['GoogleIamV1AuditLogConfigLogType']]:
        """
        The log type that this config enables.
        """
        return pulumi.get(self, "log_type")

    @log_type.setter
    def log_type(self, value: Optional[pulumi.Input['GoogleIamV1AuditLogConfigLogType']]):
        pulumi.set(self, "log_type", value)


@pulumi.input_type
class GoogleIamV1BindingArgs:
    def __init__(__self__, *,
                 condition: Optional[pulumi.Input['ExprArgs']] = None,
                 members: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 role: Optional[pulumi.Input[str]] = None):
        """
        Associates `members`, or principals, with a `role`.
        :param pulumi.Input['ExprArgs'] condition: The condition that is associated with this binding. If the condition evaluates to `true`, then this binding applies to the current request. If the condition evaluates to `false`, then this binding does not apply to the current request. However, a different role binding might grant the same role to one or more of the principals in this binding. To learn which resources support conditions in their IAM policies, see the [IAM documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] members: Specifies the principals requesting access for a Google Cloud resource. `members` can have the following values: * `allUsers`: A special identifier that represents anyone who is on the internet; with or without a Google account. * `allAuthenticatedUsers`: A special identifier that represents anyone who is authenticated with a Google account or a service account. Does not include identities that come from external identity providers (IdPs) through identity federation. * `user:{emailid}`: An email address that represents a specific Google account. For example, `alice@example.com` . * `serviceAccount:{emailid}`: An email address that represents a Google service account. For example, `my-other-app@appspot.gserviceaccount.com`. * `serviceAccount:{projectid}.svc.id.goog[{namespace}/{kubernetes-sa}]`: An identifier for a [Kubernetes service account](https://cloud.google.com/kubernetes-engine/docs/how-to/kubernetes-service-accounts). For example, `my-project.svc.id.goog[my-namespace/my-kubernetes-sa]`. * `group:{emailid}`: An email address that represents a Google group. For example, `admins@example.com`. * `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a user that has been recently deleted. For example, `alice@example.com?uid=123456789012345678901`. If the user is recovered, this value reverts to `user:{emailid}` and the recovered user retains the role in the binding. * `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a service account that has been recently deleted. For example, `my-other-app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the service account is undeleted, this value reverts to `serviceAccount:{emailid}` and the undeleted service account retains the role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a Google group that has been recently deleted. For example, `admins@example.com?uid=123456789012345678901`. If the group is recovered, this value reverts to `group:{emailid}` and the recovered group retains the role in the binding. * `domain:{domain}`: The G Suite domain (primary) that represents all the users of that domain. For example, `google.com` or `example.com`. 
        :param pulumi.Input[str] role: Role that is assigned to the list of `members`, or principals. For example, `roles/viewer`, `roles/editor`, or `roles/owner`.
        """
        if condition is not None:
            pulumi.set(__self__, "condition", condition)
        if members is not None:
            pulumi.set(__self__, "members", members)
        if role is not None:
            pulumi.set(__self__, "role", role)

    @property
    @pulumi.getter
    def condition(self) -> Optional[pulumi.Input['ExprArgs']]:
        """
        The condition that is associated with this binding. If the condition evaluates to `true`, then this binding applies to the current request. If the condition evaluates to `false`, then this binding does not apply to the current request. However, a different role binding might grant the same role to one or more of the principals in this binding. To learn which resources support conditions in their IAM policies, see the [IAM documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
        """
        return pulumi.get(self, "condition")

    @condition.setter
    def condition(self, value: Optional[pulumi.Input['ExprArgs']]):
        pulumi.set(self, "condition", value)

    @property
    @pulumi.getter
    def members(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies the principals requesting access for a Google Cloud resource. `members` can have the following values: * `allUsers`: A special identifier that represents anyone who is on the internet; with or without a Google account. * `allAuthenticatedUsers`: A special identifier that represents anyone who is authenticated with a Google account or a service account. Does not include identities that come from external identity providers (IdPs) through identity federation. * `user:{emailid}`: An email address that represents a specific Google account. For example, `alice@example.com` . * `serviceAccount:{emailid}`: An email address that represents a Google service account. For example, `my-other-app@appspot.gserviceaccount.com`. * `serviceAccount:{projectid}.svc.id.goog[{namespace}/{kubernetes-sa}]`: An identifier for a [Kubernetes service account](https://cloud.google.com/kubernetes-engine/docs/how-to/kubernetes-service-accounts). For example, `my-project.svc.id.goog[my-namespace/my-kubernetes-sa]`. * `group:{emailid}`: An email address that represents a Google group. For example, `admins@example.com`. * `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a user that has been recently deleted. For example, `alice@example.com?uid=123456789012345678901`. If the user is recovered, this value reverts to `user:{emailid}` and the recovered user retains the role in the binding. * `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a service account that has been recently deleted. For example, `my-other-app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the service account is undeleted, this value reverts to `serviceAccount:{emailid}` and the undeleted service account retains the role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a Google group that has been recently deleted. For example, `admins@example.com?uid=123456789012345678901`. If the group is recovered, this value reverts to `group:{emailid}` and the recovered group retains the role in the binding. * `domain:{domain}`: The G Suite domain (primary) that represents all the users of that domain. For example, `google.com` or `example.com`. 
        """
        return pulumi.get(self, "members")

    @members.setter
    def members(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "members", value)

    @property
    @pulumi.getter
    def role(self) -> Optional[pulumi.Input[str]]:
        """
        Role that is assigned to the list of `members`, or principals. For example, `roles/viewer`, `roles/editor`, or `roles/owner`.
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "role", value)


@pulumi.input_type
class ManagedZoneCloudLoggingConfigArgs:
    def __init__(__self__, *,
                 enable_logging: Optional[pulumi.Input[bool]] = None,
                 kind: Optional[pulumi.Input[str]] = None):
        """
        Cloud Logging configurations for publicly visible zones.
        :param pulumi.Input[bool] enable_logging: If set, enable query logging for this ManagedZone. False by default, making logging opt-in.
        """
        if enable_logging is not None:
            pulumi.set(__self__, "enable_logging", enable_logging)
        if kind is not None:
            pulumi.set(__self__, "kind", kind)

    @property
    @pulumi.getter(name="enableLogging")
    def enable_logging(self) -> Optional[pulumi.Input[bool]]:
        """
        If set, enable query logging for this ManagedZone. False by default, making logging opt-in.
        """
        return pulumi.get(self, "enable_logging")

    @enable_logging.setter
    def enable_logging(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_logging", value)

    @property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kind", value)


@pulumi.input_type
class ManagedZoneDnsSecConfigArgs:
    def __init__(__self__, *,
                 default_key_specs: Optional[pulumi.Input[Sequence[pulumi.Input['DnsKeySpecArgs']]]] = None,
                 kind: Optional[pulumi.Input[str]] = None,
                 non_existence: Optional[pulumi.Input['ManagedZoneDnsSecConfigNonExistence']] = None,
                 state: Optional[pulumi.Input['ManagedZoneDnsSecConfigState']] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['DnsKeySpecArgs']]] default_key_specs: Specifies parameters for generating initial DnsKeys for this ManagedZone. Can only be changed while the state is OFF.
        :param pulumi.Input['ManagedZoneDnsSecConfigNonExistence'] non_existence: Specifies the mechanism for authenticated denial-of-existence responses. Can only be changed while the state is OFF.
        :param pulumi.Input['ManagedZoneDnsSecConfigState'] state: Specifies whether DNSSEC is enabled, and what mode it is in.
        """
        if default_key_specs is not None:
            pulumi.set(__self__, "default_key_specs", default_key_specs)
        if kind is not None:
            pulumi.set(__self__, "kind", kind)
        if non_existence is not None:
            pulumi.set(__self__, "non_existence", non_existence)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="defaultKeySpecs")
    def default_key_specs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DnsKeySpecArgs']]]]:
        """
        Specifies parameters for generating initial DnsKeys for this ManagedZone. Can only be changed while the state is OFF.
        """
        return pulumi.get(self, "default_key_specs")

    @default_key_specs.setter
    def default_key_specs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DnsKeySpecArgs']]]]):
        pulumi.set(self, "default_key_specs", value)

    @property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter(name="nonExistence")
    def non_existence(self) -> Optional[pulumi.Input['ManagedZoneDnsSecConfigNonExistence']]:
        """
        Specifies the mechanism for authenticated denial-of-existence responses. Can only be changed while the state is OFF.
        """
        return pulumi.get(self, "non_existence")

    @non_existence.setter
    def non_existence(self, value: Optional[pulumi.Input['ManagedZoneDnsSecConfigNonExistence']]):
        pulumi.set(self, "non_existence", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input['ManagedZoneDnsSecConfigState']]:
        """
        Specifies whether DNSSEC is enabled, and what mode it is in.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input['ManagedZoneDnsSecConfigState']]):
        pulumi.set(self, "state", value)


@pulumi.input_type
class ManagedZoneForwardingConfigNameServerTargetArgs:
    def __init__(__self__, *,
                 forwarding_path: Optional[pulumi.Input['ManagedZoneForwardingConfigNameServerTargetForwardingPath']] = None,
                 ipv4_address: Optional[pulumi.Input[str]] = None,
                 kind: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input['ManagedZoneForwardingConfigNameServerTargetForwardingPath'] forwarding_path: Forwarding path for this NameServerTarget. If unset or set to DEFAULT, Cloud DNS makes forwarding decisions based on IP address ranges; that is, RFC1918 addresses go to the VPC network, non-RFC1918 addresses go to the internet. When set to PRIVATE, Cloud DNS always sends queries through the VPC network for this target.
        :param pulumi.Input[str] ipv4_address: IPv4 address of a target name server.
        """
        if forwarding_path is not None:
            pulumi.set(__self__, "forwarding_path", forwarding_path)
        if ipv4_address is not None:
            pulumi.set(__self__, "ipv4_address", ipv4_address)
        if kind is not None:
            pulumi.set(__self__, "kind", kind)

    @property
    @pulumi.getter(name="forwardingPath")
    def forwarding_path(self) -> Optional[pulumi.Input['ManagedZoneForwardingConfigNameServerTargetForwardingPath']]:
        """
        Forwarding path for this NameServerTarget. If unset or set to DEFAULT, Cloud DNS makes forwarding decisions based on IP address ranges; that is, RFC1918 addresses go to the VPC network, non-RFC1918 addresses go to the internet. When set to PRIVATE, Cloud DNS always sends queries through the VPC network for this target.
        """
        return pulumi.get(self, "forwarding_path")

    @forwarding_path.setter
    def forwarding_path(self, value: Optional[pulumi.Input['ManagedZoneForwardingConfigNameServerTargetForwardingPath']]):
        pulumi.set(self, "forwarding_path", value)

    @property
    @pulumi.getter(name="ipv4Address")
    def ipv4_address(self) -> Optional[pulumi.Input[str]]:
        """
        IPv4 address of a target name server.
        """
        return pulumi.get(self, "ipv4_address")

    @ipv4_address.setter
    def ipv4_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ipv4_address", value)

    @property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kind", value)


@pulumi.input_type
class ManagedZoneForwardingConfigArgs:
    def __init__(__self__, *,
                 kind: Optional[pulumi.Input[str]] = None,
                 target_name_servers: Optional[pulumi.Input[Sequence[pulumi.Input['ManagedZoneForwardingConfigNameServerTargetArgs']]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['ManagedZoneForwardingConfigNameServerTargetArgs']]] target_name_servers: List of target name servers to forward to. Cloud DNS selects the best available name server if more than one target is given.
        """
        if kind is not None:
            pulumi.set(__self__, "kind", kind)
        if target_name_servers is not None:
            pulumi.set(__self__, "target_name_servers", target_name_servers)

    @property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter(name="targetNameServers")
    def target_name_servers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ManagedZoneForwardingConfigNameServerTargetArgs']]]]:
        """
        List of target name servers to forward to. Cloud DNS selects the best available name server if more than one target is given.
        """
        return pulumi.get(self, "target_name_servers")

    @target_name_servers.setter
    def target_name_servers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ManagedZoneForwardingConfigNameServerTargetArgs']]]]):
        pulumi.set(self, "target_name_servers", value)


@pulumi.input_type
class ManagedZonePeeringConfigTargetNetworkArgs:
    def __init__(__self__, *,
                 deactivate_time: Optional[pulumi.Input[str]] = None,
                 kind: Optional[pulumi.Input[str]] = None,
                 network_url: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] deactivate_time: The time at which the zone was deactivated, in RFC 3339 date-time format. An empty string indicates that the peering connection is active. The producer network can deactivate a zone. The zone is automatically deactivated if the producer network that the zone targeted is deleted. Output only.
        :param pulumi.Input[str] network_url: The fully qualified URL of the VPC network to forward queries to. This should be formatted like https://www.googleapis.com/compute/v1/projects/{project}/global/networks/{network}
        """
        if deactivate_time is not None:
            pulumi.set(__self__, "deactivate_time", deactivate_time)
        if kind is not None:
            pulumi.set(__self__, "kind", kind)
        if network_url is not None:
            pulumi.set(__self__, "network_url", network_url)

    @property
    @pulumi.getter(name="deactivateTime")
    def deactivate_time(self) -> Optional[pulumi.Input[str]]:
        """
        The time at which the zone was deactivated, in RFC 3339 date-time format. An empty string indicates that the peering connection is active. The producer network can deactivate a zone. The zone is automatically deactivated if the producer network that the zone targeted is deleted. Output only.
        """
        return pulumi.get(self, "deactivate_time")

    @deactivate_time.setter
    def deactivate_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "deactivate_time", value)

    @property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter(name="networkUrl")
    def network_url(self) -> Optional[pulumi.Input[str]]:
        """
        The fully qualified URL of the VPC network to forward queries to. This should be formatted like https://www.googleapis.com/compute/v1/projects/{project}/global/networks/{network}
        """
        return pulumi.get(self, "network_url")

    @network_url.setter
    def network_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network_url", value)


@pulumi.input_type
class ManagedZonePeeringConfigArgs:
    def __init__(__self__, *,
                 kind: Optional[pulumi.Input[str]] = None,
                 target_network: Optional[pulumi.Input['ManagedZonePeeringConfigTargetNetworkArgs']] = None):
        """
        :param pulumi.Input['ManagedZonePeeringConfigTargetNetworkArgs'] target_network: The network with which to peer.
        """
        if kind is not None:
            pulumi.set(__self__, "kind", kind)
        if target_network is not None:
            pulumi.set(__self__, "target_network", target_network)

    @property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter(name="targetNetwork")
    def target_network(self) -> Optional[pulumi.Input['ManagedZonePeeringConfigTargetNetworkArgs']]:
        """
        The network with which to peer.
        """
        return pulumi.get(self, "target_network")

    @target_network.setter
    def target_network(self, value: Optional[pulumi.Input['ManagedZonePeeringConfigTargetNetworkArgs']]):
        pulumi.set(self, "target_network", value)


@pulumi.input_type
class ManagedZonePrivateVisibilityConfigGKEClusterArgs:
    def __init__(__self__, *,
                 gke_cluster_name: Optional[pulumi.Input[str]] = None,
                 kind: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] gke_cluster_name: The resource name of the cluster to bind this ManagedZone to. This should be specified in the format like: projects/*/locations/*/clusters/*. This is referenced from GKE projects.locations.clusters.get API: https://cloud.google.com/kubernetes-engine/docs/reference/rest/v1/projects.locations.clusters/get
        """
        if gke_cluster_name is not None:
            pulumi.set(__self__, "gke_cluster_name", gke_cluster_name)
        if kind is not None:
            pulumi.set(__self__, "kind", kind)

    @property
    @pulumi.getter(name="gkeClusterName")
    def gke_cluster_name(self) -> Optional[pulumi.Input[str]]:
        """
        The resource name of the cluster to bind this ManagedZone to. This should be specified in the format like: projects/*/locations/*/clusters/*. This is referenced from GKE projects.locations.clusters.get API: https://cloud.google.com/kubernetes-engine/docs/reference/rest/v1/projects.locations.clusters/get
        """
        return pulumi.get(self, "gke_cluster_name")

    @gke_cluster_name.setter
    def gke_cluster_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "gke_cluster_name", value)

    @property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kind", value)


@pulumi.input_type
class ManagedZonePrivateVisibilityConfigNetworkArgs:
    def __init__(__self__, *,
                 kind: Optional[pulumi.Input[str]] = None,
                 network_url: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] network_url: The fully qualified URL of the VPC network to bind to. Format this URL like https://www.googleapis.com/compute/v1/projects/{project}/global/networks/{network}
        """
        if kind is not None:
            pulumi.set(__self__, "kind", kind)
        if network_url is not None:
            pulumi.set(__self__, "network_url", network_url)

    @property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter(name="networkUrl")
    def network_url(self) -> Optional[pulumi.Input[str]]:
        """
        The fully qualified URL of the VPC network to bind to. Format this URL like https://www.googleapis.com/compute/v1/projects/{project}/global/networks/{network}
        """
        return pulumi.get(self, "network_url")

    @network_url.setter
    def network_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network_url", value)


@pulumi.input_type
class ManagedZonePrivateVisibilityConfigArgs:
    def __init__(__self__, *,
                 gke_clusters: Optional[pulumi.Input[Sequence[pulumi.Input['ManagedZonePrivateVisibilityConfigGKEClusterArgs']]]] = None,
                 kind: Optional[pulumi.Input[str]] = None,
                 networks: Optional[pulumi.Input[Sequence[pulumi.Input['ManagedZonePrivateVisibilityConfigNetworkArgs']]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['ManagedZonePrivateVisibilityConfigGKEClusterArgs']]] gke_clusters: The list of Google Kubernetes Engine clusters that can see this zone.
        :param pulumi.Input[Sequence[pulumi.Input['ManagedZonePrivateVisibilityConfigNetworkArgs']]] networks: The list of VPC networks that can see this zone.
        """
        if gke_clusters is not None:
            pulumi.set(__self__, "gke_clusters", gke_clusters)
        if kind is not None:
            pulumi.set(__self__, "kind", kind)
        if networks is not None:
            pulumi.set(__self__, "networks", networks)

    @property
    @pulumi.getter(name="gkeClusters")
    def gke_clusters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ManagedZonePrivateVisibilityConfigGKEClusterArgs']]]]:
        """
        The list of Google Kubernetes Engine clusters that can see this zone.
        """
        return pulumi.get(self, "gke_clusters")

    @gke_clusters.setter
    def gke_clusters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ManagedZonePrivateVisibilityConfigGKEClusterArgs']]]]):
        pulumi.set(self, "gke_clusters", value)

    @property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter
    def networks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ManagedZonePrivateVisibilityConfigNetworkArgs']]]]:
        """
        The list of VPC networks that can see this zone.
        """
        return pulumi.get(self, "networks")

    @networks.setter
    def networks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ManagedZonePrivateVisibilityConfigNetworkArgs']]]]):
        pulumi.set(self, "networks", value)


@pulumi.input_type
class ManagedZoneReverseLookupConfigArgs:
    def __init__(__self__, *,
                 kind: Optional[pulumi.Input[str]] = None):
        if kind is not None:
            pulumi.set(__self__, "kind", kind)

    @property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kind", value)


@pulumi.input_type
class ManagedZoneServiceDirectoryConfigNamespaceArgs:
    def __init__(__self__, *,
                 deletion_time: Optional[pulumi.Input[str]] = None,
                 kind: Optional[pulumi.Input[str]] = None,
                 namespace_url: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] deletion_time: The time that the namespace backing this zone was deleted; an empty string if it still exists. This is in RFC3339 text format. Output only.
        :param pulumi.Input[str] namespace_url: The fully qualified URL of the namespace associated with the zone. Format must be https://servicedirectory.googleapis.com/v1/projects/{project}/locations/{location}/namespaces/{namespace}
        """
        if deletion_time is not None:
            pulumi.set(__self__, "deletion_time", deletion_time)
        if kind is not None:
            pulumi.set(__self__, "kind", kind)
        if namespace_url is not None:
            pulumi.set(__self__, "namespace_url", namespace_url)

    @property
    @pulumi.getter(name="deletionTime")
    def deletion_time(self) -> Optional[pulumi.Input[str]]:
        """
        The time that the namespace backing this zone was deleted; an empty string if it still exists. This is in RFC3339 text format. Output only.
        """
        return pulumi.get(self, "deletion_time")

    @deletion_time.setter
    def deletion_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "deletion_time", value)

    @property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter(name="namespaceUrl")
    def namespace_url(self) -> Optional[pulumi.Input[str]]:
        """
        The fully qualified URL of the namespace associated with the zone. Format must be https://servicedirectory.googleapis.com/v1/projects/{project}/locations/{location}/namespaces/{namespace}
        """
        return pulumi.get(self, "namespace_url")

    @namespace_url.setter
    def namespace_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "namespace_url", value)


@pulumi.input_type
class ManagedZoneServiceDirectoryConfigArgs:
    def __init__(__self__, *,
                 kind: Optional[pulumi.Input[str]] = None,
                 namespace: Optional[pulumi.Input['ManagedZoneServiceDirectoryConfigNamespaceArgs']] = None):
        """
        Contains information about Service Directory-backed zones.
        :param pulumi.Input['ManagedZoneServiceDirectoryConfigNamespaceArgs'] namespace: Contains information about the namespace associated with the zone.
        """
        if kind is not None:
            pulumi.set(__self__, "kind", kind)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)

    @property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input['ManagedZoneServiceDirectoryConfigNamespaceArgs']]:
        """
        Contains information about the namespace associated with the zone.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input['ManagedZoneServiceDirectoryConfigNamespaceArgs']]):
        pulumi.set(self, "namespace", value)


@pulumi.input_type
class PolicyAlternativeNameServerConfigTargetNameServerArgs:
    def __init__(__self__, *,
                 forwarding_path: Optional[pulumi.Input['PolicyAlternativeNameServerConfigTargetNameServerForwardingPath']] = None,
                 ipv4_address: Optional[pulumi.Input[str]] = None,
                 kind: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input['PolicyAlternativeNameServerConfigTargetNameServerForwardingPath'] forwarding_path: Forwarding path for this TargetNameServer. If unset or set to DEFAULT, Cloud DNS makes forwarding decisions based on address ranges; that is, RFC1918 addresses go to the VPC network, non-RFC1918 addresses go to the internet. When set to PRIVATE, Cloud DNS always sends queries through the VPC network for this target.
        :param pulumi.Input[str] ipv4_address: IPv4 address to forward to.
        """
        if forwarding_path is not None:
            pulumi.set(__self__, "forwarding_path", forwarding_path)
        if ipv4_address is not None:
            pulumi.set(__self__, "ipv4_address", ipv4_address)
        if kind is not None:
            pulumi.set(__self__, "kind", kind)

    @property
    @pulumi.getter(name="forwardingPath")
    def forwarding_path(self) -> Optional[pulumi.Input['PolicyAlternativeNameServerConfigTargetNameServerForwardingPath']]:
        """
        Forwarding path for this TargetNameServer. If unset or set to DEFAULT, Cloud DNS makes forwarding decisions based on address ranges; that is, RFC1918 addresses go to the VPC network, non-RFC1918 addresses go to the internet. When set to PRIVATE, Cloud DNS always sends queries through the VPC network for this target.
        """
        return pulumi.get(self, "forwarding_path")

    @forwarding_path.setter
    def forwarding_path(self, value: Optional[pulumi.Input['PolicyAlternativeNameServerConfigTargetNameServerForwardingPath']]):
        pulumi.set(self, "forwarding_path", value)

    @property
    @pulumi.getter(name="ipv4Address")
    def ipv4_address(self) -> Optional[pulumi.Input[str]]:
        """
        IPv4 address to forward to.
        """
        return pulumi.get(self, "ipv4_address")

    @ipv4_address.setter
    def ipv4_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ipv4_address", value)

    @property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kind", value)


@pulumi.input_type
class PolicyAlternativeNameServerConfigArgs:
    def __init__(__self__, *,
                 kind: Optional[pulumi.Input[str]] = None,
                 target_name_servers: Optional[pulumi.Input[Sequence[pulumi.Input['PolicyAlternativeNameServerConfigTargetNameServerArgs']]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['PolicyAlternativeNameServerConfigTargetNameServerArgs']]] target_name_servers: Sets an alternative name server for the associated networks. When specified, all DNS queries are forwarded to a name server that you choose. Names such as .internal are not available when an alternative name server is specified.
        """
        if kind is not None:
            pulumi.set(__self__, "kind", kind)
        if target_name_servers is not None:
            pulumi.set(__self__, "target_name_servers", target_name_servers)

    @property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter(name="targetNameServers")
    def target_name_servers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PolicyAlternativeNameServerConfigTargetNameServerArgs']]]]:
        """
        Sets an alternative name server for the associated networks. When specified, all DNS queries are forwarded to a name server that you choose. Names such as .internal are not available when an alternative name server is specified.
        """
        return pulumi.get(self, "target_name_servers")

    @target_name_servers.setter
    def target_name_servers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PolicyAlternativeNameServerConfigTargetNameServerArgs']]]]):
        pulumi.set(self, "target_name_servers", value)


@pulumi.input_type
class PolicyNetworkArgs:
    def __init__(__self__, *,
                 kind: Optional[pulumi.Input[str]] = None,
                 network_url: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] network_url: The fully qualified URL of the VPC network to bind to. This should be formatted like https://www.googleapis.com/compute/v1/projects/{project}/global/networks/{network}
        """
        if kind is not None:
            pulumi.set(__self__, "kind", kind)
        if network_url is not None:
            pulumi.set(__self__, "network_url", network_url)

    @property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter(name="networkUrl")
    def network_url(self) -> Optional[pulumi.Input[str]]:
        """
        The fully qualified URL of the VPC network to bind to. This should be formatted like https://www.googleapis.com/compute/v1/projects/{project}/global/networks/{network}
        """
        return pulumi.get(self, "network_url")

    @network_url.setter
    def network_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network_url", value)


@pulumi.input_type
class RRSetRoutingPolicyGeoPolicyGeoPolicyItemArgs:
    def __init__(__self__, *,
                 health_checked_targets: Optional[pulumi.Input['RRSetRoutingPolicyHealthCheckTargetsArgs']] = None,
                 kind: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 rrdatas: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 signature_rrdatas: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        ResourceRecordSet data for one geo location.
        :param pulumi.Input['RRSetRoutingPolicyHealthCheckTargetsArgs'] health_checked_targets: For A and AAAA types only. Endpoints to return in the query result only if they are healthy. These can be specified along with rrdata within this item.
        :param pulumi.Input[str] location: The geo-location granularity is a GCP region. This location string should correspond to a GCP region. e.g. "us-east1", "southamerica-east1", "asia-east1", etc.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] signature_rrdatas: DNSSEC generated signatures for all the rrdata within this item. Note that if health checked targets are provided for DNSSEC enabled zones, there's a restriction of 1 ip per item. .
        """
        if health_checked_targets is not None:
            pulumi.set(__self__, "health_checked_targets", health_checked_targets)
        if kind is not None:
            pulumi.set(__self__, "kind", kind)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if rrdatas is not None:
            pulumi.set(__self__, "rrdatas", rrdatas)
        if signature_rrdatas is not None:
            pulumi.set(__self__, "signature_rrdatas", signature_rrdatas)

    @property
    @pulumi.getter(name="healthCheckedTargets")
    def health_checked_targets(self) -> Optional[pulumi.Input['RRSetRoutingPolicyHealthCheckTargetsArgs']]:
        """
        For A and AAAA types only. Endpoints to return in the query result only if they are healthy. These can be specified along with rrdata within this item.
        """
        return pulumi.get(self, "health_checked_targets")

    @health_checked_targets.setter
    def health_checked_targets(self, value: Optional[pulumi.Input['RRSetRoutingPolicyHealthCheckTargetsArgs']]):
        pulumi.set(self, "health_checked_targets", value)

    @property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        The geo-location granularity is a GCP region. This location string should correspond to a GCP region. e.g. "us-east1", "southamerica-east1", "asia-east1", etc.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def rrdatas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "rrdatas")

    @rrdatas.setter
    def rrdatas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "rrdatas", value)

    @property
    @pulumi.getter(name="signatureRrdatas")
    def signature_rrdatas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        DNSSEC generated signatures for all the rrdata within this item. Note that if health checked targets are provided for DNSSEC enabled zones, there's a restriction of 1 ip per item. .
        """
        return pulumi.get(self, "signature_rrdatas")

    @signature_rrdatas.setter
    def signature_rrdatas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "signature_rrdatas", value)


@pulumi.input_type
class RRSetRoutingPolicyGeoPolicyArgs:
    def __init__(__self__, *,
                 enable_fencing: Optional[pulumi.Input[bool]] = None,
                 items: Optional[pulumi.Input[Sequence[pulumi.Input['RRSetRoutingPolicyGeoPolicyGeoPolicyItemArgs']]]] = None,
                 kind: Optional[pulumi.Input[str]] = None):
        """
        Configures a RRSetRoutingPolicy that routes based on the geo location of the querying user.
        :param pulumi.Input[bool] enable_fencing: Without fencing, if health check fails for all configured items in the current geo bucket, we'll failover to the next nearest geo bucket. With fencing, if health check is enabled, as long as some targets in the current geo bucket are healthy, we'll return only the healthy targets. However, if they're all unhealthy, we won't failover to the next nearest bucket, we'll simply return all the items in the current bucket even though they're unhealthy.
        :param pulumi.Input[Sequence[pulumi.Input['RRSetRoutingPolicyGeoPolicyGeoPolicyItemArgs']]] items: The primary geo routing configuration. If there are multiple items with the same location, an error is returned instead.
        """
        if enable_fencing is not None:
            pulumi.set(__self__, "enable_fencing", enable_fencing)
        if items is not None:
            pulumi.set(__self__, "items", items)
        if kind is not None:
            pulumi.set(__self__, "kind", kind)

    @property
    @pulumi.getter(name="enableFencing")
    def enable_fencing(self) -> Optional[pulumi.Input[bool]]:
        """
        Without fencing, if health check fails for all configured items in the current geo bucket, we'll failover to the next nearest geo bucket. With fencing, if health check is enabled, as long as some targets in the current geo bucket are healthy, we'll return only the healthy targets. However, if they're all unhealthy, we won't failover to the next nearest bucket, we'll simply return all the items in the current bucket even though they're unhealthy.
        """
        return pulumi.get(self, "enable_fencing")

    @enable_fencing.setter
    def enable_fencing(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_fencing", value)

    @property
    @pulumi.getter
    def items(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RRSetRoutingPolicyGeoPolicyGeoPolicyItemArgs']]]]:
        """
        The primary geo routing configuration. If there are multiple items with the same location, an error is returned instead.
        """
        return pulumi.get(self, "items")

    @items.setter
    def items(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RRSetRoutingPolicyGeoPolicyGeoPolicyItemArgs']]]]):
        pulumi.set(self, "items", value)

    @property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kind", value)


@pulumi.input_type
class RRSetRoutingPolicyHealthCheckTargetsArgs:
    def __init__(__self__, *,
                 internal_load_balancers: Optional[pulumi.Input[Sequence[pulumi.Input['RRSetRoutingPolicyLoadBalancerTargetArgs']]]] = None):
        """
        HealthCheckTargets describes endpoints to health-check when responding to Routing Policy queries. Only the healthy endpoints will be included in the response.
        """
        if internal_load_balancers is not None:
            pulumi.set(__self__, "internal_load_balancers", internal_load_balancers)

    @property
    @pulumi.getter(name="internalLoadBalancers")
    def internal_load_balancers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RRSetRoutingPolicyLoadBalancerTargetArgs']]]]:
        return pulumi.get(self, "internal_load_balancers")

    @internal_load_balancers.setter
    def internal_load_balancers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RRSetRoutingPolicyLoadBalancerTargetArgs']]]]):
        pulumi.set(self, "internal_load_balancers", value)


@pulumi.input_type
class RRSetRoutingPolicyLoadBalancerTargetArgs:
    def __init__(__self__, *,
                 ip_address: Optional[pulumi.Input[str]] = None,
                 ip_protocol: Optional[pulumi.Input['RRSetRoutingPolicyLoadBalancerTargetIpProtocol']] = None,
                 kind: Optional[pulumi.Input[str]] = None,
                 load_balancer_type: Optional[pulumi.Input['RRSetRoutingPolicyLoadBalancerTargetLoadBalancerType']] = None,
                 network_url: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] ip_address: The frontend IP address of the
        :param pulumi.Input[str] network_url: The fully qualified url of the network on which the ILB is
        :param pulumi.Input[str] port: Load Balancer to health check. The configured port of the Load Balancer.
        :param pulumi.Input[str] project: present. This should be formatted like https://www.googleapis.com/compute/v1/projects/{project}/global/networks/{network} The project ID in which the ILB exists.
        :param pulumi.Input[str] region: The region for regional ILBs.
        """
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if ip_protocol is not None:
            pulumi.set(__self__, "ip_protocol", ip_protocol)
        if kind is not None:
            pulumi.set(__self__, "kind", kind)
        if load_balancer_type is not None:
            pulumi.set(__self__, "load_balancer_type", load_balancer_type)
        if network_url is not None:
            pulumi.set(__self__, "network_url", network_url)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[pulumi.Input[str]]:
        """
        The frontend IP address of the
        """
        return pulumi.get(self, "ip_address")

    @ip_address.setter
    def ip_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip_address", value)

    @property
    @pulumi.getter(name="ipProtocol")
    def ip_protocol(self) -> Optional[pulumi.Input['RRSetRoutingPolicyLoadBalancerTargetIpProtocol']]:
        return pulumi.get(self, "ip_protocol")

    @ip_protocol.setter
    def ip_protocol(self, value: Optional[pulumi.Input['RRSetRoutingPolicyLoadBalancerTargetIpProtocol']]):
        pulumi.set(self, "ip_protocol", value)

    @property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter(name="loadBalancerType")
    def load_balancer_type(self) -> Optional[pulumi.Input['RRSetRoutingPolicyLoadBalancerTargetLoadBalancerType']]:
        return pulumi.get(self, "load_balancer_type")

    @load_balancer_type.setter
    def load_balancer_type(self, value: Optional[pulumi.Input['RRSetRoutingPolicyLoadBalancerTargetLoadBalancerType']]):
        pulumi.set(self, "load_balancer_type", value)

    @property
    @pulumi.getter(name="networkUrl")
    def network_url(self) -> Optional[pulumi.Input[str]]:
        """
        The fully qualified url of the network on which the ILB is
        """
        return pulumi.get(self, "network_url")

    @network_url.setter
    def network_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network_url", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[str]]:
        """
        Load Balancer to health check. The configured port of the Load Balancer.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        present. This should be formatted like https://www.googleapis.com/compute/v1/projects/{project}/global/networks/{network} The project ID in which the ILB exists.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region for regional ILBs.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class RRSetRoutingPolicyPrimaryBackupPolicyArgs:
    def __init__(__self__, *,
                 backup_geo_targets: Optional[pulumi.Input['RRSetRoutingPolicyGeoPolicyArgs']] = None,
                 kind: Optional[pulumi.Input[str]] = None,
                 primary_targets: Optional[pulumi.Input['RRSetRoutingPolicyHealthCheckTargetsArgs']] = None,
                 trickle_traffic: Optional[pulumi.Input[float]] = None):
        """
        Configures a RRSetRoutingPolicy such that all queries are responded with the primary_targets if they are healthy. And if all of them are unhealthy, then we fallback to a geo localized policy.
        :param pulumi.Input['RRSetRoutingPolicyGeoPolicyArgs'] backup_geo_targets: Backup targets provide a regional failover policy for the otherwise global primary targets. If serving state is set to BACKUP, this policy essentially becomes a geo routing policy.
        :param pulumi.Input[float] trickle_traffic: When serving state is PRIMARY, this field provides the option of sending a small percentage of the traffic to the backup targets.
        """
        if backup_geo_targets is not None:
            pulumi.set(__self__, "backup_geo_targets", backup_geo_targets)
        if kind is not None:
            pulumi.set(__self__, "kind", kind)
        if primary_targets is not None:
            pulumi.set(__self__, "primary_targets", primary_targets)
        if trickle_traffic is not None:
            pulumi.set(__self__, "trickle_traffic", trickle_traffic)

    @property
    @pulumi.getter(name="backupGeoTargets")
    def backup_geo_targets(self) -> Optional[pulumi.Input['RRSetRoutingPolicyGeoPolicyArgs']]:
        """
        Backup targets provide a regional failover policy for the otherwise global primary targets. If serving state is set to BACKUP, this policy essentially becomes a geo routing policy.
        """
        return pulumi.get(self, "backup_geo_targets")

    @backup_geo_targets.setter
    def backup_geo_targets(self, value: Optional[pulumi.Input['RRSetRoutingPolicyGeoPolicyArgs']]):
        pulumi.set(self, "backup_geo_targets", value)

    @property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter(name="primaryTargets")
    def primary_targets(self) -> Optional[pulumi.Input['RRSetRoutingPolicyHealthCheckTargetsArgs']]:
        return pulumi.get(self, "primary_targets")

    @primary_targets.setter
    def primary_targets(self, value: Optional[pulumi.Input['RRSetRoutingPolicyHealthCheckTargetsArgs']]):
        pulumi.set(self, "primary_targets", value)

    @property
    @pulumi.getter(name="trickleTraffic")
    def trickle_traffic(self) -> Optional[pulumi.Input[float]]:
        """
        When serving state is PRIMARY, this field provides the option of sending a small percentage of the traffic to the backup targets.
        """
        return pulumi.get(self, "trickle_traffic")

    @trickle_traffic.setter
    def trickle_traffic(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "trickle_traffic", value)


@pulumi.input_type
class RRSetRoutingPolicyWrrPolicyWrrPolicyItemArgs:
    def __init__(__self__, *,
                 health_checked_targets: Optional[pulumi.Input['RRSetRoutingPolicyHealthCheckTargetsArgs']] = None,
                 kind: Optional[pulumi.Input[str]] = None,
                 rrdatas: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 signature_rrdatas: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 weight: Optional[pulumi.Input[float]] = None):
        """
        A routing block which contains the routing information for one WRR item.
        :param pulumi.Input['RRSetRoutingPolicyHealthCheckTargetsArgs'] health_checked_targets: endpoints that need to be health checked before making the routing decision. The unhealthy endpoints will be omitted from the result. If all endpoints within a buckete are unhealthy, we'll choose a different bucket (sampled w.r.t. its weight) for responding. Note that if DNSSEC is enabled for this zone, only one of rrdata or health_checked_targets can be set.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] signature_rrdatas: DNSSEC generated signatures for all the rrdata within this item. Note that if health checked targets are provided for DNSSEC enabled zones, there's a restriction of 1 ip per item. .
        :param pulumi.Input[float] weight: The weight corresponding to this subset of rrdata. When multiple WeightedRoundRobinPolicyItems are configured, the probability of returning an rrset is proportional to its weight relative to the sum of weights configured for all items. This weight should be non-negative.
        """
        if health_checked_targets is not None:
            pulumi.set(__self__, "health_checked_targets", health_checked_targets)
        if kind is not None:
            pulumi.set(__self__, "kind", kind)
        if rrdatas is not None:
            pulumi.set(__self__, "rrdatas", rrdatas)
        if signature_rrdatas is not None:
            pulumi.set(__self__, "signature_rrdatas", signature_rrdatas)
        if weight is not None:
            pulumi.set(__self__, "weight", weight)

    @property
    @pulumi.getter(name="healthCheckedTargets")
    def health_checked_targets(self) -> Optional[pulumi.Input['RRSetRoutingPolicyHealthCheckTargetsArgs']]:
        """
        endpoints that need to be health checked before making the routing decision. The unhealthy endpoints will be omitted from the result. If all endpoints within a buckete are unhealthy, we'll choose a different bucket (sampled w.r.t. its weight) for responding. Note that if DNSSEC is enabled for this zone, only one of rrdata or health_checked_targets can be set.
        """
        return pulumi.get(self, "health_checked_targets")

    @health_checked_targets.setter
    def health_checked_targets(self, value: Optional[pulumi.Input['RRSetRoutingPolicyHealthCheckTargetsArgs']]):
        pulumi.set(self, "health_checked_targets", value)

    @property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter
    def rrdatas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "rrdatas")

    @rrdatas.setter
    def rrdatas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "rrdatas", value)

    @property
    @pulumi.getter(name="signatureRrdatas")
    def signature_rrdatas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        DNSSEC generated signatures for all the rrdata within this item. Note that if health checked targets are provided for DNSSEC enabled zones, there's a restriction of 1 ip per item. .
        """
        return pulumi.get(self, "signature_rrdatas")

    @signature_rrdatas.setter
    def signature_rrdatas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "signature_rrdatas", value)

    @property
    @pulumi.getter
    def weight(self) -> Optional[pulumi.Input[float]]:
        """
        The weight corresponding to this subset of rrdata. When multiple WeightedRoundRobinPolicyItems are configured, the probability of returning an rrset is proportional to its weight relative to the sum of weights configured for all items. This weight should be non-negative.
        """
        return pulumi.get(self, "weight")

    @weight.setter
    def weight(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "weight", value)


@pulumi.input_type
class RRSetRoutingPolicyWrrPolicyArgs:
    def __init__(__self__, *,
                 items: Optional[pulumi.Input[Sequence[pulumi.Input['RRSetRoutingPolicyWrrPolicyWrrPolicyItemArgs']]]] = None,
                 kind: Optional[pulumi.Input[str]] = None):
        """
        Configures a RRSetRoutingPolicy that routes in a weighted round robin fashion.
        """
        if items is not None:
            pulumi.set(__self__, "items", items)
        if kind is not None:
            pulumi.set(__self__, "kind", kind)

    @property
    @pulumi.getter
    def items(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RRSetRoutingPolicyWrrPolicyWrrPolicyItemArgs']]]]:
        return pulumi.get(self, "items")

    @items.setter
    def items(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RRSetRoutingPolicyWrrPolicyWrrPolicyItemArgs']]]]):
        pulumi.set(self, "items", value)

    @property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kind", value)


@pulumi.input_type
class RRSetRoutingPolicyArgs:
    def __init__(__self__, *,
                 geo: Optional[pulumi.Input['RRSetRoutingPolicyGeoPolicyArgs']] = None,
                 kind: Optional[pulumi.Input[str]] = None,
                 primary_backup: Optional[pulumi.Input['RRSetRoutingPolicyPrimaryBackupPolicyArgs']] = None,
                 wrr: Optional[pulumi.Input['RRSetRoutingPolicyWrrPolicyArgs']] = None):
        """
        A RRSetRoutingPolicy represents ResourceRecordSet data that is returned dynamically with the response varying based on configured properties such as geolocation or by weighted random selection.
        """
        if geo is not None:
            pulumi.set(__self__, "geo", geo)
        if kind is not None:
            pulumi.set(__self__, "kind", kind)
        if primary_backup is not None:
            pulumi.set(__self__, "primary_backup", primary_backup)
        if wrr is not None:
            pulumi.set(__self__, "wrr", wrr)

    @property
    @pulumi.getter
    def geo(self) -> Optional[pulumi.Input['RRSetRoutingPolicyGeoPolicyArgs']]:
        return pulumi.get(self, "geo")

    @geo.setter
    def geo(self, value: Optional[pulumi.Input['RRSetRoutingPolicyGeoPolicyArgs']]):
        pulumi.set(self, "geo", value)

    @property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter(name="primaryBackup")
    def primary_backup(self) -> Optional[pulumi.Input['RRSetRoutingPolicyPrimaryBackupPolicyArgs']]:
        return pulumi.get(self, "primary_backup")

    @primary_backup.setter
    def primary_backup(self, value: Optional[pulumi.Input['RRSetRoutingPolicyPrimaryBackupPolicyArgs']]):
        pulumi.set(self, "primary_backup", value)

    @property
    @pulumi.getter
    def wrr(self) -> Optional[pulumi.Input['RRSetRoutingPolicyWrrPolicyArgs']]:
        return pulumi.get(self, "wrr")

    @wrr.setter
    def wrr(self, value: Optional[pulumi.Input['RRSetRoutingPolicyWrrPolicyArgs']]):
        pulumi.set(self, "wrr", value)


@pulumi.input_type
class ResourceRecordSetArgs:
    def __init__(__self__, *,
                 kind: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 routing_policy: Optional[pulumi.Input['RRSetRoutingPolicyArgs']] = None,
                 rrdatas: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 signature_rrdatas: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 ttl: Optional[pulumi.Input[int]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        A unit of data that is returned by the DNS servers.
        :param pulumi.Input[str] name: For example, www.example.com.
        :param pulumi.Input['RRSetRoutingPolicyArgs'] routing_policy: Configures dynamic query responses based on geo location of querying user or a weighted round robin based routing policy. A ResourceRecordSet should only have either rrdata (static) or routing_policy (dynamic). An error is returned otherwise.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] rrdatas: As defined in RFC 1035 (section 5) and RFC 1034 (section 3.6.1) -- see examples.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] signature_rrdatas: As defined in RFC 4034 (section 3.2).
        :param pulumi.Input[int] ttl: Number of seconds that this ResourceRecordSet can be cached by resolvers.
        :param pulumi.Input[str] type: The identifier of a supported record type. See the list of Supported DNS record types.
        """
        if kind is not None:
            pulumi.set(__self__, "kind", kind)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if routing_policy is not None:
            pulumi.set(__self__, "routing_policy", routing_policy)
        if rrdatas is not None:
            pulumi.set(__self__, "rrdatas", rrdatas)
        if signature_rrdatas is not None:
            pulumi.set(__self__, "signature_rrdatas", signature_rrdatas)
        if ttl is not None:
            pulumi.set(__self__, "ttl", ttl)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        For example, www.example.com.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="routingPolicy")
    def routing_policy(self) -> Optional[pulumi.Input['RRSetRoutingPolicyArgs']]:
        """
        Configures dynamic query responses based on geo location of querying user or a weighted round robin based routing policy. A ResourceRecordSet should only have either rrdata (static) or routing_policy (dynamic). An error is returned otherwise.
        """
        return pulumi.get(self, "routing_policy")

    @routing_policy.setter
    def routing_policy(self, value: Optional[pulumi.Input['RRSetRoutingPolicyArgs']]):
        pulumi.set(self, "routing_policy", value)

    @property
    @pulumi.getter
    def rrdatas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        As defined in RFC 1035 (section 5) and RFC 1034 (section 3.6.1) -- see examples.
        """
        return pulumi.get(self, "rrdatas")

    @rrdatas.setter
    def rrdatas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "rrdatas", value)

    @property
    @pulumi.getter(name="signatureRrdatas")
    def signature_rrdatas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        As defined in RFC 4034 (section 3.2).
        """
        return pulumi.get(self, "signature_rrdatas")

    @signature_rrdatas.setter
    def signature_rrdatas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "signature_rrdatas", value)

    @property
    @pulumi.getter
    def ttl(self) -> Optional[pulumi.Input[int]]:
        """
        Number of seconds that this ResourceRecordSet can be cached by resolvers.
        """
        return pulumi.get(self, "ttl")

    @ttl.setter
    def ttl(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ttl", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        The identifier of a supported record type. See the list of Supported DNS record types.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


