# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *
from ._inputs import *

__all__ = ['OccurrenceArgs', 'Occurrence']

@pulumi.input_type
class OccurrenceArgs:
    def __init__(__self__, *,
                 note_name: pulumi.Input[str],
                 resource_uri: pulumi.Input[str],
                 attestation: Optional[pulumi.Input['AttestationOccurrenceArgs']] = None,
                 build: Optional[pulumi.Input['BuildOccurrenceArgs']] = None,
                 compliance: Optional[pulumi.Input['ComplianceOccurrenceArgs']] = None,
                 deployment: Optional[pulumi.Input['DeploymentOccurrenceArgs']] = None,
                 discovery: Optional[pulumi.Input['DiscoveryOccurrenceArgs']] = None,
                 dsse_attestation: Optional[pulumi.Input['DSSEAttestationOccurrenceArgs']] = None,
                 envelope: Optional[pulumi.Input['EnvelopeArgs']] = None,
                 image: Optional[pulumi.Input['ImageOccurrenceArgs']] = None,
                 package: Optional[pulumi.Input['PackageOccurrenceArgs']] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 remediation: Optional[pulumi.Input[str]] = None,
                 upgrade: Optional[pulumi.Input['UpgradeOccurrenceArgs']] = None,
                 vulnerability: Optional[pulumi.Input['VulnerabilityOccurrenceArgs']] = None):
        """
        The set of arguments for constructing a Occurrence resource.
        :param pulumi.Input[str] note_name: Immutable. The analysis note associated with this occurrence, in the form of `projects/[PROVIDER_ID]/notes/[NOTE_ID]`. This field can be used as a filter in list requests.
        :param pulumi.Input[str] resource_uri: Immutable. A URI that represents the resource for which the occurrence applies. For example, `https://gcr.io/project/image@sha256:123abc` for a Docker image.
        :param pulumi.Input['AttestationOccurrenceArgs'] attestation: Describes an attestation of an artifact.
        :param pulumi.Input['BuildOccurrenceArgs'] build: Describes a verifiable build.
        :param pulumi.Input['ComplianceOccurrenceArgs'] compliance: Describes a compliance violation on a linked resource.
        :param pulumi.Input['DeploymentOccurrenceArgs'] deployment: Describes the deployment of an artifact on a runtime.
        :param pulumi.Input['DiscoveryOccurrenceArgs'] discovery: Describes when a resource was discovered.
        :param pulumi.Input['DSSEAttestationOccurrenceArgs'] dsse_attestation: Describes an attestation of an artifact using dsse.
        :param pulumi.Input['EnvelopeArgs'] envelope: https://github.com/secure-systems-lab/dsse
        :param pulumi.Input['ImageOccurrenceArgs'] image: Describes how this resource derives from the basis in the associated note.
        :param pulumi.Input['PackageOccurrenceArgs'] package: Describes the installation of a package on the linked resource.
        :param pulumi.Input[str] remediation: A description of actions that can be taken to remedy the note.
        :param pulumi.Input['UpgradeOccurrenceArgs'] upgrade: Describes an available package upgrade on the linked resource.
        :param pulumi.Input['VulnerabilityOccurrenceArgs'] vulnerability: Describes a security vulnerability.
        """
        pulumi.set(__self__, "note_name", note_name)
        pulumi.set(__self__, "resource_uri", resource_uri)
        if attestation is not None:
            pulumi.set(__self__, "attestation", attestation)
        if build is not None:
            pulumi.set(__self__, "build", build)
        if compliance is not None:
            pulumi.set(__self__, "compliance", compliance)
        if deployment is not None:
            pulumi.set(__self__, "deployment", deployment)
        if discovery is not None:
            pulumi.set(__self__, "discovery", discovery)
        if dsse_attestation is not None:
            pulumi.set(__self__, "dsse_attestation", dsse_attestation)
        if envelope is not None:
            pulumi.set(__self__, "envelope", envelope)
        if image is not None:
            pulumi.set(__self__, "image", image)
        if package is not None:
            pulumi.set(__self__, "package", package)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if remediation is not None:
            pulumi.set(__self__, "remediation", remediation)
        if upgrade is not None:
            pulumi.set(__self__, "upgrade", upgrade)
        if vulnerability is not None:
            pulumi.set(__self__, "vulnerability", vulnerability)

    @property
    @pulumi.getter(name="noteName")
    def note_name(self) -> pulumi.Input[str]:
        """
        Immutable. The analysis note associated with this occurrence, in the form of `projects/[PROVIDER_ID]/notes/[NOTE_ID]`. This field can be used as a filter in list requests.
        """
        return pulumi.get(self, "note_name")

    @note_name.setter
    def note_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "note_name", value)

    @property
    @pulumi.getter(name="resourceUri")
    def resource_uri(self) -> pulumi.Input[str]:
        """
        Immutable. A URI that represents the resource for which the occurrence applies. For example, `https://gcr.io/project/image@sha256:123abc` for a Docker image.
        """
        return pulumi.get(self, "resource_uri")

    @resource_uri.setter
    def resource_uri(self, value: pulumi.Input[str]):
        pulumi.set(self, "resource_uri", value)

    @property
    @pulumi.getter
    def attestation(self) -> Optional[pulumi.Input['AttestationOccurrenceArgs']]:
        """
        Describes an attestation of an artifact.
        """
        return pulumi.get(self, "attestation")

    @attestation.setter
    def attestation(self, value: Optional[pulumi.Input['AttestationOccurrenceArgs']]):
        pulumi.set(self, "attestation", value)

    @property
    @pulumi.getter
    def build(self) -> Optional[pulumi.Input['BuildOccurrenceArgs']]:
        """
        Describes a verifiable build.
        """
        return pulumi.get(self, "build")

    @build.setter
    def build(self, value: Optional[pulumi.Input['BuildOccurrenceArgs']]):
        pulumi.set(self, "build", value)

    @property
    @pulumi.getter
    def compliance(self) -> Optional[pulumi.Input['ComplianceOccurrenceArgs']]:
        """
        Describes a compliance violation on a linked resource.
        """
        return pulumi.get(self, "compliance")

    @compliance.setter
    def compliance(self, value: Optional[pulumi.Input['ComplianceOccurrenceArgs']]):
        pulumi.set(self, "compliance", value)

    @property
    @pulumi.getter
    def deployment(self) -> Optional[pulumi.Input['DeploymentOccurrenceArgs']]:
        """
        Describes the deployment of an artifact on a runtime.
        """
        return pulumi.get(self, "deployment")

    @deployment.setter
    def deployment(self, value: Optional[pulumi.Input['DeploymentOccurrenceArgs']]):
        pulumi.set(self, "deployment", value)

    @property
    @pulumi.getter
    def discovery(self) -> Optional[pulumi.Input['DiscoveryOccurrenceArgs']]:
        """
        Describes when a resource was discovered.
        """
        return pulumi.get(self, "discovery")

    @discovery.setter
    def discovery(self, value: Optional[pulumi.Input['DiscoveryOccurrenceArgs']]):
        pulumi.set(self, "discovery", value)

    @property
    @pulumi.getter(name="dsseAttestation")
    def dsse_attestation(self) -> Optional[pulumi.Input['DSSEAttestationOccurrenceArgs']]:
        """
        Describes an attestation of an artifact using dsse.
        """
        return pulumi.get(self, "dsse_attestation")

    @dsse_attestation.setter
    def dsse_attestation(self, value: Optional[pulumi.Input['DSSEAttestationOccurrenceArgs']]):
        pulumi.set(self, "dsse_attestation", value)

    @property
    @pulumi.getter
    def envelope(self) -> Optional[pulumi.Input['EnvelopeArgs']]:
        """
        https://github.com/secure-systems-lab/dsse
        """
        return pulumi.get(self, "envelope")

    @envelope.setter
    def envelope(self, value: Optional[pulumi.Input['EnvelopeArgs']]):
        pulumi.set(self, "envelope", value)

    @property
    @pulumi.getter
    def image(self) -> Optional[pulumi.Input['ImageOccurrenceArgs']]:
        """
        Describes how this resource derives from the basis in the associated note.
        """
        return pulumi.get(self, "image")

    @image.setter
    def image(self, value: Optional[pulumi.Input['ImageOccurrenceArgs']]):
        pulumi.set(self, "image", value)

    @property
    @pulumi.getter
    def package(self) -> Optional[pulumi.Input['PackageOccurrenceArgs']]:
        """
        Describes the installation of a package on the linked resource.
        """
        return pulumi.get(self, "package")

    @package.setter
    def package(self, value: Optional[pulumi.Input['PackageOccurrenceArgs']]):
        pulumi.set(self, "package", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def remediation(self) -> Optional[pulumi.Input[str]]:
        """
        A description of actions that can be taken to remedy the note.
        """
        return pulumi.get(self, "remediation")

    @remediation.setter
    def remediation(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "remediation", value)

    @property
    @pulumi.getter
    def upgrade(self) -> Optional[pulumi.Input['UpgradeOccurrenceArgs']]:
        """
        Describes an available package upgrade on the linked resource.
        """
        return pulumi.get(self, "upgrade")

    @upgrade.setter
    def upgrade(self, value: Optional[pulumi.Input['UpgradeOccurrenceArgs']]):
        pulumi.set(self, "upgrade", value)

    @property
    @pulumi.getter
    def vulnerability(self) -> Optional[pulumi.Input['VulnerabilityOccurrenceArgs']]:
        """
        Describes a security vulnerability.
        """
        return pulumi.get(self, "vulnerability")

    @vulnerability.setter
    def vulnerability(self, value: Optional[pulumi.Input['VulnerabilityOccurrenceArgs']]):
        pulumi.set(self, "vulnerability", value)


class Occurrence(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 attestation: Optional[pulumi.Input[pulumi.InputType['AttestationOccurrenceArgs']]] = None,
                 build: Optional[pulumi.Input[pulumi.InputType['BuildOccurrenceArgs']]] = None,
                 compliance: Optional[pulumi.Input[pulumi.InputType['ComplianceOccurrenceArgs']]] = None,
                 deployment: Optional[pulumi.Input[pulumi.InputType['DeploymentOccurrenceArgs']]] = None,
                 discovery: Optional[pulumi.Input[pulumi.InputType['DiscoveryOccurrenceArgs']]] = None,
                 dsse_attestation: Optional[pulumi.Input[pulumi.InputType['DSSEAttestationOccurrenceArgs']]] = None,
                 envelope: Optional[pulumi.Input[pulumi.InputType['EnvelopeArgs']]] = None,
                 image: Optional[pulumi.Input[pulumi.InputType['ImageOccurrenceArgs']]] = None,
                 note_name: Optional[pulumi.Input[str]] = None,
                 package: Optional[pulumi.Input[pulumi.InputType['PackageOccurrenceArgs']]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 remediation: Optional[pulumi.Input[str]] = None,
                 resource_uri: Optional[pulumi.Input[str]] = None,
                 upgrade: Optional[pulumi.Input[pulumi.InputType['UpgradeOccurrenceArgs']]] = None,
                 vulnerability: Optional[pulumi.Input[pulumi.InputType['VulnerabilityOccurrenceArgs']]] = None,
                 __props__=None):
        """
        Creates a new occurrence.
        Auto-naming is currently not supported for this resource.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['AttestationOccurrenceArgs']] attestation: Describes an attestation of an artifact.
        :param pulumi.Input[pulumi.InputType['BuildOccurrenceArgs']] build: Describes a verifiable build.
        :param pulumi.Input[pulumi.InputType['ComplianceOccurrenceArgs']] compliance: Describes a compliance violation on a linked resource.
        :param pulumi.Input[pulumi.InputType['DeploymentOccurrenceArgs']] deployment: Describes the deployment of an artifact on a runtime.
        :param pulumi.Input[pulumi.InputType['DiscoveryOccurrenceArgs']] discovery: Describes when a resource was discovered.
        :param pulumi.Input[pulumi.InputType['DSSEAttestationOccurrenceArgs']] dsse_attestation: Describes an attestation of an artifact using dsse.
        :param pulumi.Input[pulumi.InputType['EnvelopeArgs']] envelope: https://github.com/secure-systems-lab/dsse
        :param pulumi.Input[pulumi.InputType['ImageOccurrenceArgs']] image: Describes how this resource derives from the basis in the associated note.
        :param pulumi.Input[str] note_name: Immutable. The analysis note associated with this occurrence, in the form of `projects/[PROVIDER_ID]/notes/[NOTE_ID]`. This field can be used as a filter in list requests.
        :param pulumi.Input[pulumi.InputType['PackageOccurrenceArgs']] package: Describes the installation of a package on the linked resource.
        :param pulumi.Input[str] remediation: A description of actions that can be taken to remedy the note.
        :param pulumi.Input[str] resource_uri: Immutable. A URI that represents the resource for which the occurrence applies. For example, `https://gcr.io/project/image@sha256:123abc` for a Docker image.
        :param pulumi.Input[pulumi.InputType['UpgradeOccurrenceArgs']] upgrade: Describes an available package upgrade on the linked resource.
        :param pulumi.Input[pulumi.InputType['VulnerabilityOccurrenceArgs']] vulnerability: Describes a security vulnerability.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: OccurrenceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates a new occurrence.
        Auto-naming is currently not supported for this resource.

        :param str resource_name: The name of the resource.
        :param OccurrenceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(OccurrenceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 attestation: Optional[pulumi.Input[pulumi.InputType['AttestationOccurrenceArgs']]] = None,
                 build: Optional[pulumi.Input[pulumi.InputType['BuildOccurrenceArgs']]] = None,
                 compliance: Optional[pulumi.Input[pulumi.InputType['ComplianceOccurrenceArgs']]] = None,
                 deployment: Optional[pulumi.Input[pulumi.InputType['DeploymentOccurrenceArgs']]] = None,
                 discovery: Optional[pulumi.Input[pulumi.InputType['DiscoveryOccurrenceArgs']]] = None,
                 dsse_attestation: Optional[pulumi.Input[pulumi.InputType['DSSEAttestationOccurrenceArgs']]] = None,
                 envelope: Optional[pulumi.Input[pulumi.InputType['EnvelopeArgs']]] = None,
                 image: Optional[pulumi.Input[pulumi.InputType['ImageOccurrenceArgs']]] = None,
                 note_name: Optional[pulumi.Input[str]] = None,
                 package: Optional[pulumi.Input[pulumi.InputType['PackageOccurrenceArgs']]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 remediation: Optional[pulumi.Input[str]] = None,
                 resource_uri: Optional[pulumi.Input[str]] = None,
                 upgrade: Optional[pulumi.Input[pulumi.InputType['UpgradeOccurrenceArgs']]] = None,
                 vulnerability: Optional[pulumi.Input[pulumi.InputType['VulnerabilityOccurrenceArgs']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = OccurrenceArgs.__new__(OccurrenceArgs)

            __props__.__dict__["attestation"] = attestation
            __props__.__dict__["build"] = build
            __props__.__dict__["compliance"] = compliance
            __props__.__dict__["deployment"] = deployment
            __props__.__dict__["discovery"] = discovery
            __props__.__dict__["dsse_attestation"] = dsse_attestation
            __props__.__dict__["envelope"] = envelope
            __props__.__dict__["image"] = image
            if note_name is None and not opts.urn:
                raise TypeError("Missing required property 'note_name'")
            __props__.__dict__["note_name"] = note_name
            __props__.__dict__["package"] = package
            __props__.__dict__["project"] = project
            __props__.__dict__["remediation"] = remediation
            if resource_uri is None and not opts.urn:
                raise TypeError("Missing required property 'resource_uri'")
            __props__.__dict__["resource_uri"] = resource_uri
            __props__.__dict__["upgrade"] = upgrade
            __props__.__dict__["vulnerability"] = vulnerability
            __props__.__dict__["create_time"] = None
            __props__.__dict__["kind"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["update_time"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["project"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(Occurrence, __self__).__init__(
            'google-native:containeranalysis/v1:Occurrence',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Occurrence':
        """
        Get an existing Occurrence resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = OccurrenceArgs.__new__(OccurrenceArgs)

        __props__.__dict__["attestation"] = None
        __props__.__dict__["build"] = None
        __props__.__dict__["compliance"] = None
        __props__.__dict__["create_time"] = None
        __props__.__dict__["deployment"] = None
        __props__.__dict__["discovery"] = None
        __props__.__dict__["dsse_attestation"] = None
        __props__.__dict__["envelope"] = None
        __props__.__dict__["image"] = None
        __props__.__dict__["kind"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["note_name"] = None
        __props__.__dict__["package"] = None
        __props__.__dict__["project"] = None
        __props__.__dict__["remediation"] = None
        __props__.__dict__["resource_uri"] = None
        __props__.__dict__["update_time"] = None
        __props__.__dict__["upgrade"] = None
        __props__.__dict__["vulnerability"] = None
        return Occurrence(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def attestation(self) -> pulumi.Output['outputs.AttestationOccurrenceResponse']:
        """
        Describes an attestation of an artifact.
        """
        return pulumi.get(self, "attestation")

    @property
    @pulumi.getter
    def build(self) -> pulumi.Output['outputs.BuildOccurrenceResponse']:
        """
        Describes a verifiable build.
        """
        return pulumi.get(self, "build")

    @property
    @pulumi.getter
    def compliance(self) -> pulumi.Output['outputs.ComplianceOccurrenceResponse']:
        """
        Describes a compliance violation on a linked resource.
        """
        return pulumi.get(self, "compliance")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[str]:
        """
        The time this occurrence was created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def deployment(self) -> pulumi.Output['outputs.DeploymentOccurrenceResponse']:
        """
        Describes the deployment of an artifact on a runtime.
        """
        return pulumi.get(self, "deployment")

    @property
    @pulumi.getter
    def discovery(self) -> pulumi.Output['outputs.DiscoveryOccurrenceResponse']:
        """
        Describes when a resource was discovered.
        """
        return pulumi.get(self, "discovery")

    @property
    @pulumi.getter(name="dsseAttestation")
    def dsse_attestation(self) -> pulumi.Output['outputs.DSSEAttestationOccurrenceResponse']:
        """
        Describes an attestation of an artifact using dsse.
        """
        return pulumi.get(self, "dsse_attestation")

    @property
    @pulumi.getter
    def envelope(self) -> pulumi.Output['outputs.EnvelopeResponse']:
        """
        https://github.com/secure-systems-lab/dsse
        """
        return pulumi.get(self, "envelope")

    @property
    @pulumi.getter
    def image(self) -> pulumi.Output['outputs.ImageOccurrenceResponse']:
        """
        Describes how this resource derives from the basis in the associated note.
        """
        return pulumi.get(self, "image")

    @property
    @pulumi.getter
    def kind(self) -> pulumi.Output[str]:
        """
        This explicitly denotes which of the occurrence details are specified. This field can be used as a filter in list requests.
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the occurrence in the form of `projects/[PROJECT_ID]/occurrences/[OCCURRENCE_ID]`.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="noteName")
    def note_name(self) -> pulumi.Output[str]:
        """
        Immutable. The analysis note associated with this occurrence, in the form of `projects/[PROVIDER_ID]/notes/[NOTE_ID]`. This field can be used as a filter in list requests.
        """
        return pulumi.get(self, "note_name")

    @property
    @pulumi.getter
    def package(self) -> pulumi.Output['outputs.PackageOccurrenceResponse']:
        """
        Describes the installation of a package on the linked resource.
        """
        return pulumi.get(self, "package")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        return pulumi.get(self, "project")

    @property
    @pulumi.getter
    def remediation(self) -> pulumi.Output[str]:
        """
        A description of actions that can be taken to remedy the note.
        """
        return pulumi.get(self, "remediation")

    @property
    @pulumi.getter(name="resourceUri")
    def resource_uri(self) -> pulumi.Output[str]:
        """
        Immutable. A URI that represents the resource for which the occurrence applies. For example, `https://gcr.io/project/image@sha256:123abc` for a Docker image.
        """
        return pulumi.get(self, "resource_uri")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[str]:
        """
        The time this occurrence was last updated.
        """
        return pulumi.get(self, "update_time")

    @property
    @pulumi.getter
    def upgrade(self) -> pulumi.Output['outputs.UpgradeOccurrenceResponse']:
        """
        Describes an available package upgrade on the linked resource.
        """
        return pulumi.get(self, "upgrade")

    @property
    @pulumi.getter
    def vulnerability(self) -> pulumi.Output['outputs.VulnerabilityOccurrenceResponse']:
        """
        Describes a security vulnerability.
        """
        return pulumi.get(self, "vulnerability")

