# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *
from ._inputs import *

__all__ = ['FutureReservationArgs', 'FutureReservation']

@pulumi.input_type
class FutureReservationArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 name_prefix: Optional[pulumi.Input[str]] = None,
                 planning_status: Optional[pulumi.Input['FutureReservationPlanningStatus']] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 request_id: Optional[pulumi.Input[str]] = None,
                 share_settings: Optional[pulumi.Input['ShareSettingsArgs']] = None,
                 specific_sku_properties: Optional[pulumi.Input['FutureReservationSpecificSKUPropertiesArgs']] = None,
                 time_window: Optional[pulumi.Input['FutureReservationTimeWindowArgs']] = None,
                 zone: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a FutureReservation resource.
        :param pulumi.Input[str] description: An optional description of this resource. Provide this property when you create the future reservation.
        :param pulumi.Input[str] name: The name of the resource, provided by the client when initially creating the resource. The resource name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
        :param pulumi.Input[str] name_prefix: Name prefix for the reservations to be created at the time of delivery. The name prefix must comply with RFC1035. Maximum allowed length for name prefix is 20. Automatically created reservations name format will be -date-####.
        :param pulumi.Input['FutureReservationPlanningStatus'] planning_status: Planning state before being submitted for evaluation
        :param pulumi.Input[str] request_id: An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
        :param pulumi.Input['ShareSettingsArgs'] share_settings: List of Projects/Folders to share with.
        :param pulumi.Input['FutureReservationSpecificSKUPropertiesArgs'] specific_sku_properties: Future Reservation configuration to indicate instance properties and total count.
        :param pulumi.Input['FutureReservationTimeWindowArgs'] time_window: Time window for this Future Reservation.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if name_prefix is not None:
            pulumi.set(__self__, "name_prefix", name_prefix)
        if planning_status is not None:
            pulumi.set(__self__, "planning_status", planning_status)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if request_id is not None:
            pulumi.set(__self__, "request_id", request_id)
        if share_settings is not None:
            pulumi.set(__self__, "share_settings", share_settings)
        if specific_sku_properties is not None:
            pulumi.set(__self__, "specific_sku_properties", specific_sku_properties)
        if time_window is not None:
            pulumi.set(__self__, "time_window", time_window)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        An optional description of this resource. Provide this property when you create the future reservation.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the resource, provided by the client when initially creating the resource. The resource name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="namePrefix")
    def name_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        Name prefix for the reservations to be created at the time of delivery. The name prefix must comply with RFC1035. Maximum allowed length for name prefix is 20. Automatically created reservations name format will be -date-####.
        """
        return pulumi.get(self, "name_prefix")

    @name_prefix.setter
    def name_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name_prefix", value)

    @property
    @pulumi.getter(name="planningStatus")
    def planning_status(self) -> Optional[pulumi.Input['FutureReservationPlanningStatus']]:
        """
        Planning state before being submitted for evaluation
        """
        return pulumi.get(self, "planning_status")

    @planning_status.setter
    def planning_status(self, value: Optional[pulumi.Input['FutureReservationPlanningStatus']]):
        pulumi.set(self, "planning_status", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="requestId")
    def request_id(self) -> Optional[pulumi.Input[str]]:
        """
        An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
        """
        return pulumi.get(self, "request_id")

    @request_id.setter
    def request_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "request_id", value)

    @property
    @pulumi.getter(name="shareSettings")
    def share_settings(self) -> Optional[pulumi.Input['ShareSettingsArgs']]:
        """
        List of Projects/Folders to share with.
        """
        return pulumi.get(self, "share_settings")

    @share_settings.setter
    def share_settings(self, value: Optional[pulumi.Input['ShareSettingsArgs']]):
        pulumi.set(self, "share_settings", value)

    @property
    @pulumi.getter(name="specificSkuProperties")
    def specific_sku_properties(self) -> Optional[pulumi.Input['FutureReservationSpecificSKUPropertiesArgs']]:
        """
        Future Reservation configuration to indicate instance properties and total count.
        """
        return pulumi.get(self, "specific_sku_properties")

    @specific_sku_properties.setter
    def specific_sku_properties(self, value: Optional[pulumi.Input['FutureReservationSpecificSKUPropertiesArgs']]):
        pulumi.set(self, "specific_sku_properties", value)

    @property
    @pulumi.getter(name="timeWindow")
    def time_window(self) -> Optional[pulumi.Input['FutureReservationTimeWindowArgs']]:
        """
        Time window for this Future Reservation.
        """
        return pulumi.get(self, "time_window")

    @time_window.setter
    def time_window(self, value: Optional[pulumi.Input['FutureReservationTimeWindowArgs']]):
        pulumi.set(self, "time_window", value)

    @property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zone", value)


class FutureReservation(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 name_prefix: Optional[pulumi.Input[str]] = None,
                 planning_status: Optional[pulumi.Input['FutureReservationPlanningStatus']] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 request_id: Optional[pulumi.Input[str]] = None,
                 share_settings: Optional[pulumi.Input[pulumi.InputType['ShareSettingsArgs']]] = None,
                 specific_sku_properties: Optional[pulumi.Input[pulumi.InputType['FutureReservationSpecificSKUPropertiesArgs']]] = None,
                 time_window: Optional[pulumi.Input[pulumi.InputType['FutureReservationTimeWindowArgs']]] = None,
                 zone: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Creates a new Future Reservation.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: An optional description of this resource. Provide this property when you create the future reservation.
        :param pulumi.Input[str] name: The name of the resource, provided by the client when initially creating the resource. The resource name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
        :param pulumi.Input[str] name_prefix: Name prefix for the reservations to be created at the time of delivery. The name prefix must comply with RFC1035. Maximum allowed length for name prefix is 20. Automatically created reservations name format will be -date-####.
        :param pulumi.Input['FutureReservationPlanningStatus'] planning_status: Planning state before being submitted for evaluation
        :param pulumi.Input[str] request_id: An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
        :param pulumi.Input[pulumi.InputType['ShareSettingsArgs']] share_settings: List of Projects/Folders to share with.
        :param pulumi.Input[pulumi.InputType['FutureReservationSpecificSKUPropertiesArgs']] specific_sku_properties: Future Reservation configuration to indicate instance properties and total count.
        :param pulumi.Input[pulumi.InputType['FutureReservationTimeWindowArgs']] time_window: Time window for this Future Reservation.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[FutureReservationArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates a new Future Reservation.

        :param str resource_name: The name of the resource.
        :param FutureReservationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FutureReservationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 name_prefix: Optional[pulumi.Input[str]] = None,
                 planning_status: Optional[pulumi.Input['FutureReservationPlanningStatus']] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 request_id: Optional[pulumi.Input[str]] = None,
                 share_settings: Optional[pulumi.Input[pulumi.InputType['ShareSettingsArgs']]] = None,
                 specific_sku_properties: Optional[pulumi.Input[pulumi.InputType['FutureReservationSpecificSKUPropertiesArgs']]] = None,
                 time_window: Optional[pulumi.Input[pulumi.InputType['FutureReservationTimeWindowArgs']]] = None,
                 zone: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FutureReservationArgs.__new__(FutureReservationArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["name"] = name
            __props__.__dict__["name_prefix"] = name_prefix
            __props__.__dict__["planning_status"] = planning_status
            __props__.__dict__["project"] = project
            __props__.__dict__["request_id"] = request_id
            __props__.__dict__["share_settings"] = share_settings
            __props__.__dict__["specific_sku_properties"] = specific_sku_properties
            __props__.__dict__["time_window"] = time_window
            __props__.__dict__["zone"] = zone
            __props__.__dict__["creation_timestamp"] = None
            __props__.__dict__["kind"] = None
            __props__.__dict__["self_link"] = None
            __props__.__dict__["self_link_with_id"] = None
            __props__.__dict__["status"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["project", "zone"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(FutureReservation, __self__).__init__(
            'google-native:compute/alpha:FutureReservation',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'FutureReservation':
        """
        Get an existing FutureReservation resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = FutureReservationArgs.__new__(FutureReservationArgs)

        __props__.__dict__["creation_timestamp"] = None
        __props__.__dict__["description"] = None
        __props__.__dict__["kind"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["name_prefix"] = None
        __props__.__dict__["planning_status"] = None
        __props__.__dict__["project"] = None
        __props__.__dict__["request_id"] = None
        __props__.__dict__["self_link"] = None
        __props__.__dict__["self_link_with_id"] = None
        __props__.__dict__["share_settings"] = None
        __props__.__dict__["specific_sku_properties"] = None
        __props__.__dict__["status"] = None
        __props__.__dict__["time_window"] = None
        __props__.__dict__["zone"] = None
        return FutureReservation(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="creationTimestamp")
    def creation_timestamp(self) -> pulumi.Output[str]:
        """
        The creation timestamp for this future reservation in RFC3339 text format.
        """
        return pulumi.get(self, "creation_timestamp")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        An optional description of this resource. Provide this property when you create the future reservation.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def kind(self) -> pulumi.Output[str]:
        """
        Type of the resource. Always compute#futureReservation for future reservations.
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the resource, provided by the client when initially creating the resource. The resource name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="namePrefix")
    def name_prefix(self) -> pulumi.Output[str]:
        """
        Name prefix for the reservations to be created at the time of delivery. The name prefix must comply with RFC1035. Maximum allowed length for name prefix is 20. Automatically created reservations name format will be -date-####.
        """
        return pulumi.get(self, "name_prefix")

    @property
    @pulumi.getter(name="planningStatus")
    def planning_status(self) -> pulumi.Output[str]:
        """
        Planning state before being submitted for evaluation
        """
        return pulumi.get(self, "planning_status")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="requestId")
    def request_id(self) -> pulumi.Output[Optional[str]]:
        """
        An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
        """
        return pulumi.get(self, "request_id")

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> pulumi.Output[str]:
        """
        Server-defined fully-qualified URL for this resource.
        """
        return pulumi.get(self, "self_link")

    @property
    @pulumi.getter(name="selfLinkWithId")
    def self_link_with_id(self) -> pulumi.Output[str]:
        """
        Server-defined URL for this resource with the resource id.
        """
        return pulumi.get(self, "self_link_with_id")

    @property
    @pulumi.getter(name="shareSettings")
    def share_settings(self) -> pulumi.Output['outputs.ShareSettingsResponse']:
        """
        List of Projects/Folders to share with.
        """
        return pulumi.get(self, "share_settings")

    @property
    @pulumi.getter(name="specificSkuProperties")
    def specific_sku_properties(self) -> pulumi.Output['outputs.FutureReservationSpecificSKUPropertiesResponse']:
        """
        Future Reservation configuration to indicate instance properties and total count.
        """
        return pulumi.get(self, "specific_sku_properties")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output['outputs.FutureReservationStatusResponse']:
        """
        [Output only] Status of the Future Reservation
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="timeWindow")
    def time_window(self) -> pulumi.Output['outputs.FutureReservationTimeWindowResponse']:
        """
        Time window for this Future Reservation.
        """
        return pulumi.get(self, "time_window")

    @property
    @pulumi.getter
    def zone(self) -> pulumi.Output[str]:
        return pulumi.get(self, "zone")

