# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = [
    'ApprovalConfigArgs',
    'ArtifactObjectsArgs',
    'ArtifactsArgs',
    'BitbucketServerSecretsArgs',
    'BitbucketServerTriggerConfigArgs',
    'BuildOptionsArgs',
    'BuildStepArgs',
    'BuildArgs',
    'GitFileSourceArgs',
    'GitHubEnterpriseSecretsArgs',
    'GitHubEventsConfigArgs',
    'GitRepoSourceArgs',
    'InlineSecretArgs',
    'NetworkConfigArgs',
    'PoolOptionArgs',
    'PrivatePoolV1ConfigArgs',
    'PubsubConfigArgs',
    'PullRequestFilterArgs',
    'PushFilterArgs',
    'RepoSourceArgs',
    'SecretManagerSecretArgs',
    'SecretsArgs',
    'SecretArgs',
    'SourceArgs',
    'StorageSourceManifestArgs',
    'StorageSourceArgs',
    'VolumeArgs',
    'WebhookConfigArgs',
    'WorkerConfigArgs',
]

@pulumi.input_type
class ApprovalConfigArgs:
    def __init__(__self__, *,
                 approval_required: Optional[pulumi.Input[bool]] = None):
        """
        ApprovalConfig describes configuration for manual approval of a build.
        :param pulumi.Input[bool] approval_required: Whether or not approval is needed. If this is set on a build, it will become pending when created, and will need to be explicitly approved to start.
        """
        if approval_required is not None:
            pulumi.set(__self__, "approval_required", approval_required)

    @property
    @pulumi.getter(name="approvalRequired")
    def approval_required(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not approval is needed. If this is set on a build, it will become pending when created, and will need to be explicitly approved to start.
        """
        return pulumi.get(self, "approval_required")

    @approval_required.setter
    def approval_required(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "approval_required", value)


@pulumi.input_type
class ArtifactObjectsArgs:
    def __init__(__self__, *,
                 location: Optional[pulumi.Input[str]] = None,
                 paths: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Files in the workspace to upload to Cloud Storage upon successful completion of all build steps.
        :param pulumi.Input[str] location: Cloud Storage bucket and optional object path, in the form "gs://bucket/path/to/somewhere/". (see [Bucket Name Requirements](https://cloud.google.com/storage/docs/bucket-naming#requirements)). Files in the workspace matching any path pattern will be uploaded to Cloud Storage with this location as a prefix.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] paths: Path globs used to match files in the build's workspace.
        """
        if location is not None:
            pulumi.set(__self__, "location", location)
        if paths is not None:
            pulumi.set(__self__, "paths", paths)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        Cloud Storage bucket and optional object path, in the form "gs://bucket/path/to/somewhere/". (see [Bucket Name Requirements](https://cloud.google.com/storage/docs/bucket-naming#requirements)). Files in the workspace matching any path pattern will be uploaded to Cloud Storage with this location as a prefix.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def paths(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Path globs used to match files in the build's workspace.
        """
        return pulumi.get(self, "paths")

    @paths.setter
    def paths(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "paths", value)


@pulumi.input_type
class ArtifactsArgs:
    def __init__(__self__, *,
                 images: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 objects: Optional[pulumi.Input['ArtifactObjectsArgs']] = None):
        """
        Artifacts produced by a build that should be uploaded upon successful completion of all build steps.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] images: A list of images to be pushed upon the successful completion of all build steps. The images will be pushed using the builder service account's credentials. The digests of the pushed images will be stored in the Build resource's results field. If any of the images fail to be pushed, the build is marked FAILURE.
        :param pulumi.Input['ArtifactObjectsArgs'] objects: A list of objects to be uploaded to Cloud Storage upon successful completion of all build steps. Files in the workspace matching specified paths globs will be uploaded to the specified Cloud Storage location using the builder service account's credentials. The location and generation of the uploaded objects will be stored in the Build resource's results field. If any objects fail to be pushed, the build is marked FAILURE.
        """
        if images is not None:
            pulumi.set(__self__, "images", images)
        if objects is not None:
            pulumi.set(__self__, "objects", objects)

    @property
    @pulumi.getter
    def images(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of images to be pushed upon the successful completion of all build steps. The images will be pushed using the builder service account's credentials. The digests of the pushed images will be stored in the Build resource's results field. If any of the images fail to be pushed, the build is marked FAILURE.
        """
        return pulumi.get(self, "images")

    @images.setter
    def images(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "images", value)

    @property
    @pulumi.getter
    def objects(self) -> Optional[pulumi.Input['ArtifactObjectsArgs']]:
        """
        A list of objects to be uploaded to Cloud Storage upon successful completion of all build steps. Files in the workspace matching specified paths globs will be uploaded to the specified Cloud Storage location using the builder service account's credentials. The location and generation of the uploaded objects will be stored in the Build resource's results field. If any objects fail to be pushed, the build is marked FAILURE.
        """
        return pulumi.get(self, "objects")

    @objects.setter
    def objects(self, value: Optional[pulumi.Input['ArtifactObjectsArgs']]):
        pulumi.set(self, "objects", value)


@pulumi.input_type
class BitbucketServerSecretsArgs:
    def __init__(__self__, *,
                 admin_access_token_version_name: pulumi.Input[str],
                 read_access_token_version_name: pulumi.Input[str],
                 webhook_secret_version_name: pulumi.Input[str]):
        """
        BitbucketServerSecrets represents the secrets in Secret Manager for a Bitbucket Server.
        :param pulumi.Input[str] admin_access_token_version_name: The resource name for the admin access token's secret version.
        :param pulumi.Input[str] read_access_token_version_name: The resource name for the read access token's secret version.
        :param pulumi.Input[str] webhook_secret_version_name: Immutable. The resource name for the webhook secret's secret version. Once this field has been set, it cannot be changed. If you need to change it, please create another BitbucketServerConfig.
        """
        pulumi.set(__self__, "admin_access_token_version_name", admin_access_token_version_name)
        pulumi.set(__self__, "read_access_token_version_name", read_access_token_version_name)
        pulumi.set(__self__, "webhook_secret_version_name", webhook_secret_version_name)

    @property
    @pulumi.getter(name="adminAccessTokenVersionName")
    def admin_access_token_version_name(self) -> pulumi.Input[str]:
        """
        The resource name for the admin access token's secret version.
        """
        return pulumi.get(self, "admin_access_token_version_name")

    @admin_access_token_version_name.setter
    def admin_access_token_version_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "admin_access_token_version_name", value)

    @property
    @pulumi.getter(name="readAccessTokenVersionName")
    def read_access_token_version_name(self) -> pulumi.Input[str]:
        """
        The resource name for the read access token's secret version.
        """
        return pulumi.get(self, "read_access_token_version_name")

    @read_access_token_version_name.setter
    def read_access_token_version_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "read_access_token_version_name", value)

    @property
    @pulumi.getter(name="webhookSecretVersionName")
    def webhook_secret_version_name(self) -> pulumi.Input[str]:
        """
        Immutable. The resource name for the webhook secret's secret version. Once this field has been set, it cannot be changed. If you need to change it, please create another BitbucketServerConfig.
        """
        return pulumi.get(self, "webhook_secret_version_name")

    @webhook_secret_version_name.setter
    def webhook_secret_version_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "webhook_secret_version_name", value)


@pulumi.input_type
class BitbucketServerTriggerConfigArgs:
    def __init__(__self__, *,
                 bitbucket_server_config_resource: pulumi.Input[str],
                 project_key: pulumi.Input[str],
                 repo_slug: pulumi.Input[str],
                 pull_request: Optional[pulumi.Input['PullRequestFilterArgs']] = None,
                 push: Optional[pulumi.Input['PushFilterArgs']] = None):
        """
        BitbucketServerTriggerConfig describes the configuration of a trigger that creates a build whenever a Bitbucket Server event is received.
        :param pulumi.Input[str] bitbucket_server_config_resource: The Bitbucket server config resource that this trigger config maps to.
        :param pulumi.Input[str] project_key: Key of the project that the repo is in. For example: The key for https://mybitbucket.server/projects/TEST/repos/test-repo is "TEST".
        :param pulumi.Input[str] repo_slug: Slug of the repository. A repository slug is a URL-friendly version of a repository name, automatically generated by Bitbucket for use in the URL. For example, if the repository name is 'test repo', in the URL it would become 'test-repo' as in https://mybitbucket.server/projects/TEST/repos/test-repo.
        :param pulumi.Input['PullRequestFilterArgs'] pull_request: Filter to match changes in pull requests.
        :param pulumi.Input['PushFilterArgs'] push: Filter to match changes in refs like branches, tags.
        """
        pulumi.set(__self__, "bitbucket_server_config_resource", bitbucket_server_config_resource)
        pulumi.set(__self__, "project_key", project_key)
        pulumi.set(__self__, "repo_slug", repo_slug)
        if pull_request is not None:
            pulumi.set(__self__, "pull_request", pull_request)
        if push is not None:
            pulumi.set(__self__, "push", push)

    @property
    @pulumi.getter(name="bitbucketServerConfigResource")
    def bitbucket_server_config_resource(self) -> pulumi.Input[str]:
        """
        The Bitbucket server config resource that this trigger config maps to.
        """
        return pulumi.get(self, "bitbucket_server_config_resource")

    @bitbucket_server_config_resource.setter
    def bitbucket_server_config_resource(self, value: pulumi.Input[str]):
        pulumi.set(self, "bitbucket_server_config_resource", value)

    @property
    @pulumi.getter(name="projectKey")
    def project_key(self) -> pulumi.Input[str]:
        """
        Key of the project that the repo is in. For example: The key for https://mybitbucket.server/projects/TEST/repos/test-repo is "TEST".
        """
        return pulumi.get(self, "project_key")

    @project_key.setter
    def project_key(self, value: pulumi.Input[str]):
        pulumi.set(self, "project_key", value)

    @property
    @pulumi.getter(name="repoSlug")
    def repo_slug(self) -> pulumi.Input[str]:
        """
        Slug of the repository. A repository slug is a URL-friendly version of a repository name, automatically generated by Bitbucket for use in the URL. For example, if the repository name is 'test repo', in the URL it would become 'test-repo' as in https://mybitbucket.server/projects/TEST/repos/test-repo.
        """
        return pulumi.get(self, "repo_slug")

    @repo_slug.setter
    def repo_slug(self, value: pulumi.Input[str]):
        pulumi.set(self, "repo_slug", value)

    @property
    @pulumi.getter(name="pullRequest")
    def pull_request(self) -> Optional[pulumi.Input['PullRequestFilterArgs']]:
        """
        Filter to match changes in pull requests.
        """
        return pulumi.get(self, "pull_request")

    @pull_request.setter
    def pull_request(self, value: Optional[pulumi.Input['PullRequestFilterArgs']]):
        pulumi.set(self, "pull_request", value)

    @property
    @pulumi.getter
    def push(self) -> Optional[pulumi.Input['PushFilterArgs']]:
        """
        Filter to match changes in refs like branches, tags.
        """
        return pulumi.get(self, "push")

    @push.setter
    def push(self, value: Optional[pulumi.Input['PushFilterArgs']]):
        pulumi.set(self, "push", value)


@pulumi.input_type
class BuildOptionsArgs:
    def __init__(__self__, *,
                 disk_size_gb: Optional[pulumi.Input[str]] = None,
                 dynamic_substitutions: Optional[pulumi.Input[bool]] = None,
                 env: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 log_streaming_option: Optional[pulumi.Input['BuildOptionsLogStreamingOption']] = None,
                 logging: Optional[pulumi.Input['BuildOptionsLogging']] = None,
                 machine_type: Optional[pulumi.Input['BuildOptionsMachineType']] = None,
                 pool: Optional[pulumi.Input['PoolOptionArgs']] = None,
                 requested_verify_option: Optional[pulumi.Input['BuildOptionsRequestedVerifyOption']] = None,
                 secret_env: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 source_provenance_hash: Optional[pulumi.Input[Sequence[pulumi.Input['BuildOptionsSourceProvenanceHashItem']]]] = None,
                 substitution_option: Optional[pulumi.Input['BuildOptionsSubstitutionOption']] = None,
                 volumes: Optional[pulumi.Input[Sequence[pulumi.Input['VolumeArgs']]]] = None,
                 worker_pool: Optional[pulumi.Input[str]] = None):
        """
        Optional arguments to enable specific features of builds.
        :param pulumi.Input[str] disk_size_gb: Requested disk size for the VM that runs the build. Note that this is *NOT* "disk free"; some of the space will be used by the operating system and build utilities. Also note that this is the minimum disk size that will be allocated for the build -- the build may run with a larger disk than requested. At present, the maximum disk size is 1000GB; builds that request more than the maximum are rejected with an error.
        :param pulumi.Input[bool] dynamic_substitutions: Option to specify whether or not to apply bash style string operations to the substitutions. NOTE: this is always enabled for triggered builds and cannot be overridden in the build configuration file.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] env: A list of global environment variable definitions that will exist for all build steps in this build. If a variable is defined in both globally and in a build step, the variable will use the build step value. The elements are of the form "KEY=VALUE" for the environment variable "KEY" being given the value "VALUE".
        :param pulumi.Input['BuildOptionsLogStreamingOption'] log_streaming_option: Option to define build log streaming behavior to Google Cloud Storage.
        :param pulumi.Input['BuildOptionsLogging'] logging: Option to specify the logging mode, which determines if and where build logs are stored.
        :param pulumi.Input['BuildOptionsMachineType'] machine_type: Compute Engine machine type on which to run the build.
        :param pulumi.Input['PoolOptionArgs'] pool: Optional. Specification for execution on a `WorkerPool`. See [running builds in a private pool](https://cloud.google.com/build/docs/private-pools/run-builds-in-private-pool) for more information.
        :param pulumi.Input['BuildOptionsRequestedVerifyOption'] requested_verify_option: Requested verifiability options.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] secret_env: A list of global environment variables, which are encrypted using a Cloud Key Management Service crypto key. These values must be specified in the build's `Secret`. These variables will be available to all build steps in this build.
        :param pulumi.Input[Sequence[pulumi.Input['BuildOptionsSourceProvenanceHashItem']]] source_provenance_hash: Requested hash for SourceProvenance.
        :param pulumi.Input['BuildOptionsSubstitutionOption'] substitution_option: Option to specify behavior when there is an error in the substitution checks. NOTE: this is always set to ALLOW_LOOSE for triggered builds and cannot be overridden in the build configuration file.
        :param pulumi.Input[Sequence[pulumi.Input['VolumeArgs']]] volumes: Global list of volumes to mount for ALL build steps Each volume is created as an empty volume prior to starting the build process. Upon completion of the build, volumes and their contents are discarded. Global volume names and paths cannot conflict with the volumes defined a build step. Using a global volume in a build with only one step is not valid as it is indicative of a build request with an incorrect configuration.
        :param pulumi.Input[str] worker_pool: This field deprecated; please use `pool.name` instead.
        """
        if disk_size_gb is not None:
            pulumi.set(__self__, "disk_size_gb", disk_size_gb)
        if dynamic_substitutions is not None:
            pulumi.set(__self__, "dynamic_substitutions", dynamic_substitutions)
        if env is not None:
            pulumi.set(__self__, "env", env)
        if log_streaming_option is not None:
            pulumi.set(__self__, "log_streaming_option", log_streaming_option)
        if logging is not None:
            pulumi.set(__self__, "logging", logging)
        if machine_type is not None:
            pulumi.set(__self__, "machine_type", machine_type)
        if pool is not None:
            pulumi.set(__self__, "pool", pool)
        if requested_verify_option is not None:
            pulumi.set(__self__, "requested_verify_option", requested_verify_option)
        if secret_env is not None:
            pulumi.set(__self__, "secret_env", secret_env)
        if source_provenance_hash is not None:
            pulumi.set(__self__, "source_provenance_hash", source_provenance_hash)
        if substitution_option is not None:
            pulumi.set(__self__, "substitution_option", substitution_option)
        if volumes is not None:
            pulumi.set(__self__, "volumes", volumes)
        if worker_pool is not None:
            pulumi.set(__self__, "worker_pool", worker_pool)

    @property
    @pulumi.getter(name="diskSizeGb")
    def disk_size_gb(self) -> Optional[pulumi.Input[str]]:
        """
        Requested disk size for the VM that runs the build. Note that this is *NOT* "disk free"; some of the space will be used by the operating system and build utilities. Also note that this is the minimum disk size that will be allocated for the build -- the build may run with a larger disk than requested. At present, the maximum disk size is 1000GB; builds that request more than the maximum are rejected with an error.
        """
        return pulumi.get(self, "disk_size_gb")

    @disk_size_gb.setter
    def disk_size_gb(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "disk_size_gb", value)

    @property
    @pulumi.getter(name="dynamicSubstitutions")
    def dynamic_substitutions(self) -> Optional[pulumi.Input[bool]]:
        """
        Option to specify whether or not to apply bash style string operations to the substitutions. NOTE: this is always enabled for triggered builds and cannot be overridden in the build configuration file.
        """
        return pulumi.get(self, "dynamic_substitutions")

    @dynamic_substitutions.setter
    def dynamic_substitutions(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "dynamic_substitutions", value)

    @property
    @pulumi.getter
    def env(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of global environment variable definitions that will exist for all build steps in this build. If a variable is defined in both globally and in a build step, the variable will use the build step value. The elements are of the form "KEY=VALUE" for the environment variable "KEY" being given the value "VALUE".
        """
        return pulumi.get(self, "env")

    @env.setter
    def env(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "env", value)

    @property
    @pulumi.getter(name="logStreamingOption")
    def log_streaming_option(self) -> Optional[pulumi.Input['BuildOptionsLogStreamingOption']]:
        """
        Option to define build log streaming behavior to Google Cloud Storage.
        """
        return pulumi.get(self, "log_streaming_option")

    @log_streaming_option.setter
    def log_streaming_option(self, value: Optional[pulumi.Input['BuildOptionsLogStreamingOption']]):
        pulumi.set(self, "log_streaming_option", value)

    @property
    @pulumi.getter
    def logging(self) -> Optional[pulumi.Input['BuildOptionsLogging']]:
        """
        Option to specify the logging mode, which determines if and where build logs are stored.
        """
        return pulumi.get(self, "logging")

    @logging.setter
    def logging(self, value: Optional[pulumi.Input['BuildOptionsLogging']]):
        pulumi.set(self, "logging", value)

    @property
    @pulumi.getter(name="machineType")
    def machine_type(self) -> Optional[pulumi.Input['BuildOptionsMachineType']]:
        """
        Compute Engine machine type on which to run the build.
        """
        return pulumi.get(self, "machine_type")

    @machine_type.setter
    def machine_type(self, value: Optional[pulumi.Input['BuildOptionsMachineType']]):
        pulumi.set(self, "machine_type", value)

    @property
    @pulumi.getter
    def pool(self) -> Optional[pulumi.Input['PoolOptionArgs']]:
        """
        Optional. Specification for execution on a `WorkerPool`. See [running builds in a private pool](https://cloud.google.com/build/docs/private-pools/run-builds-in-private-pool) for more information.
        """
        return pulumi.get(self, "pool")

    @pool.setter
    def pool(self, value: Optional[pulumi.Input['PoolOptionArgs']]):
        pulumi.set(self, "pool", value)

    @property
    @pulumi.getter(name="requestedVerifyOption")
    def requested_verify_option(self) -> Optional[pulumi.Input['BuildOptionsRequestedVerifyOption']]:
        """
        Requested verifiability options.
        """
        return pulumi.get(self, "requested_verify_option")

    @requested_verify_option.setter
    def requested_verify_option(self, value: Optional[pulumi.Input['BuildOptionsRequestedVerifyOption']]):
        pulumi.set(self, "requested_verify_option", value)

    @property
    @pulumi.getter(name="secretEnv")
    def secret_env(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of global environment variables, which are encrypted using a Cloud Key Management Service crypto key. These values must be specified in the build's `Secret`. These variables will be available to all build steps in this build.
        """
        return pulumi.get(self, "secret_env")

    @secret_env.setter
    def secret_env(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "secret_env", value)

    @property
    @pulumi.getter(name="sourceProvenanceHash")
    def source_provenance_hash(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BuildOptionsSourceProvenanceHashItem']]]]:
        """
        Requested hash for SourceProvenance.
        """
        return pulumi.get(self, "source_provenance_hash")

    @source_provenance_hash.setter
    def source_provenance_hash(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BuildOptionsSourceProvenanceHashItem']]]]):
        pulumi.set(self, "source_provenance_hash", value)

    @property
    @pulumi.getter(name="substitutionOption")
    def substitution_option(self) -> Optional[pulumi.Input['BuildOptionsSubstitutionOption']]:
        """
        Option to specify behavior when there is an error in the substitution checks. NOTE: this is always set to ALLOW_LOOSE for triggered builds and cannot be overridden in the build configuration file.
        """
        return pulumi.get(self, "substitution_option")

    @substitution_option.setter
    def substitution_option(self, value: Optional[pulumi.Input['BuildOptionsSubstitutionOption']]):
        pulumi.set(self, "substitution_option", value)

    @property
    @pulumi.getter
    def volumes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VolumeArgs']]]]:
        """
        Global list of volumes to mount for ALL build steps Each volume is created as an empty volume prior to starting the build process. Upon completion of the build, volumes and their contents are discarded. Global volume names and paths cannot conflict with the volumes defined a build step. Using a global volume in a build with only one step is not valid as it is indicative of a build request with an incorrect configuration.
        """
        return pulumi.get(self, "volumes")

    @volumes.setter
    def volumes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VolumeArgs']]]]):
        pulumi.set(self, "volumes", value)

    @property
    @pulumi.getter(name="workerPool")
    def worker_pool(self) -> Optional[pulumi.Input[str]]:
        """
        This field deprecated; please use `pool.name` instead.
        """
        return pulumi.get(self, "worker_pool")

    @worker_pool.setter
    def worker_pool(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "worker_pool", value)


@pulumi.input_type
class BuildStepArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 allow_exit_codes: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
                 allow_failure: Optional[pulumi.Input[bool]] = None,
                 args: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 dir: Optional[pulumi.Input[str]] = None,
                 entrypoint: Optional[pulumi.Input[str]] = None,
                 env: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 script: Optional[pulumi.Input[str]] = None,
                 secret_env: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 timeout: Optional[pulumi.Input[str]] = None,
                 volumes: Optional[pulumi.Input[Sequence[pulumi.Input['VolumeArgs']]]] = None,
                 wait_for: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        A step in the build pipeline.
        :param pulumi.Input[str] name: The name of the container image that will run this particular build step. If the image is available in the host's Docker daemon's cache, it will be run directly. If not, the host will attempt to pull the image first, using the builder service account's credentials if necessary. The Docker daemon's cache will already have the latest versions of all of the officially supported build steps ([https://github.com/GoogleCloudPlatform/cloud-builders](https://github.com/GoogleCloudPlatform/cloud-builders)). The Docker daemon will also have cached many of the layers for some popular images, like "ubuntu", "debian", but they will be refreshed at the time you attempt to use them. If you built an image in a previous build step, it will be stored in the host's Docker daemon's cache and is available to use as the name for a later build step.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] allow_exit_codes: Allow this build step to fail without failing the entire build if and only if the exit code is one of the specified codes. If allow_failure is also specified, this field will take precedence.
        :param pulumi.Input[bool] allow_failure: Allow this build step to fail without failing the entire build. If false, the entire build will fail if this step fails. Otherwise, the build will succeed, but this step will still have a failure status. Error information will be reported in the failure_detail field.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] args: A list of arguments that will be presented to the step when it is started. If the image used to run the step's container has an entrypoint, the `args` are used as arguments to that entrypoint. If the image does not define an entrypoint, the first element in args is used as the entrypoint, and the remainder will be used as arguments.
        :param pulumi.Input[str] dir: Working directory to use when running this step's container. If this value is a relative path, it is relative to the build's working directory. If this value is absolute, it may be outside the build's working directory, in which case the contents of the path may not be persisted across build step executions, unless a `volume` for that path is specified. If the build specifies a `RepoSource` with `dir` and a step with a `dir`, which specifies an absolute path, the `RepoSource` `dir` is ignored for the step's execution.
        :param pulumi.Input[str] entrypoint: Entrypoint to be used instead of the build step image's default entrypoint. If unset, the image's default entrypoint is used.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] env: A list of environment variable definitions to be used when running a step. The elements are of the form "KEY=VALUE" for the environment variable "KEY" being given the value "VALUE".
        :param pulumi.Input[str] id: Unique identifier for this build step, used in `wait_for` to reference this build step as a dependency.
        :param pulumi.Input[str] script: A shell script to be executed in the step. When script is provided, the user cannot specify the entrypoint or args.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] secret_env: A list of environment variables which are encrypted using a Cloud Key Management Service crypto key. These values must be specified in the build's `Secret`.
        :param pulumi.Input[str] timeout: Time limit for executing this build step. If not defined, the step has no time limit and will be allowed to continue to run until either it completes or the build itself times out.
        :param pulumi.Input[Sequence[pulumi.Input['VolumeArgs']]] volumes: List of volumes to mount into the build step. Each volume is created as an empty volume prior to execution of the build step. Upon completion of the build, volumes and their contents are discarded. Using a named volume in only one step is not valid as it is indicative of a build request with an incorrect configuration.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] wait_for: The ID(s) of the step(s) that this build step depends on. This build step will not start until all the build steps in `wait_for` have completed successfully. If `wait_for` is empty, this build step will start when all previous build steps in the `Build.Steps` list have completed successfully.
        """
        pulumi.set(__self__, "name", name)
        if allow_exit_codes is not None:
            pulumi.set(__self__, "allow_exit_codes", allow_exit_codes)
        if allow_failure is not None:
            pulumi.set(__self__, "allow_failure", allow_failure)
        if args is not None:
            pulumi.set(__self__, "args", args)
        if dir is not None:
            pulumi.set(__self__, "dir", dir)
        if entrypoint is not None:
            pulumi.set(__self__, "entrypoint", entrypoint)
        if env is not None:
            pulumi.set(__self__, "env", env)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if script is not None:
            pulumi.set(__self__, "script", script)
        if secret_env is not None:
            pulumi.set(__self__, "secret_env", secret_env)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)
        if volumes is not None:
            pulumi.set(__self__, "volumes", volumes)
        if wait_for is not None:
            pulumi.set(__self__, "wait_for", wait_for)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of the container image that will run this particular build step. If the image is available in the host's Docker daemon's cache, it will be run directly. If not, the host will attempt to pull the image first, using the builder service account's credentials if necessary. The Docker daemon's cache will already have the latest versions of all of the officially supported build steps ([https://github.com/GoogleCloudPlatform/cloud-builders](https://github.com/GoogleCloudPlatform/cloud-builders)). The Docker daemon will also have cached many of the layers for some popular images, like "ubuntu", "debian", but they will be refreshed at the time you attempt to use them. If you built an image in a previous build step, it will be stored in the host's Docker daemon's cache and is available to use as the name for a later build step.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="allowExitCodes")
    def allow_exit_codes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]:
        """
        Allow this build step to fail without failing the entire build if and only if the exit code is one of the specified codes. If allow_failure is also specified, this field will take precedence.
        """
        return pulumi.get(self, "allow_exit_codes")

    @allow_exit_codes.setter
    def allow_exit_codes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]):
        pulumi.set(self, "allow_exit_codes", value)

    @property
    @pulumi.getter(name="allowFailure")
    def allow_failure(self) -> Optional[pulumi.Input[bool]]:
        """
        Allow this build step to fail without failing the entire build. If false, the entire build will fail if this step fails. Otherwise, the build will succeed, but this step will still have a failure status. Error information will be reported in the failure_detail field.
        """
        return pulumi.get(self, "allow_failure")

    @allow_failure.setter
    def allow_failure(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_failure", value)

    @property
    @pulumi.getter
    def args(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of arguments that will be presented to the step when it is started. If the image used to run the step's container has an entrypoint, the `args` are used as arguments to that entrypoint. If the image does not define an entrypoint, the first element in args is used as the entrypoint, and the remainder will be used as arguments.
        """
        return pulumi.get(self, "args")

    @args.setter
    def args(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "args", value)

    @property
    @pulumi.getter
    def dir(self) -> Optional[pulumi.Input[str]]:
        """
        Working directory to use when running this step's container. If this value is a relative path, it is relative to the build's working directory. If this value is absolute, it may be outside the build's working directory, in which case the contents of the path may not be persisted across build step executions, unless a `volume` for that path is specified. If the build specifies a `RepoSource` with `dir` and a step with a `dir`, which specifies an absolute path, the `RepoSource` `dir` is ignored for the step's execution.
        """
        return pulumi.get(self, "dir")

    @dir.setter
    def dir(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dir", value)

    @property
    @pulumi.getter
    def entrypoint(self) -> Optional[pulumi.Input[str]]:
        """
        Entrypoint to be used instead of the build step image's default entrypoint. If unset, the image's default entrypoint is used.
        """
        return pulumi.get(self, "entrypoint")

    @entrypoint.setter
    def entrypoint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "entrypoint", value)

    @property
    @pulumi.getter
    def env(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of environment variable definitions to be used when running a step. The elements are of the form "KEY=VALUE" for the environment variable "KEY" being given the value "VALUE".
        """
        return pulumi.get(self, "env")

    @env.setter
    def env(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "env", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Unique identifier for this build step, used in `wait_for` to reference this build step as a dependency.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def script(self) -> Optional[pulumi.Input[str]]:
        """
        A shell script to be executed in the step. When script is provided, the user cannot specify the entrypoint or args.
        """
        return pulumi.get(self, "script")

    @script.setter
    def script(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "script", value)

    @property
    @pulumi.getter(name="secretEnv")
    def secret_env(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of environment variables which are encrypted using a Cloud Key Management Service crypto key. These values must be specified in the build's `Secret`.
        """
        return pulumi.get(self, "secret_env")

    @secret_env.setter
    def secret_env(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "secret_env", value)

    @property
    @pulumi.getter
    def timeout(self) -> Optional[pulumi.Input[str]]:
        """
        Time limit for executing this build step. If not defined, the step has no time limit and will be allowed to continue to run until either it completes or the build itself times out.
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "timeout", value)

    @property
    @pulumi.getter
    def volumes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VolumeArgs']]]]:
        """
        List of volumes to mount into the build step. Each volume is created as an empty volume prior to execution of the build step. Upon completion of the build, volumes and their contents are discarded. Using a named volume in only one step is not valid as it is indicative of a build request with an incorrect configuration.
        """
        return pulumi.get(self, "volumes")

    @volumes.setter
    def volumes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VolumeArgs']]]]):
        pulumi.set(self, "volumes", value)

    @property
    @pulumi.getter(name="waitFor")
    def wait_for(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The ID(s) of the step(s) that this build step depends on. This build step will not start until all the build steps in `wait_for` have completed successfully. If `wait_for` is empty, this build step will start when all previous build steps in the `Build.Steps` list have completed successfully.
        """
        return pulumi.get(self, "wait_for")

    @wait_for.setter
    def wait_for(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "wait_for", value)


@pulumi.input_type
class BuildArgs:
    def __init__(__self__, *,
                 steps: pulumi.Input[Sequence[pulumi.Input['BuildStepArgs']]],
                 artifacts: Optional[pulumi.Input['ArtifactsArgs']] = None,
                 available_secrets: Optional[pulumi.Input['SecretsArgs']] = None,
                 images: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 logs_bucket: Optional[pulumi.Input[str]] = None,
                 options: Optional[pulumi.Input['BuildOptionsArgs']] = None,
                 queue_ttl: Optional[pulumi.Input[str]] = None,
                 secrets: Optional[pulumi.Input[Sequence[pulumi.Input['SecretArgs']]]] = None,
                 service_account: Optional[pulumi.Input[str]] = None,
                 source: Optional[pulumi.Input['SourceArgs']] = None,
                 substitutions: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 timeout: Optional[pulumi.Input[str]] = None):
        """
        A build resource in the Cloud Build API. At a high level, a `Build` describes where to find source code, how to build it (for example, the builder image to run on the source), and where to store the built artifacts. Fields can include the following variables, which will be expanded when the build is created: - $PROJECT_ID: the project ID of the build. - $PROJECT_NUMBER: the project number of the build. - $LOCATION: the location/region of the build. - $BUILD_ID: the autogenerated ID of the build. - $REPO_NAME: the source repository name specified by RepoSource. - $BRANCH_NAME: the branch name specified by RepoSource. - $TAG_NAME: the tag name specified by RepoSource. - $REVISION_ID or $COMMIT_SHA: the commit SHA specified by RepoSource or resolved from the specified branch or tag. - $SHORT_SHA: first 7 characters of $REVISION_ID or $COMMIT_SHA.
        :param pulumi.Input[Sequence[pulumi.Input['BuildStepArgs']]] steps: The operations to be performed on the workspace.
        :param pulumi.Input['ArtifactsArgs'] artifacts: Artifacts produced by the build that should be uploaded upon successful completion of all build steps.
        :param pulumi.Input['SecretsArgs'] available_secrets: Secrets and secret environment variables.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] images: A list of images to be pushed upon the successful completion of all build steps. The images are pushed using the builder service account's credentials. The digests of the pushed images will be stored in the `Build` resource's results field. If any of the images fail to be pushed, the build status is marked `FAILURE`.
        :param pulumi.Input[str] logs_bucket: Google Cloud Storage bucket where logs should be written (see [Bucket Name Requirements](https://cloud.google.com/storage/docs/bucket-naming#requirements)). Logs file names will be of the format `${logs_bucket}/log-${build_id}.txt`.
        :param pulumi.Input['BuildOptionsArgs'] options: Special options for this build.
        :param pulumi.Input[str] queue_ttl: TTL in queue for this build. If provided and the build is enqueued longer than this value, the build will expire and the build status will be `EXPIRED`. The TTL starts ticking from create_time.
        :param pulumi.Input[Sequence[pulumi.Input['SecretArgs']]] secrets: Secrets to decrypt using Cloud Key Management Service. Note: Secret Manager is the recommended technique for managing sensitive data with Cloud Build. Use `available_secrets` to configure builds to access secrets from Secret Manager. For instructions, see: https://cloud.google.com/cloud-build/docs/securing-builds/use-secrets
        :param pulumi.Input[str] service_account: IAM service account whose credentials will be used at build runtime. Must be of the format `projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT}`. ACCOUNT can be email address or uniqueId of the service account. 
        :param pulumi.Input['SourceArgs'] source: The location of the source files to build.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] substitutions: Substitutions data for `Build` resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: Tags for annotation of a `Build`. These are not docker tags.
        :param pulumi.Input[str] timeout: Amount of time that this build should be allowed to run, to second granularity. If this amount of time elapses, work on the build will cease and the build status will be `TIMEOUT`. `timeout` starts ticking from `startTime`. Default time is ten minutes.
        """
        pulumi.set(__self__, "steps", steps)
        if artifacts is not None:
            pulumi.set(__self__, "artifacts", artifacts)
        if available_secrets is not None:
            pulumi.set(__self__, "available_secrets", available_secrets)
        if images is not None:
            pulumi.set(__self__, "images", images)
        if logs_bucket is not None:
            pulumi.set(__self__, "logs_bucket", logs_bucket)
        if options is not None:
            pulumi.set(__self__, "options", options)
        if queue_ttl is not None:
            pulumi.set(__self__, "queue_ttl", queue_ttl)
        if secrets is not None:
            pulumi.set(__self__, "secrets", secrets)
        if service_account is not None:
            pulumi.set(__self__, "service_account", service_account)
        if source is not None:
            pulumi.set(__self__, "source", source)
        if substitutions is not None:
            pulumi.set(__self__, "substitutions", substitutions)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)

    @property
    @pulumi.getter
    def steps(self) -> pulumi.Input[Sequence[pulumi.Input['BuildStepArgs']]]:
        """
        The operations to be performed on the workspace.
        """
        return pulumi.get(self, "steps")

    @steps.setter
    def steps(self, value: pulumi.Input[Sequence[pulumi.Input['BuildStepArgs']]]):
        pulumi.set(self, "steps", value)

    @property
    @pulumi.getter
    def artifacts(self) -> Optional[pulumi.Input['ArtifactsArgs']]:
        """
        Artifacts produced by the build that should be uploaded upon successful completion of all build steps.
        """
        return pulumi.get(self, "artifacts")

    @artifacts.setter
    def artifacts(self, value: Optional[pulumi.Input['ArtifactsArgs']]):
        pulumi.set(self, "artifacts", value)

    @property
    @pulumi.getter(name="availableSecrets")
    def available_secrets(self) -> Optional[pulumi.Input['SecretsArgs']]:
        """
        Secrets and secret environment variables.
        """
        return pulumi.get(self, "available_secrets")

    @available_secrets.setter
    def available_secrets(self, value: Optional[pulumi.Input['SecretsArgs']]):
        pulumi.set(self, "available_secrets", value)

    @property
    @pulumi.getter
    def images(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of images to be pushed upon the successful completion of all build steps. The images are pushed using the builder service account's credentials. The digests of the pushed images will be stored in the `Build` resource's results field. If any of the images fail to be pushed, the build status is marked `FAILURE`.
        """
        return pulumi.get(self, "images")

    @images.setter
    def images(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "images", value)

    @property
    @pulumi.getter(name="logsBucket")
    def logs_bucket(self) -> Optional[pulumi.Input[str]]:
        """
        Google Cloud Storage bucket where logs should be written (see [Bucket Name Requirements](https://cloud.google.com/storage/docs/bucket-naming#requirements)). Logs file names will be of the format `${logs_bucket}/log-${build_id}.txt`.
        """
        return pulumi.get(self, "logs_bucket")

    @logs_bucket.setter
    def logs_bucket(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "logs_bucket", value)

    @property
    @pulumi.getter
    def options(self) -> Optional[pulumi.Input['BuildOptionsArgs']]:
        """
        Special options for this build.
        """
        return pulumi.get(self, "options")

    @options.setter
    def options(self, value: Optional[pulumi.Input['BuildOptionsArgs']]):
        pulumi.set(self, "options", value)

    @property
    @pulumi.getter(name="queueTtl")
    def queue_ttl(self) -> Optional[pulumi.Input[str]]:
        """
        TTL in queue for this build. If provided and the build is enqueued longer than this value, the build will expire and the build status will be `EXPIRED`. The TTL starts ticking from create_time.
        """
        return pulumi.get(self, "queue_ttl")

    @queue_ttl.setter
    def queue_ttl(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "queue_ttl", value)

    @property
    @pulumi.getter
    def secrets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SecretArgs']]]]:
        """
        Secrets to decrypt using Cloud Key Management Service. Note: Secret Manager is the recommended technique for managing sensitive data with Cloud Build. Use `available_secrets` to configure builds to access secrets from Secret Manager. For instructions, see: https://cloud.google.com/cloud-build/docs/securing-builds/use-secrets
        """
        return pulumi.get(self, "secrets")

    @secrets.setter
    def secrets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SecretArgs']]]]):
        pulumi.set(self, "secrets", value)

    @property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> Optional[pulumi.Input[str]]:
        """
        IAM service account whose credentials will be used at build runtime. Must be of the format `projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT}`. ACCOUNT can be email address or uniqueId of the service account. 
        """
        return pulumi.get(self, "service_account")

    @service_account.setter
    def service_account(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_account", value)

    @property
    @pulumi.getter
    def source(self) -> Optional[pulumi.Input['SourceArgs']]:
        """
        The location of the source files to build.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: Optional[pulumi.Input['SourceArgs']]):
        pulumi.set(self, "source", value)

    @property
    @pulumi.getter
    def substitutions(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Substitutions data for `Build` resource.
        """
        return pulumi.get(self, "substitutions")

    @substitutions.setter
    def substitutions(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "substitutions", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Tags for annotation of a `Build`. These are not docker tags.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def timeout(self) -> Optional[pulumi.Input[str]]:
        """
        Amount of time that this build should be allowed to run, to second granularity. If this amount of time elapses, work on the build will cease and the build status will be `TIMEOUT`. `timeout` starts ticking from `startTime`. Default time is ten minutes.
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "timeout", value)


@pulumi.input_type
class GitFileSourceArgs:
    def __init__(__self__, *,
                 bitbucket_server_config: Optional[pulumi.Input[str]] = None,
                 github_enterprise_config: Optional[pulumi.Input[str]] = None,
                 path: Optional[pulumi.Input[str]] = None,
                 repo_type: Optional[pulumi.Input['GitFileSourceRepoType']] = None,
                 revision: Optional[pulumi.Input[str]] = None,
                 uri: Optional[pulumi.Input[str]] = None):
        """
        GitFileSource describes a file within a (possibly remote) code repository.
        :param pulumi.Input[str] bitbucket_server_config: The full resource name of the bitbucket server config. Format: `projects/{project}/locations/{location}/bitbucketServerConfigs/{id}`.
        :param pulumi.Input[str] github_enterprise_config: The full resource name of the github enterprise config. Format: `projects/{project}/locations/{location}/githubEnterpriseConfigs/{id}`. `projects/{project}/githubEnterpriseConfigs/{id}`.
        :param pulumi.Input[str] path: The path of the file, with the repo root as the root of the path.
        :param pulumi.Input['GitFileSourceRepoType'] repo_type: See RepoType above.
        :param pulumi.Input[str] revision: The branch, tag, arbitrary ref, or SHA version of the repo to use when resolving the filename (optional). This field respects the same syntax/resolution as described here: https://git-scm.com/docs/gitrevisions If unspecified, the revision from which the trigger invocation originated is assumed to be the revision from which to read the specified path.
        :param pulumi.Input[str] uri: The URI of the repo. Either uri or repository can be specified. If unspecified, the repo from which the trigger invocation originated is assumed to be the repo from which to read the specified path.
        """
        if bitbucket_server_config is not None:
            pulumi.set(__self__, "bitbucket_server_config", bitbucket_server_config)
        if github_enterprise_config is not None:
            pulumi.set(__self__, "github_enterprise_config", github_enterprise_config)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if repo_type is not None:
            pulumi.set(__self__, "repo_type", repo_type)
        if revision is not None:
            pulumi.set(__self__, "revision", revision)
        if uri is not None:
            pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter(name="bitbucketServerConfig")
    def bitbucket_server_config(self) -> Optional[pulumi.Input[str]]:
        """
        The full resource name of the bitbucket server config. Format: `projects/{project}/locations/{location}/bitbucketServerConfigs/{id}`.
        """
        return pulumi.get(self, "bitbucket_server_config")

    @bitbucket_server_config.setter
    def bitbucket_server_config(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bitbucket_server_config", value)

    @property
    @pulumi.getter(name="githubEnterpriseConfig")
    def github_enterprise_config(self) -> Optional[pulumi.Input[str]]:
        """
        The full resource name of the github enterprise config. Format: `projects/{project}/locations/{location}/githubEnterpriseConfigs/{id}`. `projects/{project}/githubEnterpriseConfigs/{id}`.
        """
        return pulumi.get(self, "github_enterprise_config")

    @github_enterprise_config.setter
    def github_enterprise_config(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "github_enterprise_config", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        """
        The path of the file, with the repo root as the root of the path.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter(name="repoType")
    def repo_type(self) -> Optional[pulumi.Input['GitFileSourceRepoType']]:
        """
        See RepoType above.
        """
        return pulumi.get(self, "repo_type")

    @repo_type.setter
    def repo_type(self, value: Optional[pulumi.Input['GitFileSourceRepoType']]):
        pulumi.set(self, "repo_type", value)

    @property
    @pulumi.getter
    def revision(self) -> Optional[pulumi.Input[str]]:
        """
        The branch, tag, arbitrary ref, or SHA version of the repo to use when resolving the filename (optional). This field respects the same syntax/resolution as described here: https://git-scm.com/docs/gitrevisions If unspecified, the revision from which the trigger invocation originated is assumed to be the revision from which to read the specified path.
        """
        return pulumi.get(self, "revision")

    @revision.setter
    def revision(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "revision", value)

    @property
    @pulumi.getter
    def uri(self) -> Optional[pulumi.Input[str]]:
        """
        The URI of the repo. Either uri or repository can be specified. If unspecified, the repo from which the trigger invocation originated is assumed to be the repo from which to read the specified path.
        """
        return pulumi.get(self, "uri")

    @uri.setter
    def uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "uri", value)


@pulumi.input_type
class GitHubEnterpriseSecretsArgs:
    def __init__(__self__, *,
                 oauth_client_id_name: Optional[pulumi.Input[str]] = None,
                 oauth_client_id_version_name: Optional[pulumi.Input[str]] = None,
                 oauth_secret_name: Optional[pulumi.Input[str]] = None,
                 oauth_secret_version_name: Optional[pulumi.Input[str]] = None,
                 private_key_name: Optional[pulumi.Input[str]] = None,
                 private_key_version_name: Optional[pulumi.Input[str]] = None,
                 webhook_secret_name: Optional[pulumi.Input[str]] = None,
                 webhook_secret_version_name: Optional[pulumi.Input[str]] = None):
        """
        GitHubEnterpriseSecrets represents the names of all necessary secrets in Secret Manager for a GitHub Enterprise server. Format is: projects//secrets/.
        :param pulumi.Input[str] oauth_client_id_name: The resource name for the OAuth client ID secret in Secret Manager.
        :param pulumi.Input[str] oauth_client_id_version_name: The resource name for the OAuth client ID secret version in Secret Manager.
        :param pulumi.Input[str] oauth_secret_name: The resource name for the OAuth secret in Secret Manager.
        :param pulumi.Input[str] oauth_secret_version_name: The resource name for the OAuth secret secret version in Secret Manager.
        :param pulumi.Input[str] private_key_name: The resource name for the private key secret.
        :param pulumi.Input[str] private_key_version_name: The resource name for the private key secret version.
        :param pulumi.Input[str] webhook_secret_name: The resource name for the webhook secret in Secret Manager.
        :param pulumi.Input[str] webhook_secret_version_name: The resource name for the webhook secret secret version in Secret Manager.
        """
        if oauth_client_id_name is not None:
            pulumi.set(__self__, "oauth_client_id_name", oauth_client_id_name)
        if oauth_client_id_version_name is not None:
            pulumi.set(__self__, "oauth_client_id_version_name", oauth_client_id_version_name)
        if oauth_secret_name is not None:
            pulumi.set(__self__, "oauth_secret_name", oauth_secret_name)
        if oauth_secret_version_name is not None:
            pulumi.set(__self__, "oauth_secret_version_name", oauth_secret_version_name)
        if private_key_name is not None:
            pulumi.set(__self__, "private_key_name", private_key_name)
        if private_key_version_name is not None:
            pulumi.set(__self__, "private_key_version_name", private_key_version_name)
        if webhook_secret_name is not None:
            pulumi.set(__self__, "webhook_secret_name", webhook_secret_name)
        if webhook_secret_version_name is not None:
            pulumi.set(__self__, "webhook_secret_version_name", webhook_secret_version_name)

    @property
    @pulumi.getter(name="oauthClientIdName")
    def oauth_client_id_name(self) -> Optional[pulumi.Input[str]]:
        """
        The resource name for the OAuth client ID secret in Secret Manager.
        """
        return pulumi.get(self, "oauth_client_id_name")

    @oauth_client_id_name.setter
    def oauth_client_id_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "oauth_client_id_name", value)

    @property
    @pulumi.getter(name="oauthClientIdVersionName")
    def oauth_client_id_version_name(self) -> Optional[pulumi.Input[str]]:
        """
        The resource name for the OAuth client ID secret version in Secret Manager.
        """
        return pulumi.get(self, "oauth_client_id_version_name")

    @oauth_client_id_version_name.setter
    def oauth_client_id_version_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "oauth_client_id_version_name", value)

    @property
    @pulumi.getter(name="oauthSecretName")
    def oauth_secret_name(self) -> Optional[pulumi.Input[str]]:
        """
        The resource name for the OAuth secret in Secret Manager.
        """
        return pulumi.get(self, "oauth_secret_name")

    @oauth_secret_name.setter
    def oauth_secret_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "oauth_secret_name", value)

    @property
    @pulumi.getter(name="oauthSecretVersionName")
    def oauth_secret_version_name(self) -> Optional[pulumi.Input[str]]:
        """
        The resource name for the OAuth secret secret version in Secret Manager.
        """
        return pulumi.get(self, "oauth_secret_version_name")

    @oauth_secret_version_name.setter
    def oauth_secret_version_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "oauth_secret_version_name", value)

    @property
    @pulumi.getter(name="privateKeyName")
    def private_key_name(self) -> Optional[pulumi.Input[str]]:
        """
        The resource name for the private key secret.
        """
        return pulumi.get(self, "private_key_name")

    @private_key_name.setter
    def private_key_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_key_name", value)

    @property
    @pulumi.getter(name="privateKeyVersionName")
    def private_key_version_name(self) -> Optional[pulumi.Input[str]]:
        """
        The resource name for the private key secret version.
        """
        return pulumi.get(self, "private_key_version_name")

    @private_key_version_name.setter
    def private_key_version_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_key_version_name", value)

    @property
    @pulumi.getter(name="webhookSecretName")
    def webhook_secret_name(self) -> Optional[pulumi.Input[str]]:
        """
        The resource name for the webhook secret in Secret Manager.
        """
        return pulumi.get(self, "webhook_secret_name")

    @webhook_secret_name.setter
    def webhook_secret_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "webhook_secret_name", value)

    @property
    @pulumi.getter(name="webhookSecretVersionName")
    def webhook_secret_version_name(self) -> Optional[pulumi.Input[str]]:
        """
        The resource name for the webhook secret secret version in Secret Manager.
        """
        return pulumi.get(self, "webhook_secret_version_name")

    @webhook_secret_version_name.setter
    def webhook_secret_version_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "webhook_secret_version_name", value)


@pulumi.input_type
class GitHubEventsConfigArgs:
    def __init__(__self__, *,
                 enterprise_config_resource_name: Optional[pulumi.Input[str]] = None,
                 installation_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 owner: Optional[pulumi.Input[str]] = None,
                 pull_request: Optional[pulumi.Input['PullRequestFilterArgs']] = None,
                 push: Optional[pulumi.Input['PushFilterArgs']] = None):
        """
        GitHubEventsConfig describes the configuration of a trigger that creates a build whenever a GitHub event is received.
        :param pulumi.Input[str] enterprise_config_resource_name: Optional. The resource name of the github enterprise config that should be applied to this installation. For example: "projects/{$project_id}/githubEnterpriseConfigs/{$config_id}"
        :param pulumi.Input[str] installation_id: The installationID that emits the GitHub event.
        :param pulumi.Input[str] name: Name of the repository. For example: The name for https://github.com/googlecloudplatform/cloud-builders is "cloud-builders".
        :param pulumi.Input[str] owner: Owner of the repository. For example: The owner for https://github.com/googlecloudplatform/cloud-builders is "googlecloudplatform".
        :param pulumi.Input['PullRequestFilterArgs'] pull_request: filter to match changes in pull requests.
        :param pulumi.Input['PushFilterArgs'] push: filter to match changes in refs like branches, tags.
        """
        if enterprise_config_resource_name is not None:
            pulumi.set(__self__, "enterprise_config_resource_name", enterprise_config_resource_name)
        if installation_id is not None:
            pulumi.set(__self__, "installation_id", installation_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if owner is not None:
            pulumi.set(__self__, "owner", owner)
        if pull_request is not None:
            pulumi.set(__self__, "pull_request", pull_request)
        if push is not None:
            pulumi.set(__self__, "push", push)

    @property
    @pulumi.getter(name="enterpriseConfigResourceName")
    def enterprise_config_resource_name(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The resource name of the github enterprise config that should be applied to this installation. For example: "projects/{$project_id}/githubEnterpriseConfigs/{$config_id}"
        """
        return pulumi.get(self, "enterprise_config_resource_name")

    @enterprise_config_resource_name.setter
    def enterprise_config_resource_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "enterprise_config_resource_name", value)

    @property
    @pulumi.getter(name="installationId")
    def installation_id(self) -> Optional[pulumi.Input[str]]:
        """
        The installationID that emits the GitHub event.
        """
        return pulumi.get(self, "installation_id")

    @installation_id.setter
    def installation_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "installation_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the repository. For example: The name for https://github.com/googlecloudplatform/cloud-builders is "cloud-builders".
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def owner(self) -> Optional[pulumi.Input[str]]:
        """
        Owner of the repository. For example: The owner for https://github.com/googlecloudplatform/cloud-builders is "googlecloudplatform".
        """
        return pulumi.get(self, "owner")

    @owner.setter
    def owner(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "owner", value)

    @property
    @pulumi.getter(name="pullRequest")
    def pull_request(self) -> Optional[pulumi.Input['PullRequestFilterArgs']]:
        """
        filter to match changes in pull requests.
        """
        return pulumi.get(self, "pull_request")

    @pull_request.setter
    def pull_request(self, value: Optional[pulumi.Input['PullRequestFilterArgs']]):
        pulumi.set(self, "pull_request", value)

    @property
    @pulumi.getter
    def push(self) -> Optional[pulumi.Input['PushFilterArgs']]:
        """
        filter to match changes in refs like branches, tags.
        """
        return pulumi.get(self, "push")

    @push.setter
    def push(self, value: Optional[pulumi.Input['PushFilterArgs']]):
        pulumi.set(self, "push", value)


@pulumi.input_type
class GitRepoSourceArgs:
    def __init__(__self__, *,
                 bitbucket_server_config: Optional[pulumi.Input[str]] = None,
                 github_enterprise_config: Optional[pulumi.Input[str]] = None,
                 ref: Optional[pulumi.Input[str]] = None,
                 repo_type: Optional[pulumi.Input['GitRepoSourceRepoType']] = None,
                 uri: Optional[pulumi.Input[str]] = None):
        """
        GitRepoSource describes a repo and ref of a code repository.
        :param pulumi.Input[str] bitbucket_server_config: The full resource name of the bitbucket server config. Format: `projects/{project}/locations/{location}/bitbucketServerConfigs/{id}`.
        :param pulumi.Input[str] github_enterprise_config: The full resource name of the github enterprise config. Format: `projects/{project}/locations/{location}/githubEnterpriseConfigs/{id}`. `projects/{project}/githubEnterpriseConfigs/{id}`.
        :param pulumi.Input[str] ref: The branch or tag to use. Must start with "refs/" (required).
        :param pulumi.Input['GitRepoSourceRepoType'] repo_type: See RepoType below.
        :param pulumi.Input[str] uri: The URI of the repo. Either uri or repository can be specified and is required.
        """
        if bitbucket_server_config is not None:
            pulumi.set(__self__, "bitbucket_server_config", bitbucket_server_config)
        if github_enterprise_config is not None:
            pulumi.set(__self__, "github_enterprise_config", github_enterprise_config)
        if ref is not None:
            pulumi.set(__self__, "ref", ref)
        if repo_type is not None:
            pulumi.set(__self__, "repo_type", repo_type)
        if uri is not None:
            pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter(name="bitbucketServerConfig")
    def bitbucket_server_config(self) -> Optional[pulumi.Input[str]]:
        """
        The full resource name of the bitbucket server config. Format: `projects/{project}/locations/{location}/bitbucketServerConfigs/{id}`.
        """
        return pulumi.get(self, "bitbucket_server_config")

    @bitbucket_server_config.setter
    def bitbucket_server_config(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bitbucket_server_config", value)

    @property
    @pulumi.getter(name="githubEnterpriseConfig")
    def github_enterprise_config(self) -> Optional[pulumi.Input[str]]:
        """
        The full resource name of the github enterprise config. Format: `projects/{project}/locations/{location}/githubEnterpriseConfigs/{id}`. `projects/{project}/githubEnterpriseConfigs/{id}`.
        """
        return pulumi.get(self, "github_enterprise_config")

    @github_enterprise_config.setter
    def github_enterprise_config(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "github_enterprise_config", value)

    @property
    @pulumi.getter
    def ref(self) -> Optional[pulumi.Input[str]]:
        """
        The branch or tag to use. Must start with "refs/" (required).
        """
        return pulumi.get(self, "ref")

    @ref.setter
    def ref(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ref", value)

    @property
    @pulumi.getter(name="repoType")
    def repo_type(self) -> Optional[pulumi.Input['GitRepoSourceRepoType']]:
        """
        See RepoType below.
        """
        return pulumi.get(self, "repo_type")

    @repo_type.setter
    def repo_type(self, value: Optional[pulumi.Input['GitRepoSourceRepoType']]):
        pulumi.set(self, "repo_type", value)

    @property
    @pulumi.getter
    def uri(self) -> Optional[pulumi.Input[str]]:
        """
        The URI of the repo. Either uri or repository can be specified and is required.
        """
        return pulumi.get(self, "uri")

    @uri.setter
    def uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "uri", value)


@pulumi.input_type
class InlineSecretArgs:
    def __init__(__self__, *,
                 env_map: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 kms_key_name: Optional[pulumi.Input[str]] = None):
        """
        Pairs a set of secret environment variables mapped to encrypted values with the Cloud KMS key to use to decrypt the value.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] env_map: Map of environment variable name to its encrypted value. Secret environment variables must be unique across all of a build's secrets, and must be used by at least one build step. Values can be at most 64 KB in size. There can be at most 100 secret values across all of a build's secrets.
        :param pulumi.Input[str] kms_key_name: Resource name of Cloud KMS crypto key to decrypt the encrypted value. In format: projects/*/locations/*/keyRings/*/cryptoKeys/*
        """
        if env_map is not None:
            pulumi.set(__self__, "env_map", env_map)
        if kms_key_name is not None:
            pulumi.set(__self__, "kms_key_name", kms_key_name)

    @property
    @pulumi.getter(name="envMap")
    def env_map(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Map of environment variable name to its encrypted value. Secret environment variables must be unique across all of a build's secrets, and must be used by at least one build step. Values can be at most 64 KB in size. There can be at most 100 secret values across all of a build's secrets.
        """
        return pulumi.get(self, "env_map")

    @env_map.setter
    def env_map(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "env_map", value)

    @property
    @pulumi.getter(name="kmsKeyName")
    def kms_key_name(self) -> Optional[pulumi.Input[str]]:
        """
        Resource name of Cloud KMS crypto key to decrypt the encrypted value. In format: projects/*/locations/*/keyRings/*/cryptoKeys/*
        """
        return pulumi.get(self, "kms_key_name")

    @kms_key_name.setter
    def kms_key_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_key_name", value)


@pulumi.input_type
class NetworkConfigArgs:
    def __init__(__self__, *,
                 peered_network: pulumi.Input[str],
                 egress_option: Optional[pulumi.Input['NetworkConfigEgressOption']] = None):
        """
        Defines the network configuration for the pool.
        :param pulumi.Input[str] peered_network: Immutable. The network definition that the workers are peered to. If this section is left empty, the workers will be peered to `WorkerPool.project_id` on the service producer network. Must be in the format `projects/{project}/global/networks/{network}`, where `{project}` is a project number, such as `12345`, and `{network}` is the name of a VPC network in the project. See [Understanding network configuration options](https://cloud.google.com/build/docs/private-pools/set-up-private-pool-environment)
        :param pulumi.Input['NetworkConfigEgressOption'] egress_option: Option to configure network egress for the workers.
        """
        pulumi.set(__self__, "peered_network", peered_network)
        if egress_option is not None:
            pulumi.set(__self__, "egress_option", egress_option)

    @property
    @pulumi.getter(name="peeredNetwork")
    def peered_network(self) -> pulumi.Input[str]:
        """
        Immutable. The network definition that the workers are peered to. If this section is left empty, the workers will be peered to `WorkerPool.project_id` on the service producer network. Must be in the format `projects/{project}/global/networks/{network}`, where `{project}` is a project number, such as `12345`, and `{network}` is the name of a VPC network in the project. See [Understanding network configuration options](https://cloud.google.com/build/docs/private-pools/set-up-private-pool-environment)
        """
        return pulumi.get(self, "peered_network")

    @peered_network.setter
    def peered_network(self, value: pulumi.Input[str]):
        pulumi.set(self, "peered_network", value)

    @property
    @pulumi.getter(name="egressOption")
    def egress_option(self) -> Optional[pulumi.Input['NetworkConfigEgressOption']]:
        """
        Option to configure network egress for the workers.
        """
        return pulumi.get(self, "egress_option")

    @egress_option.setter
    def egress_option(self, value: Optional[pulumi.Input['NetworkConfigEgressOption']]):
        pulumi.set(self, "egress_option", value)


@pulumi.input_type
class PoolOptionArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None):
        """
        Details about how a build should be executed on a `WorkerPool`. See [running builds in a private pool](https://cloud.google.com/build/docs/private-pools/run-builds-in-private-pool) for more information.
        :param pulumi.Input[str] name: The `WorkerPool` resource to execute the build on. You must have `cloudbuild.workerpools.use` on the project hosting the WorkerPool. Format projects/{project}/locations/{location}/workerPools/{workerPoolId}
        """
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The `WorkerPool` resource to execute the build on. You must have `cloudbuild.workerpools.use` on the project hosting the WorkerPool. Format projects/{project}/locations/{location}/workerPools/{workerPoolId}
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class PrivatePoolV1ConfigArgs:
    def __init__(__self__, *,
                 network_config: Optional[pulumi.Input['NetworkConfigArgs']] = None,
                 worker_config: Optional[pulumi.Input['WorkerConfigArgs']] = None):
        """
        Configuration for a V1 `PrivatePool`.
        :param pulumi.Input['NetworkConfigArgs'] network_config: Network configuration for the pool.
        :param pulumi.Input['WorkerConfigArgs'] worker_config: Machine configuration for the workers in the pool.
        """
        if network_config is not None:
            pulumi.set(__self__, "network_config", network_config)
        if worker_config is not None:
            pulumi.set(__self__, "worker_config", worker_config)

    @property
    @pulumi.getter(name="networkConfig")
    def network_config(self) -> Optional[pulumi.Input['NetworkConfigArgs']]:
        """
        Network configuration for the pool.
        """
        return pulumi.get(self, "network_config")

    @network_config.setter
    def network_config(self, value: Optional[pulumi.Input['NetworkConfigArgs']]):
        pulumi.set(self, "network_config", value)

    @property
    @pulumi.getter(name="workerConfig")
    def worker_config(self) -> Optional[pulumi.Input['WorkerConfigArgs']]:
        """
        Machine configuration for the workers in the pool.
        """
        return pulumi.get(self, "worker_config")

    @worker_config.setter
    def worker_config(self, value: Optional[pulumi.Input['WorkerConfigArgs']]):
        pulumi.set(self, "worker_config", value)


@pulumi.input_type
class PubsubConfigArgs:
    def __init__(__self__, *,
                 service_account_email: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input['PubsubConfigState']] = None,
                 topic: Optional[pulumi.Input[str]] = None):
        """
        PubsubConfig describes the configuration of a trigger that creates a build whenever a Pub/Sub message is published.
        :param pulumi.Input[str] service_account_email: Service account that will make the push request.
        :param pulumi.Input['PubsubConfigState'] state: Potential issues with the underlying Pub/Sub subscription configuration. Only populated on get requests.
        :param pulumi.Input[str] topic: The name of the topic from which this subscription is receiving messages. Format is `projects/{project}/topics/{topic}`.
        """
        if service_account_email is not None:
            pulumi.set(__self__, "service_account_email", service_account_email)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if topic is not None:
            pulumi.set(__self__, "topic", topic)

    @property
    @pulumi.getter(name="serviceAccountEmail")
    def service_account_email(self) -> Optional[pulumi.Input[str]]:
        """
        Service account that will make the push request.
        """
        return pulumi.get(self, "service_account_email")

    @service_account_email.setter
    def service_account_email(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_account_email", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input['PubsubConfigState']]:
        """
        Potential issues with the underlying Pub/Sub subscription configuration. Only populated on get requests.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input['PubsubConfigState']]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter
    def topic(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the topic from which this subscription is receiving messages. Format is `projects/{project}/topics/{topic}`.
        """
        return pulumi.get(self, "topic")

    @topic.setter
    def topic(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "topic", value)


@pulumi.input_type
class PullRequestFilterArgs:
    def __init__(__self__, *,
                 branch: Optional[pulumi.Input[str]] = None,
                 comment_control: Optional[pulumi.Input['PullRequestFilterCommentControl']] = None,
                 invert_regex: Optional[pulumi.Input[bool]] = None):
        """
        PullRequestFilter contains filter properties for matching GitHub Pull Requests.
        :param pulumi.Input[str] branch: Regex of branches to match. The syntax of the regular expressions accepted is the syntax accepted by RE2 and described at https://github.com/google/re2/wiki/Syntax
        :param pulumi.Input['PullRequestFilterCommentControl'] comment_control: Configure builds to run whether a repository owner or collaborator need to comment `/gcbrun`.
        :param pulumi.Input[bool] invert_regex: If true, branches that do NOT match the git_ref will trigger a build.
        """
        if branch is not None:
            pulumi.set(__self__, "branch", branch)
        if comment_control is not None:
            pulumi.set(__self__, "comment_control", comment_control)
        if invert_regex is not None:
            pulumi.set(__self__, "invert_regex", invert_regex)

    @property
    @pulumi.getter
    def branch(self) -> Optional[pulumi.Input[str]]:
        """
        Regex of branches to match. The syntax of the regular expressions accepted is the syntax accepted by RE2 and described at https://github.com/google/re2/wiki/Syntax
        """
        return pulumi.get(self, "branch")

    @branch.setter
    def branch(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "branch", value)

    @property
    @pulumi.getter(name="commentControl")
    def comment_control(self) -> Optional[pulumi.Input['PullRequestFilterCommentControl']]:
        """
        Configure builds to run whether a repository owner or collaborator need to comment `/gcbrun`.
        """
        return pulumi.get(self, "comment_control")

    @comment_control.setter
    def comment_control(self, value: Optional[pulumi.Input['PullRequestFilterCommentControl']]):
        pulumi.set(self, "comment_control", value)

    @property
    @pulumi.getter(name="invertRegex")
    def invert_regex(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, branches that do NOT match the git_ref will trigger a build.
        """
        return pulumi.get(self, "invert_regex")

    @invert_regex.setter
    def invert_regex(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "invert_regex", value)


@pulumi.input_type
class PushFilterArgs:
    def __init__(__self__, *,
                 branch: Optional[pulumi.Input[str]] = None,
                 invert_regex: Optional[pulumi.Input[bool]] = None,
                 tag: Optional[pulumi.Input[str]] = None):
        """
        Push contains filter properties for matching GitHub git pushes.
        :param pulumi.Input[str] branch: Regexes matching branches to build. The syntax of the regular expressions accepted is the syntax accepted by RE2 and described at https://github.com/google/re2/wiki/Syntax
        :param pulumi.Input[bool] invert_regex: When true, only trigger a build if the revision regex does NOT match the git_ref regex.
        :param pulumi.Input[str] tag: Regexes matching tags to build. The syntax of the regular expressions accepted is the syntax accepted by RE2 and described at https://github.com/google/re2/wiki/Syntax
        """
        if branch is not None:
            pulumi.set(__self__, "branch", branch)
        if invert_regex is not None:
            pulumi.set(__self__, "invert_regex", invert_regex)
        if tag is not None:
            pulumi.set(__self__, "tag", tag)

    @property
    @pulumi.getter
    def branch(self) -> Optional[pulumi.Input[str]]:
        """
        Regexes matching branches to build. The syntax of the regular expressions accepted is the syntax accepted by RE2 and described at https://github.com/google/re2/wiki/Syntax
        """
        return pulumi.get(self, "branch")

    @branch.setter
    def branch(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "branch", value)

    @property
    @pulumi.getter(name="invertRegex")
    def invert_regex(self) -> Optional[pulumi.Input[bool]]:
        """
        When true, only trigger a build if the revision regex does NOT match the git_ref regex.
        """
        return pulumi.get(self, "invert_regex")

    @invert_regex.setter
    def invert_regex(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "invert_regex", value)

    @property
    @pulumi.getter
    def tag(self) -> Optional[pulumi.Input[str]]:
        """
        Regexes matching tags to build. The syntax of the regular expressions accepted is the syntax accepted by RE2 and described at https://github.com/google/re2/wiki/Syntax
        """
        return pulumi.get(self, "tag")

    @tag.setter
    def tag(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tag", value)


@pulumi.input_type
class RepoSourceArgs:
    def __init__(__self__, *,
                 branch_name: Optional[pulumi.Input[str]] = None,
                 commit_sha: Optional[pulumi.Input[str]] = None,
                 dir: Optional[pulumi.Input[str]] = None,
                 invert_regex: Optional[pulumi.Input[bool]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 repo_name: Optional[pulumi.Input[str]] = None,
                 substitutions: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tag_name: Optional[pulumi.Input[str]] = None):
        """
        Location of the source in a Google Cloud Source Repository.
        :param pulumi.Input[str] branch_name: Regex matching branches to build. The syntax of the regular expressions accepted is the syntax accepted by RE2 and described at https://github.com/google/re2/wiki/Syntax
        :param pulumi.Input[str] commit_sha: Explicit commit SHA to build.
        :param pulumi.Input[str] dir: Directory, relative to the source root, in which to run the build. This must be a relative path. If a step's `dir` is specified and is an absolute path, this value is ignored for that step's execution.
        :param pulumi.Input[bool] invert_regex: Only trigger a build if the revision regex does NOT match the revision regex.
        :param pulumi.Input[str] project: ID of the project that owns the Cloud Source Repository. If omitted, the project ID requesting the build is assumed.
        :param pulumi.Input[str] repo_name: Name of the Cloud Source Repository.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] substitutions: Substitutions to use in a triggered build. Should only be used with RunBuildTrigger
        :param pulumi.Input[str] tag_name: Regex matching tags to build. The syntax of the regular expressions accepted is the syntax accepted by RE2 and described at https://github.com/google/re2/wiki/Syntax
        """
        if branch_name is not None:
            pulumi.set(__self__, "branch_name", branch_name)
        if commit_sha is not None:
            pulumi.set(__self__, "commit_sha", commit_sha)
        if dir is not None:
            pulumi.set(__self__, "dir", dir)
        if invert_regex is not None:
            pulumi.set(__self__, "invert_regex", invert_regex)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if repo_name is not None:
            pulumi.set(__self__, "repo_name", repo_name)
        if substitutions is not None:
            pulumi.set(__self__, "substitutions", substitutions)
        if tag_name is not None:
            pulumi.set(__self__, "tag_name", tag_name)

    @property
    @pulumi.getter(name="branchName")
    def branch_name(self) -> Optional[pulumi.Input[str]]:
        """
        Regex matching branches to build. The syntax of the regular expressions accepted is the syntax accepted by RE2 and described at https://github.com/google/re2/wiki/Syntax
        """
        return pulumi.get(self, "branch_name")

    @branch_name.setter
    def branch_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "branch_name", value)

    @property
    @pulumi.getter(name="commitSha")
    def commit_sha(self) -> Optional[pulumi.Input[str]]:
        """
        Explicit commit SHA to build.
        """
        return pulumi.get(self, "commit_sha")

    @commit_sha.setter
    def commit_sha(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "commit_sha", value)

    @property
    @pulumi.getter
    def dir(self) -> Optional[pulumi.Input[str]]:
        """
        Directory, relative to the source root, in which to run the build. This must be a relative path. If a step's `dir` is specified and is an absolute path, this value is ignored for that step's execution.
        """
        return pulumi.get(self, "dir")

    @dir.setter
    def dir(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dir", value)

    @property
    @pulumi.getter(name="invertRegex")
    def invert_regex(self) -> Optional[pulumi.Input[bool]]:
        """
        Only trigger a build if the revision regex does NOT match the revision regex.
        """
        return pulumi.get(self, "invert_regex")

    @invert_regex.setter
    def invert_regex(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "invert_regex", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the project that owns the Cloud Source Repository. If omitted, the project ID requesting the build is assumed.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="repoName")
    def repo_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the Cloud Source Repository.
        """
        return pulumi.get(self, "repo_name")

    @repo_name.setter
    def repo_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "repo_name", value)

    @property
    @pulumi.getter
    def substitutions(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Substitutions to use in a triggered build. Should only be used with RunBuildTrigger
        """
        return pulumi.get(self, "substitutions")

    @substitutions.setter
    def substitutions(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "substitutions", value)

    @property
    @pulumi.getter(name="tagName")
    def tag_name(self) -> Optional[pulumi.Input[str]]:
        """
        Regex matching tags to build. The syntax of the regular expressions accepted is the syntax accepted by RE2 and described at https://github.com/google/re2/wiki/Syntax
        """
        return pulumi.get(self, "tag_name")

    @tag_name.setter
    def tag_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tag_name", value)


@pulumi.input_type
class SecretManagerSecretArgs:
    def __init__(__self__, *,
                 env: Optional[pulumi.Input[str]] = None,
                 version_name: Optional[pulumi.Input[str]] = None):
        """
        Pairs a secret environment variable with a SecretVersion in Secret Manager.
        :param pulumi.Input[str] env: Environment variable name to associate with the secret. Secret environment variables must be unique across all of a build's secrets, and must be used by at least one build step.
        :param pulumi.Input[str] version_name: Resource name of the SecretVersion. In format: projects/*/secrets/*/versions/*
        """
        if env is not None:
            pulumi.set(__self__, "env", env)
        if version_name is not None:
            pulumi.set(__self__, "version_name", version_name)

    @property
    @pulumi.getter
    def env(self) -> Optional[pulumi.Input[str]]:
        """
        Environment variable name to associate with the secret. Secret environment variables must be unique across all of a build's secrets, and must be used by at least one build step.
        """
        return pulumi.get(self, "env")

    @env.setter
    def env(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "env", value)

    @property
    @pulumi.getter(name="versionName")
    def version_name(self) -> Optional[pulumi.Input[str]]:
        """
        Resource name of the SecretVersion. In format: projects/*/secrets/*/versions/*
        """
        return pulumi.get(self, "version_name")

    @version_name.setter
    def version_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version_name", value)


@pulumi.input_type
class SecretsArgs:
    def __init__(__self__, *,
                 inline: Optional[pulumi.Input[Sequence[pulumi.Input['InlineSecretArgs']]]] = None,
                 secret_manager: Optional[pulumi.Input[Sequence[pulumi.Input['SecretManagerSecretArgs']]]] = None):
        """
        Secrets and secret environment variables.
        :param pulumi.Input[Sequence[pulumi.Input['InlineSecretArgs']]] inline: Secrets encrypted with KMS key and the associated secret environment variable.
        :param pulumi.Input[Sequence[pulumi.Input['SecretManagerSecretArgs']]] secret_manager: Secrets in Secret Manager and associated secret environment variable.
        """
        if inline is not None:
            pulumi.set(__self__, "inline", inline)
        if secret_manager is not None:
            pulumi.set(__self__, "secret_manager", secret_manager)

    @property
    @pulumi.getter
    def inline(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InlineSecretArgs']]]]:
        """
        Secrets encrypted with KMS key and the associated secret environment variable.
        """
        return pulumi.get(self, "inline")

    @inline.setter
    def inline(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InlineSecretArgs']]]]):
        pulumi.set(self, "inline", value)

    @property
    @pulumi.getter(name="secretManager")
    def secret_manager(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SecretManagerSecretArgs']]]]:
        """
        Secrets in Secret Manager and associated secret environment variable.
        """
        return pulumi.get(self, "secret_manager")

    @secret_manager.setter
    def secret_manager(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SecretManagerSecretArgs']]]]):
        pulumi.set(self, "secret_manager", value)


@pulumi.input_type
class SecretArgs:
    def __init__(__self__, *,
                 kms_key_name: Optional[pulumi.Input[str]] = None,
                 secret_env: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        Pairs a set of secret environment variables containing encrypted values with the Cloud KMS key to use to decrypt the value. Note: Use `kmsKeyName` with `available_secrets` instead of using `kmsKeyName` with `secret`. For instructions see: https://cloud.google.com/cloud-build/docs/securing-builds/use-encrypted-credentials.
        :param pulumi.Input[str] kms_key_name: Cloud KMS key name to use to decrypt these envs.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] secret_env: Map of environment variable name to its encrypted value. Secret environment variables must be unique across all of a build's secrets, and must be used by at least one build step. Values can be at most 64 KB in size. There can be at most 100 secret values across all of a build's secrets.
        """
        if kms_key_name is not None:
            pulumi.set(__self__, "kms_key_name", kms_key_name)
        if secret_env is not None:
            pulumi.set(__self__, "secret_env", secret_env)

    @property
    @pulumi.getter(name="kmsKeyName")
    def kms_key_name(self) -> Optional[pulumi.Input[str]]:
        """
        Cloud KMS key name to use to decrypt these envs.
        """
        return pulumi.get(self, "kms_key_name")

    @kms_key_name.setter
    def kms_key_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_key_name", value)

    @property
    @pulumi.getter(name="secretEnv")
    def secret_env(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Map of environment variable name to its encrypted value. Secret environment variables must be unique across all of a build's secrets, and must be used by at least one build step. Values can be at most 64 KB in size. There can be at most 100 secret values across all of a build's secrets.
        """
        return pulumi.get(self, "secret_env")

    @secret_env.setter
    def secret_env(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "secret_env", value)


@pulumi.input_type
class SourceArgs:
    def __init__(__self__, *,
                 repo_source: Optional[pulumi.Input['RepoSourceArgs']] = None,
                 storage_source: Optional[pulumi.Input['StorageSourceArgs']] = None,
                 storage_source_manifest: Optional[pulumi.Input['StorageSourceManifestArgs']] = None):
        """
        Location of the source in a supported storage service.
        :param pulumi.Input['RepoSourceArgs'] repo_source: If provided, get the source from this location in a Cloud Source Repository.
        :param pulumi.Input['StorageSourceArgs'] storage_source: If provided, get the source from this location in Google Cloud Storage.
        :param pulumi.Input['StorageSourceManifestArgs'] storage_source_manifest: If provided, get the source from this manifest in Google Cloud Storage. This feature is in Preview; see description [here](https://github.com/GoogleCloudPlatform/cloud-builders/tree/master/gcs-fetcher).
        """
        if repo_source is not None:
            pulumi.set(__self__, "repo_source", repo_source)
        if storage_source is not None:
            pulumi.set(__self__, "storage_source", storage_source)
        if storage_source_manifest is not None:
            pulumi.set(__self__, "storage_source_manifest", storage_source_manifest)

    @property
    @pulumi.getter(name="repoSource")
    def repo_source(self) -> Optional[pulumi.Input['RepoSourceArgs']]:
        """
        If provided, get the source from this location in a Cloud Source Repository.
        """
        return pulumi.get(self, "repo_source")

    @repo_source.setter
    def repo_source(self, value: Optional[pulumi.Input['RepoSourceArgs']]):
        pulumi.set(self, "repo_source", value)

    @property
    @pulumi.getter(name="storageSource")
    def storage_source(self) -> Optional[pulumi.Input['StorageSourceArgs']]:
        """
        If provided, get the source from this location in Google Cloud Storage.
        """
        return pulumi.get(self, "storage_source")

    @storage_source.setter
    def storage_source(self, value: Optional[pulumi.Input['StorageSourceArgs']]):
        pulumi.set(self, "storage_source", value)

    @property
    @pulumi.getter(name="storageSourceManifest")
    def storage_source_manifest(self) -> Optional[pulumi.Input['StorageSourceManifestArgs']]:
        """
        If provided, get the source from this manifest in Google Cloud Storage. This feature is in Preview; see description [here](https://github.com/GoogleCloudPlatform/cloud-builders/tree/master/gcs-fetcher).
        """
        return pulumi.get(self, "storage_source_manifest")

    @storage_source_manifest.setter
    def storage_source_manifest(self, value: Optional[pulumi.Input['StorageSourceManifestArgs']]):
        pulumi.set(self, "storage_source_manifest", value)


@pulumi.input_type
class StorageSourceManifestArgs:
    def __init__(__self__, *,
                 bucket: Optional[pulumi.Input[str]] = None,
                 generation: Optional[pulumi.Input[str]] = None,
                 object: Optional[pulumi.Input[str]] = None):
        """
        Location of the source manifest in Google Cloud Storage. This feature is in Preview; see description [here](https://github.com/GoogleCloudPlatform/cloud-builders/tree/master/gcs-fetcher).
        :param pulumi.Input[str] bucket: Google Cloud Storage bucket containing the source manifest (see [Bucket Name Requirements](https://cloud.google.com/storage/docs/bucket-naming#requirements)).
        :param pulumi.Input[str] generation: Google Cloud Storage generation for the object. If the generation is omitted, the latest generation will be used.
        :param pulumi.Input[str] object: Google Cloud Storage object containing the source manifest. This object must be a JSON file.
        """
        if bucket is not None:
            pulumi.set(__self__, "bucket", bucket)
        if generation is not None:
            pulumi.set(__self__, "generation", generation)
        if object is not None:
            pulumi.set(__self__, "object", object)

    @property
    @pulumi.getter
    def bucket(self) -> Optional[pulumi.Input[str]]:
        """
        Google Cloud Storage bucket containing the source manifest (see [Bucket Name Requirements](https://cloud.google.com/storage/docs/bucket-naming#requirements)).
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bucket", value)

    @property
    @pulumi.getter
    def generation(self) -> Optional[pulumi.Input[str]]:
        """
        Google Cloud Storage generation for the object. If the generation is omitted, the latest generation will be used.
        """
        return pulumi.get(self, "generation")

    @generation.setter
    def generation(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "generation", value)

    @property
    @pulumi.getter
    def object(self) -> Optional[pulumi.Input[str]]:
        """
        Google Cloud Storage object containing the source manifest. This object must be a JSON file.
        """
        return pulumi.get(self, "object")

    @object.setter
    def object(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "object", value)


@pulumi.input_type
class StorageSourceArgs:
    def __init__(__self__, *,
                 bucket: Optional[pulumi.Input[str]] = None,
                 generation: Optional[pulumi.Input[str]] = None,
                 object: Optional[pulumi.Input[str]] = None):
        """
        Location of the source in an archive file in Google Cloud Storage.
        :param pulumi.Input[str] bucket: Google Cloud Storage bucket containing the source (see [Bucket Name Requirements](https://cloud.google.com/storage/docs/bucket-naming#requirements)).
        :param pulumi.Input[str] generation: Google Cloud Storage generation for the object. If the generation is omitted, the latest generation will be used.
        :param pulumi.Input[str] object: Google Cloud Storage object containing the source. This object must be a zipped (`.zip`) or gzipped archive file (`.tar.gz`) containing source to build.
        """
        if bucket is not None:
            pulumi.set(__self__, "bucket", bucket)
        if generation is not None:
            pulumi.set(__self__, "generation", generation)
        if object is not None:
            pulumi.set(__self__, "object", object)

    @property
    @pulumi.getter
    def bucket(self) -> Optional[pulumi.Input[str]]:
        """
        Google Cloud Storage bucket containing the source (see [Bucket Name Requirements](https://cloud.google.com/storage/docs/bucket-naming#requirements)).
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bucket", value)

    @property
    @pulumi.getter
    def generation(self) -> Optional[pulumi.Input[str]]:
        """
        Google Cloud Storage generation for the object. If the generation is omitted, the latest generation will be used.
        """
        return pulumi.get(self, "generation")

    @generation.setter
    def generation(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "generation", value)

    @property
    @pulumi.getter
    def object(self) -> Optional[pulumi.Input[str]]:
        """
        Google Cloud Storage object containing the source. This object must be a zipped (`.zip`) or gzipped archive file (`.tar.gz`) containing source to build.
        """
        return pulumi.get(self, "object")

    @object.setter
    def object(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "object", value)


@pulumi.input_type
class VolumeArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 path: Optional[pulumi.Input[str]] = None):
        """
        Volume describes a Docker container volume which is mounted into build steps in order to persist files across build step execution.
        :param pulumi.Input[str] name: Name of the volume to mount. Volume names must be unique per build step and must be valid names for Docker volumes. Each named volume must be used by at least two build steps.
        :param pulumi.Input[str] path: Path at which to mount the volume. Paths must be absolute and cannot conflict with other volume paths on the same build step or with certain reserved volume paths.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if path is not None:
            pulumi.set(__self__, "path", path)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the volume to mount. Volume names must be unique per build step and must be valid names for Docker volumes. Each named volume must be used by at least two build steps.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        """
        Path at which to mount the volume. Paths must be absolute and cannot conflict with other volume paths on the same build step or with certain reserved volume paths.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)


@pulumi.input_type
class WebhookConfigArgs:
    def __init__(__self__, *,
                 secret: pulumi.Input[str],
                 state: Optional[pulumi.Input['WebhookConfigState']] = None):
        """
        WebhookConfig describes the configuration of a trigger that creates a build whenever a webhook is sent to a trigger's webhook URL.
        :param pulumi.Input[str] secret: Resource name for the secret required as a URL parameter.
        :param pulumi.Input['WebhookConfigState'] state: Potential issues with the underlying Pub/Sub subscription configuration. Only populated on get requests.
        """
        pulumi.set(__self__, "secret", secret)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter
    def secret(self) -> pulumi.Input[str]:
        """
        Resource name for the secret required as a URL parameter.
        """
        return pulumi.get(self, "secret")

    @secret.setter
    def secret(self, value: pulumi.Input[str]):
        pulumi.set(self, "secret", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input['WebhookConfigState']]:
        """
        Potential issues with the underlying Pub/Sub subscription configuration. Only populated on get requests.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input['WebhookConfigState']]):
        pulumi.set(self, "state", value)


@pulumi.input_type
class WorkerConfigArgs:
    def __init__(__self__, *,
                 disk_size_gb: Optional[pulumi.Input[str]] = None,
                 machine_type: Optional[pulumi.Input[str]] = None):
        """
        Defines the configuration to be used for creating workers in the pool.
        :param pulumi.Input[str] disk_size_gb: Size of the disk attached to the worker, in GB. See [Worker pool config file](https://cloud.google.com/build/docs/private-pools/worker-pool-config-file-schema). Specify a value of up to 1000. If `0` is specified, Cloud Build will use a standard disk size.
        :param pulumi.Input[str] machine_type: Machine type of a worker, such as `e2-medium`. See [Worker pool config file](https://cloud.google.com/build/docs/private-pools/worker-pool-config-file-schema). If left blank, Cloud Build will use a sensible default.
        """
        if disk_size_gb is not None:
            pulumi.set(__self__, "disk_size_gb", disk_size_gb)
        if machine_type is not None:
            pulumi.set(__self__, "machine_type", machine_type)

    @property
    @pulumi.getter(name="diskSizeGb")
    def disk_size_gb(self) -> Optional[pulumi.Input[str]]:
        """
        Size of the disk attached to the worker, in GB. See [Worker pool config file](https://cloud.google.com/build/docs/private-pools/worker-pool-config-file-schema). Specify a value of up to 1000. If `0` is specified, Cloud Build will use a standard disk size.
        """
        return pulumi.get(self, "disk_size_gb")

    @disk_size_gb.setter
    def disk_size_gb(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "disk_size_gb", value)

    @property
    @pulumi.getter(name="machineType")
    def machine_type(self) -> Optional[pulumi.Input[str]]:
        """
        Machine type of a worker, such as `e2-medium`. See [Worker pool config file](https://cloud.google.com/build/docs/private-pools/worker-pool-config-file-schema). If left blank, Cloud Build will use a sensible default.
        """
        return pulumi.get(self, "machine_type")

    @machine_type.setter
    def machine_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "machine_type", value)


