# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'GetTableResult',
    'AwaitableGetTableResult',
    'get_table',
    'get_table_output',
]

@pulumi.output_type
class GetTableResult:
    def __init__(__self__, cluster_states=None, column_families=None, granularity=None, name=None, restore_info=None):
        if cluster_states and not isinstance(cluster_states, dict):
            raise TypeError("Expected argument 'cluster_states' to be a dict")
        pulumi.set(__self__, "cluster_states", cluster_states)
        if column_families and not isinstance(column_families, dict):
            raise TypeError("Expected argument 'column_families' to be a dict")
        pulumi.set(__self__, "column_families", column_families)
        if granularity and not isinstance(granularity, str):
            raise TypeError("Expected argument 'granularity' to be a str")
        pulumi.set(__self__, "granularity", granularity)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if restore_info and not isinstance(restore_info, dict):
            raise TypeError("Expected argument 'restore_info' to be a dict")
        pulumi.set(__self__, "restore_info", restore_info)

    @property
    @pulumi.getter(name="clusterStates")
    def cluster_states(self) -> Mapping[str, str]:
        """
        Map from cluster ID to per-cluster table state. If it could not be determined whether or not the table has data in a particular cluster (for example, if its zone is unavailable), then there will be an entry for the cluster with UNKNOWN `replication_status`. Views: `REPLICATION_VIEW`, `ENCRYPTION_VIEW`, `FULL`
        """
        return pulumi.get(self, "cluster_states")

    @property
    @pulumi.getter(name="columnFamilies")
    def column_families(self) -> Mapping[str, str]:
        """
        The column families configured for this table, mapped by column family ID. Views: `SCHEMA_VIEW`, `FULL`
        """
        return pulumi.get(self, "column_families")

    @property
    @pulumi.getter
    def granularity(self) -> str:
        """
        Immutable. The granularity (i.e. `MILLIS`) at which timestamps are stored in this table. Timestamps not matching the granularity will be rejected. If unspecified at creation time, the value will be set to `MILLIS`. Views: `SCHEMA_VIEW`, `FULL`.
        """
        return pulumi.get(self, "granularity")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The unique name of the table. Values are of the form `projects/{project}/instances/{instance}/tables/_a-zA-Z0-9*`. Views: `NAME_ONLY`, `SCHEMA_VIEW`, `REPLICATION_VIEW`, `FULL`
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="restoreInfo")
    def restore_info(self) -> 'outputs.RestoreInfoResponse':
        """
        If this table was restored from another data source (e.g. a backup), this field will be populated with information about the restore.
        """
        return pulumi.get(self, "restore_info")


class AwaitableGetTableResult(GetTableResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetTableResult(
            cluster_states=self.cluster_states,
            column_families=self.column_families,
            granularity=self.granularity,
            name=self.name,
            restore_info=self.restore_info)


def get_table(instance_id: Optional[str] = None,
              project: Optional[str] = None,
              table_id: Optional[str] = None,
              view: Optional[str] = None,
              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetTableResult:
    """
    Gets metadata information about the specified table.
    """
    __args__ = dict()
    __args__['instanceId'] = instance_id
    __args__['project'] = project
    __args__['tableId'] = table_id
    __args__['view'] = view
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('google-native:bigtableadmin/v2:getTable', __args__, opts=opts, typ=GetTableResult).value

    return AwaitableGetTableResult(
        cluster_states=__ret__.cluster_states,
        column_families=__ret__.column_families,
        granularity=__ret__.granularity,
        name=__ret__.name,
        restore_info=__ret__.restore_info)


@_utilities.lift_output_func(get_table)
def get_table_output(instance_id: Optional[pulumi.Input[str]] = None,
                     project: Optional[pulumi.Input[Optional[str]]] = None,
                     table_id: Optional[pulumi.Input[str]] = None,
                     view: Optional[pulumi.Input[Optional[str]]] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetTableResult]:
    """
    Gets metadata information about the specified table.
    """
    ...
