# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'GetConnectionResult',
    'AwaitableGetConnectionResult',
    'get_connection',
    'get_connection_output',
]

@pulumi.output_type
class GetConnectionResult:
    def __init__(__self__, cloud_sql=None, creation_time=None, description=None, friendly_name=None, has_credential=None, last_modified_time=None, name=None):
        if cloud_sql and not isinstance(cloud_sql, dict):
            raise TypeError("Expected argument 'cloud_sql' to be a dict")
        pulumi.set(__self__, "cloud_sql", cloud_sql)
        if creation_time and not isinstance(creation_time, str):
            raise TypeError("Expected argument 'creation_time' to be a str")
        pulumi.set(__self__, "creation_time", creation_time)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if friendly_name and not isinstance(friendly_name, str):
            raise TypeError("Expected argument 'friendly_name' to be a str")
        pulumi.set(__self__, "friendly_name", friendly_name)
        if has_credential and not isinstance(has_credential, bool):
            raise TypeError("Expected argument 'has_credential' to be a bool")
        pulumi.set(__self__, "has_credential", has_credential)
        if last_modified_time and not isinstance(last_modified_time, str):
            raise TypeError("Expected argument 'last_modified_time' to be a str")
        pulumi.set(__self__, "last_modified_time", last_modified_time)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="cloudSql")
    def cloud_sql(self) -> 'outputs.CloudSqlPropertiesResponse':
        """
        Cloud SQL properties.
        """
        return pulumi.get(self, "cloud_sql")

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> str:
        """
        The creation timestamp of the connection.
        """
        return pulumi.get(self, "creation_time")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        User provided description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="friendlyName")
    def friendly_name(self) -> str:
        """
        User provided display name for the connection.
        """
        return pulumi.get(self, "friendly_name")

    @property
    @pulumi.getter(name="hasCredential")
    def has_credential(self) -> bool:
        """
        True, if credential is configured for this connection.
        """
        return pulumi.get(self, "has_credential")

    @property
    @pulumi.getter(name="lastModifiedTime")
    def last_modified_time(self) -> str:
        """
        The last update timestamp of the connection.
        """
        return pulumi.get(self, "last_modified_time")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The resource name of the connection in the form of: `projects/{project_id}/locations/{location_id}/connections/{connection_id}`
        """
        return pulumi.get(self, "name")


class AwaitableGetConnectionResult(GetConnectionResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetConnectionResult(
            cloud_sql=self.cloud_sql,
            creation_time=self.creation_time,
            description=self.description,
            friendly_name=self.friendly_name,
            has_credential=self.has_credential,
            last_modified_time=self.last_modified_time,
            name=self.name)


def get_connection(connection_id: Optional[str] = None,
                   location: Optional[str] = None,
                   project: Optional[str] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetConnectionResult:
    """
    Returns specified connection.
    """
    __args__ = dict()
    __args__['connectionId'] = connection_id
    __args__['location'] = location
    __args__['project'] = project
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('google-native:bigqueryconnection/v1beta1:getConnection', __args__, opts=opts, typ=GetConnectionResult).value

    return AwaitableGetConnectionResult(
        cloud_sql=__ret__.cloud_sql,
        creation_time=__ret__.creation_time,
        description=__ret__.description,
        friendly_name=__ret__.friendly_name,
        has_credential=__ret__.has_credential,
        last_modified_time=__ret__.last_modified_time,
        name=__ret__.name)


@_utilities.lift_output_func(get_connection)
def get_connection_output(connection_id: Optional[pulumi.Input[str]] = None,
                          location: Optional[pulumi.Input[str]] = None,
                          project: Optional[pulumi.Input[Optional[str]]] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetConnectionResult]:
    """
    Returns specified connection.
    """
    ...
