# doculog

_README generated with **Documatic**_.

Quickly generate changelogs
and release notes
by analysing your git history.
A python tool.
Format based on `KeepAChangelog`.

## Getting started

### Requirements

Minimum python 3.8.
Project actively supports python 3.8,
3.9,
3.10.
To install,
clone the repository
and run `pip install -e .`
to package locally
OR
`pip install doculog`.

### API key

To generate a changelog
with a full feature-set,
doculog requires a (free)
API key.
Join the waitlist
for an API key [here](https://www.documatic.com).
doculog uses `python-dotenv`
to load environment variables
stored in a `.env` file.
To use your API key,
create a `.env` file
in your project root directory
with the following fields:

```
DOCULOG_API_KEY = <your-api-key>
```

**IMPORTANT: DO NOT ADD `.env` TO VERSION CONTROL.
YOUR API KEY MUST BE KEPT SECRET.**


### Generate a Changelog

In a terminal,
run `doculog`
to create
a `CHANGELOG.md`
from your git commit history,
or update an existing changelog.
See [configuration](#configuration)
for information on how to configure
the changelog.

## Concepts

### Git commit parsing

The initial logic for generating a changelog
comes from reading
your git commit messages.
`doculog`
expects
commit messages to begin with an imperitive verb,
and to written passively.
`doculog` parses the message for signalling words
and phrases.

E.g. `Rename 'my_func' to 'my_awesome_func'`
will get interpreted as a "Changed" feature.
Whereas `'my_func' -> 'my_awesome_func'`
will not.

### Configuration

You can configure how `doculog` runs
by adding a `tool.doculog` section
to `pyproject.toml`.

| Field | Purpose | Required | Default value |
|:------|:--------|:---------|:--------------|
| changelog | Name of changelog file generated. ".md" suffix added if not present. | No | CHANGELOG.md |
| local | If `true`, use a local sever for advanced features. Only used for project development | No | false |

## Developers

Read the [contributing guide](CONTRIBUTING.md)
for information on coding styles
and workflow.

Run `pip install -r requirements-dev.txt`
to get developer requirements.

| CI file | Purpose |
|:--------|:--------|
| `test.yml` | Linting and unit testing. Runs on every pull request |

## FAQ

### I want more intelligent featureset generation. What can I do?

Request access to the free Documatic API
to generate a changelog
driven by machine learning.
Follow `Documatic` on GitHub
and socials
to stay up to date
with the latest features
and releases.

### The changelog is great, but I want more.

Get in touch.

### Can I contribute to doculog?

Absolutely:
feature requests,
bug fixes,
bug reports
and PRs of all shapes and sizes
are welcome.
See the [developers](#developers)
section.

## License

Licensed under GNU GPL3.
Please see the [LICENSE]
for terms in full.

_Generated by **Documatic**._
