"""
    Authentication endpoints - OpenAPI 3.0

    The endpoints for the authentication API.  # noqa: E501

    The version of the OpenAPI document: DRAFT
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from swx_sdk.api_client import ApiClient, Endpoint as _Endpoint
from swx_sdk.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from swx_sdk.model.discoveries_response import DiscoveriesResponse
from swx_sdk.model.discovery_request import DiscoveryRequest
from swx_sdk.model.discovery_response import DiscoveryResponse
from swx_sdk.model.discovery_update_request import DiscoveryUpdateRequest
from swx_sdk.model.discovery_update_response import DiscoveryUpdateResponse
from swx_sdk.model.discovery_uploads_response import DiscoveryUploadsResponse


class DiscoveryApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

        def __delete_reports_discovery(
            self,
            discovery_type,
            report_id,
            **kwargs
        ):
            """Delete Discovery Report  # noqa: E501

            Deletes or cancels an existing discovery report by Id  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_reports_discovery(discovery_type, report_id, async_req=True)
            >>> result = thread.get()

            Args:
                discovery_type (str):
                report_id (str):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['discovery_type'] = \
                discovery_type
            kwargs['report_id'] = \
                report_id
            return self.call_with_http_info(**kwargs)

        self.delete_reports_discovery = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/reports/discovery/{discovery_type}/{report_id}',
                'operation_id': 'delete_reports_discovery',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'discovery_type',
                    'report_id',
                ],
                'required': [
                    'discovery_type',
                    'report_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'discovery_type':
                        (str,),
                    'report_id':
                        (str,),
                },
                'attribute_map': {
                    'discovery_type': 'discovery_type',
                    'report_id': 'report_id',
                },
                'location_map': {
                    'discovery_type': 'path',
                    'report_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client,
            callable=__delete_reports_discovery
        )

        def __list_reports_discoveries(
            self,
            **kwargs
        ):
            """List history of request for all Discovery Reports  # noqa: E501

            List all history of request for all Discovery Reports  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_reports_discoveries(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                [DiscoveriesResponse]
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.list_reports_discoveries = _Endpoint(
            settings={
                'response_type': ([DiscoveriesResponse],),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/reports/discovery',
                'operation_id': 'list_reports_discoveries',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                },
                'attribute_map': {
                },
                'location_map': {
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__list_reports_discoveries
        )

        def __list_reports_discoveries_by_type(
            self,
            discovery_type,
            **kwargs
        ):
            """List history of requests for a Discovery Report  # noqa: E501

            List all history of requests for a Discovery Report  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_reports_discoveries_by_type(discovery_type, async_req=True)
            >>> result = thread.get()

            Args:
                discovery_type (str):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                [DiscoveriesResponse]
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['discovery_type'] = \
                discovery_type
            return self.call_with_http_info(**kwargs)

        self.list_reports_discoveries_by_type = _Endpoint(
            settings={
                'response_type': ([DiscoveriesResponse],),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/reports/discovery/{discovery_type}',
                'operation_id': 'list_reports_discoveries_by_type',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'discovery_type',
                ],
                'required': [
                    'discovery_type',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'discovery_type':
                        (str,),
                },
                'attribute_map': {
                    'discovery_type': 'discovery_type',
                },
                'location_map': {
                    'discovery_type': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__list_reports_discoveries_by_type
        )

        def __list_reports_discovery_discovery_uploads(
            self,
            discovery_type,
            report_id,
            **kwargs
        ):
            """List Discovery Report Uploads  # noqa: E501

            List an existing discovery report's uploads request by Id  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_reports_discovery_discovery_uploads(discovery_type, report_id, async_req=True)
            >>> result = thread.get()

            Args:
                discovery_type (str):
                report_id (str):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                [DiscoveryUploadsResponse]
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['discovery_type'] = \
                discovery_type
            kwargs['report_id'] = \
                report_id
            return self.call_with_http_info(**kwargs)

        self.list_reports_discovery_discovery_uploads = _Endpoint(
            settings={
                'response_type': ([DiscoveryUploadsResponse],),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/reports/discovery/{discovery_type}/{report_id}/uploads',
                'operation_id': 'list_reports_discovery_discovery_uploads',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'discovery_type',
                    'report_id',
                ],
                'required': [
                    'discovery_type',
                    'report_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'discovery_type':
                        (str,),
                    'report_id':
                        (str,),
                },
                'attribute_map': {
                    'discovery_type': 'discovery_type',
                    'report_id': 'report_id',
                },
                'location_map': {
                    'discovery_type': 'path',
                    'report_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__list_reports_discovery_discovery_uploads
        )

        def __request_reports_discovery(
            self,
            discovery_type,
            discovery_request,
            **kwargs
        ):
            """Request a Discovery Report  # noqa: E501

            Request a Discovery Report to be generated  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.request_reports_discovery(discovery_type, discovery_request, async_req=True)
            >>> result = thread.get()

            Args:
                discovery_type (str):
                discovery_request (DiscoveryRequest): Request an Discovery Report to be generated

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                DiscoveryResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['discovery_type'] = \
                discovery_type
            kwargs['discovery_request'] = \
                discovery_request
            return self.call_with_http_info(**kwargs)

        self.request_reports_discovery = _Endpoint(
            settings={
                'response_type': (DiscoveryResponse,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/reports/discovery/{discovery_type}',
                'operation_id': 'request_reports_discovery',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'discovery_type',
                    'discovery_request',
                ],
                'required': [
                    'discovery_type',
                    'discovery_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'discovery_type':
                        (str,),
                    'discovery_request':
                        (DiscoveryRequest,),
                },
                'attribute_map': {
                    'discovery_type': 'discovery_type',
                },
                'location_map': {
                    'discovery_type': 'path',
                    'discovery_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__request_reports_discovery
        )

        def __retrieve_reports_discovery_discovery_upload(
            self,
            discovery_type,
            report_id,
            upload_id,
            **kwargs
        ):
            """Retrieve Discovery Report Upload Content  # noqa: E501

            Retrieve an existing discovery report's upload content request by Id  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.retrieve_reports_discovery_discovery_upload(discovery_type, report_id, upload_id, async_req=True)
            >>> result = thread.get()

            Args:
                discovery_type (str):
                report_id (str):
                upload_id (str):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                str
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['discovery_type'] = \
                discovery_type
            kwargs['report_id'] = \
                report_id
            kwargs['upload_id'] = \
                upload_id
            return self.call_with_http_info(**kwargs)

        self.retrieve_reports_discovery_discovery_upload = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/reports/discovery/{discovery_type}/{report_id}/uploads/{upload_id}',
                'operation_id': 'retrieve_reports_discovery_discovery_upload',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'discovery_type',
                    'report_id',
                    'upload_id',
                ],
                'required': [
                    'discovery_type',
                    'report_id',
                    'upload_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'discovery_type':
                        (str,),
                    'report_id':
                        (str,),
                    'upload_id':
                        (str,),
                },
                'attribute_map': {
                    'discovery_type': 'discovery_type',
                    'report_id': 'report_id',
                    'upload_id': 'upload_id',
                },
                'location_map': {
                    'discovery_type': 'path',
                    'report_id': 'path',
                    'upload_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__retrieve_reports_discovery_discovery_upload
        )

        def __show_reports_discovery(
            self,
            discovery_type,
            report_id,
            **kwargs
        ):
            """Show Discovery Report  # noqa: E501

            Show an existing discovery report request by Id  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.show_reports_discovery(discovery_type, report_id, async_req=True)
            >>> result = thread.get()

            Args:
                discovery_type (str):
                report_id (str):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                DiscoveryResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['discovery_type'] = \
                discovery_type
            kwargs['report_id'] = \
                report_id
            return self.call_with_http_info(**kwargs)

        self.show_reports_discovery = _Endpoint(
            settings={
                'response_type': (DiscoveryResponse,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/reports/discovery/{discovery_type}/{report_id}',
                'operation_id': 'show_reports_discovery',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'discovery_type',
                    'report_id',
                ],
                'required': [
                    'discovery_type',
                    'report_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'discovery_type':
                        (str,),
                    'report_id':
                        (str,),
                },
                'attribute_map': {
                    'discovery_type': 'discovery_type',
                    'report_id': 'report_id',
                },
                'location_map': {
                    'discovery_type': 'path',
                    'report_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__show_reports_discovery
        )

        def __update_reports_action(
            self,
            discovery_type,
            report_id,
            discovery_update_request,
            **kwargs
        ):
            """Update a request for a Discovery Report  # noqa: E501

            Update an existing discovery report request by Id  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.update_reports_action(discovery_type, report_id, discovery_update_request, async_req=True)
            >>> result = thread.get()

            Args:
                discovery_type (str):
                report_id (str):
                discovery_update_request (DiscoveryUpdateRequest): Update an existing discovery report by id

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                DiscoveryUpdateResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['discovery_type'] = \
                discovery_type
            kwargs['report_id'] = \
                report_id
            kwargs['discovery_update_request'] = \
                discovery_update_request
            return self.call_with_http_info(**kwargs)

        self.update_reports_action = _Endpoint(
            settings={
                'response_type': (DiscoveryUpdateResponse,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/reports/discovery/{discovery_type}/{report_id}',
                'operation_id': 'update_reports_action',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'discovery_type',
                    'report_id',
                    'discovery_update_request',
                ],
                'required': [
                    'discovery_type',
                    'report_id',
                    'discovery_update_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'discovery_type':
                        (str,),
                    'report_id':
                        (str,),
                    'discovery_update_request':
                        (DiscoveryUpdateRequest,),
                },
                'attribute_map': {
                    'discovery_type': 'discovery_type',
                    'report_id': 'report_id',
                },
                'location_map': {
                    'discovery_type': 'path',
                    'report_id': 'path',
                    'discovery_update_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__update_reports_action
        )
