# README

This folder was created with [shell-command-logger](https://github.com/six-two/shell-command-logger), a python tool for logging comand outputs.

## Structure

Command outputs for each program is stored in a separate folder.
For example all invocations of `nmap` will be stored in a folder called `nmap`.

Each output is stored in three files:

- `<time>.log` contains the raw output.
  You can `cat` this file to see the whole output with colors and everything.
  However, some output may look broken if your terminal has a different size than the terminal this command was recorded in.
- `<time>.time` contains timing info for `scriptreplay`.
  This file can be used in combination with `<time>.log` to replay the command output in real time.
- `<time>.json` contains metadata such as:
    - the start and end time of the process
    - the full command line used to start the process
    - the exit code if the process
    - the username and hostname combination, that was used to run the command

## scl-replay

You can use also use the `scl-replay` script from the `shell-command-logger` package to replay the commands.
Just install the package with `pip`:

```bash
python3 -m pip install shell-command-logger
```

If you want to use advanced features like searching command line agruments, you need to configure `shell-command-logger` to use this folder as its data directory:

```bash
scl-config -s Output DataDirectory </path/to/this/folder>
```

Then you can use `scl-replay` to search and replay commands.
See `scl-replay --help` for usage information.

### Incompatible versions

It is possible, that the latest version of `shell-command-logger` may noy be compatible with the output generated by an older version of the package.
If this is the case, you can install an older version with `pip`.

The version used to create this folder was {{version}}.
You can install it with the following command:

```bash
python3 -m pip install shell-command-logger=={{version}}
```
