"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Dashboard = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk8s_1 = require("cdk8s");
const constructs_1 = require("constructs");
const grafana_dashboard_1 = require("./imports/grafana-dashboard");
/**
 * A Grafana dashboard.
 * @see https://grafana.com/docs/grafana/latest/http_api/dashboard/
 */
class Dashboard extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.plugins = [];
        const refreshRate = props.refreshRate ?? cdk8s_1.Duration.seconds(5);
        const timeRange = props.timeRange ?? cdk8s_1.Duration.hours(6);
        const dataSources = Object.entries(props.dataSourceVariables ?? {}).map(([variable, name]) => ({ datasourceName: name, inputName: variable }));
        const defaults = {
            title: props.title,
            id: null,
            tags: [],
            style: 'dark',
            timezone: 'browser',
            editable: true,
            hideControls: false,
            graphTooltip: 1,
            panels: [],
            time: {
                from: `now-${timeRange.toSeconds()}s`,
                to: 'now',
            },
            timepicker: {
                time_options: [],
                refresh_intervals: [],
            },
            templating: {
                list: [],
            },
            annotations: {
                list: [],
            },
            refresh: `${refreshRate.toSeconds()}s`,
            schemaVersion: 17,
            version: 0,
            links: [],
        };
        new grafana_dashboard_1.GrafanaDashboard(this, 'Resource', {
            metadata: {
                labels: props.labels,
                namespace: props.namespace,
            },
            spec: {
                customFolderName: props.folder,
                datasources: dataSources,
                plugins: this.plugins,
                json: JSON.stringify({
                    ...defaults,
                    ...props.jsonModel,
                }, null, 2),
            },
        });
        if (props.plugins) {
            this.addPlugins(...props.plugins);
        }
    }
    /**
     * Adds one or more plugins.
     */
    addPlugins(...plugins) {
        for (const plugin of plugins) {
            this.plugins.push(plugin);
        }
    }
}
exports.Dashboard = Dashboard;
_a = JSII_RTTI_SYMBOL_1;
Dashboard[_a] = { fqn: "cdk8s-grafana.Dashboard", version: "0.1.286" };
//# sourceMappingURL=data:application/json;base64,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