import * as cdk from 'aws-cdk-lib';
import * as constructs from 'constructs';
/**
 * Manage a team in Github
 *
 * @schema CfnTeamProps
 */
export interface CfnTeamProps {
    /**
     * Team name
     *
     * @schema CfnTeamProps#Name
     */
    readonly name: string;
    /**
     * The Organization that the team will belong to
     *
     * @schema CfnTeamProps#Organization
     */
    readonly organization: string;
    /**
     * Describe the team
     *
     * @schema CfnTeamProps#Description
     */
    readonly description?: string;
    /**
     * The privacy for the team - must be either secret or closed
     *
     * @schema CfnTeamProps#Privacy
     */
    readonly privacy?: CfnTeamPropsPrivacy;
}
/**
 * Converts an object of type 'CfnTeamProps' to JSON representation.
 */
export declare function toJson_CfnTeamProps(obj: CfnTeamProps | undefined): Record<string, any> | undefined;
/**
 * The privacy for the team - must be either secret or closed
 *
 * @schema CfnTeamPropsPrivacy
 */
export declare enum CfnTeamPropsPrivacy {
    /** secret */
    SECRET = "secret",
    /** closed */
    CLOSED = "closed"
}
/**
 * A CloudFormation `GitHub::Teams::Team`
 *
 * @cloudformationResource GitHub::Teams::Team
 * @stability external
 * @link https://github.com/aws-ia/cloudformation-github-resource-providers.git
 */
export declare class CfnTeam extends cdk.CfnResource {
    /**
    * The CloudFormation resource type name for this resource class.
    */
    static readonly CFN_RESOURCE_TYPE_NAME = "GitHub::Teams::Team";
    /**
     * Resource props.
     */
    readonly props: CfnTeamProps;
    /**
     * Attribute `GitHub::Teams::Team.Slug`
     * @link https://github.com/aws-ia/cloudformation-github-resource-providers.git
     */
    readonly attrSlug: string;
    /**
     * Create a new `GitHub::Teams::Team`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: constructs.Construct, id: string, props: CfnTeamProps);
}
